/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.util.Comparator;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;

abstract class DataSourcesComparator
implements Comparator<DataSource> {
    DataSourcesComparator() {
    }

    @Override
    public int compare(DataSource d1, DataSource d2) {
        DataSourceDescriptor<DataSource> dd1 = DataSourceDescriptorFactory.getDescriptor(d1);
        DataSourceDescriptor<DataSource> dd2 = DataSourceDescriptorFactory.getDescriptor(d2);
        int p1 = dd1.getPreferredPosition();
        int p2 = dd2.getPreferredPosition();
        if (p1 == 0x7FFFFFFE && p2 == 0x7FFFFFFE) {
            p1 = this.getRelativePosition(d1, 0x7FFFFFFE);
            p2 = this.getRelativePosition(d2, 0x7FFFFFFE);
        } else if (p1 == Integer.MAX_VALUE && p2 == Integer.MAX_VALUE) {
            p1 = this.getRelativePosition(d1, Integer.MAX_VALUE);
            p2 = this.getRelativePosition(d2, Integer.MAX_VALUE);
        }
        int result = this.doCompare(p1, p2);
        if (result == 0) {
            result = dd1.getName().compareTo(dd2.getName());
        }
        return result;
    }

    protected abstract int getRelativePosition(DataSource var1, int var2);

    private int doCompare(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }
}

