#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.1
visibility:           public
id:                   arch-hs-0.12.0.1-7yJF1IFZrcpCDaoA2huFvO
key:                  arch-hs-0.12.0.1-7yJF1IFZrcpCDaoA2huFvO
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  4944a9c916156749d6caaf3757b145a3
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.1-7yJF1IFZrcpCDaoA2huFvO
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-94wHByfojTDaWJlRbLpnx
    aeson-2.1.2.1-LDBL5bcX1HC79scYyh3opi
    algebraic-graphs-0.7-6KI4cxEGeOSFUwmcUCvt4j
    arch-web-0.3.1-JObeVTug5Ak8ZhI8aceP5y base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-AL3EmwxQHuQ1mZT9WLAkFR
    conduit-extra-1.3.6-6dO1xP5ViME37M1InDuSps containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-480pvkFneX5BP9GAXdA3e
    http-client-0.7.17-39vQCRHDS8Y4AZkwpcxUyW
    http-client-tls-0.3.6.4-8CeCL7zDXbKxhjkugWal5
    megaparsec-9.6.1-AHfz4qPwoQs815dRss8YYZ
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    neat-interpolation-0.5.1.4-FDXf57UFkBoIcRk4AnF6I2
    optparse-simple-0.1.1.4-DHa8H4aVdj27U3REaghshn
    polysemy-1.9.2.0-LoSZtu0t3ha7XvG4ZRASfn
    prettyprinter-1.7.1-BaAmjemZ9A8Bwhfteg2YYF
    prettyprinter-ansi-terminal-1.1.3-3UaEd28yvERuzLBWT3ZVt
    servant-client-0.20-JwEsolkxlls9LEoxCk14Zl
    split-0.2.5-LghWP1sjueiF0Ln6STtUGf
    tar-conduit-0.4.1-13cXxZ4q50P2tD5heIDOsy template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

