#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.1
visibility:           public
id:                   arch-hs-0.12.0.1-IqiL3XTOIQtFN8scDWR873
key:                  arch-hs-0.12.0.1-IqiL3XTOIQtFN8scDWR873
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  15518130f4b6a772926d506902a01349
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.1-IqiL3XTOIQtFN8scDWR873
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-LlG9CqI0BWmDdGO3rVr0iN
    aeson-2.1.2.1-LS8mizUYnpf1U9zpV4sjcf
    algebraic-graphs-0.7-D2Hecr5Lv1OClon5EivPPD
    arch-web-0.3.1-ApJImpuM008D8t7vZB6HQ base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-LEKlJ5sjhOMOY4BoQvHAk
    conduit-extra-1.3.6-2wqo8ucVt5IGPwh2HHGSdk containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-2bc2GYzzJu2AsAZ3Of0Ok3
    http-client-0.7.18-LXBlgncwp3M12RggVCuJyY
    http-client-tls-0.3.6.4-EpkYNSTVr5IILDsEq9OqBv
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    neat-interpolation-0.5.1.4-2kcUPoncs8oJAGP7v0IPkf
    optparse-simple-0.1.1.4-GZvP5M3HVVWB8o6FOApC8H
    polysemy-1.9.2.0-4N0Frq85KnV1IT3OjB6v05
    prettyprinter-1.7.1-L5f5fQ72tN6KrwJu1IwhTZ
    prettyprinter-ansi-terminal-1.1.3-3gezl4y1Fis6b0vPmlsQhT
    servant-client-0.20-2PXYmIiQGaY4crM4QaX2oZ
    split-0.2.5-KcBaumhT6eFHklJKzsytdC
    tar-conduit-0.4.1-LngG8S44TPO9t3VHdr1Knb template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

