﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/AssessmentReportEvidenceError.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {
class BatchDisassociateAssessmentReportEvidenceResult {
 public:
  AWS_AUDITMANAGER_API BatchDisassociateAssessmentReportEvidenceResult() = default;
  AWS_AUDITMANAGER_API BatchDisassociateAssessmentReportEvidenceResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_AUDITMANAGER_API BatchDisassociateAssessmentReportEvidenceResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The identifier for the evidence. </p>
   */
  inline const Aws::Vector<Aws::String>& GetEvidenceIds() const { return m_evidenceIds; }
  template <typename EvidenceIdsT = Aws::Vector<Aws::String>>
  void SetEvidenceIds(EvidenceIdsT&& value) {
    m_evidenceIdsHasBeenSet = true;
    m_evidenceIds = std::forward<EvidenceIdsT>(value);
  }
  template <typename EvidenceIdsT = Aws::Vector<Aws::String>>
  BatchDisassociateAssessmentReportEvidenceResult& WithEvidenceIds(EvidenceIdsT&& value) {
    SetEvidenceIds(std::forward<EvidenceIdsT>(value));
    return *this;
  }
  template <typename EvidenceIdsT = Aws::String>
  BatchDisassociateAssessmentReportEvidenceResult& AddEvidenceIds(EvidenceIdsT&& value) {
    m_evidenceIdsHasBeenSet = true;
    m_evidenceIds.emplace_back(std::forward<EvidenceIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A list of errors that the
   * <code>BatchDisassociateAssessmentReportEvidence</code> API returned. </p>
   */
  inline const Aws::Vector<AssessmentReportEvidenceError>& GetErrors() const { return m_errors; }
  template <typename ErrorsT = Aws::Vector<AssessmentReportEvidenceError>>
  void SetErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors = std::forward<ErrorsT>(value);
  }
  template <typename ErrorsT = Aws::Vector<AssessmentReportEvidenceError>>
  BatchDisassociateAssessmentReportEvidenceResult& WithErrors(ErrorsT&& value) {
    SetErrors(std::forward<ErrorsT>(value));
    return *this;
  }
  template <typename ErrorsT = AssessmentReportEvidenceError>
  BatchDisassociateAssessmentReportEvidenceResult& AddErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors.emplace_back(std::forward<ErrorsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchDisassociateAssessmentReportEvidenceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_evidenceIds;

  Aws::Vector<AssessmentReportEvidenceError> m_errors;

  Aws::String m_requestId;
  bool m_evidenceIdsHasBeenSet = false;
  bool m_errorsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
