/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;

public class LocationPath
extends Path {
    private final boolean absolute;

    public LocationPath(boolean absolute, Step[] steps) {
        super(steps);
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean computeContextDependent() {
        return !this.absolute || super.computeContextDependent();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Step[] steps = this.getSteps();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                if (i > 0 || this.absolute) {
                    buffer.append('/');
                }
                buffer.append(steps[i]);
            }
        }
        return buffer.toString();
    }

    @Override
    public Object compute(EvalContext context) {
        EvalContext rootContext = this.isAbsolute() ? context.getRootContext().getAbsoluteRootContext() : new InitialContext(context);
        return this.evalSteps(rootContext);
    }

    @Override
    public Object computeValue(EvalContext context) {
        EvalContext rootContext = this.isAbsolute() ? context.getRootContext().getAbsoluteRootContext() : new InitialContext(context);
        return this.getSingleNodePointerForSteps(rootContext);
    }
}

