/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.AlternativeTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.CaptureTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.DefaultTokenPredicateFactory;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.OptionalTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenPredicateFactory;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SequenceTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;

public abstract class TokenPredicateFactory {
    @NotNull
    public static TokenPredicateFactory makeDefaultFactory() {
        return new DefaultTokenPredicateFactory();
    }

    @NotNull
    public static TokenPredicateFactory makeDialectSpecificFactory(@NotNull SQLRuleManager ruleManager) {
        return new SQLTokenPredicateFactory(ruleManager);
    }

    protected TokenPredicateFactory() {
    }

    @Nullable
    protected abstract SQLTokenType classifyToken(@NotNull String var1);

    @NotNull
    private TokenPredicateNode makeNode(@Nullable Object obj) {
        if (obj == null) {
            return new SQLTokenEntry(null, null, false);
        }
        if (obj instanceof TokenPredicateNode) {
            return (TokenPredicateNode)obj;
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return new SQLTokenEntry(string, this.classifyToken(string), false);
        }
        if (obj instanceof SQLTokenType) {
            return new SQLTokenEntry(null, (SQLTokenType)obj, false);
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private TokenPredicateNode[] makeGroup(Object ... objs) {
        return (TokenPredicateNode[])Arrays.stream(objs).map(this::makeNode).toArray(TokenPredicateNode[]::new);
    }

    @NotNull
    public TokenPredicateNode token(@NotNull Object obj) {
        return this.makeNode(obj);
    }

    @NotNull
    public TokenPredicateNode captureToken(@NotNull SQLTokenType type, String key) {
        return new CaptureTokenPredicateNode(null, type, key);
    }

    @NotNull
    public TokenPredicateNode captureToken(@NotNull String string, String key) {
        return new CaptureTokenPredicateNode(string, this.classifyToken(string), key);
    }

    @NotNull
    public TokenPredicateNode sequence(TokenPredicateNode ... nodes) {
        return new SequenceTokenPredicateNode(nodes);
    }

    @NotNull
    public TokenPredicateNode sequence(Object ... objs) {
        return new SequenceTokenPredicateNode(this.makeGroup(objs));
    }

    @NotNull
    public TokenPredicateNode alternative(TokenPredicateNode ... nodes) {
        return new AlternativeTokenPredicateNode(nodes);
    }

    @NotNull
    public TokenPredicateNode alternative(Object ... objs) {
        return new AlternativeTokenPredicateNode(this.makeGroup(objs));
    }

    @NotNull
    public TokenPredicateNode optional(@NotNull TokenPredicateNode node) {
        return new OptionalTokenPredicateNode(node);
    }

    @NotNull
    public TokenPredicateNode optional(Object ... obj) {
        return new OptionalTokenPredicateNode(obj.length == 1 ? this.makeNode(obj[0]) : this.sequence(obj));
    }

    @NotNull
    public TokenPredicateNode not(@NotNull String str) {
        return new SQLTokenEntry(str, this.classifyToken(str), true);
    }

    @NotNull
    public TokenPredicateNode not(@NotNull SQLTokenType token) {
        return new SQLTokenEntry(null, token, true);
    }
}

