/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTableColumn;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sUniqueKey;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class GBase8sTableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{GBase8sTableColumn.class, GBase8sUniqueKey.class, GenericTableForeignKey.class, GenericTableIndex.class});

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, GenericTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == GBase8sUniqueKey.class) {
            return object.getConstraints(monitor);
        }
        return super.getChildObjects(monitor, (DBSObject)object, childType);
    }

    public boolean canEditObject(GenericTableBase object) {
        return true;
    }

    public boolean canRenameObject(GenericTableBase object) {
        return false;
    }

    protected boolean isIncludeDropInDDL(GenericTableBase table) {
        return false;
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        DBPObject object = command.getObject();
        if (object instanceof DBSTableIndex) {
            for (SQLObjectEditor.NestedObjectCommand ccom : orderedCommands) {
                if (!this.isUniqueConstraint(ccom)) continue;
                List a = ((GenericTableIndex)object).getAttributeReferences(null);
                List b = ((GBase8sUniqueKey)ccom.getObject()).getAttributeReferences(null);
                if (a.size() != b.size() || !a.stream().allMatch(colA -> b.stream().anyMatch(colB -> colA.getName().equals(colB.getName())))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUniqueConstraint(SQLObjectEditor.NestedObjectCommand command) {
        return command.getObject() instanceof DBSEntityConstraint && ((DBSEntityConstraint)command.getObject()).getConstraintType().isUnique();
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @Nullable String newName) throws DBException {
        if (object.isView()) {
            throw new DBException("View rename is not supported");
        }
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) throws DBException {
        boolean hasDescription;
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        boolean objectSave = CommonUtils.getOption(options, (String)"object.save");
        boolean includeComments = CommonUtils.getOption(options, (String)"ddl.includeComments");
        boolean bl = hasDescription = !CommonUtils.isEmpty((String)tableBase.getDescription());
        if (objectSave && command.hasProperty((Object)"description") || hasDescription) {
            this.addTableCommentAction(actions, tableBase);
        }
        if (!tableBase.isPersisted() ? objectSave || includeComments : !objectSave && includeComments) {
            for (GenericTableColumn column : CommonUtils.safeCollection((Collection)tableBase.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                GenericTableColumnManager.addColumnCommentAction(actions, (DBSEntityAttribute)column, (DBSEntity)column.getTable());
            }
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericDataSource dataSource = (GenericDataSource)((GenericTableBase)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + (String)(((GenericTableBase)command.getObject()).getSchema() != null ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)((GenericTableBase)command.getObject()).getSchema().getName()) + "." : "") + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    private void addTableCommentAction(@NotNull List<DBEPersistAction> actionList, @NotNull GenericTableBase table) {
        String tableName = DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        String commentSQL = String.format("COMMENT ON TABLE %s IS %s", tableName, SQLUtils.quoteString((DBSObject)table, (String)CommonUtils.notEmpty((String)table.getDescription())));
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Table", commentSQL));
    }
}

