/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.css;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.css2.CSSPropertyBackgroundSWTHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CustomCompositeElementHandler
extends CSSPropertyBackgroundSWTHandler {
    public static final String PROP_BACKGROUND_COLOR = "background-color";
    public static final String PROP_COLOR = "color";
    private static final boolean APPLY_CON_TYPE_HIERARCHICALLY = false;

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Composite widget;
        Widget mimicControl;
        if (property.equals(PROP_BACKGROUND_COLOR) && UIStyles.isDarkTheme() && (mimicControl = CSSUtils.getMimicControl((Widget)(widget = (Composite)SWTElementHelpers.getWidget((Object)element)))) != null && CustomCompositeElementHandler.mimicControlStyles(engine, mimicControl, widget)) {
            return true;
        }
        return super.applyCSSProperty(element, property, value, pseudo, engine);
    }

    private static boolean mimicControlStyles(CSSEngine engine, Widget mimicControl, Composite widget) throws Exception {
        CSSStyleDeclaration computedStyle;
        Element mimicElement = engine.getElement((Object)mimicControl);
        if (mimicElement != null && (computedStyle = engine.getViewCSS().getComputedStyle(mimicElement, null)) != null) {
            Color bgColor = (Color)engine.convert(computedStyle.getPropertyCSSValue(PROP_BACKGROUND_COLOR), Color.class, (Object)widget.getDisplay());
            widget.setBackground(bgColor);
            return true;
        }
        return false;
    }

    public void applyCSSPropertyBackgroundColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Control ctrl;
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget == null || widget instanceof Control && UIUtils.isInDialog((Control)widget)) {
            super.applyCSSPropertyBackgroundColor(element, value, pseudo, engine);
            return;
        }
        if (widget instanceof Control && !((ctrl = (Control)widget) instanceof StyledText)) {
            Color newColor;
            boolean colorByConnectionType = false;
            colorByConnectionType = "coloredByConnectionType".equals(CSSUtils.getCSSClass(widget));
            if (colorByConnectionType && (newColor = CSSUtils.getCurrentEditorConnectionColor(widget)) != null) {
                this.applyCustomBackground(element, newColor);
                return;
            }
        }
        super.applyCSSPropertyBackgroundColor(element, value, pseudo, engine);
    }

    protected void applyCustomBackground(Object element, Color newColor) {
        Composite nativeWidget = (Composite)((CompositeElement)element).getNativeWidget();
        nativeWidget.setBackground(newColor);
    }
}

