/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.utils.CommonUtils;

public abstract class OracleTrigger<PARENT extends DBSObject>
extends OracleObject<PARENT>
implements DBSTrigger,
DBPQualifiedObject,
OracleSourceObject {
    private BaseObjectType objectType;
    private String triggerType;
    private String triggeringEvent;
    private String columnName;
    private String refNames;
    private String whenClause;
    private OracleObjectStatus status;
    private String description;
    private ActionType actionType;
    private String sourceDeclaration;

    public OracleTrigger(PARENT parent, String name) {
        super(parent, name, false);
    }

    public OracleTrigger(PARENT parent, ResultSet dbResult) {
        super(parent, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGGER_NAME"), true);
        this.objectType = (BaseObjectType)CommonUtils.valueOf(BaseObjectType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"BASE_OBJECT_TYPE"));
        this.triggerType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGGER_TYPE");
        this.triggeringEvent = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGGERING_EVENT");
        this.columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        this.refNames = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFERENCING_NAMES");
        this.whenClause = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WHEN_CLAUSE");
        this.status = (OracleObjectStatus)CommonUtils.valueOf(OracleObjectStatus.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"STATUS"));
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DESCRIPTION");
        this.actionType = "CALL".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_TYPE")) ? ActionType.CALL : ActionType.PLSQL;
    }

    @Override
    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=5)
    public BaseObjectType getObjectType() {
        return this.objectType;
    }

    @Property(viewable=true, order=5)
    public String getTriggerType() {
        return this.triggerType;
    }

    @Property(viewable=true, order=6)
    public String getTriggeringEvent() {
        return this.triggeringEvent;
    }

    @Property(viewable=true, order=7)
    public String getColumnName() {
        return this.columnName;
    }

    @Property(order=8)
    public String getRefNames() {
        return this.refNames;
    }

    @Property(order=9)
    public String getWhenClause() {
        return this.whenClause;
    }

    @Property(viewable=true, order=10)
    public OracleObjectStatus getStatus() {
        return this.status;
    }

    @Override
    @Property(length=PropertyLength.MULTILINE, order=11)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=12)
    public ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.TRIGGER;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = OracleUtils.getSource(monitor, this, false, true);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String source) {
        this.sourceDeclaration = source;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.status == OracleObjectStatus.ENABLED ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.status = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.TRIGGER) ? OracleObjectStatus.ENABLED : OracleObjectStatus.ERROR;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.TRIGGER, "Compile trigger", "ALTER TRIGGER " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    public static enum ActionType implements DBPNamedObject
    {
        PLSQL("PL/SQL"),
        CALL("CALL");

        private final String title;

        private ActionType(String title) {
            this.title = title;
        }

        @NotNull
        public String getName() {
            return this.title;
        }
    }

    public static enum BaseObjectType {
        TABLE,
        VIEW,
        SCHEMA,
        DATABASE;

    }
}

