/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.utils.CommonUtils;

class SpreadsheetFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(SpreadsheetFindReplaceTarget.class);
    private static final Object REDRAW_SYNC = new Object();
    private static SpreadsheetFindReplaceTarget instance;
    private int ownerIdentity;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;
    private boolean sessionActive = false;
    private boolean firstSearchInSession = true;
    private List<GridPos> originalSelection = new ArrayList<GridPos>();
    private final Set<DBDValueRow> updatedRows = new LinkedHashSet<DBDValueRow>();
    private final Set<DBDAttributeBinding> updatedAttributes = new LinkedHashSet<DBDAttributeBinding>();
    private final Set<GridPos> processedCells = new HashSet<GridPos>();
    private AbstractJob redrawJob = null;
    private String currentFindString = "";
    private boolean currentCaseSensitive;
    private boolean currentWholeWord;
    private boolean currentRegEx;

    SpreadsheetFindReplaceTarget() {
    }

    public static synchronized SpreadsheetFindReplaceTarget getInstance() {
        if (instance == null) {
            instance = new SpreadsheetFindReplaceTarget();
            SpreadsheetFindReplaceTarget.instance.scopeHighlightColor = UIStyles.getDefaultTextColor((String)"AbstractTextEditor.Color.FindScope", (int)26);
        }
        return instance;
    }

    public synchronized SpreadsheetFindReplaceTarget owned(@NotNull SpreadsheetPresentation newOwner) {
        this.refreshOwner(newOwner);
        return this;
    }

    public boolean isSessionActive() {
        return this.sessionActive;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Color getScopeHighlightColor() {
        return this.scopeHighlightColor;
    }

    public boolean canPerformFind() {
        return true;
    }

    public Point getSelection() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return new Point(0, 0);
        }
        Collection<Integer> rowSelection = owner.getSpreadsheet().getRowSelection();
        int minRow = rowSelection.stream().mapToInt(v -> v).min().orElse(-1);
        int maxRow = rowSelection.stream().mapToInt(v -> v).max().orElse(-1);
        return new Point(minRow, maxRow);
    }

    public String getSelectionText() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return "";
        }
        GridPos selection = owner.getSelection().getFirstElement();
        if (selection == null) {
            return "";
        }
        Spreadsheet spreadsheet = owner.getSpreadsheet();
        GridCell cell = spreadsheet.posToCell(selection);
        String value = cell == null ? "" : CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, false));
        return CommonUtils.toString((Object)value);
    }

    public boolean isEditable() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        return owner != null && owner.getController().getReadOnlyStatus() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSession() {
        Object object = REDRAW_SYNC;
        synchronized (object) {
            this.updatedRows.clear();
            this.updatedAttributes.clear();
        }
        this.processedCells.clear();
        SpreadsheetPresentation owner = this.getActiveSpreadsheet(false);
        if (owner == null) {
            return;
        }
        this.sessionActive = true;
        owner.getControl().redraw();
        this.originalSelection = new ArrayList<GridPos>(owner.getSpreadsheet().getSelection());
        owner.highlightRows(-1, -1, null);
    }

    public void endSession() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet(false);
        if (owner == null) {
            return;
        }
        this.sessionActive = false;
        this.searchPattern = null;
        this.firstSearchInSession = true;
        Control control = owner.getControl();
        if (control != null && !control.isDisposed()) {
            owner.getSpreadsheet().deselectAll();
            owner.getSpreadsheet().selectCells(this.originalSelection);
        }
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return;
        }
        if (scope == null || scope.getLength() == 0) {
            owner.highlightRows(-1, -1, null);
            if (scope == null) {
                owner.getSpreadsheet().deselectAll();
                owner.getSpreadsheet().selectCells(this.originalSelection);
            }
        } else {
            owner.highlightRows(scope.getOffset(), scope.getLength(), this.scopeHighlightColor);
        }
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return;
        }
        int columnCount = owner.getSpreadsheet().getColumnCount();
        ArrayList<GridPos> selRows = new ArrayList<GridPos>();
        int rowNum = 0;
        while (rowNum < length) {
            int col = 0;
            while (col < columnCount) {
                selRows.add(new GridPos(col, offset + rowNum));
                ++col;
            }
            ++rowNum;
        }
        owner.setSelection((ISelection)new StructuredSelection(selRows));
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replaceSelection(@NotNull String text, boolean regExReplace) {
        ResultSetCellLocation cellLocation;
        SpreadsheetPresentation owner;
        block19: {
            block20: {
                String oldValue;
                GridPos selection;
                owner = this.getActiveSpreadsheet();
                if (owner == null) {
                    return;
                }
                if (this.searchPattern == null && !this.currentFindString.isEmpty()) {
                    this.searchPattern = this.createSearchPattern(this.currentFindString, this.currentCaseSensitive, this.currentWholeWord, this.currentRegEx);
                }
                if ((selection = owner.getSelection().getFirstElement()) == null) {
                    return;
                }
                if (this.replaceAll && this.processedCells.contains(selection)) {
                    return;
                }
                GridCell cell = owner.getSpreadsheet().posToCell(selection);
                if (cell == null) {
                    return;
                }
                cellLocation = owner.getCellLocation(cell);
                String newValue = oldValue = CommonUtils.toString((Object)owner.getSpreadsheet().getContentProvider().getCellValue(cell.col, cell.row, true));
                if (this.searchPattern != null) {
                    newValue = this.searchPattern.matcher(oldValue).replaceAll(text);
                }
                try {
                    if (oldValue.equals(newValue)) {
                        if (!this.replaceAll) return;
                        this.searchPattern = null;
                        this.currentFindString = "";
                        return;
                    }
                }
                catch (DBException e) {
                    log.error((Object)"Error updating cell value", (Throwable)e);
                    if (this.replaceAll) {
                        this.searchPattern = null;
                        this.currentFindString = "";
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    if (!this.replaceAll) throw throwable;
                    this.searchPattern = null;
                    this.currentFindString = "";
                    throw throwable;
                }
                {
                    Object originalValue = owner.getSpreadsheet().getContentProvider().getCellValue(cell.col, cell.row, false);
                    if (originalValue instanceof DBDContent) {
                        DBDContent content = (DBDContent)originalValue;
                        content.updateContents((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContentStorage)new StringContentStorage(newValue));
                        new ResultSetValueController(owner.getController(), cellLocation, IValueController.EditType.NONE, null).updateValue(originalValue, !this.replaceAll);
                    } else {
                        owner.getController().updateCellValue(cellLocation.getAttribute(), cellLocation.getRow(), cellLocation.getRowIndexes(), newValue, !this.replaceAll);
                    }
                    if (!this.replaceAll) break block20;
                    this.processedCells.add(selection);
                }
            }
            if (this.replaceAll) {
                this.searchPattern = null;
                this.currentFindString = "";
            }
        }
        GridPos currentPos = owner.getSpreadsheet().getFocusPos();
        this.storeLastFoundPosition(currentPos);
        if (this.replaceAll) return;
        owner.getController().redrawData(true, true);
        Object object = REDRAW_SYNC;
        synchronized (object) {
            this.updatedAttributes.add(cellLocation.getAttribute());
            this.updatedRows.add(cellLocation.getRow());
            if (this.redrawJob != null) return;
            this.redrawJob = new AbstractJob("Redraw grid after replace"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(DBRProgressMonitor monitor) {
                    LinkedHashSet<DBDValueRow> rows;
                    LinkedHashSet<DBDAttributeBinding> attrs;
                    Object object = REDRAW_SYNC;
                    synchronized (object) {
                        attrs = new LinkedHashSet<DBDAttributeBinding>(SpreadsheetFindReplaceTarget.this.updatedAttributes);
                        rows = new LinkedHashSet<DBDValueRow>(SpreadsheetFindReplaceTarget.this.updatedRows);
                        SpreadsheetFindReplaceTarget.this.updatedAttributes.clear();
                        SpreadsheetFindReplaceTarget.this.updatedRows.clear();
                        SpreadsheetFindReplaceTarget.this.redrawJob = null;
                    }
                    UIUtils.syncExec(() -> {
                        owner.getController().refreshHintCache(attrs, rows, null);
                        owner.getController().redrawData(false, true);
                        owner.getController().updatePanelsContent(false);
                    });
                    return Status.OK_STATUS;
                }
            };
            this.redrawJob.schedule(150L);
            return;
        }
    }

    public int findAndSelect(int widgetOffset, @NotNull String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public int findAndSelect(int offset, @NotNull String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        Pattern pattern;
        this.currentFindString = findString;
        this.currentCaseSensitive = caseSensitive;
        this.currentWholeWord = wholeWord;
        this.currentRegEx = regExSearch;
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return -1;
        }
        ResultSetModel model = owner.getController().getModel();
        if (model.isEmpty()) {
            return -1;
        }
        Spreadsheet spreadsheet = owner.getSpreadsheet();
        int rowCount = spreadsheet.getItemCount();
        int columnCount = spreadsheet.getColumnCount();
        boolean recordMode = owner.getController().isRecordMode();
        int minColumn = recordMode ? -1 : 0;
        int firstRow = Math.max(owner.getHighlightScopeFirstLine(), 0);
        int lastRow = Math.min(owner.getHighlightScopeLastLine(), rowCount - 1);
        if (lastRow < 0) {
            lastRow = rowCount - 1;
        }
        GridPos startPos = this.getStartPosition(spreadsheet, searchForward, firstRow, lastRow, minColumn, columnCount, this.firstSearchInSession);
        if (this.firstSearchInSession) {
            this.firstSearchInSession = false;
            this.storeLastFoundPosition(startPos);
        }
        if ((pattern = this.createSearchPattern(this.currentFindString, this.currentCaseSensitive, this.currentWholeWord, this.currentRegEx)) == null) {
            return -1;
        }
        this.searchPattern = pattern;
        GridPos currentPos = new GridPos(startPos.col, startPos.row);
        boolean wrapped = false;
        int totalCells = (lastRow - firstRow + 1) * (columnCount - minColumn);
        int checked = 0;
        while (checked <= totalCells) {
            if (this.isCellInScope(currentPos, firstRow, lastRow, minColumn, columnCount)) {
                String cellText;
                if (!(this.replaceAll && this.processedCells.contains(currentPos) || (cellText = this.getCellText(spreadsheet, currentPos, recordMode, minColumn)) == null || !pattern.matcher(cellText).find())) {
                    this.selectCell(spreadsheet, currentPos, minColumn);
                    this.storeLastFoundPosition(currentPos);
                    return currentPos.row;
                }
                ++checked;
            }
            if (this.isCellInScope(currentPos = this.getNextPosition(currentPos, searchForward, columnCount, minColumn, firstRow, lastRow), firstRow, lastRow, minColumn, columnCount)) continue;
            if (wrapped) break;
            currentPos = this.getWrapAroundPosition(searchForward, firstRow, lastRow, minColumn, columnCount);
            wrapped = true;
        }
        this.processedCells.clear();
        return -1;
    }

    private Pattern createSearchPattern(@NotNull String findString, boolean caseSensitive, boolean wholeWord, boolean regEx) {
        if (findString.isEmpty()) {
            return null;
        }
        try {
            if (regEx) {
                return Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            Object pattern = wholeWord ? "\\b" + Pattern.quote(findString) + "\\b" : Pattern.quote(findString);
            return Pattern.compile((String)pattern, caseSensitive ? 0 : 2);
        }
        catch (PatternSyntaxException e) {
            log.error((Object)("Invalid search pattern: " + findString), (Throwable)e);
            return null;
        }
    }

    private GridPos getStartPosition(@NotNull Spreadsheet spreadsheet, boolean searchForward, int firstRow, int lastRow, int minColumn, int columnCount, boolean isFirstSearch) {
        GridPos currentPos = spreadsheet.getCursorPosition();
        if (currentPos == null) {
            return searchForward ? new GridPos(minColumn, firstRow) : new GridPos(columnCount - 1, lastRow);
        }
        return isFirstSearch ? currentPos : this.getNextPosition(currentPos, searchForward, columnCount, minColumn, firstRow, lastRow);
    }

    private void storeLastFoundPosition(@NotNull GridPos pos) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner != null) {
            Spreadsheet spreadsheet = owner.getSpreadsheet();
            if (owner.getController().isRecordMode() && pos.col == -1) {
                pos = new GridPos(0, pos.row);
            }
            spreadsheet.setFocusColumn(pos.col);
            spreadsheet.setFocusItem(pos.row);
            spreadsheet.setCellSelection(pos);
            spreadsheet.showSelection();
        }
    }

    private String getCellText(@NotNull Spreadsheet spreadsheet, @NotNull GridPos pos, boolean recordMode, int minColumn) {
        if (recordMode && pos.col == minColumn) {
            return spreadsheet.getLabelProvider().getText(spreadsheet.getRow(pos.row));
        }
        GridCell cell = spreadsheet.posToCell(pos);
        return cell != null ? CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, false)) : null;
    }

    private void selectCell(@NotNull Spreadsheet spreadsheet, @NotNull GridPos pos, int minColumn) {
        if (pos.col == minColumn) {
            pos = new GridPos(0, pos.row);
        }
        spreadsheet.setFocusColumn(pos.col);
        spreadsheet.setFocusItem(pos.row);
        spreadsheet.setCellSelection(pos);
        spreadsheet.showSelection();
    }

    private GridPos getNextPosition(@NotNull GridPos pos, boolean searchForward, int columnCount, int minColumn, int firstRow, int lastRow) {
        GridPos next = new GridPos(pos.col, pos.row);
        if (searchForward) {
            ++next.col;
            if (next.col >= columnCount) {
                next.col = minColumn;
                next.row = next.row >= lastRow ? firstRow : next.row + 1;
            }
        } else {
            --next.col;
            if (next.col < minColumn) {
                next.col = columnCount - 1;
                next.row = next.row <= firstRow ? lastRow : next.row - 1;
            }
        }
        return next;
    }

    private GridPos getWrapAroundPosition(boolean searchForward, int firstRow, int lastRow, int minColumn, int columnCount) {
        return searchForward ? new GridPos(minColumn, firstRow) : new GridPos(columnCount - 1, lastRow);
    }

    private boolean isCellInScope(GridPos pos, int firstRow, int lastRow, int minColumn, int columnCount) {
        return pos.row >= firstRow && pos.row <= lastRow && pos.col >= minColumn && pos.col < columnCount;
    }

    public String toString() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return super.toString();
        }
        DBSDataContainer dataContainer = owner.getController().getDataContainer();
        return "Target: " + (dataContainer == null ? null : dataContainer.getName());
    }

    private void refreshOwner(@NotNull SpreadsheetPresentation newOwner) {
        if (this.ownerIdentity == newOwner.hashCode()) {
            return;
        }
        boolean refreshSession = this.sessionActive;
        Pattern searchPattern = this.searchPattern;
        if (refreshSession) {
            this.endSession();
        }
        this.ownerIdentity = newOwner.hashCode();
        if (refreshSession) {
            this.beginSession();
            this.searchPattern = searchPattern;
        }
    }

    @Nullable
    private SpreadsheetPresentation getActiveSpreadsheet() {
        return this.getActiveSpreadsheet(true);
    }

    @Nullable
    private SpreadsheetPresentation getActiveSpreadsheet(boolean refreshActiveSpreadsheet) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        SpreadsheetPresentation spreadsheet = (SpreadsheetPresentation)activeEditor.getAdapter(SpreadsheetPresentation.class);
        if (spreadsheet == null) {
            return null;
        }
        if (refreshActiveSpreadsheet) {
            this.refreshOwner(spreadsheet);
        }
        return spreadsheet;
    }
}

