#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-Fyx7CFjT3Eb9P8OY2PhLFO
key:                  dhall-1.42.1-Fyx7CFjT3Eb9P8OY2PhLFO
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  467849c7f2b9ce0d65dda0f9d7eebe4d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-Fyx7CFjT3Eb9P8OY2PhLFO
depends:
    Diff-0.4.1-LlG9CqI0BWmDdGO3rVr0iN
    aeson-2.1.2.1-LS8mizUYnpf1U9zpV4sjcf
    aeson-pretty-0.8.10-CCkxQiITOw1DT6rZMnwiIR
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS
    atomic-write-0.2.1.1-6r6q9RQVRkJ80zKxzFbjv7 base-4.17.2.1
    base16-bytestring-1.0.2.0-L60Rqi32njv1QNA4jOe3ZV
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-FZkso54i68UDZy9QWLkbnV
    cborg-0.2.9.0-K9KsnPoq6aqJU9KJyDFlNF
    cborg-json-0.2.6.0-JG15jCHtRni9kG5eNqCC5s containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-KELsgKgjkD73rbSeiZmRup
    data-fix-0.3.3-AOSPUTFFnYPK2em0XT0Zo deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-7ngaaf4aUZkDN9ScahDVo6 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-K5YBh2hFOfsDmjdFaG2a7Y
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY haskeline-0.8.2
    http-client-0.7.18-LXBlgncwp3M12RggVCuJyY
    http-client-tls-0.3.6.4-EpkYNSTVr5IILDsEq9OqBv
    http-types-0.12.4-3waRWhsRr1C4PfAAAPJbwc
    indexed-traversable-0.1.4-GpzHE24npZbHvtNh8tX2xS
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-APaQU0Ye6OaKm6pWDY2rCG
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-39k4tAcUKBMAMGdiIGgBr9
    pretty-simple-4.1.3.0-LZgLKj6ccQI7Np83QXbC6H
    prettyprinter-1.7.1-L5f5fQ72tN6KrwJu1IwhTZ
    prettyprinter-ansi-terminal-1.1.3-3gezl4y1Fis6b0vPmlsQhT
    profunctors-5.6.2-EsgLQtFnlIg5jr0U9yDwZT
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-I6iMwi20J4G9Jw2tSdEPEK
    serialise-0.2.6.1-AAlJH1EtxKE6UR3G3pZvv1 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-10xlRiYQX4K76As3rHcTsG
    text-short-0.1.6-DNGGv482v6LFox88X13vWq
    th-lift-instances-0.1.20-7x3aJxt6vZXGANjpY7X1Vm time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-4KjQwvobFGi5CULM8PAvE4
    unordered-containers-0.2.20-vB8Yx6KwyeBrT13JKFJ0i
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

