/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.InvisibleView;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.ScaledStyleSheet;
import com.lightdev.app.shtm.Util;
import java.awt.Cursor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.StyleSheet;

public class SHTMLEditorKit
extends HTMLEditorKit {
    private static final ViewFactory defaultFactory = new SHTMLFactory();

    public SHTMLEditorKit() {
        Cursor textCursor = Cursor.getPredefinedCursor(2);
        this.setDefaultCursor(textCursor);
    }

    @Override
    protected HTMLEditorKit.Parser getParser() {
        return SHTMLDocument.defaultParser;
    }

    @Override
    public Document createDefaultDocument() {
        SHTMLDocument doc = this.createEmptyDocument();
        this.setStandardSuffix(doc);
        return doc;
    }

    void setStandardSuffix(SHTMLDocument doc) {
        String standardContent = Util.preferenceIsTrue("gray_row_below_end") ? "<p style=\"background-color: #808080\">\n&nbsp;\n</p>\n" : "<p>\n&nbsp;\n</p>\n";
        doc.setSuffix(standardContent);
    }

    private SHTMLDocument createEmptyDocument() {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        SHTMLDocument doc = new SHTMLDocument(ss);
        doc.setAsynchronousLoadPriority(-1);
        doc.setTokenThreshold(1);
        return doc;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof SHTMLDocument) {
            SHTMLDocument hdoc = (SHTMLDocument)doc;
            HTMLEditorKit.Parser parser = this.getParser();
            if (parser == null) {
                throw new IOException("Can't load parser");
            }
            if (pos > doc.getLength()) {
                throw new BadLocationException("Invalid location", pos);
            }
            HTMLEditorKit.ParserCallback receiver = hdoc.getReader(pos);
            if (doc.getLength() == 0) {
                Boolean ignoreCharset = (Boolean)doc.getProperty("IgnoreCharsetDirective");
                parser.parse(in, receiver, ignoreCharset != null && ignoreCharset != false);
            } else {
                parser.parse(in, receiver, true);
            }
            receiver.flush();
        } else {
            super.read(in, doc, pos);
        }
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof SHTMLDocument) {
            try {
                SHTMLDocument shtmlDoc = (SHTMLDocument)doc;
                SHTMLWriter w = new SHTMLWriter(out, shtmlDoc, pos, Math.max(0, Math.min(len, shtmlDoc.getLastDocumentPosition() - pos)));
                w.write();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (doc instanceof StyledDocument) {
            MinimalHTMLWriter w = new MinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
            w.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    void updateInputAttributes(SHTMLEditorPane e) {
        int start = e.getSelectionStart();
        SHTMLDocument doc = e.getDocument();
        Element currentParagraph = doc.getParagraphElement(start);
        Element run = currentParagraph.getStartOffset() == start || start != e.getSelectionEnd() ? doc.getCharacterElement(start) : doc.getCharacterElement(Math.max(start - 1, 0));
        this.createInputAttributes(run, this.getInputAttributes());
    }

    @Override
    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    public static void removeCharacterAttributes(StyledDocument doc, Object attributeName, int start, int length) {
        int end = start + length;
        int i = start;
        while (i < end) {
            Element characterElement = doc.getCharacterElement(i);
            SimpleAttributeSet sasText = new SimpleAttributeSet(characterElement.getAttributes().copyAttributes());
            MutableAttributeSet spanAttributes = attributeName != null ? (MutableAttributeSet)sasText.getAttribute(HTML.Tag.SPAN) : null;
            int endOffset = characterElement.getEndOffset();
            ArrayList<?> attributeNames = Collections.list(sasText.getAttributeNames());
            for (Object entryKey : attributeNames) {
                if (!entryKey.equals(attributeName) && (attributeName != null || entryKey.equals(StyleConstants.NameAttribute))) continue;
                sasText.removeAttribute(entryKey);
                if (spanAttributes == null) continue;
                spanAttributes.removeAttribute(entryKey);
            }
            int last = Math.min(end, endOffset);
            try {
                doc.setCharacterAttributes(i, last - i, sasText, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            i = i < last ? last : i + 1;
        }
    }

    public static class SHTMLFactory
    extends HTMLEditorKit.HTMLFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag kind;
            View view = null;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            view = o instanceof HTML.Tag ? ((kind = (HTML.Tag)o) == HTML.Tag.TABLE ? super.create(elem) : (kind == HTML.Tag.COMMENT ? new InvisibleView(elem) : (kind instanceof HTML.UnknownTag ? new InvisibleView(elem) : super.create(elem)))) : new LabelView(elem);
            return view;
        }
    }
}

