/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AntiAliasingConfigurator;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterConditions;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionNotSatisfiedDecorator;
import org.freeplane.features.filter.condition.ConjunctConditions;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.DisjunctConditions;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class AFilterComposerDialog
extends JDialog
implements IMapViewChangeListener {
    private boolean success;
    private static final long serialVersionUID = 1L;
    private static final int GAP_BETWEEN_BUTTONS = 10;
    private final JButton btnAnd;
    private final JButton btnApply;
    private final JButton btnCancel;
    private final JButton btnDelete;
    private final JButton btnName;
    private final JButton btnPin;
    private final JButton btnUnpin;
    private final JButton btnUp;
    private final JButton btnDown;
    private JButton btnLoad;
    private final JButton btnNot;
    private final JButton btnSplit;
    private final JButton btnOK;
    private final JButton btnOr;
    private JButton btnSave;
    private final ConditionListSelectionListener conditionListListener;
    private final FilterConditionEditor editor;
    private final JList<ASelectableCondition> elementaryConditionList;
    private final FilterController filterController;
    private FilterConditions internalConditionsModel;
    private Box conditionButtonBox;
    private final ConditionalStyleModel context;
    private static final Border pinnedBorder = new EmptyBorder(0, 12, 0, 0){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            AntiAliasingConfigurator.setAntialiasing((Graphics2D)g);
            g.setColor(c.getForeground());
            int pinRadius = 2;
            int pinDiameter = pinRadius * 2 + 1;
            g.drawOval(x + pinRadius, y + pinRadius, pinDiameter, pinDiameter);
            g.drawLine(x + pinDiameter, y + pinRadius + pinDiameter, x + pinDiameter, y + height * 3 / 4);
        }
    };

    public boolean isSuccess() {
        return this.success;
    }

    private void dispose(boolean b) {
        this.success = b;
        this.dispose();
    }

    private ASelectableCondition[] toConditionsArray(Object[] objects) {
        ASelectableCondition[] conditions = new ASelectableCondition[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            conditions[i] = (ASelectableCondition)objects[i];
        }
        return conditions;
    }

    public AFilterComposerDialog(String title, boolean modal, FilterConditionEditor.Variant variant, ConditionalStyleModel context) {
        super(UITools.getCurrentFrame(), title, modal);
        this.context = context;
        this.filterController = FilterController.getCurrentFilterController();
        this.editor = new FilterConditionEditor(this.filterController, variant);
        this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        this.getContentPane().add((Component)this.editor.getPanel(), "North");
        this.conditionButtonBox = Box.createVerticalBox();
        this.conditionButtonBox.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.getContentPane().add((Component)this.conditionButtonBox, "East");
        this.addAction(new AddElementaryConditionAction(), true);
        this.btnNot = this.addAction(new CreateNotSatisfiedConditionAction(), false);
        this.btnAnd = this.addAction(new CreateConjunctConditionAction(), false);
        this.btnOr = this.addAction(new CreateDisjunctConditionAction(), false);
        this.btnSplit = this.addAction(new SplitConditionAction(), false);
        this.btnDelete = this.addAction(new DeleteConditionAction(), false);
        this.btnName = this.addAction(new NameConditionAction(), false);
        this.btnPin = this.addAction(new MoveConditionAction(MoveActionDestination.PIN), false);
        this.btnUnpin = this.addAction(new MoveConditionAction(MoveActionDestination.UNPIN), false);
        this.btnUp = this.addAction(new MoveConditionAction(MoveActionDestination.UP), false);
        this.btnDown = this.addAction(new MoveConditionAction(MoveActionDestination.DOWN), false);
        this.conditionButtonBox.add(Box.createVerticalGlue());
        Box controllerBox = Box.createHorizontalBox();
        controllerBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.getContentPane().add((Component)controllerBox, "South");
        CloseAction closeAction = new CloseAction();
        this.btnOK = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.btnOK, TextUtils.getRawText("ok"));
        this.btnOK.addActionListener(closeAction);
        this.btnOK.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnOK);
        if (!this.isModal()) {
            this.btnApply = new JButton();
            LabelAndMnemonicSetter.setLabelAndMnemonic(this.btnApply, TextUtils.getRawText("apply"));
            this.btnApply.addActionListener(closeAction);
            this.btnApply.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
            controllerBox.add(Box.createHorizontalGlue());
            controllerBox.add(this.btnApply);
        } else {
            this.btnApply = null;
        }
        this.btnCancel = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.btnCancel, TextUtils.getRawText("cancel"));
        this.btnCancel.addActionListener(closeAction);
        this.btnCancel.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnCancel);
        controllerBox.add(Box.createHorizontalGlue());
        if (!Compat.isApplet()) {
            SaveAction saveAction = new SaveAction();
            this.btnSave = new JButton();
            LabelAndMnemonicSetter.setLabelAndMnemonic(this.btnSave, TextUtils.getRawText("save"));
            this.btnSave.addActionListener(saveAction);
            this.btnSave.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
            LoadAction loadAction = new LoadAction();
            this.btnLoad = new JButton();
            LabelAndMnemonicSetter.setLabelAndMnemonic(this.btnLoad, TextUtils.getRawText("load"));
            this.btnLoad.addActionListener(loadAction);
            this.btnLoad.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
            controllerBox.add(this.btnSave);
            controllerBox.add(Box.createHorizontalGlue());
            controllerBox.add(this.btnLoad);
            controllerBox.add(Box.createHorizontalGlue());
        }
        this.elementaryConditionList = new JList();
        this.elementaryConditionList.setSelectionMode(2);
        this.elementaryConditionList.setCellRenderer(this.conditionRenderer());
        this.elementaryConditionList.setLayoutOrientation(0);
        this.elementaryConditionList.setAlignmentX(0.0f);
        this.conditionListListener = new ConditionListSelectionListener();
        this.elementaryConditionList.addListSelectionListener(this.conditionListListener);
        this.elementaryConditionList.addMouseListener(new ConditionListMouseListener());
        JScrollPane conditionScrollPane = new JScrollPane(this.elementaryConditionList);
        UITools.setScrollbarIncrement(conditionScrollPane);
        UITools.addScrollbarIncrementPropertyListener(conditionScrollPane);
        JLabel conditionColumnHeader = new JLabel(TextUtils.getText("filter_conditions"));
        conditionColumnHeader.setHorizontalAlignment(0);
        conditionScrollPane.setColumnHeaderView(conditionColumnHeader);
        Rectangle screenBounds = UITools.getAvailableScreenBounds(this);
        Dimension preferredSize = new Dimension(screenBounds.width * 2 / 3, screenBounds.height * 2 / 3);
        conditionScrollPane.setPreferredSize(preferredSize);
        this.getContentPane().add((Component)conditionScrollPane, "Center");
        UITools.addEscapeActionToDialog(this);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && !AFilterComposerDialog.this.isShowing()) {
                    AFilterComposerDialog.this.filterController.setHighlightCondition(null, null);
                }
            }
        });
        this.pack();
    }

    private ListCellRenderer<ASelectableCondition> conditionRenderer() {
        return new ListCellRenderer<ASelectableCondition>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ASelectableCondition> list, ASelectableCondition value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultConditionRenderer conditionRenderer = AFilterComposerDialog.this.filterController.getConditionRenderer();
                JComponent component = conditionRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index >= 0 && index < AFilterComposerDialog.this.internalConditionsModel.getPinnedConditionsCount()) {
                    component.setBorder(pinnedBorder);
                }
                return component;
            }
        };
    }

    public void setConditionRenderer(ListCellRenderer cellRenderer) {
        this.elementaryConditionList.setCellRenderer(cellRenderer);
    }

    private JButton addAction(AFreeplaneAction action, boolean enabled) {
        JButton button = TranslatedElementFactory.createButtonWithIcon(action, action.getIconKey(), action.getTextKey());
        button.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
        this.conditionButtonBox.add(Box.createVerticalStrut(10));
        this.conditionButtonBox.add(button);
        if (!enabled) {
            button.setEnabled(false);
        }
        return button;
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        this.editor.filterChanged(newView != null ? Controller.getCurrentController().getSelection().getFilter() : null);
    }

    private boolean applyChanges() {
        this.internalConditionsModel.setSelectedItem(this.elementaryConditionList.getSelectedValue());
        int[] selectedIndices = this.elementaryConditionList.getSelectedIndices();
        if (this.isSelectionValid(selectedIndices)) {
            this.applyModel(this.internalConditionsModel, selectedIndices);
            this.internalConditionsModel = null;
            return true;
        }
        return false;
    }

    protected abstract boolean isSelectionValid(int[] var1);

    protected abstract void applyModel(FilterConditions var1, int[] var2);

    protected JFileChooser getFileChooser() {
        JFreeplaneCustomizableFileChooser chooser = UrlManager.getController().getFileChooser(MindMapFilterFileFilter.filter);
        return chooser;
    }

    private void initInternalConditionModel() {
        int selectedIndex;
        this.internalConditionsModel = this.createModel();
        this.elementaryConditionList.setModel(this.internalConditionsModel.getConditions());
        ASelectableCondition selectedItem = this.internalConditionsModel.getSelectedItem();
        if (selectedItem != null && (selectedIndex = this.internalConditionsModel.getIndexOf(selectedItem)) >= 0) {
            this.elementaryConditionList.setSelectedIndex(selectedIndex);
        }
    }

    protected abstract FilterConditions createModel();

    private boolean selectCondition() {
        int max;
        int min = this.elementaryConditionList.getMinSelectionIndex();
        if (min >= 0 && min == (max = this.elementaryConditionList.getMinSelectionIndex())) {
            return this.applyChanges();
        }
        return false;
    }

    public void setSelectedItem(Object selectedItem) {
        this.elementaryConditionList.setSelectedValue(selectedItem, true);
    }

    @Override
    public void show() {
        this.initInternalConditionModel();
        this.success = false;
        super.show();
    }

    private class AddElementaryConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        AddElementaryConditionAction() {
            super("AddElementaryConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Controller.getCurrentController().getSelection() == null) {
                return;
            }
            ASelectableCondition newCond = AFilterComposerDialog.this.editor.getCondition();
            if (newCond != null) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
                model.addElement(newCond);
            }
            AFilterComposerDialog.this.validate();
        }
    }

    private class CreateNotSatisfiedConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        CreateNotSatisfiedConditionAction() {
            super("CreateNotSatisfiedConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int max;
            int min = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex();
            if (min >= 0 && min == (max = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex())) {
                ASelectableCondition oldCond = (ASelectableCondition)AFilterComposerDialog.this.elementaryConditionList.getSelectedValue();
                ConditionNotSatisfiedDecorator newCond = new ConditionNotSatisfiedDecorator(oldCond);
                DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
                model.addElement(newCond);
                AFilterComposerDialog.this.validate();
            }
        }
    }

    private class CreateConjunctConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        CreateConjunctConditionAction() {
            super("CreateConjunctConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ASelectableCondition[] selectedValues = AFilterComposerDialog.this.toConditionsArray(AFilterComposerDialog.this.elementaryConditionList.getSelectedValues());
            if (selectedValues.length < 2) {
                return;
            }
            ConjunctConditions newCond = ConjunctConditions.combine(selectedValues);
            DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
            model.addElement(newCond);
            AFilterComposerDialog.this.validate();
        }
    }

    private class CreateDisjunctConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        CreateDisjunctConditionAction() {
            super("CreateDisjunctConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ASelectableCondition[] selectedValues = AFilterComposerDialog.this.toConditionsArray(AFilterComposerDialog.this.elementaryConditionList.getSelectedValues());
            if (selectedValues.length < 2) {
                return;
            }
            DisjunctConditions newCond = DisjunctConditions.combine(selectedValues);
            DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
            model.addElement(newCond);
            AFilterComposerDialog.this.validate();
        }
    }

    private class SplitConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        SplitConditionAction() {
            super("SplitConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int max;
            int min = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex();
            if (min >= 0 && min == (max = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex())) {
                ASelectableCondition oldCond = (ASelectableCondition)AFilterComposerDialog.this.elementaryConditionList.getSelectedValue();
                if (!(oldCond instanceof ICombinedCondition)) {
                    return;
                }
                Collection<ASelectableCondition> newConditions = ((ICombinedCondition)((Object)oldCond)).split();
                DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
                for (ASelectableCondition newCond : newConditions) {
                    int index = model.getIndexOf(newCond);
                    if (-1 == index) {
                        model.addElement(newCond);
                        int newIndex = model.getSize() - 1;
                        AFilterComposerDialog.this.elementaryConditionList.addSelectionInterval(newIndex, newIndex);
                        continue;
                    }
                    AFilterComposerDialog.this.elementaryConditionList.addSelectionInterval(index, index);
                }
                AFilterComposerDialog.this.elementaryConditionList.removeSelectionInterval(min, min);
                AFilterComposerDialog.this.validate();
            }
        }
    }

    private class DeleteConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        DeleteConditionAction() {
            super("DeleteConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex;
            DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
            int minSelectionIndex = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex();
            while (0 <= (selectedIndex = AFilterComposerDialog.this.elementaryConditionList.getSelectedIndex())) {
                model.removeElementAt(selectedIndex);
            }
            int size = AFilterComposerDialog.this.elementaryConditionList.getModel().getSize();
            if (size > 0) {
                AFilterComposerDialog.this.elementaryConditionList.setSelectedIndex(minSelectionIndex < size ? minSelectionIndex : size - 1);
            }
            AFilterComposerDialog.this.validate();
        }
    }

    private class NameConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        NameConditionAction() {
            super("NameConditionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
            int minSelectionIndex = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex();
            if (minSelectionIndex == -1) {
                return;
            }
            ASelectableCondition condition = (ASelectableCondition)model.getElementAt(minSelectionIndex);
            String userName = condition.getUserName();
            String newUserName = JOptionPane.showInputDialog(AFilterComposerDialog.this, TextUtils.getText("enter_condition_name"), userName == null ? "" : userName);
            if (newUserName == null) {
                return;
            }
            XMLElement xmlCondition = new XMLElement();
            condition.toXml(xmlCondition);
            ASelectableCondition newCondition = AFilterComposerDialog.this.filterController.getConditionFactory().loadCondition(xmlCondition.getChildAtIndex(0));
            if (newCondition == null) {
                return;
            }
            if (newUserName.equals("")) {
                if (userName == null) {
                    return;
                }
                newCondition.setUserName(null);
            } else {
                if (newUserName.equals(userName)) {
                    return;
                }
                newCondition.setUserName(newUserName);
            }
            model.removeElementAt(minSelectionIndex);
            model.insertElementAt(newCondition, minSelectionIndex);
        }
    }

    private class MoveConditionAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;
        private final MoveActionDestination destination;
        private DefaultComboBoxModel model;
        private int[] selectedIndices;

        MoveConditionAction(MoveActionDestination destination) {
            super(destination.actionKey);
            this.destination = destination;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.model = (DefaultComboBoxModel)AFilterComposerDialog.this.elementaryConditionList.getModel();
            this.selectedIndices = AFilterComposerDialog.this.elementaryConditionList.getSelectedIndices();
            if (this.destination == MoveActionDestination.UP || this.destination == MoveActionDestination.PIN) {
                for (int selectedIndexPosition = 0; selectedIndexPosition < this.selectedIndices.length; ++selectedIndexPosition) {
                    this.moveIndex(selectedIndexPosition);
                }
            } else {
                for (int selectedIndexPosition = this.selectedIndices.length - 1; selectedIndexPosition >= 0; --selectedIndexPosition) {
                    this.moveIndex(selectedIndexPosition);
                }
            }
            AFilterComposerDialog.this.elementaryConditionList.setSelectedIndices(this.selectedIndices);
        }

        private void moveIndex(int selectedIndexPosition) {
            int newPosition;
            int index = this.selectedIndices[selectedIndexPosition];
            int pinnedConditionsCount = AFilterComposerDialog.this.internalConditionsModel.getPinnedConditionsCount();
            if (this.destination == MoveActionDestination.PIN && index < pinnedConditionsCount || this.destination == MoveActionDestination.UNPIN && index >= pinnedConditionsCount) {
                return;
            }
            switch (this.destination.ordinal()) {
                case 0: {
                    newPosition = index - 1;
                    break;
                }
                case 1: {
                    newPosition = index + 1;
                    break;
                }
                case 2: {
                    newPosition = pinnedConditionsCount;
                    break;
                }
                case 3: {
                    newPosition = pinnedConditionsCount - 1;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ASelectableCondition condition = (ASelectableCondition)this.model.getElementAt(index);
            if (newPosition >= 0 && newPosition < this.model.getSize()) {
                this.model.removeElementAt(index);
                this.model.insertElementAt(condition, newPosition);
                this.selectedIndices[selectedIndexPosition] = newPosition;
                if (this.destination == MoveActionDestination.PIN || this.destination == MoveActionDestination.UP && newPosition == pinnedConditionsCount - 1) {
                    AFilterComposerDialog.this.internalConditionsModel.setPinnedConditionsCount(pinnedConditionsCount + 1);
                } else if (this.destination == MoveActionDestination.UNPIN || this.destination == MoveActionDestination.DOWN && newPosition == pinnedConditionsCount) {
                    AFilterComposerDialog.this.internalConditionsModel.setPinnedConditionsCount(pinnedConditionsCount - 1);
                }
            }
        }
    }

    private static enum MoveActionDestination {
        UP,
        DOWN,
        PIN,
        UNPIN;

        final String actionKey;

        private MoveActionDestination() {
            String name = this.name();
            this.actionKey = name.charAt(0) + name.substring(1).toLowerCase() + "ConditionAction";
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            boolean success = source == AFilterComposerDialog.this.btnOK || source == AFilterComposerDialog.this.btnApply ? AFilterComposerDialog.this.applyChanges() : true;
            if (!success) {
                return;
            }
            AFilterComposerDialog.this.internalConditionsModel = null;
            if (source == AFilterComposerDialog.this.btnOK) {
                AFilterComposerDialog.this.dispose(true);
            } else if (source == AFilterComposerDialog.this.btnCancel) {
                AFilterComposerDialog.this.dispose(false);
            } else {
                AFilterComposerDialog.this.initInternalConditionModel();
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = AFilterComposerDialog.this.getFileChooser();
            chooser.setDialogTitle(TextUtils.getText("SaveAsAction.text"));
            int returnVal = chooser.showSaveDialog(AFilterComposerDialog.this);
            if (returnVal != 0) {
                return;
            }
            try {
                File f = chooser.getSelectedFile();
                String canonicalPath = f.getCanonicalPath();
                String suffix = ".mmfilter";
                if (!canonicalPath.endsWith(".mmfilter")) {
                    canonicalPath = canonicalPath + ".mmfilter";
                }
                AFilterComposerDialog.this.filterController.saveConditions(AFilterComposerDialog.this.internalConditionsModel, canonicalPath, Integer.MAX_VALUE);
            }
            catch (Exception ex) {
                LogUtils.severe(ex);
            }
        }
    }

    private class LoadAction
    implements ActionListener {
        private LoadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = AFilterComposerDialog.this.getFileChooser();
            int returnVal = chooser.showOpenDialog(AFilterComposerDialog.this);
            if (returnVal == 0) {
                try {
                    File theFile = chooser.getSelectedFile();
                    AFilterComposerDialog.this.internalConditionsModel.removeAllElements();
                    AFilterComposerDialog.this.filterController.loadConditions(AFilterComposerDialog.this.internalConditionsModel, theFile.getCanonicalPath(), true);
                }
                catch (Exception ex) {
                    LogUtils.severe(ex);
                }
            }
        }
    }

    private class ConditionListSelectionListener
    implements ListSelectionListener {
        private ConditionListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int minSelectionIndex = AFilterComposerDialog.this.elementaryConditionList.getMinSelectionIndex();
            if (minSelectionIndex == -1) {
                AFilterComposerDialog.this.btnNot.setEnabled(false);
                AFilterComposerDialog.this.btnSplit.setEnabled(false);
                AFilterComposerDialog.this.btnAnd.setEnabled(false);
                AFilterComposerDialog.this.btnOr.setEnabled(false);
                AFilterComposerDialog.this.btnDelete.setEnabled(false);
                AFilterComposerDialog.this.btnName.setEnabled(false);
                AFilterComposerDialog.this.btnPin.setEnabled(false);
                AFilterComposerDialog.this.btnUnpin.setEnabled(false);
                AFilterComposerDialog.this.btnUp.setEnabled(false);
                AFilterComposerDialog.this.btnDown.setEnabled(false);
                AFilterComposerDialog.this.filterController.setHighlightCondition(null, null);
            } else {
                AFilterComposerDialog.this.btnPin.setEnabled(true);
                AFilterComposerDialog.this.btnUnpin.setEnabled(true);
                AFilterComposerDialog.this.btnUp.setEnabled(true);
                AFilterComposerDialog.this.btnDown.setEnabled(true);
                boolean areValuesOnlySelected = !this.isNullSelected();
                AFilterComposerDialog.this.btnDelete.setEnabled(areValuesOnlySelected);
                int maxSelectionIndex = AFilterComposerDialog.this.elementaryConditionList.getMaxSelectionIndex();
                boolean oneElementChosen = minSelectionIndex == maxSelectionIndex;
                AFilterComposerDialog.this.btnNot.setEnabled(oneElementChosen && areValuesOnlySelected);
                AFilterComposerDialog.this.btnName.setEnabled(oneElementChosen && areValuesOnlySelected);
                AFilterComposerDialog.this.btnAnd.setEnabled(!oneElementChosen && areValuesOnlySelected);
                AFilterComposerDialog.this.btnOr.setEnabled(!oneElementChosen && areValuesOnlySelected);
                AFilterComposerDialog.this.btnSplit.setEnabled(oneElementChosen && AFilterComposerDialog.this.elementaryConditionList.getSelectedValue() instanceof ICombinedCondition);
                if (oneElementChosen) {
                    AFilterComposerDialog.this.filterController.setHighlightCondition((ASelectableCondition)AFilterComposerDialog.this.elementaryConditionList.getSelectedValue(), AFilterComposerDialog.this.context);
                } else {
                    AFilterComposerDialog.this.filterController.setHighlightCondition(null, null);
                }
            }
        }

        private boolean isNullSelected() {
            for (Object selectedValue : AFilterComposerDialog.this.elementaryConditionList.getSelectedValuesList()) {
                if (selectedValue != null) continue;
                return true;
            }
            return false;
        }
    }

    private class ConditionListMouseListener
    extends MouseAdapter {
        private ConditionListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AFilterComposerDialog.this.selectCondition()) {
                            AFilterComposerDialog.this.dispose(true);
                        }
                    }
                });
            }
        }
    }

    private static class MindMapFilterFileFilter
    extends FileFilter {
        static FileFilter filter = new MindMapFilterFileFilter();

        private MindMapFilterFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileUtils.getExtension(f.getName());
            if (extension != null) {
                return extension.equals("mmfilter");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return TextUtils.getText("mindmaps_filter_desc");
        }
    }
}

