/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.JColorButton;
import org.freeplane.core.resources.components.ResponsiveFlowLayout;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.ColorTracker;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.AutoResizedTable;
import org.freeplane.core.ui.components.JFilterableComboBox;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditorHolder;

class TagEditor {
    private static final JPanel TRANSPARENT_RENDERER = new JPanel();
    private static final String WIDTH_PROPERTY = "tagDialog.width";
    private static final String HEIGHT_PROPERTY = "tagDialog.height";
    private static String importId;
    private final NodeModel node;
    private MIconController iconController;
    private JTable tagTable;
    private JDialog dialog;
    private final JColorButton colorButton;
    private final Action modifyColorAction;
    private final JTextField tagCategorySeparatorField;
    private TagCategories tagCategories;

    TagEditor(MIconController iconController, RootPaneContainer frame, final NodeModel node) {
        this.iconController = iconController;
        this.node = node;
        String title = TextUtils.getText((String)"edit_tags") + " (" + TextController.getController().getShortPlainText(node) + ")";
        this.dialog = frame instanceof Frame ? new JDialog((Frame)((Object)frame), title, false) : new JDialog((JDialog)frame, title, false);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JButton sortButton = new JButton();
        this.modifyColorAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditor.this.modifyTagColor();
            }
        };
        this.colorButton = new JColorButton(this.modifyColorAction);
        this.colorButton.setColor(Tag.EMPTY_TAG.getColor());
        final JCheckBox enterConfirms = new JCheckBox("", ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okButton, (String)TextUtils.getRawText((String)"ok"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelButton, (String)TextUtils.getRawText((String)"cancel"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)sortButton, (String)TextUtils.getRawText((String)"sort"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)enterConfirms, (String)TextUtils.getRawText((String)"enter_confirms"));
        this.modifyColorAction.setEnabled(false);
        okButton.addActionListener(e -> {
            this.closeDialog();
            this.submit();
        });
        cancelButton.addActionListener(e -> this.closeDialog());
        sortButton.addActionListener(e -> this.sortSelectedTags());
        this.tagCategories = this.getCurrentMapTagCategories().copy();
        JPanel buttonPane = new JPanel((LayoutManager)new ResponsiveFlowLayout());
        this.tagCategorySeparatorField = new JTextField(10);
        this.tagCategorySeparatorField.setText(this.tagCategories.getTagCategorySeparator());
        buttonPane.add(TranslatedElementFactory.createLabel((String)"OptionPanel.category_separator"));
        buttonPane.add(this.tagCategorySeparatorField);
        buttonPane.add(enterConfirms);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add((Component)this.colorButton);
        buttonPane.add(sortButton);
        buttonPane.setMaximumSize(new Dimension(1000, 20));
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        Container contentPane = this.dialog.getContentPane();
        JRestrictedSizeScrollPane editorScrollPane = this.createScrollPane();
        List<Tag> originalNodeTags = iconController.getTags(node).stream().map(tag -> (Tag)this.tagCategories.getTag(tag).get()).collect(Collectors.toList());
        this.tagTable = this.createTagTable(originalNodeTags);
        this.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1 || e.getType() == 0) {
                    SwingUtilities.invokeLater(() -> this.merge(e));
                }
            }

            private void merge(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                TagsWrapper tags = TagEditor.this.getTableModel();
                if (lastRow == -1) {
                    return;
                }
                if (firstRow == lastRow) {
                    this.merge(Collections.singleton(tags.getTag(firstRow)));
                } else {
                    ArrayList<Tag> mergedTags = new ArrayList<Tag>(lastRow - firstRow + 1);
                    for (int i = firstRow; i <= lastRow; ++i) {
                        mergedTags.add(tags.getTag(i));
                    }
                }
            }

            private void merge(Collection<Tag> tags) {
                tags.forEach(this::merge);
            }

            private void merge(Tag tag) {
                if (tag.isEmpty()) {
                    return;
                }
                TagsWrapper tags = TagEditor.this.getTableModel();
                boolean found = false;
                for (int i = 0; i < tags.getRowCount(); ++i) {
                    if (!tags.getTag(i).equals((Object)tag)) continue;
                    if (found) {
                        tags.removeTag(i--);
                        continue;
                    }
                    found = true;
                }
            }
        });
        this.tagCategorySeparatorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TagEditor.this.updateTagCategorySeparator();
            }
        });
        JMenuBar menubar = new JMenuBar();
        JMenu editMenu = TranslatedElementFactory.createMenu((String)"edit");
        JMenuItem addTagMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_addTag");
        addTagMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 1));
        addTagMenuItem.addActionListener(ev -> this.insertTags());
        editMenu.add(addTagMenuItem);
        JMenuItem removeMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_remove");
        removeMenuItem.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        removeMenuItem.addActionListener(ev -> this.deleteTags());
        editMenu.add(removeMenuItem);
        JMenuItem copyMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_copy");
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        copyMenuItem.addActionListener(ev -> TransferHandler.getCopyAction().actionPerformed(this.toTableEvent(ev)));
        editMenu.add(copyMenuItem);
        JMenuItem cutMenuItem = TranslatedElementFactory.createMenuItem((String)"CutAction.text");
        cutMenuItem.addActionListener(ev -> TransferHandler.getCutAction().actionPerformed(this.toTableEvent(ev)));
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        editMenu.add(cutMenuItem);
        JMenuItem pasteMenuItem = TranslatedElementFactory.createMenuItem((String)"PasteAction.text");
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        pasteMenuItem.addActionListener(ev -> TransferHandler.getPasteAction().actionPerformed(this.toTableEvent(ev)));
        editMenu.add(pasteMenuItem);
        JMenuItem colorMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_color");
        colorMenuItem.addActionListener(this.modifyColorAction);
        editMenu.add(colorMenuItem);
        editMenu.addSeparator();
        JMenuItem insertIntoNodesMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_insert");
        insertIntoNodesMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        insertIntoNodesMenuItem.addActionListener(e -> this.insertSelectedTagsIntoSelectedNodes());
        editMenu.add(insertIntoNodesMenuItem);
        JMenuItem removeFromNodesMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_remove");
        removeFromNodesMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        removeFromNodesMenuItem.addActionListener(e -> this.removeSelectedTagsFromSelectedNodes());
        editMenu.add(removeFromNodesMenuItem);
        menubar.add(editMenu);
        if (!this.tagCategories.isEmpty()) {
            JMenu insertMenu = TranslatedElementFactory.createMenu((String)"insert");
            insertMenu.addSeparator();
            insertMenu.add(iconController.createTagSubmenu("menu_tag", this.getCurrentMapTagCategories(), tag -> this.getTableModel().insertTag(this.tagTable.getSelectedRow(), (Tag)tag)));
            menubar.add(insertMenu);
        }
        this.dialog.setJMenuBar(menubar);
        editorScrollPane.setViewportView((Component)this.tagTable);
        editorScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TagEditor.this.tagTable.revalidate();
                TagEditor.this.tagTable.repaint();
            }
        });
        enterConfirms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditor.this.tagTable.requestFocus();
                ResourceController.getResourceController().setProperty("el__enter_confirms_by_default", Boolean.toString(enterConfirms.isSelected()));
            }
        });
        this.tagTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        e.consume();
                        TagEditor.this.closeDialog();
                        break;
                    }
                    case 10: {
                        if ((e.getModifiersEx() & 0x40) != 0) break;
                        e.consume();
                        if (enterConfirms.isSelected() == ((e.getModifiers() & 8) != 0)) {
                            TagEditor.this.insertTags();
                            break;
                        }
                        TagEditor.this.closeDialog();
                        TagEditor.this.submit();
                        break;
                    }
                    case 8: 
                    case 127: {
                        e.consume();
                        TagEditor.this.deleteTags();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.tagTable.getSelectionModel().addListSelectionListener(this::updateColorButton);
        this.tagTable.getModel().addTableModelListener(this::selectRowsAfterUpdate);
        this.tagTable.changeSelection(this.tagTable.getRowCount() - 1, 0, true, false);
        contentPane.add((Component)editorScrollPane, "Center");
        boolean areButtonsAtTheTop = ResourceController.getResourceController().getBooleanProperty("el__buttons_above");
        contentPane.add((Component)buttonPane, areButtonsAtTheTop ? "North" : "South");
        node.addExtension((IExtension)new TagEditorHolder(node, this.dialog));
        this.dialog.pack();
        this.restoreDialogSize(this.dialog);
        this.dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                TagEditor.this.saveDialogSize(TagEditor.this.dialog);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                node.removeExtension(TagEditorHolder.class);
                TagEditor.this.dialog.dispose();
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TagEditor.this.dialog.isVisible()) {
                    TagEditor.this.confirmedSubmit();
                }
            }
        });
    }

    private ActionEvent toTableEvent(ActionEvent ev) {
        return new ActionEvent(this.tagTable, ev.getID(), ev.getActionCommand(), ev.getWhen(), ev.getModifiers());
    }

    private void restoreDialogSize(JDialog dialog) {
        ResourceController resourceController = ResourceController.getResourceController();
        int width = resourceController.getIntProperty(WIDTH_PROPERTY, 0);
        int height = resourceController.getIntProperty(HEIGHT_PROPERTY, 0);
        if (width > 0 && height > 0) {
            dialog.setSize(width, height);
        }
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
    }

    private void insertSelectedTagsIntoSelectedNodes() {
        List<Tag> selectedTags = this.collectSelectedTags().collect(Collectors.toList());
        this.iconController.insertTagsIntoSelectedNodes(selectedTags);
    }

    private void removeSelectedTagsFromSelectedNodes() {
        Set<Tag> selectedTags = this.collectSelectedTags().collect(Collectors.toSet());
        this.iconController.removeSelectedTagsFromSelectedNodes(selectedTags);
    }

    private Stream<Tag> collectSelectedTags() {
        return IntStream.of(this.tagTable.getSelectedRows()).mapToObj(row -> (Tag)this.tagTable.getValueAt(row, 0));
    }

    private void insertTags() {
        ListSelectionModel selectionModel = this.tagTable.getSelectionModel();
        int minSelectedRow = selectionModel.getMinSelectionIndex();
        if (minSelectedRow >= 0) {
            int maxSelectionRow = selectionModel.getMaxSelectionIndex();
            int count = maxSelectionRow - minSelectedRow + 1;
            this.getTableModel().insertEmptyTags(minSelectedRow + count, maxSelectionRow + count);
        }
    }

    private void modifyTagColor() {
        int selectedRow = this.tagTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Tag modifiedCategorizedTag = (Tag)this.tagTable.getValueAt(selectedRow, 0);
        Tag modifiedTag = modifiedCategorizedTag;
        if (modifiedTag.isEmpty()) {
            return;
        }
        Color defaultColor = new Color(modifiedTag.getDefaultColor().getRGB(), true);
        Color initialColor = modifiedTag.getColor();
        Color result = ColorTracker.showCommonJColorChooserDialog((Component)this.tagTable, (String)modifiedTag.getContent(), (Color)initialColor, (Color)defaultColor);
        if (result != null && !initialColor.equals(result)) {
            modifiedTag.setColor(result);
            TagsWrapper tableModel = this.getTableModel();
            IntStream.range(0, this.tagTable.getRowCount() - 1).filter(i -> this.tagTable.getValueAt(i, 0) == modifiedCategorizedTag).forEach(i -> tableModel.fireTableCellUpdated(i, 0));
            this.updateColorButton();
        }
    }

    protected void sortSelectedTags() {
        ListSelectionModel selectionModel = this.tagTable.getSelectionModel();
        if (selectionModel.getMinSelectionIndex() < selectionModel.getMaxSelectionIndex()) {
            this.getTableModel().sortTags(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
        } else {
            this.getTableModel().sortTags(0, this.tagTable.getRowCount() - 2);
        }
    }

    void show() {
        Controller.getCurrentModeController().getController().getMapViewManager().scrollNodeToVisible(this.node);
        if (ResourceController.getResourceController().getBooleanProperty("el__position_window_below_node")) {
            UITools.setDialogLocationUnder((JDialog)this.dialog, (NodeModel)this.node);
        } else {
            UITools.setDialogLocationRelativeTo((JDialog)this.dialog, (NodeModel)this.node);
        }
        this.dialog.setVisible(true);
    }

    private boolean wasAnyValueModified() {
        TagCategories tagCategories = this.getCurrentMapTagCategories();
        if (!this.tagCategorySeparatorField.getText().equals(tagCategories.getTagCategorySeparator())) {
            return true;
        }
        List<Tag> tags = this.getCurrentTags();
        List originalNodeTags = this.iconController.getTags(this.node);
        HashSet filteringSet = new HashSet();
        List newNodeTags = tags.stream().filter(tag -> tag.isEmpty() || filteringSet.add(tag)).collect(Collectors.toList());
        if (originalNodeTags.size() != newNodeTags.size()) {
            return true;
        }
        for (int i = 0; i < newNodeTags.size(); ++i) {
            Tag originalTag = (Tag)originalNodeTags.get(i);
            Tag newTag = (Tag)newNodeTags.get(i);
            if (!originalTag.getContent().equals(newTag.getContent())) {
                return true;
            }
            if (originalTag.getColor().equals(newTag.getColor())) continue;
            return true;
        }
        return false;
    }

    protected void submit() {
        boolean isSeparatorUpdated;
        MapModel map = this.node.getMap();
        TagCategories newTagCategories = this.getCurrentMapTagCategories().copy();
        boolean bl = isSeparatorUpdated = !this.tagCategorySeparatorField.getText().equals(newTagCategories.getTagCategorySeparator());
        if (isSeparatorUpdated) {
            newTagCategories.updateTagCategorySeparator(this.tagCategorySeparatorField.getText());
            this.iconController.setTagCategories(map, newTagCategories);
        } else if (newTagCategories.areCategoriesChanged()) {
            this.iconController.setTagCategories(map, newTagCategories);
        }
        List<Tag> tags = this.getCurrentTags();
        this.iconController.setTags(this.node, tags, true);
    }

    private TagCategories getCurrentMapTagCategories() {
        return this.node.getMap().getIconRegistry().getTagCategories();
    }

    private List<Tag> getCurrentTags() {
        return this.getTableModel().getCurrentTags(this.tagCategories.getTagCategorySeparator(), this.getTagCategorySeparator());
    }

    private JRestrictedSizeScrollPane createScrollPane() {
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(new Dimension(0, 60));
        return scrollPane;
    }

    private Tag createTagIfAbsent(String spec, boolean specContainsColor) {
        return specContainsColor ? this.tagCategories.registerTag(spec) : this.tagCategories.registerTag(new Tag(spec));
    }

    private JTable createTagTable(List<Tag> tags) {
        AutoResizedTable table = new AutoResizedTable(new TagsWrapper(new ArrayList<Tag>(tags))){

            public void setUI(TableUI ui) {
                super.setUI(ui);
                Font tagFont = TagEditor.this.iconController.getTagFont(TagEditor.this.node);
                Font font = tagFont.deriveFont(this.getFont().getSize2D());
                this.setFont(font);
                Rectangle2D rect = font.getStringBounds("*", 0, 1, new FontRenderContext(new AffineTransform(), true, true));
                double textHeight = rect.getHeight();
                this.setRowHeight((int)Math.ceil(textHeight * 1.4));
            }

            public boolean editCellAt(int row, int column, EventObject e) {
                if (super.editCellAt(row, column, e)) {
                    ComboBoxEditor editor;
                    Component textFieldComponent;
                    Component editorComponent = this.getEditorComponent();
                    if (editorComponent instanceof JComboBox && (textFieldComponent = (editor = ((JComboBox)editorComponent).getEditor()).getEditorComponent()) instanceof JTextField) {
                        JTextField textField = (JTextField)textFieldComponent;
                        if (!textField.getText().isEmpty()) {
                            textField.selectAll();
                        }
                        SwingUtilities.invokeLater(textFieldComponent::requestFocusInWindow);
                    }
                    return true;
                }
                return false;
            }

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
            }

            public void editingCanceled(ChangeEvent e) {
                super.editingCanceled(e);
            }
        };
        table.setTransferHandler(new TableCellTransferHandler());
        table.setDragEnabled(true);
        table.setDropMode(DropMode.ON);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer((JTable)table){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            protected void setValue(Object value) {
                if (value == null) {
                    this.setIcon(null);
                } else {
                    Tag tag = (Tag)value;
                    String initialSeparator = TagEditor.this.tagCategories.getTagCategorySeparator();
                    String currentSeparator = TagEditor.this.getTagCategorySeparator();
                    this.setIcon((Icon)new TagIcon(tag.updateSeparator(initialSeparator, currentSeparator), this.val$table.getFont()));
                }
            }
        });
        final JFilterableComboBox comboBox = new JFilterableComboBox(() -> this.tagCategories.getTagsAsListModel().stream(), text -> text.isEmpty(), (item, text) -> item.getContent().toLowerCase().contains(text.toLowerCase()), (item, text) -> item.getContent().toLowerCase().equals(text.toLowerCase()));
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer((JTable)table){
            final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object displayedValue;
                if (index == -1) {
                    return TRANSPARENT_RENDERER;
                }
                if (value instanceof Tag) {
                    Tag tag = (Tag)value;
                    displayedValue = new TagIcon(tag, this.val$table.getFont());
                } else {
                    displayedValue = value;
                }
                return super.getListCellRendererComponent(list, displayedValue, index, isSelected, cellHasFocus);
            }
        };
        comboBox.setRenderer((ListCellRenderer)cellRenderer);
        comboBox.setEditable(true);
        JTextField editorComponent = (JTextField)comboBox.getEditor().getEditorComponent();
        editorComponent.putClientProperty("JTextField.selectAllOnFocusPolicy", "never");
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox)comboBox){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getCellEditorValue() {
                Object value = super.getCellEditorValue();
                if (value instanceof Tag) {
                    return value;
                }
                return TagEditor.this.createTagIfAbsent(value.toString(), false);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String text = value instanceof Tag ? ((Tag)value).getContent() : value.toString();
                return super.getTableCellEditorComponent(table, text, isSelected, row, column);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    return super.isCellEditable(anEvent);
                }
                if (anEvent instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)anEvent;
                    return !keyEvent.isControlDown() && !keyEvent.isMetaDown() && (keyEvent.getKeyChar() != '\uffff' || keyEvent.getKeyCode() == 113);
                }
                return false;
            }

            @Override
            public boolean stopCellEditing() {
                return !comboBox.isFilterRunning() && super.stopCellEditing();
            }
        };
        cellEditor.setClickCountToStart(2);
        table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        AbstractAction moveSelectedLocationsUpAction = new AbstractAction("moveSelectedLocationsUp"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditor.this.moveSelectedLocationsUp();
            }
        };
        AbstractAction moveSelectedLocationsDownAction = new AbstractAction("moveSelectedLocationsDown"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagEditor.this.moveSelectedLocationsDown();
            }
        };
        ActionMap actionMap = table.getActionMap();
        actionMap.put("moveSelectedLocationsUp", moveSelectedLocationsUpAction);
        actionMap.put("moveSelectedLocationsDown", moveSelectedLocationsDownAction);
        InputMap inputMap = table.getInputMap(1);
        ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();
        inputMap.put(acceleratorManager.getAccelerator("NodeUpAction"), "moveSelectedLocationsUp");
        inputMap.put(acceleratorManager.getAccelerator("NodeDownAction"), "moveSelectedLocationsDown");
        return table;
    }

    private void saveDialogSize(JDialog dialog) {
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.setProperty(WIDTH_PROPERTY, dialog.getWidth());
        resourceController.setProperty(HEIGHT_PROPERTY, dialog.getHeight());
    }

    private void confirmedSubmit() {
        if (this.dialog.isVisible()) {
            if (this.wasAnyValueModified()) {
                int action = JOptionPane.showConfirmDialog(this.dialog, TextUtils.getText((String)"long_node_changed_submit"), "", 1);
                if (action == 0) {
                    this.submit();
                } else if (action == 2 || action == -1) {
                    return;
                }
            }
            this.closeDialog();
        }
    }

    private TagsWrapper getTableModel() {
        return (TagsWrapper)this.tagTable.getModel();
    }

    private void updateColorButton(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateColorButton();
        }
    }

    private void selectRowsAfterUpdate(TableModelEvent e) {
        if (e.getType() == 1) {
            EventQueue.invokeLater(() -> this.tagTable.getSelectionModel().setSelectionInterval(e.getFirstRow(), e.getLastRow()));
        } else if (e.getType() == -1) {
            EventQueue.invokeLater(() -> this.tagTable.getSelectionModel().setSelectionInterval(e.getFirstRow(), e.getFirstRow()));
        } else if (e.getType() == 0 && e.getFirstRow() == this.tagTable.getSelectedRow()) {
            if (this.tagTable.getSelectedRow() <= this.tagTable.getRowCount() - 2) {
                this.tagTable.changeSelection(this.tagTable.getSelectedRow() + 1, 0, false, false);
            } else {
                EventQueue.invokeLater(this::updateColorButton);
            }
        }
    }

    private void deleteTags() {
        ListSelectionModel selectionModel = this.tagTable.getSelectionModel();
        int minSelectedRow = selectionModel.getMinSelectionIndex();
        if (minSelectedRow >= 0) {
            this.getTableModel().deleteTags(minSelectedRow, selectionModel.getMaxSelectionIndex());
        }
    }

    private void updateColorButton() {
        int firstIndex = this.tagTable.getSelectedRow();
        if (firstIndex == -1) {
            return;
        }
        Tag tag = (Tag)this.tagTable.getValueAt(firstIndex, 0);
        if (tag.isEmpty()) {
            this.modifyColorAction.setEnabled(false);
            this.colorButton.setColor(Tag.EMPTY_TAG.getColor());
            return;
        }
        this.modifyColorAction.setEnabled(true);
        this.colorButton.setColor(tag.getColor());
    }

    private void moveSelectedLocationsUp() {
        int[] selectedRows = this.tagTable.getSelectedRows();
        TagsWrapper tagTableModel = (TagsWrapper)this.tagTable.getModel();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int selectedIndex = selectedRows[i];
                tagTableModel.moveTag(selectedIndex, selectedIndex - 1);
            }
            SwingUtilities.invokeLater(() -> {
                this.tagTable.getSelectionModel().setValueIsAdjusting(true);
                this.tagTable.clearSelection();
                for (int selectedIndex : selectedRows) {
                    this.tagTable.addRowSelectionInterval(selectedIndex - 1, selectedIndex - 1);
                }
                this.tagTable.getSelectionModel().setValueIsAdjusting(false);
            });
        }
    }

    private void moveSelectedLocationsDown() {
        int[] selectedRows = this.tagTable.getSelectedRows();
        TagsWrapper tagTableModel = (TagsWrapper)this.tagTable.getModel();
        if (selectedRows.length > 0) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int selectedIndex = selectedRows[i];
                tagTableModel.moveTag(selectedIndex, selectedIndex + 1);
            }
            SwingUtilities.invokeLater(() -> {
                this.tagTable.getSelectionModel().setValueIsAdjusting(true);
                this.tagTable.clearSelection();
                for (int selectedIndex : selectedRows) {
                    this.tagTable.addRowSelectionInterval(selectedIndex + 1, selectedIndex + 1);
                }
                this.tagTable.getSelectionModel().setValueIsAdjusting(false);
            });
        }
    }

    private String getTagCategorySeparator() {
        return this.tagCategorySeparatorField.getText();
    }

    private void updateTagCategorySeparator() {
        String newTagCategorySeparator = this.getTagCategorySeparator();
        String currentTagCategorySeparator = this.tagCategories.getTagCategorySeparator();
        if (!currentTagCategorySeparator.equals(newTagCategorySeparator)) {
            if (!newTagCategorySeparator.isEmpty()) {
                this.tagTable.tableChanged(new TableModelEvent(this.getTableModel()));
            } else {
                this.tagCategorySeparatorField.setText(currentTagCategorySeparator);
            }
        }
    }

    static {
        TRANSPARENT_RENDERER.setOpaque(false);
        importId = "";
    }

    private static class TagsWrapper
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final ArrayList<Tag> tags;

        public TagsWrapper(ArrayList<Tag> tags) {
            this.tags = tags;
        }

        List<Tag> getCurrentTags(String initialSeparator, String newSeparator) {
            if (initialSeparator.equals(newSeparator)) {
                return this.tags;
            }
            return this.tags.stream().map(tag -> tag.updateSeparator(initialSeparator, newSeparator)).collect(Collectors.toCollection(ArrayList::new));
        }

        void insertEmptyTags(int first, int last) {
            for (int index = last; index >= first; --index) {
                this.tags.add(first <= this.tags.size() ? first : this.tags.size(), Tag.EMPTY_TAG);
            }
            this.fireTableRowsInserted(first, last);
        }

        void deleteTags(int first, int last) {
            int lastRemoved = last < this.tags.size() ? last : this.tags.size() - 1;
            int firstRemoved = last == this.tags.size() && first > 0 && this.getTag(first).isEmpty() && this.tags.get(first - 1).isEmpty() ? first - 1 : first;
            for (int index = lastRemoved; index >= firstRemoved; --index) {
                this.tags.remove(index);
            }
            this.fireTableRowsDeleted(firstRemoved, last);
        }

        @Override
        public int getRowCount() {
            return this.tags.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getTag(rowIndex);
        }

        Tag getTag(int index) {
            return index < this.tags.size() ? this.tags.get(index) : Tag.EMPTY_TAG;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                Tag tag = (Tag)aValue;
                this.setTag(rowIndex, tag);
            }
        }

        void setTag(int index, Tag tag) {
            int tagCount = this.tags.size();
            if (index < tagCount) {
                this.tags.set(index, tag);
            } else {
                this.tags.add(tag);
                this.fireTableRowsInserted(tagCount + 1, tagCount + 1);
            }
            this.fireTableCellUpdated(index, 0);
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void sortTags(int first, int last) {
            if (first == 0 && last + 1 == this.tags.size()) {
                Collections.sort(this.tags);
            } else {
                Collections.sort(this.tags.subList(first, last + 1));
            }
            this.fireTableRowsUpdated(first, last);
        }

        public void insertTag(int index, Tag tag) {
            if (index < 0) {
                index = this.tags.size();
            }
            this.tags.add(index, tag);
            this.fireTableRowsInserted(index, index);
        }

        public void moveTag(int oldIndex, int newIndex) {
            if (oldIndex != newIndex) {
                if (newIndex >= this.tags.size()) {
                    this.insertTag(this.tags.size(), Tag.EMPTY_TAG);
                }
                Tag tag = oldIndex < this.tags.size() ? this.removeTag(oldIndex) : Tag.EMPTY_TAG;
                if (newIndex <= this.tags.size()) {
                    this.insertTag(newIndex, tag);
                }
            }
        }

        public Tag removeTag(int index) {
            Tag tag = this.tags.remove(index);
            this.fireTableRowsDeleted(index, index);
            return tag;
        }
    }

    static class TagEditorHolder
    extends EditorHolder {
        public TagEditorHolder(NodeModel node, Window window) {
            super(node, window);
        }
    }

    class TableCellTransferHandler
    extends TransferHandler {
        TableCellTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTable table = (JTable)c;
            int[] rows = table.getSelectedRows();
            int col = table.getSelectedColumn();
            StringWriter writer = new StringWriter();
            for (int row : rows) {
                Object cellValue = table.getValueAt(row, col);
                if (cellValue instanceof Tag) {
                    Tag tag = (Tag)cellValue;
                    try {
                        TagCategories.writeTag((Tag)tag, (Writer)writer);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (cellValue != null) {
                    writer.append(cellValue.toString());
                }
                writer.append(System.lineSeparator());
            }
            return new TagSelection(UUID.randomUUID(), writer.toString());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            String data;
            if (!this.canImport(info)) {
                return false;
            }
            Transferable transferable = info.getTransferable();
            try {
                DataFlavor flavor = transferable.isDataFlavorSupported(TagSelection.tagFlavor) ? TagSelection.tagFlavor : DataFlavor.stringFlavor;
                data = (String)transferable.getTransferData(flavor);
                importId = flavor == TagSelection.tagFlavor && transferable.isDataFlavorSupported(TagSelection.uuidFlavor) ? (String)transferable.getTransferData(TagSelection.uuidFlavor) : "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            JTable target = (JTable)info.getComponent();
            if (info.isDrop()) {
                JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                int index = dl.getRow();
                this.insertData(target, data, index);
            } else {
                int index = target.getSelectedRow();
                if (index >= 0) {
                    this.insertData(target, data, index);
                } else {
                    return false;
                }
            }
            return true;
        }

        private void insertData(JTable target, String data, int index) {
            String[] rows;
            TableModel model = target.getModel();
            for (String row : rows = data.split(System.lineSeparator())) {
                ((TagsWrapper)model).insertTag(index++, TagEditor.this.createTagIfAbsent(row, true));
            }
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            if (action != 2 || !data.isDataFlavorSupported(TagSelection.tagFlavor)) {
                return;
            }
            try {
                if (!importId.isEmpty() && data.isDataFlavorSupported(TagSelection.uuidFlavor) && importId.equals(data.getTransferData(TagSelection.uuidFlavor))) {
                    TagEditor.this.deleteTags();
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
    }
}

