/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.Direction;

public class Tab
extends JPanel {
    private TabbedPanel tabbedPanel;
    private JComponent contentComponent;
    private JComponent focusableComponent;
    private ArrayList listeners;
    private DraggableComponent draggableComponent;
    private KeyListener focusableKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (Tab.this.tabbedPanel != null) {
                Tab tab;
                Direction tabOrientation = Tab.this.tabbedPanel.getProperties().getTabAreaOrientation();
                int incKey = tabOrientation.isHorizontal() ? 40 : 39;
                int decKey = tabOrientation.isHorizontal() ? 38 : 37;
                int index = Tab.this.tabbedPanel.getTabIndex(Tab.this);
                do {
                    index = (index + Tab.this.tabbedPanel.getTabCount() + (e.getKeyCode() == incKey ? 1 : (e.getKeyCode() == decKey ? -1 : 0))) % Tab.this.tabbedPanel.getTabCount();
                    tab = Tab.this.tabbedPanel.getTabAt(index);
                    if (tab != Tab.this) continue;
                    return;
                } while (tab.getFocusableComponent() == null);
                tab.setSelected(true);
            }
        }
    };
    private TabListener tabbedPanelListener = new TabListener(){

        @Override
        public void tabAdded(TabEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireAddedEvent();
            }
        }

        @Override
        public void tabRemoved(TabRemovedEvent event) {
            if (event.getTab() == Tab.this) {
                event.getTabbedPanel().removeTabListener(this);
                Tab.this.fireRemovedEvent(event);
            }
        }

        @Override
        public void tabMoved(TabEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireMovedEvent();
            }
        }

        @Override
        public void tabDragged(TabDragEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireDraggedEvent(event);
            }
        }

        @Override
        public void tabDropped(TabDragEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireDroppedEvent(event);
            }
        }

        @Override
        public void tabDragAborted(TabEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireNotDroppedEvent();
            }
        }

        @Override
        public void tabSelected(TabStateChangedEvent event) {
            if (event.getTab() == Tab.this) {
                boolean hasFocus;
                Tab tab = event.getPreviousTab();
                boolean bl = hasFocus = tab != null && tab.getFocusableComponent() != null && tab.getFocusableComponent().hasFocus();
                if (tab != null && tab.getFocusableComponent() != null) {
                    tab.getFocusableComponent().setFocusable(false);
                }
                if (Tab.this.focusableComponent != null) {
                    Tab.this.focusableComponent.setFocusable(true);
                    if (hasFocus) {
                        Tab.this.focusableComponent.requestFocusInWindow();
                    }
                }
                Tab.this.fireSelectedEvent(event);
            }
        }

        @Override
        public void tabDeselected(TabStateChangedEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireDeselectedEvent(event);
            }
        }

        @Override
        public void tabHighlighted(TabStateChangedEvent event) {
            if (event.getTab() == Tab.this) {
                Tab.this.fireHighlightedEvent(event);
            }
        }

        @Override
        public void tabDehighlighted(TabStateChangedEvent event) {
            if (event.getPreviousTab() == Tab.this) {
                Tab.this.fireDehighlightedEvent(event);
            }
        }
    };

    public Tab() {
        this((JComponent)null);
    }

    public Tab(JComponent contentComponent) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.contentComponent = contentComponent;
        this.draggableComponent = new DraggableComponent(this);
    }

    public void addTabListener(TabListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public void removeTabListener(TabListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getDraggableComponent().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.draggableComponent.select();
        } else if (this.tabbedPanel != null && this.tabbedPanel.getSelectedTab() == this) {
            this.tabbedPanel.setSelectedTab(null);
        }
    }

    public boolean isSelected() {
        return this.tabbedPanel != null ? this.tabbedPanel.getSelectedTab() == this : false;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.tabbedPanel != null) {
            if (highlighted) {
                this.tabbedPanel.setHighlightedTab(this);
            } else if (this.tabbedPanel.getHighlightedTab() == this) {
                this.tabbedPanel.setHighlightedTab(null);
            }
        }
    }

    public boolean isHighlighted() {
        return this.tabbedPanel != null ? this.tabbedPanel.getHighlightedTab() == this : false;
    }

    public void setEventComponent(JComponent eventComponent) {
        this.setEventComponents(new JComponent[]{eventComponent});
    }

    public void setEventComponents(JComponent[] eventComponents) {
        this.draggableComponent.setEventComponents(eventComponents);
    }

    public JComponent[] getEventComponents() {
        return this.draggableComponent.getEventComponents();
    }

    public int getIndex() {
        return this.tabbedPanel == null ? -1 : this.tabbedPanel.getTabIndex(this);
    }

    public JComponent getFocusableComponent() {
        return this.focusableComponent;
    }

    public void setFocusableComponent(JComponent focusableComponent) {
        if (this.focusableComponent != focusableComponent) {
            boolean hasFocus = false;
            if (this.focusableComponent != null) {
                this.focusableComponent.removeKeyListener(this.focusableKeyListener);
                hasFocus = this.focusableComponent.hasFocus();
            }
            this.focusableComponent = focusableComponent;
            if (this.focusableComponent != null) {
                this.focusableComponent.setFocusable(this.isSelected());
                this.focusableComponent.addKeyListener(this.focusableKeyListener);
                if (hasFocus) {
                    this.focusableComponent.requestFocusInWindow();
                }
            }
        }
    }

    public Shape getShape() {
        return null;
    }

    protected void setTabbedPanel(TabbedPanel tabbedPanel) {
        this.tabbedPanel = tabbedPanel;
        if (this.tabbedPanel != null) {
            this.tabbedPanel.addTabListener(this.tabbedPanelListener);
        }
    }

    DraggableComponent getDraggableComponent() {
        return this.draggableComponent;
    }

    private void fireHighlightedEvent(TabStateChangedEvent event) {
        if (this.listeners != null) {
            TabStateChangedEvent e = new TabStateChangedEvent(this, event.getTabbedPanel(), this, event.getPreviousTab(), event.getCurrentTab());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabHighlighted(e);
                ++i;
            }
        }
    }

    private void fireDehighlightedEvent(TabStateChangedEvent event) {
        if (this.listeners != null) {
            TabStateChangedEvent e = new TabStateChangedEvent(this, event.getTabbedPanel(), this, event.getPreviousTab(), event.getCurrentTab());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDehighlighted(e);
                ++i;
            }
        }
    }

    private void fireSelectedEvent(TabStateChangedEvent event) {
        if (this.listeners != null) {
            TabStateChangedEvent e = new TabStateChangedEvent(this, event.getTabbedPanel(), this, event.getPreviousTab(), event.getCurrentTab());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabSelected(e);
                ++i;
            }
        }
    }

    private void fireDeselectedEvent(TabStateChangedEvent event) {
        if (this.listeners != null) {
            TabStateChangedEvent e = new TabStateChangedEvent(this, event.getTabbedPanel(), this, event.getPreviousTab(), event.getCurrentTab());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDeselected(e);
                ++i;
            }
        }
    }

    private void fireDraggedEvent(TabDragEvent event) {
        if (this.listeners != null) {
            TabDragEvent e = new TabDragEvent((Object)this, event.getMouseEvent());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDragged(e);
                ++i;
            }
        }
    }

    private void fireDroppedEvent(TabDragEvent event) {
        if (this.listeners != null) {
            TabDragEvent e = new TabDragEvent(this, this, event.getPoint());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDropped(e);
                ++i;
            }
        }
    }

    private void fireNotDroppedEvent() {
        if (this.listeners != null) {
            TabEvent e = new TabEvent(this, this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDragAborted(e);
                ++i;
            }
        }
    }

    private void fireMovedEvent() {
        if (this.listeners != null) {
            TabEvent e = new TabEvent(this, this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabMoved(e);
                ++i;
            }
        }
    }

    private void fireAddedEvent() {
        if (this.listeners != null) {
            TabEvent e = new TabEvent(this, this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabAdded(e);
                ++i;
            }
        }
    }

    private void fireRemovedEvent(TabRemovedEvent event) {
        if (this.listeners != null) {
            TabRemovedEvent e = new TabRemovedEvent(this, this, event.getTabbedPanel());
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabRemoved(e);
                ++i;
            }
        }
    }

    @Override
    public void addNotify() {
        if (!this.draggableComponent.isIgnoreAddNotify()) {
            super.addNotify();
        }
    }

    @Override
    public void removeNotify() {
        if (!this.draggableComponent.isIgnoreAddNotify()) {
            super.removeNotify();
        }
    }
}

