# CoReLG, chapter 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("corelg02.tst");

# doc/manual.xml:436-457
gap> RealFormsInformation( "A", 4 );

  There are 4 simple real forms with complexification A4
    1 is of type su(5), compact form
    2 - 3 are of type su(p,5-p) with 1 <= p <= 2
    4 is of type sl(5,R)
  Index '0' returns the realification of A4

gap> RealFormsInformation( "E", 6 );
 
  There are 5 simple real forms with complexification E6
    1 is the compact form
    2 is EI   = E6(6), with k_0 of type sp(4) (C4)
    3 is EII  = E6(2), with k_0 of type su(6)+su(2) (A5+A1)
    4 is EIII = E6(-14), with k_0 of type so(10)+R (D5+R)
    5 is EIV  = E6(-26), with k_0 of type f_4 (F4)
  Index '0' returns the realification of E6

gap> NumberRealForms("D",10);
12

# doc/manual.xml:490-497
gap> RealFormById( "A", 4, 2 );
<Lie algebra of dimension 24 over SqrtField>
gap> RealFormById( "A", 4, 2, CF(4) );
<Lie algebra of dimension 24 over GaussianRationals>
gap> RealFormById( [ ["A", 4, 2], ["D", 5, 2] ], SqrtField);
<Lie algebra of dimension 69 over SqrtField>

# doc/manual.xml:509-516
gap> L := RealFormById( [ ["A", 4, 2], ["D", 5, 2] ], SqrtField);;
gap> IdRealForm( L );
[ [ "A", 4, 2 ], [ "D", 5, 2 ] ]
gap> K := RealFormById("A",5,2);;
gap> IdRealForm( K );
[ "A", 5, 2 ]

# doc/manual.xml:532-536
gap> L := RealFormById( [ ["A", 4, 2], ["D", 5, 2] ], SqrtField);;
gap> NameRealForm( L );
"su(1,4)+so(2,8)"

# doc/manual.xml:637-650
gap> L:= RealFormById( "A", 5, 3 );
<Lie algebra of dimension 35 over SqrtField>
gap> H := CartanSubalgebra(L);;
gap> K:= LieCentralizer( L, Subalgebra( L, [Basis( H )[1]] ) );
<Lie algebra of dimension 17 over SqrtField>
gap> DK:= LieDerivedSubalgebra( K );
<Lie algebra of dimension 15 over SqrtField>
gap> CartanDecomposition( DK );
rec( CartanInv := function( v ) ... end, 
  K := <Lie algebra of dimension 15 over SqrtField>, 
  P := <vector space of dimension 0 over SqrtField> )
gap> # We see that the semisimple subalgebra DK is compact. 

# doc/manual.xml:680-690
gap> r:= MaximalReductiveSubalgebras("F",4,3);;
gap> NameRealForm( r.liealg );
"F4(-20)"
gap> for K in r.subalgs do Print( NameRealForm(K), "\n" ); od;
su(1,2)+su(3)
su(2)+sp(1,2)
so(8,1)
so(9)
sl(2,R)+G2c

# doc/manual.xml:707-719
gap> L:=RealFormById("E",6,3);;                            
gap> H:=CartanSubalgebra(L);;
gap> K:=LieCentralizer(L,Subalgebra(L,Basis(H){[1,2,4]}));;
gap> DK:=LieDerivedSubalgebra(K);
<Lie algebra of dimension 8 over SqrtField>
gap> IdRealForm(DK);          
[ "A", 2, 2 ]
gap> M:=RealFormById("A",2,2);
<Lie algebra of dimension 8 over SqrtField>
gap> IsomorphismOfRealSemisimpleLieAlgebras(DK,M);
<Lie algebra isomorphism between Lie algebras of dimension 8 over SqrtField>

# doc/manual.xml:815-829
gap> L:= RealFormById( [["E", 6, 3],["A", 3, 2]] );;
gap>  K:= LieCentralizer( L, Subalgebra( L, Basis( CartanSubalgebra(L) ){[1]} ) );
<Lie algebra of dimension 51 over SqrtField>
gap>  DK:= LieDerivedSubalgebra( K );
<Lie algebra of dimension 50 over SqrtField>
gap> vd:= VoganDiagram(DK);
<Vogan diagram in Lie algebra of type A3+A5>
gap>  Display( vd );
A3:  (1)---2---3
A5:  4---(5)---6---7---8
Involution: ()
Types of direct summands:
[ [ "A", 3, 2 ], [ "A", 5, 3 ] ]

# doc/manual.xml:838-850
gap> L:= RealFormById( [["E", 6, 3],["A", 3, 2]] );;
gap> K:= LieCentralizer( L, Subalgebra( L, Basis( CartanSubalgebra(L) ){[1]} ) );
<Lie algebra of dimension 51 over SqrtField>
gap>  DK:= LieDerivedSubalgebra( K );
<Lie algebra of dimension 50 over SqrtField>
gap> sd:= SatakeDiagram( DK );
<Satake diagram in Lie algebra of type A5xA3>
gap> Display( sd );
A5:  1---2---(3)---4---5
A3:  6---(7)---8
Involution:  (1,5)(2,4)(6,8)

#
gap> STOP_TEST("corelg02.tst", 1);
