#############################################################################
##
#W  database.g                GAP4 Package `RCWA'                 Stefan Kohl
##
##  Data library of the groups generated by 4 class transpositions which
##  interchange residue classes with moduli <= 6.
##
#############################################################################

return rec(

cts := List(ClassPairs(6),c->SparseRep(ClassTransposition(c))),

grps4_3finitepos :=
[[1,7,9,13],[1,7,9,15],[1,7,9,16],[1,7,9,19],
 [1,7,9,20],[1,7,9,21],[1,7,9,22],[1,7,9,23],
 [1,7,9,24],[1,7,9,25],[1,7,9,26],[1,7,9,27],
 [1,7,9,34],[1,7,9,39],[1,7,9,41],[1,7,9,43],
 [1,7,9,44],[1,7,9,45],[1,7,9,46],[1,7,9,47],
 [1,7,9,48],[1,7,9,49],[1,7,9,55],[1,7,9,58],
 [1,7,9,59],[1,7,9,60],[1,7,9,61],[1,7,9,62],
 [1,7,9,66],[1,7,9,67],[1,7,9,68],[1,7,9,69],
 [1,7,13,15],[1,7,13,16],[1,7,13,19],[1,7,13,20],
 [1,7,13,21],[1,7,13,22],[1,7,13,23],[1,7,13,24],
 [1,7,13,25],[1,7,13,26],[1,7,13,27],[1,7,13,34],
 [1,7,13,39],[1,7,13,41],[1,7,13,43],[1,7,13,44],
 [1,7,13,45],[1,7,13,46],[1,7,13,47],[1,7,13,48],
 [1,7,13,49],[1,7,13,50],[1,7,13,51],[1,7,13,55],
 [1,7,13,58],[1,7,13,59],[1,7,13,60],[1,7,13,61],
 [1,7,13,62],[1,7,13,66],[1,7,13,67],[1,7,13,68],
 [1,7,13,69],[1,7,15,16],[1,7,15,19],[1,7,15,20],
 [1,7,15,21],[1,7,15,22],[1,7,15,23],[1,7,15,24],
 [1,7,15,25],[1,7,15,26],[1,7,15,27],[1,7,15,34],
 [1,7,15,39],[1,7,15,41],[1,7,15,43],[1,7,15,44],
 [1,7,15,45],[1,7,15,46],[1,7,15,47],[1,7,15,48],
 [1,7,15,49],[1,7,15,55],[1,7,15,58],[1,7,15,59],
 [1,7,15,60],[1,7,15,61],[1,7,15,62],[1,7,15,66],
 [1,7,15,67],[1,7,15,68],[1,7,15,69],[1,7,16,19],
 [1,7,16,20],[1,7,16,21],[1,7,16,22],[1,7,16,23],
 [1,7,16,24],[1,7,16,25],[1,7,16,26],[1,7,16,27],
 [1,7,16,34],[1,7,16,39],[1,7,16,41],[1,7,16,43],
 [1,7,16,44],[1,7,16,45],[1,7,16,46],[1,7,16,47],
 [1,7,16,48],[1,7,16,49],[1,7,16,55],[1,7,16,58],
 [1,7,16,59],[1,7,16,60],[1,7,16,61],[1,7,16,62],
 [1,7,16,66],[1,7,16,67],[1,7,16,68],[1,7,16,69],
 [1,7,19,20],[1,7,19,21],[1,7,19,22],[1,7,19,23],
 [1,7,19,24],[1,7,19,25],[1,7,19,26],[1,7,19,27],
 [1,7,19,34],[1,7,19,39],[1,7,19,41],[1,7,19,43],
 [1,7,19,44],[1,7,19,45],[1,7,19,46],[1,7,19,47],
 [1,7,19,48],[1,7,19,49],[1,7,19,55],[1,7,19,58],
 [1,7,19,59],[1,7,19,60],[1,7,19,61],[1,7,19,62],
 [1,7,19,66],[1,7,19,67],[1,7,19,68],[1,7,19,69],
 [1,7,20,21],[1,7,20,22],[1,7,20,23],[1,7,20,24],
 [1,7,20,25],[1,7,20,26],[1,7,20,27],[1,7,20,34],
 [1,7,20,39],[1,7,20,41],[1,7,20,43],[1,7,20,44],
 [1,7,20,45],[1,7,20,46],[1,7,20,47],[1,7,20,48],
 [1,7,20,49],[1,7,20,55],[1,7,20,58],[1,7,20,59],
 [1,7,20,60],[1,7,20,61],[1,7,20,62],[1,7,20,66],
 [1,7,20,67],[1,7,20,68],[1,7,20,69],[1,7,21,22],
 [1,7,21,23],[1,7,21,24],[1,7,21,25],[1,7,21,26],
 [1,7,21,27],[1,7,21,34],[1,7,21,39],[1,7,21,41],
 [1,7,21,43],[1,7,21,44],[1,7,21,45],[1,7,21,46],
 [1,7,21,47],[1,7,21,48],[1,7,21,49],[1,7,21,55],
 [1,7,21,58],[1,7,21,59],[1,7,21,60],[1,7,21,61],
 [1,7,21,62],[1,7,21,66],[1,7,21,67],[1,7,21,68],
 [1,7,21,69],[1,7,22,23],[1,7,22,24],[1,7,22,25],
 [1,7,22,26],[1,7,22,27],[1,7,22,34],[1,7,22,39],
 [1,7,22,41],[1,7,22,43],[1,7,22,44],[1,7,22,45],
 [1,7,22,46],[1,7,22,47],[1,7,22,48],[1,7,22,49],
 [1,7,22,55],[1,7,22,58],[1,7,22,59],[1,7,22,60],
 [1,7,22,61],[1,7,22,62],[1,7,22,66],[1,7,22,67],
 [1,7,22,68],[1,7,22,69],[1,7,23,24],[1,7,23,25],
 [1,7,23,26],[1,7,23,27],[1,7,23,34],[1,7,23,39],
 [1,7,23,41],[1,7,23,43],[1,7,23,44],[1,7,23,45],
 [1,7,23,46],[1,7,23,47],[1,7,23,48],[1,7,23,49],
 [1,7,23,50],[1,7,23,51],[1,7,23,55],[1,7,23,58],
 [1,7,23,59],[1,7,23,60],[1,7,23,61],[1,7,23,62],
 [1,7,23,66],[1,7,23,67],[1,7,23,68],[1,7,23,69],
 [1,7,24,25],[1,7,24,26],[1,7,24,27],[1,7,24,34],
 [1,7,24,39],[1,7,24,41],[1,7,24,43],[1,7,24,44],
 [1,7,24,45],[1,7,24,46],[1,7,24,47],[1,7,24,48],
 [1,7,24,49],[1,7,24,55],[1,7,24,58],[1,7,24,59],
 [1,7,24,60],[1,7,24,61],[1,7,24,62],[1,7,24,66],
 [1,7,24,67],[1,7,24,68],[1,7,24,69],[1,7,25,26],
 [1,7,25,27],[1,7,25,34],[1,7,25,39],[1,7,25,41],
 [1,7,25,43],[1,7,25,44],[1,7,25,45],[1,7,25,46],
 [1,7,25,47],[1,7,25,48],[1,7,25,49],[1,7,25,55],
 [1,7,25,58],[1,7,25,59],[1,7,25,60],[1,7,25,61],
 [1,7,25,62],[1,7,25,66],[1,7,25,67],[1,7,25,68],
 [1,7,25,69],[1,7,26,27],[1,7,26,34],[1,7,26,39],
 [1,7,26,41],[1,7,26,43],[1,7,26,44],[1,7,26,45],
 [1,7,26,46],[1,7,26,47],[1,7,26,48],[1,7,26,49],
 [1,7,26,55],[1,7,26,58],[1,7,26,59],[1,7,26,60],
 [1,7,26,61],[1,7,26,62],[1,7,26,66],[1,7,26,67],
 [1,7,26,68],[1,7,26,69],[1,7,27,34],[1,7,27,39],
 [1,7,27,41],[1,7,27,43],[1,7,27,44],[1,7,27,45],
 [1,7,27,46],[1,7,27,47],[1,7,27,48],[1,7,27,49],
 [1,7,27,55],[1,7,27,58],[1,7,27,59],[1,7,27,60],
 [1,7,27,61],[1,7,27,62],[1,7,27,66],[1,7,27,67],
 [1,7,27,68],[1,7,27,69],[1,7,34,39],[1,7,34,41],
 [1,7,34,43],[1,7,34,44],[1,7,34,45],[1,7,34,46],
 [1,7,34,47],[1,7,34,48],[1,7,34,49],[1,7,34,55],
 [1,7,34,58],[1,7,34,59],[1,7,34,60],[1,7,34,61],
 [1,7,34,62],[1,7,34,66],[1,7,34,67],[1,7,34,68],
 [1,7,34,69],[1,7,39,41],[1,7,39,43],[1,7,39,44],
 [1,7,39,45],[1,7,39,46],[1,7,39,47],[1,7,39,48],
 [1,7,39,49],[1,7,39,55],[1,7,39,58],[1,7,39,59],
 [1,7,39,60],[1,7,39,61],[1,7,39,62],[1,7,39,66],
 [1,7,39,67],[1,7,39,68],[1,7,39,69],[1,7,41,43],
 [1,7,41,44],[1,7,41,45],[1,7,41,46],[1,7,41,47],
 [1,7,41,48],[1,7,41,49],[1,7,41,55],[1,7,41,58],
 [1,7,41,59],[1,7,41,60],[1,7,41,61],[1,7,41,62],
 [1,7,41,66],[1,7,41,67],[1,7,41,68],[1,7,41,69],
 [1,7,43,44],[1,7,43,45],[1,7,43,46],[1,7,43,47],
 [1,7,43,48],[1,7,43,49],[1,7,43,55],[1,7,43,58],
 [1,7,43,59],[1,7,43,60],[1,7,43,61],[1,7,43,62],
 [1,7,43,66],[1,7,43,67],[1,7,43,68],[1,7,43,69],
 [1,7,44,45],[1,7,44,46],[1,7,44,47],[1,7,44,48],
 [1,7,44,49],[1,7,44,55],[1,7,44,58],[1,7,44,59],
 [1,7,44,60],[1,7,44,61],[1,7,44,62],[1,7,44,66],
 [1,7,44,67],[1,7,44,68],[1,7,44,69],[1,7,45,46],
 [1,7,45,47],[1,7,45,48],[1,7,45,49],[1,7,45,50],
 [1,7,45,51],[1,7,45,55],[1,7,45,58],[1,7,45,59],
 [1,7,45,60],[1,7,45,61],[1,7,45,62],[1,7,45,66],
 [1,7,45,67],[1,7,45,68],[1,7,45,69],[1,7,46,47],
 [1,7,46,48],[1,7,46,49],[1,7,46,55],[1,7,46,58],
 [1,7,46,59],[1,7,46,60],[1,7,46,61],[1,7,46,62],
 [1,7,46,66],[1,7,46,67],[1,7,46,68],[1,7,46,69],
 [1,7,47,48],[1,7,47,49],[1,7,47,55],[1,7,47,58],
 [1,7,47,59],[1,7,47,60],[1,7,47,61],[1,7,47,62],
 [1,7,47,66],[1,7,47,67],[1,7,47,68],[1,7,47,69],
 [1,7,48,49],[1,7,48,55],[1,7,48,58],[1,7,48,59],
 [1,7,48,60],[1,7,48,61],[1,7,48,62],[1,7,48,66],
 [1,7,48,67],[1,7,48,68],[1,7,48,69],[1,7,49,55],
 [1,7,49,58],[1,7,49,59],[1,7,49,60],[1,7,49,61],
 [1,7,49,62],[1,7,49,66],[1,7,49,67],[1,7,49,68],
 [1,7,49,69],[1,7,50,51],[1,7,50,55],[1,7,50,58],
 [1,7,50,60],[1,7,50,61],[1,7,50,62],[1,7,50,67],
 [1,7,50,68],[1,7,50,69],[1,7,51,55],[1,7,51,58],
 [1,7,51,60],[1,7,51,61],[1,7,51,62],[1,7,51,67],
 [1,7,51,68],[1,7,51,69],[1,7,55,58],[1,7,55,59],
 [1,7,55,60],[1,7,55,61],[1,7,55,62],[1,7,55,66],
 [1,7,55,67],[1,7,55,68],[1,7,55,69],[1,7,58,59],
 [1,7,58,60],[1,7,58,61],[1,7,58,62],[1,7,58,66],
 [1,7,58,67],[1,7,58,68],[1,7,58,69],[1,7,59,60],
 [1,7,59,61],[1,7,59,62],[1,7,59,66],[1,7,59,67],
 [1,7,59,68],[1,7,59,69],[1,7,60,61],[1,7,60,62],
 [1,7,60,66],[1,7,60,67],[1,7,60,68],[1,7,60,69],
 [1,7,61,62],[1,7,61,66],[1,7,61,67],[1,7,61,68],
 [1,7,61,69],[1,7,62,66],[1,7,62,67],[1,7,62,68],
 [1,7,62,69],[1,7,66,67],[1,7,66,68],[1,7,66,69],
 [1,7,67,68],[1,7,67,69],[1,7,68,69],[1,9,13,15],
 [1,9,13,16],[1,9,13,19],[1,9,13,20],[1,9,13,21],
 [1,9,13,22],[1,9,13,23],[1,9,13,24],[1,9,13,25],
 [1,9,13,26],[1,9,13,27],[1,9,13,34],[1,9,13,39],
 [1,9,13,41],[1,9,13,43],[1,9,13,44],[1,9,13,45],
 [1,9,13,46],[1,9,13,47],[1,9,13,48],[1,9,13,49],
 [1,9,13,55],[1,9,13,58],[1,9,13,59],[1,9,13,60],
 [1,9,13,61],[1,9,13,62],[1,9,13,66],[1,9,13,67],
 [1,9,13,68],[1,9,13,69],[1,9,15,16],[1,9,15,19],
 [1,9,15,20],[1,9,15,21],[1,9,15,22],[1,9,15,23],
 [1,9,15,24],[1,9,15,25],[1,9,15,26],[1,9,15,27],
 [1,9,15,34],[1,9,15,39],[1,9,15,41],[1,9,15,43],
 [1,9,15,44],[1,9,15,45],[1,9,15,46],[1,9,15,47],
 [1,9,15,48],[1,9,15,49],[1,9,15,55],[1,9,15,58],
 [1,9,15,59],[1,9,15,60],[1,9,15,61],[1,9,15,62],
 [1,9,15,66],[1,9,15,67],[1,9,15,68],[1,9,15,69],
 [1,9,16,19],[1,9,16,20],[1,9,16,21],[1,9,16,22],
 [1,9,16,23],[1,9,16,24],[1,9,16,25],[1,9,16,26],
 [1,9,16,27],[1,9,16,34],[1,9,16,39],[1,9,16,41],
 [1,9,16,43],[1,9,16,44],[1,9,16,45],[1,9,16,46],
 [1,9,16,47],[1,9,16,48],[1,9,16,49],[1,9,16,55],
 [1,9,16,58],[1,9,16,59],[1,9,16,60],[1,9,16,61],
 [1,9,16,62],[1,9,16,66],[1,9,16,67],[1,9,16,68],
 [1,9,16,69],[1,9,19,20],[1,9,19,21],[1,9,19,22],
 [1,9,19,23],[1,9,19,24],[1,9,19,25],[1,9,19,26],
 [1,9,19,27],[1,9,19,34],[1,9,19,39],[1,9,19,41],
 [1,9,19,43],[1,9,19,44],[1,9,19,45],[1,9,19,46],
 [1,9,19,47],[1,9,19,48],[1,9,19,49],[1,9,19,55],
 [1,9,19,58],[1,9,19,59],[1,9,19,60],[1,9,19,61],
 [1,9,19,62],[1,9,19,66],[1,9,19,67],[1,9,19,68],
 [1,9,19,69],[1,9,20,21],[1,9,20,22],[1,9,20,23],
 [1,9,20,24],[1,9,20,25],[1,9,20,26],[1,9,20,27],
 [1,9,20,34],[1,9,20,39],[1,9,20,41],[1,9,20,43],
 [1,9,20,44],[1,9,20,45],[1,9,20,46],[1,9,20,47],
 [1,9,20,48],[1,9,20,49],[1,9,20,55],[1,9,20,58],
 [1,9,20,59],[1,9,20,60],[1,9,20,61],[1,9,20,62],
 [1,9,20,66],[1,9,20,67],[1,9,20,68],[1,9,20,69],
 [1,9,21,22],[1,9,21,23],[1,9,21,24],[1,9,21,25],
 [1,9,21,26],[1,9,21,27],[1,9,21,34],[1,9,21,39],
 [1,9,21,41],[1,9,21,43],[1,9,21,44],[1,9,21,45],
 [1,9,21,46],[1,9,21,47],[1,9,21,48],[1,9,21,49],
 [1,9,21,55],[1,9,21,58],[1,9,21,59],[1,9,21,60],
 [1,9,21,61],[1,9,21,62],[1,9,21,66],[1,9,21,67],
 [1,9,21,68],[1,9,21,69],[1,9,22,23],[1,9,22,24],
 [1,9,22,25],[1,9,22,26],[1,9,22,27],[1,9,22,34],
 [1,9,22,39],[1,9,22,41],[1,9,22,43],[1,9,22,44],
 [1,9,22,45],[1,9,22,46],[1,9,22,47],[1,9,22,48],
 [1,9,22,49],[1,9,22,55],[1,9,22,58],[1,9,22,59],
 [1,9,22,60],[1,9,22,61],[1,9,22,62],[1,9,22,66],
 [1,9,22,67],[1,9,22,68],[1,9,22,69],[1,9,23,24],
 [1,9,23,25],[1,9,23,26],[1,9,23,27],[1,9,23,34],
 [1,9,23,39],[1,9,23,41],[1,9,23,43],[1,9,23,44],
 [1,9,23,45],[1,9,23,46],[1,9,23,47],[1,9,23,48],
 [1,9,23,49],[1,9,23,55],[1,9,23,58],[1,9,23,59],
 [1,9,23,60],[1,9,23,61],[1,9,23,62],[1,9,23,66],
 [1,9,23,67],[1,9,23,68],[1,9,23,69],[1,9,24,25],
 [1,9,24,26],[1,9,24,27],[1,9,24,34],[1,9,24,39],
 [1,9,24,41],[1,9,24,43],[1,9,24,44],[1,9,24,45],
 [1,9,24,46],[1,9,24,47],[1,9,24,48],[1,9,24,49],
 [1,9,24,55],[1,9,24,58],[1,9,24,59],[1,9,24,60],
 [1,9,24,61],[1,9,24,62],[1,9,24,66],[1,9,24,67],
 [1,9,24,68],[1,9,24,69],[1,9,25,26],[1,9,25,27],
 [1,9,25,34],[1,9,25,39],[1,9,25,41],[1,9,25,43],
 [1,9,25,44],[1,9,25,45],[1,9,25,46],[1,9,25,47],
 [1,9,25,48],[1,9,25,49],[1,9,25,55],[1,9,25,58],
 [1,9,25,59],[1,9,25,60],[1,9,25,61],[1,9,25,62],
 [1,9,25,66],[1,9,25,67],[1,9,25,68],[1,9,25,69],
 [1,9,26,27],[1,9,26,34],[1,9,26,39],[1,9,26,41],
 [1,9,26,43],[1,9,26,44],[1,9,26,45],[1,9,26,46],
 [1,9,26,47],[1,9,26,48],[1,9,26,49],[1,9,26,55],
 [1,9,26,58],[1,9,26,59],[1,9,26,60],[1,9,26,61],
 [1,9,26,62],[1,9,26,66],[1,9,26,67],[1,9,26,68],
 [1,9,26,69],[1,9,27,34],[1,9,27,39],[1,9,27,41],
 [1,9,27,43],[1,9,27,44],[1,9,27,45],[1,9,27,46],
 [1,9,27,47],[1,9,27,48],[1,9,27,49],[1,9,27,55],
 [1,9,27,58],[1,9,27,59],[1,9,27,60],[1,9,27,61],
 [1,9,27,62],[1,9,27,66],[1,9,27,67],[1,9,27,68],
 [1,9,27,69],[1,9,34,39],[1,9,34,41],[1,9,34,43],
 [1,9,34,44],[1,9,34,45],[1,9,34,46],[1,9,34,47],
 [1,9,34,48],[1,9,34,49],[1,9,34,55],[1,9,34,58],
 [1,9,34,59],[1,9,34,60],[1,9,34,61],[1,9,34,62],
 [1,9,34,66],[1,9,34,67],[1,9,34,68],[1,9,34,69],
 [1,9,39,41],[1,9,39,43],[1,9,39,44],[1,9,39,45],
 [1,9,39,46],[1,9,39,47],[1,9,39,48],[1,9,39,49],
 [1,9,39,55],[1,9,39,58],[1,9,39,59],[1,9,39,60],
 [1,9,39,61],[1,9,39,62],[1,9,39,66],[1,9,39,67],
 [1,9,39,68],[1,9,39,69],[1,9,41,43],[1,9,41,44],
 [1,9,41,45],[1,9,41,46],[1,9,41,47],[1,9,41,48],
 [1,9,41,49],[1,9,41,55],[1,9,41,58],[1,9,41,59],
 [1,9,41,60],[1,9,41,61],[1,9,41,62],[1,9,41,66],
 [1,9,41,67],[1,9,41,68],[1,9,41,69],[1,9,43,44],
 [1,9,43,45],[1,9,43,46],[1,9,43,47],[1,9,43,48],
 [1,9,43,49],[1,9,43,55],[1,9,43,58],[1,9,43,59],
 [1,9,43,60],[1,9,43,61],[1,9,43,62],[1,9,43,66],
 [1,9,43,67],[1,9,43,68],[1,9,43,69],[1,9,44,45],
 [1,9,44,46],[1,9,44,47],[1,9,44,48],[1,9,44,49],
 [1,9,44,55],[1,9,44,58],[1,9,44,59],[1,9,44,60],
 [1,9,44,61],[1,9,44,62],[1,9,44,66],[1,9,44,67],
 [1,9,44,68],[1,9,44,69],[1,9,45,46],[1,9,45,47],
 [1,9,45,48],[1,9,45,49],[1,9,45,55],[1,9,45,58],
 [1,9,45,59],[1,9,45,60],[1,9,45,61],[1,9,45,62],
 [1,9,45,66],[1,9,45,67],[1,9,45,68],[1,9,45,69],
 [1,9,46,47],[1,9,46,48],[1,9,46,49],[1,9,46,55],
 [1,9,46,58],[1,9,46,59],[1,9,46,60],[1,9,46,61],
 [1,9,46,62],[1,9,46,66],[1,9,46,67],[1,9,46,68],
 [1,9,46,69],[1,9,47,48],[1,9,47,49],[1,9,47,55],
 [1,9,47,58],[1,9,47,59],[1,9,47,60],[1,9,47,61],
 [1,9,47,62],[1,9,47,66],[1,9,47,67],[1,9,47,68],
 [1,9,47,69],[1,9,48,49],[1,9,48,55],[1,9,48,58],
 [1,9,48,59],[1,9,48,60],[1,9,48,61],[1,9,48,62],
 [1,9,48,66],[1,9,48,67],[1,9,48,68],[1,9,48,69],
 [1,9,49,55],[1,9,49,58],[1,9,49,59],[1,9,49,60],
 [1,9,49,61],[1,9,49,62],[1,9,49,66],[1,9,49,67],
 [1,9,49,68],[1,9,49,69],[1,9,55,58],[1,9,55,59],
 [1,9,55,60],[1,9,55,61],[1,9,55,62],[1,9,55,66],
 [1,9,55,67],[1,9,55,68],[1,9,55,69],[1,9,58,59],
 [1,9,58,60],[1,9,58,61],[1,9,58,62],[1,9,58,66],
 [1,9,58,67],[1,9,58,68],[1,9,58,69],[1,9,59,60],
 [1,9,59,61],[1,9,59,62],[1,9,59,66],[1,9,59,67],
 [1,9,59,68],[1,9,59,69],[1,9,60,61],[1,9,60,62],
 [1,9,60,66],[1,9,60,67],[1,9,60,68],[1,9,60,69],
 [1,9,61,62],[1,9,61,66],[1,9,61,67],[1,9,61,68],
 [1,9,61,69],[1,9,62,66],[1,9,62,67],[1,9,62,68],
 [1,9,62,69],[1,9,66,67],[1,9,66,68],[1,9,66,69],
 [1,9,67,68],[1,9,67,69],[1,9,68,69],[1,11,12,13],
 [1,11,12,21],[1,11,12,23],[1,11,12,24],[1,11,12,25],
 [1,11,12,34],[1,11,12,43],[1,11,12,46],[1,11,12,47],
 [1,11,12,55],[1,11,12,60],[1,11,12,69],[1,11,13,21],
 [1,11,13,23],[1,11,13,24],[1,11,13,25],[1,11,13,34],
 [1,11,13,43],[1,11,13,46],[1,11,13,47],[1,11,13,55],
 [1,11,13,60],[1,11,13,69],[1,11,21,23],[1,11,21,24],
 [1,11,21,25],[1,11,21,34],[1,11,21,43],[1,11,21,46],
 [1,11,21,55],[1,11,21,60],[1,11,21,69],[1,11,23,24],
 [1,11,23,25],[1,11,23,34],[1,11,23,43],[1,11,23,46],
 [1,11,23,47],[1,11,23,55],[1,11,23,60],[1,11,23,69],
 [1,11,24,25],[1,11,24,34],[1,11,24,43],[1,11,24,46],
 [1,11,24,47],[1,11,24,55],[1,11,24,60],[1,11,24,69],
 [1,11,25,34],[1,11,25,43],[1,11,25,46],[1,11,25,47],
 [1,11,25,55],[1,11,25,60],[1,11,25,69],[1,11,34,43],
 [1,11,34,46],[1,11,34,47],[1,11,34,55],[1,11,34,60],
 [1,11,34,69],[1,11,43,46],[1,11,43,47],[1,11,43,55],
 [1,11,43,60],[1,11,43,69],[1,11,46,47],[1,11,46,55],
 [1,11,46,60],[1,11,46,69],[1,11,47,55],[1,11,47,60],
 [1,11,47,69],[1,11,55,60],[1,11,55,69],[1,11,60,69],
 [1,12,13,21],[1,12,13,23],[1,12,13,24],[1,12,13,25],
 [1,12,13,34],[1,12,13,43],[1,12,13,46],[1,12,13,47],
 [1,12,13,55],[1,12,13,60],[1,12,13,69],[1,12,21,23],
 [1,12,21,24],[1,12,21,25],[1,12,21,34],[1,12,21,43],
 [1,12,21,46],[1,12,21,47],[1,12,21,55],[1,12,21,60],
 [1,12,21,69],[1,12,23,24],[1,12,23,25],[1,12,23,34],
 [1,12,23,43],[1,12,23,46],[1,12,23,47],[1,12,23,55],
 [1,12,23,60],[1,12,23,69],[1,12,24,25],[1,12,24,34],
 [1,12,24,43],[1,12,24,46],[1,12,24,47],[1,12,24,55],
 [1,12,24,60],[1,12,24,69],[1,12,25,34],[1,12,25,43],
 [1,12,25,46],[1,12,25,47],[1,12,25,55],[1,12,25,60],
 [1,12,25,69],[1,12,34,43],[1,12,34,46],[1,12,34,47],
 [1,12,34,55],[1,12,34,60],[1,12,34,69],[1,12,43,46],
 [1,12,43,47],[1,12,43,55],[1,12,43,60],[1,12,43,69],
 [1,12,46,47],[1,12,46,55],[1,12,46,60],[1,12,46,69],
 [1,12,47,55],[1,12,47,60],[1,12,47,69],[1,12,55,60],
 [1,12,55,69],[1,12,60,69],[1,13,15,16],[1,13,15,19],
 [1,13,15,20],[1,13,15,21],[1,13,15,22],[1,13,15,23],
 [1,13,15,24],[1,13,15,25],[1,13,15,26],[1,13,15,27],
 [1,13,15,34],[1,13,15,39],[1,13,15,41],[1,13,15,43],
 [1,13,15,44],[1,13,15,45],[1,13,15,46],[1,13,15,47],
 [1,13,15,48],[1,13,15,49],[1,13,15,55],[1,13,15,58],
 [1,13,15,59],[1,13,15,60],[1,13,15,61],[1,13,15,62],
 [1,13,15,66],[1,13,15,67],[1,13,15,68],[1,13,15,69],
 [1,13,16,19],[1,13,16,20],[1,13,16,21],[1,13,16,22],
 [1,13,16,23],[1,13,16,24],[1,13,16,25],[1,13,16,26],
 [1,13,16,27],[1,13,16,34],[1,13,16,39],[1,13,16,41],
 [1,13,16,43],[1,13,16,44],[1,13,16,45],[1,13,16,46],
 [1,13,16,47],[1,13,16,48],[1,13,16,49],[1,13,16,55],
 [1,13,16,58],[1,13,16,59],[1,13,16,60],[1,13,16,61],
 [1,13,16,62],[1,13,16,66],[1,13,16,67],[1,13,16,68],
 [1,13,16,69],[1,13,19,20],[1,13,19,21],[1,13,19,22],
 [1,13,19,23],[1,13,19,24],[1,13,19,25],[1,13,19,26],
 [1,13,19,27],[1,13,19,34],[1,13,19,35],[1,13,19,36],
 [1,13,19,39],[1,13,19,41],[1,13,19,43],[1,13,19,44],
 [1,13,19,45],[1,13,19,46],[1,13,19,47],[1,13,19,48],
 [1,13,19,49],[1,13,19,55],[1,13,19,58],[1,13,19,59],
 [1,13,19,60],[1,13,19,61],[1,13,19,62],[1,13,19,66],
 [1,13,19,67],[1,13,19,68],[1,13,19,69],[1,13,20,21],
 [1,13,20,22],[1,13,20,23],[1,13,20,24],[1,13,20,25],
 [1,13,20,26],[1,13,20,27],[1,13,20,34],[1,13,20,39],
 [1,13,20,41],[1,13,20,43],[1,13,20,44],[1,13,20,45],
 [1,13,20,46],[1,13,20,47],[1,13,20,48],[1,13,20,49],
 [1,13,20,55],[1,13,20,58],[1,13,20,59],[1,13,20,60],
 [1,13,20,61],[1,13,20,62],[1,13,20,66],[1,13,20,67],
 [1,13,20,68],[1,13,20,69],[1,13,21,22],[1,13,21,23],
 [1,13,21,24],[1,13,21,25],[1,13,21,26],[1,13,21,27],
 [1,13,21,34],[1,13,21,39],[1,13,21,41],[1,13,21,43],
 [1,13,21,44],[1,13,21,45],[1,13,21,46],[1,13,21,47],
 [1,13,21,48],[1,13,21,49],[1,13,21,55],[1,13,21,58],
 [1,13,21,59],[1,13,21,60],[1,13,21,61],[1,13,21,62],
 [1,13,21,66],[1,13,21,67],[1,13,21,68],[1,13,21,69],
 [1,13,22,23],[1,13,22,24],[1,13,22,25],[1,13,22,26],
 [1,13,22,27],[1,13,22,34],[1,13,22,39],[1,13,22,41],
 [1,13,22,43],[1,13,22,44],[1,13,22,45],[1,13,22,46],
 [1,13,22,47],[1,13,22,48],[1,13,22,49],[1,13,22,55],
 [1,13,22,58],[1,13,22,59],[1,13,22,60],[1,13,22,61],
 [1,13,22,62],[1,13,22,66],[1,13,22,67],[1,13,22,68],
 [1,13,22,69],[1,13,23,24],[1,13,23,25],[1,13,23,26],
 [1,13,23,27],[1,13,23,34],[1,13,23,35],[1,13,23,36],
 [1,13,23,39],[1,13,23,41],[1,13,23,43],[1,13,23,44],
 [1,13,23,45],[1,13,23,46],[1,13,23,47],[1,13,23,48],
 [1,13,23,49],[1,13,23,50],[1,13,23,51],[1,13,23,55],
 [1,13,23,58],[1,13,23,59],[1,13,23,60],[1,13,23,61],
 [1,13,23,62],[1,13,23,66],[1,13,23,67],[1,13,23,68],
 [1,13,23,69],[1,13,24,25],[1,13,24,26],[1,13,24,27],
 [1,13,24,34],[1,13,24,39],[1,13,24,41],[1,13,24,43],
 [1,13,24,44],[1,13,24,45],[1,13,24,46],[1,13,24,47],
 [1,13,24,48],[1,13,24,49],[1,13,24,55],[1,13,24,58],
 [1,13,24,59],[1,13,24,60],[1,13,24,61],[1,13,24,62],
 [1,13,24,66],[1,13,24,67],[1,13,24,68],[1,13,24,69],
 [1,13,25,26],[1,13,25,27],[1,13,25,34],[1,13,25,39],
 [1,13,25,41],[1,13,25,43],[1,13,25,44],[1,13,25,45],
 [1,13,25,46],[1,13,25,47],[1,13,25,48],[1,13,25,49],
 [1,13,25,55],[1,13,25,58],[1,13,25,59],[1,13,25,60],
 [1,13,25,61],[1,13,25,62],[1,13,25,66],[1,13,25,67],
 [1,13,25,68],[1,13,25,69],[1,13,26,27],[1,13,26,34],
 [1,13,26,35],[1,13,26,36],[1,13,26,39],[1,13,26,41],
 [1,13,26,43],[1,13,26,44],[1,13,26,45],[1,13,26,46],
 [1,13,26,47],[1,13,26,48],[1,13,26,49],[1,13,26,55],
 [1,13,26,58],[1,13,26,59],[1,13,26,60],[1,13,26,61],
 [1,13,26,62],[1,13,26,66],[1,13,26,67],[1,13,26,68],
 [1,13,26,69],[1,13,27,34],[1,13,27,35],[1,13,27,36],
 [1,13,27,39],[1,13,27,41],[1,13,27,43],[1,13,27,44],
 [1,13,27,45],[1,13,27,46],[1,13,27,47],[1,13,27,48],
 [1,13,27,49],[1,13,27,55],[1,13,27,58],[1,13,27,59],
 [1,13,27,60],[1,13,27,61],[1,13,27,62],[1,13,27,66],
 [1,13,27,67],[1,13,27,68],[1,13,27,69],[1,13,34,39],
 [1,13,34,41],[1,13,34,43],[1,13,34,44],[1,13,34,45],
 [1,13,34,46],[1,13,34,47],[1,13,34,48],[1,13,34,49],
 [1,13,34,55],[1,13,34,58],[1,13,34,59],[1,13,34,60],
 [1,13,34,61],[1,13,34,62],[1,13,34,66],[1,13,34,67],
 [1,13,34,68],[1,13,34,69],[1,13,35,36],[1,13,35,48],
 [1,13,35,49],[1,13,35,55],[1,13,35,60],[1,13,35,66],
 [1,13,35,69],[1,13,36,48],[1,13,36,49],[1,13,36,55],
 [1,13,36,60],[1,13,36,66],[1,13,36,69],[1,13,39,41],
 [1,13,39,43],[1,13,39,44],[1,13,39,45],[1,13,39,46],
 [1,13,39,47],[1,13,39,48],[1,13,39,49],[1,13,39,55],
 [1,13,39,58],[1,13,39,59],[1,13,39,60],[1,13,39,61],
 [1,13,39,62],[1,13,39,66],[1,13,39,67],[1,13,39,68],
 [1,13,39,69],[1,13,41,43],[1,13,41,44],[1,13,41,45],
 [1,13,41,46],[1,13,41,47],[1,13,41,48],[1,13,41,49],
 [1,13,41,55],[1,13,41,58],[1,13,41,59],[1,13,41,60],
 [1,13,41,61],[1,13,41,62],[1,13,41,66],[1,13,41,67],
 [1,13,41,68],[1,13,41,69],[1,13,43,44],[1,13,43,45],
 [1,13,43,46],[1,13,43,47],[1,13,43,48],[1,13,43,49],
 [1,13,43,55],[1,13,43,58],[1,13,43,59],[1,13,43,60],
 [1,13,43,61],[1,13,43,62],[1,13,43,66],[1,13,43,67],
 [1,13,43,68],[1,13,43,69],[1,13,44,45],[1,13,44,46],
 [1,13,44,47],[1,13,44,48],[1,13,44,49],[1,13,44,55],
 [1,13,44,58],[1,13,44,59],[1,13,44,60],[1,13,44,61],
 [1,13,44,62],[1,13,44,66],[1,13,44,67],[1,13,44,68],
 [1,13,44,69],[1,13,45,46],[1,13,45,47],[1,13,45,48],
 [1,13,45,49],[1,13,45,50],[1,13,45,51],[1,13,45,55],
 [1,13,45,58],[1,13,45,59],[1,13,45,60],[1,13,45,61],
 [1,13,45,62],[1,13,45,66],[1,13,45,67],[1,13,45,68],
 [1,13,45,69],[1,13,46,47],[1,13,46,48],[1,13,46,49],
 [1,13,46,55],[1,13,46,58],[1,13,46,59],[1,13,46,60],
 [1,13,46,61],[1,13,46,62],[1,13,46,66],[1,13,46,67],
 [1,13,46,68],[1,13,46,69],[1,13,47,48],[1,13,47,49],
 [1,13,47,55],[1,13,47,58],[1,13,47,59],[1,13,47,60],
 [1,13,47,61],[1,13,47,62],[1,13,47,66],[1,13,47,67],
 [1,13,47,68],[1,13,47,69],[1,13,48,49],[1,13,48,55],
 [1,13,48,58],[1,13,48,59],[1,13,48,60],[1,13,48,61],
 [1,13,48,62],[1,13,48,66],[1,13,48,67],[1,13,48,68],
 [1,13,48,69],[1,13,49,55],[1,13,49,58],[1,13,49,59],
 [1,13,49,60],[1,13,49,61],[1,13,49,62],[1,13,49,66],
 [1,13,49,67],[1,13,49,68],[1,13,49,69],[1,13,50,51],
 [1,13,50,55],[1,13,50,58],[1,13,50,60],[1,13,50,61],
 [1,13,50,62],[1,13,50,67],[1,13,50,68],[1,13,50,69],
 [1,13,51,55],[1,13,51,58],[1,13,51,60],[1,13,51,61],
 [1,13,51,62],[1,13,51,67],[1,13,51,68],[1,13,51,69],
 [1,13,55,58],[1,13,55,59],[1,13,55,60],[1,13,55,61],
 [1,13,55,62],[1,13,55,66],[1,13,55,67],[1,13,55,68],
 [1,13,55,69],[1,13,58,59],[1,13,58,60],[1,13,58,61],
 [1,13,58,62],[1,13,58,66],[1,13,58,67],[1,13,58,68],
 [1,13,58,69],[1,13,59,60],[1,13,59,61],[1,13,59,62],
 [1,13,59,66],[1,13,59,67],[1,13,59,68],[1,13,59,69],
 [1,13,60,61],[1,13,60,62],[1,13,60,66],[1,13,60,67],
 [1,13,60,68],[1,13,60,69],[1,13,61,62],[1,13,61,66],
 [1,13,61,67],[1,13,61,68],[1,13,61,69],[1,13,62,66],
 [1,13,62,67],[1,13,62,68],[1,13,62,69],[1,13,66,67],
 [1,13,66,68],[1,13,66,69],[1,13,67,68],[1,13,67,69],
 [1,13,68,69],[1,15,16,19],[1,15,16,20],[1,15,16,21],
 [1,15,16,22],[1,15,16,23],[1,15,16,24],[1,15,16,25],
 [1,15,16,26],[1,15,16,27],[1,15,16,34],[1,15,16,39],
 [1,15,16,41],[1,15,16,43],[1,15,16,44],[1,15,16,45],
 [1,15,16,46],[1,15,16,47],[1,15,16,48],[1,15,16,49],
 [1,15,16,55],[1,15,16,58],[1,15,16,59],[1,15,16,60],
 [1,15,16,61],[1,15,16,62],[1,15,16,66],[1,15,16,67],
 [1,15,16,68],[1,15,16,69],[1,15,19,20],[1,15,19,21],
 [1,15,19,22],[1,15,19,23],[1,15,19,24],[1,15,19,25],
 [1,15,19,26],[1,15,19,27],[1,15,19,34],[1,15,19,39],
 [1,15,19,41],[1,15,19,43],[1,15,19,44],[1,15,19,45],
 [1,15,19,46],[1,15,19,47],[1,15,19,48],[1,15,19,49],
 [1,15,19,55],[1,15,19,58],[1,15,19,59],[1,15,19,60],
 [1,15,19,61],[1,15,19,62],[1,15,19,66],[1,15,19,67],
 [1,15,19,68],[1,15,19,69],[1,15,20,21],[1,15,20,22],
 [1,15,20,23],[1,15,20,24],[1,15,20,25],[1,15,20,26],
 [1,15,20,27],[1,15,20,34],[1,15,20,39],[1,15,20,41],
 [1,15,20,43],[1,15,20,44],[1,15,20,45],[1,15,20,46],
 [1,15,20,47],[1,15,20,48],[1,15,20,49],[1,15,20,55],
 [1,15,20,58],[1,15,20,59],[1,15,20,60],[1,15,20,61],
 [1,15,20,62],[1,15,20,66],[1,15,20,67],[1,15,20,68],
 [1,15,20,69],[1,15,21,22],[1,15,21,23],[1,15,21,24],
 [1,15,21,25],[1,15,21,26],[1,15,21,27],[1,15,21,34],
 [1,15,21,39],[1,15,21,41],[1,15,21,43],[1,15,21,44],
 [1,15,21,45],[1,15,21,46],[1,15,21,47],[1,15,21,48],
 [1,15,21,49],[1,15,21,55],[1,15,21,58],[1,15,21,59],
 [1,15,21,60],[1,15,21,61],[1,15,21,62],[1,15,21,66],
 [1,15,21,67],[1,15,21,68],[1,15,21,69],[1,15,22,23],
 [1,15,22,24],[1,15,22,25],[1,15,22,26],[1,15,22,27],
 [1,15,22,34],[1,15,22,39],[1,15,22,41],[1,15,22,43],
 [1,15,22,44],[1,15,22,45],[1,15,22,46],[1,15,22,47],
 [1,15,22,48],[1,15,22,49],[1,15,22,55],[1,15,22,58],
 [1,15,22,59],[1,15,22,60],[1,15,22,61],[1,15,22,62],
 [1,15,22,66],[1,15,22,67],[1,15,22,68],[1,15,22,69],
 [1,15,23,24],[1,15,23,25],[1,15,23,26],[1,15,23,27],
 [1,15,23,34],[1,15,23,39],[1,15,23,41],[1,15,23,43],
 [1,15,23,44],[1,15,23,45],[1,15,23,46],[1,15,23,47],
 [1,15,23,48],[1,15,23,49],[1,15,23,55],[1,15,23,58],
 [1,15,23,59],[1,15,23,60],[1,15,23,61],[1,15,23,62],
 [1,15,23,66],[1,15,23,67],[1,15,23,68],[1,15,23,69],
 [1,15,24,25],[1,15,24,26],[1,15,24,27],[1,15,24,34],
 [1,15,24,39],[1,15,24,41],[1,15,24,43],[1,15,24,44],
 [1,15,24,45],[1,15,24,46],[1,15,24,47],[1,15,24,48],
 [1,15,24,49],[1,15,24,55],[1,15,24,58],[1,15,24,59],
 [1,15,24,60],[1,15,24,61],[1,15,24,62],[1,15,24,66],
 [1,15,24,67],[1,15,24,68],[1,15,24,69],[1,15,25,26],
 [1,15,25,27],[1,15,25,34],[1,15,25,39],[1,15,25,41],
 [1,15,25,43],[1,15,25,44],[1,15,25,45],[1,15,25,46],
 [1,15,25,47],[1,15,25,48],[1,15,25,49],[1,15,25,55],
 [1,15,25,58],[1,15,25,59],[1,15,25,60],[1,15,25,61],
 [1,15,25,62],[1,15,25,66],[1,15,25,67],[1,15,25,68],
 [1,15,25,69],[1,15,26,27],[1,15,26,34],[1,15,26,39],
 [1,15,26,41],[1,15,26,43],[1,15,26,44],[1,15,26,45],
 [1,15,26,46],[1,15,26,47],[1,15,26,48],[1,15,26,49],
 [1,15,26,55],[1,15,26,58],[1,15,26,59],[1,15,26,60],
 [1,15,26,61],[1,15,26,62],[1,15,26,66],[1,15,26,67],
 [1,15,26,68],[1,15,26,69],[1,15,27,34],[1,15,27,39],
 [1,15,27,41],[1,15,27,43],[1,15,27,44],[1,15,27,45],
 [1,15,27,46],[1,15,27,47],[1,15,27,48],[1,15,27,49],
 [1,15,27,55],[1,15,27,58],[1,15,27,59],[1,15,27,60],
 [1,15,27,61],[1,15,27,62],[1,15,27,66],[1,15,27,67],
 [1,15,27,68],[1,15,27,69],[1,15,34,39],[1,15,34,41],
 [1,15,34,43],[1,15,34,44],[1,15,34,45],[1,15,34,46],
 [1,15,34,47],[1,15,34,48],[1,15,34,49],[1,15,34,55],
 [1,15,34,58],[1,15,34,59],[1,15,34,60],[1,15,34,61],
 [1,15,34,62],[1,15,34,66],[1,15,34,67],[1,15,34,68],
 [1,15,34,69],[1,15,39,41],[1,15,39,43],[1,15,39,44],
 [1,15,39,45],[1,15,39,46],[1,15,39,47],[1,15,39,48],
 [1,15,39,49],[1,15,39,55],[1,15,39,58],[1,15,39,59],
 [1,15,39,60],[1,15,39,61],[1,15,39,62],[1,15,39,66],
 [1,15,39,67],[1,15,39,68],[1,15,39,69],[1,15,41,43],
 [1,15,41,44],[1,15,41,45],[1,15,41,46],[1,15,41,47],
 [1,15,41,48],[1,15,41,49],[1,15,41,55],[1,15,41,58],
 [1,15,41,59],[1,15,41,60],[1,15,41,61],[1,15,41,62],
 [1,15,41,66],[1,15,41,67],[1,15,41,68],[1,15,41,69],
 [1,15,43,44],[1,15,43,45],[1,15,43,46],[1,15,43,47],
 [1,15,43,48],[1,15,43,49],[1,15,43,55],[1,15,43,58],
 [1,15,43,59],[1,15,43,60],[1,15,43,61],[1,15,43,62],
 [1,15,43,66],[1,15,43,67],[1,15,43,68],[1,15,43,69],
 [1,15,44,45],[1,15,44,46],[1,15,44,47],[1,15,44,48],
 [1,15,44,49],[1,15,44,55],[1,15,44,58],[1,15,44,59],
 [1,15,44,60],[1,15,44,61],[1,15,44,62],[1,15,44,66],
 [1,15,44,67],[1,15,44,68],[1,15,44,69],[1,15,45,46],
 [1,15,45,47],[1,15,45,48],[1,15,45,49],[1,15,45,55],
 [1,15,45,58],[1,15,45,59],[1,15,45,60],[1,15,45,61],
 [1,15,45,62],[1,15,45,66],[1,15,45,67],[1,15,45,68],
 [1,15,45,69],[1,15,46,47],[1,15,46,48],[1,15,46,49],
 [1,15,46,55],[1,15,46,58],[1,15,46,59],[1,15,46,60],
 [1,15,46,61],[1,15,46,62],[1,15,46,66],[1,15,46,67],
 [1,15,46,68],[1,15,46,69],[1,15,47,48],[1,15,47,49],
 [1,15,47,55],[1,15,47,58],[1,15,47,59],[1,15,47,60],
 [1,15,47,61],[1,15,47,62],[1,15,47,66],[1,15,47,67],
 [1,15,47,68],[1,15,47,69],[1,15,48,49],[1,15,48,55],
 [1,15,48,58],[1,15,48,59],[1,15,48,60],[1,15,48,61],
 [1,15,48,62],[1,15,48,66],[1,15,48,67],[1,15,48,68],
 [1,15,48,69],[1,15,49,55],[1,15,49,58],[1,15,49,59],
 [1,15,49,60],[1,15,49,61],[1,15,49,62],[1,15,49,66],
 [1,15,49,67],[1,15,49,68],[1,15,49,69],[1,15,55,58],
 [1,15,55,59],[1,15,55,60],[1,15,55,61],[1,15,55,62],
 [1,15,55,66],[1,15,55,67],[1,15,55,68],[1,15,55,69],
 [1,15,58,59],[1,15,58,60],[1,15,58,61],[1,15,58,62],
 [1,15,58,66],[1,15,58,67],[1,15,58,68],[1,15,58,69],
 [1,15,59,60],[1,15,59,61],[1,15,59,62],[1,15,59,66],
 [1,15,59,67],[1,15,59,68],[1,15,59,69],[1,15,60,61],
 [1,15,60,62],[1,15,60,66],[1,15,60,67],[1,15,60,68],
 [1,15,60,69],[1,15,61,62],[1,15,61,66],[1,15,61,67],
 [1,15,61,68],[1,15,61,69],[1,15,62,66],[1,15,62,67],
 [1,15,62,68],[1,15,62,69],[1,15,66,67],[1,15,66,68],
 [1,15,66,69],[1,15,67,68],[1,15,67,69],[1,15,68,69],
 [1,16,19,20],[1,16,19,21],[1,16,19,22],[1,16,19,23],
 [1,16,19,24],[1,16,19,25],[1,16,19,26],[1,16,19,27],
 [1,16,19,34],[1,16,19,39],[1,16,19,41],[1,16,19,43],
 [1,16,19,44],[1,16,19,45],[1,16,19,46],[1,16,19,47],
 [1,16,19,48],[1,16,19,49],[1,16,19,55],[1,16,19,58],
 [1,16,19,59],[1,16,19,60],[1,16,19,61],[1,16,19,62],
 [1,16,19,66],[1,16,19,67],[1,16,19,68],[1,16,19,69],
 [1,16,20,21],[1,16,20,22],[1,16,20,23],[1,16,20,24],
 [1,16,20,25],[1,16,20,26],[1,16,20,27],[1,16,20,34],
 [1,16,20,39],[1,16,20,41],[1,16,20,43],[1,16,20,44],
 [1,16,20,45],[1,16,20,46],[1,16,20,47],[1,16,20,48],
 [1,16,20,49],[1,16,20,55],[1,16,20,58],[1,16,20,59],
 [1,16,20,60],[1,16,20,61],[1,16,20,62],[1,16,20,66],
 [1,16,20,67],[1,16,20,68],[1,16,20,69],[1,16,21,22],
 [1,16,21,23],[1,16,21,24],[1,16,21,25],[1,16,21,26],
 [1,16,21,27],[1,16,21,34],[1,16,21,39],[1,16,21,41],
 [1,16,21,43],[1,16,21,44],[1,16,21,45],[1,16,21,46],
 [1,16,21,47],[1,16,21,48],[1,16,21,49],[1,16,21,55],
 [1,16,21,58],[1,16,21,59],[1,16,21,60],[1,16,21,61],
 [1,16,21,62],[1,16,21,66],[1,16,21,67],[1,16,21,68],
 [1,16,21,69],[1,16,22,23],[1,16,22,24],[1,16,22,25],
 [1,16,22,26],[1,16,22,27],[1,16,22,34],[1,16,22,39],
 [1,16,22,41],[1,16,22,43],[1,16,22,44],[1,16,22,45],
 [1,16,22,46],[1,16,22,47],[1,16,22,48],[1,16,22,49],
 [1,16,22,55],[1,16,22,58],[1,16,22,59],[1,16,22,60],
 [1,16,22,61],[1,16,22,62],[1,16,22,66],[1,16,22,67],
 [1,16,22,68],[1,16,22,69],[1,16,23,24],[1,16,23,25],
 [1,16,23,26],[1,16,23,27],[1,16,23,34],[1,16,23,39],
 [1,16,23,41],[1,16,23,43],[1,16,23,44],[1,16,23,45],
 [1,16,23,46],[1,16,23,47],[1,16,23,48],[1,16,23,49],
 [1,16,23,55],[1,16,23,58],[1,16,23,59],[1,16,23,60],
 [1,16,23,61],[1,16,23,62],[1,16,23,66],[1,16,23,67],
 [1,16,23,68],[1,16,23,69],[1,16,24,25],[1,16,24,26],
 [1,16,24,27],[1,16,24,34],[1,16,24,39],[1,16,24,41],
 [1,16,24,43],[1,16,24,44],[1,16,24,45],[1,16,24,46],
 [1,16,24,47],[1,16,24,48],[1,16,24,49],[1,16,24,55],
 [1,16,24,58],[1,16,24,59],[1,16,24,60],[1,16,24,61],
 [1,16,24,62],[1,16,24,66],[1,16,24,67],[1,16,24,68],
 [1,16,24,69],[1,16,25,26],[1,16,25,27],[1,16,25,34],
 [1,16,25,39],[1,16,25,41],[1,16,25,43],[1,16,25,44],
 [1,16,25,45],[1,16,25,46],[1,16,25,47],[1,16,25,48],
 [1,16,25,49],[1,16,25,55],[1,16,25,58],[1,16,25,59],
 [1,16,25,60],[1,16,25,61],[1,16,25,62],[1,16,25,66],
 [1,16,25,67],[1,16,25,68],[1,16,25,69],[1,16,26,27],
 [1,16,26,34],[1,16,26,39],[1,16,26,41],[1,16,26,43],
 [1,16,26,44],[1,16,26,45],[1,16,26,46],[1,16,26,47],
 [1,16,26,48],[1,16,26,49],[1,16,26,55],[1,16,26,58],
 [1,16,26,59],[1,16,26,60],[1,16,26,61],[1,16,26,62],
 [1,16,26,66],[1,16,26,67],[1,16,26,68],[1,16,26,69],
 [1,16,27,34],[1,16,27,39],[1,16,27,41],[1,16,27,43],
 [1,16,27,44],[1,16,27,45],[1,16,27,46],[1,16,27,47],
 [1,16,27,48],[1,16,27,49],[1,16,27,55],[1,16,27,58],
 [1,16,27,59],[1,16,27,60],[1,16,27,61],[1,16,27,62],
 [1,16,27,66],[1,16,27,67],[1,16,27,68],[1,16,27,69],
 [1,16,34,39],[1,16,34,41],[1,16,34,43],[1,16,34,44],
 [1,16,34,45],[1,16,34,46],[1,16,34,47],[1,16,34,48],
 [1,16,34,49],[1,16,34,55],[1,16,34,58],[1,16,34,59],
 [1,16,34,60],[1,16,34,61],[1,16,34,62],[1,16,34,66],
 [1,16,34,67],[1,16,34,68],[1,16,34,69],[1,16,39,41],
 [1,16,39,43],[1,16,39,44],[1,16,39,45],[1,16,39,46],
 [1,16,39,47],[1,16,39,48],[1,16,39,49],[1,16,39,55],
 [1,16,39,58],[1,16,39,59],[1,16,39,60],[1,16,39,61],
 [1,16,39,62],[1,16,39,66],[1,16,39,67],[1,16,39,68],
 [1,16,39,69],[1,16,41,43],[1,16,41,44],[1,16,41,45],
 [1,16,41,46],[1,16,41,47],[1,16,41,48],[1,16,41,49],
 [1,16,41,55],[1,16,41,58],[1,16,41,59],[1,16,41,60],
 [1,16,41,61],[1,16,41,62],[1,16,41,66],[1,16,41,67],
 [1,16,41,68],[1,16,41,69],[1,16,43,44],[1,16,43,45],
 [1,16,43,46],[1,16,43,47],[1,16,43,48],[1,16,43,49],
 [1,16,43,55],[1,16,43,58],[1,16,43,59],[1,16,43,60],
 [1,16,43,61],[1,16,43,62],[1,16,43,66],[1,16,43,67],
 [1,16,43,68],[1,16,43,69],[1,16,44,45],[1,16,44,46],
 [1,16,44,47],[1,16,44,48],[1,16,44,49],[1,16,44,55],
 [1,16,44,58],[1,16,44,59],[1,16,44,60],[1,16,44,61],
 [1,16,44,62],[1,16,44,66],[1,16,44,67],[1,16,44,68],
 [1,16,44,69],[1,16,45,46],[1,16,45,47],[1,16,45,48],
 [1,16,45,49],[1,16,45,55],[1,16,45,58],[1,16,45,59],
 [1,16,45,60],[1,16,45,61],[1,16,45,62],[1,16,45,66],
 [1,16,45,67],[1,16,45,68],[1,16,45,69],[1,16,46,47],
 [1,16,46,48],[1,16,46,49],[1,16,46,55],[1,16,46,58],
 [1,16,46,59],[1,16,46,60],[1,16,46,61],[1,16,46,62],
 [1,16,46,66],[1,16,46,67],[1,16,46,68],[1,16,46,69],
 [1,16,47,48],[1,16,47,49],[1,16,47,55],[1,16,47,58],
 [1,16,47,59],[1,16,47,60],[1,16,47,61],[1,16,47,62],
 [1,16,47,66],[1,16,47,67],[1,16,47,68],[1,16,47,69],
 [1,16,48,49],[1,16,48,55],[1,16,48,58],[1,16,48,59],
 [1,16,48,60],[1,16,48,61],[1,16,48,62],[1,16,48,66],
 [1,16,48,67],[1,16,48,68],[1,16,48,69],[1,16,49,55],
 [1,16,49,58],[1,16,49,59],[1,16,49,60],[1,16,49,61],
 [1,16,49,62],[1,16,49,66],[1,16,49,67],[1,16,49,68],
 [1,16,49,69],[1,16,55,58],[1,16,55,59],[1,16,55,60],
 [1,16,55,61],[1,16,55,62],[1,16,55,66],[1,16,55,67],
 [1,16,55,68],[1,16,55,69],[1,16,58,59],[1,16,58,60],
 [1,16,58,61],[1,16,58,62],[1,16,58,66],[1,16,58,67],
 [1,16,58,68],[1,16,58,69],[1,16,59,60],[1,16,59,61],
 [1,16,59,62],[1,16,59,66],[1,16,59,67],[1,16,59,68],
 [1,16,59,69],[1,16,60,61],[1,16,60,62],[1,16,60,66],
 [1,16,60,67],[1,16,60,68],[1,16,60,69],[1,16,61,62],
 [1,16,61,66],[1,16,61,67],[1,16,61,68],[1,16,61,69],
 [1,16,62,66],[1,16,62,67],[1,16,62,68],[1,16,62,69],
 [1,16,66,67],[1,16,66,68],[1,16,66,69],[1,16,67,68],
 [1,16,67,69],[1,16,68,69],[1,19,20,21],[1,19,20,22],
 [1,19,20,23],[1,19,20,24],[1,19,20,25],[1,19,20,26],
 [1,19,20,27],[1,19,20,34],[1,19,20,39],[1,19,20,41],
 [1,19,20,43],[1,19,20,44],[1,19,20,45],[1,19,20,46],
 [1,19,20,47],[1,19,20,48],[1,19,20,49],[1,19,20,55],
 [1,19,20,58],[1,19,20,59],[1,19,20,60],[1,19,20,61],
 [1,19,20,62],[1,19,20,66],[1,19,20,67],[1,19,20,68],
 [1,19,20,69],[1,19,21,22],[1,19,21,23],[1,19,21,24],
 [1,19,21,25],[1,19,21,26],[1,19,21,27],[1,19,21,34],
 [1,19,21,39],[1,19,21,41],[1,19,21,43],[1,19,21,44],
 [1,19,21,45],[1,19,21,46],[1,19,21,47],[1,19,21,48],
 [1,19,21,49],[1,19,21,55],[1,19,21,58],[1,19,21,59],
 [1,19,21,60],[1,19,21,61],[1,19,21,62],[1,19,21,66],
 [1,19,21,67],[1,19,21,68],[1,19,21,69],[1,19,22,23],
 [1,19,22,24],[1,19,22,25],[1,19,22,26],[1,19,22,27],
 [1,19,22,34],[1,19,22,39],[1,19,22,41],[1,19,22,43],
 [1,19,22,44],[1,19,22,45],[1,19,22,46],[1,19,22,47],
 [1,19,22,48],[1,19,22,49],[1,19,22,55],[1,19,22,58],
 [1,19,22,59],[1,19,22,60],[1,19,22,61],[1,19,22,62],
 [1,19,22,66],[1,19,22,67],[1,19,22,68],[1,19,22,69],
 [1,19,23,24],[1,19,23,25],[1,19,23,26],[1,19,23,27],
 [1,19,23,34],[1,19,23,35],[1,19,23,36],[1,19,23,39],
 [1,19,23,41],[1,19,23,43],[1,19,23,44],[1,19,23,45],
 [1,19,23,46],[1,19,23,47],[1,19,23,48],[1,19,23,49],
 [1,19,23,55],[1,19,23,58],[1,19,23,59],[1,19,23,60],
 [1,19,23,61],[1,19,23,62],[1,19,23,66],[1,19,23,67],
 [1,19,23,68],[1,19,23,69],[1,19,24,25],[1,19,24,26],
 [1,19,24,27],[1,19,24,34],[1,19,24,39],[1,19,24,41],
 [1,19,24,43],[1,19,24,44],[1,19,24,45],[1,19,24,46],
 [1,19,24,47],[1,19,24,48],[1,19,24,49],[1,19,24,55],
 [1,19,24,58],[1,19,24,59],[1,19,24,60],[1,19,24,61],
 [1,19,24,62],[1,19,24,66],[1,19,24,67],[1,19,24,68],
 [1,19,24,69],[1,19,25,26],[1,19,25,27],[1,19,25,34],
 [1,19,25,39],[1,19,25,41],[1,19,25,43],[1,19,25,44],
 [1,19,25,45],[1,19,25,46],[1,19,25,47],[1,19,25,48],
 [1,19,25,49],[1,19,25,55],[1,19,25,58],[1,19,25,59],
 [1,19,25,60],[1,19,25,61],[1,19,25,62],[1,19,25,66],
 [1,19,25,67],[1,19,25,68],[1,19,25,69],[1,19,26,27],
 [1,19,26,34],[1,19,26,35],[1,19,26,36],[1,19,26,39],
 [1,19,26,41],[1,19,26,43],[1,19,26,44],[1,19,26,45],
 [1,19,26,46],[1,19,26,47],[1,19,26,48],[1,19,26,49],
 [1,19,26,55],[1,19,26,58],[1,19,26,59],[1,19,26,60],
 [1,19,26,61],[1,19,26,62],[1,19,26,66],[1,19,26,67],
 [1,19,26,68],[1,19,26,69],[1,19,27,34],[1,19,27,35],
 [1,19,27,36],[1,19,27,39],[1,19,27,41],[1,19,27,43],
 [1,19,27,44],[1,19,27,45],[1,19,27,46],[1,19,27,47],
 [1,19,27,48],[1,19,27,49],[1,19,27,55],[1,19,27,58],
 [1,19,27,59],[1,19,27,60],[1,19,27,61],[1,19,27,62],
 [1,19,27,66],[1,19,27,67],[1,19,27,68],[1,19,27,69],
 [1,19,34,39],[1,19,34,41],[1,19,34,43],[1,19,34,44],
 [1,19,34,45],[1,19,34,46],[1,19,34,47],[1,19,34,48],
 [1,19,34,49],[1,19,34,55],[1,19,34,58],[1,19,34,59],
 [1,19,34,60],[1,19,34,61],[1,19,34,62],[1,19,34,66],
 [1,19,34,67],[1,19,34,68],[1,19,34,69],[1,19,35,36],
 [1,19,35,49],[1,19,35,55],[1,19,35,60],[1,19,35,66],
 [1,19,35,69],[1,19,36,48],[1,19,36,49],[1,19,36,55],
 [1,19,36,60],[1,19,36,66],[1,19,36,69],[1,19,39,41],
 [1,19,39,43],[1,19,39,44],[1,19,39,45],[1,19,39,46],
 [1,19,39,47],[1,19,39,48],[1,19,39,49],[1,19,39,55],
 [1,19,39,58],[1,19,39,59],[1,19,39,60],[1,19,39,61],
 [1,19,39,62],[1,19,39,66],[1,19,39,67],[1,19,39,68],
 [1,19,39,69],[1,19,41,43],[1,19,41,44],[1,19,41,45],
 [1,19,41,46],[1,19,41,47],[1,19,41,48],[1,19,41,49],
 [1,19,41,55],[1,19,41,58],[1,19,41,59],[1,19,41,60],
 [1,19,41,61],[1,19,41,62],[1,19,41,66],[1,19,41,67],
 [1,19,41,68],[1,19,41,69],[1,19,43,44],[1,19,43,45],
 [1,19,43,46],[1,19,43,47],[1,19,43,48],[1,19,43,49],
 [1,19,43,55],[1,19,43,58],[1,19,43,59],[1,19,43,60],
 [1,19,43,61],[1,19,43,62],[1,19,43,66],[1,19,43,67],
 [1,19,43,68],[1,19,43,69],[1,19,44,45],[1,19,44,46],
 [1,19,44,47],[1,19,44,48],[1,19,44,49],[1,19,44,55],
 [1,19,44,58],[1,19,44,59],[1,19,44,60],[1,19,44,61],
 [1,19,44,62],[1,19,44,66],[1,19,44,67],[1,19,44,68],
 [1,19,44,69],[1,19,45,46],[1,19,45,47],[1,19,45,48],
 [1,19,45,49],[1,19,45,55],[1,19,45,58],[1,19,45,59],
 [1,19,45,60],[1,19,45,61],[1,19,45,62],[1,19,45,66],
 [1,19,45,67],[1,19,45,68],[1,19,45,69],[1,19,46,47],
 [1,19,46,48],[1,19,46,49],[1,19,46,55],[1,19,46,58],
 [1,19,46,59],[1,19,46,60],[1,19,46,61],[1,19,46,62],
 [1,19,46,66],[1,19,46,67],[1,19,46,68],[1,19,46,69],
 [1,19,47,48],[1,19,47,49],[1,19,47,55],[1,19,47,58],
 [1,19,47,59],[1,19,47,60],[1,19,47,61],[1,19,47,62],
 [1,19,47,66],[1,19,47,67],[1,19,47,68],[1,19,47,69],
 [1,19,48,49],[1,19,48,55],[1,19,48,58],[1,19,48,59],
 [1,19,48,60],[1,19,48,61],[1,19,48,62],[1,19,48,66],
 [1,19,48,67],[1,19,48,68],[1,19,48,69],[1,19,49,55],
 [1,19,49,58],[1,19,49,59],[1,19,49,60],[1,19,49,61],
 [1,19,49,62],[1,19,49,66],[1,19,49,67],[1,19,49,68],
 [1,19,49,69],[1,19,55,58],[1,19,55,59],[1,19,55,60],
 [1,19,55,61],[1,19,55,62],[1,19,55,66],[1,19,55,67],
 [1,19,55,68],[1,19,55,69],[1,19,58,59],[1,19,58,60],
 [1,19,58,61],[1,19,58,62],[1,19,58,66],[1,19,58,67],
 [1,19,58,68],[1,19,58,69],[1,19,59,60],[1,19,59,61],
 [1,19,59,62],[1,19,59,66],[1,19,59,67],[1,19,59,68],
 [1,19,59,69],[1,19,60,61],[1,19,60,62],[1,19,60,66],
 [1,19,60,67],[1,19,60,68],[1,19,60,69],[1,19,61,62],
 [1,19,61,66],[1,19,61,67],[1,19,61,68],[1,19,61,69],
 [1,19,62,66],[1,19,62,67],[1,19,62,68],[1,19,62,69],
 [1,19,66,67],[1,19,66,68],[1,19,66,69],[1,19,67,68],
 [1,19,67,69],[1,19,68,69],[1,20,21,22],[1,20,21,23],
 [1,20,21,24],[1,20,21,25],[1,20,21,26],[1,20,21,27],
 [1,20,21,34],[1,20,21,39],[1,20,21,41],[1,20,21,43],
 [1,20,21,44],[1,20,21,45],[1,20,21,46],[1,20,21,47],
 [1,20,21,48],[1,20,21,49],[1,20,21,55],[1,20,21,58],
 [1,20,21,59],[1,20,21,60],[1,20,21,61],[1,20,21,62],
 [1,20,21,66],[1,20,21,67],[1,20,21,68],[1,20,21,69],
 [1,20,22,23],[1,20,22,24],[1,20,22,25],[1,20,22,26],
 [1,20,22,27],[1,20,22,34],[1,20,22,39],[1,20,22,41],
 [1,20,22,43],[1,20,22,44],[1,20,22,45],[1,20,22,46],
 [1,20,22,47],[1,20,22,48],[1,20,22,49],[1,20,22,55],
 [1,20,22,58],[1,20,22,59],[1,20,22,60],[1,20,22,61],
 [1,20,22,62],[1,20,22,66],[1,20,22,67],[1,20,22,68],
 [1,20,22,69],[1,20,23,24],[1,20,23,25],[1,20,23,26],
 [1,20,23,27],[1,20,23,34],[1,20,23,39],[1,20,23,41],
 [1,20,23,43],[1,20,23,44],[1,20,23,45],[1,20,23,46],
 [1,20,23,47],[1,20,23,48],[1,20,23,49],[1,20,23,55],
 [1,20,23,58],[1,20,23,59],[1,20,23,60],[1,20,23,61],
 [1,20,23,62],[1,20,23,66],[1,20,23,67],[1,20,23,68],
 [1,20,23,69],[1,20,24,25],[1,20,24,26],[1,20,24,27],
 [1,20,24,34],[1,20,24,39],[1,20,24,41],[1,20,24,43],
 [1,20,24,44],[1,20,24,45],[1,20,24,46],[1,20,24,47],
 [1,20,24,48],[1,20,24,49],[1,20,24,55],[1,20,24,58],
 [1,20,24,59],[1,20,24,60],[1,20,24,61],[1,20,24,62],
 [1,20,24,66],[1,20,24,67],[1,20,24,68],[1,20,24,69],
 [1,20,25,26],[1,20,25,27],[1,20,25,34],[1,20,25,39],
 [1,20,25,41],[1,20,25,43],[1,20,25,44],[1,20,25,45],
 [1,20,25,46],[1,20,25,47],[1,20,25,48],[1,20,25,49],
 [1,20,25,55],[1,20,25,58],[1,20,25,59],[1,20,25,60],
 [1,20,25,61],[1,20,25,62],[1,20,25,66],[1,20,25,67],
 [1,20,25,68],[1,20,25,69],[1,20,26,27],[1,20,26,34],
 [1,20,26,39],[1,20,26,41],[1,20,26,43],[1,20,26,44],
 [1,20,26,45],[1,20,26,46],[1,20,26,47],[1,20,26,48],
 [1,20,26,49],[1,20,26,55],[1,20,26,58],[1,20,26,59],
 [1,20,26,60],[1,20,26,61],[1,20,26,62],[1,20,26,66],
 [1,20,26,67],[1,20,26,68],[1,20,26,69],[1,20,27,34],
 [1,20,27,39],[1,20,27,41],[1,20,27,43],[1,20,27,44],
 [1,20,27,45],[1,20,27,46],[1,20,27,47],[1,20,27,48],
 [1,20,27,49],[1,20,27,55],[1,20,27,58],[1,20,27,59],
 [1,20,27,60],[1,20,27,61],[1,20,27,62],[1,20,27,66],
 [1,20,27,67],[1,20,27,68],[1,20,27,69],[1,20,34,39],
 [1,20,34,41],[1,20,34,43],[1,20,34,44],[1,20,34,45],
 [1,20,34,46],[1,20,34,47],[1,20,34,48],[1,20,34,49],
 [1,20,34,55],[1,20,34,58],[1,20,34,59],[1,20,34,60],
 [1,20,34,61],[1,20,34,62],[1,20,34,66],[1,20,34,67],
 [1,20,34,68],[1,20,34,69],[1,20,39,41],[1,20,39,43],
 [1,20,39,44],[1,20,39,45],[1,20,39,46],[1,20,39,47],
 [1,20,39,48],[1,20,39,49],[1,20,39,55],[1,20,39,58],
 [1,20,39,59],[1,20,39,60],[1,20,39,61],[1,20,39,62],
 [1,20,39,66],[1,20,39,67],[1,20,39,68],[1,20,39,69],
 [1,20,41,43],[1,20,41,44],[1,20,41,45],[1,20,41,46],
 [1,20,41,47],[1,20,41,48],[1,20,41,49],[1,20,41,55],
 [1,20,41,58],[1,20,41,59],[1,20,41,60],[1,20,41,61],
 [1,20,41,62],[1,20,41,66],[1,20,41,67],[1,20,41,68],
 [1,20,41,69],[1,20,43,44],[1,20,43,45],[1,20,43,46],
 [1,20,43,47],[1,20,43,48],[1,20,43,49],[1,20,43,55],
 [1,20,43,58],[1,20,43,59],[1,20,43,60],[1,20,43,61],
 [1,20,43,62],[1,20,43,66],[1,20,43,67],[1,20,43,68],
 [1,20,43,69],[1,20,44,45],[1,20,44,46],[1,20,44,47],
 [1,20,44,48],[1,20,44,49],[1,20,44,55],[1,20,44,58],
 [1,20,44,59],[1,20,44,60],[1,20,44,61],[1,20,44,62],
 [1,20,44,66],[1,20,44,67],[1,20,44,68],[1,20,44,69],
 [1,20,45,46],[1,20,45,47],[1,20,45,48],[1,20,45,49],
 [1,20,45,55],[1,20,45,58],[1,20,45,59],[1,20,45,60],
 [1,20,45,61],[1,20,45,62],[1,20,45,66],[1,20,45,67],
 [1,20,45,68],[1,20,45,69],[1,20,46,47],[1,20,46,48],
 [1,20,46,49],[1,20,46,55],[1,20,46,58],[1,20,46,59],
 [1,20,46,60],[1,20,46,61],[1,20,46,62],[1,20,46,66],
 [1,20,46,67],[1,20,46,68],[1,20,46,69],[1,20,47,48],
 [1,20,47,49],[1,20,47,55],[1,20,47,58],[1,20,47,59],
 [1,20,47,60],[1,20,47,61],[1,20,47,62],[1,20,47,66],
 [1,20,47,67],[1,20,47,68],[1,20,47,69],[1,20,48,49],
 [1,20,48,55],[1,20,48,58],[1,20,48,59],[1,20,48,60],
 [1,20,48,61],[1,20,48,62],[1,20,48,66],[1,20,48,67],
 [1,20,48,68],[1,20,48,69],[1,20,49,55],[1,20,49,58],
 [1,20,49,59],[1,20,49,60],[1,20,49,61],[1,20,49,62],
 [1,20,49,66],[1,20,49,67],[1,20,49,68],[1,20,49,69],
 [1,20,55,58],[1,20,55,59],[1,20,55,60],[1,20,55,61],
 [1,20,55,62],[1,20,55,66],[1,20,55,67],[1,20,55,68],
 [1,20,55,69],[1,20,58,59],[1,20,58,60],[1,20,58,61],
 [1,20,58,62],[1,20,58,66],[1,20,58,67],[1,20,58,68],
 [1,20,58,69],[1,20,59,60],[1,20,59,61],[1,20,59,62],
 [1,20,59,66],[1,20,59,67],[1,20,59,68],[1,20,59,69],
 [1,20,60,61],[1,20,60,62],[1,20,60,66],[1,20,60,67],
 [1,20,60,68],[1,20,60,69],[1,20,61,62],[1,20,61,66],
 [1,20,61,67],[1,20,61,68],[1,20,61,69],[1,20,62,66],
 [1,20,62,67],[1,20,62,68],[1,20,62,69],[1,20,66,67],
 [1,20,66,68],[1,20,66,69],[1,20,67,68],[1,20,67,69],
 [1,20,68,69],[1,21,22,23],[1,21,22,24],[1,21,22,25],
 [1,21,22,26],[1,21,22,27],[1,21,22,34],[1,21,22,39],
 [1,21,22,41],[1,21,22,43],[1,21,22,44],[1,21,22,45],
 [1,21,22,46],[1,21,22,47],[1,21,22,48],[1,21,22,49],
 [1,21,22,55],[1,21,22,58],[1,21,22,59],[1,21,22,60],
 [1,21,22,61],[1,21,22,62],[1,21,22,66],[1,21,22,67],
 [1,21,22,68],[1,21,22,69],[1,21,23,24],[1,21,23,25],
 [1,21,23,26],[1,21,23,27],[1,21,23,34],[1,21,23,39],
 [1,21,23,41],[1,21,23,43],[1,21,23,44],[1,21,23,45],
 [1,21,23,46],[1,21,23,47],[1,21,23,48],[1,21,23,49],
 [1,21,23,55],[1,21,23,58],[1,21,23,59],[1,21,23,60],
 [1,21,23,61],[1,21,23,62],[1,21,23,66],[1,21,23,67],
 [1,21,23,68],[1,21,23,69],[1,21,24,25],[1,21,24,26],
 [1,21,24,27],[1,21,24,34],[1,21,24,39],[1,21,24,41],
 [1,21,24,43],[1,21,24,44],[1,21,24,45],[1,21,24,46],
 [1,21,24,47],[1,21,24,48],[1,21,24,49],[1,21,24,55],
 [1,21,24,58],[1,21,24,59],[1,21,24,60],[1,21,24,61],
 [1,21,24,62],[1,21,24,66],[1,21,24,67],[1,21,24,68],
 [1,21,24,69],[1,21,25,26],[1,21,25,27],[1,21,25,34],
 [1,21,25,39],[1,21,25,41],[1,21,25,43],[1,21,25,44],
 [1,21,25,45],[1,21,25,46],[1,21,25,47],[1,21,25,48],
 [1,21,25,49],[1,21,25,55],[1,21,25,58],[1,21,25,59],
 [1,21,25,60],[1,21,25,61],[1,21,25,62],[1,21,25,66],
 [1,21,25,67],[1,21,25,68],[1,21,25,69],[1,21,26,27],
 [1,21,26,34],[1,21,26,39],[1,21,26,41],[1,21,26,43],
 [1,21,26,44],[1,21,26,45],[1,21,26,46],[1,21,26,47],
 [1,21,26,48],[1,21,26,49],[1,21,26,55],[1,21,26,58],
 [1,21,26,59],[1,21,26,60],[1,21,26,61],[1,21,26,62],
 [1,21,26,66],[1,21,26,67],[1,21,26,68],[1,21,26,69],
 [1,21,27,34],[1,21,27,39],[1,21,27,41],[1,21,27,43],
 [1,21,27,44],[1,21,27,45],[1,21,27,46],[1,21,27,47],
 [1,21,27,48],[1,21,27,49],[1,21,27,55],[1,21,27,58],
 [1,21,27,59],[1,21,27,60],[1,21,27,61],[1,21,27,62],
 [1,21,27,66],[1,21,27,67],[1,21,27,68],[1,21,27,69],
 [1,21,34,39],[1,21,34,41],[1,21,34,43],[1,21,34,44],
 [1,21,34,45],[1,21,34,46],[1,21,34,47],[1,21,34,48],
 [1,21,34,49],[1,21,34,55],[1,21,34,58],[1,21,34,59],
 [1,21,34,60],[1,21,34,61],[1,21,34,62],[1,21,34,66],
 [1,21,34,67],[1,21,34,68],[1,21,34,69],[1,21,39,41],
 [1,21,39,43],[1,21,39,44],[1,21,39,45],[1,21,39,46],
 [1,21,39,47],[1,21,39,48],[1,21,39,49],[1,21,39,55],
 [1,21,39,58],[1,21,39,59],[1,21,39,60],[1,21,39,61],
 [1,21,39,62],[1,21,39,66],[1,21,39,67],[1,21,39,68],
 [1,21,39,69],[1,21,41,43],[1,21,41,44],[1,21,41,45],
 [1,21,41,46],[1,21,41,47],[1,21,41,48],[1,21,41,49],
 [1,21,41,55],[1,21,41,58],[1,21,41,59],[1,21,41,60],
 [1,21,41,61],[1,21,41,62],[1,21,41,66],[1,21,41,67],
 [1,21,41,68],[1,21,41,69],[1,21,43,44],[1,21,43,45],
 [1,21,43,46],[1,21,43,47],[1,21,43,48],[1,21,43,49],
 [1,21,43,55],[1,21,43,58],[1,21,43,59],[1,21,43,60],
 [1,21,43,61],[1,21,43,62],[1,21,43,66],[1,21,43,67],
 [1,21,43,68],[1,21,43,69],[1,21,44,45],[1,21,44,46],
 [1,21,44,47],[1,21,44,48],[1,21,44,49],[1,21,44,55],
 [1,21,44,58],[1,21,44,59],[1,21,44,60],[1,21,44,61],
 [1,21,44,62],[1,21,44,66],[1,21,44,67],[1,21,44,68],
 [1,21,44,69],[1,21,45,46],[1,21,45,47],[1,21,45,48],
 [1,21,45,49],[1,21,45,55],[1,21,45,58],[1,21,45,59],
 [1,21,45,60],[1,21,45,61],[1,21,45,62],[1,21,45,66],
 [1,21,45,67],[1,21,45,68],[1,21,45,69],[1,21,46,47],
 [1,21,46,48],[1,21,46,49],[1,21,46,55],[1,21,46,58],
 [1,21,46,59],[1,21,46,60],[1,21,46,61],[1,21,46,62],
 [1,21,46,66],[1,21,46,67],[1,21,46,68],[1,21,46,69],
 [1,21,47,48],[1,21,47,49],[1,21,47,55],[1,21,47,58],
 [1,21,47,59],[1,21,47,60],[1,21,47,61],[1,21,47,62],
 [1,21,47,66],[1,21,47,67],[1,21,47,68],[1,21,47,69],
 [1,21,48,49],[1,21,48,55],[1,21,48,58],[1,21,48,59],
 [1,21,48,60],[1,21,48,61],[1,21,48,62],[1,21,48,66],
 [1,21,48,67],[1,21,48,68],[1,21,48,69],[1,21,49,55],
 [1,21,49,58],[1,21,49,59],[1,21,49,60],[1,21,49,61],
 [1,21,49,62],[1,21,49,66],[1,21,49,67],[1,21,49,68],
 [1,21,49,69],[1,21,55,58],[1,21,55,59],[1,21,55,60],
 [1,21,55,61],[1,21,55,62],[1,21,55,66],[1,21,55,67],
 [1,21,55,68],[1,21,55,69],[1,21,58,59],[1,21,58,60],
 [1,21,58,61],[1,21,58,62],[1,21,58,66],[1,21,58,67],
 [1,21,58,68],[1,21,58,69],[1,21,59,60],[1,21,59,61],
 [1,21,59,62],[1,21,59,66],[1,21,59,67],[1,21,59,68],
 [1,21,59,69],[1,21,60,61],[1,21,60,62],[1,21,60,66],
 [1,21,60,67],[1,21,60,68],[1,21,60,69],[1,21,61,62],
 [1,21,61,66],[1,21,61,67],[1,21,61,68],[1,21,61,69],
 [1,21,62,66],[1,21,62,67],[1,21,62,68],[1,21,62,69],
 [1,21,66,67],[1,21,66,68],[1,21,66,69],[1,21,67,68],
 [1,21,67,69],[1,21,68,69],[1,22,23,24],[1,22,23,25],
 [1,22,23,26],[1,22,23,27],[1,22,23,34],[1,22,23,39],
 [1,22,23,41],[1,22,23,43],[1,22,23,44],[1,22,23,45],
 [1,22,23,46],[1,22,23,47],[1,22,23,48],[1,22,23,49],
 [1,22,23,55],[1,22,23,58],[1,22,23,59],[1,22,23,60],
 [1,22,23,61],[1,22,23,62],[1,22,23,66],[1,22,23,67],
 [1,22,23,68],[1,22,23,69],[1,22,24,25],[1,22,24,26],
 [1,22,24,27],[1,22,24,34],[1,22,24,39],[1,22,24,41],
 [1,22,24,43],[1,22,24,44],[1,22,24,45],[1,22,24,46],
 [1,22,24,47],[1,22,24,48],[1,22,24,49],[1,22,24,55],
 [1,22,24,58],[1,22,24,59],[1,22,24,60],[1,22,24,61],
 [1,22,24,62],[1,22,24,66],[1,22,24,67],[1,22,24,68],
 [1,22,24,69],[1,22,25,26],[1,22,25,27],[1,22,25,34],
 [1,22,25,39],[1,22,25,41],[1,22,25,43],[1,22,25,44],
 [1,22,25,45],[1,22,25,46],[1,22,25,47],[1,22,25,48],
 [1,22,25,49],[1,22,25,55],[1,22,25,58],[1,22,25,59],
 [1,22,25,60],[1,22,25,61],[1,22,25,62],[1,22,25,66],
 [1,22,25,67],[1,22,25,68],[1,22,25,69],[1,22,26,27],
 [1,22,26,34],[1,22,26,39],[1,22,26,41],[1,22,26,43],
 [1,22,26,44],[1,22,26,45],[1,22,26,46],[1,22,26,47],
 [1,22,26,48],[1,22,26,49],[1,22,26,55],[1,22,26,58],
 [1,22,26,59],[1,22,26,60],[1,22,26,61],[1,22,26,62],
 [1,22,26,66],[1,22,26,67],[1,22,26,68],[1,22,26,69],
 [1,22,27,34],[1,22,27,39],[1,22,27,41],[1,22,27,43],
 [1,22,27,44],[1,22,27,45],[1,22,27,46],[1,22,27,47],
 [1,22,27,48],[1,22,27,49],[1,22,27,55],[1,22,27,58],
 [1,22,27,59],[1,22,27,60],[1,22,27,61],[1,22,27,62],
 [1,22,27,66],[1,22,27,67],[1,22,27,68],[1,22,27,69],
 [1,22,34,39],[1,22,34,41],[1,22,34,43],[1,22,34,44],
 [1,22,34,45],[1,22,34,46],[1,22,34,47],[1,22,34,48],
 [1,22,34,49],[1,22,34,55],[1,22,34,58],[1,22,34,59],
 [1,22,34,60],[1,22,34,61],[1,22,34,62],[1,22,34,66],
 [1,22,34,67],[1,22,34,68],[1,22,34,69],[1,22,39,41],
 [1,22,39,43],[1,22,39,44],[1,22,39,45],[1,22,39,46],
 [1,22,39,47],[1,22,39,48],[1,22,39,49],[1,22,39,55],
 [1,22,39,58],[1,22,39,59],[1,22,39,60],[1,22,39,61],
 [1,22,39,62],[1,22,39,66],[1,22,39,67],[1,22,39,68],
 [1,22,39,69],[1,22,41,43],[1,22,41,44],[1,22,41,45],
 [1,22,41,46],[1,22,41,47],[1,22,41,48],[1,22,41,49],
 [1,22,41,55],[1,22,41,58],[1,22,41,59],[1,22,41,60],
 [1,22,41,61],[1,22,41,62],[1,22,41,66],[1,22,41,67],
 [1,22,41,68],[1,22,41,69],[1,22,43,44],[1,22,43,45],
 [1,22,43,46],[1,22,43,47],[1,22,43,48],[1,22,43,49],
 [1,22,43,55],[1,22,43,58],[1,22,43,59],[1,22,43,60],
 [1,22,43,61],[1,22,43,62],[1,22,43,66],[1,22,43,67],
 [1,22,43,68],[1,22,43,69],[1,22,44,45],[1,22,44,46],
 [1,22,44,47],[1,22,44,48],[1,22,44,49],[1,22,44,55],
 [1,22,44,58],[1,22,44,59],[1,22,44,60],[1,22,44,61],
 [1,22,44,62],[1,22,44,66],[1,22,44,67],[1,22,44,68],
 [1,22,44,69],[1,22,45,46],[1,22,45,47],[1,22,45,48],
 [1,22,45,49],[1,22,45,55],[1,22,45,58],[1,22,45,59],
 [1,22,45,60],[1,22,45,61],[1,22,45,62],[1,22,45,66],
 [1,22,45,67],[1,22,45,68],[1,22,45,69],[1,22,46,47],
 [1,22,46,48],[1,22,46,49],[1,22,46,55],[1,22,46,58],
 [1,22,46,59],[1,22,46,60],[1,22,46,61],[1,22,46,62],
 [1,22,46,66],[1,22,46,67],[1,22,46,68],[1,22,46,69],
 [1,22,47,48],[1,22,47,49],[1,22,47,55],[1,22,47,58],
 [1,22,47,59],[1,22,47,60],[1,22,47,61],[1,22,47,62],
 [1,22,47,66],[1,22,47,67],[1,22,47,68],[1,22,47,69],
 [1,22,48,49],[1,22,48,55],[1,22,48,58],[1,22,48,59],
 [1,22,48,60],[1,22,48,61],[1,22,48,62],[1,22,48,66],
 [1,22,48,67],[1,22,48,68],[1,22,48,69],[1,22,49,55],
 [1,22,49,58],[1,22,49,59],[1,22,49,60],[1,22,49,61],
 [1,22,49,62],[1,22,49,66],[1,22,49,67],[1,22,49,68],
 [1,22,49,69],[1,22,55,58],[1,22,55,59],[1,22,55,60],
 [1,22,55,61],[1,22,55,62],[1,22,55,66],[1,22,55,67],
 [1,22,55,68],[1,22,55,69],[1,22,58,59],[1,22,58,60],
 [1,22,58,61],[1,22,58,62],[1,22,58,66],[1,22,58,67],
 [1,22,58,68],[1,22,58,69],[1,22,59,60],[1,22,59,61],
 [1,22,59,62],[1,22,59,66],[1,22,59,67],[1,22,59,68],
 [1,22,59,69],[1,22,60,61],[1,22,60,62],[1,22,60,66],
 [1,22,60,67],[1,22,60,68],[1,22,60,69],[1,22,61,62],
 [1,22,61,66],[1,22,61,67],[1,22,61,68],[1,22,61,69],
 [1,22,62,66],[1,22,62,67],[1,22,62,68],[1,22,62,69],
 [1,22,66,67],[1,22,66,68],[1,22,66,69],[1,22,67,68],
 [1,22,67,69],[1,22,68,69],[1,23,24,25],[1,23,24,26],
 [1,23,24,27],[1,23,24,34],[1,23,24,39],[1,23,24,41],
 [1,23,24,43],[1,23,24,44],[1,23,24,45],[1,23,24,46],
 [1,23,24,47],[1,23,24,48],[1,23,24,49],[1,23,24,55],
 [1,23,24,58],[1,23,24,59],[1,23,24,60],[1,23,24,61],
 [1,23,24,62],[1,23,24,66],[1,23,24,67],[1,23,24,68],
 [1,23,24,69],[1,23,25,26],[1,23,25,27],[1,23,25,34],
 [1,23,25,39],[1,23,25,41],[1,23,25,43],[1,23,25,44],
 [1,23,25,45],[1,23,25,46],[1,23,25,47],[1,23,25,48],
 [1,23,25,49],[1,23,25,55],[1,23,25,58],[1,23,25,59],
 [1,23,25,60],[1,23,25,61],[1,23,25,62],[1,23,25,66],
 [1,23,25,67],[1,23,25,68],[1,23,25,69],[1,23,26,27],
 [1,23,26,34],[1,23,26,35],[1,23,26,36],[1,23,26,39],
 [1,23,26,41],[1,23,26,43],[1,23,26,44],[1,23,26,45],
 [1,23,26,46],[1,23,26,47],[1,23,26,48],[1,23,26,49],
 [1,23,26,55],[1,23,26,58],[1,23,26,59],[1,23,26,60],
 [1,23,26,61],[1,23,26,62],[1,23,26,66],[1,23,26,67],
 [1,23,26,68],[1,23,26,69],[1,23,27,34],[1,23,27,35],
 [1,23,27,36],[1,23,27,39],[1,23,27,41],[1,23,27,43],
 [1,23,27,44],[1,23,27,45],[1,23,27,46],[1,23,27,47],
 [1,23,27,48],[1,23,27,49],[1,23,27,55],[1,23,27,58],
 [1,23,27,59],[1,23,27,60],[1,23,27,61],[1,23,27,62],
 [1,23,27,66],[1,23,27,67],[1,23,27,68],[1,23,27,69],
 [1,23,34,39],[1,23,34,41],[1,23,34,43],[1,23,34,44],
 [1,23,34,45],[1,23,34,46],[1,23,34,47],[1,23,34,48],
 [1,23,34,49],[1,23,34,55],[1,23,34,58],[1,23,34,59],
 [1,23,34,60],[1,23,34,61],[1,23,34,62],[1,23,34,66],
 [1,23,34,67],[1,23,34,68],[1,23,34,69],[1,23,35,36],
 [1,23,35,48],[1,23,35,49],[1,23,35,55],[1,23,35,60],
 [1,23,35,66],[1,23,35,69],[1,23,36,48],[1,23,36,49],
 [1,23,36,55],[1,23,36,60],[1,23,36,66],[1,23,36,69],
 [1,23,39,41],[1,23,39,43],[1,23,39,44],[1,23,39,45],
 [1,23,39,46],[1,23,39,47],[1,23,39,48],[1,23,39,49],
 [1,23,39,55],[1,23,39,58],[1,23,39,59],[1,23,39,60],
 [1,23,39,61],[1,23,39,62],[1,23,39,66],[1,23,39,67],
 [1,23,39,68],[1,23,39,69],[1,23,41,43],[1,23,41,44],
 [1,23,41,45],[1,23,41,46],[1,23,41,47],[1,23,41,48],
 [1,23,41,49],[1,23,41,55],[1,23,41,58],[1,23,41,59],
 [1,23,41,60],[1,23,41,61],[1,23,41,62],[1,23,41,66],
 [1,23,41,67],[1,23,41,68],[1,23,41,69],[1,23,43,44],
 [1,23,43,45],[1,23,43,46],[1,23,43,47],[1,23,43,48],
 [1,23,43,49],[1,23,43,55],[1,23,43,58],[1,23,43,59],
 [1,23,43,60],[1,23,43,61],[1,23,43,62],[1,23,43,66],
 [1,23,43,67],[1,23,43,68],[1,23,43,69],[1,23,44,45],
 [1,23,44,46],[1,23,44,47],[1,23,44,48],[1,23,44,49],
 [1,23,44,55],[1,23,44,58],[1,23,44,59],[1,23,44,60],
 [1,23,44,61],[1,23,44,62],[1,23,44,66],[1,23,44,67],
 [1,23,44,68],[1,23,44,69],[1,23,45,46],[1,23,45,47],
 [1,23,45,48],[1,23,45,49],[1,23,45,50],[1,23,45,51],
 [1,23,45,55],[1,23,45,58],[1,23,45,59],[1,23,45,60],
 [1,23,45,61],[1,23,45,62],[1,23,45,66],[1,23,45,67],
 [1,23,45,68],[1,23,45,69],[1,23,46,47],[1,23,46,48],
 [1,23,46,49],[1,23,46,55],[1,23,46,58],[1,23,46,59],
 [1,23,46,60],[1,23,46,61],[1,23,46,62],[1,23,46,66],
 [1,23,46,67],[1,23,46,68],[1,23,46,69],[1,23,47,48],
 [1,23,47,49],[1,23,47,55],[1,23,47,58],[1,23,47,59],
 [1,23,47,60],[1,23,47,61],[1,23,47,62],[1,23,47,66],
 [1,23,47,67],[1,23,47,68],[1,23,47,69],[1,23,48,49],
 [1,23,48,55],[1,23,48,58],[1,23,48,59],[1,23,48,60],
 [1,23,48,61],[1,23,48,62],[1,23,48,66],[1,23,48,67],
 [1,23,48,68],[1,23,48,69],[1,23,49,55],[1,23,49,58],
 [1,23,49,59],[1,23,49,60],[1,23,49,61],[1,23,49,62],
 [1,23,49,66],[1,23,49,67],[1,23,49,68],[1,23,49,69],
 [1,23,50,51],[1,23,50,55],[1,23,50,58],[1,23,50,60],
 [1,23,50,61],[1,23,50,62],[1,23,50,67],[1,23,50,68],
 [1,23,50,69],[1,23,51,55],[1,23,51,58],[1,23,51,60],
 [1,23,51,61],[1,23,51,62],[1,23,51,67],[1,23,51,68],
 [1,23,51,69],[1,23,55,58],[1,23,55,59],[1,23,55,60],
 [1,23,55,61],[1,23,55,62],[1,23,55,66],[1,23,55,67],
 [1,23,55,68],[1,23,55,69],[1,23,58,59],[1,23,58,60],
 [1,23,58,61],[1,23,58,62],[1,23,58,66],[1,23,58,67],
 [1,23,58,68],[1,23,58,69],[1,23,59,60],[1,23,59,61],
 [1,23,59,62],[1,23,59,66],[1,23,59,67],[1,23,59,68],
 [1,23,59,69],[1,23,60,61],[1,23,60,62],[1,23,60,66],
 [1,23,60,67],[1,23,60,68],[1,23,60,69],[1,23,61,62],
 [1,23,61,66],[1,23,61,67],[1,23,61,68],[1,23,61,69],
 [1,23,62,66],[1,23,62,67],[1,23,62,68],[1,23,62,69],
 [1,23,66,67],[1,23,66,68],[1,23,66,69],[1,23,67,68],
 [1,23,67,69],[1,23,68,69],[1,24,25,26],[1,24,25,27],
 [1,24,25,34],[1,24,25,39],[1,24,25,41],[1,24,25,43],
 [1,24,25,44],[1,24,25,45],[1,24,25,46],[1,24,25,47],
 [1,24,25,48],[1,24,25,49],[1,24,25,55],[1,24,25,58],
 [1,24,25,59],[1,24,25,60],[1,24,25,61],[1,24,25,62],
 [1,24,25,66],[1,24,25,67],[1,24,25,68],[1,24,25,69],
 [1,24,26,27],[1,24,26,34],[1,24,26,39],[1,24,26,41],
 [1,24,26,43],[1,24,26,44],[1,24,26,45],[1,24,26,46],
 [1,24,26,47],[1,24,26,48],[1,24,26,49],[1,24,26,55],
 [1,24,26,58],[1,24,26,59],[1,24,26,60],[1,24,26,61],
 [1,24,26,62],[1,24,26,66],[1,24,26,67],[1,24,26,68],
 [1,24,26,69],[1,24,27,34],[1,24,27,39],[1,24,27,41],
 [1,24,27,43],[1,24,27,44],[1,24,27,45],[1,24,27,46],
 [1,24,27,47],[1,24,27,48],[1,24,27,49],[1,24,27,55],
 [1,24,27,58],[1,24,27,59],[1,24,27,60],[1,24,27,61],
 [1,24,27,62],[1,24,27,66],[1,24,27,67],[1,24,27,68],
 [1,24,27,69],[1,24,34,39],[1,24,34,41],[1,24,34,43],
 [1,24,34,44],[1,24,34,45],[1,24,34,46],[1,24,34,47],
 [1,24,34,48],[1,24,34,49],[1,24,34,55],[1,24,34,58],
 [1,24,34,59],[1,24,34,60],[1,24,34,61],[1,24,34,62],
 [1,24,34,66],[1,24,34,67],[1,24,34,68],[1,24,34,69],
 [1,24,39,41],[1,24,39,43],[1,24,39,44],[1,24,39,45],
 [1,24,39,46],[1,24,39,47],[1,24,39,48],[1,24,39,49],
 [1,24,39,55],[1,24,39,58],[1,24,39,59],[1,24,39,60],
 [1,24,39,61],[1,24,39,62],[1,24,39,66],[1,24,39,67],
 [1,24,39,68],[1,24,39,69],[1,24,41,43],[1,24,41,44],
 [1,24,41,45],[1,24,41,46],[1,24,41,47],[1,24,41,48],
 [1,24,41,49],[1,24,41,55],[1,24,41,58],[1,24,41,59],
 [1,24,41,60],[1,24,41,61],[1,24,41,62],[1,24,41,66],
 [1,24,41,67],[1,24,41,68],[1,24,41,69],[1,24,43,44],
 [1,24,43,45],[1,24,43,46],[1,24,43,47],[1,24,43,48],
 [1,24,43,49],[1,24,43,55],[1,24,43,58],[1,24,43,59],
 [1,24,43,60],[1,24,43,61],[1,24,43,62],[1,24,43,66],
 [1,24,43,67],[1,24,43,68],[1,24,43,69],[1,24,44,45],
 [1,24,44,46],[1,24,44,47],[1,24,44,48],[1,24,44,49],
 [1,24,44,55],[1,24,44,58],[1,24,44,59],[1,24,44,60],
 [1,24,44,61],[1,24,44,62],[1,24,44,66],[1,24,44,67],
 [1,24,44,68],[1,24,44,69],[1,24,45,46],[1,24,45,47],
 [1,24,45,48],[1,24,45,49],[1,24,45,55],[1,24,45,58],
 [1,24,45,59],[1,24,45,60],[1,24,45,61],[1,24,45,62],
 [1,24,45,66],[1,24,45,67],[1,24,45,68],[1,24,45,69],
 [1,24,46,47],[1,24,46,48],[1,24,46,49],[1,24,46,55],
 [1,24,46,58],[1,24,46,59],[1,24,46,60],[1,24,46,61],
 [1,24,46,62],[1,24,46,66],[1,24,46,67],[1,24,46,68],
 [1,24,46,69],[1,24,47,48],[1,24,47,49],[1,24,47,55],
 [1,24,47,58],[1,24,47,59],[1,24,47,60],[1,24,47,61],
 [1,24,47,62],[1,24,47,66],[1,24,47,67],[1,24,47,68],
 [1,24,47,69],[1,24,48,49],[1,24,48,55],[1,24,48,58],
 [1,24,48,59],[1,24,48,60],[1,24,48,61],[1,24,48,62],
 [1,24,48,66],[1,24,48,67],[1,24,48,68],[1,24,48,69],
 [1,24,49,55],[1,24,49,58],[1,24,49,59],[1,24,49,60],
 [1,24,49,61],[1,24,49,62],[1,24,49,66],[1,24,49,67],
 [1,24,49,68],[1,24,49,69],[1,24,55,58],[1,24,55,59],
 [1,24,55,60],[1,24,55,61],[1,24,55,62],[1,24,55,66],
 [1,24,55,67],[1,24,55,68],[1,24,55,69],[1,24,58,59],
 [1,24,58,60],[1,24,58,61],[1,24,58,62],[1,24,58,66],
 [1,24,58,67],[1,24,58,68],[1,24,58,69],[1,24,59,60],
 [1,24,59,61],[1,24,59,62],[1,24,59,66],[1,24,59,67],
 [1,24,59,68],[1,24,59,69],[1,24,60,61],[1,24,60,62],
 [1,24,60,66],[1,24,60,67],[1,24,60,68],[1,24,60,69],
 [1,24,61,62],[1,24,61,66],[1,24,61,67],[1,24,61,68],
 [1,24,61,69],[1,24,62,66],[1,24,62,67],[1,24,62,68],
 [1,24,62,69],[1,24,66,67],[1,24,66,68],[1,24,66,69],
 [1,24,67,68],[1,24,67,69],[1,24,68,69],[1,25,26,27],
 [1,25,26,34],[1,25,26,39],[1,25,26,41],[1,25,26,43],
 [1,25,26,44],[1,25,26,45],[1,25,26,46],[1,25,26,47],
 [1,25,26,48],[1,25,26,49],[1,25,26,55],[1,25,26,58],
 [1,25,26,59],[1,25,26,60],[1,25,26,61],[1,25,26,62],
 [1,25,26,66],[1,25,26,67],[1,25,26,68],[1,25,26,69],
 [1,25,27,34],[1,25,27,39],[1,25,27,41],[1,25,27,43],
 [1,25,27,44],[1,25,27,45],[1,25,27,46],[1,25,27,47],
 [1,25,27,48],[1,25,27,49],[1,25,27,55],[1,25,27,58],
 [1,25,27,59],[1,25,27,60],[1,25,27,61],[1,25,27,62],
 [1,25,27,66],[1,25,27,67],[1,25,27,68],[1,25,27,69],
 [1,25,34,39],[1,25,34,41],[1,25,34,43],[1,25,34,44],
 [1,25,34,45],[1,25,34,46],[1,25,34,47],[1,25,34,48],
 [1,25,34,49],[1,25,34,55],[1,25,34,58],[1,25,34,59],
 [1,25,34,60],[1,25,34,61],[1,25,34,62],[1,25,34,66],
 [1,25,34,67],[1,25,34,68],[1,25,34,69],[1,25,39,41],
 [1,25,39,43],[1,25,39,44],[1,25,39,45],[1,25,39,46],
 [1,25,39,47],[1,25,39,48],[1,25,39,49],[1,25,39,55],
 [1,25,39,58],[1,25,39,59],[1,25,39,60],[1,25,39,61],
 [1,25,39,62],[1,25,39,66],[1,25,39,67],[1,25,39,68],
 [1,25,39,69],[1,25,41,43],[1,25,41,44],[1,25,41,45],
 [1,25,41,46],[1,25,41,47],[1,25,41,48],[1,25,41,49],
 [1,25,41,55],[1,25,41,58],[1,25,41,59],[1,25,41,60],
 [1,25,41,61],[1,25,41,62],[1,25,41,66],[1,25,41,67],
 [1,25,41,68],[1,25,41,69],[1,25,43,44],[1,25,43,45],
 [1,25,43,46],[1,25,43,47],[1,25,43,48],[1,25,43,49],
 [1,25,43,55],[1,25,43,58],[1,25,43,59],[1,25,43,60],
 [1,25,43,61],[1,25,43,62],[1,25,43,66],[1,25,43,67],
 [1,25,43,68],[1,25,43,69],[1,25,44,45],[1,25,44,46],
 [1,25,44,47],[1,25,44,48],[1,25,44,49],[1,25,44,55],
 [1,25,44,58],[1,25,44,59],[1,25,44,60],[1,25,44,61],
 [1,25,44,62],[1,25,44,66],[1,25,44,67],[1,25,44,68],
 [1,25,44,69],[1,25,45,46],[1,25,45,47],[1,25,45,48],
 [1,25,45,49],[1,25,45,55],[1,25,45,58],[1,25,45,59],
 [1,25,45,60],[1,25,45,61],[1,25,45,62],[1,25,45,66],
 [1,25,45,67],[1,25,45,68],[1,25,45,69],[1,25,46,47],
 [1,25,46,48],[1,25,46,49],[1,25,46,55],[1,25,46,58],
 [1,25,46,59],[1,25,46,60],[1,25,46,61],[1,25,46,62],
 [1,25,46,66],[1,25,46,67],[1,25,46,68],[1,25,46,69],
 [1,25,47,48],[1,25,47,49],[1,25,47,55],[1,25,47,58],
 [1,25,47,59],[1,25,47,60],[1,25,47,61],[1,25,47,62],
 [1,25,47,66],[1,25,47,67],[1,25,47,68],[1,25,47,69],
 [1,25,48,49],[1,25,48,55],[1,25,48,58],[1,25,48,59],
 [1,25,48,60],[1,25,48,61],[1,25,48,62],[1,25,48,66],
 [1,25,48,67],[1,25,48,68],[1,25,48,69],[1,25,49,55],
 [1,25,49,58],[1,25,49,59],[1,25,49,60],[1,25,49,61],
 [1,25,49,62],[1,25,49,66],[1,25,49,67],[1,25,49,68],
 [1,25,49,69],[1,25,55,58],[1,25,55,59],[1,25,55,60],
 [1,25,55,61],[1,25,55,62],[1,25,55,66],[1,25,55,67],
 [1,25,55,68],[1,25,55,69],[1,25,58,59],[1,25,58,60],
 [1,25,58,61],[1,25,58,62],[1,25,58,66],[1,25,58,67],
 [1,25,58,68],[1,25,58,69],[1,25,59,60],[1,25,59,61],
 [1,25,59,62],[1,25,59,66],[1,25,59,67],[1,25,59,68],
 [1,25,59,69],[1,25,60,61],[1,25,60,62],[1,25,60,66],
 [1,25,60,67],[1,25,60,68],[1,25,60,69],[1,25,61,62],
 [1,25,61,66],[1,25,61,67],[1,25,61,68],[1,25,61,69],
 [1,25,62,66],[1,25,62,67],[1,25,62,68],[1,25,62,69],
 [1,25,66,67],[1,25,66,68],[1,25,66,69],[1,25,67,68],
 [1,25,67,69],[1,25,68,69],[1,26,27,34],[1,26,27,35],
 [1,26,27,36],[1,26,27,39],[1,26,27,41],[1,26,27,43],
 [1,26,27,44],[1,26,27,45],[1,26,27,46],[1,26,27,47],
 [1,26,27,48],[1,26,27,49],[1,26,27,55],[1,26,27,58],
 [1,26,27,59],[1,26,27,60],[1,26,27,61],[1,26,27,62],
 [1,26,27,66],[1,26,27,67],[1,26,27,68],[1,26,27,69],
 [1,26,34,39],[1,26,34,41],[1,26,34,43],[1,26,34,44],
 [1,26,34,45],[1,26,34,46],[1,26,34,47],[1,26,34,48],
 [1,26,34,49],[1,26,34,55],[1,26,34,58],[1,26,34,59],
 [1,26,34,60],[1,26,34,61],[1,26,34,62],[1,26,34,66],
 [1,26,34,67],[1,26,34,68],[1,26,34,69],[1,26,35,36],
 [1,26,35,48],[1,26,35,49],[1,26,35,55],[1,26,35,60],
 [1,26,35,66],[1,26,35,69],[1,26,36,48],[1,26,36,49],
 [1,26,36,55],[1,26,36,60],[1,26,36,66],[1,26,36,69],
 [1,26,39,41],[1,26,39,43],[1,26,39,44],[1,26,39,45],
 [1,26,39,46],[1,26,39,47],[1,26,39,48],[1,26,39,49],
 [1,26,39,55],[1,26,39,58],[1,26,39,59],[1,26,39,60],
 [1,26,39,61],[1,26,39,62],[1,26,39,66],[1,26,39,67],
 [1,26,39,68],[1,26,39,69],[1,26,41,43],[1,26,41,44],
 [1,26,41,45],[1,26,41,46],[1,26,41,47],[1,26,41,48],
 [1,26,41,49],[1,26,41,55],[1,26,41,58],[1,26,41,59],
 [1,26,41,60],[1,26,41,61],[1,26,41,62],[1,26,41,66],
 [1,26,41,67],[1,26,41,68],[1,26,41,69],[1,26,43,44],
 [1,26,43,45],[1,26,43,46],[1,26,43,47],[1,26,43,48],
 [1,26,43,49],[1,26,43,55],[1,26,43,58],[1,26,43,59],
 [1,26,43,60],[1,26,43,61],[1,26,43,62],[1,26,43,66],
 [1,26,43,67],[1,26,43,68],[1,26,43,69],[1,26,44,45],
 [1,26,44,46],[1,26,44,47],[1,26,44,48],[1,26,44,49],
 [1,26,44,55],[1,26,44,58],[1,26,44,59],[1,26,44,60],
 [1,26,44,61],[1,26,44,62],[1,26,44,66],[1,26,44,67],
 [1,26,44,68],[1,26,44,69],[1,26,45,46],[1,26,45,47],
 [1,26,45,48],[1,26,45,49],[1,26,45,55],[1,26,45,58],
 [1,26,45,59],[1,26,45,60],[1,26,45,61],[1,26,45,62],
 [1,26,45,66],[1,26,45,67],[1,26,45,68],[1,26,45,69],
 [1,26,46,47],[1,26,46,48],[1,26,46,49],[1,26,46,55],
 [1,26,46,58],[1,26,46,59],[1,26,46,60],[1,26,46,61],
 [1,26,46,62],[1,26,46,66],[1,26,46,67],[1,26,46,68],
 [1,26,46,69],[1,26,47,48],[1,26,47,49],[1,26,47,55],
 [1,26,47,58],[1,26,47,59],[1,26,47,60],[1,26,47,61],
 [1,26,47,62],[1,26,47,66],[1,26,47,67],[1,26,47,68],
 [1,26,47,69],[1,26,48,49],[1,26,48,55],[1,26,48,58],
 [1,26,48,59],[1,26,48,60],[1,26,48,61],[1,26,48,62],
 [1,26,48,66],[1,26,48,67],[1,26,48,68],[1,26,48,69],
 [1,26,49,55],[1,26,49,58],[1,26,49,59],[1,26,49,60],
 [1,26,49,61],[1,26,49,62],[1,26,49,66],[1,26,49,67],
 [1,26,49,68],[1,26,49,69],[1,26,55,58],[1,26,55,59],
 [1,26,55,60],[1,26,55,61],[1,26,55,62],[1,26,55,66],
 [1,26,55,67],[1,26,55,68],[1,26,55,69],[1,26,58,59],
 [1,26,58,60],[1,26,58,61],[1,26,58,62],[1,26,58,66],
 [1,26,58,67],[1,26,58,68],[1,26,58,69],[1,26,59,60],
 [1,26,59,61],[1,26,59,62],[1,26,59,66],[1,26,59,67],
 [1,26,59,68],[1,26,59,69],[1,26,60,61],[1,26,60,62],
 [1,26,60,66],[1,26,60,67],[1,26,60,68],[1,26,60,69],
 [1,26,61,62],[1,26,61,66],[1,26,61,67],[1,26,61,68],
 [1,26,61,69],[1,26,62,66],[1,26,62,67],[1,26,62,68],
 [1,26,62,69],[1,26,66,67],[1,26,66,68],[1,26,66,69],
 [1,26,67,68],[1,26,67,69],[1,26,68,69],[1,27,34,39],
 [1,27,34,41],[1,27,34,43],[1,27,34,44],[1,27,34,45],
 [1,27,34,46],[1,27,34,47],[1,27,34,48],[1,27,34,49],
 [1,27,34,55],[1,27,34,58],[1,27,34,59],[1,27,34,60],
 [1,27,34,61],[1,27,34,62],[1,27,34,66],[1,27,34,67],
 [1,27,34,68],[1,27,34,69],[1,27,35,36],[1,27,35,48],
 [1,27,35,49],[1,27,35,55],[1,27,35,60],[1,27,35,66],
 [1,27,35,69],[1,27,36,48],[1,27,36,49],[1,27,36,55],
 [1,27,36,60],[1,27,36,66],[1,27,36,69],[1,27,39,41],
 [1,27,39,43],[1,27,39,44],[1,27,39,45],[1,27,39,46],
 [1,27,39,47],[1,27,39,48],[1,27,39,49],[1,27,39,55],
 [1,27,39,58],[1,27,39,59],[1,27,39,60],[1,27,39,61],
 [1,27,39,62],[1,27,39,66],[1,27,39,67],[1,27,39,68],
 [1,27,39,69],[1,27,41,43],[1,27,41,44],[1,27,41,45],
 [1,27,41,46],[1,27,41,47],[1,27,41,48],[1,27,41,49],
 [1,27,41,55],[1,27,41,58],[1,27,41,59],[1,27,41,60],
 [1,27,41,61],[1,27,41,62],[1,27,41,66],[1,27,41,67],
 [1,27,41,68],[1,27,41,69],[1,27,43,44],[1,27,43,45],
 [1,27,43,46],[1,27,43,47],[1,27,43,48],[1,27,43,49],
 [1,27,43,55],[1,27,43,58],[1,27,43,59],[1,27,43,60],
 [1,27,43,61],[1,27,43,62],[1,27,43,66],[1,27,43,67],
 [1,27,43,68],[1,27,43,69],[1,27,44,45],[1,27,44,46],
 [1,27,44,47],[1,27,44,48],[1,27,44,49],[1,27,44,55],
 [1,27,44,58],[1,27,44,59],[1,27,44,60],[1,27,44,61],
 [1,27,44,62],[1,27,44,66],[1,27,44,67],[1,27,44,68],
 [1,27,44,69],[1,27,45,46],[1,27,45,47],[1,27,45,48],
 [1,27,45,49],[1,27,45,55],[1,27,45,58],[1,27,45,59],
 [1,27,45,60],[1,27,45,61],[1,27,45,62],[1,27,45,66],
 [1,27,45,67],[1,27,45,68],[1,27,45,69],[1,27,46,47],
 [1,27,46,48],[1,27,46,49],[1,27,46,55],[1,27,46,58],
 [1,27,46,59],[1,27,46,60],[1,27,46,61],[1,27,46,62],
 [1,27,46,66],[1,27,46,67],[1,27,46,68],[1,27,46,69],
 [1,27,47,48],[1,27,47,49],[1,27,47,55],[1,27,47,58],
 [1,27,47,59],[1,27,47,60],[1,27,47,61],[1,27,47,62],
 [1,27,47,66],[1,27,47,67],[1,27,47,68],[1,27,47,69],
 [1,27,48,49],[1,27,48,55],[1,27,48,58],[1,27,48,59],
 [1,27,48,60],[1,27,48,61],[1,27,48,62],[1,27,48,66],
 [1,27,48,67],[1,27,48,68],[1,27,48,69],[1,27,49,55],
 [1,27,49,58],[1,27,49,59],[1,27,49,60],[1,27,49,61],
 [1,27,49,62],[1,27,49,66],[1,27,49,67],[1,27,49,68],
 [1,27,49,69],[1,27,55,58],[1,27,55,59],[1,27,55,60],
 [1,27,55,61],[1,27,55,62],[1,27,55,66],[1,27,55,67],
 [1,27,55,68],[1,27,55,69],[1,27,58,59],[1,27,58,60],
 [1,27,58,61],[1,27,58,62],[1,27,58,66],[1,27,58,67],
 [1,27,58,68],[1,27,58,69],[1,27,59,60],[1,27,59,61],
 [1,27,59,62],[1,27,59,66],[1,27,59,67],[1,27,59,68],
 [1,27,59,69],[1,27,60,61],[1,27,60,62],[1,27,60,66],
 [1,27,60,67],[1,27,60,68],[1,27,60,69],[1,27,61,62],
 [1,27,61,66],[1,27,61,67],[1,27,61,68],[1,27,61,69],
 [1,27,62,66],[1,27,62,67],[1,27,62,68],[1,27,62,69],
 [1,27,66,67],[1,27,66,68],[1,27,66,69],[1,27,67,68],
 [1,27,67,69],[1,27,68,69],[1,34,39,41],[1,34,39,43],
 [1,34,39,44],[1,34,39,45],[1,34,39,46],[1,34,39,47],
 [1,34,39,48],[1,34,39,49],[1,34,39,55],[1,34,39,58],
 [1,34,39,59],[1,34,39,60],[1,34,39,61],[1,34,39,62],
 [1,34,39,66],[1,34,39,67],[1,34,39,68],[1,34,39,69],
 [1,34,41,43],[1,34,41,44],[1,34,41,45],[1,34,41,46],
 [1,34,41,47],[1,34,41,48],[1,34,41,49],[1,34,41,55],
 [1,34,41,58],[1,34,41,59],[1,34,41,60],[1,34,41,61],
 [1,34,41,62],[1,34,41,66],[1,34,41,67],[1,34,41,68],
 [1,34,41,69],[1,34,43,44],[1,34,43,45],[1,34,43,46],
 [1,34,43,47],[1,34,43,48],[1,34,43,49],[1,34,43,55],
 [1,34,43,58],[1,34,43,59],[1,34,43,60],[1,34,43,61],
 [1,34,43,62],[1,34,43,66],[1,34,43,67],[1,34,43,68],
 [1,34,43,69],[1,34,44,45],[1,34,44,46],[1,34,44,47],
 [1,34,44,48],[1,34,44,49],[1,34,44,55],[1,34,44,58],
 [1,34,44,59],[1,34,44,60],[1,34,44,61],[1,34,44,62],
 [1,34,44,66],[1,34,44,67],[1,34,44,68],[1,34,44,69],
 [1,34,45,46],[1,34,45,47],[1,34,45,48],[1,34,45,49],
 [1,34,45,55],[1,34,45,58],[1,34,45,59],[1,34,45,60],
 [1,34,45,61],[1,34,45,62],[1,34,45,66],[1,34,45,67],
 [1,34,45,68],[1,34,45,69],[1,34,46,47],[1,34,46,48],
 [1,34,46,49],[1,34,46,55],[1,34,46,58],[1,34,46,59],
 [1,34,46,60],[1,34,46,61],[1,34,46,62],[1,34,46,66],
 [1,34,46,67],[1,34,46,68],[1,34,46,69],[1,34,47,48],
 [1,34,47,49],[1,34,47,55],[1,34,47,58],[1,34,47,59],
 [1,34,47,60],[1,34,47,61],[1,34,47,62],[1,34,47,66],
 [1,34,47,67],[1,34,47,68],[1,34,47,69],[1,34,48,49],
 [1,34,48,55],[1,34,48,58],[1,34,48,59],[1,34,48,60],
 [1,34,48,61],[1,34,48,62],[1,34,48,66],[1,34,48,67],
 [1,34,48,68],[1,34,48,69],[1,34,49,55],[1,34,49,58],
 [1,34,49,59],[1,34,49,60],[1,34,49,61],[1,34,49,62],
 [1,34,49,66],[1,34,49,67],[1,34,49,68],[1,34,49,69],
 [1,34,55,58],[1,34,55,59],[1,34,55,60],[1,34,55,61],
 [1,34,55,62],[1,34,55,66],[1,34,55,67],[1,34,55,68],
 [1,34,55,69],[1,34,58,59],[1,34,58,60],[1,34,58,61],
 [1,34,58,62],[1,34,58,66],[1,34,58,67],[1,34,58,68],
 [1,34,58,69],[1,34,59,60],[1,34,59,61],[1,34,59,62],
 [1,34,59,66],[1,34,59,67],[1,34,59,68],[1,34,59,69],
 [1,34,60,61],[1,34,60,62],[1,34,60,66],[1,34,60,67],
 [1,34,60,68],[1,34,60,69],[1,34,61,62],[1,34,61,66],
 [1,34,61,67],[1,34,61,68],[1,34,61,69],[1,34,62,66],
 [1,34,62,67],[1,34,62,68],[1,34,62,69],[1,34,66,67],
 [1,34,66,68],[1,34,66,69],[1,34,67,68],[1,34,67,69],
 [1,34,68,69],[1,35,36,48],[1,35,36,49],[1,35,36,55],
 [1,35,36,60],[1,35,36,66],[1,35,36,69],[1,35,48,49],
 [1,35,48,55],[1,35,48,60],[1,35,48,66],[1,35,48,69],
 [1,35,49,55],[1,35,49,60],[1,35,49,66],[1,35,49,69],
 [1,35,55,60],[1,35,55,66],[1,35,55,69],[1,35,60,66],
 [1,35,60,69],[1,35,66,69],[1,36,48,49],[1,36,48,55],
 [1,36,48,60],[1,36,48,69],[1,36,49,55],[1,36,49,60],
 [1,36,49,66],[1,36,49,69],[1,36,55,60],[1,36,55,66],
 [1,36,55,69],[1,36,60,66],[1,36,60,69],[1,36,66,69],
 [1,39,41,43],[1,39,41,44],[1,39,41,45],[1,39,41,46],
 [1,39,41,47],[1,39,41,48],[1,39,41,49],[1,39,41,55],
 [1,39,41,58],[1,39,41,59],[1,39,41,60],[1,39,41,61],
 [1,39,41,62],[1,39,41,66],[1,39,41,67],[1,39,41,68],
 [1,39,41,69],[1,39,43,44],[1,39,43,45],[1,39,43,46],
 [1,39,43,47],[1,39,43,48],[1,39,43,49],[1,39,43,55],
 [1,39,43,58],[1,39,43,59],[1,39,43,60],[1,39,43,61],
 [1,39,43,62],[1,39,43,66],[1,39,43,67],[1,39,43,68],
 [1,39,43,69],[1,39,44,45],[1,39,44,46],[1,39,44,47],
 [1,39,44,48],[1,39,44,49],[1,39,44,55],[1,39,44,58],
 [1,39,44,59],[1,39,44,60],[1,39,44,61],[1,39,44,62],
 [1,39,44,66],[1,39,44,67],[1,39,44,68],[1,39,44,69],
 [1,39,45,46],[1,39,45,47],[1,39,45,48],[1,39,45,49],
 [1,39,45,55],[1,39,45,58],[1,39,45,59],[1,39,45,60],
 [1,39,45,61],[1,39,45,62],[1,39,45,66],[1,39,45,67],
 [1,39,45,68],[1,39,45,69],[1,39,46,47],[1,39,46,48],
 [1,39,46,49],[1,39,46,55],[1,39,46,58],[1,39,46,59],
 [1,39,46,60],[1,39,46,61],[1,39,46,62],[1,39,46,66],
 [1,39,46,67],[1,39,46,68],[1,39,46,69],[1,39,47,48],
 [1,39,47,49],[1,39,47,55],[1,39,47,58],[1,39,47,59],
 [1,39,47,60],[1,39,47,61],[1,39,47,62],[1,39,47,66],
 [1,39,47,67],[1,39,47,68],[1,39,47,69],[1,39,48,49],
 [1,39,48,55],[1,39,48,58],[1,39,48,59],[1,39,48,60],
 [1,39,48,61],[1,39,48,62],[1,39,48,66],[1,39,48,67],
 [1,39,48,68],[1,39,48,69],[1,39,49,55],[1,39,49,58],
 [1,39,49,59],[1,39,49,60],[1,39,49,61],[1,39,49,62],
 [1,39,49,66],[1,39,49,67],[1,39,49,68],[1,39,49,69],
 [1,39,55,58],[1,39,55,59],[1,39,55,60],[1,39,55,61],
 [1,39,55,62],[1,39,55,66],[1,39,55,67],[1,39,55,68],
 [1,39,55,69],[1,39,58,59],[1,39,58,60],[1,39,58,61],
 [1,39,58,62],[1,39,58,66],[1,39,58,67],[1,39,58,68],
 [1,39,58,69],[1,39,59,60],[1,39,59,61],[1,39,59,62],
 [1,39,59,66],[1,39,59,67],[1,39,59,68],[1,39,59,69],
 [1,39,60,61],[1,39,60,62],[1,39,60,66],[1,39,60,67],
 [1,39,60,68],[1,39,60,69],[1,39,61,62],[1,39,61,66],
 [1,39,61,67],[1,39,61,68],[1,39,61,69],[1,39,62,66],
 [1,39,62,67],[1,39,62,68],[1,39,62,69],[1,39,66,67],
 [1,39,66,68],[1,39,66,69],[1,39,67,68],[1,39,67,69],
 [1,39,68,69],[1,41,43,44],[1,41,43,45],[1,41,43,46],
 [1,41,43,47],[1,41,43,48],[1,41,43,49],[1,41,43,55],
 [1,41,43,58],[1,41,43,59],[1,41,43,60],[1,41,43,61],
 [1,41,43,62],[1,41,43,66],[1,41,43,67],[1,41,43,68],
 [1,41,43,69],[1,41,44,45],[1,41,44,46],[1,41,44,47],
 [1,41,44,48],[1,41,44,49],[1,41,44,55],[1,41,44,58],
 [1,41,44,59],[1,41,44,60],[1,41,44,61],[1,41,44,62],
 [1,41,44,66],[1,41,44,67],[1,41,44,68],[1,41,44,69],
 [1,41,45,46],[1,41,45,47],[1,41,45,48],[1,41,45,49],
 [1,41,45,55],[1,41,45,58],[1,41,45,59],[1,41,45,60],
 [1,41,45,61],[1,41,45,62],[1,41,45,66],[1,41,45,67],
 [1,41,45,68],[1,41,45,69],[1,41,46,47],[1,41,46,48],
 [1,41,46,49],[1,41,46,55],[1,41,46,58],[1,41,46,59],
 [1,41,46,60],[1,41,46,61],[1,41,46,62],[1,41,46,66],
 [1,41,46,67],[1,41,46,68],[1,41,46,69],[1,41,47,48],
 [1,41,47,49],[1,41,47,55],[1,41,47,58],[1,41,47,59],
 [1,41,47,60],[1,41,47,61],[1,41,47,62],[1,41,47,66],
 [1,41,47,67],[1,41,47,68],[1,41,47,69],[1,41,48,49],
 [1,41,48,55],[1,41,48,58],[1,41,48,59],[1,41,48,60],
 [1,41,48,61],[1,41,48,62],[1,41,48,66],[1,41,48,67],
 [1,41,48,68],[1,41,48,69],[1,41,49,55],[1,41,49,58],
 [1,41,49,59],[1,41,49,60],[1,41,49,61],[1,41,49,62],
 [1,41,49,66],[1,41,49,67],[1,41,49,68],[1,41,49,69],
 [1,41,55,58],[1,41,55,59],[1,41,55,60],[1,41,55,61],
 [1,41,55,62],[1,41,55,66],[1,41,55,67],[1,41,55,68],
 [1,41,55,69],[1,41,58,59],[1,41,58,60],[1,41,58,61],
 [1,41,58,62],[1,41,58,66],[1,41,58,67],[1,41,58,68],
 [1,41,58,69],[1,41,59,60],[1,41,59,61],[1,41,59,62],
 [1,41,59,66],[1,41,59,67],[1,41,59,68],[1,41,59,69],
 [1,41,60,61],[1,41,60,62],[1,41,60,66],[1,41,60,67],
 [1,41,60,68],[1,41,60,69],[1,41,61,62],[1,41,61,66],
 [1,41,61,67],[1,41,61,68],[1,41,61,69],[1,41,62,66],
 [1,41,62,67],[1,41,62,68],[1,41,62,69],[1,41,66,67],
 [1,41,66,68],[1,41,66,69],[1,41,67,68],[1,41,67,69],
 [1,41,68,69],[1,43,44,45],[1,43,44,46],[1,43,44,47],
 [1,43,44,48],[1,43,44,49],[1,43,44,55],[1,43,44,58],
 [1,43,44,59],[1,43,44,60],[1,43,44,61],[1,43,44,62],
 [1,43,44,66],[1,43,44,67],[1,43,44,68],[1,43,44,69],
 [1,43,45,46],[1,43,45,47],[1,43,45,48],[1,43,45,49],
 [1,43,45,55],[1,43,45,58],[1,43,45,59],[1,43,45,60],
 [1,43,45,61],[1,43,45,62],[1,43,45,66],[1,43,45,67],
 [1,43,45,68],[1,43,45,69],[1,43,46,47],[1,43,46,48],
 [1,43,46,49],[1,43,46,55],[1,43,46,58],[1,43,46,59],
 [1,43,46,60],[1,43,46,61],[1,43,46,62],[1,43,46,66],
 [1,43,46,67],[1,43,46,68],[1,43,46,69],[1,43,47,48],
 [1,43,47,49],[1,43,47,55],[1,43,47,58],[1,43,47,59],
 [1,43,47,60],[1,43,47,61],[1,43,47,62],[1,43,47,66],
 [1,43,47,67],[1,43,47,68],[1,43,47,69],[1,43,48,49],
 [1,43,48,55],[1,43,48,58],[1,43,48,59],[1,43,48,60],
 [1,43,48,61],[1,43,48,62],[1,43,48,66],[1,43,48,67],
 [1,43,48,68],[1,43,48,69],[1,43,49,55],[1,43,49,58],
 [1,43,49,59],[1,43,49,60],[1,43,49,61],[1,43,49,62],
 [1,43,49,66],[1,43,49,67],[1,43,49,68],[1,43,49,69],
 [1,43,55,58],[1,43,55,59],[1,43,55,60],[1,43,55,61],
 [1,43,55,62],[1,43,55,66],[1,43,55,67],[1,43,55,68],
 [1,43,55,69],[1,43,58,59],[1,43,58,60],[1,43,58,61],
 [1,43,58,62],[1,43,58,66],[1,43,58,67],[1,43,58,68],
 [1,43,58,69],[1,43,59,60],[1,43,59,61],[1,43,59,62],
 [1,43,59,66],[1,43,59,67],[1,43,59,68],[1,43,59,69],
 [1,43,60,61],[1,43,60,62],[1,43,60,66],[1,43,60,67],
 [1,43,60,68],[1,43,60,69],[1,43,61,62],[1,43,61,66],
 [1,43,61,67],[1,43,61,68],[1,43,61,69],[1,43,62,66],
 [1,43,62,67],[1,43,62,68],[1,43,62,69],[1,43,66,67],
 [1,43,66,68],[1,43,66,69],[1,43,67,68],[1,43,67,69],
 [1,43,68,69],[1,44,45,46],[1,44,45,47],[1,44,45,48],
 [1,44,45,49],[1,44,45,55],[1,44,45,58],[1,44,45,59],
 [1,44,45,60],[1,44,45,61],[1,44,45,62],[1,44,45,66],
 [1,44,45,67],[1,44,45,68],[1,44,45,69],[1,44,46,47],
 [1,44,46,48],[1,44,46,49],[1,44,46,55],[1,44,46,58],
 [1,44,46,59],[1,44,46,60],[1,44,46,61],[1,44,46,62],
 [1,44,46,66],[1,44,46,67],[1,44,46,68],[1,44,46,69],
 [1,44,47,48],[1,44,47,49],[1,44,47,55],[1,44,47,58],
 [1,44,47,59],[1,44,47,60],[1,44,47,61],[1,44,47,62],
 [1,44,47,66],[1,44,47,67],[1,44,47,68],[1,44,47,69],
 [1,44,48,49],[1,44,48,55],[1,44,48,58],[1,44,48,59],
 [1,44,48,60],[1,44,48,61],[1,44,48,62],[1,44,48,66],
 [1,44,48,67],[1,44,48,68],[1,44,48,69],[1,44,49,55],
 [1,44,49,58],[1,44,49,59],[1,44,49,60],[1,44,49,61],
 [1,44,49,62],[1,44,49,66],[1,44,49,67],[1,44,49,68],
 [1,44,49,69],[1,44,55,58],[1,44,55,59],[1,44,55,60],
 [1,44,55,61],[1,44,55,62],[1,44,55,66],[1,44,55,67],
 [1,44,55,68],[1,44,55,69],[1,44,58,59],[1,44,58,60],
 [1,44,58,61],[1,44,58,62],[1,44,58,66],[1,44,58,67],
 [1,44,58,68],[1,44,58,69],[1,44,59,60],[1,44,59,61],
 [1,44,59,62],[1,44,59,66],[1,44,59,67],[1,44,59,68],
 [1,44,59,69],[1,44,60,61],[1,44,60,62],[1,44,60,66],
 [1,44,60,67],[1,44,60,68],[1,44,60,69],[1,44,61,62],
 [1,44,61,66],[1,44,61,67],[1,44,61,68],[1,44,61,69],
 [1,44,62,66],[1,44,62,67],[1,44,62,68],[1,44,62,69],
 [1,44,66,67],[1,44,66,68],[1,44,66,69],[1,44,67,68],
 [1,44,67,69],[1,44,68,69],[1,45,46,47],[1,45,46,48],
 [1,45,46,49],[1,45,46,55],[1,45,46,58],[1,45,46,59],
 [1,45,46,60],[1,45,46,61],[1,45,46,62],[1,45,46,66],
 [1,45,46,67],[1,45,46,68],[1,45,46,69],[1,45,47,48],
 [1,45,47,49],[1,45,47,55],[1,45,47,58],[1,45,47,59],
 [1,45,47,60],[1,45,47,61],[1,45,47,62],[1,45,47,66],
 [1,45,47,67],[1,45,47,68],[1,45,47,69],[1,45,48,49],
 [1,45,48,55],[1,45,48,58],[1,45,48,59],[1,45,48,60],
 [1,45,48,61],[1,45,48,62],[1,45,48,66],[1,45,48,67],
 [1,45,48,68],[1,45,48,69],[1,45,49,55],[1,45,49,58],
 [1,45,49,59],[1,45,49,60],[1,45,49,61],[1,45,49,62],
 [1,45,49,66],[1,45,49,67],[1,45,49,68],[1,45,49,69],
 [1,45,50,51],[1,45,50,55],[1,45,50,58],[1,45,50,60],
 [1,45,50,61],[1,45,50,62],[1,45,50,67],[1,45,50,68],
 [1,45,50,69],[1,45,51,55],[1,45,51,58],[1,45,51,60],
 [1,45,51,62],[1,45,51,67],[1,45,51,68],[1,45,51,69],
 [1,45,55,58],[1,45,55,59],[1,45,55,60],[1,45,55,61],
 [1,45,55,62],[1,45,55,66],[1,45,55,67],[1,45,55,68],
 [1,45,55,69],[1,45,58,59],[1,45,58,60],[1,45,58,61],
 [1,45,58,62],[1,45,58,66],[1,45,58,67],[1,45,58,68],
 [1,45,58,69],[1,45,59,60],[1,45,59,61],[1,45,59,62],
 [1,45,59,66],[1,45,59,67],[1,45,59,68],[1,45,59,69],
 [1,45,60,61],[1,45,60,62],[1,45,60,66],[1,45,60,67],
 [1,45,60,68],[1,45,60,69],[1,45,61,62],[1,45,61,66],
 [1,45,61,67],[1,45,61,68],[1,45,61,69],[1,45,62,66],
 [1,45,62,67],[1,45,62,68],[1,45,62,69],[1,45,66,67],
 [1,45,66,68],[1,45,66,69],[1,45,67,68],[1,45,67,69],
 [1,45,68,69],[1,46,47,48],[1,46,47,49],[1,46,47,55],
 [1,46,47,58],[1,46,47,59],[1,46,47,60],[1,46,47,61],
 [1,46,47,62],[1,46,47,66],[1,46,47,67],[1,46,47,68],
 [1,46,47,69],[1,46,48,49],[1,46,48,55],[1,46,48,58],
 [1,46,48,59],[1,46,48,60],[1,46,48,61],[1,46,48,62],
 [1,46,48,66],[1,46,48,67],[1,46,48,68],[1,46,48,69],
 [1,46,49,55],[1,46,49,58],[1,46,49,59],[1,46,49,60],
 [1,46,49,61],[1,46,49,62],[1,46,49,66],[1,46,49,67],
 [1,46,49,68],[1,46,49,69],[1,46,55,58],[1,46,55,59],
 [1,46,55,60],[1,46,55,61],[1,46,55,62],[1,46,55,66],
 [1,46,55,67],[1,46,55,68],[1,46,55,69],[1,46,58,59],
 [1,46,58,60],[1,46,58,61],[1,46,58,62],[1,46,58,66],
 [1,46,58,67],[1,46,58,68],[1,46,58,69],[1,46,59,60],
 [1,46,59,61],[1,46,59,62],[1,46,59,66],[1,46,59,67],
 [1,46,59,68],[1,46,59,69],[1,46,60,61],[1,46,60,62],
 [1,46,60,66],[1,46,60,67],[1,46,60,68],[1,46,60,69],
 [1,46,61,62],[1,46,61,66],[1,46,61,67],[1,46,61,68],
 [1,46,61,69],[1,46,62,66],[1,46,62,67],[1,46,62,68],
 [1,46,62,69],[1,46,66,67],[1,46,66,68],[1,46,66,69],
 [1,46,67,68],[1,46,67,69],[1,46,68,69],[1,47,48,49],
 [1,47,48,55],[1,47,48,58],[1,47,48,59],[1,47,48,60],
 [1,47,48,61],[1,47,48,62],[1,47,48,66],[1,47,48,67],
 [1,47,48,68],[1,47,48,69],[1,47,49,55],[1,47,49,58],
 [1,47,49,59],[1,47,49,60],[1,47,49,61],[1,47,49,62],
 [1,47,49,66],[1,47,49,67],[1,47,49,68],[1,47,49,69],
 [1,47,55,58],[1,47,55,59],[1,47,55,60],[1,47,55,61],
 [1,47,55,62],[1,47,55,66],[1,47,55,67],[1,47,55,68],
 [1,47,55,69],[1,47,58,59],[1,47,58,60],[1,47,58,61],
 [1,47,58,62],[1,47,58,66],[1,47,58,67],[1,47,58,68],
 [1,47,58,69],[1,47,59,60],[1,47,59,61],[1,47,59,62],
 [1,47,59,66],[1,47,59,67],[1,47,59,68],[1,47,59,69],
 [1,47,60,61],[1,47,60,62],[1,47,60,66],[1,47,60,67],
 [1,47,60,68],[1,47,60,69],[1,47,61,62],[1,47,61,66],
 [1,47,61,67],[1,47,61,68],[1,47,61,69],[1,47,62,66],
 [1,47,62,67],[1,47,62,68],[1,47,62,69],[1,47,66,67],
 [1,47,66,68],[1,47,66,69],[1,47,67,68],[1,47,67,69],
 [1,47,68,69],[1,48,49,55],[1,48,49,58],[1,48,49,59],
 [1,48,49,60],[1,48,49,61],[1,48,49,62],[1,48,49,66],
 [1,48,49,67],[1,48,49,68],[1,48,49,69],[1,48,55,58],
 [1,48,55,59],[1,48,55,60],[1,48,55,61],[1,48,55,62],
 [1,48,55,66],[1,48,55,67],[1,48,55,68],[1,48,55,69],
 [1,48,58,59],[1,48,58,60],[1,48,58,61],[1,48,58,62],
 [1,48,58,66],[1,48,58,67],[1,48,58,68],[1,48,58,69],
 [1,48,59,60],[1,48,59,61],[1,48,59,62],[1,48,59,66],
 [1,48,59,67],[1,48,59,68],[1,48,59,69],[1,48,60,61],
 [1,48,60,62],[1,48,60,66],[1,48,60,67],[1,48,60,68],
 [1,48,60,69],[1,48,61,62],[1,48,61,66],[1,48,61,67],
 [1,48,61,68],[1,48,61,69],[1,48,62,66],[1,48,62,67],
 [1,48,62,68],[1,48,62,69],[1,48,66,67],[1,48,66,68],
 [1,48,66,69],[1,48,67,68],[1,48,67,69],[1,48,68,69],
 [1,49,55,58],[1,49,55,59],[1,49,55,60],[1,49,55,61],
 [1,49,55,62],[1,49,55,66],[1,49,55,67],[1,49,55,68],
 [1,49,55,69],[1,49,58,59],[1,49,58,60],[1,49,58,61],
 [1,49,58,62],[1,49,58,66],[1,49,58,67],[1,49,58,68],
 [1,49,58,69],[1,49,59,60],[1,49,59,61],[1,49,59,62],
 [1,49,59,66],[1,49,59,67],[1,49,59,68],[1,49,59,69],
 [1,49,60,61],[1,49,60,62],[1,49,60,66],[1,49,60,67],
 [1,49,60,68],[1,49,60,69],[1,49,61,62],[1,49,61,66],
 [1,49,61,67],[1,49,61,68],[1,49,61,69],[1,49,62,66],
 [1,49,62,67],[1,49,62,68],[1,49,62,69],[1,49,66,67],
 [1,49,66,68],[1,49,66,69],[1,49,67,68],[1,49,67,69],
 [1,49,68,69],[1,50,51,55],[1,50,51,58],[1,50,51,60],
 [1,50,51,61],[1,50,51,62],[1,50,51,67],[1,50,51,68],
 [1,50,51,69],[1,50,55,58],[1,50,55,60],[1,50,55,61],
 [1,50,55,62],[1,50,55,67],[1,50,55,68],[1,50,55,69],
 [1,50,58,60],[1,50,58,61],[1,50,58,62],[1,50,58,67],
 [1,50,58,68],[1,50,58,69],[1,50,60,61],[1,50,60,62],
 [1,50,60,67],[1,50,60,68],[1,50,60,69],[1,50,61,62],
 [1,50,61,67],[1,50,61,68],[1,50,61,69],[1,50,62,67],
 [1,50,62,68],[1,50,62,69],[1,50,67,68],[1,50,67,69],
 [1,50,68,69],[1,51,55,58],[1,51,55,60],[1,51,55,61],
 [1,51,55,62],[1,51,55,67],[1,51,55,68],[1,51,55,69],
 [1,51,58,60],[1,51,58,61],[1,51,58,62],[1,51,58,67],
 [1,51,58,68],[1,51,58,69],[1,51,60,61],[1,51,60,62],
 [1,51,60,67],[1,51,60,68],[1,51,60,69],[1,51,61,62],
 [1,51,61,67],[1,51,61,68],[1,51,61,69],[1,51,62,67],
 [1,51,62,68],[1,51,62,69],[1,51,67,68],[1,51,67,69],
 [1,51,68,69],[1,55,58,59],[1,55,58,60],[1,55,58,61],
 [1,55,58,62],[1,55,58,66],[1,55,58,67],[1,55,58,68],
 [1,55,58,69],[1,55,59,60],[1,55,59,61],[1,55,59,62],
 [1,55,59,66],[1,55,59,67],[1,55,59,68],[1,55,59,69],
 [1,55,60,61],[1,55,60,62],[1,55,60,66],[1,55,60,67],
 [1,55,60,68],[1,55,60,69],[1,55,61,62],[1,55,61,66],
 [1,55,61,67],[1,55,61,68],[1,55,61,69],[1,55,62,66],
 [1,55,62,67],[1,55,62,68],[1,55,62,69],[1,55,66,67],
 [1,55,66,68],[1,55,66,69],[1,55,67,68],[1,55,67,69],
 [1,55,68,69],[1,58,59,60],[1,58,59,61],[1,58,59,62],
 [1,58,59,66],[1,58,59,67],[1,58,59,68],[1,58,59,69],
 [1,58,60,61],[1,58,60,62],[1,58,60,66],[1,58,60,67],
 [1,58,60,68],[1,58,60,69],[1,58,61,62],[1,58,61,66],
 [1,58,61,67],[1,58,61,68],[1,58,61,69],[1,58,62,66],
 [1,58,62,67],[1,58,62,68],[1,58,62,69],[1,58,66,67],
 [1,58,66,68],[1,58,66,69],[1,58,67,68],[1,58,67,69],
 [1,58,68,69],[1,59,60,61],[1,59,60,62],[1,59,60,66],
 [1,59,60,67],[1,59,60,68],[1,59,60,69],[1,59,61,62],
 [1,59,61,66],[1,59,61,67],[1,59,61,68],[1,59,61,69],
 [1,59,62,66],[1,59,62,67],[1,59,62,68],[1,59,62,69],
 [1,59,66,67],[1,59,66,68],[1,59,66,69],[1,59,67,68],
 [1,59,67,69],[1,59,68,69],[1,60,61,62],[1,60,61,66],
 [1,60,61,67],[1,60,61,68],[1,60,61,69],[1,60,62,66],
 [1,60,62,67],[1,60,62,68],[1,60,62,69],[1,60,66,67],
 [1,60,66,68],[1,60,66,69],[1,60,67,68],[1,60,67,69],
 [1,60,68,69],[1,61,62,66],[1,61,62,67],[1,61,62,68],
 [1,61,62,69],[1,61,66,67],[1,61,66,68],[1,61,66,69],
 [1,61,67,68],[1,61,67,69],[1,61,68,69],[1,62,66,67],
 [1,62,66,68],[1,62,66,69],[1,62,67,68],[1,62,67,69],
 [1,62,68,69],[1,66,67,68],[1,66,67,69],[1,66,68,69],
 [1,67,68,69],[2,4,8,26],[2,4,8,27],[2,4,8,41],
 [2,4,8,44],[2,4,8,49],[2,4,8,59],[2,4,8,60],
 [2,4,8,61],[2,4,8,68],[2,4,9,15],[2,4,9,20],
 [2,4,9,22],[2,4,9,24],[2,4,9,26],[2,4,9,41],
 [2,4,9,44],[2,4,9,47],[2,4,9,48],[2,4,9,49],
 [2,4,9,59],[2,4,9,61],[2,4,9,68],[2,4,10,26],
 [2,4,10,41],[2,4,10,48],[2,4,10,59],[2,4,15,20],
 [2,4,15,22],[2,4,15,24],[2,4,15,26],[2,4,15,41],
 [2,4,15,44],[2,4,15,47],[2,4,15,49],[2,4,15,59],
 [2,4,15,61],[2,4,15,68],[2,4,20,22],[2,4,20,24],
 [2,4,20,26],[2,4,20,41],[2,4,20,44],[2,4,20,47],
 [2,4,20,49],[2,4,20,59],[2,4,20,61],[2,4,20,68],
 [2,4,22,24],[2,4,22,26],[2,4,22,41],[2,4,22,44],
 [2,4,22,47],[2,4,22,49],[2,4,22,59],[2,4,22,61],
 [2,4,22,68],[2,4,24,26],[2,4,24,41],[2,4,24,44],
 [2,4,24,47],[2,4,24,48],[2,4,24,49],[2,4,24,59],
 [2,4,24,61],[2,4,24,68],[2,4,26,41],[2,4,26,44],
 [2,4,26,47],[2,4,26,49],[2,4,26,59],[2,4,26,60],
 [2,4,26,61],[2,4,26,68],[2,4,27,41],[2,4,27,47],
 [2,4,27,48],[2,4,27,60],[2,4,27,61],[2,4,41,43],
 [2,4,41,44],[2,4,41,47],[2,4,41,48],[2,4,41,49],
 [2,4,41,50],[2,4,41,59],[2,4,41,60],[2,4,41,61],
 [2,4,41,68],[2,4,43,48],[2,4,43,68],[2,4,44,47],
 [2,4,44,49],[2,4,44,50],[2,4,44,59],[2,4,44,61],
 [2,4,44,68],[2,4,47,49],[2,4,47,50],[2,4,47,59],
 [2,4,47,61],[2,4,47,68],[2,4,48,50],[2,4,48,60],
 [2,4,48,68],[2,4,49,59],[2,4,49,60],[2,4,49,61],
 [2,4,49,68],[2,4,50,59],[2,4,50,61],[2,4,59,60],
 [2,4,59,61],[2,4,59,68],[2,4,61,68],[2,8,9,15],
 [2,8,9,24],[2,8,9,26],[2,8,9,44],[2,8,9,51],
 [2,8,9,59],[2,8,9,61],[2,8,9,68],[2,8,10,25],
 [2,8,10,26],[2,8,10,37],[2,8,10,41],[2,8,10,46],
 [2,8,10,59],[2,8,10,63],[2,8,12,15],[2,8,12,24],
 [2,8,12,25],[2,8,12,26],[2,8,12,44],[2,8,12,49],
 [2,8,12,60],[2,8,12,61],[2,8,12,63],[2,8,12,64],
 [2,8,15,22],[2,8,15,24],[2,8,15,26],[2,8,15,41],
 [2,8,15,44],[2,8,15,49],[2,8,15,51],[2,8,15,52],
 [2,8,15,55],[2,8,15,59],[2,8,15,61],[2,8,15,63],
 [2,8,15,64],[2,8,15,66],[2,8,15,68],[2,8,15,69],
 [2,8,22,24],[2,8,22,25],[2,8,22,26],[2,8,22,44],
 [2,8,22,61],[2,8,22,63],[2,8,22,64],[2,8,22,66],
 [2,8,24,25],[2,8,24,26],[2,8,24,41],[2,8,24,44],
 [2,8,24,45],[2,8,24,49],[2,8,24,51],[2,8,24,52],
 [2,8,24,53],[2,8,24,55],[2,8,24,59],[2,8,24,60],
 [2,8,24,61],[2,8,24,63],[2,8,24,64],[2,8,24,68],
 [2,8,24,69],[2,8,25,27],[2,8,25,35],[2,8,25,37],
 [2,8,25,43],[2,8,25,45],[2,8,25,46],[2,8,25,49],
 [2,8,25,50],[2,8,25,51],[2,8,25,52],[2,8,25,53],
 [2,8,25,60],[2,8,25,61],[2,8,25,64],[2,8,25,66],
 [2,8,25,68],[2,8,25,69],[2,8,26,27],[2,8,26,35],
 [2,8,26,37],[2,8,26,41],[2,8,26,44],[2,8,26,46],
 [2,8,26,49],[2,8,26,50],[2,8,26,51],[2,8,26,52],
 [2,8,26,53],[2,8,26,55],[2,8,26,59],[2,8,26,60],
 [2,8,26,61],[2,8,26,63],[2,8,26,64],[2,8,26,66],
 [2,8,26,68],[2,8,26,69],[2,8,27,45],[2,8,27,52],
 [2,8,27,53],[2,8,27,55],[2,8,27,60],[2,8,27,61],
 [2,8,27,64],[2,8,27,68],[2,8,27,69],[2,8,35,45],
 [2,8,35,63],[2,8,35,68],[2,8,37,43],[2,8,37,44],
 [2,8,37,46],[2,8,37,59],[2,8,37,60],[2,8,37,61],
 [2,8,37,63],[2,8,41,43],[2,8,41,44],[2,8,41,59],
 [2,8,41,60],[2,8,41,61],[2,8,43,45],[2,8,43,52],
 [2,8,43,53],[2,8,43,55],[2,8,43,59],[2,8,43,60],
 [2,8,43,64],[2,8,43,68],[2,8,43,69],[2,8,44,46],
 [2,8,44,49],[2,8,44,50],[2,8,44,51],[2,8,44,53],
 [2,8,44,55],[2,8,44,59],[2,8,44,61],[2,8,44,64],
 [2,8,44,68],[2,8,44,69],[2,8,45,46],[2,8,45,49],
 [2,8,45,52],[2,8,45,53],[2,8,45,55],[2,8,45,59],
 [2,8,45,60],[2,8,45,61],[2,8,45,63],[2,8,45,68],
 [2,8,45,69],[2,8,46,53],[2,8,46,59],[2,8,46,61],
 [2,8,46,63],[2,8,46,68],[2,8,46,69],[2,8,49,53],
 [2,8,49,55],[2,8,49,60],[2,8,49,61],[2,8,49,63],
 [2,8,49,64],[2,8,49,69],[2,8,50,52],[2,8,50,53],
 [2,8,50,55],[2,8,50,59],[2,8,50,60],[2,8,50,61],
 [2,8,50,64],[2,8,50,68],[2,8,50,69],[2,8,51,53],
 [2,8,51,60],[2,8,51,61],[2,8,51,68],[2,8,51,69],
 [2,8,52,63],[2,8,52,69],[2,8,53,63],[2,8,53,64],
 [2,8,55,60],[2,8,55,61],[2,8,55,66],[2,8,55,69],
 [2,8,59,60],[2,8,59,61],[2,8,59,63],[2,8,59,64],
 [2,8,59,68],[2,8,60,63],[2,8,60,66],[2,8,61,63],
 [2,8,61,64],[2,8,61,66],[2,8,61,68],[2,8,63,64],
 [2,8,63,66],[2,8,63,68],[2,8,63,69],[2,8,64,69],
 [2,9,15,20],[2,9,15,22],[2,9,15,24],[2,9,15,26],
 [2,9,15,41],[2,9,15,44],[2,9,15,47],[2,9,15,49],
 [2,9,15,51],[2,9,15,59],[2,9,15,61],[2,9,15,68],
 [2,9,20,22],[2,9,20,24],[2,9,20,26],[2,9,20,41],
 [2,9,20,44],[2,9,20,47],[2,9,20,49],[2,9,20,59],
 [2,9,20,61],[2,9,20,68],[2,9,22,24],[2,9,22,26],
 [2,9,22,41],[2,9,22,44],[2,9,22,47],[2,9,22,49],
 [2,9,22,59],[2,9,22,61],[2,9,22,68],[2,9,24,26],
 [2,9,24,41],[2,9,24,44],[2,9,24,47],[2,9,24,48],
 [2,9,24,49],[2,9,24,51],[2,9,24,59],[2,9,24,61],
 [2,9,24,68],[2,9,26,41],[2,9,26,44],[2,9,26,47],
 [2,9,26,49],[2,9,26,51],[2,9,26,59],[2,9,26,61],
 [2,9,26,68],[2,9,41,44],[2,9,41,47],[2,9,41,48],
 [2,9,41,49],[2,9,41,59],[2,9,41,61],[2,9,41,68],
 [2,9,44,47],[2,9,44,48],[2,9,44,49],[2,9,44,51],
 [2,9,44,59],[2,9,44,61],[2,9,44,68],[2,9,47,49],
 [2,9,47,59],[2,9,47,61],[2,9,47,68],[2,9,48,49],
 [2,9,48,51],[2,9,48,61],[2,9,48,68],[2,9,49,59],
 [2,9,49,61],[2,9,49,68],[2,9,51,61],[2,9,51,68],
 [2,9,59,61],[2,9,59,68],[2,9,61,68],[2,10,16,25],
 [2,10,16,26],[2,10,16,46],[2,10,16,48],[2,10,16,66],
 [2,10,25,37],[2,10,25,46],[2,10,25,65],[2,10,25,66],
 [2,10,26,36],[2,10,26,37],[2,10,26,41],[2,10,26,46],
 [2,10,26,47],[2,10,26,55],[2,10,26,63],[2,10,26,65],
 [2,10,26,66],[2,10,36,37],[2,10,36,48],[2,10,36,55],
 [2,10,36,65],[2,10,36,66],[2,10,37,46],[2,10,37,47],
 [2,10,37,48],[2,10,37,59],[2,10,37,63],[2,10,41,47],
 [2,10,41,48],[2,10,41,59],[2,10,46,48],[2,10,46,59],
 [2,10,46,63],[2,10,46,65],[2,10,47,55],[2,10,47,59],
 [2,10,47,66],[2,10,48,55],[2,10,48,63],[2,10,48,66],
 [2,10,55,66],[2,10,63,65],[2,10,63,66],[2,12,15,16],
 [2,12,15,21],[2,12,15,22],[2,12,15,24],[2,12,15,26],
 [2,12,15,36],[2,12,15,44],[2,12,15,47],[2,12,15,49],
 [2,12,15,51],[2,12,15,61],[2,12,15,63],[2,12,15,64],
 [2,12,16,21],[2,12,16,22],[2,12,16,24],[2,12,16,25],
 [2,12,16,26],[2,12,16,48],[2,12,16,49],[2,12,16,51],
 [2,12,16,61],[2,12,21,24],[2,12,21,25],[2,12,21,48],
 [2,12,21,49],[2,12,21,51],[2,12,21,60],[2,12,21,61],
 [2,12,21,64],[2,12,22,24],[2,12,22,25],[2,12,22,26],
 [2,12,22,36],[2,12,22,44],[2,12,22,61],[2,12,22,64],
 [2,12,24,25],[2,12,24,26],[2,12,24,36],[2,12,24,44],
 [2,12,24,47],[2,12,24,48],[2,12,24,49],[2,12,24,51],
 [2,12,24,60],[2,12,24,61],[2,12,24,63],[2,12,24,64],
 [2,12,25,49],[2,12,25,51],[2,12,25,60],[2,12,25,61],
 [2,12,25,64],[2,12,26,36],[2,12,26,44],[2,12,26,47],
 [2,12,26,49],[2,12,26,51],[2,12,26,60],[2,12,26,61],
 [2,12,26,63],[2,12,26,64],[2,12,36,48],[2,12,36,60],
 [2,12,36,61],[2,12,36,64],[2,12,44,47],[2,12,44,49],
 [2,12,44,61],[2,12,44,64],[2,12,47,60],[2,12,47,61],
 [2,12,47,64],[2,12,48,49],[2,12,48,51],[2,12,48,60],
 [2,12,48,61],[2,12,48,63],[2,12,48,64],[2,12,49,60],
 [2,12,49,61],[2,12,49,63],[2,12,49,64],[2,12,51,60],
 [2,12,51,61],[2,12,60,63],[2,12,61,63],[2,12,61,64],
 [2,12,63,64],[2,15,16,20],[2,15,16,21],[2,15,16,22],
 [2,15,16,24],[2,15,16,26],[2,15,16,49],[2,15,16,51],
 [2,15,16,55],[2,15,16,61],[2,15,16,66],[2,15,16,68],
 [2,15,16,69],[2,15,20,22],[2,15,20,24],[2,15,20,26],
 [2,15,20,36],[2,15,20,41],[2,15,20,44],[2,15,20,47],
 [2,15,20,49],[2,15,20,52],[2,15,20,55],[2,15,20,59],
 [2,15,20,61],[2,15,20,66],[2,15,20,68],[2,15,20,69],
 [2,15,21,22],[2,15,21,24],[2,15,21,49],[2,15,21,55],
 [2,15,21,59],[2,15,21,61],[2,15,21,65],[2,15,21,66],
 [2,15,21,68],[2,15,21,69],[2,15,22,24],[2,15,22,26],
 [2,15,22,36],[2,15,22,41],[2,15,22,44],[2,15,22,47],
 [2,15,22,49],[2,15,22,55],[2,15,22,59],[2,15,22,61],
 [2,15,22,63],[2,15,22,64],[2,15,22,65],[2,15,22,66],
 [2,15,22,68],[2,15,24,26],[2,15,24,36],[2,15,24,41],
 [2,15,24,44],[2,15,24,47],[2,15,24,49],[2,15,24,51],
 [2,15,24,52],[2,15,24,55],[2,15,24,59],[2,15,24,61],
 [2,15,24,63],[2,15,24,64],[2,15,24,65],[2,15,24,68],
 [2,15,24,69],[2,15,26,36],[2,15,26,41],[2,15,26,44],
 [2,15,26,47],[2,15,26,49],[2,15,26,51],[2,15,26,52],
 [2,15,26,55],[2,15,26,59],[2,15,26,61],[2,15,26,63],
 [2,15,26,64],[2,15,26,65],[2,15,26,66],[2,15,26,68],
 [2,15,26,69],[2,15,36,49],[2,15,36,51],[2,15,36,52],
 [2,15,36,55],[2,15,36,59],[2,15,36,61],[2,15,36,64],
 [2,15,36,65],[2,15,36,66],[2,15,36,68],[2,15,36,69],
 [2,15,41,44],[2,15,41,47],[2,15,41,49],[2,15,41,59],
 [2,15,41,61],[2,15,41,68],[2,15,44,47],[2,15,44,49],
 [2,15,44,51],[2,15,44,52],[2,15,44,55],[2,15,44,59],
 [2,15,44,61],[2,15,44,64],[2,15,44,68],[2,15,44,69],
 [2,15,47,49],[2,15,47,51],[2,15,47,52],[2,15,47,55],
 [2,15,47,59],[2,15,47,61],[2,15,47,64],[2,15,47,66],
 [2,15,47,68],[2,15,47,69],[2,15,49,52],[2,15,49,55],
 [2,15,49,59],[2,15,49,61],[2,15,49,63],[2,15,49,64],
 [2,15,49,65],[2,15,49,68],[2,15,49,69],[2,15,51,52],
 [2,15,51,61],[2,15,51,65],[2,15,51,68],[2,15,51,69],
 [2,15,52,69],[2,15,55,61],[2,15,55,66],[2,15,55,69],
 [2,15,59,61],[2,15,59,63],[2,15,59,64],[2,15,59,68],
 [2,15,61,63],[2,15,61,64],[2,15,61,65],[2,15,61,66],
 [2,15,61,68],[2,15,63,64],[2,15,63,65],[2,15,63,66],
 [2,15,63,68],[2,15,63,69],[2,15,64,65],[2,16,20,22],
 [2,16,20,24],[2,16,20,25],[2,16,20,26],[2,16,20,45],
 [2,16,20,49],[2,16,20,55],[2,16,20,60],[2,16,20,61],
 [2,16,20,66],[2,16,20,68],[2,16,20,69],[2,16,21,22],
 [2,16,21,24],[2,16,21,25],[2,16,21,27],[2,16,21,46],
 [2,16,21,48],[2,16,21,49],[2,16,21,50],[2,16,21,51],
 [2,16,21,52],[2,16,21,53],[2,16,21,55],[2,16,21,60],
 [2,16,21,61],[2,16,21,66],[2,16,21,68],[2,16,21,69],
 [2,16,22,24],[2,16,22,25],[2,16,22,26],[2,16,22,49],
 [2,16,22,55],[2,16,22,61],[2,16,22,66],[2,16,22,68],
 [2,16,24,25],[2,16,24,26],[2,16,24,45],[2,16,24,48],
 [2,16,24,49],[2,16,24,51],[2,16,24,53],[2,16,24,55],
 [2,16,24,60],[2,16,24,61],[2,16,24,68],[2,16,24,69],
 [2,16,25,27],[2,16,25,35],[2,16,25,43],[2,16,25,45],
 [2,16,25,46],[2,16,25,49],[2,16,25,50],[2,16,25,51],
 [2,16,25,52],[2,16,25,53],[2,16,25,55],[2,16,25,60],
 [2,16,25,61],[2,16,25,66],[2,16,25,68],[2,16,25,69],
 [2,16,26,27],[2,16,26,35],[2,16,26,46],[2,16,26,49],
 [2,16,26,50],[2,16,26,51],[2,16,26,52],[2,16,26,53],
 [2,16,26,55],[2,16,26,60],[2,16,26,61],[2,16,26,66],
 [2,16,26,68],[2,16,26,69],[2,16,27,45],[2,16,27,48],
 [2,16,27,52],[2,16,27,53],[2,16,27,55],[2,16,27,60],
 [2,16,27,61],[2,16,27,68],[2,16,27,69],[2,16,35,45],
 [2,16,35,48],[2,16,35,60],[2,16,35,68],[2,16,43,45],
 [2,16,43,46],[2,16,43,48],[2,16,43,53],[2,16,43,55],
 [2,16,43,60],[2,16,43,68],[2,16,43,69],[2,16,45,46],
 [2,16,45,48],[2,16,45,49],[2,16,45,52],[2,16,45,53],
 [2,16,45,55],[2,16,45,60],[2,16,45,61],[2,16,45,68],
 [2,16,45,69],[2,16,46,48],[2,16,46,52],[2,16,46,55],
 [2,16,46,60],[2,16,46,61],[2,16,46,66],[2,16,46,68],
 [2,16,46,69],[2,16,48,49],[2,16,48,50],[2,16,48,51],
 [2,16,48,52],[2,16,48,53],[2,16,48,55],[2,16,48,60],
 [2,16,48,61],[2,16,48,66],[2,16,48,68],[2,16,48,69],
 [2,16,49,52],[2,16,49,55],[2,16,49,60],[2,16,49,61],
 [2,16,49,68],[2,16,49,69],[2,16,50,52],[2,16,50,53],
 [2,16,50,61],[2,16,50,68],[2,16,50,69],[2,16,51,52],
 [2,16,51,53],[2,16,51,60],[2,16,51,61],[2,16,51,68],
 [2,16,52,69],[2,16,55,60],[2,16,55,61],[2,16,55,66],
 [2,16,55,69],[2,16,60,66],[2,16,61,66],[2,16,61,68],
 [2,20,22,24],[2,20,22,25],[2,20,22,26],[2,20,22,41],
 [2,20,22,44],[2,20,22,47],[2,20,22,49],[2,20,22,55],
 [2,20,22,59],[2,20,22,61],[2,20,22,66],[2,20,22,68],
 [2,20,24,25],[2,20,24,26],[2,20,24,36],[2,20,24,41],
 [2,20,24,44],[2,20,24,45],[2,20,24,47],[2,20,24,49],
 [2,20,24,52],[2,20,24,55],[2,20,24,59],[2,20,24,60],
 [2,20,24,61],[2,20,24,68],[2,20,24,69],[2,20,25,45],
 [2,20,25,49],[2,20,25,55],[2,20,25,60],[2,20,25,61],
 [2,20,25,66],[2,20,25,68],[2,20,25,69],[2,20,26,36],
 [2,20,26,41],[2,20,26,44],[2,20,26,47],[2,20,26,49],
 [2,20,26,52],[2,20,26,55],[2,20,26,59],[2,20,26,60],
 [2,20,26,61],[2,20,26,66],[2,20,26,68],[2,20,26,69],
 [2,20,36,45],[2,20,36,49],[2,20,36,52],[2,20,36,55],
 [2,20,36,60],[2,20,36,61],[2,20,36,66],[2,20,36,68],
 [2,20,36,69],[2,20,41,44],[2,20,41,47],[2,20,41,49],
 [2,20,41,59],[2,20,41,60],[2,20,41,61],[2,20,41,68],
 [2,20,44,47],[2,20,44,49],[2,20,44,52],[2,20,44,55],
 [2,20,44,59],[2,20,44,61],[2,20,44,68],[2,20,44,69],
 [2,20,45,49],[2,20,45,52],[2,20,45,55],[2,20,45,59],
 [2,20,45,60],[2,20,45,61],[2,20,45,68],[2,20,45,69],
 [2,20,47,49],[2,20,47,55],[2,20,47,59],[2,20,47,60],
 [2,20,47,61],[2,20,47,66],[2,20,47,68],[2,20,47,69],
 [2,20,49,55],[2,20,49,59],[2,20,49,60],[2,20,49,61],
 [2,20,49,68],[2,20,49,69],[2,20,52,69],[2,20,55,60],
 [2,20,55,61],[2,20,55,66],[2,20,55,69],[2,20,59,60],
 [2,20,59,61],[2,20,59,68],[2,20,60,66],[2,20,61,66],
 [2,20,61,68],[2,21,22,24],[2,21,22,25],[2,21,22,49],
 [2,21,22,55],[2,21,22,59],[2,21,22,61],[2,21,22,64],
 [2,21,22,66],[2,21,22,68],[2,21,24,25],[2,21,24,48],
 [2,21,24,49],[2,21,24,51],[2,21,24,53],[2,21,24,55],
 [2,21,24,59],[2,21,24,60],[2,21,24,61],[2,21,24,65],
 [2,21,24,68],[2,21,24,69],[2,21,25,27],[2,21,25,37],
 [2,21,25,46],[2,21,25,49],[2,21,25,50],[2,21,25,51],
 [2,21,25,52],[2,21,25,53],[2,21,25,55],[2,21,25,60],
 [2,21,25,61],[2,21,25,64],[2,21,25,65],[2,21,25,66],
 [2,21,25,68],[2,21,25,69],[2,21,27,48],[2,21,27,53],
 [2,21,27,55],[2,21,27,60],[2,21,27,61],[2,21,27,65],
 [2,21,27,68],[2,21,27,69],[2,21,37,46],[2,21,37,48],
 [2,21,37,59],[2,21,37,60],[2,21,37,61],[2,21,37,68],
 [2,21,46,48],[2,21,46,52],[2,21,46,53],[2,21,46,55],
 [2,21,46,59],[2,21,46,60],[2,21,46,61],[2,21,46,65],
 [2,21,46,66],[2,21,46,68],[2,21,46,69],[2,21,48,49],
 [2,21,48,50],[2,21,48,51],[2,21,48,52],[2,21,48,53],
 [2,21,48,55],[2,21,48,60],[2,21,48,61],[2,21,48,64],
 [2,21,48,66],[2,21,48,68],[2,21,48,69],[2,21,49,52],
 [2,21,49,55],[2,21,49,59],[2,21,49,60],[2,21,49,61],
 [2,21,49,64],[2,21,49,68],[2,21,49,69],[2,21,50,52],
 [2,21,50,53],[2,21,50,59],[2,21,50,61],[2,21,50,65],
 [2,21,50,68],[2,21,50,69],[2,21,51,52],[2,21,51,53],
 [2,21,51,60],[2,21,51,68],[2,21,52,69],[2,21,53,64],
 [2,21,55,60],[2,21,55,61],[2,21,55,66],[2,21,55,69],
 [2,21,59,60],[2,21,59,61],[2,21,59,64],[2,21,59,68],
 [2,21,60,65],[2,21,60,66],[2,21,61,64],[2,21,61,65],
 [2,21,61,66],[2,21,61,68],[2,21,64,65],[2,21,64,66],
 [2,21,64,69],[2,22,24,25],[2,22,24,26],[2,22,24,36],
 [2,22,24,41],[2,22,24,44],[2,22,24,47],[2,22,24,49],
 [2,22,24,55],[2,22,24,59],[2,22,24,61],[2,22,24,63],
 [2,22,24,64],[2,22,24,65],[2,22,24,68],[2,22,25,49],
 [2,22,25,55],[2,22,25,61],[2,22,25,64],[2,22,25,66],
 [2,22,25,68],[2,22,26,36],[2,22,26,41],[2,22,26,44],
 [2,22,26,47],[2,22,26,49],[2,22,26,55],[2,22,26,59],
 [2,22,26,61],[2,22,26,63],[2,22,26,64],[2,22,26,65],
 [2,22,26,66],[2,22,26,68],[2,22,36,49],[2,22,36,61],
 [2,22,36,64],[2,22,36,66],[2,22,36,68],[2,22,41,44],
 [2,22,41,47],[2,22,41,49],[2,22,41,59],[2,22,41,61],
 [2,22,41,68],[2,22,44,47],[2,22,44,49],[2,22,44,55],
 [2,22,44,59],[2,22,44,61],[2,22,44,64],[2,22,44,68],
 [2,22,47,49],[2,22,47,55],[2,22,47,59],[2,22,47,61],
 [2,22,47,64],[2,22,47,66],[2,22,47,68],[2,22,49,55],
 [2,22,49,59],[2,22,49,61],[2,22,49,63],[2,22,49,64],
 [2,22,49,65],[2,22,49,68],[2,22,55,61],[2,22,55,66],
 [2,22,59,61],[2,22,59,63],[2,22,59,64],[2,22,59,68],
 [2,22,61,63],[2,22,61,64],[2,22,61,65],[2,22,61,66],
 [2,22,61,68],[2,22,63,64],[2,22,63,65],[2,22,63,68],
 [2,22,64,65],[2,22,64,66],[2,24,25,45],[2,24,25,49],
 [2,24,25,51],[2,24,25,53],[2,24,25,55],[2,24,25,60],
 [2,24,25,61],[2,24,25,65],[2,24,25,68],[2,24,25,69],
 [2,24,26,36],[2,24,26,41],[2,24,26,44],[2,24,26,47],
 [2,24,26,49],[2,24,26,51],[2,24,26,52],[2,24,26,55],
 [2,24,26,59],[2,24,26,60],[2,24,26,61],[2,24,26,63],
 [2,24,26,64],[2,24,26,65],[2,24,26,68],[2,24,26,69],
 [2,24,36,45],[2,24,36,48],[2,24,36,49],[2,24,36,51],
 [2,24,36,52],[2,24,36,53],[2,24,36,55],[2,24,36,59],
 [2,24,36,60],[2,24,36,61],[2,24,36,64],[2,24,36,65],
 [2,24,36,68],[2,24,36,69],[2,24,41,44],[2,24,41,47],
 [2,24,41,48],[2,24,41,49],[2,24,41,59],[2,24,41,60],
 [2,24,41,61],[2,24,41,68],[2,24,44,47],[2,24,44,48],
 [2,24,44,49],[2,24,44,51],[2,24,44,52],[2,24,44,53],
 [2,24,44,55],[2,24,44,59],[2,24,44,61],[2,24,44,64],
 [2,24,44,68],[2,24,44,69],[2,24,45,48],[2,24,45,49],
 [2,24,45,53],[2,24,45,55],[2,24,45,59],[2,24,45,60],
 [2,24,45,61],[2,24,45,68],[2,24,45,69],[2,24,47,49],
 [2,24,47,51],[2,24,47,52],[2,24,47,53],[2,24,47,55],
 [2,24,47,59],[2,24,47,60],[2,24,47,61],[2,24,47,64],
 [2,24,47,68],[2,24,47,69],[2,24,48,49],[2,24,48,51],
 [2,24,48,52],[2,24,48,53],[2,24,48,55],[2,24,48,60],
 [2,24,48,61],[2,24,48,63],[2,24,48,64],[2,24,48,68],
 [2,24,48,69],[2,24,49,52],[2,24,49,53],[2,24,49,55],
 [2,24,49,59],[2,24,49,60],[2,24,49,61],[2,24,49,63],
 [2,24,49,64],[2,24,49,65],[2,24,49,68],[2,24,49,69],
 [2,24,51,52],[2,24,51,53],[2,24,51,60],[2,24,51,61],
 [2,24,51,65],[2,24,51,68],[2,24,51,69],[2,24,52,69],
 [2,24,53,63],[2,24,53,64],[2,24,55,60],[2,24,55,61],
 [2,24,55,69],[2,24,59,60],[2,24,59,61],[2,24,59,63],
 [2,24,59,64],[2,24,59,68],[2,24,60,65],[2,24,61,63],
 [2,24,61,64],[2,24,61,65],[2,24,61,68],[2,24,63,64],
 [2,24,63,65],[2,24,63,68],[2,24,63,69],[2,24,64,65],
 [2,24,64,69],[2,25,27,45],[2,25,27,53],[2,25,27,55],
 [2,25,27,60],[2,25,27,61],[2,25,27,64],[2,25,27,65],
 [2,25,27,68],[2,25,27,69],[2,25,35,45],[2,25,35,55],
 [2,25,35,60],[2,25,35,65],[2,25,35,68],[2,25,37,43],
 [2,25,37,46],[2,25,37,60],[2,25,37,61],[2,25,37,68],
 [2,25,43,45],[2,25,43,46],[2,25,43,52],[2,25,43,53],
 [2,25,43,55],[2,25,43,60],[2,25,43,64],[2,25,43,65],
 [2,25,43,68],[2,25,43,69],[2,25,45,46],[2,25,45,49],
 [2,25,45,52],[2,25,45,53],[2,25,45,55],[2,25,45,60],
 [2,25,45,61],[2,25,45,68],[2,25,45,69],[2,25,46,52],
 [2,25,46,53],[2,25,46,55],[2,25,46,60],[2,25,46,61],
 [2,25,46,65],[2,25,46,66],[2,25,46,68],[2,25,46,69],
 [2,25,49,52],[2,25,49,53],[2,25,49,55],[2,25,49,60],
 [2,25,49,61],[2,25,49,64],[2,25,49,65],[2,25,49,68],
 [2,25,49,69],[2,25,50,52],[2,25,50,53],[2,25,50,61],
 [2,25,50,65],[2,25,50,69],[2,25,51,52],[2,25,51,53],
 [2,25,51,60],[2,25,51,61],[2,25,51,65],[2,25,51,68],
 [2,25,51,69],[2,25,52,69],[2,25,53,64],[2,25,55,60],
 [2,25,55,61],[2,25,55,66],[2,25,55,69],[2,25,60,65],
 [2,25,60,66],[2,25,61,64],[2,25,61,65],[2,25,61,66],
 [2,25,61,68],[2,25,64,65],[2,25,64,66],[2,25,64,69],
 [2,26,27,36],[2,26,27,41],[2,26,27,47],[2,26,27,52],
 [2,26,27,55],[2,26,27,60],[2,26,27,61],[2,26,27,64],
 [2,26,27,68],[2,26,27,69],[2,26,35,36],[2,26,35,47],
 [2,26,35,55],[2,26,35,60],[2,26,35,63],[2,26,35,65],
 [2,26,35,68],[2,26,36,37],[2,26,36,46],[2,26,36,49],
 [2,26,36,50],[2,26,36,51],[2,26,36,52],[2,26,36,53],
 [2,26,36,55],[2,26,36,59],[2,26,36,60],[2,26,36,61],
 [2,26,36,64],[2,26,36,65],[2,26,36,66],[2,26,36,68],
 [2,26,36,69],[2,26,37,44],[2,26,37,46],[2,26,37,47],
 [2,26,37,59],[2,26,37,60],[2,26,37,61],[2,26,37,68],
 [2,26,41,44],[2,26,41,47],[2,26,41,49],[2,26,41,50],
 [2,26,41,59],[2,26,41,60],[2,26,41,61],[2,26,41,68],
 [2,26,44,46],[2,26,44,47],[2,26,44,49],[2,26,44,50],
 [2,26,44,51],[2,26,44,52],[2,26,44,53],[2,26,44,55],
 [2,26,44,59],[2,26,44,61],[2,26,44,64],[2,26,44,68],
 [2,26,44,69],[2,26,46,47],[2,26,46,52],[2,26,46,53],
 [2,26,46,55],[2,26,46,59],[2,26,46,60],[2,26,46,61],
 [2,26,46,63],[2,26,46,65],[2,26,46,66],[2,26,46,68],
 [2,26,46,69],[2,26,47,49],[2,26,47,50],[2,26,47,51],
 [2,26,47,52],[2,26,47,53],[2,26,47,55],[2,26,47,59],
 [2,26,47,60],[2,26,47,61],[2,26,47,64],[2,26,47,66],
 [2,26,47,68],[2,26,47,69],[2,26,49,52],[2,26,49,53],
 [2,26,49,55],[2,26,49,59],[2,26,49,60],[2,26,49,61],
 [2,26,49,63],[2,26,49,64],[2,26,49,65],[2,26,49,68],
 [2,26,49,69],[2,26,50,52],[2,26,50,53],[2,26,50,60],
 [2,26,50,64],[2,26,50,68],[2,26,51,52],[2,26,51,53],
 [2,26,51,60],[2,26,51,61],[2,26,51,65],[2,26,51,68],
 [2,26,51,69],[2,26,52,63],[2,26,52,69],[2,26,53,64],
 [2,26,55,60],[2,26,55,61],[2,26,55,66],[2,26,55,69],
 [2,26,59,60],[2,26,59,61],[2,26,59,63],[2,26,59,64],
 [2,26,59,68],[2,26,60,63],[2,26,60,65],[2,26,60,66],
 [2,26,61,63],[2,26,61,64],[2,26,61,65],[2,26,61,66],
 [2,26,61,68],[2,26,63,64],[2,26,63,65],[2,26,63,68],
 [2,26,64,65],[2,26,64,66],[2,26,64,69],[2,27,36,45],
 [2,27,36,48],[2,27,36,52],[2,27,36,53],[2,27,36,55],
 [2,27,36,60],[2,27,36,61],[2,27,36,64],[2,27,36,65],
 [2,27,36,68],[2,27,36,69],[2,27,41,47],[2,27,41,48],
 [2,27,41,60],[2,27,41,61],[2,27,41,68],[2,27,45,48],
 [2,27,45,53],[2,27,45,55],[2,27,45,60],[2,27,45,61],
 [2,27,45,68],[2,27,45,69],[2,27,47,52],[2,27,47,53],
 [2,27,47,55],[2,27,47,60],[2,27,47,61],[2,27,47,64],
 [2,27,47,68],[2,27,47,69],[2,27,48,52],[2,27,48,53],
 [2,27,48,55],[2,27,48,60],[2,27,48,61],[2,27,48,64],
 [2,27,48,68],[2,27,48,69],[2,27,52,69],[2,27,53,64],
 [2,27,55,60],[2,27,55,61],[2,27,55,69],[2,27,60,65],
 [2,27,61,64],[2,27,61,65],[2,27,61,68],[2,27,64,65],
 [2,27,64,69],[2,34,36,43],[2,34,36,46],[2,34,36,52],
 [2,34,36,69],[2,34,43,46],[2,34,43,52],[2,34,43,55],
 [2,34,43,69],[2,34,46,52],[2,34,46,55],[2,34,46,63],
 [2,34,46,69],[2,34,52,63],[2,34,52,69],[2,34,55,69],
 [2,34,63,69],[2,35,36,45],[2,35,36,48],[2,35,36,55],
 [2,35,36,60],[2,35,36,65],[2,35,36,68],[2,35,45,48],
 [2,35,45,60],[2,35,45,63],[2,35,45,68],[2,35,47,68],
 [2,35,48,55],[2,35,48,60],[2,35,48,63],[2,35,48,68],
 [2,35,55,60],[2,35,60,63],[2,35,60,65],[2,35,63,65],
 [2,35,63,68],[2,36,37,43],[2,36,37,46],[2,36,37,48],
 [2,36,37,60],[2,36,37,61],[2,36,37,68],[2,36,43,45],
 [2,36,43,46],[2,36,43,48],[2,36,43,52],[2,36,43,53],
 [2,36,43,59],[2,36,43,68],[2,36,43,69],[2,36,45,46],
 [2,36,45,48],[2,36,45,49],[2,36,45,52],[2,36,45,53],
 [2,36,45,59],[2,36,45,60],[2,36,45,61],[2,36,45,68],
 [2,36,45,69],[2,36,46,48],[2,36,46,52],[2,36,46,53],
 [2,36,46,59],[2,36,46,61],[2,36,46,65],[2,36,46,66],
 [2,36,46,68],[2,36,46,69],[2,36,48,49],[2,36,48,50],
 [2,36,48,51],[2,36,48,52],[2,36,48,53],[2,36,48,55],
 [2,36,48,60],[2,36,48,61],[2,36,48,64],[2,36,48,68],
 [2,36,48,69],[2,36,49,52],[2,36,49,53],[2,36,49,55],
 [2,36,49,59],[2,36,49,60],[2,36,49,61],[2,36,49,64],
 [2,36,49,65],[2,36,49,69],[2,36,50,52],[2,36,50,53],
 [2,36,50,55],[2,36,50,59],[2,36,50,60],[2,36,50,61],
 [2,36,50,64],[2,36,50,65],[2,36,50,68],[2,36,50,69],
 [2,36,51,53],[2,36,51,61],[2,36,51,65],[2,36,51,69],
 [2,36,52,69],[2,36,53,64],[2,36,55,60],[2,36,55,61],
 [2,36,55,66],[2,36,55,69],[2,36,59,60],[2,36,59,61],
 [2,36,59,64],[2,36,60,65],[2,36,60,66],[2,36,61,64],
 [2,36,61,65],[2,36,61,66],[2,36,61,68],[2,36,64,65],
 [2,36,64,69],[2,37,43,46],[2,37,43,47],[2,37,43,48],
 [2,37,43,59],[2,37,43,60],[2,37,43,68],[2,37,44,46],
 [2,37,44,47],[2,37,44,48],[2,37,44,59],[2,37,44,61],
 [2,37,46,47],[2,37,46,48],[2,37,46,59],[2,37,46,60],
 [2,37,46,61],[2,37,46,63],[2,37,46,68],[2,37,47,59],
 [2,37,47,60],[2,37,47,61],[2,37,48,60],[2,37,48,61],
 [2,37,48,63],[2,37,48,68],[2,37,59,60],[2,37,59,61],
 [2,37,59,63],[2,37,60,63],[2,37,61,63],[2,37,61,68],
 [2,37,63,68],[2,41,43,47],[2,41,43,48],[2,41,43,59],
 [2,41,43,60],[2,41,43,68],[2,41,44,47],[2,41,44,48],
 [2,41,44,49],[2,41,44,50],[2,41,44,59],[2,41,44,61],
 [2,41,44,68],[2,41,47,49],[2,41,47,50],[2,41,47,59],
 [2,41,47,60],[2,41,47,61],[2,41,47,68],[2,41,48,49],
 [2,41,48,50],[2,41,48,60],[2,41,48,61],[2,41,48,68],
 [2,41,49,59],[2,41,49,60],[2,41,49,61],[2,41,49,68],
 [2,41,50,59],[2,41,50,60],[2,41,50,61],[2,41,50,68],
 [2,41,59,60],[2,41,59,61],[2,41,59,68],[2,41,61,68],
 [2,43,45,46],[2,43,45,48],[2,43,45,55],[2,43,45,59],
 [2,43,45,60],[2,43,45,68],[2,43,45,69],[2,43,46,47],
 [2,43,46,48],[2,43,46,52],[2,43,46,53],[2,43,46,55],
 [2,43,46,59],[2,43,46,60],[2,43,46,65],[2,43,46,68],
 [2,43,46,69],[2,43,47,53],[2,43,47,55],[2,43,47,59],
 [2,43,47,60],[2,43,47,68],[2,43,47,69],[2,43,48,52],
 [2,43,48,55],[2,43,48,60],[2,43,48,64],[2,43,48,68],
 [2,43,48,69],[2,43,52,69],[2,43,53,64],[2,43,55,60],
 [2,43,55,69],[2,43,59,60],[2,43,59,68],[2,43,60,65],
 [2,43,64,65],[2,43,64,69],[2,44,46,47],[2,44,46,48],
 [2,44,46,53],[2,44,46,55],[2,44,46,59],[2,44,46,61],
 [2,44,46,68],[2,44,46,69],[2,44,47,49],[2,44,47,50],
 [2,44,47,53],[2,44,47,55],[2,44,47,59],[2,44,47,61],
 [2,44,47,64],[2,44,47,68],[2,44,47,69],[2,44,48,49],
 [2,44,48,51],[2,44,48,52],[2,44,48,53],[2,44,48,55],
 [2,44,48,61],[2,44,48,64],[2,44,48,68],[2,44,48,69],
 [2,44,49,52],[2,44,49,53],[2,44,49,55],[2,44,49,59],
 [2,44,49,61],[2,44,49,64],[2,44,49,68],[2,44,49,69],
 [2,44,50,52],[2,44,50,53],[2,44,50,55],[2,44,50,59],
 [2,44,50,61],[2,44,50,64],[2,44,50,68],[2,44,50,69],
 [2,44,51,53],[2,44,51,61],[2,44,51,68],[2,44,51,69],
 [2,44,52,69],[2,44,55,61],[2,44,55,69],[2,44,59,61],
 [2,44,59,64],[2,44,59,68],[2,44,61,64],[2,44,61,68],
 [2,45,46,48],[2,45,46,52],[2,45,46,55],[2,45,46,59],
 [2,45,46,60],[2,45,46,61],[2,45,46,63],[2,45,46,68],
 [2,45,46,69],[2,45,48,49],[2,45,48,52],[2,45,48,53],
 [2,45,48,55],[2,45,48,60],[2,45,48,61],[2,45,48,63],
 [2,45,48,68],[2,45,48,69],[2,45,49,52],[2,45,49,55],
 [2,45,49,59],[2,45,49,60],[2,45,49,61],[2,45,49,63],
 [2,45,49,68],[2,45,49,69],[2,45,52,69],[2,45,53,63],
 [2,45,55,60],[2,45,55,61],[2,45,55,69],[2,45,59,60],
 [2,45,59,61],[2,45,59,68],[2,45,60,63],[2,45,61,63],
 [2,45,61,68],[2,45,63,68],[2,45,63,69],[2,46,47,53],
 [2,46,47,55],[2,46,47,59],[2,46,47,60],[2,46,47,61],
 [2,46,47,66],[2,46,47,68],[2,46,47,69],[2,46,48,52],
 [2,46,48,55],[2,46,48,60],[2,46,48,61],[2,46,48,63],
 [2,46,48,66],[2,46,48,68],[2,46,48,69],[2,46,52,63],
 [2,46,52,69],[2,46,53,63],[2,46,55,60],[2,46,55,61],
 [2,46,55,66],[2,46,55,69],[2,46,59,60],[2,46,59,61],
 [2,46,59,63],[2,46,59,68],[2,46,60,63],[2,46,60,65],
 [2,46,60,66],[2,46,61,63],[2,46,61,66],[2,46,61,68],
 [2,46,63,65],[2,46,63,66],[2,46,63,68],[2,46,63,69],
 [2,47,49,53],[2,47,49,55],[2,47,49,59],[2,47,49,60],
 [2,47,49,61],[2,47,49,64],[2,47,49,68],[2,47,49,69],
 [2,47,50,52],[2,47,50,53],[2,47,50,55],[2,47,50,59],
 [2,47,50,60],[2,47,50,61],[2,47,50,64],[2,47,50,68],
 [2,47,50,69],[2,47,51,52],[2,47,51,53],[2,47,51,61],
 [2,47,51,69],[2,47,52,69],[2,47,53,64],[2,47,55,60],
 [2,47,55,61],[2,47,55,66],[2,47,55,69],[2,47,59,60],
 [2,47,59,61],[2,47,59,64],[2,47,59,68],[2,47,60,66],
 [2,47,61,64],[2,47,61,66],[2,47,61,68],[2,47,64,69],
 [2,48,49,52],[2,48,49,55],[2,48,49,60],[2,48,49,61],
 [2,48,49,63],[2,48,49,64],[2,48,49,68],[2,48,49,69],
 [2,48,50,52],[2,48,50,53],[2,48,50,60],[2,48,50,61],
 [2,48,50,64],[2,48,50,68],[2,48,50,69],[2,48,51,52],
 [2,48,51,53],[2,48,51,60],[2,48,51,68],[2,48,52,63],
 [2,48,52,69],[2,48,53,63],[2,48,53,64],[2,48,55,60],
 [2,48,55,61],[2,48,55,66],[2,48,55,69],[2,48,60,63],
 [2,48,60,66],[2,48,61,63],[2,48,61,66],[2,48,61,68],
 [2,48,63,64],[2,48,63,66],[2,48,63,68],[2,48,63,69],
 [2,48,64,66],[2,48,64,69],[2,49,52,63],[2,49,52,69],
 [2,49,53,63],[2,49,53,64],[2,49,55,60],[2,49,55,61],
 [2,49,55,69],[2,49,59,60],[2,49,59,61],[2,49,59,63],
 [2,49,59,64],[2,49,59,68],[2,49,60,63],[2,49,60,65],
 [2,49,61,63],[2,49,61,64],[2,49,61,65],[2,49,61,68],
 [2,49,63,64],[2,49,63,65],[2,49,63,68],[2,49,63,69],
 [2,49,64,65],[2,49,64,69],[2,50,52,69],[2,50,53,64],
 [2,50,55,60],[2,50,55,61],[2,50,55,69],[2,50,59,60],
 [2,50,59,61],[2,50,59,64],[2,50,59,68],[2,50,60,65],
 [2,50,61,64],[2,50,61,65],[2,50,61,68],[2,50,64,65],
 [2,50,64,69],[2,51,52,69],[2,51,60,65],[2,51,61,65],
 [2,51,61,68],[2,52,63,69],[2,53,63,64],[2,55,60,66],
 [2,55,61,66],[2,59,60,63],[2,59,61,63],[2,59,61,64],
 [2,59,61,68],[2,59,63,64],[2,59,63,68],[2,60,63,65],
 [2,60,63,66],[2,61,63,64],[2,61,63,65],[2,61,63,66],
 [2,61,63,68],[2,61,64,65],[2,63,64,65],[2,63,64,66],
 [2,63,64,69],[3,5,6,9],[3,5,6,15],[3,5,6,20],
 [3,5,6,22],[3,5,6,24],[3,5,6,26],[3,5,6,41],
 [3,5,6,44],[3,5,6,47],[3,5,6,49],[3,5,6,59],
 [3,5,6,61],[3,5,6,68],[3,5,9,15],[3,5,9,20],
 [3,5,9,22],[3,5,9,24],[3,5,9,26],[3,5,9,41],
 [3,5,9,44],[3,5,9,47],[3,5,9,49],[3,5,9,59],
 [3,5,9,61],[3,5,9,68],[3,5,12,15],[3,5,12,22],
 [3,5,12,24],[3,5,12,26],[3,5,12,44],[3,5,12,47],
 [3,5,12,61],[3,5,15,18],[3,5,15,20],[3,5,15,22],
 [3,5,15,24],[3,5,15,26],[3,5,15,27],[3,5,15,37],
 [3,5,15,41],[3,5,15,44],[3,5,15,47],[3,5,15,49],
 [3,5,15,53],[3,5,15,57],[3,5,15,59],[3,5,15,61],
 [3,5,15,62],[3,5,15,68],[3,5,15,69],[3,5,18,22],
 [3,5,18,24],[3,5,18,26],[3,5,18,41],[3,5,18,47],
 [3,5,18,50],[3,5,18,53],[3,5,18,57],[3,5,18,59],
 [3,5,18,61],[3,5,20,22],[3,5,20,24],[3,5,20,26],
 [3,5,20,41],[3,5,20,44],[3,5,20,47],[3,5,20,49],
 [3,5,20,59],[3,5,20,61],[3,5,20,68],[3,5,20,69],
 [3,5,22,24],[3,5,22,26],[3,5,22,27],[3,5,22,41],
 [3,5,22,44],[3,5,22,47],[3,5,22,49],[3,5,22,50],
 [3,5,22,59],[3,5,22,61],[3,5,22,68],[3,5,24,26],
 [3,5,24,27],[3,5,24,37],[3,5,24,41],[3,5,24,44],
 [3,5,24,47],[3,5,24,49],[3,5,24,53],[3,5,24,57],
 [3,5,24,59],[3,5,24,61],[3,5,24,62],[3,5,24,68],
 [3,5,24,69],[3,5,26,27],[3,5,26,37],[3,5,26,41],
 [3,5,26,44],[3,5,26,47],[3,5,26,49],[3,5,26,50],
 [3,5,26,53],[3,5,26,57],[3,5,26,59],[3,5,26,61],
 [3,5,26,62],[3,5,26,68],[3,5,26,69],[3,5,27,47],
 [3,5,27,53],[3,5,27,59],[3,5,27,61],[3,5,27,62],
 [3,5,27,69],[3,5,37,47],[3,5,37,61],[3,5,41,44],
 [3,5,41,47],[3,5,41,49],[3,5,41,59],[3,5,41,61],
 [3,5,41,68],[3,5,44,47],[3,5,44,49],[3,5,44,50],
 [3,5,44,57],[3,5,44,59],[3,5,44,61],[3,5,44,62],
 [3,5,44,68],[3,5,44,69],[3,5,47,49],[3,5,47,50],
 [3,5,47,53],[3,5,47,57],[3,5,47,59],[3,5,47,61],
 [3,5,47,62],[3,5,47,68],[3,5,47,69],[3,5,49,59],
 [3,5,49,61],[3,5,49,68],[3,5,50,53],[3,5,50,59],
 [3,5,50,61],[3,5,50,62],[3,5,50,69],[3,5,53,62],
 [3,5,57,61],[3,5,59,61],[3,5,59,62],[3,5,59,68],
 [3,5,61,62],[3,5,61,68],[3,5,61,69],[3,5,62,69],
 [3,6,9,15],[3,6,9,20],[3,6,9,22],[3,6,9,24],
 [3,6,9,26],[3,6,9,41],[3,6,9,44],[3,6,9,47],
 [3,6,9,49],[3,6,9,59],[3,6,9,61],[3,6,9,68],
 [3,6,10,11],[3,6,10,25],[3,6,10,26],[3,6,10,44],
 [3,6,10,49],[3,6,10,56],[3,6,10,59],[3,6,10,61],
 [3,6,10,67],[3,6,11,17],[3,6,11,24],[3,6,11,25],
 [3,6,11,49],[3,6,11,60],[3,6,11,61],[3,6,15,17],
 [3,6,15,20],[3,6,15,22],[3,6,15,24],[3,6,15,25],
 [3,6,15,26],[3,6,15,36],[3,6,15,41],[3,6,15,44],
 [3,6,15,47],[3,6,15,49],[3,6,15,52],[3,6,15,56],
 [3,6,15,58],[3,6,15,59],[3,6,15,60],[3,6,15,61],
 [3,6,15,67],[3,6,15,68],[3,6,16,22],[3,6,16,25],
 [3,6,16,26],[3,6,16,49],[3,6,16,52],[3,6,16,56],
 [3,6,16,60],[3,6,16,67],[3,6,17,20],[3,6,17,24],
 [3,6,17,26],[3,6,17,39],[3,6,17,49],[3,6,17,56],
 [3,6,17,58],[3,6,17,61],[3,6,20,22],[3,6,20,24],
 [3,6,20,25],[3,6,20,26],[3,6,20,41],[3,6,20,44],
 [3,6,20,47],[3,6,20,49],[3,6,20,52],[3,6,20,59],
 [3,6,20,61],[3,6,20,68],[3,6,22,24],[3,6,22,25],
 [3,6,22,26],[3,6,22,39],[3,6,22,41],[3,6,22,44],
 [3,6,22,47],[3,6,22,49],[3,6,22,56],[3,6,22,58],
 [3,6,22,59],[3,6,22,60],[3,6,22,61],[3,6,22,68],
 [3,6,24,25],[3,6,24,26],[3,6,24,36],[3,6,24,41],
 [3,6,24,44],[3,6,24,47],[3,6,24,49],[3,6,24,52],
 [3,6,24,56],[3,6,24,59],[3,6,24,60],[3,6,24,61],
 [3,6,24,67],[3,6,24,68],[3,6,25,26],[3,6,25,39],
 [3,6,25,49],[3,6,25,58],[3,6,25,59],[3,6,25,60],
 [3,6,25,61],[3,6,25,67],[3,6,26,36],[3,6,26,39],
 [3,6,26,41],[3,6,26,44],[3,6,26,47],[3,6,26,49],
 [3,6,26,52],[3,6,26,56],[3,6,26,58],[3,6,26,59],
 [3,6,26,60],[3,6,26,61],[3,6,26,67],[3,6,26,68],
 [3,6,36,49],[3,6,36,61],[3,6,39,49],[3,6,39,58],
 [3,6,39,60],[3,6,39,67],[3,6,41,44],[3,6,41,47],
 [3,6,41,49],[3,6,41,59],[3,6,41,60],[3,6,41,61],
 [3,6,41,68],[3,6,44,47],[3,6,44,49],[3,6,44,56],
 [3,6,44,59],[3,6,44,60],[3,6,44,61],[3,6,44,67],
 [3,6,44,68],[3,6,47,49],[3,6,47,59],[3,6,47,61],
 [3,6,47,68],[3,6,49,52],[3,6,49,56],[3,6,49,58],
 [3,6,49,59],[3,6,49,60],[3,6,49,61],[3,6,49,67],
 [3,6,49,68],[3,6,52,61],[3,6,56,61],[3,6,58,60],
 [3,6,58,61],[3,6,58,67],[3,6,59,60],[3,6,59,61],
 [3,6,59,68],[3,6,60,61],[3,6,60,67],[3,6,61,67],
 [3,6,61,68],[3,9,11,17],[3,9,11,18],[3,9,11,24],
 [3,9,11,25],[3,9,11,27],[3,9,11,41],[3,9,11,49],
 [3,9,11,53],[3,9,11,60],[3,9,11,62],[3,9,11,68],
 [3,9,15,17],[3,9,15,18],[3,9,15,20],[3,9,15,22],
 [3,9,15,24],[3,9,15,25],[3,9,15,26],[3,9,15,27],
 [3,9,15,36],[3,9,15,37],[3,9,15,41],[3,9,15,44],
 [3,9,15,47],[3,9,15,49],[3,9,15,56],[3,9,15,57],
 [3,9,15,59],[3,9,15,60],[3,9,15,61],[3,9,15,62],
 [3,9,15,67],[3,9,15,68],[3,9,15,69],[3,9,16,22],
 [3,9,16,24],[3,9,16,25],[3,9,16,26],[3,9,16,27],
 [3,9,16,37],[3,9,16,49],[3,9,16,60],[3,9,16,62],
 [3,9,16,67],[3,9,16,68],[3,9,16,69],[3,9,17,18],
 [3,9,17,20],[3,9,17,22],[3,9,17,24],[3,9,17,26],
 [3,9,17,49],[3,9,17,53],[3,9,17,56],[3,9,17,57],
 [3,9,17,61],[3,9,17,68],[3,9,18,22],[3,9,18,24],
 [3,9,18,26],[3,9,18,41],[3,9,18,47],[3,9,18,53],
 [3,9,18,56],[3,9,18,57],[3,9,18,59],[3,9,18,61],
 [3,9,18,68],[3,9,20,22],[3,9,20,24],[3,9,20,25],
 [3,9,20,26],[3,9,20,41],[3,9,20,44],[3,9,20,47],
 [3,9,20,49],[3,9,20,59],[3,9,20,60],[3,9,20,61],
 [3,9,20,68],[3,9,20,69],[3,9,22,24],[3,9,22,25],
 [3,9,22,26],[3,9,22,27],[3,9,22,36],[3,9,22,41],
 [3,9,22,44],[3,9,22,47],[3,9,22,49],[3,9,22,56],
 [3,9,22,59],[3,9,22,60],[3,9,22,61],[3,9,22,62],
 [3,9,22,68],[3,9,24,25],[3,9,24,26],[3,9,24,27],
 [3,9,24,36],[3,9,24,37],[3,9,24,41],[3,9,24,44],
 [3,9,24,47],[3,9,24,49],[3,9,24,53],[3,9,24,56],
 [3,9,24,57],[3,9,24,59],[3,9,24,60],[3,9,24,61],
 [3,9,24,62],[3,9,24,67],[3,9,24,68],[3,9,24,69],
 [3,9,25,26],[3,9,25,27],[3,9,25,37],[3,9,25,49],
 [3,9,25,53],[3,9,25,59],[3,9,25,60],[3,9,25,61],
 [3,9,25,62],[3,9,25,67],[3,9,25,68],[3,9,25,69],
 [3,9,26,27],[3,9,26,36],[3,9,26,37],[3,9,26,41],
 [3,9,26,44],[3,9,26,47],[3,9,26,49],[3,9,26,56],
 [3,9,26,57],[3,9,26,59],[3,9,26,60],[3,9,26,61],
 [3,9,26,62],[3,9,26,67],[3,9,26,68],[3,9,26,69],
 [3,9,27,36],[3,9,27,41],[3,9,27,44],[3,9,27,47],
 [3,9,27,53],[3,9,27,59],[3,9,27,60],[3,9,27,61],
 [3,9,27,62],[3,9,27,67],[3,9,27,68],[3,9,27,69],
 [3,9,36,37],[3,9,36,61],[3,9,36,62],[3,9,36,68],
 [3,9,37,60],[3,9,37,61],[3,9,37,68],[3,9,41,44],
 [3,9,41,47],[3,9,41,49],[3,9,41,56],[3,9,41,59],
 [3,9,41,60],[3,9,41,61],[3,9,41,68],[3,9,41,69],
 [3,9,44,47],[3,9,44,49],[3,9,44,53],[3,9,44,56],
 [3,9,44,57],[3,9,44,59],[3,9,44,60],[3,9,44,61],
 [3,9,44,62],[3,9,44,67],[3,9,44,68],[3,9,44,69],
 [3,9,47,49],[3,9,47,53],[3,9,47,57],[3,9,47,59],
 [3,9,47,61],[3,9,47,62],[3,9,47,68],[3,9,47,69],
 [3,9,49,56],[3,9,49,59],[3,9,49,60],[3,9,49,61],
 [3,9,49,67],[3,9,49,68],[3,9,53,60],[3,9,53,62],
 [3,9,53,68],[3,9,56,57],[3,9,56,59],[3,9,56,61],
 [3,9,56,68],[3,9,57,59],[3,9,57,61],[3,9,57,68],
 [3,9,59,60],[3,9,59,61],[3,9,59,62],[3,9,59,67],
 [3,9,59,68],[3,9,60,61],[3,9,60,62],[3,9,60,67],
 [3,9,60,68],[3,9,60,69],[3,9,61,62],[3,9,61,67],
 [3,9,61,68],[3,9,61,69],[3,9,62,67],[3,9,62,68],
 [3,9,62,69],[3,9,67,68],[3,9,67,69],[3,9,68,69],
 [3,10,11,12],[3,10,11,18],[3,10,11,25],[3,10,11,27],
 [3,10,11,37],[3,10,11,49],[3,10,11,57],[3,10,11,61],
 [3,10,11,62],[3,10,11,68],[3,10,11,69],[3,10,12,16],
 [3,10,12,25],[3,10,12,26],[3,10,12,44],[3,10,12,53],
 [3,10,12,56],[3,10,12,61],[3,10,12,62],[3,10,12,67],
 [3,10,12,69],[3,10,16,25],[3,10,16,26],[3,10,16,27],
 [3,10,16,37],[3,10,16,49],[3,10,16,57],[3,10,16,62],
 [3,10,16,67],[3,10,16,69],[3,10,18,25],[3,10,18,26],
 [3,10,18,53],[3,10,18,56],[3,10,18,61],[3,10,18,67],
 [3,10,25,26],[3,10,25,27],[3,10,25,37],[3,10,25,49],
 [3,10,25,53],[3,10,25,57],[3,10,25,59],[3,10,25,61],
 [3,10,25,62],[3,10,25,67],[3,10,25,68],[3,10,25,69],
 [3,10,26,27],[3,10,26,37],[3,10,26,44],[3,10,26,49],
 [3,10,26,56],[3,10,26,57],[3,10,26,62],[3,10,26,67],
 [3,10,26,68],[3,10,26,69],[3,10,27,44],[3,10,27,53],
 [3,10,27,56],[3,10,27,59],[3,10,27,61],[3,10,27,67],
 [3,10,27,68],[3,10,27,69],[3,10,37,56],[3,10,37,59],
 [3,10,37,61],[3,10,37,67],[3,10,37,68],[3,10,44,49],
 [3,10,44,57],[3,10,44,59],[3,10,44,62],[3,10,44,68],
 [3,10,44,69],[3,10,49,56],[3,10,49,59],[3,10,49,61],
 [3,10,49,67],[3,10,49,68],[3,10,53,56],[3,10,53,62],
 [3,10,53,68],[3,10,56,57],[3,10,56,59],[3,10,56,62],
 [3,10,56,68],[3,10,56,69],[3,10,57,59],[3,10,57,61],
 [3,10,57,67],[3,10,57,68],[3,10,59,67],[3,10,59,68],
 [3,10,61,62],[3,10,61,68],[3,10,61,69],[3,10,62,67],
 [3,10,62,69],[3,10,67,68],[3,10,67,69],[3,10,68,69],
 [3,11,12,17],[3,11,12,24],[3,11,12,25],[3,11,12,43],
 [3,11,12,60],[3,11,12,61],[3,11,12,62],[3,11,12,69],
 [3,11,17,18],[3,11,17,24],[3,11,17,27],[3,11,17,37],
 [3,11,17,49],[3,11,17,50],[3,11,17,53],[3,11,17,57],
 [3,11,17,62],[3,11,17,68],[3,11,17,69],[3,11,18,24],
 [3,11,18,25],[3,11,18,41],[3,11,18,52],[3,11,18,53],
 [3,11,18,60],[3,11,18,61],[3,11,18,68],[3,11,24,25],
 [3,11,24,27],[3,11,24,37],[3,11,24,41],[3,11,24,49],
 [3,11,24,52],[3,11,24,53],[3,11,24,57],[3,11,24,60],
 [3,11,24,62],[3,11,24,68],[3,11,24,69],[3,11,25,27],
 [3,11,25,37],[3,11,25,43],[3,11,25,49],[3,11,25,50],
 [3,11,25,52],[3,11,25,53],[3,11,25,57],[3,11,25,60],
 [3,11,25,61],[3,11,25,62],[3,11,25,68],[3,11,25,69],
 [3,11,27,41],[3,11,27,52],[3,11,27,53],[3,11,27,60],
 [3,11,27,61],[3,11,27,62],[3,11,27,68],[3,11,37,60],
 [3,11,37,61],[3,11,41,49],[3,11,41,60],[3,11,41,61],
 [3,11,41,68],[3,11,43,52],[3,11,43,53],[3,11,43,60],
 [3,11,43,62],[3,11,43,68],[3,11,43,69],[3,11,49,52],
 [3,11,49,60],[3,11,49,61],[3,11,49,68],[3,11,50,52],
 [3,11,50,60],[3,11,50,62],[3,11,50,68],[3,11,52,62],
 [3,11,53,60],[3,11,53,62],[3,11,53,68],[3,11,57,60],
 [3,11,57,61],[3,11,60,62],[3,11,60,68],[3,11,60,69],
 [3,11,61,62],[3,11,61,68],[3,11,61,69],[3,11,62,68],
 [3,11,62,69],[3,12,15,17],[3,12,15,22],[3,12,15,24],
 [3,12,15,25],[3,12,15,26],[3,12,15,36],[3,12,15,44],
 [3,12,15,47],[3,12,15,56],[3,12,15,60],[3,12,15,61],
 [3,12,15,67],[3,12,16,22],[3,12,16,24],[3,12,16,25],
 [3,12,16,26],[3,12,16,56],[3,12,16,62],[3,12,16,67],
 [3,12,16,69],[3,12,17,24],[3,12,17,26],[3,12,17,53],
 [3,12,17,56],[3,12,17,58],[3,12,17,61],[3,12,17,69],
 [3,12,22,24],[3,12,22,25],[3,12,22,26],[3,12,22,36],
 [3,12,22,43],[3,12,22,44],[3,12,22,56],[3,12,22,58],
 [3,12,22,60],[3,12,22,61],[3,12,24,25],[3,12,24,26],
 [3,12,24,36],[3,12,24,44],[3,12,24,47],[3,12,24,53],
 [3,12,24,56],[3,12,24,60],[3,12,24,61],[3,12,24,67],
 [3,12,24,69],[3,12,25,26],[3,12,25,43],[3,12,25,53],
 [3,12,25,60],[3,12,25,61],[3,12,25,62],[3,12,25,67],
 [3,12,25,69],[3,12,26,36],[3,12,26,44],[3,12,26,47],
 [3,12,26,56],[3,12,26,58],[3,12,26,60],[3,12,26,61],
 [3,12,26,62],[3,12,26,67],[3,12,36,43],[3,12,36,61],
 [3,12,36,62],[3,12,43,44],[3,12,43,53],[3,12,43,56],
 [3,12,43,58],[3,12,43,60],[3,12,43,61],[3,12,43,67],
 [3,12,43,69],[3,12,44,47],[3,12,44,53],[3,12,44,58],
 [3,12,44,60],[3,12,44,61],[3,12,44,62],[3,12,44,67],
 [3,12,44,69],[3,12,47,53],[3,12,47,61],[3,12,47,62],
 [3,12,47,69],[3,12,53,60],[3,12,53,62],[3,12,56,61],
 [3,12,56,62],[3,12,58,60],[3,12,58,61],[3,12,58,62],
 [3,12,58,67],[3,12,60,61],[3,12,60,67],[3,12,60,69],
 [3,12,61,62],[3,12,61,67],[3,12,61,69],[3,12,62,67],
 [3,12,62,69],[3,15,17,18],[3,15,17,20],[3,15,17,22],
 [3,15,17,24],[3,15,17,26],[3,15,17,27],[3,15,17,37],
 [3,15,17,49],[3,15,17,53],[3,15,17,56],[3,15,17,57],
 [3,15,17,61],[3,15,17,62],[3,15,17,68],[3,15,17,69],
 [3,15,18,22],[3,15,18,24],[3,15,18,25],[3,15,18,26],
 [3,15,18,36],[3,15,18,41],[3,15,18,47],[3,15,18,52],
 [3,15,18,56],[3,15,18,57],[3,15,18,59],[3,15,18,60],
 [3,15,18,61],[3,15,18,67],[3,15,18,68],[3,15,20,22],
 [3,15,20,24],[3,15,20,25],[3,15,20,26],[3,15,20,41],
 [3,15,20,44],[3,15,20,47],[3,15,20,49],[3,15,20,52],
 [3,15,20,59],[3,15,20,60],[3,15,20,61],[3,15,20,68],
 [3,15,20,69],[3,15,22,24],[3,15,22,25],[3,15,22,26],
 [3,15,22,27],[3,15,22,36],[3,15,22,41],[3,15,22,44],
 [3,15,22,47],[3,15,22,49],[3,15,22,56],[3,15,22,58],
 [3,15,22,59],[3,15,22,60],[3,15,22,61],[3,15,22,62],
 [3,15,22,68],[3,15,24,25],[3,15,24,26],[3,15,24,27],
 [3,15,24,36],[3,15,24,37],[3,15,24,41],[3,15,24,44],
 [3,15,24,47],[3,15,24,49],[3,15,24,52],[3,15,24,56],
 [3,15,24,57],[3,15,24,59],[3,15,24,60],[3,15,24,61],
 [3,15,24,62],[3,15,24,67],[3,15,24,68],[3,15,24,69],
 [3,15,25,26],[3,15,25,27],[3,15,25,37],[3,15,25,49],
 [3,15,25,53],[3,15,25,57],[3,15,25,58],[3,15,25,59],
 [3,15,25,60],[3,15,25,61],[3,15,25,62],[3,15,25,67],
 [3,15,25,68],[3,15,25,69],[3,15,26,27],[3,15,26,36],
 [3,15,26,37],[3,15,26,41],[3,15,26,44],[3,15,26,47],
 [3,15,26,49],[3,15,26,52],[3,15,26,56],[3,15,26,57],
 [3,15,26,58],[3,15,26,59],[3,15,26,60],[3,15,26,61],
 [3,15,26,62],[3,15,26,67],[3,15,26,68],[3,15,26,69],
 [3,15,27,36],[3,15,27,41],[3,15,27,44],[3,15,27,47],
 [3,15,27,52],[3,15,27,56],[3,15,27,58],[3,15,27,59],
 [3,15,27,60],[3,15,27,61],[3,15,27,62],[3,15,27,67],
 [3,15,27,68],[3,15,27,69],[3,15,36,37],[3,15,36,49],
 [3,15,36,53],[3,15,36,57],[3,15,36,61],[3,15,36,62],
 [3,15,36,68],[3,15,36,69],[3,15,37,47],[3,15,37,52],
 [3,15,37,56],[3,15,37,59],[3,15,37,60],[3,15,37,61],
 [3,15,37,67],[3,15,37,68],[3,15,41,44],[3,15,41,47],
 [3,15,41,49],[3,15,41,56],[3,15,41,59],[3,15,41,60],
 [3,15,41,61],[3,15,41,68],[3,15,41,69],[3,15,44,47],
 [3,15,44,49],[3,15,44,52],[3,15,44,53],[3,15,44,56],
 [3,15,44,57],[3,15,44,58],[3,15,44,59],[3,15,44,60],
 [3,15,44,61],[3,15,44,62],[3,15,44,67],[3,15,44,68],
 [3,15,44,69],[3,15,47,49],[3,15,47,53],[3,15,47,57],
 [3,15,47,59],[3,15,47,61],[3,15,47,62],[3,15,47,68],
 [3,15,47,69],[3,15,49,52],[3,15,49,56],[3,15,49,58],
 [3,15,49,59],[3,15,49,60],[3,15,49,61],[3,15,49,67],
 [3,15,49,68],[3,15,52,53],[3,15,52,57],[3,15,52,61],
 [3,15,52,62],[3,15,52,67],[3,15,52,69],[3,15,53,56],
 [3,15,53,58],[3,15,53,60],[3,15,53,67],[3,15,53,68],
 [3,15,56,57],[3,15,56,59],[3,15,56,61],[3,15,56,62],
 [3,15,56,68],[3,15,56,69],[3,15,57,59],[3,15,57,60],
 [3,15,57,61],[3,15,57,67],[3,15,57,68],[3,15,58,60],
 [3,15,58,61],[3,15,58,62],[3,15,58,67],[3,15,58,68],
 [3,15,58,69],[3,15,59,60],[3,15,59,61],[3,15,59,62],
 [3,15,59,67],[3,15,59,68],[3,15,60,61],[3,15,60,62],
 [3,15,60,67],[3,15,60,68],[3,15,60,69],[3,15,61,62],
 [3,15,61,67],[3,15,61,68],[3,15,61,69],[3,15,62,67],
 [3,15,62,68],[3,15,62,69],[3,15,67,68],[3,15,67,69],
 [3,15,68,69],[3,16,22,24],[3,16,22,25],[3,16,22,26],
 [3,16,22,27],[3,16,22,43],[3,16,22,49],[3,16,22,50],
 [3,16,22,56],[3,16,22,60],[3,16,22,62],[3,16,22,68],
 [3,16,24,25],[3,16,24,26],[3,16,24,27],[3,16,24,37],
 [3,16,24,49],[3,16,24,60],[3,16,24,62],[3,16,24,67],
 [3,16,24,68],[3,16,24,69],[3,16,25,26],[3,16,25,27],
 [3,16,25,37],[3,16,25,43],[3,16,25,49],[3,16,25,50],
 [3,16,25,52],[3,16,25,57],[3,16,25,60],[3,16,25,62],
 [3,16,25,67],[3,16,25,68],[3,16,25,69],[3,16,26,27],
 [3,16,26,37],[3,16,26,49],[3,16,26,50],[3,16,26,52],
 [3,16,26,56],[3,16,26,57],[3,16,26,60],[3,16,26,62],
 [3,16,26,67],[3,16,26,68],[3,16,26,69],[3,16,27,52],
 [3,16,27,56],[3,16,27,60],[3,16,27,62],[3,16,27,67],
 [3,16,27,68],[3,16,27,69],[3,16,37,52],[3,16,37,56],
 [3,16,37,60],[3,16,37,67],[3,16,37,68],[3,16,43,56],
 [3,16,43,60],[3,16,43,62],[3,16,43,67],[3,16,43,68],
 [3,16,43,69],[3,16,49,52],[3,16,49,56],[3,16,49,60],
 [3,16,49,67],[3,16,49,68],[3,16,50,52],[3,16,50,62],
 [3,16,50,67],[3,16,50,68],[3,16,50,69],[3,16,52,57],
 [3,16,52,62],[3,16,52,67],[3,16,52,69],[3,16,56,57],
 [3,16,56,62],[3,16,56,68],[3,16,56,69],[3,16,57,60],
 [3,16,57,67],[3,16,57,68],[3,16,60,62],[3,16,60,67],
 [3,16,60,68],[3,16,60,69],[3,16,62,67],[3,16,62,68],
 [3,16,62,69],[3,16,67,68],[3,16,67,69],[3,16,68,69],
 [3,17,18,22],[3,17,18,24],[3,17,18,26],[3,17,18,39],
 [3,17,18,50],[3,17,18,53],[3,17,18,56],[3,17,18,57],
 [3,17,18,61],[3,17,18,68],[3,17,20,22],[3,17,20,24],
 [3,17,20,26],[3,17,20,49],[3,17,20,61],[3,17,20,68],
 [3,17,20,69],[3,17,22,24],[3,17,22,26],[3,17,22,39],
 [3,17,22,49],[3,17,22,50],[3,17,22,56],[3,17,22,58],
 [3,17,22,61],[3,17,22,62],[3,17,22,68],[3,17,24,26],
 [3,17,24,27],[3,17,24,37],[3,17,24,49],[3,17,24,53],
 [3,17,24,56],[3,17,24,57],[3,17,24,61],[3,17,24,62],
 [3,17,24,68],[3,17,24,69],[3,17,26,27],[3,17,26,37],
 [3,17,26,39],[3,17,26,49],[3,17,26,50],[3,17,26,53],
 [3,17,26,56],[3,17,26,57],[3,17,26,58],[3,17,26,61],
 [3,17,26,62],[3,17,26,68],[3,17,26,69],[3,17,27,39],
 [3,17,27,53],[3,17,27,56],[3,17,27,58],[3,17,27,61],
 [3,17,27,62],[3,17,27,69],[3,17,37,56],[3,17,37,61],
 [3,17,39,49],[3,17,39,58],[3,17,39,62],[3,17,39,68],
 [3,17,39,69],[3,17,49,56],[3,17,49,58],[3,17,49,61],
 [3,17,49,68],[3,17,50,53],[3,17,50,61],[3,17,50,62],
 [3,17,50,68],[3,17,50,69],[3,17,53,56],[3,17,53,58],
 [3,17,53,62],[3,17,53,68],[3,17,56,57],[3,17,56,61],
 [3,17,56,62],[3,17,56,68],[3,17,56,69],[3,17,57,58],
 [3,17,57,61],[3,17,57,68],[3,17,58,62],[3,17,58,69],
 [3,17,61,62],[3,17,61,68],[3,17,61,69],[3,17,62,69],
 [3,18,22,24],[3,18,22,25],[3,18,22,26],[3,18,22,39],
 [3,18,22,41],[3,18,22,43],[3,18,22,47],[3,18,22,56],
 [3,18,22,59],[3,18,22,60],[3,18,22,61],[3,18,22,68],
 [3,18,24,25],[3,18,24,26],[3,18,24,36],[3,18,24,41],
 [3,18,24,47],[3,18,24,52],[3,18,24,53],[3,18,24,56],
 [3,18,24,57],[3,18,24,59],[3,18,24,60],[3,18,24,61],
 [3,18,24,67],[3,18,24,68],[3,18,25,26],[3,18,25,39],
 [3,18,25,43],[3,18,25,50],[3,18,25,52],[3,18,25,53],
 [3,18,25,57],[3,18,25,59],[3,18,25,60],[3,18,25,61],
 [3,18,25,67],[3,18,26,36],[3,18,26,39],[3,18,26,41],
 [3,18,26,47],[3,18,26,50],[3,18,26,52],[3,18,26,53],
 [3,18,26,56],[3,18,26,57],[3,18,26,59],[3,18,26,60],
 [3,18,26,61],[3,18,26,67],[3,18,26,68],[3,18,36,43],
 [3,18,36,50],[3,18,36,53],[3,18,36,57],[3,18,36,61],
 [3,18,39,52],[3,18,39,60],[3,18,39,67],[3,18,39,68],
 [3,18,41,47],[3,18,41,56],[3,18,41,59],[3,18,41,61],
 [3,18,41,68],[3,18,43,56],[3,18,43,60],[3,18,43,61],
 [3,18,43,67],[3,18,47,50],[3,18,47,53],[3,18,47,57],
 [3,18,47,59],[3,18,47,61],[3,18,47,68],[3,18,50,52],
 [3,18,50,53],[3,18,50,56],[3,18,50,59],[3,18,50,60],
 [3,18,50,61],[3,18,50,67],[3,18,50,68],[3,18,52,53],
 [3,18,52,57],[3,18,52,61],[3,18,52,67],[3,18,53,56],
 [3,18,53,60],[3,18,53,67],[3,18,53,68],[3,18,56,57],
 [3,18,56,59],[3,18,56,61],[3,18,56,68],[3,18,57,59],
 [3,18,57,60],[3,18,57,61],[3,18,57,67],[3,18,57,68],
 [3,18,59,61],[3,18,59,67],[3,18,59,68],[3,18,60,61],
 [3,18,60,67],[3,18,61,67],[3,18,61,68],[3,20,22,24],
 [3,20,22,25],[3,20,22,26],[3,20,22,41],[3,20,22,44],
 [3,20,22,47],[3,20,22,49],[3,20,22,59],[3,20,22,60],
 [3,20,22,61],[3,20,22,68],[3,20,24,25],[3,20,24,26],
 [3,20,24,41],[3,20,24,44],[3,20,24,47],[3,20,24,49],
 [3,20,24,52],[3,20,24,59],[3,20,24,60],[3,20,24,61],
 [3,20,24,68],[3,20,24,69],[3,20,25,26],[3,20,25,49],
 [3,20,25,59],[3,20,25,60],[3,20,25,61],[3,20,25,68],
 [3,20,25,69],[3,20,26,41],[3,20,26,44],[3,20,26,47],
 [3,20,26,49],[3,20,26,52],[3,20,26,59],[3,20,26,60],
 [3,20,26,61],[3,20,26,68],[3,20,26,69],[3,20,41,44],
 [3,20,41,47],[3,20,41,49],[3,20,41,59],[3,20,41,60],
 [3,20,41,61],[3,20,41,68],[3,20,41,69],[3,20,44,47],
 [3,20,44,49],[3,20,44,52],[3,20,44,59],[3,20,44,60],
 [3,20,44,61],[3,20,44,68],[3,20,44,69],[3,20,47,49],
 [3,20,47,59],[3,20,47,61],[3,20,47,68],[3,20,47,69],
 [3,20,49,59],[3,20,49,60],[3,20,49,61],[3,20,49,68],
 [3,20,52,61],[3,20,52,69],[3,20,59,60],[3,20,59,61],
 [3,20,59,68],[3,20,60,61],[3,20,60,68],[3,20,60,69],
 [3,20,61,68],[3,20,61,69],[3,20,68,69],[3,22,24,25],
 [3,22,24,26],[3,22,24,27],[3,22,24,36],[3,22,24,41],
 [3,22,24,44],[3,22,24,47],[3,22,24,49],[3,22,24,56],
 [3,22,24,59],[3,22,24,60],[3,22,24,61],[3,22,24,62],
 [3,22,24,68],[3,22,25,26],[3,22,25,27],[3,22,25,39],
 [3,22,25,43],[3,22,25,49],[3,22,25,58],[3,22,25,59],
 [3,22,25,60],[3,22,25,61],[3,22,25,62],[3,22,25,68],
 [3,22,26,27],[3,22,26,36],[3,22,26,39],[3,22,26,41],
 [3,22,26,44],[3,22,26,47],[3,22,26,49],[3,22,26,56],
 [3,22,26,58],[3,22,26,59],[3,22,26,60],[3,22,26,61],
 [3,22,26,62],[3,22,26,68],[3,22,27,39],[3,22,27,41],
 [3,22,27,44],[3,22,27,47],[3,22,27,56],[3,22,27,58],
 [3,22,27,59],[3,22,27,60],[3,22,27,61],[3,22,27,62],
 [3,22,27,68],[3,22,36,43],[3,22,36,49],[3,22,36,50],
 [3,22,36,61],[3,22,36,62],[3,22,36,68],[3,22,39,49],
 [3,22,39,58],[3,22,39,59],[3,22,39,60],[3,22,39,62],
 [3,22,39,68],[3,22,41,44],[3,22,41,47],[3,22,41,49],
 [3,22,41,56],[3,22,41,59],[3,22,41,60],[3,22,41,61],
 [3,22,41,68],[3,22,43,44],[3,22,43,56],[3,22,43,58],
 [3,22,43,60],[3,22,43,61],[3,22,43,62],[3,22,43,68],
 [3,22,44,47],[3,22,44,49],[3,22,44,50],[3,22,44,56],
 [3,22,44,58],[3,22,44,59],[3,22,44,60],[3,22,44,61],
 [3,22,44,62],[3,22,44,68],[3,22,47,49],[3,22,47,50],
 [3,22,47,59],[3,22,47,61],[3,22,47,62],[3,22,47,68],
 [3,22,49,56],[3,22,49,58],[3,22,49,59],[3,22,49,60],
 [3,22,49,61],[3,22,49,68],[3,22,50,60],[3,22,50,62],
 [3,22,50,68],[3,22,56,59],[3,22,56,61],[3,22,56,62],
 [3,22,56,68],[3,22,58,60],[3,22,58,61],[3,22,58,62],
 [3,22,58,68],[3,22,59,60],[3,22,59,61],[3,22,59,62],
 [3,22,59,68],[3,22,60,61],[3,22,60,62],[3,22,60,68],
 [3,22,61,62],[3,22,61,68],[3,22,62,68],[3,24,25,26],
 [3,24,25,27],[3,24,25,37],[3,24,25,49],[3,24,25,53],
 [3,24,25,57],[3,24,25,59],[3,24,25,60],[3,24,25,61],
 [3,24,25,62],[3,24,25,67],[3,24,25,68],[3,24,25,69],
 [3,24,26,27],[3,24,26,36],[3,24,26,37],[3,24,26,41],
 [3,24,26,44],[3,24,26,47],[3,24,26,49],[3,24,26,52],
 [3,24,26,56],[3,24,26,57],[3,24,26,59],[3,24,26,60],
 [3,24,26,61],[3,24,26,62],[3,24,26,67],[3,24,26,68],
 [3,24,26,69],[3,24,27,36],[3,24,27,41],[3,24,27,44],
 [3,24,27,47],[3,24,27,52],[3,24,27,53],[3,24,27,56],
 [3,24,27,59],[3,24,27,60],[3,24,27,61],[3,24,27,62],
 [3,24,27,67],[3,24,27,68],[3,24,27,69],[3,24,36,37],
 [3,24,36,49],[3,24,36,53],[3,24,36,57],[3,24,36,61],
 [3,24,36,62],[3,24,36,68],[3,24,36,69],[3,24,37,47],
 [3,24,37,52],[3,24,37,56],[3,24,37,59],[3,24,37,60],
 [3,24,37,61],[3,24,37,67],[3,24,37,68],[3,24,41,44],
 [3,24,41,47],[3,24,41,49],[3,24,41,56],[3,24,41,59],
 [3,24,41,60],[3,24,41,61],[3,24,41,68],[3,24,41,69],
 [3,24,44,47],[3,24,44,49],[3,24,44,52],[3,24,44,53],
 [3,24,44,56],[3,24,44,57],[3,24,44,59],[3,24,44,60],
 [3,24,44,61],[3,24,44,62],[3,24,44,67],[3,24,44,68],
 [3,24,44,69],[3,24,47,49],[3,24,47,53],[3,24,47,57],
 [3,24,47,59],[3,24,47,61],[3,24,47,62],[3,24,47,68],
 [3,24,47,69],[3,24,49,52],[3,24,49,56],[3,24,49,59],
 [3,24,49,60],[3,24,49,61],[3,24,49,67],[3,24,49,68],
 [3,24,52,53],[3,24,52,57],[3,24,52,61],[3,24,52,62],
 [3,24,52,67],[3,24,52,69],[3,24,53,56],[3,24,53,60],
 [3,24,53,62],[3,24,53,67],[3,24,53,68],[3,24,56,57],
 [3,24,56,59],[3,24,56,61],[3,24,56,62],[3,24,56,68],
 [3,24,56,69],[3,24,57,59],[3,24,57,60],[3,24,57,61],
 [3,24,57,67],[3,24,57,68],[3,24,59,60],[3,24,59,61],
 [3,24,59,62],[3,24,59,67],[3,24,59,68],[3,24,60,61],
 [3,24,60,62],[3,24,60,67],[3,24,60,68],[3,24,60,69],
 [3,24,61,62],[3,24,61,67],[3,24,61,68],[3,24,61,69],
 [3,24,62,67],[3,24,62,68],[3,24,62,69],[3,24,67,68],
 [3,24,67,69],[3,24,68,69],[3,25,26,27],[3,25,26,37],
 [3,25,26,39],[3,25,26,49],[3,25,26,50],[3,25,26,52],
 [3,25,26,53],[3,25,26,57],[3,25,26,58],[3,25,26,59],
 [3,25,26,60],[3,25,26,61],[3,25,26,62],[3,25,26,67],
 [3,25,26,68],[3,25,26,69],[3,25,27,39],[3,25,27,53],
 [3,25,27,58],[3,25,27,59],[3,25,27,60],[3,25,27,61],
 [3,25,27,62],[3,25,27,67],[3,25,27,68],[3,25,27,69],
 [3,25,37,52],[3,25,37,59],[3,25,37,60],[3,25,37,61],
 [3,25,37,67],[3,25,37,68],[3,25,39,49],[3,25,39,58],
 [3,25,39,59],[3,25,39,60],[3,25,39,62],[3,25,39,67],
 [3,25,39,68],[3,25,39,69],[3,25,43,52],[3,25,43,53],
 [3,25,43,58],[3,25,43,60],[3,25,43,61],[3,25,43,62],
 [3,25,43,67],[3,25,43,68],[3,25,43,69],[3,25,49,52],
 [3,25,49,58],[3,25,49,59],[3,25,49,60],[3,25,49,61],
 [3,25,49,67],[3,25,49,68],[3,25,50,52],[3,25,50,53],
 [3,25,50,61],[3,25,50,62],[3,25,50,67],[3,25,50,69],
 [3,25,52,53],[3,25,52,61],[3,25,52,62],[3,25,52,67],
 [3,25,52,69],[3,25,53,58],[3,25,53,60],[3,25,53,62],
 [3,25,53,67],[3,25,53,68],[3,25,57,58],[3,25,57,59],
 [3,25,57,60],[3,25,57,61],[3,25,57,67],[3,25,58,60],
 [3,25,58,61],[3,25,58,62],[3,25,58,67],[3,25,58,68],
 [3,25,58,69],[3,25,59,60],[3,25,59,61],[3,25,59,62],
 [3,25,59,67],[3,25,59,68],[3,25,60,61],[3,25,60,62],
 [3,25,60,67],[3,25,60,68],[3,25,60,69],[3,25,61,62],
 [3,25,61,67],[3,25,61,68],[3,25,61,69],[3,25,62,67],
 [3,25,62,68],[3,25,62,69],[3,25,67,68],[3,25,67,69],
 [3,25,68,69],[3,26,27,36],[3,26,27,39],[3,26,27,41],
 [3,26,27,44],[3,26,27,47],[3,26,27,52],[3,26,27,56],
 [3,26,27,58],[3,26,27,59],[3,26,27,60],[3,26,27,61],
 [3,26,27,62],[3,26,27,67],[3,26,27,68],[3,26,27,69],
 [3,26,36,37],[3,26,36,49],[3,26,36,50],[3,26,36,53],
 [3,26,36,57],[3,26,36,61],[3,26,36,62],[3,26,36,68],
 [3,26,36,69],[3,26,37,47],[3,26,37,52],[3,26,37,56],
 [3,26,37,59],[3,26,37,60],[3,26,37,61],[3,26,37,67],
 [3,26,37,68],[3,26,39,49],[3,26,39,58],[3,26,39,59],
 [3,26,39,60],[3,26,39,62],[3,26,39,67],[3,26,39,68],
 [3,26,39,69],[3,26,41,44],[3,26,41,47],[3,26,41,49],
 [3,26,41,56],[3,26,41,59],[3,26,41,60],[3,26,41,61],
 [3,26,41,68],[3,26,41,69],[3,26,44,47],[3,26,44,49],
 [3,26,44,50],[3,26,44,52],[3,26,44,53],[3,26,44,56],
 [3,26,44,57],[3,26,44,58],[3,26,44,59],[3,26,44,60],
 [3,26,44,61],[3,26,44,62],[3,26,44,67],[3,26,44,68],
 [3,26,44,69],[3,26,47,49],[3,26,47,50],[3,26,47,53],
 [3,26,47,57],[3,26,47,59],[3,26,47,61],[3,26,47,62],
 [3,26,47,68],[3,26,47,69],[3,26,49,52],[3,26,49,56],
 [3,26,49,58],[3,26,49,59],[3,26,49,60],[3,26,49,61],
 [3,26,49,67],[3,26,49,68],[3,26,50,52],[3,26,50,53],
 [3,26,50,56],[3,26,50,60],[3,26,50,62],[3,26,50,67],
 [3,26,50,68],[3,26,52,53],[3,26,52,57],[3,26,52,61],
 [3,26,52,62],[3,26,52,67],[3,26,52,69],[3,26,53,56],
 [3,26,53,58],[3,26,53,60],[3,26,53,62],[3,26,53,67],
 [3,26,53,68],[3,26,56,57],[3,26,56,59],[3,26,56,61],
 [3,26,56,62],[3,26,56,68],[3,26,56,69],[3,26,57,58],
 [3,26,57,59],[3,26,57,60],[3,26,57,61],[3,26,57,67],
 [3,26,57,68],[3,26,58,60],[3,26,58,61],[3,26,58,62],
 [3,26,58,67],[3,26,58,68],[3,26,58,69],[3,26,59,60],
 [3,26,59,61],[3,26,59,62],[3,26,59,67],[3,26,59,68],
 [3,26,60,61],[3,26,60,62],[3,26,60,67],[3,26,60,68],
 [3,26,60,69],[3,26,61,62],[3,26,61,67],[3,26,61,68],
 [3,26,61,69],[3,26,62,67],[3,26,62,68],[3,26,62,69],
 [3,26,67,68],[3,26,67,69],[3,26,68,69],[3,27,36,53],
 [3,27,36,61],[3,27,36,62],[3,27,36,68],[3,27,36,69],
 [3,27,39,52],[3,27,39,58],[3,27,39,59],[3,27,39,60],
 [3,27,39,62],[3,27,39,67],[3,27,39,68],[3,27,39,69],
 [3,27,41,44],[3,27,41,47],[3,27,41,59],[3,27,41,60],
 [3,27,41,61],[3,27,41,68],[3,27,41,69],[3,27,44,47],
 [3,27,44,52],[3,27,44,56],[3,27,44,58],[3,27,44,59],
 [3,27,44,60],[3,27,44,61],[3,27,44,62],[3,27,44,67],
 [3,27,44,68],[3,27,44,69],[3,27,47,53],[3,27,47,59],
 [3,27,47,61],[3,27,47,62],[3,27,47,68],[3,27,47,69],
 [3,27,52,53],[3,27,52,61],[3,27,52,62],[3,27,52,67],
 [3,27,52,69],[3,27,53,56],[3,27,53,58],[3,27,53,60],
 [3,27,53,62],[3,27,53,67],[3,27,53,68],[3,27,56,59],
 [3,27,56,61],[3,27,56,62],[3,27,56,69],[3,27,58,60],
 [3,27,58,61],[3,27,58,62],[3,27,58,67],[3,27,58,68],
 [3,27,58,69],[3,27,59,60],[3,27,59,61],[3,27,59,62],
 [3,27,59,67],[3,27,59,68],[3,27,60,61],[3,27,60,62],
 [3,27,60,67],[3,27,60,68],[3,27,60,69],[3,27,61,62],
 [3,27,61,67],[3,27,61,68],[3,27,61,69],[3,27,62,67],
 [3,27,62,68],[3,27,62,69],[3,27,67,68],[3,27,67,69],
 [3,27,68,69],[3,36,37,61],[3,36,37,68],[3,36,43,53],
 [3,36,43,62],[3,36,43,68],[3,36,43,69],[3,36,49,61],
 [3,36,50,53],[3,36,50,61],[3,36,50,62],[3,36,50,68],
 [3,36,50,69],[3,36,53,62],[3,36,57,61],[3,36,61,62],
 [3,36,61,68],[3,36,61,69],[3,36,62,68],[3,36,62,69],
 [3,37,47,59],[3,37,47,61],[3,37,52,61],[3,37,56,61],
 [3,37,59,60],[3,37,59,61],[3,37,60,61],[3,37,60,67],
 [3,37,60,68],[3,37,61,67],[3,37,61,68],[3,39,49,52],
 [3,39,49,58],[3,39,49,59],[3,39,49,60],[3,39,49,67],
 [3,39,49,68],[3,39,52,62],[3,39,52,67],[3,39,58,60],
 [3,39,58,62],[3,39,58,67],[3,39,58,68],[3,39,58,69],
 [3,39,59,60],[3,39,59,62],[3,39,59,67],[3,39,59,68],
 [3,39,60,62],[3,39,60,67],[3,39,60,68],[3,39,60,69],
 [3,39,62,67],[3,39,62,68],[3,39,62,69],[3,39,67,68],
 [3,39,67,69],[3,39,68,69],[3,41,44,47],[3,41,44,49],
 [3,41,44,56],[3,41,44,59],[3,41,44,60],[3,41,44,61],
 [3,41,44,68],[3,41,44,69],[3,41,47,49],[3,41,47,59],
 [3,41,47,61],[3,41,47,68],[3,41,47,69],[3,41,49,56],
 [3,41,49,59],[3,41,49,60],[3,41,49,61],[3,41,49,68],
 [3,41,56,59],[3,41,56,61],[3,41,56,68],[3,41,59,60],
 [3,41,59,61],[3,41,59,68],[3,41,60,61],[3,41,60,68],
 [3,41,60,69],[3,41,61,68],[3,41,61,69],[3,41,68,69],
 [3,43,44,53],[3,43,44,58],[3,43,44,60],[3,43,44,61],
 [3,43,44,62],[3,43,44,67],[3,43,44,68],[3,43,44,69],
 [3,43,52,53],[3,43,52,61],[3,43,52,67],[3,43,52,69],
 [3,43,53,56],[3,43,53,58],[3,43,53,60],[3,43,53,62],
 [3,43,53,67],[3,43,53,68],[3,43,56,62],[3,43,56,68],
 [3,43,56,69],[3,43,58,60],[3,43,58,61],[3,43,58,62],
 [3,43,58,67],[3,43,58,68],[3,43,58,69],[3,43,60,61],
 [3,43,60,62],[3,43,60,67],[3,43,60,68],[3,43,60,69],
 [3,43,61,62],[3,43,61,67],[3,43,61,68],[3,43,61,69],
 [3,43,62,67],[3,43,62,68],[3,43,62,69],[3,43,67,68],
 [3,43,67,69],[3,43,68,69],[3,44,47,49],[3,44,47,50],
 [3,44,47,53],[3,44,47,57],[3,44,47,59],[3,44,47,61],
 [3,44,47,62],[3,44,47,68],[3,44,47,69],[3,44,49,52],
 [3,44,49,56],[3,44,49,58],[3,44,49,59],[3,44,49,60],
 [3,44,49,61],[3,44,49,67],[3,44,49,68],[3,44,50,52],
 [3,44,50,53],[3,44,50,56],[3,44,50,59],[3,44,50,60],
 [3,44,50,61],[3,44,50,62],[3,44,50,67],[3,44,50,68],
 [3,44,50,69],[3,44,52,53],[3,44,52,57],[3,44,52,61],
 [3,44,52,62],[3,44,52,67],[3,44,52,69],[3,44,53,56],
 [3,44,53,58],[3,44,53,60],[3,44,53,67],[3,44,53,68],
 [3,44,56,57],[3,44,56,59],[3,44,56,61],[3,44,56,62],
 [3,44,56,68],[3,44,56,69],[3,44,57,58],[3,44,57,59],
 [3,44,57,60],[3,44,57,61],[3,44,57,67],[3,44,57,68],
 [3,44,58,60],[3,44,58,61],[3,44,58,62],[3,44,58,67],
 [3,44,58,68],[3,44,58,69],[3,44,59,60],[3,44,59,61],
 [3,44,59,62],[3,44,59,67],[3,44,59,68],[3,44,60,61],
 [3,44,60,62],[3,44,60,67],[3,44,60,68],[3,44,60,69],
 [3,44,61,62],[3,44,61,67],[3,44,61,68],[3,44,61,69],
 [3,44,62,67],[3,44,62,68],[3,44,62,69],[3,44,67,68],
 [3,44,67,69],[3,44,68,69],[3,47,49,59],[3,47,49,61],
 [3,47,49,68],[3,47,50,53],[3,47,50,59],[3,47,50,61],
 [3,47,50,62],[3,47,50,68],[3,47,50,69],[3,47,53,62],
 [3,47,53,68],[3,47,57,59],[3,47,57,61],[3,47,57,68],
 [3,47,59,61],[3,47,59,62],[3,47,59,68],[3,47,61,62],
 [3,47,61,68],[3,47,61,69],[3,47,62,68],[3,47,62,69],
 [3,47,68,69],[3,49,52,61],[3,49,52,67],[3,49,56,59],
 [3,49,56,61],[3,49,56,68],[3,49,58,60],[3,49,58,61],
 [3,49,58,67],[3,49,58,68],[3,49,59,60],[3,49,59,61],
 [3,49,59,67],[3,49,59,68],[3,49,60,61],[3,49,60,67],
 [3,49,60,68],[3,49,61,67],[3,49,61,68],[3,49,67,68],
 [3,50,52,53],[3,50,52,61],[3,50,52,62],[3,50,52,67],
 [3,50,52,69],[3,50,53,56],[3,50,53,60],[3,50,53,62],
 [3,50,53,67],[3,50,53,68],[3,50,56,59],[3,50,56,61],
 [3,50,56,62],[3,50,56,69],[3,50,59,60],[3,50,59,61],
 [3,50,59,62],[3,50,59,67],[3,50,59,68],[3,50,60,61],
 [3,50,60,62],[3,50,60,67],[3,50,60,68],[3,50,60,69],
 [3,50,61,62],[3,50,61,67],[3,50,61,68],[3,50,61,69],
 [3,50,62,67],[3,50,62,68],[3,50,62,69],[3,50,67,68],
 [3,50,67,69],[3,50,68,69],[3,52,53,62],[3,52,53,67],
 [3,52,57,61],[3,52,61,62],[3,52,61,69],[3,52,62,67],
 [3,52,62,69],[3,53,56,62],[3,53,58,60],[3,53,58,62],
 [3,53,60,62],[3,53,60,68],[3,53,62,67],[3,53,62,68],
 [3,56,57,59],[3,56,57,61],[3,56,57,68],[3,56,59,61],
 [3,56,59,62],[3,56,59,68],[3,56,61,62],[3,56,61,68],
 [3,56,61,69],[3,56,62,69],[3,57,58,60],[3,57,58,61],
 [3,57,58,67],[3,57,59,60],[3,57,59,61],[3,57,59,68],
 [3,57,60,61],[3,57,60,67],[3,57,61,67],[3,57,61,68],
 [3,58,60,61],[3,58,60,62],[3,58,60,67],[3,58,60,68],
 [3,58,60,69],[3,58,61,62],[3,58,61,67],[3,58,61,68],
 [3,58,61,69],[3,58,62,67],[3,58,62,68],[3,58,62,69],
 [3,58,67,68],[3,58,67,69],[3,58,68,69],[3,59,60,61],
 [3,59,60,62],[3,59,60,67],[3,59,60,68],[3,59,61,62],
 [3,59,61,67],[3,59,61,68],[3,59,62,67],[3,59,62,68],
 [3,59,67,68],[3,60,61,62],[3,60,61,67],[3,60,61,68],
 [3,60,61,69],[3,60,62,67],[3,60,62,68],[3,60,62,69],
 [3,60,67,68],[3,60,67,69],[3,60,68,69],[3,61,62,67],
 [3,61,62,68],[3,61,62,69],[3,61,67,68],[3,61,67,69],
 [3,61,68,69],[3,62,67,68],[3,62,67,69],[3,62,68,69],
 [3,67,68,69],[4,7,12,13],[4,7,12,23],[4,7,12,37],
 [4,7,12,40],[4,7,12,43],[4,7,12,67],[4,7,13,23],
 [4,7,13,37],[4,7,13,39],[4,7,13,43],[4,7,13,67],
 [4,7,23,37],[4,7,23,39],[4,7,23,40],[4,7,23,43],
 [4,7,23,67],[4,7,37,43],[4,7,37,67],[4,7,39,43],
 [4,7,39,67],[4,7,40,67],[4,7,43,67],[4,8,11,37],
 [4,8,11,48],[4,8,11,49],[4,8,11,60],[4,8,11,61],
 [4,8,11,62],[4,8,12,44],[4,8,12,48],[4,8,12,49],
 [4,8,12,60],[4,8,12,61],[4,8,12,62],[4,8,12,67],
 [4,8,26,37],[4,8,26,39],[4,8,26,41],[4,8,26,44],
 [4,8,26,49],[4,8,26,59],[4,8,26,60],[4,8,26,61],
 [4,8,26,62],[4,8,26,68],[4,8,27,39],[4,8,27,42],
 [4,8,27,48],[4,8,27,60],[4,8,27,61],[4,8,27,62],
 [4,8,37,42],[4,8,37,44],[4,8,37,48],[4,8,37,59],
 [4,8,37,60],[4,8,37,61],[4,8,37,67],[4,8,39,58],
 [4,8,39,60],[4,8,39,61],[4,8,39,67],[4,8,41,44],
 [4,8,41,48],[4,8,41,59],[4,8,41,60],[4,8,41,61],
 [4,8,42,44],[4,8,42,49],[4,8,42,60],[4,8,42,61],
 [4,8,42,62],[4,8,44,49],[4,8,44,58],[4,8,44,59],
 [4,8,44,60],[4,8,44,61],[4,8,44,67],[4,8,44,68],
 [4,8,48,60],[4,8,48,68],[4,8,49,58],[4,8,49,60],
 [4,8,49,61],[4,8,49,67],[4,8,58,60],[4,8,58,61],
 [4,8,58,62],[4,8,59,60],[4,8,59,61],[4,8,59,62],
 [4,8,59,68],[4,8,60,61],[4,8,60,62],[4,8,60,67],
 [4,8,60,68],[4,8,61,67],[4,8,61,68],[4,8,62,67],
 [4,8,62,68],[4,9,15,20],[4,9,15,22],[4,9,15,24],
 [4,9,15,26],[4,9,15,41],[4,9,15,44],[4,9,15,47],
 [4,9,15,49],[4,9,15,59],[4,9,15,61],[4,9,15,68],
 [4,9,20,22],[4,9,20,24],[4,9,20,26],[4,9,20,41],
 [4,9,20,44],[4,9,20,47],[4,9,20,48],[4,9,20,49],
 [4,9,20,59],[4,9,20,61],[4,9,20,68],[4,9,22,24],
 [4,9,22,26],[4,9,22,41],[4,9,22,43],[4,9,22,44],
 [4,9,22,47],[4,9,22,49],[4,9,22,59],[4,9,22,61],
 [4,9,22,68],[4,9,24,26],[4,9,24,41],[4,9,24,43],
 [4,9,24,44],[4,9,24,47],[4,9,24,48],[4,9,24,49],
 [4,9,24,59],[4,9,24,61],[4,9,24,68],[4,9,26,41],
 [4,9,26,43],[4,9,26,44],[4,9,26,47],[4,9,26,48],
 [4,9,26,49],[4,9,26,59],[4,9,26,61],[4,9,26,68],
 [4,9,41,43],[4,9,41,44],[4,9,41,47],[4,9,41,48],
 [4,9,41,49],[4,9,41,59],[4,9,41,61],[4,9,41,68],
 [4,9,43,44],[4,9,43,48],[4,9,43,49],[4,9,43,61],
 [4,9,43,68],[4,9,44,47],[4,9,44,49],[4,9,44,59],
 [4,9,44,61],[4,9,44,68],[4,9,47,48],[4,9,47,49],
 [4,9,47,59],[4,9,47,61],[4,9,47,68],[4,9,48,68],
 [4,9,49,59],[4,9,49,61],[4,9,49,68],[4,9,59,61],
 [4,9,59,68],[4,9,61,68],[4,10,11,37],[4,10,11,38],
 [4,10,11,48],[4,10,11,49],[4,10,11,51],[4,10,11,61],
 [4,10,11,62],[4,10,12,37],[4,10,12,48],[4,10,12,49],
 [4,10,12,51],[4,10,12,61],[4,10,12,62],[4,10,12,67],
 [4,10,26,37],[4,10,26,38],[4,10,26,39],[4,10,26,41],
 [4,10,26,42],[4,10,26,48],[4,10,26,49],[4,10,26,51],
 [4,10,26,62],[4,10,26,68],[4,10,27,37],[4,10,27,39],
 [4,10,27,41],[4,10,27,42],[4,10,27,48],[4,10,27,49],
 [4,10,27,51],[4,10,27,61],[4,10,37,38],[4,10,37,42],
 [4,10,37,48],[4,10,37,59],[4,10,37,61],[4,10,37,67],
 [4,10,37,68],[4,10,38,42],[4,10,38,48],[4,10,38,49],
 [4,10,38,61],[4,10,38,67],[4,10,39,48],[4,10,39,58],
 [4,10,39,67],[4,10,41,48],[4,10,41,49],[4,10,41,59],
 [4,10,41,61],[4,10,41,68],[4,10,42,49],[4,10,42,62],
 [4,10,48,58],[4,10,48,67],[4,10,48,68],[4,10,49,58],
 [4,10,49,59],[4,10,49,61],[4,10,49,67],[4,10,49,68],
 [4,10,51,58],[4,10,51,62],[4,10,51,67],[4,10,51,68],
 [4,10,58,62],[4,10,59,68],[4,10,61,68],[4,10,62,67],
 [4,11,13,23],[4,11,13,24],[4,11,13,37],[4,11,13,43],
 [4,11,13,51],[4,11,13,60],[4,11,13,62],[4,11,20,23],
 [4,11,20,24],[4,11,20,37],[4,11,20,38],[4,11,20,47],
 [4,11,20,49],[4,11,23,37],[4,11,23,40],[4,11,23,43],
 [4,11,23,49],[4,11,23,51],[4,11,23,61],[4,11,23,62],
 [4,11,24,37],[4,11,24,38],[4,11,24,40],[4,11,24,43],
 [4,11,24,47],[4,11,24,48],[4,11,24,49],[4,11,24,51],
 [4,11,24,62],[4,11,37,38],[4,11,37,43],[4,11,37,47],
 [4,11,37,48],[4,11,37,60],[4,11,37,61],[4,11,38,40],
 [4,11,38,43],[4,11,38,49],[4,11,38,51],[4,11,38,60],
 [4,11,38,61],[4,11,38,62],[4,11,40,48],[4,11,40,49],
 [4,11,43,48],[4,11,43,49],[4,11,43,62],[4,11,47,49],
 [4,11,47,51],[4,11,47,61],[4,11,47,62],[4,11,48,60],
 [4,11,49,60],[4,11,49,61],[4,11,51,60],[4,11,51,62],
 [4,11,60,62],[4,12,13,23],[4,12,13,24],[4,12,13,37],
 [4,12,13,43],[4,12,13,51],[4,12,13,60],[4,12,13,61],
 [4,12,13,67],[4,12,20,24],[4,12,20,44],[4,12,20,47],
 [4,12,20,48],[4,12,20,61],[4,12,20,67],[4,12,23,37],
 [4,12,23,40],[4,12,23,43],[4,12,23,48],[4,12,23,61],
 [4,12,23,62],[4,12,23,67],[4,12,24,37],[4,12,24,43],
 [4,12,24,44],[4,12,24,47],[4,12,24,48],[4,12,24,49],
 [4,12,24,51],[4,12,24,61],[4,12,24,67],[4,12,37,43],
 [4,12,37,44],[4,12,37,47],[4,12,37,48],[4,12,37,60],
 [4,12,37,61],[4,12,37,67],[4,12,40,44],[4,12,40,48],
 [4,12,40,49],[4,12,40,61],[4,12,40,67],[4,12,43,44],
 [4,12,43,48],[4,12,43,49],[4,12,43,61],[4,12,43,67],
 [4,12,44,47],[4,12,44,49],[4,12,44,60],[4,12,44,61],
 [4,12,44,67],[4,12,47,48],[4,12,47,61],[4,12,47,62],
 [4,12,47,67],[4,12,48,60],[4,12,48,67],[4,12,49,60],
 [4,12,49,61],[4,12,49,67],[4,12,51,60],[4,12,51,62],
 [4,12,51,67],[4,12,60,61],[4,12,60,67],[4,12,61,67],
 [4,12,62,67],[4,13,15,22],[4,13,15,23],[4,13,15,24],
 [4,13,15,26],[4,13,15,37],[4,13,15,39],[4,13,15,49],
 [4,13,15,52],[4,13,15,59],[4,13,15,61],[4,13,15,68],
 [4,13,22,23],[4,13,22,24],[4,13,22,26],[4,13,22,27],
 [4,13,22,39],[4,13,22,43],[4,13,22,49],[4,13,22,50],
 [4,13,22,58],[4,13,22,59],[4,13,22,61],[4,13,22,68],
 [4,13,23,26],[4,13,23,27],[4,13,23,36],[4,13,23,37],
 [4,13,23,39],[4,13,23,43],[4,13,23,48],[4,13,23,49],
 [4,13,23,50],[4,13,23,51],[4,13,23,58],[4,13,23,59],
 [4,13,23,61],[4,13,23,62],[4,13,23,67],[4,13,23,68],
 [4,13,24,26],[4,13,24,27],[4,13,24,37],[4,13,24,39],
 [4,13,24,43],[4,13,24,48],[4,13,24,49],[4,13,24,52],
 [4,13,24,59],[4,13,24,61],[4,13,24,62],[4,13,24,67],
 [4,13,24,68],[4,13,26,36],[4,13,26,39],[4,13,26,43],
 [4,13,26,48],[4,13,26,49],[4,13,26,51],[4,13,26,52],
 [4,13,26,59],[4,13,26,60],[4,13,26,61],[4,13,26,62],
 [4,13,26,68],[4,13,27,36],[4,13,27,39],[4,13,27,43],
 [4,13,27,48],[4,13,27,49],[4,13,27,51],[4,13,27,52],
 [4,13,27,60],[4,13,27,61],[4,13,27,62],[4,13,36,37],
 [4,13,36,43],[4,13,36,48],[4,13,36,49],[4,13,36,50],
 [4,13,36,51],[4,13,36,59],[4,13,36,62],[4,13,36,68],
 [4,13,37,39],[4,13,37,43],[4,13,37,50],[4,13,37,52],
 [4,13,37,59],[4,13,37,60],[4,13,37,61],[4,13,37,67],
 [4,13,37,68],[4,13,39,43],[4,13,39,48],[4,13,39,49],
 [4,13,39,58],[4,13,39,60],[4,13,39,61],[4,13,39,62],
 [4,13,39,67],[4,13,43,48],[4,13,43,49],[4,13,43,58],
 [4,13,43,61],[4,13,43,62],[4,13,43,67],[4,13,43,68],
 [4,13,48,50],[4,13,48,52],[4,13,48,58],[4,13,48,60],
 [4,13,48,67],[4,13,48,68],[4,13,49,50],[4,13,49,52],
 [4,13,49,58],[4,13,49,59],[4,13,49,60],[4,13,49,61],
 [4,13,49,67],[4,13,49,68],[4,13,50,51],[4,13,50,59],
 [4,13,50,61],[4,13,50,62],[4,13,51,52],[4,13,51,58],
 [4,13,51,60],[4,13,51,62],[4,13,51,67],[4,13,51,68],
 [4,13,52,61],[4,13,58,60],[4,13,58,61],[4,13,58,62],
 [4,13,59,60],[4,13,59,61],[4,13,59,62],[4,13,59,68],
 [4,13,60,61],[4,13,60,62],[4,13,60,67],[4,13,60,68],
 [4,13,61,67],[4,13,61,68],[4,13,62,67],[4,13,62,68],
 [4,15,20,22],[4,15,20,23],[4,15,20,24],[4,15,20,26],
 [4,15,20,36],[4,15,20,37],[4,15,20,38],[4,15,20,39],
 [4,15,20,41],[4,15,20,44],[4,15,20,47],[4,15,20,49],
 [4,15,20,52],[4,15,20,59],[4,15,20,61],[4,15,20,68],
 [4,15,22,23],[4,15,22,24],[4,15,22,26],[4,15,22,36],
 [4,15,22,37],[4,15,22,38],[4,15,22,39],[4,15,22,40],
 [4,15,22,41],[4,15,22,42],[4,15,22,44],[4,15,22,47],
 [4,15,22,49],[4,15,22,59],[4,15,22,61],[4,15,22,68],
 [4,15,23,26],[4,15,23,36],[4,15,23,37],[4,15,23,39],
 [4,15,23,42],[4,15,23,49],[4,15,23,59],[4,15,23,61],
 [4,15,23,68],[4,15,24,26],[4,15,24,37],[4,15,24,38],
 [4,15,24,39],[4,15,24,40],[4,15,24,41],[4,15,24,42],
 [4,15,24,44],[4,15,24,47],[4,15,24,49],[4,15,24,52],
 [4,15,24,59],[4,15,24,61],[4,15,24,68],[4,15,26,36],
 [4,15,26,37],[4,15,26,38],[4,15,26,39],[4,15,26,40],
 [4,15,26,41],[4,15,26,42],[4,15,26,44],[4,15,26,47],
 [4,15,26,49],[4,15,26,52],[4,15,26,59],[4,15,26,61],
 [4,15,26,68],[4,15,36,37],[4,15,36,49],[4,15,36,59],
 [4,15,36,61],[4,15,36,68],[4,15,37,38],[4,15,37,39],
 [4,15,37,42],[4,15,37,44],[4,15,37,47],[4,15,37,52],
 [4,15,37,59],[4,15,37,61],[4,15,37,68],[4,15,38,40],
 [4,15,38,42],[4,15,38,49],[4,15,38,52],[4,15,38,61],
 [4,15,39,47],[4,15,39,49],[4,15,39,61],[4,15,40,42],
 [4,15,40,44],[4,15,40,49],[4,15,40,52],[4,15,40,61],
 [4,15,40,68],[4,15,41,44],[4,15,41,47],[4,15,41,49],
 [4,15,41,59],[4,15,41,61],[4,15,41,68],[4,15,42,44],
 [4,15,42,47],[4,15,42,49],[4,15,42,61],[4,15,44,47],
 [4,15,44,49],[4,15,44,52],[4,15,44,59],[4,15,44,61],
 [4,15,44,68],[4,15,47,49],[4,15,47,52],[4,15,47,59],
 [4,15,47,61],[4,15,47,68],[4,15,49,52],[4,15,49,59],
 [4,15,49,61],[4,15,49,68],[4,15,52,61],[4,15,59,61],
 [4,15,59,68],[4,15,61,68],[4,20,22,23],[4,20,22,24],
 [4,20,22,26],[4,20,22,37],[4,20,22,38],[4,20,22,39],
 [4,20,22,41],[4,20,22,44],[4,20,22,47],[4,20,22,49],
 [4,20,22,59],[4,20,22,61],[4,20,22,68],[4,20,23,26],
 [4,20,23,36],[4,20,23,37],[4,20,23,39],[4,20,23,48],
 [4,20,23,49],[4,20,23,59],[4,20,23,61],[4,20,23,67],
 [4,20,23,68],[4,20,24,26],[4,20,24,37],[4,20,24,38],
 [4,20,24,39],[4,20,24,41],[4,20,24,44],[4,20,24,47],
 [4,20,24,48],[4,20,24,49],[4,20,24,52],[4,20,24,59],
 [4,20,24,61],[4,20,24,67],[4,20,24,68],[4,20,26,36],
 [4,20,26,37],[4,20,26,38],[4,20,26,39],[4,20,26,41],
 [4,20,26,44],[4,20,26,47],[4,20,26,48],[4,20,26,49],
 [4,20,26,52],[4,20,26,59],[4,20,26,61],[4,20,26,68],
 [4,20,33,37],[4,20,33,49],[4,20,33,59],[4,20,33,61],
 [4,20,33,68],[4,20,36,37],[4,20,36,49],[4,20,36,61],
 [4,20,36,68],[4,20,37,38],[4,20,37,39],[4,20,37,44],
 [4,20,37,47],[4,20,37,48],[4,20,37,52],[4,20,37,59],
 [4,20,37,61],[4,20,37,68],[4,20,38,48],[4,20,38,49],
 [4,20,38,52],[4,20,38,61],[4,20,39,47],[4,20,39,48],
 [4,20,39,49],[4,20,39,61],[4,20,39,67],[4,20,41,44],
 [4,20,41,47],[4,20,41,48],[4,20,41,49],[4,20,41,59],
 [4,20,41,61],[4,20,41,68],[4,20,44,47],[4,20,44,49],
 [4,20,44,52],[4,20,44,59],[4,20,44,61],[4,20,44,67],
 [4,20,44,68],[4,20,47,48],[4,20,47,49],[4,20,47,59],
 [4,20,47,61],[4,20,47,67],[4,20,47,68],[4,20,48,52],
 [4,20,48,67],[4,20,48,68],[4,20,49,59],[4,20,49,61],
 [4,20,49,67],[4,20,49,68],[4,20,52,61],[4,20,59,61],
 [4,20,59,68],[4,20,61,67],[4,20,61,68],[4,22,23,26],
 [4,22,23,27],[4,22,23,36],[4,22,23,37],[4,22,23,39],
 [4,22,23,40],[4,22,23,43],[4,22,23,49],[4,22,23,58],
 [4,22,23,59],[4,22,23,61],[4,22,23,68],[4,22,24,26],
 [4,22,24,27],[4,22,24,37],[4,22,24,38],[4,22,24,39],
 [4,22,24,40],[4,22,24,41],[4,22,24,42],[4,22,24,43],
 [4,22,24,44],[4,22,24,47],[4,22,24,49],[4,22,24,59],
 [4,22,24,61],[4,22,24,68],[4,22,26,36],[4,22,26,37],
 [4,22,26,38],[4,22,26,39],[4,22,26,40],[4,22,26,41],
 [4,22,26,42],[4,22,26,43],[4,22,26,44],[4,22,26,47],
 [4,22,26,49],[4,22,26,59],[4,22,26,61],[4,22,26,68],
 [4,22,27,37],[4,22,27,39],[4,22,27,40],[4,22,27,41],
 [4,22,27,42],[4,22,27,43],[4,22,27,44],[4,22,27,47],
 [4,22,27,49],[4,22,27,61],[4,22,36,37],[4,22,36,40],
 [4,22,36,43],[4,22,36,49],[4,22,36,50],[4,22,36,61],
 [4,22,36,68],[4,22,37,38],[4,22,37,39],[4,22,37,42],
 [4,22,37,43],[4,22,37,44],[4,22,37,47],[4,22,37,50],
 [4,22,37,58],[4,22,37,59],[4,22,37,61],[4,22,37,68],
 [4,22,38,40],[4,22,38,42],[4,22,38,43],[4,22,38,49],
 [4,22,38,61],[4,22,39,43],[4,22,39,47],[4,22,39,49],
 [4,22,39,58],[4,22,39,61],[4,22,40,42],[4,22,40,44],
 [4,22,40,49],[4,22,40,50],[4,22,40,58],[4,22,40,61],
 [4,22,40,68],[4,22,41,43],[4,22,41,44],[4,22,41,47],
 [4,22,41,49],[4,22,41,50],[4,22,41,59],[4,22,41,61],
 [4,22,41,68],[4,22,42,43],[4,22,42,44],[4,22,42,47],
 [4,22,42,49],[4,22,42,50],[4,22,42,61],[4,22,43,44],
 [4,22,43,49],[4,22,43,58],[4,22,43,61],[4,22,43,68],
 [4,22,44,47],[4,22,44,49],[4,22,44,50],[4,22,44,58],
 [4,22,44,59],[4,22,44,61],[4,22,44,68],[4,22,47,49],
 [4,22,47,50],[4,22,47,58],[4,22,47,59],[4,22,47,61],
 [4,22,47,68],[4,22,49,50],[4,22,49,58],[4,22,49,59],
 [4,22,49,61],[4,22,49,68],[4,22,58,61],[4,22,59,61],
 [4,22,59,68],[4,22,61,68],[4,23,26,36],[4,23,26,37],
 [4,23,26,39],[4,23,26,40],[4,23,26,43],[4,23,26,48],
 [4,23,26,49],[4,23,26,51],[4,23,26,59],[4,23,26,61],
 [4,23,26,62],[4,23,26,68],[4,23,27,36],[4,23,27,39],
 [4,23,27,40],[4,23,27,42],[4,23,27,43],[4,23,27,48],
 [4,23,27,49],[4,23,27,61],[4,23,27,62],[4,23,36,37],
 [4,23,36,40],[4,23,36,43],[4,23,36,48],[4,23,36,49],
 [4,23,36,50],[4,23,36,51],[4,23,36,59],[4,23,36,61],
 [4,23,36,62],[4,23,36,68],[4,23,37,42],[4,23,37,43],
 [4,23,37,48],[4,23,37,58],[4,23,37,59],[4,23,37,61],
 [4,23,37,67],[4,23,37,68],[4,23,39,43],[4,23,39,48],
 [4,23,39,49],[4,23,39,58],[4,23,39,61],[4,23,39,62],
 [4,23,39,67],[4,23,40,42],[4,23,40,48],[4,23,40,49],
 [4,23,40,58],[4,23,40,61],[4,23,40,67],[4,23,40,68],
 [4,23,42,43],[4,23,42,49],[4,23,42,50],[4,23,42,61],
 [4,23,42,62],[4,23,43,48],[4,23,43,49],[4,23,43,58],
 [4,23,43,61],[4,23,43,62],[4,23,43,67],[4,23,43,68],
 [4,23,48,50],[4,23,48,58],[4,23,48,67],[4,23,48,68],
 [4,23,49,58],[4,23,49,59],[4,23,49,61],[4,23,49,67],
 [4,23,49,68],[4,23,50,51],[4,23,50,59],[4,23,50,61],
 [4,23,50,62],[4,23,51,58],[4,23,51,62],[4,23,51,67],
 [4,23,51,68],[4,23,58,61],[4,23,58,62],[4,23,59,61],
 [4,23,59,62],[4,23,59,68],[4,23,61,67],[4,23,61,68],
 [4,23,62,67],[4,23,62,68],[4,24,26,37],[4,24,26,38],
 [4,24,26,39],[4,24,26,40],[4,24,26,41],[4,24,26,42],
 [4,24,26,43],[4,24,26,44],[4,24,26,47],[4,24,26,48],
 [4,24,26,49],[4,24,26,51],[4,24,26,52],[4,24,26,59],
 [4,24,26,61],[4,24,26,62],[4,24,26,68],[4,24,27,37],
 [4,24,27,39],[4,24,27,41],[4,24,27,42],[4,24,27,43],
 [4,24,27,44],[4,24,27,47],[4,24,27,48],[4,24,27,49],
 [4,24,27,51],[4,24,27,52],[4,24,27,61],[4,24,27,62],
 [4,24,37,38],[4,24,37,39],[4,24,37,42],[4,24,37,43],
 [4,24,37,44],[4,24,37,47],[4,24,37,48],[4,24,37,52],
 [4,24,37,59],[4,24,37,61],[4,24,37,67],[4,24,37,68],
 [4,24,38,40],[4,24,38,42],[4,24,38,48],[4,24,38,49],
 [4,24,38,52],[4,24,38,61],[4,24,38,67],[4,24,39,43],
 [4,24,39,47],[4,24,39,48],[4,24,39,49],[4,24,39,61],
 [4,24,39,62],[4,24,39,67],[4,24,40,42],[4,24,40,44],
 [4,24,40,48],[4,24,40,49],[4,24,40,52],[4,24,40,61],
 [4,24,40,67],[4,24,40,68],[4,24,41,43],[4,24,41,44],
 [4,24,41,47],[4,24,41,48],[4,24,41,49],[4,24,41,59],
 [4,24,41,61],[4,24,41,68],[4,24,42,43],[4,24,42,44],
 [4,24,42,47],[4,24,42,49],[4,24,42,61],[4,24,42,62],
 [4,24,43,44],[4,24,43,48],[4,24,43,49],[4,24,43,52],
 [4,24,43,61],[4,24,43,62],[4,24,43,67],[4,24,43,68],
 [4,24,44,47],[4,24,44,49],[4,24,44,52],[4,24,44,59],
 [4,24,44,61],[4,24,44,67],[4,24,44,68],[4,24,47,48],
 [4,24,47,49],[4,24,47,51],[4,24,47,52],[4,24,47,59],
 [4,24,47,61],[4,24,47,62],[4,24,47,67],[4,24,47,68],
 [4,24,48,52],[4,24,48,67],[4,24,48,68],[4,24,49,52],
 [4,24,49,59],[4,24,49,61],[4,24,49,67],[4,24,49,68],
 [4,24,51,52],[4,24,51,62],[4,24,51,67],[4,24,51,68],
 [4,24,52,61],[4,24,52,62],[4,24,59,61],[4,24,59,62],
 [4,24,59,68],[4,24,61,67],[4,24,61,68],[4,24,62,67],
 [4,24,62,68],[4,26,36,37],[4,26,36,40],[4,26,36,43],
 [4,26,36,48],[4,26,36,49],[4,26,36,51],[4,26,36,59],
 [4,26,36,61],[4,26,36,62],[4,26,36,68],[4,26,37,38],
 [4,26,37,39],[4,26,37,42],[4,26,37,43],[4,26,37,44],
 [4,26,37,47],[4,26,37,48],[4,26,37,52],[4,26,37,59],
 [4,26,37,60],[4,26,37,61],[4,26,37,68],[4,26,38,40],
 [4,26,38,42],[4,26,38,43],[4,26,38,49],[4,26,38,51],
 [4,26,38,52],[4,26,38,60],[4,26,38,61],[4,26,38,62],
 [4,26,39,43],[4,26,39,47],[4,26,39,48],[4,26,39,49],
 [4,26,39,60],[4,26,39,61],[4,26,39,62],[4,26,40,42],
 [4,26,40,44],[4,26,40,48],[4,26,40,49],[4,26,40,52],
 [4,26,40,61],[4,26,40,68],[4,26,41,43],[4,26,41,44],
 [4,26,41,47],[4,26,41,48],[4,26,41,49],[4,26,41,59],
 [4,26,41,60],[4,26,41,61],[4,26,41,68],[4,26,42,43],
 [4,26,42,44],[4,26,42,47],[4,26,42,49],[4,26,42,60],
 [4,26,42,61],[4,26,42,62],[4,26,43,44],[4,26,43,48],
 [4,26,43,49],[4,26,43,52],[4,26,43,61],[4,26,43,62],
 [4,26,43,68],[4,26,44,47],[4,26,44,49],[4,26,44,52],
 [4,26,44,59],[4,26,44,60],[4,26,44,61],[4,26,44,68],
 [4,26,47,48],[4,26,47,49],[4,26,47,51],[4,26,47,52],
 [4,26,47,59],[4,26,47,61],[4,26,47,62],[4,26,47,68],
 [4,26,48,52],[4,26,48,60],[4,26,48,68],[4,26,49,52],
 [4,26,49,59],[4,26,49,60],[4,26,49,61],[4,26,49,68],
 [4,26,51,52],[4,26,51,60],[4,26,51,62],[4,26,51,68],
 [4,26,52,61],[4,26,52,62],[4,26,59,60],[4,26,59,61],
 [4,26,59,62],[4,26,59,68],[4,26,60,61],[4,26,60,62],
 [4,26,60,68],[4,26,61,68],[4,26,62,68],[4,27,33,37],
 [4,27,33,39],[4,27,33,40],[4,27,33,42],[4,27,33,48],
 [4,27,33,61],[4,27,33,62],[4,27,36,37],[4,27,36,40],
 [4,27,36,43],[4,27,36,48],[4,27,36,49],[4,27,36,51],
 [4,27,36,61],[4,27,36,62],[4,27,37,39],[4,27,37,42],
 [4,27,37,44],[4,27,37,47],[4,27,37,48],[4,27,37,52],
 [4,27,37,60],[4,27,37,61],[4,27,39,43],[4,27,39,47],
 [4,27,39,48],[4,27,39,49],[4,27,39,60],[4,27,39,61],
 [4,27,39,62],[4,27,40,42],[4,27,40,44],[4,27,40,48],
 [4,27,40,49],[4,27,40,52],[4,27,40,61],[4,27,41,43],
 [4,27,41,44],[4,27,41,47],[4,27,41,48],[4,27,41,49],
 [4,27,41,60],[4,27,41,61],[4,27,42,43],[4,27,42,44],
 [4,27,42,47],[4,27,42,49],[4,27,42,60],[4,27,42,61],
 [4,27,42,62],[4,27,43,44],[4,27,43,48],[4,27,43,49],
 [4,27,43,52],[4,27,43,61],[4,27,43,62],[4,27,44,47],
 [4,27,44,49],[4,27,44,52],[4,27,44,60],[4,27,44,61],
 [4,27,47,48],[4,27,47,49],[4,27,47,51],[4,27,47,52],
 [4,27,47,61],[4,27,47,62],[4,27,48,52],[4,27,48,60],
 [4,27,49,52],[4,27,49,60],[4,27,49,61],[4,27,51,52],
 [4,27,51,60],[4,27,51,62],[4,27,52,61],[4,27,52,62],
 [4,27,60,61],[4,27,60,62],[4,33,37,39],[4,33,37,42],
 [4,33,37,48],[4,33,37,59],[4,33,37,61],[4,33,37,68],
 [4,33,39,48],[4,33,39,49],[4,33,39,58],[4,33,39,61],
 [4,33,39,62],[4,33,40,42],[4,33,40,48],[4,33,40,49],
 [4,33,40,58],[4,33,40,61],[4,33,40,68],[4,33,42,49],
 [4,33,42,61],[4,33,42,62],[4,33,48,58],[4,33,48,68],
 [4,33,49,58],[4,33,49,59],[4,33,49,61],[4,33,49,68],
 [4,33,51,58],[4,33,51,62],[4,33,51,68],[4,33,58,61],
 [4,33,58,62],[4,33,59,61],[4,33,59,62],[4,33,59,68],
 [4,33,61,68],[4,33,62,68],[4,36,37,43],[4,36,37,48],
 [4,36,37,50],[4,36,37,61],[4,36,37,68],[4,36,40,48],
 [4,36,40,49],[4,36,40,50],[4,36,40,68],[4,36,43,48],
 [4,36,43,49],[4,36,43,62],[4,36,43,68],[4,36,48,50],
 [4,36,48,68],[4,36,49,50],[4,36,49,59],[4,36,49,61],
 [4,36,50,51],[4,36,50,59],[4,36,50,61],[4,36,50,62],
 [4,36,51,62],[4,36,59,61],[4,36,59,62],[4,36,61,68],
 [4,36,62,68],[4,37,38,42],[4,37,38,48],[4,37,38,52],
 [4,37,38,60],[4,37,38,61],[4,37,38,67],[4,37,39,43],
 [4,37,39,47],[4,37,39,48],[4,37,39,58],[4,37,39,60],
 [4,37,39,61],[4,37,39,67],[4,37,42,43],[4,37,42,44],
 [4,37,42,47],[4,37,42,50],[4,37,42,60],[4,37,42,61],
 [4,37,43,44],[4,37,43,48],[4,37,43,52],[4,37,43,58],
 [4,37,43,61],[4,37,43,67],[4,37,43,68],[4,37,44,47],
 [4,37,44,50],[4,37,44,52],[4,37,44,58],[4,37,44,59],
 [4,37,44,60],[4,37,44,61],[4,37,44,67],[4,37,47,48],
 [4,37,47,50],[4,37,47,58],[4,37,47,59],[4,37,47,61],
 [4,37,47,67],[4,37,48,50],[4,37,48,52],[4,37,48,58],
 [4,37,48,60],[4,37,48,67],[4,37,48,68],[4,37,50,59],
 [4,37,50,61],[4,37,52,61],[4,37,58,60],[4,37,58,61],
 [4,37,59,60],[4,37,59,61],[4,37,60,61],[4,37,60,67],
 [4,37,60,68],[4,37,61,67],[4,37,61,68],[4,38,40,42],
 [4,38,40,48],[4,38,40,49],[4,38,40,52],[4,38,40,61],
 [4,38,40,67],[4,38,42,43],[4,38,42,49],[4,38,42,60],
 [4,38,42,61],[4,38,42,62],[4,38,43,48],[4,38,43,49],
 [4,38,43,52],[4,38,43,61],[4,38,43,62],[4,38,43,67],
 [4,38,48,52],[4,38,48,60],[4,38,48,67],[4,38,49,52],
 [4,38,49,60],[4,38,49,61],[4,38,49,67],[4,38,51,52],
 [4,38,51,60],[4,38,51,62],[4,38,51,67],[4,38,52,61],
 [4,38,52,62],[4,38,60,61],[4,38,60,62],[4,38,60,67],
 [4,38,61,67],[4,38,62,67],[4,39,43,48],[4,39,43,49],
 [4,39,43,58],[4,39,43,61],[4,39,43,62],[4,39,43,67],
 [4,39,47,48],[4,39,47,49],[4,39,47,58],[4,39,47,61],
 [4,39,47,62],[4,39,47,67],[4,39,48,58],[4,39,48,60],
 [4,39,48,67],[4,39,49,58],[4,39,49,60],[4,39,49,61],
 [4,39,49,67],[4,39,58,60],[4,39,58,61],[4,39,58,62],
 [4,39,60,61],[4,39,60,62],[4,39,60,67],[4,39,61,67],
 [4,39,62,67],[4,40,42,44],[4,40,42,49],[4,40,42,50],
 [4,40,42,61],[4,40,44,49],[4,40,44,61],[4,40,44,68],
 [4,40,48,50],[4,40,48,52],[4,40,48,58],[4,40,48,67],
 [4,40,48,68],[4,40,49,50],[4,40,49,52],[4,40,49,58],
 [4,40,49,61],[4,40,49,67],[4,40,49,68],[4,40,50,61],
 [4,40,52,61],[4,40,61,68],[4,41,43,44],[4,41,43,48],
 [4,41,43,49],[4,41,43,61],[4,41,43,68],[4,41,44,47],
 [4,41,44,49],[4,41,44,50],[4,41,44,59],[4,41,44,60],
 [4,41,44,61],[4,41,44,68],[4,41,47,48],[4,41,47,49],
 [4,41,47,50],[4,41,47,59],[4,41,47,61],[4,41,47,68],
 [4,41,48,50],[4,41,48,60],[4,41,48,68],[4,41,49,50],
 [4,41,49,59],[4,41,49,60],[4,41,49,61],[4,41,49,68],
 [4,41,50,59],[4,41,50,61],[4,41,59,60],[4,41,59,61],
 [4,41,59,68],[4,41,60,61],[4,41,60,68],[4,41,61,68],
 [4,42,43,49],[4,42,43,62],[4,42,44,47],[4,42,44,49],
 [4,42,44,50],[4,42,44,61],[4,42,47,49],[4,42,47,50],
 [4,42,47,61],[4,42,47,62],[4,42,49,50],[4,42,49,60],
 [4,42,49,61],[4,42,50,61],[4,42,50,62],[4,42,60,62],
 [4,43,44,49],[4,43,44,58],[4,43,44,61],[4,43,44,67],
 [4,43,44,68],[4,43,48,52],[4,43,48,58],[4,43,48,67],
 [4,43,48,68],[4,43,49,52],[4,43,49,58],[4,43,49,61],
 [4,43,49,67],[4,43,49,68],[4,43,52,61],[4,43,58,61],
 [4,43,58,62],[4,43,61,67],[4,43,61,68],[4,43,62,67],
 [4,43,62,68],[4,44,47,49],[4,44,47,50],[4,44,47,58],
 [4,44,47,59],[4,44,47,61],[4,44,47,67],[4,44,47,68],
 [4,44,49,50],[4,44,49,52],[4,44,49,58],[4,44,49,59],
 [4,44,49,60],[4,44,49,61],[4,44,49,67],[4,44,49,68],
 [4,44,50,59],[4,44,50,61],[4,44,52,61],[4,44,58,60],
 [4,44,58,61],[4,44,59,60],[4,44,59,61],[4,44,59,68],
 [4,44,60,61],[4,44,60,67],[4,44,60,68],[4,44,61,67],
 [4,44,61,68],[4,47,48,50],[4,47,48,52],[4,47,48,58],
 [4,47,48,67],[4,47,48,68],[4,47,49,50],[4,47,49,58],
 [4,47,49,59],[4,47,49,61],[4,47,49,67],[4,47,49,68],
 [4,47,50,51],[4,47,50,59],[4,47,50,61],[4,47,50,62],
 [4,47,51,52],[4,47,51,62],[4,47,51,67],[4,47,52,61],
 [4,47,52,62],[4,47,58,61],[4,47,58,62],[4,47,59,61],
 [4,47,59,62],[4,47,59,68],[4,47,61,67],[4,47,61,68],
 [4,47,62,67],[4,47,62,68],[4,48,58,60],[4,48,60,67],
 [4,48,60,68],[4,49,50,59],[4,49,50,61],[4,49,52,61],
 [4,49,58,60],[4,49,58,61],[4,49,59,60],[4,49,59,61],
 [4,49,59,68],[4,49,60,61],[4,49,60,67],[4,49,60,68],
 [4,49,61,67],[4,49,61,68],[4,50,51,62],[4,50,59,61],
 [4,50,59,62],[4,51,52,62],[4,51,58,60],[4,51,58,62],
 [4,51,60,62],[4,51,60,67],[4,51,60,68],[4,51,62,67],
 [4,51,62,68],[4,58,60,61],[4,58,60,62],[4,59,60,61],
 [4,59,60,62],[4,59,60,68],[4,59,61,68],[4,59,62,68],
 [4,60,61,67],[4,60,61,68],[4,60,62,67],[4,60,62,68],
 [5,6,8,9],[5,6,8,15],[5,6,8,24],[5,6,8,26],
 [5,6,8,51],[5,6,8,61],[5,6,8,68],[5,6,9,14],
 [5,6,9,15],[5,6,9,20],[5,6,9,22],[5,6,9,23],
 [5,6,9,24],[5,6,9,26],[5,6,9,33],[5,6,9,35],
 [5,6,9,41],[5,6,9,44],[5,6,9,46],[5,6,9,47],
 [5,6,9,48],[5,6,9,49],[5,6,9,51],[5,6,9,54],
 [5,6,9,59],[5,6,9,61],[5,6,9,68],[5,6,14,15],
 [5,6,14,20],[5,6,14,22],[5,6,14,24],[5,6,14,26],
 [5,6,14,35],[5,6,14,45],[5,6,14,54],[5,6,14,61],
 [5,6,14,68],[5,6,15,20],[5,6,15,22],[5,6,15,23],
 [5,6,15,24],[5,6,15,26],[5,6,15,41],[5,6,15,44],
 [5,6,15,46],[5,6,15,47],[5,6,15,48],[5,6,15,49],
 [5,6,15,51],[5,6,15,54],[5,6,15,59],[5,6,15,61],
 [5,6,15,68],[5,6,20,22],[5,6,20,23],[5,6,20,24],
 [5,6,20,26],[5,6,20,35],[5,6,20,41],[5,6,20,44],
 [5,6,20,45],[5,6,20,46],[5,6,20,47],[5,6,20,49],
 [5,6,20,59],[5,6,20,61],[5,6,20,68],[5,6,22,23],
 [5,6,22,24],[5,6,22,26],[5,6,22,35],[5,6,22,41],
 [5,6,22,44],[5,6,22,47],[5,6,22,49],[5,6,22,59],
 [5,6,22,61],[5,6,22,68],[5,6,23,24],[5,6,23,26],
 [5,6,23,35],[5,6,23,45],[5,6,23,46],[5,6,23,48],
 [5,6,23,59],[5,6,23,61],[5,6,23,68],[5,6,24,26],
 [5,6,24,33],[5,6,24,35],[5,6,24,41],[5,6,24,44],
 [5,6,24,46],[5,6,24,47],[5,6,24,48],[5,6,24,49],
 [5,6,24,51],[5,6,24,54],[5,6,24,59],[5,6,24,61],
 [5,6,24,68],[5,6,26,35],[5,6,26,41],[5,6,26,44],
 [5,6,26,45],[5,6,26,46],[5,6,26,47],[5,6,26,48],
 [5,6,26,49],[5,6,26,51],[5,6,26,54],[5,6,26,59],
 [5,6,26,61],[5,6,26,68],[5,6,33,35],[5,6,33,45],
 [5,6,33,46],[5,6,33,48],[5,6,33,54],[5,6,33,61],
 [5,6,33,68],[5,6,35,41],[5,6,35,48],[5,6,35,68],
 [5,6,41,44],[5,6,41,45],[5,6,41,47],[5,6,41,49],
 [5,6,41,54],[5,6,41,59],[5,6,41,61],[5,6,41,68],
 [5,6,44,46],[5,6,44,47],[5,6,44,48],[5,6,44,49],
 [5,6,44,51],[5,6,44,54],[5,6,44,59],[5,6,44,61],
 [5,6,44,68],[5,6,45,46],[5,6,45,48],[5,6,45,68],
 [5,6,46,48],[5,6,46,59],[5,6,46,61],[5,6,46,68],
 [5,6,47,49],[5,6,47,59],[5,6,47,61],[5,6,47,68],
 [5,6,48,61],[5,6,48,68],[5,6,49,59],[5,6,49,61],
 [5,6,49,68],[5,6,51,61],[5,6,51,68],[5,6,54,61],
 [5,6,54,68],[5,6,59,61],[5,6,59,68],[5,6,61,68],
 [5,8,9,15],[5,8,9,24],[5,8,9,26],[5,8,9,51],
 [5,8,9,59],[5,8,9,61],[5,8,9,68],[5,8,12,15],
 [5,8,12,24],[5,8,12,26],[5,8,12,49],[5,8,12,61],
 [5,8,15,18],[5,8,15,24],[5,8,15,26],[5,8,15,27],
 [5,8,15,37],[5,8,15,49],[5,8,15,51],[5,8,15,53],
 [5,8,15,57],[5,8,15,59],[5,8,15,61],[5,8,15,62],
 [5,8,15,66],[5,8,15,68],[5,8,15,69],[5,8,18,24],
 [5,8,18,26],[5,8,18,43],[5,8,18,50],[5,8,18,51],
 [5,8,18,53],[5,8,18,57],[5,8,18,61],[5,8,18,66],
 [5,8,24,26],[5,8,24,27],[5,8,24,37],[5,8,24,49],
 [5,8,24,51],[5,8,24,53],[5,8,24,57],[5,8,24,59],
 [5,8,24,61],[5,8,24,62],[5,8,24,66],[5,8,24,68],
 [5,8,24,69],[5,8,26,27],[5,8,26,37],[5,8,26,49],
 [5,8,26,50],[5,8,26,51],[5,8,26,53],[5,8,26,57],
 [5,8,26,59],[5,8,26,61],[5,8,26,62],[5,8,26,68],
 [5,8,26,69],[5,8,27,43],[5,8,27,51],[5,8,27,53],
 [5,8,27,59],[5,8,27,61],[5,8,27,62],[5,8,27,69],
 [5,8,37,61],[5,8,37,62],[5,8,43,49],[5,8,43,57],
 [5,8,43,62],[5,8,43,69],[5,8,49,53],[5,8,49,61],
 [5,8,49,62],[5,8,49,69],[5,8,50,53],[5,8,50,59],
 [5,8,50,61],[5,8,50,62],[5,8,50,69],[5,8,51,53],
 [5,8,51,57],[5,8,51,59],[5,8,51,61],[5,8,51,62],
 [5,8,51,66],[5,8,51,68],[5,8,51,69],[5,8,53,62],
 [5,8,57,61],[5,8,59,61],[5,8,59,62],[5,8,59,68],
 [5,8,61,62],[5,8,61,68],[5,8,61,69],[5,8,62,66],
 [5,8,62,69],[5,8,66,69],[5,9,14,15],[5,9,14,20],
 [5,9,14,22],[5,9,14,24],[5,9,14,26],[5,9,14,49],
 [5,9,14,54],[5,9,14,61],[5,9,14,68],[5,9,15,20],
 [5,9,15,22],[5,9,15,23],[5,9,15,24],[5,9,15,26],
 [5,9,15,41],[5,9,15,44],[5,9,15,46],[5,9,15,47],
 [5,9,15,48],[5,9,15,49],[5,9,15,51],[5,9,15,54],
 [5,9,15,59],[5,9,15,61],[5,9,15,68],[5,9,20,22],
 [5,9,20,23],[5,9,20,24],[5,9,20,26],[5,9,20,41],
 [5,9,20,44],[5,9,20,46],[5,9,20,47],[5,9,20,49],
 [5,9,20,59],[5,9,20,61],[5,9,20,68],[5,9,22,23],
 [5,9,22,24],[5,9,22,26],[5,9,22,33],[5,9,22,35],
 [5,9,22,41],[5,9,22,44],[5,9,22,47],[5,9,22,48],
 [5,9,22,49],[5,9,22,59],[5,9,22,61],[5,9,22,68],
 [5,9,23,24],[5,9,23,26],[5,9,23,46],[5,9,23,48],
 [5,9,23,49],[5,9,23,59],[5,9,23,61],[5,9,23,68],
 [5,9,24,26],[5,9,24,33],[5,9,24,35],[5,9,24,41],
 [5,9,24,44],[5,9,24,46],[5,9,24,47],[5,9,24,48],
 [5,9,24,49],[5,9,24,51],[5,9,24,54],[5,9,24,59],
 [5,9,24,61],[5,9,24,68],[5,9,26,41],[5,9,26,44],
 [5,9,26,46],[5,9,26,47],[5,9,26,48],[5,9,26,49],
 [5,9,26,51],[5,9,26,54],[5,9,26,59],[5,9,26,61],
 [5,9,26,68],[5,9,33,35],[5,9,33,48],[5,9,33,49],
 [5,9,33,68],[5,9,35,41],[5,9,35,48],[5,9,35,49],
 [5,9,35,68],[5,9,41,44],[5,9,41,46],[5,9,41,47],
 [5,9,41,49],[5,9,41,54],[5,9,41,59],[5,9,41,61],
 [5,9,41,68],[5,9,44,46],[5,9,44,47],[5,9,44,48],
 [5,9,44,49],[5,9,44,51],[5,9,44,54],[5,9,44,59],
 [5,9,44,61],[5,9,44,68],[5,9,46,48],[5,9,46,49],
 [5,9,46,59],[5,9,46,61],[5,9,46,68],[5,9,47,49],
 [5,9,47,59],[5,9,47,61],[5,9,47,68],[5,9,48,49],
 [5,9,48,51],[5,9,48,59],[5,9,48,61],[5,9,48,68],
 [5,9,49,54],[5,9,49,59],[5,9,49,61],[5,9,49,68],
 [5,9,51,59],[5,9,51,61],[5,9,51,68],[5,9,54,59],
 [5,9,54,61],[5,9,54,68],[5,9,59,61],[5,9,59,68],
 [5,9,61,68],[5,12,13,23],[5,12,13,46],[5,12,13,51],
 [5,12,13,54],[5,12,14,15],[5,12,14,20],[5,12,14,22],
 [5,12,14,24],[5,12,14,26],[5,12,14,35],[5,12,14,45],
 [5,12,14,54],[5,12,14,61],[5,12,15,20],[5,12,15,22],
 [5,12,15,23],[5,12,15,24],[5,12,15,26],[5,12,15,44],
 [5,12,15,46],[5,12,15,47],[5,12,15,48],[5,12,15,49],
 [5,12,15,51],[5,12,15,54],[5,12,15,61],[5,12,20,24],
 [5,12,20,26],[5,12,20,35],[5,12,20,44],[5,12,20,45],
 [5,12,20,46],[5,12,20,47],[5,12,20,61],[5,12,22,23],
 [5,12,22,24],[5,12,22,26],[5,12,22,33],[5,12,22,35],
 [5,12,22,44],[5,12,22,48],[5,12,22,61],[5,12,23,24],
 [5,12,23,26],[5,12,23,35],[5,12,23,45],[5,12,23,46],
 [5,12,23,48],[5,12,23,61],[5,12,24,26],[5,12,24,33],
 [5,12,24,35],[5,12,24,44],[5,12,24,46],[5,12,24,47],
 [5,12,24,48],[5,12,24,49],[5,12,24,51],[5,12,24,54],
 [5,12,24,61],[5,12,26,35],[5,12,26,44],[5,12,26,45],
 [5,12,26,46],[5,12,26,47],[5,12,26,48],[5,12,26,49],
 [5,12,26,51],[5,12,26,54],[5,12,26,61],[5,12,33,35],
 [5,12,33,45],[5,12,33,46],[5,12,33,48],[5,12,33,54],
 [5,12,33,61],[5,12,35,45],[5,12,35,48],[5,12,35,49],
 [5,12,44,46],[5,12,44,47],[5,12,44,49],[5,12,44,54],
 [5,12,44,61],[5,12,45,46],[5,12,45,48],[5,12,45,49],
 [5,12,45,51],[5,12,45,61],[5,12,46,48],[5,12,46,49],
 [5,12,46,61],[5,12,47,61],[5,12,48,49],[5,12,48,51],
 [5,12,48,61],[5,12,49,61],[5,12,51,61],[5,12,54,61],
 [5,13,19,23],[5,13,19,26],[5,13,19,27],[5,13,19,34],
 [5,13,19,46],[5,13,19,48],[5,13,19,49],[5,13,19,51],
 [5,13,19,54],[5,13,19,57],[5,13,19,62],[5,13,19,69],
 [5,13,22,23],[5,13,22,26],[5,13,22,27],[5,13,22,48],
 [5,13,22,49],[5,13,22,50],[5,13,22,69],[5,13,23,26],
 [5,13,23,27],[5,13,23,34],[5,13,23,37],[5,13,23,45],
 [5,13,23,46],[5,13,23,48],[5,13,23,49],[5,13,23,50],
 [5,13,23,51],[5,13,23,57],[5,13,23,62],[5,13,23,66],
 [5,13,23,69],[5,13,26,27],[5,13,26,34],[5,13,26,45],
 [5,13,26,46],[5,13,26,48],[5,13,26,49],[5,13,26,50],
 [5,13,26,51],[5,13,26,54],[5,13,26,57],[5,13,26,62],
 [5,13,26,69],[5,13,27,34],[5,13,27,46],[5,13,27,48],
 [5,13,27,49],[5,13,27,51],[5,13,27,54],[5,13,27,62],
 [5,13,27,66],[5,13,27,69],[5,13,34,45],[5,13,34,46],
 [5,13,34,48],[5,13,34,49],[5,13,34,62],[5,13,34,66],
 [5,13,34,69],[5,13,37,46],[5,13,37,50],[5,13,37,54],
 [5,13,37,62],[5,13,45,46],[5,13,45,48],[5,13,45,49],
 [5,13,45,51],[5,13,45,57],[5,13,45,62],[5,13,45,66],
 [5,13,45,69],[5,13,46,48],[5,13,46,49],[5,13,46,57],
 [5,13,46,62],[5,13,46,66],[5,13,46,69],[5,13,48,49],
 [5,13,48,50],[5,13,48,51],[5,13,48,57],[5,13,48,62],
 [5,13,48,66],[5,13,48,69],[5,13,49,50],[5,13,49,54],
 [5,13,49,57],[5,13,49,62],[5,13,49,66],[5,13,49,69],
 [5,13,50,51],[5,13,50,62],[5,13,50,69],[5,13,51,57],
 [5,13,51,62],[5,13,51,69],[5,13,54,57],[5,13,54,62],
 [5,13,54,66],[5,13,54,69],[5,13,62,66],[5,13,62,69],
 [5,13,66,69],[5,14,15,18],[5,14,15,20],[5,14,15,22],
 [5,14,15,24],[5,14,15,26],[5,14,15,27],[5,14,15,37],
 [5,14,15,49],[5,14,15,53],[5,14,15,54],[5,14,15,57],
 [5,14,15,61],[5,14,15,62],[5,14,15,68],[5,14,15,69],
 [5,14,18,20],[5,14,18,22],[5,14,18,24],[5,14,18,26],
 [5,14,18,35],[5,14,18,43],[5,14,18,49],[5,14,18,50],
 [5,14,18,53],[5,14,18,54],[5,14,18,55],[5,14,18,57],
 [5,14,18,61],[5,14,18,66],[5,14,20,22],[5,14,20,24],
 [5,14,20,26],[5,14,20,27],[5,14,20,37],[5,14,20,45],
 [5,14,20,49],[5,14,20,57],[5,14,20,61],[5,14,20,66],
 [5,14,20,68],[5,14,22,24],[5,14,22,26],[5,14,22,27],
 [5,14,22,37],[5,14,22,43],[5,14,22,49],[5,14,22,53],
 [5,14,22,55],[5,14,22,61],[5,14,22,68],[5,14,22,69],
 [5,14,24,26],[5,14,24,27],[5,14,24,37],[5,14,24,49],
 [5,14,24,53],[5,14,24,54],[5,14,24,57],[5,14,24,61],
 [5,14,24,62],[5,14,24,68],[5,14,24,69],[5,14,26,27],
 [5,14,26,35],[5,14,26,37],[5,14,26,49],[5,14,26,50],
 [5,14,26,53],[5,14,26,54],[5,14,26,55],[5,14,26,57],
 [5,14,26,61],[5,14,26,62],[5,14,26,68],[5,14,26,69],
 [5,14,27,35],[5,14,27,43],[5,14,27,53],[5,14,27,54],
 [5,14,27,55],[5,14,27,61],[5,14,27,62],[5,14,27,66],
 [5,14,27,69],[5,14,35,37],[5,14,35,49],[5,14,35,55],
 [5,14,35,57],[5,14,35,62],[5,14,35,68],[5,14,35,69],
 [5,14,37,45],[5,14,37,50],[5,14,37,54],[5,14,37,61],
 [5,14,37,62],[5,14,43,49],[5,14,43,57],[5,14,43,62],
 [5,14,43,69],[5,14,45,53],[5,14,45,55],[5,14,45,57],
 [5,14,45,61],[5,14,45,62],[5,14,45,66],[5,14,45,68],
 [5,14,45,69],[5,14,49,50],[5,14,49,53],[5,14,49,54],
 [5,14,49,55],[5,14,49,57],[5,14,49,61],[5,14,49,66],
 [5,14,49,68],[5,14,50,53],[5,14,50,61],[5,14,50,62],
 [5,14,50,69],[5,14,53,54],[5,14,53,62],[5,14,54,57],
 [5,14,54,61],[5,14,54,62],[5,14,54,68],[5,14,54,69],
 [5,14,55,62],[5,14,55,66],[5,14,55,69],[5,14,57,61],
 [5,14,61,62],[5,14,61,68],[5,14,61,69],[5,14,62,66],
 [5,14,62,69],[5,14,66,69],[5,15,18,20],[5,15,18,22],
 [5,15,18,23],[5,15,18,24],[5,15,18,26],[5,15,18,41],
 [5,15,18,44],[5,15,18,46],[5,15,18,47],[5,15,18,48],
 [5,15,18,49],[5,15,18,51],[5,15,18,54],[5,15,18,57],
 [5,15,18,59],[5,15,18,61],[5,15,19,20],[5,15,19,23],
 [5,15,19,24],[5,15,19,26],[5,15,19,27],[5,15,19,34],
 [5,15,19,37],[5,15,19,46],[5,15,19,48],[5,15,19,49],
 [5,15,19,59],[5,15,19,62],[5,15,19,69],[5,15,20,22],
 [5,15,20,23],[5,15,20,24],[5,15,20,26],[5,15,20,27],
 [5,15,20,34],[5,15,20,37],[5,15,20,41],[5,15,20,44],
 [5,15,20,46],[5,15,20,47],[5,15,20,49],[5,15,20,57],
 [5,15,20,59],[5,15,20,61],[5,15,20,66],[5,15,20,68],
 [5,15,20,69],[5,15,22,23],[5,15,22,24],[5,15,22,26],
 [5,15,22,27],[5,15,22,37],[5,15,22,41],[5,15,22,44],
 [5,15,22,47],[5,15,22,48],[5,15,22,49],[5,15,22,59],
 [5,15,22,61],[5,15,22,68],[5,15,22,69],[5,15,23,24],
 [5,15,23,26],[5,15,23,27],[5,15,23,34],[5,15,23,37],
 [5,15,23,46],[5,15,23,48],[5,15,23,49],[5,15,23,53],
 [5,15,23,57],[5,15,23,59],[5,15,23,61],[5,15,23,62],
 [5,15,23,66],[5,15,23,68],[5,15,23,69],[5,15,24,26],
 [5,15,24,27],[5,15,24,34],[5,15,24,37],[5,15,24,41],
 [5,15,24,44],[5,15,24,46],[5,15,24,47],[5,15,24,48],
 [5,15,24,49],[5,15,24,51],[5,15,24,54],[5,15,24,57],
 [5,15,24,59],[5,15,24,61],[5,15,24,62],[5,15,24,66],
 [5,15,24,68],[5,15,24,69],[5,15,26,27],[5,15,26,34],
 [5,15,26,37],[5,15,26,41],[5,15,26,44],[5,15,26,46],
 [5,15,26,47],[5,15,26,48],[5,15,26,49],[5,15,26,51],
 [5,15,26,54],[5,15,26,57],[5,15,26,59],[5,15,26,61],
 [5,15,26,62],[5,15,26,68],[5,15,26,69],[5,15,27,34],
 [5,15,27,46],[5,15,27,47],[5,15,27,48],[5,15,27,49],
 [5,15,27,51],[5,15,27,54],[5,15,27,59],[5,15,27,61],
 [5,15,27,62],[5,15,27,66],[5,15,27,69],[5,15,34,44],
 [5,15,34,46],[5,15,34,48],[5,15,34,49],[5,15,34,61],
 [5,15,34,62],[5,15,34,66],[5,15,34,69],[5,15,37,44],
 [5,15,37,46],[5,15,37,47],[5,15,37,48],[5,15,37,54],
 [5,15,37,61],[5,15,41,44],[5,15,41,46],[5,15,41,47],
 [5,15,41,49],[5,15,41,54],[5,15,41,59],[5,15,41,61],
 [5,15,41,62],[5,15,41,68],[5,15,44,46],[5,15,44,47],
 [5,15,44,48],[5,15,44,49],[5,15,44,51],[5,15,44,54],
 [5,15,44,57],[5,15,44,59],[5,15,44,61],[5,15,44,62],
 [5,15,44,66],[5,15,44,68],[5,15,44,69],[5,15,46,48],
 [5,15,46,49],[5,15,46,53],[5,15,46,57],[5,15,46,59],
 [5,15,46,61],[5,15,46,62],[5,15,46,66],[5,15,46,68],
 [5,15,46,69],[5,15,47,49],[5,15,47,53],[5,15,47,57],
 [5,15,47,59],[5,15,47,61],[5,15,47,62],[5,15,47,68],
 [5,15,47,69],[5,15,48,49],[5,15,48,51],[5,15,48,53],
 [5,15,48,57],[5,15,48,59],[5,15,48,61],[5,15,48,62],
 [5,15,48,66],[5,15,48,68],[5,15,48,69],[5,15,49,53],
 [5,15,49,54],[5,15,49,57],[5,15,49,59],[5,15,49,61],
 [5,15,49,62],[5,15,49,66],[5,15,49,68],[5,15,49,69],
 [5,15,51,53],[5,15,51,57],[5,15,51,59],[5,15,51,61],
 [5,15,51,62],[5,15,51,66],[5,15,51,68],[5,15,51,69],
 [5,15,53,54],[5,15,54,57],[5,15,54,59],[5,15,54,61],
 [5,15,54,62],[5,15,54,68],[5,15,54,69],[5,15,57,61],
 [5,15,59,61],[5,15,59,62],[5,15,59,68],[5,15,61,62],
 [5,15,61,68],[5,15,61,69],[5,15,62,66],[5,15,62,69],
 [5,15,66,69],[5,18,20,22],[5,18,20,23],[5,18,20,24],
 [5,18,20,26],[5,18,20,35],[5,18,20,41],[5,18,20,43],
 [5,18,20,44],[5,18,20,46],[5,18,20,47],[5,18,20,49],
 [5,18,20,57],[5,18,20,59],[5,18,20,61],[5,18,20,66],
 [5,18,22,23],[5,18,22,24],[5,18,22,26],[5,18,22,33],
 [5,18,22,35],[5,18,22,41],[5,18,22,43],[5,18,22,44],
 [5,18,22,47],[5,18,22,48],[5,18,22,49],[5,18,22,53],
 [5,18,22,55],[5,18,22,59],[5,18,22,61],[5,18,23,24],
 [5,18,23,26],[5,18,23,35],[5,18,23,43],[5,18,23,46],
 [5,18,23,48],[5,18,23,50],[5,18,23,51],[5,18,23,53],
 [5,18,23,55],[5,18,23,57],[5,18,23,61],[5,18,23,66],
 [5,18,24,26],[5,18,24,33],[5,18,24,35],[5,18,24,41],
 [5,18,24,44],[5,18,24,46],[5,18,24,47],[5,18,24,48],
 [5,18,24,49],[5,18,24,51],[5,18,24,53],[5,18,24,54],
 [5,18,24,57],[5,18,24,59],[5,18,24,61],[5,18,24,66],
 [5,18,26,35],[5,18,26,41],[5,18,26,44],[5,18,26,46],
 [5,18,26,47],[5,18,26,48],[5,18,26,49],[5,18,26,50],
 [5,18,26,51],[5,18,26,53],[5,18,26,54],[5,18,26,55],
 [5,18,26,57],[5,18,26,59],[5,18,26,61],[5,18,33,35],
 [5,18,33,46],[5,18,33,48],[5,18,33,53],[5,18,33,54],
 [5,18,33,61],[5,18,33,66],[5,18,35,41],[5,18,35,48],
 [5,18,35,49],[5,18,35,50],[5,18,41,44],[5,18,41,47],
 [5,18,41,49],[5,18,41,54],[5,18,41,59],[5,18,41,61],
 [5,18,43,46],[5,18,43,48],[5,18,43,49],[5,18,43,57],
 [5,18,44,47],[5,18,44,48],[5,18,44,49],[5,18,44,50],
 [5,18,44,51],[5,18,44,54],[5,18,44,57],[5,18,44,59],
 [5,18,44,61],[5,18,46,48],[5,18,46,50],[5,18,46,53],
 [5,18,46,55],[5,18,46,57],[5,18,46,59],[5,18,46,61],
 [5,18,46,66],[5,18,47,49],[5,18,47,50],[5,18,47,53],
 [5,18,47,57],[5,18,47,59],[5,18,47,61],[5,18,48,50],
 [5,18,48,51],[5,18,48,53],[5,18,48,55],[5,18,48,57],
 [5,18,48,59],[5,18,48,61],[5,18,48,66],[5,18,49,50],
 [5,18,49,53],[5,18,49,54],[5,18,49,55],[5,18,49,57],
 [5,18,49,59],[5,18,49,61],[5,18,49,66],[5,18,50,51],
 [5,18,50,53],[5,18,50,54],[5,18,50,59],[5,18,50,61],
 [5,18,51,53],[5,18,51,55],[5,18,51,57],[5,18,51,59],
 [5,18,51,61],[5,18,51,66],[5,18,53,54],[5,18,54,57],
 [5,18,54,59],[5,18,54,61],[5,18,54,66],[5,18,55,66],
 [5,18,57,61],[5,18,59,61],[5,19,20,23],[5,19,20,24],
 [5,19,20,26],[5,19,20,27],[5,19,20,34],[5,19,20,43],
 [5,19,20,46],[5,19,20,49],[5,19,20,59],[5,19,20,69],
 [5,19,23,24],[5,19,23,26],[5,19,23,27],[5,19,23,34],
 [5,19,23,37],[5,19,23,43],[5,19,23,46],[5,19,23,48],
 [5,19,23,49],[5,19,23,53],[5,19,23,55],[5,19,23,57],
 [5,19,23,59],[5,19,23,62],[5,19,23,69],[5,19,24,26],
 [5,19,24,27],[5,19,24,34],[5,19,24,37],[5,19,24,43],
 [5,19,24,46],[5,19,24,48],[5,19,24,49],[5,19,24,53],
 [5,19,24,57],[5,19,24,59],[5,19,24,62],[5,19,24,69],
 [5,19,26,27],[5,19,26,34],[5,19,26,37],[5,19,26,46],
 [5,19,26,48],[5,19,26,49],[5,19,26,51],[5,19,26,54],
 [5,19,26,55],[5,19,26,59],[5,19,26,62],[5,19,26,69],
 [5,19,27,34],[5,19,27,43],[5,19,27,46],[5,19,27,48],
 [5,19,27,49],[5,19,27,51],[5,19,27,54],[5,19,27,55],
 [5,19,27,59],[5,19,27,62],[5,19,27,69],[5,19,34,43],
 [5,19,34,46],[5,19,34,48],[5,19,34,49],[5,19,34,55],
 [5,19,34,62],[5,19,34,69],[5,19,37,46],[5,19,37,48],
 [5,19,37,54],[5,19,37,62],[5,19,43,46],[5,19,43,48],
 [5,19,43,49],[5,19,43,62],[5,19,43,69],[5,19,46,48],
 [5,19,46,49],[5,19,46,53],[5,19,46,55],[5,19,46,57],
 [5,19,46,59],[5,19,46,62],[5,19,46,69],[5,19,48,49],
 [5,19,48,51],[5,19,48,53],[5,19,48,55],[5,19,48,57],
 [5,19,48,59],[5,19,48,62],[5,19,48,69],[5,19,49,53],
 [5,19,49,54],[5,19,49,55],[5,19,49,57],[5,19,49,59],
 [5,19,49,62],[5,19,49,69],[5,19,51,53],[5,19,51,59],
 [5,19,51,69],[5,19,53,54],[5,19,53,62],[5,19,54,57],
 [5,19,54,59],[5,19,54,62],[5,19,54,69],[5,19,55,62],
 [5,19,55,69],[5,19,59,62],[5,19,62,69],[5,20,22,23],
 [5,20,22,24],[5,20,22,26],[5,20,22,27],[5,20,22,37],
 [5,20,22,41],[5,20,22,43],[5,20,22,44],[5,20,22,47],
 [5,20,22,49],[5,20,22,59],[5,20,22,61],[5,20,22,68],
 [5,20,22,69],[5,20,23,24],[5,20,23,26],[5,20,23,27],
 [5,20,23,34],[5,20,23,37],[5,20,23,43],[5,20,23,45],
 [5,20,23,46],[5,20,23,49],[5,20,23,57],[5,20,23,59],
 [5,20,23,61],[5,20,23,66],[5,20,23,68],[5,20,23,69],
 [5,20,24,26],[5,20,24,27],[5,20,24,34],[5,20,24,37],
 [5,20,24,41],[5,20,24,43],[5,20,24,44],[5,20,24,46],
 [5,20,24,47],[5,20,24,49],[5,20,24,57],[5,20,24,59],
 [5,20,24,61],[5,20,24,66],[5,20,24,68],[5,20,24,69],
 [5,20,26,27],[5,20,26,34],[5,20,26,35],[5,20,26,37],
 [5,20,26,41],[5,20,26,44],[5,20,26,45],[5,20,26,46],
 [5,20,26,47],[5,20,26,49],[5,20,26,57],[5,20,26,59],
 [5,20,26,61],[5,20,26,68],[5,20,26,69],[5,20,27,34],
 [5,20,27,35],[5,20,27,37],[5,20,27,43],[5,20,27,46],
 [5,20,27,47],[5,20,27,49],[5,20,27,59],[5,20,27,61],
 [5,20,27,66],[5,20,27,69],[5,20,34,43],[5,20,34,44],
 [5,20,34,45],[5,20,34,46],[5,20,34,49],[5,20,34,61],
 [5,20,34,66],[5,20,34,69],[5,20,35,37],[5,20,35,41],
 [5,20,35,45],[5,20,35,49],[5,20,35,57],[5,20,35,66],
 [5,20,35,68],[5,20,35,69],[5,20,37,44],[5,20,37,45],
 [5,20,37,46],[5,20,37,47],[5,20,37,61],[5,20,41,44],
 [5,20,41,45],[5,20,41,46],[5,20,41,47],[5,20,41,49],
 [5,20,41,59],[5,20,41,61],[5,20,41,68],[5,20,43,46],
 [5,20,43,49],[5,20,43,69],[5,20,44,45],[5,20,44,46],
 [5,20,44,47],[5,20,44,49],[5,20,44,57],[5,20,44,59],
 [5,20,44,61],[5,20,44,66],[5,20,44,68],[5,20,44,69],
 [5,20,45,46],[5,20,45,49],[5,20,45,57],[5,20,45,61],
 [5,20,45,66],[5,20,45,68],[5,20,45,69],[5,20,46,49],
 [5,20,46,57],[5,20,46,59],[5,20,46,61],[5,20,46,66],
 [5,20,46,68],[5,20,46,69],[5,20,47,49],[5,20,47,57],
 [5,20,47,59],[5,20,47,61],[5,20,47,68],[5,20,47,69],
 [5,20,49,57],[5,20,49,59],[5,20,49,61],[5,20,49,66],
 [5,20,49,68],[5,20,49,69],[5,20,57,61],[5,20,59,61],
 [5,20,59,68],[5,20,61,68],[5,20,61,69],[5,20,66,69],
 [5,22,23,24],[5,22,23,26],[5,22,23,27],[5,22,23,37],
 [5,22,23,43],[5,22,23,48],[5,22,23,49],[5,22,23,53],
 [5,22,23,55],[5,22,23,59],[5,22,23,61],[5,22,23,68],
 [5,22,23,69],[5,22,24,26],[5,22,24,27],[5,22,24,33],
 [5,22,24,35],[5,22,24,37],[5,22,24,41],[5,22,24,43],
 [5,22,24,44],[5,22,24,47],[5,22,24,48],[5,22,24,49],
 [5,22,24,59],[5,22,24,61],[5,22,24,68],[5,22,24,69],
 [5,22,26,27],[5,22,26,35],[5,22,26,37],[5,22,26,41],
 [5,22,26,44],[5,22,26,47],[5,22,26,48],[5,22,26,49],
 [5,22,26,55],[5,22,26,59],[5,22,26,61],[5,22,26,68],
 [5,22,26,69],[5,22,27,33],[5,22,27,37],[5,22,27,43],
 [5,22,27,47],[5,22,27,48],[5,22,27,49],[5,22,27,53],
 [5,22,27,55],[5,22,27,59],[5,22,27,61],[5,22,27,69],
 [5,22,33,35],[5,22,33,37],[5,22,33,43],[5,22,33,49],
 [5,22,33,50],[5,22,33,61],[5,22,33,68],[5,22,33,69],
 [5,22,35,37],[5,22,35,41],[5,22,35,49],[5,22,35,50],
 [5,22,35,68],[5,22,35,69],[5,22,37,44],[5,22,37,47],
 [5,22,37,50],[5,22,37,61],[5,22,41,44],[5,22,41,47],
 [5,22,41,49],[5,22,41,59],[5,22,41,61],[5,22,41,68],
 [5,22,43,48],[5,22,43,49],[5,22,43,69],[5,22,44,47],
 [5,22,44,48],[5,22,44,49],[5,22,44,50],[5,22,44,59],
 [5,22,44,61],[5,22,44,68],[5,22,44,69],[5,22,47,49],
 [5,22,47,50],[5,22,47,53],[5,22,47,59],[5,22,47,61],
 [5,22,47,68],[5,22,47,69],[5,22,48,49],[5,22,48,50],
 [5,22,48,55],[5,22,48,59],[5,22,48,61],[5,22,48,68],
 [5,22,48,69],[5,22,49,50],[5,22,49,53],[5,22,49,55],
 [5,22,49,59],[5,22,49,61],[5,22,49,68],[5,22,49,69],
 [5,22,50,69],[5,22,55,69],[5,22,59,61],[5,22,59,68],
 [5,22,61,68],[5,22,61,69],[5,23,24,26],[5,23,24,27],
 [5,23,24,34],[5,23,24,37],[5,23,24,43],[5,23,24,46],
 [5,23,24,48],[5,23,24,49],[5,23,24,53],[5,23,24,57],
 [5,23,24,59],[5,23,24,61],[5,23,24,62],[5,23,24,66],
 [5,23,24,68],[5,23,24,69],[5,23,26,27],[5,23,26,34],
 [5,23,26,35],[5,23,26,37],[5,23,26,45],[5,23,26,46],
 [5,23,26,48],[5,23,26,49],[5,23,26,50],[5,23,26,51],
 [5,23,26,53],[5,23,26,55],[5,23,26,57],[5,23,26,59],
 [5,23,26,61],[5,23,26,62],[5,23,26,68],[5,23,26,69],
 [5,23,27,34],[5,23,27,35],[5,23,27,43],[5,23,27,46],
 [5,23,27,48],[5,23,27,49],[5,23,27,53],[5,23,27,55],
 [5,23,27,59],[5,23,27,61],[5,23,27,62],[5,23,27,66],
 [5,23,27,69],[5,23,34,43],[5,23,34,45],[5,23,34,46],
 [5,23,34,48],[5,23,34,49],[5,23,34,55],[5,23,34,61],
 [5,23,34,62],[5,23,34,66],[5,23,34,69],[5,23,35,37],
 [5,23,35,45],[5,23,35,48],[5,23,35,49],[5,23,35,55],
 [5,23,35,57],[5,23,35,62],[5,23,35,66],[5,23,35,68],
 [5,23,35,69],[5,23,37,45],[5,23,37,46],[5,23,37,48],
 [5,23,37,61],[5,23,37,62],[5,23,43,46],[5,23,43,48],
 [5,23,43,49],[5,23,43,57],[5,23,43,62],[5,23,43,69],
 [5,23,45,46],[5,23,45,48],[5,23,45,49],[5,23,45,51],
 [5,23,45,53],[5,23,45,55],[5,23,45,57],[5,23,45,61],
 [5,23,45,62],[5,23,45,66],[5,23,45,68],[5,23,45,69],
 [5,23,46,48],[5,23,46,49],[5,23,46,53],[5,23,46,55],
 [5,23,46,57],[5,23,46,59],[5,23,46,61],[5,23,46,62],
 [5,23,46,66],[5,23,46,68],[5,23,46,69],[5,23,48,49],
 [5,23,48,50],[5,23,48,51],[5,23,48,53],[5,23,48,55],
 [5,23,48,57],[5,23,48,59],[5,23,48,61],[5,23,48,62],
 [5,23,48,66],[5,23,48,68],[5,23,48,69],[5,23,49,53],
 [5,23,49,55],[5,23,49,59],[5,23,49,61],[5,23,49,62],
 [5,23,49,66],[5,23,49,68],[5,23,49,69],[5,23,50,51],
 [5,23,50,53],[5,23,50,59],[5,23,50,61],[5,23,50,62],
 [5,23,50,69],[5,23,51,53],[5,23,51,55],[5,23,51,59],
 [5,23,51,61],[5,23,51,62],[5,23,51,68],[5,23,51,69],
 [5,23,53,62],[5,23,55,62],[5,23,55,66],[5,23,55,69],
 [5,23,57,61],[5,23,59,61],[5,23,59,62],[5,23,59,68],
 [5,23,61,62],[5,23,61,68],[5,23,61,69],[5,23,62,66],
 [5,23,62,69],[5,23,66,69],[5,24,26,27],[5,24,26,34],
 [5,24,26,37],[5,24,26,41],[5,24,26,44],[5,24,26,46],
 [5,24,26,47],[5,24,26,48],[5,24,26,49],[5,24,26,51],
 [5,24,26,54],[5,24,26,57],[5,24,26,59],[5,24,26,61],
 [5,24,26,62],[5,24,26,68],[5,24,26,69],[5,24,27,33],
 [5,24,27,34],[5,24,27,35],[5,24,27,37],[5,24,27,43],
 [5,24,27,46],[5,24,27,47],[5,24,27,48],[5,24,27,49],
 [5,24,27,51],[5,24,27,53],[5,24,27,54],[5,24,27,59],
 [5,24,27,61],[5,24,27,62],[5,24,27,66],[5,24,27,69],
 [5,24,33,35],[5,24,33,37],[5,24,33,48],[5,24,33,49],
 [5,24,33,57],[5,24,33,62],[5,24,33,66],[5,24,33,68],
 [5,24,33,69],[5,24,34,43],[5,24,34,44],[5,24,34,46],
 [5,24,34,48],[5,24,34,49],[5,24,34,61],[5,24,34,62],
 [5,24,34,66],[5,24,34,69],[5,24,35,37],[5,24,35,41],
 [5,24,35,48],[5,24,35,49],[5,24,35,57],[5,24,35,62],
 [5,24,35,66],[5,24,35,68],[5,24,35,69],[5,24,37,44],
 [5,24,37,46],[5,24,37,47],[5,24,37,48],[5,24,37,54],
 [5,24,37,61],[5,24,37,62],[5,24,41,44],[5,24,41,46],
 [5,24,41,47],[5,24,41,49],[5,24,41,54],[5,24,41,59],
 [5,24,41,61],[5,24,41,62],[5,24,41,68],[5,24,43,46],
 [5,24,43,48],[5,24,43,49],[5,24,43,57],[5,24,43,62],
 [5,24,43,69],[5,24,44,46],[5,24,44,47],[5,24,44,48],
 [5,24,44,49],[5,24,44,51],[5,24,44,54],[5,24,44,57],
 [5,24,44,59],[5,24,44,61],[5,24,44,62],[5,24,44,66],
 [5,24,44,68],[5,24,44,69],[5,24,46,48],[5,24,46,49],
 [5,24,46,53],[5,24,46,57],[5,24,46,59],[5,24,46,61],
 [5,24,46,62],[5,24,46,66],[5,24,46,68],[5,24,46,69],
 [5,24,47,49],[5,24,47,53],[5,24,47,57],[5,24,47,59],
 [5,24,47,61],[5,24,47,62],[5,24,47,68],[5,24,47,69],
 [5,24,48,49],[5,24,48,51],[5,24,48,53],[5,24,48,57],
 [5,24,48,59],[5,24,48,61],[5,24,48,62],[5,24,48,66],
 [5,24,48,68],[5,24,48,69],[5,24,49,53],[5,24,49,54],
 [5,24,49,57],[5,24,49,59],[5,24,49,61],[5,24,49,62],
 [5,24,49,66],[5,24,49,68],[5,24,49,69],[5,24,51,53],
 [5,24,51,57],[5,24,51,59],[5,24,51,61],[5,24,51,62],
 [5,24,51,66],[5,24,51,68],[5,24,51,69],[5,24,53,54],
 [5,24,53,62],[5,24,54,57],[5,24,54,59],[5,24,54,61],
 [5,24,54,62],[5,24,54,68],[5,24,54,69],[5,24,57,61],
 [5,24,59,61],[5,24,59,62],[5,24,59,68],[5,24,61,62],
 [5,24,61,68],[5,24,61,69],[5,24,62,66],[5,24,62,69],
 [5,24,66,69],[5,26,27,34],[5,26,27,35],[5,26,27,46],
 [5,26,27,47],[5,26,27,48],[5,26,27,49],[5,26,27,51],
 [5,26,27,54],[5,26,27,55],[5,26,27,59],[5,26,27,61],
 [5,26,27,62],[5,26,27,69],[5,26,34,44],[5,26,34,45],
 [5,26,34,46],[5,26,34,48],[5,26,34,49],[5,26,34,55],
 [5,26,34,61],[5,26,34,62],[5,26,34,69],[5,26,35,37],
 [5,26,35,41],[5,26,35,45],[5,26,35,48],[5,26,35,49],
 [5,26,35,55],[5,26,35,57],[5,26,35,62],[5,26,35,68],
 [5,26,35,69],[5,26,37,44],[5,26,37,45],[5,26,37,46],
 [5,26,37,47],[5,26,37,48],[5,26,37,54],[5,26,37,61],
 [5,26,37,62],[5,26,41,44],[5,26,41,45],[5,26,41,46],
 [5,26,41,47],[5,26,41,49],[5,26,41,54],[5,26,41,59],
 [5,26,41,61],[5,26,41,62],[5,26,41,68],[5,26,44,45],
 [5,26,44,46],[5,26,44,47],[5,26,44,48],[5,26,44,49],
 [5,26,44,50],[5,26,44,51],[5,26,44,54],[5,26,44,57],
 [5,26,44,59],[5,26,44,61],[5,26,44,62],[5,26,44,68],
 [5,26,44,69],[5,26,45,46],[5,26,45,48],[5,26,45,49],
 [5,26,45,51],[5,26,45,53],[5,26,45,55],[5,26,45,57],
 [5,26,45,61],[5,26,45,62],[5,26,45,68],[5,26,45,69],
 [5,26,46,48],[5,26,46,49],[5,26,46,50],[5,26,46,53],
 [5,26,46,55],[5,26,46,57],[5,26,46,59],[5,26,46,61],
 [5,26,46,62],[5,26,46,68],[5,26,46,69],[5,26,47,49],
 [5,26,47,50],[5,26,47,53],[5,26,47,57],[5,26,47,59],
 [5,26,47,61],[5,26,47,62],[5,26,47,68],[5,26,47,69],
 [5,26,48,49],[5,26,48,50],[5,26,48,51],[5,26,48,53],
 [5,26,48,55],[5,26,48,57],[5,26,48,59],[5,26,48,61],
 [5,26,48,62],[5,26,48,68],[5,26,48,69],[5,26,49,50],
 [5,26,49,53],[5,26,49,54],[5,26,49,55],[5,26,49,57],
 [5,26,49,59],[5,26,49,61],[5,26,49,62],[5,26,49,68],
 [5,26,49,69],[5,26,50,51],[5,26,50,53],[5,26,50,54],
 [5,26,50,62],[5,26,51,53],[5,26,51,57],[5,26,51,59],
 [5,26,51,61],[5,26,51,62],[5,26,51,68],[5,26,51,69],
 [5,26,53,54],[5,26,53,62],[5,26,54,57],[5,26,54,59],
 [5,26,54,61],[5,26,54,62],[5,26,54,68],[5,26,54,69],
 [5,26,55,62],[5,26,55,69],[5,26,57,61],[5,26,59,61],
 [5,26,59,62],[5,26,59,68],[5,26,61,62],[5,26,61,68],
 [5,26,61,69],[5,26,62,69],[5,27,33,35],[5,27,33,37],
 [5,27,33,46],[5,27,33,48],[5,27,33,54],[5,27,33,61],
 [5,27,33,62],[5,27,34,43],[5,27,34,46],[5,27,34,48],
 [5,27,34,49],[5,27,34,55],[5,27,34,61],[5,27,34,62],
 [5,27,34,66],[5,27,34,69],[5,27,35,37],[5,27,35,48],
 [5,27,35,49],[5,27,35,55],[5,27,35,62],[5,27,35,66],
 [5,27,35,69],[5,27,37,46],[5,27,37,47],[5,27,37,48],
 [5,27,37,54],[5,27,37,61],[5,27,37,62],[5,27,43,46],
 [5,27,43,48],[5,27,43,49],[5,27,43,62],[5,27,43,69],
 [5,27,46,48],[5,27,46,49],[5,27,46,53],[5,27,46,55],
 [5,27,46,59],[5,27,46,61],[5,27,46,62],[5,27,46,66],
 [5,27,46,69],[5,27,47,49],[5,27,47,53],[5,27,47,59],
 [5,27,47,61],[5,27,47,62],[5,27,47,69],[5,27,48,49],
 [5,27,48,51],[5,27,48,53],[5,27,48,55],[5,27,48,59],
 [5,27,48,61],[5,27,48,62],[5,27,48,66],[5,27,48,69],
 [5,27,49,53],[5,27,49,55],[5,27,49,59],[5,27,49,61],
 [5,27,49,62],[5,27,49,66],[5,27,49,69],[5,27,51,53],
 [5,27,51,59],[5,27,51,61],[5,27,51,62],[5,27,51,66],
 [5,27,51,69],[5,27,53,54],[5,27,53,62],[5,27,54,61],
 [5,27,54,62],[5,27,54,69],[5,27,55,62],[5,27,55,66],
 [5,27,55,69],[5,27,59,61],[5,27,59,62],[5,27,61,62],
 [5,27,61,69],[5,27,62,66],[5,27,62,69],[5,27,66,69],
 [5,33,34,43],[5,33,34,45],[5,33,34,46],[5,33,34,48],
 [5,33,34,49],[5,33,34,50],[5,33,34,55],[5,33,34,61],
 [5,33,34,62],[5,33,34,66],[5,33,34,69],[5,33,35,37],
 [5,33,35,45],[5,33,35,48],[5,33,35,49],[5,33,35,55],
 [5,33,35,57],[5,33,35,62],[5,33,35,66],[5,33,35,68],
 [5,33,35,69],[5,33,37,45],[5,33,37,46],[5,33,37,48],
 [5,33,37,54],[5,33,37,61],[5,33,37,62],[5,33,43,46],
 [5,33,43,48],[5,33,43,62],[5,33,43,69],[5,33,45,46],
 [5,33,45,48],[5,33,45,49],[5,33,45,51],[5,33,45,53],
 [5,33,45,55],[5,33,45,57],[5,33,45,61],[5,33,45,62],
 [5,33,45,66],[5,33,45,68],[5,33,45,69],[5,33,46,48],
 [5,33,46,49],[5,33,46,50],[5,33,46,53],[5,33,46,55],
 [5,33,46,57],[5,33,46,61],[5,33,46,62],[5,33,46,66],
 [5,33,46,68],[5,33,46,69],[5,33,48,49],[5,33,48,50],
 [5,33,48,51],[5,33,48,53],[5,33,48,57],[5,33,48,61],
 [5,33,48,62],[5,33,48,66],[5,33,48,68],[5,33,48,69],
 [5,33,49,50],[5,33,49,53],[5,33,49,54],[5,33,49,57],
 [5,33,49,61],[5,33,49,62],[5,33,49,66],[5,33,49,68],
 [5,33,49,69],[5,33,50,61],[5,33,50,62],[5,33,50,69],
 [5,33,51,53],[5,33,51,55],[5,33,51,57],[5,33,51,61],
 [5,33,51,62],[5,33,51,68],[5,33,51,69],[5,33,53,54],
 [5,33,53,62],[5,33,54,57],[5,33,54,61],[5,33,54,62],
 [5,33,54,68],[5,33,54,69],[5,33,55,62],[5,33,55,69],
 [5,33,57,61],[5,33,61,62],[5,33,61,68],[5,33,61,69],
 [5,33,62,66],[5,33,62,69],[5,33,66,69],[5,34,43,46],
 [5,34,43,48],[5,34,43,49],[5,34,43,62],[5,34,43,69],
 [5,34,44,45],[5,34,44,46],[5,34,44,48],[5,34,44,49],
 [5,34,44,50],[5,34,44,61],[5,34,44,62],[5,34,44,66],
 [5,34,44,69],[5,34,45,46],[5,34,45,48],[5,34,45,49],
 [5,34,45,55],[5,34,45,61],[5,34,45,62],[5,34,45,66],
 [5,34,45,69],[5,34,46,48],[5,34,46,49],[5,34,46,50],
 [5,34,46,55],[5,34,46,61],[5,34,46,62],[5,34,46,66],
 [5,34,46,69],[5,34,48,49],[5,34,48,50],[5,34,48,55],
 [5,34,48,61],[5,34,48,62],[5,34,48,66],[5,34,48,69],
 [5,34,49,50],[5,34,49,55],[5,34,49,61],[5,34,49,62],
 [5,34,49,66],[5,34,49,69],[5,34,50,61],[5,34,50,62],
 [5,34,50,69],[5,34,55,62],[5,34,55,66],[5,34,55,69],
 [5,34,61,62],[5,34,61,69],[5,34,62,66],[5,34,62,69],
 [5,34,66,69],[5,35,37,45],[5,35,37,48],[5,35,37,50],
 [5,35,37,62],[5,35,41,45],[5,35,41,49],[5,35,41,68],
 [5,35,45,48],[5,35,45,62],[5,35,45,68],[5,35,48,49],
 [5,35,48,50],[5,35,48,55],[5,35,48,57],[5,35,48,62],
 [5,35,48,66],[5,35,48,68],[5,35,48,69],[5,35,49,50],
 [5,35,49,55],[5,35,49,66],[5,35,49,68],[5,35,49,69],
 [5,35,50,62],[5,35,50,69],[5,35,55,66],[5,35,55,69],
 [5,35,66,69],[5,37,44,46],[5,37,44,47],[5,37,44,48],
 [5,37,44,50],[5,37,44,54],[5,37,44,61],[5,37,45,46],
 [5,37,45,48],[5,37,45,62],[5,37,46,48],[5,37,46,50],
 [5,37,46,61],[5,37,47,50],[5,37,47,61],[5,37,47,62],
 [5,37,48,50],[5,37,48,61],[5,37,48,62],[5,37,50,61],
 [5,37,50,62],[5,37,54,61],[5,41,44,45],[5,41,44,46],
 [5,41,44,47],[5,41,44,49],[5,41,44,54],[5,41,44,59],
 [5,41,44,61],[5,41,44,62],[5,41,44,68],[5,41,45,46],
 [5,41,45,49],[5,41,45,61],[5,41,45,62],[5,41,45,68],
 [5,41,46,49],[5,41,46,59],[5,41,46,61],[5,41,46,62],
 [5,41,46,68],[5,41,47,49],[5,41,47,59],[5,41,47,61],
 [5,41,47,62],[5,41,47,68],[5,41,49,54],[5,41,49,59],
 [5,41,49,61],[5,41,49,62],[5,41,49,68],[5,41,54,59],
 [5,41,54,61],[5,41,54,68],[5,41,59,61],[5,41,59,62],
 [5,41,59,68],[5,41,61,62],[5,41,61,68],[5,43,46,48],
 [5,43,46,49],[5,43,46,57],[5,43,46,62],[5,43,46,69],
 [5,43,48,49],[5,43,48,57],[5,43,48,62],[5,43,48,69],
 [5,43,49,62],[5,43,49,69],[5,43,62,69],[5,44,45,46],
 [5,44,45,48],[5,44,45,49],[5,44,45,51],[5,44,45,61],
 [5,44,45,62],[5,44,45,66],[5,44,45,68],[5,44,45,69],
 [5,44,46,48],[5,44,46,49],[5,44,46,50],[5,44,46,57],
 [5,44,46,59],[5,44,46,61],[5,44,46,62],[5,44,46,66],
 [5,44,46,68],[5,44,46,69],[5,44,47,49],[5,44,47,50],
 [5,44,47,57],[5,44,47,59],[5,44,47,61],[5,44,47,62],
 [5,44,47,68],[5,44,47,69],[5,44,48,49],[5,44,48,51],
 [5,44,48,59],[5,44,48,61],[5,44,48,62],[5,44,48,66],
 [5,44,48,68],[5,44,48,69],[5,44,49,50],[5,44,49,54],
 [5,44,49,57],[5,44,49,59],[5,44,49,61],[5,44,49,62],
 [5,44,49,66],[5,44,49,68],[5,44,49,69],[5,44,50,51],
 [5,44,50,54],[5,44,50,59],[5,44,50,61],[5,44,50,62],
 [5,44,50,69],[5,44,51,59],[5,44,51,61],[5,44,51,66],
 [5,44,51,68],[5,44,51,69],[5,44,54,57],[5,44,54,59],
 [5,44,54,61],[5,44,54,62],[5,44,54,66],[5,44,54,68],
 [5,44,57,61],[5,44,59,61],[5,44,59,62],[5,44,59,68],
 [5,44,61,62],[5,44,61,68],[5,44,61,69],[5,44,62,66],
 [5,44,62,69],[5,44,66,69],[5,45,46,48],[5,45,46,49],
 [5,45,46,55],[5,45,46,57],[5,45,46,61],[5,45,46,62],
 [5,45,46,66],[5,45,46,68],[5,45,46,69],[5,45,48,49],
 [5,45,48,51],[5,45,48,53],[5,45,48,55],[5,45,48,57],
 [5,45,48,61],[5,45,48,62],[5,45,48,66],[5,45,48,68],
 [5,45,48,69],[5,45,49,55],[5,45,49,61],[5,45,49,62],
 [5,45,49,66],[5,45,49,68],[5,45,49,69],[5,45,51,53],
 [5,45,51,55],[5,45,51,57],[5,45,51,62],[5,45,51,66],
 [5,45,51,68],[5,45,51,69],[5,45,53,62],[5,45,55,62],
 [5,45,55,66],[5,45,55,69],[5,45,61,62],[5,45,61,68],
 [5,45,61,69],[5,45,62,66],[5,45,62,69],[5,45,66,69],
 [5,46,48,49],[5,46,48,50],[5,46,48,55],[5,46,48,57],
 [5,46,48,59],[5,46,48,61],[5,46,48,62],[5,46,48,66],
 [5,46,48,68],[5,46,48,69],[5,46,49,50],[5,46,49,53],
 [5,46,49,55],[5,46,49,59],[5,46,49,61],[5,46,49,62],
 [5,46,49,66],[5,46,49,68],[5,46,49,69],[5,46,50,53],
 [5,46,50,59],[5,46,50,61],[5,46,50,62],[5,46,50,69],
 [5,46,53,62],[5,46,55,62],[5,46,55,66],[5,46,55,69],
 [5,46,57,61],[5,46,59,61],[5,46,59,62],[5,46,59,68],
 [5,46,61,62],[5,46,61,68],[5,46,61,69],[5,46,62,66],
 [5,46,62,69],[5,46,66,69],[5,47,49,50],[5,47,49,53],
 [5,47,49,57],[5,47,49,59],[5,47,49,61],[5,47,49,62],
 [5,47,49,68],[5,47,49,69],[5,47,50,53],[5,47,50,59],
 [5,47,50,61],[5,47,50,62],[5,47,50,69],[5,47,53,62],
 [5,47,57,61],[5,47,59,61],[5,47,59,62],[5,47,59,68],
 [5,47,61,62],[5,47,61,68],[5,47,61,69],[5,47,62,69],
 [5,48,49,50],[5,48,49,55],[5,48,49,59],[5,48,49,61],
 [5,48,49,62],[5,48,49,66],[5,48,49,68],[5,48,49,69],
 [5,48,50,51],[5,48,50,53],[5,48,50,59],[5,48,50,61],
 [5,48,50,62],[5,48,50,69],[5,48,51,53],[5,48,51,62],
 [5,48,51,68],[5,48,53,62],[5,48,55,62],[5,48,55,66],
 [5,48,55,69],[5,48,57,61],[5,48,59,61],[5,48,59,62],
 [5,48,59,68],[5,48,61,62],[5,48,61,68],[5,48,61,69],
 [5,48,62,66],[5,48,62,69],[5,48,66,69],[5,49,50,53],
 [5,49,50,59],[5,49,50,61],[5,49,50,62],[5,49,50,69],
 [5,49,53,62],[5,49,54,57],[5,49,54,59],[5,49,54,61],
 [5,49,54,68],[5,49,55,62],[5,49,55,66],[5,49,55,69],
 [5,49,57,61],[5,49,59,61],[5,49,59,62],[5,49,59,68],
 [5,49,61,62],[5,49,61,68],[5,49,61,69],[5,49,62,66],
 [5,49,62,69],[5,49,66,69],[5,50,51,53],[5,50,51,59],
 [5,50,51,61],[5,50,51,62],[5,50,51,69],[5,50,53,54],
 [5,50,53,62],[5,50,54,59],[5,50,54,61],[5,50,54,62],
 [5,50,54,69],[5,50,59,61],[5,50,59,62],[5,50,61,62],
 [5,50,61,69],[5,50,62,69],[5,51,53,62],[5,51,55,62],
 [5,51,55,66],[5,51,55,69],[5,51,57,61],[5,51,59,61],
 [5,51,59,62],[5,51,59,68],[5,51,61,62],[5,51,61,68],
 [5,51,61,69],[5,51,62,66],[5,51,62,69],[5,51,66,69],
 [5,53,54,62],[5,54,57,61],[5,54,59,61],[5,54,59,68],
 [5,54,61,62],[5,54,61,68],[5,54,61,69],[5,54,62,66],
 [5,54,62,69],[5,54,66,69],[5,55,62,66],[5,55,62,69],
 [5,55,66,69],[5,59,61,62],[5,59,61,68],[5,61,62,69],
 [5,62,66,69],[6,7,10,19],[6,7,10,23],[6,7,10,25],
 [6,7,10,26],[6,7,10,35],[6,7,10,45],[6,7,10,47],
 [6,7,10,48],[6,7,10,58],[6,7,10,67],[6,7,15,19],
 [6,7,15,20],[6,7,15,23],[6,7,15,24],[6,7,15,25],
 [6,7,15,26],[6,7,15,46],[6,7,15,47],[6,7,15,48],
 [6,7,15,58],[6,7,15,60],[6,7,15,61],[6,7,15,67],
 [6,7,16,23],[6,7,16,25],[6,7,16,26],[6,7,16,45],
 [6,7,16,46],[6,7,16,47],[6,7,16,48],[6,7,16,58],
 [6,7,16,60],[6,7,16,67],[6,7,19,23],[6,7,19,24],
 [6,7,19,25],[6,7,19,35],[6,7,19,39],[6,7,19,45],
 [6,7,19,46],[6,7,19,47],[6,7,19,48],[6,7,19,60],
 [6,7,19,61],[6,7,19,67],[6,7,20,21],[6,7,20,23],
 [6,7,20,24],[6,7,20,25],[6,7,20,26],[6,7,20,39],
 [6,7,20,45],[6,7,20,46],[6,7,20,47],[6,7,20,58],
 [6,7,20,61],[6,7,20,67],[6,7,21,23],[6,7,21,25],
 [6,7,21,26],[6,7,21,46],[6,7,21,47],[6,7,21,48],
 [6,7,21,58],[6,7,21,60],[6,7,21,67],[6,7,23,24],
 [6,7,23,25],[6,7,23,26],[6,7,23,35],[6,7,23,39],
 [6,7,23,45],[6,7,23,46],[6,7,23,47],[6,7,23,48],
 [6,7,23,58],[6,7,23,60],[6,7,23,61],[6,7,23,67],
 [6,7,24,25],[6,7,24,26],[6,7,24,46],[6,7,24,47],
 [6,7,24,48],[6,7,24,58],[6,7,24,60],[6,7,24,61],
 [6,7,24,67],[6,7,25,26],[6,7,25,35],[6,7,25,39],
 [6,7,25,45],[6,7,25,46],[6,7,25,47],[6,7,25,48],
 [6,7,25,58],[6,7,25,60],[6,7,25,61],[6,7,25,67],
 [6,7,26,35],[6,7,26,39],[6,7,26,45],[6,7,26,46],
 [6,7,26,47],[6,7,26,48],[6,7,26,58],[6,7,26,60],
 [6,7,26,61],[6,7,26,67],[6,7,35,47],[6,7,35,48],
 [6,7,35,58],[6,7,35,67],[6,7,39,45],[6,7,39,46],
 [6,7,39,47],[6,7,39,48],[6,7,39,58],[6,7,39,60],
 [6,7,39,61],[6,7,39,67],[6,7,45,46],[6,7,45,47],
 [6,7,45,48],[6,7,45,60],[6,7,45,67],[6,7,46,47],
 [6,7,46,48],[6,7,46,58],[6,7,46,60],[6,7,46,61],
 [6,7,46,67],[6,7,47,48],[6,7,47,58],[6,7,47,60],
 [6,7,47,61],[6,7,47,67],[6,7,48,58],[6,7,48,60],
 [6,7,48,61],[6,7,48,67],[6,7,58,60],[6,7,58,61],
 [6,7,58,67],[6,7,60,61],[6,7,60,67],[6,7,61,67],
 [6,8,9,15],[6,8,9,24],[6,8,9,26],[6,8,9,44],
 [6,8,9,48],[6,8,9,51],[6,8,9,61],[6,8,9,68],
 [6,8,10,11],[6,8,10,25],[6,8,10,26],[6,8,10,39],
 [6,8,10,44],[6,8,10,45],[6,8,10,46],[6,8,10,48],
 [6,8,10,56],[6,8,10,58],[6,8,10,61],[6,8,10,67],
 [6,8,11,16],[6,8,11,17],[6,8,11,21],[6,8,11,24],
 [6,8,11,25],[6,8,11,35],[6,8,11,45],[6,8,11,46],
 [6,8,11,48],[6,8,11,51],[6,8,11,60],[6,8,11,61],
 [6,8,15,17],[6,8,15,22],[6,8,15,24],[6,8,15,25],
 [6,8,15,26],[6,8,15,44],[6,8,15,51],[6,8,15,52],
 [6,8,15,56],[6,8,15,58],[6,8,15,60],[6,8,15,61],
 [6,8,15,67],[6,8,15,68],[6,8,16,25],[6,8,16,45],
 [6,8,16,46],[6,8,16,48],[6,8,16,52],[6,8,16,56],
 [6,8,16,58],[6,8,16,60],[6,8,17,24],[6,8,17,26],
 [6,8,17,35],[6,8,17,39],[6,8,17,45],[6,8,17,48],
 [6,8,17,51],[6,8,17,56],[6,8,17,58],[6,8,17,61],
 [6,8,21,25],[6,8,21,46],[6,8,21,48],[6,8,21,52],
 [6,8,21,60],[6,8,22,24],[6,8,22,25],[6,8,22,26],
 [6,8,22,35],[6,8,22,44],[6,8,22,58],[6,8,22,60],
 [6,8,22,61],[6,8,24,25],[6,8,24,26],[6,8,24,44],
 [6,8,24,48],[6,8,24,51],[6,8,24,52],[6,8,24,56],
 [6,8,24,58],[6,8,24,60],[6,8,24,61],[6,8,24,67],
 [6,8,24,68],[6,8,25,26],[6,8,25,35],[6,8,25,39],
 [6,8,25,45],[6,8,25,46],[6,8,25,48],[6,8,25,51],
 [6,8,25,58],[6,8,25,60],[6,8,25,61],[6,8,25,67],
 [6,8,26,35],[6,8,26,39],[6,8,26,44],[6,8,26,46],
 [6,8,26,51],[6,8,26,52],[6,8,26,56],[6,8,26,58],
 [6,8,26,60],[6,8,26,61],[6,8,26,67],[6,8,26,68],
 [6,8,35,48],[6,8,35,58],[6,8,35,67],[6,8,35,68],
 [6,8,39,44],[6,8,39,45],[6,8,39,46],[6,8,39,58],
 [6,8,39,60],[6,8,39,61],[6,8,39,67],[6,8,44,46],
 [6,8,44,48],[6,8,44,51],[6,8,44,56],[6,8,44,60],
 [6,8,44,61],[6,8,44,67],[6,8,44,68],[6,8,45,46],
 [6,8,45,48],[6,8,45,52],[6,8,45,60],[6,8,45,67],
 [6,8,45,68],[6,8,46,48],[6,8,46,56],[6,8,46,58],
 [6,8,46,61],[6,8,46,67],[6,8,46,68],[6,8,48,52],
 [6,8,48,60],[6,8,48,61],[6,8,48,68],[6,8,51,56],
 [6,8,51,58],[6,8,51,60],[6,8,51,61],[6,8,51,67],
 [6,8,51,68],[6,8,52,61],[6,8,56,61],[6,8,58,60],
 [6,8,58,61],[6,8,58,67],[6,8,60,61],[6,8,60,67],
 [6,8,61,67],[6,8,61,68],[6,9,14,15],[6,9,14,20],
 [6,9,14,22],[6,9,14,24],[6,9,14,26],[6,9,14,44],
 [6,9,14,47],[6,9,14,54],[6,9,14,61],[6,9,14,68],
 [6,9,15,20],[6,9,15,22],[6,9,15,23],[6,9,15,24],
 [6,9,15,26],[6,9,15,41],[6,9,15,44],[6,9,15,46],
 [6,9,15,47],[6,9,15,48],[6,9,15,49],[6,9,15,51],
 [6,9,15,54],[6,9,15,59],[6,9,15,61],[6,9,15,68],
 [6,9,20,22],[6,9,20,23],[6,9,20,24],[6,9,20,26],
 [6,9,20,41],[6,9,20,44],[6,9,20,46],[6,9,20,47],
 [6,9,20,49],[6,9,20,54],[6,9,20,59],[6,9,20,61],
 [6,9,20,68],[6,9,22,23],[6,9,22,24],[6,9,22,26],
 [6,9,22,35],[6,9,22,41],[6,9,22,44],[6,9,22,46],
 [6,9,22,47],[6,9,22,49],[6,9,22,59],[6,9,22,61],
 [6,9,22,68],[6,9,23,24],[6,9,23,26],[6,9,23,41],
 [6,9,23,46],[6,9,23,47],[6,9,23,48],[6,9,23,59],
 [6,9,23,61],[6,9,23,68],[6,9,24,26],[6,9,24,33],
 [6,9,24,35],[6,9,24,41],[6,9,24,44],[6,9,24,46],
 [6,9,24,47],[6,9,24,48],[6,9,24,49],[6,9,24,51],
 [6,9,24,54],[6,9,24,59],[6,9,24,61],[6,9,24,68],
 [6,9,26,41],[6,9,26,44],[6,9,26,46],[6,9,26,47],
 [6,9,26,48],[6,9,26,49],[6,9,26,51],[6,9,26,54],
 [6,9,26,59],[6,9,26,61],[6,9,26,68],[6,9,33,35],
 [6,9,33,47],[6,9,33,48],[6,9,33,59],[6,9,33,68],
 [6,9,35,41],[6,9,35,47],[6,9,35,48],[6,9,35,59],
 [6,9,35,68],[6,9,41,44],[6,9,41,47],[6,9,41,48],
 [6,9,41,49],[6,9,41,54],[6,9,41,59],[6,9,41,61],
 [6,9,41,68],[6,9,44,46],[6,9,44,47],[6,9,44,48],
 [6,9,44,49],[6,9,44,51],[6,9,44,54],[6,9,44,59],
 [6,9,44,61],[6,9,44,68],[6,9,46,47],[6,9,46,48],
 [6,9,46,59],[6,9,46,61],[6,9,46,68],[6,9,47,48],
 [6,9,47,49],[6,9,47,54],[6,9,47,59],[6,9,47,61],
 [6,9,47,68],[6,9,48,61],[6,9,48,68],[6,9,49,59],
 [6,9,49,61],[6,9,49,68],[6,9,51,61],[6,9,51,68],
 [6,9,54,61],[6,9,54,68],[6,9,59,61],[6,9,59,68],
 [6,9,61,68],[6,10,11,14],[6,10,11,19],[6,10,11,23],
 [6,10,11,25],[6,10,11,45],[6,10,11,46],[6,10,11,47],
 [6,10,11,48],[6,10,11,49],[6,10,11,51],[6,10,11,54],
 [6,10,11,61],[6,10,14,25],[6,10,14,26],[6,10,14,44],
 [6,10,14,45],[6,10,14,56],[6,10,14,58],[6,10,14,61],
 [6,10,14,67],[6,10,19,23],[6,10,19,25],[6,10,19,35],
 [6,10,19,36],[6,10,19,48],[6,10,19,59],[6,10,19,61],
 [6,10,19,67],[6,10,23,25],[6,10,23,26],[6,10,23,35],
 [6,10,23,36],[6,10,23,41],[6,10,23,45],[6,10,23,47],
 [6,10,23,48],[6,10,23,56],[6,10,23,58],[6,10,23,59],
 [6,10,23,61],[6,10,23,67],[6,10,25,26],[6,10,25,33],
 [6,10,25,35],[6,10,25,36],[6,10,25,39],[6,10,25,45],
 [6,10,25,46],[6,10,25,47],[6,10,25,48],[6,10,25,49],
 [6,10,25,51],[6,10,25,54],[6,10,25,59],[6,10,25,61],
 [6,10,25,67],[6,10,26,35],[6,10,26,36],[6,10,26,39],
 [6,10,26,41],[6,10,26,44],[6,10,26,45],[6,10,26,46],
 [6,10,26,47],[6,10,26,48],[6,10,26,49],[6,10,26,51],
 [6,10,26,54],[6,10,26,56],[6,10,26,58],[6,10,26,67],
 [6,10,33,36],[6,10,33,44],[6,10,33,45],[6,10,33,47],
 [6,10,33,48],[6,10,33,56],[6,10,33,58],[6,10,33,59],
 [6,10,33,67],[6,10,35,41],[6,10,35,47],[6,10,35,48],
 [6,10,35,58],[6,10,35,59],[6,10,35,67],[6,10,36,45],
 [6,10,36,48],[6,10,36,49],[6,10,36,54],[6,10,39,45],
 [6,10,39,46],[6,10,39,47],[6,10,39,48],[6,10,39,58],
 [6,10,39,67],[6,10,41,44],[6,10,41,47],[6,10,41,48],
 [6,10,41,49],[6,10,41,54],[6,10,41,59],[6,10,41,61],
 [6,10,44,46],[6,10,44,47],[6,10,44,48],[6,10,44,49],
 [6,10,44,51],[6,10,44,54],[6,10,44,59],[6,10,45,46],
 [6,10,45,47],[6,10,45,48],[6,10,45,54],[6,10,45,67],
 [6,10,46,48],[6,10,46,56],[6,10,46,58],[6,10,46,59],
 [6,10,46,61],[6,10,46,67],[6,10,47,48],[6,10,47,49],
 [6,10,47,54],[6,10,47,56],[6,10,47,58],[6,10,47,59],
 [6,10,47,61],[6,10,47,67],[6,10,48,56],[6,10,48,58],
 [6,10,48,61],[6,10,48,67],[6,10,49,56],[6,10,49,58],
 [6,10,49,59],[6,10,49,61],[6,10,49,67],[6,10,51,56],
 [6,10,51,58],[6,10,51,61],[6,10,51,67],[6,10,54,56],
 [6,10,54,61],[6,10,54,67],[6,10,58,67],[6,11,14,17],
 [6,11,14,24],[6,11,14,25],[6,11,14,35],[6,11,14,47],
 [6,11,14,60],[6,11,14,61],[6,11,16,25],[6,11,16,45],
 [6,11,16,46],[6,11,16,47],[6,11,16,48],[6,11,16,49],
 [6,11,16,60],[6,11,17,19],[6,11,17,23],[6,11,17,24],
 [6,11,17,46],[6,11,17,47],[6,11,17,48],[6,11,17,49],
 [6,11,17,51],[6,11,17,54],[6,11,19,23],[6,11,19,24],
 [6,11,19,25],[6,11,19,35],[6,11,19,46],[6,11,19,47],
 [6,11,19,51],[6,11,19,54],[6,11,19,60],[6,11,19,61],
 [6,11,21,23],[6,11,21,25],[6,11,21,46],[6,11,21,48],
 [6,11,21,60],[6,11,23,24],[6,11,23,25],[6,11,23,35],
 [6,11,23,46],[6,11,23,47],[6,11,23,60],[6,11,23,61],
 [6,11,24,25],[6,11,24,46],[6,11,24,47],[6,11,24,48],
 [6,11,24,49],[6,11,24,51],[6,11,24,54],[6,11,24,60],
 [6,11,25,35],[6,11,25,45],[6,11,25,46],[6,11,25,47],
 [6,11,25,48],[6,11,25,49],[6,11,25,51],[6,11,25,54],
 [6,11,25,60],[6,11,25,61],[6,11,35,47],[6,11,35,48],
 [6,11,45,46],[6,11,45,48],[6,11,45,60],[6,11,46,47],
 [6,11,46,48],[6,11,46,60],[6,11,46,61],[6,11,47,49],
 [6,11,47,51],[6,11,47,60],[6,11,47,61],[6,11,48,60],
 [6,11,48,61],[6,11,49,60],[6,11,49,61],[6,11,51,60],
 [6,11,51,61],[6,11,54,60],[6,11,54,61],[6,14,15,17],
 [6,14,15,20],[6,14,15,22],[6,14,15,24],[6,14,15,25],
 [6,14,15,26],[6,14,15,36],[6,14,15,44],[6,14,15,47],
 [6,14,15,52],[6,14,15,54],[6,14,15,56],[6,14,15,58],
 [6,14,15,60],[6,14,15,61],[6,14,15,67],[6,14,15,68],
 [6,14,17,20],[6,14,17,24],[6,14,17,26],[6,14,17,35],
 [6,14,17,39],[6,14,17,44],[6,14,17,45],[6,14,17,47],
 [6,14,17,54],[6,14,17,56],[6,14,17,58],[6,14,17,61],
 [6,14,20,22],[6,14,20,24],[6,14,20,25],[6,14,20,26],
 [6,14,20,36],[6,14,20,44],[6,14,20,45],[6,14,20,47],
 [6,14,20,52],[6,14,20,54],[6,14,20,56],[6,14,20,58],
 [6,14,20,61],[6,14,20,67],[6,14,20,68],[6,14,22,24],
 [6,14,22,26],[6,14,22,39],[6,14,22,44],[6,14,22,47],
 [6,14,22,56],[6,14,22,58],[6,14,22,60],[6,14,22,61],
 [6,14,22,68],[6,14,24,25],[6,14,24,26],[6,14,24,36],
 [6,14,24,44],[6,14,24,47],[6,14,24,52],[6,14,24,54],
 [6,14,24,56],[6,14,24,60],[6,14,24,61],[6,14,24,67],
 [6,14,24,68],[6,14,25,26],[6,14,25,35],[6,14,25,39],
 [6,14,25,45],[6,14,25,54],[6,14,25,58],[6,14,25,60],
 [6,14,25,61],[6,14,25,67],[6,14,26,35],[6,14,26,36],
 [6,14,26,39],[6,14,26,44],[6,14,26,47],[6,14,26,52],
 [6,14,26,54],[6,14,26,56],[6,14,26,58],[6,14,26,60],
 [6,14,26,61],[6,14,26,67],[6,14,26,68],[6,14,35,36],
 [6,14,35,47],[6,14,35,52],[6,14,35,56],[6,14,35,60],
 [6,14,35,67],[6,14,35,68],[6,14,36,45],[6,14,36,54],
 [6,14,36,60],[6,14,36,61],[6,14,39,44],[6,14,39,45],
 [6,14,39,47],[6,14,39,58],[6,14,39,60],[6,14,39,67],
 [6,14,44,47],[6,14,44,54],[6,14,44,56],[6,14,44,60],
 [6,14,44,61],[6,14,44,67],[6,14,44,68],[6,14,45,47],
 [6,14,45,52],[6,14,45,54],[6,14,45,60],[6,14,45,67],
 [6,14,45,68],[6,14,47,54],[6,14,47,56],[6,14,47,58],
 [6,14,47,61],[6,14,47,68],[6,14,52,54],[6,14,52,61],
 [6,14,54,56],[6,14,54,58],[6,14,54,60],[6,14,54,61],
 [6,14,54,67],[6,14,54,68],[6,14,56,61],[6,14,58,60],
 [6,14,58,61],[6,14,58,67],[6,14,60,61],[6,14,60,67],
 [6,14,61,67],[6,14,61,68],[6,15,17,19],[6,15,17,20],
 [6,15,17,23],[6,15,17,24],[6,15,17,26],[6,15,17,41],
 [6,15,17,44],[6,15,17,46],[6,15,17,47],[6,15,17,48],
 [6,15,17,49],[6,15,17,51],[6,15,17,54],[6,15,17,56],
 [6,15,17,59],[6,15,17,61],[6,15,19,22],[6,15,19,23],
 [6,15,19,24],[6,15,19,25],[6,15,19,36],[6,15,19,46],
 [6,15,19,47],[6,15,19,48],[6,15,19,56],[6,15,19,59],
 [6,15,19,60],[6,15,19,61],[6,15,19,67],[6,15,20,22],
 [6,15,20,23],[6,15,20,24],[6,15,20,25],[6,15,20,26],
 [6,15,20,36],[6,15,20,41],[6,15,20,44],[6,15,20,46],
 [6,15,20,47],[6,15,20,49],[6,15,20,52],[6,15,20,54],
 [6,15,20,56],[6,15,20,58],[6,15,20,59],[6,15,20,61],
 [6,15,20,67],[6,15,20,68],[6,15,22,23],[6,15,22,24],
 [6,15,22,25],[6,15,22,26],[6,15,22,41],[6,15,22,44],
 [6,15,22,46],[6,15,22,47],[6,15,22,49],[6,15,22,56],
 [6,15,22,58],[6,15,22,59],[6,15,22,60],[6,15,22,61],
 [6,15,22,68],[6,15,23,24],[6,15,23,25],[6,15,23,26],
 [6,15,23,36],[6,15,23,41],[6,15,23,46],[6,15,23,47],
 [6,15,23,48],[6,15,23,52],[6,15,23,56],[6,15,23,58],
 [6,15,23,59],[6,15,23,60],[6,15,23,61],[6,15,23,67],
 [6,15,23,68],[6,15,24,25],[6,15,24,26],[6,15,24,36],
 [6,15,24,41],[6,15,24,44],[6,15,24,46],[6,15,24,47],
 [6,15,24,48],[6,15,24,49],[6,15,24,51],[6,15,24,52],
 [6,15,24,54],[6,15,24,56],[6,15,24,58],[6,15,24,59],
 [6,15,24,60],[6,15,24,61],[6,15,24,67],[6,15,24,68],
 [6,15,25,26],[6,15,25,46],[6,15,25,47],[6,15,25,48],
 [6,15,25,49],[6,15,25,51],[6,15,25,54],[6,15,25,58],
 [6,15,25,59],[6,15,25,60],[6,15,25,61],[6,15,25,67],
 [6,15,26,36],[6,15,26,41],[6,15,26,44],[6,15,26,46],
 [6,15,26,47],[6,15,26,48],[6,15,26,49],[6,15,26,51],
 [6,15,26,52],[6,15,26,54],[6,15,26,56],[6,15,26,58],
 [6,15,26,59],[6,15,26,60],[6,15,26,61],[6,15,26,67],
 [6,15,26,68],[6,15,36,46],[6,15,36,48],[6,15,36,49],
 [6,15,36,51],[6,15,36,54],[6,15,36,61],[6,15,41,44],
 [6,15,41,47],[6,15,41,48],[6,15,41,49],[6,15,41,54],
 [6,15,41,59],[6,15,41,60],[6,15,41,61],[6,15,41,68],
 [6,15,44,46],[6,15,44,47],[6,15,44,48],[6,15,44,49],
 [6,15,44,51],[6,15,44,54],[6,15,44,56],[6,15,44,59],
 [6,15,44,60],[6,15,44,61],[6,15,44,67],[6,15,44,68],
 [6,15,46,47],[6,15,46,48],[6,15,46,52],[6,15,46,56],
 [6,15,46,58],[6,15,46,59],[6,15,46,60],[6,15,46,61],
 [6,15,46,67],[6,15,46,68],[6,15,47,48],[6,15,47,49],
 [6,15,47,51],[6,15,47,52],[6,15,47,54],[6,15,47,56],
 [6,15,47,58],[6,15,47,59],[6,15,47,60],[6,15,47,61],
 [6,15,47,67],[6,15,47,68],[6,15,48,52],[6,15,48,56],
 [6,15,48,58],[6,15,48,60],[6,15,48,61],[6,15,48,67],
 [6,15,48,68],[6,15,49,52],[6,15,49,56],[6,15,49,58],
 [6,15,49,59],[6,15,49,60],[6,15,49,61],[6,15,49,67],
 [6,15,49,68],[6,15,51,52],[6,15,51,56],[6,15,51,58],
 [6,15,51,60],[6,15,51,61],[6,15,51,67],[6,15,51,68],
 [6,15,52,54],[6,15,52,61],[6,15,54,56],[6,15,54,58],
 [6,15,54,60],[6,15,54,61],[6,15,54,67],[6,15,54,68],
 [6,15,56,61],[6,15,58,60],[6,15,58,61],[6,15,58,67],
 [6,15,59,60],[6,15,59,61],[6,15,59,68],[6,15,60,61],
 [6,15,60,67],[6,15,61,67],[6,15,61,68],[6,16,22,23],
 [6,16,22,25],[6,16,22,26],[6,16,22,45],[6,16,22,46],
 [6,16,22,47],[6,16,22,49],[6,16,22,56],[6,16,22,58],
 [6,16,22,60],[6,16,23,25],[6,16,23,26],[6,16,23,45],
 [6,16,23,46],[6,16,23,47],[6,16,23,48],[6,16,23,52],
 [6,16,23,56],[6,16,23,58],[6,16,23,60],[6,16,23,67],
 [6,16,25,26],[6,16,25,33],[6,16,25,36],[6,16,25,45],
 [6,16,25,46],[6,16,25,47],[6,16,25,48],[6,16,25,49],
 [6,16,25,54],[6,16,25,58],[6,16,25,60],[6,16,25,67],
 [6,16,26,45],[6,16,26,46],[6,16,26,47],[6,16,26,48],
 [6,16,26,49],[6,16,26,52],[6,16,26,54],[6,16,26,56],
 [6,16,26,58],[6,16,26,60],[6,16,26,67],[6,16,33,36],
 [6,16,33,45],[6,16,33,46],[6,16,33,48],[6,16,33,52],
 [6,16,33,56],[6,16,33,58],[6,16,33,60],[6,16,36,45],
 [6,16,36,46],[6,16,36,48],[6,16,36,49],[6,16,36,54],
 [6,16,36,60],[6,16,45,46],[6,16,45,47],[6,16,45,48],
 [6,16,45,52],[6,16,45,54],[6,16,45,60],[6,16,45,67],
 [6,16,46,47],[6,16,46,48],[6,16,46,52],[6,16,46,56],
 [6,16,46,58],[6,16,46,60],[6,16,46,67],[6,16,47,48],
 [6,16,47,49],[6,16,47,52],[6,16,47,54],[6,16,47,56],
 [6,16,47,58],[6,16,47,60],[6,16,47,67],[6,16,48,52],
 [6,16,48,56],[6,16,48,58],[6,16,48,60],[6,16,48,67],
 [6,16,49,52],[6,16,49,56],[6,16,49,58],[6,16,49,60],
 [6,16,49,67],[6,16,52,54],[6,16,54,56],[6,16,54,58],
 [6,16,54,60],[6,16,54,67],[6,16,58,60],[6,16,58,67],
 [6,16,60,67],[6,17,19,23],[6,17,19,24],[6,17,19,39],
 [6,17,19,45],[6,17,19,46],[6,17,19,48],[6,17,19,51],
 [6,17,19,54],[6,17,19,56],[6,17,19,59],[6,17,20,23],
 [6,17,20,24],[6,17,20,26],[6,17,20,35],[6,17,20,39],
 [6,17,20,41],[6,17,20,44],[6,17,20,45],[6,17,20,47],
 [6,17,20,49],[6,17,20,54],[6,17,20,56],[6,17,20,59],
 [6,17,20,61],[6,17,23,24],[6,17,23,26],[6,17,23,35],
 [6,17,23,39],[6,17,23,45],[6,17,23,46],[6,17,23,48],
 [6,17,23,56],[6,17,23,58],[6,17,23,59],[6,17,23,61],
 [6,17,24,26],[6,17,24,33],[6,17,24,35],[6,17,24,41],
 [6,17,24,44],[6,17,24,46],[6,17,24,47],[6,17,24,48],
 [6,17,24,49],[6,17,24,51],[6,17,24,54],[6,17,24,56],
 [6,17,24,59],[6,17,24,61],[6,17,26,35],[6,17,26,39],
 [6,17,26,41],[6,17,26,44],[6,17,26,45],[6,17,26,46],
 [6,17,26,47],[6,17,26,48],[6,17,26,49],[6,17,26,51],
 [6,17,26,54],[6,17,26,56],[6,17,26,58],[6,17,26,59],
 [6,17,26,61],[6,17,33,35],[6,17,33,46],[6,17,33,48],
 [6,17,33,54],[6,17,33,58],[6,17,33,59],[6,17,33,61],
 [6,17,35,41],[6,17,35,47],[6,17,35,48],[6,17,35,59],
 [6,17,39,45],[6,17,39,46],[6,17,39,47],[6,17,39,48],
 [6,17,39,49],[6,17,39,58],[6,17,41,44],[6,17,41,47],
 [6,17,41,49],[6,17,41,54],[6,17,41,59],[6,17,41,61],
 [6,17,44,46],[6,17,44,47],[6,17,44,48],[6,17,44,49],
 [6,17,44,51],[6,17,44,54],[6,17,44,56],[6,17,44,59],
 [6,17,44,61],[6,17,45,46],[6,17,45,47],[6,17,45,48],
 [6,17,45,54],[6,17,46,48],[6,17,46,56],[6,17,46,58],
 [6,17,46,59],[6,17,46,61],[6,17,47,49],[6,17,47,54],
 [6,17,47,56],[6,17,47,58],[6,17,47,59],[6,17,47,61],
 [6,17,48,56],[6,17,48,58],[6,17,48,61],[6,17,49,56],
 [6,17,49,58],[6,17,49,59],[6,17,49,61],[6,17,51,56],
 [6,17,51,58],[6,17,51,61],[6,17,54,56],[6,17,54,58],
 [6,17,54,61],[6,17,56,61],[6,17,59,61],[6,19,22,23],
 [6,19,22,24],[6,19,22,25],[6,19,22,35],[6,19,22,39],
 [6,19,22,45],[6,19,22,46],[6,19,22,47],[6,19,22,59],
 [6,19,22,60],[6,19,22,61],[6,19,23,24],[6,19,23,25],
 [6,19,23,35],[6,19,23,36],[6,19,23,39],[6,19,23,45],
 [6,19,23,46],[6,19,23,47],[6,19,23,48],[6,19,23,56],
 [6,19,23,59],[6,19,23,60],[6,19,23,61],[6,19,23,67],
 [6,19,24,25],[6,19,24,36],[6,19,24,46],[6,19,24,47],
 [6,19,24,48],[6,19,24,56],[6,19,24,59],[6,19,24,60],
 [6,19,24,61],[6,19,24,67],[6,19,25,35],[6,19,25,39],
 [6,19,25,45],[6,19,25,46],[6,19,25,47],[6,19,25,48],
 [6,19,25,51],[6,19,25,54],[6,19,25,59],[6,19,25,60],
 [6,19,25,61],[6,19,25,67],[6,19,35,36],[6,19,35,47],
 [6,19,35,56],[6,19,35,59],[6,19,35,60],[6,19,35,67],
 [6,19,36,45],[6,19,36,46],[6,19,36,48],[6,19,36,51],
 [6,19,36,54],[6,19,36,60],[6,19,36,61],[6,19,39,45],
 [6,19,39,46],[6,19,39,47],[6,19,39,48],[6,19,39,60],
 [6,19,39,61],[6,19,39,67],[6,19,45,46],[6,19,45,47],
 [6,19,45,48],[6,19,45,54],[6,19,45,60],[6,19,45,67],
 [6,19,46,47],[6,19,46,48],[6,19,46,56],[6,19,46,59],
 [6,19,46,60],[6,19,46,61],[6,19,46,67],[6,19,47,48],
 [6,19,47,51],[6,19,47,54],[6,19,47,56],[6,19,47,59],
 [6,19,47,60],[6,19,47,61],[6,19,47,67],[6,19,48,56],
 [6,19,48,60],[6,19,48,61],[6,19,48,67],[6,19,51,56],
 [6,19,51,60],[6,19,51,61],[6,19,51,67],[6,19,54,56],
 [6,19,54,60],[6,19,54,67],[6,19,59,60],[6,19,59,61],
 [6,19,60,61],[6,19,60,67],[6,19,61,67],[6,20,21,23],
 [6,20,21,25],[6,20,21,26],[6,20,21,46],[6,20,21,47],
 [6,20,21,58],[6,20,21,59],[6,20,21,67],[6,20,22,23],
 [6,20,22,24],[6,20,22,25],[6,20,22,26],[6,20,22,39],
 [6,20,22,41],[6,20,22,44],[6,20,22,45],[6,20,22,46],
 [6,20,22,47],[6,20,22,49],[6,20,22,56],[6,20,22,58],
 [6,20,22,59],[6,20,22,61],[6,20,22,68],[6,20,23,24],
 [6,20,23,25],[6,20,23,26],[6,20,23,36],[6,20,23,39],
 [6,20,23,41],[6,20,23,45],[6,20,23,46],[6,20,23,47],
 [6,20,23,52],[6,20,23,56],[6,20,23,58],[6,20,23,59],
 [6,20,23,61],[6,20,23,67],[6,20,23,68],[6,20,24,25],
 [6,20,24,26],[6,20,24,36],[6,20,24,41],[6,20,24,44],
 [6,20,24,46],[6,20,24,47],[6,20,24,49],[6,20,24,52],
 [6,20,24,54],[6,20,24,56],[6,20,24,58],[6,20,24,59],
 [6,20,24,61],[6,20,24,67],[6,20,24,68],[6,20,25,26],
 [6,20,25,35],[6,20,25,36],[6,20,25,39],[6,20,25,45],
 [6,20,25,46],[6,20,25,47],[6,20,25,49],[6,20,25,54],
 [6,20,25,58],[6,20,25,59],[6,20,25,61],[6,20,25,67],
 [6,20,26,35],[6,20,26,36],[6,20,26,39],[6,20,26,41],
 [6,20,26,44],[6,20,26,45],[6,20,26,46],[6,20,26,47],
 [6,20,26,49],[6,20,26,52],[6,20,26,54],[6,20,26,56],
 [6,20,26,58],[6,20,26,59],[6,20,26,61],[6,20,26,67],
 [6,20,26,68],[6,20,35,36],[6,20,35,41],[6,20,35,47],
 [6,20,35,56],[6,20,35,58],[6,20,35,67],[6,20,35,68],
 [6,20,36,45],[6,20,36,46],[6,20,36,49],[6,20,36,61],
 [6,20,39,44],[6,20,39,45],[6,20,39,46],[6,20,39,47],
 [6,20,39,49],[6,20,39,58],[6,20,39,61],[6,20,39,67],
 [6,20,41,44],[6,20,41,45],[6,20,41,47],[6,20,41,49],
 [6,20,41,54],[6,20,41,59],[6,20,41,61],[6,20,41,68],
 [6,20,44,46],[6,20,44,47],[6,20,44,49],[6,20,44,54],
 [6,20,44,56],[6,20,44,59],[6,20,44,61],[6,20,44,67],
 [6,20,44,68],[6,20,45,46],[6,20,45,47],[6,20,45,52],
 [6,20,45,54],[6,20,45,67],[6,20,45,68],[6,20,46,47],
 [6,20,46,52],[6,20,46,56],[6,20,46,58],[6,20,46,59],
 [6,20,46,61],[6,20,46,67],[6,20,46,68],[6,20,47,49],
 [6,20,47,54],[6,20,47,56],[6,20,47,58],[6,20,47,59],
 [6,20,47,61],[6,20,47,67],[6,20,47,68],[6,20,49,56],
 [6,20,49,58],[6,20,49,59],[6,20,49,61],[6,20,49,67],
 [6,20,49,68],[6,20,52,54],[6,20,52,61],[6,20,54,56],
 [6,20,54,61],[6,20,54,68],[6,20,56,61],[6,20,58,61],
 [6,20,58,67],[6,20,59,61],[6,20,59,68],[6,20,61,67],
 [6,20,61,68],[6,21,23,25],[6,21,23,26],[6,21,23,46],
 [6,21,23,47],[6,21,23,48],[6,21,23,52],[6,21,23,56],
 [6,21,23,58],[6,21,23,59],[6,21,23,60],[6,21,23,67],
 [6,21,25,26],[6,21,25,33],[6,21,25,36],[6,21,25,46],
 [6,21,25,47],[6,21,25,48],[6,21,25,58],[6,21,25,59],
 [6,21,25,60],[6,21,25,67],[6,21,26,46],[6,21,26,47],
 [6,21,26,48],[6,21,26,52],[6,21,26,58],[6,21,26,59],
 [6,21,26,60],[6,21,26,67],[6,21,33,36],[6,21,33,46],
 [6,21,33,48],[6,21,33,52],[6,21,33,58],[6,21,33,59],
 [6,21,33,60],[6,21,33,67],[6,21,36,46],[6,21,36,48],
 [6,21,36,60],[6,21,46,47],[6,21,46,48],[6,21,46,52],
 [6,21,46,56],[6,21,46,58],[6,21,46,59],[6,21,46,60],
 [6,21,46,67],[6,21,47,48],[6,21,47,52],[6,21,47,58],
 [6,21,47,59],[6,21,47,60],[6,21,47,67],[6,21,48,52],
 [6,21,48,56],[6,21,48,58],[6,21,48,60],[6,21,48,67],
 [6,21,58,60],[6,21,58,67],[6,21,59,60],[6,21,60,67],
 [6,22,23,24],[6,22,23,25],[6,22,23,26],[6,22,23,39],
 [6,22,23,41],[6,22,23,45],[6,22,23,46],[6,22,23,47],
 [6,22,23,56],[6,22,23,58],[6,22,23,59],[6,22,23,60],
 [6,22,23,61],[6,22,23,68],[6,22,24,25],[6,22,24,26],
 [6,22,24,35],[6,22,24,41],[6,22,24,44],[6,22,24,46],
 [6,22,24,47],[6,22,24,49],[6,22,24,56],[6,22,24,58],
 [6,22,24,59],[6,22,24,60],[6,22,24,61],[6,22,24,68],
 [6,22,25,26],[6,22,25,35],[6,22,25,39],[6,22,25,45],
 [6,22,25,46],[6,22,25,47],[6,22,25,49],[6,22,25,58],
 [6,22,25,59],[6,22,25,60],[6,22,25,61],[6,22,26,35],
 [6,22,26,39],[6,22,26,41],[6,22,26,44],[6,22,26,45],
 [6,22,26,46],[6,22,26,47],[6,22,26,49],[6,22,26,56],
 [6,22,26,58],[6,22,26,59],[6,22,26,60],[6,22,26,61],
 [6,22,26,68],[6,22,35,41],[6,22,35,47],[6,22,35,56],
 [6,22,35,58],[6,22,35,60],[6,22,35,68],[6,22,39,44],
 [6,22,39,45],[6,22,39,46],[6,22,39,47],[6,22,39,49],
 [6,22,39,58],[6,22,39,60],[6,22,39,61],[6,22,41,44],
 [6,22,41,45],[6,22,41,47],[6,22,41,49],[6,22,41,59],
 [6,22,41,60],[6,22,41,61],[6,22,41,68],[6,22,44,46],
 [6,22,44,47],[6,22,44,49],[6,22,44,56],[6,22,44,59],
 [6,22,44,60],[6,22,44,61],[6,22,44,68],[6,22,45,46],
 [6,22,45,47],[6,22,45,60],[6,22,45,68],[6,22,46,47],
 [6,22,46,58],[6,22,46,59],[6,22,46,60],[6,22,46,61],
 [6,22,46,68],[6,22,47,49],[6,22,47,56],[6,22,47,58],
 [6,22,47,59],[6,22,47,60],[6,22,47,61],[6,22,47,68],
 [6,22,49,56],[6,22,49,58],[6,22,49,59],[6,22,49,60],
 [6,22,49,61],[6,22,49,68],[6,22,56,61],[6,22,58,60],
 [6,22,58,61],[6,22,59,60],[6,22,59,61],[6,22,59,68],
 [6,22,60,61],[6,22,61,68],[6,23,24,25],[6,23,24,26],
 [6,23,24,36],[6,23,24,41],[6,23,24,46],[6,23,24,47],
 [6,23,24,48],[6,23,24,52],[6,23,24,56],[6,23,24,58],
 [6,23,24,59],[6,23,24,60],[6,23,24,61],[6,23,24,67],
 [6,23,24,68],[6,23,25,26],[6,23,25,35],[6,23,25,39],
 [6,23,25,45],[6,23,25,46],[6,23,25,47],[6,23,25,48],
 [6,23,25,58],[6,23,25,59],[6,23,25,60],[6,23,25,61],
 [6,23,25,67],[6,23,26,35],[6,23,26,36],[6,23,26,39],
 [6,23,26,41],[6,23,26,45],[6,23,26,46],[6,23,26,47],
 [6,23,26,48],[6,23,26,52],[6,23,26,56],[6,23,26,58],
 [6,23,26,59],[6,23,26,60],[6,23,26,61],[6,23,26,67],
 [6,23,26,68],[6,23,35,36],[6,23,35,41],[6,23,35,47],
 [6,23,35,48],[6,23,35,52],[6,23,35,56],[6,23,35,58],
 [6,23,35,59],[6,23,35,60],[6,23,35,67],[6,23,35,68],
 [6,23,36,46],[6,23,36,48],[6,23,36,60],[6,23,36,61],
 [6,23,39,45],[6,23,39,46],[6,23,39,47],[6,23,39,48],
 [6,23,39,58],[6,23,39,60],[6,23,39,61],[6,23,39,67],
 [6,23,41,45],[6,23,41,47],[6,23,41,48],[6,23,41,59],
 [6,23,41,60],[6,23,41,61],[6,23,41,68],[6,23,45,46],
 [6,23,45,47],[6,23,45,48],[6,23,45,52],[6,23,45,60],
 [6,23,45,67],[6,23,45,68],[6,23,46,47],[6,23,46,48],
 [6,23,46,52],[6,23,46,56],[6,23,46,58],[6,23,46,59],
 [6,23,46,60],[6,23,46,61],[6,23,46,67],[6,23,46,68],
 [6,23,47,48],[6,23,47,52],[6,23,47,58],[6,23,47,59],
 [6,23,47,60],[6,23,47,61],[6,23,47,67],[6,23,47,68],
 [6,23,48,52],[6,23,48,56],[6,23,48,58],[6,23,48,60],
 [6,23,48,61],[6,23,48,67],[6,23,48,68],[6,23,52,61],
 [6,23,56,61],[6,23,58,60],[6,23,58,61],[6,23,58,67],
 [6,23,59,60],[6,23,59,61],[6,23,59,68],[6,23,60,61],
 [6,23,60,67],[6,23,61,67],[6,23,61,68],[6,24,25,26],
 [6,24,25,33],[6,24,25,35],[6,24,25,36],[6,24,25,46],
 [6,24,25,47],[6,24,25,48],[6,24,25,49],[6,24,25,51],
 [6,24,25,54],[6,24,25,58],[6,24,25,59],[6,24,25,60],
 [6,24,25,61],[6,24,25,67],[6,24,26,36],[6,24,26,41],
 [6,24,26,44],[6,24,26,46],[6,24,26,47],[6,24,26,48],
 [6,24,26,49],[6,24,26,51],[6,24,26,52],[6,24,26,54],
 [6,24,26,56],[6,24,26,58],[6,24,26,59],[6,24,26,60],
 [6,24,26,61],[6,24,26,67],[6,24,26,68],[6,24,33,35],
 [6,24,33,36],[6,24,33,47],[6,24,33,48],[6,24,33,52],
 [6,24,33,56],[6,24,33,58],[6,24,33,59],[6,24,33,60],
 [6,24,33,67],[6,24,33,68],[6,24,35,36],[6,24,35,41],
 [6,24,35,47],[6,24,35,48],[6,24,35,52],[6,24,35,56],
 [6,24,35,58],[6,24,35,59],[6,24,35,60],[6,24,35,67],
 [6,24,35,68],[6,24,36,46],[6,24,36,48],[6,24,36,49],
 [6,24,36,51],[6,24,36,54],[6,24,36,60],[6,24,36,61],
 [6,24,41,44],[6,24,41,47],[6,24,41,48],[6,24,41,49],
 [6,24,41,54],[6,24,41,59],[6,24,41,60],[6,24,41,61],
 [6,24,41,68],[6,24,44,46],[6,24,44,47],[6,24,44,48],
 [6,24,44,49],[6,24,44,51],[6,24,44,54],[6,24,44,56],
 [6,24,44,59],[6,24,44,60],[6,24,44,61],[6,24,44,67],
 [6,24,44,68],[6,24,46,47],[6,24,46,48],[6,24,46,52],
 [6,24,46,56],[6,24,46,58],[6,24,46,59],[6,24,46,60],
 [6,24,46,61],[6,24,46,67],[6,24,46,68],[6,24,47,48],
 [6,24,47,49],[6,24,47,51],[6,24,47,52],[6,24,47,54],
 [6,24,47,56],[6,24,47,58],[6,24,47,59],[6,24,47,60],
 [6,24,47,61],[6,24,47,67],[6,24,47,68],[6,24,48,52],
 [6,24,48,56],[6,24,48,58],[6,24,48,60],[6,24,48,61],
 [6,24,48,67],[6,24,48,68],[6,24,49,52],[6,24,49,56],
 [6,24,49,58],[6,24,49,59],[6,24,49,60],[6,24,49,61],
 [6,24,49,67],[6,24,49,68],[6,24,51,52],[6,24,51,56],
 [6,24,51,58],[6,24,51,60],[6,24,51,61],[6,24,51,67],
 [6,24,51,68],[6,24,52,54],[6,24,52,61],[6,24,54,56],
 [6,24,54,60],[6,24,54,61],[6,24,54,67],[6,24,54,68],
 [6,24,56,61],[6,24,58,60],[6,24,58,61],[6,24,58,67],
 [6,24,59,60],[6,24,59,61],[6,24,59,68],[6,24,60,61],
 [6,24,60,67],[6,24,61,67],[6,24,61,68],[6,25,26,35],
 [6,25,26,39],[6,25,26,45],[6,25,26,46],[6,25,26,47],
 [6,25,26,48],[6,25,26,49],[6,25,26,51],[6,25,26,54],
 [6,25,26,58],[6,25,26,59],[6,25,26,60],[6,25,26,61],
 [6,25,26,67],[6,25,33,35],[6,25,33,36],[6,25,33,45],
 [6,25,33,46],[6,25,33,48],[6,25,33,54],[6,25,33,59],
 [6,25,33,60],[6,25,33,61],[6,25,35,36],[6,25,35,47],
 [6,25,35,48],[6,25,35,58],[6,25,35,59],[6,25,35,60],
 [6,25,35,67],[6,25,36,45],[6,25,36,46],[6,25,36,48],
 [6,25,36,49],[6,25,36,51],[6,25,36,54],[6,25,36,60],
 [6,25,36,61],[6,25,39,45],[6,25,39,46],[6,25,39,47],
 [6,25,39,48],[6,25,39,49],[6,25,39,58],[6,25,39,60],
 [6,25,39,61],[6,25,39,67],[6,25,45,46],[6,25,45,47],
 [6,25,45,48],[6,25,45,54],[6,25,45,60],[6,25,45,67],
 [6,25,46,47],[6,25,46,48],[6,25,46,58],[6,25,46,59],
 [6,25,46,60],[6,25,46,61],[6,25,46,67],[6,25,47,48],
 [6,25,47,49],[6,25,47,51],[6,25,47,58],[6,25,47,59],
 [6,25,47,60],[6,25,47,61],[6,25,47,67],[6,25,48,58],
 [6,25,48,60],[6,25,48,61],[6,25,48,67],[6,25,49,58],
 [6,25,49,59],[6,25,49,60],[6,25,49,61],[6,25,49,67],
 [6,25,51,58],[6,25,51,60],[6,25,51,61],[6,25,51,67],
 [6,25,54,58],[6,25,54,60],[6,25,54,61],[6,25,54,67],
 [6,25,58,60],[6,25,58,61],[6,25,58,67],[6,25,59,60],
 [6,25,59,61],[6,25,60,61],[6,25,60,67],[6,25,61,67],
 [6,26,35,36],[6,26,35,41],[6,26,35,47],[6,26,35,48],
 [6,26,35,52],[6,26,35,56],[6,26,35,58],[6,26,35,59],
 [6,26,35,60],[6,26,35,67],[6,26,35,68],[6,26,36,45],
 [6,26,36,46],[6,26,36,48],[6,26,36,49],[6,26,36,51],
 [6,26,36,54],[6,26,36,60],[6,26,36,61],[6,26,39,44],
 [6,26,39,45],[6,26,39,46],[6,26,39,47],[6,26,39,48],
 [6,26,39,49],[6,26,39,58],[6,26,39,60],[6,26,39,61],
 [6,26,39,67],[6,26,41,44],[6,26,41,45],[6,26,41,47],
 [6,26,41,48],[6,26,41,49],[6,26,41,54],[6,26,41,59],
 [6,26,41,60],[6,26,41,61],[6,26,41,68],[6,26,44,46],
 [6,26,44,47],[6,26,44,48],[6,26,44,49],[6,26,44,51],
 [6,26,44,54],[6,26,44,56],[6,26,44,59],[6,26,44,60],
 [6,26,44,61],[6,26,44,67],[6,26,44,68],[6,26,45,46],
 [6,26,45,47],[6,26,45,48],[6,26,45,52],[6,26,45,60],
 [6,26,45,67],[6,26,45,68],[6,26,46,47],[6,26,46,48],
 [6,26,46,52],[6,26,46,56],[6,26,46,58],[6,26,46,59],
 [6,26,46,60],[6,26,46,61],[6,26,46,67],[6,26,46,68],
 [6,26,47,48],[6,26,47,49],[6,26,47,51],[6,26,47,52],
 [6,26,47,54],[6,26,47,56],[6,26,47,58],[6,26,47,59],
 [6,26,47,60],[6,26,47,61],[6,26,47,67],[6,26,47,68],
 [6,26,48,52],[6,26,48,56],[6,26,48,58],[6,26,48,60],
 [6,26,48,61],[6,26,48,67],[6,26,48,68],[6,26,49,52],
 [6,26,49,56],[6,26,49,58],[6,26,49,59],[6,26,49,60],
 [6,26,49,61],[6,26,49,67],[6,26,49,68],[6,26,51,52],
 [6,26,51,56],[6,26,51,58],[6,26,51,60],[6,26,51,61],
 [6,26,51,67],[6,26,51,68],[6,26,52,54],[6,26,52,61],
 [6,26,54,56],[6,26,54,58],[6,26,54,60],[6,26,54,61],
 [6,26,54,67],[6,26,54,68],[6,26,56,61],[6,26,58,60],
 [6,26,58,61],[6,26,58,67],[6,26,59,60],[6,26,59,61],
 [6,26,59,68],[6,26,60,61],[6,26,60,67],[6,26,61,67],
 [6,26,61,68],[6,33,35,36],[6,33,35,47],[6,33,35,48],
 [6,33,35,52],[6,33,35,56],[6,33,35,58],[6,33,35,59],
 [6,33,35,60],[6,33,35,67],[6,33,35,68],[6,33,36,45],
 [6,33,36,46],[6,33,36,48],[6,33,36,54],[6,33,36,60],
 [6,33,36,61],[6,33,44,46],[6,33,44,47],[6,33,44,48],
 [6,33,44,54],[6,33,44,56],[6,33,44,59],[6,33,44,60],
 [6,33,44,61],[6,33,44,67],[6,33,44,68],[6,33,45,46],
 [6,33,45,47],[6,33,45,48],[6,33,45,52],[6,33,45,54],
 [6,33,45,60],[6,33,45,67],[6,33,45,68],[6,33,46,47],
 [6,33,46,48],[6,33,46,52],[6,33,46,56],[6,33,46,58],
 [6,33,46,60],[6,33,46,61],[6,33,46,67],[6,33,46,68],
 [6,33,47,48],[6,33,47,52],[6,33,47,54],[6,33,47,56],
 [6,33,47,58],[6,33,47,59],[6,33,47,60],[6,33,47,61],
 [6,33,47,67],[6,33,47,68],[6,33,48,52],[6,33,48,56],
 [6,33,48,58],[6,33,48,60],[6,33,48,61],[6,33,48,67],
 [6,33,48,68],[6,33,52,54],[6,33,52,61],[6,33,54,56],
 [6,33,54,58],[6,33,54,60],[6,33,54,61],[6,33,54,67],
 [6,33,54,68],[6,33,56,61],[6,33,58,60],[6,33,58,61],
 [6,33,58,67],[6,33,59,60],[6,33,59,61],[6,33,59,68],
 [6,33,60,61],[6,33,60,67],[6,33,61,67],[6,33,61,68],
 [6,35,36,48],[6,35,36,60],[6,35,41,47],[6,35,41,48],
 [6,35,41,59],[6,35,41,68],[6,35,47,48],[6,35,47,59],
 [6,35,47,67],[6,35,47,68],[6,35,48,52],[6,35,48,56],
 [6,35,48,58],[6,35,48,60],[6,35,48,67],[6,35,48,68],
 [6,35,58,67],[6,35,59,60],[6,35,59,68],[6,36,45,46],
 [6,36,45,48],[6,36,45,54],[6,36,45,60],[6,36,46,48],
 [6,36,46,61],[6,36,48,60],[6,36,48,61],[6,36,49,60],
 [6,36,49,61],[6,36,51,61],[6,36,54,61],[6,39,44,46],
 [6,39,44,47],[6,39,44,48],[6,39,44,49],[6,39,44,60],
 [6,39,44,61],[6,39,44,67],[6,39,45,46],[6,39,45,47],
 [6,39,45,48],[6,39,45,60],[6,39,45,67],[6,39,46,47],
 [6,39,46,48],[6,39,46,58],[6,39,46,60],[6,39,46,61],
 [6,39,46,67],[6,39,47,48],[6,39,47,49],[6,39,47,58],
 [6,39,47,60],[6,39,47,61],[6,39,47,67],[6,39,48,58],
 [6,39,48,60],[6,39,48,61],[6,39,48,67],[6,39,49,58],
 [6,39,49,60],[6,39,49,61],[6,39,49,67],[6,39,58,60],
 [6,39,58,61],[6,39,58,67],[6,39,60,61],[6,39,60,67],
 [6,39,61,67],[6,41,44,47],[6,41,44,48],[6,41,44,49],
 [6,41,44,54],[6,41,44,59],[6,41,44,60],[6,41,44,61],
 [6,41,44,68],[6,41,45,47],[6,41,45,48],[6,41,45,60],
 [6,41,45,68],[6,41,47,48],[6,41,47,49],[6,41,47,54],
 [6,41,47,59],[6,41,47,60],[6,41,47,61],[6,41,47,68],
 [6,41,48,60],[6,41,48,61],[6,41,48,68],[6,41,49,59],
 [6,41,49,60],[6,41,49,61],[6,41,49,68],[6,41,54,61],
 [6,41,54,68],[6,41,59,60],[6,41,59,61],[6,41,59,68],
 [6,41,60,61],[6,41,61,68],[6,44,46,47],[6,44,46,48],
 [6,44,46,59],[6,44,46,60],[6,44,46,61],[6,44,46,67],
 [6,44,46,68],[6,44,47,48],[6,44,47,49],[6,44,47,54],
 [6,44,47,56],[6,44,47,59],[6,44,47,60],[6,44,47,61],
 [6,44,47,67],[6,44,47,68],[6,44,48,56],[6,44,48,60],
 [6,44,48,61],[6,44,48,67],[6,44,48,68],[6,44,49,56],
 [6,44,49,59],[6,44,49,60],[6,44,49,61],[6,44,49,67],
 [6,44,49,68],[6,44,51,61],[6,44,51,67],[6,44,51,68],
 [6,44,54,56],[6,44,54,61],[6,44,54,67],[6,44,54,68],
 [6,44,56,61],[6,44,59,60],[6,44,59,61],[6,44,59,68],
 [6,44,60,61],[6,44,60,67],[6,44,61,67],[6,44,61,68],
 [6,45,46,47],[6,45,46,48],[6,45,46,52],[6,45,46,60],
 [6,45,46,67],[6,45,46,68],[6,45,47,48],[6,45,47,52],
 [6,45,47,60],[6,45,47,67],[6,45,47,68],[6,45,48,52],
 [6,45,48,60],[6,45,48,67],[6,45,48,68],[6,45,52,54],
 [6,45,54,60],[6,45,54,67],[6,45,54,68],[6,45,60,67],
 [6,46,47,48],[6,46,47,58],[6,46,47,59],[6,46,47,60],
 [6,46,47,61],[6,46,47,67],[6,46,47,68],[6,46,48,52],
 [6,46,48,56],[6,46,48,58],[6,46,48,60],[6,46,48,61],
 [6,46,48,67],[6,46,48,68],[6,46,52,61],[6,46,56,61],
 [6,46,58,60],[6,46,58,61],[6,46,58,67],[6,46,59,60],
 [6,46,59,61],[6,46,59,68],[6,46,60,61],[6,46,60,67],
 [6,46,61,67],[6,46,61,68],[6,47,48,52],[6,47,48,58],
 [6,47,48,60],[6,47,48,61],[6,47,48,67],[6,47,48,68],
 [6,47,49,56],[6,47,49,58],[6,47,49,59],[6,47,49,60],
 [6,47,49,61],[6,47,49,67],[6,47,49,68],[6,47,51,52],
 [6,47,51,61],[6,47,51,67],[6,47,52,61],[6,47,54,56],
 [6,47,54,61],[6,47,54,68],[6,47,56,61],[6,47,58,60],
 [6,47,58,61],[6,47,58,67],[6,47,59,60],[6,47,59,61],
 [6,47,59,68],[6,47,60,61],[6,47,60,67],[6,47,61,67],
 [6,47,61,68],[6,48,52,61],[6,48,56,61],[6,48,58,60],
 [6,48,58,61],[6,48,58,67],[6,48,60,61],[6,48,60,67],
 [6,48,61,67],[6,48,61,68],[6,49,52,61],[6,49,56,61],
 [6,49,58,60],[6,49,58,61],[6,49,58,67],[6,49,59,60],
 [6,49,59,61],[6,49,59,68],[6,49,60,61],[6,49,60,67],
 [6,49,61,67],[6,49,61,68],[6,51,52,61],[6,51,56,61],
 [6,51,58,60],[6,51,58,61],[6,51,58,67],[6,51,60,61],
 [6,51,60,67],[6,51,61,67],[6,51,61,68],[6,52,54,61],
 [6,54,56,61],[6,54,58,60],[6,54,58,61],[6,54,58,67],
 [6,54,60,61],[6,54,60,67],[6,54,61,67],[6,54,61,68],
 [6,58,60,61],[6,58,60,67],[6,58,61,67],[6,59,60,61],
 [6,59,61,68],[6,60,61,67],[7,9,13,15],[7,9,13,16],
 [7,9,13,19],[7,9,13,20],[7,9,13,21],[7,9,13,22],
 [7,9,13,23],[7,9,13,24],[7,9,13,25],[7,9,13,26],
 [7,9,13,27],[7,9,13,34],[7,9,13,39],[7,9,13,41],
 [7,9,13,43],[7,9,13,44],[7,9,13,45],[7,9,13,46],
 [7,9,13,47],[7,9,13,48],[7,9,13,49],[7,9,13,55],
 [7,9,13,58],[7,9,13,59],[7,9,13,60],[7,9,13,61],
 [7,9,13,62],[7,9,13,66],[7,9,13,67],[7,9,13,68],
 [7,9,13,69],[7,9,15,16],[7,9,15,19],[7,9,15,20],
 [7,9,15,21],[7,9,15,22],[7,9,15,23],[7,9,15,24],
 [7,9,15,25],[7,9,15,26],[7,9,15,27],[7,9,15,34],
 [7,9,15,39],[7,9,15,41],[7,9,15,43],[7,9,15,44],
 [7,9,15,45],[7,9,15,46],[7,9,15,47],[7,9,15,48],
 [7,9,15,49],[7,9,15,55],[7,9,15,58],[7,9,15,59],
 [7,9,15,60],[7,9,15,61],[7,9,15,62],[7,9,15,66],
 [7,9,15,67],[7,9,15,68],[7,9,15,69],[7,9,16,19],
 [7,9,16,20],[7,9,16,21],[7,9,16,22],[7,9,16,23],
 [7,9,16,24],[7,9,16,25],[7,9,16,26],[7,9,16,27],
 [7,9,16,34],[7,9,16,39],[7,9,16,41],[7,9,16,43],
 [7,9,16,44],[7,9,16,45],[7,9,16,46],[7,9,16,47],
 [7,9,16,48],[7,9,16,49],[7,9,16,55],[7,9,16,58],
 [7,9,16,59],[7,9,16,60],[7,9,16,61],[7,9,16,62],
 [7,9,16,66],[7,9,16,67],[7,9,16,68],[7,9,16,69],
 [7,9,19,20],[7,9,19,21],[7,9,19,22],[7,9,19,23],
 [7,9,19,24],[7,9,19,25],[7,9,19,26],[7,9,19,27],
 [7,9,19,34],[7,9,19,39],[7,9,19,41],[7,9,19,43],
 [7,9,19,44],[7,9,19,45],[7,9,19,46],[7,9,19,47],
 [7,9,19,48],[7,9,19,49],[7,9,19,55],[7,9,19,58],
 [7,9,19,59],[7,9,19,60],[7,9,19,61],[7,9,19,62],
 [7,9,19,66],[7,9,19,67],[7,9,19,68],[7,9,19,69],
 [7,9,20,21],[7,9,20,22],[7,9,20,23],[7,9,20,24],
 [7,9,20,25],[7,9,20,26],[7,9,20,27],[7,9,20,34],
 [7,9,20,39],[7,9,20,41],[7,9,20,43],[7,9,20,44],
 [7,9,20,45],[7,9,20,46],[7,9,20,47],[7,9,20,48],
 [7,9,20,49],[7,9,20,55],[7,9,20,58],[7,9,20,59],
 [7,9,20,60],[7,9,20,61],[7,9,20,62],[7,9,20,66],
 [7,9,20,67],[7,9,20,68],[7,9,20,69],[7,9,21,22],
 [7,9,21,23],[7,9,21,24],[7,9,21,25],[7,9,21,26],
 [7,9,21,27],[7,9,21,34],[7,9,21,39],[7,9,21,41],
 [7,9,21,43],[7,9,21,44],[7,9,21,45],[7,9,21,46],
 [7,9,21,47],[7,9,21,48],[7,9,21,49],[7,9,21,55],
 [7,9,21,58],[7,9,21,59],[7,9,21,60],[7,9,21,61],
 [7,9,21,62],[7,9,21,66],[7,9,21,67],[7,9,21,68],
 [7,9,21,69],[7,9,22,23],[7,9,22,24],[7,9,22,25],
 [7,9,22,26],[7,9,22,27],[7,9,22,34],[7,9,22,39],
 [7,9,22,41],[7,9,22,43],[7,9,22,44],[7,9,22,45],
 [7,9,22,46],[7,9,22,47],[7,9,22,48],[7,9,22,49],
 [7,9,22,55],[7,9,22,58],[7,9,22,59],[7,9,22,60],
 [7,9,22,61],[7,9,22,62],[7,9,22,66],[7,9,22,67],
 [7,9,22,68],[7,9,22,69],[7,9,23,24],[7,9,23,25],
 [7,9,23,26],[7,9,23,27],[7,9,23,34],[7,9,23,39],
 [7,9,23,41],[7,9,23,43],[7,9,23,44],[7,9,23,45],
 [7,9,23,46],[7,9,23,47],[7,9,23,48],[7,9,23,49],
 [7,9,23,55],[7,9,23,58],[7,9,23,59],[7,9,23,60],
 [7,9,23,61],[7,9,23,62],[7,9,23,66],[7,9,23,67],
 [7,9,23,68],[7,9,23,69],[7,9,24,25],[7,9,24,26],
 [7,9,24,27],[7,9,24,34],[7,9,24,39],[7,9,24,41],
 [7,9,24,43],[7,9,24,44],[7,9,24,45],[7,9,24,46],
 [7,9,24,47],[7,9,24,48],[7,9,24,49],[7,9,24,55],
 [7,9,24,58],[7,9,24,59],[7,9,24,60],[7,9,24,61],
 [7,9,24,62],[7,9,24,66],[7,9,24,67],[7,9,24,68],
 [7,9,24,69],[7,9,25,26],[7,9,25,27],[7,9,25,34],
 [7,9,25,39],[7,9,25,41],[7,9,25,43],[7,9,25,44],
 [7,9,25,45],[7,9,25,46],[7,9,25,47],[7,9,25,48],
 [7,9,25,49],[7,9,25,55],[7,9,25,58],[7,9,25,59],
 [7,9,25,60],[7,9,25,61],[7,9,25,62],[7,9,25,66],
 [7,9,25,67],[7,9,25,68],[7,9,25,69],[7,9,26,27],
 [7,9,26,34],[7,9,26,39],[7,9,26,41],[7,9,26,43],
 [7,9,26,44],[7,9,26,45],[7,9,26,46],[7,9,26,47],
 [7,9,26,48],[7,9,26,49],[7,9,26,55],[7,9,26,58],
 [7,9,26,59],[7,9,26,60],[7,9,26,61],[7,9,26,62],
 [7,9,26,66],[7,9,26,67],[7,9,26,68],[7,9,26,69],
 [7,9,27,34],[7,9,27,39],[7,9,27,41],[7,9,27,43],
 [7,9,27,44],[7,9,27,45],[7,9,27,46],[7,9,27,47],
 [7,9,27,48],[7,9,27,49],[7,9,27,55],[7,9,27,58],
 [7,9,27,59],[7,9,27,60],[7,9,27,61],[7,9,27,62],
 [7,9,27,66],[7,9,27,67],[7,9,27,68],[7,9,27,69],
 [7,9,34,39],[7,9,34,41],[7,9,34,43],[7,9,34,44],
 [7,9,34,45],[7,9,34,46],[7,9,34,47],[7,9,34,48],
 [7,9,34,49],[7,9,34,55],[7,9,34,58],[7,9,34,59],
 [7,9,34,60],[7,9,34,61],[7,9,34,62],[7,9,34,66],
 [7,9,34,67],[7,9,34,68],[7,9,34,69],[7,9,39,41],
 [7,9,39,43],[7,9,39,44],[7,9,39,45],[7,9,39,46],
 [7,9,39,47],[7,9,39,48],[7,9,39,49],[7,9,39,55],
 [7,9,39,58],[7,9,39,59],[7,9,39,60],[7,9,39,61],
 [7,9,39,62],[7,9,39,66],[7,9,39,67],[7,9,39,68],
 [7,9,39,69],[7,9,41,43],[7,9,41,44],[7,9,41,45],
 [7,9,41,46],[7,9,41,47],[7,9,41,48],[7,9,41,49],
 [7,9,41,55],[7,9,41,58],[7,9,41,59],[7,9,41,60],
 [7,9,41,61],[7,9,41,62],[7,9,41,66],[7,9,41,67],
 [7,9,41,68],[7,9,41,69],[7,9,43,44],[7,9,43,45],
 [7,9,43,46],[7,9,43,47],[7,9,43,48],[7,9,43,49],
 [7,9,43,55],[7,9,43,58],[7,9,43,59],[7,9,43,60],
 [7,9,43,61],[7,9,43,62],[7,9,43,66],[7,9,43,67],
 [7,9,43,68],[7,9,43,69],[7,9,44,45],[7,9,44,46],
 [7,9,44,47],[7,9,44,48],[7,9,44,49],[7,9,44,55],
 [7,9,44,58],[7,9,44,59],[7,9,44,60],[7,9,44,61],
 [7,9,44,62],[7,9,44,66],[7,9,44,67],[7,9,44,68],
 [7,9,44,69],[7,9,45,46],[7,9,45,47],[7,9,45,48],
 [7,9,45,49],[7,9,45,55],[7,9,45,58],[7,9,45,59],
 [7,9,45,60],[7,9,45,61],[7,9,45,62],[7,9,45,66],
 [7,9,45,67],[7,9,45,68],[7,9,45,69],[7,9,46,47],
 [7,9,46,48],[7,9,46,49],[7,9,46,55],[7,9,46,58],
 [7,9,46,59],[7,9,46,60],[7,9,46,61],[7,9,46,62],
 [7,9,46,66],[7,9,46,67],[7,9,46,68],[7,9,46,69],
 [7,9,47,48],[7,9,47,49],[7,9,47,55],[7,9,47,58],
 [7,9,47,59],[7,9,47,60],[7,9,47,61],[7,9,47,62],
 [7,9,47,66],[7,9,47,67],[7,9,47,68],[7,9,47,69],
 [7,9,48,49],[7,9,48,55],[7,9,48,58],[7,9,48,59],
 [7,9,48,60],[7,9,48,61],[7,9,48,62],[7,9,48,66],
 [7,9,48,67],[7,9,48,68],[7,9,48,69],[7,9,49,55],
 [7,9,49,58],[7,9,49,59],[7,9,49,60],[7,9,49,61],
 [7,9,49,62],[7,9,49,66],[7,9,49,67],[7,9,49,68],
 [7,9,49,69],[7,9,55,58],[7,9,55,59],[7,9,55,60],
 [7,9,55,61],[7,9,55,62],[7,9,55,66],[7,9,55,67],
 [7,9,55,68],[7,9,55,69],[7,9,58,59],[7,9,58,60],
 [7,9,58,61],[7,9,58,62],[7,9,58,66],[7,9,58,67],
 [7,9,58,68],[7,9,58,69],[7,9,59,60],[7,9,59,61],
 [7,9,59,62],[7,9,59,66],[7,9,59,67],[7,9,59,68],
 [7,9,59,69],[7,9,60,61],[7,9,60,62],[7,9,60,66],
 [7,9,60,67],[7,9,60,68],[7,9,60,69],[7,9,61,62],
 [7,9,61,66],[7,9,61,67],[7,9,61,68],[7,9,61,69],
 [7,9,62,66],[7,9,62,67],[7,9,62,68],[7,9,62,69],
 [7,9,66,67],[7,9,66,68],[7,9,66,69],[7,9,67,68],
 [7,9,67,69],[7,9,68,69],[7,10,12,16],[7,10,12,19],
 [7,10,12,21],[7,10,12,23],[7,10,12,25],[7,10,12,26],
 [7,10,12,35],[7,10,12,37],[7,10,12,45],[7,10,12,47],
 [7,10,12,48],[7,10,12,58],[7,10,12,62],[7,10,12,67],
 [7,10,16,19],[7,10,16,21],[7,10,16,23],[7,10,16,25],
 [7,10,16,26],[7,10,16,27],[7,10,16,35],[7,10,16,37],
 [7,10,16,45],[7,10,16,47],[7,10,16,48],[7,10,16,49],
 [7,10,16,57],[7,10,16,62],[7,10,16,66],[7,10,16,67],
 [7,10,16,69],[7,10,18,19],[7,10,18,23],[7,10,18,25],
 [7,10,18,26],[7,10,18,30],[7,10,18,35],[7,10,18,47],
 [7,10,18,48],[7,10,18,55],[7,10,18,66],[7,10,18,67],
 [7,10,19,21],[7,10,19,23],[7,10,19,25],[7,10,19,26],
 [7,10,19,27],[7,10,19,35],[7,10,19,37],[7,10,19,41],
 [7,10,19,48],[7,10,19,49],[7,10,19,55],[7,10,19,57],
 [7,10,19,58],[7,10,19,59],[7,10,19,62],[7,10,19,66],
 [7,10,19,67],[7,10,19,68],[7,10,19,69],[7,10,21,23],
 [7,10,21,25],[7,10,21,26],[7,10,21,35],[7,10,21,37],
 [7,10,21,41],[7,10,21,45],[7,10,21,47],[7,10,21,48],
 [7,10,21,49],[7,10,21,59],[7,10,21,62],[7,10,21,67],
 [7,10,21,69],[7,10,23,25],[7,10,23,26],[7,10,23,27],
 [7,10,23,30],[7,10,23,35],[7,10,23,37],[7,10,23,41],
 [7,10,23,45],[7,10,23,47],[7,10,23,48],[7,10,23,49],
 [7,10,23,55],[7,10,23,57],[7,10,23,58],[7,10,23,59],
 [7,10,23,62],[7,10,23,66],[7,10,23,67],[7,10,23,68],
 [7,10,23,69],[7,10,25,26],[7,10,25,27],[7,10,25,35],
 [7,10,25,37],[7,10,25,41],[7,10,25,45],[7,10,25,47],
 [7,10,25,48],[7,10,25,49],[7,10,25,57],[7,10,25,59],
 [7,10,25,62],[7,10,25,66],[7,10,25,67],[7,10,25,68],
 [7,10,25,69],[7,10,26,27],[7,10,26,35],[7,10,26,37],
 [7,10,26,41],[7,10,26,45],[7,10,26,47],[7,10,26,48],
 [7,10,26,49],[7,10,26,55],[7,10,26,57],[7,10,26,58],
 [7,10,26,62],[7,10,26,66],[7,10,26,67],[7,10,26,68],
 [7,10,26,69],[7,10,27,35],[7,10,27,41],[7,10,27,47],
 [7,10,27,48],[7,10,27,49],[7,10,27,55],[7,10,27,58],
 [7,10,27,59],[7,10,27,66],[7,10,27,67],[7,10,27,68],
 [7,10,27,69],[7,10,30,35],[7,10,30,58],[7,10,30,67],
 [7,10,35,37],[7,10,35,41],[7,10,35,45],[7,10,35,47],
 [7,10,35,48],[7,10,35,49],[7,10,35,55],[7,10,35,57],
 [7,10,35,58],[7,10,35,59],[7,10,35,62],[7,10,35,66],
 [7,10,35,67],[7,10,35,68],[7,10,35,69],[7,10,37,45],
 [7,10,37,47],[7,10,37,48],[7,10,37,62],[7,10,37,67],
 [7,10,41,47],[7,10,41,48],[7,10,41,49],[7,10,41,55],
 [7,10,41,58],[7,10,41,59],[7,10,41,66],[7,10,41,67],
 [7,10,41,68],[7,10,41,69],[7,10,45,47],[7,10,45,48],
 [7,10,45,49],[7,10,45,58],[7,10,45,62],[7,10,45,66],
 [7,10,45,67],[7,10,45,69],[7,10,47,48],[7,10,47,49],
 [7,10,47,55],[7,10,47,57],[7,10,47,58],[7,10,47,59],
 [7,10,47,62],[7,10,47,66],[7,10,47,67],[7,10,47,68],
 [7,10,47,69],[7,10,48,49],[7,10,48,55],[7,10,48,57],
 [7,10,48,58],[7,10,48,59],[7,10,48,62],[7,10,48,66],
 [7,10,48,67],[7,10,48,68],[7,10,48,69],[7,10,49,55],
 [7,10,49,58],[7,10,49,59],[7,10,49,62],[7,10,49,66],
 [7,10,49,67],[7,10,49,68],[7,10,49,69],[7,10,55,59],
 [7,10,55,62],[7,10,55,66],[7,10,55,67],[7,10,55,68],
 [7,10,55,69],[7,10,57,58],[7,10,57,67],[7,10,58,59],
 [7,10,58,62],[7,10,58,66],[7,10,58,67],[7,10,58,68],
 [7,10,58,69],[7,10,59,66],[7,10,59,67],[7,10,59,68],
 [7,10,59,69],[7,10,62,67],[7,10,62,69],[7,10,66,67],
 [7,10,66,68],[7,10,66,69],[7,10,67,68],[7,10,67,69],
 [7,10,68,69],[7,12,13,21],[7,12,13,23],[7,12,13,24],
 [7,12,13,25],[7,12,13,37],[7,12,13,43],[7,12,13,44],
 [7,12,13,46],[7,12,13,47],[7,12,13,58],[7,12,13,60],
 [7,12,13,61],[7,12,13,67],[7,12,15,16],[7,12,15,19],
 [7,12,15,21],[7,12,15,22],[7,12,15,23],[7,12,15,24],
 [7,12,15,25],[7,12,15,26],[7,12,15,37],[7,12,15,43],
 [7,12,15,44],[7,12,15,45],[7,12,15,46],[7,12,15,47],
 [7,12,15,48],[7,12,15,60],[7,12,15,61],[7,12,15,64],
 [7,12,15,67],[7,12,16,19],[7,12,16,21],[7,12,16,22],
 [7,12,16,23],[7,12,16,24],[7,12,16,25],[7,12,16,26],
 [7,12,16,35],[7,12,16,37],[7,12,16,44],[7,12,16,45],
 [7,12,16,46],[7,12,16,47],[7,12,16,48],[7,12,16,61],
 [7,12,16,62],[7,12,16,67],[7,12,19,21],[7,12,19,22],
 [7,12,19,23],[7,12,19,24],[7,12,19,25],[7,12,19,26],
 [7,12,19,35],[7,12,19,37],[7,12,19,40],[7,12,19,44],
 [7,12,19,45],[7,12,19,46],[7,12,19,47],[7,12,19,48],
 [7,12,19,58],[7,12,19,60],[7,12,19,61],[7,12,19,62],
 [7,12,19,64],[7,12,19,67],[7,12,21,23],[7,12,21,24],
 [7,12,21,25],[7,12,21,26],[7,12,21,35],[7,12,21,37],
 [7,12,21,43],[7,12,21,44],[7,12,21,45],[7,12,21,46],
 [7,12,21,47],[7,12,21,48],[7,12,21,58],[7,12,21,60],
 [7,12,21,61],[7,12,21,62],[7,12,21,64],[7,12,21,67],
 [7,12,22,23],[7,12,22,24],[7,12,22,25],[7,12,22,26],
 [7,12,22,37],[7,12,22,43],[7,12,22,44],[7,12,22,45],
 [7,12,22,46],[7,12,22,48],[7,12,22,58],[7,12,22,60],
 [7,12,22,61],[7,12,22,67],[7,12,23,24],[7,12,23,25],
 [7,12,23,26],[7,12,23,31],[7,12,23,35],[7,12,23,37],
 [7,12,23,40],[7,12,23,43],[7,12,23,44],[7,12,23,45],
 [7,12,23,46],[7,12,23,47],[7,12,23,48],[7,12,23,58],
 [7,12,23,60],[7,12,23,61],[7,12,23,62],[7,12,23,64],
 [7,12,23,67],[7,12,24,25],[7,12,24,26],[7,12,24,37],
 [7,12,24,43],[7,12,24,44],[7,12,24,45],[7,12,24,46],
 [7,12,24,47],[7,12,24,48],[7,12,24,58],[7,12,24,60],
 [7,12,24,61],[7,12,24,67],[7,12,25,26],[7,12,25,31],
 [7,12,25,35],[7,12,25,37],[7,12,25,40],[7,12,25,43],
 [7,12,25,44],[7,12,25,45],[7,12,25,46],[7,12,25,47],
 [7,12,25,48],[7,12,25,60],[7,12,25,61],[7,12,25,62],
 [7,12,25,64],[7,12,25,67],[7,12,26,31],[7,12,26,35],
 [7,12,26,37],[7,12,26,40],[7,12,26,43],[7,12,26,44],
 [7,12,26,45],[7,12,26,46],[7,12,26,47],[7,12,26,48],
 [7,12,26,58],[7,12,26,60],[7,12,26,61],[7,12,26,62],
 [7,12,26,64],[7,12,26,67],[7,12,31,37],[7,12,31,44],
 [7,12,31,47],[7,12,31,48],[7,12,31,67],[7,12,35,37],
 [7,12,35,45],[7,12,35,47],[7,12,35,48],[7,12,35,58],
 [7,12,35,62],[7,12,35,67],[7,12,37,40],[7,12,37,43],
 [7,12,37,44],[7,12,37,45],[7,12,37,46],[7,12,37,47],
 [7,12,37,48],[7,12,37,58],[7,12,37,60],[7,12,37,61],
 [7,12,37,62],[7,12,37,64],[7,12,37,67],[7,12,40,47],
 [7,12,40,48],[7,12,40,58],[7,12,40,67],[7,12,43,44],
 [7,12,43,46],[7,12,43,47],[7,12,43,48],[7,12,43,58],
 [7,12,43,60],[7,12,43,61],[7,12,43,67],[7,12,44,46],
 [7,12,44,47],[7,12,44,58],[7,12,44,60],[7,12,44,61],
 [7,12,44,62],[7,12,44,67],[7,12,45,46],[7,12,45,47],
 [7,12,45,48],[7,12,45,58],[7,12,45,61],[7,12,45,62],
 [7,12,45,67],[7,12,46,47],[7,12,46,48],[7,12,46,58],
 [7,12,46,60],[7,12,46,61],[7,12,46,62],[7,12,46,67],
 [7,12,47,48],[7,12,47,58],[7,12,47,60],[7,12,47,61],
 [7,12,47,62],[7,12,47,64],[7,12,47,67],[7,12,48,58],
 [7,12,48,60],[7,12,48,61],[7,12,48,62],[7,12,48,64],
 [7,12,48,67],[7,12,58,60],[7,12,58,61],[7,12,58,62],
 [7,12,58,67],[7,12,60,61],[7,12,60,67],[7,12,61,62],
 [7,12,61,67],[7,12,62,67],[7,12,64,67],[7,13,15,16],
 [7,13,15,19],[7,13,15,20],[7,13,15,21],[7,13,15,22],
 [7,13,15,23],[7,13,15,24],[7,13,15,25],[7,13,15,26],
 [7,13,15,27],[7,13,15,34],[7,13,15,37],[7,13,15,39],
 [7,13,15,41],[7,13,15,43],[7,13,15,44],[7,13,15,45],
 [7,13,15,46],[7,13,15,47],[7,13,15,48],[7,13,15,49],
 [7,13,15,55],[7,13,15,58],[7,13,15,59],[7,13,15,60],
 [7,13,15,61],[7,13,15,62],[7,13,15,64],[7,13,15,66],
 [7,13,15,67],[7,13,15,68],[7,13,15,69],[7,13,16,19],
 [7,13,16,20],[7,13,16,21],[7,13,16,22],[7,13,16,23],
 [7,13,16,24],[7,13,16,25],[7,13,16,26],[7,13,16,27],
 [7,13,16,34],[7,13,16,39],[7,13,16,41],[7,13,16,43],
 [7,13,16,44],[7,13,16,45],[7,13,16,46],[7,13,16,47],
 [7,13,16,48],[7,13,16,49],[7,13,16,50],[7,13,16,55],
 [7,13,16,57],[7,13,16,58],[7,13,16,59],[7,13,16,60],
 [7,13,16,61],[7,13,16,62],[7,13,16,66],[7,13,16,67],
 [7,13,16,68],[7,13,16,69],[7,13,19,20],[7,13,19,21],
 [7,13,19,22],[7,13,19,23],[7,13,19,24],[7,13,19,25],
 [7,13,19,26],[7,13,19,27],[7,13,19,31],[7,13,19,34],
 [7,13,19,39],[7,13,19,41],[7,13,19,43],[7,13,19,44],
 [7,13,19,45],[7,13,19,46],[7,13,19,47],[7,13,19,48],
 [7,13,19,49],[7,13,19,55],[7,13,19,57],[7,13,19,58],
 [7,13,19,59],[7,13,19,60],[7,13,19,61],[7,13,19,62],
 [7,13,19,64],[7,13,19,66],[7,13,19,67],[7,13,19,68],
 [7,13,19,69],[7,13,20,21],[7,13,20,22],[7,13,20,23],
 [7,13,20,24],[7,13,20,25],[7,13,20,26],[7,13,20,27],
 [7,13,20,34],[7,13,20,39],[7,13,20,41],[7,13,20,43],
 [7,13,20,44],[7,13,20,45],[7,13,20,46],[7,13,20,47],
 [7,13,20,48],[7,13,20,49],[7,13,20,55],[7,13,20,57],
 [7,13,20,58],[7,13,20,59],[7,13,20,60],[7,13,20,61],
 [7,13,20,62],[7,13,20,64],[7,13,20,66],[7,13,20,67],
 [7,13,20,68],[7,13,20,69],[7,13,21,22],[7,13,21,23],
 [7,13,21,24],[7,13,21,25],[7,13,21,26],[7,13,21,27],
 [7,13,21,31],[7,13,21,34],[7,13,21,37],[7,13,21,39],
 [7,13,21,41],[7,13,21,43],[7,13,21,44],[7,13,21,45],
 [7,13,21,46],[7,13,21,47],[7,13,21,48],[7,13,21,49],
 [7,13,21,50],[7,13,21,51],[7,13,21,55],[7,13,21,57],
 [7,13,21,58],[7,13,21,59],[7,13,21,60],[7,13,21,61],
 [7,13,21,62],[7,13,21,64],[7,13,21,66],[7,13,21,67],
 [7,13,21,68],[7,13,21,69],[7,13,22,23],[7,13,22,24],
 [7,13,22,25],[7,13,22,26],[7,13,22,27],[7,13,22,34],
 [7,13,22,39],[7,13,22,41],[7,13,22,43],[7,13,22,44],
 [7,13,22,45],[7,13,22,46],[7,13,22,47],[7,13,22,48],
 [7,13,22,49],[7,13,22,55],[7,13,22,57],[7,13,22,58],
 [7,13,22,59],[7,13,22,60],[7,13,22,61],[7,13,22,62],
 [7,13,22,66],[7,13,22,67],[7,13,22,68],[7,13,22,69],
 [7,13,23,24],[7,13,23,25],[7,13,23,26],[7,13,23,27],
 [7,13,23,30],[7,13,23,31],[7,13,23,34],[7,13,23,37],
 [7,13,23,39],[7,13,23,41],[7,13,23,43],[7,13,23,44],
 [7,13,23,45],[7,13,23,46],[7,13,23,47],[7,13,23,48],
 [7,13,23,49],[7,13,23,50],[7,13,23,51],[7,13,23,55],
 [7,13,23,57],[7,13,23,58],[7,13,23,59],[7,13,23,60],
 [7,13,23,61],[7,13,23,62],[7,13,23,64],[7,13,23,66],
 [7,13,23,67],[7,13,23,68],[7,13,23,69],[7,13,24,25],
 [7,13,24,26],[7,13,24,27],[7,13,24,34],[7,13,24,37],
 [7,13,24,39],[7,13,24,41],[7,13,24,43],[7,13,24,44],
 [7,13,24,45],[7,13,24,46],[7,13,24,47],[7,13,24,48],
 [7,13,24,49],[7,13,24,55],[7,13,24,57],[7,13,24,58],
 [7,13,24,59],[7,13,24,60],[7,13,24,61],[7,13,24,62],
 [7,13,24,66],[7,13,24,67],[7,13,24,68],[7,13,24,69],
 [7,13,25,26],[7,13,25,27],[7,13,25,31],[7,13,25,34],
 [7,13,25,37],[7,13,25,39],[7,13,25,41],[7,13,25,43],
 [7,13,25,44],[7,13,25,45],[7,13,25,46],[7,13,25,47],
 [7,13,25,48],[7,13,25,49],[7,13,25,50],[7,13,25,51],
 [7,13,25,55],[7,13,25,57],[7,13,25,58],[7,13,25,59],
 [7,13,25,60],[7,13,25,61],[7,13,25,62],[7,13,25,64],
 [7,13,25,66],[7,13,25,67],[7,13,25,68],[7,13,25,69],
 [7,13,26,27],[7,13,26,31],[7,13,26,34],[7,13,26,39],
 [7,13,26,41],[7,13,26,43],[7,13,26,44],[7,13,26,45],
 [7,13,26,46],[7,13,26,47],[7,13,26,48],[7,13,26,49],
 [7,13,26,50],[7,13,26,51],[7,13,26,55],[7,13,26,57],
 [7,13,26,58],[7,13,26,59],[7,13,26,60],[7,13,26,61],
 [7,13,26,62],[7,13,26,64],[7,13,26,66],[7,13,26,67],
 [7,13,26,68],[7,13,26,69],[7,13,27,31],[7,13,27,34],
 [7,13,27,39],[7,13,27,41],[7,13,27,43],[7,13,27,44],
 [7,13,27,45],[7,13,27,46],[7,13,27,47],[7,13,27,48],
 [7,13,27,49],[7,13,27,55],[7,13,27,58],[7,13,27,59],
 [7,13,27,60],[7,13,27,61],[7,13,27,62],[7,13,27,64],
 [7,13,27,66],[7,13,27,67],[7,13,27,68],[7,13,27,69],
 [7,13,30,58],[7,13,30,67],[7,13,31,37],[7,13,31,48],
 [7,13,31,49],[7,13,31,66],[7,13,31,67],[7,13,31,69],
 [7,13,34,39],[7,13,34,41],[7,13,34,43],[7,13,34,44],
 [7,13,34,45],[7,13,34,46],[7,13,34,47],[7,13,34,48],
 [7,13,34,49],[7,13,34,55],[7,13,34,58],[7,13,34,59],
 [7,13,34,60],[7,13,34,61],[7,13,34,62],[7,13,34,66],
 [7,13,34,67],[7,13,34,68],[7,13,34,69],[7,13,37,43],
 [7,13,37,44],[7,13,37,46],[7,13,37,47],[7,13,37,60],
 [7,13,37,61],[7,13,37,62],[7,13,37,64],[7,13,37,67],
 [7,13,39,41],[7,13,39,43],[7,13,39,44],[7,13,39,45],
 [7,13,39,46],[7,13,39,47],[7,13,39,48],[7,13,39,49],
 [7,13,39,55],[7,13,39,58],[7,13,39,59],[7,13,39,60],
 [7,13,39,61],[7,13,39,62],[7,13,39,64],[7,13,39,66],
 [7,13,39,67],[7,13,39,68],[7,13,39,69],[7,13,41,43],
 [7,13,41,44],[7,13,41,45],[7,13,41,46],[7,13,41,47],
 [7,13,41,48],[7,13,41,49],[7,13,41,55],[7,13,41,58],
 [7,13,41,59],[7,13,41,60],[7,13,41,61],[7,13,41,62],
 [7,13,41,66],[7,13,41,67],[7,13,41,68],[7,13,41,69],
 [7,13,43,44],[7,13,43,45],[7,13,43,46],[7,13,43,47],
 [7,13,43,48],[7,13,43,49],[7,13,43,55],[7,13,43,57],
 [7,13,43,58],[7,13,43,59],[7,13,43,60],[7,13,43,61],
 [7,13,43,62],[7,13,43,64],[7,13,43,66],[7,13,43,67],
 [7,13,43,68],[7,13,43,69],[7,13,44,45],[7,13,44,46],
 [7,13,44,47],[7,13,44,48],[7,13,44,49],[7,13,44,50],
 [7,13,44,51],[7,13,44,55],[7,13,44,57],[7,13,44,58],
 [7,13,44,59],[7,13,44,60],[7,13,44,61],[7,13,44,62],
 [7,13,44,66],[7,13,44,67],[7,13,44,68],[7,13,44,69],
 [7,13,45,46],[7,13,45,47],[7,13,45,48],[7,13,45,49],
 [7,13,45,50],[7,13,45,51],[7,13,45,55],[7,13,45,57],
 [7,13,45,58],[7,13,45,59],[7,13,45,60],[7,13,45,61],
 [7,13,45,62],[7,13,45,66],[7,13,45,67],[7,13,45,68],
 [7,13,45,69],[7,13,46,47],[7,13,46,48],[7,13,46,49],
 [7,13,46,55],[7,13,46,57],[7,13,46,58],[7,13,46,59],
 [7,13,46,60],[7,13,46,61],[7,13,46,62],[7,13,46,66],
 [7,13,46,67],[7,13,46,68],[7,13,46,69],[7,13,47,48],
 [7,13,47,49],[7,13,47,50],[7,13,47,51],[7,13,47,55],
 [7,13,47,57],[7,13,47,58],[7,13,47,59],[7,13,47,60],
 [7,13,47,61],[7,13,47,62],[7,13,47,66],[7,13,47,67],
 [7,13,47,68],[7,13,47,69],[7,13,48,49],[7,13,48,50],
 [7,13,48,51],[7,13,48,55],[7,13,48,57],[7,13,48,58],
 [7,13,48,59],[7,13,48,60],[7,13,48,61],[7,13,48,62],
 [7,13,48,64],[7,13,48,66],[7,13,48,67],[7,13,48,68],
 [7,13,48,69],[7,13,49,55],[7,13,49,58],[7,13,49,59],
 [7,13,49,60],[7,13,49,61],[7,13,49,62],[7,13,49,64],
 [7,13,49,66],[7,13,49,67],[7,13,49,68],[7,13,49,69],
 [7,13,50,51],[7,13,50,55],[7,13,50,58],[7,13,50,59],
 [7,13,50,60],[7,13,50,61],[7,13,50,62],[7,13,50,64],
 [7,13,50,67],[7,13,50,68],[7,13,50,69],[7,13,51,55],
 [7,13,51,58],[7,13,51,59],[7,13,51,60],[7,13,51,61],
 [7,13,51,62],[7,13,51,64],[7,13,51,67],[7,13,51,68],
 [7,13,51,69],[7,13,55,58],[7,13,55,59],[7,13,55,60],
 [7,13,55,61],[7,13,55,62],[7,13,55,66],[7,13,55,67],
 [7,13,55,68],[7,13,55,69],[7,13,57,58],[7,13,57,60],
 [7,13,57,67],[7,13,58,59],[7,13,58,60],[7,13,58,61],
 [7,13,58,62],[7,13,58,66],[7,13,58,67],[7,13,58,68],
 [7,13,58,69],[7,13,59,60],[7,13,59,61],[7,13,59,62],
 [7,13,59,66],[7,13,59,67],[7,13,59,68],[7,13,59,69],
 [7,13,60,61],[7,13,60,62],[7,13,60,66],[7,13,60,67],
 [7,13,60,68],[7,13,60,69],[7,13,61,62],[7,13,61,66],
 [7,13,61,67],[7,13,61,68],[7,13,61,69],[7,13,62,66],
 [7,13,62,67],[7,13,62,68],[7,13,62,69],[7,13,64,66],
 [7,13,64,67],[7,13,64,69],[7,13,66,67],[7,13,66,68],
 [7,13,66,69],[7,13,67,68],[7,13,67,69],[7,13,68,69],
 [7,15,16,19],[7,15,16,20],[7,15,16,21],[7,15,16,22],
 [7,15,16,23],[7,15,16,24],[7,15,16,25],[7,15,16,26],
 [7,15,16,27],[7,15,16,34],[7,15,16,39],[7,15,16,41],
 [7,15,16,43],[7,15,16,44],[7,15,16,45],[7,15,16,46],
 [7,15,16,47],[7,15,16,48],[7,15,16,49],[7,15,16,55],
 [7,15,16,58],[7,15,16,59],[7,15,16,60],[7,15,16,61],
 [7,15,16,62],[7,15,16,66],[7,15,16,67],[7,15,16,68],
 [7,15,16,69],[7,15,18,20],[7,15,18,21],[7,15,18,23],
 [7,15,18,24],[7,15,18,25],[7,15,18,26],[7,15,18,41],
 [7,15,18,43],[7,15,18,46],[7,15,18,47],[7,15,18,48],
 [7,15,18,52],[7,15,18,57],[7,15,18,60],[7,15,18,61],
 [7,15,18,67],[7,15,19,20],[7,15,19,21],[7,15,19,22],
 [7,15,19,23],[7,15,19,24],[7,15,19,25],[7,15,19,26],
 [7,15,19,27],[7,15,19,34],[7,15,19,37],[7,15,19,39],
 [7,15,19,41],[7,15,19,43],[7,15,19,44],[7,15,19,45],
 [7,15,19,46],[7,15,19,47],[7,15,19,48],[7,15,19,49],
 [7,15,19,55],[7,15,19,58],[7,15,19,59],[7,15,19,60],
 [7,15,19,61],[7,15,19,62],[7,15,19,64],[7,15,19,66],
 [7,15,19,67],[7,15,19,68],[7,15,19,69],[7,15,20,21],
 [7,15,20,22],[7,15,20,23],[7,15,20,24],[7,15,20,25],
 [7,15,20,26],[7,15,20,27],[7,15,20,34],[7,15,20,39],
 [7,15,20,41],[7,15,20,43],[7,15,20,44],[7,15,20,45],
 [7,15,20,46],[7,15,20,47],[7,15,20,48],[7,15,20,49],
 [7,15,20,52],[7,15,20,53],[7,15,20,55],[7,15,20,57],
 [7,15,20,58],[7,15,20,59],[7,15,20,60],[7,15,20,61],
 [7,15,20,62],[7,15,20,64],[7,15,20,66],[7,15,20,67],
 [7,15,20,68],[7,15,20,69],[7,15,21,22],[7,15,21,23],
 [7,15,21,24],[7,15,21,25],[7,15,21,26],[7,15,21,27],
 [7,15,21,34],[7,15,21,37],[7,15,21,39],[7,15,21,41],
 [7,15,21,43],[7,15,21,44],[7,15,21,45],[7,15,21,46],
 [7,15,21,47],[7,15,21,48],[7,15,21,49],[7,15,21,55],
 [7,15,21,57],[7,15,21,58],[7,15,21,59],[7,15,21,60],
 [7,15,21,61],[7,15,21,62],[7,15,21,66],[7,15,21,67],
 [7,15,21,68],[7,15,21,69],[7,15,22,23],[7,15,22,24],
 [7,15,22,25],[7,15,22,26],[7,15,22,27],[7,15,22,34],
 [7,15,22,37],[7,15,22,39],[7,15,22,41],[7,15,22,43],
 [7,15,22,44],[7,15,22,45],[7,15,22,46],[7,15,22,47],
 [7,15,22,48],[7,15,22,49],[7,15,22,55],[7,15,22,57],
 [7,15,22,58],[7,15,22,59],[7,15,22,60],[7,15,22,61],
 [7,15,22,62],[7,15,22,66],[7,15,22,67],[7,15,22,68],
 [7,15,22,69],[7,15,23,24],[7,15,23,25],[7,15,23,26],
 [7,15,23,27],[7,15,23,34],[7,15,23,37],[7,15,23,39],
 [7,15,23,41],[7,15,23,43],[7,15,23,44],[7,15,23,45],
 [7,15,23,46],[7,15,23,47],[7,15,23,48],[7,15,23,49],
 [7,15,23,52],[7,15,23,53],[7,15,23,55],[7,15,23,57],
 [7,15,23,58],[7,15,23,59],[7,15,23,60],[7,15,23,61],
 [7,15,23,62],[7,15,23,64],[7,15,23,66],[7,15,23,67],
 [7,15,23,68],[7,15,23,69],[7,15,24,25],[7,15,24,26],
 [7,15,24,27],[7,15,24,34],[7,15,24,37],[7,15,24,39],
 [7,15,24,41],[7,15,24,43],[7,15,24,44],[7,15,24,45],
 [7,15,24,46],[7,15,24,47],[7,15,24,48],[7,15,24,49],
 [7,15,24,52],[7,15,24,55],[7,15,24,57],[7,15,24,58],
 [7,15,24,59],[7,15,24,60],[7,15,24,61],[7,15,24,62],
 [7,15,24,66],[7,15,24,67],[7,15,24,68],[7,15,24,69],
 [7,15,25,26],[7,15,25,27],[7,15,25,34],[7,15,25,37],
 [7,15,25,39],[7,15,25,41],[7,15,25,43],[7,15,25,44],
 [7,15,25,45],[7,15,25,46],[7,15,25,47],[7,15,25,48],
 [7,15,25,49],[7,15,25,53],[7,15,25,55],[7,15,25,57],
 [7,15,25,58],[7,15,25,59],[7,15,25,60],[7,15,25,61],
 [7,15,25,62],[7,15,25,66],[7,15,25,67],[7,15,25,68],
 [7,15,25,69],[7,15,26,27],[7,15,26,34],[7,15,26,37],
 [7,15,26,39],[7,15,26,41],[7,15,26,43],[7,15,26,44],
 [7,15,26,45],[7,15,26,46],[7,15,26,47],[7,15,26,48],
 [7,15,26,49],[7,15,26,52],[7,15,26,55],[7,15,26,57],
 [7,15,26,58],[7,15,26,59],[7,15,26,60],[7,15,26,61],
 [7,15,26,62],[7,15,26,64],[7,15,26,66],[7,15,26,67],
 [7,15,26,68],[7,15,26,69],[7,15,27,34],[7,15,27,39],
 [7,15,27,41],[7,15,27,43],[7,15,27,44],[7,15,27,45],
 [7,15,27,46],[7,15,27,47],[7,15,27,48],[7,15,27,49],
 [7,15,27,52],[7,15,27,55],[7,15,27,58],[7,15,27,59],
 [7,15,27,60],[7,15,27,61],[7,15,27,62],[7,15,27,64],
 [7,15,27,66],[7,15,27,67],[7,15,27,68],[7,15,27,69],
 [7,15,34,39],[7,15,34,41],[7,15,34,43],[7,15,34,44],
 [7,15,34,45],[7,15,34,46],[7,15,34,47],[7,15,34,48],
 [7,15,34,49],[7,15,34,55],[7,15,34,58],[7,15,34,59],
 [7,15,34,60],[7,15,34,61],[7,15,34,62],[7,15,34,66],
 [7,15,34,67],[7,15,34,68],[7,15,34,69],[7,15,37,43],
 [7,15,37,44],[7,15,37,46],[7,15,37,47],[7,15,37,48],
 [7,15,37,58],[7,15,37,60],[7,15,37,61],[7,15,37,67],
 [7,15,39,41],[7,15,39,43],[7,15,39,44],[7,15,39,45],
 [7,15,39,46],[7,15,39,47],[7,15,39,48],[7,15,39,49],
 [7,15,39,52],[7,15,39,55],[7,15,39,58],[7,15,39,59],
 [7,15,39,60],[7,15,39,61],[7,15,39,62],[7,15,39,64],
 [7,15,39,66],[7,15,39,67],[7,15,39,68],[7,15,39,69],
 [7,15,41,43],[7,15,41,44],[7,15,41,45],[7,15,41,46],
 [7,15,41,47],[7,15,41,48],[7,15,41,49],[7,15,41,55],
 [7,15,41,58],[7,15,41,59],[7,15,41,60],[7,15,41,61],
 [7,15,41,62],[7,15,41,64],[7,15,41,66],[7,15,41,67],
 [7,15,41,68],[7,15,41,69],[7,15,43,44],[7,15,43,45],
 [7,15,43,46],[7,15,43,47],[7,15,43,48],[7,15,43,49],
 [7,15,43,52],[7,15,43,55],[7,15,43,57],[7,15,43,58],
 [7,15,43,59],[7,15,43,60],[7,15,43,61],[7,15,43,62],
 [7,15,43,66],[7,15,43,67],[7,15,43,68],[7,15,43,69],
 [7,15,44,45],[7,15,44,46],[7,15,44,47],[7,15,44,48],
 [7,15,44,49],[7,15,44,52],[7,15,44,53],[7,15,44,55],
 [7,15,44,57],[7,15,44,58],[7,15,44,59],[7,15,44,60],
 [7,15,44,61],[7,15,44,62],[7,15,44,66],[7,15,44,67],
 [7,15,44,68],[7,15,44,69],[7,15,45,46],[7,15,45,47],
 [7,15,45,48],[7,15,45,49],[7,15,45,52],[7,15,45,55],
 [7,15,45,58],[7,15,45,59],[7,15,45,60],[7,15,45,61],
 [7,15,45,62],[7,15,45,66],[7,15,45,67],[7,15,45,68],
 [7,15,45,69],[7,15,46,47],[7,15,46,48],[7,15,46,49],
 [7,15,46,52],[7,15,46,53],[7,15,46,55],[7,15,46,57],
 [7,15,46,58],[7,15,46,59],[7,15,46,60],[7,15,46,61],
 [7,15,46,62],[7,15,46,66],[7,15,46,67],[7,15,46,68],
 [7,15,46,69],[7,15,47,48],[7,15,47,49],[7,15,47,52],
 [7,15,47,53],[7,15,47,55],[7,15,47,57],[7,15,47,58],
 [7,15,47,59],[7,15,47,60],[7,15,47,61],[7,15,47,62],
 [7,15,47,64],[7,15,47,66],[7,15,47,67],[7,15,47,68],
 [7,15,47,69],[7,15,48,49],[7,15,48,52],[7,15,48,53],
 [7,15,48,55],[7,15,48,57],[7,15,48,58],[7,15,48,59],
 [7,15,48,60],[7,15,48,61],[7,15,48,62],[7,15,48,66],
 [7,15,48,67],[7,15,48,68],[7,15,48,69],[7,15,49,52],
 [7,15,49,53],[7,15,49,55],[7,15,49,58],[7,15,49,59],
 [7,15,49,60],[7,15,49,61],[7,15,49,62],[7,15,49,64],
 [7,15,49,66],[7,15,49,67],[7,15,49,68],[7,15,49,69],
 [7,15,52,53],[7,15,52,62],[7,15,52,67],[7,15,53,67],
 [7,15,55,58],[7,15,55,59],[7,15,55,60],[7,15,55,61],
 [7,15,55,62],[7,15,55,66],[7,15,55,67],[7,15,55,68],
 [7,15,55,69],[7,15,57,60],[7,15,57,61],[7,15,57,67],
 [7,15,58,59],[7,15,58,60],[7,15,58,61],[7,15,58,62],
 [7,15,58,66],[7,15,58,67],[7,15,58,68],[7,15,58,69],
 [7,15,59,60],[7,15,59,61],[7,15,59,62],[7,15,59,66],
 [7,15,59,67],[7,15,59,68],[7,15,59,69],[7,15,60,61],
 [7,15,60,62],[7,15,60,66],[7,15,60,67],[7,15,60,68],
 [7,15,60,69],[7,15,61,62],[7,15,61,66],[7,15,61,67],
 [7,15,61,68],[7,15,61,69],[7,15,62,66],[7,15,62,67],
 [7,15,62,68],[7,15,62,69],[7,15,64,67],[7,15,64,68],
 [7,15,66,67],[7,15,66,68],[7,15,66,69],[7,15,67,68],
 [7,15,67,69],[7,15,68,69],[7,16,19,20],[7,16,19,21],
 [7,16,19,22],[7,16,19,23],[7,16,19,24],[7,16,19,25],
 [7,16,19,26],[7,16,19,27],[7,16,19,34],[7,16,19,35],
 [7,16,19,37],[7,16,19,39],[7,16,19,40],[7,16,19,41],
 [7,16,19,43],[7,16,19,44],[7,16,19,45],[7,16,19,46],
 [7,16,19,47],[7,16,19,48],[7,16,19,49],[7,16,19,55],
 [7,16,19,57],[7,16,19,58],[7,16,19,59],[7,16,19,60],
 [7,16,19,61],[7,16,19,62],[7,16,19,66],[7,16,19,67],
 [7,16,19,68],[7,16,19,69],[7,16,20,21],[7,16,20,22],
 [7,16,20,23],[7,16,20,24],[7,16,20,25],[7,16,20,26],
 [7,16,20,27],[7,16,20,34],[7,16,20,39],[7,16,20,41],
 [7,16,20,43],[7,16,20,44],[7,16,20,45],[7,16,20,46],
 [7,16,20,47],[7,16,20,48],[7,16,20,49],[7,16,20,53],
 [7,16,20,55],[7,16,20,58],[7,16,20,59],[7,16,20,60],
 [7,16,20,61],[7,16,20,62],[7,16,20,66],[7,16,20,67],
 [7,16,20,68],[7,16,20,69],[7,16,21,22],[7,16,21,23],
 [7,16,21,24],[7,16,21,25],[7,16,21,26],[7,16,21,27],
 [7,16,21,34],[7,16,21,35],[7,16,21,37],[7,16,21,39],
 [7,16,21,41],[7,16,21,43],[7,16,21,44],[7,16,21,45],
 [7,16,21,46],[7,16,21,47],[7,16,21,48],[7,16,21,49],
 [7,16,21,50],[7,16,21,51],[7,16,21,52],[7,16,21,53],
 [7,16,21,55],[7,16,21,57],[7,16,21,58],[7,16,21,59],
 [7,16,21,60],[7,16,21,61],[7,16,21,62],[7,16,21,66],
 [7,16,21,67],[7,16,21,68],[7,16,21,69],[7,16,22,23],
 [7,16,22,24],[7,16,22,25],[7,16,22,26],[7,16,22,27],
 [7,16,22,34],[7,16,22,37],[7,16,22,39],[7,16,22,41],
 [7,16,22,43],[7,16,22,44],[7,16,22,45],[7,16,22,46],
 [7,16,22,47],[7,16,22,48],[7,16,22,49],[7,16,22,55],
 [7,16,22,57],[7,16,22,58],[7,16,22,59],[7,16,22,60],
 [7,16,22,61],[7,16,22,62],[7,16,22,66],[7,16,22,67],
 [7,16,22,68],[7,16,22,69],[7,16,23,24],[7,16,23,25],
 [7,16,23,26],[7,16,23,27],[7,16,23,34],[7,16,23,35],
 [7,16,23,37],[7,16,23,39],[7,16,23,40],[7,16,23,41],
 [7,16,23,43],[7,16,23,44],[7,16,23,45],[7,16,23,46],
 [7,16,23,47],[7,16,23,48],[7,16,23,49],[7,16,23,50],
 [7,16,23,51],[7,16,23,52],[7,16,23,53],[7,16,23,55],
 [7,16,23,57],[7,16,23,58],[7,16,23,59],[7,16,23,60],
 [7,16,23,61],[7,16,23,62],[7,16,23,66],[7,16,23,67],
 [7,16,23,68],[7,16,23,69],[7,16,24,25],[7,16,24,26],
 [7,16,24,27],[7,16,24,34],[7,16,24,37],[7,16,24,39],
 [7,16,24,41],[7,16,24,43],[7,16,24,44],[7,16,24,45],
 [7,16,24,46],[7,16,24,47],[7,16,24,48],[7,16,24,49],
 [7,16,24,53],[7,16,24,55],[7,16,24,58],[7,16,24,59],
 [7,16,24,60],[7,16,24,61],[7,16,24,62],[7,16,24,66],
 [7,16,24,67],[7,16,24,68],[7,16,24,69],[7,16,25,26],
 [7,16,25,27],[7,16,25,34],[7,16,25,35],[7,16,25,37],
 [7,16,25,39],[7,16,25,40],[7,16,25,41],[7,16,25,43],
 [7,16,25,44],[7,16,25,45],[7,16,25,46],[7,16,25,47],
 [7,16,25,48],[7,16,25,49],[7,16,25,50],[7,16,25,51],
 [7,16,25,52],[7,16,25,53],[7,16,25,55],[7,16,25,57],
 [7,16,25,58],[7,16,25,59],[7,16,25,60],[7,16,25,61],
 [7,16,25,62],[7,16,25,66],[7,16,25,67],[7,16,25,68],
 [7,16,25,69],[7,16,26,27],[7,16,26,34],[7,16,26,35],
 [7,16,26,37],[7,16,26,39],[7,16,26,40],[7,16,26,41],
 [7,16,26,43],[7,16,26,44],[7,16,26,45],[7,16,26,46],
 [7,16,26,47],[7,16,26,48],[7,16,26,49],[7,16,26,50],
 [7,16,26,51],[7,16,26,52],[7,16,26,53],[7,16,26,55],
 [7,16,26,57],[7,16,26,58],[7,16,26,59],[7,16,26,60],
 [7,16,26,61],[7,16,26,62],[7,16,26,66],[7,16,26,67],
 [7,16,26,68],[7,16,26,69],[7,16,27,34],[7,16,27,35],
 [7,16,27,39],[7,16,27,40],[7,16,27,41],[7,16,27,43],
 [7,16,27,44],[7,16,27,45],[7,16,27,46],[7,16,27,47],
 [7,16,27,48],[7,16,27,49],[7,16,27,52],[7,16,27,53],
 [7,16,27,55],[7,16,27,58],[7,16,27,59],[7,16,27,60],
 [7,16,27,61],[7,16,27,62],[7,16,27,66],[7,16,27,67],
 [7,16,27,68],[7,16,27,69],[7,16,34,39],[7,16,34,41],
 [7,16,34,43],[7,16,34,44],[7,16,34,45],[7,16,34,46],
 [7,16,34,47],[7,16,34,48],[7,16,34,49],[7,16,34,55],
 [7,16,34,58],[7,16,34,59],[7,16,34,60],[7,16,34,61],
 [7,16,34,62],[7,16,34,66],[7,16,34,67],[7,16,34,68],
 [7,16,34,69],[7,16,35,37],[7,16,35,41],[7,16,35,45],
 [7,16,35,47],[7,16,35,48],[7,16,35,59],[7,16,35,62],
 [7,16,35,67],[7,16,35,68],[7,16,37,40],[7,16,37,43],
 [7,16,37,45],[7,16,37,47],[7,16,37,48],[7,16,37,60],
 [7,16,37,62],[7,16,37,67],[7,16,39,41],[7,16,39,43],
 [7,16,39,44],[7,16,39,45],[7,16,39,46],[7,16,39,47],
 [7,16,39,48],[7,16,39,49],[7,16,39,52],[7,16,39,53],
 [7,16,39,55],[7,16,39,58],[7,16,39,59],[7,16,39,60],
 [7,16,39,61],[7,16,39,62],[7,16,39,66],[7,16,39,67],
 [7,16,39,68],[7,16,39,69],[7,16,40,45],[7,16,40,47],
 [7,16,40,48],[7,16,40,49],[7,16,40,53],[7,16,40,55],
 [7,16,40,58],[7,16,40,66],[7,16,40,67],[7,16,40,69],
 [7,16,41,43],[7,16,41,44],[7,16,41,45],[7,16,41,46],
 [7,16,41,47],[7,16,41,48],[7,16,41,49],[7,16,41,55],
 [7,16,41,58],[7,16,41,59],[7,16,41,60],[7,16,41,61],
 [7,16,41,62],[7,16,41,66],[7,16,41,67],[7,16,41,68],
 [7,16,41,69],[7,16,43,44],[7,16,43,45],[7,16,43,46],
 [7,16,43,47],[7,16,43,48],[7,16,43,49],[7,16,43,53],
 [7,16,43,55],[7,16,43,57],[7,16,43,58],[7,16,43,59],
 [7,16,43,60],[7,16,43,61],[7,16,43,62],[7,16,43,66],
 [7,16,43,67],[7,16,43,68],[7,16,43,69],[7,16,44,45],
 [7,16,44,46],[7,16,44,47],[7,16,44,48],[7,16,44,49],
 [7,16,44,50],[7,16,44,52],[7,16,44,55],[7,16,44,58],
 [7,16,44,59],[7,16,44,60],[7,16,44,61],[7,16,44,62],
 [7,16,44,66],[7,16,44,67],[7,16,44,68],[7,16,44,69],
 [7,16,45,46],[7,16,45,47],[7,16,45,48],[7,16,45,49],
 [7,16,45,50],[7,16,45,51],[7,16,45,52],[7,16,45,53],
 [7,16,45,55],[7,16,45,57],[7,16,45,58],[7,16,45,59],
 [7,16,45,60],[7,16,45,61],[7,16,45,62],[7,16,45,66],
 [7,16,45,67],[7,16,45,68],[7,16,45,69],[7,16,46,47],
 [7,16,46,48],[7,16,46,49],[7,16,46,52],[7,16,46,55],
 [7,16,46,57],[7,16,46,58],[7,16,46,59],[7,16,46,60],
 [7,16,46,61],[7,16,46,62],[7,16,46,66],[7,16,46,67],
 [7,16,46,68],[7,16,46,69],[7,16,47,48],[7,16,47,49],
 [7,16,47,50],[7,16,47,51],[7,16,47,52],[7,16,47,53],
 [7,16,47,55],[7,16,47,57],[7,16,47,58],[7,16,47,59],
 [7,16,47,60],[7,16,47,61],[7,16,47,62],[7,16,47,66],
 [7,16,47,67],[7,16,47,68],[7,16,47,69],[7,16,48,49],
 [7,16,48,50],[7,16,48,51],[7,16,48,52],[7,16,48,53],
 [7,16,48,55],[7,16,48,57],[7,16,48,58],[7,16,48,59],
 [7,16,48,60],[7,16,48,61],[7,16,48,62],[7,16,48,66],
 [7,16,48,67],[7,16,48,68],[7,16,48,69],[7,16,49,52],
 [7,16,49,55],[7,16,49,58],[7,16,49,59],[7,16,49,60],
 [7,16,49,61],[7,16,49,62],[7,16,49,66],[7,16,49,67],
 [7,16,49,68],[7,16,49,69],[7,16,50,51],[7,16,50,52],
 [7,16,50,53],[7,16,50,59],[7,16,50,61],[7,16,50,62],
 [7,16,50,67],[7,16,50,68],[7,16,50,69],[7,16,51,52],
 [7,16,51,53],[7,16,51,55],[7,16,51,58],[7,16,51,59],
 [7,16,51,60],[7,16,51,61],[7,16,51,62],[7,16,51,67],
 [7,16,51,68],[7,16,52,53],[7,16,52,62],[7,16,52,67],
 [7,16,53,62],[7,16,53,67],[7,16,55,58],[7,16,55,59],
 [7,16,55,60],[7,16,55,61],[7,16,55,62],[7,16,55,66],
 [7,16,55,67],[7,16,55,68],[7,16,55,69],[7,16,57,58],
 [7,16,57,60],[7,16,57,67],[7,16,58,59],[7,16,58,60],
 [7,16,58,61],[7,16,58,62],[7,16,58,66],[7,16,58,67],
 [7,16,58,68],[7,16,58,69],[7,16,59,60],[7,16,59,61],
 [7,16,59,62],[7,16,59,66],[7,16,59,67],[7,16,59,68],
 [7,16,59,69],[7,16,60,61],[7,16,60,62],[7,16,60,66],
 [7,16,60,67],[7,16,60,68],[7,16,60,69],[7,16,61,62],
 [7,16,61,66],[7,16,61,67],[7,16,61,68],[7,16,61,69],
 [7,16,62,66],[7,16,62,67],[7,16,62,68],[7,16,62,69],
 [7,16,66,67],[7,16,66,68],[7,16,66,69],[7,16,67,68],
 [7,16,67,69],[7,16,68,69],[7,18,19,20],[7,18,19,21],
 [7,18,19,23],[7,18,19,24],[7,18,19,25],[7,18,19,35],
 [7,18,19,39],[7,18,19,41],[7,18,19,43],[7,18,19,46],
 [7,18,19,47],[7,18,19,48],[7,18,19,55],[7,18,19,60],
 [7,18,19,61],[7,18,19,66],[7,18,19,67],[7,18,20,23],
 [7,18,20,24],[7,18,20,25],[7,18,20,26],[7,18,20,39],
 [7,18,20,41],[7,18,20,43],[7,18,20,46],[7,18,20,47],
 [7,18,20,53],[7,18,20,55],[7,18,20,57],[7,18,20,60],
 [7,18,20,61],[7,18,20,66],[7,18,20,67],[7,18,21,23],
 [7,18,21,24],[7,18,21,25],[7,18,21,26],[7,18,21,35],
 [7,18,21,39],[7,18,21,43],[7,18,21,46],[7,18,21,47],
 [7,18,21,48],[7,18,21,51],[7,18,21,52],[7,18,21,53],
 [7,18,21,55],[7,18,21,57],[7,18,21,60],[7,18,21,66],
 [7,18,21,67],[7,18,23,24],[7,18,23,25],[7,18,23,26],
 [7,18,23,30],[7,18,23,35],[7,18,23,39],[7,18,23,41],
 [7,18,23,43],[7,18,23,46],[7,18,23,47],[7,18,23,48],
 [7,18,23,50],[7,18,23,51],[7,18,23,52],[7,18,23,53],
 [7,18,23,55],[7,18,23,57],[7,18,23,60],[7,18,23,61],
 [7,18,23,66],[7,18,23,67],[7,18,24,25],[7,18,24,26],
 [7,18,24,41],[7,18,24,46],[7,18,24,47],[7,18,24,48],
 [7,18,24,52],[7,18,24,53],[7,18,24,55],[7,18,24,57],
 [7,18,24,60],[7,18,24,61],[7,18,24,66],[7,18,24,67],
 [7,18,25,26],[7,18,25,35],[7,18,25,39],[7,18,25,41],
 [7,18,25,43],[7,18,25,46],[7,18,25,47],[7,18,25,48],
 [7,18,25,50],[7,18,25,51],[7,18,25,52],[7,18,25,53],
 [7,18,25,55],[7,18,25,57],[7,18,25,60],[7,18,25,61],
 [7,18,25,66],[7,18,25,67],[7,18,26,35],[7,18,26,39],
 [7,18,26,41],[7,18,26,43],[7,18,26,46],[7,18,26,47],
 [7,18,26,48],[7,18,26,50],[7,18,26,51],[7,18,26,52],
 [7,18,26,53],[7,18,26,55],[7,18,26,57],[7,18,26,60],
 [7,18,26,61],[7,18,26,66],[7,18,26,67],[7,18,30,67],
 [7,18,35,41],[7,18,35,47],[7,18,35,48],[7,18,35,67],
 [7,18,39,41],[7,18,39,43],[7,18,39,46],[7,18,39,47],
 [7,18,39,48],[7,18,39,52],[7,18,39,53],[7,18,39,55],
 [7,18,39,60],[7,18,39,61],[7,18,39,66],[7,18,39,67],
 [7,18,41,47],[7,18,41,48],[7,18,41,55],[7,18,41,61],
 [7,18,41,67],[7,18,43,46],[7,18,43,47],[7,18,43,48],
 [7,18,43,55],[7,18,43,57],[7,18,43,60],[7,18,43,61],
 [7,18,43,67],[7,18,46,47],[7,18,46,48],[7,18,46,52],
 [7,18,46,53],[7,18,46,55],[7,18,46,57],[7,18,46,60],
 [7,18,46,61],[7,18,46,66],[7,18,46,67],[7,18,47,48],
 [7,18,47,50],[7,18,47,51],[7,18,47,52],[7,18,47,53],
 [7,18,47,55],[7,18,47,57],[7,18,47,60],[7,18,47,61],
 [7,18,47,66],[7,18,47,67],[7,18,48,50],[7,18,48,51],
 [7,18,48,52],[7,18,48,53],[7,18,48,55],[7,18,48,57],
 [7,18,48,60],[7,18,48,61],[7,18,48,66],[7,18,48,67],
 [7,18,50,51],[7,18,50,52],[7,18,50,53],[7,18,50,55],
 [7,18,50,60],[7,18,50,61],[7,18,50,67],[7,18,51,52],
 [7,18,51,53],[7,18,51,55],[7,18,51,60],[7,18,51,61],
 [7,18,51,67],[7,18,52,53],[7,18,52,67],[7,18,53,67],
 [7,18,55,60],[7,18,55,66],[7,18,55,67],[7,18,57,60],
 [7,18,57,61],[7,18,57,67],[7,18,60,61],[7,18,60,66],
 [7,18,60,67],[7,18,61,67],[7,18,66,67],[7,19,20,21],
 [7,19,20,22],[7,19,20,23],[7,19,20,24],[7,19,20,25],
 [7,19,20,26],[7,19,20,27],[7,19,20,34],[7,19,20,39],
 [7,19,20,41],[7,19,20,43],[7,19,20,44],[7,19,20,45],
 [7,19,20,46],[7,19,20,47],[7,19,20,48],[7,19,20,49],
 [7,19,20,55],[7,19,20,58],[7,19,20,59],[7,19,20,60],
 [7,19,20,61],[7,19,20,62],[7,19,20,64],[7,19,20,66],
 [7,19,20,67],[7,19,20,68],[7,19,20,69],[7,19,21,22],
 [7,19,21,23],[7,19,21,24],[7,19,21,25],[7,19,21,26],
 [7,19,21,27],[7,19,21,31],[7,19,21,34],[7,19,21,37],
 [7,19,21,39],[7,19,21,41],[7,19,21,43],[7,19,21,44],
 [7,19,21,45],[7,19,21,46],[7,19,21,47],[7,19,21,48],
 [7,19,21,49],[7,19,21,55],[7,19,21,57],[7,19,21,58],
 [7,19,21,59],[7,19,21,60],[7,19,21,61],[7,19,21,62],
 [7,19,21,64],[7,19,21,66],[7,19,21,67],[7,19,21,68],
 [7,19,21,69],[7,19,22,23],[7,19,22,24],[7,19,22,25],
 [7,19,22,26],[7,19,22,27],[7,19,22,34],[7,19,22,37],
 [7,19,22,39],[7,19,22,41],[7,19,22,43],[7,19,22,44],
 [7,19,22,45],[7,19,22,46],[7,19,22,47],[7,19,22,48],
 [7,19,22,49],[7,19,22,55],[7,19,22,57],[7,19,22,58],
 [7,19,22,59],[7,19,22,60],[7,19,22,61],[7,19,22,62],
 [7,19,22,66],[7,19,22,67],[7,19,22,68],[7,19,22,69],
 [7,19,23,24],[7,19,23,25],[7,19,23,26],[7,19,23,27],
 [7,19,23,31],[7,19,23,34],[7,19,23,35],[7,19,23,37],
 [7,19,23,39],[7,19,23,40],[7,19,23,41],[7,19,23,43],
 [7,19,23,44],[7,19,23,45],[7,19,23,46],[7,19,23,47],
 [7,19,23,48],[7,19,23,49],[7,19,23,55],[7,19,23,57],
 [7,19,23,58],[7,19,23,59],[7,19,23,60],[7,19,23,61],
 [7,19,23,62],[7,19,23,64],[7,19,23,66],[7,19,23,67],
 [7,19,23,68],[7,19,23,69],[7,19,24,25],[7,19,24,26],
 [7,19,24,27],[7,19,24,34],[7,19,24,37],[7,19,24,39],
 [7,19,24,41],[7,19,24,43],[7,19,24,44],[7,19,24,45],
 [7,19,24,46],[7,19,24,47],[7,19,24,48],[7,19,24,49],
 [7,19,24,55],[7,19,24,57],[7,19,24,58],[7,19,24,59],
 [7,19,24,60],[7,19,24,61],[7,19,24,62],[7,19,24,66],
 [7,19,24,67],[7,19,24,68],[7,19,24,69],[7,19,25,26],
 [7,19,25,27],[7,19,25,31],[7,19,25,34],[7,19,25,35],
 [7,19,25,37],[7,19,25,39],[7,19,25,40],[7,19,25,41],
 [7,19,25,43],[7,19,25,44],[7,19,25,45],[7,19,25,46],
 [7,19,25,47],[7,19,25,48],[7,19,25,49],[7,19,25,55],
 [7,19,25,57],[7,19,25,58],[7,19,25,59],[7,19,25,60],
 [7,19,25,61],[7,19,25,62],[7,19,25,64],[7,19,25,66],
 [7,19,25,67],[7,19,25,68],[7,19,25,69],[7,19,26,27],
 [7,19,26,31],[7,19,26,34],[7,19,26,35],[7,19,26,37],
 [7,19,26,39],[7,19,26,40],[7,19,26,41],[7,19,26,43],
 [7,19,26,44],[7,19,26,45],[7,19,26,46],[7,19,26,47],
 [7,19,26,48],[7,19,26,49],[7,19,26,55],[7,19,26,58],
 [7,19,26,59],[7,19,26,60],[7,19,26,61],[7,19,26,62],
 [7,19,26,64],[7,19,26,66],[7,19,26,67],[7,19,26,68],
 [7,19,26,69],[7,19,27,31],[7,19,27,34],[7,19,27,35],
 [7,19,27,39],[7,19,27,40],[7,19,27,41],[7,19,27,43],
 [7,19,27,44],[7,19,27,45],[7,19,27,46],[7,19,27,47],
 [7,19,27,48],[7,19,27,49],[7,19,27,55],[7,19,27,58],
 [7,19,27,59],[7,19,27,60],[7,19,27,61],[7,19,27,62],
 [7,19,27,64],[7,19,27,66],[7,19,27,67],[7,19,27,68],
 [7,19,27,69],[7,19,31,37],[7,19,31,41],[7,19,31,44],
 [7,19,31,48],[7,19,31,55],[7,19,31,59],[7,19,31,67],
 [7,19,31,68],[7,19,31,69],[7,19,34,39],[7,19,34,41],
 [7,19,34,43],[7,19,34,44],[7,19,34,45],[7,19,34,46],
 [7,19,34,47],[7,19,34,48],[7,19,34,49],[7,19,34,55],
 [7,19,34,58],[7,19,34,59],[7,19,34,60],[7,19,34,61],
 [7,19,34,62],[7,19,34,66],[7,19,34,67],[7,19,34,68],
 [7,19,34,69],[7,19,35,37],[7,19,35,41],[7,19,35,45],
 [7,19,35,47],[7,19,35,49],[7,19,35,55],[7,19,35,57],
 [7,19,35,58],[7,19,35,59],[7,19,35,62],[7,19,35,66],
 [7,19,35,67],[7,19,35,68],[7,19,35,69],[7,19,37,40],
 [7,19,37,44],[7,19,37,45],[7,19,37,46],[7,19,37,47],
 [7,19,37,48],[7,19,37,58],[7,19,37,60],[7,19,37,61],
 [7,19,37,62],[7,19,37,64],[7,19,37,67],[7,19,39,41],
 [7,19,39,43],[7,19,39,44],[7,19,39,45],[7,19,39,46],
 [7,19,39,47],[7,19,39,48],[7,19,39,49],[7,19,39,55],
 [7,19,39,58],[7,19,39,59],[7,19,39,60],[7,19,39,61],
 [7,19,39,62],[7,19,39,64],[7,19,39,66],[7,19,39,67],
 [7,19,39,68],[7,19,39,69],[7,19,40,41],[7,19,40,45],
 [7,19,40,48],[7,19,40,49],[7,19,40,55],[7,19,40,59],
 [7,19,40,64],[7,19,40,66],[7,19,40,67],[7,19,40,69],
 [7,19,41,43],[7,19,41,44],[7,19,41,45],[7,19,41,46],
 [7,19,41,47],[7,19,41,48],[7,19,41,49],[7,19,41,55],
 [7,19,41,58],[7,19,41,59],[7,19,41,60],[7,19,41,61],
 [7,19,41,62],[7,19,41,64],[7,19,41,66],[7,19,41,67],
 [7,19,41,68],[7,19,41,69],[7,19,43,44],[7,19,43,45],
 [7,19,43,46],[7,19,43,47],[7,19,43,48],[7,19,43,49],
 [7,19,43,55],[7,19,43,58],[7,19,43,59],[7,19,43,60],
 [7,19,43,61],[7,19,43,62],[7,19,43,64],[7,19,43,66],
 [7,19,43,67],[7,19,43,68],[7,19,43,69],[7,19,44,45],
 [7,19,44,46],[7,19,44,47],[7,19,44,48],[7,19,44,49],
 [7,19,44,55],[7,19,44,57],[7,19,44,58],[7,19,44,59],
 [7,19,44,60],[7,19,44,61],[7,19,44,62],[7,19,44,66],
 [7,19,44,67],[7,19,44,68],[7,19,44,69],[7,19,45,46],
 [7,19,45,47],[7,19,45,48],[7,19,45,49],[7,19,45,55],
 [7,19,45,57],[7,19,45,58],[7,19,45,59],[7,19,45,60],
 [7,19,45,61],[7,19,45,62],[7,19,45,66],[7,19,45,67],
 [7,19,45,68],[7,19,45,69],[7,19,46,47],[7,19,46,48],
 [7,19,46,49],[7,19,46,55],[7,19,46,57],[7,19,46,58],
 [7,19,46,59],[7,19,46,60],[7,19,46,61],[7,19,46,62],
 [7,19,46,66],[7,19,46,67],[7,19,46,68],[7,19,46,69],
 [7,19,47,48],[7,19,47,49],[7,19,47,55],[7,19,47,57],
 [7,19,47,58],[7,19,47,59],[7,19,47,60],[7,19,47,61],
 [7,19,47,62],[7,19,47,66],[7,19,47,67],[7,19,47,68],
 [7,19,47,69],[7,19,48,49],[7,19,48,55],[7,19,48,57],
 [7,19,48,58],[7,19,48,59],[7,19,48,60],[7,19,48,61],
 [7,19,48,62],[7,19,48,64],[7,19,48,66],[7,19,48,67],
 [7,19,48,68],[7,19,48,69],[7,19,49,55],[7,19,49,58],
 [7,19,49,59],[7,19,49,60],[7,19,49,61],[7,19,49,62],
 [7,19,49,66],[7,19,49,67],[7,19,49,68],[7,19,49,69],
 [7,19,55,58],[7,19,55,59],[7,19,55,60],[7,19,55,61],
 [7,19,55,62],[7,19,55,66],[7,19,55,67],[7,19,55,68],
 [7,19,55,69],[7,19,57,58],[7,19,57,60],[7,19,57,61],
 [7,19,57,67],[7,19,58,59],[7,19,58,60],[7,19,58,61],
 [7,19,58,62],[7,19,58,66],[7,19,58,67],[7,19,58,68],
 [7,19,58,69],[7,19,59,60],[7,19,59,61],[7,19,59,62],
 [7,19,59,66],[7,19,59,67],[7,19,59,68],[7,19,59,69],
 [7,19,60,61],[7,19,60,62],[7,19,60,66],[7,19,60,67],
 [7,19,60,68],[7,19,60,69],[7,19,61,62],[7,19,61,66],
 [7,19,61,67],[7,19,61,68],[7,19,61,69],[7,19,62,66],
 [7,19,62,67],[7,19,62,68],[7,19,62,69],[7,19,64,66],
 [7,19,64,67],[7,19,64,68],[7,19,64,69],[7,19,66,67],
 [7,19,66,68],[7,19,66,69],[7,19,67,68],[7,19,67,69],
 [7,19,68,69],[7,20,21,22],[7,20,21,23],[7,20,21,24],
 [7,20,21,25],[7,20,21,26],[7,20,21,27],[7,20,21,34],
 [7,20,21,39],[7,20,21,41],[7,20,21,43],[7,20,21,44],
 [7,20,21,45],[7,20,21,46],[7,20,21,47],[7,20,21,48],
 [7,20,21,49],[7,20,21,53],[7,20,21,55],[7,20,21,57],
 [7,20,21,58],[7,20,21,59],[7,20,21,60],[7,20,21,61],
 [7,20,21,62],[7,20,21,66],[7,20,21,67],[7,20,21,68],
 [7,20,21,69],[7,20,22,23],[7,20,22,24],[7,20,22,25],
 [7,20,22,26],[7,20,22,27],[7,20,22,34],[7,20,22,39],
 [7,20,22,41],[7,20,22,43],[7,20,22,44],[7,20,22,45],
 [7,20,22,46],[7,20,22,47],[7,20,22,48],[7,20,22,49],
 [7,20,22,55],[7,20,22,57],[7,20,22,58],[7,20,22,59],
 [7,20,22,60],[7,20,22,61],[7,20,22,62],[7,20,22,66],
 [7,20,22,67],[7,20,22,68],[7,20,22,69],[7,20,23,24],
 [7,20,23,25],[7,20,23,26],[7,20,23,27],[7,20,23,34],
 [7,20,23,39],[7,20,23,41],[7,20,23,43],[7,20,23,44],
 [7,20,23,45],[7,20,23,46],[7,20,23,47],[7,20,23,48],
 [7,20,23,49],[7,20,23,52],[7,20,23,53],[7,20,23,55],
 [7,20,23,57],[7,20,23,58],[7,20,23,59],[7,20,23,60],
 [7,20,23,61],[7,20,23,62],[7,20,23,64],[7,20,23,66],
 [7,20,23,67],[7,20,23,68],[7,20,23,69],[7,20,24,25],
 [7,20,24,26],[7,20,24,27],[7,20,24,34],[7,20,24,39],
 [7,20,24,41],[7,20,24,43],[7,20,24,44],[7,20,24,45],
 [7,20,24,46],[7,20,24,47],[7,20,24,48],[7,20,24,49],
 [7,20,24,52],[7,20,24,53],[7,20,24,55],[7,20,24,57],
 [7,20,24,58],[7,20,24,59],[7,20,24,60],[7,20,24,61],
 [7,20,24,62],[7,20,24,66],[7,20,24,67],[7,20,24,68],
 [7,20,24,69],[7,20,25,26],[7,20,25,27],[7,20,25,34],
 [7,20,25,39],[7,20,25,41],[7,20,25,43],[7,20,25,44],
 [7,20,25,45],[7,20,25,46],[7,20,25,47],[7,20,25,48],
 [7,20,25,49],[7,20,25,53],[7,20,25,55],[7,20,25,58],
 [7,20,25,59],[7,20,25,60],[7,20,25,61],[7,20,25,62],
 [7,20,25,66],[7,20,25,67],[7,20,25,68],[7,20,25,69],
 [7,20,26,27],[7,20,26,34],[7,20,26,39],[7,20,26,41],
 [7,20,26,43],[7,20,26,44],[7,20,26,45],[7,20,26,46],
 [7,20,26,47],[7,20,26,48],[7,20,26,49],[7,20,26,52],
 [7,20,26,55],[7,20,26,57],[7,20,26,58],[7,20,26,59],
 [7,20,26,60],[7,20,26,61],[7,20,26,62],[7,20,26,64],
 [7,20,26,66],[7,20,26,67],[7,20,26,68],[7,20,26,69],
 [7,20,27,34],[7,20,27,39],[7,20,27,41],[7,20,27,43],
 [7,20,27,44],[7,20,27,45],[7,20,27,46],[7,20,27,47],
 [7,20,27,48],[7,20,27,49],[7,20,27,52],[7,20,27,53],
 [7,20,27,55],[7,20,27,58],[7,20,27,59],[7,20,27,60],
 [7,20,27,61],[7,20,27,62],[7,20,27,64],[7,20,27,66],
 [7,20,27,67],[7,20,27,68],[7,20,27,69],[7,20,34,39],
 [7,20,34,41],[7,20,34,43],[7,20,34,44],[7,20,34,45],
 [7,20,34,46],[7,20,34,47],[7,20,34,48],[7,20,34,49],
 [7,20,34,55],[7,20,34,58],[7,20,34,59],[7,20,34,60],
 [7,20,34,61],[7,20,34,62],[7,20,34,66],[7,20,34,67],
 [7,20,34,68],[7,20,34,69],[7,20,39,41],[7,20,39,43],
 [7,20,39,44],[7,20,39,45],[7,20,39,46],[7,20,39,47],
 [7,20,39,48],[7,20,39,49],[7,20,39,52],[7,20,39,55],
 [7,20,39,58],[7,20,39,59],[7,20,39,60],[7,20,39,61],
 [7,20,39,62],[7,20,39,64],[7,20,39,66],[7,20,39,67],
 [7,20,39,68],[7,20,39,69],[7,20,41,43],[7,20,41,44],
 [7,20,41,45],[7,20,41,46],[7,20,41,47],[7,20,41,48],
 [7,20,41,49],[7,20,41,55],[7,20,41,58],[7,20,41,59],
 [7,20,41,60],[7,20,41,61],[7,20,41,62],[7,20,41,64],
 [7,20,41,66],[7,20,41,67],[7,20,41,68],[7,20,41,69],
 [7,20,43,44],[7,20,43,45],[7,20,43,46],[7,20,43,47],
 [7,20,43,48],[7,20,43,49],[7,20,43,52],[7,20,43,55],
 [7,20,43,58],[7,20,43,59],[7,20,43,60],[7,20,43,61],
 [7,20,43,62],[7,20,43,64],[7,20,43,66],[7,20,43,67],
 [7,20,43,68],[7,20,43,69],[7,20,44,45],[7,20,44,46],
 [7,20,44,47],[7,20,44,48],[7,20,44,49],[7,20,44,52],
 [7,20,44,53],[7,20,44,55],[7,20,44,57],[7,20,44,58],
 [7,20,44,59],[7,20,44,60],[7,20,44,61],[7,20,44,62],
 [7,20,44,66],[7,20,44,67],[7,20,44,68],[7,20,44,69],
 [7,20,45,46],[7,20,45,47],[7,20,45,48],[7,20,45,49],
 [7,20,45,52],[7,20,45,53],[7,20,45,55],[7,20,45,57],
 [7,20,45,58],[7,20,45,59],[7,20,45,60],[7,20,45,61],
 [7,20,45,62],[7,20,45,66],[7,20,45,67],[7,20,45,68],
 [7,20,45,69],[7,20,46,47],[7,20,46,48],[7,20,46,49],
 [7,20,46,52],[7,20,46,53],[7,20,46,55],[7,20,46,57],
 [7,20,46,58],[7,20,46,59],[7,20,46,60],[7,20,46,61],
 [7,20,46,62],[7,20,46,66],[7,20,46,67],[7,20,46,68],
 [7,20,46,69],[7,20,47,48],[7,20,47,49],[7,20,47,53],
 [7,20,47,55],[7,20,47,57],[7,20,47,58],[7,20,47,59],
 [7,20,47,60],[7,20,47,61],[7,20,47,62],[7,20,47,64],
 [7,20,47,66],[7,20,47,67],[7,20,47,68],[7,20,47,69],
 [7,20,48,49],[7,20,48,52],[7,20,48,55],[7,20,48,58],
 [7,20,48,59],[7,20,48,60],[7,20,48,61],[7,20,48,62],
 [7,20,48,64],[7,20,48,66],[7,20,48,67],[7,20,48,68],
 [7,20,48,69],[7,20,49,53],[7,20,49,55],[7,20,49,58],
 [7,20,49,59],[7,20,49,60],[7,20,49,61],[7,20,49,62],
 [7,20,49,64],[7,20,49,66],[7,20,49,67],[7,20,49,68],
 [7,20,49,69],[7,20,52,53],[7,20,52,62],[7,20,52,67],
 [7,20,53,62],[7,20,53,67],[7,20,55,58],[7,20,55,59],
 [7,20,55,60],[7,20,55,61],[7,20,55,62],[7,20,55,66],
 [7,20,55,67],[7,20,55,68],[7,20,55,69],[7,20,57,58],
 [7,20,57,60],[7,20,57,61],[7,20,57,67],[7,20,58,59],
 [7,20,58,60],[7,20,58,61],[7,20,58,62],[7,20,58,66],
 [7,20,58,67],[7,20,58,68],[7,20,58,69],[7,20,59,60],
 [7,20,59,61],[7,20,59,62],[7,20,59,66],[7,20,59,67],
 [7,20,59,68],[7,20,59,69],[7,20,60,61],[7,20,60,62],
 [7,20,60,66],[7,20,60,67],[7,20,60,68],[7,20,60,69],
 [7,20,61,62],[7,20,61,66],[7,20,61,67],[7,20,61,68],
 [7,20,61,69],[7,20,62,66],[7,20,62,67],[7,20,62,68],
 [7,20,62,69],[7,20,64,66],[7,20,64,67],[7,20,64,68],
 [7,20,64,69],[7,20,66,67],[7,20,66,68],[7,20,66,69],
 [7,20,67,68],[7,20,67,69],[7,20,68,69],[7,21,22,23],
 [7,21,22,24],[7,21,22,25],[7,21,22,26],[7,21,22,27],
 [7,21,22,34],[7,21,22,39],[7,21,22,41],[7,21,22,43],
 [7,21,22,44],[7,21,22,45],[7,21,22,46],[7,21,22,47],
 [7,21,22,48],[7,21,22,49],[7,21,22,55],[7,21,22,58],
 [7,21,22,59],[7,21,22,60],[7,21,22,61],[7,21,22,62],
 [7,21,22,66],[7,21,22,67],[7,21,22,68],[7,21,22,69],
 [7,21,23,24],[7,21,23,25],[7,21,23,26],[7,21,23,27],
 [7,21,23,31],[7,21,23,34],[7,21,23,35],[7,21,23,37],
 [7,21,23,39],[7,21,23,41],[7,21,23,43],[7,21,23,44],
 [7,21,23,45],[7,21,23,46],[7,21,23,47],[7,21,23,48],
 [7,21,23,49],[7,21,23,50],[7,21,23,51],[7,21,23,52],
 [7,21,23,53],[7,21,23,55],[7,21,23,57],[7,21,23,58],
 [7,21,23,59],[7,21,23,60],[7,21,23,61],[7,21,23,62],
 [7,21,23,64],[7,21,23,66],[7,21,23,67],[7,21,23,68],
 [7,21,23,69],[7,21,24,25],[7,21,24,26],[7,21,24,27],
 [7,21,24,34],[7,21,24,37],[7,21,24,39],[7,21,24,41],
 [7,21,24,43],[7,21,24,44],[7,21,24,45],[7,21,24,46],
 [7,21,24,47],[7,21,24,48],[7,21,24,49],[7,21,24,53],
 [7,21,24,55],[7,21,24,57],[7,21,24,58],[7,21,24,59],
 [7,21,24,60],[7,21,24,61],[7,21,24,62],[7,21,24,66],
 [7,21,24,67],[7,21,24,68],[7,21,24,69],[7,21,25,26],
 [7,21,25,27],[7,21,25,31],[7,21,25,34],[7,21,25,35],
 [7,21,25,37],[7,21,25,39],[7,21,25,41],[7,21,25,43],
 [7,21,25,44],[7,21,25,45],[7,21,25,46],[7,21,25,47],
 [7,21,25,48],[7,21,25,49],[7,21,25,50],[7,21,25,51],
 [7,21,25,52],[7,21,25,53],[7,21,25,55],[7,21,25,57],
 [7,21,25,58],[7,21,25,59],[7,21,25,60],[7,21,25,61],
 [7,21,25,62],[7,21,25,64],[7,21,25,66],[7,21,25,67],
 [7,21,25,68],[7,21,25,69],[7,21,26,27],[7,21,26,31],
 [7,21,26,34],[7,21,26,35],[7,21,26,37],[7,21,26,39],
 [7,21,26,41],[7,21,26,43],[7,21,26,44],[7,21,26,45],
 [7,21,26,46],[7,21,26,47],[7,21,26,48],[7,21,26,49],
 [7,21,26,50],[7,21,26,51],[7,21,26,52],[7,21,26,53],
 [7,21,26,55],[7,21,26,57],[7,21,26,58],[7,21,26,59],
 [7,21,26,60],[7,21,26,61],[7,21,26,62],[7,21,26,64],
 [7,21,26,66],[7,21,26,67],[7,21,26,68],[7,21,26,69],
 [7,21,27,34],[7,21,27,35],[7,21,27,39],[7,21,27,41],
 [7,21,27,43],[7,21,27,44],[7,21,27,45],[7,21,27,46],
 [7,21,27,47],[7,21,27,48],[7,21,27,49],[7,21,27,53],
 [7,21,27,55],[7,21,27,58],[7,21,27,59],[7,21,27,60],
 [7,21,27,61],[7,21,27,62],[7,21,27,66],[7,21,27,67],
 [7,21,27,68],[7,21,27,69],[7,21,31,37],[7,21,31,44],
 [7,21,31,47],[7,21,31,48],[7,21,31,49],[7,21,31,55],
 [7,21,31,59],[7,21,31,67],[7,21,31,69],[7,21,34,39],
 [7,21,34,41],[7,21,34,43],[7,21,34,44],[7,21,34,45],
 [7,21,34,46],[7,21,34,47],[7,21,34,48],[7,21,34,49],
 [7,21,34,55],[7,21,34,58],[7,21,34,59],[7,21,34,60],
 [7,21,34,61],[7,21,34,62],[7,21,34,66],[7,21,34,67],
 [7,21,34,68],[7,21,34,69],[7,21,35,37],[7,21,35,45],
 [7,21,35,47],[7,21,35,48],[7,21,35,49],[7,21,35,55],
 [7,21,35,57],[7,21,35,58],[7,21,35,59],[7,21,35,62],
 [7,21,35,66],[7,21,35,67],[7,21,35,68],[7,21,37,43],
 [7,21,37,44],[7,21,37,45],[7,21,37,46],[7,21,37,47],
 [7,21,37,48],[7,21,37,58],[7,21,37,60],[7,21,37,61],
 [7,21,37,62],[7,21,37,67],[7,21,39,41],[7,21,39,43],
 [7,21,39,44],[7,21,39,45],[7,21,39,46],[7,21,39,47],
 [7,21,39,48],[7,21,39,49],[7,21,39,52],[7,21,39,53],
 [7,21,39,55],[7,21,39,58],[7,21,39,59],[7,21,39,60],
 [7,21,39,61],[7,21,39,62],[7,21,39,64],[7,21,39,66],
 [7,21,39,67],[7,21,39,68],[7,21,39,69],[7,21,41,43],
 [7,21,41,44],[7,21,41,45],[7,21,41,46],[7,21,41,47],
 [7,21,41,48],[7,21,41,49],[7,21,41,55],[7,21,41,58],
 [7,21,41,59],[7,21,41,60],[7,21,41,61],[7,21,41,62],
 [7,21,41,66],[7,21,41,67],[7,21,41,68],[7,21,41,69],
 [7,21,43,44],[7,21,43,45],[7,21,43,46],[7,21,43,47],
 [7,21,43,48],[7,21,43,49],[7,21,43,52],[7,21,43,53],
 [7,21,43,55],[7,21,43,57],[7,21,43,58],[7,21,43,59],
 [7,21,43,60],[7,21,43,61],[7,21,43,62],[7,21,43,64],
 [7,21,43,66],[7,21,43,67],[7,21,43,68],[7,21,43,69],
 [7,21,44,45],[7,21,44,46],[7,21,44,47],[7,21,44,48],
 [7,21,44,49],[7,21,44,51],[7,21,44,52],[7,21,44,53],
 [7,21,44,55],[7,21,44,57],[7,21,44,58],[7,21,44,59],
 [7,21,44,60],[7,21,44,61],[7,21,44,62],[7,21,44,66],
 [7,21,44,67],[7,21,44,68],[7,21,44,69],[7,21,45,46],
 [7,21,45,47],[7,21,45,48],[7,21,45,49],[7,21,45,50],
 [7,21,45,51],[7,21,45,52],[7,21,45,53],[7,21,45,55],
 [7,21,45,57],[7,21,45,58],[7,21,45,59],[7,21,45,60],
 [7,21,45,61],[7,21,45,62],[7,21,45,66],[7,21,45,67],
 [7,21,45,68],[7,21,45,69],[7,21,46,47],[7,21,46,48],
 [7,21,46,49],[7,21,46,52],[7,21,46,53],[7,21,46,55],
 [7,21,46,57],[7,21,46,58],[7,21,46,59],[7,21,46,60],
 [7,21,46,61],[7,21,46,62],[7,21,46,66],[7,21,46,67],
 [7,21,46,68],[7,21,46,69],[7,21,47,48],[7,21,47,49],
 [7,21,47,50],[7,21,47,51],[7,21,47,52],[7,21,47,53],
 [7,21,47,55],[7,21,47,57],[7,21,47,58],[7,21,47,59],
 [7,21,47,60],[7,21,47,61],[7,21,47,62],[7,21,47,64],
 [7,21,47,66],[7,21,47,67],[7,21,47,68],[7,21,47,69],
 [7,21,48,49],[7,21,48,50],[7,21,48,51],[7,21,48,52],
 [7,21,48,53],[7,21,48,55],[7,21,48,57],[7,21,48,58],
 [7,21,48,59],[7,21,48,60],[7,21,48,61],[7,21,48,62],
 [7,21,48,64],[7,21,48,66],[7,21,48,67],[7,21,48,68],
 [7,21,48,69],[7,21,49,52],[7,21,49,55],[7,21,49,58],
 [7,21,49,59],[7,21,49,60],[7,21,49,61],[7,21,49,62],
 [7,21,49,64],[7,21,49,66],[7,21,49,67],[7,21,49,68],
 [7,21,49,69],[7,21,50,51],[7,21,50,52],[7,21,50,53],
 [7,21,50,59],[7,21,50,61],[7,21,50,62],[7,21,50,67],
 [7,21,50,68],[7,21,50,69],[7,21,51,52],[7,21,51,53],
 [7,21,51,59],[7,21,51,60],[7,21,51,62],[7,21,51,67],
 [7,21,51,68],[7,21,52,53],[7,21,52,62],[7,21,52,67],
 [7,21,53,62],[7,21,53,67],[7,21,55,58],[7,21,55,59],
 [7,21,55,60],[7,21,55,61],[7,21,55,62],[7,21,55,66],
 [7,21,55,67],[7,21,55,68],[7,21,55,69],[7,21,57,58],
 [7,21,57,60],[7,21,57,61],[7,21,57,67],[7,21,58,59],
 [7,21,58,60],[7,21,58,61],[7,21,58,62],[7,21,58,66],
 [7,21,58,67],[7,21,58,68],[7,21,58,69],[7,21,59,60],
 [7,21,59,61],[7,21,59,62],[7,21,59,66],[7,21,59,67],
 [7,21,59,68],[7,21,59,69],[7,21,60,61],[7,21,60,62],
 [7,21,60,66],[7,21,60,67],[7,21,60,68],[7,21,60,69],
 [7,21,61,62],[7,21,61,66],[7,21,61,67],[7,21,61,68],
 [7,21,61,69],[7,21,62,66],[7,21,62,67],[7,21,62,68],
 [7,21,62,69],[7,21,64,66],[7,21,64,67],[7,21,64,68],
 [7,21,64,69],[7,21,66,67],[7,21,66,68],[7,21,66,69],
 [7,21,67,68],[7,21,67,69],[7,21,68,69],[7,22,23,24],
 [7,22,23,25],[7,22,23,26],[7,22,23,27],[7,22,23,34],
 [7,22,23,37],[7,22,23,39],[7,22,23,41],[7,22,23,43],
 [7,22,23,44],[7,22,23,45],[7,22,23,46],[7,22,23,47],
 [7,22,23,48],[7,22,23,49],[7,22,23,55],[7,22,23,57],
 [7,22,23,58],[7,22,23,59],[7,22,23,60],[7,22,23,61],
 [7,22,23,62],[7,22,23,66],[7,22,23,67],[7,22,23,68],
 [7,22,23,69],[7,22,24,25],[7,22,24,26],[7,22,24,27],
 [7,22,24,34],[7,22,24,37],[7,22,24,39],[7,22,24,41],
 [7,22,24,43],[7,22,24,44],[7,22,24,45],[7,22,24,46],
 [7,22,24,47],[7,22,24,48],[7,22,24,49],[7,22,24,55],
 [7,22,24,57],[7,22,24,58],[7,22,24,59],[7,22,24,60],
 [7,22,24,61],[7,22,24,62],[7,22,24,66],[7,22,24,67],
 [7,22,24,68],[7,22,24,69],[7,22,25,26],[7,22,25,27],
 [7,22,25,34],[7,22,25,37],[7,22,25,39],[7,22,25,41],
 [7,22,25,43],[7,22,25,44],[7,22,25,45],[7,22,25,46],
 [7,22,25,47],[7,22,25,48],[7,22,25,49],[7,22,25,55],
 [7,22,25,57],[7,22,25,58],[7,22,25,59],[7,22,25,60],
 [7,22,25,61],[7,22,25,62],[7,22,25,66],[7,22,25,67],
 [7,22,25,68],[7,22,25,69],[7,22,26,27],[7,22,26,34],
 [7,22,26,37],[7,22,26,39],[7,22,26,41],[7,22,26,43],
 [7,22,26,44],[7,22,26,45],[7,22,26,46],[7,22,26,47],
 [7,22,26,48],[7,22,26,49],[7,22,26,55],[7,22,26,57],
 [7,22,26,58],[7,22,26,59],[7,22,26,60],[7,22,26,61],
 [7,22,26,62],[7,22,26,66],[7,22,26,67],[7,22,26,68],
 [7,22,26,69],[7,22,27,34],[7,22,27,39],[7,22,27,41],
 [7,22,27,43],[7,22,27,44],[7,22,27,45],[7,22,27,46],
 [7,22,27,47],[7,22,27,48],[7,22,27,49],[7,22,27,55],
 [7,22,27,58],[7,22,27,59],[7,22,27,60],[7,22,27,61],
 [7,22,27,62],[7,22,27,66],[7,22,27,67],[7,22,27,68],
 [7,22,27,69],[7,22,34,39],[7,22,34,41],[7,22,34,43],
 [7,22,34,44],[7,22,34,45],[7,22,34,46],[7,22,34,47],
 [7,22,34,48],[7,22,34,49],[7,22,34,55],[7,22,34,58],
 [7,22,34,59],[7,22,34,60],[7,22,34,61],[7,22,34,62],
 [7,22,34,66],[7,22,34,67],[7,22,34,68],[7,22,34,69],
 [7,22,37,43],[7,22,37,44],[7,22,37,45],[7,22,37,46],
 [7,22,37,47],[7,22,37,58],[7,22,37,60],[7,22,37,61],
 [7,22,37,62],[7,22,37,67],[7,22,39,41],[7,22,39,43],
 [7,22,39,44],[7,22,39,45],[7,22,39,46],[7,22,39,47],
 [7,22,39,48],[7,22,39,49],[7,22,39,55],[7,22,39,58],
 [7,22,39,59],[7,22,39,60],[7,22,39,61],[7,22,39,62],
 [7,22,39,66],[7,22,39,67],[7,22,39,68],[7,22,39,69],
 [7,22,41,43],[7,22,41,44],[7,22,41,45],[7,22,41,46],
 [7,22,41,47],[7,22,41,48],[7,22,41,49],[7,22,41,55],
 [7,22,41,58],[7,22,41,59],[7,22,41,60],[7,22,41,61],
 [7,22,41,62],[7,22,41,66],[7,22,41,67],[7,22,41,68],
 [7,22,41,69],[7,22,43,44],[7,22,43,45],[7,22,43,46],
 [7,22,43,47],[7,22,43,48],[7,22,43,49],[7,22,43,55],
 [7,22,43,57],[7,22,43,58],[7,22,43,59],[7,22,43,60],
 [7,22,43,61],[7,22,43,62],[7,22,43,66],[7,22,43,67],
 [7,22,43,68],[7,22,43,69],[7,22,44,45],[7,22,44,46],
 [7,22,44,47],[7,22,44,48],[7,22,44,49],[7,22,44,55],
 [7,22,44,57],[7,22,44,58],[7,22,44,59],[7,22,44,60],
 [7,22,44,61],[7,22,44,62],[7,22,44,66],[7,22,44,67],
 [7,22,44,68],[7,22,44,69],[7,22,45,46],[7,22,45,47],
 [7,22,45,48],[7,22,45,49],[7,22,45,55],[7,22,45,57],
 [7,22,45,58],[7,22,45,59],[7,22,45,60],[7,22,45,61],
 [7,22,45,62],[7,22,45,66],[7,22,45,67],[7,22,45,68],
 [7,22,45,69],[7,22,46,47],[7,22,46,48],[7,22,46,49],
 [7,22,46,55],[7,22,46,57],[7,22,46,58],[7,22,46,59],
 [7,22,46,60],[7,22,46,61],[7,22,46,62],[7,22,46,66],
 [7,22,46,67],[7,22,46,68],[7,22,46,69],[7,22,47,48],
 [7,22,47,49],[7,22,47,55],[7,22,47,57],[7,22,47,58],
 [7,22,47,59],[7,22,47,60],[7,22,47,61],[7,22,47,62],
 [7,22,47,66],[7,22,47,67],[7,22,47,68],[7,22,47,69],
 [7,22,48,49],[7,22,48,55],[7,22,48,58],[7,22,48,59],
 [7,22,48,60],[7,22,48,61],[7,22,48,62],[7,22,48,66],
 [7,22,48,67],[7,22,48,68],[7,22,48,69],[7,22,49,55],
 [7,22,49,58],[7,22,49,59],[7,22,49,60],[7,22,49,61],
 [7,22,49,62],[7,22,49,66],[7,22,49,67],[7,22,49,68],
 [7,22,49,69],[7,22,55,58],[7,22,55,59],[7,22,55,60],
 [7,22,55,61],[7,22,55,62],[7,22,55,66],[7,22,55,67],
 [7,22,55,68],[7,22,55,69],[7,22,57,58],[7,22,57,60],
 [7,22,57,61],[7,22,57,67],[7,22,58,59],[7,22,58,60],
 [7,22,58,61],[7,22,58,62],[7,22,58,66],[7,22,58,67],
 [7,22,58,68],[7,22,58,69],[7,22,59,60],[7,22,59,61],
 [7,22,59,62],[7,22,59,66],[7,22,59,67],[7,22,59,68],
 [7,22,59,69],[7,22,60,61],[7,22,60,62],[7,22,60,66],
 [7,22,60,67],[7,22,60,68],[7,22,60,69],[7,22,61,62],
 [7,22,61,66],[7,22,61,67],[7,22,61,68],[7,22,61,69],
 [7,22,62,66],[7,22,62,67],[7,22,62,68],[7,22,62,69],
 [7,22,66,67],[7,22,66,68],[7,22,66,69],[7,22,67,68],
 [7,22,67,69],[7,22,68,69],[7,23,24,25],[7,23,24,26],
 [7,23,24,27],[7,23,24,34],[7,23,24,37],[7,23,24,39],
 [7,23,24,41],[7,23,24,43],[7,23,24,44],[7,23,24,45],
 [7,23,24,46],[7,23,24,47],[7,23,24,48],[7,23,24,49],
 [7,23,24,52],[7,23,24,53],[7,23,24,55],[7,23,24,57],
 [7,23,24,58],[7,23,24,59],[7,23,24,60],[7,23,24,61],
 [7,23,24,62],[7,23,24,66],[7,23,24,67],[7,23,24,68],
 [7,23,24,69],[7,23,25,26],[7,23,25,27],[7,23,25,31],
 [7,23,25,34],[7,23,25,35],[7,23,25,37],[7,23,25,39],
 [7,23,25,40],[7,23,25,41],[7,23,25,43],[7,23,25,44],
 [7,23,25,45],[7,23,25,46],[7,23,25,47],[7,23,25,48],
 [7,23,25,49],[7,23,25,50],[7,23,25,51],[7,23,25,52],
 [7,23,25,53],[7,23,25,55],[7,23,25,57],[7,23,25,58],
 [7,23,25,59],[7,23,25,60],[7,23,25,61],[7,23,25,62],
 [7,23,25,64],[7,23,25,66],[7,23,25,67],[7,23,25,68],
 [7,23,25,69],[7,23,26,27],[7,23,26,31],[7,23,26,34],
 [7,23,26,35],[7,23,26,37],[7,23,26,39],[7,23,26,40],
 [7,23,26,41],[7,23,26,43],[7,23,26,44],[7,23,26,45],
 [7,23,26,46],[7,23,26,47],[7,23,26,48],[7,23,26,49],
 [7,23,26,50],[7,23,26,51],[7,23,26,52],[7,23,26,53],
 [7,23,26,55],[7,23,26,57],[7,23,26,58],[7,23,26,59],
 [7,23,26,60],[7,23,26,61],[7,23,26,62],[7,23,26,64],
 [7,23,26,66],[7,23,26,67],[7,23,26,68],[7,23,26,69],
 [7,23,27,31],[7,23,27,34],[7,23,27,35],[7,23,27,39],
 [7,23,27,40],[7,23,27,41],[7,23,27,43],[7,23,27,44],
 [7,23,27,45],[7,23,27,46],[7,23,27,47],[7,23,27,48],
 [7,23,27,49],[7,23,27,52],[7,23,27,53],[7,23,27,55],
 [7,23,27,58],[7,23,27,59],[7,23,27,60],[7,23,27,61],
 [7,23,27,62],[7,23,27,64],[7,23,27,66],[7,23,27,67],
 [7,23,27,68],[7,23,27,69],[7,23,30,35],[7,23,30,58],
 [7,23,30,67],[7,23,31,37],[7,23,31,41],[7,23,31,44],
 [7,23,31,47],[7,23,31,48],[7,23,31,49],[7,23,31,55],
 [7,23,31,58],[7,23,31,59],[7,23,31,66],[7,23,31,67],
 [7,23,31,68],[7,23,31,69],[7,23,34,39],[7,23,34,41],
 [7,23,34,43],[7,23,34,44],[7,23,34,45],[7,23,34,46],
 [7,23,34,47],[7,23,34,48],[7,23,34,49],[7,23,34,55],
 [7,23,34,58],[7,23,34,59],[7,23,34,60],[7,23,34,61],
 [7,23,34,62],[7,23,34,66],[7,23,34,67],[7,23,34,68],
 [7,23,34,69],[7,23,35,37],[7,23,35,41],[7,23,35,45],
 [7,23,35,47],[7,23,35,48],[7,23,35,49],[7,23,35,55],
 [7,23,35,57],[7,23,35,58],[7,23,35,59],[7,23,35,62],
 [7,23,35,66],[7,23,35,67],[7,23,35,68],[7,23,35,69],
 [7,23,37,40],[7,23,37,43],[7,23,37,44],[7,23,37,45],
 [7,23,37,46],[7,23,37,47],[7,23,37,48],[7,23,37,58],
 [7,23,37,60],[7,23,37,61],[7,23,37,62],[7,23,37,64],
 [7,23,37,67],[7,23,39,41],[7,23,39,43],[7,23,39,44],
 [7,23,39,45],[7,23,39,46],[7,23,39,47],[7,23,39,48],
 [7,23,39,49],[7,23,39,52],[7,23,39,53],[7,23,39,55],
 [7,23,39,58],[7,23,39,59],[7,23,39,60],[7,23,39,61],
 [7,23,39,62],[7,23,39,64],[7,23,39,66],[7,23,39,67],
 [7,23,39,68],[7,23,39,69],[7,23,40,41],[7,23,40,45],
 [7,23,40,47],[7,23,40,48],[7,23,40,49],[7,23,40,52],
 [7,23,40,53],[7,23,40,55],[7,23,40,58],[7,23,40,59],
 [7,23,40,64],[7,23,40,66],[7,23,40,67],[7,23,40,68],
 [7,23,40,69],[7,23,41,43],[7,23,41,44],[7,23,41,45],
 [7,23,41,46],[7,23,41,47],[7,23,41,48],[7,23,41,49],
 [7,23,41,55],[7,23,41,58],[7,23,41,59],[7,23,41,60],
 [7,23,41,61],[7,23,41,62],[7,23,41,64],[7,23,41,66],
 [7,23,41,67],[7,23,41,68],[7,23,41,69],[7,23,43,44],
 [7,23,43,45],[7,23,43,46],[7,23,43,47],[7,23,43,48],
 [7,23,43,49],[7,23,43,52],[7,23,43,53],[7,23,43,55],
 [7,23,43,57],[7,23,43,58],[7,23,43,59],[7,23,43,60],
 [7,23,43,61],[7,23,43,62],[7,23,43,64],[7,23,43,66],
 [7,23,43,67],[7,23,43,68],[7,23,43,69],[7,23,44,45],
 [7,23,44,46],[7,23,44,47],[7,23,44,48],[7,23,44,49],
 [7,23,44,50],[7,23,44,51],[7,23,44,52],[7,23,44,53],
 [7,23,44,55],[7,23,44,57],[7,23,44,58],[7,23,44,59],
 [7,23,44,60],[7,23,44,61],[7,23,44,62],[7,23,44,66],
 [7,23,44,67],[7,23,44,68],[7,23,44,69],[7,23,45,46],
 [7,23,45,47],[7,23,45,48],[7,23,45,49],[7,23,45,50],
 [7,23,45,51],[7,23,45,52],[7,23,45,53],[7,23,45,55],
 [7,23,45,57],[7,23,45,58],[7,23,45,59],[7,23,45,60],
 [7,23,45,61],[7,23,45,62],[7,23,45,66],[7,23,45,67],
 [7,23,45,68],[7,23,45,69],[7,23,46,47],[7,23,46,48],
 [7,23,46,49],[7,23,46,52],[7,23,46,53],[7,23,46,55],
 [7,23,46,57],[7,23,46,58],[7,23,46,59],[7,23,46,60],
 [7,23,46,61],[7,23,46,62],[7,23,46,66],[7,23,46,67],
 [7,23,46,68],[7,23,46,69],[7,23,47,48],[7,23,47,49],
 [7,23,47,50],[7,23,47,51],[7,23,47,52],[7,23,47,53],
 [7,23,47,55],[7,23,47,57],[7,23,47,58],[7,23,47,59],
 [7,23,47,60],[7,23,47,61],[7,23,47,62],[7,23,47,64],
 [7,23,47,66],[7,23,47,67],[7,23,47,68],[7,23,47,69],
 [7,23,48,49],[7,23,48,50],[7,23,48,51],[7,23,48,52],
 [7,23,48,53],[7,23,48,55],[7,23,48,57],[7,23,48,58],
 [7,23,48,59],[7,23,48,60],[7,23,48,61],[7,23,48,62],
 [7,23,48,64],[7,23,48,66],[7,23,48,67],[7,23,48,68],
 [7,23,48,69],[7,23,49,52],[7,23,49,53],[7,23,49,55],
 [7,23,49,58],[7,23,49,59],[7,23,49,60],[7,23,49,61],
 [7,23,49,62],[7,23,49,64],[7,23,49,66],[7,23,49,67],
 [7,23,49,68],[7,23,49,69],[7,23,50,51],[7,23,50,52],
 [7,23,50,53],[7,23,50,55],[7,23,50,58],[7,23,50,59],
 [7,23,50,60],[7,23,50,61],[7,23,50,62],[7,23,50,64],
 [7,23,50,67],[7,23,50,68],[7,23,50,69],[7,23,51,52],
 [7,23,51,53],[7,23,51,55],[7,23,51,58],[7,23,51,59],
 [7,23,51,60],[7,23,51,61],[7,23,51,62],[7,23,51,64],
 [7,23,51,67],[7,23,51,68],[7,23,51,69],[7,23,52,53],
 [7,23,52,62],[7,23,52,67],[7,23,53,62],[7,23,53,67],
 [7,23,55,58],[7,23,55,59],[7,23,55,60],[7,23,55,61],
 [7,23,55,62],[7,23,55,66],[7,23,55,67],[7,23,55,68],
 [7,23,55,69],[7,23,57,58],[7,23,57,60],[7,23,57,61],
 [7,23,57,67],[7,23,58,59],[7,23,58,60],[7,23,58,61],
 [7,23,58,62],[7,23,58,66],[7,23,58,67],[7,23,58,68],
 [7,23,58,69],[7,23,59,60],[7,23,59,61],[7,23,59,62],
 [7,23,59,66],[7,23,59,67],[7,23,59,68],[7,23,59,69],
 [7,23,60,61],[7,23,60,62],[7,23,60,66],[7,23,60,67],
 [7,23,60,68],[7,23,60,69],[7,23,61,62],[7,23,61,66],
 [7,23,61,67],[7,23,61,68],[7,23,61,69],[7,23,62,66],
 [7,23,62,67],[7,23,62,68],[7,23,62,69],[7,23,64,66],
 [7,23,64,67],[7,23,64,68],[7,23,64,69],[7,23,66,67],
 [7,23,66,68],[7,23,66,69],[7,23,67,68],[7,23,67,69],
 [7,23,68,69],[7,24,25,26],[7,24,25,27],[7,24,25,34],
 [7,24,25,37],[7,24,25,39],[7,24,25,41],[7,24,25,43],
 [7,24,25,44],[7,24,25,45],[7,24,25,46],[7,24,25,47],
 [7,24,25,48],[7,24,25,49],[7,24,25,53],[7,24,25,55],
 [7,24,25,57],[7,24,25,58],[7,24,25,59],[7,24,25,60],
 [7,24,25,61],[7,24,25,62],[7,24,25,66],[7,24,25,67],
 [7,24,25,68],[7,24,25,69],[7,24,26,27],[7,24,26,34],
 [7,24,26,37],[7,24,26,39],[7,24,26,41],[7,24,26,43],
 [7,24,26,44],[7,24,26,45],[7,24,26,46],[7,24,26,47],
 [7,24,26,48],[7,24,26,49],[7,24,26,52],[7,24,26,55],
 [7,24,26,57],[7,24,26,58],[7,24,26,59],[7,24,26,60],
 [7,24,26,61],[7,24,26,62],[7,24,26,66],[7,24,26,67],
 [7,24,26,68],[7,24,26,69],[7,24,27,34],[7,24,27,39],
 [7,24,27,41],[7,24,27,43],[7,24,27,44],[7,24,27,45],
 [7,24,27,46],[7,24,27,47],[7,24,27,48],[7,24,27,49],
 [7,24,27,52],[7,24,27,53],[7,24,27,55],[7,24,27,58],
 [7,24,27,59],[7,24,27,60],[7,24,27,61],[7,24,27,62],
 [7,24,27,66],[7,24,27,67],[7,24,27,68],[7,24,27,69],
 [7,24,34,39],[7,24,34,41],[7,24,34,43],[7,24,34,44],
 [7,24,34,45],[7,24,34,46],[7,24,34,47],[7,24,34,48],
 [7,24,34,49],[7,24,34,55],[7,24,34,58],[7,24,34,59],
 [7,24,34,60],[7,24,34,61],[7,24,34,62],[7,24,34,66],
 [7,24,34,67],[7,24,34,68],[7,24,34,69],[7,24,37,43],
 [7,24,37,44],[7,24,37,45],[7,24,37,46],[7,24,37,47],
 [7,24,37,48],[7,24,37,58],[7,24,37,60],[7,24,37,61],
 [7,24,37,62],[7,24,37,67],[7,24,39,41],[7,24,39,43],
 [7,24,39,44],[7,24,39,45],[7,24,39,46],[7,24,39,47],
 [7,24,39,48],[7,24,39,49],[7,24,39,52],[7,24,39,53],
 [7,24,39,55],[7,24,39,58],[7,24,39,59],[7,24,39,60],
 [7,24,39,61],[7,24,39,62],[7,24,39,66],[7,24,39,67],
 [7,24,39,68],[7,24,39,69],[7,24,41,43],[7,24,41,44],
 [7,24,41,45],[7,24,41,46],[7,24,41,47],[7,24,41,48],
 [7,24,41,49],[7,24,41,55],[7,24,41,58],[7,24,41,59],
 [7,24,41,60],[7,24,41,61],[7,24,41,62],[7,24,41,66],
 [7,24,41,67],[7,24,41,68],[7,24,41,69],[7,24,43,44],
 [7,24,43,45],[7,24,43,46],[7,24,43,47],[7,24,43,48],
 [7,24,43,49],[7,24,43,52],[7,24,43,53],[7,24,43,55],
 [7,24,43,57],[7,24,43,58],[7,24,43,59],[7,24,43,60],
 [7,24,43,61],[7,24,43,62],[7,24,43,66],[7,24,43,67],
 [7,24,43,68],[7,24,43,69],[7,24,44,45],[7,24,44,46],
 [7,24,44,47],[7,24,44,48],[7,24,44,49],[7,24,44,52],
 [7,24,44,53],[7,24,44,55],[7,24,44,57],[7,24,44,58],
 [7,24,44,59],[7,24,44,60],[7,24,44,61],[7,24,44,62],
 [7,24,44,66],[7,24,44,67],[7,24,44,68],[7,24,44,69],
 [7,24,45,46],[7,24,45,47],[7,24,45,48],[7,24,45,49],
 [7,24,45,53],[7,24,45,55],[7,24,45,57],[7,24,45,58],
 [7,24,45,59],[7,24,45,60],[7,24,45,61],[7,24,45,62],
 [7,24,45,66],[7,24,45,67],[7,24,45,68],[7,24,45,69],
 [7,24,46,47],[7,24,46,48],[7,24,46,49],[7,24,46,52],
 [7,24,46,53],[7,24,46,55],[7,24,46,57],[7,24,46,58],
 [7,24,46,59],[7,24,46,60],[7,24,46,61],[7,24,46,62],
 [7,24,46,66],[7,24,46,67],[7,24,46,68],[7,24,46,69],
 [7,24,47,48],[7,24,47,49],[7,24,47,52],[7,24,47,53],
 [7,24,47,55],[7,24,47,57],[7,24,47,58],[7,24,47,59],
 [7,24,47,60],[7,24,47,61],[7,24,47,62],[7,24,47,66],
 [7,24,47,67],[7,24,47,68],[7,24,47,69],[7,24,48,49],
 [7,24,48,52],[7,24,48,53],[7,24,48,55],[7,24,48,57],
 [7,24,48,58],[7,24,48,59],[7,24,48,60],[7,24,48,61],
 [7,24,48,62],[7,24,48,66],[7,24,48,67],[7,24,48,68],
 [7,24,48,69],[7,24,49,52],[7,24,49,53],[7,24,49,55],
 [7,24,49,58],[7,24,49,59],[7,24,49,60],[7,24,49,61],
 [7,24,49,62],[7,24,49,66],[7,24,49,67],[7,24,49,68],
 [7,24,49,69],[7,24,52,53],[7,24,52,62],[7,24,52,67],
 [7,24,53,62],[7,24,53,67],[7,24,55,58],[7,24,55,59],
 [7,24,55,60],[7,24,55,61],[7,24,55,62],[7,24,55,66],
 [7,24,55,67],[7,24,55,68],[7,24,55,69],[7,24,57,60],
 [7,24,57,61],[7,24,57,67],[7,24,58,59],[7,24,58,60],
 [7,24,58,61],[7,24,58,62],[7,24,58,66],[7,24,58,67],
 [7,24,58,68],[7,24,58,69],[7,24,59,60],[7,24,59,61],
 [7,24,59,62],[7,24,59,66],[7,24,59,67],[7,24,59,68],
 [7,24,59,69],[7,24,60,61],[7,24,60,62],[7,24,60,66],
 [7,24,60,67],[7,24,60,68],[7,24,60,69],[7,24,61,62],
 [7,24,61,66],[7,24,61,67],[7,24,61,68],[7,24,61,69],
 [7,24,62,66],[7,24,62,67],[7,24,62,68],[7,24,62,69],
 [7,24,66,67],[7,24,66,68],[7,24,66,69],[7,24,67,68],
 [7,24,67,69],[7,24,68,69],[7,25,26,27],[7,25,26,31],
 [7,25,26,34],[7,25,26,35],[7,25,26,37],[7,25,26,39],
 [7,25,26,40],[7,25,26,41],[7,25,26,43],[7,25,26,44],
 [7,25,26,45],[7,25,26,46],[7,25,26,47],[7,25,26,48],
 [7,25,26,49],[7,25,26,50],[7,25,26,51],[7,25,26,52],
 [7,25,26,53],[7,25,26,55],[7,25,26,57],[7,25,26,58],
 [7,25,26,59],[7,25,26,60],[7,25,26,61],[7,25,26,62],
 [7,25,26,64],[7,25,26,66],[7,25,26,67],[7,25,26,68],
 [7,25,26,69],[7,25,27,31],[7,25,27,34],[7,25,27,35],
 [7,25,27,39],[7,25,27,40],[7,25,27,41],[7,25,27,43],
 [7,25,27,44],[7,25,27,45],[7,25,27,46],[7,25,27,47],
 [7,25,27,48],[7,25,27,49],[7,25,27,53],[7,25,27,55],
 [7,25,27,58],[7,25,27,59],[7,25,27,60],[7,25,27,61],
 [7,25,27,62],[7,25,27,64],[7,25,27,66],[7,25,27,67],
 [7,25,27,68],[7,25,27,69],[7,25,31,37],[7,25,31,41],
 [7,25,31,44],[7,25,31,47],[7,25,31,48],[7,25,31,49],
 [7,25,31,55],[7,25,31,58],[7,25,31,66],[7,25,31,67],
 [7,25,31,68],[7,25,31,69],[7,25,34,39],[7,25,34,41],
 [7,25,34,43],[7,25,34,44],[7,25,34,45],[7,25,34,46],
 [7,25,34,47],[7,25,34,48],[7,25,34,49],[7,25,34,55],
 [7,25,34,58],[7,25,34,59],[7,25,34,60],[7,25,34,61],
 [7,25,34,62],[7,25,34,66],[7,25,34,67],[7,25,34,68],
 [7,25,34,69],[7,25,35,37],[7,25,35,41],[7,25,35,45],
 [7,25,35,47],[7,25,35,48],[7,25,35,49],[7,25,35,55],
 [7,25,35,57],[7,25,35,58],[7,25,35,59],[7,25,35,62],
 [7,25,35,66],[7,25,35,67],[7,25,35,68],[7,25,35,69],
 [7,25,37,40],[7,25,37,43],[7,25,37,44],[7,25,37,45],
 [7,25,37,46],[7,25,37,47],[7,25,37,48],[7,25,37,58],
 [7,25,37,60],[7,25,37,61],[7,25,37,62],[7,25,37,64],
 [7,25,37,67],[7,25,39,41],[7,25,39,43],[7,25,39,44],
 [7,25,39,45],[7,25,39,46],[7,25,39,47],[7,25,39,48],
 [7,25,39,49],[7,25,39,55],[7,25,39,58],[7,25,39,59],
 [7,25,39,60],[7,25,39,61],[7,25,39,62],[7,25,39,64],
 [7,25,39,66],[7,25,39,67],[7,25,39,68],[7,25,39,69],
 [7,25,40,41],[7,25,40,45],[7,25,40,47],[7,25,40,48],
 [7,25,40,49],[7,25,40,52],[7,25,40,53],[7,25,40,55],
 [7,25,40,58],[7,25,40,59],[7,25,40,64],[7,25,40,66],
 [7,25,40,67],[7,25,40,68],[7,25,40,69],[7,25,41,43],
 [7,25,41,44],[7,25,41,45],[7,25,41,46],[7,25,41,47],
 [7,25,41,48],[7,25,41,49],[7,25,41,55],[7,25,41,58],
 [7,25,41,59],[7,25,41,60],[7,25,41,61],[7,25,41,62],
 [7,25,41,64],[7,25,41,66],[7,25,41,67],[7,25,41,68],
 [7,25,41,69],[7,25,43,44],[7,25,43,45],[7,25,43,46],
 [7,25,43,47],[7,25,43,48],[7,25,43,49],[7,25,43,52],
 [7,25,43,53],[7,25,43,55],[7,25,43,57],[7,25,43,58],
 [7,25,43,59],[7,25,43,60],[7,25,43,61],[7,25,43,62],
 [7,25,43,64],[7,25,43,66],[7,25,43,67],[7,25,43,68],
 [7,25,43,69],[7,25,44,45],[7,25,44,46],[7,25,44,47],
 [7,25,44,48],[7,25,44,49],[7,25,44,50],[7,25,44,51],
 [7,25,44,52],[7,25,44,55],[7,25,44,57],[7,25,44,58],
 [7,25,44,59],[7,25,44,60],[7,25,44,61],[7,25,44,62],
 [7,25,44,66],[7,25,44,67],[7,25,44,68],[7,25,44,69],
 [7,25,45,46],[7,25,45,47],[7,25,45,48],[7,25,45,49],
 [7,25,45,50],[7,25,45,51],[7,25,45,52],[7,25,45,53],
 [7,25,45,55],[7,25,45,57],[7,25,45,58],[7,25,45,59],
 [7,25,45,60],[7,25,45,61],[7,25,45,62],[7,25,45,66],
 [7,25,45,67],[7,25,45,68],[7,25,45,69],[7,25,46,47],
 [7,25,46,48],[7,25,46,49],[7,25,46,52],[7,25,46,53],
 [7,25,46,55],[7,25,46,57],[7,25,46,58],[7,25,46,59],
 [7,25,46,60],[7,25,46,61],[7,25,46,62],[7,25,46,66],
 [7,25,46,67],[7,25,46,68],[7,25,46,69],[7,25,47,48],
 [7,25,47,49],[7,25,47,50],[7,25,47,51],[7,25,47,52],
 [7,25,47,53],[7,25,47,55],[7,25,47,57],[7,25,47,58],
 [7,25,47,59],[7,25,47,60],[7,25,47,61],[7,25,47,62],
 [7,25,47,64],[7,25,47,66],[7,25,47,67],[7,25,47,68],
 [7,25,47,69],[7,25,48,49],[7,25,48,50],[7,25,48,51],
 [7,25,48,52],[7,25,48,53],[7,25,48,55],[7,25,48,57],
 [7,25,48,58],[7,25,48,59],[7,25,48,60],[7,25,48,61],
 [7,25,48,62],[7,25,48,64],[7,25,48,66],[7,25,48,67],
 [7,25,48,68],[7,25,48,69],[7,25,49,52],[7,25,49,53],
 [7,25,49,55],[7,25,49,58],[7,25,49,59],[7,25,49,60],
 [7,25,49,61],[7,25,49,62],[7,25,49,64],[7,25,49,66],
 [7,25,49,67],[7,25,49,68],[7,25,49,69],[7,25,50,51],
 [7,25,50,52],[7,25,50,53],[7,25,50,61],[7,25,50,62],
 [7,25,50,67],[7,25,50,69],[7,25,51,52],[7,25,51,53],
 [7,25,51,55],[7,25,51,58],[7,25,51,59],[7,25,51,60],
 [7,25,51,61],[7,25,51,62],[7,25,51,64],[7,25,51,67],
 [7,25,51,68],[7,25,51,69],[7,25,52,53],[7,25,52,62],
 [7,25,52,67],[7,25,53,62],[7,25,53,67],[7,25,55,58],
 [7,25,55,59],[7,25,55,60],[7,25,55,61],[7,25,55,62],
 [7,25,55,66],[7,25,55,67],[7,25,55,68],[7,25,55,69],
 [7,25,57,58],[7,25,57,60],[7,25,57,61],[7,25,57,67],
 [7,25,58,59],[7,25,58,60],[7,25,58,61],[7,25,58,62],
 [7,25,58,66],[7,25,58,67],[7,25,58,68],[7,25,58,69],
 [7,25,59,60],[7,25,59,61],[7,25,59,62],[7,25,59,66],
 [7,25,59,67],[7,25,59,68],[7,25,59,69],[7,25,60,61],
 [7,25,60,62],[7,25,60,66],[7,25,60,67],[7,25,60,68],
 [7,25,60,69],[7,25,61,62],[7,25,61,66],[7,25,61,67],
 [7,25,61,68],[7,25,61,69],[7,25,62,66],[7,25,62,67],
 [7,25,62,68],[7,25,62,69],[7,25,64,66],[7,25,64,67],
 [7,25,64,68],[7,25,64,69],[7,25,66,67],[7,25,66,68],
 [7,25,66,69],[7,25,67,68],[7,25,67,69],[7,25,68,69],
 [7,26,27,31],[7,26,27,34],[7,26,27,35],[7,26,27,39],
 [7,26,27,40],[7,26,27,41],[7,26,27,43],[7,26,27,44],
 [7,26,27,45],[7,26,27,46],[7,26,27,47],[7,26,27,48],
 [7,26,27,49],[7,26,27,52],[7,26,27,55],[7,26,27,58],
 [7,26,27,59],[7,26,27,60],[7,26,27,61],[7,26,27,62],
 [7,26,27,64],[7,26,27,66],[7,26,27,67],[7,26,27,68],
 [7,26,27,69],[7,26,31,37],[7,26,31,41],[7,26,31,44],
 [7,26,31,47],[7,26,31,48],[7,26,31,49],[7,26,31,55],
 [7,26,31,58],[7,26,31,59],[7,26,31,66],[7,26,31,67],
 [7,26,31,68],[7,26,31,69],[7,26,34,39],[7,26,34,41],
 [7,26,34,43],[7,26,34,44],[7,26,34,45],[7,26,34,46],
 [7,26,34,47],[7,26,34,48],[7,26,34,49],[7,26,34,55],
 [7,26,34,58],[7,26,34,59],[7,26,34,60],[7,26,34,61],
 [7,26,34,62],[7,26,34,66],[7,26,34,67],[7,26,34,68],
 [7,26,34,69],[7,26,35,37],[7,26,35,41],[7,26,35,45],
 [7,26,35,47],[7,26,35,48],[7,26,35,49],[7,26,35,55],
 [7,26,35,57],[7,26,35,58],[7,26,35,59],[7,26,35,62],
 [7,26,35,66],[7,26,35,67],[7,26,35,68],[7,26,35,69],
 [7,26,37,40],[7,26,37,43],[7,26,37,44],[7,26,37,45],
 [7,26,37,46],[7,26,37,47],[7,26,37,48],[7,26,37,60],
 [7,26,37,61],[7,26,37,62],[7,26,37,64],[7,26,37,67],
 [7,26,39,41],[7,26,39,43],[7,26,39,44],[7,26,39,45],
 [7,26,39,46],[7,26,39,47],[7,26,39,48],[7,26,39,49],
 [7,26,39,55],[7,26,39,58],[7,26,39,59],[7,26,39,60],
 [7,26,39,61],[7,26,39,62],[7,26,39,64],[7,26,39,66],
 [7,26,39,67],[7,26,39,68],[7,26,39,69],[7,26,40,41],
 [7,26,40,45],[7,26,40,47],[7,26,40,48],[7,26,40,49],
 [7,26,40,52],[7,26,40,53],[7,26,40,55],[7,26,40,58],
 [7,26,40,59],[7,26,40,64],[7,26,40,66],[7,26,40,67],
 [7,26,40,68],[7,26,40,69],[7,26,41,43],[7,26,41,44],
 [7,26,41,45],[7,26,41,46],[7,26,41,47],[7,26,41,48],
 [7,26,41,49],[7,26,41,55],[7,26,41,58],[7,26,41,59],
 [7,26,41,60],[7,26,41,61],[7,26,41,62],[7,26,41,64],
 [7,26,41,66],[7,26,41,67],[7,26,41,68],[7,26,41,69],
 [7,26,43,44],[7,26,43,45],[7,26,43,46],[7,26,43,47],
 [7,26,43,48],[7,26,43,49],[7,26,43,52],[7,26,43,53],
 [7,26,43,55],[7,26,43,58],[7,26,43,59],[7,26,43,60],
 [7,26,43,61],[7,26,43,62],[7,26,43,64],[7,26,43,66],
 [7,26,43,67],[7,26,43,68],[7,26,43,69],[7,26,44,45],
 [7,26,44,46],[7,26,44,47],[7,26,44,48],[7,26,44,49],
 [7,26,44,50],[7,26,44,51],[7,26,44,52],[7,26,44,53],
 [7,26,44,55],[7,26,44,57],[7,26,44,58],[7,26,44,59],
 [7,26,44,60],[7,26,44,61],[7,26,44,62],[7,26,44,66],
 [7,26,44,67],[7,26,44,68],[7,26,44,69],[7,26,45,46],
 [7,26,45,47],[7,26,45,48],[7,26,45,49],[7,26,45,50],
 [7,26,45,51],[7,26,45,52],[7,26,45,53],[7,26,45,55],
 [7,26,45,57],[7,26,45,58],[7,26,45,59],[7,26,45,60],
 [7,26,45,61],[7,26,45,62],[7,26,45,66],[7,26,45,67],
 [7,26,45,68],[7,26,45,69],[7,26,46,47],[7,26,46,48],
 [7,26,46,49],[7,26,46,52],[7,26,46,53],[7,26,46,55],
 [7,26,46,57],[7,26,46,58],[7,26,46,59],[7,26,46,60],
 [7,26,46,61],[7,26,46,62],[7,26,46,66],[7,26,46,67],
 [7,26,46,68],[7,26,46,69],[7,26,47,48],[7,26,47,49],
 [7,26,47,50],[7,26,47,51],[7,26,47,52],[7,26,47,53],
 [7,26,47,55],[7,26,47,57],[7,26,47,58],[7,26,47,59],
 [7,26,47,60],[7,26,47,61],[7,26,47,62],[7,26,47,64],
 [7,26,47,66],[7,26,47,67],[7,26,47,68],[7,26,47,69],
 [7,26,48,49],[7,26,48,50],[7,26,48,51],[7,26,48,52],
 [7,26,48,53],[7,26,48,55],[7,26,48,57],[7,26,48,58],
 [7,26,48,59],[7,26,48,60],[7,26,48,61],[7,26,48,62],
 [7,26,48,64],[7,26,48,66],[7,26,48,67],[7,26,48,68],
 [7,26,48,69],[7,26,49,52],[7,26,49,53],[7,26,49,55],
 [7,26,49,58],[7,26,49,59],[7,26,49,60],[7,26,49,61],
 [7,26,49,62],[7,26,49,64],[7,26,49,66],[7,26,49,67],
 [7,26,49,68],[7,26,49,69],[7,26,50,51],[7,26,50,52],
 [7,26,50,53],[7,26,50,58],[7,26,50,60],[7,26,50,62],
 [7,26,50,64],[7,26,50,67],[7,26,50,68],[7,26,51,52],
 [7,26,51,53],[7,26,51,58],[7,26,51,59],[7,26,51,60],
 [7,26,51,61],[7,26,51,62],[7,26,51,64],[7,26,51,67],
 [7,26,51,68],[7,26,51,69],[7,26,52,53],[7,26,52,62],
 [7,26,52,67],[7,26,53,62],[7,26,53,67],[7,26,55,58],
 [7,26,55,59],[7,26,55,60],[7,26,55,61],[7,26,55,62],
 [7,26,55,66],[7,26,55,67],[7,26,55,68],[7,26,55,69],
 [7,26,57,58],[7,26,57,60],[7,26,57,61],[7,26,57,67],
 [7,26,58,59],[7,26,58,60],[7,26,58,61],[7,26,58,62],
 [7,26,58,66],[7,26,58,67],[7,26,58,68],[7,26,58,69],
 [7,26,59,60],[7,26,59,61],[7,26,59,62],[7,26,59,66],
 [7,26,59,67],[7,26,59,68],[7,26,59,69],[7,26,60,61],
 [7,26,60,62],[7,26,60,66],[7,26,60,67],[7,26,60,68],
 [7,26,60,69],[7,26,61,62],[7,26,61,66],[7,26,61,67],
 [7,26,61,68],[7,26,61,69],[7,26,62,66],[7,26,62,67],
 [7,26,62,68],[7,26,62,69],[7,26,64,66],[7,26,64,67],
 [7,26,64,68],[7,26,64,69],[7,26,66,67],[7,26,66,68],
 [7,26,66,69],[7,26,67,68],[7,26,67,69],[7,26,68,69],
 [7,27,31,41],[7,27,31,47],[7,27,31,48],[7,27,31,49],
 [7,27,31,55],[7,27,31,58],[7,27,31,59],[7,27,31,66],
 [7,27,31,67],[7,27,31,68],[7,27,31,69],[7,27,34,39],
 [7,27,34,41],[7,27,34,43],[7,27,34,44],[7,27,34,45],
 [7,27,34,46],[7,27,34,47],[7,27,34,48],[7,27,34,49],
 [7,27,34,55],[7,27,34,58],[7,27,34,59],[7,27,34,60],
 [7,27,34,61],[7,27,34,62],[7,27,34,66],[7,27,34,67],
 [7,27,34,68],[7,27,34,69],[7,27,35,41],[7,27,35,45],
 [7,27,35,47],[7,27,35,48],[7,27,35,49],[7,27,35,55],
 [7,27,35,58],[7,27,35,59],[7,27,35,62],[7,27,35,66],
 [7,27,35,67],[7,27,35,68],[7,27,35,69],[7,27,39,41],
 [7,27,39,43],[7,27,39,44],[7,27,39,45],[7,27,39,46],
 [7,27,39,47],[7,27,39,48],[7,27,39,49],[7,27,39,52],
 [7,27,39,53],[7,27,39,55],[7,27,39,58],[7,27,39,59],
 [7,27,39,60],[7,27,39,61],[7,27,39,62],[7,27,39,64],
 [7,27,39,66],[7,27,39,67],[7,27,39,68],[7,27,39,69],
 [7,27,40,41],[7,27,40,47],[7,27,40,48],[7,27,40,49],
 [7,27,40,52],[7,27,40,53],[7,27,40,55],[7,27,40,58],
 [7,27,40,64],[7,27,40,66],[7,27,40,67],[7,27,40,68],
 [7,27,40,69],[7,27,41,43],[7,27,41,44],[7,27,41,45],
 [7,27,41,46],[7,27,41,47],[7,27,41,48],[7,27,41,49],
 [7,27,41,55],[7,27,41,58],[7,27,41,59],[7,27,41,60],
 [7,27,41,61],[7,27,41,62],[7,27,41,64],[7,27,41,66],
 [7,27,41,67],[7,27,41,68],[7,27,41,69],[7,27,43,44],
 [7,27,43,45],[7,27,43,46],[7,27,43,47],[7,27,43,48],
 [7,27,43,49],[7,27,43,52],[7,27,43,53],[7,27,43,55],
 [7,27,43,58],[7,27,43,59],[7,27,43,60],[7,27,43,61],
 [7,27,43,62],[7,27,43,64],[7,27,43,66],[7,27,43,67],
 [7,27,43,68],[7,27,43,69],[7,27,44,45],[7,27,44,46],
 [7,27,44,47],[7,27,44,48],[7,27,44,49],[7,27,44,52],
 [7,27,44,55],[7,27,44,58],[7,27,44,59],[7,27,44,60],
 [7,27,44,61],[7,27,44,62],[7,27,44,66],[7,27,44,67],
 [7,27,44,68],[7,27,44,69],[7,27,45,46],[7,27,45,47],
 [7,27,45,48],[7,27,45,49],[7,27,45,53],[7,27,45,55],
 [7,27,45,58],[7,27,45,59],[7,27,45,60],[7,27,45,61],
 [7,27,45,62],[7,27,45,66],[7,27,45,67],[7,27,45,68],
 [7,27,45,69],[7,27,46,47],[7,27,46,48],[7,27,46,49],
 [7,27,46,52],[7,27,46,53],[7,27,46,55],[7,27,46,58],
 [7,27,46,59],[7,27,46,60],[7,27,46,61],[7,27,46,62],
 [7,27,46,66],[7,27,46,67],[7,27,46,68],[7,27,46,69],
 [7,27,47,48],[7,27,47,49],[7,27,47,52],[7,27,47,53],
 [7,27,47,55],[7,27,47,58],[7,27,47,59],[7,27,47,60],
 [7,27,47,61],[7,27,47,62],[7,27,47,64],[7,27,47,66],
 [7,27,47,67],[7,27,47,68],[7,27,47,69],[7,27,48,49],
 [7,27,48,52],[7,27,48,53],[7,27,48,55],[7,27,48,58],
 [7,27,48,59],[7,27,48,60],[7,27,48,61],[7,27,48,62],
 [7,27,48,64],[7,27,48,66],[7,27,48,67],[7,27,48,68],
 [7,27,48,69],[7,27,49,52],[7,27,49,53],[7,27,49,55],
 [7,27,49,58],[7,27,49,59],[7,27,49,60],[7,27,49,61],
 [7,27,49,62],[7,27,49,64],[7,27,49,66],[7,27,49,67],
 [7,27,49,68],[7,27,49,69],[7,27,52,53],[7,27,52,62],
 [7,27,52,67],[7,27,53,62],[7,27,53,67],[7,27,55,58],
 [7,27,55,59],[7,27,55,60],[7,27,55,61],[7,27,55,62],
 [7,27,55,66],[7,27,55,67],[7,27,55,68],[7,27,55,69],
 [7,27,58,59],[7,27,58,60],[7,27,58,61],[7,27,58,62],
 [7,27,58,66],[7,27,58,67],[7,27,58,68],[7,27,58,69],
 [7,27,59,60],[7,27,59,61],[7,27,59,62],[7,27,59,66],
 [7,27,59,67],[7,27,59,68],[7,27,59,69],[7,27,60,61],
 [7,27,60,62],[7,27,60,66],[7,27,60,67],[7,27,60,68],
 [7,27,60,69],[7,27,61,62],[7,27,61,66],[7,27,61,67],
 [7,27,61,68],[7,27,61,69],[7,27,62,66],[7,27,62,67],
 [7,27,62,68],[7,27,62,69],[7,27,64,66],[7,27,64,67],
 [7,27,64,68],[7,27,64,69],[7,27,66,67],[7,27,66,68],
 [7,27,66,69],[7,27,67,68],[7,27,67,69],[7,27,68,69],
 [7,30,35,58],[7,30,35,67],[7,30,58,67],[7,31,37,47],
 [7,31,37,48],[7,31,37,58],[7,31,37,67],[7,31,41,44],
 [7,31,41,47],[7,31,41,48],[7,31,41,49],[7,31,41,59],
 [7,31,41,66],[7,31,41,67],[7,31,41,68],[7,31,41,69],
 [7,31,44,47],[7,31,44,48],[7,31,44,49],[7,31,44,59],
 [7,31,44,67],[7,31,44,68],[7,31,47,48],[7,31,47,49],
 [7,31,47,59],[7,31,47,67],[7,31,47,68],[7,31,47,69],
 [7,31,48,49],[7,31,48,55],[7,31,48,58],[7,31,48,66],
 [7,31,48,67],[7,31,48,68],[7,31,48,69],[7,31,49,55],
 [7,31,49,59],[7,31,49,66],[7,31,49,67],[7,31,49,68],
 [7,31,49,69],[7,31,55,66],[7,31,55,67],[7,31,55,69],
 [7,31,58,59],[7,31,58,66],[7,31,58,67],[7,31,58,68],
 [7,31,58,69],[7,31,59,66],[7,31,59,67],[7,31,59,68],
 [7,31,59,69],[7,31,66,67],[7,31,66,68],[7,31,66,69],
 [7,31,67,68],[7,31,67,69],[7,31,68,69],[7,34,39,41],
 [7,34,39,43],[7,34,39,44],[7,34,39,45],[7,34,39,46],
 [7,34,39,47],[7,34,39,48],[7,34,39,49],[7,34,39,55],
 [7,34,39,58],[7,34,39,59],[7,34,39,60],[7,34,39,61],
 [7,34,39,62],[7,34,39,66],[7,34,39,67],[7,34,39,68],
 [7,34,39,69],[7,34,41,43],[7,34,41,44],[7,34,41,45],
 [7,34,41,46],[7,34,41,47],[7,34,41,48],[7,34,41,49],
 [7,34,41,55],[7,34,41,58],[7,34,41,59],[7,34,41,60],
 [7,34,41,61],[7,34,41,62],[7,34,41,66],[7,34,41,67],
 [7,34,41,68],[7,34,41,69],[7,34,43,44],[7,34,43,45],
 [7,34,43,46],[7,34,43,47],[7,34,43,48],[7,34,43,49],
 [7,34,43,55],[7,34,43,58],[7,34,43,59],[7,34,43,60],
 [7,34,43,61],[7,34,43,62],[7,34,43,66],[7,34,43,67],
 [7,34,43,68],[7,34,43,69],[7,34,44,45],[7,34,44,46],
 [7,34,44,47],[7,34,44,48],[7,34,44,49],[7,34,44,55],
 [7,34,44,58],[7,34,44,59],[7,34,44,60],[7,34,44,61],
 [7,34,44,62],[7,34,44,66],[7,34,44,67],[7,34,44,68],
 [7,34,44,69],[7,34,45,46],[7,34,45,47],[7,34,45,48],
 [7,34,45,49],[7,34,45,55],[7,34,45,58],[7,34,45,59],
 [7,34,45,60],[7,34,45,61],[7,34,45,62],[7,34,45,66],
 [7,34,45,67],[7,34,45,68],[7,34,45,69],[7,34,46,47],
 [7,34,46,48],[7,34,46,49],[7,34,46,55],[7,34,46,58],
 [7,34,46,59],[7,34,46,60],[7,34,46,61],[7,34,46,62],
 [7,34,46,66],[7,34,46,67],[7,34,46,68],[7,34,46,69],
 [7,34,47,48],[7,34,47,49],[7,34,47,55],[7,34,47,58],
 [7,34,47,59],[7,34,47,60],[7,34,47,61],[7,34,47,62],
 [7,34,47,66],[7,34,47,67],[7,34,47,68],[7,34,47,69],
 [7,34,48,49],[7,34,48,55],[7,34,48,58],[7,34,48,59],
 [7,34,48,60],[7,34,48,61],[7,34,48,62],[7,34,48,66],
 [7,34,48,67],[7,34,48,68],[7,34,48,69],[7,34,49,55],
 [7,34,49,58],[7,34,49,59],[7,34,49,60],[7,34,49,61],
 [7,34,49,62],[7,34,49,66],[7,34,49,67],[7,34,49,68],
 [7,34,49,69],[7,34,55,58],[7,34,55,59],[7,34,55,60],
 [7,34,55,61],[7,34,55,62],[7,34,55,66],[7,34,55,67],
 [7,34,55,68],[7,34,55,69],[7,34,58,59],[7,34,58,60],
 [7,34,58,61],[7,34,58,62],[7,34,58,66],[7,34,58,67],
 [7,34,58,68],[7,34,58,69],[7,34,59,60],[7,34,59,61],
 [7,34,59,62],[7,34,59,66],[7,34,59,67],[7,34,59,68],
 [7,34,59,69],[7,34,60,61],[7,34,60,62],[7,34,60,66],
 [7,34,60,67],[7,34,60,68],[7,34,60,69],[7,34,61,62],
 [7,34,61,66],[7,34,61,67],[7,34,61,68],[7,34,61,69],
 [7,34,62,66],[7,34,62,67],[7,34,62,68],[7,34,62,69],
 [7,34,66,67],[7,34,66,68],[7,34,66,69],[7,34,67,68],
 [7,34,67,69],[7,34,68,69],[7,35,37,45],[7,35,37,47],
 [7,35,37,48],[7,35,37,58],[7,35,37,62],[7,35,37,67],
 [7,35,41,45],[7,35,41,47],[7,35,41,48],[7,35,41,49],
 [7,35,41,59],[7,35,41,66],[7,35,41,67],[7,35,41,68],
 [7,35,41,69],[7,35,45,47],[7,35,45,48],[7,35,45,58],
 [7,35,45,62],[7,35,45,67],[7,35,45,68],[7,35,47,48],
 [7,35,47,49],[7,35,47,57],[7,35,47,59],[7,35,47,62],
 [7,35,47,66],[7,35,47,67],[7,35,47,68],[7,35,47,69],
 [7,35,48,49],[7,35,48,55],[7,35,48,57],[7,35,48,58],
 [7,35,48,62],[7,35,48,66],[7,35,48,67],[7,35,48,68],
 [7,35,48,69],[7,35,49,55],[7,35,49,58],[7,35,49,59],
 [7,35,49,66],[7,35,49,67],[7,35,49,68],[7,35,49,69],
 [7,35,55,58],[7,35,55,59],[7,35,55,66],[7,35,55,67],
 [7,35,55,68],[7,35,55,69],[7,35,57,58],[7,35,57,67],
 [7,35,58,59],[7,35,58,62],[7,35,58,66],[7,35,58,67],
 [7,35,58,68],[7,35,58,69],[7,35,59,62],[7,35,59,66],
 [7,35,59,67],[7,35,59,68],[7,35,59,69],[7,35,62,67],
 [7,35,62,68],[7,35,66,67],[7,35,66,68],[7,35,66,69],
 [7,35,67,68],[7,35,67,69],[7,35,68,69],[7,37,40,47],
 [7,37,40,48],[7,37,40,58],[7,37,40,67],[7,37,43,44],
 [7,37,43,45],[7,37,43,46],[7,37,43,47],[7,37,43,48],
 [7,37,43,58],[7,37,43,60],[7,37,43,61],[7,37,43,64],
 [7,37,43,67],[7,37,44,46],[7,37,44,47],[7,37,44,48],
 [7,37,44,58],[7,37,44,60],[7,37,44,61],[7,37,44,67],
 [7,37,45,46],[7,37,45,47],[7,37,45,48],[7,37,45,58],
 [7,37,45,60],[7,37,45,62],[7,37,45,67],[7,37,46,47],
 [7,37,46,48],[7,37,46,58],[7,37,46,60],[7,37,46,61],
 [7,37,46,67],[7,37,47,48],[7,37,47,58],[7,37,47,60],
 [7,37,47,61],[7,37,47,62],[7,37,47,64],[7,37,47,67],
 [7,37,48,58],[7,37,48,60],[7,37,48,61],[7,37,48,62],
 [7,37,48,64],[7,37,48,67],[7,37,58,60],[7,37,58,61],
 [7,37,58,62],[7,37,58,67],[7,37,60,61],[7,37,60,62],
 [7,37,60,67],[7,37,61,67],[7,37,62,67],[7,37,64,67],
 [7,39,41,43],[7,39,41,44],[7,39,41,45],[7,39,41,46],
 [7,39,41,47],[7,39,41,48],[7,39,41,49],[7,39,41,55],
 [7,39,41,58],[7,39,41,59],[7,39,41,60],[7,39,41,61],
 [7,39,41,62],[7,39,41,66],[7,39,41,67],[7,39,41,68],
 [7,39,41,69],[7,39,43,44],[7,39,43,45],[7,39,43,46],
 [7,39,43,47],[7,39,43,48],[7,39,43,49],[7,39,43,52],
 [7,39,43,53],[7,39,43,55],[7,39,43,58],[7,39,43,59],
 [7,39,43,60],[7,39,43,61],[7,39,43,62],[7,39,43,64],
 [7,39,43,66],[7,39,43,67],[7,39,43,68],[7,39,43,69],
 [7,39,44,45],[7,39,44,46],[7,39,44,47],[7,39,44,48],
 [7,39,44,49],[7,39,44,53],[7,39,44,55],[7,39,44,58],
 [7,39,44,59],[7,39,44,60],[7,39,44,61],[7,39,44,62],
 [7,39,44,66],[7,39,44,67],[7,39,44,68],[7,39,44,69],
 [7,39,45,46],[7,39,45,47],[7,39,45,48],[7,39,45,49],
 [7,39,45,55],[7,39,45,58],[7,39,45,59],[7,39,45,60],
 [7,39,45,61],[7,39,45,62],[7,39,45,66],[7,39,45,67],
 [7,39,45,68],[7,39,45,69],[7,39,46,47],[7,39,46,48],
 [7,39,46,49],[7,39,46,52],[7,39,46,53],[7,39,46,55],
 [7,39,46,58],[7,39,46,59],[7,39,46,60],[7,39,46,61],
 [7,39,46,62],[7,39,46,66],[7,39,46,67],[7,39,46,68],
 [7,39,46,69],[7,39,47,48],[7,39,47,49],[7,39,47,53],
 [7,39,47,55],[7,39,47,58],[7,39,47,59],[7,39,47,60],
 [7,39,47,61],[7,39,47,62],[7,39,47,66],[7,39,47,67],
 [7,39,47,68],[7,39,47,69],[7,39,48,49],[7,39,48,52],
 [7,39,48,55],[7,39,48,58],[7,39,48,59],[7,39,48,60],
 [7,39,48,61],[7,39,48,62],[7,39,48,64],[7,39,48,66],
 [7,39,48,67],[7,39,48,68],[7,39,48,69],[7,39,49,52],
 [7,39,49,53],[7,39,49,55],[7,39,49,58],[7,39,49,59],
 [7,39,49,60],[7,39,49,61],[7,39,49,62],[7,39,49,64],
 [7,39,49,66],[7,39,49,67],[7,39,49,68],[7,39,49,69],
 [7,39,52,53],[7,39,52,62],[7,39,52,67],[7,39,53,62],
 [7,39,53,67],[7,39,55,58],[7,39,55,59],[7,39,55,60],
 [7,39,55,61],[7,39,55,62],[7,39,55,66],[7,39,55,67],
 [7,39,55,68],[7,39,55,69],[7,39,58,59],[7,39,58,60],
 [7,39,58,61],[7,39,58,62],[7,39,58,66],[7,39,58,67],
 [7,39,58,68],[7,39,58,69],[7,39,59,60],[7,39,59,61],
 [7,39,59,62],[7,39,59,66],[7,39,59,67],[7,39,59,68],
 [7,39,59,69],[7,39,60,61],[7,39,60,62],[7,39,60,66],
 [7,39,60,67],[7,39,60,68],[7,39,60,69],[7,39,61,62],
 [7,39,61,66],[7,39,61,67],[7,39,61,68],[7,39,61,69],
 [7,39,62,66],[7,39,62,67],[7,39,62,68],[7,39,62,69],
 [7,39,64,66],[7,39,64,67],[7,39,64,68],[7,39,64,69],
 [7,39,66,67],[7,39,66,68],[7,39,66,69],[7,39,67,68],
 [7,39,67,69],[7,39,68,69],[7,40,41,47],[7,40,41,48],
 [7,40,41,49],[7,40,41,59],[7,40,41,64],[7,40,41,66],
 [7,40,41,67],[7,40,41,68],[7,40,41,69],[7,40,45,47],
 [7,40,45,48],[7,40,45,55],[7,40,45,58],[7,40,45,66],
 [7,40,45,67],[7,40,45,69],[7,40,47,48],[7,40,47,49],
 [7,40,47,53],[7,40,47,59],[7,40,47,64],[7,40,47,67],
 [7,40,47,68],[7,40,47,69],[7,40,48,49],[7,40,48,52],
 [7,40,48,55],[7,40,48,58],[7,40,48,64],[7,40,48,66],
 [7,40,48,67],[7,40,48,68],[7,40,48,69],[7,40,49,52],
 [7,40,49,53],[7,40,49,55],[7,40,49,58],[7,40,49,59],
 [7,40,49,64],[7,40,49,66],[7,40,49,67],[7,40,49,68],
 [7,40,49,69],[7,40,52,53],[7,40,52,67],[7,40,53,67],
 [7,40,55,58],[7,40,55,59],[7,40,55,66],[7,40,55,67],
 [7,40,55,69],[7,40,58,59],[7,40,58,66],[7,40,58,67],
 [7,40,58,68],[7,40,58,69],[7,40,59,66],[7,40,59,67],
 [7,40,59,68],[7,40,59,69],[7,40,64,66],[7,40,64,67],
 [7,40,64,68],[7,40,64,69],[7,40,66,67],[7,40,66,68],
 [7,40,66,69],[7,40,67,68],[7,40,67,69],[7,40,68,69],
 [7,41,43,44],[7,41,43,45],[7,41,43,46],[7,41,43,47],
 [7,41,43,48],[7,41,43,49],[7,41,43,55],[7,41,43,58],
 [7,41,43,59],[7,41,43,60],[7,41,43,61],[7,41,43,62],
 [7,41,43,66],[7,41,43,67],[7,41,43,68],[7,41,43,69],
 [7,41,44,45],[7,41,44,46],[7,41,44,47],[7,41,44,48],
 [7,41,44,49],[7,41,44,55],[7,41,44,58],[7,41,44,59],
 [7,41,44,60],[7,41,44,61],[7,41,44,62],[7,41,44,66],
 [7,41,44,67],[7,41,44,68],[7,41,44,69],[7,41,45,46],
 [7,41,45,47],[7,41,45,48],[7,41,45,49],[7,41,45,55],
 [7,41,45,58],[7,41,45,59],[7,41,45,60],[7,41,45,61],
 [7,41,45,62],[7,41,45,66],[7,41,45,67],[7,41,45,68],
 [7,41,45,69],[7,41,46,47],[7,41,46,48],[7,41,46,49],
 [7,41,46,55],[7,41,46,58],[7,41,46,59],[7,41,46,60],
 [7,41,46,61],[7,41,46,62],[7,41,46,66],[7,41,46,67],
 [7,41,46,68],[7,41,46,69],[7,41,47,48],[7,41,47,49],
 [7,41,47,55],[7,41,47,58],[7,41,47,59],[7,41,47,60],
 [7,41,47,61],[7,41,47,62],[7,41,47,64],[7,41,47,66],
 [7,41,47,67],[7,41,47,68],[7,41,47,69],[7,41,48,49],
 [7,41,48,55],[7,41,48,58],[7,41,48,59],[7,41,48,60],
 [7,41,48,61],[7,41,48,62],[7,41,48,64],[7,41,48,66],
 [7,41,48,67],[7,41,48,68],[7,41,48,69],[7,41,49,55],
 [7,41,49,58],[7,41,49,59],[7,41,49,60],[7,41,49,61],
 [7,41,49,62],[7,41,49,64],[7,41,49,66],[7,41,49,67],
 [7,41,49,68],[7,41,49,69],[7,41,55,58],[7,41,55,59],
 [7,41,55,60],[7,41,55,61],[7,41,55,62],[7,41,55,66],
 [7,41,55,67],[7,41,55,68],[7,41,55,69],[7,41,58,59],
 [7,41,58,60],[7,41,58,61],[7,41,58,62],[7,41,58,66],
 [7,41,58,67],[7,41,58,68],[7,41,58,69],[7,41,59,60],
 [7,41,59,61],[7,41,59,62],[7,41,59,66],[7,41,59,67],
 [7,41,59,68],[7,41,59,69],[7,41,60,61],[7,41,60,62],
 [7,41,60,66],[7,41,60,67],[7,41,60,68],[7,41,60,69],
 [7,41,61,62],[7,41,61,66],[7,41,61,67],[7,41,61,68],
 [7,41,61,69],[7,41,62,66],[7,41,62,67],[7,41,62,68],
 [7,41,62,69],[7,41,64,66],[7,41,64,67],[7,41,64,68],
 [7,41,64,69],[7,41,66,67],[7,41,66,68],[7,41,66,69],
 [7,41,67,68],[7,41,67,69],[7,41,68,69],[7,43,44,45],
 [7,43,44,46],[7,43,44,47],[7,43,44,48],[7,43,44,49],
 [7,43,44,53],[7,43,44,55],[7,43,44,57],[7,43,44,58],
 [7,43,44,59],[7,43,44,60],[7,43,44,61],[7,43,44,62],
 [7,43,44,66],[7,43,44,67],[7,43,44,68],[7,43,44,69],
 [7,43,45,46],[7,43,45,47],[7,43,45,48],[7,43,45,49],
 [7,43,45,55],[7,43,45,57],[7,43,45,58],[7,43,45,59],
 [7,43,45,60],[7,43,45,61],[7,43,45,62],[7,43,45,66],
 [7,43,45,67],[7,43,45,68],[7,43,45,69],[7,43,46,47],
 [7,43,46,48],[7,43,46,49],[7,43,46,52],[7,43,46,53],
 [7,43,46,55],[7,43,46,57],[7,43,46,58],[7,43,46,59],
 [7,43,46,60],[7,43,46,61],[7,43,46,62],[7,43,46,66],
 [7,43,46,67],[7,43,46,68],[7,43,46,69],[7,43,47,48],
 [7,43,47,49],[7,43,47,53],[7,43,47,55],[7,43,47,57],
 [7,43,47,58],[7,43,47,59],[7,43,47,60],[7,43,47,61],
 [7,43,47,62],[7,43,47,66],[7,43,47,67],[7,43,47,68],
 [7,43,47,69],[7,43,48,49],[7,43,48,52],[7,43,48,55],
 [7,43,48,57],[7,43,48,58],[7,43,48,59],[7,43,48,60],
 [7,43,48,61],[7,43,48,62],[7,43,48,64],[7,43,48,66],
 [7,43,48,67],[7,43,48,68],[7,43,48,69],[7,43,49,52],
 [7,43,49,53],[7,43,49,55],[7,43,49,58],[7,43,49,59],
 [7,43,49,60],[7,43,49,61],[7,43,49,62],[7,43,49,64],
 [7,43,49,66],[7,43,49,67],[7,43,49,68],[7,43,49,69],
 [7,43,52,53],[7,43,52,67],[7,43,53,62],[7,43,53,67],
 [7,43,55,58],[7,43,55,59],[7,43,55,60],[7,43,55,61],
 [7,43,55,62],[7,43,55,66],[7,43,55,67],[7,43,55,68],
 [7,43,55,69],[7,43,57,58],[7,43,57,60],[7,43,57,61],
 [7,43,57,67],[7,43,58,59],[7,43,58,60],[7,43,58,61],
 [7,43,58,62],[7,43,58,66],[7,43,58,67],[7,43,58,68],
 [7,43,58,69],[7,43,59,60],[7,43,59,61],[7,43,59,62],
 [7,43,59,66],[7,43,59,67],[7,43,59,68],[7,43,59,69],
 [7,43,60,61],[7,43,60,62],[7,43,60,66],[7,43,60,67],
 [7,43,60,68],[7,43,60,69],[7,43,61,62],[7,43,61,66],
 [7,43,61,67],[7,43,61,68],[7,43,61,69],[7,43,62,66],
 [7,43,62,67],[7,43,62,68],[7,43,62,69],[7,43,64,67],
 [7,43,64,69],[7,43,66,67],[7,43,66,68],[7,43,66,69],
 [7,43,67,68],[7,43,67,69],[7,43,68,69],[7,44,45,46],
 [7,44,45,47],[7,44,45,48],[7,44,45,49],[7,44,45,50],
 [7,44,45,51],[7,44,45,52],[7,44,45,55],[7,44,45,58],
 [7,44,45,59],[7,44,45,60],[7,44,45,61],[7,44,45,62],
 [7,44,45,66],[7,44,45,67],[7,44,45,68],[7,44,45,69],
 [7,44,46,47],[7,44,46,48],[7,44,46,49],[7,44,46,53],
 [7,44,46,55],[7,44,46,57],[7,44,46,58],[7,44,46,59],
 [7,44,46,60],[7,44,46,61],[7,44,46,62],[7,44,46,66],
 [7,44,46,67],[7,44,46,68],[7,44,46,69],[7,44,47,48],
 [7,44,47,49],[7,44,47,50],[7,44,47,53],[7,44,47,55],
 [7,44,47,57],[7,44,47,58],[7,44,47,59],[7,44,47,60],
 [7,44,47,61],[7,44,47,62],[7,44,47,66],[7,44,47,67],
 [7,44,47,68],[7,44,47,69],[7,44,48,49],[7,44,48,51],
 [7,44,48,52],[7,44,48,53],[7,44,48,55],[7,44,48,58],
 [7,44,48,59],[7,44,48,60],[7,44,48,61],[7,44,48,62],
 [7,44,48,66],[7,44,48,67],[7,44,48,68],[7,44,48,69],
 [7,44,49,52],[7,44,49,53],[7,44,49,55],[7,44,49,58],
 [7,44,49,59],[7,44,49,60],[7,44,49,61],[7,44,49,62],
 [7,44,49,66],[7,44,49,67],[7,44,49,68],[7,44,49,69],
 [7,44,50,51],[7,44,50,52],[7,44,50,53],[7,44,50,55],
 [7,44,50,58],[7,44,50,59],[7,44,50,60],[7,44,50,61],
 [7,44,50,62],[7,44,50,67],[7,44,50,68],[7,44,50,69],
 [7,44,51,53],[7,44,51,59],[7,44,51,61],[7,44,51,67],
 [7,44,51,68],[7,44,51,69],[7,44,52,53],[7,44,52,62],
 [7,44,52,67],[7,44,53,67],[7,44,55,58],[7,44,55,59],
 [7,44,55,60],[7,44,55,61],[7,44,55,62],[7,44,55,66],
 [7,44,55,67],[7,44,55,68],[7,44,55,69],[7,44,57,58],
 [7,44,57,60],[7,44,57,61],[7,44,57,67],[7,44,58,59],
 [7,44,58,60],[7,44,58,61],[7,44,58,62],[7,44,58,66],
 [7,44,58,67],[7,44,58,68],[7,44,58,69],[7,44,59,60],
 [7,44,59,61],[7,44,59,62],[7,44,59,66],[7,44,59,67],
 [7,44,59,68],[7,44,59,69],[7,44,60,61],[7,44,60,62],
 [7,44,60,66],[7,44,60,67],[7,44,60,68],[7,44,60,69],
 [7,44,61,62],[7,44,61,66],[7,44,61,67],[7,44,61,68],
 [7,44,61,69],[7,44,62,66],[7,44,62,67],[7,44,62,68],
 [7,44,62,69],[7,44,66,67],[7,44,66,68],[7,44,66,69],
 [7,44,67,68],[7,44,67,69],[7,44,68,69],[7,45,46,47],
 [7,45,46,48],[7,45,46,49],[7,45,46,52],[7,45,46,55],
 [7,45,46,57],[7,45,46,58],[7,45,46,59],[7,45,46,60],
 [7,45,46,61],[7,45,46,62],[7,45,46,66],[7,45,46,67],
 [7,45,46,68],[7,45,46,69],[7,45,47,48],[7,45,47,49],
 [7,45,47,50],[7,45,47,51],[7,45,47,52],[7,45,47,53],
 [7,45,47,55],[7,45,47,57],[7,45,47,58],[7,45,47,59],
 [7,45,47,60],[7,45,47,61],[7,45,47,62],[7,45,47,66],
 [7,45,47,67],[7,45,47,68],[7,45,47,69],[7,45,48,49],
 [7,45,48,50],[7,45,48,51],[7,45,48,52],[7,45,48,53],
 [7,45,48,55],[7,45,48,57],[7,45,48,58],[7,45,48,59],
 [7,45,48,60],[7,45,48,61],[7,45,48,62],[7,45,48,66],
 [7,45,48,67],[7,45,48,68],[7,45,48,69],[7,45,49,52],
 [7,45,49,55],[7,45,49,58],[7,45,49,59],[7,45,49,60],
 [7,45,49,61],[7,45,49,62],[7,45,49,66],[7,45,49,67],
 [7,45,49,68],[7,45,49,69],[7,45,50,51],[7,45,50,52],
 [7,45,50,53],[7,45,50,55],[7,45,50,58],[7,45,50,59],
 [7,45,50,60],[7,45,50,61],[7,45,50,62],[7,45,50,67],
 [7,45,50,68],[7,45,50,69],[7,45,51,52],[7,45,51,53],
 [7,45,51,55],[7,45,51,58],[7,45,51,60],[7,45,51,62],
 [7,45,51,67],[7,45,51,68],[7,45,51,69],[7,45,52,53],
 [7,45,52,62],[7,45,52,67],[7,45,53,62],[7,45,53,67],
 [7,45,55,58],[7,45,55,59],[7,45,55,60],[7,45,55,61],
 [7,45,55,62],[7,45,55,66],[7,45,55,67],[7,45,55,68],
 [7,45,55,69],[7,45,57,58],[7,45,57,60],[7,45,57,67],
 [7,45,58,59],[7,45,58,60],[7,45,58,61],[7,45,58,62],
 [7,45,58,66],[7,45,58,67],[7,45,58,68],[7,45,58,69],
 [7,45,59,60],[7,45,59,61],[7,45,59,62],[7,45,59,66],
 [7,45,59,67],[7,45,59,68],[7,45,59,69],[7,45,60,61],
 [7,45,60,62],[7,45,60,66],[7,45,60,67],[7,45,60,68],
 [7,45,60,69],[7,45,61,62],[7,45,61,66],[7,45,61,67],
 [7,45,61,68],[7,45,61,69],[7,45,62,66],[7,45,62,67],
 [7,45,62,68],[7,45,62,69],[7,45,66,67],[7,45,66,68],
 [7,45,66,69],[7,45,67,68],[7,45,67,69],[7,45,68,69],
 [7,46,47,48],[7,46,47,49],[7,46,47,53],[7,46,47,55],
 [7,46,47,57],[7,46,47,58],[7,46,47,59],[7,46,47,60],
 [7,46,47,61],[7,46,47,62],[7,46,47,66],[7,46,47,67],
 [7,46,47,68],[7,46,47,69],[7,46,48,49],[7,46,48,52],
 [7,46,48,55],[7,46,48,57],[7,46,48,58],[7,46,48,59],
 [7,46,48,60],[7,46,48,61],[7,46,48,62],[7,46,48,66],
 [7,46,48,67],[7,46,48,68],[7,46,48,69],[7,46,49,52],
 [7,46,49,53],[7,46,49,55],[7,46,49,58],[7,46,49,59],
 [7,46,49,60],[7,46,49,61],[7,46,49,62],[7,46,49,66],
 [7,46,49,67],[7,46,49,68],[7,46,49,69],[7,46,52,53],
 [7,46,52,62],[7,46,52,67],[7,46,53,62],[7,46,53,67],
 [7,46,55,58],[7,46,55,59],[7,46,55,60],[7,46,55,61],
 [7,46,55,62],[7,46,55,66],[7,46,55,67],[7,46,55,68],
 [7,46,55,69],[7,46,57,58],[7,46,57,60],[7,46,57,61],
 [7,46,57,67],[7,46,58,59],[7,46,58,60],[7,46,58,61],
 [7,46,58,62],[7,46,58,66],[7,46,58,67],[7,46,58,68],
 [7,46,58,69],[7,46,59,60],[7,46,59,61],[7,46,59,62],
 [7,46,59,66],[7,46,59,67],[7,46,59,68],[7,46,59,69],
 [7,46,60,61],[7,46,60,62],[7,46,60,66],[7,46,60,67],
 [7,46,60,68],[7,46,60,69],[7,46,61,62],[7,46,61,66],
 [7,46,61,67],[7,46,61,68],[7,46,61,69],[7,46,62,66],
 [7,46,62,67],[7,46,62,68],[7,46,62,69],[7,46,66,67],
 [7,46,66,68],[7,46,66,69],[7,46,67,68],[7,46,67,69],
 [7,46,68,69],[7,47,48,49],[7,47,48,50],[7,47,48,51],
 [7,47,48,52],[7,47,48,53],[7,47,48,55],[7,47,48,57],
 [7,47,48,58],[7,47,48,59],[7,47,48,60],[7,47,48,61],
 [7,47,48,62],[7,47,48,64],[7,47,48,66],[7,47,48,67],
 [7,47,48,68],[7,47,48,69],[7,47,49,53],[7,47,49,55],
 [7,47,49,58],[7,47,49,59],[7,47,49,60],[7,47,49,61],
 [7,47,49,62],[7,47,49,64],[7,47,49,66],[7,47,49,67],
 [7,47,49,68],[7,47,49,69],[7,47,50,51],[7,47,50,52],
 [7,47,50,53],[7,47,50,55],[7,47,50,58],[7,47,50,59],
 [7,47,50,60],[7,47,50,61],[7,47,50,62],[7,47,50,64],
 [7,47,50,67],[7,47,50,68],[7,47,50,69],[7,47,51,52],
 [7,47,51,53],[7,47,51,61],[7,47,51,62],[7,47,51,67],
 [7,47,51,69],[7,47,52,53],[7,47,52,62],[7,47,52,67],
 [7,47,53,62],[7,47,53,67],[7,47,55,58],[7,47,55,59],
 [7,47,55,60],[7,47,55,61],[7,47,55,62],[7,47,55,66],
 [7,47,55,67],[7,47,55,68],[7,47,55,69],[7,47,57,58],
 [7,47,57,60],[7,47,57,61],[7,47,57,67],[7,47,58,59],
 [7,47,58,60],[7,47,58,61],[7,47,58,62],[7,47,58,66],
 [7,47,58,67],[7,47,58,68],[7,47,58,69],[7,47,59,60],
 [7,47,59,61],[7,47,59,62],[7,47,59,66],[7,47,59,67],
 [7,47,59,68],[7,47,59,69],[7,47,60,61],[7,47,60,62],
 [7,47,60,66],[7,47,60,67],[7,47,60,68],[7,47,60,69],
 [7,47,61,62],[7,47,61,66],[7,47,61,67],[7,47,61,68],
 [7,47,61,69],[7,47,62,66],[7,47,62,67],[7,47,62,68],
 [7,47,62,69],[7,47,64,67],[7,47,64,68],[7,47,64,69],
 [7,47,66,67],[7,47,66,68],[7,47,66,69],[7,47,67,68],
 [7,47,67,69],[7,47,68,69],[7,48,49,52],[7,48,49,55],
 [7,48,49,58],[7,48,49,59],[7,48,49,60],[7,48,49,61],
 [7,48,49,62],[7,48,49,64],[7,48,49,66],[7,48,49,67],
 [7,48,49,68],[7,48,49,69],[7,48,50,51],[7,48,50,52],
 [7,48,50,53],[7,48,50,58],[7,48,50,59],[7,48,50,60],
 [7,48,50,61],[7,48,50,62],[7,48,50,64],[7,48,50,67],
 [7,48,50,68],[7,48,50,69],[7,48,51,52],[7,48,51,53],
 [7,48,51,58],[7,48,51,60],[7,48,51,62],[7,48,51,64],
 [7,48,51,67],[7,48,51,68],[7,48,52,53],[7,48,52,62],
 [7,48,52,67],[7,48,53,62],[7,48,53,67],[7,48,55,58],
 [7,48,55,59],[7,48,55,60],[7,48,55,61],[7,48,55,62],
 [7,48,55,66],[7,48,55,67],[7,48,55,68],[7,48,55,69],
 [7,48,57,58],[7,48,57,60],[7,48,57,61],[7,48,57,67],
 [7,48,58,59],[7,48,58,60],[7,48,58,61],[7,48,58,62],
 [7,48,58,66],[7,48,58,67],[7,48,58,68],[7,48,58,69],
 [7,48,59,60],[7,48,59,61],[7,48,59,62],[7,48,59,66],
 [7,48,59,67],[7,48,59,68],[7,48,59,69],[7,48,60,61],
 [7,48,60,62],[7,48,60,66],[7,48,60,67],[7,48,60,68],
 [7,48,60,69],[7,48,61,62],[7,48,61,66],[7,48,61,67],
 [7,48,61,68],[7,48,61,69],[7,48,62,66],[7,48,62,67],
 [7,48,62,68],[7,48,62,69],[7,48,64,66],[7,48,64,67],
 [7,48,64,68],[7,48,64,69],[7,48,66,67],[7,48,66,68],
 [7,48,66,69],[7,48,67,68],[7,48,67,69],[7,48,68,69],
 [7,49,52,53],[7,49,52,62],[7,49,52,67],[7,49,53,62],
 [7,49,53,67],[7,49,55,58],[7,49,55,59],[7,49,55,60],
 [7,49,55,61],[7,49,55,62],[7,49,55,66],[7,49,55,67],
 [7,49,55,68],[7,49,55,69],[7,49,58,59],[7,49,58,60],
 [7,49,58,61],[7,49,58,62],[7,49,58,66],[7,49,58,67],
 [7,49,58,68],[7,49,58,69],[7,49,59,60],[7,49,59,61],
 [7,49,59,62],[7,49,59,66],[7,49,59,67],[7,49,59,68],
 [7,49,59,69],[7,49,60,61],[7,49,60,62],[7,49,60,66],
 [7,49,60,67],[7,49,60,68],[7,49,60,69],[7,49,61,62],
 [7,49,61,66],[7,49,61,67],[7,49,61,68],[7,49,61,69],
 [7,49,62,66],[7,49,62,67],[7,49,62,68],[7,49,62,69],
 [7,49,64,66],[7,49,64,67],[7,49,64,68],[7,49,64,69],
 [7,49,66,67],[7,49,66,68],[7,49,66,69],[7,49,67,68],
 [7,49,67,69],[7,49,68,69],[7,50,51,52],[7,50,51,53],
 [7,50,51,55],[7,50,51,58],[7,50,51,59],[7,50,51,60],
 [7,50,51,61],[7,50,51,62],[7,50,51,64],[7,50,51,67],
 [7,50,51,68],[7,50,51,69],[7,50,52,53],[7,50,52,62],
 [7,50,52,67],[7,50,53,62],[7,50,53,67],[7,50,55,58],
 [7,50,55,60],[7,50,55,61],[7,50,55,62],[7,50,55,67],
 [7,50,55,68],[7,50,55,69],[7,50,58,60],[7,50,58,61],
 [7,50,58,62],[7,50,58,67],[7,50,58,68],[7,50,58,69],
 [7,50,59,60],[7,50,59,61],[7,50,59,62],[7,50,59,67],
 [7,50,59,68],[7,50,60,61],[7,50,60,62],[7,50,60,67],
 [7,50,60,68],[7,50,60,69],[7,50,61,62],[7,50,61,67],
 [7,50,61,68],[7,50,61,69],[7,50,62,67],[7,50,62,68],
 [7,50,62,69],[7,50,64,67],[7,50,64,68],[7,50,64,69],
 [7,50,67,68],[7,50,67,69],[7,50,68,69],[7,51,52,53],
 [7,51,52,62],[7,51,52,67],[7,51,53,62],[7,51,53,67],
 [7,51,55,58],[7,51,55,59],[7,51,55,60],[7,51,55,61],
 [7,51,55,62],[7,51,55,67],[7,51,55,68],[7,51,55,69],
 [7,51,58,59],[7,51,58,60],[7,51,58,61],[7,51,58,62],
 [7,51,58,67],[7,51,58,68],[7,51,58,69],[7,51,59,60],
 [7,51,59,61],[7,51,59,62],[7,51,59,67],[7,51,59,68],
 [7,51,59,69],[7,51,60,61],[7,51,60,62],[7,51,60,67],
 [7,51,60,68],[7,51,60,69],[7,51,61,62],[7,51,61,67],
 [7,51,61,68],[7,51,61,69],[7,51,62,67],[7,51,62,68],
 [7,51,62,69],[7,51,64,67],[7,51,64,68],[7,51,64,69],
 [7,51,67,68],[7,51,67,69],[7,51,68,69],[7,52,53,62],
 [7,52,53,67],[7,52,62,67],[7,53,62,67],[7,55,58,59],
 [7,55,58,60],[7,55,58,61],[7,55,58,62],[7,55,58,66],
 [7,55,58,67],[7,55,58,68],[7,55,58,69],[7,55,59,60],
 [7,55,59,61],[7,55,59,62],[7,55,59,66],[7,55,59,67],
 [7,55,59,68],[7,55,59,69],[7,55,60,61],[7,55,60,62],
 [7,55,60,66],[7,55,60,67],[7,55,60,68],[7,55,60,69],
 [7,55,61,62],[7,55,61,66],[7,55,61,67],[7,55,61,68],
 [7,55,61,69],[7,55,62,66],[7,55,62,67],[7,55,62,68],
 [7,55,62,69],[7,55,66,67],[7,55,66,68],[7,55,66,69],
 [7,55,67,68],[7,55,67,69],[7,55,68,69],[7,57,58,60],
 [7,57,58,61],[7,57,58,67],[7,57,60,61],[7,57,60,67],
 [7,57,61,67],[7,58,59,60],[7,58,59,61],[7,58,59,62],
 [7,58,59,66],[7,58,59,67],[7,58,59,68],[7,58,59,69],
 [7,58,60,61],[7,58,60,62],[7,58,60,66],[7,58,60,67],
 [7,58,60,68],[7,58,60,69],[7,58,61,62],[7,58,61,66],
 [7,58,61,67],[7,58,61,68],[7,58,61,69],[7,58,62,66],
 [7,58,62,67],[7,58,62,68],[7,58,62,69],[7,58,66,67],
 [7,58,66,68],[7,58,66,69],[7,58,67,68],[7,58,67,69],
 [7,58,68,69],[7,59,60,61],[7,59,60,62],[7,59,60,66],
 [7,59,60,67],[7,59,60,68],[7,59,60,69],[7,59,61,62],
 [7,59,61,66],[7,59,61,67],[7,59,61,68],[7,59,61,69],
 [7,59,62,66],[7,59,62,67],[7,59,62,68],[7,59,62,69],
 [7,59,66,67],[7,59,66,68],[7,59,66,69],[7,59,67,68],
 [7,59,67,69],[7,59,68,69],[7,60,61,62],[7,60,61,66],
 [7,60,61,67],[7,60,61,68],[7,60,61,69],[7,60,62,66],
 [7,60,62,67],[7,60,62,68],[7,60,62,69],[7,60,66,67],
 [7,60,66,68],[7,60,66,69],[7,60,67,68],[7,60,67,69],
 [7,60,68,69],[7,61,62,66],[7,61,62,67],[7,61,62,68],
 [7,61,62,69],[7,61,66,67],[7,61,66,68],[7,61,66,69],
 [7,61,67,68],[7,61,67,69],[7,61,68,69],[7,62,66,67],
 [7,62,66,68],[7,62,66,69],[7,62,67,68],[7,62,67,69],
 [7,62,68,69],[7,64,66,67],[7,64,66,68],[7,64,66,69],
 [7,64,67,68],[7,64,67,69],[7,64,68,69],[7,66,67,68],
 [7,66,67,69],[7,66,68,69],[7,67,68,69],[8,9,11,16],
 [8,9,11,17],[8,9,11,18],[8,9,11,21],[8,9,11,24],
 [8,9,11,25],[8,9,11,27],[8,9,11,44],[8,9,11,45],
 [8,9,11,48],[8,9,11,51],[8,9,11,53],[8,9,11,60],
 [8,9,11,62],[8,9,11,63],[8,9,11,64],[8,9,11,68],
 [8,9,15,16],[8,9,15,17],[8,9,15,18],[8,9,15,21],
 [8,9,15,24],[8,9,15,25],[8,9,15,26],[8,9,15,27],
 [8,9,15,42],[8,9,15,44],[8,9,15,45],[8,9,15,51],
 [8,9,15,55],[8,9,15,56],[8,9,15,57],[8,9,15,58],
 [8,9,15,59],[8,9,15,60],[8,9,15,61],[8,9,15,62],
 [8,9,15,63],[8,9,15,64],[8,9,15,65],[8,9,15,66],
 [8,9,15,67],[8,9,15,68],[8,9,15,69],[8,9,16,21],
 [8,9,16,24],[8,9,16,25],[8,9,16,27],[8,9,16,45],
 [8,9,16,48],[8,9,16,51],[8,9,16,53],[8,9,16,55],
 [8,9,16,58],[8,9,16,59],[8,9,16,60],[8,9,16,61],
 [8,9,16,62],[8,9,16,68],[8,9,16,69],[8,9,17,18],
 [8,9,17,24],[8,9,17,26],[8,9,17,48],[8,9,17,51],
 [8,9,17,53],[8,9,17,56],[8,9,17,57],[8,9,17,59],
 [8,9,17,61],[8,9,17,66],[8,9,17,68],[8,9,18,24],
 [8,9,18,26],[8,9,18,44],[8,9,18,48],[8,9,18,51],
 [8,9,18,53],[8,9,18,56],[8,9,18,57],[8,9,18,61],
 [8,9,18,66],[8,9,18,68],[8,9,21,24],[8,9,21,25],
 [8,9,21,27],[8,9,21,45],[8,9,21,48],[8,9,21,51],
 [8,9,21,53],[8,9,21,55],[8,9,21,59],[8,9,21,60],
 [8,9,21,61],[8,9,21,62],[8,9,21,65],[8,9,21,66],
 [8,9,21,68],[8,9,21,69],[8,9,24,25],[8,9,24,26],
 [8,9,24,27],[8,9,24,32],[8,9,24,42],[8,9,24,44],
 [8,9,24,45],[8,9,24,48],[8,9,24,51],[8,9,24,53],
 [8,9,24,55],[8,9,24,56],[8,9,24,57],[8,9,24,58],
 [8,9,24,59],[8,9,24,60],[8,9,24,61],[8,9,24,62],
 [8,9,24,63],[8,9,24,64],[8,9,24,65],[8,9,24,66],
 [8,9,24,67],[8,9,24,68],[8,9,24,69],[8,9,25,26],
 [8,9,25,27],[8,9,25,32],[8,9,25,42],[8,9,25,45],
 [8,9,25,48],[8,9,25,51],[8,9,25,53],[8,9,25,58],
 [8,9,25,59],[8,9,25,60],[8,9,25,61],[8,9,25,62],
 [8,9,25,65],[8,9,25,66],[8,9,25,67],[8,9,25,68],
 [8,9,25,69],[8,9,26,27],[8,9,26,44],[8,9,26,51],
 [8,9,26,55],[8,9,26,56],[8,9,26,57],[8,9,26,58],
 [8,9,26,59],[8,9,26,60],[8,9,26,61],[8,9,26,62],
 [8,9,26,63],[8,9,26,64],[8,9,26,65],[8,9,26,66],
 [8,9,26,67],[8,9,26,68],[8,9,26,69],[8,9,27,32],
 [8,9,27,42],[8,9,27,45],[8,9,27,48],[8,9,27,51],
 [8,9,27,53],[8,9,27,55],[8,9,27,58],[8,9,27,59],
 [8,9,27,60],[8,9,27,61],[8,9,27,62],[8,9,27,65],
 [8,9,27,67],[8,9,27,68],[8,9,27,69],[8,9,32,44],
 [8,9,32,51],[8,9,32,60],[8,9,32,61],[8,9,32,62],
 [8,9,32,63],[8,9,32,64],[8,9,32,68],[8,9,42,44],
 [8,9,42,51],[8,9,42,59],[8,9,42,60],[8,9,42,61],
 [8,9,42,62],[8,9,42,63],[8,9,42,64],[8,9,42,65],
 [8,9,42,68],[8,9,44,45],[8,9,44,48],[8,9,44,51],
 [8,9,44,53],[8,9,44,55],[8,9,44,56],[8,9,44,58],
 [8,9,44,59],[8,9,44,60],[8,9,44,61],[8,9,44,64],
 [8,9,44,65],[8,9,44,66],[8,9,44,67],[8,9,44,68],
 [8,9,44,69],[8,9,45,48],[8,9,45,51],[8,9,45,53],
 [8,9,45,55],[8,9,45,58],[8,9,45,59],[8,9,45,60],
 [8,9,45,61],[8,9,45,62],[8,9,45,66],[8,9,45,67],
 [8,9,45,68],[8,9,45,69],[8,9,48,51],[8,9,48,53],
 [8,9,48,55],[8,9,48,57],[8,9,48,60],[8,9,48,61],
 [8,9,48,62],[8,9,48,63],[8,9,48,64],[8,9,48,66],
 [8,9,48,68],[8,9,48,69],[8,9,51,53],[8,9,51,55],
 [8,9,51,56],[8,9,51,57],[8,9,51,58],[8,9,51,59],
 [8,9,51,60],[8,9,51,61],[8,9,51,62],[8,9,51,63],
 [8,9,51,64],[8,9,51,65],[8,9,51,66],[8,9,51,67],
 [8,9,51,68],[8,9,51,69],[8,9,53,60],[8,9,53,62],
 [8,9,53,63],[8,9,53,64],[8,9,53,68],[8,9,55,60],
 [8,9,55,61],[8,9,55,62],[8,9,55,66],[8,9,55,67],
 [8,9,55,68],[8,9,55,69],[8,9,56,57],[8,9,56,59],
 [8,9,56,61],[8,9,56,68],[8,9,57,59],[8,9,57,61],
 [8,9,57,68],[8,9,58,60],[8,9,58,61],[8,9,58,62],
 [8,9,58,67],[8,9,58,68],[8,9,58,69],[8,9,59,60],
 [8,9,59,61],[8,9,59,62],[8,9,59,63],[8,9,59,64],
 [8,9,59,65],[8,9,59,67],[8,9,59,68],[8,9,59,69],
 [8,9,60,61],[8,9,60,62],[8,9,60,65],[8,9,60,66],
 [8,9,60,67],[8,9,60,68],[8,9,60,69],[8,9,61,62],
 [8,9,61,63],[8,9,61,64],[8,9,61,65],[8,9,61,66],
 [8,9,61,67],[8,9,61,68],[8,9,61,69],[8,9,62,65],
 [8,9,62,66],[8,9,62,67],[8,9,62,68],[8,9,62,69],
 [8,9,63,64],[8,9,63,65],[8,9,63,66],[8,9,63,67],
 [8,9,63,68],[8,9,63,69],[8,9,64,65],[8,9,64,67],
 [8,9,64,68],[8,9,64,69],[8,9,65,68],[8,9,66,67],
 [8,9,66,68],[8,9,66,69],[8,9,67,68],[8,9,67,69],
 [8,9,68,69],[8,10,11,12],[8,10,11,16],[8,10,11,18],
 [8,10,11,21],[8,10,11,25],[8,10,11,27],[8,10,11,34],
 [8,10,11,37],[8,10,11,41],[8,10,11,45],[8,10,11,46],
 [8,10,11,48],[8,10,11,49],[8,10,11,57],[8,10,11,61],
 [8,10,11,62],[8,10,11,63],[8,10,11,68],[8,10,11,69],
 [8,10,12,16],[8,10,12,21],[8,10,12,25],[8,10,12,26],
 [8,10,12,32],[8,10,12,34],[8,10,12,42],[8,10,12,44],
 [8,10,12,45],[8,10,12,46],[8,10,12,48],[8,10,12,49],
 [8,10,12,53],[8,10,12,56],[8,10,12,58],[8,10,12,61],
 [8,10,12,62],[8,10,12,63],[8,10,12,65],[8,10,12,67],
 [8,10,12,69],[8,10,16,21],[8,10,16,25],[8,10,16,27],
 [8,10,16,34],[8,10,16,37],[8,10,16,39],[8,10,16,45],
 [8,10,16,46],[8,10,16,48],[8,10,16,49],[8,10,16,53],
 [8,10,16,57],[8,10,16,61],[8,10,16,62],[8,10,16,69],
 [8,10,18,25],[8,10,18,26],[8,10,18,39],[8,10,18,44],
 [8,10,18,46],[8,10,18,48],[8,10,18,53],[8,10,18,56],
 [8,10,18,61],[8,10,18,67],[8,10,21,25],[8,10,21,34],
 [8,10,21,37],[8,10,21,45],[8,10,21,46],[8,10,21,48],
 [8,10,21,49],[8,10,21,53],[8,10,21,59],[8,10,21,61],
 [8,10,21,62],[8,10,21,65],[8,10,21,69],[8,10,25,26],
 [8,10,25,27],[8,10,25,32],[8,10,25,34],[8,10,25,37],
 [8,10,25,39],[8,10,25,42],[8,10,25,45],[8,10,25,46],
 [8,10,25,48],[8,10,25,49],[8,10,25,53],[8,10,25,57],
 [8,10,25,59],[8,10,25,61],[8,10,25,62],[8,10,25,65],
 [8,10,25,67],[8,10,25,68],[8,10,25,69],[8,10,26,27],
 [8,10,26,34],[8,10,26,37],[8,10,26,39],[8,10,26,41],
 [8,10,26,44],[8,10,26,46],[8,10,26,49],[8,10,26,56],
 [8,10,26,57],[8,10,26,58],[8,10,26,62],[8,10,26,63],
 [8,10,26,65],[8,10,26,67],[8,10,26,68],[8,10,26,69],
 [8,10,27,32],[8,10,27,34],[8,10,27,39],[8,10,27,42],
 [8,10,27,46],[8,10,27,48],[8,10,27,53],[8,10,27,56],
 [8,10,27,58],[8,10,27,59],[8,10,27,61],[8,10,27,65],
 [8,10,27,67],[8,10,27,68],[8,10,27,69],[8,10,32,41],
 [8,10,32,44],[8,10,32,46],[8,10,32,49],[8,10,32,58],
 [8,10,32,62],[8,10,32,63],[8,10,32,68],[8,10,34,39],
 [8,10,34,41],[8,10,34,44],[8,10,34,45],[8,10,34,46],
 [8,10,34,48],[8,10,34,49],[8,10,34,56],[8,10,34,58],
 [8,10,34,59],[8,10,34,61],[8,10,34,62],[8,10,34,63],
 [8,10,34,67],[8,10,34,68],[8,10,34,69],[8,10,37,42],
 [8,10,37,44],[8,10,37,45],[8,10,37,46],[8,10,37,48],
 [8,10,37,56],[8,10,37,59],[8,10,37,61],[8,10,37,62],
 [8,10,37,63],[8,10,37,67],[8,10,39,45],[8,10,39,46],
 [8,10,39,53],[8,10,39,58],[8,10,39,63],[8,10,39,65],
 [8,10,39,67],[8,10,39,68],[8,10,39,69],[8,10,41,42],
 [8,10,41,44],[8,10,41,46],[8,10,41,48],[8,10,41,53],
 [8,10,41,59],[8,10,41,61],[8,10,41,65],[8,10,41,67],
 [8,10,41,69],[8,10,42,46],[8,10,42,49],[8,10,42,59],
 [8,10,42,62],[8,10,42,63],[8,10,42,65],[8,10,42,68],
 [8,10,44,45],[8,10,44,46],[8,10,44,48],[8,10,44,49],
 [8,10,44,59],[8,10,44,65],[8,10,44,68],[8,10,44,69],
 [8,10,45,46],[8,10,45,48],[8,10,45,49],[8,10,45,53],
 [8,10,45,58],[8,10,45,61],[8,10,45,62],[8,10,45,63],
 [8,10,45,67],[8,10,45,69],[8,10,46,48],[8,10,46,49],
 [8,10,46,53],[8,10,46,56],[8,10,46,57],[8,10,46,58],
 [8,10,46,59],[8,10,46,61],[8,10,46,62],[8,10,46,63],
 [8,10,46,65],[8,10,46,67],[8,10,46,68],[8,10,46,69],
 [8,10,48,49],[8,10,48,53],[8,10,48,57],[8,10,48,61],
 [8,10,48,62],[8,10,48,63],[8,10,48,68],[8,10,48,69],
 [8,10,49,53],[8,10,49,56],[8,10,49,58],[8,10,49,61],
 [8,10,49,62],[8,10,49,63],[8,10,49,65],[8,10,49,67],
 [8,10,49,69],[8,10,53,56],[8,10,53,58],[8,10,53,62],
 [8,10,53,63],[8,10,53,68],[8,10,56,57],[8,10,56,59],
 [8,10,56,62],[8,10,56,68],[8,10,56,69],[8,10,57,58],
 [8,10,57,59],[8,10,57,61],[8,10,57,67],[8,10,57,68],
 [8,10,58,62],[8,10,58,65],[8,10,58,67],[8,10,58,68],
 [8,10,58,69],[8,10,59,65],[8,10,59,67],[8,10,59,68],
 [8,10,59,69],[8,10,61,62],[8,10,61,63],[8,10,61,68],
 [8,10,61,69],[8,10,62,63],[8,10,62,65],[8,10,62,67],
 [8,10,62,69],[8,10,63,65],[8,10,63,67],[8,10,63,68],
 [8,10,63,69],[8,10,65,68],[8,10,67,68],[8,10,67,69],
 [8,10,68,69],[8,11,12,16],[8,11,12,17],[8,11,12,21],
 [8,11,12,24],[8,11,12,25],[8,11,12,31],[8,11,12,34],
 [8,11,12,35],[8,11,12,40],[8,11,12,43],[8,11,12,44],
 [8,11,12,45],[8,11,12,46],[8,11,12,48],[8,11,12,49],
 [8,11,12,55],[8,11,12,60],[8,11,12,61],[8,11,12,62],
 [8,11,12,63],[8,11,12,64],[8,11,12,69],[8,11,16,21],
 [8,11,16,24],[8,11,16,25],[8,11,16,27],[8,11,16,30],
 [8,11,16,34],[8,11,16,35],[8,11,16,37],[8,11,16,40],
 [8,11,16,43],[8,11,16,45],[8,11,16,46],[8,11,16,48],
 [8,11,16,49],[8,11,16,50],[8,11,16,51],[8,11,16,52],
 [8,11,16,53],[8,11,16,57],[8,11,16,60],[8,11,16,61],
 [8,11,16,62],[8,11,16,68],[8,11,16,69],[8,11,17,18],
 [8,11,17,24],[8,11,17,27],[8,11,17,37],[8,11,17,48],
 [8,11,17,49],[8,11,17,50],[8,11,17,51],[8,11,17,53],
 [8,11,17,55],[8,11,17,57],[8,11,17,62],[8,11,17,68],
 [8,11,17,69],[8,11,18,21],[8,11,18,24],[8,11,18,25],
 [8,11,18,35],[8,11,18,44],[8,11,18,46],[8,11,18,48],
 [8,11,18,51],[8,11,18,52],[8,11,18,53],[8,11,18,55],
 [8,11,18,60],[8,11,18,61],[8,11,18,68],[8,11,21,24],
 [8,11,21,25],[8,11,21,27],[8,11,21,31],[8,11,21,34],
 [8,11,21,35],[8,11,21,37],[8,11,21,43],[8,11,21,45],
 [8,11,21,46],[8,11,21,48],[8,11,21,49],[8,11,21,50],
 [8,11,21,51],[8,11,21,52],[8,11,21,53],[8,11,21,55],
 [8,11,21,57],[8,11,21,60],[8,11,21,61],[8,11,21,62],
 [8,11,21,64],[8,11,21,68],[8,11,21,69],[8,11,24,25],
 [8,11,24,27],[8,11,24,37],[8,11,24,41],[8,11,24,44],
 [8,11,24,45],[8,11,24,48],[8,11,24,49],[8,11,24,51],
 [8,11,24,52],[8,11,24,53],[8,11,24,55],[8,11,24,57],
 [8,11,24,60],[8,11,24,62],[8,11,24,63],[8,11,24,64],
 [8,11,24,66],[8,11,24,68],[8,11,24,69],[8,11,25,27],
 [8,11,25,31],[8,11,25,34],[8,11,25,35],[8,11,25,37],
 [8,11,25,40],[8,11,25,43],[8,11,25,45],[8,11,25,46],
 [8,11,25,48],[8,11,25,49],[8,11,25,50],[8,11,25,51],
 [8,11,25,52],[8,11,25,53],[8,11,25,57],[8,11,25,60],
 [8,11,25,61],[8,11,25,62],[8,11,25,64],[8,11,25,68],
 [8,11,25,69],[8,11,27,31],[8,11,27,35],[8,11,27,40],
 [8,11,27,45],[8,11,27,46],[8,11,27,48],[8,11,27,51],
 [8,11,27,52],[8,11,27,53],[8,11,27,55],[8,11,27,60],
 [8,11,27,61],[8,11,27,62],[8,11,27,64],[8,11,27,68],
 [8,11,30,35],[8,11,30,44],[8,11,30,45],[8,11,30,48],
 [8,11,30,49],[8,11,30,53],[8,11,30,61],[8,11,30,62],
 [8,11,30,68],[8,11,31,37],[8,11,31,41],[8,11,31,48],
 [8,11,31,49],[8,11,31,53],[8,11,31,63],[8,11,31,66],
 [8,11,31,68],[8,11,31,69],[8,11,34,44],[8,11,34,45],
 [8,11,34,46],[8,11,34,48],[8,11,34,49],[8,11,34,61],
 [8,11,34,62],[8,11,34,63],[8,11,34,69],[8,11,35,37],
 [8,11,35,41],[8,11,35,45],[8,11,35,48],[8,11,35,49],
 [8,11,35,57],[8,11,35,62],[8,11,35,63],[8,11,35,68],
 [8,11,35,69],[8,11,37,40],[8,11,37,43],[8,11,37,45],
 [8,11,37,46],[8,11,37,48],[8,11,37,60],[8,11,37,61],
 [8,11,37,62],[8,11,37,64],[8,11,40,41],[8,11,40,45],
 [8,11,40,48],[8,11,40,49],[8,11,40,52],[8,11,40,53],
 [8,11,40,55],[8,11,40,63],[8,11,40,64],[8,11,40,66],
 [8,11,40,68],[8,11,40,69],[8,11,41,43],[8,11,41,44],
 [8,11,41,46],[8,11,41,48],[8,11,41,53],[8,11,41,60],
 [8,11,41,61],[8,11,41,62],[8,11,41,64],[8,11,43,48],
 [8,11,43,49],[8,11,43,52],[8,11,43,53],[8,11,43,55],
 [8,11,43,57],[8,11,43,60],[8,11,43,62],[8,11,43,64],
 [8,11,43,66],[8,11,43,68],[8,11,43,69],[8,11,44,45],
 [8,11,44,46],[8,11,44,48],[8,11,44,49],[8,11,44,51],
 [8,11,44,53],[8,11,44,55],[8,11,44,64],[8,11,44,66],
 [8,11,44,68],[8,11,44,69],[8,11,45,46],[8,11,45,48],
 [8,11,45,49],[8,11,45,50],[8,11,45,51],[8,11,45,52],
 [8,11,45,53],[8,11,45,55],[8,11,45,57],[8,11,45,60],
 [8,11,45,61],[8,11,45,62],[8,11,45,63],[8,11,45,66],
 [8,11,45,68],[8,11,45,69],[8,11,46,48],[8,11,46,49],
 [8,11,46,53],[8,11,46,57],[8,11,46,61],[8,11,46,62],
 [8,11,46,63],[8,11,46,68],[8,11,46,69],[8,11,48,49],
 [8,11,48,50],[8,11,48,51],[8,11,48,52],[8,11,48,53],
 [8,11,48,55],[8,11,48,57],[8,11,48,60],[8,11,48,61],
 [8,11,48,62],[8,11,48,63],[8,11,48,64],[8,11,48,66],
 [8,11,48,68],[8,11,48,69],[8,11,49,53],[8,11,49,55],
 [8,11,49,60],[8,11,49,61],[8,11,49,62],[8,11,49,63],
 [8,11,49,64],[8,11,49,69],[8,11,50,52],[8,11,50,55],
 [8,11,50,60],[8,11,50,62],[8,11,50,64],[8,11,50,68],
 [8,11,51,53],[8,11,51,55],[8,11,51,57],[8,11,51,60],
 [8,11,51,61],[8,11,51,62],[8,11,51,63],[8,11,51,64],
 [8,11,51,66],[8,11,51,68],[8,11,51,69],[8,11,52,62],
 [8,11,52,63],[8,11,53,60],[8,11,53,62],[8,11,53,63],
 [8,11,53,64],[8,11,53,68],[8,11,55,60],[8,11,55,61],
 [8,11,55,62],[8,11,55,66],[8,11,55,69],[8,11,57,60],
 [8,11,57,61],[8,11,60,62],[8,11,60,63],[8,11,60,66],
 [8,11,60,68],[8,11,60,69],[8,11,61,62],[8,11,61,63],
 [8,11,61,66],[8,11,61,68],[8,11,61,69],[8,11,62,63],
 [8,11,62,66],[8,11,62,68],[8,11,62,69],[8,11,63,64],
 [8,11,63,68],[8,11,63,69],[8,11,64,68],[8,11,64,69],
 [8,12,15,16],[8,12,15,17],[8,12,15,21],[8,12,15,24],
 [8,12,15,25],[8,12,15,26],[8,12,15,44],[8,12,15,45],
 [8,12,15,49],[8,12,15,55],[8,12,15,56],[8,12,15,60],
 [8,12,15,61],[8,12,15,63],[8,12,15,64],[8,12,15,65],
 [8,12,15,67],[8,12,16,21],[8,12,16,24],[8,12,16,25],
 [8,12,16,30],[8,12,16,34],[8,12,16,35],[8,12,16,45],
 [8,12,16,46],[8,12,16,48],[8,12,16,49],[8,12,16,53],
 [8,12,16,55],[8,12,16,56],[8,12,16,61],[8,12,16,62],
 [8,12,16,69],[8,12,17,24],[8,12,17,26],[8,12,17,30],
 [8,12,17,35],[8,12,17,48],[8,12,17,49],[8,12,17,53],
 [8,12,17,55],[8,12,17,56],[8,12,17,58],[8,12,17,61],
 [8,12,17,69],[8,12,21,24],[8,12,21,25],[8,12,21,34],
 [8,12,21,35],[8,12,21,43],[8,12,21,45],[8,12,21,46],
 [8,12,21,48],[8,12,21,49],[8,12,21,53],[8,12,21,55],
 [8,12,21,60],[8,12,21,61],[8,12,21,62],[8,12,21,64],
 [8,12,21,65],[8,12,21,69],[8,12,24,25],[8,12,24,26],
 [8,12,24,32],[8,12,24,42],[8,12,24,44],[8,12,24,45],
 [8,12,24,48],[8,12,24,49],[8,12,24,53],[8,12,24,55],
 [8,12,24,56],[8,12,24,58],[8,12,24,60],[8,12,24,61],
 [8,12,24,63],[8,12,24,64],[8,12,24,65],[8,12,24,67],
 [8,12,24,69],[8,12,25,26],[8,12,25,31],[8,12,25,32],
 [8,12,25,34],[8,12,25,35],[8,12,25,40],[8,12,25,42],
 [8,12,25,43],[8,12,25,45],[8,12,25,46],[8,12,25,48],
 [8,12,25,49],[8,12,25,53],[8,12,25,60],[8,12,25,61],
 [8,12,25,62],[8,12,25,64],[8,12,25,65],[8,12,25,67],
 [8,12,25,69],[8,12,26,31],[8,12,26,35],[8,12,26,40],
 [8,12,26,43],[8,12,26,44],[8,12,26,46],[8,12,26,49],
 [8,12,26,55],[8,12,26,56],[8,12,26,58],[8,12,26,60],
 [8,12,26,61],[8,12,26,62],[8,12,26,63],[8,12,26,64],
 [8,12,26,65],[8,12,26,67],[8,12,30,35],[8,12,30,44],
 [8,12,30,45],[8,12,30,48],[8,12,30,49],[8,12,30,53],
 [8,12,30,61],[8,12,30,62],[8,12,31,32],[8,12,31,42],
 [8,12,31,48],[8,12,31,49],[8,12,31,53],[8,12,31,61],
 [8,12,31,63],[8,12,31,65],[8,12,31,67],[8,12,31,69],
 [8,12,32,35],[8,12,32,40],[8,12,32,44],[8,12,32,46],
 [8,12,32,49],[8,12,32,60],[8,12,32,61],[8,12,32,62],
 [8,12,32,63],[8,12,32,64],[8,12,34,44],[8,12,34,45],
 [8,12,34,46],[8,12,34,48],[8,12,34,49],[8,12,34,61],
 [8,12,34,62],[8,12,34,63],[8,12,34,69],[8,12,35,42],
 [8,12,35,45],[8,12,35,48],[8,12,35,49],[8,12,35,58],
 [8,12,35,62],[8,12,35,63],[8,12,35,65],[8,12,35,67],
 [8,12,35,69],[8,12,40,42],[8,12,40,44],[8,12,40,48],
 [8,12,40,49],[8,12,40,53],[8,12,40,55],[8,12,40,58],
 [8,12,40,61],[8,12,40,63],[8,12,40,65],[8,12,40,67],
 [8,12,40,69],[8,12,42,43],[8,12,42,44],[8,12,42,46],
 [8,12,42,49],[8,12,42,60],[8,12,42,61],[8,12,42,62],
 [8,12,42,63],[8,12,42,64],[8,12,43,44],[8,12,43,48],
 [8,12,43,49],[8,12,43,53],[8,12,43,55],[8,12,43,56],
 [8,12,43,58],[8,12,43,60],[8,12,43,61],[8,12,43,67],
 [8,12,43,69],[8,12,44,46],[8,12,44,49],[8,12,44,53],
 [8,12,44,55],[8,12,44,58],[8,12,44,60],[8,12,44,61],
 [8,12,44,64],[8,12,44,65],[8,12,44,67],[8,12,44,69],
 [8,12,45,46],[8,12,45,48],[8,12,45,49],[8,12,45,53],
 [8,12,45,55],[8,12,45,58],[8,12,45,61],[8,12,45,62],
 [8,12,45,67],[8,12,45,69],[8,12,46,48],[8,12,46,49],
 [8,12,46,53],[8,12,46,56],[8,12,46,58],[8,12,46,61],
 [8,12,46,62],[8,12,46,63],[8,12,46,65],[8,12,46,67],
 [8,12,46,69],[8,12,48,49],[8,12,48,53],[8,12,48,55],
 [8,12,48,60],[8,12,48,61],[8,12,48,62],[8,12,48,63],
 [8,12,48,64],[8,12,48,69],[8,12,49,53],[8,12,49,55],
 [8,12,49,56],[8,12,49,58],[8,12,49,60],[8,12,49,61],
 [8,12,49,62],[8,12,49,63],[8,12,49,64],[8,12,49,65],
 [8,12,49,67],[8,12,49,69],[8,12,53,60],[8,12,53,62],
 [8,12,53,63],[8,12,53,64],[8,12,55,60],[8,12,55,61],
 [8,12,55,62],[8,12,55,69],[8,12,56,61],[8,12,56,62],
 [8,12,58,60],[8,12,58,61],[8,12,58,62],[8,12,58,67],
 [8,12,60,61],[8,12,60,63],[8,12,60,65],[8,12,60,67],
 [8,12,60,69],[8,12,61,62],[8,12,61,63],[8,12,61,64],
 [8,12,61,65],[8,12,61,67],[8,12,61,69],[8,12,62,63],
 [8,12,62,65],[8,12,62,67],[8,12,62,69],[8,12,63,64],
 [8,12,63,65],[8,12,63,67],[8,12,63,69],[8,12,64,65],
 [8,12,64,67],[8,12,64,69],[8,15,16,21],[8,15,16,24],
 [8,15,16,25],[8,15,16,27],[8,15,16,45],[8,15,16,49],
 [8,15,16,51],[8,15,16,55],[8,15,16,58],[8,15,16,59],
 [8,15,16,60],[8,15,16,61],[8,15,16,62],[8,15,16,68],
 [8,15,16,69],[8,15,17,18],[8,15,17,22],[8,15,17,24],
 [8,15,17,26],[8,15,17,27],[8,15,17,37],[8,15,17,49],
 [8,15,17,51],[8,15,17,53],[8,15,17,56],[8,15,17,57],
 [8,15,17,59],[8,15,17,61],[8,15,17,62],[8,15,17,66],
 [8,15,17,68],[8,15,17,69],[8,15,18,21],[8,15,18,22],
 [8,15,18,24],[8,15,18,25],[8,15,18,26],[8,15,18,44],
 [8,15,18,51],[8,15,18,52],[8,15,18,56],[8,15,18,57],
 [8,15,18,60],[8,15,18,61],[8,15,18,67],[8,15,18,68],
 [8,15,21,22],[8,15,21,24],[8,15,21,25],[8,15,21,27],
 [8,15,21,37],[8,15,21,45],[8,15,21,49],[8,15,21,55],
 [8,15,21,57],[8,15,21,59],[8,15,21,60],[8,15,21,61],
 [8,15,21,62],[8,15,21,65],[8,15,21,66],[8,15,21,68],
 [8,15,21,69],[8,15,22,24],[8,15,22,25],[8,15,22,26],
 [8,15,22,27],[8,15,22,44],[8,15,22,57],[8,15,22,58],
 [8,15,22,60],[8,15,22,61],[8,15,22,62],[8,15,22,63],
 [8,15,22,64],[8,15,22,65],[8,15,22,66],[8,15,22,67],
 [8,15,22,69],[8,15,24,25],[8,15,24,26],[8,15,24,27],
 [8,15,24,37],[8,15,24,41],[8,15,24,42],[8,15,24,44],
 [8,15,24,45],[8,15,24,49],[8,15,24,51],[8,15,24,52],
 [8,15,24,55],[8,15,24,56],[8,15,24,57],[8,15,24,58],
 [8,15,24,59],[8,15,24,60],[8,15,24,61],[8,15,24,62],
 [8,15,24,63],[8,15,24,64],[8,15,24,65],[8,15,24,66],
 [8,15,24,67],[8,15,24,68],[8,15,24,69],[8,15,25,26],
 [8,15,25,27],[8,15,25,37],[8,15,25,45],[8,15,25,49],
 [8,15,25,51],[8,15,25,53],[8,15,25,57],[8,15,25,58],
 [8,15,25,59],[8,15,25,60],[8,15,25,61],[8,15,25,62],
 [8,15,25,65],[8,15,25,66],[8,15,25,67],[8,15,25,68],
 [8,15,25,69],[8,15,26,27],[8,15,26,37],[8,15,26,41],
 [8,15,26,44],[8,15,26,49],[8,15,26,51],[8,15,26,52],
 [8,15,26,55],[8,15,26,56],[8,15,26,57],[8,15,26,58],
 [8,15,26,59],[8,15,26,60],[8,15,26,61],[8,15,26,62],
 [8,15,26,63],[8,15,26,64],[8,15,26,65],[8,15,26,66],
 [8,15,26,67],[8,15,26,68],[8,15,26,69],[8,15,27,42],
 [8,15,27,45],[8,15,27,51],[8,15,27,52],[8,15,27,55],
 [8,15,27,56],[8,15,27,58],[8,15,27,59],[8,15,27,60],
 [8,15,27,61],[8,15,27,62],[8,15,27,64],[8,15,27,67],
 [8,15,27,68],[8,15,27,69],[8,15,37,42],[8,15,37,44],
 [8,15,37,56],[8,15,37,59],[8,15,37,60],[8,15,37,61],
 [8,15,37,63],[8,15,37,67],[8,15,41,42],[8,15,41,44],
 [8,15,41,53],[8,15,41,59],[8,15,41,60],[8,15,41,61],
 [8,15,41,62],[8,15,41,64],[8,15,41,65],[8,15,41,67],
 [8,15,41,69],[8,15,42,44],[8,15,42,49],[8,15,42,52],
 [8,15,42,55],[8,15,42,59],[8,15,42,61],[8,15,42,62],
 [8,15,42,63],[8,15,42,64],[8,15,42,65],[8,15,42,68],
 [8,15,44,45],[8,15,44,49],[8,15,44,51],[8,15,44,53],
 [8,15,44,55],[8,15,44,56],[8,15,44,58],[8,15,44,59],
 [8,15,44,60],[8,15,44,61],[8,15,44,64],[8,15,44,65],
 [8,15,44,66],[8,15,44,67],[8,15,44,68],[8,15,44,69],
 [8,15,45,49],[8,15,45,51],[8,15,45,52],[8,15,45,55],
 [8,15,45,58],[8,15,45,59],[8,15,45,60],[8,15,45,61],
 [8,15,45,62],[8,15,45,66],[8,15,45,67],[8,15,45,68],
 [8,15,45,69],[8,15,49,53],[8,15,49,55],[8,15,49,56],
 [8,15,49,58],[8,15,49,60],[8,15,49,61],[8,15,49,62],
 [8,15,49,63],[8,15,49,64],[8,15,49,65],[8,15,49,67],
 [8,15,49,69],[8,15,51,53],[8,15,51,55],[8,15,51,56],
 [8,15,51,57],[8,15,51,58],[8,15,51,59],[8,15,51,60],
 [8,15,51,61],[8,15,51,62],[8,15,51,63],[8,15,51,64],
 [8,15,51,65],[8,15,51,66],[8,15,51,67],[8,15,51,68],
 [8,15,51,69],[8,15,52,53],[8,15,52,57],[8,15,52,61],
 [8,15,52,62],[8,15,52,66],[8,15,52,67],[8,15,52,69],
 [8,15,53,56],[8,15,53,58],[8,15,53,60],[8,15,53,67],
 [8,15,53,68],[8,15,55,60],[8,15,55,61],[8,15,55,62],
 [8,15,55,66],[8,15,55,67],[8,15,55,68],[8,15,55,69],
 [8,15,56,57],[8,15,56,59],[8,15,56,61],[8,15,56,62],
 [8,15,56,66],[8,15,56,68],[8,15,56,69],[8,15,57,59],
 [8,15,57,60],[8,15,57,61],[8,15,57,67],[8,15,57,68],
 [8,15,58,60],[8,15,58,61],[8,15,58,62],[8,15,58,67],
 [8,15,58,68],[8,15,58,69],[8,15,59,60],[8,15,59,61],
 [8,15,59,62],[8,15,59,63],[8,15,59,64],[8,15,59,65],
 [8,15,59,67],[8,15,59,68],[8,15,59,69],[8,15,60,61],
 [8,15,60,62],[8,15,60,65],[8,15,60,66],[8,15,60,67],
 [8,15,60,68],[8,15,60,69],[8,15,61,62],[8,15,61,63],
 [8,15,61,64],[8,15,61,65],[8,15,61,66],[8,15,61,67],
 [8,15,61,68],[8,15,61,69],[8,15,62,63],[8,15,62,66],
 [8,15,62,67],[8,15,62,68],[8,15,62,69],[8,15,63,64],
 [8,15,63,65],[8,15,63,66],[8,15,63,68],[8,15,63,69],
 [8,15,64,65],[8,15,64,67],[8,15,64,68],[8,15,65,68],
 [8,15,66,67],[8,15,66,68],[8,15,66,69],[8,15,67,68],
 [8,15,67,69],[8,15,68,69],[8,16,21,24],[8,16,21,25],
 [8,16,21,27],[8,16,21,30],[8,16,21,34],[8,16,21,35],
 [8,16,21,37],[8,16,21,43],[8,16,21,45],[8,16,21,46],
 [8,16,21,48],[8,16,21,49],[8,16,21,50],[8,16,21,51],
 [8,16,21,52],[8,16,21,53],[8,16,21,55],[8,16,21,57],
 [8,16,21,59],[8,16,21,60],[8,16,21,61],[8,16,21,62],
 [8,16,21,68],[8,16,21,69],[8,16,24,25],[8,16,24,27],
 [8,16,24,37],[8,16,24,45],[8,16,24,48],[8,16,24,49],
 [8,16,24,51],[8,16,24,53],[8,16,24,55],[8,16,24,58],
 [8,16,24,59],[8,16,24,60],[8,16,24,61],[8,16,24,62],
 [8,16,24,68],[8,16,24,69],[8,16,25,27],[8,16,25,34],
 [8,16,25,35],[8,16,25,37],[8,16,25,39],[8,16,25,40],
 [8,16,25,43],[8,16,25,45],[8,16,25,46],[8,16,25,48],
 [8,16,25,49],[8,16,25,50],[8,16,25,51],[8,16,25,52],
 [8,16,25,53],[8,16,25,57],[8,16,25,58],[8,16,25,59],
 [8,16,25,60],[8,16,25,61],[8,16,25,62],[8,16,25,68],
 [8,16,25,69],[8,16,27,30],[8,16,27,34],[8,16,27,35],
 [8,16,27,39],[8,16,27,40],[8,16,27,43],[8,16,27,45],
 [8,16,27,46],[8,16,27,48],[8,16,27,51],[8,16,27,52],
 [8,16,27,53],[8,16,27,55],[8,16,27,56],[8,16,27,58],
 [8,16,27,59],[8,16,27,60],[8,16,27,61],[8,16,27,62],
 [8,16,27,68],[8,16,27,69],[8,16,30,45],[8,16,30,48],
 [8,16,30,49],[8,16,30,58],[8,16,30,62],[8,16,30,68],
 [8,16,34,39],[8,16,34,45],[8,16,34,46],[8,16,34,48],
 [8,16,34,49],[8,16,34,56],[8,16,34,58],[8,16,34,59],
 [8,16,34,61],[8,16,34,62],[8,16,34,68],[8,16,34,69],
 [8,16,35,37],[8,16,35,45],[8,16,35,48],[8,16,35,59],
 [8,16,35,62],[8,16,35,68],[8,16,37,40],[8,16,37,43],
 [8,16,37,45],[8,16,37,48],[8,16,37,56],[8,16,37,59],
 [8,16,37,60],[8,16,37,62],[8,16,39,43],[8,16,39,45],
 [8,16,39,46],[8,16,39,52],[8,16,39,53],[8,16,39,58],
 [8,16,39,60],[8,16,39,61],[8,16,39,68],[8,16,39,69],
 [8,16,40,45],[8,16,40,48],[8,16,40,49],[8,16,40,53],
 [8,16,40,55],[8,16,40,58],[8,16,40,61],[8,16,40,69],
 [8,16,43,45],[8,16,43,48],[8,16,43,49],[8,16,43,53],
 [8,16,43,55],[8,16,43,56],[8,16,43,57],[8,16,43,58],
 [8,16,43,59],[8,16,43,60],[8,16,43,61],[8,16,43,62],
 [8,16,43,68],[8,16,43,69],[8,16,45,46],[8,16,45,48],
 [8,16,45,49],[8,16,45,50],[8,16,45,51],[8,16,45,52],
 [8,16,45,53],[8,16,45,55],[8,16,45,57],[8,16,45,58],
 [8,16,45,59],[8,16,45,60],[8,16,45,61],[8,16,45,62],
 [8,16,45,68],[8,16,45,69],[8,16,46,48],[8,16,46,49],
 [8,16,46,56],[8,16,46,57],[8,16,46,58],[8,16,46,59],
 [8,16,46,61],[8,16,46,62],[8,16,46,68],[8,16,46,69],
 [8,16,48,49],[8,16,48,50],[8,16,48,51],[8,16,48,52],
 [8,16,48,53],[8,16,48,55],[8,16,48,57],[8,16,48,60],
 [8,16,48,61],[8,16,48,62],[8,16,48,68],[8,16,48,69],
 [8,16,49,55],[8,16,49,56],[8,16,49,58],[8,16,49,60],
 [8,16,49,61],[8,16,49,62],[8,16,49,69],[8,16,50,52],
 [8,16,50,53],[8,16,50,59],[8,16,50,61],[8,16,50,62],
 [8,16,50,68],[8,16,50,69],[8,16,51,53],[8,16,51,55],
 [8,16,51,56],[8,16,51,57],[8,16,51,58],[8,16,51,59],
 [8,16,51,60],[8,16,51,61],[8,16,51,62],[8,16,51,68],
 [8,16,52,53],[8,16,52,57],[8,16,52,61],[8,16,52,62],
 [8,16,52,69],[8,16,53,56],[8,16,53,58],[8,16,53,60],
 [8,16,53,62],[8,16,53,68],[8,16,55,60],[8,16,55,61],
 [8,16,55,62],[8,16,55,68],[8,16,55,69],[8,16,56,57],
 [8,16,56,59],[8,16,56,61],[8,16,56,62],[8,16,56,68],
 [8,16,56,69],[8,16,57,58],[8,16,57,59],[8,16,57,60],
 [8,16,57,68],[8,16,58,60],[8,16,58,61],[8,16,58,62],
 [8,16,58,68],[8,16,58,69],[8,16,59,60],[8,16,59,61],
 [8,16,59,62],[8,16,59,68],[8,16,59,69],[8,16,60,61],
 [8,16,60,62],[8,16,60,68],[8,16,60,69],[8,16,61,62],
 [8,16,61,68],[8,16,61,69],[8,16,62,68],[8,16,62,69],
 [8,16,68,69],[8,17,18,22],[8,17,18,24],[8,17,18,26],
 [8,17,18,30],[8,17,18,35],[8,17,18,39],[8,17,18,48],
 [8,17,18,50],[8,17,18,51],[8,17,18,53],[8,17,18,55],
 [8,17,18,56],[8,17,18,57],[8,17,18,61],[8,17,18,66],
 [8,17,18,68],[8,17,22,24],[8,17,22,26],[8,17,22,35],
 [8,17,22,50],[8,17,22,53],[8,17,22,57],[8,17,22,58],
 [8,17,22,61],[8,17,22,62],[8,17,24,26],[8,17,24,27],
 [8,17,24,37],[8,17,24,45],[8,17,24,48],[8,17,24,49],
 [8,17,24,51],[8,17,24,53],[8,17,24,56],[8,17,24,57],
 [8,17,24,59],[8,17,24,61],[8,17,24,62],[8,17,24,66],
 [8,17,24,68],[8,17,24,69],[8,17,26,27],[8,17,26,30],
 [8,17,26,35],[8,17,26,37],[8,17,26,39],[8,17,26,49],
 [8,17,26,50],[8,17,26,51],[8,17,26,53],[8,17,26,55],
 [8,17,26,56],[8,17,26,57],[8,17,26,58],[8,17,26,59],
 [8,17,26,61],[8,17,26,62],[8,17,26,68],[8,17,26,69],
 [8,17,27,30],[8,17,27,35],[8,17,27,39],[8,17,27,48],
 [8,17,27,51],[8,17,27,53],[8,17,27,55],[8,17,27,56],
 [8,17,27,58],[8,17,27,59],[8,17,27,61],[8,17,27,62],
 [8,17,27,69],[8,17,30,35],[8,17,30,45],[8,17,30,48],
 [8,17,30,49],[8,17,30,53],[8,17,30,58],[8,17,30,61],
 [8,17,30,62],[8,17,30,68],[8,17,35,37],[8,17,35,45],
 [8,17,35,48],[8,17,35,49],[8,17,35,57],[8,17,35,59],
 [8,17,35,62],[8,17,35,68],[8,17,35,69],[8,17,37,45],
 [8,17,37,48],[8,17,37,56],[8,17,37,59],[8,17,37,61],
 [8,17,37,62],[8,17,39,45],[8,17,39,53],[8,17,39,58],
 [8,17,39,68],[8,17,39,69],[8,17,45,48],[8,17,45,49],
 [8,17,45,50],[8,17,45,51],[8,17,45,53],[8,17,45,55],
 [8,17,45,58],[8,17,45,61],[8,17,45,62],[8,17,45,66],
 [8,17,45,69],[8,17,48,49],[8,17,48,50],[8,17,48,51],
 [8,17,48,53],[8,17,48,55],[8,17,48,57],[8,17,48,61],
 [8,17,48,62],[8,17,48,66],[8,17,48,68],[8,17,48,69],
 [8,17,49,53],[8,17,49,55],[8,17,49,56],[8,17,49,58],
 [8,17,49,61],[8,17,49,62],[8,17,49,69],[8,17,50,53],
 [8,17,50,59],[8,17,50,61],[8,17,50,62],[8,17,50,66],
 [8,17,50,68],[8,17,50,69],[8,17,51,53],[8,17,51,55],
 [8,17,51,56],[8,17,51,57],[8,17,51,58],[8,17,51,59],
 [8,17,51,61],[8,17,51,62],[8,17,51,66],[8,17,51,68],
 [8,17,51,69],[8,17,53,56],[8,17,53,58],[8,17,53,62],
 [8,17,53,68],[8,17,55,62],[8,17,55,66],[8,17,55,68],
 [8,17,55,69],[8,17,56,57],[8,17,56,59],[8,17,56,61],
 [8,17,56,62],[8,17,56,66],[8,17,56,68],[8,17,56,69],
 [8,17,57,58],[8,17,57,59],[8,17,57,61],[8,17,57,68],
 [8,17,58,62],[8,17,58,69],[8,17,59,61],[8,17,59,68],
 [8,17,59,69],[8,17,61,62],[8,17,61,68],[8,17,61,69],
 [8,17,62,66],[8,17,62,69],[8,17,66,68],[8,17,66,69],
 [8,18,21,22],[8,18,21,24],[8,18,21,25],[8,18,21,30],
 [8,18,21,35],[8,18,21,43],[8,18,21,46],[8,18,21,48],
 [8,18,21,51],[8,18,21,52],[8,18,21,53],[8,18,21,55],
 [8,18,21,57],[8,18,21,60],[8,18,21,66],[8,18,22,24],
 [8,18,22,25],[8,18,22,26],[8,18,22,35],[8,18,22,43],
 [8,18,22,44],[8,18,22,53],[8,18,22,57],[8,18,22,60],
 [8,18,22,61],[8,18,22,66],[8,18,24,25],[8,18,24,26],
 [8,18,24,44],[8,18,24,48],[8,18,24,51],[8,18,24,52],
 [8,18,24,53],[8,18,24,55],[8,18,24,56],[8,18,24,57],
 [8,18,24,60],[8,18,24,61],[8,18,24,66],[8,18,24,67],
 [8,18,24,68],[8,18,25,26],[8,18,25,35],[8,18,25,39],
 [8,18,25,43],[8,18,25,46],[8,18,25,48],[8,18,25,50],
 [8,18,25,51],[8,18,25,52],[8,18,25,53],[8,18,25,57],
 [8,18,25,60],[8,18,25,61],[8,18,25,66],[8,18,25,67],
 [8,18,26,30],[8,18,26,35],[8,18,26,39],[8,18,26,43],
 [8,18,26,44],[8,18,26,46],[8,18,26,50],[8,18,26,51],
 [8,18,26,52],[8,18,26,53],[8,18,26,55],[8,18,26,56],
 [8,18,26,57],[8,18,26,60],[8,18,26,61],[8,18,26,66],
 [8,18,26,67],[8,18,26,68],[8,18,30,48],[8,18,30,53],
 [8,18,30,67],[8,18,30,68],[8,18,35,48],[8,18,35,67],
 [8,18,35,68],[8,18,39,43],[8,18,39,44],[8,18,39,46],
 [8,18,39,52],[8,18,39,53],[8,18,39,60],[8,18,39,61],
 [8,18,39,67],[8,18,39,68],[8,18,43,48],[8,18,43,55],
 [8,18,43,56],[8,18,43,57],[8,18,43,60],[8,18,43,61],
 [8,18,43,67],[8,18,44,48],[8,18,44,50],[8,18,44,51],
 [8,18,44,56],[8,18,44,60],[8,18,44,61],[8,18,44,68],
 [8,18,46,48],[8,18,46,53],[8,18,46,56],[8,18,46,57],
 [8,18,46,61],[8,18,46,67],[8,18,46,68],[8,18,48,50],
 [8,18,48,51],[8,18,48,52],[8,18,48,53],[8,18,48,55],
 [8,18,48,57],[8,18,48,60],[8,18,48,61],[8,18,48,66],
 [8,18,48,68],[8,18,50,52],[8,18,50,53],[8,18,50,55],
 [8,18,50,56],[8,18,50,60],[8,18,50,61],[8,18,50,66],
 [8,18,50,67],[8,18,50,68],[8,18,51,53],[8,18,51,55],
 [8,18,51,56],[8,18,51,57],[8,18,51,60],[8,18,51,61],
 [8,18,51,66],[8,18,51,67],[8,18,51,68],[8,18,52,53],
 [8,18,52,57],[8,18,52,61],[8,18,52,66],[8,18,52,67],
 [8,18,53,56],[8,18,53,60],[8,18,53,67],[8,18,53,68],
 [8,18,55,60],[8,18,55,66],[8,18,55,67],[8,18,55,68],
 [8,18,56,57],[8,18,56,61],[8,18,56,66],[8,18,56,68],
 [8,18,57,60],[8,18,57,61],[8,18,57,67],[8,18,57,68],
 [8,18,60,61],[8,18,60,66],[8,18,60,67],[8,18,61,67],
 [8,18,61,68],[8,18,66,67],[8,18,66,68],[8,21,22,24],
 [8,21,22,25],[8,21,22,27],[8,21,22,35],[8,21,22,43],
 [8,21,22,50],[8,21,22,60],[8,21,22,61],[8,21,22,62],
 [8,21,22,64],[8,21,22,66],[8,21,22,69],[8,21,24,25],
 [8,21,24,27],[8,21,24,37],[8,21,24,45],[8,21,24,48],
 [8,21,24,49],[8,21,24,51],[8,21,24,53],[8,21,24,55],
 [8,21,24,57],[8,21,24,59],[8,21,24,60],[8,21,24,61],
 [8,21,24,62],[8,21,24,65],[8,21,24,66],[8,21,24,68],
 [8,21,24,69],[8,21,25,27],[8,21,25,31],[8,21,25,34],
 [8,21,25,35],[8,21,25,37],[8,21,25,43],[8,21,25,45],
 [8,21,25,46],[8,21,25,48],[8,21,25,49],[8,21,25,50],
 [8,21,25,51],[8,21,25,52],[8,21,25,53],[8,21,25,57],
 [8,21,25,59],[8,21,25,60],[8,21,25,61],[8,21,25,62],
 [8,21,25,64],[8,21,25,65],[8,21,25,66],[8,21,25,68],
 [8,21,25,69],[8,21,27,30],[8,21,27,34],[8,21,27,35],
 [8,21,27,43],[8,21,27,45],[8,21,27,46],[8,21,27,48],
 [8,21,27,51],[8,21,27,53],[8,21,27,55],[8,21,27,59],
 [8,21,27,60],[8,21,27,61],[8,21,27,62],[8,21,27,65],
 [8,21,27,68],[8,21,27,69],[8,21,30,35],[8,21,30,48],
 [8,21,30,53],[8,21,30,62],[8,21,30,68],[8,21,31,37],
 [8,21,31,48],[8,21,31,49],[8,21,31,65],[8,21,31,69],
 [8,21,34,45],[8,21,34,46],[8,21,34,48],[8,21,34,49],
 [8,21,34,59],[8,21,34,61],[8,21,34,62],[8,21,34,68],
 [8,21,34,69],[8,21,35,37],[8,21,35,45],[8,21,35,48],
 [8,21,35,49],[8,21,35,57],[8,21,35,59],[8,21,35,62],
 [8,21,35,65],[8,21,35,68],[8,21,37,43],[8,21,37,45],
 [8,21,37,46],[8,21,37,48],[8,21,37,59],[8,21,37,60],
 [8,21,37,61],[8,21,37,62],[8,21,43,45],[8,21,43,48],
 [8,21,43,49],[8,21,43,52],[8,21,43,53],[8,21,43,55],
 [8,21,43,57],[8,21,43,59],[8,21,43,60],[8,21,43,61],
 [8,21,43,62],[8,21,43,64],[8,21,43,65],[8,21,43,66],
 [8,21,43,68],[8,21,43,69],[8,21,45,46],[8,21,45,48],
 [8,21,45,49],[8,21,45,50],[8,21,45,51],[8,21,45,52],
 [8,21,45,53],[8,21,45,55],[8,21,45,57],[8,21,45,59],
 [8,21,45,60],[8,21,45,61],[8,21,45,62],[8,21,45,66],
 [8,21,45,68],[8,21,45,69],[8,21,46,48],[8,21,46,49],
 [8,21,46,53],[8,21,46,57],[8,21,46,59],[8,21,46,61],
 [8,21,46,62],[8,21,46,65],[8,21,46,68],[8,21,46,69],
 [8,21,48,49],[8,21,48,50],[8,21,48,51],[8,21,48,52],
 [8,21,48,53],[8,21,48,55],[8,21,48,57],[8,21,48,60],
 [8,21,48,61],[8,21,48,62],[8,21,48,64],[8,21,48,66],
 [8,21,48,68],[8,21,48,69],[8,21,49,55],[8,21,49,60],
 [8,21,49,61],[8,21,49,62],[8,21,49,64],[8,21,49,69],
 [8,21,50,52],[8,21,50,53],[8,21,50,59],[8,21,50,61],
 [8,21,50,62],[8,21,50,65],[8,21,50,66],[8,21,50,68],
 [8,21,50,69],[8,21,51,53],[8,21,51,59],[8,21,51,60],
 [8,21,51,62],[8,21,51,68],[8,21,52,53],[8,21,52,61],
 [8,21,52,62],[8,21,52,65],[8,21,52,69],[8,21,53,60],
 [8,21,53,62],[8,21,53,64],[8,21,53,68],[8,21,55,60],
 [8,21,55,61],[8,21,55,62],[8,21,55,66],[8,21,55,68],
 [8,21,55,69],[8,21,57,59],[8,21,57,60],[8,21,57,61],
 [8,21,57,68],[8,21,59,60],[8,21,59,61],[8,21,59,62],
 [8,21,59,64],[8,21,59,65],[8,21,59,68],[8,21,59,69],
 [8,21,60,61],[8,21,60,62],[8,21,60,65],[8,21,60,66],
 [8,21,60,68],[8,21,60,69],[8,21,61,62],[8,21,61,64],
 [8,21,61,65],[8,21,61,66],[8,21,61,68],[8,21,61,69],
 [8,21,62,65],[8,21,62,66],[8,21,62,68],[8,21,62,69],
 [8,21,64,65],[8,21,64,68],[8,21,64,69],[8,21,65,68],
 [8,21,66,68],[8,21,66,69],[8,21,68,69],[8,22,24,25],
 [8,22,24,26],[8,22,24,27],[8,22,24,44],[8,22,24,57],
 [8,22,24,58],[8,22,24,60],[8,22,24,61],[8,22,24,62],
 [8,22,24,63],[8,22,24,64],[8,22,24,65],[8,22,24,66],
 [8,22,24,67],[8,22,24,69],[8,22,25,26],[8,22,25,27],
 [8,22,25,35],[8,22,25,40],[8,22,25,43],[8,22,25,53],
 [8,22,25,57],[8,22,25,58],[8,22,25,60],[8,22,25,61],
 [8,22,25,62],[8,22,25,64],[8,22,25,66],[8,22,25,67],
 [8,22,25,69],[8,22,26,27],[8,22,26,31],[8,22,26,35],
 [8,22,26,40],[8,22,26,43],[8,22,26,44],[8,22,26,57],
 [8,22,26,58],[8,22,26,60],[8,22,26,61],[8,22,26,62],
 [8,22,26,63],[8,22,26,64],[8,22,26,65],[8,22,26,66],
 [8,22,26,67],[8,22,26,69],[8,22,27,31],[8,22,27,40],
 [8,22,27,43],[8,22,27,53],[8,22,27,58],[8,22,27,60],
 [8,22,27,61],[8,22,27,62],[8,22,27,65],[8,22,27,67],
 [8,22,27,69],[8,22,31,61],[8,22,31,63],[8,22,31,65],
 [8,22,31,69],[8,22,35,57],[8,22,35,58],[8,22,35,62],
 [8,22,35,67],[8,22,35,69],[8,22,40,44],[8,22,40,58],
 [8,22,40,61],[8,22,40,63],[8,22,40,64],[8,22,40,65],
 [8,22,40,69],[8,22,43,44],[8,22,43,53],[8,22,43,57],
 [8,22,43,58],[8,22,43,60],[8,22,43,61],[8,22,43,62],
 [8,22,43,64],[8,22,43,65],[8,22,43,66],[8,22,43,67],
 [8,22,43,69],[8,22,44,50],[8,22,44,53],[8,22,44,58],
 [8,22,44,60],[8,22,44,61],[8,22,44,64],[8,22,44,65],
 [8,22,44,66],[8,22,44,67],[8,22,44,69],[8,22,50,58],
 [8,22,50,60],[8,22,50,62],[8,22,50,65],[8,22,50,66],
 [8,22,50,67],[8,22,50,69],[8,22,53,58],[8,22,53,60],
 [8,22,53,62],[8,22,53,63],[8,22,53,64],[8,22,57,58],
 [8,22,57,60],[8,22,57,61],[8,22,57,67],[8,22,58,60],
 [8,22,58,61],[8,22,58,62],[8,22,58,65],[8,22,58,67],
 [8,22,58,69],[8,22,60,61],[8,22,60,62],[8,22,60,63],
 [8,22,60,65],[8,22,60,66],[8,22,60,67],[8,22,60,69],
 [8,22,61,62],[8,22,61,63],[8,22,61,64],[8,22,61,65],
 [8,22,61,66],[8,22,61,67],[8,22,61,69],[8,22,62,63],
 [8,22,62,66],[8,22,62,67],[8,22,62,69],[8,22,63,64],
 [8,22,63,65],[8,22,63,69],[8,22,64,65],[8,22,64,67],
 [8,22,66,67],[8,22,66,69],[8,22,67,69],[8,24,25,26],
 [8,24,25,27],[8,24,25,32],[8,24,25,37],[8,24,25,42],
 [8,24,25,45],[8,24,25,48],[8,24,25,49],[8,24,25,51],
 [8,24,25,53],[8,24,25,57],[8,24,25,58],[8,24,25,59],
 [8,24,25,60],[8,24,25,61],[8,24,25,62],[8,24,25,65],
 [8,24,25,66],[8,24,25,67],[8,24,25,68],[8,24,25,69],
 [8,24,26,27],[8,24,26,37],[8,24,26,41],[8,24,26,44],
 [8,24,26,49],[8,24,26,51],[8,24,26,52],[8,24,26,55],
 [8,24,26,56],[8,24,26,57],[8,24,26,58],[8,24,26,59],
 [8,24,26,60],[8,24,26,61],[8,24,26,62],[8,24,26,63],
 [8,24,26,64],[8,24,26,65],[8,24,26,66],[8,24,26,67],
 [8,24,26,68],[8,24,26,69],[8,24,27,32],[8,24,27,42],
 [8,24,27,45],[8,24,27,48],[8,24,27,51],[8,24,27,52],
 [8,24,27,53],[8,24,27,55],[8,24,27,56],[8,24,27,58],
 [8,24,27,59],[8,24,27,60],[8,24,27,61],[8,24,27,62],
 [8,24,27,65],[8,24,27,67],[8,24,27,68],[8,24,27,69],
 [8,24,32,41],[8,24,32,44],[8,24,32,49],[8,24,32,51],
 [8,24,32,52],[8,24,32,58],[8,24,32,60],[8,24,32,61],
 [8,24,32,62],[8,24,32,63],[8,24,32,64],[8,24,32,68],
 [8,24,37,42],[8,24,37,44],[8,24,37,45],[8,24,37,48],
 [8,24,37,56],[8,24,37,59],[8,24,37,60],[8,24,37,61],
 [8,24,37,62],[8,24,37,63],[8,24,37,64],[8,24,37,67],
 [8,24,41,42],[8,24,41,44],[8,24,41,48],[8,24,41,53],
 [8,24,41,59],[8,24,41,60],[8,24,41,61],[8,24,41,62],
 [8,24,41,64],[8,24,41,65],[8,24,41,67],[8,24,41,69],
 [8,24,42,44],[8,24,42,49],[8,24,42,51],[8,24,42,52],
 [8,24,42,55],[8,24,42,59],[8,24,42,60],[8,24,42,61],
 [8,24,42,62],[8,24,42,63],[8,24,42,64],[8,24,42,65],
 [8,24,42,66],[8,24,42,68],[8,24,44,45],[8,24,44,48],
 [8,24,44,49],[8,24,44,51],[8,24,44,53],[8,24,44,55],
 [8,24,44,56],[8,24,44,58],[8,24,44,59],[8,24,44,60],
 [8,24,44,61],[8,24,44,64],[8,24,44,65],[8,24,44,66],
 [8,24,44,67],[8,24,44,68],[8,24,44,69],[8,24,45,48],
 [8,24,45,49],[8,24,45,51],[8,24,45,53],[8,24,45,55],
 [8,24,45,57],[8,24,45,58],[8,24,45,59],[8,24,45,60],
 [8,24,45,61],[8,24,45,62],[8,24,45,66],[8,24,45,67],
 [8,24,45,68],[8,24,45,69],[8,24,48,49],[8,24,48,51],
 [8,24,48,52],[8,24,48,53],[8,24,48,55],[8,24,48,57],
 [8,24,48,60],[8,24,48,61],[8,24,48,62],[8,24,48,63],
 [8,24,48,64],[8,24,48,66],[8,24,48,68],[8,24,48,69],
 [8,24,49,53],[8,24,49,55],[8,24,49,56],[8,24,49,58],
 [8,24,49,60],[8,24,49,61],[8,24,49,62],[8,24,49,63],
 [8,24,49,64],[8,24,49,65],[8,24,49,67],[8,24,49,69],
 [8,24,51,53],[8,24,51,55],[8,24,51,56],[8,24,51,57],
 [8,24,51,58],[8,24,51,59],[8,24,51,60],[8,24,51,61],
 [8,24,51,62],[8,24,51,63],[8,24,51,64],[8,24,51,65],
 [8,24,51,66],[8,24,51,67],[8,24,51,68],[8,24,51,69],
 [8,24,52,53],[8,24,52,57],[8,24,52,61],[8,24,52,62],
 [8,24,52,65],[8,24,52,66],[8,24,52,67],[8,24,52,69],
 [8,24,53,56],[8,24,53,58],[8,24,53,60],[8,24,53,62],
 [8,24,53,63],[8,24,53,64],[8,24,53,67],[8,24,53,68],
 [8,24,55,60],[8,24,55,61],[8,24,55,62],[8,24,55,66],
 [8,24,55,67],[8,24,55,68],[8,24,55,69],[8,24,56,57],
 [8,24,56,59],[8,24,56,61],[8,24,56,62],[8,24,56,68],
 [8,24,56,69],[8,24,57,59],[8,24,57,60],[8,24,57,61],
 [8,24,57,67],[8,24,57,68],[8,24,58,60],[8,24,58,61],
 [8,24,58,62],[8,24,58,65],[8,24,58,67],[8,24,58,68],
 [8,24,58,69],[8,24,59,60],[8,24,59,61],[8,24,59,62],
 [8,24,59,63],[8,24,59,64],[8,24,59,65],[8,24,59,67],
 [8,24,59,68],[8,24,59,69],[8,24,60,61],[8,24,60,62],
 [8,24,60,65],[8,24,60,66],[8,24,60,67],[8,24,60,68],
 [8,24,60,69],[8,24,61,62],[8,24,61,63],[8,24,61,64],
 [8,24,61,65],[8,24,61,66],[8,24,61,67],[8,24,61,68],
 [8,24,61,69],[8,24,62,65],[8,24,62,66],[8,24,62,67],
 [8,24,62,68],[8,24,62,69],[8,24,63,64],[8,24,63,65],
 [8,24,63,66],[8,24,63,67],[8,24,63,68],[8,24,63,69],
 [8,24,64,65],[8,24,64,67],[8,24,64,68],[8,24,64,69],
 [8,24,65,68],[8,24,66,67],[8,24,66,68],[8,24,66,69],
 [8,24,67,68],[8,24,67,69],[8,24,68,69],[8,25,26,27],
 [8,25,26,31],[8,25,26,34],[8,25,26,35],[8,25,26,37],
 [8,25,26,39],[8,25,26,40],[8,25,26,43],[8,25,26,46],
 [8,25,26,49],[8,25,26,50],[8,25,26,51],[8,25,26,52],
 [8,25,26,53],[8,25,26,57],[8,25,26,58],[8,25,26,59],
 [8,25,26,60],[8,25,26,61],[8,25,26,62],[8,25,26,64],
 [8,25,26,66],[8,25,26,67],[8,25,26,68],[8,25,26,69],
 [8,25,27,31],[8,25,27,32],[8,25,27,34],[8,25,27,35],
 [8,25,27,39],[8,25,27,40],[8,25,27,42],[8,25,27,43],
 [8,25,27,45],[8,25,27,46],[8,25,27,48],[8,25,27,51],
 [8,25,27,53],[8,25,27,58],[8,25,27,59],[8,25,27,60],
 [8,25,27,61],[8,25,27,62],[8,25,27,64],[8,25,27,65],
 [8,25,27,67],[8,25,27,68],[8,25,27,69],[8,25,31,32],
 [8,25,31,37],[8,25,31,42],[8,25,31,48],[8,25,31,49],
 [8,25,31,53],[8,25,31,61],[8,25,31,65],[8,25,31,66],
 [8,25,31,67],[8,25,31,68],[8,25,31,69],[8,25,32,35],
 [8,25,32,40],[8,25,32,43],[8,25,32,46],[8,25,32,49],
 [8,25,32,50],[8,25,32,51],[8,25,32,52],[8,25,32,58],
 [8,25,32,60],[8,25,32,61],[8,25,32,62],[8,25,32,64],
 [8,25,32,68],[8,25,34,39],[8,25,34,45],[8,25,34,46],
 [8,25,34,48],[8,25,34,49],[8,25,34,58],[8,25,34,59],
 [8,25,34,61],[8,25,34,62],[8,25,34,67],[8,25,34,68],
 [8,25,34,69],[8,25,35,37],[8,25,35,42],[8,25,35,45],
 [8,25,35,48],[8,25,35,49],[8,25,35,57],[8,25,35,58],
 [8,25,35,59],[8,25,35,62],[8,25,35,65],[8,25,35,67],
 [8,25,35,68],[8,25,35,69],[8,25,37,40],[8,25,37,42],
 [8,25,37,43],[8,25,37,45],[8,25,37,46],[8,25,37,48],
 [8,25,37,59],[8,25,37,60],[8,25,37,61],[8,25,37,62],
 [8,25,37,64],[8,25,37,67],[8,25,39,43],[8,25,39,45],
 [8,25,39,46],[8,25,39,58],[8,25,39,60],[8,25,39,61],
 [8,25,39,64],[8,25,39,65],[8,25,39,67],[8,25,39,68],
 [8,25,39,69],[8,25,40,42],[8,25,40,45],[8,25,40,48],
 [8,25,40,49],[8,25,40,52],[8,25,40,53],[8,25,40,58],
 [8,25,40,59],[8,25,40,61],[8,25,40,64],[8,25,40,65],
 [8,25,40,66],[8,25,40,67],[8,25,40,68],[8,25,40,69],
 [8,25,42,43],[8,25,42,46],[8,25,42,49],[8,25,42,50],
 [8,25,42,51],[8,25,42,52],[8,25,42,59],[8,25,42,60],
 [8,25,42,61],[8,25,42,62],[8,25,42,64],[8,25,42,65],
 [8,25,42,66],[8,25,42,68],[8,25,43,45],[8,25,43,48],
 [8,25,43,49],[8,25,43,52],[8,25,43,53],[8,25,43,57],
 [8,25,43,58],[8,25,43,59],[8,25,43,60],[8,25,43,61],
 [8,25,43,62],[8,25,43,64],[8,25,43,65],[8,25,43,66],
 [8,25,43,67],[8,25,43,68],[8,25,43,69],[8,25,45,46],
 [8,25,45,48],[8,25,45,49],[8,25,45,50],[8,25,45,51],
 [8,25,45,52],[8,25,45,53],[8,25,45,57],[8,25,45,58],
 [8,25,45,59],[8,25,45,60],[8,25,45,61],[8,25,45,62],
 [8,25,45,66],[8,25,45,67],[8,25,45,68],[8,25,45,69],
 [8,25,46,48],[8,25,46,49],[8,25,46,53],[8,25,46,57],
 [8,25,46,58],[8,25,46,59],[8,25,46,61],[8,25,46,62],
 [8,25,46,65],[8,25,46,67],[8,25,46,68],[8,25,46,69],
 [8,25,48,49],[8,25,48,50],[8,25,48,51],[8,25,48,52],
 [8,25,48,53],[8,25,48,57],[8,25,48,60],[8,25,48,61],
 [8,25,48,62],[8,25,48,64],[8,25,48,66],[8,25,48,68],
 [8,25,48,69],[8,25,49,53],[8,25,49,58],[8,25,49,60],
 [8,25,49,61],[8,25,49,62],[8,25,49,64],[8,25,49,65],
 [8,25,49,67],[8,25,49,69],[8,25,50,52],[8,25,50,53],
 [8,25,50,61],[8,25,50,62],[8,25,50,65],[8,25,50,66],
 [8,25,50,67],[8,25,50,69],[8,25,51,53],[8,25,51,57],
 [8,25,51,58],[8,25,51,59],[8,25,51,60],[8,25,51,61],
 [8,25,51,62],[8,25,51,64],[8,25,51,65],[8,25,51,66],
 [8,25,51,67],[8,25,51,68],[8,25,51,69],[8,25,52,53],
 [8,25,52,61],[8,25,52,62],[8,25,52,65],[8,25,52,66],
 [8,25,52,67],[8,25,52,69],[8,25,53,58],[8,25,53,60],
 [8,25,53,62],[8,25,53,64],[8,25,53,67],[8,25,53,68],
 [8,25,57,58],[8,25,57,59],[8,25,57,60],[8,25,57,61],
 [8,25,57,67],[8,25,58,60],[8,25,58,61],[8,25,58,62],
 [8,25,58,65],[8,25,58,67],[8,25,58,68],[8,25,58,69],
 [8,25,59,60],[8,25,59,61],[8,25,59,62],[8,25,59,64],
 [8,25,59,65],[8,25,59,67],[8,25,59,68],[8,25,59,69],
 [8,25,60,61],[8,25,60,62],[8,25,60,65],[8,25,60,66],
 [8,25,60,67],[8,25,60,68],[8,25,60,69],[8,25,61,62],
 [8,25,61,64],[8,25,61,65],[8,25,61,66],[8,25,61,67],
 [8,25,61,68],[8,25,61,69],[8,25,62,65],[8,25,62,66],
 [8,25,62,67],[8,25,62,68],[8,25,62,69],[8,25,64,65],
 [8,25,64,67],[8,25,64,68],[8,25,64,69],[8,25,65,68],
 [8,25,66,67],[8,25,66,68],[8,25,66,69],[8,25,67,68],
 [8,25,67,69],[8,25,68,69],[8,26,27,31],[8,26,27,34],
 [8,26,27,35],[8,26,27,39],[8,26,27,40],[8,26,27,43],
 [8,26,27,46],[8,26,27,51],[8,26,27,52],[8,26,27,55],
 [8,26,27,56],[8,26,27,58],[8,26,27,59],[8,26,27,60],
 [8,26,27,61],[8,26,27,62],[8,26,27,64],[8,26,27,67],
 [8,26,27,68],[8,26,27,69],[8,26,30,35],[8,26,30,44],
 [8,26,30,49],[8,26,30,53],[8,26,30,61],[8,26,30,62],
 [8,26,30,68],[8,26,31,37],[8,26,31,41],[8,26,31,49],
 [8,26,31,53],[8,26,31,61],[8,26,31,63],[8,26,31,65],
 [8,26,31,66],[8,26,31,67],[8,26,31,68],[8,26,31,69],
 [8,26,34,39],[8,26,34,41],[8,26,34,44],[8,26,34,46],
 [8,26,34,49],[8,26,34,56],[8,26,34,58],[8,26,34,59],
 [8,26,34,61],[8,26,34,62],[8,26,34,67],[8,26,34,68],
 [8,26,34,69],[8,26,35,37],[8,26,35,41],[8,26,35,49],
 [8,26,35,57],[8,26,35,58],[8,26,35,59],[8,26,35,62],
 [8,26,35,63],[8,26,35,65],[8,26,35,67],[8,26,35,68],
 [8,26,35,69],[8,26,37,40],[8,26,37,43],[8,26,37,44],
 [8,26,37,46],[8,26,37,56],[8,26,37,59],[8,26,37,60],
 [8,26,37,61],[8,26,37,62],[8,26,37,64],[8,26,37,67],
 [8,26,39,43],[8,26,39,44],[8,26,39,46],[8,26,39,58],
 [8,26,39,60],[8,26,39,61],[8,26,39,63],[8,26,39,64],
 [8,26,39,65],[8,26,39,67],[8,26,39,68],[8,26,39,69],
 [8,26,40,41],[8,26,40,44],[8,26,40,49],[8,26,40,52],
 [8,26,40,53],[8,26,40,55],[8,26,40,58],[8,26,40,59],
 [8,26,40,61],[8,26,40,63],[8,26,40,64],[8,26,40,65],
 [8,26,40,66],[8,26,40,67],[8,26,40,68],[8,26,40,69],
 [8,26,41,43],[8,26,41,44],[8,26,41,46],[8,26,41,53],
 [8,26,41,59],[8,26,41,60],[8,26,41,61],[8,26,41,62],
 [8,26,41,64],[8,26,41,65],[8,26,41,67],[8,26,41,69],
 [8,26,43,44],[8,26,43,49],[8,26,43,52],[8,26,43,53],
 [8,26,43,55],[8,26,43,56],[8,26,43,58],[8,26,43,59],
 [8,26,43,60],[8,26,43,61],[8,26,43,62],[8,26,43,64],
 [8,26,43,66],[8,26,43,67],[8,26,43,68],[8,26,43,69],
 [8,26,44,46],[8,26,44,49],[8,26,44,50],[8,26,44,51],
 [8,26,44,53],[8,26,44,55],[8,26,44,56],[8,26,44,58],
 [8,26,44,59],[8,26,44,60],[8,26,44,61],[8,26,44,64],
 [8,26,44,65],[8,26,44,66],[8,26,44,67],[8,26,44,68],
 [8,26,44,69],[8,26,46,49],[8,26,46,53],[8,26,46,56],
 [8,26,46,57],[8,26,46,58],[8,26,46,59],[8,26,46,61],
 [8,26,46,62],[8,26,46,63],[8,26,46,65],[8,26,46,67],
 [8,26,46,68],[8,26,46,69],[8,26,49,53],[8,26,49,55],
 [8,26,49,56],[8,26,49,58],[8,26,49,60],[8,26,49,61],
 [8,26,49,62],[8,26,49,63],[8,26,49,64],[8,26,49,65],
 [8,26,49,67],[8,26,49,69],[8,26,50,52],[8,26,50,53],
 [8,26,50,56],[8,26,50,58],[8,26,50,60],[8,26,50,62],
 [8,26,50,64],[8,26,50,67],[8,26,50,68],[8,26,51,53],
 [8,26,51,56],[8,26,51,57],[8,26,51,58],[8,26,51,59],
 [8,26,51,60],[8,26,51,61],[8,26,51,62],[8,26,51,63],
 [8,26,51,64],[8,26,51,65],[8,26,51,66],[8,26,51,67],
 [8,26,51,68],[8,26,51,69],[8,26,52,53],[8,26,52,57],
 [8,26,52,61],[8,26,52,62],[8,26,52,63],[8,26,52,65],
 [8,26,52,66],[8,26,52,67],[8,26,52,69],[8,26,53,56],
 [8,26,53,58],[8,26,53,60],[8,26,53,62],[8,26,53,64],
 [8,26,53,67],[8,26,53,68],[8,26,55,60],[8,26,55,61],
 [8,26,55,62],[8,26,55,66],[8,26,55,67],[8,26,55,68],
 [8,26,55,69],[8,26,56,57],[8,26,56,59],[8,26,56,61],
 [8,26,56,62],[8,26,56,66],[8,26,56,68],[8,26,56,69],
 [8,26,57,58],[8,26,57,59],[8,26,57,60],[8,26,57,61],
 [8,26,57,67],[8,26,57,68],[8,26,58,60],[8,26,58,61],
 [8,26,58,62],[8,26,58,65],[8,26,58,67],[8,26,58,68],
 [8,26,58,69],[8,26,59,60],[8,26,59,61],[8,26,59,62],
 [8,26,59,63],[8,26,59,64],[8,26,59,65],[8,26,59,67],
 [8,26,59,68],[8,26,59,69],[8,26,60,61],[8,26,60,62],
 [8,26,60,63],[8,26,60,65],[8,26,60,66],[8,26,60,67],
 [8,26,60,68],[8,26,60,69],[8,26,61,62],[8,26,61,63],
 [8,26,61,64],[8,26,61,65],[8,26,61,66],[8,26,61,67],
 [8,26,61,68],[8,26,61,69],[8,26,62,63],[8,26,62,65],
 [8,26,62,66],[8,26,62,67],[8,26,62,68],[8,26,62,69],
 [8,26,63,64],[8,26,63,65],[8,26,63,68],[8,26,64,65],
 [8,26,64,67],[8,26,64,68],[8,26,64,69],[8,26,65,68],
 [8,26,66,67],[8,26,66,68],[8,26,66,69],[8,26,67,68],
 [8,26,67,69],[8,26,68,69],[8,27,30,35],[8,27,30,45],
 [8,27,30,48],[8,27,30,53],[8,27,30,61],[8,27,30,62],
 [8,27,31,32],[8,27,31,42],[8,27,31,48],[8,27,31,53],
 [8,27,31,61],[8,27,31,65],[8,27,31,67],[8,27,31,68],
 [8,27,31,69],[8,27,32,35],[8,27,32,40],[8,27,32,43],
 [8,27,32,46],[8,27,32,51],[8,27,32,52],[8,27,32,60],
 [8,27,32,61],[8,27,32,62],[8,27,32,64],[8,27,32,68],
 [8,27,34,39],[8,27,34,45],[8,27,34,46],[8,27,34,48],
 [8,27,34,56],[8,27,34,58],[8,27,34,59],[8,27,34,61],
 [8,27,34,62],[8,27,34,67],[8,27,34,68],[8,27,34,69],
 [8,27,35,42],[8,27,35,45],[8,27,35,48],[8,27,35,58],
 [8,27,35,59],[8,27,35,62],[8,27,35,65],[8,27,35,67],
 [8,27,35,68],[8,27,35,69],[8,27,39,43],[8,27,39,45],
 [8,27,39,46],[8,27,39,52],[8,27,39,53],[8,27,39,58],
 [8,27,39,60],[8,27,39,61],[8,27,39,64],[8,27,39,65],
 [8,27,39,67],[8,27,39,68],[8,27,39,69],[8,27,40,42],
 [8,27,40,48],[8,27,40,52],[8,27,40,53],[8,27,40,55],
 [8,27,40,58],[8,27,40,61],[8,27,40,64],[8,27,40,65],
 [8,27,40,67],[8,27,40,68],[8,27,40,69],[8,27,42,43],
 [8,27,42,46],[8,27,42,51],[8,27,42,52],[8,27,42,55],
 [8,27,42,59],[8,27,42,60],[8,27,42,61],[8,27,42,62],
 [8,27,42,64],[8,27,42,65],[8,27,42,68],[8,27,43,45],
 [8,27,43,48],[8,27,43,52],[8,27,43,53],[8,27,43,55],
 [8,27,43,56],[8,27,43,58],[8,27,43,59],[8,27,43,60],
 [8,27,43,61],[8,27,43,62],[8,27,43,64],[8,27,43,67],
 [8,27,43,68],[8,27,43,69],[8,27,45,46],[8,27,45,48],
 [8,27,45,51],[8,27,45,53],[8,27,45,55],[8,27,45,58],
 [8,27,45,59],[8,27,45,60],[8,27,45,61],[8,27,45,62],
 [8,27,45,67],[8,27,45,68],[8,27,45,69],[8,27,46,48],
 [8,27,46,53],[8,27,46,56],[8,27,46,58],[8,27,46,59],
 [8,27,46,61],[8,27,46,62],[8,27,46,65],[8,27,46,67],
 [8,27,46,68],[8,27,46,69],[8,27,48,51],[8,27,48,52],
 [8,27,48,53],[8,27,48,55],[8,27,48,60],[8,27,48,61],
 [8,27,48,62],[8,27,48,64],[8,27,48,68],[8,27,48,69],
 [8,27,51,53],[8,27,51,56],[8,27,51,59],[8,27,51,60],
 [8,27,51,61],[8,27,51,62],[8,27,51,64],[8,27,51,65],
 [8,27,51,67],[8,27,51,68],[8,27,51,69],[8,27,52,53],
 [8,27,52,61],[8,27,52,62],[8,27,52,65],[8,27,52,67],
 [8,27,52,69],[8,27,53,56],[8,27,53,58],[8,27,53,60],
 [8,27,53,62],[8,27,53,64],[8,27,53,67],[8,27,53,68],
 [8,27,55,60],[8,27,55,61],[8,27,55,62],[8,27,55,67],
 [8,27,55,68],[8,27,55,69],[8,27,56,59],[8,27,56,61],
 [8,27,56,62],[8,27,56,69],[8,27,58,60],[8,27,58,61],
 [8,27,58,62],[8,27,58,65],[8,27,58,67],[8,27,58,68],
 [8,27,58,69],[8,27,59,60],[8,27,59,61],[8,27,59,62],
 [8,27,59,64],[8,27,59,65],[8,27,59,67],[8,27,59,68],
 [8,27,59,69],[8,27,60,61],[8,27,60,62],[8,27,60,65],
 [8,27,60,67],[8,27,60,68],[8,27,60,69],[8,27,61,62],
 [8,27,61,64],[8,27,61,65],[8,27,61,67],[8,27,61,68],
 [8,27,61,69],[8,27,62,65],[8,27,62,67],[8,27,62,68],
 [8,27,62,69],[8,27,64,65],[8,27,64,67],[8,27,64,68],
 [8,27,64,69],[8,27,65,68],[8,27,67,68],[8,27,67,69],
 [8,27,68,69],[8,30,35,48],[8,30,35,49],[8,30,35,58],
 [8,30,35,67],[8,30,35,68],[8,30,44,48],[8,30,44,49],
 [8,30,44,53],[8,30,44,61],[8,30,44,67],[8,30,44,68],
 [8,30,45,48],[8,30,45,62],[8,30,45,67],[8,30,45,68],
 [8,30,48,68],[8,30,49,53],[8,30,49,61],[8,30,49,67],
 [8,30,53,58],[8,30,53,62],[8,30,53,67],[8,30,53,68],
 [8,30,58,61],[8,30,58,62],[8,30,58,67],[8,30,61,67],
 [8,30,61,68],[8,30,62,67],[8,30,62,68],[8,31,32,41],
 [8,31,32,49],[8,31,32,61],[8,31,32,63],[8,31,32,68],
 [8,31,37,42],[8,31,37,48],[8,31,37,63],[8,31,37,67],
 [8,31,41,42],[8,31,41,48],[8,31,41,53],[8,31,41,61],
 [8,31,41,65],[8,31,41,67],[8,31,41,69],[8,31,42,49],
 [8,31,42,63],[8,31,42,65],[8,31,42,66],[8,31,42,68],
 [8,31,48,49],[8,31,48,63],[8,31,48,66],[8,31,48,68],
 [8,31,48,69],[8,31,49,53],[8,31,49,61],[8,31,49,63],
 [8,31,49,65],[8,31,49,67],[8,31,49,69],[8,31,53,63],
 [8,31,53,68],[8,31,61,63],[8,31,61,68],[8,31,63,65],
 [8,31,63,67],[8,31,63,68],[8,31,63,69],[8,31,65,68],
 [8,31,66,67],[8,31,66,68],[8,31,66,69],[8,31,67,68],
 [8,31,67,69],[8,31,68,69],[8,32,35,41],[8,32,35,49],
 [8,32,35,58],[8,32,35,63],[8,32,35,68],[8,32,40,41],
 [8,32,40,44],[8,32,40,49],[8,32,40,52],[8,32,40,58],
 [8,32,40,63],[8,32,40,64],[8,32,40,68],[8,32,41,43],
 [8,32,41,44],[8,32,41,46],[8,32,41,60],[8,32,41,61],
 [8,32,41,62],[8,32,41,64],[8,32,43,44],[8,32,43,49],
 [8,32,43,58],[8,32,43,60],[8,32,43,62],[8,32,43,64],
 [8,32,44,46],[8,32,44,49],[8,32,44,50],[8,32,44,58],
 [8,32,44,60],[8,32,44,61],[8,32,44,68],[8,32,46,49],
 [8,32,46,58],[8,32,46,62],[8,32,46,63],[8,32,46,68],
 [8,32,49,60],[8,32,49,61],[8,32,49,62],[8,32,49,63],
 [8,32,49,64],[8,32,50,52],[8,32,50,58],[8,32,50,60],
 [8,32,50,61],[8,32,50,62],[8,32,50,64],[8,32,50,68],
 [8,32,51,58],[8,32,51,60],[8,32,51,62],[8,32,51,63],
 [8,32,51,64],[8,32,51,68],[8,32,52,62],[8,32,52,63],
 [8,32,58,60],[8,32,58,62],[8,32,60,62],[8,32,60,63],
 [8,32,60,68],[8,32,61,63],[8,32,61,68],[8,32,62,63],
 [8,32,62,68],[8,32,63,64],[8,32,63,68],[8,32,64,68],
 [8,34,39,44],[8,34,39,45],[8,34,39,46],[8,34,39,58],
 [8,34,39,61],[8,34,39,63],[8,34,39,67],[8,34,39,68],
 [8,34,39,69],[8,34,41,44],[8,34,41,46],[8,34,41,48],
 [8,34,41,59],[8,34,41,61],[8,34,41,62],[8,34,41,67],
 [8,34,41,69],[8,34,44,45],[8,34,44,46],[8,34,44,48],
 [8,34,44,49],[8,34,44,58],[8,34,44,59],[8,34,44,61],
 [8,34,44,67],[8,34,44,68],[8,34,44,69],[8,34,45,46],
 [8,34,45,48],[8,34,45,49],[8,34,45,58],[8,34,45,59],
 [8,34,45,61],[8,34,45,62],[8,34,45,63],[8,34,45,67],
 [8,34,45,68],[8,34,45,69],[8,34,46,48],[8,34,46,49],
 [8,34,46,56],[8,34,46,58],[8,34,46,59],[8,34,46,61],
 [8,34,46,62],[8,34,46,63],[8,34,46,67],[8,34,46,68],
 [8,34,46,69],[8,34,48,49],[8,34,48,61],[8,34,48,62],
 [8,34,48,63],[8,34,48,68],[8,34,48,69],[8,34,49,56],
 [8,34,49,58],[8,34,49,61],[8,34,49,62],[8,34,49,63],
 [8,34,49,67],[8,34,49,69],[8,34,56,61],[8,34,56,62],
 [8,34,56,69],[8,34,58,61],[8,34,58,62],[8,34,58,67],
 [8,34,58,68],[8,34,58,69],[8,34,59,61],[8,34,59,62],
 [8,34,59,63],[8,34,59,67],[8,34,59,68],[8,34,59,69],
 [8,34,61,62],[8,34,61,63],[8,34,61,67],[8,34,61,68],
 [8,34,61,69],[8,34,62,63],[8,34,62,67],[8,34,62,68],
 [8,34,62,69],[8,34,63,67],[8,34,63,68],[8,34,63,69],
 [8,34,67,68],[8,34,67,69],[8,34,68,69],[8,35,37,42],
 [8,35,37,45],[8,35,37,48],[8,35,37,59],[8,35,37,62],
 [8,35,37,63],[8,35,37,67],[8,35,41,42],[8,35,41,48],
 [8,35,41,59],[8,35,41,65],[8,35,41,67],[8,35,41,69],
 [8,35,42,49],[8,35,42,62],[8,35,42,63],[8,35,42,65],
 [8,35,42,68],[8,35,45,48],[8,35,45,58],[8,35,45,62],
 [8,35,45,63],[8,35,45,67],[8,35,45,68],[8,35,48,49],
 [8,35,48,57],[8,35,48,62],[8,35,48,63],[8,35,48,68],
 [8,35,48,69],[8,35,49,58],[8,35,49,63],[8,35,49,65],
 [8,35,49,67],[8,35,49,69],[8,35,57,58],[8,35,57,59],
 [8,35,57,67],[8,35,57,68],[8,35,58,62],[8,35,58,65],
 [8,35,58,67],[8,35,58,68],[8,35,58,69],[8,35,59,62],
 [8,35,59,63],[8,35,59,65],[8,35,59,67],[8,35,59,68],
 [8,35,59,69],[8,35,62,63],[8,35,62,67],[8,35,62,68],
 [8,35,63,65],[8,35,63,67],[8,35,63,68],[8,35,63,69],
 [8,35,65,68],[8,35,67,68],[8,35,67,69],[8,35,68,69],
 [8,37,40,42],[8,37,40,44],[8,37,40,48],[8,37,40,59],
 [8,37,40,61],[8,37,40,63],[8,37,40,67],[8,37,42,43],
 [8,37,42,44],[8,37,42,46],[8,37,42,60],[8,37,42,61],
 [8,37,42,62],[8,37,42,63],[8,37,42,64],[8,37,43,44],
 [8,37,43,45],[8,37,43,48],[8,37,43,56],[8,37,43,59],
 [8,37,43,60],[8,37,43,61],[8,37,43,64],[8,37,43,67],
 [8,37,44,46],[8,37,44,48],[8,37,44,56],[8,37,44,59],
 [8,37,44,60],[8,37,44,61],[8,37,44,67],[8,37,45,46],
 [8,37,45,48],[8,37,45,59],[8,37,45,60],[8,37,45,62],
 [8,37,45,63],[8,37,45,67],[8,37,46,48],[8,37,46,56],
 [8,37,46,59],[8,37,46,61],[8,37,46,63],[8,37,46,67],
 [8,37,48,60],[8,37,48,61],[8,37,48,62],[8,37,48,63],
 [8,37,48,64],[8,37,56,61],[8,37,56,62],[8,37,59,60],
 [8,37,59,61],[8,37,59,62],[8,37,59,63],[8,37,59,64],
 [8,37,60,61],[8,37,60,62],[8,37,60,63],[8,37,60,67],
 [8,37,61,63],[8,37,61,67],[8,37,62,63],[8,37,62,67],
 [8,37,63,64],[8,37,63,67],[8,37,64,67],[8,39,43,44],
 [8,39,43,45],[8,39,43,52],[8,39,43,53],[8,39,43,58],
 [8,39,43,60],[8,39,43,61],[8,39,43,64],[8,39,43,65],
 [8,39,43,67],[8,39,43,68],[8,39,43,69],[8,39,44,45],
 [8,39,44,46],[8,39,44,53],[8,39,44,58],[8,39,44,60],
 [8,39,44,61],[8,39,44,65],[8,39,44,67],[8,39,44,68],
 [8,39,44,69],[8,39,45,46],[8,39,45,58],[8,39,45,60],
 [8,39,45,61],[8,39,45,63],[8,39,45,67],[8,39,45,68],
 [8,39,45,69],[8,39,46,53],[8,39,46,58],[8,39,46,61],
 [8,39,46,63],[8,39,46,65],[8,39,46,67],[8,39,46,68],
 [8,39,46,69],[8,39,52,53],[8,39,52,61],[8,39,52,63],
 [8,39,52,67],[8,39,53,58],[8,39,53,60],[8,39,53,63],
 [8,39,53,64],[8,39,53,67],[8,39,58,60],[8,39,58,61],
 [8,39,58,65],[8,39,58,67],[8,39,58,68],[8,39,58,69],
 [8,39,60,61],[8,39,60,63],[8,39,60,65],[8,39,60,67],
 [8,39,60,68],[8,39,60,69],[8,39,61,63],[8,39,61,64],
 [8,39,61,65],[8,39,61,67],[8,39,61,68],[8,39,61,69],
 [8,39,63,64],[8,39,63,65],[8,39,63,67],[8,39,63,69],
 [8,39,64,65],[8,39,64,67],[8,39,64,68],[8,39,64,69],
 [8,39,67,68],[8,39,67,69],[8,39,68,69],[8,40,41,42],
 [8,40,41,44],[8,40,41,48],[8,40,41,53],[8,40,41,59],
 [8,40,41,61],[8,40,41,64],[8,40,41,65],[8,40,41,67],
 [8,40,41,69],[8,40,42,44],[8,40,42,49],[8,40,42,52],
 [8,40,42,55],[8,40,42,59],[8,40,42,61],[8,40,42,63],
 [8,40,42,64],[8,40,42,65],[8,40,42,66],[8,40,42,68],
 [8,40,44,45],[8,40,44,48],[8,40,44,49],[8,40,44,53],
 [8,40,44,59],[8,40,44,61],[8,40,44,64],[8,40,44,65],
 [8,40,44,66],[8,40,44,68],[8,40,44,69],[8,40,45,48],
 [8,40,45,55],[8,40,45,58],[8,40,45,63],[8,40,45,66],
 [8,40,45,67],[8,40,45,69],[8,40,48,49],[8,40,48,52],
 [8,40,48,55],[8,40,48,63],[8,40,48,64],[8,40,48,66],
 [8,40,48,68],[8,40,48,69],[8,40,49,53],[8,40,49,55],
 [8,40,49,58],[8,40,49,61],[8,40,49,63],[8,40,49,64],
 [8,40,49,65],[8,40,49,67],[8,40,49,69],[8,40,52,53],
 [8,40,52,61],[8,40,52,63],[8,40,52,65],[8,40,52,67],
 [8,40,52,69],[8,40,53,58],[8,40,53,63],[8,40,53,64],
 [8,40,53,67],[8,40,53,68],[8,40,55,61],[8,40,55,66],
 [8,40,55,67],[8,40,55,69],[8,40,58,65],[8,40,58,67],
 [8,40,58,68],[8,40,58,69],[8,40,59,61],[8,40,59,63],
 [8,40,59,64],[8,40,59,65],[8,40,59,67],[8,40,59,68],
 [8,40,59,69],[8,40,61,63],[8,40,61,64],[8,40,61,65],
 [8,40,61,66],[8,40,61,68],[8,40,63,64],[8,40,63,65],
 [8,40,63,66],[8,40,63,67],[8,40,63,68],[8,40,63,69],
 [8,40,64,65],[8,40,64,67],[8,40,64,68],[8,40,64,69],
 [8,40,65,68],[8,40,66,67],[8,40,66,68],[8,40,66,69],
 [8,40,67,68],[8,40,67,69],[8,40,68,69],[8,41,42,43],
 [8,41,42,44],[8,41,42,46],[8,41,42,59],[8,41,42,60],
 [8,41,42,61],[8,41,42,62],[8,41,42,64],[8,41,42,65],
 [8,41,43,44],[8,41,43,48],[8,41,43,53],[8,41,43,59],
 [8,41,43,60],[8,41,43,61],[8,41,43,62],[8,41,43,65],
 [8,41,43,67],[8,41,43,69],[8,41,44,46],[8,41,44,48],
 [8,41,44,53],[8,41,44,59],[8,41,44,60],[8,41,44,61],
 [8,41,44,64],[8,41,44,65],[8,41,44,67],[8,41,44,69],
 [8,41,46,48],[8,41,46,53],[8,41,46,59],[8,41,46,61],
 [8,41,46,62],[8,41,46,65],[8,41,46,67],[8,41,46,69],
 [8,41,48,60],[8,41,48,61],[8,41,48,62],[8,41,48,64],
 [8,41,48,69],[8,41,53,60],[8,41,53,62],[8,41,53,64],
 [8,41,59,60],[8,41,59,61],[8,41,59,62],[8,41,59,64],
 [8,41,59,65],[8,41,59,67],[8,41,59,69],[8,41,60,61],
 [8,41,60,62],[8,41,60,65],[8,41,60,67],[8,41,60,69],
 [8,41,61,62],[8,41,61,64],[8,41,61,65],[8,41,61,67],
 [8,41,61,69],[8,41,62,65],[8,41,62,67],[8,41,62,69],
 [8,41,64,65],[8,41,64,67],[8,41,64,69],[8,41,67,69],
 [8,42,43,49],[8,42,43,55],[8,42,43,60],[8,42,43,62],
 [8,42,43,64],[8,42,43,65],[8,42,44,46],[8,42,44,49],
 [8,42,44,50],[8,42,44,51],[8,42,44,55],[8,42,44,59],
 [8,42,44,61],[8,42,44,64],[8,42,44,65],[8,42,44,68],
 [8,42,46,49],[8,42,46,62],[8,42,46,63],[8,42,46,65],
 [8,42,46,68],[8,42,49,55],[8,42,49,60],[8,42,49,61],
 [8,42,49,62],[8,42,49,63],[8,42,49,64],[8,42,49,65],
 [8,42,50,52],[8,42,50,55],[8,42,50,60],[8,42,50,61],
 [8,42,50,62],[8,42,50,64],[8,42,50,65],[8,42,50,66],
 [8,42,50,68],[8,42,51,55],[8,42,51,60],[8,42,51,62],
 [8,42,51,63],[8,42,51,64],[8,42,51,66],[8,42,51,68],
 [8,42,52,61],[8,42,52,62],[8,42,52,63],[8,42,55,60],
 [8,42,55,61],[8,42,55,62],[8,42,55,66],[8,42,59,60],
 [8,42,59,61],[8,42,59,62],[8,42,59,63],[8,42,59,64],
 [8,42,59,65],[8,42,59,68],[8,42,60,62],[8,42,60,63],
 [8,42,60,65],[8,42,60,66],[8,42,60,68],[8,42,61,63],
 [8,42,61,64],[8,42,61,65],[8,42,61,66],[8,42,61,68],
 [8,42,62,63],[8,42,62,65],[8,42,62,66],[8,42,62,68],
 [8,42,63,64],[8,42,63,65],[8,42,63,66],[8,42,63,68],
 [8,42,64,65],[8,42,64,68],[8,42,65,68],[8,43,44,45],
 [8,43,44,48],[8,43,44,49],[8,43,44,53],[8,43,44,55],
 [8,43,44,58],[8,43,44,59],[8,43,44,60],[8,43,44,61],
 [8,43,44,65],[8,43,44,66],[8,43,44,67],[8,43,44,68],
 [8,43,44,69],[8,43,45,48],[8,43,45,49],[8,43,45,55],
 [8,43,45,57],[8,43,45,58],[8,43,45,59],[8,43,45,60],
 [8,43,45,61],[8,43,45,62],[8,43,45,66],[8,43,45,67],
 [8,43,45,68],[8,43,45,69],[8,43,48,49],[8,43,48,52],
 [8,43,48,55],[8,43,48,57],[8,43,48,60],[8,43,48,61],
 [8,43,48,62],[8,43,48,64],[8,43,48,66],[8,43,48,68],
 [8,43,48,69],[8,43,49,53],[8,43,49,55],[8,43,49,56],
 [8,43,49,58],[8,43,49,60],[8,43,49,61],[8,43,49,62],
 [8,43,49,64],[8,43,49,65],[8,43,49,67],[8,43,49,69],
 [8,43,52,53],[8,43,52,57],[8,43,52,61],[8,43,52,65],
 [8,43,52,66],[8,43,52,67],[8,43,52,69],[8,43,53,56],
 [8,43,53,58],[8,43,53,60],[8,43,53,62],[8,43,53,64],
 [8,43,53,67],[8,43,53,68],[8,43,55,60],[8,43,55,61],
 [8,43,55,62],[8,43,55,66],[8,43,55,67],[8,43,55,68],
 [8,43,55,69],[8,43,56,57],[8,43,56,62],[8,43,56,68],
 [8,43,56,69],[8,43,57,58],[8,43,57,59],[8,43,57,60],
 [8,43,57,61],[8,43,57,67],[8,43,57,68],[8,43,58,60],
 [8,43,58,61],[8,43,58,62],[8,43,58,65],[8,43,58,67],
 [8,43,58,68],[8,43,58,69],[8,43,59,60],[8,43,59,61],
 [8,43,59,62],[8,43,59,65],[8,43,59,67],[8,43,59,68],
 [8,43,59,69],[8,43,60,61],[8,43,60,62],[8,43,60,65],
 [8,43,60,66],[8,43,60,67],[8,43,60,68],[8,43,60,69],
 [8,43,61,62],[8,43,61,64],[8,43,61,65],[8,43,61,66],
 [8,43,61,67],[8,43,61,68],[8,43,61,69],[8,43,62,65],
 [8,43,62,66],[8,43,62,67],[8,43,62,68],[8,43,62,69],
 [8,43,64,65],[8,43,64,67],[8,43,64,69],[8,43,66,67],
 [8,43,66,68],[8,43,66,69],[8,43,67,68],[8,43,67,69],
 [8,43,68,69],[8,44,45,46],[8,44,45,48],[8,44,45,49],
 [8,44,45,50],[8,44,45,51],[8,44,45,55],[8,44,45,58],
 [8,44,45,59],[8,44,45,60],[8,44,45,61],[8,44,45,66],
 [8,44,45,67],[8,44,45,68],[8,44,45,69],[8,44,46,48],
 [8,44,46,49],[8,44,46,53],[8,44,46,58],[8,44,46,59],
 [8,44,46,61],[8,44,46,65],[8,44,46,67],[8,44,46,68],
 [8,44,46,69],[8,44,48,49],[8,44,48,51],[8,44,48,53],
 [8,44,48,55],[8,44,48,60],[8,44,48,61],[8,44,48,64],
 [8,44,48,66],[8,44,48,68],[8,44,48,69],[8,44,49,53],
 [8,44,49,55],[8,44,49,56],[8,44,49,58],[8,44,49,60],
 [8,44,49,61],[8,44,49,64],[8,44,49,65],[8,44,49,67],
 [8,44,49,69],[8,44,50,53],[8,44,50,55],[8,44,50,56],
 [8,44,50,58],[8,44,50,59],[8,44,50,60],[8,44,50,61],
 [8,44,50,64],[8,44,50,66],[8,44,50,67],[8,44,50,68],
 [8,44,50,69],[8,44,51,53],[8,44,51,59],[8,44,51,61],
 [8,44,51,65],[8,44,51,66],[8,44,51,67],[8,44,51,68],
 [8,44,51,69],[8,44,53,56],[8,44,53,58],[8,44,53,60],
 [8,44,53,67],[8,44,53,68],[8,44,55,60],[8,44,55,61],
 [8,44,55,66],[8,44,55,67],[8,44,55,68],[8,44,55,69],
 [8,44,56,59],[8,44,56,61],[8,44,56,68],[8,44,56,69],
 [8,44,58,60],[8,44,58,61],[8,44,58,65],[8,44,58,67],
 [8,44,58,68],[8,44,58,69],[8,44,59,60],[8,44,59,61],
 [8,44,59,64],[8,44,59,65],[8,44,59,67],[8,44,59,68],
 [8,44,59,69],[8,44,60,61],[8,44,60,65],[8,44,60,66],
 [8,44,60,67],[8,44,60,68],[8,44,60,69],[8,44,61,64],
 [8,44,61,65],[8,44,61,66],[8,44,61,67],[8,44,61,68],
 [8,44,61,69],[8,44,64,65],[8,44,64,67],[8,44,64,68],
 [8,44,65,68],[8,44,66,67],[8,44,66,68],[8,44,66,69],
 [8,44,67,68],[8,44,67,69],[8,44,68,69],[8,45,46,48],
 [8,45,46,49],[8,45,46,57],[8,45,46,58],[8,45,46,59],
 [8,45,46,61],[8,45,46,62],[8,45,46,63],[8,45,46,67],
 [8,45,46,68],[8,45,46,69],[8,45,48,49],[8,45,48,50],
 [8,45,48,51],[8,45,48,52],[8,45,48,53],[8,45,48,55],
 [8,45,48,57],[8,45,48,60],[8,45,48,61],[8,45,48,62],
 [8,45,48,63],[8,45,48,66],[8,45,48,68],[8,45,48,69],
 [8,45,49,55],[8,45,49,58],[8,45,49,60],[8,45,49,61],
 [8,45,49,62],[8,45,49,63],[8,45,49,67],[8,45,49,69],
 [8,45,50,52],[8,45,50,53],[8,45,50,55],[8,45,50,58],
 [8,45,50,59],[8,45,50,60],[8,45,50,61],[8,45,50,62],
 [8,45,50,66],[8,45,50,67],[8,45,50,68],[8,45,50,69],
 [8,45,51,53],[8,45,51,55],[8,45,51,57],[8,45,51,58],
 [8,45,51,60],[8,45,51,62],[8,45,51,63],[8,45,51,66],
 [8,45,51,67],[8,45,51,68],[8,45,51,69],[8,45,52,53],
 [8,45,52,57],[8,45,52,61],[8,45,52,62],[8,45,52,66],
 [8,45,52,67],[8,45,52,69],[8,45,53,58],[8,45,53,60],
 [8,45,53,62],[8,45,53,63],[8,45,53,67],[8,45,53,68],
 [8,45,55,60],[8,45,55,61],[8,45,55,62],[8,45,55,66],
 [8,45,55,67],[8,45,55,68],[8,45,55,69],[8,45,57,58],
 [8,45,57,59],[8,45,57,60],[8,45,57,67],[8,45,58,60],
 [8,45,58,61],[8,45,58,62],[8,45,58,67],[8,45,58,68],
 [8,45,58,69],[8,45,59,60],[8,45,59,61],[8,45,59,62],
 [8,45,59,67],[8,45,59,68],[8,45,59,69],[8,45,60,61],
 [8,45,60,62],[8,45,60,63],[8,45,60,66],[8,45,60,67],
 [8,45,60,68],[8,45,60,69],[8,45,61,62],[8,45,61,63],
 [8,45,61,66],[8,45,61,67],[8,45,61,68],[8,45,61,69],
 [8,45,62,63],[8,45,62,66],[8,45,62,67],[8,45,62,68],
 [8,45,62,69],[8,45,63,66],[8,45,63,67],[8,45,63,68],
 [8,45,63,69],[8,45,66,67],[8,45,66,68],[8,45,66,69],
 [8,45,67,68],[8,45,67,69],[8,45,68,69],[8,46,48,49],
 [8,46,48,57],[8,46,48,61],[8,46,48,62],[8,46,48,63],
 [8,46,48,68],[8,46,48,69],[8,46,49,53],[8,46,49,56],
 [8,46,49,58],[8,46,49,61],[8,46,49,62],[8,46,49,63],
 [8,46,49,65],[8,46,49,67],[8,46,49,69],[8,46,53,56],
 [8,46,53,58],[8,46,53,62],[8,46,53,63],[8,46,53,67],
 [8,46,53,68],[8,46,56,57],[8,46,56,59],[8,46,56,61],
 [8,46,56,62],[8,46,56,68],[8,46,56,69],[8,46,57,58],
 [8,46,57,61],[8,46,57,67],[8,46,57,68],[8,46,58,61],
 [8,46,58,62],[8,46,58,65],[8,46,58,67],[8,46,58,68],
 [8,46,58,69],[8,46,59,61],[8,46,59,62],[8,46,59,63],
 [8,46,59,65],[8,46,59,67],[8,46,59,68],[8,46,59,69],
 [8,46,61,62],[8,46,61,63],[8,46,61,67],[8,46,61,68],
 [8,46,61,69],[8,46,62,63],[8,46,62,65],[8,46,62,67],
 [8,46,62,68],[8,46,62,69],[8,46,63,65],[8,46,63,67],
 [8,46,63,68],[8,46,63,69],[8,46,65,68],[8,46,67,68],
 [8,46,67,69],[8,46,68,69],[8,48,49,55],[8,48,49,60],
 [8,48,49,61],[8,48,49,62],[8,48,49,63],[8,48,49,64],
 [8,48,49,69],[8,48,50,52],[8,48,50,53],[8,48,50,60],
 [8,48,50,61],[8,48,50,62],[8,48,50,64],[8,48,50,66],
 [8,48,50,68],[8,48,50,69],[8,48,51,53],[8,48,51,60],
 [8,48,51,62],[8,48,51,63],[8,48,51,64],[8,48,51,68],
 [8,48,52,53],[8,48,52,57],[8,48,52,61],[8,48,52,62],
 [8,48,52,63],[8,48,52,66],[8,48,52,69],[8,48,53,60],
 [8,48,53,62],[8,48,53,63],[8,48,53,64],[8,48,53,68],
 [8,48,55,60],[8,48,55,61],[8,48,55,62],[8,48,55,66],
 [8,48,55,68],[8,48,55,69],[8,48,57,60],[8,48,57,61],
 [8,48,57,68],[8,48,60,61],[8,48,60,62],[8,48,60,63],
 [8,48,60,66],[8,48,60,68],[8,48,60,69],[8,48,61,62],
 [8,48,61,63],[8,48,61,66],[8,48,61,68],[8,48,61,69],
 [8,48,62,63],[8,48,62,66],[8,48,62,68],[8,48,62,69],
 [8,48,63,64],[8,48,63,66],[8,48,63,68],[8,48,63,69],
 [8,48,64,68],[8,48,64,69],[8,48,66,68],[8,48,66,69],
 [8,48,68,69],[8,49,53,56],[8,49,53,58],[8,49,53,60],
 [8,49,53,62],[8,49,53,63],[8,49,53,64],[8,49,53,67],
 [8,49,55,60],[8,49,55,61],[8,49,55,62],[8,49,55,67],
 [8,49,55,69],[8,49,56,61],[8,49,56,62],[8,49,56,69],
 [8,49,58,60],[8,49,58,61],[8,49,58,62],[8,49,58,65],
 [8,49,58,67],[8,49,58,69],[8,49,60,61],[8,49,60,62],
 [8,49,60,63],[8,49,60,65],[8,49,60,67],[8,49,60,69],
 [8,49,61,62],[8,49,61,63],[8,49,61,64],[8,49,61,65],
 [8,49,61,67],[8,49,61,69],[8,49,62,63],[8,49,62,65],
 [8,49,62,67],[8,49,62,69],[8,49,63,64],[8,49,63,65],
 [8,49,63,67],[8,49,63,69],[8,49,64,65],[8,49,64,67],
 [8,49,64,69],[8,49,67,69],[8,50,52,53],[8,50,52,61],
 [8,50,52,62],[8,50,52,65],[8,50,52,66],[8,50,52,67],
 [8,50,52,69],[8,50,53,56],[8,50,53,58],[8,50,53,60],
 [8,50,53,62],[8,50,53,64],[8,50,53,67],[8,50,53,68],
 [8,50,55,60],[8,50,55,61],[8,50,55,62],[8,50,55,67],
 [8,50,55,68],[8,50,55,69],[8,50,56,59],[8,50,56,61],
 [8,50,56,62],[8,50,56,66],[8,50,56,69],[8,50,58,60],
 [8,50,58,61],[8,50,58,62],[8,50,58,65],[8,50,58,67],
 [8,50,58,68],[8,50,58,69],[8,50,59,60],[8,50,59,61],
 [8,50,59,62],[8,50,59,64],[8,50,59,65],[8,50,59,67],
 [8,50,59,68],[8,50,60,61],[8,50,60,62],[8,50,60,65],
 [8,50,60,66],[8,50,60,67],[8,50,60,68],[8,50,60,69],
 [8,50,61,62],[8,50,61,64],[8,50,61,65],[8,50,61,66],
 [8,50,61,67],[8,50,61,68],[8,50,61,69],[8,50,62,65],
 [8,50,62,66],[8,50,62,67],[8,50,62,68],[8,50,62,69],
 [8,50,64,65],[8,50,64,67],[8,50,64,68],[8,50,64,69],
 [8,50,65,68],[8,50,66,67],[8,50,66,68],[8,50,66,69],
 [8,50,67,68],[8,50,67,69],[8,50,68,69],[8,51,53,56],
 [8,51,53,58],[8,51,53,60],[8,51,53,62],[8,51,53,63],
 [8,51,53,64],[8,51,53,67],[8,51,53,68],[8,51,55,60],
 [8,51,55,61],[8,51,55,62],[8,51,55,66],[8,51,55,67],
 [8,51,55,68],[8,51,55,69],[8,51,56,57],[8,51,56,59],
 [8,51,56,61],[8,51,56,62],[8,51,56,66],[8,51,56,68],
 [8,51,56,69],[8,51,57,58],[8,51,57,59],[8,51,57,60],
 [8,51,57,61],[8,51,57,67],[8,51,57,68],[8,51,58,60],
 [8,51,58,61],[8,51,58,62],[8,51,58,65],[8,51,58,67],
 [8,51,58,68],[8,51,58,69],[8,51,59,60],[8,51,59,61],
 [8,51,59,62],[8,51,59,63],[8,51,59,64],[8,51,59,65],
 [8,51,59,67],[8,51,59,68],[8,51,59,69],[8,51,60,61],
 [8,51,60,62],[8,51,60,63],[8,51,60,65],[8,51,60,66],
 [8,51,60,67],[8,51,60,68],[8,51,60,69],[8,51,61,62],
 [8,51,61,63],[8,51,61,64],[8,51,61,65],[8,51,61,66],
 [8,51,61,67],[8,51,61,68],[8,51,61,69],[8,51,62,63],
 [8,51,62,65],[8,51,62,66],[8,51,62,67],[8,51,62,68],
 [8,51,62,69],[8,51,63,64],[8,51,63,65],[8,51,63,66],
 [8,51,63,67],[8,51,63,68],[8,51,63,69],[8,51,64,65],
 [8,51,64,67],[8,51,64,68],[8,51,64,69],[8,51,65,68],
 [8,51,66,67],[8,51,66,68],[8,51,66,69],[8,51,67,68],
 [8,51,67,69],[8,51,68,69],[8,52,53,62],[8,52,53,63],
 [8,52,53,67],[8,52,57,61],[8,52,61,62],[8,52,61,63],
 [8,52,61,69],[8,52,62,63],[8,52,62,65],[8,52,62,66],
 [8,52,62,67],[8,52,62,69],[8,52,63,65],[8,52,63,66],
 [8,52,63,67],[8,52,63,69],[8,52,66,69],[8,53,56,62],
 [8,53,58,60],[8,53,58,62],[8,53,60,62],[8,53,60,63],
 [8,53,60,68],[8,53,62,63],[8,53,62,67],[8,53,62,68],
 [8,53,63,64],[8,53,63,67],[8,53,63,68],[8,53,64,68],
 [8,55,60,61],[8,55,60,62],[8,55,60,66],[8,55,60,67],
 [8,55,60,68],[8,55,60,69],[8,55,61,62],[8,55,61,66],
 [8,55,61,67],[8,55,61,68],[8,55,61,69],[8,55,62,66],
 [8,55,62,67],[8,55,62,68],[8,55,62,69],[8,55,66,67],
 [8,55,66,68],[8,55,66,69],[8,55,67,68],[8,55,67,69],
 [8,55,68,69],[8,56,57,59],[8,56,57,61],[8,56,57,68],
 [8,56,59,61],[8,56,59,62],[8,56,59,68],[8,56,61,62],
 [8,56,61,68],[8,56,61,69],[8,56,62,66],[8,56,62,69],
 [8,56,66,69],[8,57,58,60],[8,57,58,61],[8,57,58,67],
 [8,57,59,60],[8,57,59,61],[8,57,59,68],[8,57,60,61],
 [8,57,60,67],[8,57,61,67],[8,57,61,68],[8,58,60,61],
 [8,58,60,62],[8,58,60,65],[8,58,60,67],[8,58,60,68],
 [8,58,60,69],[8,58,61,62],[8,58,61,67],[8,58,61,68],
 [8,58,61,69],[8,58,62,65],[8,58,62,67],[8,58,62,68],
 [8,58,62,69],[8,58,67,68],[8,58,67,69],[8,58,68,69],
 [8,59,60,61],[8,59,60,62],[8,59,60,63],[8,59,60,67],
 [8,59,60,68],[8,59,60,69],[8,59,61,62],[8,59,61,63],
 [8,59,61,64],[8,59,61,65],[8,59,61,67],[8,59,61,68],
 [8,59,61,69],[8,59,62,63],[8,59,62,65],[8,59,62,67],
 [8,59,62,68],[8,59,62,69],[8,59,63,64],[8,59,63,65],
 [8,59,63,67],[8,59,63,68],[8,59,63,69],[8,59,64,65],
 [8,59,64,68],[8,59,64,69],[8,59,65,68],[8,59,67,68],
 [8,59,67,69],[8,59,68,69],[8,60,61,62],[8,60,61,63],
 [8,60,61,66],[8,60,61,67],[8,60,61,68],[8,60,61,69],
 [8,60,62,63],[8,60,62,65],[8,60,62,66],[8,60,62,67],
 [8,60,62,68],[8,60,62,69],[8,60,63,65],[8,60,63,66],
 [8,60,63,67],[8,60,63,68],[8,60,63,69],[8,60,65,68],
 [8,60,66,67],[8,60,66,68],[8,60,66,69],[8,60,67,68],
 [8,60,67,69],[8,60,68,69],[8,61,62,63],[8,61,62,66],
 [8,61,62,67],[8,61,62,68],[8,61,62,69],[8,61,63,64],
 [8,61,63,65],[8,61,63,66],[8,61,63,67],[8,61,63,68],
 [8,61,63,69],[8,61,64,65],[8,61,64,68],[8,61,65,68],
 [8,61,66,67],[8,61,66,68],[8,61,66,69],[8,61,67,68],
 [8,61,67,69],[8,61,68,69],[8,62,63,65],[8,62,63,66],
 [8,62,63,67],[8,62,63,68],[8,62,63,69],[8,62,65,68],
 [8,62,66,67],[8,62,66,68],[8,62,66,69],[8,62,67,68],
 [8,62,67,69],[8,62,68,69],[8,63,64,65],[8,63,64,67],
 [8,63,64,68],[8,63,64,69],[8,63,65,68],[8,63,66,67],
 [8,63,66,68],[8,63,66,69],[8,63,67,68],[8,63,67,69],
 [8,63,68,69],[8,64,65,68],[8,64,67,68],[8,64,67,69],
 [8,64,68,69],[8,66,67,68],[8,66,67,69],[8,66,68,69],
 [8,67,68,69],[9,11,13,16],[9,11,13,19],[9,11,13,20],
 [9,11,13,21],[9,11,13,23],[9,11,13,24],[9,11,13,25],
 [9,11,13,41],[9,11,13,43],[9,11,13,46],[9,11,13,47],
 [9,11,13,53],[9,11,13,60],[9,11,13,62],[9,11,13,68],
 [9,11,14,17],[9,11,14,18],[9,11,14,20],[9,11,14,24],
 [9,11,14,25],[9,11,14,27],[9,11,14,41],[9,11,14,44],
 [9,11,14,47],[9,11,14,49],[9,11,14,53],[9,11,14,60],
 [9,11,14,62],[9,11,14,68],[9,11,16,19],[9,11,16,20],
 [9,11,16,21],[9,11,16,24],[9,11,16,25],[9,11,16,27],
 [9,11,16,41],[9,11,16,43],[9,11,16,45],[9,11,16,46],
 [9,11,16,47],[9,11,16,48],[9,11,16,49],[9,11,16,51],
 [9,11,16,53],[9,11,16,60],[9,11,16,62],[9,11,16,68],
 [9,11,17,18],[9,11,17,19],[9,11,17,20],[9,11,17,23],
 [9,11,17,24],[9,11,17,41],[9,11,17,46],[9,11,17,47],
 [9,11,17,48],[9,11,17,49],[9,11,17,51],[9,11,17,53],
 [9,11,17,54],[9,11,17,68],[9,11,18,19],[9,11,18,20],
 [9,11,18,23],[9,11,18,24],[9,11,18,41],[9,11,18,44],
 [9,11,18,46],[9,11,18,47],[9,11,18,48],[9,11,18,49],
 [9,11,18,51],[9,11,18,53],[9,11,18,54],[9,11,18,68],
 [9,11,19,20],[9,11,19,21],[9,11,19,23],[9,11,19,24],
 [9,11,19,25],[9,11,19,27],[9,11,19,41],[9,11,19,43],
 [9,11,19,44],[9,11,19,46],[9,11,19,47],[9,11,19,49],
 [9,11,19,53],[9,11,19,60],[9,11,19,62],[9,11,19,63],
 [9,11,19,64],[9,11,19,68],[9,11,20,23],[9,11,20,24],
 [9,11,20,25],[9,11,20,27],[9,11,20,31],[9,11,20,38],
 [9,11,20,40],[9,11,20,41],[9,11,20,43],[9,11,20,44],
 [9,11,20,45],[9,11,20,46],[9,11,20,47],[9,11,20,49],
 [9,11,20,53],[9,11,20,60],[9,11,20,62],[9,11,20,63],
 [9,11,20,64],[9,11,20,68],[9,11,21,23],[9,11,21,24],
 [9,11,21,25],[9,11,21,27],[9,11,21,41],[9,11,21,43],
 [9,11,21,44],[9,11,21,45],[9,11,21,46],[9,11,21,48],
 [9,11,21,49],[9,11,21,51],[9,11,21,53],[9,11,21,60],
 [9,11,21,62],[9,11,21,68],[9,11,23,24],[9,11,23,25],
 [9,11,23,27],[9,11,23,41],[9,11,23,43],[9,11,23,44],
 [9,11,23,46],[9,11,23,47],[9,11,23,49],[9,11,23,53],
 [9,11,23,60],[9,11,23,62],[9,11,23,68],[9,11,24,25],
 [9,11,24,27],[9,11,24,29],[9,11,24,30],[9,11,24,31],
 [9,11,24,38],[9,11,24,40],[9,11,24,41],[9,11,24,43],
 [9,11,24,44],[9,11,24,45],[9,11,24,46],[9,11,24,47],
 [9,11,24,48],[9,11,24,49],[9,11,24,51],[9,11,24,53],
 [9,11,24,54],[9,11,24,60],[9,11,24,62],[9,11,24,63],
 [9,11,24,64],[9,11,24,68],[9,11,25,27],[9,11,25,41],
 [9,11,25,43],[9,11,25,45],[9,11,25,46],[9,11,25,47],
 [9,11,25,48],[9,11,25,49],[9,11,25,51],[9,11,25,53],
 [9,11,25,54],[9,11,25,60],[9,11,25,62],[9,11,25,68],
 [9,11,27,41],[9,11,27,45],[9,11,27,46],[9,11,27,47],
 [9,11,27,48],[9,11,27,49],[9,11,27,51],[9,11,27,53],
 [9,11,27,54],[9,11,27,60],[9,11,27,62],[9,11,27,68],
 [9,11,29,31],[9,11,29,41],[9,11,29,44],[9,11,29,47],
 [9,11,29,49],[9,11,29,53],[9,11,29,68],[9,11,30,41],
 [9,11,30,44],[9,11,30,47],[9,11,30,48],[9,11,30,49],
 [9,11,30,53],[9,11,30,68],[9,11,31,41],[9,11,31,44],
 [9,11,31,47],[9,11,31,48],[9,11,31,49],[9,11,31,53],
 [9,11,31,68],[9,11,38,40],[9,11,38,41],[9,11,38,47],
 [9,11,38,49],[9,11,38,53],[9,11,38,63],[9,11,38,64],
 [9,11,38,68],[9,11,40,41],[9,11,40,47],[9,11,40,48],
 [9,11,40,49],[9,11,40,53],[9,11,40,63],[9,11,40,64],
 [9,11,40,68],[9,11,41,43],[9,11,41,44],[9,11,41,46],
 [9,11,41,47],[9,11,41,48],[9,11,41,49],[9,11,41,53],
 [9,11,41,60],[9,11,41,62],[9,11,41,63],[9,11,41,64],
 [9,11,41,68],[9,11,43,46],[9,11,43,47],[9,11,43,48],
 [9,11,43,49],[9,11,43,53],[9,11,43,60],[9,11,43,62],
 [9,11,43,68],[9,11,44,45],[9,11,44,46],[9,11,44,47],
 [9,11,44,48],[9,11,44,49],[9,11,44,51],[9,11,44,53],
 [9,11,44,54],[9,11,44,62],[9,11,44,63],[9,11,44,64],
 [9,11,44,68],[9,11,45,46],[9,11,45,48],[9,11,45,49],
 [9,11,45,51],[9,11,45,53],[9,11,45,60],[9,11,45,62],
 [9,11,45,68],[9,11,46,47],[9,11,46,48],[9,11,46,49],
 [9,11,46,53],[9,11,46,60],[9,11,46,62],[9,11,46,68],
 [9,11,47,49],[9,11,47,53],[9,11,47,60],[9,11,47,62],
 [9,11,47,63],[9,11,47,64],[9,11,47,68],[9,11,48,49],
 [9,11,48,51],[9,11,48,53],[9,11,48,60],[9,11,48,62],
 [9,11,48,63],[9,11,48,64],[9,11,48,68],[9,11,49,53],
 [9,11,49,54],[9,11,49,60],[9,11,49,62],[9,11,49,63],
 [9,11,49,64],[9,11,49,68],[9,11,51,53],[9,11,51,60],
 [9,11,51,62],[9,11,51,63],[9,11,51,64],[9,11,51,68],
 [9,11,53,54],[9,11,53,60],[9,11,53,62],[9,11,53,63],
 [9,11,53,64],[9,11,53,68],[9,11,54,60],[9,11,54,62],
 [9,11,54,68],[9,11,60,62],[9,11,60,68],[9,11,62,68],
 [9,11,63,64],[9,11,63,68],[9,11,64,68],[9,13,15,16],
 [9,13,15,19],[9,13,15,20],[9,13,15,21],[9,13,15,22],
 [9,13,15,23],[9,13,15,24],[9,13,15,25],[9,13,15,26],
 [9,13,15,27],[9,13,15,34],[9,13,15,37],[9,13,15,39],
 [9,13,15,41],[9,13,15,43],[9,13,15,44],[9,13,15,45],
 [9,13,15,46],[9,13,15,47],[9,13,15,48],[9,13,15,49],
 [9,13,15,55],[9,13,15,58],[9,13,15,59],[9,13,15,60],
 [9,13,15,61],[9,13,15,62],[9,13,15,66],[9,13,15,67],
 [9,13,15,68],[9,13,15,69],[9,13,16,19],[9,13,16,20],
 [9,13,16,21],[9,13,16,22],[9,13,16,23],[9,13,16,24],
 [9,13,16,25],[9,13,16,26],[9,13,16,27],[9,13,16,34],
 [9,13,16,39],[9,13,16,41],[9,13,16,43],[9,13,16,44],
 [9,13,16,45],[9,13,16,46],[9,13,16,47],[9,13,16,48],
 [9,13,16,49],[9,13,16,53],[9,13,16,55],[9,13,16,58],
 [9,13,16,59],[9,13,16,60],[9,13,16,61],[9,13,16,62],
 [9,13,16,66],[9,13,16,67],[9,13,16,68],[9,13,16,69],
 [9,13,19,20],[9,13,19,21],[9,13,19,22],[9,13,19,23],
 [9,13,19,24],[9,13,19,25],[9,13,19,26],[9,13,19,27],
 [9,13,19,34],[9,13,19,36],[9,13,19,39],[9,13,19,41],
 [9,13,19,43],[9,13,19,44],[9,13,19,45],[9,13,19,46],
 [9,13,19,47],[9,13,19,48],[9,13,19,49],[9,13,19,53],
 [9,13,19,55],[9,13,19,58],[9,13,19,59],[9,13,19,60],
 [9,13,19,61],[9,13,19,62],[9,13,19,66],[9,13,19,67],
 [9,13,19,68],[9,13,19,69],[9,13,20,21],[9,13,20,22],
 [9,13,20,23],[9,13,20,24],[9,13,20,25],[9,13,20,26],
 [9,13,20,27],[9,13,20,34],[9,13,20,36],[9,13,20,39],
 [9,13,20,41],[9,13,20,43],[9,13,20,44],[9,13,20,45],
 [9,13,20,46],[9,13,20,47],[9,13,20,48],[9,13,20,49],
 [9,13,20,55],[9,13,20,58],[9,13,20,59],[9,13,20,60],
 [9,13,20,61],[9,13,20,62],[9,13,20,66],[9,13,20,67],
 [9,13,20,68],[9,13,20,69],[9,13,21,22],[9,13,21,23],
 [9,13,21,24],[9,13,21,25],[9,13,21,26],[9,13,21,27],
 [9,13,21,34],[9,13,21,37],[9,13,21,39],[9,13,21,41],
 [9,13,21,43],[9,13,21,44],[9,13,21,45],[9,13,21,46],
 [9,13,21,47],[9,13,21,48],[9,13,21,49],[9,13,21,53],
 [9,13,21,55],[9,13,21,58],[9,13,21,59],[9,13,21,60],
 [9,13,21,61],[9,13,21,62],[9,13,21,66],[9,13,21,67],
 [9,13,21,68],[9,13,21,69],[9,13,22,23],[9,13,22,24],
 [9,13,22,25],[9,13,22,26],[9,13,22,27],[9,13,22,34],
 [9,13,22,39],[9,13,22,41],[9,13,22,43],[9,13,22,44],
 [9,13,22,45],[9,13,22,46],[9,13,22,47],[9,13,22,48],
 [9,13,22,49],[9,13,22,55],[9,13,22,58],[9,13,22,59],
 [9,13,22,60],[9,13,22,61],[9,13,22,62],[9,13,22,66],
 [9,13,22,67],[9,13,22,68],[9,13,22,69],[9,13,23,24],
 [9,13,23,25],[9,13,23,26],[9,13,23,27],[9,13,23,34],
 [9,13,23,36],[9,13,23,37],[9,13,23,39],[9,13,23,41],
 [9,13,23,43],[9,13,23,44],[9,13,23,45],[9,13,23,46],
 [9,13,23,47],[9,13,23,48],[9,13,23,49],[9,13,23,53],
 [9,13,23,55],[9,13,23,58],[9,13,23,59],[9,13,23,60],
 [9,13,23,61],[9,13,23,62],[9,13,23,66],[9,13,23,67],
 [9,13,23,68],[9,13,23,69],[9,13,24,25],[9,13,24,26],
 [9,13,24,27],[9,13,24,34],[9,13,24,36],[9,13,24,37],
 [9,13,24,39],[9,13,24,41],[9,13,24,43],[9,13,24,44],
 [9,13,24,45],[9,13,24,46],[9,13,24,47],[9,13,24,48],
 [9,13,24,49],[9,13,24,53],[9,13,24,55],[9,13,24,58],
 [9,13,24,59],[9,13,24,60],[9,13,24,61],[9,13,24,62],
 [9,13,24,66],[9,13,24,67],[9,13,24,68],[9,13,24,69],
 [9,13,25,26],[9,13,25,27],[9,13,25,34],[9,13,25,37],
 [9,13,25,39],[9,13,25,41],[9,13,25,43],[9,13,25,44],
 [9,13,25,45],[9,13,25,46],[9,13,25,47],[9,13,25,48],
 [9,13,25,49],[9,13,25,53],[9,13,25,55],[9,13,25,58],
 [9,13,25,59],[9,13,25,60],[9,13,25,61],[9,13,25,62],
 [9,13,25,66],[9,13,25,67],[9,13,25,68],[9,13,25,69],
 [9,13,26,27],[9,13,26,34],[9,13,26,36],[9,13,26,39],
 [9,13,26,41],[9,13,26,43],[9,13,26,44],[9,13,26,45],
 [9,13,26,46],[9,13,26,47],[9,13,26,48],[9,13,26,49],
 [9,13,26,55],[9,13,26,58],[9,13,26,59],[9,13,26,60],
 [9,13,26,61],[9,13,26,62],[9,13,26,66],[9,13,26,67],
 [9,13,26,68],[9,13,26,69],[9,13,27,34],[9,13,27,36],
 [9,13,27,39],[9,13,27,41],[9,13,27,43],[9,13,27,44],
 [9,13,27,45],[9,13,27,46],[9,13,27,47],[9,13,27,48],
 [9,13,27,49],[9,13,27,53],[9,13,27,55],[9,13,27,58],
 [9,13,27,59],[9,13,27,60],[9,13,27,61],[9,13,27,62],
 [9,13,27,66],[9,13,27,67],[9,13,27,68],[9,13,27,69],
 [9,13,34,39],[9,13,34,41],[9,13,34,43],[9,13,34,44],
 [9,13,34,45],[9,13,34,46],[9,13,34,47],[9,13,34,48],
 [9,13,34,49],[9,13,34,55],[9,13,34,58],[9,13,34,59],
 [9,13,34,60],[9,13,34,61],[9,13,34,62],[9,13,34,66],
 [9,13,34,67],[9,13,34,68],[9,13,34,69],[9,13,36,37],
 [9,13,36,43],[9,13,36,45],[9,13,36,46],[9,13,36,48],
 [9,13,36,60],[9,13,36,62],[9,13,36,68],[9,13,37,43],
 [9,13,37,46],[9,13,37,60],[9,13,37,61],[9,13,37,62],
 [9,13,37,68],[9,13,39,41],[9,13,39,43],[9,13,39,44],
 [9,13,39,45],[9,13,39,46],[9,13,39,47],[9,13,39,48],
 [9,13,39,49],[9,13,39,55],[9,13,39,58],[9,13,39,59],
 [9,13,39,60],[9,13,39,61],[9,13,39,62],[9,13,39,66],
 [9,13,39,67],[9,13,39,68],[9,13,39,69],[9,13,41,43],
 [9,13,41,44],[9,13,41,45],[9,13,41,46],[9,13,41,47],
 [9,13,41,48],[9,13,41,49],[9,13,41,53],[9,13,41,55],
 [9,13,41,58],[9,13,41,59],[9,13,41,60],[9,13,41,61],
 [9,13,41,62],[9,13,41,66],[9,13,41,67],[9,13,41,68],
 [9,13,41,69],[9,13,43,44],[9,13,43,45],[9,13,43,46],
 [9,13,43,47],[9,13,43,48],[9,13,43,49],[9,13,43,55],
 [9,13,43,58],[9,13,43,59],[9,13,43,60],[9,13,43,61],
 [9,13,43,62],[9,13,43,66],[9,13,43,67],[9,13,43,68],
 [9,13,43,69],[9,13,44,45],[9,13,44,46],[9,13,44,47],
 [9,13,44,48],[9,13,44,49],[9,13,44,53],[9,13,44,55],
 [9,13,44,58],[9,13,44,59],[9,13,44,60],[9,13,44,61],
 [9,13,44,62],[9,13,44,66],[9,13,44,67],[9,13,44,68],
 [9,13,44,69],[9,13,45,46],[9,13,45,47],[9,13,45,48],
 [9,13,45,49],[9,13,45,53],[9,13,45,55],[9,13,45,58],
 [9,13,45,59],[9,13,45,60],[9,13,45,61],[9,13,45,62],
 [9,13,45,66],[9,13,45,67],[9,13,45,68],[9,13,45,69],
 [9,13,46,47],[9,13,46,48],[9,13,46,49],[9,13,46,53],
 [9,13,46,55],[9,13,46,58],[9,13,46,59],[9,13,46,60],
 [9,13,46,61],[9,13,46,62],[9,13,46,66],[9,13,46,67],
 [9,13,46,68],[9,13,46,69],[9,13,47,48],[9,13,47,49],
 [9,13,47,53],[9,13,47,55],[9,13,47,58],[9,13,47,59],
 [9,13,47,60],[9,13,47,61],[9,13,47,62],[9,13,47,66],
 [9,13,47,67],[9,13,47,68],[9,13,47,69],[9,13,48,49],
 [9,13,48,53],[9,13,48,55],[9,13,48,58],[9,13,48,59],
 [9,13,48,60],[9,13,48,61],[9,13,48,62],[9,13,48,66],
 [9,13,48,67],[9,13,48,68],[9,13,48,69],[9,13,49,53],
 [9,13,49,55],[9,13,49,58],[9,13,49,59],[9,13,49,60],
 [9,13,49,61],[9,13,49,62],[9,13,49,66],[9,13,49,67],
 [9,13,49,68],[9,13,49,69],[9,13,53,60],[9,13,53,68],
 [9,13,55,58],[9,13,55,59],[9,13,55,60],[9,13,55,61],
 [9,13,55,62],[9,13,55,66],[9,13,55,67],[9,13,55,68],
 [9,13,55,69],[9,13,58,59],[9,13,58,60],[9,13,58,61],
 [9,13,58,62],[9,13,58,66],[9,13,58,67],[9,13,58,68],
 [9,13,58,69],[9,13,59,60],[9,13,59,61],[9,13,59,62],
 [9,13,59,66],[9,13,59,67],[9,13,59,68],[9,13,59,69],
 [9,13,60,61],[9,13,60,62],[9,13,60,66],[9,13,60,67],
 [9,13,60,68],[9,13,60,69],[9,13,61,62],[9,13,61,66],
 [9,13,61,67],[9,13,61,68],[9,13,61,69],[9,13,62,66],
 [9,13,62,67],[9,13,62,68],[9,13,62,69],[9,13,66,67],
 [9,13,66,68],[9,13,66,69],[9,13,67,68],[9,13,67,69],
 [9,13,68,69],[9,14,15,17],[9,14,15,18],[9,14,15,20],
 [9,14,15,22],[9,14,15,24],[9,14,15,25],[9,14,15,26],
 [9,14,15,27],[9,14,15,36],[9,14,15,37],[9,14,15,41],
 [9,14,15,44],[9,14,15,45],[9,14,15,47],[9,14,15,49],
 [9,14,15,54],[9,14,15,56],[9,14,15,57],[9,14,15,59],
 [9,14,15,60],[9,14,15,61],[9,14,15,62],[9,14,15,67],
 [9,14,15,68],[9,14,15,69],[9,14,17,18],[9,14,17,20],
 [9,14,17,22],[9,14,17,24],[9,14,17,26],[9,14,17,41],
 [9,14,17,44],[9,14,17,47],[9,14,17,49],[9,14,17,53],
 [9,14,17,54],[9,14,17,56],[9,14,17,57],[9,14,17,59],
 [9,14,17,61],[9,14,17,68],[9,14,18,20],[9,14,18,22],
 [9,14,18,24],[9,14,18,26],[9,14,18,41],[9,14,18,44],
 [9,14,18,47],[9,14,18,49],[9,14,18,53],[9,14,18,54],
 [9,14,18,56],[9,14,18,57],[9,14,18,59],[9,14,18,61],
 [9,14,18,68],[9,14,20,21],[9,14,20,22],[9,14,20,24],
 [9,14,20,25],[9,14,20,26],[9,14,20,27],[9,14,20,36],
 [9,14,20,37],[9,14,20,41],[9,14,20,44],[9,14,20,45],
 [9,14,20,47],[9,14,20,49],[9,14,20,53],[9,14,20,54],
 [9,14,20,56],[9,14,20,57],[9,14,20,59],[9,14,20,61],
 [9,14,20,62],[9,14,20,67],[9,14,20,68],[9,14,21,22],
 [9,14,21,24],[9,14,21,25],[9,14,21,27],[9,14,21,45],
 [9,14,21,59],[9,14,21,60],[9,14,21,62],[9,14,21,67],
 [9,14,21,68],[9,14,21,69],[9,14,22,24],[9,14,22,26],
 [9,14,22,27],[9,14,22,37],[9,14,22,41],[9,14,22,44],
 [9,14,22,47],[9,14,22,49],[9,14,22,54],[9,14,22,56],
 [9,14,22,57],[9,14,22,59],[9,14,22,60],[9,14,22,61],
 [9,14,22,67],[9,14,22,68],[9,14,22,69],[9,14,24,25],
 [9,14,24,26],[9,14,24,27],[9,14,24,36],[9,14,24,37],
 [9,14,24,41],[9,14,24,44],[9,14,24,45],[9,14,24,47],
 [9,14,24,49],[9,14,24,53],[9,14,24,54],[9,14,24,56],
 [9,14,24,57],[9,14,24,59],[9,14,24,60],[9,14,24,61],
 [9,14,24,62],[9,14,24,67],[9,14,24,68],[9,14,24,69],
 [9,14,25,26],[9,14,25,27],[9,14,25,37],[9,14,25,45],
 [9,14,25,49],[9,14,25,53],[9,14,25,54],[9,14,25,59],
 [9,14,25,60],[9,14,25,61],[9,14,25,62],[9,14,25,67],
 [9,14,25,68],[9,14,25,69],[9,14,26,27],[9,14,26,36],
 [9,14,26,37],[9,14,26,41],[9,14,26,44],[9,14,26,47],
 [9,14,26,49],[9,14,26,54],[9,14,26,56],[9,14,26,57],
 [9,14,26,59],[9,14,26,60],[9,14,26,61],[9,14,26,62],
 [9,14,26,67],[9,14,26,68],[9,14,26,69],[9,14,27,36],
 [9,14,27,45],[9,14,27,47],[9,14,27,53],[9,14,27,54],
 [9,14,27,60],[9,14,27,61],[9,14,27,62],[9,14,27,67],
 [9,14,27,68],[9,14,27,69],[9,14,36,37],[9,14,36,45],
 [9,14,36,54],[9,14,36,60],[9,14,36,61],[9,14,36,62],
 [9,14,36,68],[9,14,37,45],[9,14,37,54],[9,14,37,60],
 [9,14,37,61],[9,14,37,62],[9,14,37,68],[9,14,41,44],
 [9,14,41,45],[9,14,41,47],[9,14,41,49],[9,14,41,53],
 [9,14,41,54],[9,14,41,56],[9,14,41,57],[9,14,41,59],
 [9,14,41,60],[9,14,41,61],[9,14,41,62],[9,14,41,68],
 [9,14,44,45],[9,14,44,47],[9,14,44,49],[9,14,44,53],
 [9,14,44,54],[9,14,44,56],[9,14,44,57],[9,14,44,59],
 [9,14,44,60],[9,14,44,61],[9,14,44,67],[9,14,44,68],
 [9,14,44,69],[9,14,45,47],[9,14,45,53],[9,14,45,54],
 [9,14,45,59],[9,14,45,60],[9,14,45,61],[9,14,45,62],
 [9,14,45,67],[9,14,45,68],[9,14,45,69],[9,14,47,49],
 [9,14,47,53],[9,14,47,54],[9,14,47,56],[9,14,47,57],
 [9,14,47,59],[9,14,47,61],[9,14,47,62],[9,14,47,68],
 [9,14,47,69],[9,14,49,53],[9,14,49,54],[9,14,49,56],
 [9,14,49,57],[9,14,49,59],[9,14,49,60],[9,14,49,61],
 [9,14,49,67],[9,14,49,68],[9,14,53,54],[9,14,53,60],
 [9,14,53,62],[9,14,53,68],[9,14,54,56],[9,14,54,57],
 [9,14,54,59],[9,14,54,60],[9,14,54,61],[9,14,54,62],
 [9,14,54,67],[9,14,54,68],[9,14,54,69],[9,14,56,57],
 [9,14,56,59],[9,14,56,61],[9,14,56,68],[9,14,57,59],
 [9,14,57,61],[9,14,57,68],[9,14,59,60],[9,14,59,61],
 [9,14,59,67],[9,14,59,68],[9,14,59,69],[9,14,60,61],
 [9,14,60,62],[9,14,60,67],[9,14,60,68],[9,14,60,69],
 [9,14,61,62],[9,14,61,67],[9,14,61,68],[9,14,61,69],
 [9,14,62,67],[9,14,62,68],[9,14,62,69],[9,14,67,68],
 [9,14,67,69],[9,14,68,69],[9,15,16,19],[9,15,16,20],
 [9,15,16,21],[9,15,16,22],[9,15,16,23],[9,15,16,24],
 [9,15,16,25],[9,15,16,26],[9,15,16,27],[9,15,16,34],
 [9,15,16,36],[9,15,16,39],[9,15,16,41],[9,15,16,42],
 [9,15,16,43],[9,15,16,44],[9,15,16,45],[9,15,16,46],
 [9,15,16,47],[9,15,16,48],[9,15,16,49],[9,15,16,51],
 [9,15,16,55],[9,15,16,58],[9,15,16,59],[9,15,16,60],
 [9,15,16,61],[9,15,16,62],[9,15,16,66],[9,15,16,67],
 [9,15,16,68],[9,15,16,69],[9,15,17,18],[9,15,17,19],
 [9,15,17,20],[9,15,17,22],[9,15,17,23],[9,15,17,24],
 [9,15,17,26],[9,15,17,41],[9,15,17,44],[9,15,17,46],
 [9,15,17,47],[9,15,17,48],[9,15,17,49],[9,15,17,51],
 [9,15,17,54],[9,15,17,56],[9,15,17,57],[9,15,17,59],
 [9,15,17,61],[9,15,17,66],[9,15,17,68],[9,15,18,20],
 [9,15,18,22],[9,15,18,23],[9,15,18,24],[9,15,18,26],
 [9,15,18,41],[9,15,18,44],[9,15,18,46],[9,15,18,47],
 [9,15,18,48],[9,15,18,49],[9,15,18,51],[9,15,18,54],
 [9,15,18,56],[9,15,18,57],[9,15,18,59],[9,15,18,61],
 [9,15,18,68],[9,15,19,20],[9,15,19,21],[9,15,19,22],
 [9,15,19,23],[9,15,19,24],[9,15,19,25],[9,15,19,26],
 [9,15,19,27],[9,15,19,34],[9,15,19,36],[9,15,19,37],
 [9,15,19,39],[9,15,19,41],[9,15,19,43],[9,15,19,44],
 [9,15,19,45],[9,15,19,46],[9,15,19,47],[9,15,19,48],
 [9,15,19,49],[9,15,19,55],[9,15,19,58],[9,15,19,59],
 [9,15,19,60],[9,15,19,61],[9,15,19,62],[9,15,19,64],
 [9,15,19,66],[9,15,19,67],[9,15,19,68],[9,15,19,69],
 [9,15,20,21],[9,15,20,22],[9,15,20,23],[9,15,20,24],
 [9,15,20,25],[9,15,20,26],[9,15,20,27],[9,15,20,28],
 [9,15,20,29],[9,15,20,30],[9,15,20,31],[9,15,20,32],
 [9,15,20,34],[9,15,20,36],[9,15,20,37],[9,15,20,38],
 [9,15,20,39],[9,15,20,40],[9,15,20,41],[9,15,20,42],
 [9,15,20,43],[9,15,20,44],[9,15,20,45],[9,15,20,46],
 [9,15,20,47],[9,15,20,48],[9,15,20,49],[9,15,20,54],
 [9,15,20,55],[9,15,20,56],[9,15,20,57],[9,15,20,58],
 [9,15,20,59],[9,15,20,60],[9,15,20,61],[9,15,20,62],
 [9,15,20,63],[9,15,20,64],[9,15,20,65],[9,15,20,66],
 [9,15,20,67],[9,15,20,68],[9,15,20,69],[9,15,21,22],
 [9,15,21,23],[9,15,21,24],[9,15,21,25],[9,15,21,26],
 [9,15,21,27],[9,15,21,34],[9,15,21,36],[9,15,21,37],
 [9,15,21,39],[9,15,21,41],[9,15,21,43],[9,15,21,44],
 [9,15,21,45],[9,15,21,46],[9,15,21,47],[9,15,21,48],
 [9,15,21,49],[9,15,21,55],[9,15,21,58],[9,15,21,59],
 [9,15,21,60],[9,15,21,61],[9,15,21,62],[9,15,21,65],
 [9,15,21,66],[9,15,21,67],[9,15,21,68],[9,15,21,69],
 [9,15,22,23],[9,15,22,24],[9,15,22,25],[9,15,22,26],
 [9,15,22,27],[9,15,22,28],[9,15,22,29],[9,15,22,30],
 [9,15,22,31],[9,15,22,32],[9,15,22,34],[9,15,22,36],
 [9,15,22,37],[9,15,22,38],[9,15,22,39],[9,15,22,40],
 [9,15,22,41],[9,15,22,42],[9,15,22,43],[9,15,22,44],
 [9,15,22,45],[9,15,22,46],[9,15,22,47],[9,15,22,48],
 [9,15,22,49],[9,15,22,54],[9,15,22,55],[9,15,22,56],
 [9,15,22,57],[9,15,22,58],[9,15,22,59],[9,15,22,60],
 [9,15,22,61],[9,15,22,62],[9,15,22,63],[9,15,22,64],
 [9,15,22,65],[9,15,22,66],[9,15,22,67],[9,15,22,68],
 [9,15,22,69],[9,15,23,24],[9,15,23,25],[9,15,23,26],
 [9,15,23,27],[9,15,23,32],[9,15,23,34],[9,15,23,36],
 [9,15,23,37],[9,15,23,39],[9,15,23,41],[9,15,23,42],
 [9,15,23,43],[9,15,23,44],[9,15,23,45],[9,15,23,46],
 [9,15,23,47],[9,15,23,48],[9,15,23,49],[9,15,23,55],
 [9,15,23,56],[9,15,23,57],[9,15,23,58],[9,15,23,59],
 [9,15,23,60],[9,15,23,61],[9,15,23,62],[9,15,23,66],
 [9,15,23,67],[9,15,23,68],[9,15,23,69],[9,15,24,25],
 [9,15,24,26],[9,15,24,27],[9,15,24,28],[9,15,24,29],
 [9,15,24,30],[9,15,24,31],[9,15,24,32],[9,15,24,34],
 [9,15,24,36],[9,15,24,37],[9,15,24,38],[9,15,24,39],
 [9,15,24,40],[9,15,24,41],[9,15,24,42],[9,15,24,43],
 [9,15,24,44],[9,15,24,45],[9,15,24,46],[9,15,24,47],
 [9,15,24,48],[9,15,24,49],[9,15,24,51],[9,15,24,54],
 [9,15,24,55],[9,15,24,56],[9,15,24,57],[9,15,24,58],
 [9,15,24,59],[9,15,24,60],[9,15,24,61],[9,15,24,62],
 [9,15,24,63],[9,15,24,64],[9,15,24,65],[9,15,24,66],
 [9,15,24,67],[9,15,24,68],[9,15,24,69],[9,15,25,26],
 [9,15,25,27],[9,15,25,34],[9,15,25,37],[9,15,25,39],
 [9,15,25,41],[9,15,25,43],[9,15,25,44],[9,15,25,45],
 [9,15,25,46],[9,15,25,47],[9,15,25,48],[9,15,25,49],
 [9,15,25,51],[9,15,25,54],[9,15,25,55],[9,15,25,58],
 [9,15,25,59],[9,15,25,60],[9,15,25,61],[9,15,25,62],
 [9,15,25,65],[9,15,25,66],[9,15,25,67],[9,15,25,68],
 [9,15,25,69],[9,15,26,27],[9,15,26,28],[9,15,26,29],
 [9,15,26,30],[9,15,26,31],[9,15,26,32],[9,15,26,34],
 [9,15,26,36],[9,15,26,37],[9,15,26,38],[9,15,26,39],
 [9,15,26,40],[9,15,26,41],[9,15,26,42],[9,15,26,43],
 [9,15,26,44],[9,15,26,45],[9,15,26,46],[9,15,26,47],
 [9,15,26,48],[9,15,26,49],[9,15,26,51],[9,15,26,54],
 [9,15,26,55],[9,15,26,56],[9,15,26,57],[9,15,26,58],
 [9,15,26,59],[9,15,26,60],[9,15,26,61],[9,15,26,62],
 [9,15,26,63],[9,15,26,64],[9,15,26,65],[9,15,26,66],
 [9,15,26,67],[9,15,26,68],[9,15,26,69],[9,15,27,32],
 [9,15,27,34],[9,15,27,36],[9,15,27,39],[9,15,27,41],
 [9,15,27,42],[9,15,27,43],[9,15,27,44],[9,15,27,45],
 [9,15,27,46],[9,15,27,47],[9,15,27,48],[9,15,27,49],
 [9,15,27,51],[9,15,27,54],[9,15,27,55],[9,15,27,58],
 [9,15,27,59],[9,15,27,60],[9,15,27,61],[9,15,27,62],
 [9,15,27,66],[9,15,27,67],[9,15,27,68],[9,15,27,69],
 [9,15,28,30],[9,15,28,41],[9,15,28,44],[9,15,28,47],
 [9,15,28,48],[9,15,28,49],[9,15,28,58],[9,15,28,59],
 [9,15,28,61],[9,15,28,68],[9,15,29,31],[9,15,29,32],
 [9,15,29,36],[9,15,29,41],[9,15,29,42],[9,15,29,44],
 [9,15,29,47],[9,15,29,48],[9,15,29,49],[9,15,29,59],
 [9,15,29,61],[9,15,29,68],[9,15,29,69],[9,15,30,41],
 [9,15,30,44],[9,15,30,47],[9,15,30,48],[9,15,30,49],
 [9,15,30,59],[9,15,30,61],[9,15,30,68],[9,15,31,32],
 [9,15,31,36],[9,15,31,41],[9,15,31,42],[9,15,31,44],
 [9,15,31,47],[9,15,31,49],[9,15,31,59],[9,15,31,61],
 [9,15,31,67],[9,15,31,68],[9,15,32,40],[9,15,32,41],
 [9,15,32,44],[9,15,32,47],[9,15,32,49],[9,15,32,51],
 [9,15,32,59],[9,15,32,60],[9,15,32,61],[9,15,32,63],
 [9,15,32,68],[9,15,34,39],[9,15,34,41],[9,15,34,43],
 [9,15,34,44],[9,15,34,45],[9,15,34,46],[9,15,34,47],
 [9,15,34,48],[9,15,34,49],[9,15,34,55],[9,15,34,58],
 [9,15,34,59],[9,15,34,60],[9,15,34,61],[9,15,34,62],
 [9,15,34,66],[9,15,34,67],[9,15,34,68],[9,15,34,69],
 [9,15,36,37],[9,15,36,38],[9,15,36,46],[9,15,36,48],
 [9,15,36,54],[9,15,36,61],[9,15,36,62],[9,15,36,63],
 [9,15,36,64],[9,15,36,68],[9,15,37,38],[9,15,37,40],
 [9,15,37,43],[9,15,37,46],[9,15,37,48],[9,15,37,54],
 [9,15,37,60],[9,15,37,61],[9,15,37,63],[9,15,37,68],
 [9,15,38,40],[9,15,38,41],[9,15,38,42],[9,15,38,44],
 [9,15,38,47],[9,15,38,49],[9,15,38,59],[9,15,38,61],
 [9,15,38,63],[9,15,38,64],[9,15,38,65],[9,15,38,67],
 [9,15,38,68],[9,15,39,41],[9,15,39,43],[9,15,39,44],
 [9,15,39,45],[9,15,39,46],[9,15,39,47],[9,15,39,48],
 [9,15,39,49],[9,15,39,55],[9,15,39,58],[9,15,39,59],
 [9,15,39,60],[9,15,39,61],[9,15,39,62],[9,15,39,66],
 [9,15,39,67],[9,15,39,68],[9,15,39,69],[9,15,40,41],
 [9,15,40,42],[9,15,40,44],[9,15,40,47],[9,15,40,48],
 [9,15,40,49],[9,15,40,59],[9,15,40,61],[9,15,40,63],
 [9,15,40,64],[9,15,40,65],[9,15,40,68],[9,15,40,69],
 [9,15,41,42],[9,15,41,43],[9,15,41,44],[9,15,41,45],
 [9,15,41,46],[9,15,41,47],[9,15,41,48],[9,15,41,49],
 [9,15,41,54],[9,15,41,55],[9,15,41,56],[9,15,41,57],
 [9,15,41,58],[9,15,41,59],[9,15,41,60],[9,15,41,61],
 [9,15,41,62],[9,15,41,63],[9,15,41,64],[9,15,41,65],
 [9,15,41,66],[9,15,41,67],[9,15,41,68],[9,15,41,69],
 [9,15,42,44],[9,15,42,46],[9,15,42,47],[9,15,42,49],
 [9,15,42,59],[9,15,42,61],[9,15,42,62],[9,15,42,63],
 [9,15,42,64],[9,15,42,65],[9,15,42,68],[9,15,43,44],
 [9,15,43,45],[9,15,43,46],[9,15,43,47],[9,15,43,48],
 [9,15,43,49],[9,15,43,55],[9,15,43,57],[9,15,43,58],
 [9,15,43,59],[9,15,43,60],[9,15,43,61],[9,15,43,62],
 [9,15,43,66],[9,15,43,67],[9,15,43,68],[9,15,43,69],
 [9,15,44,45],[9,15,44,46],[9,15,44,47],[9,15,44,48],
 [9,15,44,49],[9,15,44,51],[9,15,44,54],[9,15,44,55],
 [9,15,44,56],[9,15,44,57],[9,15,44,58],[9,15,44,59],
 [9,15,44,60],[9,15,44,61],[9,15,44,62],[9,15,44,63],
 [9,15,44,64],[9,15,44,65],[9,15,44,66],[9,15,44,67],
 [9,15,44,68],[9,15,44,69],[9,15,45,46],[9,15,45,47],
 [9,15,45,48],[9,15,45,49],[9,15,45,51],[9,15,45,54],
 [9,15,45,55],[9,15,45,58],[9,15,45,59],[9,15,45,60],
 [9,15,45,61],[9,15,45,62],[9,15,45,66],[9,15,45,67],
 [9,15,45,68],[9,15,45,69],[9,15,46,47],[9,15,46,48],
 [9,15,46,49],[9,15,46,55],[9,15,46,56],[9,15,46,57],
 [9,15,46,58],[9,15,46,59],[9,15,46,60],[9,15,46,61],
 [9,15,46,62],[9,15,46,66],[9,15,46,67],[9,15,46,68],
 [9,15,46,69],[9,15,47,48],[9,15,47,49],[9,15,47,54],
 [9,15,47,55],[9,15,47,56],[9,15,47,57],[9,15,47,58],
 [9,15,47,59],[9,15,47,60],[9,15,47,61],[9,15,47,62],
 [9,15,47,63],[9,15,47,64],[9,15,47,65],[9,15,47,66],
 [9,15,47,67],[9,15,47,68],[9,15,47,69],[9,15,48,49],
 [9,15,48,51],[9,15,48,55],[9,15,48,56],[9,15,48,57],
 [9,15,48,58],[9,15,48,59],[9,15,48,60],[9,15,48,61],
 [9,15,48,62],[9,15,48,63],[9,15,48,66],[9,15,48,67],
 [9,15,48,68],[9,15,48,69],[9,15,49,54],[9,15,49,55],
 [9,15,49,56],[9,15,49,57],[9,15,49,58],[9,15,49,59],
 [9,15,49,60],[9,15,49,61],[9,15,49,62],[9,15,49,63],
 [9,15,49,64],[9,15,49,65],[9,15,49,66],[9,15,49,67],
 [9,15,49,68],[9,15,49,69],[9,15,51,55],[9,15,51,56],
 [9,15,51,57],[9,15,51,58],[9,15,51,59],[9,15,51,60],
 [9,15,51,61],[9,15,51,62],[9,15,51,63],[9,15,51,64],
 [9,15,51,65],[9,15,51,66],[9,15,51,67],[9,15,51,68],
 [9,15,51,69],[9,15,54,56],[9,15,54,57],[9,15,54,59],
 [9,15,54,60],[9,15,54,61],[9,15,54,62],[9,15,54,67],
 [9,15,54,68],[9,15,54,69],[9,15,55,58],[9,15,55,59],
 [9,15,55,60],[9,15,55,61],[9,15,55,62],[9,15,55,66],
 [9,15,55,67],[9,15,55,68],[9,15,55,69],[9,15,56,57],
 [9,15,56,59],[9,15,56,61],[9,15,56,68],[9,15,57,59],
 [9,15,57,61],[9,15,57,68],[9,15,58,59],[9,15,58,60],
 [9,15,58,61],[9,15,58,62],[9,15,58,66],[9,15,58,67],
 [9,15,58,68],[9,15,58,69],[9,15,59,60],[9,15,59,61],
 [9,15,59,62],[9,15,59,63],[9,15,59,64],[9,15,59,65],
 [9,15,59,66],[9,15,59,67],[9,15,59,68],[9,15,59,69],
 [9,15,60,61],[9,15,60,62],[9,15,60,65],[9,15,60,66],
 [9,15,60,67],[9,15,60,68],[9,15,60,69],[9,15,61,62],
 [9,15,61,63],[9,15,61,64],[9,15,61,65],[9,15,61,66],
 [9,15,61,67],[9,15,61,68],[9,15,61,69],[9,15,62,66],
 [9,15,62,67],[9,15,62,68],[9,15,62,69],[9,15,63,64],
 [9,15,63,65],[9,15,63,66],[9,15,63,68],[9,15,63,69],
 [9,15,64,65],[9,15,64,67],[9,15,64,68],[9,15,65,68],
 [9,15,66,67],[9,15,66,68],[9,15,66,69],[9,15,67,68],
 [9,15,67,69],[9,15,68,69],[9,16,19,20],[9,16,19,21],
 [9,16,19,22],[9,16,19,23],[9,16,19,24],[9,16,19,25],
 [9,16,19,26],[9,16,19,27],[9,16,19,34],[9,16,19,37],
 [9,16,19,39],[9,16,19,41],[9,16,19,43],[9,16,19,44],
 [9,16,19,45],[9,16,19,46],[9,16,19,47],[9,16,19,48],
 [9,16,19,49],[9,16,19,55],[9,16,19,58],[9,16,19,59],
 [9,16,19,60],[9,16,19,61],[9,16,19,62],[9,16,19,66],
 [9,16,19,67],[9,16,19,68],[9,16,19,69],[9,16,20,21],
 [9,16,20,22],[9,16,20,23],[9,16,20,24],[9,16,20,25],
 [9,16,20,26],[9,16,20,27],[9,16,20,34],[9,16,20,36],
 [9,16,20,37],[9,16,20,39],[9,16,20,41],[9,16,20,42],
 [9,16,20,43],[9,16,20,44],[9,16,20,45],[9,16,20,46],
 [9,16,20,47],[9,16,20,48],[9,16,20,49],[9,16,20,53],
 [9,16,20,54],[9,16,20,55],[9,16,20,58],[9,16,20,59],
 [9,16,20,60],[9,16,20,61],[9,16,20,62],[9,16,20,66],
 [9,16,20,67],[9,16,20,68],[9,16,20,69],[9,16,21,22],
 [9,16,21,23],[9,16,21,24],[9,16,21,25],[9,16,21,26],
 [9,16,21,27],[9,16,21,33],[9,16,21,34],[9,16,21,35],
 [9,16,21,36],[9,16,21,37],[9,16,21,39],[9,16,21,41],
 [9,16,21,42],[9,16,21,43],[9,16,21,44],[9,16,21,45],
 [9,16,21,46],[9,16,21,47],[9,16,21,48],[9,16,21,49],
 [9,16,21,51],[9,16,21,53],[9,16,21,55],[9,16,21,58],
 [9,16,21,59],[9,16,21,60],[9,16,21,61],[9,16,21,62],
 [9,16,21,66],[9,16,21,67],[9,16,21,68],[9,16,21,69],
 [9,16,22,23],[9,16,22,24],[9,16,22,25],[9,16,22,26],
 [9,16,22,27],[9,16,22,32],[9,16,22,33],[9,16,22,34],
 [9,16,22,35],[9,16,22,36],[9,16,22,37],[9,16,22,39],
 [9,16,22,41],[9,16,22,42],[9,16,22,43],[9,16,22,44],
 [9,16,22,45],[9,16,22,46],[9,16,22,47],[9,16,22,48],
 [9,16,22,49],[9,16,22,54],[9,16,22,55],[9,16,22,58],
 [9,16,22,59],[9,16,22,60],[9,16,22,61],[9,16,22,62],
 [9,16,22,66],[9,16,22,67],[9,16,22,68],[9,16,22,69],
 [9,16,23,24],[9,16,23,25],[9,16,23,26],[9,16,23,27],
 [9,16,23,32],[9,16,23,34],[9,16,23,37],[9,16,23,39],
 [9,16,23,41],[9,16,23,42],[9,16,23,43],[9,16,23,44],
 [9,16,23,45],[9,16,23,46],[9,16,23,47],[9,16,23,48],
 [9,16,23,49],[9,16,23,53],[9,16,23,55],[9,16,23,58],
 [9,16,23,59],[9,16,23,60],[9,16,23,61],[9,16,23,62],
 [9,16,23,66],[9,16,23,67],[9,16,23,68],[9,16,23,69],
 [9,16,24,25],[9,16,24,26],[9,16,24,27],[9,16,24,32],
 [9,16,24,33],[9,16,24,34],[9,16,24,35],[9,16,24,36],
 [9,16,24,37],[9,16,24,39],[9,16,24,41],[9,16,24,42],
 [9,16,24,43],[9,16,24,44],[9,16,24,45],[9,16,24,46],
 [9,16,24,47],[9,16,24,48],[9,16,24,49],[9,16,24,51],
 [9,16,24,53],[9,16,24,54],[9,16,24,55],[9,16,24,58],
 [9,16,24,59],[9,16,24,60],[9,16,24,61],[9,16,24,62],
 [9,16,24,66],[9,16,24,67],[9,16,24,68],[9,16,24,69],
 [9,16,25,26],[9,16,25,27],[9,16,25,32],[9,16,25,33],
 [9,16,25,34],[9,16,25,35],[9,16,25,36],[9,16,25,37],
 [9,16,25,39],[9,16,25,41],[9,16,25,42],[9,16,25,43],
 [9,16,25,44],[9,16,25,45],[9,16,25,46],[9,16,25,47],
 [9,16,25,48],[9,16,25,49],[9,16,25,51],[9,16,25,53],
 [9,16,25,54],[9,16,25,55],[9,16,25,58],[9,16,25,59],
 [9,16,25,60],[9,16,25,61],[9,16,25,62],[9,16,25,66],
 [9,16,25,67],[9,16,25,68],[9,16,25,69],[9,16,26,27],
 [9,16,26,32],[9,16,26,34],[9,16,26,37],[9,16,26,39],
 [9,16,26,41],[9,16,26,42],[9,16,26,43],[9,16,26,44],
 [9,16,26,45],[9,16,26,46],[9,16,26,47],[9,16,26,48],
 [9,16,26,49],[9,16,26,51],[9,16,26,54],[9,16,26,55],
 [9,16,26,58],[9,16,26,59],[9,16,26,60],[9,16,26,61],
 [9,16,26,62],[9,16,26,66],[9,16,26,67],[9,16,26,68],
 [9,16,26,69],[9,16,27,32],[9,16,27,33],[9,16,27,34],
 [9,16,27,35],[9,16,27,36],[9,16,27,37],[9,16,27,39],
 [9,16,27,41],[9,16,27,42],[9,16,27,43],[9,16,27,44],
 [9,16,27,45],[9,16,27,46],[9,16,27,47],[9,16,27,48],
 [9,16,27,49],[9,16,27,51],[9,16,27,53],[9,16,27,54],
 [9,16,27,55],[9,16,27,58],[9,16,27,59],[9,16,27,60],
 [9,16,27,61],[9,16,27,62],[9,16,27,66],[9,16,27,67],
 [9,16,27,68],[9,16,27,69],[9,16,32,33],[9,16,32,46],
 [9,16,32,49],[9,16,32,60],[9,16,32,62],[9,16,32,68],
 [9,16,33,35],[9,16,33,36],[9,16,33,37],[9,16,33,42],
 [9,16,33,45],[9,16,33,48],[9,16,33,49],[9,16,33,58],
 [9,16,33,59],[9,16,33,60],[9,16,33,62],[9,16,33,66],
 [9,16,33,68],[9,16,33,69],[9,16,34,39],[9,16,34,41],
 [9,16,34,43],[9,16,34,44],[9,16,34,45],[9,16,34,46],
 [9,16,34,47],[9,16,34,48],[9,16,34,49],[9,16,34,55],
 [9,16,34,58],[9,16,34,59],[9,16,34,60],[9,16,34,61],
 [9,16,34,62],[9,16,34,66],[9,16,34,67],[9,16,34,68],
 [9,16,34,69],[9,16,35,36],[9,16,35,37],[9,16,35,41],
 [9,16,35,42],[9,16,35,45],[9,16,35,47],[9,16,35,48],
 [9,16,35,59],[9,16,35,60],[9,16,35,62],[9,16,35,67],
 [9,16,35,68],[9,16,36,37],[9,16,36,45],[9,16,36,46],
 [9,16,36,48],[9,16,36,54],[9,16,36,60],[9,16,36,61],
 [9,16,36,62],[9,16,36,68],[9,16,37,43],[9,16,37,45],
 [9,16,37,48],[9,16,37,54],[9,16,37,60],[9,16,37,62],
 [9,16,37,68],[9,16,39,41],[9,16,39,43],[9,16,39,44],
 [9,16,39,45],[9,16,39,46],[9,16,39,47],[9,16,39,48],
 [9,16,39,49],[9,16,39,55],[9,16,39,58],[9,16,39,59],
 [9,16,39,60],[9,16,39,61],[9,16,39,62],[9,16,39,66],
 [9,16,39,67],[9,16,39,68],[9,16,39,69],[9,16,41,43],
 [9,16,41,44],[9,16,41,45],[9,16,41,46],[9,16,41,47],
 [9,16,41,48],[9,16,41,49],[9,16,41,53],[9,16,41,54],
 [9,16,41,55],[9,16,41,58],[9,16,41,59],[9,16,41,60],
 [9,16,41,61],[9,16,41,62],[9,16,41,66],[9,16,41,67],
 [9,16,41,68],[9,16,41,69],[9,16,42,44],[9,16,42,46],
 [9,16,42,49],[9,16,42,59],[9,16,42,60],[9,16,42,61],
 [9,16,42,62],[9,16,42,68],[9,16,43,44],[9,16,43,45],
 [9,16,43,46],[9,16,43,47],[9,16,43,48],[9,16,43,49],
 [9,16,43,53],[9,16,43,55],[9,16,43,58],[9,16,43,59],
 [9,16,43,60],[9,16,43,61],[9,16,43,62],[9,16,43,66],
 [9,16,43,67],[9,16,43,68],[9,16,43,69],[9,16,44,45],
 [9,16,44,46],[9,16,44,47],[9,16,44,48],[9,16,44,49],
 [9,16,44,54],[9,16,44,55],[9,16,44,58],[9,16,44,59],
 [9,16,44,60],[9,16,44,61],[9,16,44,62],[9,16,44,66],
 [9,16,44,67],[9,16,44,68],[9,16,44,69],[9,16,45,46],
 [9,16,45,47],[9,16,45,48],[9,16,45,49],[9,16,45,51],
 [9,16,45,53],[9,16,45,54],[9,16,45,55],[9,16,45,58],
 [9,16,45,59],[9,16,45,60],[9,16,45,61],[9,16,45,62],
 [9,16,45,66],[9,16,45,67],[9,16,45,68],[9,16,45,69],
 [9,16,46,47],[9,16,46,48],[9,16,46,49],[9,16,46,55],
 [9,16,46,58],[9,16,46,59],[9,16,46,60],[9,16,46,61],
 [9,16,46,62],[9,16,46,66],[9,16,46,67],[9,16,46,68],
 [9,16,46,69],[9,16,47,48],[9,16,47,49],[9,16,47,53],
 [9,16,47,54],[9,16,47,55],[9,16,47,58],[9,16,47,59],
 [9,16,47,60],[9,16,47,61],[9,16,47,62],[9,16,47,66],
 [9,16,47,67],[9,16,47,68],[9,16,47,69],[9,16,48,49],
 [9,16,48,51],[9,16,48,53],[9,16,48,55],[9,16,48,58],
 [9,16,48,59],[9,16,48,60],[9,16,48,61],[9,16,48,62],
 [9,16,48,66],[9,16,48,67],[9,16,48,68],[9,16,48,69],
 [9,16,49,54],[9,16,49,55],[9,16,49,58],[9,16,49,59],
 [9,16,49,60],[9,16,49,61],[9,16,49,62],[9,16,49,66],
 [9,16,49,67],[9,16,49,68],[9,16,49,69],[9,16,51,53],
 [9,16,51,55],[9,16,51,58],[9,16,51,59],[9,16,51,60],
 [9,16,51,61],[9,16,51,62],[9,16,51,66],[9,16,51,67],
 [9,16,51,68],[9,16,53,60],[9,16,53,62],[9,16,53,68],
 [9,16,54,59],[9,16,54,60],[9,16,54,62],[9,16,54,67],
 [9,16,54,68],[9,16,54,69],[9,16,55,58],[9,16,55,59],
 [9,16,55,60],[9,16,55,61],[9,16,55,62],[9,16,55,66],
 [9,16,55,67],[9,16,55,68],[9,16,55,69],[9,16,58,59],
 [9,16,58,60],[9,16,58,61],[9,16,58,62],[9,16,58,66],
 [9,16,58,67],[9,16,58,68],[9,16,58,69],[9,16,59,60],
 [9,16,59,61],[9,16,59,62],[9,16,59,66],[9,16,59,67],
 [9,16,59,68],[9,16,59,69],[9,16,60,61],[9,16,60,62],
 [9,16,60,66],[9,16,60,67],[9,16,60,68],[9,16,60,69],
 [9,16,61,62],[9,16,61,66],[9,16,61,67],[9,16,61,68],
 [9,16,61,69],[9,16,62,66],[9,16,62,67],[9,16,62,68],
 [9,16,62,69],[9,16,66,67],[9,16,66,68],[9,16,66,69],
 [9,16,67,68],[9,16,67,69],[9,16,68,69],[9,17,18,19],
 [9,17,18,20],[9,17,18,22],[9,17,18,23],[9,17,18,24],
 [9,17,18,26],[9,17,18,33],[9,17,18,35],[9,17,18,41],
 [9,17,18,44],[9,17,18,46],[9,17,18,47],[9,17,18,48],
 [9,17,18,49],[9,17,18,51],[9,17,18,53],[9,17,18,54],
 [9,17,18,56],[9,17,18,57],[9,17,18,59],[9,17,18,61],
 [9,17,18,66],[9,17,18,68],[9,17,19,22],[9,17,19,23],
 [9,17,19,24],[9,17,19,26],[9,17,19,46],[9,17,19,48],
 [9,17,19,49],[9,17,19,59],[9,17,19,66],[9,17,19,68],
 [9,17,20,22],[9,17,20,23],[9,17,20,24],[9,17,20,26],
 [9,17,20,41],[9,17,20,44],[9,17,20,47],[9,17,20,48],
 [9,17,20,49],[9,17,20,53],[9,17,20,54],[9,17,20,56],
 [9,17,20,57],[9,17,20,59],[9,17,20,61],[9,17,20,66],
 [9,17,20,68],[9,17,22,24],[9,17,22,26],[9,17,22,33],
 [9,17,22,35],[9,17,22,41],[9,17,22,44],[9,17,22,46],
 [9,17,22,47],[9,17,22,48],[9,17,22,49],[9,17,22,54],
 [9,17,22,56],[9,17,22,57],[9,17,22,59],[9,17,22,61],
 [9,17,22,68],[9,17,23,24],[9,17,23,26],[9,17,23,46],
 [9,17,23,48],[9,17,23,49],[9,17,23,53],[9,17,23,56],
 [9,17,23,57],[9,17,23,59],[9,17,23,61],[9,17,23,66],
 [9,17,23,68],[9,17,24,26],[9,17,24,33],[9,17,24,35],
 [9,17,24,41],[9,17,24,44],[9,17,24,46],[9,17,24,47],
 [9,17,24,48],[9,17,24,49],[9,17,24,51],[9,17,24,53],
 [9,17,24,54],[9,17,24,56],[9,17,24,57],[9,17,24,59],
 [9,17,24,61],[9,17,24,66],[9,17,24,68],[9,17,26,41],
 [9,17,26,44],[9,17,26,46],[9,17,26,47],[9,17,26,48],
 [9,17,26,49],[9,17,26,51],[9,17,26,54],[9,17,26,56],
 [9,17,26,57],[9,17,26,59],[9,17,26,61],[9,17,26,68],
 [9,17,33,35],[9,17,33,48],[9,17,33,49],[9,17,33,57],
 [9,17,33,59],[9,17,33,66],[9,17,33,68],[9,17,35,41],
 [9,17,35,47],[9,17,35,48],[9,17,35,49],[9,17,35,57],
 [9,17,35,59],[9,17,35,68],[9,17,41,44],[9,17,41,46],
 [9,17,41,47],[9,17,41,49],[9,17,41,53],[9,17,41,54],
 [9,17,41,56],[9,17,41,57],[9,17,41,59],[9,17,41,61],
 [9,17,41,66],[9,17,41,68],[9,17,44,46],[9,17,44,47],
 [9,17,44,48],[9,17,44,49],[9,17,44,51],[9,17,44,53],
 [9,17,44,54],[9,17,44,56],[9,17,44,57],[9,17,44,59],
 [9,17,44,61],[9,17,44,66],[9,17,44,68],[9,17,46,48],
 [9,17,46,49],[9,17,46,53],[9,17,46,56],[9,17,46,57],
 [9,17,46,59],[9,17,46,61],[9,17,46,66],[9,17,46,68],
 [9,17,47,49],[9,17,47,53],[9,17,47,54],[9,17,47,56],
 [9,17,47,57],[9,17,47,59],[9,17,47,61],[9,17,47,68],
 [9,17,48,49],[9,17,48,51],[9,17,48,53],[9,17,48,56],
 [9,17,48,57],[9,17,48,59],[9,17,48,61],[9,17,48,66],
 [9,17,48,68],[9,17,49,53],[9,17,49,54],[9,17,49,56],
 [9,17,49,57],[9,17,49,59],[9,17,49,61],[9,17,49,66],
 [9,17,49,68],[9,17,51,53],[9,17,51,56],[9,17,51,57],
 [9,17,51,59],[9,17,51,61],[9,17,51,66],[9,17,51,68],
 [9,17,53,54],[9,17,53,68],[9,17,54,56],[9,17,54,57],
 [9,17,54,59],[9,17,54,61],[9,17,54,68],[9,17,56,57],
 [9,17,56,59],[9,17,56,61],[9,17,56,68],[9,17,57,59],
 [9,17,57,61],[9,17,57,68],[9,17,59,61],[9,17,59,66],
 [9,17,59,68],[9,17,61,68],[9,17,66,68],[9,18,19,20],
 [9,18,19,23],[9,18,19,24],[9,18,19,41],[9,18,19,44],
 [9,18,19,46],[9,18,19,47],[9,18,19,48],[9,18,19,53],
 [9,18,19,59],[9,18,19,61],[9,18,19,66],[9,18,19,68],
 [9,18,20,22],[9,18,20,23],[9,18,20,24],[9,18,20,26],
 [9,18,20,41],[9,18,20,44],[9,18,20,46],[9,18,20,47],
 [9,18,20,49],[9,18,20,53],[9,18,20,54],[9,18,20,56],
 [9,18,20,57],[9,18,20,59],[9,18,20,61],[9,18,20,66],
 [9,18,20,68],[9,18,22,23],[9,18,22,24],[9,18,22,26],
 [9,18,22,33],[9,18,22,35],[9,18,22,41],[9,18,22,44],
 [9,18,22,47],[9,18,22,48],[9,18,22,49],[9,18,22,54],
 [9,18,22,56],[9,18,22,57],[9,18,22,59],[9,18,22,61],
 [9,18,22,66],[9,18,22,68],[9,18,23,24],[9,18,23,26],
 [9,18,23,41],[9,18,23,44],[9,18,23,46],[9,18,23,47],
 [9,18,23,48],[9,18,23,53],[9,18,23,56],[9,18,23,57],
 [9,18,23,61],[9,18,23,66],[9,18,23,68],[9,18,24,26],
 [9,18,24,33],[9,18,24,35],[9,18,24,41],[9,18,24,44],
 [9,18,24,46],[9,18,24,47],[9,18,24,48],[9,18,24,49],
 [9,18,24,51],[9,18,24,53],[9,18,24,54],[9,18,24,56],
 [9,18,24,57],[9,18,24,59],[9,18,24,61],[9,18,24,66],
 [9,18,24,68],[9,18,26,41],[9,18,26,44],[9,18,26,46],
 [9,18,26,47],[9,18,26,48],[9,18,26,49],[9,18,26,51],
 [9,18,26,54],[9,18,26,56],[9,18,26,57],[9,18,26,59],
 [9,18,26,61],[9,18,26,66],[9,18,26,68],[9,18,33,35],
 [9,18,33,41],[9,18,33,47],[9,18,33,48],[9,18,33,56],
 [9,18,33,59],[9,18,33,66],[9,18,33,68],[9,18,35,41],
 [9,18,35,47],[9,18,35,48],[9,18,35,49],[9,18,35,56],
 [9,18,35,59],[9,18,35,68],[9,18,41,44],[9,18,41,47],
 [9,18,41,48],[9,18,41,49],[9,18,41,53],[9,18,41,54],
 [9,18,41,56],[9,18,41,57],[9,18,41,59],[9,18,41,61],
 [9,18,41,68],[9,18,44,47],[9,18,44,48],[9,18,44,49],
 [9,18,44,51],[9,18,44,54],[9,18,44,56],[9,18,44,57],
 [9,18,44,59],[9,18,44,61],[9,18,44,68],[9,18,46,47],
 [9,18,46,48],[9,18,46,53],[9,18,46,56],[9,18,46,57],
 [9,18,46,59],[9,18,46,61],[9,18,46,66],[9,18,46,68],
 [9,18,47,48],[9,18,47,49],[9,18,47,53],[9,18,47,54],
 [9,18,47,56],[9,18,47,57],[9,18,47,59],[9,18,47,61],
 [9,18,47,66],[9,18,47,68],[9,18,48,51],[9,18,48,53],
 [9,18,48,56],[9,18,48,57],[9,18,48,59],[9,18,48,61],
 [9,18,48,66],[9,18,48,68],[9,18,49,53],[9,18,49,54],
 [9,18,49,56],[9,18,49,57],[9,18,49,59],[9,18,49,61],
 [9,18,49,66],[9,18,49,68],[9,18,51,53],[9,18,51,56],
 [9,18,51,57],[9,18,51,59],[9,18,51,61],[9,18,51,66],
 [9,18,51,68],[9,18,53,54],[9,18,53,68],[9,18,54,56],
 [9,18,54,57],[9,18,54,59],[9,18,54,61],[9,18,54,68],
 [9,18,56,57],[9,18,56,59],[9,18,56,61],[9,18,56,68],
 [9,18,57,59],[9,18,57,61],[9,18,57,68],[9,18,59,61],
 [9,18,59,68],[9,18,61,68],[9,18,66,68],[9,19,20,21],
 [9,19,20,22],[9,19,20,23],[9,19,20,24],[9,19,20,25],
 [9,19,20,26],[9,19,20,27],[9,19,20,34],[9,19,20,36],
 [9,19,20,39],[9,19,20,41],[9,19,20,43],[9,19,20,44],
 [9,19,20,45],[9,19,20,46],[9,19,20,47],[9,19,20,48],
 [9,19,20,49],[9,19,20,55],[9,19,20,58],[9,19,20,59],
 [9,19,20,60],[9,19,20,61],[9,19,20,62],[9,19,20,64],
 [9,19,20,66],[9,19,20,67],[9,19,20,68],[9,19,20,69],
 [9,19,21,22],[9,19,21,23],[9,19,21,24],[9,19,21,25],
 [9,19,21,26],[9,19,21,27],[9,19,21,34],[9,19,21,37],
 [9,19,21,39],[9,19,21,41],[9,19,21,43],[9,19,21,44],
 [9,19,21,45],[9,19,21,46],[9,19,21,47],[9,19,21,48],
 [9,19,21,49],[9,19,21,53],[9,19,21,55],[9,19,21,58],
 [9,19,21,59],[9,19,21,60],[9,19,21,61],[9,19,21,62],
 [9,19,21,66],[9,19,21,67],[9,19,21,68],[9,19,21,69],
 [9,19,22,23],[9,19,22,24],[9,19,22,25],[9,19,22,26],
 [9,19,22,27],[9,19,22,34],[9,19,22,36],[9,19,22,37],
 [9,19,22,39],[9,19,22,41],[9,19,22,43],[9,19,22,44],
 [9,19,22,45],[9,19,22,46],[9,19,22,47],[9,19,22,48],
 [9,19,22,49],[9,19,22,55],[9,19,22,58],[9,19,22,59],
 [9,19,22,60],[9,19,22,61],[9,19,22,62],[9,19,22,63],
 [9,19,22,66],[9,19,22,67],[9,19,22,68],[9,19,22,69],
 [9,19,23,24],[9,19,23,25],[9,19,23,26],[9,19,23,27],
 [9,19,23,34],[9,19,23,36],[9,19,23,37],[9,19,23,39],
 [9,19,23,41],[9,19,23,43],[9,19,23,44],[9,19,23,45],
 [9,19,23,46],[9,19,23,47],[9,19,23,48],[9,19,23,49],
 [9,19,23,53],[9,19,23,55],[9,19,23,58],[9,19,23,59],
 [9,19,23,60],[9,19,23,61],[9,19,23,62],[9,19,23,66],
 [9,19,23,67],[9,19,23,68],[9,19,23,69],[9,19,24,25],
 [9,19,24,26],[9,19,24,27],[9,19,24,34],[9,19,24,36],
 [9,19,24,37],[9,19,24,39],[9,19,24,41],[9,19,24,43],
 [9,19,24,44],[9,19,24,45],[9,19,24,46],[9,19,24,47],
 [9,19,24,48],[9,19,24,49],[9,19,24,53],[9,19,24,55],
 [9,19,24,58],[9,19,24,59],[9,19,24,60],[9,19,24,61],
 [9,19,24,62],[9,19,24,63],[9,19,24,64],[9,19,24,66],
 [9,19,24,67],[9,19,24,68],[9,19,24,69],[9,19,25,26],
 [9,19,25,27],[9,19,25,34],[9,19,25,37],[9,19,25,39],
 [9,19,25,41],[9,19,25,43],[9,19,25,44],[9,19,25,45],
 [9,19,25,46],[9,19,25,47],[9,19,25,48],[9,19,25,49],
 [9,19,25,53],[9,19,25,55],[9,19,25,58],[9,19,25,59],
 [9,19,25,60],[9,19,25,61],[9,19,25,62],[9,19,25,66],
 [9,19,25,67],[9,19,25,68],[9,19,25,69],[9,19,26,27],
 [9,19,26,34],[9,19,26,36],[9,19,26,37],[9,19,26,39],
 [9,19,26,41],[9,19,26,43],[9,19,26,44],[9,19,26,45],
 [9,19,26,46],[9,19,26,47],[9,19,26,48],[9,19,26,49],
 [9,19,26,55],[9,19,26,58],[9,19,26,59],[9,19,26,60],
 [9,19,26,61],[9,19,26,62],[9,19,26,63],[9,19,26,64],
 [9,19,26,66],[9,19,26,67],[9,19,26,68],[9,19,26,69],
 [9,19,27,34],[9,19,27,36],[9,19,27,39],[9,19,27,41],
 [9,19,27,43],[9,19,27,44],[9,19,27,45],[9,19,27,46],
 [9,19,27,47],[9,19,27,48],[9,19,27,49],[9,19,27,55],
 [9,19,27,58],[9,19,27,59],[9,19,27,60],[9,19,27,61],
 [9,19,27,62],[9,19,27,66],[9,19,27,67],[9,19,27,68],
 [9,19,27,69],[9,19,34,39],[9,19,34,41],[9,19,34,43],
 [9,19,34,44],[9,19,34,45],[9,19,34,46],[9,19,34,47],
 [9,19,34,48],[9,19,34,49],[9,19,34,55],[9,19,34,58],
 [9,19,34,59],[9,19,34,60],[9,19,34,61],[9,19,34,62],
 [9,19,34,66],[9,19,34,67],[9,19,34,68],[9,19,34,69],
 [9,19,36,37],[9,19,36,43],[9,19,36,45],[9,19,36,46],
 [9,19,36,48],[9,19,36,60],[9,19,36,61],[9,19,36,62],
 [9,19,36,68],[9,19,37,45],[9,19,37,46],[9,19,37,48],
 [9,19,37,60],[9,19,37,61],[9,19,37,62],[9,19,37,63],
 [9,19,37,64],[9,19,37,68],[9,19,39,41],[9,19,39,43],
 [9,19,39,44],[9,19,39,45],[9,19,39,46],[9,19,39,47],
 [9,19,39,48],[9,19,39,49],[9,19,39,55],[9,19,39,58],
 [9,19,39,59],[9,19,39,60],[9,19,39,61],[9,19,39,62],
 [9,19,39,66],[9,19,39,67],[9,19,39,68],[9,19,39,69],
 [9,19,41,43],[9,19,41,44],[9,19,41,45],[9,19,41,46],
 [9,19,41,47],[9,19,41,48],[9,19,41,49],[9,19,41,53],
 [9,19,41,55],[9,19,41,58],[9,19,41,59],[9,19,41,60],
 [9,19,41,61],[9,19,41,62],[9,19,41,64],[9,19,41,66],
 [9,19,41,67],[9,19,41,68],[9,19,41,69],[9,19,43,44],
 [9,19,43,45],[9,19,43,46],[9,19,43,47],[9,19,43,48],
 [9,19,43,49],[9,19,43,55],[9,19,43,58],[9,19,43,59],
 [9,19,43,60],[9,19,43,61],[9,19,43,62],[9,19,43,66],
 [9,19,43,67],[9,19,43,68],[9,19,43,69],[9,19,44,45],
 [9,19,44,46],[9,19,44,47],[9,19,44,48],[9,19,44,49],
 [9,19,44,53],[9,19,44,55],[9,19,44,58],[9,19,44,59],
 [9,19,44,60],[9,19,44,61],[9,19,44,62],[9,19,44,64],
 [9,19,44,66],[9,19,44,67],[9,19,44,68],[9,19,44,69],
 [9,19,45,46],[9,19,45,47],[9,19,45,48],[9,19,45,49],
 [9,19,45,53],[9,19,45,55],[9,19,45,58],[9,19,45,59],
 [9,19,45,60],[9,19,45,61],[9,19,45,62],[9,19,45,66],
 [9,19,45,67],[9,19,45,68],[9,19,45,69],[9,19,46,47],
 [9,19,46,48],[9,19,46,49],[9,19,46,53],[9,19,46,55],
 [9,19,46,58],[9,19,46,59],[9,19,46,60],[9,19,46,61],
 [9,19,46,62],[9,19,46,66],[9,19,46,67],[9,19,46,68],
 [9,19,46,69],[9,19,47,48],[9,19,47,49],[9,19,47,53],
 [9,19,47,55],[9,19,47,58],[9,19,47,59],[9,19,47,60],
 [9,19,47,61],[9,19,47,62],[9,19,47,66],[9,19,47,67],
 [9,19,47,68],[9,19,47,69],[9,19,48,49],[9,19,48,53],
 [9,19,48,55],[9,19,48,58],[9,19,48,59],[9,19,48,60],
 [9,19,48,61],[9,19,48,62],[9,19,48,63],[9,19,48,64],
 [9,19,48,66],[9,19,48,67],[9,19,48,68],[9,19,48,69],
 [9,19,49,53],[9,19,49,55],[9,19,49,58],[9,19,49,59],
 [9,19,49,60],[9,19,49,61],[9,19,49,62],[9,19,49,63],
 [9,19,49,66],[9,19,49,67],[9,19,49,68],[9,19,49,69],
 [9,19,53,60],[9,19,53,62],[9,19,53,63],[9,19,53,64],
 [9,19,53,68],[9,19,55,58],[9,19,55,59],[9,19,55,60],
 [9,19,55,61],[9,19,55,62],[9,19,55,66],[9,19,55,67],
 [9,19,55,68],[9,19,55,69],[9,19,58,59],[9,19,58,60],
 [9,19,58,61],[9,19,58,62],[9,19,58,66],[9,19,58,67],
 [9,19,58,68],[9,19,58,69],[9,19,59,60],[9,19,59,61],
 [9,19,59,62],[9,19,59,63],[9,19,59,64],[9,19,59,66],
 [9,19,59,67],[9,19,59,68],[9,19,59,69],[9,19,60,61],
 [9,19,60,62],[9,19,60,66],[9,19,60,67],[9,19,60,68],
 [9,19,60,69],[9,19,61,62],[9,19,61,63],[9,19,61,66],
 [9,19,61,67],[9,19,61,68],[9,19,61,69],[9,19,62,66],
 [9,19,62,67],[9,19,62,68],[9,19,62,69],[9,19,63,64],
 [9,19,63,66],[9,19,63,67],[9,19,63,68],[9,19,63,69],
 [9,19,64,66],[9,19,64,67],[9,19,64,68],[9,19,64,69],
 [9,19,66,67],[9,19,66,68],[9,19,66,69],[9,19,67,68],
 [9,19,67,69],[9,19,68,69],[9,20,21,22],[9,20,21,23],
 [9,20,21,24],[9,20,21,25],[9,20,21,26],[9,20,21,27],
 [9,20,21,34],[9,20,21,37],[9,20,21,39],[9,20,21,41],
 [9,20,21,43],[9,20,21,44],[9,20,21,45],[9,20,21,46],
 [9,20,21,47],[9,20,21,48],[9,20,21,49],[9,20,21,53],
 [9,20,21,55],[9,20,21,58],[9,20,21,59],[9,20,21,60],
 [9,20,21,61],[9,20,21,62],[9,20,21,65],[9,20,21,66],
 [9,20,21,67],[9,20,21,68],[9,20,21,69],[9,20,22,23],
 [9,20,22,24],[9,20,22,25],[9,20,22,26],[9,20,22,27],
 [9,20,22,28],[9,20,22,29],[9,20,22,30],[9,20,22,31],
 [9,20,22,32],[9,20,22,34],[9,20,22,37],[9,20,22,38],
 [9,20,22,39],[9,20,22,40],[9,20,22,41],[9,20,22,42],
 [9,20,22,43],[9,20,22,44],[9,20,22,45],[9,20,22,46],
 [9,20,22,47],[9,20,22,48],[9,20,22,49],[9,20,22,54],
 [9,20,22,55],[9,20,22,56],[9,20,22,57],[9,20,22,58],
 [9,20,22,59],[9,20,22,60],[9,20,22,61],[9,20,22,62],
 [9,20,22,63],[9,20,22,64],[9,20,22,65],[9,20,22,66],
 [9,20,22,67],[9,20,22,68],[9,20,22,69],[9,20,23,24],
 [9,20,23,25],[9,20,23,26],[9,20,23,27],[9,20,23,34],
 [9,20,23,36],[9,20,23,37],[9,20,23,39],[9,20,23,41],
 [9,20,23,42],[9,20,23,43],[9,20,23,44],[9,20,23,45],
 [9,20,23,46],[9,20,23,47],[9,20,23,48],[9,20,23,49],
 [9,20,23,53],[9,20,23,55],[9,20,23,56],[9,20,23,57],
 [9,20,23,58],[9,20,23,59],[9,20,23,60],[9,20,23,61],
 [9,20,23,62],[9,20,23,65],[9,20,23,66],[9,20,23,67],
 [9,20,23,68],[9,20,23,69],[9,20,24,25],[9,20,24,26],
 [9,20,24,27],[9,20,24,28],[9,20,24,29],[9,20,24,30],
 [9,20,24,31],[9,20,24,32],[9,20,24,34],[9,20,24,36],
 [9,20,24,37],[9,20,24,38],[9,20,24,39],[9,20,24,40],
 [9,20,24,41],[9,20,24,42],[9,20,24,43],[9,20,24,44],
 [9,20,24,45],[9,20,24,46],[9,20,24,47],[9,20,24,48],
 [9,20,24,49],[9,20,24,53],[9,20,24,54],[9,20,24,55],
 [9,20,24,56],[9,20,24,57],[9,20,24,58],[9,20,24,59],
 [9,20,24,60],[9,20,24,61],[9,20,24,62],[9,20,24,63],
 [9,20,24,64],[9,20,24,65],[9,20,24,66],[9,20,24,67],
 [9,20,24,68],[9,20,24,69],[9,20,25,26],[9,20,25,27],
 [9,20,25,32],[9,20,25,34],[9,20,25,36],[9,20,25,37],
 [9,20,25,39],[9,20,25,41],[9,20,25,43],[9,20,25,44],
 [9,20,25,45],[9,20,25,46],[9,20,25,47],[9,20,25,48],
 [9,20,25,49],[9,20,25,53],[9,20,25,54],[9,20,25,55],
 [9,20,25,58],[9,20,25,59],[9,20,25,60],[9,20,25,61],
 [9,20,25,62],[9,20,25,66],[9,20,25,67],[9,20,25,68],
 [9,20,25,69],[9,20,26,27],[9,20,26,28],[9,20,26,29],
 [9,20,26,30],[9,20,26,31],[9,20,26,32],[9,20,26,34],
 [9,20,26,36],[9,20,26,37],[9,20,26,38],[9,20,26,39],
 [9,20,26,40],[9,20,26,41],[9,20,26,42],[9,20,26,43],
 [9,20,26,44],[9,20,26,45],[9,20,26,46],[9,20,26,47],
 [9,20,26,48],[9,20,26,49],[9,20,26,54],[9,20,26,55],
 [9,20,26,56],[9,20,26,57],[9,20,26,58],[9,20,26,59],
 [9,20,26,60],[9,20,26,61],[9,20,26,62],[9,20,26,63],
 [9,20,26,64],[9,20,26,65],[9,20,26,66],[9,20,26,67],
 [9,20,26,68],[9,20,26,69],[9,20,27,32],[9,20,27,34],
 [9,20,27,36],[9,20,27,37],[9,20,27,39],[9,20,27,41],
 [9,20,27,43],[9,20,27,44],[9,20,27,45],[9,20,27,46],
 [9,20,27,47],[9,20,27,48],[9,20,27,49],[9,20,27,53],
 [9,20,27,54],[9,20,27,55],[9,20,27,58],[9,20,27,59],
 [9,20,27,60],[9,20,27,61],[9,20,27,62],[9,20,27,66],
 [9,20,27,67],[9,20,27,68],[9,20,27,69],[9,20,28,30],
 [9,20,28,41],[9,20,28,44],[9,20,28,47],[9,20,28,49],
 [9,20,28,59],[9,20,28,61],[9,20,28,68],[9,20,29,31],
 [9,20,29,32],[9,20,29,36],[9,20,29,37],[9,20,29,41],
 [9,20,29,44],[9,20,29,47],[9,20,29,49],[9,20,29,59],
 [9,20,29,61],[9,20,29,67],[9,20,29,68],[9,20,29,69],
 [9,20,30,41],[9,20,30,44],[9,20,30,47],[9,20,30,49],
 [9,20,30,53],[9,20,30,59],[9,20,30,61],[9,20,30,68],
 [9,20,31,32],[9,20,31,41],[9,20,31,42],[9,20,31,44],
 [9,20,31,47],[9,20,31,48],[9,20,31,49],[9,20,31,53],
 [9,20,31,59],[9,20,31,61],[9,20,31,67],[9,20,31,68],
 [9,20,31,69],[9,20,32,38],[9,20,32,40],[9,20,32,41],
 [9,20,32,44],[9,20,32,46],[9,20,32,47],[9,20,32,49],
 [9,20,32,59],[9,20,32,60],[9,20,32,61],[9,20,32,62],
 [9,20,32,63],[9,20,32,68],[9,20,34,39],[9,20,34,41],
 [9,20,34,43],[9,20,34,44],[9,20,34,45],[9,20,34,46],
 [9,20,34,47],[9,20,34,48],[9,20,34,49],[9,20,34,55],
 [9,20,34,58],[9,20,34,59],[9,20,34,60],[9,20,34,61],
 [9,20,34,62],[9,20,34,66],[9,20,34,67],[9,20,34,68],
 [9,20,34,69],[9,20,36,37],[9,20,36,38],[9,20,36,40],
 [9,20,36,43],[9,20,36,45],[9,20,36,46],[9,20,36,60],
 [9,20,36,61],[9,20,36,62],[9,20,36,63],[9,20,36,64],
 [9,20,36,68],[9,20,37,38],[9,20,37,40],[9,20,37,45],
 [9,20,37,46],[9,20,37,48],[9,20,37,60],[9,20,37,61],
 [9,20,37,62],[9,20,37,63],[9,20,37,64],[9,20,37,68],
 [9,20,38,40],[9,20,38,41],[9,20,38,42],[9,20,38,44],
 [9,20,38,47],[9,20,38,48],[9,20,38,49],[9,20,38,53],
 [9,20,38,58],[9,20,38,59],[9,20,38,61],[9,20,38,63],
 [9,20,38,64],[9,20,38,65],[9,20,38,68],[9,20,38,69],
 [9,20,39,41],[9,20,39,43],[9,20,39,44],[9,20,39,45],
 [9,20,39,46],[9,20,39,47],[9,20,39,48],[9,20,39,49],
 [9,20,39,55],[9,20,39,58],[9,20,39,59],[9,20,39,60],
 [9,20,39,61],[9,20,39,62],[9,20,39,66],[9,20,39,67],
 [9,20,39,68],[9,20,39,69],[9,20,40,41],[9,20,40,42],
 [9,20,40,44],[9,20,40,47],[9,20,40,48],[9,20,40,49],
 [9,20,40,53],[9,20,40,59],[9,20,40,61],[9,20,40,63],
 [9,20,40,64],[9,20,40,65],[9,20,40,67],[9,20,40,68],
 [9,20,41,42],[9,20,41,43],[9,20,41,44],[9,20,41,45],
 [9,20,41,46],[9,20,41,47],[9,20,41,48],[9,20,41,49],
 [9,20,41,53],[9,20,41,54],[9,20,41,55],[9,20,41,56],
 [9,20,41,57],[9,20,41,58],[9,20,41,59],[9,20,41,60],
 [9,20,41,61],[9,20,41,62],[9,20,41,63],[9,20,41,64],
 [9,20,41,65],[9,20,41,66],[9,20,41,67],[9,20,41,68],
 [9,20,41,69],[9,20,42,44],[9,20,42,46],[9,20,42,47],
 [9,20,42,49],[9,20,42,59],[9,20,42,60],[9,20,42,61],
 [9,20,42,63],[9,20,42,64],[9,20,42,65],[9,20,42,68],
 [9,20,43,44],[9,20,43,45],[9,20,43,46],[9,20,43,47],
 [9,20,43,48],[9,20,43,49],[9,20,43,55],[9,20,43,56],
 [9,20,43,58],[9,20,43,59],[9,20,43,60],[9,20,43,61],
 [9,20,43,62],[9,20,43,66],[9,20,43,67],[9,20,43,68],
 [9,20,43,69],[9,20,44,45],[9,20,44,46],[9,20,44,47],
 [9,20,44,48],[9,20,44,49],[9,20,44,53],[9,20,44,54],
 [9,20,44,55],[9,20,44,56],[9,20,44,57],[9,20,44,58],
 [9,20,44,59],[9,20,44,60],[9,20,44,61],[9,20,44,62],
 [9,20,44,63],[9,20,44,64],[9,20,44,65],[9,20,44,66],
 [9,20,44,67],[9,20,44,68],[9,20,44,69],[9,20,45,46],
 [9,20,45,47],[9,20,45,48],[9,20,45,49],[9,20,45,53],
 [9,20,45,54],[9,20,45,55],[9,20,45,58],[9,20,45,59],
 [9,20,45,60],[9,20,45,61],[9,20,45,62],[9,20,45,65],
 [9,20,45,66],[9,20,45,67],[9,20,45,68],[9,20,45,69],
 [9,20,46,47],[9,20,46,48],[9,20,46,49],[9,20,46,53],
 [9,20,46,55],[9,20,46,56],[9,20,46,57],[9,20,46,58],
 [9,20,46,59],[9,20,46,60],[9,20,46,61],[9,20,46,62],
 [9,20,46,65],[9,20,46,66],[9,20,46,67],[9,20,46,68],
 [9,20,46,69],[9,20,47,48],[9,20,47,49],[9,20,47,53],
 [9,20,47,54],[9,20,47,55],[9,20,47,56],[9,20,47,57],
 [9,20,47,58],[9,20,47,59],[9,20,47,60],[9,20,47,61],
 [9,20,47,62],[9,20,47,63],[9,20,47,64],[9,20,47,65],
 [9,20,47,66],[9,20,47,67],[9,20,47,68],[9,20,47,69],
 [9,20,48,49],[9,20,48,55],[9,20,48,58],[9,20,48,59],
 [9,20,48,60],[9,20,48,61],[9,20,48,62],[9,20,48,63],
 [9,20,48,64],[9,20,48,66],[9,20,48,67],[9,20,48,68],
 [9,20,48,69],[9,20,49,53],[9,20,49,54],[9,20,49,55],
 [9,20,49,56],[9,20,49,57],[9,20,49,58],[9,20,49,59],
 [9,20,49,60],[9,20,49,61],[9,20,49,62],[9,20,49,63],
 [9,20,49,64],[9,20,49,65],[9,20,49,66],[9,20,49,67],
 [9,20,49,68],[9,20,49,69],[9,20,53,54],[9,20,53,60],
 [9,20,53,62],[9,20,53,64],[9,20,53,68],[9,20,54,56],
 [9,20,54,57],[9,20,54,59],[9,20,54,60],[9,20,54,61],
 [9,20,54,62],[9,20,54,68],[9,20,54,69],[9,20,55,58],
 [9,20,55,59],[9,20,55,60],[9,20,55,61],[9,20,55,62],
 [9,20,55,66],[9,20,55,67],[9,20,55,68],[9,20,55,69],
 [9,20,56,57],[9,20,56,59],[9,20,56,61],[9,20,56,68],
 [9,20,57,59],[9,20,57,61],[9,20,57,68],[9,20,58,59],
 [9,20,58,60],[9,20,58,61],[9,20,58,62],[9,20,58,66],
 [9,20,58,67],[9,20,58,68],[9,20,58,69],[9,20,59,60],
 [9,20,59,61],[9,20,59,62],[9,20,59,63],[9,20,59,64],
 [9,20,59,65],[9,20,59,66],[9,20,59,67],[9,20,59,68],
 [9,20,59,69],[9,20,60,61],[9,20,60,62],[9,20,60,65],
 [9,20,60,66],[9,20,60,67],[9,20,60,68],[9,20,60,69],
 [9,20,61,62],[9,20,61,63],[9,20,61,64],[9,20,61,65],
 [9,20,61,66],[9,20,61,67],[9,20,61,68],[9,20,61,69],
 [9,20,62,65],[9,20,62,66],[9,20,62,67],[9,20,62,68],
 [9,20,62,69],[9,20,63,64],[9,20,63,65],[9,20,63,66],
 [9,20,63,67],[9,20,63,68],[9,20,64,65],[9,20,64,66],
 [9,20,64,67],[9,20,64,68],[9,20,64,69],[9,20,65,68],
 [9,20,66,67],[9,20,66,68],[9,20,66,69],[9,20,67,68],
 [9,20,67,69],[9,20,68,69],[9,21,22,23],[9,21,22,24],
 [9,21,22,25],[9,21,22,26],[9,21,22,27],[9,21,22,33],
 [9,21,22,34],[9,21,22,35],[9,21,22,36],[9,21,22,39],
 [9,21,22,41],[9,21,22,42],[9,21,22,43],[9,21,22,44],
 [9,21,22,45],[9,21,22,46],[9,21,22,47],[9,21,22,48],
 [9,21,22,49],[9,21,22,55],[9,21,22,58],[9,21,22,59],
 [9,21,22,60],[9,21,22,61],[9,21,22,62],[9,21,22,66],
 [9,21,22,67],[9,21,22,68],[9,21,22,69],[9,21,23,24],
 [9,21,23,25],[9,21,23,26],[9,21,23,27],[9,21,23,34],
 [9,21,23,37],[9,21,23,39],[9,21,23,41],[9,21,23,42],
 [9,21,23,43],[9,21,23,44],[9,21,23,45],[9,21,23,46],
 [9,21,23,47],[9,21,23,48],[9,21,23,49],[9,21,23,53],
 [9,21,23,55],[9,21,23,58],[9,21,23,59],[9,21,23,60],
 [9,21,23,61],[9,21,23,62],[9,21,23,65],[9,21,23,66],
 [9,21,23,67],[9,21,23,68],[9,21,23,69],[9,21,24,25],
 [9,21,24,26],[9,21,24,27],[9,21,24,33],[9,21,24,34],
 [9,21,24,35],[9,21,24,36],[9,21,24,37],[9,21,24,39],
 [9,21,24,41],[9,21,24,42],[9,21,24,43],[9,21,24,44],
 [9,21,24,45],[9,21,24,46],[9,21,24,47],[9,21,24,48],
 [9,21,24,49],[9,21,24,51],[9,21,24,53],[9,21,24,55],
 [9,21,24,58],[9,21,24,59],[9,21,24,60],[9,21,24,61],
 [9,21,24,62],[9,21,24,65],[9,21,24,66],[9,21,24,67],
 [9,21,24,68],[9,21,24,69],[9,21,25,26],[9,21,25,27],
 [9,21,25,33],[9,21,25,34],[9,21,25,35],[9,21,25,36],
 [9,21,25,37],[9,21,25,39],[9,21,25,41],[9,21,25,42],
 [9,21,25,43],[9,21,25,44],[9,21,25,45],[9,21,25,46],
 [9,21,25,47],[9,21,25,48],[9,21,25,49],[9,21,25,51],
 [9,21,25,53],[9,21,25,55],[9,21,25,58],[9,21,25,59],
 [9,21,25,60],[9,21,25,61],[9,21,25,62],[9,21,25,65],
 [9,21,25,66],[9,21,25,67],[9,21,25,68],[9,21,25,69],
 [9,21,26,27],[9,21,26,34],[9,21,26,37],[9,21,26,39],
 [9,21,26,41],[9,21,26,43],[9,21,26,44],[9,21,26,45],
 [9,21,26,46],[9,21,26,47],[9,21,26,48],[9,21,26,49],
 [9,21,26,51],[9,21,26,55],[9,21,26,58],[9,21,26,59],
 [9,21,26,60],[9,21,26,61],[9,21,26,62],[9,21,26,66],
 [9,21,26,67],[9,21,26,68],[9,21,26,69],[9,21,27,33],
 [9,21,27,34],[9,21,27,35],[9,21,27,36],[9,21,27,37],
 [9,21,27,39],[9,21,27,41],[9,21,27,42],[9,21,27,43],
 [9,21,27,44],[9,21,27,45],[9,21,27,46],[9,21,27,47],
 [9,21,27,48],[9,21,27,49],[9,21,27,51],[9,21,27,53],
 [9,21,27,55],[9,21,27,58],[9,21,27,59],[9,21,27,60],
 [9,21,27,61],[9,21,27,62],[9,21,27,65],[9,21,27,66],
 [9,21,27,67],[9,21,27,68],[9,21,27,69],[9,21,33,35],
 [9,21,33,36],[9,21,33,37],[9,21,33,42],[9,21,33,45],
 [9,21,33,48],[9,21,33,49],[9,21,33,58],[9,21,33,59],
 [9,21,33,60],[9,21,33,62],[9,21,33,65],[9,21,33,66],
 [9,21,33,67],[9,21,33,68],[9,21,33,69],[9,21,34,39],
 [9,21,34,41],[9,21,34,43],[9,21,34,44],[9,21,34,45],
 [9,21,34,46],[9,21,34,47],[9,21,34,48],[9,21,34,49],
 [9,21,34,55],[9,21,34,58],[9,21,34,59],[9,21,34,60],
 [9,21,34,61],[9,21,34,62],[9,21,34,66],[9,21,34,67],
 [9,21,34,68],[9,21,34,69],[9,21,35,36],[9,21,35,37],
 [9,21,35,42],[9,21,35,45],[9,21,35,47],[9,21,35,48],
 [9,21,35,49],[9,21,35,55],[9,21,35,58],[9,21,35,59],
 [9,21,35,60],[9,21,35,62],[9,21,35,65],[9,21,35,66],
 [9,21,35,67],[9,21,35,68],[9,21,36,37],[9,21,36,43],
 [9,21,36,45],[9,21,36,46],[9,21,36,48],[9,21,36,60],
 [9,21,36,61],[9,21,36,62],[9,21,36,68],[9,21,37,43],
 [9,21,37,45],[9,21,37,46],[9,21,37,48],[9,21,37,60],
 [9,21,37,61],[9,21,37,62],[9,21,37,68],[9,21,39,41],
 [9,21,39,43],[9,21,39,44],[9,21,39,45],[9,21,39,46],
 [9,21,39,47],[9,21,39,48],[9,21,39,49],[9,21,39,55],
 [9,21,39,58],[9,21,39,59],[9,21,39,60],[9,21,39,61],
 [9,21,39,62],[9,21,39,66],[9,21,39,67],[9,21,39,68],
 [9,21,39,69],[9,21,41,42],[9,21,41,43],[9,21,41,44],
 [9,21,41,45],[9,21,41,46],[9,21,41,47],[9,21,41,48],
 [9,21,41,49],[9,21,41,53],[9,21,41,55],[9,21,41,58],
 [9,21,41,59],[9,21,41,60],[9,21,41,61],[9,21,41,62],
 [9,21,41,65],[9,21,41,66],[9,21,41,67],[9,21,41,68],
 [9,21,41,69],[9,21,42,44],[9,21,42,46],[9,21,42,59],
 [9,21,42,60],[9,21,42,62],[9,21,42,65],[9,21,42,68],
 [9,21,43,44],[9,21,43,45],[9,21,43,46],[9,21,43,47],
 [9,21,43,48],[9,21,43,49],[9,21,43,53],[9,21,43,55],
 [9,21,43,58],[9,21,43,59],[9,21,43,60],[9,21,43,61],
 [9,21,43,62],[9,21,43,66],[9,21,43,67],[9,21,43,68],
 [9,21,43,69],[9,21,44,45],[9,21,44,46],[9,21,44,47],
 [9,21,44,48],[9,21,44,49],[9,21,44,51],[9,21,44,53],
 [9,21,44,55],[9,21,44,58],[9,21,44,59],[9,21,44,60],
 [9,21,44,61],[9,21,44,62],[9,21,44,65],[9,21,44,66],
 [9,21,44,67],[9,21,44,68],[9,21,44,69],[9,21,45,46],
 [9,21,45,47],[9,21,45,48],[9,21,45,49],[9,21,45,51],
 [9,21,45,53],[9,21,45,55],[9,21,45,58],[9,21,45,59],
 [9,21,45,60],[9,21,45,61],[9,21,45,62],[9,21,45,65],
 [9,21,45,66],[9,21,45,67],[9,21,45,68],[9,21,45,69],
 [9,21,46,47],[9,21,46,48],[9,21,46,49],[9,21,46,53],
 [9,21,46,55],[9,21,46,58],[9,21,46,59],[9,21,46,60],
 [9,21,46,61],[9,21,46,62],[9,21,46,65],[9,21,46,66],
 [9,21,46,67],[9,21,46,68],[9,21,46,69],[9,21,47,48],
 [9,21,47,49],[9,21,47,53],[9,21,47,55],[9,21,47,58],
 [9,21,47,59],[9,21,47,60],[9,21,47,61],[9,21,47,62],
 [9,21,47,65],[9,21,47,66],[9,21,47,67],[9,21,47,68],
 [9,21,47,69],[9,21,48,49],[9,21,48,51],[9,21,48,53],
 [9,21,48,55],[9,21,48,58],[9,21,48,59],[9,21,48,60],
 [9,21,48,61],[9,21,48,62],[9,21,48,66],[9,21,48,67],
 [9,21,48,68],[9,21,48,69],[9,21,49,55],[9,21,49,58],
 [9,21,49,59],[9,21,49,60],[9,21,49,61],[9,21,49,62],
 [9,21,49,66],[9,21,49,67],[9,21,49,68],[9,21,49,69],
 [9,21,51,53],[9,21,51,59],[9,21,51,60],[9,21,51,62],
 [9,21,51,67],[9,21,51,68],[9,21,53,60],[9,21,53,62],
 [9,21,53,68],[9,21,55,58],[9,21,55,59],[9,21,55,60],
 [9,21,55,61],[9,21,55,62],[9,21,55,66],[9,21,55,67],
 [9,21,55,68],[9,21,55,69],[9,21,58,59],[9,21,58,60],
 [9,21,58,61],[9,21,58,62],[9,21,58,66],[9,21,58,67],
 [9,21,58,68],[9,21,58,69],[9,21,59,60],[9,21,59,61],
 [9,21,59,62],[9,21,59,65],[9,21,59,66],[9,21,59,67],
 [9,21,59,68],[9,21,59,69],[9,21,60,61],[9,21,60,62],
 [9,21,60,65],[9,21,60,66],[9,21,60,67],[9,21,60,68],
 [9,21,60,69],[9,21,61,62],[9,21,61,65],[9,21,61,66],
 [9,21,61,67],[9,21,61,68],[9,21,61,69],[9,21,62,65],
 [9,21,62,66],[9,21,62,67],[9,21,62,68],[9,21,62,69],
 [9,21,65,68],[9,21,66,67],[9,21,66,68],[9,21,66,69],
 [9,21,67,68],[9,21,67,69],[9,21,68,69],[9,22,23,24],
 [9,22,23,25],[9,22,23,26],[9,22,23,27],[9,22,23,34],
 [9,22,23,36],[9,22,23,37],[9,22,23,39],[9,22,23,41],
 [9,22,23,43],[9,22,23,44],[9,22,23,45],[9,22,23,46],
 [9,22,23,47],[9,22,23,48],[9,22,23,49],[9,22,23,55],
 [9,22,23,56],[9,22,23,57],[9,22,23,58],[9,22,23,59],
 [9,22,23,60],[9,22,23,61],[9,22,23,62],[9,22,23,65],
 [9,22,23,66],[9,22,23,67],[9,22,23,68],[9,22,23,69],
 [9,22,24,25],[9,22,24,26],[9,22,24,27],[9,22,24,28],
 [9,22,24,29],[9,22,24,30],[9,22,24,31],[9,22,24,32],
 [9,22,24,33],[9,22,24,34],[9,22,24,35],[9,22,24,36],
 [9,22,24,37],[9,22,24,38],[9,22,24,39],[9,22,24,40],
 [9,22,24,41],[9,22,24,42],[9,22,24,43],[9,22,24,44],
 [9,22,24,45],[9,22,24,46],[9,22,24,47],[9,22,24,48],
 [9,22,24,49],[9,22,24,54],[9,22,24,55],[9,22,24,56],
 [9,22,24,57],[9,22,24,58],[9,22,24,59],[9,22,24,60],
 [9,22,24,61],[9,22,24,62],[9,22,24,63],[9,22,24,64],
 [9,22,24,65],[9,22,24,66],[9,22,24,67],[9,22,24,68],
 [9,22,24,69],[9,22,25,26],[9,22,25,27],[9,22,25,32],
 [9,22,25,33],[9,22,25,34],[9,22,25,35],[9,22,25,36],
 [9,22,25,37],[9,22,25,39],[9,22,25,41],[9,22,25,42],
 [9,22,25,43],[9,22,25,44],[9,22,25,45],[9,22,25,46],
 [9,22,25,47],[9,22,25,48],[9,22,25,49],[9,22,25,54],
 [9,22,25,55],[9,22,25,58],[9,22,25,59],[9,22,25,60],
 [9,22,25,61],[9,22,25,62],[9,22,25,66],[9,22,25,67],
 [9,22,25,68],[9,22,25,69],[9,22,26,27],[9,22,26,28],
 [9,22,26,29],[9,22,26,30],[9,22,26,31],[9,22,26,32],
 [9,22,26,34],[9,22,26,36],[9,22,26,37],[9,22,26,38],
 [9,22,26,39],[9,22,26,40],[9,22,26,41],[9,22,26,42],
 [9,22,26,43],[9,22,26,44],[9,22,26,45],[9,22,26,46],
 [9,22,26,47],[9,22,26,48],[9,22,26,49],[9,22,26,54],
 [9,22,26,55],[9,22,26,56],[9,22,26,57],[9,22,26,58],
 [9,22,26,59],[9,22,26,60],[9,22,26,61],[9,22,26,62],
 [9,22,26,63],[9,22,26,64],[9,22,26,65],[9,22,26,66],
 [9,22,26,67],[9,22,26,68],[9,22,26,69],[9,22,27,32],
 [9,22,27,33],[9,22,27,34],[9,22,27,37],[9,22,27,39],
 [9,22,27,41],[9,22,27,42],[9,22,27,43],[9,22,27,44],
 [9,22,27,45],[9,22,27,46],[9,22,27,47],[9,22,27,48],
 [9,22,27,49],[9,22,27,54],[9,22,27,55],[9,22,27,58],
 [9,22,27,59],[9,22,27,60],[9,22,27,61],[9,22,27,62],
 [9,22,27,65],[9,22,27,66],[9,22,27,67],[9,22,27,68],
 [9,22,27,69],[9,22,28,30],[9,22,28,41],[9,22,28,44],
 [9,22,28,47],[9,22,28,49],[9,22,28,58],[9,22,28,59],
 [9,22,28,61],[9,22,28,68],[9,22,29,31],[9,22,29,32],
 [9,22,29,36],[9,22,29,41],[9,22,29,44],[9,22,29,47],
 [9,22,29,49],[9,22,29,59],[9,22,29,61],[9,22,29,65],
 [9,22,29,67],[9,22,29,68],[9,22,29,69],[9,22,30,41],
 [9,22,30,44],[9,22,30,47],[9,22,30,49],[9,22,30,59],
 [9,22,30,61],[9,22,30,68],[9,22,31,32],[9,22,31,36],
 [9,22,31,37],[9,22,31,41],[9,22,31,44],[9,22,31,47],
 [9,22,31,48],[9,22,31,49],[9,22,31,59],[9,22,31,61],
 [9,22,31,65],[9,22,31,68],[9,22,31,69],[9,22,32,35],
 [9,22,32,40],[9,22,32,41],[9,22,32,44],[9,22,32,47],
 [9,22,32,49],[9,22,32,59],[9,22,32,60],[9,22,32,61],
 [9,22,32,62],[9,22,32,63],[9,22,32,64],[9,22,32,68],
 [9,22,33,35],[9,22,33,36],[9,22,33,37],[9,22,33,41],
 [9,22,33,47],[9,22,33,49],[9,22,33,56],[9,22,33,57],
 [9,22,33,58],[9,22,33,59],[9,22,33,60],[9,22,33,62],
 [9,22,33,65],[9,22,33,66],[9,22,33,67],[9,22,33,68],
 [9,22,33,69],[9,22,34,39],[9,22,34,41],[9,22,34,43],
 [9,22,34,44],[9,22,34,45],[9,22,34,46],[9,22,34,47],
 [9,22,34,48],[9,22,34,49],[9,22,34,55],[9,22,34,58],
 [9,22,34,59],[9,22,34,60],[9,22,34,61],[9,22,34,62],
 [9,22,34,66],[9,22,34,67],[9,22,34,68],[9,22,34,69],
 [9,22,35,36],[9,22,35,37],[9,22,35,41],[9,22,35,42],
 [9,22,35,45],[9,22,35,47],[9,22,35,49],[9,22,35,56],
 [9,22,35,57],[9,22,35,58],[9,22,35,60],[9,22,35,62],
 [9,22,35,66],[9,22,35,67],[9,22,35,68],[9,22,35,69],
 [9,22,36,37],[9,22,36,38],[9,22,36,40],[9,22,36,43],
 [9,22,36,45],[9,22,36,46],[9,22,36,54],[9,22,36,60],
 [9,22,36,61],[9,22,36,62],[9,22,36,63],[9,22,36,64],
 [9,22,36,68],[9,22,37,38],[9,22,37,40],[9,22,37,43],
 [9,22,37,45],[9,22,37,46],[9,22,37,60],[9,22,37,61],
 [9,22,37,62],[9,22,37,63],[9,22,37,64],[9,22,37,68],
 [9,22,38,40],[9,22,38,41],[9,22,38,42],[9,22,38,44],
 [9,22,38,47],[9,22,38,49],[9,22,38,58],[9,22,38,59],
 [9,22,38,61],[9,22,38,63],[9,22,38,64],[9,22,38,65],
 [9,22,38,67],[9,22,38,68],[9,22,38,69],[9,22,39,41],
 [9,22,39,43],[9,22,39,44],[9,22,39,45],[9,22,39,46],
 [9,22,39,47],[9,22,39,48],[9,22,39,49],[9,22,39,55],
 [9,22,39,58],[9,22,39,59],[9,22,39,60],[9,22,39,61],
 [9,22,39,62],[9,22,39,66],[9,22,39,67],[9,22,39,68],
 [9,22,39,69],[9,22,40,41],[9,22,40,42],[9,22,40,44],
 [9,22,40,47],[9,22,40,48],[9,22,40,49],[9,22,40,58],
 [9,22,40,59],[9,22,40,61],[9,22,40,63],[9,22,40,64],
 [9,22,40,65],[9,22,40,68],[9,22,40,69],[9,22,41,42],
 [9,22,41,43],[9,22,41,44],[9,22,41,45],[9,22,41,46],
 [9,22,41,47],[9,22,41,48],[9,22,41,49],[9,22,41,54],
 [9,22,41,55],[9,22,41,56],[9,22,41,57],[9,22,41,58],
 [9,22,41,59],[9,22,41,60],[9,22,41,61],[9,22,41,62],
 [9,22,41,63],[9,22,41,64],[9,22,41,65],[9,22,41,66],
 [9,22,41,67],[9,22,41,68],[9,22,41,69],[9,22,42,44],
 [9,22,42,46],[9,22,42,47],[9,22,42,49],[9,22,42,59],
 [9,22,42,61],[9,22,42,62],[9,22,42,63],[9,22,42,64],
 [9,22,42,65],[9,22,42,68],[9,22,43,44],[9,22,43,45],
 [9,22,43,46],[9,22,43,47],[9,22,43,48],[9,22,43,49],
 [9,22,43,55],[9,22,43,56],[9,22,43,57],[9,22,43,58],
 [9,22,43,59],[9,22,43,60],[9,22,43,61],[9,22,43,62],
 [9,22,43,66],[9,22,43,67],[9,22,43,68],[9,22,43,69],
 [9,22,44,45],[9,22,44,46],[9,22,44,47],[9,22,44,48],
 [9,22,44,49],[9,22,44,54],[9,22,44,55],[9,22,44,56],
 [9,22,44,57],[9,22,44,58],[9,22,44,59],[9,22,44,60],
 [9,22,44,61],[9,22,44,62],[9,22,44,63],[9,22,44,64],
 [9,22,44,65],[9,22,44,66],[9,22,44,67],[9,22,44,68],
 [9,22,44,69],[9,22,45,46],[9,22,45,47],[9,22,45,48],
 [9,22,45,49],[9,22,45,54],[9,22,45,55],[9,22,45,58],
 [9,22,45,59],[9,22,45,60],[9,22,45,61],[9,22,45,62],
 [9,22,45,65],[9,22,45,66],[9,22,45,67],[9,22,45,68],
 [9,22,45,69],[9,22,46,47],[9,22,46,48],[9,22,46,49],
 [9,22,46,55],[9,22,46,57],[9,22,46,58],[9,22,46,59],
 [9,22,46,60],[9,22,46,61],[9,22,46,62],[9,22,46,65],
 [9,22,46,66],[9,22,46,67],[9,22,46,68],[9,22,46,69],
 [9,22,47,48],[9,22,47,49],[9,22,47,54],[9,22,47,55],
 [9,22,47,56],[9,22,47,57],[9,22,47,58],[9,22,47,59],
 [9,22,47,60],[9,22,47,61],[9,22,47,62],[9,22,47,63],
 [9,22,47,64],[9,22,47,65],[9,22,47,66],[9,22,47,67],
 [9,22,47,68],[9,22,47,69],[9,22,48,49],[9,22,48,55],
 [9,22,48,56],[9,22,48,58],[9,22,48,59],[9,22,48,60],
 [9,22,48,61],[9,22,48,62],[9,22,48,63],[9,22,48,64],
 [9,22,48,66],[9,22,48,67],[9,22,48,68],[9,22,48,69],
 [9,22,49,54],[9,22,49,55],[9,22,49,56],[9,22,49,57],
 [9,22,49,58],[9,22,49,59],[9,22,49,60],[9,22,49,61],
 [9,22,49,62],[9,22,49,63],[9,22,49,64],[9,22,49,65],
 [9,22,49,66],[9,22,49,67],[9,22,49,68],[9,22,49,69],
 [9,22,54,56],[9,22,54,57],[9,22,54,59],[9,22,54,61],
 [9,22,54,62],[9,22,54,67],[9,22,54,68],[9,22,55,58],
 [9,22,55,59],[9,22,55,60],[9,22,55,61],[9,22,55,62],
 [9,22,55,66],[9,22,55,67],[9,22,55,68],[9,22,55,69],
 [9,22,56,57],[9,22,56,59],[9,22,56,61],[9,22,56,68],
 [9,22,57,59],[9,22,57,61],[9,22,57,68],[9,22,58,59],
 [9,22,58,60],[9,22,58,61],[9,22,58,62],[9,22,58,66],
 [9,22,58,67],[9,22,58,68],[9,22,58,69],[9,22,59,60],
 [9,22,59,61],[9,22,59,62],[9,22,59,63],[9,22,59,64],
 [9,22,59,65],[9,22,59,66],[9,22,59,67],[9,22,59,68],
 [9,22,59,69],[9,22,60,61],[9,22,60,62],[9,22,60,65],
 [9,22,60,66],[9,22,60,67],[9,22,60,68],[9,22,60,69],
 [9,22,61,62],[9,22,61,63],[9,22,61,64],[9,22,61,65],
 [9,22,61,66],[9,22,61,67],[9,22,61,68],[9,22,61,69],
 [9,22,62,66],[9,22,62,67],[9,22,62,68],[9,22,62,69],
 [9,22,63,64],[9,22,63,65],[9,22,63,68],[9,22,63,69],
 [9,22,64,65],[9,22,64,66],[9,22,64,67],[9,22,64,68],
 [9,22,65,68],[9,22,66,67],[9,22,66,68],[9,22,66,69],
 [9,22,67,68],[9,22,67,69],[9,22,68,69],[9,23,24,25],
 [9,23,24,26],[9,23,24,27],[9,23,24,32],[9,23,24,34],
 [9,23,24,36],[9,23,24,37],[9,23,24,39],[9,23,24,41],
 [9,23,24,42],[9,23,24,43],[9,23,24,44],[9,23,24,45],
 [9,23,24,46],[9,23,24,47],[9,23,24,48],[9,23,24,49],
 [9,23,24,53],[9,23,24,55],[9,23,24,56],[9,23,24,57],
 [9,23,24,58],[9,23,24,59],[9,23,24,60],[9,23,24,61],
 [9,23,24,62],[9,23,24,65],[9,23,24,66],[9,23,24,67],
 [9,23,24,68],[9,23,24,69],[9,23,25,26],[9,23,25,27],
 [9,23,25,32],[9,23,25,34],[9,23,25,37],[9,23,25,39],
 [9,23,25,41],[9,23,25,42],[9,23,25,43],[9,23,25,44],
 [9,23,25,45],[9,23,25,46],[9,23,25,47],[9,23,25,48],
 [9,23,25,49],[9,23,25,53],[9,23,25,55],[9,23,25,58],
 [9,23,25,59],[9,23,25,60],[9,23,25,61],[9,23,25,62],
 [9,23,25,65],[9,23,25,66],[9,23,25,67],[9,23,25,68],
 [9,23,25,69],[9,23,26,27],[9,23,26,34],[9,23,26,36],
 [9,23,26,37],[9,23,26,39],[9,23,26,41],[9,23,26,43],
 [9,23,26,44],[9,23,26,45],[9,23,26,46],[9,23,26,47],
 [9,23,26,48],[9,23,26,49],[9,23,26,55],[9,23,26,56],
 [9,23,26,57],[9,23,26,58],[9,23,26,59],[9,23,26,60],
 [9,23,26,61],[9,23,26,62],[9,23,26,66],[9,23,26,67],
 [9,23,26,68],[9,23,26,69],[9,23,27,32],[9,23,27,34],
 [9,23,27,36],[9,23,27,39],[9,23,27,41],[9,23,27,42],
 [9,23,27,43],[9,23,27,44],[9,23,27,45],[9,23,27,46],
 [9,23,27,47],[9,23,27,48],[9,23,27,49],[9,23,27,53],
 [9,23,27,55],[9,23,27,58],[9,23,27,59],[9,23,27,60],
 [9,23,27,61],[9,23,27,62],[9,23,27,65],[9,23,27,66],
 [9,23,27,67],[9,23,27,68],[9,23,27,69],[9,23,32,41],
 [9,23,32,44],[9,23,32,46],[9,23,32,47],[9,23,32,49],
 [9,23,32,59],[9,23,32,60],[9,23,32,61],[9,23,32,62],
 [9,23,32,68],[9,23,34,39],[9,23,34,41],[9,23,34,43],
 [9,23,34,44],[9,23,34,45],[9,23,34,46],[9,23,34,47],
 [9,23,34,48],[9,23,34,49],[9,23,34,55],[9,23,34,58],
 [9,23,34,59],[9,23,34,60],[9,23,34,61],[9,23,34,62],
 [9,23,34,66],[9,23,34,67],[9,23,34,68],[9,23,34,69],
 [9,23,36,37],[9,23,36,43],[9,23,36,46],[9,23,36,48],
 [9,23,36,60],[9,23,36,61],[9,23,36,62],[9,23,36,68],
 [9,23,37,43],[9,23,37,45],[9,23,37,46],[9,23,37,48],
 [9,23,37,60],[9,23,37,61],[9,23,37,62],[9,23,37,68],
 [9,23,39,41],[9,23,39,43],[9,23,39,44],[9,23,39,45],
 [9,23,39,46],[9,23,39,47],[9,23,39,48],[9,23,39,49],
 [9,23,39,55],[9,23,39,58],[9,23,39,59],[9,23,39,60],
 [9,23,39,61],[9,23,39,62],[9,23,39,66],[9,23,39,67],
 [9,23,39,68],[9,23,39,69],[9,23,41,42],[9,23,41,43],
 [9,23,41,44],[9,23,41,45],[9,23,41,46],[9,23,41,47],
 [9,23,41,48],[9,23,41,49],[9,23,41,53],[9,23,41,55],
 [9,23,41,56],[9,23,41,58],[9,23,41,59],[9,23,41,60],
 [9,23,41,61],[9,23,41,62],[9,23,41,65],[9,23,41,66],
 [9,23,41,67],[9,23,41,68],[9,23,41,69],[9,23,42,46],
 [9,23,42,47],[9,23,42,49],[9,23,42,59],[9,23,42,60],
 [9,23,42,61],[9,23,42,62],[9,23,42,65],[9,23,42,68],
 [9,23,43,44],[9,23,43,45],[9,23,43,46],[9,23,43,47],
 [9,23,43,48],[9,23,43,49],[9,23,43,53],[9,23,43,55],
 [9,23,43,56],[9,23,43,57],[9,23,43,58],[9,23,43,59],
 [9,23,43,60],[9,23,43,61],[9,23,43,62],[9,23,43,66],
 [9,23,43,67],[9,23,43,68],[9,23,43,69],[9,23,44,45],
 [9,23,44,46],[9,23,44,47],[9,23,44,48],[9,23,44,49],
 [9,23,44,53],[9,23,44,55],[9,23,44,56],[9,23,44,57],
 [9,23,44,58],[9,23,44,59],[9,23,44,60],[9,23,44,61],
 [9,23,44,62],[9,23,44,65],[9,23,44,66],[9,23,44,67],
 [9,23,44,68],[9,23,44,69],[9,23,45,46],[9,23,45,47],
 [9,23,45,48],[9,23,45,49],[9,23,45,53],[9,23,45,55],
 [9,23,45,58],[9,23,45,59],[9,23,45,60],[9,23,45,61],
 [9,23,45,62],[9,23,45,65],[9,23,45,66],[9,23,45,67],
 [9,23,45,68],[9,23,45,69],[9,23,46,47],[9,23,46,48],
 [9,23,46,49],[9,23,46,53],[9,23,46,55],[9,23,46,56],
 [9,23,46,57],[9,23,46,58],[9,23,46,59],[9,23,46,60],
 [9,23,46,61],[9,23,46,62],[9,23,46,65],[9,23,46,66],
 [9,23,46,67],[9,23,46,68],[9,23,46,69],[9,23,47,48],
 [9,23,47,49],[9,23,47,53],[9,23,47,55],[9,23,47,57],
 [9,23,47,58],[9,23,47,59],[9,23,47,60],[9,23,47,61],
 [9,23,47,62],[9,23,47,65],[9,23,47,66],[9,23,47,67],
 [9,23,47,68],[9,23,47,69],[9,23,48,49],[9,23,48,53],
 [9,23,48,55],[9,23,48,56],[9,23,48,57],[9,23,48,58],
 [9,23,48,59],[9,23,48,60],[9,23,48,61],[9,23,48,62],
 [9,23,48,66],[9,23,48,67],[9,23,48,68],[9,23,48,69],
 [9,23,49,53],[9,23,49,55],[9,23,49,56],[9,23,49,58],
 [9,23,49,59],[9,23,49,60],[9,23,49,61],[9,23,49,62],
 [9,23,49,65],[9,23,49,66],[9,23,49,67],[9,23,49,68],
 [9,23,49,69],[9,23,53,60],[9,23,53,62],[9,23,53,68],
 [9,23,55,58],[9,23,55,59],[9,23,55,60],[9,23,55,61],
 [9,23,55,62],[9,23,55,66],[9,23,55,67],[9,23,55,68],
 [9,23,55,69],[9,23,56,57],[9,23,56,61],[9,23,56,68],
 [9,23,57,59],[9,23,57,61],[9,23,57,68],[9,23,58,59],
 [9,23,58,60],[9,23,58,61],[9,23,58,62],[9,23,58,66],
 [9,23,58,67],[9,23,58,68],[9,23,58,69],[9,23,59,60],
 [9,23,59,61],[9,23,59,62],[9,23,59,66],[9,23,59,67],
 [9,23,59,68],[9,23,59,69],[9,23,60,61],[9,23,60,62],
 [9,23,60,65],[9,23,60,66],[9,23,60,67],[9,23,60,68],
 [9,23,60,69],[9,23,61,62],[9,23,61,65],[9,23,61,66],
 [9,23,61,67],[9,23,61,68],[9,23,61,69],[9,23,62,65],
 [9,23,62,66],[9,23,62,67],[9,23,62,68],[9,23,62,69],
 [9,23,65,68],[9,23,66,67],[9,23,66,68],[9,23,66,69],
 [9,23,67,68],[9,23,67,69],[9,23,68,69],[9,24,25,26],
 [9,24,25,27],[9,24,25,32],[9,24,25,33],[9,24,25,34],
 [9,24,25,35],[9,24,25,36],[9,24,25,37],[9,24,25,39],
 [9,24,25,41],[9,24,25,42],[9,24,25,43],[9,24,25,44],
 [9,24,25,45],[9,24,25,46],[9,24,25,47],[9,24,25,48],
 [9,24,25,49],[9,24,25,51],[9,24,25,53],[9,24,25,54],
 [9,24,25,55],[9,24,25,58],[9,24,25,59],[9,24,25,60],
 [9,24,25,61],[9,24,25,62],[9,24,25,65],[9,24,25,66],
 [9,24,25,67],[9,24,25,68],[9,24,25,69],[9,24,26,27],
 [9,24,26,28],[9,24,26,29],[9,24,26,30],[9,24,26,31],
 [9,24,26,32],[9,24,26,34],[9,24,26,36],[9,24,26,37],
 [9,24,26,38],[9,24,26,39],[9,24,26,40],[9,24,26,41],
 [9,24,26,42],[9,24,26,43],[9,24,26,44],[9,24,26,45],
 [9,24,26,46],[9,24,26,47],[9,24,26,48],[9,24,26,49],
 [9,24,26,51],[9,24,26,54],[9,24,26,55],[9,24,26,56],
 [9,24,26,57],[9,24,26,58],[9,24,26,59],[9,24,26,60],
 [9,24,26,61],[9,24,26,62],[9,24,26,63],[9,24,26,64],
 [9,24,26,65],[9,24,26,66],[9,24,26,67],[9,24,26,68],
 [9,24,26,69],[9,24,27,32],[9,24,27,33],[9,24,27,34],
 [9,24,27,35],[9,24,27,36],[9,24,27,37],[9,24,27,39],
 [9,24,27,41],[9,24,27,42],[9,24,27,43],[9,24,27,44],
 [9,24,27,45],[9,24,27,46],[9,24,27,47],[9,24,27,48],
 [9,24,27,49],[9,24,27,51],[9,24,27,53],[9,24,27,54],
 [9,24,27,55],[9,24,27,58],[9,24,27,59],[9,24,27,60],
 [9,24,27,61],[9,24,27,62],[9,24,27,65],[9,24,27,66],
 [9,24,27,67],[9,24,27,68],[9,24,27,69],[9,24,28,30],
 [9,24,28,41],[9,24,28,44],[9,24,28,47],[9,24,28,48],
 [9,24,28,49],[9,24,28,58],[9,24,28,59],[9,24,28,61],
 [9,24,28,68],[9,24,29,31],[9,24,29,32],[9,24,29,36],
 [9,24,29,37],[9,24,29,41],[9,24,29,42],[9,24,29,44],
 [9,24,29,47],[9,24,29,48],[9,24,29,49],[9,24,29,53],
 [9,24,29,59],[9,24,29,61],[9,24,29,65],[9,24,29,67],
 [9,24,29,68],[9,24,29,69],[9,24,30,41],[9,24,30,44],
 [9,24,30,47],[9,24,30,48],[9,24,30,49],[9,24,30,53],
 [9,24,30,59],[9,24,30,61],[9,24,30,68],[9,24,31,32],
 [9,24,31,36],[9,24,31,37],[9,24,31,41],[9,24,31,42],
 [9,24,31,44],[9,24,31,47],[9,24,31,48],[9,24,31,49],
 [9,24,31,53],[9,24,31,59],[9,24,31,61],[9,24,31,65],
 [9,24,31,67],[9,24,31,68],[9,24,31,69],[9,24,32,33],
 [9,24,32,35],[9,24,32,38],[9,24,32,40],[9,24,32,41],
 [9,24,32,44],[9,24,32,46],[9,24,32,47],[9,24,32,49],
 [9,24,32,51],[9,24,32,59],[9,24,32,60],[9,24,32,61],
 [9,24,32,62],[9,24,32,63],[9,24,32,64],[9,24,32,68],
 [9,24,33,35],[9,24,33,36],[9,24,33,37],[9,24,33,41],
 [9,24,33,42],[9,24,33,45],[9,24,33,47],[9,24,33,48],
 [9,24,33,49],[9,24,33,55],[9,24,33,56],[9,24,33,57],
 [9,24,33,58],[9,24,33,59],[9,24,33,60],[9,24,33,62],
 [9,24,33,65],[9,24,33,66],[9,24,33,67],[9,24,33,68],
 [9,24,33,69],[9,24,34,39],[9,24,34,41],[9,24,34,43],
 [9,24,34,44],[9,24,34,45],[9,24,34,46],[9,24,34,47],
 [9,24,34,48],[9,24,34,49],[9,24,34,55],[9,24,34,58],
 [9,24,34,59],[9,24,34,60],[9,24,34,61],[9,24,34,62],
 [9,24,34,66],[9,24,34,67],[9,24,34,68],[9,24,34,69],
 [9,24,35,36],[9,24,35,37],[9,24,35,41],[9,24,35,42],
 [9,24,35,45],[9,24,35,47],[9,24,35,48],[9,24,35,49],
 [9,24,35,55],[9,24,35,56],[9,24,35,57],[9,24,35,58],
 [9,24,35,59],[9,24,35,60],[9,24,35,62],[9,24,35,65],
 [9,24,35,66],[9,24,35,67],[9,24,35,68],[9,24,35,69],
 [9,24,36,37],[9,24,36,38],[9,24,36,40],[9,24,36,43],
 [9,24,36,45],[9,24,36,46],[9,24,36,48],[9,24,36,54],
 [9,24,36,60],[9,24,36,61],[9,24,36,62],[9,24,36,63],
 [9,24,36,64],[9,24,36,68],[9,24,37,38],[9,24,37,40],
 [9,24,37,43],[9,24,37,45],[9,24,37,46],[9,24,37,48],
 [9,24,37,54],[9,24,37,60],[9,24,37,61],[9,24,37,62],
 [9,24,37,63],[9,24,37,64],[9,24,37,68],[9,24,38,40],
 [9,24,38,41],[9,24,38,42],[9,24,38,44],[9,24,38,47],
 [9,24,38,48],[9,24,38,49],[9,24,38,53],[9,24,38,58],
 [9,24,38,59],[9,24,38,61],[9,24,38,63],[9,24,38,64],
 [9,24,38,65],[9,24,38,67],[9,24,38,68],[9,24,38,69],
 [9,24,39,41],[9,24,39,43],[9,24,39,44],[9,24,39,45],
 [9,24,39,46],[9,24,39,47],[9,24,39,48],[9,24,39,49],
 [9,24,39,55],[9,24,39,58],[9,24,39,59],[9,24,39,60],
 [9,24,39,61],[9,24,39,62],[9,24,39,66],[9,24,39,67],
 [9,24,39,68],[9,24,39,69],[9,24,40,41],[9,24,40,42],
 [9,24,40,44],[9,24,40,47],[9,24,40,48],[9,24,40,49],
 [9,24,40,53],[9,24,40,58],[9,24,40,59],[9,24,40,61],
 [9,24,40,63],[9,24,40,64],[9,24,40,65],[9,24,40,67],
 [9,24,40,68],[9,24,40,69],[9,24,41,42],[9,24,41,43],
 [9,24,41,44],[9,24,41,45],[9,24,41,46],[9,24,41,47],
 [9,24,41,48],[9,24,41,49],[9,24,41,53],[9,24,41,54],
 [9,24,41,55],[9,24,41,56],[9,24,41,57],[9,24,41,58],
 [9,24,41,59],[9,24,41,60],[9,24,41,61],[9,24,41,62],
 [9,24,41,63],[9,24,41,64],[9,24,41,65],[9,24,41,66],
 [9,24,41,67],[9,24,41,68],[9,24,41,69],[9,24,42,44],
 [9,24,42,46],[9,24,42,47],[9,24,42,49],[9,24,42,51],
 [9,24,42,59],[9,24,42,60],[9,24,42,61],[9,24,42,62],
 [9,24,42,63],[9,24,42,64],[9,24,42,65],[9,24,42,68],
 [9,24,43,44],[9,24,43,45],[9,24,43,46],[9,24,43,47],
 [9,24,43,48],[9,24,43,49],[9,24,43,53],[9,24,43,55],
 [9,24,43,56],[9,24,43,57],[9,24,43,58],[9,24,43,59],
 [9,24,43,60],[9,24,43,61],[9,24,43,62],[9,24,43,66],
 [9,24,43,67],[9,24,43,68],[9,24,43,69],[9,24,44,45],
 [9,24,44,46],[9,24,44,47],[9,24,44,48],[9,24,44,49],
 [9,24,44,51],[9,24,44,53],[9,24,44,54],[9,24,44,55],
 [9,24,44,56],[9,24,44,57],[9,24,44,58],[9,24,44,59],
 [9,24,44,60],[9,24,44,61],[9,24,44,62],[9,24,44,63],
 [9,24,44,64],[9,24,44,65],[9,24,44,66],[9,24,44,67],
 [9,24,44,68],[9,24,44,69],[9,24,45,46],[9,24,45,47],
 [9,24,45,48],[9,24,45,49],[9,24,45,51],[9,24,45,53],
 [9,24,45,54],[9,24,45,55],[9,24,45,58],[9,24,45,59],
 [9,24,45,60],[9,24,45,61],[9,24,45,62],[9,24,45,65],
 [9,24,45,66],[9,24,45,67],[9,24,45,68],[9,24,45,69],
 [9,24,46,47],[9,24,46,48],[9,24,46,49],[9,24,46,53],
 [9,24,46,55],[9,24,46,56],[9,24,46,57],[9,24,46,58],
 [9,24,46,59],[9,24,46,60],[9,24,46,61],[9,24,46,62],
 [9,24,46,65],[9,24,46,66],[9,24,46,67],[9,24,46,68],
 [9,24,46,69],[9,24,47,48],[9,24,47,49],[9,24,47,53],
 [9,24,47,54],[9,24,47,55],[9,24,47,56],[9,24,47,57],
 [9,24,47,58],[9,24,47,59],[9,24,47,60],[9,24,47,61],
 [9,24,47,62],[9,24,47,63],[9,24,47,64],[9,24,47,65],
 [9,24,47,66],[9,24,47,67],[9,24,47,68],[9,24,47,69],
 [9,24,48,49],[9,24,48,51],[9,24,48,53],[9,24,48,55],
 [9,24,48,56],[9,24,48,57],[9,24,48,58],[9,24,48,59],
 [9,24,48,60],[9,24,48,61],[9,24,48,62],[9,24,48,63],
 [9,24,48,64],[9,24,48,66],[9,24,48,67],[9,24,48,68],
 [9,24,48,69],[9,24,49,53],[9,24,49,54],[9,24,49,55],
 [9,24,49,56],[9,24,49,57],[9,24,49,58],[9,24,49,59],
 [9,24,49,60],[9,24,49,61],[9,24,49,62],[9,24,49,63],
 [9,24,49,64],[9,24,49,65],[9,24,49,66],[9,24,49,67],
 [9,24,49,68],[9,24,49,69],[9,24,51,53],[9,24,51,55],
 [9,24,51,56],[9,24,51,57],[9,24,51,58],[9,24,51,59],
 [9,24,51,60],[9,24,51,61],[9,24,51,62],[9,24,51,63],
 [9,24,51,64],[9,24,51,65],[9,24,51,66],[9,24,51,67],
 [9,24,51,68],[9,24,51,69],[9,24,53,54],[9,24,53,60],
 [9,24,53,62],[9,24,53,63],[9,24,53,64],[9,24,53,68],
 [9,24,54,56],[9,24,54,57],[9,24,54,59],[9,24,54,60],
 [9,24,54,61],[9,24,54,62],[9,24,54,67],[9,24,54,68],
 [9,24,54,69],[9,24,55,58],[9,24,55,59],[9,24,55,60],
 [9,24,55,61],[9,24,55,62],[9,24,55,66],[9,24,55,67],
 [9,24,55,68],[9,24,55,69],[9,24,56,57],[9,24,56,59],
 [9,24,56,61],[9,24,56,68],[9,24,57,59],[9,24,57,61],
 [9,24,57,68],[9,24,58,59],[9,24,58,60],[9,24,58,61],
 [9,24,58,62],[9,24,58,66],[9,24,58,67],[9,24,58,68],
 [9,24,58,69],[9,24,59,60],[9,24,59,61],[9,24,59,62],
 [9,24,59,63],[9,24,59,64],[9,24,59,65],[9,24,59,66],
 [9,24,59,67],[9,24,59,68],[9,24,59,69],[9,24,60,61],
 [9,24,60,62],[9,24,60,65],[9,24,60,66],[9,24,60,67],
 [9,24,60,68],[9,24,60,69],[9,24,61,62],[9,24,61,63],
 [9,24,61,64],[9,24,61,65],[9,24,61,66],[9,24,61,67],
 [9,24,61,68],[9,24,61,69],[9,24,62,65],[9,24,62,66],
 [9,24,62,67],[9,24,62,68],[9,24,62,69],[9,24,63,64],
 [9,24,63,65],[9,24,63,66],[9,24,63,67],[9,24,63,68],
 [9,24,63,69],[9,24,64,65],[9,24,64,66],[9,24,64,67],
 [9,24,64,68],[9,24,64,69],[9,24,65,68],[9,24,66,67],
 [9,24,66,68],[9,24,66,69],[9,24,67,68],[9,24,67,69],
 [9,24,68,69],[9,25,26,27],[9,25,26,34],[9,25,26,37],
 [9,25,26,39],[9,25,26,41],[9,25,26,43],[9,25,26,44],
 [9,25,26,45],[9,25,26,46],[9,25,26,47],[9,25,26,48],
 [9,25,26,49],[9,25,26,51],[9,25,26,54],[9,25,26,55],
 [9,25,26,58],[9,25,26,59],[9,25,26,60],[9,25,26,61],
 [9,25,26,62],[9,25,26,66],[9,25,26,67],[9,25,26,68],
 [9,25,26,69],[9,25,27,32],[9,25,27,33],[9,25,27,34],
 [9,25,27,35],[9,25,27,36],[9,25,27,37],[9,25,27,39],
 [9,25,27,41],[9,25,27,42],[9,25,27,43],[9,25,27,44],
 [9,25,27,45],[9,25,27,46],[9,25,27,47],[9,25,27,48],
 [9,25,27,49],[9,25,27,51],[9,25,27,53],[9,25,27,54],
 [9,25,27,55],[9,25,27,58],[9,25,27,59],[9,25,27,60],
 [9,25,27,61],[9,25,27,62],[9,25,27,65],[9,25,27,66],
 [9,25,27,67],[9,25,27,68],[9,25,27,69],[9,25,32,35],
 [9,25,32,41],[9,25,32,44],[9,25,32,46],[9,25,32,47],
 [9,25,32,49],[9,25,32,51],[9,25,32,60],[9,25,32,61],
 [9,25,32,62],[9,25,32,68],[9,25,33,35],[9,25,33,36],
 [9,25,33,37],[9,25,33,45],[9,25,33,48],[9,25,33,49],
 [9,25,33,55],[9,25,33,59],[9,25,33,60],[9,25,33,62],
 [9,25,33,65],[9,25,33,66],[9,25,33,68],[9,25,33,69],
 [9,25,34,39],[9,25,34,41],[9,25,34,43],[9,25,34,44],
 [9,25,34,45],[9,25,34,46],[9,25,34,47],[9,25,34,48],
 [9,25,34,49],[9,25,34,55],[9,25,34,58],[9,25,34,59],
 [9,25,34,60],[9,25,34,61],[9,25,34,62],[9,25,34,66],
 [9,25,34,67],[9,25,34,68],[9,25,34,69],[9,25,35,36],
 [9,25,35,37],[9,25,35,41],[9,25,35,42],[9,25,35,45],
 [9,25,35,47],[9,25,35,48],[9,25,35,49],[9,25,35,55],
 [9,25,35,58],[9,25,35,59],[9,25,35,60],[9,25,35,62],
 [9,25,35,65],[9,25,35,66],[9,25,35,67],[9,25,35,68],
 [9,25,35,69],[9,25,36,37],[9,25,36,43],[9,25,36,45],
 [9,25,36,46],[9,25,36,48],[9,25,36,54],[9,25,36,60],
 [9,25,36,61],[9,25,36,62],[9,25,36,68],[9,25,37,43],
 [9,25,37,45],[9,25,37,46],[9,25,37,48],[9,25,37,54],
 [9,25,37,60],[9,25,37,61],[9,25,37,62],[9,25,37,68],
 [9,25,39,41],[9,25,39,43],[9,25,39,44],[9,25,39,45],
 [9,25,39,46],[9,25,39,47],[9,25,39,48],[9,25,39,49],
 [9,25,39,55],[9,25,39,58],[9,25,39,59],[9,25,39,60],
 [9,25,39,61],[9,25,39,62],[9,25,39,66],[9,25,39,67],
 [9,25,39,68],[9,25,39,69],[9,25,41,42],[9,25,41,43],
 [9,25,41,44],[9,25,41,45],[9,25,41,46],[9,25,41,47],
 [9,25,41,48],[9,25,41,49],[9,25,41,53],[9,25,41,54],
 [9,25,41,55],[9,25,41,58],[9,25,41,59],[9,25,41,60],
 [9,25,41,61],[9,25,41,62],[9,25,41,65],[9,25,41,66],
 [9,25,41,67],[9,25,41,68],[9,25,41,69],[9,25,42,44],
 [9,25,42,46],[9,25,42,47],[9,25,42,49],[9,25,42,51],
 [9,25,42,59],[9,25,42,60],[9,25,42,61],[9,25,42,62],
 [9,25,42,65],[9,25,42,68],[9,25,43,44],[9,25,43,45],
 [9,25,43,46],[9,25,43,47],[9,25,43,48],[9,25,43,49],
 [9,25,43,53],[9,25,43,55],[9,25,43,58],[9,25,43,59],
 [9,25,43,60],[9,25,43,61],[9,25,43,62],[9,25,43,66],
 [9,25,43,67],[9,25,43,68],[9,25,43,69],[9,25,44,45],
 [9,25,44,46],[9,25,44,47],[9,25,44,48],[9,25,44,49],
 [9,25,44,51],[9,25,44,54],[9,25,44,55],[9,25,44,58],
 [9,25,44,59],[9,25,44,60],[9,25,44,61],[9,25,44,62],
 [9,25,44,66],[9,25,44,67],[9,25,44,68],[9,25,44,69],
 [9,25,45,46],[9,25,45,47],[9,25,45,48],[9,25,45,49],
 [9,25,45,51],[9,25,45,53],[9,25,45,54],[9,25,45,55],
 [9,25,45,58],[9,25,45,59],[9,25,45,60],[9,25,45,61],
 [9,25,45,62],[9,25,45,65],[9,25,45,66],[9,25,45,67],
 [9,25,45,68],[9,25,45,69],[9,25,46,47],[9,25,46,48],
 [9,25,46,49],[9,25,46,53],[9,25,46,55],[9,25,46,58],
 [9,25,46,59],[9,25,46,60],[9,25,46,61],[9,25,46,62],
 [9,25,46,65],[9,25,46,66],[9,25,46,67],[9,25,46,68],
 [9,25,46,69],[9,25,47,48],[9,25,47,49],[9,25,47,53],
 [9,25,47,55],[9,25,47,58],[9,25,47,59],[9,25,47,60],
 [9,25,47,61],[9,25,47,62],[9,25,47,65],[9,25,47,66],
 [9,25,47,67],[9,25,47,68],[9,25,47,69],[9,25,48,49],
 [9,25,48,51],[9,25,48,53],[9,25,48,55],[9,25,48,58],
 [9,25,48,59],[9,25,48,60],[9,25,48,61],[9,25,48,62],
 [9,25,48,66],[9,25,48,67],[9,25,48,68],[9,25,48,69],
 [9,25,49,53],[9,25,49,54],[9,25,49,55],[9,25,49,58],
 [9,25,49,59],[9,25,49,60],[9,25,49,61],[9,25,49,62],
 [9,25,49,65],[9,25,49,66],[9,25,49,67],[9,25,49,68],
 [9,25,49,69],[9,25,51,53],[9,25,51,55],[9,25,51,58],
 [9,25,51,59],[9,25,51,60],[9,25,51,61],[9,25,51,62],
 [9,25,51,65],[9,25,51,66],[9,25,51,67],[9,25,51,68],
 [9,25,51,69],[9,25,53,54],[9,25,53,60],[9,25,53,62],
 [9,25,53,68],[9,25,54,60],[9,25,54,61],[9,25,54,62],
 [9,25,54,67],[9,25,54,68],[9,25,54,69],[9,25,55,58],
 [9,25,55,59],[9,25,55,60],[9,25,55,61],[9,25,55,62],
 [9,25,55,66],[9,25,55,67],[9,25,55,68],[9,25,55,69],
 [9,25,58,59],[9,25,58,60],[9,25,58,61],[9,25,58,62],
 [9,25,58,66],[9,25,58,67],[9,25,58,68],[9,25,58,69],
 [9,25,59,60],[9,25,59,61],[9,25,59,62],[9,25,59,65],
 [9,25,59,66],[9,25,59,67],[9,25,59,68],[9,25,59,69],
 [9,25,60,61],[9,25,60,62],[9,25,60,65],[9,25,60,66],
 [9,25,60,67],[9,25,60,68],[9,25,60,69],[9,25,61,62],
 [9,25,61,65],[9,25,61,66],[9,25,61,67],[9,25,61,68],
 [9,25,61,69],[9,25,62,65],[9,25,62,66],[9,25,62,67],
 [9,25,62,68],[9,25,62,69],[9,25,65,68],[9,25,66,67],
 [9,25,66,68],[9,25,66,69],[9,25,67,68],[9,25,67,69],
 [9,25,68,69],[9,26,27,34],[9,26,27,36],[9,26,27,39],
 [9,26,27,41],[9,26,27,43],[9,26,27,44],[9,26,27,45],
 [9,26,27,46],[9,26,27,47],[9,26,27,48],[9,26,27,49],
 [9,26,27,51],[9,26,27,54],[9,26,27,55],[9,26,27,58],
 [9,26,27,59],[9,26,27,60],[9,26,27,61],[9,26,27,62],
 [9,26,27,66],[9,26,27,67],[9,26,27,68],[9,26,27,69],
 [9,26,28,30],[9,26,28,41],[9,26,28,44],[9,26,28,47],
 [9,26,28,49],[9,26,28,58],[9,26,28,59],[9,26,28,61],
 [9,26,28,68],[9,26,29,31],[9,26,29,32],[9,26,29,41],
 [9,26,29,44],[9,26,29,47],[9,26,29,49],[9,26,29,59],
 [9,26,29,61],[9,26,29,68],[9,26,30,41],[9,26,30,44],
 [9,26,30,47],[9,26,30,48],[9,26,30,49],[9,26,30,59],
 [9,26,30,61],[9,26,30,68],[9,26,31,32],[9,26,31,36],
 [9,26,31,37],[9,26,31,41],[9,26,31,42],[9,26,31,44],
 [9,26,31,47],[9,26,31,48],[9,26,31,49],[9,26,31,59],
 [9,26,31,61],[9,26,31,65],[9,26,31,67],[9,26,31,68],
 [9,26,31,69],[9,26,32,40],[9,26,32,41],[9,26,32,44],
 [9,26,32,46],[9,26,32,47],[9,26,32,49],[9,26,32,51],
 [9,26,32,59],[9,26,32,60],[9,26,32,61],[9,26,32,62],
 [9,26,32,64],[9,26,32,68],[9,26,34,39],[9,26,34,41],
 [9,26,34,43],[9,26,34,44],[9,26,34,45],[9,26,34,46],
 [9,26,34,47],[9,26,34,48],[9,26,34,49],[9,26,34,55],
 [9,26,34,58],[9,26,34,59],[9,26,34,60],[9,26,34,61],
 [9,26,34,62],[9,26,34,66],[9,26,34,67],[9,26,34,68],
 [9,26,34,69],[9,26,36,37],[9,26,36,40],[9,26,36,43],
 [9,26,36,45],[9,26,36,46],[9,26,36,48],[9,26,36,54],
 [9,26,36,60],[9,26,36,61],[9,26,36,62],[9,26,36,63],
 [9,26,36,64],[9,26,36,68],[9,26,37,38],[9,26,37,40],
 [9,26,37,43],[9,26,37,45],[9,26,37,46],[9,26,37,48],
 [9,26,37,54],[9,26,37,60],[9,26,37,61],[9,26,37,62],
 [9,26,37,64],[9,26,37,68],[9,26,38,40],[9,26,38,41],
 [9,26,38,42],[9,26,38,44],[9,26,38,47],[9,26,38,49],
 [9,26,38,59],[9,26,38,61],[9,26,38,63],[9,26,38,64],
 [9,26,38,65],[9,26,38,68],[9,26,39,41],[9,26,39,43],
 [9,26,39,44],[9,26,39,45],[9,26,39,46],[9,26,39,47],
 [9,26,39,48],[9,26,39,49],[9,26,39,55],[9,26,39,58],
 [9,26,39,59],[9,26,39,60],[9,26,39,61],[9,26,39,62],
 [9,26,39,66],[9,26,39,67],[9,26,39,68],[9,26,39,69],
 [9,26,40,41],[9,26,40,42],[9,26,40,44],[9,26,40,47],
 [9,26,40,48],[9,26,40,49],[9,26,40,58],[9,26,40,59],
 [9,26,40,61],[9,26,40,63],[9,26,40,64],[9,26,40,65],
 [9,26,40,67],[9,26,40,68],[9,26,40,69],[9,26,41,42],
 [9,26,41,43],[9,26,41,44],[9,26,41,45],[9,26,41,46],
 [9,26,41,47],[9,26,41,48],[9,26,41,49],[9,26,41,54],
 [9,26,41,55],[9,26,41,56],[9,26,41,57],[9,26,41,58],
 [9,26,41,59],[9,26,41,60],[9,26,41,61],[9,26,41,62],
 [9,26,41,63],[9,26,41,64],[9,26,41,65],[9,26,41,66],
 [9,26,41,67],[9,26,41,68],[9,26,41,69],[9,26,42,44],
 [9,26,42,46],[9,26,42,47],[9,26,42,49],[9,26,42,51],
 [9,26,42,59],[9,26,42,60],[9,26,42,61],[9,26,42,62],
 [9,26,42,63],[9,26,42,64],[9,26,42,65],[9,26,42,68],
 [9,26,43,44],[9,26,43,45],[9,26,43,46],[9,26,43,47],
 [9,26,43,48],[9,26,43,49],[9,26,43,55],[9,26,43,56],
 [9,26,43,58],[9,26,43,59],[9,26,43,60],[9,26,43,61],
 [9,26,43,62],[9,26,43,66],[9,26,43,67],[9,26,43,68],
 [9,26,43,69],[9,26,44,45],[9,26,44,46],[9,26,44,47],
 [9,26,44,48],[9,26,44,49],[9,26,44,51],[9,26,44,54],
 [9,26,44,55],[9,26,44,56],[9,26,44,57],[9,26,44,58],
 [9,26,44,59],[9,26,44,60],[9,26,44,61],[9,26,44,62],
 [9,26,44,63],[9,26,44,64],[9,26,44,65],[9,26,44,66],
 [9,26,44,67],[9,26,44,68],[9,26,44,69],[9,26,45,46],
 [9,26,45,47],[9,26,45,48],[9,26,45,49],[9,26,45,51],
 [9,26,45,55],[9,26,45,58],[9,26,45,59],[9,26,45,60],
 [9,26,45,61],[9,26,45,62],[9,26,45,66],[9,26,45,67],
 [9,26,45,68],[9,26,45,69],[9,26,46,47],[9,26,46,48],
 [9,26,46,49],[9,26,46,55],[9,26,46,56],[9,26,46,57],
 [9,26,46,58],[9,26,46,59],[9,26,46,60],[9,26,46,61],
 [9,26,46,62],[9,26,46,65],[9,26,46,66],[9,26,46,67],
 [9,26,46,68],[9,26,46,69],[9,26,47,48],[9,26,47,49],
 [9,26,47,54],[9,26,47,55],[9,26,47,56],[9,26,47,57],
 [9,26,47,58],[9,26,47,59],[9,26,47,60],[9,26,47,61],
 [9,26,47,62],[9,26,47,63],[9,26,47,64],[9,26,47,65],
 [9,26,47,66],[9,26,47,67],[9,26,47,68],[9,26,47,69],
 [9,26,48,49],[9,26,48,51],[9,26,48,55],[9,26,48,56],
 [9,26,48,57],[9,26,48,58],[9,26,48,59],[9,26,48,60],
 [9,26,48,61],[9,26,48,62],[9,26,48,64],[9,26,48,66],
 [9,26,48,67],[9,26,48,68],[9,26,48,69],[9,26,49,54],
 [9,26,49,55],[9,26,49,56],[9,26,49,57],[9,26,49,58],
 [9,26,49,59],[9,26,49,60],[9,26,49,61],[9,26,49,62],
 [9,26,49,63],[9,26,49,64],[9,26,49,65],[9,26,49,66],
 [9,26,49,67],[9,26,49,68],[9,26,49,69],[9,26,51,56],
 [9,26,51,57],[9,26,51,58],[9,26,51,59],[9,26,51,60],
 [9,26,51,61],[9,26,51,62],[9,26,51,63],[9,26,51,64],
 [9,26,51,65],[9,26,51,66],[9,26,51,67],[9,26,51,68],
 [9,26,51,69],[9,26,54,56],[9,26,54,57],[9,26,54,59],
 [9,26,54,60],[9,26,54,61],[9,26,54,62],[9,26,54,67],
 [9,26,54,68],[9,26,54,69],[9,26,55,58],[9,26,55,59],
 [9,26,55,60],[9,26,55,61],[9,26,55,62],[9,26,55,66],
 [9,26,55,67],[9,26,55,68],[9,26,55,69],[9,26,56,57],
 [9,26,56,59],[9,26,56,61],[9,26,56,68],[9,26,57,59],
 [9,26,57,61],[9,26,57,68],[9,26,58,59],[9,26,58,60],
 [9,26,58,61],[9,26,58,62],[9,26,58,66],[9,26,58,67],
 [9,26,58,68],[9,26,58,69],[9,26,59,60],[9,26,59,61],
 [9,26,59,62],[9,26,59,63],[9,26,59,64],[9,26,59,65],
 [9,26,59,66],[9,26,59,67],[9,26,59,68],[9,26,59,69],
 [9,26,60,61],[9,26,60,62],[9,26,60,65],[9,26,60,66],
 [9,26,60,67],[9,26,60,68],[9,26,60,69],[9,26,61,62],
 [9,26,61,63],[9,26,61,64],[9,26,61,65],[9,26,61,66],
 [9,26,61,67],[9,26,61,68],[9,26,61,69],[9,26,62,65],
 [9,26,62,66],[9,26,62,67],[9,26,62,68],[9,26,62,69],
 [9,26,63,64],[9,26,63,65],[9,26,63,68],[9,26,64,65],
 [9,26,64,66],[9,26,64,67],[9,26,64,68],[9,26,64,69],
 [9,26,65,68],[9,26,66,67],[9,26,66,68],[9,26,66,69],
 [9,26,67,68],[9,26,67,69],[9,26,68,69],[9,27,32,35],
 [9,27,32,41],[9,27,32,44],[9,27,32,46],[9,27,32,47],
 [9,27,32,49],[9,27,32,51],[9,27,32,60],[9,27,32,61],
 [9,27,32,62],[9,27,32,68],[9,27,33,35],[9,27,33,36],
 [9,27,33,37],[9,27,33,42],[9,27,33,45],[9,27,33,47],
 [9,27,33,48],[9,27,33,59],[9,27,33,60],[9,27,33,62],
 [9,27,33,67],[9,27,33,68],[9,27,34,39],[9,27,34,41],
 [9,27,34,43],[9,27,34,44],[9,27,34,45],[9,27,34,46],
 [9,27,34,47],[9,27,34,48],[9,27,34,49],[9,27,34,55],
 [9,27,34,58],[9,27,34,59],[9,27,34,60],[9,27,34,61],
 [9,27,34,62],[9,27,34,66],[9,27,34,67],[9,27,34,68],
 [9,27,34,69],[9,27,35,36],[9,27,35,37],[9,27,35,41],
 [9,27,35,42],[9,27,35,45],[9,27,35,47],[9,27,35,48],
 [9,27,35,49],[9,27,35,55],[9,27,35,58],[9,27,35,59],
 [9,27,35,60],[9,27,35,62],[9,27,35,65],[9,27,35,66],
 [9,27,35,67],[9,27,35,68],[9,27,35,69],[9,27,36,37],
 [9,27,36,43],[9,27,36,45],[9,27,36,46],[9,27,36,48],
 [9,27,36,54],[9,27,36,60],[9,27,36,61],[9,27,36,62],
 [9,27,36,68],[9,27,37,45],[9,27,37,46],[9,27,37,48],
 [9,27,37,54],[9,27,37,60],[9,27,37,61],[9,27,37,62],
 [9,27,37,68],[9,27,39,41],[9,27,39,43],[9,27,39,44],
 [9,27,39,45],[9,27,39,46],[9,27,39,47],[9,27,39,48],
 [9,27,39,49],[9,27,39,55],[9,27,39,58],[9,27,39,59],
 [9,27,39,60],[9,27,39,61],[9,27,39,62],[9,27,39,66],
 [9,27,39,67],[9,27,39,68],[9,27,39,69],[9,27,41,42],
 [9,27,41,43],[9,27,41,44],[9,27,41,45],[9,27,41,46],
 [9,27,41,47],[9,27,41,48],[9,27,41,49],[9,27,41,53],
 [9,27,41,54],[9,27,41,55],[9,27,41,58],[9,27,41,59],
 [9,27,41,60],[9,27,41,61],[9,27,41,62],[9,27,41,65],
 [9,27,41,66],[9,27,41,67],[9,27,41,68],[9,27,41,69],
 [9,27,42,44],[9,27,42,46],[9,27,42,47],[9,27,42,49],
 [9,27,42,51],[9,27,42,59],[9,27,42,60],[9,27,42,61],
 [9,27,42,62],[9,27,42,65],[9,27,42,68],[9,27,43,44],
 [9,27,43,45],[9,27,43,46],[9,27,43,47],[9,27,43,48],
 [9,27,43,49],[9,27,43,53],[9,27,43,55],[9,27,43,58],
 [9,27,43,59],[9,27,43,60],[9,27,43,61],[9,27,43,62],
 [9,27,43,66],[9,27,43,67],[9,27,43,68],[9,27,43,69],
 [9,27,44,45],[9,27,44,46],[9,27,44,47],[9,27,44,48],
 [9,27,44,49],[9,27,44,54],[9,27,44,55],[9,27,44,58],
 [9,27,44,59],[9,27,44,60],[9,27,44,61],[9,27,44,62],
 [9,27,44,66],[9,27,44,67],[9,27,44,68],[9,27,44,69],
 [9,27,45,46],[9,27,45,47],[9,27,45,48],[9,27,45,49],
 [9,27,45,51],[9,27,45,53],[9,27,45,54],[9,27,45,55],
 [9,27,45,58],[9,27,45,59],[9,27,45,60],[9,27,45,61],
 [9,27,45,62],[9,27,45,65],[9,27,45,66],[9,27,45,67],
 [9,27,45,68],[9,27,45,69],[9,27,46,47],[9,27,46,48],
 [9,27,46,49],[9,27,46,53],[9,27,46,55],[9,27,46,58],
 [9,27,46,59],[9,27,46,60],[9,27,46,61],[9,27,46,62],
 [9,27,46,65],[9,27,46,66],[9,27,46,67],[9,27,46,68],
 [9,27,46,69],[9,27,47,48],[9,27,47,49],[9,27,47,53],
 [9,27,47,54],[9,27,47,55],[9,27,47,58],[9,27,47,59],
 [9,27,47,60],[9,27,47,61],[9,27,47,62],[9,27,47,65],
 [9,27,47,66],[9,27,47,67],[9,27,47,68],[9,27,47,69],
 [9,27,48,49],[9,27,48,51],[9,27,48,53],[9,27,48,55],
 [9,27,48,58],[9,27,48,59],[9,27,48,60],[9,27,48,61],
 [9,27,48,62],[9,27,48,66],[9,27,48,67],[9,27,48,68],
 [9,27,48,69],[9,27,49,53],[9,27,49,55],[9,27,49,58],
 [9,27,49,59],[9,27,49,60],[9,27,49,61],[9,27,49,62],
 [9,27,49,65],[9,27,49,66],[9,27,49,67],[9,27,49,68],
 [9,27,49,69],[9,27,51,53],[9,27,51,59],[9,27,51,60],
 [9,27,51,61],[9,27,51,62],[9,27,51,65],[9,27,51,66],
 [9,27,51,67],[9,27,51,68],[9,27,51,69],[9,27,53,54],
 [9,27,53,60],[9,27,53,62],[9,27,53,68],[9,27,54,60],
 [9,27,54,61],[9,27,54,62],[9,27,54,67],[9,27,54,68],
 [9,27,54,69],[9,27,55,58],[9,27,55,59],[9,27,55,60],
 [9,27,55,61],[9,27,55,62],[9,27,55,66],[9,27,55,67],
 [9,27,55,68],[9,27,55,69],[9,27,58,59],[9,27,58,60],
 [9,27,58,61],[9,27,58,62],[9,27,58,66],[9,27,58,67],
 [9,27,58,68],[9,27,58,69],[9,27,59,60],[9,27,59,61],
 [9,27,59,62],[9,27,59,65],[9,27,59,66],[9,27,59,67],
 [9,27,59,68],[9,27,59,69],[9,27,60,61],[9,27,60,62],
 [9,27,60,65],[9,27,60,66],[9,27,60,67],[9,27,60,68],
 [9,27,60,69],[9,27,61,62],[9,27,61,65],[9,27,61,66],
 [9,27,61,67],[9,27,61,68],[9,27,61,69],[9,27,62,65],
 [9,27,62,66],[9,27,62,67],[9,27,62,68],[9,27,62,69],
 [9,27,65,68],[9,27,66,67],[9,27,66,68],[9,27,66,69],
 [9,27,67,68],[9,27,67,69],[9,27,68,69],[9,28,30,41],
 [9,28,30,44],[9,28,30,47],[9,28,30,48],[9,28,30,49],
 [9,28,30,59],[9,28,30,61],[9,28,30,68],[9,28,41,44],
 [9,28,41,47],[9,28,41,49],[9,28,41,59],[9,28,41,61],
 [9,28,41,68],[9,28,44,47],[9,28,44,49],[9,28,44,58],
 [9,28,44,59],[9,28,44,61],[9,28,44,68],[9,28,47,49],
 [9,28,47,58],[9,28,47,59],[9,28,47,61],[9,28,47,68],
 [9,28,48,49],[9,28,48,58],[9,28,48,59],[9,28,48,61],
 [9,28,48,68],[9,28,49,58],[9,28,49,59],[9,28,49,61],
 [9,28,49,68],[9,28,58,68],[9,28,59,61],[9,28,59,68],
 [9,28,61,68],[9,29,31,32],[9,29,31,36],[9,29,31,37],
 [9,29,31,41],[9,29,31,42],[9,29,31,44],[9,29,31,47],
 [9,29,31,48],[9,29,31,49],[9,29,31,53],[9,29,31,59],
 [9,29,31,61],[9,29,31,65],[9,29,31,67],[9,29,31,68],
 [9,29,31,69],[9,29,32,41],[9,29,32,44],[9,29,32,47],
 [9,29,32,49],[9,29,32,59],[9,29,32,61],[9,29,32,68],
 [9,29,36,37],[9,29,36,48],[9,29,36,61],[9,29,36,68],
 [9,29,37,48],[9,29,37,61],[9,29,37,68],[9,29,41,42],
 [9,29,41,44],[9,29,41,47],[9,29,41,48],[9,29,41,49],
 [9,29,41,53],[9,29,41,59],[9,29,41,61],[9,29,41,65],
 [9,29,41,67],[9,29,41,68],[9,29,41,69],[9,29,42,44],
 [9,29,42,47],[9,29,42,49],[9,29,42,59],[9,29,42,61],
 [9,29,42,65],[9,29,42,68],[9,29,44,47],[9,29,44,48],
 [9,29,44,49],[9,29,44,53],[9,29,44,59],[9,29,44,61],
 [9,29,44,65],[9,29,44,67],[9,29,44,68],[9,29,47,48],
 [9,29,47,49],[9,29,47,53],[9,29,47,59],[9,29,47,61],
 [9,29,47,65],[9,29,47,67],[9,29,47,68],[9,29,47,69],
 [9,29,48,49],[9,29,48,53],[9,29,48,61],[9,29,48,67],
 [9,29,48,68],[9,29,48,69],[9,29,49,53],[9,29,49,59],
 [9,29,49,61],[9,29,49,65],[9,29,49,67],[9,29,49,68],
 [9,29,49,69],[9,29,53,68],[9,29,59,61],[9,29,59,65],
 [9,29,59,67],[9,29,59,68],[9,29,59,69],[9,29,61,65],
 [9,29,61,67],[9,29,61,68],[9,29,61,69],[9,29,65,68],
 [9,29,67,68],[9,29,67,69],[9,29,68,69],[9,30,41,44],
 [9,30,41,47],[9,30,41,49],[9,30,41,53],[9,30,41,59],
 [9,30,41,61],[9,30,41,68],[9,30,44,47],[9,30,44,48],
 [9,30,44,49],[9,30,44,53],[9,30,44,59],[9,30,44,61],
 [9,30,44,68],[9,30,47,48],[9,30,47,49],[9,30,47,53],
 [9,30,47,59],[9,30,47,61],[9,30,47,68],[9,30,48,68],
 [9,30,49,53],[9,30,49,59],[9,30,49,61],[9,30,49,68],
 [9,30,53,68],[9,30,59,61],[9,30,59,68],[9,30,61,68],
 [9,31,32,41],[9,31,32,44],[9,31,32,47],[9,31,32,49],
 [9,31,32,59],[9,31,32,61],[9,31,32,68],[9,31,36,37],
 [9,31,36,48],[9,31,36,68],[9,31,37,48],[9,31,37,68],
 [9,31,41,42],[9,31,41,44],[9,31,41,47],[9,31,41,48],
 [9,31,41,49],[9,31,41,53],[9,31,41,59],[9,31,41,61],
 [9,31,41,65],[9,31,41,67],[9,31,41,68],[9,31,41,69],
 [9,31,42,44],[9,31,42,47],[9,31,42,49],[9,31,42,65],
 [9,31,42,68],[9,31,44,47],[9,31,44,48],[9,31,44,49],
 [9,31,44,59],[9,31,44,61],[9,31,44,67],[9,31,44,68],
 [9,31,47,48],[9,31,47,49],[9,31,47,53],[9,31,47,59],
 [9,31,47,61],[9,31,47,65],[9,31,47,67],[9,31,47,68],
 [9,31,47,69],[9,31,48,49],[9,31,48,67],[9,31,48,68],
 [9,31,48,69],[9,31,49,53],[9,31,49,59],[9,31,49,61],
 [9,31,49,65],[9,31,49,67],[9,31,49,68],[9,31,49,69],
 [9,31,53,68],[9,31,59,61],[9,31,59,65],[9,31,59,67],
 [9,31,59,68],[9,31,59,69],[9,31,61,68],[9,31,65,68],
 [9,31,67,68],[9,31,67,69],[9,31,68,69],[9,32,33,35],
 [9,32,33,41],[9,32,33,47],[9,32,33,49],[9,32,33,60],
 [9,32,33,62],[9,32,33,68],[9,32,35,41],[9,32,35,47],
 [9,32,35,49],[9,32,35,68],[9,32,38,40],[9,32,38,41],
 [9,32,38,44],[9,32,38,47],[9,32,38,49],[9,32,38,61],
 [9,32,38,63],[9,32,38,64],[9,32,38,68],[9,32,40,41],
 [9,32,40,44],[9,32,40,47],[9,32,40,49],[9,32,40,63],
 [9,32,40,64],[9,32,40,68],[9,32,41,44],[9,32,41,46],
 [9,32,41,47],[9,32,41,49],[9,32,41,59],[9,32,41,60],
 [9,32,41,61],[9,32,41,62],[9,32,41,63],[9,32,41,64],
 [9,32,41,68],[9,32,44,46],[9,32,44,47],[9,32,44,49],
 [9,32,44,59],[9,32,44,60],[9,32,44,61],[9,32,44,68],
 [9,32,46,47],[9,32,46,49],[9,32,46,60],[9,32,46,62],
 [9,32,46,68],[9,32,47,49],[9,32,47,59],[9,32,47,60],
 [9,32,47,61],[9,32,47,62],[9,32,47,63],[9,32,47,64],
 [9,32,47,68],[9,32,49,59],[9,32,49,60],[9,32,49,61],
 [9,32,49,62],[9,32,49,63],[9,32,49,64],[9,32,49,68],
 [9,32,51,60],[9,32,51,62],[9,32,51,63],[9,32,51,64],
 [9,32,51,68],[9,32,59,60],[9,32,59,61],[9,32,59,62],
 [9,32,59,64],[9,32,59,68],[9,32,60,62],[9,32,60,68],
 [9,32,61,63],[9,32,61,68],[9,32,62,68],[9,32,63,64],
 [9,32,63,68],[9,32,64,68],[9,33,35,36],[9,33,35,37],
 [9,33,35,41],[9,33,35,42],[9,33,35,45],[9,33,35,47],
 [9,33,35,48],[9,33,35,49],[9,33,35,55],[9,33,35,56],
 [9,33,35,57],[9,33,35,58],[9,33,35,59],[9,33,35,60],
 [9,33,35,62],[9,33,35,65],[9,33,35,66],[9,33,35,67],
 [9,33,35,68],[9,33,35,69],[9,33,36,37],[9,33,36,45],
 [9,33,36,48],[9,33,36,60],[9,33,36,62],[9,33,36,68],
 [9,33,37,45],[9,33,37,48],[9,33,37,60],[9,33,37,62],
 [9,33,37,68],[9,33,41,42],[9,33,41,45],[9,33,41,47],
 [9,33,41,48],[9,33,41,49],[9,33,41,55],[9,33,41,56],
 [9,33,41,57],[9,33,41,58],[9,33,41,59],[9,33,41,60],
 [9,33,41,62],[9,33,41,65],[9,33,41,66],[9,33,41,67],
 [9,33,41,68],[9,33,41,69],[9,33,42,47],[9,33,42,49],
 [9,33,42,60],[9,33,42,62],[9,33,42,65],[9,33,42,68],
 [9,33,45,47],[9,33,45,48],[9,33,45,49],[9,33,45,55],
 [9,33,45,58],[9,33,45,59],[9,33,45,60],[9,33,45,62],
 [9,33,45,66],[9,33,45,67],[9,33,45,68],[9,33,45,69],
 [9,33,47,48],[9,33,47,49],[9,33,47,55],[9,33,47,56],
 [9,33,47,57],[9,33,47,58],[9,33,47,59],[9,33,47,60],
 [9,33,47,62],[9,33,47,65],[9,33,47,66],[9,33,47,67],
 [9,33,47,68],[9,33,47,69],[9,33,48,49],[9,33,48,56],
 [9,33,48,57],[9,33,48,58],[9,33,48,59],[9,33,48,60],
 [9,33,48,62],[9,33,48,66],[9,33,48,67],[9,33,48,68],
 [9,33,48,69],[9,33,49,56],[9,33,49,57],[9,33,49,58],
 [9,33,49,59],[9,33,49,60],[9,33,49,62],[9,33,49,65],
 [9,33,49,66],[9,33,49,67],[9,33,49,68],[9,33,49,69],
 [9,33,55,58],[9,33,55,60],[9,33,55,62],[9,33,55,67],
 [9,33,55,68],[9,33,55,69],[9,33,56,57],[9,33,56,59],
 [9,33,56,68],[9,33,57,59],[9,33,57,68],[9,33,58,60],
 [9,33,58,62],[9,33,58,67],[9,33,58,68],[9,33,58,69],
 [9,33,59,60],[9,33,59,62],[9,33,59,65],[9,33,59,67],
 [9,33,59,68],[9,33,59,69],[9,33,60,62],[9,33,60,65],
 [9,33,60,66],[9,33,60,67],[9,33,60,68],[9,33,60,69],
 [9,33,62,65],[9,33,62,66],[9,33,62,67],[9,33,62,68],
 [9,33,62,69],[9,33,65,68],[9,33,66,67],[9,33,66,68],
 [9,33,66,69],[9,33,67,68],[9,33,67,69],[9,33,68,69],
 [9,34,39,41],[9,34,39,43],[9,34,39,44],[9,34,39,45],
 [9,34,39,46],[9,34,39,47],[9,34,39,48],[9,34,39,49],
 [9,34,39,55],[9,34,39,58],[9,34,39,59],[9,34,39,60],
 [9,34,39,61],[9,34,39,62],[9,34,39,66],[9,34,39,67],
 [9,34,39,68],[9,34,39,69],[9,34,41,43],[9,34,41,44],
 [9,34,41,45],[9,34,41,46],[9,34,41,47],[9,34,41,48],
 [9,34,41,49],[9,34,41,55],[9,34,41,58],[9,34,41,59],
 [9,34,41,60],[9,34,41,61],[9,34,41,62],[9,34,41,66],
 [9,34,41,67],[9,34,41,68],[9,34,41,69],[9,34,43,44],
 [9,34,43,45],[9,34,43,46],[9,34,43,47],[9,34,43,48],
 [9,34,43,49],[9,34,43,55],[9,34,43,58],[9,34,43,59],
 [9,34,43,60],[9,34,43,61],[9,34,43,62],[9,34,43,66],
 [9,34,43,67],[9,34,43,68],[9,34,43,69],[9,34,44,45],
 [9,34,44,46],[9,34,44,47],[9,34,44,48],[9,34,44,49],
 [9,34,44,55],[9,34,44,58],[9,34,44,59],[9,34,44,60],
 [9,34,44,61],[9,34,44,62],[9,34,44,66],[9,34,44,67],
 [9,34,44,68],[9,34,44,69],[9,34,45,46],[9,34,45,47],
 [9,34,45,48],[9,34,45,49],[9,34,45,55],[9,34,45,58],
 [9,34,45,59],[9,34,45,60],[9,34,45,61],[9,34,45,62],
 [9,34,45,66],[9,34,45,67],[9,34,45,68],[9,34,45,69],
 [9,34,46,47],[9,34,46,48],[9,34,46,49],[9,34,46,55],
 [9,34,46,58],[9,34,46,59],[9,34,46,60],[9,34,46,61],
 [9,34,46,62],[9,34,46,66],[9,34,46,67],[9,34,46,68],
 [9,34,46,69],[9,34,47,48],[9,34,47,49],[9,34,47,55],
 [9,34,47,58],[9,34,47,59],[9,34,47,60],[9,34,47,61],
 [9,34,47,62],[9,34,47,66],[9,34,47,67],[9,34,47,68],
 [9,34,47,69],[9,34,48,49],[9,34,48,55],[9,34,48,58],
 [9,34,48,59],[9,34,48,60],[9,34,48,61],[9,34,48,62],
 [9,34,48,66],[9,34,48,67],[9,34,48,68],[9,34,48,69],
 [9,34,49,55],[9,34,49,58],[9,34,49,59],[9,34,49,60],
 [9,34,49,61],[9,34,49,62],[9,34,49,66],[9,34,49,67],
 [9,34,49,68],[9,34,49,69],[9,34,55,58],[9,34,55,59],
 [9,34,55,60],[9,34,55,61],[9,34,55,62],[9,34,55,66],
 [9,34,55,67],[9,34,55,68],[9,34,55,69],[9,34,58,59],
 [9,34,58,60],[9,34,58,61],[9,34,58,62],[9,34,58,66],
 [9,34,58,67],[9,34,58,68],[9,34,58,69],[9,34,59,60],
 [9,34,59,61],[9,34,59,62],[9,34,59,66],[9,34,59,67],
 [9,34,59,68],[9,34,59,69],[9,34,60,61],[9,34,60,62],
 [9,34,60,66],[9,34,60,67],[9,34,60,68],[9,34,60,69],
 [9,34,61,62],[9,34,61,66],[9,34,61,67],[9,34,61,68],
 [9,34,61,69],[9,34,62,66],[9,34,62,67],[9,34,62,68],
 [9,34,62,69],[9,34,66,67],[9,34,66,68],[9,34,66,69],
 [9,34,67,68],[9,34,67,69],[9,34,68,69],[9,35,36,37],
 [9,35,36,45],[9,35,36,48],[9,35,36,60],[9,35,36,62],
 [9,35,36,68],[9,35,37,45],[9,35,37,48],[9,35,37,60],
 [9,35,37,62],[9,35,37,68],[9,35,41,42],[9,35,41,45],
 [9,35,41,47],[9,35,41,48],[9,35,41,49],[9,35,41,57],
 [9,35,41,59],[9,35,41,65],[9,35,41,66],[9,35,41,67],
 [9,35,41,68],[9,35,41,69],[9,35,42,47],[9,35,42,49],
 [9,35,42,62],[9,35,42,65],[9,35,42,68],[9,35,45,47],
 [9,35,45,48],[9,35,45,58],[9,35,45,60],[9,35,45,62],
 [9,35,45,67],[9,35,45,68],[9,35,47,48],[9,35,47,49],
 [9,35,47,57],[9,35,47,59],[9,35,47,62],[9,35,47,65],
 [9,35,47,66],[9,35,47,67],[9,35,47,68],[9,35,47,69],
 [9,35,48,49],[9,35,48,55],[9,35,48,56],[9,35,48,57],
 [9,35,48,58],[9,35,48,60],[9,35,48,62],[9,35,48,66],
 [9,35,48,67],[9,35,48,68],[9,35,48,69],[9,35,49,55],
 [9,35,49,56],[9,35,49,58],[9,35,49,59],[9,35,49,60],
 [9,35,49,65],[9,35,49,66],[9,35,49,67],[9,35,49,68],
 [9,35,49,69],[9,35,55,58],[9,35,55,59],[9,35,55,60],
 [9,35,55,66],[9,35,55,67],[9,35,55,68],[9,35,55,69],
 [9,35,56,57],[9,35,56,59],[9,35,56,68],[9,35,57,59],
 [9,35,57,68],[9,35,58,59],[9,35,58,62],[9,35,58,66],
 [9,35,58,67],[9,35,58,68],[9,35,58,69],[9,35,59,60],
 [9,35,59,62],[9,35,59,65],[9,35,59,66],[9,35,59,67],
 [9,35,59,68],[9,35,59,69],[9,35,60,62],[9,35,60,65],
 [9,35,60,66],[9,35,60,68],[9,35,60,69],[9,35,62,67],
 [9,35,62,68],[9,35,65,68],[9,35,66,67],[9,35,66,68],
 [9,35,66,69],[9,35,67,68],[9,35,67,69],[9,35,68,69],
 [9,36,37,38],[9,36,37,40],[9,36,37,43],[9,36,37,45],
 [9,36,37,46],[9,36,37,48],[9,36,37,54],[9,36,37,60],
 [9,36,37,61],[9,36,37,62],[9,36,37,63],[9,36,37,64],
 [9,36,37,68],[9,36,38,40],[9,36,38,48],[9,36,38,61],
 [9,36,38,64],[9,36,38,68],[9,36,40,48],[9,36,40,63],
 [9,36,40,68],[9,36,43,45],[9,36,43,46],[9,36,43,48],
 [9,36,43,62],[9,36,43,68],[9,36,45,46],[9,36,45,48],
 [9,36,45,54],[9,36,45,60],[9,36,45,61],[9,36,45,62],
 [9,36,45,68],[9,36,46,48],[9,36,46,61],[9,36,46,62],
 [9,36,46,68],[9,36,48,60],[9,36,48,61],[9,36,48,62],
 [9,36,48,63],[9,36,48,64],[9,36,48,68],[9,36,54,61],
 [9,36,54,62],[9,36,54,68],[9,36,60,62],[9,36,60,68],
 [9,36,61,62],[9,36,61,63],[9,36,61,64],[9,36,61,68],
 [9,36,62,68],[9,36,63,64],[9,36,63,68],[9,36,64,68],
 [9,37,38,40],[9,37,38,48],[9,37,38,61],[9,37,38,64],
 [9,37,38,68],[9,37,40,48],[9,37,40,61],[9,37,40,63],
 [9,37,40,68],[9,37,43,45],[9,37,43,46],[9,37,43,48],
 [9,37,43,60],[9,37,43,61],[9,37,43,68],[9,37,45,46],
 [9,37,45,48],[9,37,45,54],[9,37,45,60],[9,37,45,62],
 [9,37,45,68],[9,37,46,48],[9,37,46,60],[9,37,46,61],
 [9,37,46,68],[9,37,48,60],[9,37,48,61],[9,37,48,62],
 [9,37,48,63],[9,37,48,64],[9,37,48,68],[9,37,54,60],
 [9,37,54,61],[9,37,54,68],[9,37,60,61],[9,37,60,62],
 [9,37,60,68],[9,37,61,63],[9,37,61,68],[9,37,62,68],
 [9,37,63,64],[9,37,63,68],[9,37,64,68],[9,38,40,41],
 [9,38,40,42],[9,38,40,44],[9,38,40,47],[9,38,40,48],
 [9,38,40,49],[9,38,40,53],[9,38,40,58],[9,38,40,59],
 [9,38,40,61],[9,38,40,63],[9,38,40,64],[9,38,40,65],
 [9,38,40,67],[9,38,40,68],[9,38,40,69],[9,38,41,42],
 [9,38,41,44],[9,38,41,47],[9,38,41,48],[9,38,41,49],
 [9,38,41,53],[9,38,41,58],[9,38,41,59],[9,38,41,61],
 [9,38,41,63],[9,38,41,64],[9,38,41,65],[9,38,41,67],
 [9,38,41,68],[9,38,41,69],[9,38,42,44],[9,38,42,47],
 [9,38,42,49],[9,38,42,59],[9,38,42,61],[9,38,42,63],
 [9,38,42,64],[9,38,42,65],[9,38,42,68],[9,38,44,47],
 [9,38,44,49],[9,38,44,58],[9,38,44,59],[9,38,44,61],
 [9,38,44,63],[9,38,44,64],[9,38,44,65],[9,38,44,67],
 [9,38,44,68],[9,38,44,69],[9,38,47,48],[9,38,47,49],
 [9,38,47,53],[9,38,47,58],[9,38,47,59],[9,38,47,61],
 [9,38,47,63],[9,38,47,64],[9,38,47,65],[9,38,47,67],
 [9,38,47,68],[9,38,47,69],[9,38,48,49],[9,38,48,53],
 [9,38,48,58],[9,38,48,61],[9,38,48,63],[9,38,48,64],
 [9,38,48,67],[9,38,48,68],[9,38,48,69],[9,38,49,53],
 [9,38,49,59],[9,38,49,61],[9,38,49,63],[9,38,49,64],
 [9,38,49,65],[9,38,49,67],[9,38,49,68],[9,38,49,69],
 [9,38,53,63],[9,38,53,64],[9,38,53,68],[9,38,58,61],
 [9,38,58,67],[9,38,58,68],[9,38,58,69],[9,38,59,61],
 [9,38,59,63],[9,38,59,64],[9,38,59,65],[9,38,59,67],
 [9,38,59,68],[9,38,59,69],[9,38,61,63],[9,38,61,64],
 [9,38,61,65],[9,38,61,67],[9,38,61,68],[9,38,61,69],
 [9,38,63,64],[9,38,63,65],[9,38,63,67],[9,38,63,68],
 [9,38,63,69],[9,38,64,65],[9,38,64,67],[9,38,64,68],
 [9,38,64,69],[9,38,65,68],[9,38,67,68],[9,38,67,69],
 [9,38,68,69],[9,39,41,43],[9,39,41,44],[9,39,41,45],
 [9,39,41,46],[9,39,41,47],[9,39,41,48],[9,39,41,49],
 [9,39,41,55],[9,39,41,58],[9,39,41,59],[9,39,41,60],
 [9,39,41,61],[9,39,41,62],[9,39,41,66],[9,39,41,67],
 [9,39,41,68],[9,39,41,69],[9,39,43,44],[9,39,43,45],
 [9,39,43,46],[9,39,43,47],[9,39,43,48],[9,39,43,49],
 [9,39,43,55],[9,39,43,58],[9,39,43,59],[9,39,43,60],
 [9,39,43,61],[9,39,43,62],[9,39,43,66],[9,39,43,67],
 [9,39,43,68],[9,39,43,69],[9,39,44,45],[9,39,44,46],
 [9,39,44,47],[9,39,44,48],[9,39,44,49],[9,39,44,55],
 [9,39,44,58],[9,39,44,59],[9,39,44,60],[9,39,44,61],
 [9,39,44,62],[9,39,44,66],[9,39,44,67],[9,39,44,68],
 [9,39,44,69],[9,39,45,46],[9,39,45,47],[9,39,45,48],
 [9,39,45,49],[9,39,45,55],[9,39,45,58],[9,39,45,59],
 [9,39,45,60],[9,39,45,61],[9,39,45,62],[9,39,45,66],
 [9,39,45,67],[9,39,45,68],[9,39,45,69],[9,39,46,47],
 [9,39,46,48],[9,39,46,49],[9,39,46,55],[9,39,46,58],
 [9,39,46,59],[9,39,46,60],[9,39,46,61],[9,39,46,62],
 [9,39,46,66],[9,39,46,67],[9,39,46,68],[9,39,46,69],
 [9,39,47,48],[9,39,47,49],[9,39,47,55],[9,39,47,58],
 [9,39,47,59],[9,39,47,60],[9,39,47,61],[9,39,47,62],
 [9,39,47,66],[9,39,47,67],[9,39,47,68],[9,39,47,69],
 [9,39,48,49],[9,39,48,55],[9,39,48,58],[9,39,48,59],
 [9,39,48,60],[9,39,48,61],[9,39,48,62],[9,39,48,66],
 [9,39,48,67],[9,39,48,68],[9,39,48,69],[9,39,49,55],
 [9,39,49,58],[9,39,49,59],[9,39,49,60],[9,39,49,61],
 [9,39,49,62],[9,39,49,66],[9,39,49,67],[9,39,49,68],
 [9,39,49,69],[9,39,55,58],[9,39,55,59],[9,39,55,60],
 [9,39,55,61],[9,39,55,62],[9,39,55,66],[9,39,55,67],
 [9,39,55,68],[9,39,55,69],[9,39,58,59],[9,39,58,60],
 [9,39,58,61],[9,39,58,62],[9,39,58,66],[9,39,58,67],
 [9,39,58,68],[9,39,58,69],[9,39,59,60],[9,39,59,61],
 [9,39,59,62],[9,39,59,66],[9,39,59,67],[9,39,59,68],
 [9,39,59,69],[9,39,60,61],[9,39,60,62],[9,39,60,66],
 [9,39,60,67],[9,39,60,68],[9,39,60,69],[9,39,61,62],
 [9,39,61,66],[9,39,61,67],[9,39,61,68],[9,39,61,69],
 [9,39,62,66],[9,39,62,67],[9,39,62,68],[9,39,62,69],
 [9,39,66,67],[9,39,66,68],[9,39,66,69],[9,39,67,68],
 [9,39,67,69],[9,39,68,69],[9,40,41,42],[9,40,41,44],
 [9,40,41,47],[9,40,41,48],[9,40,41,49],[9,40,41,53],
 [9,40,41,59],[9,40,41,61],[9,40,41,63],[9,40,41,64],
 [9,40,41,65],[9,40,41,67],[9,40,41,68],[9,40,41,69],
 [9,40,42,44],[9,40,42,47],[9,40,42,49],[9,40,42,59],
 [9,40,42,61],[9,40,42,63],[9,40,42,64],[9,40,42,65],
 [9,40,42,68],[9,40,44,47],[9,40,44,48],[9,40,44,49],
 [9,40,44,53],[9,40,44,59],[9,40,44,61],[9,40,44,63],
 [9,40,44,64],[9,40,44,65],[9,40,44,68],[9,40,44,69],
 [9,40,47,48],[9,40,47,49],[9,40,47,53],[9,40,47,59],
 [9,40,47,61],[9,40,47,63],[9,40,47,64],[9,40,47,65],
 [9,40,47,67],[9,40,47,68],[9,40,47,69],[9,40,48,49],
 [9,40,48,58],[9,40,48,63],[9,40,48,64],[9,40,48,67],
 [9,40,48,68],[9,40,48,69],[9,40,49,53],[9,40,49,58],
 [9,40,49,59],[9,40,49,61],[9,40,49,63],[9,40,49,64],
 [9,40,49,65],[9,40,49,67],[9,40,49,68],[9,40,49,69],
 [9,40,53,63],[9,40,53,64],[9,40,53,68],[9,40,58,59],
 [9,40,58,67],[9,40,58,68],[9,40,58,69],[9,40,59,61],
 [9,40,59,63],[9,40,59,64],[9,40,59,65],[9,40,59,67],
 [9,40,59,68],[9,40,59,69],[9,40,61,63],[9,40,61,64],
 [9,40,61,65],[9,40,61,68],[9,40,63,64],[9,40,63,65],
 [9,40,63,67],[9,40,63,68],[9,40,63,69],[9,40,64,65],
 [9,40,64,67],[9,40,64,68],[9,40,64,69],[9,40,65,68],
 [9,40,67,68],[9,40,67,69],[9,40,68,69],[9,41,42,44],
 [9,41,42,46],[9,41,42,47],[9,41,42,49],[9,41,42,59],
 [9,41,42,60],[9,41,42,61],[9,41,42,62],[9,41,42,63],
 [9,41,42,64],[9,41,42,65],[9,41,42,68],[9,41,43,44],
 [9,41,43,45],[9,41,43,46],[9,41,43,47],[9,41,43,48],
 [9,41,43,49],[9,41,43,53],[9,41,43,55],[9,41,43,58],
 [9,41,43,59],[9,41,43,60],[9,41,43,61],[9,41,43,62],
 [9,41,43,66],[9,41,43,67],[9,41,43,68],[9,41,43,69],
 [9,41,44,45],[9,41,44,46],[9,41,44,47],[9,41,44,48],
 [9,41,44,49],[9,41,44,53],[9,41,44,54],[9,41,44,55],
 [9,41,44,56],[9,41,44,57],[9,41,44,58],[9,41,44,59],
 [9,41,44,60],[9,41,44,61],[9,41,44,62],[9,41,44,63],
 [9,41,44,64],[9,41,44,65],[9,41,44,66],[9,41,44,67],
 [9,41,44,68],[9,41,44,69],[9,41,45,46],[9,41,45,47],
 [9,41,45,48],[9,41,45,49],[9,41,45,53],[9,41,45,55],
 [9,41,45,58],[9,41,45,59],[9,41,45,60],[9,41,45,61],
 [9,41,45,62],[9,41,45,66],[9,41,45,67],[9,41,45,68],
 [9,41,45,69],[9,41,46,47],[9,41,46,48],[9,41,46,49],
 [9,41,46,53],[9,41,46,55],[9,41,46,57],[9,41,46,58],
 [9,41,46,59],[9,41,46,60],[9,41,46,61],[9,41,46,62],
 [9,41,46,65],[9,41,46,66],[9,41,46,67],[9,41,46,68],
 [9,41,46,69],[9,41,47,48],[9,41,47,49],[9,41,47,53],
 [9,41,47,54],[9,41,47,55],[9,41,47,56],[9,41,47,57],
 [9,41,47,58],[9,41,47,59],[9,41,47,60],[9,41,47,61],
 [9,41,47,62],[9,41,47,63],[9,41,47,64],[9,41,47,65],
 [9,41,47,66],[9,41,47,67],[9,41,47,68],[9,41,47,69],
 [9,41,48,49],[9,41,48,55],[9,41,48,56],[9,41,48,58],
 [9,41,48,59],[9,41,48,60],[9,41,48,61],[9,41,48,62],
 [9,41,48,63],[9,41,48,64],[9,41,48,66],[9,41,48,67],
 [9,41,48,68],[9,41,48,69],[9,41,49,53],[9,41,49,54],
 [9,41,49,55],[9,41,49,56],[9,41,49,57],[9,41,49,58],
 [9,41,49,59],[9,41,49,60],[9,41,49,61],[9,41,49,62],
 [9,41,49,63],[9,41,49,64],[9,41,49,65],[9,41,49,66],
 [9,41,49,67],[9,41,49,68],[9,41,49,69],[9,41,53,54],
 [9,41,53,60],[9,41,53,62],[9,41,53,63],[9,41,53,64],
 [9,41,53,68],[9,41,54,56],[9,41,54,57],[9,41,54,59],
 [9,41,54,61],[9,41,54,67],[9,41,54,68],[9,41,54,69],
 [9,41,55,58],[9,41,55,59],[9,41,55,60],[9,41,55,61],
 [9,41,55,62],[9,41,55,66],[9,41,55,67],[9,41,55,68],
 [9,41,55,69],[9,41,56,57],[9,41,56,59],[9,41,56,61],
 [9,41,56,68],[9,41,57,59],[9,41,57,61],[9,41,57,68],
 [9,41,58,59],[9,41,58,60],[9,41,58,61],[9,41,58,62],
 [9,41,58,66],[9,41,58,67],[9,41,58,68],[9,41,58,69],
 [9,41,59,60],[9,41,59,61],[9,41,59,62],[9,41,59,63],
 [9,41,59,64],[9,41,59,65],[9,41,59,66],[9,41,59,67],
 [9,41,59,68],[9,41,59,69],[9,41,60,61],[9,41,60,62],
 [9,41,60,65],[9,41,60,66],[9,41,60,67],[9,41,60,68],
 [9,41,60,69],[9,41,61,62],[9,41,61,63],[9,41,61,64],
 [9,41,61,65],[9,41,61,66],[9,41,61,67],[9,41,61,68],
 [9,41,61,69],[9,41,62,65],[9,41,62,66],[9,41,62,67],
 [9,41,62,68],[9,41,62,69],[9,41,63,64],[9,41,63,65],
 [9,41,63,67],[9,41,63,68],[9,41,63,69],[9,41,64,65],
 [9,41,64,66],[9,41,64,67],[9,41,64,68],[9,41,64,69],
 [9,41,65,68],[9,41,66,67],[9,41,66,68],[9,41,66,69],
 [9,41,67,68],[9,41,67,69],[9,41,68,69],[9,42,44,46],
 [9,42,44,47],[9,42,44,49],[9,42,44,51],[9,42,44,59],
 [9,42,44,61],[9,42,44,62],[9,42,44,63],[9,42,44,64],
 [9,42,44,65],[9,42,44,68],[9,42,46,47],[9,42,46,49],
 [9,42,46,60],[9,42,46,62],[9,42,46,65],[9,42,46,68],
 [9,42,47,49],[9,42,47,59],[9,42,47,60],[9,42,47,61],
 [9,42,47,62],[9,42,47,63],[9,42,47,64],[9,42,47,65],
 [9,42,47,68],[9,42,49,59],[9,42,49,60],[9,42,49,61],
 [9,42,49,62],[9,42,49,63],[9,42,49,64],[9,42,49,65],
 [9,42,49,68],[9,42,51,60],[9,42,51,62],[9,42,51,63],
 [9,42,51,64],[9,42,51,68],[9,42,59,60],[9,42,59,61],
 [9,42,59,62],[9,42,59,63],[9,42,59,64],[9,42,59,65],
 [9,42,59,68],[9,42,60,62],[9,42,60,65],[9,42,60,68],
 [9,42,61,63],[9,42,61,64],[9,42,61,65],[9,42,61,68],
 [9,42,62,65],[9,42,62,68],[9,42,63,64],[9,42,63,65],
 [9,42,63,68],[9,42,64,65],[9,42,64,68],[9,42,65,68],
 [9,43,44,45],[9,43,44,46],[9,43,44,47],[9,43,44,48],
 [9,43,44,49],[9,43,44,53],[9,43,44,55],[9,43,44,57],
 [9,43,44,58],[9,43,44,59],[9,43,44,60],[9,43,44,61],
 [9,43,44,62],[9,43,44,66],[9,43,44,67],[9,43,44,68],
 [9,43,44,69],[9,43,45,46],[9,43,45,47],[9,43,45,48],
 [9,43,45,49],[9,43,45,55],[9,43,45,58],[9,43,45,59],
 [9,43,45,60],[9,43,45,61],[9,43,45,62],[9,43,45,66],
 [9,43,45,67],[9,43,45,68],[9,43,45,69],[9,43,46,47],
 [9,43,46,48],[9,43,46,49],[9,43,46,53],[9,43,46,55],
 [9,43,46,56],[9,43,46,57],[9,43,46,58],[9,43,46,59],
 [9,43,46,60],[9,43,46,61],[9,43,46,62],[9,43,46,66],
 [9,43,46,67],[9,43,46,68],[9,43,46,69],[9,43,47,48],
 [9,43,47,49],[9,43,47,53],[9,43,47,55],[9,43,47,57],
 [9,43,47,58],[9,43,47,59],[9,43,47,60],[9,43,47,61],
 [9,43,47,62],[9,43,47,66],[9,43,47,67],[9,43,47,68],
 [9,43,47,69],[9,43,48,49],[9,43,48,55],[9,43,48,56],
 [9,43,48,57],[9,43,48,58],[9,43,48,59],[9,43,48,60],
 [9,43,48,61],[9,43,48,62],[9,43,48,66],[9,43,48,67],
 [9,43,48,68],[9,43,48,69],[9,43,49,53],[9,43,49,55],
 [9,43,49,56],[9,43,49,58],[9,43,49,59],[9,43,49,60],
 [9,43,49,61],[9,43,49,62],[9,43,49,66],[9,43,49,67],
 [9,43,49,68],[9,43,49,69],[9,43,53,60],[9,43,53,62],
 [9,43,53,68],[9,43,55,58],[9,43,55,59],[9,43,55,60],
 [9,43,55,61],[9,43,55,62],[9,43,55,66],[9,43,55,67],
 [9,43,55,68],[9,43,55,69],[9,43,56,57],[9,43,56,68],
 [9,43,57,59],[9,43,57,61],[9,43,57,68],[9,43,58,59],
 [9,43,58,60],[9,43,58,61],[9,43,58,62],[9,43,58,66],
 [9,43,58,67],[9,43,58,68],[9,43,58,69],[9,43,59,60],
 [9,43,59,61],[9,43,59,62],[9,43,59,66],[9,43,59,67],
 [9,43,59,68],[9,43,59,69],[9,43,60,61],[9,43,60,62],
 [9,43,60,66],[9,43,60,67],[9,43,60,68],[9,43,60,69],
 [9,43,61,62],[9,43,61,66],[9,43,61,67],[9,43,61,68],
 [9,43,61,69],[9,43,62,66],[9,43,62,67],[9,43,62,68],
 [9,43,62,69],[9,43,66,67],[9,43,66,68],[9,43,66,69],
 [9,43,67,68],[9,43,67,69],[9,43,68,69],[9,44,45,46],
 [9,44,45,47],[9,44,45,48],[9,44,45,49],[9,44,45,51],
 [9,44,45,54],[9,44,45,55],[9,44,45,58],[9,44,45,59],
 [9,44,45,60],[9,44,45,61],[9,44,45,62],[9,44,45,66],
 [9,44,45,67],[9,44,45,68],[9,44,45,69],[9,44,46,47],
 [9,44,46,48],[9,44,46,49],[9,44,46,53],[9,44,46,55],
 [9,44,46,57],[9,44,46,58],[9,44,46,59],[9,44,46,60],
 [9,44,46,61],[9,44,46,62],[9,44,46,65],[9,44,46,66],
 [9,44,46,67],[9,44,46,68],[9,44,46,69],[9,44,47,48],
 [9,44,47,49],[9,44,47,53],[9,44,47,54],[9,44,47,55],
 [9,44,47,56],[9,44,47,57],[9,44,47,58],[9,44,47,59],
 [9,44,47,60],[9,44,47,61],[9,44,47,62],[9,44,47,63],
 [9,44,47,64],[9,44,47,65],[9,44,47,66],[9,44,47,67],
 [9,44,47,68],[9,44,47,69],[9,44,48,49],[9,44,48,51],
 [9,44,48,53],[9,44,48,55],[9,44,48,56],[9,44,48,58],
 [9,44,48,59],[9,44,48,60],[9,44,48,61],[9,44,48,62],
 [9,44,48,63],[9,44,48,64],[9,44,48,66],[9,44,48,67],
 [9,44,48,68],[9,44,48,69],[9,44,49,53],[9,44,49,54],
 [9,44,49,55],[9,44,49,56],[9,44,49,57],[9,44,49,58],
 [9,44,49,59],[9,44,49,60],[9,44,49,61],[9,44,49,62],
 [9,44,49,63],[9,44,49,64],[9,44,49,65],[9,44,49,66],
 [9,44,49,67],[9,44,49,68],[9,44,49,69],[9,44,51,53],
 [9,44,51,59],[9,44,51,61],[9,44,51,63],[9,44,51,65],
 [9,44,51,66],[9,44,51,67],[9,44,51,68],[9,44,51,69],
 [9,44,53,54],[9,44,53,60],[9,44,53,63],[9,44,53,68],
 [9,44,54,56],[9,44,54,57],[9,44,54,59],[9,44,54,61],
 [9,44,54,62],[9,44,54,67],[9,44,54,68],[9,44,55,58],
 [9,44,55,59],[9,44,55,60],[9,44,55,61],[9,44,55,62],
 [9,44,55,66],[9,44,55,67],[9,44,55,68],[9,44,55,69],
 [9,44,56,57],[9,44,56,59],[9,44,56,61],[9,44,56,68],
 [9,44,57,59],[9,44,57,61],[9,44,57,68],[9,44,58,59],
 [9,44,58,60],[9,44,58,61],[9,44,58,62],[9,44,58,66],
 [9,44,58,67],[9,44,58,68],[9,44,58,69],[9,44,59,60],
 [9,44,59,61],[9,44,59,62],[9,44,59,63],[9,44,59,64],
 [9,44,59,65],[9,44,59,66],[9,44,59,67],[9,44,59,68],
 [9,44,59,69],[9,44,60,61],[9,44,60,62],[9,44,60,65],
 [9,44,60,66],[9,44,60,67],[9,44,60,68],[9,44,60,69],
 [9,44,61,62],[9,44,61,63],[9,44,61,64],[9,44,61,65],
 [9,44,61,66],[9,44,61,67],[9,44,61,68],[9,44,61,69],
 [9,44,62,66],[9,44,62,67],[9,44,62,68],[9,44,62,69],
 [9,44,63,64],[9,44,63,65],[9,44,63,66],[9,44,63,68],
 [9,44,63,69],[9,44,64,65],[9,44,64,67],[9,44,64,68],
 [9,44,65,68],[9,44,66,67],[9,44,66,68],[9,44,66,69],
 [9,44,67,68],[9,44,67,69],[9,44,68,69],[9,45,46,47],
 [9,45,46,48],[9,45,46,49],[9,45,46,55],[9,45,46,58],
 [9,45,46,59],[9,45,46,60],[9,45,46,61],[9,45,46,62],
 [9,45,46,65],[9,45,46,66],[9,45,46,67],[9,45,46,68],
 [9,45,46,69],[9,45,47,48],[9,45,47,49],[9,45,47,53],
 [9,45,47,55],[9,45,47,58],[9,45,47,59],[9,45,47,60],
 [9,45,47,61],[9,45,47,62],[9,45,47,66],[9,45,47,67],
 [9,45,47,68],[9,45,47,69],[9,45,48,49],[9,45,48,51],
 [9,45,48,53],[9,45,48,55],[9,45,48,58],[9,45,48,59],
 [9,45,48,60],[9,45,48,61],[9,45,48,62],[9,45,48,66],
 [9,45,48,67],[9,45,48,68],[9,45,48,69],[9,45,49,55],
 [9,45,49,58],[9,45,49,59],[9,45,49,60],[9,45,49,61],
 [9,45,49,62],[9,45,49,66],[9,45,49,67],[9,45,49,68],
 [9,45,49,69],[9,45,51,53],[9,45,51,55],[9,45,51,58],
 [9,45,51,60],[9,45,51,62],[9,45,51,66],[9,45,51,67],
 [9,45,51,68],[9,45,51,69],[9,45,53,60],[9,45,53,62],
 [9,45,53,68],[9,45,54,60],[9,45,54,62],[9,45,54,67],
 [9,45,54,68],[9,45,54,69],[9,45,55,58],[9,45,55,59],
 [9,45,55,60],[9,45,55,61],[9,45,55,62],[9,45,55,66],
 [9,45,55,67],[9,45,55,68],[9,45,55,69],[9,45,58,59],
 [9,45,58,60],[9,45,58,61],[9,45,58,62],[9,45,58,66],
 [9,45,58,67],[9,45,58,68],[9,45,58,69],[9,45,59,60],
 [9,45,59,61],[9,45,59,62],[9,45,59,65],[9,45,59,66],
 [9,45,59,67],[9,45,59,68],[9,45,59,69],[9,45,60,61],
 [9,45,60,62],[9,45,60,65],[9,45,60,66],[9,45,60,67],
 [9,45,60,68],[9,45,60,69],[9,45,61,62],[9,45,61,66],
 [9,45,61,67],[9,45,61,68],[9,45,61,69],[9,45,62,65],
 [9,45,62,66],[9,45,62,67],[9,45,62,68],[9,45,62,69],
 [9,45,65,68],[9,45,66,67],[9,45,66,68],[9,45,66,69],
 [9,45,67,68],[9,45,67,69],[9,45,68,69],[9,46,47,48],
 [9,46,47,49],[9,46,47,53],[9,46,47,55],[9,46,47,57],
 [9,46,47,58],[9,46,47,59],[9,46,47,60],[9,46,47,61],
 [9,46,47,62],[9,46,47,65],[9,46,47,66],[9,46,47,67],
 [9,46,47,68],[9,46,47,69],[9,46,48,49],[9,46,48,55],
 [9,46,48,56],[9,46,48,57],[9,46,48,58],[9,46,48,59],
 [9,46,48,60],[9,46,48,61],[9,46,48,62],[9,46,48,66],
 [9,46,48,67],[9,46,48,68],[9,46,48,69],[9,46,49,53],
 [9,46,49,55],[9,46,49,56],[9,46,49,58],[9,46,49,59],
 [9,46,49,60],[9,46,49,61],[9,46,49,62],[9,46,49,65],
 [9,46,49,66],[9,46,49,67],[9,46,49,68],[9,46,49,69],
 [9,46,53,60],[9,46,53,62],[9,46,53,68],[9,46,55,58],
 [9,46,55,59],[9,46,55,60],[9,46,55,61],[9,46,55,62],
 [9,46,55,66],[9,46,55,67],[9,46,55,68],[9,46,55,69],
 [9,46,56,57],[9,46,56,59],[9,46,56,61],[9,46,56,68],
 [9,46,57,61],[9,46,57,68],[9,46,58,59],[9,46,58,60],
 [9,46,58,61],[9,46,58,62],[9,46,58,66],[9,46,58,67],
 [9,46,58,68],[9,46,58,69],[9,46,59,60],[9,46,59,61],
 [9,46,59,62],[9,46,59,65],[9,46,59,66],[9,46,59,67],
 [9,46,59,68],[9,46,59,69],[9,46,60,61],[9,46,60,62],
 [9,46,60,65],[9,46,60,66],[9,46,60,67],[9,46,60,68],
 [9,46,60,69],[9,46,61,62],[9,46,61,66],[9,46,61,67],
 [9,46,61,68],[9,46,61,69],[9,46,62,65],[9,46,62,66],
 [9,46,62,67],[9,46,62,68],[9,46,62,69],[9,46,65,68],
 [9,46,66,67],[9,46,66,68],[9,46,66,69],[9,46,67,68],
 [9,46,67,69],[9,46,68,69],[9,47,48,49],[9,47,48,53],
 [9,47,48,55],[9,47,48,57],[9,47,48,58],[9,47,48,59],
 [9,47,48,60],[9,47,48,61],[9,47,48,62],[9,47,48,63],
 [9,47,48,64],[9,47,48,66],[9,47,48,67],[9,47,48,68],
 [9,47,48,69],[9,47,49,53],[9,47,49,54],[9,47,49,55],
 [9,47,49,56],[9,47,49,57],[9,47,49,58],[9,47,49,59],
 [9,47,49,60],[9,47,49,61],[9,47,49,62],[9,47,49,63],
 [9,47,49,64],[9,47,49,65],[9,47,49,66],[9,47,49,67],
 [9,47,49,68],[9,47,49,69],[9,47,53,54],[9,47,53,60],
 [9,47,53,62],[9,47,53,63],[9,47,53,64],[9,47,53,68],
 [9,47,54,56],[9,47,54,57],[9,47,54,59],[9,47,54,61],
 [9,47,54,62],[9,47,54,68],[9,47,54,69],[9,47,55,58],
 [9,47,55,59],[9,47,55,60],[9,47,55,61],[9,47,55,62],
 [9,47,55,66],[9,47,55,67],[9,47,55,68],[9,47,55,69],
 [9,47,56,57],[9,47,56,59],[9,47,56,61],[9,47,56,68],
 [9,47,57,59],[9,47,57,61],[9,47,57,68],[9,47,58,59],
 [9,47,58,60],[9,47,58,61],[9,47,58,62],[9,47,58,66],
 [9,47,58,67],[9,47,58,68],[9,47,58,69],[9,47,59,60],
 [9,47,59,61],[9,47,59,62],[9,47,59,63],[9,47,59,64],
 [9,47,59,65],[9,47,59,66],[9,47,59,67],[9,47,59,68],
 [9,47,59,69],[9,47,60,61],[9,47,60,62],[9,47,60,65],
 [9,47,60,66],[9,47,60,67],[9,47,60,68],[9,47,60,69],
 [9,47,61,62],[9,47,61,63],[9,47,61,64],[9,47,61,65],
 [9,47,61,66],[9,47,61,67],[9,47,61,68],[9,47,61,69],
 [9,47,62,65],[9,47,62,66],[9,47,62,67],[9,47,62,68],
 [9,47,62,69],[9,47,63,64],[9,47,63,65],[9,47,63,66],
 [9,47,63,67],[9,47,63,68],[9,47,63,69],[9,47,64,65],
 [9,47,64,67],[9,47,64,68],[9,47,64,69],[9,47,65,68],
 [9,47,66,67],[9,47,66,68],[9,47,66,69],[9,47,67,68],
 [9,47,67,69],[9,47,68,69],[9,48,49,55],[9,48,49,56],
 [9,48,49,58],[9,48,49,59],[9,48,49,60],[9,48,49,61],
 [9,48,49,62],[9,48,49,63],[9,48,49,64],[9,48,49,66],
 [9,48,49,67],[9,48,49,68],[9,48,49,69],[9,48,51,53],
 [9,48,51,56],[9,48,51,58],[9,48,51,60],[9,48,51,62],
 [9,48,51,63],[9,48,51,64],[9,48,51,67],[9,48,51,68],
 [9,48,53,60],[9,48,53,62],[9,48,53,63],[9,48,53,64],
 [9,48,53,68],[9,48,55,58],[9,48,55,59],[9,48,55,60],
 [9,48,55,61],[9,48,55,62],[9,48,55,66],[9,48,55,67],
 [9,48,55,68],[9,48,55,69],[9,48,56,57],[9,48,56,59],
 [9,48,56,61],[9,48,56,68],[9,48,57,59],[9,48,57,61],
 [9,48,57,68],[9,48,58,59],[9,48,58,60],[9,48,58,61],
 [9,48,58,62],[9,48,58,66],[9,48,58,67],[9,48,58,68],
 [9,48,58,69],[9,48,59,60],[9,48,59,61],[9,48,59,62],
 [9,48,59,64],[9,48,59,66],[9,48,59,67],[9,48,59,68],
 [9,48,59,69],[9,48,60,61],[9,48,60,62],[9,48,60,66],
 [9,48,60,67],[9,48,60,68],[9,48,60,69],[9,48,61,62],
 [9,48,61,63],[9,48,61,66],[9,48,61,67],[9,48,61,68],
 [9,48,61,69],[9,48,62,66],[9,48,62,67],[9,48,62,68],
 [9,48,62,69],[9,48,63,64],[9,48,63,66],[9,48,63,67],
 [9,48,63,68],[9,48,63,69],[9,48,64,66],[9,48,64,67],
 [9,48,64,68],[9,48,64,69],[9,48,66,67],[9,48,66,68],
 [9,48,66,69],[9,48,67,68],[9,48,67,69],[9,48,68,69],
 [9,49,53,60],[9,49,53,62],[9,49,53,63],[9,49,53,64],
 [9,49,53,68],[9,49,54,56],[9,49,54,57],[9,49,54,59],
 [9,49,54,60],[9,49,54,61],[9,49,54,67],[9,49,54,68],
 [9,49,55,58],[9,49,55,59],[9,49,55,60],[9,49,55,61],
 [9,49,55,62],[9,49,55,66],[9,49,55,67],[9,49,55,68],
 [9,49,55,69],[9,49,56,57],[9,49,56,59],[9,49,56,61],
 [9,49,56,68],[9,49,57,59],[9,49,57,61],[9,49,57,68],
 [9,49,58,59],[9,49,58,60],[9,49,58,61],[9,49,58,62],
 [9,49,58,66],[9,49,58,67],[9,49,58,68],[9,49,58,69],
 [9,49,59,60],[9,49,59,61],[9,49,59,62],[9,49,59,63],
 [9,49,59,64],[9,49,59,65],[9,49,59,66],[9,49,59,67],
 [9,49,59,68],[9,49,59,69],[9,49,60,61],[9,49,60,62],
 [9,49,60,65],[9,49,60,66],[9,49,60,67],[9,49,60,68],
 [9,49,60,69],[9,49,61,62],[9,49,61,63],[9,49,61,64],
 [9,49,61,65],[9,49,61,66],[9,49,61,67],[9,49,61,68],
 [9,49,61,69],[9,49,62,65],[9,49,62,66],[9,49,62,67],
 [9,49,62,68],[9,49,62,69],[9,49,63,64],[9,49,63,65],
 [9,49,63,67],[9,49,63,68],[9,49,63,69],[9,49,64,65],
 [9,49,64,66],[9,49,64,67],[9,49,64,68],[9,49,64,69],
 [9,49,65,68],[9,49,66,67],[9,49,66,68],[9,49,66,69],
 [9,49,67,68],[9,49,67,69],[9,49,68,69],[9,51,53,60],
 [9,51,53,62],[9,51,53,63],[9,51,53,64],[9,51,53,68],
 [9,51,55,58],[9,51,55,59],[9,51,55,60],[9,51,55,61],
 [9,51,55,62],[9,51,55,66],[9,51,55,67],[9,51,55,68],
 [9,51,55,69],[9,51,56,57],[9,51,56,59],[9,51,56,61],
 [9,51,56,68],[9,51,57,59],[9,51,57,61],[9,51,57,68],
 [9,51,58,59],[9,51,58,60],[9,51,58,61],[9,51,58,62],
 [9,51,58,66],[9,51,58,67],[9,51,58,68],[9,51,58,69],
 [9,51,59,60],[9,51,59,61],[9,51,59,62],[9,51,59,63],
 [9,51,59,64],[9,51,59,65],[9,51,59,66],[9,51,59,67],
 [9,51,59,68],[9,51,59,69],[9,51,60,61],[9,51,60,62],
 [9,51,60,65],[9,51,60,66],[9,51,60,67],[9,51,60,68],
 [9,51,60,69],[9,51,61,62],[9,51,61,63],[9,51,61,64],
 [9,51,61,65],[9,51,61,66],[9,51,61,67],[9,51,61,68],
 [9,51,61,69],[9,51,62,65],[9,51,62,66],[9,51,62,67],
 [9,51,62,68],[9,51,62,69],[9,51,63,64],[9,51,63,65],
 [9,51,63,66],[9,51,63,67],[9,51,63,68],[9,51,63,69],
 [9,51,64,65],[9,51,64,66],[9,51,64,67],[9,51,64,68],
 [9,51,64,69],[9,51,65,68],[9,51,66,67],[9,51,66,68],
 [9,51,66,69],[9,51,67,68],[9,51,67,69],[9,51,68,69],
 [9,53,54,60],[9,53,54,62],[9,53,54,68],[9,53,60,62],
 [9,53,60,68],[9,53,62,68],[9,53,63,64],[9,53,63,68],
 [9,53,64,68],[9,54,56,57],[9,54,56,59],[9,54,56,61],
 [9,54,56,68],[9,54,57,59],[9,54,57,61],[9,54,57,68],
 [9,54,59,60],[9,54,59,61],[9,54,59,67],[9,54,59,68],
 [9,54,59,69],[9,54,60,61],[9,54,60,62],[9,54,60,67],
 [9,54,60,68],[9,54,60,69],[9,54,61,62],[9,54,61,67],
 [9,54,61,68],[9,54,61,69],[9,54,62,67],[9,54,62,68],
 [9,54,62,69],[9,54,67,68],[9,54,67,69],[9,54,68,69],
 [9,55,58,59],[9,55,58,60],[9,55,58,61],[9,55,58,62],
 [9,55,58,66],[9,55,58,67],[9,55,58,68],[9,55,58,69],
 [9,55,59,60],[9,55,59,61],[9,55,59,62],[9,55,59,66],
 [9,55,59,67],[9,55,59,68],[9,55,59,69],[9,55,60,61],
 [9,55,60,62],[9,55,60,66],[9,55,60,67],[9,55,60,68],
 [9,55,60,69],[9,55,61,62],[9,55,61,66],[9,55,61,67],
 [9,55,61,68],[9,55,61,69],[9,55,62,66],[9,55,62,67],
 [9,55,62,68],[9,55,62,69],[9,55,66,67],[9,55,66,68],
 [9,55,66,69],[9,55,67,68],[9,55,67,69],[9,55,68,69],
 [9,56,57,59],[9,56,57,61],[9,56,57,68],[9,56,59,61],
 [9,56,59,68],[9,56,61,68],[9,57,59,61],[9,57,59,68],
 [9,57,61,68],[9,58,59,60],[9,58,59,61],[9,58,59,62],
 [9,58,59,66],[9,58,59,67],[9,58,59,68],[9,58,59,69],
 [9,58,60,61],[9,58,60,62],[9,58,60,66],[9,58,60,67],
 [9,58,60,68],[9,58,60,69],[9,58,61,62],[9,58,61,66],
 [9,58,61,67],[9,58,61,68],[9,58,61,69],[9,58,62,66],
 [9,58,62,67],[9,58,62,68],[9,58,62,69],[9,58,66,67],
 [9,58,66,68],[9,58,66,69],[9,58,67,68],[9,58,67,69],
 [9,58,68,69],[9,59,60,61],[9,59,60,62],[9,59,60,66],
 [9,59,60,67],[9,59,60,68],[9,59,60,69],[9,59,61,62],
 [9,59,61,63],[9,59,61,64],[9,59,61,65],[9,59,61,66],
 [9,59,61,67],[9,59,61,68],[9,59,61,69],[9,59,62,65],
 [9,59,62,66],[9,59,62,67],[9,59,62,68],[9,59,62,69],
 [9,59,63,64],[9,59,63,65],[9,59,63,66],[9,59,63,67],
 [9,59,63,68],[9,59,63,69],[9,59,64,65],[9,59,64,68],
 [9,59,64,69],[9,59,65,68],[9,59,66,67],[9,59,66,68],
 [9,59,66,69],[9,59,67,68],[9,59,67,69],[9,59,68,69],
 [9,60,61,62],[9,60,61,66],[9,60,61,67],[9,60,61,68],
 [9,60,61,69],[9,60,62,65],[9,60,62,66],[9,60,62,67],
 [9,60,62,68],[9,60,62,69],[9,60,65,68],[9,60,66,67],
 [9,60,66,68],[9,60,66,69],[9,60,67,68],[9,60,67,69],
 [9,60,68,69],[9,61,62,66],[9,61,62,67],[9,61,62,68],
 [9,61,62,69],[9,61,63,64],[9,61,63,65],[9,61,63,66],
 [9,61,63,67],[9,61,63,68],[9,61,63,69],[9,61,64,65],
 [9,61,64,68],[9,61,65,68],[9,61,66,67],[9,61,66,68],
 [9,61,66,69],[9,61,67,68],[9,61,67,69],[9,61,68,69],
 [9,62,65,68],[9,62,66,67],[9,62,66,68],[9,62,66,69],
 [9,62,67,68],[9,62,67,69],[9,62,68,69],[9,63,64,65],
 [9,63,64,66],[9,63,64,67],[9,63,64,68],[9,63,64,69],
 [9,63,65,68],[9,63,66,67],[9,63,66,68],[9,63,66,69],
 [9,63,67,68],[9,63,67,69],[9,63,68,69],[9,64,65,68],
 [9,64,66,67],[9,64,66,68],[9,64,66,69],[9,64,67,68],
 [9,64,67,69],[9,64,68,69],[9,66,67,68],[9,66,67,69],
 [9,66,68,69],[9,67,68,69],[10,11,12,14],
 [10,11,12,16],[10,11,12,21],[10,11,12,23],
 [10,11,12,25],[10,11,12,34],[10,11,12,45],
 [10,11,12,46],[10,11,12,47],[10,11,12,48],
 [10,11,12,49],[10,11,12,51],[10,11,12,54],
 [10,11,12,55],[10,11,12,61],[10,11,12,62],
 [10,11,12,63],[10,11,12,69],[10,11,14,18],
 [10,11,14,25],[10,11,14,27],[10,11,14,37],
 [10,11,14,49],[10,11,14,55],[10,11,14,57],
 [10,11,14,61],[10,11,14,62],[10,11,14,66],
 [10,11,14,68],[10,11,14,69],[10,11,16,19],
 [10,11,16,21],[10,11,16,25],[10,11,16,27],
 [10,11,16,30],[10,11,16,34],[10,11,16,37],
 [10,11,16,38],[10,11,16,45],[10,11,16,46],
 [10,11,16,47],[10,11,16,48],[10,11,16,49],
 [10,11,16,51],[10,11,16,57],[10,11,16,61],
 [10,11,16,62],[10,11,16,69],[10,11,18,19],
 [10,11,18,23],[10,11,18,25],[10,11,18,46],
 [10,11,18,47],[10,11,18,48],[10,11,18,49],
 [10,11,18,51],[10,11,18,54],[10,11,18,55],
 [10,11,18,61],[10,11,19,21],[10,11,19,23],
 [10,11,19,25],[10,11,19,27],[10,11,19,41],
 [10,11,19,49],[10,11,19,57],[10,11,19,61],
 [10,11,19,62],[10,11,19,63],[10,11,19,66],
 [10,11,19,68],[10,11,21,23],[10,11,21,25],
 [10,11,21,34],[10,11,21,37],[10,11,21,38],
 [10,11,21,41],[10,11,21,45],[10,11,21,46],
 [10,11,21,48],[10,11,21,49],[10,11,21,51],
 [10,11,21,61],[10,11,21,62],[10,11,21,69],
 [10,11,23,25],[10,11,23,27],[10,11,23,30],
 [10,11,23,37],[10,11,23,41],[10,11,23,47],
 [10,11,23,49],[10,11,23,55],[10,11,23,57],
 [10,11,23,61],[10,11,23,62],[10,11,23,66],
 [10,11,23,68],[10,11,23,69],[10,11,25,27],
 [10,11,25,28],[10,11,25,34],[10,11,25,37],
 [10,11,25,41],[10,11,25,45],[10,11,25,46],
 [10,11,25,47],[10,11,25,48],[10,11,25,49],
 [10,11,25,51],[10,11,25,54],[10,11,25,57],
 [10,11,25,61],[10,11,25,62],[10,11,25,68],
 [10,11,25,69],[10,11,27,28],[10,11,27,41],
 [10,11,27,46],[10,11,27,47],[10,11,27,48],
 [10,11,27,49],[10,11,27,51],[10,11,27,54],
 [10,11,27,55],[10,11,27,61],[10,11,27,66],
 [10,11,27,68],[10,11,28,49],[10,11,28,55],
 [10,11,28,57],[10,11,28,61],[10,11,28,68],
 [10,11,29,41],[10,11,29,47],[10,11,29,49],
 [10,11,29,61],[10,11,29,68],[10,11,30,41],
 [10,11,30,45],[10,11,30,48],[10,11,30,49],
 [10,11,30,61],[10,11,30,62],[10,11,30,68],
 [10,11,34,45],[10,11,34,46],[10,11,34,48],
 [10,11,34,49],[10,11,34,61],[10,11,34,62],
 [10,11,34,63],[10,11,34,69],[10,11,37,38],
 [10,11,37,45],[10,11,37,46],[10,11,37,47],
 [10,11,37,48],[10,11,37,54],[10,11,37,61],
 [10,11,37,62],[10,11,38,41],[10,11,38,47],
 [10,11,38,49],[10,11,38,55],[10,11,38,61],
 [10,11,38,63],[10,11,38,68],[10,11,41,46],
 [10,11,41,47],[10,11,41,48],[10,11,41,49],
 [10,11,41,61],[10,11,41,63],[10,11,41,68],
 [10,11,45,46],[10,11,45,48],[10,11,45,49],
 [10,11,45,51],[10,11,45,61],[10,11,45,62],
 [10,11,45,63],[10,11,45,66],[10,11,45,69],
 [10,11,46,48],[10,11,46,49],[10,11,46,57],
 [10,11,46,61],[10,11,46,62],[10,11,46,63],
 [10,11,46,68],[10,11,46,69],[10,11,47,49],
 [10,11,47,55],[10,11,47,57],[10,11,47,61],
 [10,11,47,62],[10,11,47,63],[10,11,47,66],
 [10,11,47,68],[10,11,47,69],[10,11,48,49],
 [10,11,48,51],[10,11,48,55],[10,11,48,57],
 [10,11,48,61],[10,11,48,62],[10,11,48,63],
 [10,11,48,66],[10,11,48,68],[10,11,48,69],
 [10,11,49,54],[10,11,49,55],[10,11,49,57],
 [10,11,49,61],[10,11,49,62],[10,11,49,63],
 [10,11,49,66],[10,11,49,68],[10,11,49,69],
 [10,11,51,55],[10,11,51,57],[10,11,51,61],
 [10,11,51,62],[10,11,51,63],[10,11,51,66],
 [10,11,51,68],[10,11,51,69],[10,11,54,57],
 [10,11,54,61],[10,11,54,62],[10,11,54,66],
 [10,11,54,68],[10,11,54,69],[10,11,55,61],
 [10,11,55,62],[10,11,55,66],[10,11,55,69],
 [10,11,57,61],[10,11,61,62],[10,11,61,63],
 [10,11,61,66],[10,11,61,68],[10,11,61,69],
 [10,11,62,63],[10,11,62,69],[10,11,63,68],
 [10,11,63,69],[10,12,14,21],[10,12,14,25],
 [10,12,14,26],[10,12,14,45],[10,12,14,53],
 [10,12,14,55],[10,12,14,56],[10,12,14,58],
 [10,12,14,61],[10,12,14,62],[10,12,14,67],
 [10,12,14,69],[10,12,16,19],[10,12,16,21],
 [10,12,16,23],[10,12,16,25],[10,12,16,26],
 [10,12,16,30],[10,12,16,32],[10,12,16,33],
 [10,12,16,34],[10,12,16,35],[10,12,16,36],
 [10,12,16,37],[10,12,16,42],[10,12,16,44],
 [10,12,16,45],[10,12,16,46],[10,12,16,47],
 [10,12,16,48],[10,12,16,49],[10,12,16,51],
 [10,12,16,53],[10,12,16,54],[10,12,16,61],
 [10,12,16,62],[10,12,16,67],[10,12,16,69],
 [10,12,19,21],[10,12,19,23],[10,12,19,25],
 [10,12,19,26],[10,12,19,35],[10,12,19,36],
 [10,12,19,37],[10,12,19,42],[10,12,19,44],
 [10,12,19,48],[10,12,19,53],[10,12,19,55],
 [10,12,19,58],[10,12,19,61],[10,12,19,62],
 [10,12,19,63],[10,12,19,65],[10,12,19,67],
 [10,12,21,23],[10,12,21,25],[10,12,21,26],
 [10,12,21,33],[10,12,21,34],[10,12,21,35],
 [10,12,21,36],[10,12,21,37],[10,12,21,42],
 [10,12,21,44],[10,12,21,45],[10,12,21,46],
 [10,12,21,47],[10,12,21,48],[10,12,21,49],
 [10,12,21,51],[10,12,21,53],[10,12,21,61],
 [10,12,21,62],[10,12,21,65],[10,12,21,67],
 [10,12,21,69],[10,12,23,25],[10,12,23,26],
 [10,12,23,30],[10,12,23,32],[10,12,23,35],
 [10,12,23,36],[10,12,23,37],[10,12,23,42],
 [10,12,23,44],[10,12,23,45],[10,12,23,47],
 [10,12,23,48],[10,12,23,53],[10,12,23,55],
 [10,12,23,56],[10,12,23,58],[10,12,23,61],
 [10,12,23,62],[10,12,23,65],[10,12,23,67],
 [10,12,23,69],[10,12,25,26],[10,12,25,32],
 [10,12,25,33],[10,12,25,34],[10,12,25,35],
 [10,12,25,36],[10,12,25,37],[10,12,25,42],
 [10,12,25,44],[10,12,25,45],[10,12,25,46],
 [10,12,25,47],[10,12,25,48],[10,12,25,49],
 [10,12,25,51],[10,12,25,53],[10,12,25,54],
 [10,12,25,61],[10,12,25,62],[10,12,25,65],
 [10,12,25,67],[10,12,25,69],[10,12,26,35],
 [10,12,26,36],[10,12,26,37],[10,12,26,44],
 [10,12,26,45],[10,12,26,46],[10,12,26,47],
 [10,12,26,48],[10,12,26,49],[10,12,26,51],
 [10,12,26,54],[10,12,26,55],[10,12,26,56],
 [10,12,26,58],[10,12,26,62],[10,12,26,63],
 [10,12,26,65],[10,12,26,67],[10,12,30,35],
 [10,12,30,44],[10,12,30,45],[10,12,30,48],
 [10,12,30,49],[10,12,30,53],[10,12,30,61],
 [10,12,30,62],[10,12,32,44],[10,12,32,46],
 [10,12,32,47],[10,12,32,49],[10,12,32,51],
 [10,12,32,62],[10,12,32,63],[10,12,33,36],
 [10,12,33,44],[10,12,33,45],[10,12,33,47],
 [10,12,33,48],[10,12,33,55],[10,12,33,56],
 [10,12,33,62],[10,12,33,65],[10,12,33,67],
 [10,12,34,44],[10,12,34,45],[10,12,34,46],
 [10,12,34,48],[10,12,34,49],[10,12,34,61],
 [10,12,34,62],[10,12,34,63],[10,12,34,69],
 [10,12,35,37],[10,12,35,45],[10,12,35,47],
 [10,12,35,48],[10,12,35,49],[10,12,35,55],
 [10,12,35,58],[10,12,35,62],[10,12,35,67],
 [10,12,35,69],[10,12,36,45],[10,12,36,48],
 [10,12,36,54],[10,12,36,62],[10,12,36,63],
 [10,12,37,44],[10,12,37,45],[10,12,37,46],
 [10,12,37,47],[10,12,37,48],[10,12,37,61],
 [10,12,37,62],[10,12,37,67],[10,12,42,46],
 [10,12,42,47],[10,12,42,49],[10,12,42,51],
 [10,12,42,62],[10,12,42,63],[10,12,44,46],
 [10,12,44,47],[10,12,44,49],[10,12,44,54],
 [10,12,44,55],[10,12,44,62],[10,12,44,63],
 [10,12,44,65],[10,12,44,69],[10,12,45,46],
 [10,12,45,47],[10,12,45,48],[10,12,45,49],
 [10,12,45,51],[10,12,45,53],[10,12,45,54],
 [10,12,45,58],[10,12,45,61],[10,12,45,62],
 [10,12,45,65],[10,12,45,67],[10,12,45,69],
 [10,12,46,48],[10,12,46,49],[10,12,46,53],
 [10,12,46,56],[10,12,46,58],[10,12,46,61],
 [10,12,46,62],[10,12,46,63],[10,12,46,65],
 [10,12,46,67],[10,12,46,69],[10,12,47,48],
 [10,12,47,53],[10,12,47,54],[10,12,47,55],
 [10,12,47,56],[10,12,47,58],[10,12,47,61],
 [10,12,47,62],[10,12,47,63],[10,12,47,65],
 [10,12,47,67],[10,12,47,69],[10,12,48,49],
 [10,12,48,51],[10,12,48,53],[10,12,48,55],
 [10,12,48,56],[10,12,48,58],[10,12,48,61],
 [10,12,48,62],[10,12,48,63],[10,12,48,67],
 [10,12,48,69],[10,12,49,53],[10,12,49,55],
 [10,12,49,56],[10,12,49,58],[10,12,49,61],
 [10,12,49,62],[10,12,49,63],[10,12,49,65],
 [10,12,49,67],[10,12,49,69],[10,12,51,53],
 [10,12,51,56],[10,12,51,58],[10,12,51,61],
 [10,12,51,62],[10,12,51,65],[10,12,51,67],
 [10,12,51,69],[10,12,53,54],[10,12,53,62],
 [10,12,53,63],[10,12,54,56],[10,12,54,61],
 [10,12,54,62],[10,12,54,67],[10,12,54,69],
 [10,12,55,61],[10,12,55,62],[10,12,55,69],
 [10,12,56,62],[10,12,58,62],[10,12,58,67],
 [10,12,61,62],[10,12,61,63],[10,12,61,69],
 [10,12,62,63],[10,12,62,65],[10,12,62,67],
 [10,12,62,69],[10,12,63,65],[10,12,63,67],
 [10,12,63,69],[10,14,18,25],[10,14,18,26],
 [10,14,18,44],[10,14,18,49],[10,14,18,53],
 [10,14,18,55],[10,14,18,56],[10,14,18,61],
 [10,14,18,66],[10,14,18,67],[10,14,21,25],
 [10,14,21,45],[10,14,21,59],[10,14,21,62],
 [10,14,21,67],[10,14,21,69],[10,14,25,26],
 [10,14,25,27],[10,14,25,37],[10,14,25,45],
 [10,14,25,49],[10,14,25,53],[10,14,25,57],
 [10,14,25,59],[10,14,25,61],[10,14,25,62],
 [10,14,25,66],[10,14,25,67],[10,14,25,68],
 [10,14,25,69],[10,14,26,27],[10,14,26,37],
 [10,14,26,44],[10,14,26,49],[10,14,26,55],
 [10,14,26,56],[10,14,26,57],[10,14,26,58],
 [10,14,26,62],[10,14,26,67],[10,14,26,68],
 [10,14,26,69],[10,14,27,53],[10,14,27,55],
 [10,14,27,56],[10,14,27,61],[10,14,27,66],
 [10,14,27,67],[10,14,27,68],[10,14,27,69],
 [10,14,37,44],[10,14,37,45],[10,14,37,56],
 [10,14,37,61],[10,14,37,62],[10,14,37,67],
 [10,14,37,68],[10,14,44,45],[10,14,44,49],
 [10,14,44,55],[10,14,44,57],[10,14,44,59],
 [10,14,44,66],[10,14,44,68],[10,14,44,69],
 [10,14,45,53],[10,14,45,58],[10,14,45,61],
 [10,14,45,62],[10,14,45,66],[10,14,45,67],
 [10,14,45,69],[10,14,49,53],[10,14,49,55],
 [10,14,49,56],[10,14,49,57],[10,14,49,59],
 [10,14,49,61],[10,14,49,66],[10,14,49,67],
 [10,14,49,68],[10,14,53,56],[10,14,53,58],
 [10,14,53,62],[10,14,53,68],[10,14,55,59],
 [10,14,55,61],[10,14,55,62],[10,14,55,66],
 [10,14,55,67],[10,14,55,68],[10,14,55,69],
 [10,14,56,57],[10,14,56,59],[10,14,56,62],
 [10,14,56,66],[10,14,56,68],[10,14,56,69],
 [10,14,57,58],[10,14,57,59],[10,14,57,61],
 [10,14,57,67],[10,14,57,68],[10,14,58,62],
 [10,14,58,67],[10,14,58,68],[10,14,58,69],
 [10,14,59,67],[10,14,59,68],[10,14,59,69],
 [10,14,61,62],[10,14,61,66],[10,14,61,68],
 [10,14,61,69],[10,14,62,67],[10,14,62,69],
 [10,14,66,67],[10,14,66,68],[10,14,66,69],
 [10,14,67,68],[10,14,67,69],[10,14,68,69],
 [10,16,19,21],[10,16,19,23],[10,16,19,25],
 [10,16,19,26],[10,16,19,27],[10,16,19,35],
 [10,16,19,37],[10,16,19,42],[10,16,19,44],
 [10,16,19,48],[10,16,19,49],[10,16,19,57],
 [10,16,19,61],[10,16,19,62],[10,16,19,66],
 [10,16,19,67],[10,16,19,69],[10,16,21,23],
 [10,16,21,25],[10,16,21,26],[10,16,21,29],
 [10,16,21,30],[10,16,21,33],[10,16,21,34],
 [10,16,21,35],[10,16,21,36],[10,16,21,37],
 [10,16,21,38],[10,16,21,42],[10,16,21,44],
 [10,16,21,45],[10,16,21,46],[10,16,21,47],
 [10,16,21,48],[10,16,21,49],[10,16,21,51],
 [10,16,21,53],[10,16,21,61],[10,16,21,62],
 [10,16,21,67],[10,16,21,69],[10,16,23,25],
 [10,16,23,26],[10,16,23,27],[10,16,23,30],
 [10,16,23,32],[10,16,23,35],[10,16,23,37],
 [10,16,23,42],[10,16,23,44],[10,16,23,45],
 [10,16,23,47],[10,16,23,48],[10,16,23,49],
 [10,16,23,53],[10,16,23,57],[10,16,23,61],
 [10,16,23,62],[10,16,23,66],[10,16,23,67],
 [10,16,23,69],[10,16,25,26],[10,16,25,27],
 [10,16,25,32],[10,16,25,33],[10,16,25,34],
 [10,16,25,35],[10,16,25,36],[10,16,25,37],
 [10,16,25,39],[10,16,25,42],[10,16,25,44],
 [10,16,25,45],[10,16,25,46],[10,16,25,47],
 [10,16,25,48],[10,16,25,49],[10,16,25,51],
 [10,16,25,53],[10,16,25,54],[10,16,25,57],
 [10,16,25,61],[10,16,25,62],[10,16,25,66],
 [10,16,25,67],[10,16,25,69],[10,16,26,27],
 [10,16,26,29],[10,16,26,30],[10,16,26,32],
 [10,16,26,34],[10,16,26,35],[10,16,26,37],
 [10,16,26,38],[10,16,26,39],[10,16,26,42],
 [10,16,26,44],[10,16,26,45],[10,16,26,46],
 [10,16,26,47],[10,16,26,48],[10,16,26,49],
 [10,16,26,51],[10,16,26,54],[10,16,26,57],
 [10,16,26,62],[10,16,26,66],[10,16,26,67],
 [10,16,26,69],[10,16,27,30],[10,16,27,32],
 [10,16,27,33],[10,16,27,34],[10,16,27,35],
 [10,16,27,36],[10,16,27,37],[10,16,27,39],
 [10,16,27,42],[10,16,27,44],[10,16,27,46],
 [10,16,27,47],[10,16,27,48],[10,16,27,49],
 [10,16,27,51],[10,16,27,53],[10,16,27,54],
 [10,16,27,61],[10,16,27,66],[10,16,27,67],
 [10,16,27,69],[10,16,29,32],[10,16,29,37],
 [10,16,29,42],[10,16,29,48],[10,16,29,49],
 [10,16,29,53],[10,16,29,61],[10,16,29,67],
 [10,16,29,69],[10,16,30,45],[10,16,30,48],
 [10,16,30,49],[10,16,30,62],[10,16,30,67],
 [10,16,32,33],[10,16,32,38],[10,16,32,46],
 [10,16,32,49],[10,16,32,62],[10,16,33,36],
 [10,16,33,37],[10,16,33,42],[10,16,33,45],
 [10,16,33,48],[10,16,33,49],[10,16,33,57],
 [10,16,33,62],[10,16,33,66],[10,16,33,69],
 [10,16,34,39],[10,16,34,44],[10,16,34,45],
 [10,16,34,46],[10,16,34,48],[10,16,34,49],
 [10,16,34,61],[10,16,34,62],[10,16,34,67],
 [10,16,34,69],[10,16,35,37],[10,16,35,45],
 [10,16,35,47],[10,16,35,48],[10,16,35,62],
 [10,16,35,67],[10,16,36,37],[10,16,36,45],
 [10,16,36,48],[10,16,36,49],[10,16,36,54],
 [10,16,36,57],[10,16,36,62],[10,16,36,66],
 [10,16,36,69],[10,16,37,38],[10,16,37,45],
 [10,16,37,47],[10,16,37,48],[10,16,37,54],
 [10,16,37,62],[10,16,37,67],[10,16,38,42],
 [10,16,38,48],[10,16,38,49],[10,16,38,53],
 [10,16,38,61],[10,16,38,66],[10,16,38,67],
 [10,16,38,69],[10,16,39,45],[10,16,39,46],
 [10,16,39,47],[10,16,39,48],[10,16,39,53],
 [10,16,39,66],[10,16,39,67],[10,16,39,69],
 [10,16,42,46],[10,16,42,49],[10,16,42,62],
 [10,16,42,66],[10,16,44,45],[10,16,44,46],
 [10,16,44,47],[10,16,44,48],[10,16,44,49],
 [10,16,44,54],[10,16,44,62],[10,16,44,66],
 [10,16,44,69],[10,16,45,46],[10,16,45,47],
 [10,16,45,48],[10,16,45,49],[10,16,45,51],
 [10,16,45,53],[10,16,45,54],[10,16,45,61],
 [10,16,45,62],[10,16,45,66],[10,16,45,67],
 [10,16,45,69],[10,16,46,48],[10,16,46,49],
 [10,16,46,57],[10,16,46,61],[10,16,46,62],
 [10,16,46,67],[10,16,46,69],[10,16,47,48],
 [10,16,47,49],[10,16,47,53],[10,16,47,54],
 [10,16,47,57],[10,16,47,61],[10,16,47,62],
 [10,16,47,66],[10,16,47,67],[10,16,47,69],
 [10,16,48,49],[10,16,48,51],[10,16,48,53],
 [10,16,48,57],[10,16,48,61],[10,16,48,62],
 [10,16,48,66],[10,16,48,67],[10,16,48,69],
 [10,16,49,54],[10,16,49,57],[10,16,49,61],
 [10,16,49,62],[10,16,49,66],[10,16,49,67],
 [10,16,49,69],[10,16,51,53],[10,16,51,57],
 [10,16,51,61],[10,16,51,62],[10,16,51,66],
 [10,16,51,67],[10,16,53,62],[10,16,54,57],
 [10,16,54,62],[10,16,54,66],[10,16,54,67],
 [10,16,54,69],[10,16,57,67],[10,16,61,62],
 [10,16,61,66],[10,16,61,69],[10,16,62,67],
 [10,16,62,69],[10,16,66,67],[10,16,66,69],
 [10,16,67,69],[10,18,19,23],[10,18,19,25],
 [10,18,19,35],[10,18,19,36],[10,18,19,44],
 [10,18,19,48],[10,18,19,53],[10,18,19,55],
 [10,18,19,61],[10,18,19,66],[10,18,19,67],
 [10,18,23,25],[10,18,23,26],[10,18,23,30],
 [10,18,23,35],[10,18,23,36],[10,18,23,44],
 [10,18,23,47],[10,18,23,48],[10,18,23,53],
 [10,18,23,55],[10,18,23,56],[10,18,23,61],
 [10,18,23,66],[10,18,23,67],[10,18,25,26],
 [10,18,25,33],[10,18,25,35],[10,18,25,36],
 [10,18,25,39],[10,18,25,44],[10,18,25,46],
 [10,18,25,47],[10,18,25,48],[10,18,25,49],
 [10,18,25,51],[10,18,25,53],[10,18,25,54],
 [10,18,25,61],[10,18,25,66],[10,18,25,67],
 [10,18,26,30],[10,18,26,35],[10,18,26,36],
 [10,18,26,39],[10,18,26,44],[10,18,26,46],
 [10,18,26,47],[10,18,26,48],[10,18,26,49],
 [10,18,26,51],[10,18,26,54],[10,18,26,55],
 [10,18,26,56],[10,18,26,66],[10,18,26,67],
 [10,18,30,48],[10,18,30,49],[10,18,30,53],
 [10,18,30,67],[10,18,33,36],[10,18,33,47],
 [10,18,33,48],[10,18,33,56],[10,18,33,66],
 [10,18,33,67],[10,18,35,47],[10,18,35,48],
 [10,18,35,49],[10,18,35,67],[10,18,36,48],
 [10,18,36,49],[10,18,36,54],[10,18,36,55],
 [10,18,36,66],[10,18,39,46],[10,18,39,47],
 [10,18,39,48],[10,18,39,53],[10,18,39,55],
 [10,18,39,66],[10,18,39,67],[10,18,44,47],
 [10,18,44,48],[10,18,44,49],[10,18,44,51],
 [10,18,44,54],[10,18,46,48],[10,18,46,53],
 [10,18,46,56],[10,18,46,61],[10,18,46,67],
 [10,18,47,48],[10,18,47,49],[10,18,47,53],
 [10,18,47,54],[10,18,47,55],[10,18,47,56],
 [10,18,47,61],[10,18,47,66],[10,18,47,67],
 [10,18,48,51],[10,18,48,53],[10,18,48,55],
 [10,18,48,56],[10,18,48,61],[10,18,48,66],
 [10,18,48,67],[10,18,49,53],[10,18,49,54],
 [10,18,49,55],[10,18,49,56],[10,18,49,61],
 [10,18,49,66],[10,18,49,67],[10,18,51,53],
 [10,18,51,55],[10,18,51,56],[10,18,51,61],
 [10,18,51,66],[10,18,51,67],[10,18,53,54],
 [10,18,53,56],[10,18,54,56],[10,18,54,61],
 [10,18,54,66],[10,18,54,67],[10,18,55,66],
 [10,18,55,67],[10,18,56,66],[10,18,66,67],
 [10,19,21,23],[10,19,21,25],[10,19,21,26],
 [10,19,21,37],[10,19,21,41],[10,19,21,42],
 [10,19,21,44],[10,19,21,48],[10,19,21,49],
 [10,19,21,53],[10,19,21,59],[10,19,21,61],
 [10,19,21,62],[10,19,21,65],[10,19,21,67],
 [10,19,21,69],[10,19,23,25],[10,19,23,26],
 [10,19,23,27],[10,19,23,35],[10,19,23,36],
 [10,19,23,37],[10,19,23,41],[10,19,23,42],
 [10,19,23,44],[10,19,23,48],[10,19,23,49],
 [10,19,23,53],[10,19,23,55],[10,19,23,57],
 [10,19,23,58],[10,19,23,59],[10,19,23,61],
 [10,19,23,62],[10,19,23,65],[10,19,23,66],
 [10,19,23,67],[10,19,23,68],[10,19,23,69],
 [10,19,25,26],[10,19,25,27],[10,19,25,35],
 [10,19,25,37],[10,19,25,41],[10,19,25,42],
 [10,19,25,44],[10,19,25,48],[10,19,25,49],
 [10,19,25,53],[10,19,25,57],[10,19,25,59],
 [10,19,25,61],[10,19,25,62],[10,19,25,65],
 [10,19,25,66],[10,19,25,67],[10,19,25,68],
 [10,19,25,69],[10,19,26,27],[10,19,26,35],
 [10,19,26,36],[10,19,26,37],[10,19,26,41],
 [10,19,26,44],[10,19,26,48],[10,19,26,49],
 [10,19,26,55],[10,19,26,58],[10,19,26,62],
 [10,19,26,63],[10,19,26,65],[10,19,26,66],
 [10,19,26,67],[10,19,26,68],[10,19,26,69],
 [10,19,27,35],[10,19,27,36],[10,19,27,41],
 [10,19,27,44],[10,19,27,48],[10,19,27,49],
 [10,19,27,55],[10,19,27,58],[10,19,27,59],
 [10,19,27,61],[10,19,27,65],[10,19,27,66],
 [10,19,27,67],[10,19,27,68],[10,19,27,69],
 [10,19,35,37],[10,19,35,41],[10,19,35,49],
 [10,19,35,55],[10,19,35,57],[10,19,35,58],
 [10,19,35,59],[10,19,35,62],[10,19,35,66],
 [10,19,35,67],[10,19,35,68],[10,19,35,69],
 [10,19,36,37],[10,19,36,48],[10,19,36,49],
 [10,19,36,55],[10,19,36,57],[10,19,36,62],
 [10,19,36,66],[10,19,36,68],[10,19,36,69],
 [10,19,37,44],[10,19,37,48],[10,19,37,59],
 [10,19,37,61],[10,19,37,62],[10,19,37,63],
 [10,19,37,67],[10,19,37,68],[10,19,41,44],
 [10,19,41,48],[10,19,41,49],[10,19,41,53],
 [10,19,41,55],[10,19,41,58],[10,19,41,59],
 [10,19,41,61],[10,19,41,66],[10,19,41,67],
 [10,19,41,68],[10,19,41,69],[10,19,42,49],
 [10,19,42,55],[10,19,42,59],[10,19,42,62],
 [10,19,42,63],[10,19,42,66],[10,19,44,48],
 [10,19,44,49],[10,19,44,55],[10,19,44,57],
 [10,19,44,59],[10,19,44,62],[10,19,44,65],
 [10,19,44,66],[10,19,44,68],[10,19,44,69],
 [10,19,48,49],[10,19,48,53],[10,19,48,55],
 [10,19,48,57],[10,19,48,58],[10,19,48,59],
 [10,19,48,61],[10,19,48,62],[10,19,48,63],
 [10,19,48,66],[10,19,48,67],[10,19,48,68],
 [10,19,48,69],[10,19,49,53],[10,19,49,55],
 [10,19,49,57],[10,19,49,58],[10,19,49,59],
 [10,19,49,61],[10,19,49,62],[10,19,49,63],
 [10,19,49,66],[10,19,49,67],[10,19,49,68],
 [10,19,49,69],[10,19,53,58],[10,19,53,62],
 [10,19,53,63],[10,19,53,68],[10,19,55,59],
 [10,19,55,61],[10,19,55,62],[10,19,55,66],
 [10,19,55,67],[10,19,55,68],[10,19,55,69],
 [10,19,57,58],[10,19,57,59],[10,19,57,61],
 [10,19,57,67],[10,19,58,59],[10,19,58,62],
 [10,19,58,65],[10,19,58,66],[10,19,58,67],
 [10,19,58,68],[10,19,58,69],[10,19,59,65],
 [10,19,59,66],[10,19,59,67],[10,19,59,68],
 [10,19,59,69],[10,19,61,62],[10,19,61,63],
 [10,19,61,66],[10,19,61,68],[10,19,61,69],
 [10,19,62,63],[10,19,62,65],[10,19,62,67],
 [10,19,62,69],[10,19,63,65],[10,19,63,66],
 [10,19,63,67],[10,19,63,68],[10,19,63,69],
 [10,19,66,67],[10,19,66,68],[10,19,66,69],
 [10,19,67,68],[10,19,67,69],[10,19,68,69],
 [10,21,23,25],[10,21,23,26],[10,21,23,30],
 [10,21,23,35],[10,21,23,37],[10,21,23,41],
 [10,21,23,42],[10,21,23,44],[10,21,23,45],
 [10,21,23,47],[10,21,23,48],[10,21,23,49],
 [10,21,23,53],[10,21,23,59],[10,21,23,61],
 [10,21,23,62],[10,21,23,65],[10,21,23,67],
 [10,21,23,69],[10,21,25,26],[10,21,25,33],
 [10,21,25,34],[10,21,25,35],[10,21,25,36],
 [10,21,25,37],[10,21,25,41],[10,21,25,42],
 [10,21,25,44],[10,21,25,45],[10,21,25,46],
 [10,21,25,47],[10,21,25,48],[10,21,25,49],
 [10,21,25,51],[10,21,25,53],[10,21,25,59],
 [10,21,25,61],[10,21,25,62],[10,21,25,65],
 [10,21,25,67],[10,21,25,69],[10,21,26,30],
 [10,21,26,34],[10,21,26,35],[10,21,26,37],
 [10,21,26,41],[10,21,26,44],[10,21,26,45],
 [10,21,26,46],[10,21,26,47],[10,21,26,48],
 [10,21,26,49],[10,21,26,51],[10,21,26,62],
 [10,21,26,67],[10,21,26,69],[10,21,29,37],
 [10,21,29,42],[10,21,29,48],[10,21,29,49],
 [10,21,29,53],[10,21,29,59],[10,21,29,61],
 [10,21,29,65],[10,21,29,67],[10,21,29,69],
 [10,21,30,35],[10,21,30,48],[10,21,30,53],
 [10,21,30,59],[10,21,30,62],[10,21,30,67],
 [10,21,33,36],[10,21,33,37],[10,21,33,42],
 [10,21,33,45],[10,21,33,48],[10,21,33,49],
 [10,21,33,59],[10,21,33,62],[10,21,33,65],
 [10,21,33,67],[10,21,33,69],[10,21,34,41],
 [10,21,34,44],[10,21,34,45],[10,21,34,46],
 [10,21,34,48],[10,21,34,49],[10,21,34,59],
 [10,21,34,61],[10,21,34,62],[10,21,34,67],
 [10,21,34,69],[10,21,35,37],[10,21,35,45],
 [10,21,35,47],[10,21,35,48],[10,21,35,49],
 [10,21,35,59],[10,21,35,62],[10,21,35,67],
 [10,21,36,37],[10,21,36,45],[10,21,36,48],
 [10,21,36,49],[10,21,36,62],[10,21,36,69],
 [10,21,37,38],[10,21,37,42],[10,21,37,44],
 [10,21,37,45],[10,21,37,46],[10,21,37,47],
 [10,21,37,48],[10,21,37,59],[10,21,37,61],
 [10,21,37,62],[10,21,37,67],[10,21,38,48],
 [10,21,38,49],[10,21,38,53],[10,21,38,59],
 [10,21,38,61],[10,21,38,65],[10,21,38,67],
 [10,21,38,69],[10,21,41,42],[10,21,41,44],
 [10,21,41,46],[10,21,41,47],[10,21,41,48],
 [10,21,41,49],[10,21,41,53],[10,21,41,59],
 [10,21,41,61],[10,21,41,65],[10,21,41,67],
 [10,21,41,69],[10,21,42,46],[10,21,42,59],
 [10,21,42,62],[10,21,42,65],[10,21,44,45],
 [10,21,44,46],[10,21,44,47],[10,21,44,48],
 [10,21,44,49],[10,21,44,51],[10,21,44,59],
 [10,21,44,62],[10,21,44,65],[10,21,44,69],
 [10,21,45,46],[10,21,45,47],[10,21,45,48],
 [10,21,45,49],[10,21,45,51],[10,21,45,53],
 [10,21,45,61],[10,21,45,62],[10,21,45,65],
 [10,21,45,67],[10,21,45,69],[10,21,46,48],
 [10,21,46,49],[10,21,46,53],[10,21,46,59],
 [10,21,46,61],[10,21,46,62],[10,21,46,65],
 [10,21,46,67],[10,21,46,69],[10,21,47,48],
 [10,21,47,49],[10,21,47,53],[10,21,47,59],
 [10,21,47,61],[10,21,47,62],[10,21,47,65],
 [10,21,47,67],[10,21,47,69],[10,21,48,49],
 [10,21,48,51],[10,21,48,53],[10,21,48,59],
 [10,21,48,61],[10,21,48,62],[10,21,48,67],
 [10,21,48,69],[10,21,49,59],[10,21,49,61],
 [10,21,49,62],[10,21,49,67],[10,21,49,69],
 [10,21,51,53],[10,21,51,62],[10,21,51,67],
 [10,21,53,62],[10,21,59,65],[10,21,59,67],
 [10,21,59,69],[10,21,61,62],[10,21,61,69],
 [10,21,62,65],[10,21,62,67],[10,21,62,69],
 [10,21,67,69],[10,23,25,26],[10,23,25,27],
 [10,23,25,32],[10,23,25,35],[10,23,25,37],
 [10,23,25,41],[10,23,25,42],[10,23,25,44],
 [10,23,25,45],[10,23,25,47],[10,23,25,48],
 [10,23,25,49],[10,23,25,53],[10,23,25,57],
 [10,23,25,59],[10,23,25,61],[10,23,25,62],
 [10,23,25,65],[10,23,25,66],[10,23,25,67],
 [10,23,25,68],[10,23,25,69],[10,23,26,27],
 [10,23,26,30],[10,23,26,35],[10,23,26,36],
 [10,23,26,37],[10,23,26,41],[10,23,26,44],
 [10,23,26,45],[10,23,26,47],[10,23,26,48],
 [10,23,26,49],[10,23,26,55],[10,23,26,56],
 [10,23,26,57],[10,23,26,58],[10,23,26,62],
 [10,23,26,66],[10,23,26,67],[10,23,26,68],
 [10,23,26,69],[10,23,27,30],[10,23,27,32],
 [10,23,27,35],[10,23,27,36],[10,23,27,41],
 [10,23,27,42],[10,23,27,44],[10,23,27,47],
 [10,23,27,48],[10,23,27,49],[10,23,27,53],
 [10,23,27,55],[10,23,27,56],[10,23,27,58],
 [10,23,27,59],[10,23,27,61],[10,23,27,65],
 [10,23,27,66],[10,23,27,67],[10,23,27,68],
 [10,23,27,69],[10,23,30,35],[10,23,30,41],
 [10,23,30,44],[10,23,30,45],[10,23,30,48],
 [10,23,30,49],[10,23,30,53],[10,23,30,58],
 [10,23,30,59],[10,23,30,61],[10,23,30,62],
 [10,23,30,67],[10,23,30,68],[10,23,32,41],
 [10,23,32,44],[10,23,32,47],[10,23,32,49],
 [10,23,32,58],[10,23,32,59],[10,23,32,62],
 [10,23,32,68],[10,23,35,37],[10,23,35,41],
 [10,23,35,45],[10,23,35,47],[10,23,35,48],
 [10,23,35,49],[10,23,35,55],[10,23,35,57],
 [10,23,35,58],[10,23,35,59],[10,23,35,62],
 [10,23,35,66],[10,23,35,67],[10,23,35,68],
 [10,23,35,69],[10,23,36,37],[10,23,36,48],
 [10,23,36,49],[10,23,36,55],[10,23,36,57],
 [10,23,36,62],[10,23,36,65],[10,23,36,66],
 [10,23,36,68],[10,23,36,69],[10,23,37,42],
 [10,23,37,44],[10,23,37,45],[10,23,37,47],
 [10,23,37,48],[10,23,37,56],[10,23,37,59],
 [10,23,37,61],[10,23,37,62],[10,23,37,67],
 [10,23,37,68],[10,23,41,42],[10,23,41,44],
 [10,23,41,47],[10,23,41,48],[10,23,41,49],
 [10,23,41,53],[10,23,41,55],[10,23,41,56],
 [10,23,41,58],[10,23,41,59],[10,23,41,61],
 [10,23,41,65],[10,23,41,66],[10,23,41,67],
 [10,23,41,68],[10,23,41,69],[10,23,42,47],
 [10,23,42,49],[10,23,42,55],[10,23,42,59],
 [10,23,42,62],[10,23,42,65],[10,23,42,66],
 [10,23,42,68],[10,23,44,45],[10,23,44,47],
 [10,23,44,48],[10,23,44,49],[10,23,44,55],
 [10,23,44,57],[10,23,44,59],[10,23,44,62],
 [10,23,44,65],[10,23,44,66],[10,23,44,68],
 [10,23,44,69],[10,23,45,47],[10,23,45,48],
 [10,23,45,49],[10,23,45,53],[10,23,45,58],
 [10,23,45,61],[10,23,45,62],[10,23,45,65],
 [10,23,45,66],[10,23,45,67],[10,23,45,69],
 [10,23,47,48],[10,23,47,49],[10,23,47,53],
 [10,23,47,55],[10,23,47,57],[10,23,47,58],
 [10,23,47,59],[10,23,47,61],[10,23,47,62],
 [10,23,47,65],[10,23,47,66],[10,23,47,67],
 [10,23,47,68],[10,23,47,69],[10,23,48,49],
 [10,23,48,53],[10,23,48,55],[10,23,48,56],
 [10,23,48,57],[10,23,48,58],[10,23,48,59],
 [10,23,48,61],[10,23,48,62],[10,23,48,66],
 [10,23,48,67],[10,23,48,68],[10,23,48,69],
 [10,23,49,53],[10,23,49,55],[10,23,49,56],
 [10,23,49,58],[10,23,49,59],[10,23,49,61],
 [10,23,49,62],[10,23,49,65],[10,23,49,66],
 [10,23,49,67],[10,23,49,68],[10,23,49,69],
 [10,23,53,56],[10,23,53,58],[10,23,53,62],
 [10,23,53,68],[10,23,55,59],[10,23,55,61],
 [10,23,55,62],[10,23,55,66],[10,23,55,67],
 [10,23,55,68],[10,23,55,69],[10,23,56,57],
 [10,23,56,62],[10,23,56,66],[10,23,56,68],
 [10,23,56,69],[10,23,57,58],[10,23,57,59],
 [10,23,57,61],[10,23,57,67],[10,23,57,68],
 [10,23,58,59],[10,23,58,62],[10,23,58,65],
 [10,23,58,66],[10,23,58,67],[10,23,58,68],
 [10,23,58,69],[10,23,59,66],[10,23,59,67],
 [10,23,59,68],[10,23,59,69],[10,23,61,62],
 [10,23,61,66],[10,23,61,68],[10,23,61,69],
 [10,23,62,65],[10,23,62,67],[10,23,62,69],
 [10,23,65,68],[10,23,66,67],[10,23,66,68],
 [10,23,66,69],[10,23,67,68],[10,23,67,69],
 [10,23,68,69],[10,25,26,27],[10,25,26,34],
 [10,25,26,35],[10,25,26,37],[10,25,26,39],
 [10,25,26,41],[10,25,26,44],[10,25,26,45],
 [10,25,26,46],[10,25,26,47],[10,25,26,48],
 [10,25,26,49],[10,25,26,51],[10,25,26,54],
 [10,25,26,57],[10,25,26,62],[10,25,26,66],
 [10,25,26,67],[10,25,26,68],[10,25,26,69],
 [10,25,27,28],[10,25,27,32],[10,25,27,33],
 [10,25,27,34],[10,25,27,35],[10,25,27,36],
 [10,25,27,37],[10,25,27,39],[10,25,27,41],
 [10,25,27,42],[10,25,27,44],[10,25,27,46],
 [10,25,27,47],[10,25,27,48],[10,25,27,49],
 [10,25,27,51],[10,25,27,53],[10,25,27,54],
 [10,25,27,59],[10,25,27,61],[10,25,27,65],
 [10,25,27,66],[10,25,27,67],[10,25,27,68],
 [10,25,27,69],[10,25,28,49],[10,25,28,57],
 [10,25,28,61],[10,25,28,68],[10,25,32,39],
 [10,25,32,41],[10,25,32,44],[10,25,32,46],
 [10,25,32,47],[10,25,32,49],[10,25,32,51],
 [10,25,32,62],[10,25,32,68],[10,25,33,36],
 [10,25,33,37],[10,25,33,45],[10,25,33,48],
 [10,25,33,49],[10,25,33,57],[10,25,33,59],
 [10,25,33,62],[10,25,33,65],[10,25,33,66],
 [10,25,33,68],[10,25,33,69],[10,25,34,39],
 [10,25,34,41],[10,25,34,44],[10,25,34,45],
 [10,25,34,46],[10,25,34,48],[10,25,34,49],
 [10,25,34,59],[10,25,34,61],[10,25,34,62],
 [10,25,34,67],[10,25,34,68],[10,25,34,69],
 [10,25,35,37],[10,25,35,41],[10,25,35,45],
 [10,25,35,47],[10,25,35,48],[10,25,35,49],
 [10,25,35,57],[10,25,35,59],[10,25,35,62],
 [10,25,35,66],[10,25,35,67],[10,25,35,68],
 [10,25,35,69],[10,25,36,37],[10,25,36,45],
 [10,25,36,48],[10,25,36,49],[10,25,36,54],
 [10,25,36,57],[10,25,36,62],[10,25,36,65],
 [10,25,36,66],[10,25,36,68],[10,25,36,69],
 [10,25,37,42],[10,25,37,44],[10,25,37,45],
 [10,25,37,46],[10,25,37,47],[10,25,37,48],
 [10,25,37,54],[10,25,37,59],[10,25,37,61],
 [10,25,37,62],[10,25,37,67],[10,25,37,68],
 [10,25,39,41],[10,25,39,45],[10,25,39,46],
 [10,25,39,47],[10,25,39,48],[10,25,39,59],
 [10,25,39,65],[10,25,39,66],[10,25,39,67],
 [10,25,39,68],[10,25,39,69],[10,25,41,42],
 [10,25,41,44],[10,25,41,46],[10,25,41,47],
 [10,25,41,48],[10,25,41,49],[10,25,41,53],
 [10,25,41,54],[10,25,41,59],[10,25,41,61],
 [10,25,41,65],[10,25,41,66],[10,25,41,67],
 [10,25,41,68],[10,25,41,69],[10,25,42,46],
 [10,25,42,47],[10,25,42,49],[10,25,42,51],
 [10,25,42,59],[10,25,42,62],[10,25,42,65],
 [10,25,42,66],[10,25,42,68],[10,25,44,45],
 [10,25,44,46],[10,25,44,47],[10,25,44,48],
 [10,25,44,49],[10,25,44,51],[10,25,44,54],
 [10,25,44,57],[10,25,44,59],[10,25,44,62],
 [10,25,44,66],[10,25,44,68],[10,25,44,69],
 [10,25,45,46],[10,25,45,47],[10,25,45,48],
 [10,25,45,49],[10,25,45,51],[10,25,45,53],
 [10,25,45,54],[10,25,45,61],[10,25,45,62],
 [10,25,45,65],[10,25,45,66],[10,25,45,67],
 [10,25,45,69],[10,25,46,48],[10,25,46,49],
 [10,25,46,53],[10,25,46,57],[10,25,46,59],
 [10,25,46,61],[10,25,46,62],[10,25,46,65],
 [10,25,46,67],[10,25,46,68],[10,25,46,69],
 [10,25,47,48],[10,25,47,49],[10,25,47,53],
 [10,25,47,57],[10,25,47,59],[10,25,47,61],
 [10,25,47,62],[10,25,47,65],[10,25,47,66],
 [10,25,47,67],[10,25,47,68],[10,25,47,69],
 [10,25,48,49],[10,25,48,51],[10,25,48,53],
 [10,25,48,57],[10,25,48,59],[10,25,48,61],
 [10,25,48,62],[10,25,48,66],[10,25,48,67],
 [10,25,48,68],[10,25,48,69],[10,25,49,53],
 [10,25,49,54],[10,25,49,57],[10,25,49,59],
 [10,25,49,61],[10,25,49,62],[10,25,49,65],
 [10,25,49,66],[10,25,49,67],[10,25,49,68],
 [10,25,49,69],[10,25,51,53],[10,25,51,57],
 [10,25,51,61],[10,25,51,62],[10,25,51,65],
 [10,25,51,66],[10,25,51,67],[10,25,51,68],
 [10,25,51,69],[10,25,53,54],[10,25,53,62],
 [10,25,53,68],[10,25,54,57],[10,25,54,61],
 [10,25,54,62],[10,25,54,66],[10,25,54,67],
 [10,25,54,68],[10,25,54,69],[10,25,57,59],
 [10,25,57,61],[10,25,57,67],[10,25,59,65],
 [10,25,59,66],[10,25,59,67],[10,25,59,68],
 [10,25,59,69],[10,25,61,62],[10,25,61,66],
 [10,25,61,68],[10,25,61,69],[10,25,62,65],
 [10,25,62,67],[10,25,62,69],[10,25,65,68],
 [10,25,66,67],[10,25,66,68],[10,25,66,69],
 [10,25,67,68],[10,25,67,69],[10,25,68,69],
 [10,26,27,28],[10,26,27,34],[10,26,27,35],
 [10,26,27,36],[10,26,27,39],[10,26,27,41],
 [10,26,27,44],[10,26,27,46],[10,26,27,47],
 [10,26,27,48],[10,26,27,49],[10,26,27,51],
 [10,26,27,54],[10,26,27,55],[10,26,27,56],
 [10,26,27,58],[10,26,27,66],[10,26,27,67],
 [10,26,27,68],[10,26,27,69],[10,26,28,41],
 [10,26,28,44],[10,26,28,47],[10,26,28,49],
 [10,26,28,55],[10,26,28,56],[10,26,28,57],
 [10,26,28,58],[10,26,28,68],[10,26,29,32],
 [10,26,29,41],[10,26,29,47],[10,26,29,49],
 [10,26,29,68],[10,26,30,35],[10,26,30,41],
 [10,26,30,44],[10,26,30,45],[10,26,30,48],
 [10,26,30,49],[10,26,30,62],[10,26,30,68],
 [10,26,32,39],[10,26,32,41],[10,26,32,44],
 [10,26,32,46],[10,26,32,47],[10,26,32,49],
 [10,26,32,51],[10,26,32,62],[10,26,32,68],
 [10,26,34,39],[10,26,34,41],[10,26,34,44],
 [10,26,34,45],[10,26,34,46],[10,26,34,48],
 [10,26,34,49],[10,26,34,56],[10,26,34,58],
 [10,26,34,62],[10,26,34,67],[10,26,34,68],
 [10,26,34,69],[10,26,35,37],[10,26,35,41],
 [10,26,35,45],[10,26,35,47],[10,26,35,48],
 [10,26,35,49],[10,26,35,55],[10,26,35,57],
 [10,26,35,58],[10,26,35,62],[10,26,35,66],
 [10,26,35,67],[10,26,35,68],[10,26,35,69],
 [10,26,36,37],[10,26,36,45],[10,26,36,48],
 [10,26,36,49],[10,26,36,54],[10,26,36,55],
 [10,26,36,57],[10,26,36,62],[10,26,36,63],
 [10,26,36,65],[10,26,36,66],[10,26,36,68],
 [10,26,36,69],[10,26,37,38],[10,26,37,42],
 [10,26,37,44],[10,26,37,45],[10,26,37,46],
 [10,26,37,47],[10,26,37,48],[10,26,37,54],
 [10,26,37,56],[10,26,37,62],[10,26,37,67],
 [10,26,37,68],[10,26,38,41],[10,26,38,42],
 [10,26,38,44],[10,26,38,47],[10,26,38,49],
 [10,26,38,55],[10,26,38,63],[10,26,38,65],
 [10,26,38,66],[10,26,38,68],[10,26,39,41],
 [10,26,39,45],[10,26,39,46],[10,26,39,47],
 [10,26,39,48],[10,26,39,55],[10,26,39,58],
 [10,26,39,63],[10,26,39,65],[10,26,39,66],
 [10,26,39,67],[10,26,39,68],[10,26,39,69],
 [10,26,41,42],[10,26,41,44],[10,26,41,46],
 [10,26,41,47],[10,26,41,48],[10,26,41,49],
 [10,26,41,54],[10,26,41,55],[10,26,41,56],
 [10,26,41,57],[10,26,41,58],[10,26,41,63],
 [10,26,41,65],[10,26,41,66],[10,26,41,67],
 [10,26,41,68],[10,26,41,69],[10,26,42,46],
 [10,26,42,47],[10,26,42,49],[10,26,42,51],
 [10,26,42,55],[10,26,42,62],[10,26,42,63],
 [10,26,42,65],[10,26,42,66],[10,26,42,68],
 [10,26,44,45],[10,26,44,46],[10,26,44,47],
 [10,26,44,48],[10,26,44,49],[10,26,44,51],
 [10,26,44,54],[10,26,44,55],[10,26,44,57],
 [10,26,44,62],[10,26,44,63],[10,26,44,65],
 [10,26,44,66],[10,26,44,68],[10,26,44,69],
 [10,26,45,46],[10,26,45,47],[10,26,45,48],
 [10,26,45,49],[10,26,45,51],[10,26,45,58],
 [10,26,45,62],[10,26,45,66],[10,26,45,67],
 [10,26,45,69],[10,26,46,48],[10,26,46,49],
 [10,26,46,56],[10,26,46,57],[10,26,46,58],
 [10,26,46,62],[10,26,46,63],[10,26,46,65],
 [10,26,46,67],[10,26,46,68],[10,26,46,69],
 [10,26,47,48],[10,26,47,49],[10,26,47,54],
 [10,26,47,55],[10,26,47,56],[10,26,47,57],
 [10,26,47,58],[10,26,47,62],[10,26,47,63],
 [10,26,47,65],[10,26,47,66],[10,26,47,67],
 [10,26,47,68],[10,26,47,69],[10,26,48,49],
 [10,26,48,51],[10,26,48,55],[10,26,48,56],
 [10,26,48,57],[10,26,48,58],[10,26,48,62],
 [10,26,48,66],[10,26,48,67],[10,26,48,68],
 [10,26,48,69],[10,26,49,54],[10,26,49,55],
 [10,26,49,56],[10,26,49,57],[10,26,49,58],
 [10,26,49,62],[10,26,49,63],[10,26,49,65],
 [10,26,49,66],[10,26,49,67],[10,26,49,68],
 [10,26,49,69],[10,26,51,56],[10,26,51,57],
 [10,26,51,58],[10,26,51,62],[10,26,51,63],
 [10,26,51,65],[10,26,51,66],[10,26,51,67],
 [10,26,51,68],[10,26,51,69],[10,26,54,56],
 [10,26,54,57],[10,26,54,62],[10,26,54,66],
 [10,26,54,67],[10,26,54,68],[10,26,54,69],
 [10,26,55,62],[10,26,55,66],[10,26,55,67],
 [10,26,55,68],[10,26,55,69],[10,26,56,57],
 [10,26,56,62],[10,26,56,66],[10,26,56,68],
 [10,26,56,69],[10,26,57,58],[10,26,57,67],
 [10,26,57,68],[10,26,58,62],[10,26,58,65],
 [10,26,58,66],[10,26,58,67],[10,26,58,68],
 [10,26,58,69],[10,26,62,63],[10,26,62,65],
 [10,26,62,67],[10,26,62,69],[10,26,63,65],
 [10,26,63,68],[10,26,65,68],[10,26,66,67],
 [10,26,66,68],[10,26,66,69],[10,26,67,68],
 [10,26,67,69],[10,26,68,69],[10,27,28,33],
 [10,27,28,44],[10,27,28,47],[10,27,28,48],
 [10,27,28,55],[10,27,28,56],[10,27,28,58],
 [10,27,28,61],[10,27,28,68],[10,27,30,35],
 [10,27,30,48],[10,27,30,49],[10,27,30,53],
 [10,27,30,61],[10,27,32,39],[10,27,32,41],
 [10,27,32,44],[10,27,32,46],[10,27,32,47],
 [10,27,32,49],[10,27,32,51],[10,27,32,68],
 [10,27,33,36],[10,27,33,37],[10,27,33,42],
 [10,27,33,44],[10,27,33,47],[10,27,33,48],
 [10,27,33,56],[10,27,33,59],[10,27,33,67],
 [10,27,33,68],[10,27,34,39],[10,27,34,41],
 [10,27,34,44],[10,27,34,46],[10,27,34,48],
 [10,27,34,49],[10,27,34,56],[10,27,34,58],
 [10,27,34,59],[10,27,34,61],[10,27,34,67],
 [10,27,34,68],[10,27,34,69],[10,27,35,37],
 [10,27,35,41],[10,27,35,47],[10,27,35,48],
 [10,27,35,49],[10,27,35,55],[10,27,35,58],
 [10,27,35,59],[10,27,35,66],[10,27,35,67],
 [10,27,35,68],[10,27,35,69],[10,27,36,37],
 [10,27,36,48],[10,27,36,49],[10,27,36,54],
 [10,27,36,55],[10,27,36,65],[10,27,36,66],
 [10,27,36,68],[10,27,36,69],[10,27,37,42],
 [10,27,37,44],[10,27,37,46],[10,27,37,47],
 [10,27,37,48],[10,27,37,54],[10,27,37,56],
 [10,27,37,59],[10,27,37,61],[10,27,37,67],
 [10,27,37,68],[10,27,39,41],[10,27,39,46],
 [10,27,39,47],[10,27,39,48],[10,27,39,53],
 [10,27,39,55],[10,27,39,58],[10,27,39,59],
 [10,27,39,65],[10,27,39,66],[10,27,39,67],
 [10,27,39,68],[10,27,39,69],[10,27,41,42],
 [10,27,41,44],[10,27,41,46],[10,27,41,47],
 [10,27,41,48],[10,27,41,49],[10,27,41,53],
 [10,27,41,54],[10,27,41,55],[10,27,41,58],
 [10,27,41,59],[10,27,41,61],[10,27,41,65],
 [10,27,41,66],[10,27,41,67],[10,27,41,68],
 [10,27,41,69],[10,27,42,46],[10,27,42,47],
 [10,27,42,49],[10,27,42,51],[10,27,42,55],
 [10,27,42,59],[10,27,42,65],[10,27,42,66],
 [10,27,42,68],[10,27,44,46],[10,27,44,47],
 [10,27,44,48],[10,27,44,49],[10,27,44,54],
 [10,27,44,55],[10,27,44,59],[10,27,44,66],
 [10,27,44,68],[10,27,44,69],[10,27,46,48],
 [10,27,46,49],[10,27,46,53],[10,27,46,56],
 [10,27,46,58],[10,27,46,59],[10,27,46,61],
 [10,27,46,65],[10,27,46,67],[10,27,46,68],
 [10,27,46,69],[10,27,47,48],[10,27,47,49],
 [10,27,47,53],[10,27,47,54],[10,27,47,55],
 [10,27,47,56],[10,27,47,58],[10,27,47,59],
 [10,27,47,61],[10,27,47,65],[10,27,47,66],
 [10,27,47,67],[10,27,47,68],[10,27,47,69],
 [10,27,48,49],[10,27,48,51],[10,27,48,53],
 [10,27,48,55],[10,27,48,56],[10,27,48,58],
 [10,27,48,59],[10,27,48,61],[10,27,48,66],
 [10,27,48,67],[10,27,48,68],[10,27,48,69],
 [10,27,49,53],[10,27,49,55],[10,27,49,56],
 [10,27,49,58],[10,27,49,59],[10,27,49,61],
 [10,27,49,65],[10,27,49,66],[10,27,49,67],
 [10,27,49,68],[10,27,49,69],[10,27,51,53],
 [10,27,51,56],[10,27,51,61],[10,27,51,65],
 [10,27,51,66],[10,27,51,67],[10,27,51,68],
 [10,27,51,69],[10,27,53,54],[10,27,53,56],
 [10,27,53,58],[10,27,53,68],[10,27,54,56],
 [10,27,54,61],[10,27,54,67],[10,27,54,68],
 [10,27,54,69],[10,27,55,59],[10,27,55,61],
 [10,27,55,66],[10,27,55,67],[10,27,55,68],
 [10,27,55,69],[10,27,56,59],[10,27,56,66],
 [10,27,56,69],[10,27,58,59],[10,27,58,65],
 [10,27,58,66],[10,27,58,67],[10,27,58,68],
 [10,27,58,69],[10,27,59,65],[10,27,59,66],
 [10,27,59,67],[10,27,59,68],[10,27,59,69],
 [10,27,61,66],[10,27,61,68],[10,27,61,69],
 [10,27,65,68],[10,27,66,67],[10,27,66,68],
 [10,27,66,69],[10,27,67,68],[10,27,67,69],
 [10,27,68,69],[10,28,33,41],[10,28,33,44],
 [10,28,33,47],[10,28,33,48],[10,28,33,49],
 [10,28,33,55],[10,28,33,57],[10,28,33,58],
 [10,28,33,59],[10,28,33,68],[10,28,41,44],
 [10,28,41,47],[10,28,41,49],[10,28,41,55],
 [10,28,41,56],[10,28,41,57],[10,28,41,59],
 [10,28,41,61],[10,28,41,68],[10,28,44,47],
 [10,28,44,49],[10,28,44,59],[10,28,44,68],
 [10,28,47,49],[10,28,47,55],[10,28,47,56],
 [10,28,47,57],[10,28,47,58],[10,28,47,59],
 [10,28,47,61],[10,28,47,68],[10,28,48,49],
 [10,28,48,55],[10,28,48,56],[10,28,48,57],
 [10,28,48,58],[10,28,48,59],[10,28,48,61],
 [10,28,48,68],[10,28,49,55],[10,28,49,56],
 [10,28,49,57],[10,28,49,58],[10,28,49,59],
 [10,28,49,61],[10,28,49,68],[10,28,55,68],
 [10,28,56,57],[10,28,56,68],[10,28,57,58],
 [10,28,57,59],[10,28,57,68],[10,28,58,68],
 [10,28,59,68],[10,28,61,68],[10,29,32,41],
 [10,29,32,47],[10,29,32,49],[10,29,32,59],
 [10,29,32,68],[10,29,36,37],[10,29,36,48],
 [10,29,36,49],[10,29,36,65],[10,29,36,68],
 [10,29,36,69],[10,29,37,42],[10,29,37,45],
 [10,29,37,47],[10,29,37,48],[10,29,37,61],
 [10,29,37,67],[10,29,37,68],[10,29,41,42],
 [10,29,41,47],[10,29,41,48],[10,29,41,49],
 [10,29,41,53],[10,29,41,59],[10,29,41,61],
 [10,29,41,65],[10,29,41,67],[10,29,41,68],
 [10,29,41,69],[10,29,42,47],[10,29,42,49],
 [10,29,42,59],[10,29,42,65],[10,29,42,68],
 [10,29,45,48],[10,29,45,49],[10,29,45,53],
 [10,29,45,61],[10,29,45,67],[10,29,45,69],
 [10,29,47,48],[10,29,47,49],[10,29,47,53],
 [10,29,47,59],[10,29,47,61],[10,29,47,65],
 [10,29,47,67],[10,29,47,68],[10,29,47,69],
 [10,29,48,49],[10,29,48,53],[10,29,48,61],
 [10,29,48,67],[10,29,48,68],[10,29,48,69],
 [10,29,49,53],[10,29,49,59],[10,29,49,61],
 [10,29,49,65],[10,29,49,67],[10,29,49,68],
 [10,29,49,69],[10,29,53,68],[10,29,59,65],
 [10,29,59,67],[10,29,59,68],[10,29,59,69],
 [10,29,61,68],[10,29,61,69],[10,29,65,68],
 [10,29,67,68],[10,29,67,69],[10,29,68,69],
 [10,30,35,41],[10,30,35,48],[10,30,35,49],
 [10,30,35,58],[10,30,35,59],[10,30,35,67],
 [10,30,35,68],[10,30,41,44],[10,30,41,49],
 [10,30,41,53],[10,30,41,59],[10,30,41,61],
 [10,30,41,68],[10,30,44,48],[10,30,44,49],
 [10,30,44,59],[10,30,44,68],[10,30,45,48],
 [10,30,45,62],[10,30,45,67],[10,30,48,58],
 [10,30,48,67],[10,30,48,68],[10,30,49,53],
 [10,30,49,59],[10,30,49,61],[10,30,49,67],
 [10,30,49,68],[10,30,53,58],[10,30,53,62],
 [10,30,53,68],[10,30,58,62],[10,30,58,67],
 [10,30,59,68],[10,30,61,68],[10,30,62,67],
 [10,32,33,41],[10,32,33,47],[10,32,33,49],
 [10,32,33,62],[10,32,33,68],[10,32,38,41],
 [10,32,38,44],[10,32,38,47],[10,32,38,49],
 [10,32,38,63],[10,32,38,68],[10,32,39,46],
 [10,32,39,63],[10,32,41,44],[10,32,41,46],
 [10,32,41,47],[10,32,41,49],[10,32,41,59],
 [10,32,41,63],[10,32,41,68],[10,32,44,46],
 [10,32,44,47],[10,32,44,49],[10,32,44,59],
 [10,32,44,68],[10,32,46,49],[10,32,46,58],
 [10,32,46,62],[10,32,46,63],[10,32,46,68],
 [10,32,47,49],[10,32,47,58],[10,32,47,59],
 [10,32,47,62],[10,32,47,63],[10,32,47,68],
 [10,32,49,59],[10,32,49,62],[10,32,49,63],
 [10,32,49,68],[10,32,51,58],[10,32,51,62],
 [10,32,51,63],[10,32,51,68],[10,32,58,62],
 [10,32,59,68],[10,32,62,63],[10,32,63,68],
 [10,33,36,37],[10,33,36,45],[10,33,36,48],
 [10,33,36,49],[10,33,36,55],[10,33,36,57],
 [10,33,36,62],[10,33,36,65],[10,33,36,66],
 [10,33,36,68],[10,33,36,69],[10,33,37,42],
 [10,33,37,44],[10,33,37,45],[10,33,37,47],
 [10,33,37,48],[10,33,37,56],[10,33,37,59],
 [10,33,37,62],[10,33,37,67],[10,33,37,68],
 [10,33,41,42],[10,33,41,44],[10,33,41,47],
 [10,33,41,48],[10,33,41,49],[10,33,41,55],
 [10,33,41,56],[10,33,41,57],[10,33,41,58],
 [10,33,41,59],[10,33,41,65],[10,33,41,66],
 [10,33,41,67],[10,33,41,68],[10,33,41,69],
 [10,33,42,47],[10,33,42,49],[10,33,42,55],
 [10,33,42,62],[10,33,42,65],[10,33,42,66],
 [10,33,42,68],[10,33,44,45],[10,33,44,47],
 [10,33,44,48],[10,33,44,49],[10,33,44,55],
 [10,33,44,57],[10,33,44,59],[10,33,44,62],
 [10,33,44,65],[10,33,44,66],[10,33,44,68],
 [10,33,44,69],[10,33,45,47],[10,33,45,48],
 [10,33,45,49],[10,33,45,58],[10,33,45,62],
 [10,33,45,66],[10,33,45,67],[10,33,45,69],
 [10,33,47,48],[10,33,47,49],[10,33,47,55],
 [10,33,47,56],[10,33,47,57],[10,33,47,58],
 [10,33,47,59],[10,33,47,62],[10,33,47,65],
 [10,33,47,66],[10,33,47,67],[10,33,47,68],
 [10,33,47,69],[10,33,48,49],[10,33,48,56],
 [10,33,48,57],[10,33,48,58],[10,33,48,59],
 [10,33,48,62],[10,33,48,66],[10,33,48,67],
 [10,33,48,68],[10,33,48,69],[10,33,49,56],
 [10,33,49,57],[10,33,49,58],[10,33,49,59],
 [10,33,49,62],[10,33,49,65],[10,33,49,66],
 [10,33,49,67],[10,33,49,68],[10,33,49,69],
 [10,33,55,62],[10,33,55,67],[10,33,55,68],
 [10,33,55,69],[10,33,56,57],[10,33,56,59],
 [10,33,56,62],[10,33,56,66],[10,33,56,68],
 [10,33,56,69],[10,33,57,59],[10,33,57,67],
 [10,33,57,68],[10,33,58,62],[10,33,58,65],
 [10,33,58,67],[10,33,58,68],[10,33,58,69],
 [10,33,59,65],[10,33,59,67],[10,33,59,68],
 [10,33,59,69],[10,33,62,65],[10,33,62,67],
 [10,33,62,69],[10,33,65,68],[10,33,66,67],
 [10,33,66,68],[10,33,66,69],[10,33,67,68],
 [10,33,67,69],[10,33,68,69],[10,34,39,41],
 [10,34,39,45],[10,34,39,46],[10,34,39,48],
 [10,34,39,58],[10,34,39,59],[10,34,39,63],
 [10,34,39,67],[10,34,39,68],[10,34,39,69],
 [10,34,41,44],[10,34,41,46],[10,34,41,48],
 [10,34,41,49],[10,34,41,58],[10,34,41,59],
 [10,34,41,61],[10,34,41,63],[10,34,41,67],
 [10,34,41,68],[10,34,41,69],[10,34,44,45],
 [10,34,44,46],[10,34,44,48],[10,34,44,49],
 [10,34,44,59],[10,34,44,62],[10,34,44,68],
 [10,34,44,69],[10,34,45,46],[10,34,45,48],
 [10,34,45,49],[10,34,45,58],[10,34,45,61],
 [10,34,45,62],[10,34,45,63],[10,34,45,67],
 [10,34,45,69],[10,34,46,48],[10,34,46,49],
 [10,34,46,56],[10,34,46,58],[10,34,46,59],
 [10,34,46,61],[10,34,46,62],[10,34,46,63],
 [10,34,46,67],[10,34,46,68],[10,34,46,69],
 [10,34,48,49],[10,34,48,56],[10,34,48,58],
 [10,34,48,59],[10,34,48,61],[10,34,48,62],
 [10,34,48,63],[10,34,48,67],[10,34,48,68],
 [10,34,48,69],[10,34,49,56],[10,34,49,58],
 [10,34,49,59],[10,34,49,61],[10,34,49,62],
 [10,34,49,63],[10,34,49,67],[10,34,49,68],
 [10,34,49,69],[10,34,56,62],[10,34,56,69],
 [10,34,58,59],[10,34,58,62],[10,34,58,67],
 [10,34,58,68],[10,34,58,69],[10,34,59,67],
 [10,34,59,68],[10,34,59,69],[10,34,61,62],
 [10,34,61,63],[10,34,61,68],[10,34,61,69],
 [10,34,62,63],[10,34,62,67],[10,34,62,69],
 [10,34,63,67],[10,34,63,68],[10,34,63,69],
 [10,34,67,68],[10,34,67,69],[10,34,68,69],
 [10,35,37,45],[10,35,37,47],[10,35,37,48],
 [10,35,37,59],[10,35,37,62],[10,35,37,67],
 [10,35,37,68],[10,35,41,47],[10,35,41,48],
 [10,35,41,49],[10,35,41,57],[10,35,41,59],
 [10,35,41,66],[10,35,41,67],[10,35,41,68],
 [10,35,41,69],[10,35,45,47],[10,35,45,48],
 [10,35,45,58],[10,35,45,62],[10,35,45,67],
 [10,35,47,48],[10,35,47,49],[10,35,47,57],
 [10,35,47,59],[10,35,47,62],[10,35,47,66],
 [10,35,47,67],[10,35,47,68],[10,35,47,69],
 [10,35,48,49],[10,35,48,55],[10,35,48,57],
 [10,35,48,58],[10,35,48,62],[10,35,48,66],
 [10,35,48,67],[10,35,48,68],[10,35,48,69],
 [10,35,49,55],[10,35,49,58],[10,35,49,59],
 [10,35,49,66],[10,35,49,67],[10,35,49,68],
 [10,35,49,69],[10,35,55,59],[10,35,55,66],
 [10,35,55,67],[10,35,55,68],[10,35,55,69],
 [10,35,57,58],[10,35,57,59],[10,35,57,67],
 [10,35,57,68],[10,35,58,59],[10,35,58,62],
 [10,35,58,66],[10,35,58,67],[10,35,58,68],
 [10,35,58,69],[10,35,59,66],[10,35,59,67],
 [10,35,59,68],[10,35,59,69],[10,35,62,67],
 [10,35,66,67],[10,35,66,68],[10,35,66,69],
 [10,35,67,68],[10,35,67,69],[10,35,68,69],
 [10,36,37,38],[10,36,37,45],[10,36,37,48],
 [10,36,37,54],[10,36,37,62],[10,36,37,63],
 [10,36,37,68],[10,36,38,48],[10,36,38,49],
 [10,36,38,55],[10,36,38,65],[10,36,38,66],
 [10,36,38,68],[10,36,38,69],[10,36,45,48],
 [10,36,45,49],[10,36,45,54],[10,36,45,62],
 [10,36,45,63],[10,36,45,69],[10,36,48,49],
 [10,36,48,55],[10,36,48,57],[10,36,48,62],
 [10,36,48,63],[10,36,48,68],[10,36,48,69],
 [10,36,49,54],[10,36,49,55],[10,36,49,57],
 [10,36,49,62],[10,36,49,63],[10,36,49,65],
 [10,36,49,66],[10,36,49,69],[10,36,54,57],
 [10,36,54,62],[10,36,54,66],[10,36,54,68],
 [10,36,54,69],[10,36,55,62],[10,36,55,66],
 [10,36,55,69],[10,36,62,63],[10,36,62,65],
 [10,36,62,69],[10,36,63,65],[10,36,63,66],
 [10,36,63,68],[10,36,63,69],[10,36,66,69],
 [10,37,38,42],[10,37,38,44],[10,37,38,47],
 [10,37,38,48],[10,37,38,59],[10,37,38,61],
 [10,37,38,67],[10,37,38,68],[10,37,42,46],
 [10,37,42,47],[10,37,42,62],[10,37,42,63],
 [10,37,44,46],[10,37,44,47],[10,37,44,48],
 [10,37,44,54],[10,37,44,59],[10,37,45,46],
 [10,37,45,47],[10,37,45,48],[10,37,45,54],
 [10,37,45,62],[10,37,45,63],[10,37,45,67],
 [10,37,46,48],[10,37,46,56],[10,37,46,59],
 [10,37,46,61],[10,37,46,63],[10,37,46,67],
 [10,37,46,68],[10,37,47,48],[10,37,47,54],
 [10,37,47,56],[10,37,47,59],[10,37,47,61],
 [10,37,47,62],[10,37,47,63],[10,37,47,67],
 [10,37,48,56],[10,37,48,61],[10,37,48,62],
 [10,37,48,63],[10,37,48,67],[10,37,48,68],
 [10,37,54,56],[10,37,54,61],[10,37,54,67],
 [10,37,54,68],[10,37,56,62],[10,37,61,63],
 [10,37,61,68],[10,37,62,63],[10,37,62,67],
 [10,37,63,67],[10,37,63,68],[10,38,41,42],
 [10,38,41,44],[10,38,41,47],[10,38,41,48],
 [10,38,41,49],[10,38,41,53],[10,38,41,58],
 [10,38,41,59],[10,38,41,61],[10,38,41,63],
 [10,38,41,65],[10,38,41,67],[10,38,41,68],
 [10,38,41,69],[10,38,42,47],[10,38,42,49],
 [10,38,42,55],[10,38,42,59],[10,38,42,63],
 [10,38,42,65],[10,38,42,66],[10,38,42,68],
 [10,38,44,47],[10,38,44,49],[10,38,44,55],
 [10,38,44,59],[10,38,44,63],[10,38,44,65],
 [10,38,44,66],[10,38,44,68],[10,38,44,69],
 [10,38,47,48],[10,38,47,49],[10,38,47,53],
 [10,38,47,58],[10,38,47,59],[10,38,47,61],
 [10,38,47,63],[10,38,47,65],[10,38,47,66],
 [10,38,47,67],[10,38,47,68],[10,38,47,69],
 [10,38,48,49],[10,38,48,53],[10,38,48,55],
 [10,38,48,58],[10,38,48,61],[10,38,48,63],
 [10,38,48,66],[10,38,48,67],[10,38,48,68],
 [10,38,48,69],[10,38,49,53],[10,38,49,55],
 [10,38,49,59],[10,38,49,61],[10,38,49,63],
 [10,38,49,65],[10,38,49,67],[10,38,49,68],
 [10,38,49,69],[10,38,53,58],[10,38,53,63],
 [10,38,53,68],[10,38,55,59],[10,38,55,61],
 [10,38,55,66],[10,38,55,67],[10,38,55,68],
 [10,38,55,69],[10,38,58,65],[10,38,58,67],
 [10,38,58,68],[10,38,58,69],[10,38,59,65],
 [10,38,59,67],[10,38,59,68],[10,38,59,69],
 [10,38,61,63],[10,38,61,66],[10,38,61,68],
 [10,38,61,69],[10,38,63,65],[10,38,63,67],
 [10,38,63,68],[10,38,63,69],[10,38,65,68],
 [10,38,66,67],[10,38,66,68],[10,38,66,69],
 [10,38,67,68],[10,38,67,69],[10,38,68,69],
 [10,39,41,46],[10,39,41,47],[10,39,41,48],
 [10,39,41,55],[10,39,41,58],[10,39,41,59],
 [10,39,41,66],[10,39,41,67],[10,39,41,68],
 [10,39,41,69],[10,39,45,46],[10,39,45,47],
 [10,39,45,48],[10,39,45,58],[10,39,45,63],
 [10,39,45,65],[10,39,45,66],[10,39,45,67],
 [10,39,45,69],[10,39,46,48],[10,39,46,53],
 [10,39,46,58],[10,39,46,59],[10,39,46,63],
 [10,39,46,65],[10,39,46,67],[10,39,46,68],
 [10,39,46,69],[10,39,47,48],[10,39,47,53],
 [10,39,47,55],[10,39,47,58],[10,39,47,59],
 [10,39,47,63],[10,39,47,66],[10,39,47,67],
 [10,39,47,68],[10,39,47,69],[10,39,48,55],
 [10,39,48,58],[10,39,48,59],[10,39,48,63],
 [10,39,48,66],[10,39,48,67],[10,39,48,68],
 [10,39,48,69],[10,39,53,58],[10,39,53,63],
 [10,39,55,59],[10,39,55,66],[10,39,55,67],
 [10,39,55,68],[10,39,55,69],[10,39,58,59],
 [10,39,58,65],[10,39,58,66],[10,39,58,67],
 [10,39,58,68],[10,39,58,69],[10,39,59,66],
 [10,39,59,67],[10,39,59,68],[10,39,59,69],
 [10,39,63,65],[10,39,63,66],[10,39,63,67],
 [10,39,63,69],[10,39,66,67],[10,39,66,68],
 [10,39,66,69],[10,39,67,68],[10,39,67,69],
 [10,39,68,69],[10,41,42,46],[10,41,42,47],
 [10,41,42,49],[10,41,42,59],[10,41,42,63],
 [10,41,42,65],[10,41,42,68],[10,41,44,46],
 [10,41,44,47],[10,41,44,48],[10,41,44,49],
 [10,41,44,54],[10,41,44,55],[10,41,44,57],
 [10,41,44,59],[10,41,44,63],[10,41,44,65],
 [10,41,44,66],[10,41,44,68],[10,41,44,69],
 [10,41,46,48],[10,41,46,49],[10,41,46,53],
 [10,41,46,57],[10,41,46,58],[10,41,46,59],
 [10,41,46,61],[10,41,46,63],[10,41,46,65],
 [10,41,46,67],[10,41,46,68],[10,41,46,69],
 [10,41,47,48],[10,41,47,49],[10,41,47,53],
 [10,41,47,54],[10,41,47,55],[10,41,47,56],
 [10,41,47,57],[10,41,47,58],[10,41,47,59],
 [10,41,47,61],[10,41,47,63],[10,41,47,65],
 [10,41,47,66],[10,41,47,67],[10,41,47,68],
 [10,41,47,69],[10,41,48,49],[10,41,48,55],
 [10,41,48,56],[10,41,48,58],[10,41,48,59],
 [10,41,48,61],[10,41,48,63],[10,41,48,66],
 [10,41,48,67],[10,41,48,68],[10,41,48,69],
 [10,41,49,53],[10,41,49,54],[10,41,49,55],
 [10,41,49,56],[10,41,49,57],[10,41,49,58],
 [10,41,49,59],[10,41,49,61],[10,41,49,63],
 [10,41,49,65],[10,41,49,66],[10,41,49,67],
 [10,41,49,68],[10,41,49,69],[10,41,53,54],
 [10,41,53,63],[10,41,53,68],[10,41,54,56],
 [10,41,54,57],[10,41,54,59],[10,41,54,61],
 [10,41,54,67],[10,41,54,68],[10,41,54,69],
 [10,41,55,59],[10,41,55,61],[10,41,55,66],
 [10,41,55,67],[10,41,55,68],[10,41,55,69],
 [10,41,56,57],[10,41,56,59],[10,41,56,68],
 [10,41,57,59],[10,41,57,61],[10,41,57,68],
 [10,41,58,59],[10,41,58,66],[10,41,58,67],
 [10,41,58,68],[10,41,58,69],[10,41,59,65],
 [10,41,59,66],[10,41,59,67],[10,41,59,68],
 [10,41,59,69],[10,41,61,63],[10,41,61,66],
 [10,41,61,68],[10,41,61,69],[10,41,63,65],
 [10,41,63,67],[10,41,63,68],[10,41,63,69],
 [10,41,65,68],[10,41,66,67],[10,41,66,68],
 [10,41,66,69],[10,41,67,68],[10,41,67,69],
 [10,41,68,69],[10,42,46,49],[10,42,46,62],
 [10,42,46,63],[10,42,46,65],[10,42,46,68],
 [10,42,47,49],[10,42,47,55],[10,42,47,59],
 [10,42,47,62],[10,42,47,63],[10,42,47,65],
 [10,42,47,68],[10,42,49,55],[10,42,49,59],
 [10,42,49,62],[10,42,49,63],[10,42,49,65],
 [10,42,49,66],[10,42,49,68],[10,42,51,55],
 [10,42,51,62],[10,42,51,63],[10,42,51,66],
 [10,42,51,68],[10,42,55,62],[10,42,55,66],
 [10,42,59,65],[10,42,59,68],[10,42,62,63],
 [10,42,62,65],[10,42,63,65],[10,42,63,66],
 [10,42,63,68],[10,42,65,68],[10,44,45,46],
 [10,44,45,47],[10,44,45,48],[10,44,45,49],
 [10,44,45,51],[10,44,45,54],[10,44,45,62],
 [10,44,45,63],[10,44,45,66],[10,44,45,69],
 [10,44,46,48],[10,44,46,49],[10,44,46,57],
 [10,44,46,59],[10,44,46,62],[10,44,46,65],
 [10,44,46,68],[10,44,46,69],[10,44,47,48],
 [10,44,47,49],[10,44,47,54],[10,44,47,55],
 [10,44,47,57],[10,44,47,59],[10,44,47,62],
 [10,44,47,63],[10,44,47,65],[10,44,47,66],
 [10,44,47,68],[10,44,47,69],[10,44,48,49],
 [10,44,48,51],[10,44,48,55],[10,44,48,59],
 [10,44,48,62],[10,44,48,63],[10,44,48,66],
 [10,44,48,68],[10,44,48,69],[10,44,49,54],
 [10,44,49,55],[10,44,49,57],[10,44,49,59],
 [10,44,49,62],[10,44,49,63],[10,44,49,65],
 [10,44,49,66],[10,44,49,68],[10,44,49,69],
 [10,44,51,63],[10,44,51,65],[10,44,51,66],
 [10,44,51,68],[10,44,51,69],[10,44,54,57],
 [10,44,54,59],[10,44,54,62],[10,44,54,66],
 [10,44,54,68],[10,44,55,59],[10,44,55,62],
 [10,44,55,66],[10,44,55,68],[10,44,55,69],
 [10,44,57,59],[10,44,57,68],[10,44,59,65],
 [10,44,59,66],[10,44,59,68],[10,44,59,69],
 [10,44,62,63],[10,44,62,69],[10,44,63,65],
 [10,44,63,66],[10,44,63,68],[10,44,63,69],
 [10,44,65,68],[10,44,66,68],[10,44,66,69],
 [10,44,68,69],[10,45,46,48],[10,45,46,49],
 [10,45,46,58],[10,45,46,61],[10,45,46,62],
 [10,45,46,63],[10,45,46,65],[10,45,46,67],
 [10,45,46,69],[10,45,47,48],[10,45,47,49],
 [10,45,47,53],[10,45,47,58],[10,45,47,61],
 [10,45,47,62],[10,45,47,66],[10,45,47,67],
 [10,45,47,69],[10,45,48,49],[10,45,48,51],
 [10,45,48,53],[10,45,48,58],[10,45,48,61],
 [10,45,48,62],[10,45,48,63],[10,45,48,66],
 [10,45,48,67],[10,45,48,69],[10,45,49,58],
 [10,45,49,61],[10,45,49,62],[10,45,49,63],
 [10,45,49,66],[10,45,49,67],[10,45,49,69],
 [10,45,51,53],[10,45,51,58],[10,45,51,62],
 [10,45,51,63],[10,45,51,66],[10,45,51,67],
 [10,45,51,69],[10,45,53,58],[10,45,53,62],
 [10,45,53,63],[10,45,54,62],[10,45,54,66],
 [10,45,54,67],[10,45,54,69],[10,45,58,62],
 [10,45,58,65],[10,45,58,66],[10,45,58,67],
 [10,45,58,69],[10,45,61,62],[10,45,61,63],
 [10,45,61,66],[10,45,61,69],[10,45,62,63],
 [10,45,62,65],[10,45,62,67],[10,45,62,69],
 [10,45,63,66],[10,45,63,67],[10,45,63,69],
 [10,45,66,67],[10,45,66,69],[10,45,67,69],
 [10,46,48,49],[10,46,48,56],[10,46,48,57],
 [10,46,48,58],[10,46,48,59],[10,46,48,61],
 [10,46,48,62],[10,46,48,63],[10,46,48,67],
 [10,46,48,68],[10,46,48,69],[10,46,49,53],
 [10,46,49,56],[10,46,49,58],[10,46,49,59],
 [10,46,49,61],[10,46,49,62],[10,46,49,63],
 [10,46,49,65],[10,46,49,67],[10,46,49,68],
 [10,46,49,69],[10,46,53,56],[10,46,53,58],
 [10,46,53,62],[10,46,53,63],[10,46,53,68],
 [10,46,56,57],[10,46,56,59],[10,46,56,62],
 [10,46,56,68],[10,46,56,69],[10,46,57,58],
 [10,46,57,61],[10,46,57,67],[10,46,57,68],
 [10,46,58,59],[10,46,58,62],[10,46,58,65],
 [10,46,58,67],[10,46,58,68],[10,46,58,69],
 [10,46,59,65],[10,46,59,67],[10,46,59,68],
 [10,46,59,69],[10,46,61,62],[10,46,61,63],
 [10,46,61,68],[10,46,61,69],[10,46,62,63],
 [10,46,62,65],[10,46,62,67],[10,46,62,69],
 [10,46,63,65],[10,46,63,67],[10,46,63,68],
 [10,46,63,69],[10,46,65,68],[10,46,67,68],
 [10,46,67,69],[10,46,68,69],[10,47,48,49],
 [10,47,48,53],[10,47,48,55],[10,47,48,57],
 [10,47,48,58],[10,47,48,59],[10,47,48,61],
 [10,47,48,62],[10,47,48,63],[10,47,48,66],
 [10,47,48,67],[10,47,48,68],[10,47,48,69],
 [10,47,49,53],[10,47,49,54],[10,47,49,55],
 [10,47,49,56],[10,47,49,57],[10,47,49,58],
 [10,47,49,59],[10,47,49,61],[10,47,49,62],
 [10,47,49,63],[10,47,49,65],[10,47,49,66],
 [10,47,49,67],[10,47,49,68],[10,47,49,69],
 [10,47,53,54],[10,47,53,56],[10,47,53,58],
 [10,47,53,62],[10,47,53,63],[10,47,53,68],
 [10,47,54,56],[10,47,54,57],[10,47,54,59],
 [10,47,54,61],[10,47,54,62],[10,47,54,66],
 [10,47,54,68],[10,47,54,69],[10,47,55,59],
 [10,47,55,61],[10,47,55,62],[10,47,55,66],
 [10,47,55,67],[10,47,55,68],[10,47,55,69],
 [10,47,56,57],[10,47,56,59],[10,47,56,62],
 [10,47,56,66],[10,47,56,68],[10,47,56,69],
 [10,47,57,58],[10,47,57,59],[10,47,57,61],
 [10,47,57,67],[10,47,57,68],[10,47,58,59],
 [10,47,58,62],[10,47,58,65],[10,47,58,66],
 [10,47,58,67],[10,47,58,68],[10,47,58,69],
 [10,47,59,65],[10,47,59,66],[10,47,59,67],
 [10,47,59,68],[10,47,59,69],[10,47,61,62],
 [10,47,61,63],[10,47,61,66],[10,47,61,68],
 [10,47,61,69],[10,47,62,63],[10,47,62,65],
 [10,47,62,67],[10,47,62,69],[10,47,63,65],
 [10,47,63,66],[10,47,63,67],[10,47,63,68],
 [10,47,63,69],[10,47,65,68],[10,47,66,67],
 [10,47,66,68],[10,47,66,69],[10,47,67,68],
 [10,47,67,69],[10,47,68,69],[10,48,49,55],
 [10,48,49,56],[10,48,49,58],[10,48,49,59],
 [10,48,49,61],[10,48,49,62],[10,48,49,63],
 [10,48,49,66],[10,48,49,67],[10,48,49,68],
 [10,48,49,69],[10,48,51,53],[10,48,51,56],
 [10,48,51,58],[10,48,51,62],[10,48,51,63],
 [10,48,51,67],[10,48,51,68],[10,48,53,56],
 [10,48,53,58],[10,48,53,62],[10,48,53,63],
 [10,48,53,68],[10,48,55,59],[10,48,55,61],
 [10,48,55,62],[10,48,55,66],[10,48,55,67],
 [10,48,55,68],[10,48,55,69],[10,48,56,57],
 [10,48,56,59],[10,48,56,62],[10,48,56,66],
 [10,48,56,68],[10,48,56,69],[10,48,57,58],
 [10,48,57,59],[10,48,57,61],[10,48,57,67],
 [10,48,57,68],[10,48,58,59],[10,48,58,62],
 [10,48,58,66],[10,48,58,67],[10,48,58,68],
 [10,48,58,69],[10,48,59,66],[10,48,59,67],
 [10,48,59,68],[10,48,59,69],[10,48,61,62],
 [10,48,61,63],[10,48,61,66],[10,48,61,68],
 [10,48,61,69],[10,48,62,63],[10,48,62,67],
 [10,48,62,69],[10,48,63,66],[10,48,63,67],
 [10,48,63,68],[10,48,63,69],[10,48,66,67],
 [10,48,66,68],[10,48,66,69],[10,48,67,68],
 [10,48,67,69],[10,48,68,69],[10,49,53,56],
 [10,49,53,58],[10,49,53,62],[10,49,53,63],
 [10,49,53,68],[10,49,54,56],[10,49,54,57],
 [10,49,54,59],[10,49,54,61],[10,49,54,67],
 [10,49,54,68],[10,49,55,59],[10,49,55,61],
 [10,49,55,62],[10,49,55,66],[10,49,55,67],
 [10,49,55,68],[10,49,55,69],[10,49,56,57],
 [10,49,56,59],[10,49,56,62],[10,49,56,66],
 [10,49,56,68],[10,49,56,69],[10,49,57,58],
 [10,49,57,59],[10,49,57,61],[10,49,57,67],
 [10,49,57,68],[10,49,58,59],[10,49,58,62],
 [10,49,58,65],[10,49,58,66],[10,49,58,67],
 [10,49,58,68],[10,49,58,69],[10,49,59,65],
 [10,49,59,66],[10,49,59,67],[10,49,59,68],
 [10,49,59,69],[10,49,61,62],[10,49,61,63],
 [10,49,61,66],[10,49,61,68],[10,49,61,69],
 [10,49,62,63],[10,49,62,65],[10,49,62,67],
 [10,49,62,69],[10,49,63,65],[10,49,63,67],
 [10,49,63,68],[10,49,63,69],[10,49,65,68],
 [10,49,66,67],[10,49,66,68],[10,49,66,69],
 [10,49,67,68],[10,49,67,69],[10,49,68,69],
 [10,51,53,56],[10,51,53,58],[10,51,53,62],
 [10,51,53,63],[10,51,53,68],[10,51,55,61],
 [10,51,55,62],[10,51,55,66],[10,51,55,67],
 [10,51,55,68],[10,51,55,69],[10,51,56,57],
 [10,51,56,62],[10,51,56,66],[10,51,56,68],
 [10,51,56,69],[10,51,57,58],[10,51,57,61],
 [10,51,57,67],[10,51,57,68],[10,51,58,62],
 [10,51,58,65],[10,51,58,66],[10,51,58,67],
 [10,51,58,68],[10,51,58,69],[10,51,61,62],
 [10,51,61,63],[10,51,61,66],[10,51,61,68],
 [10,51,61,69],[10,51,62,63],[10,51,62,65],
 [10,51,62,67],[10,51,62,69],[10,51,63,65],
 [10,51,63,66],[10,51,63,67],[10,51,63,68],
 [10,51,63,69],[10,51,65,68],[10,51,66,67],
 [10,51,66,68],[10,51,66,69],[10,51,67,68],
 [10,51,67,69],[10,51,68,69],[10,53,54,56],
 [10,53,54,62],[10,53,54,68],[10,53,56,62],
 [10,53,58,62],[10,53,62,63],[10,53,63,68],
 [10,54,56,57],[10,54,56,59],[10,54,56,62],
 [10,54,56,66],[10,54,56,68],[10,54,56,69],
 [10,54,57,59],[10,54,57,61],[10,54,57,67],
 [10,54,57,68],[10,54,59,66],[10,54,59,67],
 [10,54,59,68],[10,54,59,69],[10,54,61,62],
 [10,54,61,66],[10,54,61,68],[10,54,61,69],
 [10,54,62,67],[10,54,62,69],[10,54,66,67],
 [10,54,66,68],[10,54,66,69],[10,54,67,68],
 [10,54,67,69],[10,54,68,69],[10,55,59,66],
 [10,55,59,67],[10,55,59,68],[10,55,59,69],
 [10,55,61,62],[10,55,61,66],[10,55,61,68],
 [10,55,61,69],[10,55,62,67],[10,55,62,69],
 [10,55,66,67],[10,55,66,68],[10,55,66,69],
 [10,55,67,68],[10,55,67,69],[10,55,68,69],
 [10,56,57,59],[10,56,57,68],[10,56,59,68],
 [10,56,62,69],[10,56,66,69],[10,57,58,67],
 [10,57,59,68],[10,57,61,68],[10,58,59,66],
 [10,58,59,67],[10,58,59,68],[10,58,59,69],
 [10,58,62,65],[10,58,62,67],[10,58,62,69],
 [10,58,66,67],[10,58,66,68],[10,58,66,69],
 [10,58,67,68],[10,58,67,69],[10,58,68,69],
 [10,59,65,68],[10,59,66,67],[10,59,66,68],
 [10,59,66,69],[10,59,67,68],[10,59,67,69],
 [10,59,68,69],[10,61,62,63],[10,61,62,69],
 [10,61,63,66],[10,61,63,68],[10,61,63,69],
 [10,61,66,68],[10,61,66,69],[10,61,68,69],
 [10,62,63,65],[10,62,63,67],[10,62,63,69],
 [10,62,67,69],[10,63,65,68],[10,63,66,67],
 [10,63,66,68],[10,63,66,69],[10,63,67,68],
 [10,63,67,69],[10,63,68,69],[10,66,67,68],
 [10,66,67,69],[10,66,68,69],[10,67,68,69],
 [11,12,13,21],[11,12,13,23],[11,12,13,24],
 [11,12,13,25],[11,12,13,34],[11,12,13,43],
 [11,12,13,46],[11,12,13,47],[11,12,13,51],
 [11,12,13,54],[11,12,13,55],[11,12,13,60],
 [11,12,13,63],[11,12,13,69],[11,12,14,17],
 [11,12,14,20],[11,12,14,24],[11,12,14,25],
 [11,12,14,35],[11,12,14,43],[11,12,14,47],
 [11,12,14,55],[11,12,14,60],[11,12,14,61],
 [11,12,14,62],[11,12,14,69],[11,12,16,20],
 [11,12,16,21],[11,12,16,24],[11,12,16,25],
 [11,12,16,34],[11,12,16,35],[11,12,16,45],
 [11,12,16,46],[11,12,16,47],[11,12,16,48],
 [11,12,16,49],[11,12,16,51],[11,12,16,61],
 [11,12,16,62],[11,12,16,69],[11,12,17,20],
 [11,12,17,23],[11,12,17,24],[11,12,17,34],
 [11,12,17,46],[11,12,17,47],[11,12,17,48],
 [11,12,17,49],[11,12,17,51],[11,12,17,54],
 [11,12,17,55],[11,12,17,69],[11,12,20,24],
 [11,12,20,25],[11,12,20,31],[11,12,20,34],
 [11,12,20,35],[11,12,20,40],[11,12,20,44],
 [11,12,20,45],[11,12,20,46],[11,12,20,47],
 [11,12,20,55],[11,12,20,60],[11,12,20,63],
 [11,12,20,64],[11,12,20,69],[11,12,21,23],
 [11,12,21,24],[11,12,21,25],[11,12,21,34],
 [11,12,21,35],[11,12,21,43],[11,12,21,44],
 [11,12,21,45],[11,12,21,46],[11,12,21,48],
 [11,12,21,49],[11,12,21,51],[11,12,21,55],
 [11,12,21,60],[11,12,21,61],[11,12,21,62],
 [11,12,21,64],[11,12,21,69],[11,12,23,24],
 [11,12,23,25],[11,12,23,31],[11,12,23,34],
 [11,12,23,35],[11,12,23,40],[11,12,23,43],
 [11,12,23,44],[11,12,23,46],[11,12,23,47],
 [11,12,23,55],[11,12,23,60],[11,12,23,61],
 [11,12,23,62],[11,12,23,64],[11,12,23,69],
 [11,12,24,25],[11,12,24,34],[11,12,24,43],
 [11,12,24,44],[11,12,24,45],[11,12,24,46],
 [11,12,24,47],[11,12,24,48],[11,12,24,49],
 [11,12,24,51],[11,12,24,54],[11,12,24,55],
 [11,12,24,60],[11,12,24,63],[11,12,24,64],
 [11,12,24,69],[11,12,25,28],[11,12,25,31],
 [11,12,25,34],[11,12,25,35],[11,12,25,40],
 [11,12,25,43],[11,12,25,45],[11,12,25,46],
 [11,12,25,47],[11,12,25,48],[11,12,25,49],
 [11,12,25,51],[11,12,25,54],[11,12,25,55],
 [11,12,25,60],[11,12,25,61],[11,12,25,62],
 [11,12,25,64],[11,12,25,69],[11,12,28,35],
 [11,12,28,55],[11,12,28,61],[11,12,28,69],
 [11,12,31,44],[11,12,31,47],[11,12,31,48],
 [11,12,31,49],[11,12,31,55],[11,12,31,63],
 [11,12,31,69],[11,12,34,43],[11,12,34,44],
 [11,12,34,45],[11,12,34,46],[11,12,34,47],
 [11,12,34,48],[11,12,34,49],[11,12,34,55],
 [11,12,34,60],[11,12,34,61],[11,12,34,62],
 [11,12,34,63],[11,12,34,69],[11,12,35,45],
 [11,12,35,47],[11,12,35,48],[11,12,35,49],
 [11,12,35,55],[11,12,35,62],[11,12,35,63],
 [11,12,35,69],[11,12,40,47],[11,12,40,48],
 [11,12,40,49],[11,12,40,55],[11,12,40,63],
 [11,12,40,69],[11,12,43,46],[11,12,43,47],
 [11,12,43,48],[11,12,43,49],[11,12,43,55],
 [11,12,43,60],[11,12,43,69],[11,12,44,46],
 [11,12,44,47],[11,12,44,49],[11,12,44,54],
 [11,12,44,55],[11,12,44,62],[11,12,44,63],
 [11,12,44,64],[11,12,44,69],[11,12,45,46],
 [11,12,45,48],[11,12,45,49],[11,12,45,51],
 [11,12,45,55],[11,12,45,61],[11,12,45,62],
 [11,12,45,69],[11,12,46,47],[11,12,46,48],
 [11,12,46,49],[11,12,46,55],[11,12,46,60],
 [11,12,46,61],[11,12,46,62],[11,12,46,63],
 [11,12,46,69],[11,12,47,55],[11,12,47,60],
 [11,12,47,61],[11,12,47,62],[11,12,47,63],
 [11,12,47,64],[11,12,47,69],[11,12,48,49],
 [11,12,48,51],[11,12,48,55],[11,12,48,60],
 [11,12,48,61],[11,12,48,62],[11,12,48,63],
 [11,12,48,64],[11,12,48,69],[11,12,49,55],
 [11,12,49,60],[11,12,49,61],[11,12,49,62],
 [11,12,49,63],[11,12,49,64],[11,12,49,69],
 [11,12,51,60],[11,12,51,61],[11,12,51,62],
 [11,12,51,64],[11,12,51,69],[11,12,54,60],
 [11,12,54,61],[11,12,54,62],[11,12,54,69],
 [11,12,55,60],[11,12,55,61],[11,12,55,62],
 [11,12,55,69],[11,12,60,63],[11,12,60,69],
 [11,12,61,62],[11,12,61,63],[11,12,61,69],
 [11,12,62,63],[11,12,62,69],[11,12,63,64],
 [11,12,63,69],[11,12,64,69],[11,13,16,19],
 [11,13,16,20],[11,13,16,21],[11,13,16,24],
 [11,13,16,25],[11,13,16,34],[11,13,16,41],
 [11,13,16,43],[11,13,16,46],[11,13,16,47],
 [11,13,16,53],[11,13,16,60],[11,13,16,62],
 [11,13,16,68],[11,13,16,69],[11,13,19,20],
 [11,13,19,21],[11,13,19,23],[11,13,19,24],
 [11,13,19,25],[11,13,19,31],[11,13,19,41],
 [11,13,19,43],[11,13,19,46],[11,13,19,47],
 [11,13,19,51],[11,13,19,52],[11,13,19,53],
 [11,13,19,54],[11,13,19,60],[11,13,19,62],
 [11,13,19,63],[11,13,19,64],[11,13,19,68],
 [11,13,20,23],[11,13,20,24],[11,13,20,25],
 [11,13,20,34],[11,13,20,41],[11,13,20,43],
 [11,13,20,46],[11,13,20,47],[11,13,20,55],
 [11,13,20,60],[11,13,20,62],[11,13,20,63],
 [11,13,20,64],[11,13,20,68],[11,13,20,69],
 [11,13,21,23],[11,13,21,24],[11,13,21,25],
 [11,13,21,31],[11,13,21,34],[11,13,21,37],
 [11,13,21,41],[11,13,21,43],[11,13,21,46],
 [11,13,21,51],[11,13,21,53],[11,13,21,55],
 [11,13,21,60],[11,13,21,62],[11,13,21,64],
 [11,13,21,68],[11,13,21,69],[11,13,23,24],
 [11,13,23,25],[11,13,23,31],[11,13,23,34],
 [11,13,23,37],[11,13,23,41],[11,13,23,43],
 [11,13,23,46],[11,13,23,47],[11,13,23,51],
 [11,13,23,52],[11,13,23,53],[11,13,23,55],
 [11,13,23,60],[11,13,23,62],[11,13,23,64],
 [11,13,23,68],[11,13,23,69],[11,13,24,25],
 [11,13,24,34],[11,13,24,37],[11,13,24,41],
 [11,13,24,43],[11,13,24,46],[11,13,24,47],
 [11,13,24,52],[11,13,24,53],[11,13,24,55],
 [11,13,24,60],[11,13,24,62],[11,13,24,63],
 [11,13,24,64],[11,13,24,68],[11,13,24,69],
 [11,13,25,31],[11,13,25,34],[11,13,25,37],
 [11,13,25,41],[11,13,25,43],[11,13,25,46],
 [11,13,25,47],[11,13,25,51],[11,13,25,52],
 [11,13,25,53],[11,13,25,54],[11,13,25,55],
 [11,13,25,60],[11,13,25,62],[11,13,25,64],
 [11,13,25,68],[11,13,25,69],[11,13,31,37],
 [11,13,31,63],[11,13,31,69],[11,13,34,43],
 [11,13,34,46],[11,13,34,47],[11,13,34,55],
 [11,13,34,60],[11,13,34,62],[11,13,34,63],
 [11,13,34,69],[11,13,37,43],[11,13,37,46],
 [11,13,37,47],[11,13,37,54],[11,13,37,60],
 [11,13,37,62],[11,13,37,64],[11,13,41,43],
 [11,13,41,46],[11,13,41,47],[11,13,41,53],
 [11,13,41,60],[11,13,41,62],[11,13,41,68],
 [11,13,43,46],[11,13,43,47],[11,13,43,55],
 [11,13,43,60],[11,13,43,62],[11,13,43,64],
 [11,13,43,68],[11,13,43,69],[11,13,46,47],
 [11,13,46,52],[11,13,46,53],[11,13,46,55],
 [11,13,46,60],[11,13,46,62],[11,13,46,63],
 [11,13,46,68],[11,13,46,69],[11,13,47,51],
 [11,13,47,52],[11,13,47,53],[11,13,47,55],
 [11,13,47,60],[11,13,47,62],[11,13,47,68],
 [11,13,47,69],[11,13,51,52],[11,13,51,53],
 [11,13,51,55],[11,13,51,60],[11,13,51,62],
 [11,13,51,63],[11,13,51,64],[11,13,51,68],
 [11,13,51,69],[11,13,52,54],[11,13,52,63],
 [11,13,53,54],[11,13,53,60],[11,13,53,63],
 [11,13,53,64],[11,13,53,68],[11,13,54,60],
 [11,13,54,62],[11,13,54,68],[11,13,54,69],
 [11,13,55,60],[11,13,55,62],[11,13,55,69],
 [11,13,60,62],[11,13,60,63],[11,13,60,68],
 [11,13,60,69],[11,13,62,63],[11,13,62,68],
 [11,13,62,69],[11,13,63,64],[11,13,63,68],
 [11,13,63,69],[11,13,64,69],[11,14,17,18],
 [11,14,17,20],[11,14,17,24],[11,14,17,27],
 [11,14,17,37],[11,14,17,41],[11,14,17,47],
 [11,14,17,49],[11,14,17,50],[11,14,17,53],
 [11,14,17,55],[11,14,17,57],[11,14,17,62],
 [11,14,17,68],[11,14,17,69],[11,14,18,20],
 [11,14,18,24],[11,14,18,25],[11,14,18,35],
 [11,14,18,41],[11,14,18,44],[11,14,18,47],
 [11,14,18,49],[11,14,18,52],[11,14,18,53],
 [11,14,18,55],[11,14,18,60],[11,14,18,61],
 [11,14,18,68],[11,14,20,24],[11,14,20,25],
 [11,14,20,27],[11,14,20,37],[11,14,20,41],
 [11,14,20,44],[11,14,20,47],[11,14,20,49],
 [11,14,20,53],[11,14,20,55],[11,14,20,57],
 [11,14,20,62],[11,14,20,66],[11,14,20,68],
 [11,14,24,25],[11,14,24,27],[11,14,24,37],
 [11,14,24,41],[11,14,24,44],[11,14,24,47],
 [11,14,24,49],[11,14,24,52],[11,14,24,53],
 [11,14,24,57],[11,14,24,60],[11,14,24,62],
 [11,14,24,68],[11,14,24,69],[11,14,25,27],
 [11,14,25,35],[11,14,25,37],[11,14,25,43],
 [11,14,25,49],[11,14,25,50],[11,14,25,52],
 [11,14,25,53],[11,14,25,55],[11,14,25,57],
 [11,14,25,60],[11,14,25,61],[11,14,25,62],
 [11,14,25,68],[11,14,25,69],[11,14,27,35],
 [11,14,27,47],[11,14,27,52],[11,14,27,53],
 [11,14,27,55],[11,14,27,60],[11,14,27,61],
 [11,14,27,62],[11,14,27,66],[11,14,27,68],
 [11,14,30,35],[11,14,30,41],[11,14,30,47],
 [11,14,30,49],[11,14,30,60],[11,14,30,62],
 [11,14,30,68],[11,14,35,37],[11,14,35,41],
 [11,14,35,47],[11,14,35,49],[11,14,35,55],
 [11,14,35,57],[11,14,35,62],[11,14,35,68],
 [11,14,35,69],[11,14,37,43],[11,14,37,47],
 [11,14,37,60],[11,14,37,61],[11,14,37,62],
 [11,14,41,44],[11,14,41,47],[11,14,41,49],
 [11,14,41,50],[11,14,41,53],[11,14,41,60],
 [11,14,41,61],[11,14,41,62],[11,14,41,68],
 [11,14,43,49],[11,14,43,52],[11,14,43,53],
 [11,14,43,55],[11,14,43,57],[11,14,43,60],
 [11,14,43,62],[11,14,43,66],[11,14,43,68],
 [11,14,43,69],[11,14,44,47],[11,14,44,49],
 [11,14,44,52],[11,14,44,53],[11,14,44,55],
 [11,14,44,57],[11,14,44,66],[11,14,44,68],
 [11,14,44,69],[11,14,47,49],[11,14,47,50],
 [11,14,47,53],[11,14,47,55],[11,14,47,57],
 [11,14,47,61],[11,14,47,62],[11,14,47,68],
 [11,14,47,69],[11,14,49,50],[11,14,49,52],
 [11,14,49,53],[11,14,49,55],[11,14,49,57],
 [11,14,49,60],[11,14,49,61],[11,14,49,66],
 [11,14,49,68],[11,14,50,52],[11,14,50,55],
 [11,14,50,60],[11,14,50,62],[11,14,50,68],
 [11,14,52,62],[11,14,53,60],[11,14,53,62],
 [11,14,53,68],[11,14,55,60],[11,14,55,61],
 [11,14,55,62],[11,14,55,66],[11,14,55,69],
 [11,14,57,60],[11,14,57,61],[11,14,60,62],
 [11,14,60,66],[11,14,60,68],[11,14,60,69],
 [11,14,61,62],[11,14,61,66],[11,14,61,68],
 [11,14,61,69],[11,14,62,66],[11,14,62,68],
 [11,14,62,69],[11,16,19,20],[11,16,19,21],
 [11,16,19,24],[11,16,19,25],[11,16,19,27],
 [11,16,19,35],[11,16,19,40],[11,16,19,41],
 [11,16,19,43],[11,16,19,46],[11,16,19,47],
 [11,16,19,49],[11,16,19,52],[11,16,19,57],
 [11,16,19,60],[11,16,19,61],[11,16,19,62],
 [11,16,19,68],[11,16,20,24],[11,16,20,25],
 [11,16,20,27],[11,16,20,34],[11,16,20,37],
 [11,16,20,38],[11,16,20,40],[11,16,20,41],
 [11,16,20,43],[11,16,20,45],[11,16,20,46],
 [11,16,20,47],[11,16,20,49],[11,16,20,53],
 [11,16,20,60],[11,16,20,62],[11,16,20,68],
 [11,16,20,69],[11,16,21,24],[11,16,21,25],
 [11,16,21,27],[11,16,21,34],[11,16,21,35],
 [11,16,21,37],[11,16,21,38],[11,16,21,41],
 [11,16,21,43],[11,16,21,45],[11,16,21,46],
 [11,16,21,48],[11,16,21,49],[11,16,21,50],
 [11,16,21,51],[11,16,21,52],[11,16,21,53],
 [11,16,21,57],[11,16,21,60],[11,16,21,61],
 [11,16,21,62],[11,16,21,68],[11,16,21,69],
 [11,16,24,25],[11,16,24,27],[11,16,24,30],
 [11,16,24,34],[11,16,24,37],[11,16,24,38],
 [11,16,24,40],[11,16,24,41],[11,16,24,43],
 [11,16,24,45],[11,16,24,46],[11,16,24,47],
 [11,16,24,48],[11,16,24,49],[11,16,24,51],
 [11,16,24,53],[11,16,24,60],[11,16,24,62],
 [11,16,24,68],[11,16,24,69],[11,16,25,27],
 [11,16,25,34],[11,16,25,35],[11,16,25,37],
 [11,16,25,40],[11,16,25,41],[11,16,25,43],
 [11,16,25,45],[11,16,25,46],[11,16,25,47],
 [11,16,25,48],[11,16,25,49],[11,16,25,50],
 [11,16,25,51],[11,16,25,52],[11,16,25,53],
 [11,16,25,57],[11,16,25,60],[11,16,25,61],
 [11,16,25,62],[11,16,25,68],[11,16,25,69],
 [11,16,27,35],[11,16,27,40],[11,16,27,41],
 [11,16,27,45],[11,16,27,46],[11,16,27,47],
 [11,16,27,48],[11,16,27,49],[11,16,27,51],
 [11,16,27,52],[11,16,27,53],[11,16,27,60],
 [11,16,27,61],[11,16,27,62],[11,16,27,68],
 [11,16,30,41],[11,16,30,45],[11,16,30,47],
 [11,16,30,48],[11,16,30,49],[11,16,30,50],
 [11,16,30,60],[11,16,30,62],[11,16,30,68],
 [11,16,34,43],[11,16,34,45],[11,16,34,46],
 [11,16,34,47],[11,16,34,48],[11,16,34,49],
 [11,16,34,60],[11,16,34,61],[11,16,34,62],
 [11,16,34,69],[11,16,35,37],[11,16,35,38],
 [11,16,35,41],[11,16,35,45],[11,16,35,47],
 [11,16,35,48],[11,16,35,62],[11,16,35,68],
 [11,16,37,38],[11,16,37,40],[11,16,37,43],
 [11,16,37,45],[11,16,37,47],[11,16,37,48],
 [11,16,37,60],[11,16,37,62],[11,16,38,40],
 [11,16,38,43],[11,16,38,46],[11,16,38,49],
 [11,16,38,51],[11,16,38,52],[11,16,38,53],
 [11,16,38,60],[11,16,38,61],[11,16,38,62],
 [11,16,40,45],[11,16,40,47],[11,16,40,48],
 [11,16,40,49],[11,16,40,50],[11,16,40,53],
 [11,16,40,69],[11,16,41,43],[11,16,41,46],
 [11,16,41,47],[11,16,41,48],[11,16,41,49],
 [11,16,41,50],[11,16,41,53],[11,16,41,60],
 [11,16,41,61],[11,16,41,62],[11,16,41,68],
 [11,16,43,46],[11,16,43,47],[11,16,43,48],
 [11,16,43,49],[11,16,43,53],[11,16,43,57],
 [11,16,43,60],[11,16,43,62],[11,16,43,68],
 [11,16,43,69],[11,16,45,46],[11,16,45,48],
 [11,16,45,49],[11,16,45,50],[11,16,45,51],
 [11,16,45,52],[11,16,45,53],[11,16,45,57],
 [11,16,45,60],[11,16,45,61],[11,16,45,62],
 [11,16,45,68],[11,16,45,69],[11,16,46,47],
 [11,16,46,48],[11,16,46,49],[11,16,46,50],
 [11,16,46,52],[11,16,46,57],[11,16,46,60],
 [11,16,46,61],[11,16,46,62],[11,16,46,68],
 [11,16,46,69],[11,16,47,49],[11,16,47,50],
 [11,16,47,51],[11,16,47,52],[11,16,47,53],
 [11,16,47,57],[11,16,47,60],[11,16,47,61],
 [11,16,47,62],[11,16,47,68],[11,16,47,69],
 [11,16,48,49],[11,16,48,50],[11,16,48,51],
 [11,16,48,52],[11,16,48,53],[11,16,48,57],
 [11,16,48,60],[11,16,48,61],[11,16,48,62],
 [11,16,48,68],[11,16,48,69],[11,16,49,50],
 [11,16,49,52],[11,16,49,57],[11,16,49,60],
 [11,16,49,61],[11,16,49,62],[11,16,49,68],
 [11,16,49,69],[11,16,50,51],[11,16,50,52],
 [11,16,50,62],[11,16,50,68],[11,16,51,52],
 [11,16,51,53],[11,16,51,57],[11,16,51,60],
 [11,16,51,61],[11,16,51,62],[11,16,51,68],
 [11,16,52,62],[11,16,53,60],[11,16,53,62],
 [11,16,53,68],[11,16,57,60],[11,16,60,62],
 [11,16,60,68],[11,16,60,69],[11,16,61,62],
 [11,16,61,68],[11,16,61,69],[11,16,62,68],
 [11,16,62,69],[11,17,18,19],[11,17,18,20],
 [11,17,18,23],[11,17,18,24],[11,17,18,41],
 [11,17,18,46],[11,17,18,47],[11,17,18,48],
 [11,17,18,49],[11,17,18,51],[11,17,18,53],
 [11,17,18,54],[11,17,18,55],[11,17,18,68],
 [11,17,19,23],[11,17,19,24],[11,17,19,27],
 [11,17,19,46],[11,17,19,49],[11,17,19,51],
 [11,17,19,54],[11,17,19,57],[11,17,19,62],
 [11,17,19,68],[11,17,20,23],[11,17,20,24],
 [11,17,20,27],[11,17,20,37],[11,17,20,41],
 [11,17,20,47],[11,17,20,49],[11,17,20,53],
 [11,17,20,57],[11,17,20,62],[11,17,20,68],
 [11,17,20,69],[11,17,23,24],[11,17,23,27],
 [11,17,23,34],[11,17,23,37],[11,17,23,46],
 [11,17,23,49],[11,17,23,50],[11,17,23,51],
 [11,17,23,53],[11,17,23,55],[11,17,23,57],
 [11,17,23,62],[11,17,23,68],[11,17,23,69],
 [11,17,24,27],[11,17,24,34],[11,17,24,37],
 [11,17,24,41],[11,17,24,46],[11,17,24,47],
 [11,17,24,48],[11,17,24,49],[11,17,24,51],
 [11,17,24,53],[11,17,24,54],[11,17,24,57],
 [11,17,24,62],[11,17,24,68],[11,17,24,69],
 [11,17,27,41],[11,17,27,46],[11,17,27,47],
 [11,17,27,48],[11,17,27,49],[11,17,27,51],
 [11,17,27,53],[11,17,27,54],[11,17,27,55],
 [11,17,27,62],[11,17,34,46],[11,17,34,48],
 [11,17,34,49],[11,17,34,55],[11,17,34,62],
 [11,17,34,69],[11,17,37,46],[11,17,37,47],
 [11,17,37,48],[11,17,37,54],[11,17,37,62],
 [11,17,41,46],[11,17,41,47],[11,17,41,49],
 [11,17,41,50],[11,17,41,53],[11,17,41,68],
 [11,17,46,48],[11,17,46,49],[11,17,46,50],
 [11,17,46,53],[11,17,46,55],[11,17,46,57],
 [11,17,46,62],[11,17,46,68],[11,17,46,69],
 [11,17,47,49],[11,17,47,50],[11,17,47,53],
 [11,17,47,55],[11,17,47,57],[11,17,47,62],
 [11,17,47,68],[11,17,47,69],[11,17,48,49],
 [11,17,48,50],[11,17,48,51],[11,17,48,53],
 [11,17,48,55],[11,17,48,57],[11,17,48,62],
 [11,17,48,68],[11,17,48,69],[11,17,49,50],
 [11,17,49,53],[11,17,49,54],[11,17,49,55],
 [11,17,49,57],[11,17,49,62],[11,17,49,68],
 [11,17,49,69],[11,17,50,51],[11,17,50,54],
 [11,17,50,62],[11,17,50,68],[11,17,51,53],
 [11,17,51,55],[11,17,51,57],[11,17,51,62],
 [11,17,51,68],[11,17,51,69],[11,17,53,54],
 [11,17,53,62],[11,17,53,68],[11,17,54,57],
 [11,17,54,62],[11,17,54,68],[11,17,54,69],
 [11,17,55,62],[11,17,55,69],[11,17,62,69],
 [11,18,19,20],[11,18,19,21],[11,18,19,23],
 [11,18,19,24],[11,18,19,25],[11,18,19,35],
 [11,18,19,41],[11,18,19,44],[11,18,19,46],
 [11,18,19,47],[11,18,19,52],[11,18,19,53],
 [11,18,19,54],[11,18,19,60],[11,18,19,61],
 [11,18,19,68],[11,18,20,23],[11,18,20,24],
 [11,18,20,25],[11,18,20,35],[11,18,20,41],
 [11,18,20,44],[11,18,20,46],[11,18,20,47],
 [11,18,20,49],[11,18,20,53],[11,18,20,55],
 [11,18,20,60],[11,18,20,68],[11,18,21,23],
 [11,18,21,24],[11,18,21,25],[11,18,21,35],
 [11,18,21,44],[11,18,21,46],[11,18,21,48],
 [11,18,21,51],[11,18,21,52],[11,18,21,53],
 [11,18,21,55],[11,18,21,60],[11,18,23,24],
 [11,18,23,25],[11,18,23,35],[11,18,23,41],
 [11,18,23,44],[11,18,23,46],[11,18,23,47],
 [11,18,23,51],[11,18,23,52],[11,18,23,53],
 [11,18,23,55],[11,18,23,60],[11,18,23,61],
 [11,18,23,68],[11,18,24,25],[11,18,24,41],
 [11,18,24,44],[11,18,24,46],[11,18,24,47],
 [11,18,24,48],[11,18,24,49],[11,18,24,51],
 [11,18,24,52],[11,18,24,53],[11,18,24,54],
 [11,18,24,55],[11,18,24,60],[11,18,24,68],
 [11,18,25,35],[11,18,25,41],[11,18,25,46],
 [11,18,25,47],[11,18,25,48],[11,18,25,49],
 [11,18,25,51],[11,18,25,52],[11,18,25,53],
 [11,18,25,54],[11,18,25,55],[11,18,25,60],
 [11,18,25,61],[11,18,35,41],[11,18,35,47],
 [11,18,35,48],[11,18,35,49],[11,18,35,68],
 [11,18,41,44],[11,18,41,47],[11,18,41,48],
 [11,18,41,49],[11,18,41,53],[11,18,41,61],
 [11,18,41,68],[11,18,44,47],[11,18,44,48],
 [11,18,44,49],[11,18,44,51],[11,18,44,52],
 [11,18,44,54],[11,18,44,68],[11,18,46,47],
 [11,18,46,48],[11,18,46,52],[11,18,46,53],
 [11,18,46,55],[11,18,46,60],[11,18,46,61],
 [11,18,46,68],[11,18,47,49],[11,18,47,51],
 [11,18,47,52],[11,18,47,53],[11,18,47,55],
 [11,18,47,60],[11,18,47,61],[11,18,47,68],
 [11,18,48,51],[11,18,48,52],[11,18,48,53],
 [11,18,48,55],[11,18,48,60],[11,18,48,61],
 [11,18,48,68],[11,18,49,52],[11,18,49,53],
 [11,18,49,54],[11,18,49,55],[11,18,49,60],
 [11,18,49,61],[11,18,49,68],[11,18,51,52],
 [11,18,51,53],[11,18,51,55],[11,18,51,60],
 [11,18,51,61],[11,18,51,68],[11,18,52,54],
 [11,18,53,54],[11,18,53,60],[11,18,53,68],
 [11,18,54,60],[11,18,54,61],[11,18,54,68],
 [11,18,55,60],[11,18,61,68],[11,19,20,23],
 [11,19,20,24],[11,19,20,25],[11,19,20,27],
 [11,19,20,41],[11,19,20,43],[11,19,20,44],
 [11,19,20,46],[11,19,20,47],[11,19,20,49],
 [11,19,20,60],[11,19,20,62],[11,19,20,64],
 [11,19,20,66],[11,19,20,68],[11,19,21,23],
 [11,19,21,24],[11,19,21,25],[11,19,21,27],
 [11,19,21,31],[11,19,21,41],[11,19,21,43],
 [11,19,21,44],[11,19,21,46],[11,19,21,49],
 [11,19,21,51],[11,19,21,52],[11,19,21,53],
 [11,19,21,57],[11,19,21,60],[11,19,21,61],
 [11,19,21,62],[11,19,21,64],[11,19,21,68],
 [11,19,23,24],[11,19,23,25],[11,19,23,27],
 [11,19,23,31],[11,19,23,35],[11,19,23,40],
 [11,19,23,41],[11,19,23,43],[11,19,23,44],
 [11,19,23,46],[11,19,23,47],[11,19,23,49],
 [11,19,23,52],[11,19,23,53],[11,19,23,57],
 [11,19,23,60],[11,19,23,61],[11,19,23,62],
 [11,19,23,64],[11,19,23,66],[11,19,23,68],
 [11,19,24,25],[11,19,24,27],[11,19,24,41],
 [11,19,24,43],[11,19,24,44],[11,19,24,46],
 [11,19,24,47],[11,19,24,49],[11,19,24,52],
 [11,19,24,53],[11,19,24,57],[11,19,24,60],
 [11,19,24,62],[11,19,24,63],[11,19,24,64],
 [11,19,24,66],[11,19,24,68],[11,19,25,27],
 [11,19,25,31],[11,19,25,35],[11,19,25,40],
 [11,19,25,41],[11,19,25,43],[11,19,25,46],
 [11,19,25,47],[11,19,25,49],[11,19,25,51],
 [11,19,25,53],[11,19,25,54],[11,19,25,57],
 [11,19,25,60],[11,19,25,61],[11,19,25,62],
 [11,19,25,64],[11,19,25,68],[11,19,27,31],
 [11,19,27,35],[11,19,27,40],[11,19,27,41],
 [11,19,27,46],[11,19,27,47],[11,19,27,49],
 [11,19,27,51],[11,19,27,52],[11,19,27,54],
 [11,19,27,60],[11,19,27,61],[11,19,27,62],
 [11,19,27,64],[11,19,27,66],[11,19,27,68],
 [11,19,31,41],[11,19,31,44],[11,19,31,53],
 [11,19,31,63],[11,19,31,68],[11,19,35,41],
 [11,19,35,47],[11,19,35,49],[11,19,35,57],
 [11,19,35,62],[11,19,35,63],[11,19,35,66],
 [11,19,35,68],[11,19,40,41],[11,19,40,49],
 [11,19,40,52],[11,19,40,53],[11,19,40,63],
 [11,19,40,64],[11,19,40,66],[11,19,41,43],
 [11,19,41,44],[11,19,41,46],[11,19,41,47],
 [11,19,41,49],[11,19,41,53],[11,19,41,60],
 [11,19,41,61],[11,19,41,62],[11,19,41,64],
 [11,19,41,68],[11,19,43,46],[11,19,43,47],
 [11,19,43,49],[11,19,43,52],[11,19,43,60],
 [11,19,43,62],[11,19,43,64],[11,19,43,66],
 [11,19,43,68],[11,19,44,46],[11,19,44,47],
 [11,19,44,49],[11,19,44,51],[11,19,44,52],
 [11,19,44,53],[11,19,44,57],[11,19,44,62],
 [11,19,44,64],[11,19,44,66],[11,19,44,68],
 [11,19,46,47],[11,19,46,49],[11,19,46,52],
 [11,19,46,53],[11,19,46,57],[11,19,46,60],
 [11,19,46,61],[11,19,46,62],[11,19,46,63],
 [11,19,46,66],[11,19,46,68],[11,19,47,49],
 [11,19,47,51],[11,19,47,52],[11,19,47,53],
 [11,19,47,57],[11,19,47,60],[11,19,47,61],
 [11,19,47,62],[11,19,47,66],[11,19,47,68],
 [11,19,49,52],[11,19,49,53],[11,19,49,54],
 [11,19,49,57],[11,19,49,60],[11,19,49,61],
 [11,19,49,62],[11,19,49,63],[11,19,49,66],
 [11,19,49,68],[11,19,51,52],[11,19,51,53],
 [11,19,51,60],[11,19,51,61],[11,19,51,66],
 [11,19,51,68],[11,19,52,54],[11,19,52,62],
 [11,19,52,63],[11,19,53,54],[11,19,53,60],
 [11,19,53,62],[11,19,53,63],[11,19,53,64],
 [11,19,53,68],[11,19,54,57],[11,19,54,60],
 [11,19,54,62],[11,19,54,66],[11,19,54,68],
 [11,19,57,60],[11,19,57,61],[11,19,60,62],
 [11,19,60,63],[11,19,60,66],[11,19,60,68],
 [11,19,61,62],[11,19,61,63],[11,19,61,66],
 [11,19,61,68],[11,19,62,63],[11,19,62,66],
 [11,19,62,68],[11,19,63,64],[11,19,63,68],
 [11,19,64,66],[11,19,64,68],[11,20,23,24],
 [11,20,23,25],[11,20,23,27],[11,20,23,34],
 [11,20,23,37],[11,20,23,41],[11,20,23,43],
 [11,20,23,44],[11,20,23,46],[11,20,23,47],
 [11,20,23,49],[11,20,23,53],[11,20,23,55],
 [11,20,23,57],[11,20,23,60],[11,20,23,62],
 [11,20,23,64],[11,20,23,66],[11,20,23,68],
 [11,20,23,69],[11,20,24,25],[11,20,24,27],
 [11,20,24,31],[11,20,24,34],[11,20,24,37],
 [11,20,24,38],[11,20,24,40],[11,20,24,41],
 [11,20,24,43],[11,20,24,44],[11,20,24,45],
 [11,20,24,46],[11,20,24,47],[11,20,24,49],
 [11,20,24,53],[11,20,24,55],[11,20,24,57],
 [11,20,24,60],[11,20,24,62],[11,20,24,63],
 [11,20,24,64],[11,20,24,66],[11,20,24,68],
 [11,20,24,69],[11,20,25,27],[11,20,25,31],
 [11,20,25,34],[11,20,25,35],[11,20,25,37],
 [11,20,25,40],[11,20,25,41],[11,20,25,43],
 [11,20,25,45],[11,20,25,46],[11,20,25,47],
 [11,20,25,49],[11,20,25,53],[11,20,25,55],
 [11,20,25,60],[11,20,25,62],[11,20,25,68],
 [11,20,25,69],[11,20,27,31],[11,20,27,35],
 [11,20,27,40],[11,20,27,41],[11,20,27,45],
 [11,20,27,46],[11,20,27,47],[11,20,27,49],
 [11,20,27,53],[11,20,27,55],[11,20,27,60],
 [11,20,27,62],[11,20,27,64],[11,20,27,66],
 [11,20,27,68],[11,20,31,41],[11,20,31,44],
 [11,20,31,47],[11,20,31,49],[11,20,31,53],
 [11,20,31,63],[11,20,31,66],[11,20,31,68],
 [11,20,31,69],[11,20,34,43],[11,20,34,44],
 [11,20,34,45],[11,20,34,46],[11,20,34,47],
 [11,20,34,49],[11,20,34,55],[11,20,34,60],
 [11,20,34,62],[11,20,34,69],[11,20,35,37],
 [11,20,35,41],[11,20,35,45],[11,20,35,47],
 [11,20,35,49],[11,20,35,55],[11,20,35,57],
 [11,20,35,62],[11,20,35,63],[11,20,35,66],
 [11,20,35,68],[11,20,35,69],[11,20,37,38],
 [11,20,37,40],[11,20,37,45],[11,20,37,46],
 [11,20,37,47],[11,20,37,60],[11,20,37,62],
 [11,20,37,64],[11,20,38,40],[11,20,38,41],
 [11,20,38,47],[11,20,38,49],[11,20,38,53],
 [11,20,38,60],[11,20,38,62],[11,20,38,63],
 [11,20,38,64],[11,20,38,68],[11,20,40,41],
 [11,20,40,45],[11,20,40,47],[11,20,40,49],
 [11,20,40,53],[11,20,40,55],[11,20,40,63],
 [11,20,40,64],[11,20,40,66],[11,20,40,68],
 [11,20,41,43],[11,20,41,44],[11,20,41,46],
 [11,20,41,47],[11,20,41,49],[11,20,41,53],
 [11,20,41,60],[11,20,41,62],[11,20,41,63],
 [11,20,41,64],[11,20,41,68],[11,20,43,46],
 [11,20,43,47],[11,20,43,49],[11,20,43,55],
 [11,20,43,60],[11,20,43,62],[11,20,43,64],
 [11,20,43,66],[11,20,43,68],[11,20,43,69],
 [11,20,44,45],[11,20,44,46],[11,20,44,47],
 [11,20,44,49],[11,20,44,53],[11,20,44,55],
 [11,20,44,57],[11,20,44,62],[11,20,44,63],
 [11,20,44,64],[11,20,44,66],[11,20,44,68],
 [11,20,44,69],[11,20,45,46],[11,20,45,49],
 [11,20,45,53],[11,20,45,55],[11,20,45,57],
 [11,20,45,60],[11,20,45,62],[11,20,45,63],
 [11,20,45,66],[11,20,45,68],[11,20,45,69],
 [11,20,46,47],[11,20,46,49],[11,20,46,53],
 [11,20,46,55],[11,20,46,57],[11,20,46,60],
 [11,20,46,62],[11,20,46,63],[11,20,46,66],
 [11,20,46,68],[11,20,46,69],[11,20,47,49],
 [11,20,47,53],[11,20,47,55],[11,20,47,57],
 [11,20,47,60],[11,20,47,62],[11,20,47,63],
 [11,20,47,64],[11,20,47,66],[11,20,47,68],
 [11,20,47,69],[11,20,49,53],[11,20,49,55],
 [11,20,49,57],[11,20,49,60],[11,20,49,62],
 [11,20,49,63],[11,20,49,64],[11,20,49,66],
 [11,20,49,68],[11,20,49,69],[11,20,53,60],
 [11,20,53,62],[11,20,53,64],[11,20,53,68],
 [11,20,55,60],[11,20,55,62],[11,20,55,66],
 [11,20,55,69],[11,20,57,60],[11,20,60,62],
 [11,20,60,66],[11,20,60,68],[11,20,60,69],
 [11,20,62,63],[11,20,62,66],[11,20,62,68],
 [11,20,62,69],[11,20,63,64],[11,20,63,68],
 [11,20,64,66],[11,20,64,68],[11,20,64,69],
 [11,21,23,24],[11,21,23,25],[11,21,23,27],
 [11,21,23,31],[11,21,23,34],[11,21,23,35],
 [11,21,23,37],[11,21,23,41],[11,21,23,43],
 [11,21,23,44],[11,21,23,46],[11,21,23,49],
 [11,21,23,50],[11,21,23,51],[11,21,23,52],
 [11,21,23,53],[11,21,23,55],[11,21,23,57],
 [11,21,23,60],[11,21,23,61],[11,21,23,62],
 [11,21,23,64],[11,21,23,68],[11,21,23,69],
 [11,21,24,25],[11,21,24,27],[11,21,24,31],
 [11,21,24,34],[11,21,24,37],[11,21,24,41],
 [11,21,24,43],[11,21,24,44],[11,21,24,45],
 [11,21,24,46],[11,21,24,48],[11,21,24,49],
 [11,21,24,51],[11,21,24,53],[11,21,24,55],
 [11,21,24,57],[11,21,24,60],[11,21,24,62],
 [11,21,24,68],[11,21,24,69],[11,21,25,27],
 [11,21,25,31],[11,21,25,34],[11,21,25,35],
 [11,21,25,37],[11,21,25,41],[11,21,25,43],
 [11,21,25,45],[11,21,25,46],[11,21,25,48],
 [11,21,25,49],[11,21,25,50],[11,21,25,51],
 [11,21,25,52],[11,21,25,53],[11,21,25,55],
 [11,21,25,57],[11,21,25,60],[11,21,25,61],
 [11,21,25,62],[11,21,25,64],[11,21,25,68],
 [11,21,25,69],[11,21,27,35],[11,21,27,41],
 [11,21,27,45],[11,21,27,46],[11,21,27,48],
 [11,21,27,49],[11,21,27,51],[11,21,27,53],
 [11,21,27,55],[11,21,27,60],[11,21,27,61],
 [11,21,27,62],[11,21,27,68],[11,21,31,37],
 [11,21,31,38],[11,21,31,44],[11,21,31,48],
 [11,21,31,49],[11,21,31,50],[11,21,31,55],
 [11,21,31,69],[11,21,34,43],[11,21,34,44],
 [11,21,34,45],[11,21,34,46],[11,21,34,48],
 [11,21,34,49],[11,21,34,55],[11,21,34,60],
 [11,21,34,61],[11,21,34,62],[11,21,34,69],
 [11,21,35,37],[11,21,35,38],[11,21,35,45],
 [11,21,35,48],[11,21,35,49],[11,21,35,55],
 [11,21,35,57],[11,21,35,62],[11,21,35,68],
 [11,21,37,38],[11,21,37,43],[11,21,37,45],
 [11,21,37,46],[11,21,37,48],[11,21,37,60],
 [11,21,37,61],[11,21,37,62],[11,21,38,43],
 [11,21,38,46],[11,21,38,49],[11,21,38,51],
 [11,21,38,53],[11,21,38,55],[11,21,38,60],
 [11,21,38,61],[11,21,38,62],[11,21,38,68],
 [11,21,41,43],[11,21,41,44],[11,21,41,46],
 [11,21,41,48],[11,21,41,49],[11,21,41,50],
 [11,21,41,53],[11,21,41,60],[11,21,41,61],
 [11,21,41,62],[11,21,41,68],[11,21,43,46],
 [11,21,43,48],[11,21,43,49],[11,21,43,50],
 [11,21,43,52],[11,21,43,53],[11,21,43,55],
 [11,21,43,57],[11,21,43,60],[11,21,43,62],
 [11,21,43,64],[11,21,43,68],[11,21,43,69],
 [11,21,44,45],[11,21,44,46],[11,21,44,48],
 [11,21,44,49],[11,21,44,51],[11,21,44,52],
 [11,21,44,53],[11,21,44,55],[11,21,44,57],
 [11,21,44,62],[11,21,44,64],[11,21,44,68],
 [11,21,44,69],[11,21,45,46],[11,21,45,48],
 [11,21,45,49],[11,21,45,50],[11,21,45,51],
 [11,21,45,52],[11,21,45,53],[11,21,45,55],
 [11,21,45,57],[11,21,45,60],[11,21,45,61],
 [11,21,45,62],[11,21,45,68],[11,21,45,69],
 [11,21,46,48],[11,21,46,49],[11,21,46,50],
 [11,21,46,52],[11,21,46,53],[11,21,46,55],
 [11,21,46,57],[11,21,46,60],[11,21,46,61],
 [11,21,46,62],[11,21,46,68],[11,21,46,69],
 [11,21,48,49],[11,21,48,50],[11,21,48,51],
 [11,21,48,52],[11,21,48,53],[11,21,48,55],
 [11,21,48,57],[11,21,48,60],[11,21,48,61],
 [11,21,48,62],[11,21,48,64],[11,21,48,68],
 [11,21,48,69],[11,21,49,50],[11,21,49,52],
 [11,21,49,55],[11,21,49,60],[11,21,49,61],
 [11,21,49,62],[11,21,49,64],[11,21,49,68],
 [11,21,49,69],[11,21,50,51],[11,21,50,52],
 [11,21,50,62],[11,21,50,68],[11,21,51,52],
 [11,21,51,53],[11,21,51,60],[11,21,51,62],
 [11,21,51,68],[11,21,52,62],[11,21,53,60],
 [11,21,53,62],[11,21,53,64],[11,21,53,68],
 [11,21,55,60],[11,21,55,61],[11,21,55,62],
 [11,21,55,69],[11,21,57,60],[11,21,57,61],
 [11,21,60,62],[11,21,60,68],[11,21,60,69],
 [11,21,61,62],[11,21,61,68],[11,21,61,69],
 [11,21,62,68],[11,21,62,69],[11,21,64,68],
 [11,21,64,69],[11,23,24,25],[11,23,24,27],
 [11,23,24,34],[11,23,24,37],[11,23,24,41],
 [11,23,24,43],[11,23,24,44],[11,23,24,46],
 [11,23,24,47],[11,23,24,49],[11,23,24,52],
 [11,23,24,53],[11,23,24,55],[11,23,24,57],
 [11,23,24,60],[11,23,24,62],[11,23,24,66],
 [11,23,24,68],[11,23,24,69],[11,23,25,27],
 [11,23,25,31],[11,23,25,34],[11,23,25,35],
 [11,23,25,37],[11,23,25,40],[11,23,25,41],
 [11,23,25,43],[11,23,25,46],[11,23,25,47],
 [11,23,25,49],[11,23,25,50],[11,23,25,51],
 [11,23,25,52],[11,23,25,53],[11,23,25,55],
 [11,23,25,57],[11,23,25,60],[11,23,25,61],
 [11,23,25,62],[11,23,25,64],[11,23,25,68],
 [11,23,25,69],[11,23,27,31],[11,23,27,35],
 [11,23,27,40],[11,23,27,41],[11,23,27,46],
 [11,23,27,47],[11,23,27,49],[11,23,27,52],
 [11,23,27,53],[11,23,27,55],[11,23,27,60],
 [11,23,27,61],[11,23,27,62],[11,23,27,64],
 [11,23,27,66],[11,23,27,68],[11,23,30,35],
 [11,23,30,41],[11,23,30,44],[11,23,30,49],
 [11,23,30,53],[11,23,30,61],[11,23,30,62],
 [11,23,30,68],[11,23,31,37],[11,23,31,41],
 [11,23,31,44],[11,23,31,47],[11,23,31,49],
 [11,23,31,53],[11,23,31,55],[11,23,31,66],
 [11,23,31,68],[11,23,31,69],[11,23,34,43],
 [11,23,34,44],[11,23,34,46],[11,23,34,47],
 [11,23,34,49],[11,23,34,55],[11,23,34,60],
 [11,23,34,61],[11,23,34,62],[11,23,34,69],
 [11,23,35,37],[11,23,35,41],[11,23,35,47],
 [11,23,35,49],[11,23,35,55],[11,23,35,57],
 [11,23,35,62],[11,23,35,66],[11,23,35,68],
 [11,23,35,69],[11,23,37,40],[11,23,37,43],
 [11,23,37,46],[11,23,37,47],[11,23,37,60],
 [11,23,37,61],[11,23,37,62],[11,23,37,64],
 [11,23,40,41],[11,23,40,47],[11,23,40,49],
 [11,23,40,52],[11,23,40,53],[11,23,40,55],
 [11,23,40,64],[11,23,40,66],[11,23,40,68],
 [11,23,40,69],[11,23,41,43],[11,23,41,44],
 [11,23,41,46],[11,23,41,47],[11,23,41,49],
 [11,23,41,53],[11,23,41,60],[11,23,41,61],
 [11,23,41,62],[11,23,41,64],[11,23,41,68],
 [11,23,43,46],[11,23,43,47],[11,23,43,49],
 [11,23,43,52],[11,23,43,53],[11,23,43,55],
 [11,23,43,57],[11,23,43,60],[11,23,43,62],
 [11,23,43,64],[11,23,43,66],[11,23,43,68],
 [11,23,43,69],[11,23,44,46],[11,23,44,47],
 [11,23,44,49],[11,23,44,51],[11,23,44,52],
 [11,23,44,53],[11,23,44,55],[11,23,44,57],
 [11,23,44,62],[11,23,44,66],[11,23,44,68],
 [11,23,44,69],[11,23,46,47],[11,23,46,49],
 [11,23,46,52],[11,23,46,53],[11,23,46,55],
 [11,23,46,57],[11,23,46,60],[11,23,46,61],
 [11,23,46,62],[11,23,46,66],[11,23,46,68],
 [11,23,46,69],[11,23,47,49],[11,23,47,50],
 [11,23,47,51],[11,23,47,52],[11,23,47,53],
 [11,23,47,55],[11,23,47,57],[11,23,47,60],
 [11,23,47,61],[11,23,47,62],[11,23,47,64],
 [11,23,47,66],[11,23,47,68],[11,23,47,69],
 [11,23,49,52],[11,23,49,53],[11,23,49,55],
 [11,23,49,60],[11,23,49,61],[11,23,49,62],
 [11,23,49,64],[11,23,49,66],[11,23,49,68],
 [11,23,49,69],[11,23,50,51],[11,23,50,52],
 [11,23,50,55],[11,23,50,60],[11,23,50,62],
 [11,23,50,64],[11,23,50,68],[11,23,51,52],
 [11,23,51,53],[11,23,51,55],[11,23,51,60],
 [11,23,51,61],[11,23,51,62],[11,23,51,64],
 [11,23,51,68],[11,23,51,69],[11,23,52,62],
 [11,23,53,60],[11,23,53,62],[11,23,53,64],
 [11,23,53,68],[11,23,55,60],[11,23,55,61],
 [11,23,55,62],[11,23,55,66],[11,23,55,69],
 [11,23,57,60],[11,23,57,61],[11,23,60,62],
 [11,23,60,66],[11,23,60,68],[11,23,60,69],
 [11,23,61,62],[11,23,61,66],[11,23,61,68],
 [11,23,61,69],[11,23,62,66],[11,23,62,68],
 [11,23,62,69],[11,23,64,66],[11,23,64,68],
 [11,23,64,69],[11,24,25,27],[11,24,25,28],
 [11,24,25,34],[11,24,25,37],[11,24,25,41],
 [11,24,25,43],[11,24,25,45],[11,24,25,46],
 [11,24,25,47],[11,24,25,48],[11,24,25,49],
 [11,24,25,51],[11,24,25,53],[11,24,25,54],
 [11,24,25,55],[11,24,25,57],[11,24,25,60],
 [11,24,25,62],[11,24,25,68],[11,24,25,69],
 [11,24,27,41],[11,24,27,45],[11,24,27,46],
 [11,24,27,47],[11,24,27,48],[11,24,27,49],
 [11,24,27,51],[11,24,27,52],[11,24,27,53],
 [11,24,27,54],[11,24,27,55],[11,24,27,60],
 [11,24,27,62],[11,24,27,66],[11,24,27,68],
 [11,24,28,37],[11,24,28,49],[11,24,28,52],
 [11,24,28,55],[11,24,28,60],[11,24,28,68],
 [11,24,28,69],[11,24,29,31],[11,24,29,41],
 [11,24,29,44],[11,24,29,47],[11,24,29,49],
 [11,24,29,53],[11,24,29,68],[11,24,30,41],
 [11,24,30,44],[11,24,30,45],[11,24,30,47],
 [11,24,30,48],[11,24,30,49],[11,24,30,53],
 [11,24,30,62],[11,24,30,68],[11,24,31,37],
 [11,24,31,41],[11,24,31,44],[11,24,31,47],
 [11,24,31,48],[11,24,31,49],[11,24,31,53],
 [11,24,31,68],[11,24,31,69],[11,24,34,43],
 [11,24,34,44],[11,24,34,45],[11,24,34,46],
 [11,24,34,47],[11,24,34,48],[11,24,34,49],
 [11,24,34,55],[11,24,34,60],[11,24,34,62],
 [11,24,34,69],[11,24,37,38],[11,24,37,40],
 [11,24,37,43],[11,24,37,45],[11,24,37,46],
 [11,24,37,47],[11,24,37,48],[11,24,37,54],
 [11,24,37,60],[11,24,37,62],[11,24,37,64],
 [11,24,38,40],[11,24,38,41],[11,24,38,47],
 [11,24,38,49],[11,24,38,52],[11,24,38,53],
 [11,24,38,55],[11,24,38,63],[11,24,38,64],
 [11,24,38,68],[11,24,40,41],[11,24,40,45],
 [11,24,40,47],[11,24,40,48],[11,24,40,49],
 [11,24,40,52],[11,24,40,53],[11,24,40,55],
 [11,24,40,63],[11,24,40,64],[11,24,40,68],
 [11,24,40,69],[11,24,41,43],[11,24,41,44],
 [11,24,41,46],[11,24,41,47],[11,24,41,48],
 [11,24,41,49],[11,24,41,53],[11,24,41,60],
 [11,24,41,62],[11,24,41,63],[11,24,41,64],
 [11,24,41,68],[11,24,43,46],[11,24,43,47],
 [11,24,43,48],[11,24,43,49],[11,24,43,52],
 [11,24,43,53],[11,24,43,55],[11,24,43,57],
 [11,24,43,60],[11,24,43,62],[11,24,43,66],
 [11,24,43,68],[11,24,43,69],[11,24,44,45],
 [11,24,44,46],[11,24,44,47],[11,24,44,48],
 [11,24,44,49],[11,24,44,51],[11,24,44,52],
 [11,24,44,53],[11,24,44,54],[11,24,44,55],
 [11,24,44,57],[11,24,44,62],[11,24,44,63],
 [11,24,44,64],[11,24,44,66],[11,24,44,68],
 [11,24,44,69],[11,24,45,46],[11,24,45,48],
 [11,24,45,49],[11,24,45,51],[11,24,45,53],
 [11,24,45,55],[11,24,45,57],[11,24,45,60],
 [11,24,45,62],[11,24,45,66],[11,24,45,68],
 [11,24,45,69],[11,24,46,47],[11,24,46,48],
 [11,24,46,49],[11,24,46,52],[11,24,46,53],
 [11,24,46,55],[11,24,46,57],[11,24,46,60],
 [11,24,46,62],[11,24,46,66],[11,24,46,68],
 [11,24,46,69],[11,24,47,49],[11,24,47,51],
 [11,24,47,52],[11,24,47,53],[11,24,47,55],
 [11,24,47,57],[11,24,47,60],[11,24,47,62],
 [11,24,47,63],[11,24,47,64],[11,24,47,66],
 [11,24,47,68],[11,24,47,69],[11,24,48,49],
 [11,24,48,51],[11,24,48,52],[11,24,48,53],
 [11,24,48,55],[11,24,48,57],[11,24,48,60],
 [11,24,48,62],[11,24,48,63],[11,24,48,64],
 [11,24,48,66],[11,24,48,68],[11,24,48,69],
 [11,24,49,52],[11,24,49,53],[11,24,49,54],
 [11,24,49,55],[11,24,49,57],[11,24,49,60],
 [11,24,49,62],[11,24,49,63],[11,24,49,64],
 [11,24,49,66],[11,24,49,68],[11,24,49,69],
 [11,24,51,52],[11,24,51,53],[11,24,51,55],
 [11,24,51,57],[11,24,51,60],[11,24,51,62],
 [11,24,51,63],[11,24,51,64],[11,24,51,66],
 [11,24,51,68],[11,24,51,69],[11,24,52,54],
 [11,24,52,62],[11,24,53,54],[11,24,53,60],
 [11,24,53,62],[11,24,53,63],[11,24,53,64],
 [11,24,53,68],[11,24,54,57],[11,24,54,60],
 [11,24,54,62],[11,24,54,68],[11,24,54,69],
 [11,24,55,60],[11,24,55,62],[11,24,55,66],
 [11,24,55,69],[11,24,57,60],[11,24,60,62],
 [11,24,60,66],[11,24,60,68],[11,24,60,69],
 [11,24,62,66],[11,24,62,68],[11,24,62,69],
 [11,24,63,64],[11,24,63,68],[11,24,63,69],
 [11,24,64,66],[11,24,64,68],[11,24,64,69],
 [11,25,27,28],[11,25,27,31],[11,25,27,35],
 [11,25,27,40],[11,25,27,41],[11,25,27,45],
 [11,25,27,46],[11,25,27,47],[11,25,27,48],
 [11,25,27,49],[11,25,27,51],[11,25,27,53],
 [11,25,27,54],[11,25,27,55],[11,25,27,60],
 [11,25,27,61],[11,25,27,62],[11,25,27,64],
 [11,25,27,68],[11,25,28,35],[11,25,28,37],
 [11,25,28,43],[11,25,28,46],[11,25,28,49],
 [11,25,28,50],[11,25,28,51],[11,25,28,52],
 [11,25,28,55],[11,25,28,57],[11,25,28,60],
 [11,25,28,61],[11,25,28,68],[11,25,28,69],
 [11,25,31,37],[11,25,31,41],[11,25,31,47],
 [11,25,31,48],[11,25,31,49],[11,25,31,53],
 [11,25,31,55],[11,25,31,68],[11,25,31,69],
 [11,25,34,43],[11,25,34,45],[11,25,34,46],
 [11,25,34,47],[11,25,34,48],[11,25,34,49],
 [11,25,34,55],[11,25,34,60],[11,25,34,61],
 [11,25,34,62],[11,25,34,69],[11,25,35,37],
 [11,25,35,41],[11,25,35,45],[11,25,35,47],
 [11,25,35,48],[11,25,35,49],[11,25,35,55],
 [11,25,35,57],[11,25,35,62],[11,25,35,68],
 [11,25,35,69],[11,25,37,40],[11,25,37,43],
 [11,25,37,45],[11,25,37,46],[11,25,37,47],
 [11,25,37,48],[11,25,37,54],[11,25,37,60],
 [11,25,37,61],[11,25,37,62],[11,25,37,64],
 [11,25,40,41],[11,25,40,45],[11,25,40,47],
 [11,25,40,48],[11,25,40,49],[11,25,40,50],
 [11,25,40,52],[11,25,40,53],[11,25,40,55],
 [11,25,40,64],[11,25,40,68],[11,25,40,69],
 [11,25,41,43],[11,25,41,46],[11,25,41,47],
 [11,25,41,48],[11,25,41,49],[11,25,41,53],
 [11,25,41,60],[11,25,41,61],[11,25,41,62],
 [11,25,41,64],[11,25,41,68],[11,25,43,46],
 [11,25,43,47],[11,25,43,48],[11,25,43,49],
 [11,25,43,50],[11,25,43,52],[11,25,43,53],
 [11,25,43,55],[11,25,43,57],[11,25,43,60],
 [11,25,43,62],[11,25,43,64],[11,25,43,68],
 [11,25,43,69],[11,25,45,46],[11,25,45,48],
 [11,25,45,49],[11,25,45,50],[11,25,45,51],
 [11,25,45,52],[11,25,45,53],[11,25,45,55],
 [11,25,45,57],[11,25,45,60],[11,25,45,61],
 [11,25,45,62],[11,25,45,68],[11,25,45,69],
 [11,25,46,47],[11,25,46,48],[11,25,46,49],
 [11,25,46,50],[11,25,46,52],[11,25,46,53],
 [11,25,46,55],[11,25,46,57],[11,25,46,60],
 [11,25,46,61],[11,25,46,62],[11,25,46,68],
 [11,25,46,69],[11,25,47,49],[11,25,47,50],
 [11,25,47,51],[11,25,47,52],[11,25,47,53],
 [11,25,47,55],[11,25,47,57],[11,25,47,60],
 [11,25,47,61],[11,25,47,62],[11,25,47,64],
 [11,25,47,68],[11,25,47,69],[11,25,48,49],
 [11,25,48,50],[11,25,48,51],[11,25,48,52],
 [11,25,48,53],[11,25,48,55],[11,25,48,57],
 [11,25,48,60],[11,25,48,61],[11,25,48,62],
 [11,25,48,64],[11,25,48,68],[11,25,48,69],
 [11,25,49,50],[11,25,49,52],[11,25,49,53],
 [11,25,49,54],[11,25,49,55],[11,25,49,57],
 [11,25,49,60],[11,25,49,61],[11,25,49,62],
 [11,25,49,64],[11,25,49,68],[11,25,49,69],
 [11,25,50,51],[11,25,50,52],[11,25,50,54],
 [11,25,50,62],[11,25,51,52],[11,25,51,53],
 [11,25,51,55],[11,25,51,57],[11,25,51,60],
 [11,25,51,61],[11,25,51,62],[11,25,51,64],
 [11,25,51,68],[11,25,51,69],[11,25,52,54],
 [11,25,52,62],[11,25,53,54],[11,25,53,60],
 [11,25,53,62],[11,25,53,64],[11,25,53,68],
 [11,25,54,57],[11,25,54,60],[11,25,54,61],
 [11,25,54,62],[11,25,54,68],[11,25,54,69],
 [11,25,55,60],[11,25,55,61],[11,25,55,62],
 [11,25,55,69],[11,25,57,60],[11,25,57,61],
 [11,25,60,62],[11,25,60,68],[11,25,60,69],
 [11,25,61,62],[11,25,61,68],[11,25,61,69],
 [11,25,62,68],[11,25,62,69],[11,25,64,68],
 [11,25,64,69],[11,27,28,35],[11,27,28,52],
 [11,27,28,55],[11,27,28,60],[11,27,28,61],
 [11,27,28,68],[11,27,31,41],[11,27,31,47],
 [11,27,31,48],[11,27,31,49],[11,27,31,53],
 [11,27,31,55],[11,27,31,66],[11,27,31,68],
 [11,27,35,41],[11,27,35,45],[11,27,35,47],
 [11,27,35,48],[11,27,35,49],[11,27,35,55],
 [11,27,35,62],[11,27,35,66],[11,27,35,68],
 [11,27,40,41],[11,27,40,47],[11,27,40,48],
 [11,27,40,49],[11,27,40,52],[11,27,40,53],
 [11,27,40,55],[11,27,40,64],[11,27,40,66],
 [11,27,40,68],[11,27,41,46],[11,27,41,47],
 [11,27,41,48],[11,27,41,49],[11,27,41,53],
 [11,27,41,60],[11,27,41,61],[11,27,41,62],
 [11,27,41,64],[11,27,41,68],[11,27,45,46],
 [11,27,45,48],[11,27,45,49],[11,27,45,51],
 [11,27,45,53],[11,27,45,55],[11,27,45,60],
 [11,27,45,61],[11,27,45,62],[11,27,45,66],
 [11,27,45,68],[11,27,46,47],[11,27,46,48],
 [11,27,46,49],[11,27,46,52],[11,27,46,53],
 [11,27,46,55],[11,27,46,60],[11,27,46,61],
 [11,27,46,62],[11,27,46,66],[11,27,46,68],
 [11,27,47,49],[11,27,47,51],[11,27,47,52],
 [11,27,47,53],[11,27,47,55],[11,27,47,60],
 [11,27,47,61],[11,27,47,62],[11,27,47,64],
 [11,27,47,66],[11,27,47,68],[11,27,48,49],
 [11,27,48,51],[11,27,48,52],[11,27,48,53],
 [11,27,48,55],[11,27,48,60],[11,27,48,61],
 [11,27,48,62],[11,27,48,64],[11,27,48,66],
 [11,27,48,68],[11,27,49,52],[11,27,49,53],
 [11,27,49,55],[11,27,49,60],[11,27,49,61],
 [11,27,49,62],[11,27,49,64],[11,27,49,66],
 [11,27,49,68],[11,27,51,52],[11,27,51,53],
 [11,27,51,60],[11,27,51,61],[11,27,51,62],
 [11,27,51,64],[11,27,51,66],[11,27,51,68],
 [11,27,52,54],[11,27,52,62],[11,27,53,54],
 [11,27,53,60],[11,27,53,62],[11,27,53,64],
 [11,27,53,68],[11,27,54,60],[11,27,54,61],
 [11,27,54,62],[11,27,54,68],[11,27,55,60],
 [11,27,55,61],[11,27,55,62],[11,27,55,66],
 [11,27,60,62],[11,27,60,66],[11,27,60,68],
 [11,27,61,62],[11,27,61,66],[11,27,61,68],
 [11,27,62,66],[11,27,62,68],[11,27,64,66],
 [11,27,64,68],[11,28,35,49],[11,28,35,55],
 [11,28,35,69],[11,28,37,43],[11,28,43,52],
 [11,28,43,55],[11,28,43,60],[11,28,43,69],
 [11,28,46,50],[11,28,46,52],[11,28,46,55],
 [11,28,46,57],[11,28,46,60],[11,28,46,61],
 [11,28,46,68],[11,28,46,69],[11,28,49,52],
 [11,28,49,55],[11,28,49,57],[11,28,49,60],
 [11,28,49,61],[11,28,49,68],[11,28,49,69],
 [11,28,50,52],[11,28,50,55],[11,28,50,60],
 [11,28,50,68],[11,28,51,52],[11,28,51,55],
 [11,28,51,57],[11,28,51,60],[11,28,51,61],
 [11,28,51,68],[11,28,51,69],[11,28,55,60],
 [11,28,55,69],[11,28,57,60],[11,28,61,68],
 [11,29,31,41],[11,29,31,44],[11,29,31,47],
 [11,29,31,49],[11,29,31,53],[11,29,31,68],
 [11,29,35,41],[11,29,35,47],[11,29,35,49],
 [11,29,35,62],[11,29,35,66],[11,29,35,68],
 [11,29,40,41],[11,29,40,47],[11,29,40,49],
 [11,29,40,52],[11,29,40,53],[11,29,40,64],
 [11,29,40,66],[11,29,40,68],[11,29,41,43],
 [11,29,41,44],[11,29,41,46],[11,29,41,47],
 [11,29,41,49],[11,29,41,53],[11,29,41,60],
 [11,29,41,61],[11,29,41,62],[11,29,41,64],
 [11,29,41,68],[11,29,43,46],[11,29,43,47],
 [11,29,43,49],[11,29,43,52],[11,29,43,53],
 [11,29,43,60],[11,29,43,62],[11,29,43,64],
 [11,29,43,68],[11,29,44,46],[11,29,44,47],
 [11,29,44,49],[11,29,44,52],[11,29,44,53],
 [11,29,44,64],[11,29,44,68],[11,29,46,47],
 [11,29,46,49],[11,29,46,52],[11,29,46,53],
 [11,29,46,60],[11,29,46,61],[11,29,46,62],
 [11,29,46,66],[11,29,46,68],[11,29,47,49],
 [11,29,47,51],[11,29,47,52],[11,29,47,53],
 [11,29,47,60],[11,29,47,61],[11,29,47,62],
 [11,29,47,64],[11,29,47,66],[11,29,47,68],
 [11,29,49,52],[11,29,49,53],[11,29,49,60],
 [11,29,49,61],[11,29,49,62],[11,29,49,64],
 [11,29,49,68],[11,29,51,52],[11,29,51,53],
 [11,29,51,60],[11,29,51,61],[11,29,51,62],
 [11,29,51,64],[11,29,51,66],[11,29,51,68],
 [11,29,52,62],[11,29,53,60],[11,29,53,62],
 [11,29,53,64],[11,29,53,68],[11,29,60,62],
 [11,29,60,66],[11,29,60,68],[11,29,61,62],
 [11,29,61,66],[11,29,61,68],[11,29,62,66],
 [11,29,62,68],[11,29,64,66],[11,29,64,68],
 [11,30,35,41],[11,30,35,47],[11,30,35,48],
 [11,30,35,49],[11,30,35,68],[11,30,41,44],
 [11,30,41,47],[11,30,41,49],[11,30,41,50],
 [11,30,41,53],[11,30,41,61],[11,30,41,68],
 [11,30,44,47],[11,30,44,48],[11,30,44,49],
 [11,30,44,53],[11,30,44,68],[11,30,45,48],
 [11,30,45,50],[11,30,45,60],[11,30,45,62],
 [11,30,45,68],[11,30,47,49],[11,30,47,50],
 [11,30,47,53],[11,30,47,61],[11,30,47,62],
 [11,30,47,68],[11,30,48,50],[11,30,48,60],
 [11,30,48,68],[11,30,49,50],[11,30,49,53],
 [11,30,49,60],[11,30,49,61],[11,30,49,68],
 [11,30,50,60],[11,30,50,62],[11,30,50,68],
 [11,30,53,60],[11,30,53,62],[11,30,53,68],
 [11,30,60,62],[11,30,60,68],[11,30,61,68],
 [11,30,62,68],[11,31,37,38],[11,31,37,47],
 [11,31,37,48],[11,31,38,41],[11,31,38,47],
 [11,31,38,49],[11,31,38,53],[11,31,38,55],
 [11,31,38,63],[11,31,38,68],[11,31,41,44],
 [11,31,41,47],[11,31,41,48],[11,31,41,49],
 [11,31,41,50],[11,31,41,53],[11,31,41,63],
 [11,31,41,68],[11,31,44,47],[11,31,44,48],
 [11,31,44,49],[11,31,44,63],[11,31,44,68],
 [11,31,47,49],[11,31,47,50],[11,31,47,53],
 [11,31,47,63],[11,31,47,68],[11,31,47,69],
 [11,31,48,49],[11,31,48,50],[11,31,48,55],
 [11,31,48,63],[11,31,48,66],[11,31,48,68],
 [11,31,48,69],[11,31,49,50],[11,31,49,53],
 [11,31,49,55],[11,31,49,63],[11,31,49,66],
 [11,31,49,68],[11,31,49,69],[11,31,50,55],
 [11,31,50,68],[11,31,53,63],[11,31,53,68],
 [11,31,55,66],[11,31,55,69],[11,31,63,68],
 [11,31,63,69],[11,34,43,46],[11,34,43,47],
 [11,34,43,48],[11,34,43,49],[11,34,43,55],
 [11,34,43,60],[11,34,43,62],[11,34,43,69],
 [11,34,44,45],[11,34,44,46],[11,34,44,47],
 [11,34,44,48],[11,34,44,49],[11,34,44,55],
 [11,34,44,62],[11,34,44,69],[11,34,45,46],
 [11,34,45,48],[11,34,45,49],[11,34,45,55],
 [11,34,45,60],[11,34,45,61],[11,34,45,62],
 [11,34,45,63],[11,34,45,69],[11,34,46,47],
 [11,34,46,48],[11,34,46,49],[11,34,46,55],
 [11,34,46,60],[11,34,46,61],[11,34,46,62],
 [11,34,46,63],[11,34,46,69],[11,34,47,49],
 [11,34,47,55],[11,34,47,60],[11,34,47,61],
 [11,34,47,62],[11,34,47,63],[11,34,47,69],
 [11,34,48,49],[11,34,48,55],[11,34,48,60],
 [11,34,48,61],[11,34,48,62],[11,34,48,63],
 [11,34,48,69],[11,34,49,55],[11,34,49,60],
 [11,34,49,61],[11,34,49,62],[11,34,49,63],
 [11,34,49,69],[11,34,55,60],[11,34,55,61],
 [11,34,55,62],[11,34,55,69],[11,34,60,62],
 [11,34,60,63],[11,34,60,69],[11,34,61,62],
 [11,34,61,63],[11,34,61,69],[11,34,62,63],
 [11,34,62,69],[11,34,63,69],[11,35,37,38],
 [11,35,37,45],[11,35,37,47],[11,35,37,48],
 [11,35,37,62],[11,35,38,41],[11,35,38,47],
 [11,35,38,49],[11,35,38,55],[11,35,38,62],
 [11,35,38,63],[11,35,38,68],[11,35,41,47],
 [11,35,41,48],[11,35,41,49],[11,35,41,63],
 [11,35,41,68],[11,35,45,48],[11,35,45,62],
 [11,35,45,63],[11,35,45,68],[11,35,47,49],
 [11,35,47,57],[11,35,47,62],[11,35,47,63],
 [11,35,47,66],[11,35,47,68],[11,35,47,69],
 [11,35,48,49],[11,35,48,55],[11,35,48,57],
 [11,35,48,62],[11,35,48,63],[11,35,48,66],
 [11,35,48,68],[11,35,48,69],[11,35,49,55],
 [11,35,49,63],[11,35,49,66],[11,35,49,68],
 [11,35,49,69],[11,35,55,66],[11,35,55,69],
 [11,35,62,63],[11,35,62,68],[11,35,63,68],
 [11,35,63,69],[11,37,38,40],[11,37,38,46],
 [11,37,38,47],[11,37,38,60],[11,37,38,61],
 [11,37,38,62],[11,37,38,64],[11,37,40,47],
 [11,37,40,48],[11,37,43,46],[11,37,43,47],
 [11,37,43,48],[11,37,43,60],[11,37,43,64],
 [11,37,45,46],[11,37,45,48],[11,37,45,60],
 [11,37,45,62],[11,37,46,47],[11,37,46,48],
 [11,37,46,60],[11,37,46,61],[11,37,47,60],
 [11,37,47,61],[11,37,47,62],[11,37,47,64],
 [11,37,48,60],[11,37,48,61],[11,37,48,62],
 [11,37,48,64],[11,37,54,60],[11,37,54,61],
 [11,37,60,62],[11,38,40,41],[11,38,40,47],
 [11,38,40,49],[11,38,40,52],[11,38,40,53],
 [11,38,40,55],[11,38,40,63],[11,38,40,64],
 [11,38,40,68],[11,38,41,46],[11,38,41,47],
 [11,38,41,49],[11,38,41,53],[11,38,41,60],
 [11,38,41,61],[11,38,41,62],[11,38,41,63],
 [11,38,41,64],[11,38,41,68],[11,38,43,46],
 [11,38,43,47],[11,38,43,49],[11,38,43,52],
 [11,38,43,53],[11,38,43,55],[11,38,43,60],
 [11,38,43,62],[11,38,43,64],[11,38,46,47],
 [11,38,46,49],[11,38,46,52],[11,38,46,53],
 [11,38,46,55],[11,38,46,60],[11,38,46,61],
 [11,38,46,62],[11,38,46,63],[11,38,46,68],
 [11,38,47,49],[11,38,47,51],[11,38,47,52],
 [11,38,47,53],[11,38,47,60],[11,38,47,61],
 [11,38,47,62],[11,38,47,63],[11,38,47,64],
 [11,38,47,68],[11,38,49,52],[11,38,49,53],
 [11,38,49,55],[11,38,49,60],[11,38,49,61],
 [11,38,49,62],[11,38,49,63],[11,38,49,64],
 [11,38,49,68],[11,38,51,52],[11,38,51,53],
 [11,38,51,60],[11,38,51,61],[11,38,51,62],
 [11,38,51,64],[11,38,51,68],[11,38,52,62],
 [11,38,53,60],[11,38,53,62],[11,38,53,63],
 [11,38,53,64],[11,38,53,68],[11,38,55,60],
 [11,38,55,61],[11,38,55,62],[11,38,60,62],
 [11,38,60,63],[11,38,60,68],[11,38,61,62],
 [11,38,61,63],[11,38,61,68],[11,38,62,63],
 [11,38,62,68],[11,38,63,64],[11,38,63,68],
 [11,38,64,68],[11,40,41,47],[11,40,41,48],
 [11,40,41,49],[11,40,41,50],[11,40,41,53],
 [11,40,41,63],[11,40,41,64],[11,40,41,68],
 [11,40,45,48],[11,40,45,50],[11,40,45,55],
 [11,40,45,63],[11,40,45,66],[11,40,45,69],
 [11,40,47,49],[11,40,47,50],[11,40,47,53],
 [11,40,47,63],[11,40,47,64],[11,40,47,68],
 [11,40,47,69],[11,40,48,49],[11,40,48,50],
 [11,40,48,52],[11,40,48,55],[11,40,48,63],
 [11,40,48,64],[11,40,48,66],[11,40,48,68],
 [11,40,48,69],[11,40,49,50],[11,40,49,52],
 [11,40,49,53],[11,40,49,55],[11,40,49,63],
 [11,40,49,64],[11,40,49,66],[11,40,49,68],
 [11,40,49,69],[11,40,50,52],[11,40,50,55],
 [11,40,50,64],[11,40,50,68],[11,40,52,63],
 [11,40,53,63],[11,40,53,64],[11,40,53,68],
 [11,40,55,66],[11,40,55,69],[11,40,63,64],
 [11,40,63,68],[11,40,63,69],[11,40,64,66],
 [11,40,64,68],[11,40,64,69],[11,41,43,46],
 [11,41,43,47],[11,41,43,48],[11,41,43,49],
 [11,41,43,53],[11,41,43,60],[11,41,43,62],
 [11,41,43,68],[11,41,44,46],[11,41,44,47],
 [11,41,44,48],[11,41,44,49],[11,41,44,53],
 [11,41,44,62],[11,41,44,63],[11,41,44,64],
 [11,41,44,68],[11,41,46,47],[11,41,46,48],
 [11,41,46,49],[11,41,46,50],[11,41,46,53],
 [11,41,46,60],[11,41,46,61],[11,41,46,62],
 [11,41,46,63],[11,41,46,68],[11,41,47,49],
 [11,41,47,50],[11,41,47,53],[11,41,47,60],
 [11,41,47,61],[11,41,47,62],[11,41,47,63],
 [11,41,47,64],[11,41,47,68],[11,41,48,49],
 [11,41,48,50],[11,41,48,60],[11,41,48,61],
 [11,41,48,62],[11,41,48,63],[11,41,48,64],
 [11,41,48,68],[11,41,49,50],[11,41,49,53],
 [11,41,49,60],[11,41,49,61],[11,41,49,62],
 [11,41,49,63],[11,41,49,64],[11,41,49,68],
 [11,41,50,60],[11,41,50,62],[11,41,50,64],
 [11,41,50,68],[11,41,53,60],[11,41,53,62],
 [11,41,53,63],[11,41,53,64],[11,41,53,68],
 [11,41,60,62],[11,41,60,63],[11,41,60,68],
 [11,41,61,62],[11,41,61,63],[11,41,61,68],
 [11,41,62,63],[11,41,62,68],[11,41,63,64],
 [11,41,63,68],[11,41,64,68],[11,43,46,47],
 [11,43,46,48],[11,43,46,49],[11,43,46,50],
 [11,43,46,52],[11,43,46,53],[11,43,46,55],
 [11,43,46,57],[11,43,46,60],[11,43,46,62],
 [11,43,46,66],[11,43,46,68],[11,43,46,69],
 [11,43,47,49],[11,43,47,50],[11,43,47,53],
 [11,43,47,55],[11,43,47,57],[11,43,47,60],
 [11,43,47,62],[11,43,47,66],[11,43,47,68],
 [11,43,47,69],[11,43,48,49],[11,43,48,50],
 [11,43,48,52],[11,43,48,55],[11,43,48,57],
 [11,43,48,60],[11,43,48,62],[11,43,48,64],
 [11,43,48,66],[11,43,48,68],[11,43,48,69],
 [11,43,49,50],[11,43,49,52],[11,43,49,53],
 [11,43,49,55],[11,43,49,60],[11,43,49,62],
 [11,43,49,64],[11,43,49,66],[11,43,49,68],
 [11,43,49,69],[11,43,50,52],[11,43,50,55],
 [11,43,50,60],[11,43,50,64],[11,43,50,68],
 [11,43,53,60],[11,43,53,62],[11,43,53,64],
 [11,43,53,68],[11,43,55,60],[11,43,55,62],
 [11,43,55,66],[11,43,55,69],[11,43,57,60],
 [11,43,60,62],[11,43,60,66],[11,43,60,68],
 [11,43,60,69],[11,43,62,66],[11,43,62,68],
 [11,43,62,69],[11,43,64,69],[11,44,45,46],
 [11,44,45,48],[11,44,45,49],[11,44,45,51],
 [11,44,45,52],[11,44,45,55],[11,44,45,62],
 [11,44,45,63],[11,44,45,66],[11,44,45,68],
 [11,44,45,69],[11,44,46,47],[11,44,46,48],
 [11,44,46,49],[11,44,46,53],[11,44,46,55],
 [11,44,46,57],[11,44,46,62],[11,44,46,66],
 [11,44,46,68],[11,44,46,69],[11,44,47,49],
 [11,44,47,53],[11,44,47,55],[11,44,47,57],
 [11,44,47,62],[11,44,47,63],[11,44,47,64],
 [11,44,47,66],[11,44,47,68],[11,44,47,69],
 [11,44,48,49],[11,44,48,51],[11,44,48,52],
 [11,44,48,53],[11,44,48,55],[11,44,48,62],
 [11,44,48,63],[11,44,48,64],[11,44,48,66],
 [11,44,48,68],[11,44,48,69],[11,44,49,52],
 [11,44,49,53],[11,44,49,54],[11,44,49,55],
 [11,44,49,57],[11,44,49,62],[11,44,49,63],
 [11,44,49,64],[11,44,49,66],[11,44,49,68],
 [11,44,49,69],[11,44,51,53],[11,44,51,63],
 [11,44,51,66],[11,44,51,68],[11,44,51,69],
 [11,44,52,62],[11,44,52,63],[11,44,53,54],
 [11,44,53,63],[11,44,53,68],[11,44,54,57],
 [11,44,54,62],[11,44,54,66],[11,44,54,68],
 [11,44,55,62],[11,44,55,66],[11,44,55,69],
 [11,44,62,63],[11,44,62,66],[11,44,62,68],
 [11,44,62,69],[11,44,63,64],[11,44,63,68],
 [11,44,63,69],[11,44,64,68],[11,45,46,48],
 [11,45,46,49],[11,45,46,50],[11,45,46,52],
 [11,45,46,55],[11,45,46,57],[11,45,46,60],
 [11,45,46,61],[11,45,46,62],[11,45,46,63],
 [11,45,46,66],[11,45,46,68],[11,45,46,69],
 [11,45,48,49],[11,45,48,50],[11,45,48,51],
 [11,45,48,52],[11,45,48,53],[11,45,48,55],
 [11,45,48,57],[11,45,48,60],[11,45,48,61],
 [11,45,48,62],[11,45,48,63],[11,45,48,66],
 [11,45,48,68],[11,45,48,69],[11,45,49,50],
 [11,45,49,52],[11,45,49,55],[11,45,49,60],
 [11,45,49,61],[11,45,49,62],[11,45,49,63],
 [11,45,49,66],[11,45,49,68],[11,45,49,69],
 [11,45,50,51],[11,45,50,52],[11,45,50,55],
 [11,45,50,60],[11,45,50,62],[11,45,50,68],
 [11,45,51,52],[11,45,51,53],[11,45,51,55],
 [11,45,51,57],[11,45,51,60],[11,45,51,62],
 [11,45,51,63],[11,45,51,66],[11,45,51,68],
 [11,45,51,69],[11,45,52,62],[11,45,53,60],
 [11,45,53,62],[11,45,53,63],[11,45,53,68],
 [11,45,55,60],[11,45,55,61],[11,45,55,62],
 [11,45,55,66],[11,45,55,69],[11,45,57,60],
 [11,45,60,62],[11,45,60,63],[11,45,60,66],
 [11,45,60,68],[11,45,60,69],[11,45,61,62],
 [11,45,61,63],[11,45,61,66],[11,45,61,68],
 [11,45,61,69],[11,45,62,63],[11,45,62,66],
 [11,45,62,68],[11,45,62,69],[11,45,63,68],
 [11,45,63,69],[11,46,47,49],[11,46,47,50],
 [11,46,47,53],[11,46,47,55],[11,46,47,57],
 [11,46,47,60],[11,46,47,61],[11,46,47,62],
 [11,46,47,63],[11,46,47,66],[11,46,47,68],
 [11,46,47,69],[11,46,48,49],[11,46,48,50],
 [11,46,48,52],[11,46,48,55],[11,46,48,57],
 [11,46,48,60],[11,46,48,61],[11,46,48,62],
 [11,46,48,63],[11,46,48,66],[11,46,48,68],
 [11,46,48,69],[11,46,49,50],[11,46,49,52],
 [11,46,49,53],[11,46,49,55],[11,46,49,60],
 [11,46,49,61],[11,46,49,62],[11,46,49,63],
 [11,46,49,66],[11,46,49,68],[11,46,49,69],
 [11,46,50,52],[11,46,50,55],[11,46,50,60],
 [11,46,50,62],[11,46,50,68],[11,46,52,62],
 [11,46,52,63],[11,46,53,60],[11,46,53,62],
 [11,46,53,63],[11,46,53,68],[11,46,55,60],
 [11,46,55,61],[11,46,55,62],[11,46,55,66],
 [11,46,55,69],[11,46,57,60],[11,46,57,61],
 [11,46,60,62],[11,46,60,63],[11,46,60,66],
 [11,46,60,68],[11,46,60,69],[11,46,61,62],
 [11,46,61,63],[11,46,61,66],[11,46,61,68],
 [11,46,61,69],[11,46,62,63],[11,46,62,66],
 [11,46,62,68],[11,46,62,69],[11,46,63,68],
 [11,46,63,69],[11,47,49,50],[11,47,49,53],
 [11,47,49,55],[11,47,49,57],[11,47,49,60],
 [11,47,49,61],[11,47,49,62],[11,47,49,63],
 [11,47,49,64],[11,47,49,66],[11,47,49,68],
 [11,47,49,69],[11,47,50,51],[11,47,50,52],
 [11,47,50,55],[11,47,50,60],[11,47,50,62],
 [11,47,50,64],[11,47,50,68],[11,47,51,52],
 [11,47,51,53],[11,47,51,57],[11,47,51,61],
 [11,47,51,62],[11,47,51,63],[11,47,51,66],
 [11,47,51,69],[11,47,52,62],[11,47,52,63],
 [11,47,53,60],[11,47,53,62],[11,47,53,63],
 [11,47,53,64],[11,47,53,68],[11,47,55,60],
 [11,47,55,61],[11,47,55,62],[11,47,55,66],
 [11,47,55,69],[11,47,57,60],[11,47,57,61],
 [11,47,60,62],[11,47,60,63],[11,47,60,66],
 [11,47,60,68],[11,47,60,69],[11,47,61,62],
 [11,47,61,63],[11,47,61,66],[11,47,61,68],
 [11,47,61,69],[11,47,62,63],[11,47,62,66],
 [11,47,62,68],[11,47,62,69],[11,47,63,64],
 [11,47,63,68],[11,47,63,69],[11,47,64,68],
 [11,47,64,69],[11,48,49,50],[11,48,49,52],
 [11,48,49,55],[11,48,49,60],[11,48,49,61],
 [11,48,49,62],[11,48,49,63],[11,48,49,64],
 [11,48,49,66],[11,48,49,68],[11,48,49,69],
 [11,48,50,51],[11,48,50,52],[11,48,50,60],
 [11,48,50,62],[11,48,50,64],[11,48,50,68],
 [11,48,51,52],[11,48,51,53],[11,48,51,60],
 [11,48,51,62],[11,48,51,63],[11,48,51,64],
 [11,48,51,68],[11,48,52,62],[11,48,52,63],
 [11,48,53,60],[11,48,53,62],[11,48,53,63],
 [11,48,53,64],[11,48,53,68],[11,48,55,60],
 [11,48,55,61],[11,48,55,62],[11,48,55,66],
 [11,48,55,69],[11,48,57,60],[11,48,57,61],
 [11,48,60,62],[11,48,60,63],[11,48,60,66],
 [11,48,60,68],[11,48,60,69],[11,48,61,62],
 [11,48,61,63],[11,48,61,66],[11,48,61,68],
 [11,48,61,69],[11,48,62,63],[11,48,62,66],
 [11,48,62,68],[11,48,62,69],[11,48,63,64],
 [11,48,63,68],[11,48,63,69],[11,48,64,66],
 [11,48,64,68],[11,48,64,69],[11,49,50,52],
 [11,49,50,60],[11,49,50,62],[11,49,50,64],
 [11,49,50,68],[11,49,52,54],[11,49,52,62],
 [11,49,52,63],[11,49,53,60],[11,49,53,62],
 [11,49,53,63],[11,49,53,64],[11,49,53,68],
 [11,49,54,57],[11,49,54,60],[11,49,54,61],
 [11,49,54,68],[11,49,55,60],[11,49,55,61],
 [11,49,55,62],[11,49,55,66],[11,49,55,69],
 [11,49,57,60],[11,49,57,61],[11,49,60,62],
 [11,49,60,63],[11,49,60,66],[11,49,60,68],
 [11,49,60,69],[11,49,61,62],[11,49,61,63],
 [11,49,61,66],[11,49,61,68],[11,49,61,69],
 [11,49,62,63],[11,49,62,66],[11,49,62,68],
 [11,49,62,69],[11,49,63,64],[11,49,63,68],
 [11,49,63,69],[11,49,64,66],[11,49,64,68],
 [11,49,64,69],[11,50,51,52],[11,50,51,55],
 [11,50,51,60],[11,50,51,62],[11,50,51,64],
 [11,50,51,68],[11,50,52,54],[11,50,52,62],
 [11,50,54,60],[11,50,54,62],[11,50,54,68],
 [11,50,55,60],[11,50,55,62],[11,50,60,62],
 [11,50,60,68],[11,50,62,68],[11,50,64,68],
 [11,51,52,62],[11,51,52,63],[11,51,53,60],
 [11,51,53,62],[11,51,53,63],[11,51,53,64],
 [11,51,53,68],[11,51,55,60],[11,51,55,61],
 [11,51,55,62],[11,51,55,66],[11,51,55,69],
 [11,51,57,60],[11,51,57,61],[11,51,60,62],
 [11,51,60,63],[11,51,60,66],[11,51,60,68],
 [11,51,60,69],[11,51,61,62],[11,51,61,63],
 [11,51,61,66],[11,51,61,68],[11,51,61,69],
 [11,51,62,63],[11,51,62,66],[11,51,62,68],
 [11,51,62,69],[11,51,63,64],[11,51,63,68],
 [11,51,63,69],[11,51,64,66],[11,51,64,68],
 [11,51,64,69],[11,52,54,62],[11,52,62,63],
 [11,53,54,60],[11,53,54,62],[11,53,54,68],
 [11,53,60,62],[11,53,60,63],[11,53,60,68],
 [11,53,62,63],[11,53,62,68],[11,53,63,64],
 [11,53,63,68],[11,53,64,68],[11,54,57,60],
 [11,54,57,61],[11,54,60,62],[11,54,60,66],
 [11,54,60,68],[11,54,60,69],[11,54,61,62],
 [11,54,61,66],[11,54,61,68],[11,54,61,69],
 [11,54,62,66],[11,54,62,68],[11,54,62,69],
 [11,55,60,62],[11,55,60,66],[11,55,60,69],
 [11,55,61,62],[11,55,61,66],[11,55,61,69],
 [11,55,62,66],[11,55,62,69],[11,60,62,63],
 [11,60,62,66],[11,60,62,68],[11,60,62,69],
 [11,60,63,68],[11,60,63,69],[11,61,62,63],
 [11,61,62,66],[11,61,62,68],[11,61,62,69],
 [11,61,63,68],[11,61,63,69],[11,62,63,68],
 [11,62,63,69],[11,63,64,68],[11,63,64,69],
 [12,13,21,23],[12,13,21,24],[12,13,21,25],
 [12,13,21,34],[12,13,21,37],[12,13,21,43],
 [12,13,21,44],[12,13,21,46],[12,13,21,47],
 [12,13,21,51],[12,13,21,53],[12,13,21,55],
 [12,13,21,56],[12,13,21,58],[12,13,21,60],
 [12,13,21,61],[12,13,21,65],[12,13,21,67],
 [12,13,21,69],[12,13,23,24],[12,13,23,25],
 [12,13,23,30],[12,13,23,34],[12,13,23,35],
 [12,13,23,36],[12,13,23,37],[12,13,23,43],
 [12,13,23,44],[12,13,23,46],[12,13,23,47],
 [12,13,23,53],[12,13,23,55],[12,13,23,56],
 [12,13,23,58],[12,13,23,60],[12,13,23,61],
 [12,13,23,65],[12,13,23,67],[12,13,23,69],
 [12,13,24,25],[12,13,24,34],[12,13,24,36],
 [12,13,24,37],[12,13,24,43],[12,13,24,44],
 [12,13,24,46],[12,13,24,47],[12,13,24,53],
 [12,13,24,55],[12,13,24,58],[12,13,24,60],
 [12,13,24,61],[12,13,24,63],[12,13,24,65],
 [12,13,24,67],[12,13,24,69],[12,13,25,34],
 [12,13,25,35],[12,13,25,37],[12,13,25,43],
 [12,13,25,44],[12,13,25,46],[12,13,25,47],
 [12,13,25,51],[12,13,25,53],[12,13,25,54],
 [12,13,25,55],[12,13,25,60],[12,13,25,61],
 [12,13,25,65],[12,13,25,67],[12,13,25,69],
 [12,13,30,35],[12,13,30,44],[12,13,30,47],
 [12,13,30,53],[12,13,30,60],[12,13,30,61],
 [12,13,34,43],[12,13,34,44],[12,13,34,46],
 [12,13,34,47],[12,13,34,55],[12,13,34,60],
 [12,13,34,61],[12,13,34,63],[12,13,34,69],
 [12,13,35,36],[12,13,35,37],[12,13,35,47],
 [12,13,35,55],[12,13,35,60],[12,13,35,63],
 [12,13,35,65],[12,13,35,69],[12,13,36,43],
 [12,13,36,46],[12,13,36,54],[12,13,36,60],
 [12,13,37,43],[12,13,37,44],[12,13,37,46],
 [12,13,37,47],[12,13,37,60],[12,13,37,61],
 [12,13,37,67],[12,13,43,44],[12,13,43,46],
 [12,13,43,47],[12,13,43,55],[12,13,43,56],
 [12,13,43,58],[12,13,43,60],[12,13,43,61],
 [12,13,43,67],[12,13,43,69],[12,13,44,46],
 [12,13,44,47],[12,13,44,53],[12,13,44,54],
 [12,13,44,55],[12,13,44,58],[12,13,44,60],
 [12,13,44,61],[12,13,44,65],[12,13,44,67],
 [12,13,44,69],[12,13,46,47],[12,13,46,53],
 [12,13,46,55],[12,13,46,56],[12,13,46,58],
 [12,13,46,60],[12,13,46,61],[12,13,46,63],
 [12,13,46,65],[12,13,46,67],[12,13,46,69],
 [12,13,47,53],[12,13,47,54],[12,13,47,55],
 [12,13,47,56],[12,13,47,58],[12,13,47,60],
 [12,13,47,61],[12,13,47,65],[12,13,47,67],
 [12,13,47,69],[12,13,51,53],[12,13,51,56],
 [12,13,51,58],[12,13,51,60],[12,13,51,61],
 [12,13,51,65],[12,13,51,67],[12,13,51,69],
 [12,13,53,54],[12,13,53,60],[12,13,53,63],
 [12,13,54,56],[12,13,54,58],[12,13,54,60],
 [12,13,54,61],[12,13,54,67],[12,13,54,69],
 [12,13,55,60],[12,13,55,61],[12,13,55,69],
 [12,13,58,60],[12,13,58,61],[12,13,58,63],
 [12,13,58,67],[12,13,60,61],[12,13,60,63],
 [12,13,60,65],[12,13,60,67],[12,13,60,69],
 [12,13,61,63],[12,13,61,65],[12,13,61,67],
 [12,13,61,69],[12,13,63,65],[12,13,63,67],
 [12,13,63,69],[12,14,15,17],[12,14,15,20],
 [12,14,15,22],[12,14,15,24],[12,14,15,25],
 [12,14,15,26],[12,14,15,36],[12,14,15,45],
 [12,14,15,47],[12,14,15,54],[12,14,15,56],
 [12,14,15,60],[12,14,15,61],[12,14,15,67],
 [12,14,17,20],[12,14,17,24],[12,14,17,26],
 [12,14,17,30],[12,14,17,35],[12,14,17,47],
 [12,14,17,53],[12,14,17,54],[12,14,17,55],
 [12,14,17,56],[12,14,17,58],[12,14,17,61],
 [12,14,17,69],[12,14,20,21],[12,14,20,24],
 [12,14,20,25],[12,14,20,26],[12,14,20,45],
 [12,14,20,47],[12,14,20,53],[12,14,20,55],
 [12,14,20,56],[12,14,20,58],[12,14,20,61],
 [12,14,20,67],[12,14,21,24],[12,14,21,25],
 [12,14,21,43],[12,14,21,45],[12,14,21,55],
 [12,14,21,58],[12,14,21,60],[12,14,21,62],
 [12,14,21,67],[12,14,21,69],[12,14,22,24],
 [12,14,22,26],[12,14,22,43],[12,14,22,53],
 [12,14,22,54],[12,14,22,55],[12,14,22,56],
 [12,14,22,58],[12,14,22,60],[12,14,22,61],
 [12,14,22,67],[12,14,24,25],[12,14,24,26],
 [12,14,24,36],[12,14,24,45],[12,14,24,47],
 [12,14,24,53],[12,14,24,54],[12,14,24,56],
 [12,14,24,60],[12,14,24,61],[12,14,24,67],
 [12,14,24,69],[12,14,25,26],[12,14,25,35],
 [12,14,25,43],[12,14,25,45],[12,14,25,53],
 [12,14,25,54],[12,14,25,55],[12,14,25,60],
 [12,14,25,61],[12,14,25,62],[12,14,25,67],
 [12,14,25,69],[12,14,26,35],[12,14,26,36],
 [12,14,26,43],[12,14,26,47],[12,14,26,54],
 [12,14,26,55],[12,14,26,56],[12,14,26,58],
 [12,14,26,60],[12,14,26,61],[12,14,26,62],
 [12,14,26,67],[12,14,30,35],[12,14,30,45],
 [12,14,30,47],[12,14,30,60],[12,14,30,62],
 [12,14,35,36],[12,14,35,47],[12,14,35,55],
 [12,14,35,56],[12,14,35,60],[12,14,35,62],
 [12,14,35,67],[12,14,35,69],[12,14,36,43],
 [12,14,36,45],[12,14,36,54],[12,14,36,60],
 [12,14,36,61],[12,14,36,62],[12,14,43,53],
 [12,14,43,55],[12,14,43,56],[12,14,43,58],
 [12,14,43,60],[12,14,43,61],[12,14,43,67],
 [12,14,43,69],[12,14,45,47],[12,14,45,53],
 [12,14,45,54],[12,14,45,55],[12,14,45,58],
 [12,14,45,61],[12,14,45,62],[12,14,45,67],
 [12,14,45,69],[12,14,47,53],[12,14,47,54],
 [12,14,47,55],[12,14,47,56],[12,14,47,58],
 [12,14,47,61],[12,14,47,62],[12,14,47,69],
 [12,14,53,54],[12,14,53,60],[12,14,53,62],
 [12,14,54,56],[12,14,54,58],[12,14,54,60],
 [12,14,54,61],[12,14,54,62],[12,14,54,67],
 [12,14,54,69],[12,14,55,60],[12,14,55,61],
 [12,14,55,62],[12,14,55,69],[12,14,56,61],
 [12,14,56,62],[12,14,58,60],[12,14,58,61],
 [12,14,58,62],[12,14,58,67],[12,14,60,61],
 [12,14,60,67],[12,14,60,69],[12,14,61,62],
 [12,14,61,67],[12,14,61,69],[12,14,62,67],
 [12,14,62,69],[12,15,16,19],[12,15,16,20],
 [12,15,16,21],[12,15,16,22],[12,15,16,23],
 [12,15,16,24],[12,15,16,25],[12,15,16,26],
 [12,15,16,36],[12,15,16,44],[12,15,16,45],
 [12,15,16,46],[12,15,16,47],[12,15,16,48],
 [12,15,16,49],[12,15,16,51],[12,15,16,55],
 [12,15,16,61],[12,15,16,67],[12,15,17,19],
 [12,15,17,20],[12,15,17,23],[12,15,17,24],
 [12,15,17,26],[12,15,17,44],[12,15,17,46],
 [12,15,17,47],[12,15,17,48],[12,15,17,49],
 [12,15,17,51],[12,15,17,54],[12,15,17,56],
 [12,15,17,61],[12,15,19,21],[12,15,19,22],
 [12,15,19,23],[12,15,19,24],[12,15,19,25],
 [12,15,19,26],[12,15,19,36],[12,15,19,37],
 [12,15,19,44],[12,15,19,45],[12,15,19,46],
 [12,15,19,47],[12,15,19,48],[12,15,19,55],
 [12,15,19,56],[12,15,19,60],[12,15,19,61],
 [12,15,19,64],[12,15,19,65],[12,15,19,67],
 [12,15,20,21],[12,15,20,24],[12,15,20,25],
 [12,15,20,26],[12,15,20,28],[12,15,20,30],
 [12,15,20,40],[12,15,20,44],[12,15,20,45],
 [12,15,20,46],[12,15,20,47],[12,15,20,48],
 [12,15,20,55],[12,15,20,56],[12,15,20,60],
 [12,15,20,61],[12,15,20,63],[12,15,20,64],
 [12,15,20,65],[12,15,20,67],[12,15,21,23],
 [12,15,21,24],[12,15,21,25],[12,15,21,26],
 [12,15,21,36],[12,15,21,37],[12,15,21,43],
 [12,15,21,44],[12,15,21,45],[12,15,21,46],
 [12,15,21,47],[12,15,21,48],[12,15,21,49],
 [12,15,21,55],[12,15,21,60],[12,15,21,61],
 [12,15,21,65],[12,15,21,67],[12,15,22,23],
 [12,15,22,24],[12,15,22,25],[12,15,22,26],
 [12,15,22,28],[12,15,22,36],[12,15,22,37],
 [12,15,22,43],[12,15,22,44],[12,15,22,45],
 [12,15,22,46],[12,15,22,48],[12,15,22,54],
 [12,15,22,55],[12,15,22,56],[12,15,22,60],
 [12,15,22,61],[12,15,22,64],[12,15,22,67],
 [12,15,23,24],[12,15,23,25],[12,15,23,26],
 [12,15,23,36],[12,15,23,37],[12,15,23,43],
 [12,15,23,44],[12,15,23,45],[12,15,23,46],
 [12,15,23,47],[12,15,23,48],[12,15,23,55],
 [12,15,23,56],[12,15,23,60],[12,15,23,61],
 [12,15,23,64],[12,15,23,67],[12,15,24,25],
 [12,15,24,26],[12,15,24,30],[12,15,24,36],
 [12,15,24,37],[12,15,24,43],[12,15,24,44],
 [12,15,24,45],[12,15,24,46],[12,15,24,47],
 [12,15,24,48],[12,15,24,49],[12,15,24,51],
 [12,15,24,54],[12,15,24,55],[12,15,24,56],
 [12,15,24,60],[12,15,24,61],[12,15,24,63],
 [12,15,24,64],[12,15,24,65],[12,15,24,67],
 [12,15,25,26],[12,15,25,37],[12,15,25,40],
 [12,15,25,43],[12,15,25,44],[12,15,25,45],
 [12,15,25,46],[12,15,25,47],[12,15,25,48],
 [12,15,25,49],[12,15,25,51],[12,15,25,54],
 [12,15,25,55],[12,15,25,60],[12,15,25,61],
 [12,15,25,65],[12,15,25,67],[12,15,26,28],
 [12,15,26,36],[12,15,26,37],[12,15,26,40],
 [12,15,26,43],[12,15,26,44],[12,15,26,45],
 [12,15,26,46],[12,15,26,47],[12,15,26,48],
 [12,15,26,49],[12,15,26,51],[12,15,26,54],
 [12,15,26,55],[12,15,26,56],[12,15,26,60],
 [12,15,26,61],[12,15,26,63],[12,15,26,64],
 [12,15,26,65],[12,15,26,67],[12,15,28,30],
 [12,15,28,44],[12,15,28,47],[12,15,28,48],
 [12,15,28,61],[12,15,30,44],[12,15,30,47],
 [12,15,30,48],[12,15,30,49],[12,15,30,60],
 [12,15,30,61],[12,15,36,46],[12,15,36,48],
 [12,15,36,54],[12,15,36,61],[12,15,36,63],
 [12,15,36,64],[12,15,37,40],[12,15,37,43],
 [12,15,37,44],[12,15,37,46],[12,15,37,47],
 [12,15,37,48],[12,15,37,60],[12,15,37,61],
 [12,15,37,67],[12,15,40,44],[12,15,40,47],
 [12,15,40,48],[12,15,40,49],[12,15,40,55],
 [12,15,40,61],[12,15,40,63],[12,15,40,65],
 [12,15,43,44],[12,15,43,46],[12,15,43,47],
 [12,15,43,48],[12,15,43,49],[12,15,43,55],
 [12,15,43,60],[12,15,43,61],[12,15,43,67],
 [12,15,44,46],[12,15,44,47],[12,15,44,49],
 [12,15,44,54],[12,15,44,55],[12,15,44,60],
 [12,15,44,61],[12,15,44,63],[12,15,44,64],
 [12,15,44,65],[12,15,44,67],[12,15,45,46],
 [12,15,45,47],[12,15,45,48],[12,15,45,49],
 [12,15,45,51],[12,15,45,54],[12,15,45,55],
 [12,15,45,61],[12,15,45,67],[12,15,46,47],
 [12,15,46,48],[12,15,46,49],[12,15,46,55],
 [12,15,46,56],[12,15,46,60],[12,15,46,61],
 [12,15,46,63],[12,15,46,67],[12,15,47,48],
 [12,15,47,54],[12,15,47,55],[12,15,47,56],
 [12,15,47,60],[12,15,47,61],[12,15,47,63],
 [12,15,47,64],[12,15,47,65],[12,15,47,67],
 [12,15,48,49],[12,15,48,51],[12,15,48,55],
 [12,15,48,56],[12,15,48,60],[12,15,48,61],
 [12,15,48,63],[12,15,48,67],[12,15,49,55],
 [12,15,49,56],[12,15,49,60],[12,15,49,61],
 [12,15,49,63],[12,15,49,64],[12,15,49,65],
 [12,15,49,67],[12,15,51,56],[12,15,51,60],
 [12,15,51,61],[12,15,51,64],[12,15,51,65],
 [12,15,51,67],[12,15,54,56],[12,15,54,60],
 [12,15,54,61],[12,15,54,67],[12,15,55,60],
 [12,15,55,61],[12,15,56,61],[12,15,60,61],
 [12,15,60,65],[12,15,60,67],[12,15,61,63],
 [12,15,61,64],[12,15,61,65],[12,15,61,67],
 [12,15,63,64],[12,15,63,65],[12,15,64,65],
 [12,15,64,67],[12,16,19,21],[12,16,19,22],
 [12,16,19,23],[12,16,19,24],[12,16,19,25],
 [12,16,19,26],[12,16,19,35],[12,16,19,37],
 [12,16,19,42],[12,16,19,44],[12,16,19,45],
 [12,16,19,46],[12,16,19,47],[12,16,19,48],
 [12,16,19,54],[12,16,19,55],[12,16,19,56],
 [12,16,19,61],[12,16,19,62],[12,16,19,67],
 [12,16,20,21],[12,16,20,24],[12,16,20,25],
 [12,16,20,26],[12,16,20,33],[12,16,20,34],
 [12,16,20,42],[12,16,20,44],[12,16,20,45],
 [12,16,20,46],[12,16,20,47],[12,16,20,48],
 [12,16,20,53],[12,16,20,55],[12,16,20,61],
 [12,16,20,67],[12,16,20,69],[12,16,21,23],
 [12,16,21,24],[12,16,21,25],[12,16,21,26],
 [12,16,21,33],[12,16,21,34],[12,16,21,35],
 [12,16,21,36],[12,16,21,37],[12,16,21,42],
 [12,16,21,44],[12,16,21,45],[12,16,21,46],
 [12,16,21,47],[12,16,21,48],[12,16,21,49],
 [12,16,21,51],[12,16,21,53],[12,16,21,55],
 [12,16,21,56],[12,16,21,61],[12,16,21,62],
 [12,16,21,67],[12,16,21,69],[12,16,22,23],
 [12,16,22,24],[12,16,22,25],[12,16,22,26],
 [12,16,22,32],[12,16,22,33],[12,16,22,35],
 [12,16,22,36],[12,16,22,37],[12,16,22,42],
 [12,16,22,44],[12,16,22,45],[12,16,22,46],
 [12,16,22,48],[12,16,22,54],[12,16,22,55],
 [12,16,22,56],[12,16,22,61],[12,16,22,67],
 [12,16,23,24],[12,16,23,25],[12,16,23,26],
 [12,16,23,30],[12,16,23,32],[12,16,23,34],
 [12,16,23,35],[12,16,23,37],[12,16,23,42],
 [12,16,23,44],[12,16,23,45],[12,16,23,46],
 [12,16,23,47],[12,16,23,48],[12,16,23,53],
 [12,16,23,55],[12,16,23,56],[12,16,23,61],
 [12,16,23,62],[12,16,23,67],[12,16,23,69],
 [12,16,24,25],[12,16,24,26],[12,16,24,30],
 [12,16,24,32],[12,16,24,33],[12,16,24,34],
 [12,16,24,35],[12,16,24,36],[12,16,24,37],
 [12,16,24,42],[12,16,24,44],[12,16,24,45],
 [12,16,24,46],[12,16,24,47],[12,16,24,48],
 [12,16,24,49],[12,16,24,51],[12,16,24,53],
 [12,16,24,54],[12,16,24,55],[12,16,24,61],
 [12,16,24,67],[12,16,24,69],[12,16,25,26],
 [12,16,25,32],[12,16,25,33],[12,16,25,34],
 [12,16,25,35],[12,16,25,36],[12,16,25,37],
 [12,16,25,42],[12,16,25,44],[12,16,25,45],
 [12,16,25,46],[12,16,25,47],[12,16,25,48],
 [12,16,25,49],[12,16,25,51],[12,16,25,53],
 [12,16,25,54],[12,16,25,55],[12,16,25,61],
 [12,16,25,62],[12,16,25,67],[12,16,25,69],
 [12,16,26,35],[12,16,26,37],[12,16,26,44],
 [12,16,26,45],[12,16,26,46],[12,16,26,47],
 [12,16,26,48],[12,16,26,49],[12,16,26,51],
 [12,16,26,54],[12,16,26,55],[12,16,26,56],
 [12,16,26,61],[12,16,26,62],[12,16,26,67],
 [12,16,30,45],[12,16,30,47],[12,16,30,48],
 [12,16,30,49],[12,16,30,62],[12,16,32,46],
 [12,16,32,49],[12,16,32,62],[12,16,33,35],
 [12,16,33,36],[12,16,33,45],[12,16,33,46],
 [12,16,33,48],[12,16,33,56],[12,16,33,61],
 [12,16,33,62],[12,16,34,44],[12,16,34,45],
 [12,16,34,46],[12,16,34,47],[12,16,34,48],
 [12,16,34,49],[12,16,34,55],[12,16,34,61],
 [12,16,34,62],[12,16,34,69],[12,16,35,36],
 [12,16,35,37],[12,16,35,42],[12,16,35,45],
 [12,16,35,47],[12,16,35,48],[12,16,35,56],
 [12,16,35,62],[12,16,35,67],[12,16,36,45],
 [12,16,36,46],[12,16,36,48],[12,16,36,54],
 [12,16,36,61],[12,16,36,62],[12,16,37,45],
 [12,16,37,47],[12,16,37,48],[12,16,37,62],
 [12,16,37,67],[12,16,42,44],[12,16,42,46],
 [12,16,42,49],[12,16,42,61],[12,16,42,62],
 [12,16,44,46],[12,16,44,47],[12,16,44,49],
 [12,16,44,54],[12,16,44,55],[12,16,44,61],
 [12,16,44,62],[12,16,44,67],[12,16,44,69],
 [12,16,45,46],[12,16,45,47],[12,16,45,48],
 [12,16,45,49],[12,16,45,51],[12,16,45,53],
 [12,16,45,54],[12,16,45,55],[12,16,45,61],
 [12,16,45,62],[12,16,45,67],[12,16,45,69],
 [12,16,46,47],[12,16,46,48],[12,16,46,49],
 [12,16,46,55],[12,16,46,56],[12,16,46,61],
 [12,16,46,62],[12,16,46,67],[12,16,46,69],
 [12,16,47,48],[12,16,47,53],[12,16,47,54],
 [12,16,47,55],[12,16,47,56],[12,16,47,61],
 [12,16,47,62],[12,16,47,67],[12,16,47,69],
 [12,16,48,49],[12,16,48,51],[12,16,48,53],
 [12,16,48,55],[12,16,48,56],[12,16,48,61],
 [12,16,48,62],[12,16,48,67],[12,16,48,69],
 [12,16,49,55],[12,16,49,56],[12,16,49,61],
 [12,16,49,62],[12,16,49,67],[12,16,49,69],
 [12,16,51,53],[12,16,51,56],[12,16,51,61],
 [12,16,51,62],[12,16,51,67],[12,16,53,62],
 [12,16,54,56],[12,16,54,62],[12,16,54,67],
 [12,16,54,69],[12,16,55,61],[12,16,55,62],
 [12,16,55,69],[12,16,56,61],[12,16,56,62],
 [12,16,61,62],[12,16,61,67],[12,16,61,69],
 [12,16,62,67],[12,16,62,69],[12,17,19,23],
 [12,17,19,24],[12,17,19,26],[12,17,19,46],
 [12,17,19,48],[12,17,19,54],[12,17,19,55],
 [12,17,19,56],[12,17,20,24],[12,17,20,26],
 [12,17,20,30],[12,17,20,33],[12,17,20,35],
 [12,17,20,44],[12,17,20,47],[12,17,20,48],
 [12,17,20,53],[12,17,20,56],[12,17,20,61],
 [12,17,20,69],[12,17,23,24],[12,17,23,26],
 [12,17,23,30],[12,17,23,34],[12,17,23,35],
 [12,17,23,46],[12,17,23,48],[12,17,23,53],
 [12,17,23,55],[12,17,23,56],[12,17,23,58],
 [12,17,23,61],[12,17,23,69],[12,17,24,26],
 [12,17,24,33],[12,17,24,34],[12,17,24,35],
 [12,17,24,44],[12,17,24,46],[12,17,24,47],
 [12,17,24,48],[12,17,24,49],[12,17,24,51],
 [12,17,24,53],[12,17,24,54],[12,17,24,56],
 [12,17,24,61],[12,17,24,69],[12,17,26,35],
 [12,17,26,44],[12,17,26,46],[12,17,26,47],
 [12,17,26,48],[12,17,26,49],[12,17,26,51],
 [12,17,26,54],[12,17,26,55],[12,17,26,56],
 [12,17,26,58],[12,17,26,61],[12,17,30,35],
 [12,17,30,44],[12,17,30,47],[12,17,30,48],
 [12,17,30,49],[12,17,30,53],[12,17,30,61],
 [12,17,33,35],[12,17,33,46],[12,17,33,48],
 [12,17,33,54],[12,17,33,55],[12,17,33,61],
 [12,17,34,46],[12,17,34,48],[12,17,34,49],
 [12,17,34,55],[12,17,34,61],[12,17,34,69],
 [12,17,35,47],[12,17,35,48],[12,17,35,49],
 [12,17,35,55],[12,17,35,69],[12,17,44,46],
 [12,17,44,47],[12,17,44,49],[12,17,44,53],
 [12,17,44,54],[12,17,44,55],[12,17,44,61],
 [12,17,46,48],[12,17,46,49],[12,17,46,53],
 [12,17,46,55],[12,17,46,56],[12,17,46,58],
 [12,17,46,61],[12,17,46,69],[12,17,47,53],
 [12,17,47,54],[12,17,47,55],[12,17,47,56],
 [12,17,47,58],[12,17,47,61],[12,17,47,69],
 [12,17,48,49],[12,17,48,51],[12,17,48,53],
 [12,17,48,55],[12,17,48,56],[12,17,48,58],
 [12,17,48,61],[12,17,48,69],[12,17,49,53],
 [12,17,49,55],[12,17,49,56],[12,17,49,58],
 [12,17,49,61],[12,17,49,69],[12,17,51,53],
 [12,17,51,56],[12,17,51,58],[12,17,51,61],
 [12,17,51,69],[12,17,53,54],[12,17,54,56],
 [12,17,54,58],[12,17,54,61],[12,17,54,69],
 [12,17,55,69],[12,17,56,61],[12,17,61,69],
 [12,19,21,23],[12,19,21,24],[12,19,21,25],
 [12,19,21,26],[12,19,21,37],[12,19,21,42],
 [12,19,21,44],[12,19,21,45],[12,19,21,46],
 [12,19,21,47],[12,19,21,48],[12,19,21,53],
 [12,19,21,55],[12,19,21,56],[12,19,21,58],
 [12,19,21,60],[12,19,21,61],[12,19,21,62],
 [12,19,21,64],[12,19,21,65],[12,19,21,67],
 [12,19,22,23],[12,19,22,24],[12,19,22,25],
 [12,19,22,26],[12,19,22,35],[12,19,22,36],
 [12,19,22,37],[12,19,22,44],[12,19,22,45],
 [12,19,22,46],[12,19,22,48],[12,19,22,53],
 [12,19,22,54],[12,19,22,55],[12,19,22,58],
 [12,19,22,60],[12,19,22,61],[12,19,22,67],
 [12,19,23,24],[12,19,23,25],[12,19,23,26],
 [12,19,23,35],[12,19,23,36],[12,19,23,37],
 [12,19,23,40],[12,19,23,42],[12,19,23,44],
 [12,19,23,45],[12,19,23,46],[12,19,23,47],
 [12,19,23,48],[12,19,23,53],[12,19,23,55],
 [12,19,23,56],[12,19,23,58],[12,19,23,60],
 [12,19,23,61],[12,19,23,62],[12,19,23,64],
 [12,19,23,65],[12,19,23,67],[12,19,24,25],
 [12,19,24,26],[12,19,24,36],[12,19,24,37],
 [12,19,24,42],[12,19,24,44],[12,19,24,45],
 [12,19,24,46],[12,19,24,47],[12,19,24,48],
 [12,19,24,53],[12,19,24,55],[12,19,24,56],
 [12,19,24,58],[12,19,24,60],[12,19,24,61],
 [12,19,24,63],[12,19,24,64],[12,19,24,65],
 [12,19,24,67],[12,19,25,26],[12,19,25,35],
 [12,19,25,37],[12,19,25,40],[12,19,25,42],
 [12,19,25,44],[12,19,25,45],[12,19,25,46],
 [12,19,25,47],[12,19,25,48],[12,19,25,53],
 [12,19,25,54],[12,19,25,55],[12,19,25,60],
 [12,19,25,61],[12,19,25,62],[12,19,25,64],
 [12,19,25,65],[12,19,25,67],[12,19,26,35],
 [12,19,26,36],[12,19,26,37],[12,19,26,40],
 [12,19,26,44],[12,19,26,45],[12,19,26,46],
 [12,19,26,47],[12,19,26,48],[12,19,26,54],
 [12,19,26,55],[12,19,26,56],[12,19,26,58],
 [12,19,26,60],[12,19,26,61],[12,19,26,62],
 [12,19,26,63],[12,19,26,64],[12,19,26,65],
 [12,19,26,67],[12,19,35,36],[12,19,35,37],
 [12,19,35,42],[12,19,35,45],[12,19,35,47],
 [12,19,35,55],[12,19,35,56],[12,19,35,58],
 [12,19,35,60],[12,19,35,62],[12,19,35,63],
 [12,19,35,65],[12,19,35,67],[12,19,36,40],
 [12,19,36,45],[12,19,36,46],[12,19,36,48],
 [12,19,36,54],[12,19,36,60],[12,19,36,61],
 [12,19,36,62],[12,19,37,40],[12,19,37,44],
 [12,19,37,45],[12,19,37,46],[12,19,37,47],
 [12,19,37,48],[12,19,37,58],[12,19,37,60],
 [12,19,37,61],[12,19,37,62],[12,19,37,64],
 [12,19,37,67],[12,19,40,42],[12,19,40,48],
 [12,19,40,53],[12,19,40,55],[12,19,40,61],
 [12,19,40,63],[12,19,40,65],[12,19,40,67],
 [12,19,42,44],[12,19,42,46],[12,19,42,47],
 [12,19,42,60],[12,19,42,61],[12,19,42,62],
 [12,19,42,63],[12,19,42,64],[12,19,44,46],
 [12,19,44,47],[12,19,44,53],[12,19,44,55],
 [12,19,44,58],[12,19,44,60],[12,19,44,61],
 [12,19,44,62],[12,19,44,64],[12,19,44,65],
 [12,19,44,67],[12,19,45,46],[12,19,45,47],
 [12,19,45,48],[12,19,45,53],[12,19,45,54],
 [12,19,45,55],[12,19,45,58],[12,19,45,61],
 [12,19,45,62],[12,19,45,65],[12,19,45,67],
 [12,19,46,47],[12,19,46,48],[12,19,46,53],
 [12,19,46,55],[12,19,46,56],[12,19,46,58],
 [12,19,46,60],[12,19,46,61],[12,19,46,62],
 [12,19,46,63],[12,19,46,65],[12,19,46,67],
 [12,19,47,48],[12,19,47,53],[12,19,47,54],
 [12,19,47,55],[12,19,47,56],[12,19,47,58],
 [12,19,47,60],[12,19,47,61],[12,19,47,62],
 [12,19,47,65],[12,19,47,67],[12,19,48,53],
 [12,19,48,55],[12,19,48,56],[12,19,48,58],
 [12,19,48,60],[12,19,48,61],[12,19,48,62],
 [12,19,48,63],[12,19,48,64],[12,19,48,67],
 [12,19,53,54],[12,19,53,60],[12,19,53,62],
 [12,19,53,63],[12,19,53,64],[12,19,54,56],
 [12,19,54,60],[12,19,54,62],[12,19,54,67],
 [12,19,55,60],[12,19,55,61],[12,19,55,62],
 [12,19,56,62],[12,19,58,60],[12,19,58,61],
 [12,19,58,62],[12,19,58,67],[12,19,60,61],
 [12,19,60,63],[12,19,60,65],[12,19,60,67],
 [12,19,61,62],[12,19,61,63],[12,19,61,67],
 [12,19,62,63],[12,19,62,65],[12,19,62,67],
 [12,19,63,64],[12,19,63,65],[12,19,63,67],
 [12,19,64,67],[12,20,21,24],[12,20,21,25],
 [12,20,21,26],[12,20,21,33],[12,20,21,34],
 [12,20,21,35],[12,20,21,44],[12,20,21,45],
 [12,20,21,46],[12,20,21,47],[12,20,21,48],
 [12,20,21,53],[12,20,21,55],[12,20,21,58],
 [12,20,21,60],[12,20,21,61],[12,20,21,65],
 [12,20,21,67],[12,20,21,69],[12,20,24,25],
 [12,20,24,26],[12,20,24,30],[12,20,24,32],
 [12,20,24,34],[12,20,24,42],[12,20,24,44],
 [12,20,24,45],[12,20,24,46],[12,20,24,47],
 [12,20,24,48],[12,20,24,53],[12,20,24,55],
 [12,20,24,56],[12,20,24,58],[12,20,24,60],
 [12,20,24,61],[12,20,24,63],[12,20,24,64],
 [12,20,24,65],[12,20,24,67],[12,20,24,69],
 [12,20,25,26],[12,20,25,28],[12,20,25,31],
 [12,20,25,32],[12,20,25,33],[12,20,25,34],
 [12,20,25,35],[12,20,25,40],[12,20,25,44],
 [12,20,25,45],[12,20,25,46],[12,20,25,47],
 [12,20,25,48],[12,20,25,53],[12,20,25,55],
 [12,20,25,60],[12,20,25,61],[12,20,25,67],
 [12,20,25,69],[12,20,26,28],[12,20,26,31],
 [12,20,26,35],[12,20,26,40],[12,20,26,44],
 [12,20,26,45],[12,20,26,46],[12,20,26,47],
 [12,20,26,48],[12,20,26,55],[12,20,26,56],
 [12,20,26,58],[12,20,26,60],[12,20,26,61],
 [12,20,26,63],[12,20,26,64],[12,20,26,65],
 [12,20,26,67],[12,20,28,30],[12,20,28,33],
 [12,20,28,35],[12,20,28,44],[12,20,28,47],
 [12,20,28,55],[12,20,28,61],[12,20,28,69],
 [12,20,30,35],[12,20,30,44],[12,20,30,45],
 [12,20,30,47],[12,20,30,53],[12,20,30,60],
 [12,20,30,61],[12,20,31,32],[12,20,31,42],
 [12,20,31,44],[12,20,31,47],[12,20,31,48],
 [12,20,31,53],[12,20,31,61],[12,20,31,63],
 [12,20,31,67],[12,20,31,69],[12,20,32,40],
 [12,20,32,44],[12,20,32,46],[12,20,32,47],
 [12,20,32,60],[12,20,32,61],[12,20,32,63],
 [12,20,33,44],[12,20,33,45],[12,20,33,47],
 [12,20,33,55],[12,20,33,56],[12,20,33,60],
 [12,20,33,61],[12,20,33,64],[12,20,33,67],
 [12,20,34,44],[12,20,34,45],[12,20,34,46],
 [12,20,34,47],[12,20,34,48],[12,20,34,55],
 [12,20,34,60],[12,20,34,61],[12,20,34,69],
 [12,20,35,42],[12,20,35,45],[12,20,35,47],
 [12,20,35,48],[12,20,35,55],[12,20,35,56],
 [12,20,35,58],[12,20,35,60],[12,20,35,63],
 [12,20,35,67],[12,20,35,69],[12,20,40,42],
 [12,20,40,44],[12,20,40,47],[12,20,40,48],
 [12,20,40,53],[12,20,40,55],[12,20,40,61],
 [12,20,40,63],[12,20,40,65],[12,20,40,67],
 [12,20,42,44],[12,20,42,46],[12,20,42,47],
 [12,20,42,60],[12,20,42,61],[12,20,42,63],
 [12,20,42,64],[12,20,44,46],[12,20,44,47],
 [12,20,44,53],[12,20,44,55],[12,20,44,58],
 [12,20,44,60],[12,20,44,61],[12,20,44,63],
 [12,20,44,64],[12,20,44,65],[12,20,44,67],
 [12,20,44,69],[12,20,45,46],[12,20,45,47],
 [12,20,45,48],[12,20,45,53],[12,20,45,55],
 [12,20,45,58],[12,20,45,61],[12,20,45,65],
 [12,20,45,67],[12,20,45,69],[12,20,46,47],
 [12,20,46,48],[12,20,46,53],[12,20,46,55],
 [12,20,46,56],[12,20,46,58],[12,20,46,60],
 [12,20,46,61],[12,20,46,63],[12,20,46,65],
 [12,20,46,67],[12,20,46,69],[12,20,47,48],
 [12,20,47,53],[12,20,47,55],[12,20,47,56],
 [12,20,47,58],[12,20,47,60],[12,20,47,61],
 [12,20,47,63],[12,20,47,64],[12,20,47,65],
 [12,20,47,67],[12,20,47,69],[12,20,48,55],
 [12,20,48,58],[12,20,48,60],[12,20,48,61],
 [12,20,48,63],[12,20,48,64],[12,20,48,67],
 [12,20,48,69],[12,20,53,60],[12,20,53,64],
 [12,20,55,60],[12,20,55,61],[12,20,55,69],
 [12,20,56,61],[12,20,58,60],[12,20,58,61],
 [12,20,58,67],[12,20,60,61],[12,20,60,65],
 [12,20,60,67],[12,20,60,69],[12,20,61,63],
 [12,20,61,64],[12,20,61,65],[12,20,61,67],
 [12,20,61,69],[12,20,63,64],[12,20,63,65],
 [12,20,63,67],[12,20,64,65],[12,20,64,67],
 [12,20,64,69],[12,21,23,24],[12,21,23,25],
 [12,21,23,26],[12,21,23,34],[12,21,23,35],
 [12,21,23,37],[12,21,23,42],[12,21,23,43],
 [12,21,23,44],[12,21,23,45],[12,21,23,46],
 [12,21,23,47],[12,21,23,48],[12,21,23,53],
 [12,21,23,55],[12,21,23,56],[12,21,23,58],
 [12,21,23,60],[12,21,23,61],[12,21,23,62],
 [12,21,23,64],[12,21,23,65],[12,21,23,67],
 [12,21,23,69],[12,21,24,25],[12,21,24,26],
 [12,21,24,33],[12,21,24,34],[12,21,24,35],
 [12,21,24,36],[12,21,24,37],[12,21,24,42],
 [12,21,24,43],[12,21,24,44],[12,21,24,45],
 [12,21,24,46],[12,21,24,47],[12,21,24,48],
 [12,21,24,49],[12,21,24,51],[12,21,24,53],
 [12,21,24,55],[12,21,24,58],[12,21,24,60],
 [12,21,24,61],[12,21,24,65],[12,21,24,67],
 [12,21,24,69],[12,21,25,26],[12,21,25,33],
 [12,21,25,34],[12,21,25,35],[12,21,25,36],
 [12,21,25,37],[12,21,25,42],[12,21,25,43],
 [12,21,25,44],[12,21,25,45],[12,21,25,46],
 [12,21,25,47],[12,21,25,48],[12,21,25,49],
 [12,21,25,51],[12,21,25,53],[12,21,25,55],
 [12,21,25,60],[12,21,25,61],[12,21,25,62],
 [12,21,25,64],[12,21,25,65],[12,21,25,67],
 [12,21,25,69],[12,21,26,35],[12,21,26,37],
 [12,21,26,43],[12,21,26,44],[12,21,26,45],
 [12,21,26,46],[12,21,26,47],[12,21,26,48],
 [12,21,26,49],[12,21,26,51],[12,21,26,55],
 [12,21,26,58],[12,21,26,60],[12,21,26,61],
 [12,21,26,62],[12,21,26,64],[12,21,26,67],
 [12,21,33,35],[12,21,33,36],[12,21,33,43],
 [12,21,33,45],[12,21,33,46],[12,21,33,48],
 [12,21,33,60],[12,21,33,61],[12,21,33,62],
 [12,21,33,64],[12,21,33,65],[12,21,33,67],
 [12,21,34,43],[12,21,34,44],[12,21,34,45],
 [12,21,34,46],[12,21,34,47],[12,21,34,48],
 [12,21,34,49],[12,21,34,55],[12,21,34,60],
 [12,21,34,61],[12,21,34,62],[12,21,34,69],
 [12,21,35,36],[12,21,35,37],[12,21,35,42],
 [12,21,35,45],[12,21,35,47],[12,21,35,48],
 [12,21,35,49],[12,21,35,55],[12,21,35,56],
 [12,21,35,58],[12,21,35,60],[12,21,35,62],
 [12,21,35,65],[12,21,35,67],[12,21,36,43],
 [12,21,36,45],[12,21,36,46],[12,21,36,48],
 [12,21,36,60],[12,21,36,61],[12,21,36,62],
 [12,21,36,64],[12,21,37,43],[12,21,37,44],
 [12,21,37,45],[12,21,37,46],[12,21,37,47],
 [12,21,37,48],[12,21,37,58],[12,21,37,60],
 [12,21,37,61],[12,21,37,62],[12,21,37,67],
 [12,21,42,43],[12,21,42,44],[12,21,42,46],
 [12,21,42,60],[12,21,42,62],[12,21,42,64],
 [12,21,43,44],[12,21,43,46],[12,21,43,47],
 [12,21,43,48],[12,21,43,49],[12,21,43,53],
 [12,21,43,55],[12,21,43,56],[12,21,43,58],
 [12,21,43,60],[12,21,43,61],[12,21,43,67],
 [12,21,43,69],[12,21,44,46],[12,21,44,47],
 [12,21,44,49],[12,21,44,53],[12,21,44,55],
 [12,21,44,58],[12,21,44,60],[12,21,44,61],
 [12,21,44,62],[12,21,44,64],[12,21,44,65],
 [12,21,44,67],[12,21,44,69],[12,21,45,46],
 [12,21,45,47],[12,21,45,48],[12,21,45,49],
 [12,21,45,51],[12,21,45,53],[12,21,45,55],
 [12,21,45,58],[12,21,45,61],[12,21,45,62],
 [12,21,45,65],[12,21,45,67],[12,21,45,69],
 [12,21,46,47],[12,21,46,48],[12,21,46,49],
 [12,21,46,53],[12,21,46,55],[12,21,46,56],
 [12,21,46,58],[12,21,46,60],[12,21,46,61],
 [12,21,46,62],[12,21,46,65],[12,21,46,67],
 [12,21,46,69],[12,21,47,48],[12,21,47,53],
 [12,21,47,55],[12,21,47,58],[12,21,47,60],
 [12,21,47,61],[12,21,47,62],[12,21,47,64],
 [12,21,47,65],[12,21,47,67],[12,21,47,69],
 [12,21,48,49],[12,21,48,51],[12,21,48,53],
 [12,21,48,55],[12,21,48,56],[12,21,48,58],
 [12,21,48,60],[12,21,48,61],[12,21,48,62],
 [12,21,48,64],[12,21,48,67],[12,21,48,69],
 [12,21,49,55],[12,21,49,56],[12,21,49,58],
 [12,21,49,60],[12,21,49,61],[12,21,49,62],
 [12,21,49,64],[12,21,49,67],[12,21,49,69],
 [12,21,51,53],[12,21,51,56],[12,21,51,60],
 [12,21,51,62],[12,21,51,67],[12,21,53,60],
 [12,21,53,62],[12,21,53,64],[12,21,55,60],
 [12,21,55,61],[12,21,55,62],[12,21,55,69],
 [12,21,56,61],[12,21,56,62],[12,21,58,60],
 [12,21,58,61],[12,21,58,62],[12,21,58,67],
 [12,21,60,61],[12,21,60,65],[12,21,60,67],
 [12,21,60,69],[12,21,61,62],[12,21,61,64],
 [12,21,61,65],[12,21,61,67],[12,21,61,69],
 [12,21,62,65],[12,21,62,67],[12,21,62,69],
 [12,21,64,65],[12,21,64,67],[12,21,64,69],
 [12,22,23,24],[12,22,23,25],[12,22,23,26],
 [12,22,23,31],[12,22,23,36],[12,22,23,37],
 [12,22,23,43],[12,22,23,44],[12,22,23,45],
 [12,22,23,46],[12,22,23,48],[12,22,23,53],
 [12,22,23,55],[12,22,23,56],[12,22,23,58],
 [12,22,23,60],[12,22,23,61],[12,22,23,67],
 [12,22,24,25],[12,22,24,26],[12,22,24,32],
 [12,22,24,33],[12,22,24,35],[12,22,24,36],
 [12,22,24,37],[12,22,24,42],[12,22,24,43],
 [12,22,24,44],[12,22,24,45],[12,22,24,46],
 [12,22,24,48],[12,22,24,54],[12,22,24,55],
 [12,22,24,56],[12,22,24,58],[12,22,24,60],
 [12,22,24,61],[12,22,24,64],[12,22,24,67],
 [12,22,25,26],[12,22,25,32],[12,22,25,33],
 [12,22,25,35],[12,22,25,36],[12,22,25,37],
 [12,22,25,42],[12,22,25,43],[12,22,25,44],
 [12,22,25,45],[12,22,25,46],[12,22,25,48],
 [12,22,25,53],[12,22,25,54],[12,22,25,55],
 [12,22,25,60],[12,22,25,61],[12,22,25,64],
 [12,22,25,67],[12,22,26,28],[12,22,26,31],
 [12,22,26,35],[12,22,26,36],[12,22,26,37],
 [12,22,26,43],[12,22,26,44],[12,22,26,45],
 [12,22,26,46],[12,22,26,48],[12,22,26,54],
 [12,22,26,55],[12,22,26,56],[12,22,26,58],
 [12,22,26,60],[12,22,26,61],[12,22,26,64],
 [12,22,26,67],[12,22,28,33],[12,22,28,35],
 [12,22,28,44],[12,22,28,54],[12,22,28,55],
 [12,22,28,56],[12,22,28,61],[12,22,31,32],
 [12,22,31,33],[12,22,31,36],[12,22,31,37],
 [12,22,31,44],[12,22,31,48],[12,22,31,55],
 [12,22,31,61],[12,22,32,35],[12,22,32,44],
 [12,22,32,60],[12,22,32,61],[12,22,32,64],
 [12,22,33,35],[12,22,33,36],[12,22,33,43],
 [12,22,33,44],[12,22,33,46],[12,22,33,54],
 [12,22,33,56],[12,22,33,60],[12,22,33,61],
 [12,22,33,64],[12,22,33,67],[12,22,35,36],
 [12,22,35,37],[12,22,35,42],[12,22,35,45],
 [12,22,35,56],[12,22,35,58],[12,22,35,60],
 [12,22,35,67],[12,22,36,43],[12,22,36,45],
 [12,22,36,46],[12,22,36,54],[12,22,36,60],
 [12,22,36,61],[12,22,36,64],[12,22,37,43],
 [12,22,37,44],[12,22,37,45],[12,22,37,46],
 [12,22,37,58],[12,22,37,60],[12,22,37,61],
 [12,22,37,64],[12,22,37,67],[12,22,42,43],
 [12,22,42,44],[12,22,42,46],[12,22,42,61],
 [12,22,42,64],[12,22,43,44],[12,22,43,46],
 [12,22,43,48],[12,22,43,53],[12,22,43,55],
 [12,22,43,56],[12,22,43,58],[12,22,43,60],
 [12,22,43,61],[12,22,43,67],[12,22,44,46],
 [12,22,44,53],[12,22,44,54],[12,22,44,55],
 [12,22,44,58],[12,22,44,60],[12,22,44,61],
 [12,22,44,64],[12,22,44,67],[12,22,45,46],
 [12,22,45,48],[12,22,45,53],[12,22,45,54],
 [12,22,45,55],[12,22,45,58],[12,22,45,61],
 [12,22,45,67],[12,22,46,48],[12,22,46,53],
 [12,22,46,55],[12,22,46,58],[12,22,46,60],
 [12,22,46,61],[12,22,46,67],[12,22,48,55],
 [12,22,48,56],[12,22,48,58],[12,22,48,60],
 [12,22,48,61],[12,22,48,64],[12,22,48,67],
 [12,22,53,60],[12,22,53,64],[12,22,54,56],
 [12,22,54,58],[12,22,54,61],[12,22,54,67],
 [12,22,55,60],[12,22,55,61],[12,22,56,61],
 [12,22,58,60],[12,22,58,61],[12,22,58,67],
 [12,22,60,61],[12,22,60,67],[12,22,61,64],
 [12,22,61,67],[12,22,64,67],[12,23,24,25],
 [12,23,24,26],[12,23,24,32],[12,23,24,34],
 [12,23,24,36],[12,23,24,37],[12,23,24,42],
 [12,23,24,43],[12,23,24,44],[12,23,24,45],
 [12,23,24,46],[12,23,24,47],[12,23,24,48],
 [12,23,24,53],[12,23,24,55],[12,23,24,56],
 [12,23,24,58],[12,23,24,60],[12,23,24,61],
 [12,23,24,65],[12,23,24,67],[12,23,24,69],
 [12,23,25,26],[12,23,25,31],[12,23,25,32],
 [12,23,25,34],[12,23,25,35],[12,23,25,37],
 [12,23,25,40],[12,23,25,42],[12,23,25,43],
 [12,23,25,44],[12,23,25,45],[12,23,25,46],
 [12,23,25,47],[12,23,25,48],[12,23,25,53],
 [12,23,25,55],[12,23,25,60],[12,23,25,61],
 [12,23,25,62],[12,23,25,64],[12,23,25,65],
 [12,23,25,67],[12,23,25,69],[12,23,26,31],
 [12,23,26,35],[12,23,26,36],[12,23,26,37],
 [12,23,26,40],[12,23,26,43],[12,23,26,44],
 [12,23,26,45],[12,23,26,46],[12,23,26,47],
 [12,23,26,48],[12,23,26,55],[12,23,26,56],
 [12,23,26,58],[12,23,26,60],[12,23,26,61],
 [12,23,26,62],[12,23,26,64],[12,23,26,67],
 [12,23,30,35],[12,23,30,44],[12,23,30,45],
 [12,23,30,48],[12,23,30,53],[12,23,30,61],
 [12,23,30,62],[12,23,31,32],[12,23,31,36],
 [12,23,31,37],[12,23,31,42],[12,23,31,44],
 [12,23,31,47],[12,23,31,48],[12,23,31,53],
 [12,23,31,55],[12,23,31,61],[12,23,31,65],
 [12,23,31,67],[12,23,31,69],[12,23,32,35],
 [12,23,32,40],[12,23,32,44],[12,23,32,46],
 [12,23,32,47],[12,23,32,60],[12,23,32,61],
 [12,23,32,62],[12,23,32,64],[12,23,34,43],
 [12,23,34,44],[12,23,34,45],[12,23,34,46],
 [12,23,34,47],[12,23,34,48],[12,23,34,55],
 [12,23,34,60],[12,23,34,61],[12,23,34,62],
 [12,23,34,69],[12,23,35,36],[12,23,35,37],
 [12,23,35,42],[12,23,35,45],[12,23,35,47],
 [12,23,35,48],[12,23,35,55],[12,23,35,56],
 [12,23,35,58],[12,23,35,60],[12,23,35,62],
 [12,23,35,65],[12,23,35,67],[12,23,35,69],
 [12,23,36,40],[12,23,36,43],[12,23,36,46],
 [12,23,36,48],[12,23,36,60],[12,23,36,61],
 [12,23,36,62],[12,23,36,64],[12,23,37,40],
 [12,23,37,43],[12,23,37,44],[12,23,37,45],
 [12,23,37,46],[12,23,37,47],[12,23,37,48],
 [12,23,37,58],[12,23,37,60],[12,23,37,61],
 [12,23,37,62],[12,23,37,64],[12,23,37,67],
 [12,23,40,42],[12,23,40,44],[12,23,40,47],
 [12,23,40,48],[12,23,40,53],[12,23,40,55],
 [12,23,40,58],[12,23,40,61],[12,23,40,65],
 [12,23,40,67],[12,23,40,69],[12,23,42,43],
 [12,23,42,46],[12,23,42,47],[12,23,42,60],
 [12,23,42,61],[12,23,42,62],[12,23,42,64],
 [12,23,43,44],[12,23,43,46],[12,23,43,47],
 [12,23,43,48],[12,23,43,53],[12,23,43,55],
 [12,23,43,56],[12,23,43,58],[12,23,43,60],
 [12,23,43,61],[12,23,43,67],[12,23,43,69],
 [12,23,44,46],[12,23,44,47],[12,23,44,53],
 [12,23,44,55],[12,23,44,58],[12,23,44,60],
 [12,23,44,61],[12,23,44,62],[12,23,44,65],
 [12,23,44,67],[12,23,44,69],[12,23,45,46],
 [12,23,45,47],[12,23,45,48],[12,23,45,53],
 [12,23,45,55],[12,23,45,58],[12,23,45,61],
 [12,23,45,62],[12,23,45,65],[12,23,45,67],
 [12,23,45,69],[12,23,46,47],[12,23,46,48],
 [12,23,46,53],[12,23,46,55],[12,23,46,56],
 [12,23,46,58],[12,23,46,60],[12,23,46,61],
 [12,23,46,62],[12,23,46,65],[12,23,46,67],
 [12,23,46,69],[12,23,47,48],[12,23,47,53],
 [12,23,47,55],[12,23,47,58],[12,23,47,60],
 [12,23,47,61],[12,23,47,62],[12,23,47,64],
 [12,23,47,65],[12,23,47,67],[12,23,47,69],
 [12,23,48,53],[12,23,48,55],[12,23,48,56],
 [12,23,48,58],[12,23,48,60],[12,23,48,61],
 [12,23,48,62],[12,23,48,64],[12,23,48,67],
 [12,23,48,69],[12,23,53,60],[12,23,53,62],
 [12,23,53,64],[12,23,55,60],[12,23,55,61],
 [12,23,55,62],[12,23,55,69],[12,23,56,61],
 [12,23,56,62],[12,23,58,60],[12,23,58,61],
 [12,23,58,62],[12,23,58,67],[12,23,60,61],
 [12,23,60,65],[12,23,60,67],[12,23,60,69],
 [12,23,61,62],[12,23,61,64],[12,23,61,65],
 [12,23,61,67],[12,23,61,69],[12,23,62,65],
 [12,23,62,67],[12,23,62,69],[12,23,64,65],
 [12,23,64,67],[12,23,64,69],[12,24,25,26],
 [12,24,25,32],[12,24,25,33],[12,24,25,34],
 [12,24,25,35],[12,24,25,36],[12,24,25,37],
 [12,24,25,42],[12,24,25,43],[12,24,25,44],
 [12,24,25,45],[12,24,25,46],[12,24,25,47],
 [12,24,25,48],[12,24,25,49],[12,24,25,51],
 [12,24,25,53],[12,24,25,54],[12,24,25,55],
 [12,24,25,60],[12,24,25,61],[12,24,25,65],
 [12,24,25,67],[12,24,25,69],[12,24,26,36],
 [12,24,26,37],[12,24,26,43],[12,24,26,44],
 [12,24,26,45],[12,24,26,46],[12,24,26,47],
 [12,24,26,48],[12,24,26,49],[12,24,26,51],
 [12,24,26,54],[12,24,26,55],[12,24,26,56],
 [12,24,26,58],[12,24,26,60],[12,24,26,61],
 [12,24,26,63],[12,24,26,64],[12,24,26,65],
 [12,24,26,67],[12,24,30,35],[12,24,30,44],
 [12,24,30,45],[12,24,30,47],[12,24,30,48],
 [12,24,30,49],[12,24,30,53],[12,24,30,61],
 [12,24,32,35],[12,24,32,44],[12,24,32,46],
 [12,24,32,47],[12,24,32,49],[12,24,32,51],
 [12,24,32,60],[12,24,32,61],[12,24,32,63],
 [12,24,32,64],[12,24,33,35],[12,24,33,36],
 [12,24,33,45],[12,24,33,47],[12,24,33,48],
 [12,24,33,55],[12,24,33,56],[12,24,33,60],
 [12,24,33,65],[12,24,33,67],[12,24,34,43],
 [12,24,34,44],[12,24,34,45],[12,24,34,46],
 [12,24,34,47],[12,24,34,48],[12,24,34,49],
 [12,24,34,55],[12,24,34,60],[12,24,34,61],
 [12,24,34,69],[12,24,35,36],[12,24,35,37],
 [12,24,35,42],[12,24,35,45],[12,24,35,47],
 [12,24,35,48],[12,24,35,49],[12,24,35,55],
 [12,24,35,56],[12,24,35,58],[12,24,35,60],
 [12,24,35,65],[12,24,35,67],[12,24,35,69],
 [12,24,36,43],[12,24,36,45],[12,24,36,46],
 [12,24,36,48],[12,24,36,54],[12,24,36,60],
 [12,24,36,61],[12,24,36,63],[12,24,36,64],
 [12,24,37,43],[12,24,37,44],[12,24,37,45],
 [12,24,37,46],[12,24,37,47],[12,24,37,48],
 [12,24,37,58],[12,24,37,60],[12,24,37,61],
 [12,24,37,64],[12,24,37,67],[12,24,42,43],
 [12,24,42,44],[12,24,42,46],[12,24,42,47],
 [12,24,42,49],[12,24,42,51],[12,24,42,60],
 [12,24,42,61],[12,24,42,63],[12,24,42,64],
 [12,24,43,44],[12,24,43,46],[12,24,43,47],
 [12,24,43,48],[12,24,43,49],[12,24,43,53],
 [12,24,43,55],[12,24,43,56],[12,24,43,58],
 [12,24,43,60],[12,24,43,61],[12,24,43,67],
 [12,24,43,69],[12,24,44,46],[12,24,44,47],
 [12,24,44,49],[12,24,44,53],[12,24,44,54],
 [12,24,44,55],[12,24,44,58],[12,24,44,60],
 [12,24,44,61],[12,24,44,63],[12,24,44,64],
 [12,24,44,65],[12,24,44,67],[12,24,44,69],
 [12,24,45,46],[12,24,45,47],[12,24,45,48],
 [12,24,45,49],[12,24,45,51],[12,24,45,53],
 [12,24,45,54],[12,24,45,55],[12,24,45,58],
 [12,24,45,61],[12,24,45,65],[12,24,45,67],
 [12,24,45,69],[12,24,46,47],[12,24,46,48],
 [12,24,46,49],[12,24,46,53],[12,24,46,55],
 [12,24,46,56],[12,24,46,58],[12,24,46,60],
 [12,24,46,61],[12,24,46,65],[12,24,46,67],
 [12,24,46,69],[12,24,47,48],[12,24,47,53],
 [12,24,47,54],[12,24,47,55],[12,24,47,56],
 [12,24,47,58],[12,24,47,60],[12,24,47,61],
 [12,24,47,63],[12,24,47,64],[12,24,47,65],
 [12,24,47,67],[12,24,47,69],[12,24,48,49],
 [12,24,48,51],[12,24,48,53],[12,24,48,55],
 [12,24,48,56],[12,24,48,58],[12,24,48,60],
 [12,24,48,61],[12,24,48,63],[12,24,48,64],
 [12,24,48,67],[12,24,48,69],[12,24,49,53],
 [12,24,49,55],[12,24,49,56],[12,24,49,58],
 [12,24,49,60],[12,24,49,61],[12,24,49,63],
 [12,24,49,64],[12,24,49,65],[12,24,49,67],
 [12,24,49,69],[12,24,51,53],[12,24,51,56],
 [12,24,51,58],[12,24,51,60],[12,24,51,61],
 [12,24,51,64],[12,24,51,65],[12,24,51,67],
 [12,24,51,69],[12,24,53,54],[12,24,53,60],
 [12,24,53,63],[12,24,53,64],[12,24,54,56],
 [12,24,54,60],[12,24,54,61],[12,24,54,67],
 [12,24,54,69],[12,24,55,60],[12,24,55,61],
 [12,24,55,69],[12,24,56,61],[12,24,58,60],
 [12,24,58,61],[12,24,58,67],[12,24,60,61],
 [12,24,60,65],[12,24,60,67],[12,24,60,69],
 [12,24,61,63],[12,24,61,64],[12,24,61,65],
 [12,24,61,67],[12,24,61,69],[12,24,63,64],
 [12,24,63,65],[12,24,63,67],[12,24,63,69],
 [12,24,64,65],[12,24,64,67],[12,24,64,69],
 [12,25,26,31],[12,25,26,35],[12,25,26,37],
 [12,25,26,40],[12,25,26,43],[12,25,26,44],
 [12,25,26,45],[12,25,26,46],[12,25,26,47],
 [12,25,26,48],[12,25,26,49],[12,25,26,51],
 [12,25,26,54],[12,25,26,55],[12,25,26,60],
 [12,25,26,61],[12,25,26,62],[12,25,26,64],
 [12,25,26,67],[12,25,28,35],[12,25,28,54],
 [12,25,28,55],[12,25,28,61],[12,25,28,69],
 [12,25,31,32],[12,25,31,33],[12,25,31,36],
 [12,25,31,37],[12,25,31,42],[12,25,31,44],
 [12,25,31,47],[12,25,31,48],[12,25,31,49],
 [12,25,31,53],[12,25,31,55],[12,25,31,61],
 [12,25,31,65],[12,25,31,67],[12,25,31,69],
 [12,25,32,35],[12,25,32,40],[12,25,32,44],
 [12,25,32,46],[12,25,32,47],[12,25,32,49],
 [12,25,32,51],[12,25,32,60],[12,25,32,61],
 [12,25,32,62],[12,25,32,64],[12,25,33,35],
 [12,25,33,36],[12,25,33,40],[12,25,33,43],
 [12,25,33,45],[12,25,33,46],[12,25,33,48],
 [12,25,33,54],[12,25,33,55],[12,25,33,60],
 [12,25,33,61],[12,25,33,62],[12,25,33,64],
 [12,25,33,65],[12,25,34,43],[12,25,34,44],
 [12,25,34,45],[12,25,34,46],[12,25,34,47],
 [12,25,34,48],[12,25,34,49],[12,25,34,55],
 [12,25,34,60],[12,25,34,61],[12,25,34,62],
 [12,25,34,69],[12,25,35,36],[12,25,35,37],
 [12,25,35,42],[12,25,35,45],[12,25,35,47],
 [12,25,35,48],[12,25,35,49],[12,25,35,55],
 [12,25,35,60],[12,25,35,62],[12,25,35,65],
 [12,25,35,67],[12,25,35,69],[12,25,36,40],
 [12,25,36,43],[12,25,36,45],[12,25,36,46],
 [12,25,36,48],[12,25,36,54],[12,25,36,60],
 [12,25,36,61],[12,25,36,62],[12,25,36,64],
 [12,25,37,40],[12,25,37,43],[12,25,37,44],
 [12,25,37,45],[12,25,37,46],[12,25,37,47],
 [12,25,37,48],[12,25,37,60],[12,25,37,61],
 [12,25,37,62],[12,25,37,64],[12,25,37,67],
 [12,25,40,42],[12,25,40,44],[12,25,40,47],
 [12,25,40,48],[12,25,40,49],[12,25,40,53],
 [12,25,40,55],[12,25,40,61],[12,25,40,65],
 [12,25,40,67],[12,25,40,69],[12,25,42,43],
 [12,25,42,44],[12,25,42,46],[12,25,42,47],
 [12,25,42,49],[12,25,42,51],[12,25,42,60],
 [12,25,42,61],[12,25,42,62],[12,25,42,64],
 [12,25,43,44],[12,25,43,46],[12,25,43,47],
 [12,25,43,48],[12,25,43,49],[12,25,43,53],
 [12,25,43,55],[12,25,43,60],[12,25,43,61],
 [12,25,43,67],[12,25,43,69],[12,25,44,46],
 [12,25,44,47],[12,25,44,49],[12,25,44,54],
 [12,25,44,55],[12,25,44,60],[12,25,44,61],
 [12,25,44,62],[12,25,44,64],[12,25,44,67],
 [12,25,44,69],[12,25,45,46],[12,25,45,47],
 [12,25,45,48],[12,25,45,49],[12,25,45,51],
 [12,25,45,53],[12,25,45,54],[12,25,45,55],
 [12,25,45,61],[12,25,45,62],[12,25,45,65],
 [12,25,45,67],[12,25,45,69],[12,25,46,47],
 [12,25,46,48],[12,25,46,49],[12,25,46,53],
 [12,25,46,55],[12,25,46,60],[12,25,46,61],
 [12,25,46,62],[12,25,46,65],[12,25,46,67],
 [12,25,46,69],[12,25,47,48],[12,25,47,53],
 [12,25,47,55],[12,25,47,60],[12,25,47,61],
 [12,25,47,62],[12,25,47,64],[12,25,47,65],
 [12,25,47,67],[12,25,47,69],[12,25,48,49],
 [12,25,48,51],[12,25,48,53],[12,25,48,55],
 [12,25,48,60],[12,25,48,61],[12,25,48,62],
 [12,25,48,64],[12,25,48,67],[12,25,48,69],
 [12,25,49,53],[12,25,49,55],[12,25,49,60],
 [12,25,49,61],[12,25,49,62],[12,25,49,64],
 [12,25,49,65],[12,25,49,67],[12,25,49,69],
 [12,25,51,53],[12,25,51,60],[12,25,51,61],
 [12,25,51,62],[12,25,51,64],[12,25,51,65],
 [12,25,51,67],[12,25,51,69],[12,25,53,54],
 [12,25,53,60],[12,25,53,62],[12,25,53,64],
 [12,25,54,60],[12,25,54,61],[12,25,54,62],
 [12,25,54,67],[12,25,54,69],[12,25,55,60],
 [12,25,55,61],[12,25,55,62],[12,25,55,69],
 [12,25,60,61],[12,25,60,65],[12,25,60,67],
 [12,25,60,69],[12,25,61,62],[12,25,61,64],
 [12,25,61,65],[12,25,61,67],[12,25,61,69],
 [12,25,62,65],[12,25,62,67],[12,25,62,69],
 [12,25,64,65],[12,25,64,67],[12,25,64,69],
 [12,26,28,35],[12,26,28,44],[12,26,28,47],
 [12,26,28,54],[12,26,28,55],[12,26,28,56],
 [12,26,28,61],[12,26,31,36],[12,26,31,37],
 [12,26,31,44],[12,26,31,47],[12,26,31,48],
 [12,26,31,49],[12,26,31,55],[12,26,31,61],
 [12,26,31,63],[12,26,31,65],[12,26,31,67],
 [12,26,35,36],[12,26,35,37],[12,26,35,45],
 [12,26,35,47],[12,26,35,48],[12,26,35,49],
 [12,26,35,55],[12,26,35,56],[12,26,35,58],
 [12,26,35,60],[12,26,35,62],[12,26,35,63],
 [12,26,35,65],[12,26,35,67],[12,26,36,40],
 [12,26,36,43],[12,26,36,45],[12,26,36,46],
 [12,26,36,48],[12,26,36,54],[12,26,36,60],
 [12,26,36,61],[12,26,36,62],[12,26,36,63],
 [12,26,36,64],[12,26,37,40],[12,26,37,43],
 [12,26,37,44],[12,26,37,45],[12,26,37,46],
 [12,26,37,47],[12,26,37,48],[12,26,37,60],
 [12,26,37,61],[12,26,37,62],[12,26,37,64],
 [12,26,37,67],[12,26,40,44],[12,26,40,47],
 [12,26,40,48],[12,26,40,49],[12,26,40,55],
 [12,26,40,58],[12,26,40,61],[12,26,40,63],
 [12,26,40,65],[12,26,40,67],[12,26,43,44],
 [12,26,43,46],[12,26,43,47],[12,26,43,48],
 [12,26,43,49],[12,26,43,55],[12,26,43,56],
 [12,26,43,58],[12,26,43,60],[12,26,43,61],
 [12,26,43,67],[12,26,44,46],[12,26,44,47],
 [12,26,44,49],[12,26,44,54],[12,26,44,55],
 [12,26,44,58],[12,26,44,60],[12,26,44,61],
 [12,26,44,62],[12,26,44,63],[12,26,44,64],
 [12,26,44,65],[12,26,44,67],[12,26,45,46],
 [12,26,45,47],[12,26,45,48],[12,26,45,49],
 [12,26,45,51],[12,26,45,55],[12,26,45,58],
 [12,26,45,61],[12,26,45,62],[12,26,45,67],
 [12,26,46,47],[12,26,46,48],[12,26,46,49],
 [12,26,46,55],[12,26,46,56],[12,26,46,58],
 [12,26,46,60],[12,26,46,61],[12,26,46,62],
 [12,26,46,63],[12,26,46,65],[12,26,46,67],
 [12,26,47,48],[12,26,47,54],[12,26,47,55],
 [12,26,47,56],[12,26,47,58],[12,26,47,60],
 [12,26,47,61],[12,26,47,62],[12,26,47,63],
 [12,26,47,64],[12,26,47,65],[12,26,47,67],
 [12,26,48,49],[12,26,48,51],[12,26,48,55],
 [12,26,48,56],[12,26,48,58],[12,26,48,60],
 [12,26,48,61],[12,26,48,62],[12,26,48,64],
 [12,26,48,67],[12,26,49,55],[12,26,49,56],
 [12,26,49,58],[12,26,49,60],[12,26,49,61],
 [12,26,49,62],[12,26,49,63],[12,26,49,64],
 [12,26,49,65],[12,26,49,67],[12,26,51,56],
 [12,26,51,58],[12,26,51,60],[12,26,51,61],
 [12,26,51,62],[12,26,51,64],[12,26,51,65],
 [12,26,51,67],[12,26,54,56],[12,26,54,58],
 [12,26,54,60],[12,26,54,61],[12,26,54,62],
 [12,26,54,67],[12,26,55,60],[12,26,55,61],
 [12,26,55,62],[12,26,56,61],[12,26,56,62],
 [12,26,58,60],[12,26,58,61],[12,26,58,62],
 [12,26,58,63],[12,26,58,67],[12,26,60,61],
 [12,26,60,63],[12,26,60,65],[12,26,60,67],
 [12,26,61,62],[12,26,61,63],[12,26,61,64],
 [12,26,61,65],[12,26,61,67],[12,26,62,63],
 [12,26,62,65],[12,26,62,67],[12,26,63,64],
 [12,26,63,65],[12,26,64,65],[12,26,64,67],
 [12,28,30,44],[12,28,30,47],[12,28,30,48],
 [12,28,30,61],[12,28,33,35],[12,28,33,44],
 [12,28,33,47],[12,28,33,48],[12,28,33,54],
 [12,28,33,55],[12,28,33,61],[12,28,35,47],
 [12,28,35,48],[12,28,35,55],[12,28,35,56],
 [12,28,35,69],[12,28,44,47],[12,28,44,54],
 [12,28,44,61],[12,28,47,54],[12,28,47,55],
 [12,28,47,56],[12,28,47,61],[12,28,47,69],
 [12,28,48,55],[12,28,48,56],[12,28,48,61],
 [12,28,48,69],[12,28,54,56],[12,28,54,61],
 [12,28,54,69],[12,28,55,69],[12,30,35,47],
 [12,30,35,48],[12,30,35,49],[12,30,35,60],
 [12,30,44,47],[12,30,44,49],[12,30,44,53],
 [12,30,44,61],[12,30,45,47],[12,30,45,48],
 [12,30,45,62],[12,30,47,48],[12,30,47,53],
 [12,30,47,61],[12,30,47,62],[12,30,48,60],
 [12,30,49,53],[12,30,49,60],[12,30,49,61],
 [12,30,53,60],[12,30,53,62],[12,30,60,61],
 [12,31,32,44],[12,31,32,47],[12,31,32,49],
 [12,31,32,61],[12,31,32,63],[12,31,33,36],
 [12,31,33,44],[12,31,33,47],[12,31,33,48],
 [12,31,33,55],[12,31,33,61],[12,31,33,65],
 [12,31,33,67],[12,31,36,48],[12,31,36,63],
 [12,31,37,47],[12,31,37,48],[12,31,37,67],
 [12,31,42,44],[12,31,42,47],[12,31,42,49],
 [12,31,42,63],[12,31,44,47],[12,31,44,49],
 [12,31,44,61],[12,31,44,63],[12,31,44,67],
 [12,31,47,48],[12,31,47,53],[12,31,47,61],
 [12,31,47,63],[12,31,47,65],[12,31,47,67],
 [12,31,47,69],[12,31,48,49],[12,31,48,55],
 [12,31,48,63],[12,31,48,67],[12,31,48,69],
 [12,31,49,53],[12,31,49,55],[12,31,49,61],
 [12,31,49,63],[12,31,49,65],[12,31,49,67],
 [12,31,49,69],[12,31,53,63],[12,31,55,69],
 [12,31,61,63],[12,31,63,65],[12,31,63,67],
 [12,31,63,69],[12,32,35,47],[12,32,35,49],
 [12,32,35,63],[12,32,40,44],[12,32,40,47],
 [12,32,40,49],[12,32,40,63],[12,32,44,46],
 [12,32,44,47],[12,32,44,49],[12,32,44,60],
 [12,32,44,61],[12,32,46,47],[12,32,46,49],
 [12,32,46,60],[12,32,46,62],[12,32,46,63],
 [12,32,47,60],[12,32,47,61],[12,32,47,62],
 [12,32,47,63],[12,32,47,64],[12,32,49,60],
 [12,32,49,61],[12,32,49,62],[12,32,49,63],
 [12,32,49,64],[12,32,51,60],[12,32,51,62],
 [12,32,51,64],[12,32,60,63],[12,32,61,63],
 [12,32,62,63],[12,32,63,64],[12,33,35,36],
 [12,33,35,45],[12,33,35,47],[12,33,35,48],
 [12,33,35,55],[12,33,35,56],[12,33,35,60],
 [12,33,35,62],[12,33,35,65],[12,33,35,67],
 [12,33,36,40],[12,33,36,43],[12,33,36,45],
 [12,33,36,46],[12,33,36,48],[12,33,36,54],
 [12,33,36,60],[12,33,36,61],[12,33,36,62],
 [12,33,36,64],[12,33,40,44],[12,33,40,47],
 [12,33,40,48],[12,33,40,55],[12,33,40,61],
 [12,33,40,65],[12,33,40,67],[12,33,43,44],
 [12,33,43,46],[12,33,43,47],[12,33,43,48],
 [12,33,43,56],[12,33,43,60],[12,33,43,61],
 [12,33,43,67],[12,33,44,46],[12,33,44,47],
 [12,33,44,54],[12,33,44,55],[12,33,44,60],
 [12,33,44,61],[12,33,44,62],[12,33,44,64],
 [12,33,44,65],[12,33,44,67],[12,33,45,46],
 [12,33,45,47],[12,33,45,48],[12,33,45,54],
 [12,33,45,55],[12,33,45,61],[12,33,45,62],
 [12,33,45,67],[12,33,46,47],[12,33,46,48],
 [12,33,46,55],[12,33,46,56],[12,33,46,60],
 [12,33,46,61],[12,33,46,62],[12,33,46,65],
 [12,33,46,67],[12,33,47,48],[12,33,47,54],
 [12,33,47,55],[12,33,47,56],[12,33,47,60],
 [12,33,47,61],[12,33,47,62],[12,33,47,64],
 [12,33,47,65],[12,33,47,67],[12,33,48,56],
 [12,33,48,60],[12,33,48,61],[12,33,48,62],
 [12,33,48,64],[12,33,48,67],[12,33,54,56],
 [12,33,54,60],[12,33,54,61],[12,33,54,62],
 [12,33,54,67],[12,33,55,60],[12,33,55,61],
 [12,33,55,62],[12,33,56,61],[12,33,56,62],
 [12,33,60,61],[12,33,60,65],[12,33,60,67],
 [12,33,61,62],[12,33,61,64],[12,33,61,65],
 [12,33,61,67],[12,33,62,65],[12,33,62,67],
 [12,33,64,65],[12,33,64,67],[12,34,43,44],
 [12,34,43,46],[12,34,43,47],[12,34,43,48],
 [12,34,43,49],[12,34,43,55],[12,34,43,60],
 [12,34,43,61],[12,34,43,69],[12,34,44,46],
 [12,34,44,47],[12,34,44,49],[12,34,44,55],
 [12,34,44,60],[12,34,44,61],[12,34,44,62],
 [12,34,44,69],[12,34,45,46],[12,34,45,47],
 [12,34,45,48],[12,34,45,49],[12,34,45,55],
 [12,34,45,61],[12,34,45,62],[12,34,45,69],
 [12,34,46,47],[12,34,46,48],[12,34,46,49],
 [12,34,46,55],[12,34,46,60],[12,34,46,61],
 [12,34,46,62],[12,34,46,63],[12,34,46,69],
 [12,34,47,48],[12,34,47,55],[12,34,47,60],
 [12,34,47,61],[12,34,47,62],[12,34,47,63],
 [12,34,47,69],[12,34,48,49],[12,34,48,55],
 [12,34,48,60],[12,34,48,61],[12,34,48,62],
 [12,34,48,63],[12,34,48,69],[12,34,49,55],
 [12,34,49,60],[12,34,49,61],[12,34,49,62],
 [12,34,49,63],[12,34,49,69],[12,34,55,60],
 [12,34,55,61],[12,34,55,62],[12,34,55,69],
 [12,34,60,61],[12,34,60,63],[12,34,60,69],
 [12,34,61,62],[12,34,61,63],[12,34,61,69],
 [12,34,62,63],[12,34,62,69],[12,34,63,69],
 [12,35,36,45],[12,35,36,48],[12,35,36,60],
 [12,35,36,62],[12,35,36,63],[12,35,37,45],
 [12,35,37,47],[12,35,37,48],[12,35,37,58],
 [12,35,37,60],[12,35,37,62],[12,35,37,67],
 [12,35,42,47],[12,35,42,49],[12,35,42,62],
 [12,35,42,63],[12,35,45,47],[12,35,45,48],
 [12,35,45,58],[12,35,45,62],[12,35,45,67],
 [12,35,47,48],[12,35,47,62],[12,35,47,63],
 [12,35,47,65],[12,35,47,67],[12,35,47,69],
 [12,35,48,49],[12,35,48,55],[12,35,48,56],
 [12,35,48,58],[12,35,48,60],[12,35,48,62],
 [12,35,48,63],[12,35,48,67],[12,35,48,69],
 [12,35,49,55],[12,35,49,56],[12,35,49,58],
 [12,35,49,60],[12,35,49,63],[12,35,49,65],
 [12,35,49,67],[12,35,49,69],[12,35,55,60],
 [12,35,55,69],[12,35,56,62],[12,35,58,62],
 [12,35,58,63],[12,35,58,67],[12,35,60,63],
 [12,35,60,65],[12,35,60,69],[12,35,62,63],
 [12,35,62,67],[12,35,63,65],[12,35,63,67],
 [12,35,63,69],[12,36,40,48],[12,36,40,63],
 [12,36,43,46],[12,36,43,48],[12,36,45,46],
 [12,36,45,48],[12,36,45,54],[12,36,45,61],
 [12,36,45,62],[12,36,46,48],[12,36,46,61],
 [12,36,46,62],[12,36,46,63],[12,36,48,60],
 [12,36,48,61],[12,36,48,62],[12,36,48,63],
 [12,36,48,64],[12,36,54,61],[12,36,54,62],
 [12,36,60,63],[12,36,61,62],[12,36,61,63],
 [12,36,61,64],[12,36,62,63],[12,36,63,64],
 [12,37,40,44],[12,37,40,47],[12,37,40,48],
 [12,37,40,58],[12,37,40,61],[12,37,40,67],
 [12,37,43,44],[12,37,43,46],[12,37,43,47],
 [12,37,43,48],[12,37,43,58],[12,37,43,60],
 [12,37,43,61],[12,37,43,67],[12,37,44,46],
 [12,37,44,47],[12,37,44,58],[12,37,44,60],
 [12,37,44,61],[12,37,44,67],[12,37,45,46],
 [12,37,45,47],[12,37,45,48],[12,37,45,58],
 [12,37,45,62],[12,37,45,67],[12,37,46,47],
 [12,37,46,48],[12,37,46,58],[12,37,46,60],
 [12,37,46,61],[12,37,46,67],[12,37,47,48],
 [12,37,47,58],[12,37,47,60],[12,37,47,61],
 [12,37,47,62],[12,37,47,64],[12,37,47,67],
 [12,37,48,58],[12,37,48,60],[12,37,48,61],
 [12,37,48,62],[12,37,48,64],[12,37,48,67],
 [12,37,58,60],[12,37,58,61],[12,37,58,62],
 [12,37,58,67],[12,37,60,61],[12,37,60,67],
 [12,37,61,67],[12,37,62,67],[12,37,64,67],
 [12,40,42,44],[12,40,42,47],[12,40,42,49],
 [12,40,42,61],[12,40,42,63],[12,40,44,47],
 [12,40,44,49],[12,40,44,53],[12,40,44,61],
 [12,40,44,63],[12,40,44,65],[12,40,44,69],
 [12,40,47,48],[12,40,47,53],[12,40,47,61],
 [12,40,47,63],[12,40,47,65],[12,40,47,67],
 [12,40,47,69],[12,40,48,49],[12,40,48,55],
 [12,40,48,58],[12,40,48,63],[12,40,48,67],
 [12,40,48,69],[12,40,49,53],[12,40,49,55],
 [12,40,49,58],[12,40,49,61],[12,40,49,63],
 [12,40,49,65],[12,40,49,67],[12,40,49,69],
 [12,40,53,63],[12,40,55,61],[12,40,55,69],
 [12,40,58,63],[12,40,58,67],[12,40,61,63],
 [12,40,61,65],[12,40,63,65],[12,40,63,67],
 [12,40,63,69],[12,42,43,46],[12,42,43,47],
 [12,42,43,49],[12,42,43,60],[12,42,44,46],
 [12,42,44,47],[12,42,44,49],[12,42,44,61],
 [12,42,44,62],[12,42,44,63],[12,42,44,64],
 [12,42,46,47],[12,42,46,49],[12,42,46,60],
 [12,42,46,62],[12,42,46,63],[12,42,47,60],
 [12,42,47,61],[12,42,47,62],[12,42,47,63],
 [12,42,47,64],[12,42,49,60],[12,42,49,61],
 [12,42,49,62],[12,42,49,63],[12,42,49,64],
 [12,42,51,60],[12,42,51,62],[12,42,51,64],
 [12,42,60,63],[12,42,61,63],[12,42,61,64],
 [12,42,62,63],[12,42,63,64],[12,43,44,46],
 [12,43,44,47],[12,43,44,49],[12,43,44,53],
 [12,43,44,55],[12,43,44,58],[12,43,44,60],
 [12,43,44,61],[12,43,44,67],[12,43,44,69],
 [12,43,46,47],[12,43,46,48],[12,43,46,49],
 [12,43,46,53],[12,43,46,55],[12,43,46,56],
 [12,43,46,58],[12,43,46,60],[12,43,46,61],
 [12,43,46,67],[12,43,46,69],[12,43,47,48],
 [12,43,47,53],[12,43,47,55],[12,43,47,58],
 [12,43,47,60],[12,43,47,61],[12,43,47,67],
 [12,43,47,69],[12,43,48,49],[12,43,48,55],
 [12,43,48,56],[12,43,48,58],[12,43,48,60],
 [12,43,48,61],[12,43,48,67],[12,43,48,69],
 [12,43,49,53],[12,43,49,55],[12,43,49,56],
 [12,43,49,58],[12,43,49,60],[12,43,49,61],
 [12,43,49,67],[12,43,49,69],[12,43,53,60],
 [12,43,55,60],[12,43,55,61],[12,43,55,69],
 [12,43,58,60],[12,43,58,61],[12,43,58,67],
 [12,43,60,61],[12,43,60,67],[12,43,60,69],
 [12,43,61,67],[12,43,61,69],[12,44,46,47],
 [12,44,46,49],[12,44,46,53],[12,44,46,55],
 [12,44,46,58],[12,44,46,60],[12,44,46,61],
 [12,44,46,62],[12,44,46,65],[12,44,46,67],
 [12,44,46,69],[12,44,47,53],[12,44,47,54],
 [12,44,47,55],[12,44,47,58],[12,44,47,60],
 [12,44,47,61],[12,44,47,62],[12,44,47,63],
 [12,44,47,64],[12,44,47,65],[12,44,47,67],
 [12,44,47,69],[12,44,49,53],[12,44,49,55],
 [12,44,49,58],[12,44,49,60],[12,44,49,61],
 [12,44,49,62],[12,44,49,63],[12,44,49,64],
 [12,44,49,65],[12,44,49,67],[12,44,49,69],
 [12,44,53,54],[12,44,53,60],[12,44,53,63],
 [12,44,54,61],[12,44,54,62],[12,44,54,67],
 [12,44,55,60],[12,44,55,61],[12,44,55,62],
 [12,44,55,69],[12,44,58,60],[12,44,58,61],
 [12,44,58,62],[12,44,58,67],[12,44,60,61],
 [12,44,60,63],[12,44,60,65],[12,44,60,67],
 [12,44,60,69],[12,44,61,62],[12,44,61,63],
 [12,44,61,64],[12,44,61,65],[12,44,61,67],
 [12,44,61,69],[12,44,62,63],[12,44,62,67],
 [12,44,62,69],[12,44,63,64],[12,44,63,65],
 [12,44,63,69],[12,44,64,65],[12,44,64,67],
 [12,45,46,47],[12,45,46,48],[12,45,46,49],
 [12,45,46,55],[12,45,46,58],[12,45,46,61],
 [12,45,46,62],[12,45,46,65],[12,45,46,67],
 [12,45,46,69],[12,45,47,48],[12,45,47,53],
 [12,45,47,55],[12,45,47,58],[12,45,47,61],
 [12,45,47,62],[12,45,47,67],[12,45,47,69],
 [12,45,48,49],[12,45,48,51],[12,45,48,53],
 [12,45,48,55],[12,45,48,58],[12,45,48,61],
 [12,45,48,62],[12,45,48,67],[12,45,48,69],
 [12,45,49,55],[12,45,49,58],[12,45,49,61],
 [12,45,49,62],[12,45,49,67],[12,45,49,69],
 [12,45,51,53],[12,45,51,58],[12,45,51,62],
 [12,45,51,67],[12,45,51,69],[12,45,53,62],
 [12,45,54,58],[12,45,54,62],[12,45,54,67],
 [12,45,54,69],[12,45,55,61],[12,45,55,62],
 [12,45,55,69],[12,45,58,61],[12,45,58,62],
 [12,45,58,67],[12,45,61,62],[12,45,61,67],
 [12,45,61,69],[12,45,62,65],[12,45,62,67],
 [12,45,62,69],[12,46,47,48],[12,46,47,53],
 [12,46,47,55],[12,46,47,58],[12,46,47,60],
 [12,46,47,61],[12,46,47,62],[12,46,47,63],
 [12,46,47,65],[12,46,47,67],[12,46,47,69],
 [12,46,48,49],[12,46,48,55],[12,46,48,56],
 [12,46,48,58],[12,46,48,60],[12,46,48,61],
 [12,46,48,62],[12,46,48,63],[12,46,48,67],
 [12,46,48,69],[12,46,49,53],[12,46,49,55],
 [12,46,49,56],[12,46,49,58],[12,46,49,60],
 [12,46,49,61],[12,46,49,62],[12,46,49,63],
 [12,46,49,65],[12,46,49,67],[12,46,49,69],
 [12,46,53,60],[12,46,53,62],[12,46,53,63],
 [12,46,55,60],[12,46,55,61],[12,46,55,62],
 [12,46,55,69],[12,46,56,61],[12,46,56,62],
 [12,46,58,60],[12,46,58,61],[12,46,58,62],
 [12,46,58,63],[12,46,58,67],[12,46,60,61],
 [12,46,60,63],[12,46,60,65],[12,46,60,67],
 [12,46,60,69],[12,46,61,62],[12,46,61,63],
 [12,46,61,67],[12,46,61,69],[12,46,62,63],
 [12,46,62,65],[12,46,62,67],[12,46,62,69],
 [12,46,63,65],[12,46,63,67],[12,46,63,69],
 [12,47,48,53],[12,47,48,55],[12,47,48,58],
 [12,47,48,60],[12,47,48,61],[12,47,48,62],
 [12,47,48,63],[12,47,48,64],[12,47,48,67],
 [12,47,48,69],[12,47,53,54],[12,47,53,60],
 [12,47,53,62],[12,47,53,63],[12,47,53,64],
 [12,47,54,56],[12,47,54,61],[12,47,54,62],
 [12,47,54,69],[12,47,55,60],[12,47,55,61],
 [12,47,55,62],[12,47,55,69],[12,47,56,61],
 [12,47,56,62],[12,47,58,60],[12,47,58,61],
 [12,47,58,62],[12,47,58,63],[12,47,58,67],
 [12,47,60,61],[12,47,60,63],[12,47,60,65],
 [12,47,60,67],[12,47,60,69],[12,47,61,62],
 [12,47,61,63],[12,47,61,64],[12,47,61,65],
 [12,47,61,67],[12,47,61,69],[12,47,62,63],
 [12,47,62,65],[12,47,62,67],[12,47,62,69],
 [12,47,63,64],[12,47,63,65],[12,47,63,67],
 [12,47,63,69],[12,47,64,65],[12,47,64,67],
 [12,47,64,69],[12,48,49,55],[12,48,49,56],
 [12,48,49,58],[12,48,49,60],[12,48,49,61],
 [12,48,49,62],[12,48,49,63],[12,48,49,64],
 [12,48,49,67],[12,48,49,69],[12,48,51,53],
 [12,48,51,56],[12,48,51,58],[12,48,51,60],
 [12,48,51,62],[12,48,51,64],[12,48,51,67],
 [12,48,53,60],[12,48,53,62],[12,48,53,63],
 [12,48,53,64],[12,48,55,60],[12,48,55,61],
 [12,48,55,62],[12,48,55,69],[12,48,56,61],
 [12,48,56,62],[12,48,58,60],[12,48,58,61],
 [12,48,58,62],[12,48,58,63],[12,48,58,67],
 [12,48,60,61],[12,48,60,63],[12,48,60,67],
 [12,48,60,69],[12,48,61,62],[12,48,61,63],
 [12,48,61,67],[12,48,61,69],[12,48,62,63],
 [12,48,62,67],[12,48,62,69],[12,48,63,64],
 [12,48,63,67],[12,48,63,69],[12,48,64,67],
 [12,48,64,69],[12,49,53,60],[12,49,53,62],
 [12,49,53,63],[12,49,53,64],[12,49,55,60],
 [12,49,55,61],[12,49,55,62],[12,49,55,69],
 [12,49,56,61],[12,49,56,62],[12,49,58,60],
 [12,49,58,61],[12,49,58,62],[12,49,58,63],
 [12,49,58,67],[12,49,60,61],[12,49,60,63],
 [12,49,60,65],[12,49,60,67],[12,49,60,69],
 [12,49,61,62],[12,49,61,63],[12,49,61,64],
 [12,49,61,65],[12,49,61,67],[12,49,61,69],
 [12,49,62,63],[12,49,62,65],[12,49,62,67],
 [12,49,62,69],[12,49,63,64],[12,49,63,65],
 [12,49,63,67],[12,49,63,69],[12,49,64,65],
 [12,49,64,67],[12,49,64,69],[12,51,53,60],
 [12,51,53,62],[12,51,53,64],[12,51,56,61],
 [12,51,56,62],[12,51,58,60],[12,51,58,61],
 [12,51,58,62],[12,51,58,67],[12,51,60,61],
 [12,51,60,65],[12,51,60,67],[12,51,60,69],
 [12,51,61,62],[12,51,61,64],[12,51,61,65],
 [12,51,61,67],[12,51,61,69],[12,51,62,65],
 [12,51,62,67],[12,51,62,69],[12,51,64,65],
 [12,51,64,67],[12,51,64,69],[12,53,54,60],
 [12,53,54,62],[12,53,60,63],[12,53,62,63],
 [12,53,63,64],[12,54,56,61],[12,54,56,62],
 [12,54,58,60],[12,54,58,61],[12,54,58,62],
 [12,54,58,67],[12,54,60,61],[12,54,60,67],
 [12,54,60,69],[12,54,61,62],[12,54,61,67],
 [12,54,61,69],[12,54,62,67],[12,54,62,69],
 [12,55,60,61],[12,55,60,69],[12,55,61,62],
 [12,55,61,69],[12,55,62,69],[12,56,61,62],
 [12,58,60,61],[12,58,60,63],[12,58,60,67],
 [12,58,61,62],[12,58,61,63],[12,58,61,67],
 [12,58,62,63],[12,58,62,67],[12,58,63,67],
 [12,60,61,63],[12,60,61,67],[12,60,61,69],
 [12,60,63,65],[12,60,63,67],[12,60,63,69],
 [12,61,62,63],[12,61,62,67],[12,61,62,69],
 [12,61,63,64],[12,61,63,65],[12,61,63,67],
 [12,61,63,69],[12,61,64,65],[12,62,63,65],
 [12,62,63,67],[12,62,63,69],[12,63,64,65],
 [12,63,64,67],[12,63,64,69],[13,15,16,19],
 [13,15,16,20],[13,15,16,21],[13,15,16,22],
 [13,15,16,23],[13,15,16,24],[13,15,16,25],
 [13,15,16,26],[13,15,16,27],[13,15,16,34],
 [13,15,16,39],[13,15,16,41],[13,15,16,43],
 [13,15,16,44],[13,15,16,45],[13,15,16,46],
 [13,15,16,47],[13,15,16,48],[13,15,16,49],
 [13,15,16,55],[13,15,16,58],[13,15,16,59],
 [13,15,16,60],[13,15,16,61],[13,15,16,62],
 [13,15,16,66],[13,15,16,67],[13,15,16,68],
 [13,15,16,69],[13,15,19,20],[13,15,19,21],
 [13,15,19,22],[13,15,19,23],[13,15,19,24],
 [13,15,19,25],[13,15,19,26],[13,15,19,27],
 [13,15,19,34],[13,15,19,39],[13,15,19,41],
 [13,15,19,43],[13,15,19,44],[13,15,19,45],
 [13,15,19,46],[13,15,19,47],[13,15,19,48],
 [13,15,19,49],[13,15,19,52],[13,15,19,55],
 [13,15,19,58],[13,15,19,59],[13,15,19,60],
 [13,15,19,61],[13,15,19,62],[13,15,19,64],
 [13,15,19,65],[13,15,19,66],[13,15,19,67],
 [13,15,19,68],[13,15,19,69],[13,15,20,21],
 [13,15,20,22],[13,15,20,23],[13,15,20,24],
 [13,15,20,25],[13,15,20,26],[13,15,20,27],
 [13,15,20,34],[13,15,20,39],[13,15,20,41],
 [13,15,20,43],[13,15,20,44],[13,15,20,45],
 [13,15,20,46],[13,15,20,47],[13,15,20,48],
 [13,15,20,49],[13,15,20,52],[13,15,20,55],
 [13,15,20,58],[13,15,20,59],[13,15,20,60],
 [13,15,20,61],[13,15,20,62],[13,15,20,63],
 [13,15,20,64],[13,15,20,65],[13,15,20,66],
 [13,15,20,67],[13,15,20,68],[13,15,20,69],
 [13,15,21,22],[13,15,21,23],[13,15,21,24],
 [13,15,21,25],[13,15,21,26],[13,15,21,27],
 [13,15,21,34],[13,15,21,37],[13,15,21,39],
 [13,15,21,41],[13,15,21,43],[13,15,21,44],
 [13,15,21,45],[13,15,21,46],[13,15,21,47],
 [13,15,21,48],[13,15,21,49],[13,15,21,55],
 [13,15,21,58],[13,15,21,59],[13,15,21,60],
 [13,15,21,61],[13,15,21,62],[13,15,21,65],
 [13,15,21,66],[13,15,21,67],[13,15,21,68],
 [13,15,21,69],[13,15,22,23],[13,15,22,24],
 [13,15,22,25],[13,15,22,26],[13,15,22,27],
 [13,15,22,34],[13,15,22,39],[13,15,22,41],
 [13,15,22,43],[13,15,22,44],[13,15,22,45],
 [13,15,22,46],[13,15,22,47],[13,15,22,48],
 [13,15,22,49],[13,15,22,55],[13,15,22,58],
 [13,15,22,59],[13,15,22,60],[13,15,22,61],
 [13,15,22,62],[13,15,22,63],[13,15,22,64],
 [13,15,22,65],[13,15,22,66],[13,15,22,67],
 [13,15,22,68],[13,15,22,69],[13,15,23,24],
 [13,15,23,25],[13,15,23,26],[13,15,23,27],
 [13,15,23,34],[13,15,23,37],[13,15,23,39],
 [13,15,23,41],[13,15,23,43],[13,15,23,44],
 [13,15,23,45],[13,15,23,46],[13,15,23,47],
 [13,15,23,48],[13,15,23,49],[13,15,23,52],
 [13,15,23,55],[13,15,23,58],[13,15,23,59],
 [13,15,23,60],[13,15,23,61],[13,15,23,62],
 [13,15,23,64],[13,15,23,66],[13,15,23,67],
 [13,15,23,68],[13,15,23,69],[13,15,24,25],
 [13,15,24,26],[13,15,24,27],[13,15,24,34],
 [13,15,24,37],[13,15,24,39],[13,15,24,41],
 [13,15,24,43],[13,15,24,44],[13,15,24,45],
 [13,15,24,46],[13,15,24,47],[13,15,24,48],
 [13,15,24,49],[13,15,24,52],[13,15,24,55],
 [13,15,24,58],[13,15,24,59],[13,15,24,60],
 [13,15,24,61],[13,15,24,62],[13,15,24,63],
 [13,15,24,64],[13,15,24,65],[13,15,24,66],
 [13,15,24,67],[13,15,24,68],[13,15,24,69],
 [13,15,25,26],[13,15,25,27],[13,15,25,34],
 [13,15,25,37],[13,15,25,39],[13,15,25,41],
 [13,15,25,43],[13,15,25,44],[13,15,25,45],
 [13,15,25,46],[13,15,25,47],[13,15,25,48],
 [13,15,25,49],[13,15,25,55],[13,15,25,58],
 [13,15,25,59],[13,15,25,60],[13,15,25,61],
 [13,15,25,62],[13,15,25,65],[13,15,25,66],
 [13,15,25,67],[13,15,25,68],[13,15,25,69],
 [13,15,26,27],[13,15,26,34],[13,15,26,39],
 [13,15,26,41],[13,15,26,43],[13,15,26,44],
 [13,15,26,45],[13,15,26,46],[13,15,26,47],
 [13,15,26,48],[13,15,26,49],[13,15,26,52],
 [13,15,26,55],[13,15,26,58],[13,15,26,59],
 [13,15,26,60],[13,15,26,61],[13,15,26,62],
 [13,15,26,63],[13,15,26,64],[13,15,26,65],
 [13,15,26,66],[13,15,26,67],[13,15,26,68],
 [13,15,26,69],[13,15,27,34],[13,15,27,39],
 [13,15,27,41],[13,15,27,43],[13,15,27,44],
 [13,15,27,45],[13,15,27,46],[13,15,27,47],
 [13,15,27,48],[13,15,27,49],[13,15,27,52],
 [13,15,27,55],[13,15,27,58],[13,15,27,59],
 [13,15,27,60],[13,15,27,61],[13,15,27,62],
 [13,15,27,64],[13,15,27,66],[13,15,27,67],
 [13,15,27,68],[13,15,27,69],[13,15,34,39],
 [13,15,34,41],[13,15,34,43],[13,15,34,44],
 [13,15,34,45],[13,15,34,46],[13,15,34,47],
 [13,15,34,48],[13,15,34,49],[13,15,34,52],
 [13,15,34,55],[13,15,34,58],[13,15,34,59],
 [13,15,34,60],[13,15,34,61],[13,15,34,62],
 [13,15,34,63],[13,15,34,66],[13,15,34,67],
 [13,15,34,68],[13,15,34,69],[13,15,37,39],
 [13,15,37,43],[13,15,37,44],[13,15,37,46],
 [13,15,37,47],[13,15,37,52],[13,15,37,59],
 [13,15,37,60],[13,15,37,61],[13,15,37,67],
 [13,15,37,68],[13,15,39,41],[13,15,39,43],
 [13,15,39,44],[13,15,39,45],[13,15,39,46],
 [13,15,39,47],[13,15,39,48],[13,15,39,49],
 [13,15,39,52],[13,15,39,55],[13,15,39,58],
 [13,15,39,59],[13,15,39,60],[13,15,39,61],
 [13,15,39,62],[13,15,39,63],[13,15,39,64],
 [13,15,39,65],[13,15,39,66],[13,15,39,67],
 [13,15,39,68],[13,15,39,69],[13,15,41,43],
 [13,15,41,44],[13,15,41,45],[13,15,41,46],
 [13,15,41,47],[13,15,41,48],[13,15,41,49],
 [13,15,41,55],[13,15,41,58],[13,15,41,59],
 [13,15,41,60],[13,15,41,61],[13,15,41,62],
 [13,15,41,66],[13,15,41,67],[13,15,41,68],
 [13,15,41,69],[13,15,43,44],[13,15,43,45],
 [13,15,43,46],[13,15,43,47],[13,15,43,48],
 [13,15,43,49],[13,15,43,55],[13,15,43,58],
 [13,15,43,59],[13,15,43,60],[13,15,43,61],
 [13,15,43,62],[13,15,43,65],[13,15,43,66],
 [13,15,43,67],[13,15,43,68],[13,15,43,69],
 [13,15,44,45],[13,15,44,46],[13,15,44,47],
 [13,15,44,48],[13,15,44,49],[13,15,44,52],
 [13,15,44,55],[13,15,44,58],[13,15,44,59],
 [13,15,44,60],[13,15,44,61],[13,15,44,62],
 [13,15,44,64],[13,15,44,65],[13,15,44,66],
 [13,15,44,67],[13,15,44,68],[13,15,44,69],
 [13,15,45,46],[13,15,45,47],[13,15,45,48],
 [13,15,45,49],[13,15,45,55],[13,15,45,58],
 [13,15,45,59],[13,15,45,60],[13,15,45,61],
 [13,15,45,62],[13,15,45,66],[13,15,45,67],
 [13,15,45,68],[13,15,45,69],[13,15,46,47],
 [13,15,46,48],[13,15,46,49],[13,15,46,52],
 [13,15,46,55],[13,15,46,58],[13,15,46,59],
 [13,15,46,60],[13,15,46,61],[13,15,46,62],
 [13,15,46,63],[13,15,46,66],[13,15,46,67],
 [13,15,46,68],[13,15,46,69],[13,15,47,48],
 [13,15,47,49],[13,15,47,52],[13,15,47,55],
 [13,15,47,58],[13,15,47,59],[13,15,47,60],
 [13,15,47,61],[13,15,47,62],[13,15,47,65],
 [13,15,47,66],[13,15,47,67],[13,15,47,68],
 [13,15,47,69],[13,15,48,49],[13,15,48,52],
 [13,15,48,55],[13,15,48,58],[13,15,48,59],
 [13,15,48,60],[13,15,48,61],[13,15,48,62],
 [13,15,48,63],[13,15,48,66],[13,15,48,67],
 [13,15,48,68],[13,15,48,69],[13,15,49,52],
 [13,15,49,55],[13,15,49,58],[13,15,49,59],
 [13,15,49,60],[13,15,49,61],[13,15,49,62],
 [13,15,49,63],[13,15,49,64],[13,15,49,65],
 [13,15,49,66],[13,15,49,67],[13,15,49,68],
 [13,15,49,69],[13,15,52,61],[13,15,52,66],
 [13,15,52,69],[13,15,55,58],[13,15,55,59],
 [13,15,55,60],[13,15,55,61],[13,15,55,62],
 [13,15,55,66],[13,15,55,67],[13,15,55,68],
 [13,15,55,69],[13,15,58,59],[13,15,58,60],
 [13,15,58,61],[13,15,58,62],[13,15,58,66],
 [13,15,58,67],[13,15,58,68],[13,15,58,69],
 [13,15,59,60],[13,15,59,61],[13,15,59,62],
 [13,15,59,63],[13,15,59,65],[13,15,59,66],
 [13,15,59,67],[13,15,59,68],[13,15,59,69],
 [13,15,60,61],[13,15,60,62],[13,15,60,65],
 [13,15,60,66],[13,15,60,67],[13,15,60,68],
 [13,15,60,69],[13,15,61,62],[13,15,61,63],
 [13,15,61,64],[13,15,61,65],[13,15,61,66],
 [13,15,61,67],[13,15,61,68],[13,15,61,69],
 [13,15,62,63],[13,15,62,66],[13,15,62,67],
 [13,15,62,68],[13,15,62,69],[13,15,63,64],
 [13,15,63,65],[13,15,63,66],[13,15,63,68],
 [13,15,63,69],[13,15,64,65],[13,15,64,67],
 [13,15,66,67],[13,15,66,68],[13,15,66,69],
 [13,15,67,68],[13,15,67,69],[13,15,68,69],
 [13,16,19,20],[13,16,19,21],[13,16,19,22],
 [13,16,19,23],[13,16,19,24],[13,16,19,25],
 [13,16,19,26],[13,16,19,27],[13,16,19,30],
 [13,16,19,34],[13,16,19,35],[13,16,19,39],
 [13,16,19,41],[13,16,19,43],[13,16,19,44],
 [13,16,19,45],[13,16,19,46],[13,16,19,47],
 [13,16,19,48],[13,16,19,49],[13,16,19,54],
 [13,16,19,55],[13,16,19,56],[13,16,19,57],
 [13,16,19,58],[13,16,19,59],[13,16,19,60],
 [13,16,19,61],[13,16,19,62],[13,16,19,66],
 [13,16,19,67],[13,16,19,68],[13,16,19,69],
 [13,16,20,21],[13,16,20,22],[13,16,20,23],
 [13,16,20,24],[13,16,20,25],[13,16,20,26],
 [13,16,20,27],[13,16,20,34],[13,16,20,39],
 [13,16,20,41],[13,16,20,43],[13,16,20,44],
 [13,16,20,45],[13,16,20,46],[13,16,20,47],
 [13,16,20,48],[13,16,20,49],[13,16,20,55],
 [13,16,20,58],[13,16,20,59],[13,16,20,60],
 [13,16,20,61],[13,16,20,62],[13,16,20,66],
 [13,16,20,67],[13,16,20,68],[13,16,20,69],
 [13,16,21,22],[13,16,21,23],[13,16,21,24],
 [13,16,21,25],[13,16,21,26],[13,16,21,27],
 [13,16,21,30],[13,16,21,34],[13,16,21,39],
 [13,16,21,41],[13,16,21,43],[13,16,21,44],
 [13,16,21,45],[13,16,21,46],[13,16,21,47],
 [13,16,21,48],[13,16,21,49],[13,16,21,50],
 [13,16,21,53],[13,16,21,55],[13,16,21,56],
 [13,16,21,57],[13,16,21,58],[13,16,21,59],
 [13,16,21,60],[13,16,21,61],[13,16,21,62],
 [13,16,21,66],[13,16,21,67],[13,16,21,68],
 [13,16,21,69],[13,16,22,23],[13,16,22,24],
 [13,16,22,25],[13,16,22,26],[13,16,22,27],
 [13,16,22,30],[13,16,22,34],[13,16,22,39],
 [13,16,22,41],[13,16,22,43],[13,16,22,44],
 [13,16,22,45],[13,16,22,46],[13,16,22,47],
 [13,16,22,48],[13,16,22,49],[13,16,22,50],
 [13,16,22,54],[13,16,22,55],[13,16,22,56],
 [13,16,22,57],[13,16,22,58],[13,16,22,59],
 [13,16,22,60],[13,16,22,61],[13,16,22,62],
 [13,16,22,66],[13,16,22,67],[13,16,22,68],
 [13,16,22,69],[13,16,23,24],[13,16,23,25],
 [13,16,23,26],[13,16,23,27],[13,16,23,30],
 [13,16,23,34],[13,16,23,35],[13,16,23,39],
 [13,16,23,41],[13,16,23,43],[13,16,23,44],
 [13,16,23,45],[13,16,23,46],[13,16,23,47],
 [13,16,23,48],[13,16,23,49],[13,16,23,50],
 [13,16,23,53],[13,16,23,55],[13,16,23,56],
 [13,16,23,57],[13,16,23,58],[13,16,23,59],
 [13,16,23,60],[13,16,23,61],[13,16,23,62],
 [13,16,23,66],[13,16,23,67],[13,16,23,68],
 [13,16,23,69],[13,16,24,25],[13,16,24,26],
 [13,16,24,27],[13,16,24,34],[13,16,24,39],
 [13,16,24,41],[13,16,24,43],[13,16,24,44],
 [13,16,24,45],[13,16,24,46],[13,16,24,47],
 [13,16,24,48],[13,16,24,49],[13,16,24,53],
 [13,16,24,55],[13,16,24,58],[13,16,24,59],
 [13,16,24,60],[13,16,24,61],[13,16,24,62],
 [13,16,24,66],[13,16,24,67],[13,16,24,68],
 [13,16,24,69],[13,16,25,26],[13,16,25,27],
 [13,16,25,34],[13,16,25,35],[13,16,25,39],
 [13,16,25,41],[13,16,25,43],[13,16,25,44],
 [13,16,25,45],[13,16,25,46],[13,16,25,47],
 [13,16,25,48],[13,16,25,49],[13,16,25,50],
 [13,16,25,53],[13,16,25,54],[13,16,25,55],
 [13,16,25,57],[13,16,25,58],[13,16,25,59],
 [13,16,25,60],[13,16,25,61],[13,16,25,62],
 [13,16,25,66],[13,16,25,67],[13,16,25,68],
 [13,16,25,69],[13,16,26,27],[13,16,26,30],
 [13,16,26,34],[13,16,26,35],[13,16,26,39],
 [13,16,26,41],[13,16,26,43],[13,16,26,44],
 [13,16,26,45],[13,16,26,46],[13,16,26,47],
 [13,16,26,48],[13,16,26,49],[13,16,26,50],
 [13,16,26,53],[13,16,26,54],[13,16,26,55],
 [13,16,26,56],[13,16,26,57],[13,16,26,58],
 [13,16,26,59],[13,16,26,60],[13,16,26,61],
 [13,16,26,62],[13,16,26,66],[13,16,26,67],
 [13,16,26,68],[13,16,26,69],[13,16,27,30],
 [13,16,27,34],[13,16,27,35],[13,16,27,39],
 [13,16,27,41],[13,16,27,43],[13,16,27,44],
 [13,16,27,45],[13,16,27,46],[13,16,27,47],
 [13,16,27,48],[13,16,27,49],[13,16,27,53],
 [13,16,27,54],[13,16,27,55],[13,16,27,56],
 [13,16,27,58],[13,16,27,59],[13,16,27,60],
 [13,16,27,61],[13,16,27,62],[13,16,27,66],
 [13,16,27,67],[13,16,27,68],[13,16,27,69],
 [13,16,30,41],[13,16,30,45],[13,16,30,47],
 [13,16,30,48],[13,16,30,49],[13,16,30,58],
 [13,16,30,59],[13,16,30,60],[13,16,30,62],
 [13,16,30,67],[13,16,30,68],[13,16,34,39],
 [13,16,34,41],[13,16,34,43],[13,16,34,44],
 [13,16,34,45],[13,16,34,46],[13,16,34,47],
 [13,16,34,48],[13,16,34,49],[13,16,34,55],
 [13,16,34,56],[13,16,34,58],[13,16,34,59],
 [13,16,34,60],[13,16,34,61],[13,16,34,62],
 [13,16,34,66],[13,16,34,67],[13,16,34,68],
 [13,16,34,69],[13,16,35,41],[13,16,35,45],
 [13,16,35,47],[13,16,35,48],[13,16,35,59],
 [13,16,35,60],[13,16,35,62],[13,16,35,68],
 [13,16,39,41],[13,16,39,43],[13,16,39,44],
 [13,16,39,45],[13,16,39,46],[13,16,39,47],
 [13,16,39,48],[13,16,39,49],[13,16,39,55],
 [13,16,39,58],[13,16,39,59],[13,16,39,60],
 [13,16,39,61],[13,16,39,62],[13,16,39,66],
 [13,16,39,67],[13,16,39,68],[13,16,39,69],
 [13,16,41,43],[13,16,41,44],[13,16,41,45],
 [13,16,41,46],[13,16,41,47],[13,16,41,48],
 [13,16,41,49],[13,16,41,50],[13,16,41,53],
 [13,16,41,54],[13,16,41,55],[13,16,41,56],
 [13,16,41,57],[13,16,41,58],[13,16,41,59],
 [13,16,41,60],[13,16,41,61],[13,16,41,62],
 [13,16,41,66],[13,16,41,67],[13,16,41,68],
 [13,16,41,69],[13,16,43,44],[13,16,43,45],
 [13,16,43,46],[13,16,43,47],[13,16,43,48],
 [13,16,43,49],[13,16,43,55],[13,16,43,56],
 [13,16,43,57],[13,16,43,58],[13,16,43,59],
 [13,16,43,60],[13,16,43,61],[13,16,43,62],
 [13,16,43,66],[13,16,43,67],[13,16,43,68],
 [13,16,43,69],[13,16,44,45],[13,16,44,46],
 [13,16,44,47],[13,16,44,48],[13,16,44,49],
 [13,16,44,50],[13,16,44,54],[13,16,44,55],
 [13,16,44,58],[13,16,44,59],[13,16,44,60],
 [13,16,44,61],[13,16,44,62],[13,16,44,66],
 [13,16,44,67],[13,16,44,68],[13,16,44,69],
 [13,16,45,46],[13,16,45,47],[13,16,45,48],
 [13,16,45,49],[13,16,45,50],[13,16,45,53],
 [13,16,45,54],[13,16,45,55],[13,16,45,57],
 [13,16,45,58],[13,16,45,59],[13,16,45,60],
 [13,16,45,61],[13,16,45,62],[13,16,45,66],
 [13,16,45,67],[13,16,45,68],[13,16,45,69],
 [13,16,46,47],[13,16,46,48],[13,16,46,49],
 [13,16,46,55],[13,16,46,56],[13,16,46,57],
 [13,16,46,58],[13,16,46,59],[13,16,46,60],
 [13,16,46,61],[13,16,46,62],[13,16,46,66],
 [13,16,46,67],[13,16,46,68],[13,16,46,69],
 [13,16,47,48],[13,16,47,49],[13,16,47,50],
 [13,16,47,53],[13,16,47,54],[13,16,47,55],
 [13,16,47,56],[13,16,47,57],[13,16,47,58],
 [13,16,47,59],[13,16,47,60],[13,16,47,61],
 [13,16,47,62],[13,16,47,66],[13,16,47,67],
 [13,16,47,68],[13,16,47,69],[13,16,48,49],
 [13,16,48,50],[13,16,48,53],[13,16,48,55],
 [13,16,48,56],[13,16,48,57],[13,16,48,58],
 [13,16,48,59],[13,16,48,60],[13,16,48,61],
 [13,16,48,62],[13,16,48,66],[13,16,48,67],
 [13,16,48,68],[13,16,48,69],[13,16,49,50],
 [13,16,49,54],[13,16,49,55],[13,16,49,56],
 [13,16,49,57],[13,16,49,58],[13,16,49,59],
 [13,16,49,60],[13,16,49,61],[13,16,49,62],
 [13,16,49,66],[13,16,49,67],[13,16,49,68],
 [13,16,49,69],[13,16,50,53],[13,16,50,59],
 [13,16,50,61],[13,16,50,62],[13,16,50,66],
 [13,16,50,67],[13,16,50,68],[13,16,50,69],
 [13,16,53,56],[13,16,53,58],[13,16,53,60],
 [13,16,53,68],[13,16,54,56],[13,16,54,57],
 [13,16,54,58],[13,16,54,59],[13,16,54,60],
 [13,16,54,62],[13,16,54,66],[13,16,54,67],
 [13,16,54,68],[13,16,54,69],[13,16,55,58],
 [13,16,55,59],[13,16,55,60],[13,16,55,61],
 [13,16,55,62],[13,16,55,66],[13,16,55,67],
 [13,16,55,68],[13,16,55,69],[13,16,56,57],
 [13,16,56,59],[13,16,56,62],[13,16,56,66],
 [13,16,56,68],[13,16,56,69],[13,16,57,58],
 [13,16,57,60],[13,16,57,67],[13,16,57,68],
 [13,16,58,59],[13,16,58,60],[13,16,58,61],
 [13,16,58,62],[13,16,58,66],[13,16,58,67],
 [13,16,58,68],[13,16,58,69],[13,16,59,60],
 [13,16,59,61],[13,16,59,62],[13,16,59,66],
 [13,16,59,67],[13,16,59,68],[13,16,59,69],
 [13,16,60,61],[13,16,60,62],[13,16,60,66],
 [13,16,60,67],[13,16,60,68],[13,16,60,69],
 [13,16,61,62],[13,16,61,66],[13,16,61,67],
 [13,16,61,68],[13,16,61,69],[13,16,62,66],
 [13,16,62,67],[13,16,62,68],[13,16,62,69],
 [13,16,66,67],[13,16,66,68],[13,16,66,69],
 [13,16,67,68],[13,16,67,69],[13,16,68,69],
 [13,19,20,21],[13,19,20,22],[13,19,20,23],
 [13,19,20,24],[13,19,20,25],[13,19,20,26],
 [13,19,20,27],[13,19,20,34],[13,19,20,36],
 [13,19,20,39],[13,19,20,41],[13,19,20,43],
 [13,19,20,44],[13,19,20,45],[13,19,20,46],
 [13,19,20,47],[13,19,20,48],[13,19,20,49],
 [13,19,20,52],[13,19,20,55],[13,19,20,56],
 [13,19,20,58],[13,19,20,59],[13,19,20,60],
 [13,19,20,61],[13,19,20,62],[13,19,20,64],
 [13,19,20,66],[13,19,20,67],[13,19,20,68],
 [13,19,20,69],[13,19,21,22],[13,19,21,23],
 [13,19,21,24],[13,19,21,25],[13,19,21,26],
 [13,19,21,27],[13,19,21,31],[13,19,21,34],
 [13,19,21,39],[13,19,21,41],[13,19,21,43],
 [13,19,21,44],[13,19,21,45],[13,19,21,46],
 [13,19,21,47],[13,19,21,48],[13,19,21,49],
 [13,19,21,51],[13,19,21,53],[13,19,21,55],
 [13,19,21,56],[13,19,21,57],[13,19,21,58],
 [13,19,21,59],[13,19,21,60],[13,19,21,61],
 [13,19,21,62],[13,19,21,64],[13,19,21,65],
 [13,19,21,66],[13,19,21,67],[13,19,21,68],
 [13,19,21,69],[13,19,22,23],[13,19,22,24],
 [13,19,22,25],[13,19,22,26],[13,19,22,27],
 [13,19,22,30],[13,19,22,34],[13,19,22,39],
 [13,19,22,41],[13,19,22,43],[13,19,22,44],
 [13,19,22,45],[13,19,22,46],[13,19,22,47],
 [13,19,22,48],[13,19,22,49],[13,19,22,54],
 [13,19,22,55],[13,19,22,57],[13,19,22,58],
 [13,19,22,59],[13,19,22,60],[13,19,22,61],
 [13,19,22,62],[13,19,22,63],[13,19,22,65],
 [13,19,22,66],[13,19,22,67],[13,19,22,68],
 [13,19,22,69],[13,19,23,24],[13,19,23,25],
 [13,19,23,26],[13,19,23,27],[13,19,23,31],
 [13,19,23,34],[13,19,23,35],[13,19,23,36],
 [13,19,23,39],[13,19,23,41],[13,19,23,43],
 [13,19,23,44],[13,19,23,45],[13,19,23,46],
 [13,19,23,47],[13,19,23,48],[13,19,23,49],
 [13,19,23,52],[13,19,23,53],[13,19,23,55],
 [13,19,23,56],[13,19,23,57],[13,19,23,58],
 [13,19,23,59],[13,19,23,60],[13,19,23,61],
 [13,19,23,62],[13,19,23,64],[13,19,23,65],
 [13,19,23,66],[13,19,23,67],[13,19,23,68],
 [13,19,23,69],[13,19,24,25],[13,19,24,26],
 [13,19,24,27],[13,19,24,34],[13,19,24,36],
 [13,19,24,39],[13,19,24,41],[13,19,24,43],
 [13,19,24,44],[13,19,24,45],[13,19,24,46],
 [13,19,24,47],[13,19,24,48],[13,19,24,49],
 [13,19,24,52],[13,19,24,53],[13,19,24,55],
 [13,19,24,57],[13,19,24,58],[13,19,24,59],
 [13,19,24,60],[13,19,24,61],[13,19,24,62],
 [13,19,24,63],[13,19,24,64],[13,19,24,65],
 [13,19,24,66],[13,19,24,67],[13,19,24,68],
 [13,19,24,69],[13,19,25,26],[13,19,25,27],
 [13,19,25,31],[13,19,25,34],[13,19,25,35],
 [13,19,25,39],[13,19,25,41],[13,19,25,43],
 [13,19,25,44],[13,19,25,45],[13,19,25,46],
 [13,19,25,47],[13,19,25,48],[13,19,25,49],
 [13,19,25,51],[13,19,25,53],[13,19,25,54],
 [13,19,25,55],[13,19,25,57],[13,19,25,58],
 [13,19,25,59],[13,19,25,60],[13,19,25,61],
 [13,19,25,62],[13,19,25,64],[13,19,25,65],
 [13,19,25,66],[13,19,25,67],[13,19,25,68],
 [13,19,25,69],[13,19,26,27],[13,19,26,31],
 [13,19,26,34],[13,19,26,35],[13,19,26,36],
 [13,19,26,39],[13,19,26,41],[13,19,26,43],
 [13,19,26,44],[13,19,26,45],[13,19,26,46],
 [13,19,26,47],[13,19,26,48],[13,19,26,49],
 [13,19,26,51],[13,19,26,52],[13,19,26,54],
 [13,19,26,55],[13,19,26,56],[13,19,26,58],
 [13,19,26,59],[13,19,26,60],[13,19,26,61],
 [13,19,26,62],[13,19,26,63],[13,19,26,64],
 [13,19,26,65],[13,19,26,66],[13,19,26,67],
 [13,19,26,68],[13,19,26,69],[13,19,27,31],
 [13,19,27,34],[13,19,27,35],[13,19,27,36],
 [13,19,27,39],[13,19,27,41],[13,19,27,43],
 [13,19,27,44],[13,19,27,45],[13,19,27,46],
 [13,19,27,47],[13,19,27,48],[13,19,27,49],
 [13,19,27,51],[13,19,27,52],[13,19,27,54],
 [13,19,27,55],[13,19,27,56],[13,19,27,58],
 [13,19,27,59],[13,19,27,60],[13,19,27,61],
 [13,19,27,62],[13,19,27,64],[13,19,27,65],
 [13,19,27,66],[13,19,27,67],[13,19,27,68],
 [13,19,27,69],[13,19,30,35],[13,19,30,41],
 [13,19,30,45],[13,19,30,47],[13,19,30,48],
 [13,19,30,49],[13,19,30,52],[13,19,30,53],
 [13,19,30,59],[13,19,30,60],[13,19,30,61],
 [13,19,30,62],[13,19,30,67],[13,19,31,36],
 [13,19,31,48],[13,19,31,63],[13,19,31,65],
 [13,19,31,67],[13,19,31,69],[13,19,34,36],
 [13,19,34,39],[13,19,34,41],[13,19,34,43],
 [13,19,34,44],[13,19,34,45],[13,19,34,46],
 [13,19,34,47],[13,19,34,48],[13,19,34,49],
 [13,19,34,52],[13,19,34,55],[13,19,34,56],
 [13,19,34,58],[13,19,34,59],[13,19,34,60],
 [13,19,34,61],[13,19,34,62],[13,19,34,63],
 [13,19,34,66],[13,19,34,67],[13,19,34,68],
 [13,19,34,69],[13,19,35,36],[13,19,35,41],
 [13,19,35,45],[13,19,35,47],[13,19,35,49],
 [13,19,35,52],[13,19,35,55],[13,19,35,57],
 [13,19,35,59],[13,19,35,60],[13,19,35,62],
 [13,19,35,63],[13,19,35,65],[13,19,35,66],
 [13,19,35,68],[13,19,35,69],[13,19,36,43],
 [13,19,36,45],[13,19,36,46],[13,19,36,48],
 [13,19,36,49],[13,19,36,51],[13,19,36,52],
 [13,19,36,54],[13,19,36,55],[13,19,36,57],
 [13,19,36,59],[13,19,36,60],[13,19,36,62],
 [13,19,36,66],[13,19,36,68],[13,19,36,69],
 [13,19,39,41],[13,19,39,43],[13,19,39,44],
 [13,19,39,45],[13,19,39,46],[13,19,39,47],
 [13,19,39,48],[13,19,39,49],[13,19,39,52],
 [13,19,39,55],[13,19,39,58],[13,19,39,59],
 [13,19,39,60],[13,19,39,61],[13,19,39,62],
 [13,19,39,63],[13,19,39,64],[13,19,39,65],
 [13,19,39,66],[13,19,39,67],[13,19,39,68],
 [13,19,39,69],[13,19,41,43],[13,19,41,44],
 [13,19,41,45],[13,19,41,46],[13,19,41,47],
 [13,19,41,48],[13,19,41,49],[13,19,41,53],
 [13,19,41,55],[13,19,41,58],[13,19,41,59],
 [13,19,41,60],[13,19,41,61],[13,19,41,62],
 [13,19,41,66],[13,19,41,67],[13,19,41,68],
 [13,19,41,69],[13,19,43,44],[13,19,43,45],
 [13,19,43,46],[13,19,43,47],[13,19,43,48],
 [13,19,43,49],[13,19,43,55],[13,19,43,56],
 [13,19,43,58],[13,19,43,59],[13,19,43,60],
 [13,19,43,61],[13,19,43,62],[13,19,43,64],
 [13,19,43,66],[13,19,43,67],[13,19,43,68],
 [13,19,43,69],[13,19,44,45],[13,19,44,46],
 [13,19,44,47],[13,19,44,48],[13,19,44,49],
 [13,19,44,51],[13,19,44,52],[13,19,44,53],
 [13,19,44,55],[13,19,44,57],[13,19,44,58],
 [13,19,44,59],[13,19,44,60],[13,19,44,61],
 [13,19,44,62],[13,19,44,64],[13,19,44,65],
 [13,19,44,66],[13,19,44,67],[13,19,44,68],
 [13,19,44,69],[13,19,45,46],[13,19,45,47],
 [13,19,45,48],[13,19,45,49],[13,19,45,53],
 [13,19,45,54],[13,19,45,55],[13,19,45,57],
 [13,19,45,58],[13,19,45,59],[13,19,45,60],
 [13,19,45,61],[13,19,45,62],[13,19,45,63],
 [13,19,45,65],[13,19,45,66],[13,19,45,67],
 [13,19,45,68],[13,19,45,69],[13,19,46,47],
 [13,19,46,48],[13,19,46,49],[13,19,46,52],
 [13,19,46,53],[13,19,46,55],[13,19,46,56],
 [13,19,46,57],[13,19,46,58],[13,19,46,59],
 [13,19,46,60],[13,19,46,61],[13,19,46,62],
 [13,19,46,63],[13,19,46,65],[13,19,46,66],
 [13,19,46,67],[13,19,46,68],[13,19,46,69],
 [13,19,47,48],[13,19,47,49],[13,19,47,51],
 [13,19,47,52],[13,19,47,53],[13,19,47,54],
 [13,19,47,55],[13,19,47,56],[13,19,47,57],
 [13,19,47,58],[13,19,47,59],[13,19,47,60],
 [13,19,47,61],[13,19,47,62],[13,19,47,65],
 [13,19,47,66],[13,19,47,67],[13,19,47,68],
 [13,19,47,69],[13,19,48,49],[13,19,48,51],
 [13,19,48,52],[13,19,48,53],[13,19,48,55],
 [13,19,48,56],[13,19,48,57],[13,19,48,58],
 [13,19,48,59],[13,19,48,60],[13,19,48,61],
 [13,19,48,62],[13,19,48,63],[13,19,48,64],
 [13,19,48,66],[13,19,48,67],[13,19,48,68],
 [13,19,48,69],[13,19,49,52],[13,19,49,53],
 [13,19,49,54],[13,19,49,55],[13,19,49,56],
 [13,19,49,57],[13,19,49,58],[13,19,49,59],
 [13,19,49,60],[13,19,49,61],[13,19,49,62],
 [13,19,49,63],[13,19,49,66],[13,19,49,67],
 [13,19,49,68],[13,19,49,69],[13,19,51,52],
 [13,19,51,53],[13,19,51,56],[13,19,51,58],
 [13,19,51,59],[13,19,51,60],[13,19,51,61],
 [13,19,51,65],[13,19,51,67],[13,19,51,68],
 [13,19,51,69],[13,19,52,54],[13,19,52,57],
 [13,19,52,61],[13,19,52,63],[13,19,52,65],
 [13,19,52,66],[13,19,52,69],[13,19,53,54],
 [13,19,53,56],[13,19,53,58],[13,19,53,60],
 [13,19,53,63],[13,19,53,64],[13,19,53,68],
 [13,19,54,56],[13,19,54,57],[13,19,54,59],
 [13,19,54,60],[13,19,54,62],[13,19,54,66],
 [13,19,54,67],[13,19,54,68],[13,19,54,69],
 [13,19,55,58],[13,19,55,59],[13,19,55,60],
 [13,19,55,61],[13,19,55,62],[13,19,55,66],
 [13,19,55,67],[13,19,55,68],[13,19,55,69],
 [13,19,56,59],[13,19,56,62],[13,19,56,66],
 [13,19,56,69],[13,19,57,58],[13,19,57,60],
 [13,19,57,67],[13,19,58,59],[13,19,58,60],
 [13,19,58,61],[13,19,58,62],[13,19,58,65],
 [13,19,58,66],[13,19,58,67],[13,19,58,68],
 [13,19,58,69],[13,19,59,60],[13,19,59,61],
 [13,19,59,62],[13,19,59,63],[13,19,59,65],
 [13,19,59,66],[13,19,59,67],[13,19,59,68],
 [13,19,59,69],[13,19,60,61],[13,19,60,62],
 [13,19,60,63],[13,19,60,65],[13,19,60,66],
 [13,19,60,67],[13,19,60,68],[13,19,60,69],
 [13,19,61,62],[13,19,61,63],[13,19,61,66],
 [13,19,61,67],[13,19,61,68],[13,19,61,69],
 [13,19,62,63],[13,19,62,65],[13,19,62,66],
 [13,19,62,67],[13,19,62,68],[13,19,62,69],
 [13,19,63,64],[13,19,63,65],[13,19,63,66],
 [13,19,63,67],[13,19,63,68],[13,19,63,69],
 [13,19,64,66],[13,19,64,67],[13,19,64,69],
 [13,19,66,67],[13,19,66,68],[13,19,66,69],
 [13,19,67,68],[13,19,67,69],[13,19,68,69],
 [13,20,21,22],[13,20,21,23],[13,20,21,24],
 [13,20,21,25],[13,20,21,26],[13,20,21,27],
 [13,20,21,34],[13,20,21,39],[13,20,21,41],
 [13,20,21,43],[13,20,21,44],[13,20,21,45],
 [13,20,21,46],[13,20,21,47],[13,20,21,48],
 [13,20,21,49],[13,20,21,55],[13,20,21,57],
 [13,20,21,58],[13,20,21,59],[13,20,21,60],
 [13,20,21,61],[13,20,21,62],[13,20,21,65],
 [13,20,21,66],[13,20,21,67],[13,20,21,68],
 [13,20,21,69],[13,20,22,23],[13,20,22,24],
 [13,20,22,25],[13,20,22,26],[13,20,22,27],
 [13,20,22,34],[13,20,22,39],[13,20,22,41],
 [13,20,22,43],[13,20,22,44],[13,20,22,45],
 [13,20,22,46],[13,20,22,47],[13,20,22,48],
 [13,20,22,49],[13,20,22,55],[13,20,22,56],
 [13,20,22,57],[13,20,22,58],[13,20,22,59],
 [13,20,22,60],[13,20,22,61],[13,20,22,62],
 [13,20,22,63],[13,20,22,64],[13,20,22,65],
 [13,20,22,66],[13,20,22,67],[13,20,22,68],
 [13,20,22,69],[13,20,23,24],[13,20,23,25],
 [13,20,23,26],[13,20,23,27],[13,20,23,34],
 [13,20,23,36],[13,20,23,39],[13,20,23,41],
 [13,20,23,43],[13,20,23,44],[13,20,23,45],
 [13,20,23,46],[13,20,23,47],[13,20,23,48],
 [13,20,23,49],[13,20,23,52],[13,20,23,55],
 [13,20,23,56],[13,20,23,57],[13,20,23,58],
 [13,20,23,59],[13,20,23,60],[13,20,23,61],
 [13,20,23,62],[13,20,23,64],[13,20,23,65],
 [13,20,23,66],[13,20,23,67],[13,20,23,68],
 [13,20,23,69],[13,20,24,25],[13,20,24,26],
 [13,20,24,27],[13,20,24,34],[13,20,24,36],
 [13,20,24,39],[13,20,24,41],[13,20,24,43],
 [13,20,24,44],[13,20,24,45],[13,20,24,46],
 [13,20,24,47],[13,20,24,48],[13,20,24,49],
 [13,20,24,52],[13,20,24,55],[13,20,24,57],
 [13,20,24,58],[13,20,24,59],[13,20,24,60],
 [13,20,24,61],[13,20,24,62],[13,20,24,63],
 [13,20,24,64],[13,20,24,65],[13,20,24,66],
 [13,20,24,67],[13,20,24,68],[13,20,24,69],
 [13,20,25,26],[13,20,25,27],[13,20,25,34],
 [13,20,25,39],[13,20,25,41],[13,20,25,43],
 [13,20,25,44],[13,20,25,45],[13,20,25,46],
 [13,20,25,47],[13,20,25,48],[13,20,25,49],
 [13,20,25,55],[13,20,25,58],[13,20,25,59],
 [13,20,25,60],[13,20,25,61],[13,20,25,62],
 [13,20,25,66],[13,20,25,67],[13,20,25,68],
 [13,20,25,69],[13,20,26,27],[13,20,26,34],
 [13,20,26,36],[13,20,26,39],[13,20,26,41],
 [13,20,26,43],[13,20,26,44],[13,20,26,45],
 [13,20,26,46],[13,20,26,47],[13,20,26,48],
 [13,20,26,49],[13,20,26,52],[13,20,26,55],
 [13,20,26,56],[13,20,26,57],[13,20,26,58],
 [13,20,26,59],[13,20,26,60],[13,20,26,61],
 [13,20,26,62],[13,20,26,63],[13,20,26,64],
 [13,20,26,65],[13,20,26,66],[13,20,26,67],
 [13,20,26,68],[13,20,26,69],[13,20,27,34],
 [13,20,27,36],[13,20,27,39],[13,20,27,41],
 [13,20,27,43],[13,20,27,44],[13,20,27,45],
 [13,20,27,46],[13,20,27,47],[13,20,27,48],
 [13,20,27,49],[13,20,27,52],[13,20,27,55],
 [13,20,27,58],[13,20,27,59],[13,20,27,60],
 [13,20,27,61],[13,20,27,62],[13,20,27,64],
 [13,20,27,66],[13,20,27,67],[13,20,27,68],
 [13,20,27,69],[13,20,34,36],[13,20,34,39],
 [13,20,34,41],[13,20,34,43],[13,20,34,44],
 [13,20,34,45],[13,20,34,46],[13,20,34,47],
 [13,20,34,48],[13,20,34,49],[13,20,34,52],
 [13,20,34,55],[13,20,34,56],[13,20,34,58],
 [13,20,34,59],[13,20,34,60],[13,20,34,61],
 [13,20,34,62],[13,20,34,66],[13,20,34,67],
 [13,20,34,68],[13,20,34,69],[13,20,36,43],
 [13,20,36,45],[13,20,36,46],[13,20,36,49],
 [13,20,36,52],[13,20,36,55],[13,20,36,60],
 [13,20,36,62],[13,20,36,64],[13,20,36,65],
 [13,20,36,66],[13,20,36,68],[13,20,36,69],
 [13,20,39,41],[13,20,39,43],[13,20,39,44],
 [13,20,39,45],[13,20,39,46],[13,20,39,47],
 [13,20,39,48],[13,20,39,49],[13,20,39,52],
 [13,20,39,55],[13,20,39,58],[13,20,39,59],
 [13,20,39,60],[13,20,39,61],[13,20,39,62],
 [13,20,39,64],[13,20,39,65],[13,20,39,66],
 [13,20,39,67],[13,20,39,68],[13,20,39,69],
 [13,20,41,43],[13,20,41,44],[13,20,41,45],
 [13,20,41,46],[13,20,41,47],[13,20,41,48],
 [13,20,41,49],[13,20,41,55],[13,20,41,56],
 [13,20,41,57],[13,20,41,58],[13,20,41,59],
 [13,20,41,60],[13,20,41,61],[13,20,41,62],
 [13,20,41,66],[13,20,41,67],[13,20,41,68],
 [13,20,41,69],[13,20,43,44],[13,20,43,45],
 [13,20,43,46],[13,20,43,47],[13,20,43,48],
 [13,20,43,49],[13,20,43,55],[13,20,43,56],
 [13,20,43,58],[13,20,43,59],[13,20,43,60],
 [13,20,43,61],[13,20,43,62],[13,20,43,64],
 [13,20,43,66],[13,20,43,67],[13,20,43,68],
 [13,20,43,69],[13,20,44,45],[13,20,44,46],
 [13,20,44,47],[13,20,44,48],[13,20,44,49],
 [13,20,44,52],[13,20,44,55],[13,20,44,57],
 [13,20,44,58],[13,20,44,59],[13,20,44,60],
 [13,20,44,61],[13,20,44,62],[13,20,44,64],
 [13,20,44,65],[13,20,44,66],[13,20,44,67],
 [13,20,44,68],[13,20,44,69],[13,20,45,46],
 [13,20,45,47],[13,20,45,48],[13,20,45,49],
 [13,20,45,55],[13,20,45,57],[13,20,45,58],
 [13,20,45,59],[13,20,45,60],[13,20,45,61],
 [13,20,45,62],[13,20,45,63],[13,20,45,65],
 [13,20,45,66],[13,20,45,67],[13,20,45,68],
 [13,20,45,69],[13,20,46,47],[13,20,46,48],
 [13,20,46,49],[13,20,46,52],[13,20,46,55],
 [13,20,46,56],[13,20,46,57],[13,20,46,58],
 [13,20,46,59],[13,20,46,60],[13,20,46,61],
 [13,20,46,62],[13,20,46,63],[13,20,46,65],
 [13,20,46,66],[13,20,46,67],[13,20,46,68],
 [13,20,46,69],[13,20,47,48],[13,20,47,49],
 [13,20,47,55],[13,20,47,56],[13,20,47,57],
 [13,20,47,58],[13,20,47,59],[13,20,47,60],
 [13,20,47,61],[13,20,47,62],[13,20,47,65],
 [13,20,47,66],[13,20,47,67],[13,20,47,68],
 [13,20,47,69],[13,20,48,49],[13,20,48,52],
 [13,20,48,55],[13,20,48,58],[13,20,48,59],
 [13,20,48,60],[13,20,48,61],[13,20,48,62],
 [13,20,48,63],[13,20,48,64],[13,20,48,66],
 [13,20,48,67],[13,20,48,68],[13,20,48,69],
 [13,20,49,55],[13,20,49,56],[13,20,49,57],
 [13,20,49,58],[13,20,49,59],[13,20,49,60],
 [13,20,49,61],[13,20,49,62],[13,20,49,63],
 [13,20,49,64],[13,20,49,65],[13,20,49,66],
 [13,20,49,67],[13,20,49,68],[13,20,49,69],
 [13,20,52,57],[13,20,52,61],[13,20,52,65],
 [13,20,52,66],[13,20,52,69],[13,20,55,58],
 [13,20,55,59],[13,20,55,60],[13,20,55,61],
 [13,20,55,62],[13,20,55,66],[13,20,55,67],
 [13,20,55,68],[13,20,55,69],[13,20,56,57],
 [13,20,56,59],[13,20,56,62],[13,20,56,66],
 [13,20,56,68],[13,20,56,69],[13,20,57,58],
 [13,20,57,60],[13,20,57,67],[13,20,57,68],
 [13,20,58,59],[13,20,58,60],[13,20,58,61],
 [13,20,58,62],[13,20,58,65],[13,20,58,66],
 [13,20,58,67],[13,20,58,68],[13,20,58,69],
 [13,20,59,60],[13,20,59,61],[13,20,59,62],
 [13,20,59,63],[13,20,59,65],[13,20,59,66],
 [13,20,59,67],[13,20,59,68],[13,20,59,69],
 [13,20,60,61],[13,20,60,62],[13,20,60,65],
 [13,20,60,66],[13,20,60,67],[13,20,60,68],
 [13,20,60,69],[13,20,61,62],[13,20,61,63],
 [13,20,61,64],[13,20,61,65],[13,20,61,66],
 [13,20,61,67],[13,20,61,68],[13,20,61,69],
 [13,20,62,63],[13,20,62,65],[13,20,62,66],
 [13,20,62,67],[13,20,62,68],[13,20,62,69],
 [13,20,63,64],[13,20,63,65],[13,20,63,66],
 [13,20,63,67],[13,20,63,68],[13,20,64,65],
 [13,20,64,66],[13,20,64,67],[13,20,64,69],
 [13,20,66,67],[13,20,66,68],[13,20,66,69],
 [13,20,67,68],[13,20,67,69],[13,20,68,69],
 [13,21,22,23],[13,21,22,24],[13,21,22,25],
 [13,21,22,26],[13,21,22,27],[13,21,22,34],
 [13,21,22,39],[13,21,22,41],[13,21,22,43],
 [13,21,22,44],[13,21,22,45],[13,21,22,46],
 [13,21,22,47],[13,21,22,48],[13,21,22,49],
 [13,21,22,50],[13,21,22,55],[13,21,22,56],
 [13,21,22,58],[13,21,22,59],[13,21,22,60],
 [13,21,22,61],[13,21,22,62],[13,21,22,64],
 [13,21,22,66],[13,21,22,67],[13,21,22,68],
 [13,21,22,69],[13,21,23,24],[13,21,23,25],
 [13,21,23,26],[13,21,23,27],[13,21,23,30],
 [13,21,23,31],[13,21,23,34],[13,21,23,37],
 [13,21,23,39],[13,21,23,41],[13,21,23,43],
 [13,21,23,44],[13,21,23,45],[13,21,23,46],
 [13,21,23,47],[13,21,23,48],[13,21,23,49],
 [13,21,23,50],[13,21,23,51],[13,21,23,53],
 [13,21,23,55],[13,21,23,56],[13,21,23,57],
 [13,21,23,58],[13,21,23,59],[13,21,23,60],
 [13,21,23,61],[13,21,23,62],[13,21,23,64],
 [13,21,23,65],[13,21,23,66],[13,21,23,67],
 [13,21,23,68],[13,21,23,69],[13,21,24,25],
 [13,21,24,26],[13,21,24,27],[13,21,24,34],
 [13,21,24,37],[13,21,24,39],[13,21,24,41],
 [13,21,24,43],[13,21,24,44],[13,21,24,45],
 [13,21,24,46],[13,21,24,47],[13,21,24,48],
 [13,21,24,49],[13,21,24,53],[13,21,24,55],
 [13,21,24,57],[13,21,24,58],[13,21,24,59],
 [13,21,24,60],[13,21,24,61],[13,21,24,62],
 [13,21,24,65],[13,21,24,66],[13,21,24,67],
 [13,21,24,68],[13,21,24,69],[13,21,25,26],
 [13,21,25,27],[13,21,25,31],[13,21,25,34],
 [13,21,25,37],[13,21,25,39],[13,21,25,41],
 [13,21,25,43],[13,21,25,44],[13,21,25,45],
 [13,21,25,46],[13,21,25,47],[13,21,25,48],
 [13,21,25,49],[13,21,25,50],[13,21,25,51],
 [13,21,25,53],[13,21,25,55],[13,21,25,57],
 [13,21,25,58],[13,21,25,59],[13,21,25,60],
 [13,21,25,61],[13,21,25,62],[13,21,25,64],
 [13,21,25,65],[13,21,25,66],[13,21,25,67],
 [13,21,25,68],[13,21,25,69],[13,21,26,27],
 [13,21,26,30],[13,21,26,31],[13,21,26,34],
 [13,21,26,39],[13,21,26,41],[13,21,26,43],
 [13,21,26,44],[13,21,26,45],[13,21,26,46],
 [13,21,26,47],[13,21,26,48],[13,21,26,49],
 [13,21,26,50],[13,21,26,51],[13,21,26,53],
 [13,21,26,55],[13,21,26,57],[13,21,26,58],
 [13,21,26,59],[13,21,26,60],[13,21,26,61],
 [13,21,26,62],[13,21,26,64],[13,21,26,66],
 [13,21,26,67],[13,21,26,68],[13,21,26,69],
 [13,21,27,30],[13,21,27,34],[13,21,27,39],
 [13,21,27,41],[13,21,27,43],[13,21,27,44],
 [13,21,27,45],[13,21,27,46],[13,21,27,47],
 [13,21,27,48],[13,21,27,49],[13,21,27,51],
 [13,21,27,53],[13,21,27,55],[13,21,27,58],
 [13,21,27,59],[13,21,27,60],[13,21,27,61],
 [13,21,27,62],[13,21,27,65],[13,21,27,66],
 [13,21,27,67],[13,21,27,68],[13,21,27,69],
 [13,21,30,47],[13,21,30,48],[13,21,30,53],
 [13,21,30,58],[13,21,30,59],[13,21,30,60],
 [13,21,30,62],[13,21,30,67],[13,21,30,68],
 [13,21,31,37],[13,21,31,48],[13,21,31,49],
 [13,21,31,65],[13,21,31,67],[13,21,31,69],
 [13,21,34,39],[13,21,34,41],[13,21,34,43],
 [13,21,34,44],[13,21,34,45],[13,21,34,46],
 [13,21,34,47],[13,21,34,48],[13,21,34,49],
 [13,21,34,55],[13,21,34,56],[13,21,34,58],
 [13,21,34,59],[13,21,34,60],[13,21,34,61],
 [13,21,34,62],[13,21,34,66],[13,21,34,67],
 [13,21,34,68],[13,21,34,69],[13,21,37,39],
 [13,21,37,43],[13,21,37,44],[13,21,37,46],
 [13,21,37,47],[13,21,37,50],[13,21,37,56],
 [13,21,37,59],[13,21,37,60],[13,21,37,61],
 [13,21,37,62],[13,21,37,67],[13,21,37,68],
 [13,21,39,41],[13,21,39,43],[13,21,39,44],
 [13,21,39,45],[13,21,39,46],[13,21,39,47],
 [13,21,39,48],[13,21,39,49],[13,21,39,55],
 [13,21,39,58],[13,21,39,59],[13,21,39,60],
 [13,21,39,61],[13,21,39,62],[13,21,39,64],
 [13,21,39,65],[13,21,39,66],[13,21,39,67],
 [13,21,39,68],[13,21,39,69],[13,21,41,43],
 [13,21,41,44],[13,21,41,45],[13,21,41,46],
 [13,21,41,47],[13,21,41,48],[13,21,41,49],
 [13,21,41,50],[13,21,41,53],[13,21,41,55],
 [13,21,41,57],[13,21,41,58],[13,21,41,59],
 [13,21,41,60],[13,21,41,61],[13,21,41,62],
 [13,21,41,66],[13,21,41,67],[13,21,41,68],
 [13,21,41,69],[13,21,43,44],[13,21,43,45],
 [13,21,43,46],[13,21,43,47],[13,21,43,48],
 [13,21,43,49],[13,21,43,55],[13,21,43,56],
 [13,21,43,57],[13,21,43,58],[13,21,43,59],
 [13,21,43,60],[13,21,43,61],[13,21,43,62],
 [13,21,43,64],[13,21,43,65],[13,21,43,66],
 [13,21,43,67],[13,21,43,68],[13,21,43,69],
 [13,21,44,45],[13,21,44,46],[13,21,44,47],
 [13,21,44,48],[13,21,44,49],[13,21,44,51],
 [13,21,44,53],[13,21,44,55],[13,21,44,57],
 [13,21,44,58],[13,21,44,59],[13,21,44,60],
 [13,21,44,61],[13,21,44,62],[13,21,44,64],
 [13,21,44,65],[13,21,44,66],[13,21,44,67],
 [13,21,44,68],[13,21,44,69],[13,21,45,46],
 [13,21,45,47],[13,21,45,48],[13,21,45,49],
 [13,21,45,50],[13,21,45,51],[13,21,45,53],
 [13,21,45,55],[13,21,45,57],[13,21,45,58],
 [13,21,45,59],[13,21,45,60],[13,21,45,61],
 [13,21,45,62],[13,21,45,65],[13,21,45,66],
 [13,21,45,67],[13,21,45,68],[13,21,45,69],
 [13,21,46,47],[13,21,46,48],[13,21,46,49],
 [13,21,46,53],[13,21,46,55],[13,21,46,56],
 [13,21,46,57],[13,21,46,58],[13,21,46,59],
 [13,21,46,60],[13,21,46,61],[13,21,46,62],
 [13,21,46,65],[13,21,46,66],[13,21,46,67],
 [13,21,46,68],[13,21,46,69],[13,21,47,48],
 [13,21,47,49],[13,21,47,50],[13,21,47,51],
 [13,21,47,53],[13,21,47,55],[13,21,47,57],
 [13,21,47,58],[13,21,47,59],[13,21,47,60],
 [13,21,47,61],[13,21,47,62],[13,21,47,65],
 [13,21,47,66],[13,21,47,67],[13,21,47,68],
 [13,21,47,69],[13,21,48,49],[13,21,48,50],
 [13,21,48,51],[13,21,48,53],[13,21,48,55],
 [13,21,48,56],[13,21,48,57],[13,21,48,58],
 [13,21,48,59],[13,21,48,60],[13,21,48,61],
 [13,21,48,62],[13,21,48,64],[13,21,48,66],
 [13,21,48,67],[13,21,48,68],[13,21,48,69],
 [13,21,49,50],[13,21,49,55],[13,21,49,56],
 [13,21,49,58],[13,21,49,59],[13,21,49,60],
 [13,21,49,61],[13,21,49,62],[13,21,49,64],
 [13,21,49,66],[13,21,49,67],[13,21,49,68],
 [13,21,49,69],[13,21,50,51],[13,21,50,53],
 [13,21,50,59],[13,21,50,61],[13,21,50,62],
 [13,21,50,65],[13,21,50,66],[13,21,50,67],
 [13,21,50,68],[13,21,50,69],[13,21,51,53],
 [13,21,51,56],[13,21,51,59],[13,21,51,60],
 [13,21,51,62],[13,21,51,67],[13,21,51,68],
 [13,21,53,56],[13,21,53,58],[13,21,53,60],
 [13,21,53,64],[13,21,53,68],[13,21,55,58],
 [13,21,55,59],[13,21,55,60],[13,21,55,61],
 [13,21,55,62],[13,21,55,66],[13,21,55,67],
 [13,21,55,68],[13,21,55,69],[13,21,56,57],
 [13,21,56,59],[13,21,56,62],[13,21,56,66],
 [13,21,56,68],[13,21,56,69],[13,21,57,58],
 [13,21,57,60],[13,21,57,67],[13,21,57,68],
 [13,21,58,59],[13,21,58,60],[13,21,58,61],
 [13,21,58,62],[13,21,58,65],[13,21,58,66],
 [13,21,58,67],[13,21,58,68],[13,21,58,69],
 [13,21,59,60],[13,21,59,61],[13,21,59,62],
 [13,21,59,65],[13,21,59,66],[13,21,59,67],
 [13,21,59,68],[13,21,59,69],[13,21,60,61],
 [13,21,60,62],[13,21,60,65],[13,21,60,66],
 [13,21,60,67],[13,21,60,68],[13,21,60,69],
 [13,21,61,62],[13,21,61,64],[13,21,61,65],
 [13,21,61,66],[13,21,61,67],[13,21,61,68],
 [13,21,61,69],[13,21,62,65],[13,21,62,66],
 [13,21,62,67],[13,21,62,68],[13,21,62,69],
 [13,21,64,65],[13,21,64,66],[13,21,64,67],
 [13,21,64,69],[13,21,66,67],[13,21,66,68],
 [13,21,66,69],[13,21,67,68],[13,21,67,69],
 [13,21,68,69],[13,22,23,24],[13,22,23,25],
 [13,22,23,26],[13,22,23,27],[13,22,23,31],
 [13,22,23,34],[13,22,23,39],[13,22,23,41],
 [13,22,23,43],[13,22,23,44],[13,22,23,45],
 [13,22,23,46],[13,22,23,47],[13,22,23,48],
 [13,22,23,49],[13,22,23,55],[13,22,23,56],
 [13,22,23,57],[13,22,23,58],[13,22,23,59],
 [13,22,23,60],[13,22,23,61],[13,22,23,62],
 [13,22,23,65],[13,22,23,66],[13,22,23,67],
 [13,22,23,68],[13,22,23,69],[13,22,24,25],
 [13,22,24,26],[13,22,24,27],[13,22,24,34],
 [13,22,24,39],[13,22,24,41],[13,22,24,43],
 [13,22,24,44],[13,22,24,45],[13,22,24,46],
 [13,22,24,47],[13,22,24,48],[13,22,24,49],
 [13,22,24,55],[13,22,24,57],[13,22,24,58],
 [13,22,24,59],[13,22,24,60],[13,22,24,61],
 [13,22,24,62],[13,22,24,63],[13,22,24,64],
 [13,22,24,65],[13,22,24,66],[13,22,24,67],
 [13,22,24,68],[13,22,24,69],[13,22,25,26],
 [13,22,25,27],[13,22,25,34],[13,22,25,39],
 [13,22,25,41],[13,22,25,43],[13,22,25,44],
 [13,22,25,45],[13,22,25,46],[13,22,25,47],
 [13,22,25,48],[13,22,25,49],[13,22,25,54],
 [13,22,25,55],[13,22,25,57],[13,22,25,58],
 [13,22,25,59],[13,22,25,60],[13,22,25,61],
 [13,22,25,62],[13,22,25,64],[13,22,25,66],
 [13,22,25,67],[13,22,25,68],[13,22,25,69],
 [13,22,26,27],[13,22,26,30],[13,22,26,31],
 [13,22,26,34],[13,22,26,39],[13,22,26,41],
 [13,22,26,43],[13,22,26,44],[13,22,26,45],
 [13,22,26,46],[13,22,26,47],[13,22,26,48],
 [13,22,26,49],[13,22,26,54],[13,22,26,55],
 [13,22,26,56],[13,22,26,57],[13,22,26,58],
 [13,22,26,59],[13,22,26,60],[13,22,26,61],
 [13,22,26,62],[13,22,26,63],[13,22,26,64],
 [13,22,26,65],[13,22,26,66],[13,22,26,67],
 [13,22,26,68],[13,22,26,69],[13,22,27,31],
 [13,22,27,34],[13,22,27,39],[13,22,27,41],
 [13,22,27,43],[13,22,27,44],[13,22,27,45],
 [13,22,27,46],[13,22,27,47],[13,22,27,48],
 [13,22,27,49],[13,22,27,54],[13,22,27,55],
 [13,22,27,56],[13,22,27,58],[13,22,27,59],
 [13,22,27,60],[13,22,27,61],[13,22,27,62],
 [13,22,27,65],[13,22,27,66],[13,22,27,67],
 [13,22,27,68],[13,22,27,69],[13,22,30,41],
 [13,22,30,44],[13,22,30,45],[13,22,30,47],
 [13,22,30,49],[13,22,30,59],[13,22,30,61],
 [13,22,30,62],[13,22,30,68],[13,22,31,48],
 [13,22,31,49],[13,22,31,63],[13,22,31,65],
 [13,22,31,69],[13,22,34,39],[13,22,34,41],
 [13,22,34,43],[13,22,34,44],[13,22,34,45],
 [13,22,34,46],[13,22,34,47],[13,22,34,48],
 [13,22,34,49],[13,22,34,55],[13,22,34,58],
 [13,22,34,59],[13,22,34,60],[13,22,34,61],
 [13,22,34,62],[13,22,34,66],[13,22,34,67],
 [13,22,34,68],[13,22,34,69],[13,22,39,41],
 [13,22,39,43],[13,22,39,44],[13,22,39,45],
 [13,22,39,46],[13,22,39,47],[13,22,39,48],
 [13,22,39,49],[13,22,39,55],[13,22,39,58],
 [13,22,39,59],[13,22,39,60],[13,22,39,61],
 [13,22,39,62],[13,22,39,63],[13,22,39,64],
 [13,22,39,65],[13,22,39,66],[13,22,39,67],
 [13,22,39,68],[13,22,39,69],[13,22,41,43],
 [13,22,41,44],[13,22,41,45],[13,22,41,46],
 [13,22,41,47],[13,22,41,48],[13,22,41,49],
 [13,22,41,50],[13,22,41,54],[13,22,41,55],
 [13,22,41,56],[13,22,41,57],[13,22,41,58],
 [13,22,41,59],[13,22,41,60],[13,22,41,61],
 [13,22,41,62],[13,22,41,66],[13,22,41,67],
 [13,22,41,68],[13,22,41,69],[13,22,43,44],
 [13,22,43,45],[13,22,43,46],[13,22,43,47],
 [13,22,43,48],[13,22,43,49],[13,22,43,55],
 [13,22,43,56],[13,22,43,57],[13,22,43,58],
 [13,22,43,59],[13,22,43,60],[13,22,43,61],
 [13,22,43,62],[13,22,43,64],[13,22,43,65],
 [13,22,43,66],[13,22,43,67],[13,22,43,68],
 [13,22,43,69],[13,22,44,45],[13,22,44,46],
 [13,22,44,47],[13,22,44,48],[13,22,44,49],
 [13,22,44,50],[13,22,44,54],[13,22,44,55],
 [13,22,44,57],[13,22,44,58],[13,22,44,59],
 [13,22,44,60],[13,22,44,61],[13,22,44,62],
 [13,22,44,64],[13,22,44,65],[13,22,44,66],
 [13,22,44,67],[13,22,44,68],[13,22,44,69],
 [13,22,45,46],[13,22,45,47],[13,22,45,48],
 [13,22,45,49],[13,22,45,54],[13,22,45,55],
 [13,22,45,57],[13,22,45,58],[13,22,45,59],
 [13,22,45,60],[13,22,45,61],[13,22,45,62],
 [13,22,45,63],[13,22,45,65],[13,22,45,66],
 [13,22,45,67],[13,22,45,68],[13,22,45,69],
 [13,22,46,47],[13,22,46,48],[13,22,46,49],
 [13,22,46,55],[13,22,46,57],[13,22,46,58],
 [13,22,46,59],[13,22,46,60],[13,22,46,61],
 [13,22,46,62],[13,22,46,65],[13,22,46,66],
 [13,22,46,67],[13,22,46,68],[13,22,46,69],
 [13,22,47,48],[13,22,47,49],[13,22,47,50],
 [13,22,47,54],[13,22,47,55],[13,22,47,56],
 [13,22,47,57],[13,22,47,58],[13,22,47,59],
 [13,22,47,60],[13,22,47,61],[13,22,47,62],
 [13,22,47,65],[13,22,47,66],[13,22,47,67],
 [13,22,47,68],[13,22,47,69],[13,22,48,49],
 [13,22,48,50],[13,22,48,55],[13,22,48,56],
 [13,22,48,58],[13,22,48,59],[13,22,48,60],
 [13,22,48,61],[13,22,48,62],[13,22,48,63],
 [13,22,48,64],[13,22,48,66],[13,22,48,67],
 [13,22,48,68],[13,22,48,69],[13,22,49,50],
 [13,22,49,54],[13,22,49,55],[13,22,49,56],
 [13,22,49,57],[13,22,49,58],[13,22,49,59],
 [13,22,49,60],[13,22,49,61],[13,22,49,62],
 [13,22,49,63],[13,22,49,64],[13,22,49,65],
 [13,22,49,66],[13,22,49,67],[13,22,49,68],
 [13,22,49,69],[13,22,50,58],[13,22,50,60],
 [13,22,50,62],[13,22,50,65],[13,22,50,66],
 [13,22,50,67],[13,22,50,68],[13,22,50,69],
 [13,22,54,56],[13,22,54,57],[13,22,54,58],
 [13,22,54,59],[13,22,54,61],[13,22,54,62],
 [13,22,54,67],[13,22,54,68],[13,22,55,58],
 [13,22,55,59],[13,22,55,60],[13,22,55,61],
 [13,22,55,62],[13,22,55,66],[13,22,55,67],
 [13,22,55,68],[13,22,55,69],[13,22,56,57],
 [13,22,56,59],[13,22,56,62],[13,22,56,66],
 [13,22,56,68],[13,22,56,69],[13,22,57,58],
 [13,22,57,60],[13,22,57,67],[13,22,57,68],
 [13,22,58,59],[13,22,58,60],[13,22,58,61],
 [13,22,58,62],[13,22,58,63],[13,22,58,65],
 [13,22,58,66],[13,22,58,67],[13,22,58,68],
 [13,22,58,69],[13,22,59,60],[13,22,59,61],
 [13,22,59,62],[13,22,59,63],[13,22,59,65],
 [13,22,59,66],[13,22,59,67],[13,22,59,68],
 [13,22,59,69],[13,22,60,61],[13,22,60,62],
 [13,22,60,63],[13,22,60,65],[13,22,60,66],
 [13,22,60,67],[13,22,60,68],[13,22,60,69],
 [13,22,61,62],[13,22,61,63],[13,22,61,64],
 [13,22,61,65],[13,22,61,66],[13,22,61,67],
 [13,22,61,68],[13,22,61,69],[13,22,62,63],
 [13,22,62,66],[13,22,62,67],[13,22,62,68],
 [13,22,62,69],[13,22,63,64],[13,22,63,65],
 [13,22,63,68],[13,22,63,69],[13,22,64,65],
 [13,22,64,66],[13,22,64,67],[13,22,66,67],
 [13,22,66,68],[13,22,66,69],[13,22,67,68],
 [13,22,67,69],[13,22,68,69],[13,23,24,25],
 [13,23,24,26],[13,23,24,27],[13,23,24,34],
 [13,23,24,36],[13,23,24,37],[13,23,24,39],
 [13,23,24,41],[13,23,24,43],[13,23,24,44],
 [13,23,24,45],[13,23,24,46],[13,23,24,47],
 [13,23,24,48],[13,23,24,49],[13,23,24,52],
 [13,23,24,53],[13,23,24,55],[13,23,24,57],
 [13,23,24,58],[13,23,24,59],[13,23,24,60],
 [13,23,24,61],[13,23,24,62],[13,23,24,65],
 [13,23,24,66],[13,23,24,67],[13,23,24,68],
 [13,23,24,69],[13,23,25,26],[13,23,25,27],
 [13,23,25,31],[13,23,25,34],[13,23,25,35],
 [13,23,25,37],[13,23,25,39],[13,23,25,41],
 [13,23,25,43],[13,23,25,44],[13,23,25,45],
 [13,23,25,46],[13,23,25,47],[13,23,25,48],
 [13,23,25,49],[13,23,25,50],[13,23,25,51],
 [13,23,25,52],[13,23,25,53],[13,23,25,55],
 [13,23,25,57],[13,23,25,58],[13,23,25,59],
 [13,23,25,60],[13,23,25,61],[13,23,25,62],
 [13,23,25,64],[13,23,25,65],[13,23,25,66],
 [13,23,25,67],[13,23,25,68],[13,23,25,69],
 [13,23,26,27],[13,23,26,30],[13,23,26,31],
 [13,23,26,34],[13,23,26,35],[13,23,26,36],
 [13,23,26,39],[13,23,26,41],[13,23,26,43],
 [13,23,26,44],[13,23,26,45],[13,23,26,46],
 [13,23,26,47],[13,23,26,48],[13,23,26,49],
 [13,23,26,50],[13,23,26,51],[13,23,26,52],
 [13,23,26,53],[13,23,26,55],[13,23,26,56],
 [13,23,26,57],[13,23,26,58],[13,23,26,59],
 [13,23,26,60],[13,23,26,61],[13,23,26,62],
 [13,23,26,64],[13,23,26,66],[13,23,26,67],
 [13,23,26,68],[13,23,26,69],[13,23,27,30],
 [13,23,27,31],[13,23,27,34],[13,23,27,35],
 [13,23,27,36],[13,23,27,39],[13,23,27,41],
 [13,23,27,43],[13,23,27,44],[13,23,27,45],
 [13,23,27,46],[13,23,27,47],[13,23,27,48],
 [13,23,27,49],[13,23,27,52],[13,23,27,53],
 [13,23,27,55],[13,23,27,56],[13,23,27,58],
 [13,23,27,59],[13,23,27,60],[13,23,27,61],
 [13,23,27,62],[13,23,27,64],[13,23,27,65],
 [13,23,27,66],[13,23,27,67],[13,23,27,68],
 [13,23,27,69],[13,23,30,35],[13,23,30,41],
 [13,23,30,44],[13,23,30,45],[13,23,30,48],
 [13,23,30,49],[13,23,30,53],[13,23,30,58],
 [13,23,30,59],[13,23,30,61],[13,23,30,62],
 [13,23,30,67],[13,23,30,68],[13,23,31,36],
 [13,23,31,37],[13,23,31,48],[13,23,31,49],
 [13,23,31,65],[13,23,31,66],[13,23,31,67],
 [13,23,31,69],[13,23,34,36],[13,23,34,39],
 [13,23,34,41],[13,23,34,43],[13,23,34,44],
 [13,23,34,45],[13,23,34,46],[13,23,34,47],
 [13,23,34,48],[13,23,34,49],[13,23,34,52],
 [13,23,34,55],[13,23,34,56],[13,23,34,58],
 [13,23,34,59],[13,23,34,60],[13,23,34,61],
 [13,23,34,62],[13,23,34,66],[13,23,34,67],
 [13,23,34,68],[13,23,34,69],[13,23,35,36],
 [13,23,35,37],[13,23,35,41],[13,23,35,45],
 [13,23,35,47],[13,23,35,48],[13,23,35,49],
 [13,23,35,52],[13,23,35,55],[13,23,35,57],
 [13,23,35,59],[13,23,35,60],[13,23,35,62],
 [13,23,35,65],[13,23,35,66],[13,23,35,68],
 [13,23,35,69],[13,23,36,37],[13,23,36,43],
 [13,23,36,46],[13,23,36,48],[13,23,36,49],
 [13,23,36,50],[13,23,36,51],[13,23,36,52],
 [13,23,36,55],[13,23,36,57],[13,23,36,59],
 [13,23,36,60],[13,23,36,62],[13,23,36,64],
 [13,23,36,65],[13,23,36,66],[13,23,36,68],
 [13,23,36,69],[13,23,37,43],[13,23,37,44],
 [13,23,37,46],[13,23,37,47],[13,23,37,52],
 [13,23,37,56],[13,23,37,59],[13,23,37,60],
 [13,23,37,61],[13,23,37,62],[13,23,37,64],
 [13,23,37,67],[13,23,37,68],[13,23,39,41],
 [13,23,39,43],[13,23,39,44],[13,23,39,45],
 [13,23,39,46],[13,23,39,47],[13,23,39,48],
 [13,23,39,49],[13,23,39,52],[13,23,39,55],
 [13,23,39,58],[13,23,39,59],[13,23,39,60],
 [13,23,39,61],[13,23,39,62],[13,23,39,64],
 [13,23,39,65],[13,23,39,66],[13,23,39,67],
 [13,23,39,68],[13,23,39,69],[13,23,41,43],
 [13,23,41,44],[13,23,41,45],[13,23,41,46],
 [13,23,41,47],[13,23,41,48],[13,23,41,49],
 [13,23,41,53],[13,23,41,55],[13,23,41,56],
 [13,23,41,58],[13,23,41,59],[13,23,41,60],
 [13,23,41,61],[13,23,41,62],[13,23,41,66],
 [13,23,41,67],[13,23,41,68],[13,23,41,69],
 [13,23,43,44],[13,23,43,45],[13,23,43,46],
 [13,23,43,47],[13,23,43,48],[13,23,43,49],
 [13,23,43,55],[13,23,43,56],[13,23,43,57],
 [13,23,43,58],[13,23,43,59],[13,23,43,60],
 [13,23,43,61],[13,23,43,62],[13,23,43,64],
 [13,23,43,65],[13,23,43,66],[13,23,43,67],
 [13,23,43,68],[13,23,43,69],[13,23,44,45],
 [13,23,44,46],[13,23,44,47],[13,23,44,48],
 [13,23,44,49],[13,23,44,50],[13,23,44,51],
 [13,23,44,52],[13,23,44,53],[13,23,44,55],
 [13,23,44,57],[13,23,44,58],[13,23,44,59],
 [13,23,44,60],[13,23,44,61],[13,23,44,62],
 [13,23,44,65],[13,23,44,66],[13,23,44,67],
 [13,23,44,68],[13,23,44,69],[13,23,45,46],
 [13,23,45,47],[13,23,45,48],[13,23,45,49],
 [13,23,45,50],[13,23,45,51],[13,23,45,53],
 [13,23,45,55],[13,23,45,57],[13,23,45,58],
 [13,23,45,59],[13,23,45,60],[13,23,45,61],
 [13,23,45,62],[13,23,45,65],[13,23,45,66],
 [13,23,45,67],[13,23,45,68],[13,23,45,69],
 [13,23,46,47],[13,23,46,48],[13,23,46,49],
 [13,23,46,52],[13,23,46,53],[13,23,46,55],
 [13,23,46,56],[13,23,46,57],[13,23,46,58],
 [13,23,46,59],[13,23,46,60],[13,23,46,61],
 [13,23,46,62],[13,23,46,65],[13,23,46,66],
 [13,23,46,67],[13,23,46,68],[13,23,46,69],
 [13,23,47,48],[13,23,47,49],[13,23,47,50],
 [13,23,47,51],[13,23,47,52],[13,23,47,53],
 [13,23,47,55],[13,23,47,57],[13,23,47,58],
 [13,23,47,59],[13,23,47,60],[13,23,47,61],
 [13,23,47,62],[13,23,47,65],[13,23,47,66],
 [13,23,47,67],[13,23,47,68],[13,23,47,69],
 [13,23,48,49],[13,23,48,50],[13,23,48,51],
 [13,23,48,52],[13,23,48,53],[13,23,48,55],
 [13,23,48,56],[13,23,48,57],[13,23,48,58],
 [13,23,48,59],[13,23,48,60],[13,23,48,61],
 [13,23,48,62],[13,23,48,64],[13,23,48,66],
 [13,23,48,67],[13,23,48,68],[13,23,48,69],
 [13,23,49,52],[13,23,49,53],[13,23,49,55],
 [13,23,49,56],[13,23,49,58],[13,23,49,59],
 [13,23,49,60],[13,23,49,61],[13,23,49,62],
 [13,23,49,64],[13,23,49,65],[13,23,49,66],
 [13,23,49,67],[13,23,49,68],[13,23,49,69],
 [13,23,50,51],[13,23,50,52],[13,23,50,53],
 [13,23,50,55],[13,23,50,56],[13,23,50,58],
 [13,23,50,59],[13,23,50,60],[13,23,50,61],
 [13,23,50,62],[13,23,50,64],[13,23,50,65],
 [13,23,50,67],[13,23,50,68],[13,23,50,69],
 [13,23,51,52],[13,23,51,53],[13,23,51,55],
 [13,23,51,56],[13,23,51,58],[13,23,51,59],
 [13,23,51,60],[13,23,51,61],[13,23,51,62],
 [13,23,51,64],[13,23,51,65],[13,23,51,67],
 [13,23,51,68],[13,23,51,69],[13,23,52,57],
 [13,23,52,61],[13,23,52,65],[13,23,52,66],
 [13,23,52,69],[13,23,53,56],[13,23,53,58],
 [13,23,53,60],[13,23,53,64],[13,23,53,68],
 [13,23,55,58],[13,23,55,59],[13,23,55,60],
 [13,23,55,61],[13,23,55,62],[13,23,55,66],
 [13,23,55,67],[13,23,55,68],[13,23,55,69],
 [13,23,56,57],[13,23,56,62],[13,23,56,66],
 [13,23,56,68],[13,23,56,69],[13,23,57,58],
 [13,23,57,60],[13,23,57,67],[13,23,57,68],
 [13,23,58,59],[13,23,58,60],[13,23,58,61],
 [13,23,58,62],[13,23,58,65],[13,23,58,66],
 [13,23,58,67],[13,23,58,68],[13,23,58,69],
 [13,23,59,60],[13,23,59,61],[13,23,59,62],
 [13,23,59,66],[13,23,59,67],[13,23,59,68],
 [13,23,59,69],[13,23,60,61],[13,23,60,62],
 [13,23,60,65],[13,23,60,66],[13,23,60,67],
 [13,23,60,68],[13,23,60,69],[13,23,61,62],
 [13,23,61,64],[13,23,61,65],[13,23,61,66],
 [13,23,61,67],[13,23,61,68],[13,23,61,69],
 [13,23,62,65],[13,23,62,66],[13,23,62,67],
 [13,23,62,68],[13,23,62,69],[13,23,64,65],
 [13,23,64,66],[13,23,64,67],[13,23,64,69],
 [13,23,66,67],[13,23,66,68],[13,23,66,69],
 [13,23,67,68],[13,23,67,69],[13,23,68,69],
 [13,24,25,26],[13,24,25,27],[13,24,25,34],
 [13,24,25,37],[13,24,25,39],[13,24,25,41],
 [13,24,25,43],[13,24,25,44],[13,24,25,45],
 [13,24,25,46],[13,24,25,47],[13,24,25,48],
 [13,24,25,49],[13,24,25,53],[13,24,25,55],
 [13,24,25,57],[13,24,25,58],[13,24,25,59],
 [13,24,25,60],[13,24,25,61],[13,24,25,62],
 [13,24,25,65],[13,24,25,66],[13,24,25,67],
 [13,24,25,68],[13,24,25,69],[13,24,26,27],
 [13,24,26,34],[13,24,26,36],[13,24,26,39],
 [13,24,26,41],[13,24,26,43],[13,24,26,44],
 [13,24,26,45],[13,24,26,46],[13,24,26,47],
 [13,24,26,48],[13,24,26,49],[13,24,26,52],
 [13,24,26,55],[13,24,26,57],[13,24,26,58],
 [13,24,26,59],[13,24,26,60],[13,24,26,61],
 [13,24,26,62],[13,24,26,63],[13,24,26,64],
 [13,24,26,65],[13,24,26,66],[13,24,26,67],
 [13,24,26,68],[13,24,26,69],[13,24,27,34],
 [13,24,27,36],[13,24,27,39],[13,24,27,41],
 [13,24,27,43],[13,24,27,44],[13,24,27,45],
 [13,24,27,46],[13,24,27,47],[13,24,27,48],
 [13,24,27,49],[13,24,27,52],[13,24,27,53],
 [13,24,27,55],[13,24,27,58],[13,24,27,59],
 [13,24,27,60],[13,24,27,61],[13,24,27,62],
 [13,24,27,65],[13,24,27,66],[13,24,27,67],
 [13,24,27,68],[13,24,27,69],[13,24,34,36],
 [13,24,34,39],[13,24,34,41],[13,24,34,43],
 [13,24,34,44],[13,24,34,45],[13,24,34,46],
 [13,24,34,47],[13,24,34,48],[13,24,34,49],
 [13,24,34,52],[13,24,34,55],[13,24,34,58],
 [13,24,34,59],[13,24,34,60],[13,24,34,61],
 [13,24,34,62],[13,24,34,66],[13,24,34,67],
 [13,24,34,68],[13,24,34,69],[13,24,36,37],
 [13,24,36,43],[13,24,36,45],[13,24,36,46],
 [13,24,36,48],[13,24,36,49],[13,24,36,52],
 [13,24,36,55],[13,24,36,57],[13,24,36,59],
 [13,24,36,60],[13,24,36,62],[13,24,36,64],
 [13,24,36,65],[13,24,36,66],[13,24,36,68],
 [13,24,36,69],[13,24,37,39],[13,24,37,43],
 [13,24,37,44],[13,24,37,46],[13,24,37,47],
 [13,24,37,52],[13,24,37,59],[13,24,37,60],
 [13,24,37,61],[13,24,37,62],[13,24,37,64],
 [13,24,37,67],[13,24,37,68],[13,24,39,41],
 [13,24,39,43],[13,24,39,44],[13,24,39,45],
 [13,24,39,46],[13,24,39,47],[13,24,39,48],
 [13,24,39,49],[13,24,39,52],[13,24,39,55],
 [13,24,39,58],[13,24,39,59],[13,24,39,60],
 [13,24,39,61],[13,24,39,62],[13,24,39,63],
 [13,24,39,64],[13,24,39,65],[13,24,39,66],
 [13,24,39,67],[13,24,39,68],[13,24,39,69],
 [13,24,41,43],[13,24,41,44],[13,24,41,45],
 [13,24,41,46],[13,24,41,47],[13,24,41,48],
 [13,24,41,49],[13,24,41,53],[13,24,41,55],
 [13,24,41,57],[13,24,41,58],[13,24,41,59],
 [13,24,41,60],[13,24,41,61],[13,24,41,62],
 [13,24,41,66],[13,24,41,67],[13,24,41,68],
 [13,24,41,69],[13,24,43,44],[13,24,43,45],
 [13,24,43,46],[13,24,43,47],[13,24,43,48],
 [13,24,43,49],[13,24,43,55],[13,24,43,57],
 [13,24,43,58],[13,24,43,59],[13,24,43,60],
 [13,24,43,61],[13,24,43,62],[13,24,43,65],
 [13,24,43,66],[13,24,43,67],[13,24,43,68],
 [13,24,43,69],[13,24,44,45],[13,24,44,46],
 [13,24,44,47],[13,24,44,48],[13,24,44,49],
 [13,24,44,52],[13,24,44,53],[13,24,44,55],
 [13,24,44,57],[13,24,44,58],[13,24,44,59],
 [13,24,44,60],[13,24,44,61],[13,24,44,62],
 [13,24,44,64],[13,24,44,65],[13,24,44,66],
 [13,24,44,67],[13,24,44,68],[13,24,44,69],
 [13,24,45,46],[13,24,45,47],[13,24,45,48],
 [13,24,45,49],[13,24,45,53],[13,24,45,55],
 [13,24,45,57],[13,24,45,58],[13,24,45,59],
 [13,24,45,60],[13,24,45,61],[13,24,45,62],
 [13,24,45,65],[13,24,45,66],[13,24,45,67],
 [13,24,45,68],[13,24,45,69],[13,24,46,47],
 [13,24,46,48],[13,24,46,49],[13,24,46,52],
 [13,24,46,53],[13,24,46,55],[13,24,46,57],
 [13,24,46,58],[13,24,46,59],[13,24,46,60],
 [13,24,46,61],[13,24,46,62],[13,24,46,65],
 [13,24,46,66],[13,24,46,67],[13,24,46,68],
 [13,24,46,69],[13,24,47,48],[13,24,47,49],
 [13,24,47,52],[13,24,47,53],[13,24,47,55],
 [13,24,47,57],[13,24,47,58],[13,24,47,59],
 [13,24,47,60],[13,24,47,61],[13,24,47,62],
 [13,24,47,65],[13,24,47,66],[13,24,47,67],
 [13,24,47,68],[13,24,47,69],[13,24,48,49],
 [13,24,48,52],[13,24,48,53],[13,24,48,55],
 [13,24,48,57],[13,24,48,58],[13,24,48,59],
 [13,24,48,60],[13,24,48,61],[13,24,48,62],
 [13,24,48,63],[13,24,48,64],[13,24,48,66],
 [13,24,48,67],[13,24,48,68],[13,24,48,69],
 [13,24,49,52],[13,24,49,53],[13,24,49,55],
 [13,24,49,57],[13,24,49,58],[13,24,49,59],
 [13,24,49,60],[13,24,49,61],[13,24,49,62],
 [13,24,49,63],[13,24,49,64],[13,24,49,65],
 [13,24,49,66],[13,24,49,67],[13,24,49,68],
 [13,24,49,69],[13,24,52,57],[13,24,52,61],
 [13,24,52,65],[13,24,52,66],[13,24,52,69],
 [13,24,53,58],[13,24,53,60],[13,24,53,63],
 [13,24,53,64],[13,24,53,68],[13,24,55,58],
 [13,24,55,59],[13,24,55,60],[13,24,55,61],
 [13,24,55,62],[13,24,55,66],[13,24,55,67],
 [13,24,55,68],[13,24,55,69],[13,24,57,60],
 [13,24,57,67],[13,24,57,68],[13,24,58,59],
 [13,24,58,60],[13,24,58,61],[13,24,58,62],
 [13,24,58,65],[13,24,58,66],[13,24,58,67],
 [13,24,58,68],[13,24,58,69],[13,24,59,60],
 [13,24,59,61],[13,24,59,62],[13,24,59,63],
 [13,24,59,65],[13,24,59,66],[13,24,59,67],
 [13,24,59,68],[13,24,59,69],[13,24,60,61],
 [13,24,60,62],[13,24,60,65],[13,24,60,66],
 [13,24,60,67],[13,24,60,68],[13,24,60,69],
 [13,24,61,62],[13,24,61,63],[13,24,61,64],
 [13,24,61,65],[13,24,61,66],[13,24,61,67],
 [13,24,61,68],[13,24,61,69],[13,24,62,65],
 [13,24,62,66],[13,24,62,67],[13,24,62,68],
 [13,24,62,69],[13,24,63,64],[13,24,63,65],
 [13,24,63,66],[13,24,63,67],[13,24,63,68],
 [13,24,63,69],[13,24,64,65],[13,24,64,66],
 [13,24,64,67],[13,24,64,69],[13,24,66,67],
 [13,24,66,68],[13,24,66,69],[13,24,67,68],
 [13,24,67,69],[13,24,68,69],[13,25,26,27],
 [13,25,26,31],[13,25,26,34],[13,25,26,35],
 [13,25,26,39],[13,25,26,41],[13,25,26,43],
 [13,25,26,44],[13,25,26,45],[13,25,26,46],
 [13,25,26,47],[13,25,26,48],[13,25,26,49],
 [13,25,26,50],[13,25,26,51],[13,25,26,52],
 [13,25,26,53],[13,25,26,54],[13,25,26,55],
 [13,25,26,57],[13,25,26,58],[13,25,26,59],
 [13,25,26,60],[13,25,26,61],[13,25,26,62],
 [13,25,26,64],[13,25,26,66],[13,25,26,67],
 [13,25,26,68],[13,25,26,69],[13,25,27,31],
 [13,25,27,34],[13,25,27,35],[13,25,27,39],
 [13,25,27,41],[13,25,27,43],[13,25,27,44],
 [13,25,27,45],[13,25,27,46],[13,25,27,47],
 [13,25,27,48],[13,25,27,49],[13,25,27,51],
 [13,25,27,53],[13,25,27,54],[13,25,27,55],
 [13,25,27,58],[13,25,27,59],[13,25,27,60],
 [13,25,27,61],[13,25,27,62],[13,25,27,64],
 [13,25,27,65],[13,25,27,66],[13,25,27,67],
 [13,25,27,68],[13,25,27,69],[13,25,31,37],
 [13,25,31,48],[13,25,31,49],[13,25,31,65],
 [13,25,31,66],[13,25,31,67],[13,25,31,69],
 [13,25,34,39],[13,25,34,41],[13,25,34,43],
 [13,25,34,44],[13,25,34,45],[13,25,34,46],
 [13,25,34,47],[13,25,34,48],[13,25,34,49],
 [13,25,34,52],[13,25,34,55],[13,25,34,58],
 [13,25,34,59],[13,25,34,60],[13,25,34,61],
 [13,25,34,62],[13,25,34,66],[13,25,34,67],
 [13,25,34,68],[13,25,34,69],[13,25,35,37],
 [13,25,35,41],[13,25,35,45],[13,25,35,47],
 [13,25,35,48],[13,25,35,49],[13,25,35,52],
 [13,25,35,55],[13,25,35,57],[13,25,35,59],
 [13,25,35,60],[13,25,35,62],[13,25,35,65],
 [13,25,35,66],[13,25,35,68],[13,25,35,69],
 [13,25,37,39],[13,25,37,43],[13,25,37,44],
 [13,25,37,46],[13,25,37,47],[13,25,37,50],
 [13,25,37,52],[13,25,37,54],[13,25,37,59],
 [13,25,37,60],[13,25,37,61],[13,25,37,62],
 [13,25,37,64],[13,25,37,67],[13,25,37,68],
 [13,25,39,41],[13,25,39,43],[13,25,39,44],
 [13,25,39,45],[13,25,39,46],[13,25,39,47],
 [13,25,39,48],[13,25,39,49],[13,25,39,55],
 [13,25,39,58],[13,25,39,59],[13,25,39,60],
 [13,25,39,61],[13,25,39,62],[13,25,39,64],
 [13,25,39,65],[13,25,39,66],[13,25,39,67],
 [13,25,39,68],[13,25,39,69],[13,25,41,43],
 [13,25,41,44],[13,25,41,45],[13,25,41,46],
 [13,25,41,47],[13,25,41,48],[13,25,41,49],
 [13,25,41,53],[13,25,41,54],[13,25,41,55],
 [13,25,41,58],[13,25,41,59],[13,25,41,60],
 [13,25,41,61],[13,25,41,62],[13,25,41,66],
 [13,25,41,67],[13,25,41,68],[13,25,41,69],
 [13,25,43,44],[13,25,43,45],[13,25,43,46],
 [13,25,43,47],[13,25,43,48],[13,25,43,49],
 [13,25,43,55],[13,25,43,57],[13,25,43,58],
 [13,25,43,59],[13,25,43,60],[13,25,43,61],
 [13,25,43,62],[13,25,43,64],[13,25,43,65],
 [13,25,43,66],[13,25,43,67],[13,25,43,68],
 [13,25,43,69],[13,25,44,45],[13,25,44,46],
 [13,25,44,47],[13,25,44,48],[13,25,44,49],
 [13,25,44,50],[13,25,44,51],[13,25,44,52],
 [13,25,44,54],[13,25,44,55],[13,25,44,57],
 [13,25,44,58],[13,25,44,59],[13,25,44,60],
 [13,25,44,61],[13,25,44,62],[13,25,44,64],
 [13,25,44,66],[13,25,44,67],[13,25,44,68],
 [13,25,44,69],[13,25,45,46],[13,25,45,47],
 [13,25,45,48],[13,25,45,49],[13,25,45,50],
 [13,25,45,51],[13,25,45,53],[13,25,45,54],
 [13,25,45,55],[13,25,45,57],[13,25,45,58],
 [13,25,45,59],[13,25,45,60],[13,25,45,61],
 [13,25,45,62],[13,25,45,65],[13,25,45,66],
 [13,25,45,67],[13,25,45,68],[13,25,45,69],
 [13,25,46,47],[13,25,46,48],[13,25,46,49],
 [13,25,46,52],[13,25,46,53],[13,25,46,55],
 [13,25,46,57],[13,25,46,58],[13,25,46,59],
 [13,25,46,60],[13,25,46,61],[13,25,46,62],
 [13,25,46,65],[13,25,46,66],[13,25,46,67],
 [13,25,46,68],[13,25,46,69],[13,25,47,48],
 [13,25,47,49],[13,25,47,50],[13,25,47,51],
 [13,25,47,52],[13,25,47,53],[13,25,47,55],
 [13,25,47,57],[13,25,47,58],[13,25,47,59],
 [13,25,47,60],[13,25,47,61],[13,25,47,62],
 [13,25,47,65],[13,25,47,66],[13,25,47,67],
 [13,25,47,68],[13,25,47,69],[13,25,48,49],
 [13,25,48,50],[13,25,48,51],[13,25,48,52],
 [13,25,48,53],[13,25,48,55],[13,25,48,57],
 [13,25,48,58],[13,25,48,59],[13,25,48,60],
 [13,25,48,61],[13,25,48,62],[13,25,48,64],
 [13,25,48,66],[13,25,48,67],[13,25,48,68],
 [13,25,48,69],[13,25,49,50],[13,25,49,52],
 [13,25,49,53],[13,25,49,54],[13,25,49,55],
 [13,25,49,57],[13,25,49,58],[13,25,49,59],
 [13,25,49,60],[13,25,49,61],[13,25,49,62],
 [13,25,49,64],[13,25,49,65],[13,25,49,66],
 [13,25,49,67],[13,25,49,68],[13,25,49,69],
 [13,25,50,51],[13,25,50,52],[13,25,50,53],
 [13,25,50,61],[13,25,50,62],[13,25,50,65],
 [13,25,50,66],[13,25,50,67],[13,25,50,69],
 [13,25,51,52],[13,25,51,53],[13,25,51,55],
 [13,25,51,57],[13,25,51,58],[13,25,51,59],
 [13,25,51,60],[13,25,51,61],[13,25,51,62],
 [13,25,51,64],[13,25,51,65],[13,25,51,67],
 [13,25,51,68],[13,25,51,69],[13,25,52,54],
 [13,25,52,61],[13,25,52,65],[13,25,52,66],
 [13,25,52,69],[13,25,53,54],[13,25,53,58],
 [13,25,53,60],[13,25,53,64],[13,25,53,68],
 [13,25,54,57],[13,25,54,58],[13,25,54,60],
 [13,25,54,61],[13,25,54,62],[13,25,54,66],
 [13,25,54,67],[13,25,54,68],[13,25,54,69],
 [13,25,55,58],[13,25,55,59],[13,25,55,60],
 [13,25,55,61],[13,25,55,62],[13,25,55,66],
 [13,25,55,67],[13,25,55,68],[13,25,55,69],
 [13,25,57,58],[13,25,57,60],[13,25,57,67],
 [13,25,58,59],[13,25,58,60],[13,25,58,61],
 [13,25,58,62],[13,25,58,65],[13,25,58,66],
 [13,25,58,67],[13,25,58,68],[13,25,58,69],
 [13,25,59,60],[13,25,59,61],[13,25,59,62],
 [13,25,59,65],[13,25,59,66],[13,25,59,67],
 [13,25,59,68],[13,25,59,69],[13,25,60,61],
 [13,25,60,62],[13,25,60,65],[13,25,60,66],
 [13,25,60,67],[13,25,60,68],[13,25,60,69],
 [13,25,61,62],[13,25,61,64],[13,25,61,65],
 [13,25,61,66],[13,25,61,67],[13,25,61,68],
 [13,25,61,69],[13,25,62,65],[13,25,62,66],
 [13,25,62,67],[13,25,62,68],[13,25,62,69],
 [13,25,64,65],[13,25,64,66],[13,25,64,67],
 [13,25,64,69],[13,25,66,67],[13,25,66,68],
 [13,25,66,69],[13,25,67,68],[13,25,67,69],
 [13,25,68,69],[13,26,27,31],[13,26,27,34],
 [13,26,27,35],[13,26,27,36],[13,26,27,39],
 [13,26,27,41],[13,26,27,43],[13,26,27,44],
 [13,26,27,45],[13,26,27,46],[13,26,27,47],
 [13,26,27,48],[13,26,27,49],[13,26,27,51],
 [13,26,27,52],[13,26,27,54],[13,26,27,55],
 [13,26,27,56],[13,26,27,58],[13,26,27,59],
 [13,26,27,60],[13,26,27,61],[13,26,27,62],
 [13,26,27,64],[13,26,27,66],[13,26,27,67],
 [13,26,27,68],[13,26,27,69],[13,26,30,35],
 [13,26,30,41],[13,26,30,44],[13,26,30,45],
 [13,26,30,47],[13,26,30,48],[13,26,30,49],
 [13,26,30,53],[13,26,30,59],[13,26,30,60],
 [13,26,30,61],[13,26,30,62],[13,26,30,68],
 [13,26,31,36],[13,26,31,48],[13,26,31,49],
 [13,26,31,63],[13,26,31,65],[13,26,31,66],
 [13,26,31,67],[13,26,31,69],[13,26,34,36],
 [13,26,34,39],[13,26,34,41],[13,26,34,43],
 [13,26,34,44],[13,26,34,45],[13,26,34,46],
 [13,26,34,47],[13,26,34,48],[13,26,34,49],
 [13,26,34,52],[13,26,34,55],[13,26,34,56],
 [13,26,34,58],[13,26,34,59],[13,26,34,60],
 [13,26,34,61],[13,26,34,62],[13,26,34,66],
 [13,26,34,67],[13,26,34,68],[13,26,34,69],
 [13,26,35,36],[13,26,35,41],[13,26,35,45],
 [13,26,35,47],[13,26,35,48],[13,26,35,49],
 [13,26,35,52],[13,26,35,55],[13,26,35,57],
 [13,26,35,59],[13,26,35,60],[13,26,35,62],
 [13,26,35,63],[13,26,35,65],[13,26,35,66],
 [13,26,35,68],[13,26,35,69],[13,26,36,43],
 [13,26,36,45],[13,26,36,46],[13,26,36,48],
 [13,26,36,49],[13,26,36,50],[13,26,36,51],
 [13,26,36,52],[13,26,36,54],[13,26,36,55],
 [13,26,36,57],[13,26,36,59],[13,26,36,60],
 [13,26,36,62],[13,26,36,64],[13,26,36,65],
 [13,26,36,66],[13,26,36,68],[13,26,36,69],
 [13,26,39,41],[13,26,39,43],[13,26,39,44],
 [13,26,39,45],[13,26,39,46],[13,26,39,47],
 [13,26,39,48],[13,26,39,49],[13,26,39,55],
 [13,26,39,58],[13,26,39,59],[13,26,39,60],
 [13,26,39,61],[13,26,39,62],[13,26,39,63],
 [13,26,39,64],[13,26,39,65],[13,26,39,66],
 [13,26,39,67],[13,26,39,68],[13,26,39,69],
 [13,26,41,43],[13,26,41,44],[13,26,41,45],
 [13,26,41,46],[13,26,41,47],[13,26,41,48],
 [13,26,41,49],[13,26,41,50],[13,26,41,53],
 [13,26,41,54],[13,26,41,55],[13,26,41,56],
 [13,26,41,57],[13,26,41,58],[13,26,41,59],
 [13,26,41,60],[13,26,41,61],[13,26,41,62],
 [13,26,41,66],[13,26,41,67],[13,26,41,68],
 [13,26,41,69],[13,26,43,44],[13,26,43,45],
 [13,26,43,46],[13,26,43,47],[13,26,43,48],
 [13,26,43,49],[13,26,43,55],[13,26,43,56],
 [13,26,43,58],[13,26,43,59],[13,26,43,60],
 [13,26,43,61],[13,26,43,62],[13,26,43,64],
 [13,26,43,66],[13,26,43,67],[13,26,43,68],
 [13,26,43,69],[13,26,44,45],[13,26,44,46],
 [13,26,44,47],[13,26,44,48],[13,26,44,49],
 [13,26,44,50],[13,26,44,51],[13,26,44,52],
 [13,26,44,53],[13,26,44,54],[13,26,44,55],
 [13,26,44,57],[13,26,44,58],[13,26,44,59],
 [13,26,44,60],[13,26,44,61],[13,26,44,62],
 [13,26,44,64],[13,26,44,65],[13,26,44,66],
 [13,26,44,67],[13,26,44,68],[13,26,44,69],
 [13,26,45,46],[13,26,45,47],[13,26,45,48],
 [13,26,45,49],[13,26,45,50],[13,26,45,51],
 [13,26,45,53],[13,26,45,55],[13,26,45,57],
 [13,26,45,58],[13,26,45,59],[13,26,45,60],
 [13,26,45,61],[13,26,45,62],[13,26,45,66],
 [13,26,45,67],[13,26,45,68],[13,26,45,69],
 [13,26,46,47],[13,26,46,48],[13,26,46,49],
 [13,26,46,52],[13,26,46,53],[13,26,46,55],
 [13,26,46,56],[13,26,46,57],[13,26,46,58],
 [13,26,46,59],[13,26,46,60],[13,26,46,61],
 [13,26,46,62],[13,26,46,63],[13,26,46,65],
 [13,26,46,66],[13,26,46,67],[13,26,46,68],
 [13,26,46,69],[13,26,47,48],[13,26,47,49],
 [13,26,47,50],[13,26,47,51],[13,26,47,52],
 [13,26,47,53],[13,26,47,54],[13,26,47,55],
 [13,26,47,56],[13,26,47,57],[13,26,47,58],
 [13,26,47,59],[13,26,47,60],[13,26,47,61],
 [13,26,47,62],[13,26,47,65],[13,26,47,66],
 [13,26,47,67],[13,26,47,68],[13,26,47,69],
 [13,26,48,49],[13,26,48,50],[13,26,48,51],
 [13,26,48,52],[13,26,48,53],[13,26,48,55],
 [13,26,48,56],[13,26,48,57],[13,26,48,58],
 [13,26,48,59],[13,26,48,60],[13,26,48,61],
 [13,26,48,62],[13,26,48,64],[13,26,48,66],
 [13,26,48,67],[13,26,48,68],[13,26,48,69],
 [13,26,49,50],[13,26,49,52],[13,26,49,53],
 [13,26,49,54],[13,26,49,55],[13,26,49,56],
 [13,26,49,57],[13,26,49,58],[13,26,49,59],
 [13,26,49,60],[13,26,49,61],[13,26,49,62],
 [13,26,49,63],[13,26,49,64],[13,26,49,65],
 [13,26,49,66],[13,26,49,67],[13,26,49,68],
 [13,26,49,69],[13,26,50,51],[13,26,50,52],
 [13,26,50,53],[13,26,50,56],[13,26,50,58],
 [13,26,50,60],[13,26,50,62],[13,26,50,64],
 [13,26,50,67],[13,26,50,68],[13,26,51,52],
 [13,26,51,53],[13,26,51,56],[13,26,51,57],
 [13,26,51,58],[13,26,51,59],[13,26,51,60],
 [13,26,51,61],[13,26,51,62],[13,26,51,63],
 [13,26,51,64],[13,26,51,65],[13,26,51,67],
 [13,26,51,68],[13,26,51,69],[13,26,52,54],
 [13,26,52,57],[13,26,52,61],[13,26,52,63],
 [13,26,52,65],[13,26,52,66],[13,26,52,69],
 [13,26,53,54],[13,26,53,56],[13,26,53,58],
 [13,26,53,60],[13,26,53,64],[13,26,53,68],
 [13,26,54,56],[13,26,54,57],[13,26,54,58],
 [13,26,54,59],[13,26,54,60],[13,26,54,61],
 [13,26,54,62],[13,26,54,66],[13,26,54,67],
 [13,26,54,68],[13,26,54,69],[13,26,55,58],
 [13,26,55,59],[13,26,55,60],[13,26,55,61],
 [13,26,55,62],[13,26,55,66],[13,26,55,67],
 [13,26,55,68],[13,26,55,69],[13,26,56,57],
 [13,26,56,59],[13,26,56,62],[13,26,56,66],
 [13,26,56,68],[13,26,56,69],[13,26,57,58],
 [13,26,57,60],[13,26,57,67],[13,26,57,68],
 [13,26,58,59],[13,26,58,60],[13,26,58,61],
 [13,26,58,62],[13,26,58,63],[13,26,58,65],
 [13,26,58,66],[13,26,58,67],[13,26,58,68],
 [13,26,58,69],[13,26,59,60],[13,26,59,61],
 [13,26,59,62],[13,26,59,63],[13,26,59,65],
 [13,26,59,66],[13,26,59,67],[13,26,59,68],
 [13,26,59,69],[13,26,60,61],[13,26,60,62],
 [13,26,60,63],[13,26,60,65],[13,26,60,66],
 [13,26,60,67],[13,26,60,68],[13,26,60,69],
 [13,26,61,62],[13,26,61,63],[13,26,61,64],
 [13,26,61,65],[13,26,61,66],[13,26,61,67],
 [13,26,61,68],[13,26,61,69],[13,26,62,63],
 [13,26,62,65],[13,26,62,66],[13,26,62,67],
 [13,26,62,68],[13,26,62,69],[13,26,63,64],
 [13,26,63,65],[13,26,63,68],[13,26,64,65],
 [13,26,64,66],[13,26,64,67],[13,26,64,69],
 [13,26,66,67],[13,26,66,68],[13,26,66,69],
 [13,26,67,68],[13,26,67,69],[13,26,68,69],
 [13,27,30,35],[13,27,30,45],[13,27,30,47],
 [13,27,30,48],[13,27,30,49],[13,27,30,53],
 [13,27,30,60],[13,27,30,61],[13,27,30,62],
 [13,27,31,36],[13,27,31,48],[13,27,31,49],
 [13,27,31,65],[13,27,31,66],[13,27,31,67],
 [13,27,31,69],[13,27,34,36],[13,27,34,39],
 [13,27,34,41],[13,27,34,43],[13,27,34,44],
 [13,27,34,45],[13,27,34,46],[13,27,34,47],
 [13,27,34,48],[13,27,34,49],[13,27,34,52],
 [13,27,34,55],[13,27,34,56],[13,27,34,58],
 [13,27,34,59],[13,27,34,60],[13,27,34,61],
 [13,27,34,62],[13,27,34,66],[13,27,34,67],
 [13,27,34,68],[13,27,34,69],[13,27,35,36],
 [13,27,35,41],[13,27,35,45],[13,27,35,47],
 [13,27,35,48],[13,27,35,49],[13,27,35,52],
 [13,27,35,55],[13,27,35,59],[13,27,35,60],
 [13,27,35,62],[13,27,35,65],[13,27,35,66],
 [13,27,35,68],[13,27,35,69],[13,27,36,43],
 [13,27,36,45],[13,27,36,46],[13,27,36,48],
 [13,27,36,49],[13,27,36,51],[13,27,36,52],
 [13,27,36,54],[13,27,36,55],[13,27,36,59],
 [13,27,36,60],[13,27,36,62],[13,27,36,64],
 [13,27,36,65],[13,27,36,66],[13,27,36,68],
 [13,27,36,69],[13,27,39,41],[13,27,39,43],
 [13,27,39,44],[13,27,39,45],[13,27,39,46],
 [13,27,39,47],[13,27,39,48],[13,27,39,49],
 [13,27,39,52],[13,27,39,55],[13,27,39,58],
 [13,27,39,59],[13,27,39,60],[13,27,39,61],
 [13,27,39,62],[13,27,39,64],[13,27,39,65],
 [13,27,39,66],[13,27,39,67],[13,27,39,68],
 [13,27,39,69],[13,27,41,43],[13,27,41,44],
 [13,27,41,45],[13,27,41,46],[13,27,41,47],
 [13,27,41,48],[13,27,41,49],[13,27,41,53],
 [13,27,41,54],[13,27,41,55],[13,27,41,58],
 [13,27,41,59],[13,27,41,60],[13,27,41,61],
 [13,27,41,62],[13,27,41,66],[13,27,41,67],
 [13,27,41,68],[13,27,41,69],[13,27,43,44],
 [13,27,43,45],[13,27,43,46],[13,27,43,47],
 [13,27,43,48],[13,27,43,49],[13,27,43,55],
 [13,27,43,56],[13,27,43,58],[13,27,43,59],
 [13,27,43,60],[13,27,43,61],[13,27,43,62],
 [13,27,43,64],[13,27,43,66],[13,27,43,67],
 [13,27,43,68],[13,27,43,69],[13,27,44,45],
 [13,27,44,46],[13,27,44,47],[13,27,44,48],
 [13,27,44,49],[13,27,44,52],[13,27,44,54],
 [13,27,44,55],[13,27,44,58],[13,27,44,59],
 [13,27,44,60],[13,27,44,61],[13,27,44,62],
 [13,27,44,64],[13,27,44,66],[13,27,44,67],
 [13,27,44,68],[13,27,44,69],[13,27,45,46],
 [13,27,45,47],[13,27,45,48],[13,27,45,49],
 [13,27,45,51],[13,27,45,53],[13,27,45,54],
 [13,27,45,55],[13,27,45,58],[13,27,45,59],
 [13,27,45,60],[13,27,45,61],[13,27,45,62],
 [13,27,45,65],[13,27,45,66],[13,27,45,67],
 [13,27,45,68],[13,27,45,69],[13,27,46,47],
 [13,27,46,48],[13,27,46,49],[13,27,46,52],
 [13,27,46,53],[13,27,46,55],[13,27,46,56],
 [13,27,46,58],[13,27,46,59],[13,27,46,60],
 [13,27,46,61],[13,27,46,62],[13,27,46,65],
 [13,27,46,66],[13,27,46,67],[13,27,46,68],
 [13,27,46,69],[13,27,47,48],[13,27,47,49],
 [13,27,47,51],[13,27,47,52],[13,27,47,53],
 [13,27,47,54],[13,27,47,55],[13,27,47,56],
 [13,27,47,58],[13,27,47,59],[13,27,47,60],
 [13,27,47,61],[13,27,47,62],[13,27,47,65],
 [13,27,47,66],[13,27,47,67],[13,27,47,68],
 [13,27,47,69],[13,27,48,49],[13,27,48,51],
 [13,27,48,52],[13,27,48,53],[13,27,48,55],
 [13,27,48,56],[13,27,48,58],[13,27,48,59],
 [13,27,48,60],[13,27,48,61],[13,27,48,62],
 [13,27,48,64],[13,27,48,66],[13,27,48,67],
 [13,27,48,68],[13,27,48,69],[13,27,49,52],
 [13,27,49,53],[13,27,49,55],[13,27,49,56],
 [13,27,49,58],[13,27,49,59],[13,27,49,60],
 [13,27,49,61],[13,27,49,62],[13,27,49,64],
 [13,27,49,65],[13,27,49,66],[13,27,49,67],
 [13,27,49,68],[13,27,49,69],[13,27,51,52],
 [13,27,51,53],[13,27,51,56],[13,27,51,59],
 [13,27,51,60],[13,27,51,61],[13,27,51,62],
 [13,27,51,64],[13,27,51,65],[13,27,51,67],
 [13,27,51,68],[13,27,51,69],[13,27,52,54],
 [13,27,52,61],[13,27,52,65],[13,27,52,66],
 [13,27,52,69],[13,27,53,54],[13,27,53,56],
 [13,27,53,58],[13,27,53,60],[13,27,53,64],
 [13,27,53,68],[13,27,54,56],[13,27,54,58],
 [13,27,54,60],[13,27,54,61],[13,27,54,62],
 [13,27,54,67],[13,27,54,68],[13,27,54,69],
 [13,27,55,58],[13,27,55,59],[13,27,55,60],
 [13,27,55,61],[13,27,55,62],[13,27,55,66],
 [13,27,55,67],[13,27,55,68],[13,27,55,69],
 [13,27,56,59],[13,27,56,62],[13,27,56,66],
 [13,27,56,69],[13,27,58,59],[13,27,58,60],
 [13,27,58,61],[13,27,58,62],[13,27,58,65],
 [13,27,58,66],[13,27,58,67],[13,27,58,68],
 [13,27,58,69],[13,27,59,60],[13,27,59,61],
 [13,27,59,62],[13,27,59,65],[13,27,59,66],
 [13,27,59,67],[13,27,59,68],[13,27,59,69],
 [13,27,60,61],[13,27,60,62],[13,27,60,65],
 [13,27,60,66],[13,27,60,67],[13,27,60,68],
 [13,27,60,69],[13,27,61,62],[13,27,61,64],
 [13,27,61,65],[13,27,61,66],[13,27,61,67],
 [13,27,61,68],[13,27,61,69],[13,27,62,65],
 [13,27,62,66],[13,27,62,67],[13,27,62,68],
 [13,27,62,69],[13,27,64,65],[13,27,64,66],
 [13,27,64,67],[13,27,64,69],[13,27,66,67],
 [13,27,66,68],[13,27,66,69],[13,27,67,68],
 [13,27,67,69],[13,27,68,69],[13,30,35,36],
 [13,30,35,41],[13,30,35,47],[13,30,35,48],
 [13,30,35,49],[13,30,35,52],[13,30,35,59],
 [13,30,35,60],[13,30,35,68],[13,30,36,48],
 [13,30,36,49],[13,30,36,60],[13,30,36,62],
 [13,30,41,44],[13,30,41,45],[13,30,41,47],
 [13,30,41,49],[13,30,41,53],[13,30,41,59],
 [13,30,41,61],[13,30,41,68],[13,30,44,47],
 [13,30,44,48],[13,30,44,49],[13,30,44,53],
 [13,30,44,59],[13,30,44,61],[13,30,44,67],
 [13,30,44,68],[13,30,45,47],[13,30,45,48],
 [13,30,45,60],[13,30,45,62],[13,30,45,67],
 [13,30,45,68],[13,30,47,48],[13,30,47,49],
 [13,30,47,53],[13,30,47,59],[13,30,47,61],
 [13,30,47,62],[13,30,47,67],[13,30,47,68],
 [13,30,48,52],[13,30,48,58],[13,30,48,60],
 [13,30,48,67],[13,30,48,68],[13,30,49,52],
 [13,30,49,53],[13,30,49,59],[13,30,49,60],
 [13,30,49,61],[13,30,49,67],[13,30,49,68],
 [13,30,52,61],[13,30,53,58],[13,30,53,60],
 [13,30,53,68],[13,30,58,60],[13,30,58,61],
 [13,30,58,62],[13,30,58,67],[13,30,59,60],
 [13,30,59,61],[13,30,59,62],[13,30,59,68],
 [13,30,60,61],[13,30,60,62],[13,30,60,67],
 [13,30,60,68],[13,30,61,67],[13,30,61,68],
 [13,30,62,67],[13,30,62,68],[13,31,36,37],
 [13,31,36,48],[13,31,36,49],[13,31,36,65],
 [13,31,36,69],[13,31,37,67],[13,31,48,49],
 [13,31,48,63],[13,31,48,66],[13,31,48,67],
 [13,31,48,69],[13,31,49,63],[13,31,49,65],
 [13,31,49,66],[13,31,49,67],[13,31,49,69],
 [13,31,63,65],[13,31,63,67],[13,31,63,69],
 [13,31,66,67],[13,31,66,69],[13,31,67,69],
 [13,34,36,43],[13,34,36,45],[13,34,36,46],
 [13,34,36,48],[13,34,36,49],[13,34,36,52],
 [13,34,36,62],[13,34,36,66],[13,34,36,69],
 [13,34,39,41],[13,34,39,43],[13,34,39,44],
 [13,34,39,45],[13,34,39,46],[13,34,39,47],
 [13,34,39,48],[13,34,39,49],[13,34,39,55],
 [13,34,39,58],[13,34,39,59],[13,34,39,60],
 [13,34,39,61],[13,34,39,62],[13,34,39,63],
 [13,34,39,66],[13,34,39,67],[13,34,39,68],
 [13,34,39,69],[13,34,41,43],[13,34,41,44],
 [13,34,41,45],[13,34,41,46],[13,34,41,47],
 [13,34,41,48],[13,34,41,49],[13,34,41,55],
 [13,34,41,58],[13,34,41,59],[13,34,41,60],
 [13,34,41,61],[13,34,41,62],[13,34,41,66],
 [13,34,41,67],[13,34,41,68],[13,34,41,69],
 [13,34,43,44],[13,34,43,45],[13,34,43,46],
 [13,34,43,47],[13,34,43,48],[13,34,43,49],
 [13,34,43,55],[13,34,43,56],[13,34,43,58],
 [13,34,43,59],[13,34,43,60],[13,34,43,61],
 [13,34,43,62],[13,34,43,66],[13,34,43,67],
 [13,34,43,68],[13,34,43,69],[13,34,44,45],
 [13,34,44,46],[13,34,44,47],[13,34,44,48],
 [13,34,44,49],[13,34,44,55],[13,34,44,58],
 [13,34,44,59],[13,34,44,60],[13,34,44,61],
 [13,34,44,62],[13,34,44,66],[13,34,44,67],
 [13,34,44,68],[13,34,44,69],[13,34,45,46],
 [13,34,45,47],[13,34,45,48],[13,34,45,49],
 [13,34,45,55],[13,34,45,58],[13,34,45,59],
 [13,34,45,60],[13,34,45,61],[13,34,45,62],
 [13,34,45,63],[13,34,45,66],[13,34,45,67],
 [13,34,45,68],[13,34,45,69],[13,34,46,47],
 [13,34,46,48],[13,34,46,49],[13,34,46,52],
 [13,34,46,55],[13,34,46,56],[13,34,46,58],
 [13,34,46,59],[13,34,46,60],[13,34,46,61],
 [13,34,46,62],[13,34,46,63],[13,34,46,66],
 [13,34,46,67],[13,34,46,68],[13,34,46,69],
 [13,34,47,48],[13,34,47,49],[13,34,47,55],
 [13,34,47,58],[13,34,47,59],[13,34,47,60],
 [13,34,47,61],[13,34,47,62],[13,34,47,66],
 [13,34,47,67],[13,34,47,68],[13,34,47,69],
 [13,34,48,49],[13,34,48,52],[13,34,48,55],
 [13,34,48,56],[13,34,48,58],[13,34,48,59],
 [13,34,48,60],[13,34,48,61],[13,34,48,62],
 [13,34,48,63],[13,34,48,66],[13,34,48,67],
 [13,34,48,68],[13,34,48,69],[13,34,49,52],
 [13,34,49,55],[13,34,49,56],[13,34,49,58],
 [13,34,49,59],[13,34,49,60],[13,34,49,61],
 [13,34,49,62],[13,34,49,63],[13,34,49,66],
 [13,34,49,67],[13,34,49,68],[13,34,49,69],
 [13,34,52,61],[13,34,52,63],[13,34,52,66],
 [13,34,52,69],[13,34,55,58],[13,34,55,59],
 [13,34,55,60],[13,34,55,61],[13,34,55,62],
 [13,34,55,66],[13,34,55,67],[13,34,55,68],
 [13,34,55,69],[13,34,56,62],[13,34,56,66],
 [13,34,56,69],[13,34,58,59],[13,34,58,60],
 [13,34,58,61],[13,34,58,62],[13,34,58,63],
 [13,34,58,66],[13,34,58,67],[13,34,58,68],
 [13,34,58,69],[13,34,59,60],[13,34,59,61],
 [13,34,59,62],[13,34,59,63],[13,34,59,66],
 [13,34,59,67],[13,34,59,68],[13,34,59,69],
 [13,34,60,61],[13,34,60,62],[13,34,60,63],
 [13,34,60,66],[13,34,60,67],[13,34,60,68],
 [13,34,60,69],[13,34,61,62],[13,34,61,63],
 [13,34,61,66],[13,34,61,67],[13,34,61,68],
 [13,34,61,69],[13,34,62,63],[13,34,62,66],
 [13,34,62,67],[13,34,62,68],[13,34,62,69],
 [13,34,63,66],[13,34,63,67],[13,34,63,68],
 [13,34,63,69],[13,34,66,67],[13,34,66,68],
 [13,34,66,69],[13,34,67,68],[13,34,67,69],
 [13,34,68,69],[13,35,36,37],[13,35,36,45],
 [13,35,36,48],[13,35,36,49],[13,35,36,55],
 [13,35,36,57],[13,35,36,59],[13,35,36,60],
 [13,35,36,62],[13,35,36,65],[13,35,36,66],
 [13,35,36,68],[13,35,36,69],[13,35,37,47],
 [13,35,37,52],[13,35,37,59],[13,35,37,60],
 [13,35,37,62],[13,35,37,68],[13,35,41,45],
 [13,35,41,47],[13,35,41,48],[13,35,41,49],
 [13,35,41,57],[13,35,41,59],[13,35,41,66],
 [13,35,41,68],[13,35,41,69],[13,35,45,47],
 [13,35,45,48],[13,35,45,60],[13,35,45,62],
 [13,35,45,63],[13,35,45,68],[13,35,47,48],
 [13,35,47,49],[13,35,47,57],[13,35,47,59],
 [13,35,47,62],[13,35,47,65],[13,35,47,66],
 [13,35,47,68],[13,35,47,69],[13,35,48,49],
 [13,35,48,52],[13,35,48,55],[13,35,48,57],
 [13,35,48,60],[13,35,48,62],[13,35,48,63],
 [13,35,48,66],[13,35,48,68],[13,35,48,69],
 [13,35,49,52],[13,35,49,55],[13,35,49,59],
 [13,35,49,60],[13,35,49,63],[13,35,49,65],
 [13,35,49,66],[13,35,49,68],[13,35,49,69],
 [13,35,52,57],[13,35,52,63],[13,35,52,66],
 [13,35,52,69],[13,35,55,59],[13,35,55,60],
 [13,35,55,66],[13,35,55,68],[13,35,55,69],
 [13,35,57,60],[13,35,57,68],[13,35,59,60],
 [13,35,59,62],[13,35,59,63],[13,35,59,65],
 [13,35,59,66],[13,35,59,68],[13,35,59,69],
 [13,35,60,62],[13,35,60,63],[13,35,60,65],
 [13,35,60,66],[13,35,60,68],[13,35,60,69],
 [13,35,62,63],[13,35,62,68],[13,35,63,65],
 [13,35,63,66],[13,35,63,68],[13,35,63,69],
 [13,35,66,68],[13,35,66,69],[13,35,68,69],
 [13,36,37,43],[13,36,37,46],[13,36,37,50],
 [13,36,37,54],[13,36,37,60],[13,36,37,62],
 [13,36,37,64],[13,36,37,68],[13,36,43,45],
 [13,36,43,46],[13,36,43,48],[13,36,43,49],
 [13,36,43,57],[13,36,43,59],[13,36,43,62],
 [13,36,43,66],[13,36,43,68],[13,36,43,69],
 [13,36,45,46],[13,36,45,48],[13,36,45,49],
 [13,36,45,50],[13,36,45,51],[13,36,45,54],
 [13,36,45,57],[13,36,45,59],[13,36,45,60],
 [13,36,45,62],[13,36,45,68],[13,36,45,69],
 [13,36,46,48],[13,36,46,49],[13,36,46,52],
 [13,36,46,57],[13,36,46,59],[13,36,46,62],
 [13,36,46,65],[13,36,46,66],[13,36,46,68],
 [13,36,46,69],[13,36,48,49],[13,36,48,50],
 [13,36,48,51],[13,36,48,52],[13,36,48,55],
 [13,36,48,57],[13,36,48,59],[13,36,48,60],
 [13,36,48,62],[13,36,48,64],[13,36,48,68],
 [13,36,48,69],[13,36,49,50],[13,36,49,52],
 [13,36,49,54],[13,36,49,55],[13,36,49,57],
 [13,36,49,59],[13,36,49,60],[13,36,49,62],
 [13,36,49,64],[13,36,49,65],[13,36,49,66],
 [13,36,49,69],[13,36,50,51],[13,36,50,52],
 [13,36,50,55],[13,36,50,59],[13,36,50,60],
 [13,36,50,62],[13,36,50,64],[13,36,50,65],
 [13,36,50,66],[13,36,50,68],[13,36,50,69],
 [13,36,51,57],[13,36,51,59],[13,36,51,62],
 [13,36,51,65],[13,36,51,69],[13,36,52,66],
 [13,36,52,69],[13,36,54,57],[13,36,54,59],
 [13,36,54,62],[13,36,54,66],[13,36,54,68],
 [13,36,54,69],[13,36,55,60],[13,36,55,62],
 [13,36,55,66],[13,36,55,69],[13,36,57,60],
 [13,36,59,60],[13,36,59,62],[13,36,60,62],
 [13,36,60,65],[13,36,60,66],[13,36,60,68],
 [13,36,60,69],[13,36,62,65],[13,36,62,66],
 [13,36,62,68],[13,36,62,69],[13,36,64,65],
 [13,36,64,69],[13,36,66,69],[13,37,39,43],
 [13,37,39,44],[13,37,39,46],[13,37,39,47],
 [13,37,39,60],[13,37,39,61],[13,37,39,64],
 [13,37,39,67],[13,37,43,44],[13,37,43,46],
 [13,37,43,47],[13,37,43,56],[13,37,43,59],
 [13,37,43,60],[13,37,43,61],[13,37,43,64],
 [13,37,43,67],[13,37,43,68],[13,37,44,46],
 [13,37,44,47],[13,37,44,50],[13,37,44,52],
 [13,37,44,54],[13,37,44,59],[13,37,44,60],
 [13,37,44,61],[13,37,44,67],[13,37,46,47],
 [13,37,46,52],[13,37,46,56],[13,37,46,59],
 [13,37,46,60],[13,37,46,61],[13,37,46,67],
 [13,37,46,68],[13,37,47,50],[13,37,47,54],
 [13,37,47,56],[13,37,47,59],[13,37,47,60],
 [13,37,47,61],[13,37,47,62],[13,37,47,67],
 [13,37,50,52],[13,37,50,56],[13,37,50,59],
 [13,37,50,60],[13,37,50,61],[13,37,50,62],
 [13,37,50,64],[13,37,50,67],[13,37,50,68],
 [13,37,52,54],[13,37,52,61],[13,37,54,56],
 [13,37,54,60],[13,37,54,61],[13,37,54,67],
 [13,37,54,68],[13,37,56,62],[13,37,59,60],
 [13,37,59,61],[13,37,59,62],[13,37,60,61],
 [13,37,60,62],[13,37,60,67],[13,37,60,68],
 [13,37,61,67],[13,37,61,68],[13,37,62,67],
 [13,37,62,68],[13,37,64,67],[13,39,41,43],
 [13,39,41,44],[13,39,41,45],[13,39,41,46],
 [13,39,41,47],[13,39,41,48],[13,39,41,49],
 [13,39,41,55],[13,39,41,58],[13,39,41,59],
 [13,39,41,60],[13,39,41,61],[13,39,41,62],
 [13,39,41,66],[13,39,41,67],[13,39,41,68],
 [13,39,41,69],[13,39,43,44],[13,39,43,45],
 [13,39,43,46],[13,39,43,47],[13,39,43,48],
 [13,39,43,49],[13,39,43,55],[13,39,43,58],
 [13,39,43,59],[13,39,43,60],[13,39,43,61],
 [13,39,43,62],[13,39,43,64],[13,39,43,65],
 [13,39,43,66],[13,39,43,67],[13,39,43,68],
 [13,39,43,69],[13,39,44,45],[13,39,44,46],
 [13,39,44,47],[13,39,44,48],[13,39,44,49],
 [13,39,44,55],[13,39,44,58],[13,39,44,59],
 [13,39,44,60],[13,39,44,61],[13,39,44,62],
 [13,39,44,65],[13,39,44,66],[13,39,44,67],
 [13,39,44,68],[13,39,44,69],[13,39,45,46],
 [13,39,45,47],[13,39,45,48],[13,39,45,49],
 [13,39,45,55],[13,39,45,58],[13,39,45,59],
 [13,39,45,60],[13,39,45,61],[13,39,45,62],
 [13,39,45,63],[13,39,45,65],[13,39,45,66],
 [13,39,45,67],[13,39,45,68],[13,39,45,69],
 [13,39,46,47],[13,39,46,48],[13,39,46,49],
 [13,39,46,52],[13,39,46,55],[13,39,46,58],
 [13,39,46,59],[13,39,46,60],[13,39,46,61],
 [13,39,46,62],[13,39,46,63],[13,39,46,65],
 [13,39,46,66],[13,39,46,67],[13,39,46,68],
 [13,39,46,69],[13,39,47,48],[13,39,47,49],
 [13,39,47,55],[13,39,47,58],[13,39,47,59],
 [13,39,47,60],[13,39,47,61],[13,39,47,62],
 [13,39,47,66],[13,39,47,67],[13,39,47,68],
 [13,39,47,69],[13,39,48,49],[13,39,48,52],
 [13,39,48,55],[13,39,48,58],[13,39,48,59],
 [13,39,48,60],[13,39,48,61],[13,39,48,62],
 [13,39,48,63],[13,39,48,64],[13,39,48,66],
 [13,39,48,67],[13,39,48,68],[13,39,48,69],
 [13,39,49,52],[13,39,49,55],[13,39,49,58],
 [13,39,49,59],[13,39,49,60],[13,39,49,61],
 [13,39,49,62],[13,39,49,63],[13,39,49,64],
 [13,39,49,65],[13,39,49,66],[13,39,49,67],
 [13,39,49,68],[13,39,49,69],[13,39,52,61],
 [13,39,52,63],[13,39,55,58],[13,39,55,59],
 [13,39,55,60],[13,39,55,61],[13,39,55,62],
 [13,39,55,66],[13,39,55,67],[13,39,55,68],
 [13,39,55,69],[13,39,58,59],[13,39,58,60],
 [13,39,58,61],[13,39,58,62],[13,39,58,63],
 [13,39,58,65],[13,39,58,66],[13,39,58,67],
 [13,39,58,68],[13,39,58,69],[13,39,59,60],
 [13,39,59,61],[13,39,59,62],[13,39,59,63],
 [13,39,59,66],[13,39,59,67],[13,39,59,68],
 [13,39,59,69],[13,39,60,61],[13,39,60,62],
 [13,39,60,63],[13,39,60,65],[13,39,60,66],
 [13,39,60,67],[13,39,60,68],[13,39,60,69],
 [13,39,61,62],[13,39,61,63],[13,39,61,64],
 [13,39,61,65],[13,39,61,66],[13,39,61,67],
 [13,39,61,68],[13,39,61,69],[13,39,62,63],
 [13,39,62,65],[13,39,62,66],[13,39,62,67],
 [13,39,62,68],[13,39,62,69],[13,39,63,64],
 [13,39,63,65],[13,39,63,66],[13,39,63,67],
 [13,39,63,69],[13,39,64,65],[13,39,64,66],
 [13,39,64,67],[13,39,64,69],[13,39,66,67],
 [13,39,66,68],[13,39,66,69],[13,39,67,68],
 [13,39,67,69],[13,39,68,69],[13,41,43,44],
 [13,41,43,45],[13,41,43,46],[13,41,43,47],
 [13,41,43,48],[13,41,43,49],[13,41,43,55],
 [13,41,43,58],[13,41,43,59],[13,41,43,60],
 [13,41,43,61],[13,41,43,62],[13,41,43,66],
 [13,41,43,67],[13,41,43,68],[13,41,43,69],
 [13,41,44,45],[13,41,44,46],[13,41,44,47],
 [13,41,44,48],[13,41,44,49],[13,41,44,50],
 [13,41,44,53],[13,41,44,54],[13,41,44,55],
 [13,41,44,57],[13,41,44,58],[13,41,44,59],
 [13,41,44,60],[13,41,44,61],[13,41,44,62],
 [13,41,44,66],[13,41,44,67],[13,41,44,68],
 [13,41,44,69],[13,41,45,46],[13,41,45,47],
 [13,41,45,48],[13,41,45,49],[13,41,45,50],
 [13,41,45,53],[13,41,45,55],[13,41,45,58],
 [13,41,45,59],[13,41,45,60],[13,41,45,61],
 [13,41,45,62],[13,41,45,66],[13,41,45,67],
 [13,41,45,68],[13,41,45,69],[13,41,46,47],
 [13,41,46,48],[13,41,46,49],[13,41,46,53],
 [13,41,46,55],[13,41,46,57],[13,41,46,58],
 [13,41,46,59],[13,41,46,60],[13,41,46,61],
 [13,41,46,62],[13,41,46,66],[13,41,46,67],
 [13,41,46,68],[13,41,46,69],[13,41,47,48],
 [13,41,47,49],[13,41,47,50],[13,41,47,53],
 [13,41,47,54],[13,41,47,55],[13,41,47,56],
 [13,41,47,57],[13,41,47,58],[13,41,47,59],
 [13,41,47,60],[13,41,47,61],[13,41,47,62],
 [13,41,47,66],[13,41,47,67],[13,41,47,68],
 [13,41,47,69],[13,41,48,49],[13,41,48,50],
 [13,41,48,55],[13,41,48,56],[13,41,48,58],
 [13,41,48,59],[13,41,48,60],[13,41,48,61],
 [13,41,48,62],[13,41,48,66],[13,41,48,67],
 [13,41,48,68],[13,41,48,69],[13,41,49,50],
 [13,41,49,53],[13,41,49,54],[13,41,49,55],
 [13,41,49,56],[13,41,49,57],[13,41,49,58],
 [13,41,49,59],[13,41,49,60],[13,41,49,61],
 [13,41,49,62],[13,41,49,66],[13,41,49,67],
 [13,41,49,68],[13,41,49,69],[13,41,50,53],
 [13,41,50,56],[13,41,50,58],[13,41,50,59],
 [13,41,50,60],[13,41,50,61],[13,41,50,62],
 [13,41,50,66],[13,41,50,67],[13,41,50,68],
 [13,41,50,69],[13,41,53,54],[13,41,53,60],
 [13,41,53,68],[13,41,54,56],[13,41,54,57],
 [13,41,54,59],[13,41,54,61],[13,41,54,67],
 [13,41,54,68],[13,41,54,69],[13,41,55,58],
 [13,41,55,59],[13,41,55,60],[13,41,55,61],
 [13,41,55,62],[13,41,55,66],[13,41,55,67],
 [13,41,55,68],[13,41,55,69],[13,41,56,57],
 [13,41,56,59],[13,41,56,62],[13,41,56,68],
 [13,41,57,60],[13,41,57,68],[13,41,58,59],
 [13,41,58,60],[13,41,58,61],[13,41,58,62],
 [13,41,58,66],[13,41,58,67],[13,41,58,68],
 [13,41,58,69],[13,41,59,60],[13,41,59,61],
 [13,41,59,62],[13,41,59,66],[13,41,59,67],
 [13,41,59,68],[13,41,59,69],[13,41,60,61],
 [13,41,60,62],[13,41,60,66],[13,41,60,67],
 [13,41,60,68],[13,41,60,69],[13,41,61,62],
 [13,41,61,66],[13,41,61,67],[13,41,61,68],
 [13,41,61,69],[13,41,62,66],[13,41,62,67],
 [13,41,62,68],[13,41,62,69],[13,41,66,67],
 [13,41,66,68],[13,41,66,69],[13,41,67,68],
 [13,41,67,69],[13,41,68,69],[13,43,44,45],
 [13,43,44,46],[13,43,44,47],[13,43,44,48],
 [13,43,44,49],[13,43,44,55],[13,43,44,57],
 [13,43,44,58],[13,43,44,59],[13,43,44,60],
 [13,43,44,61],[13,43,44,62],[13,43,44,65],
 [13,43,44,66],[13,43,44,67],[13,43,44,68],
 [13,43,44,69],[13,43,45,46],[13,43,45,47],
 [13,43,45,48],[13,43,45,49],[13,43,45,55],
 [13,43,45,57],[13,43,45,58],[13,43,45,59],
 [13,43,45,60],[13,43,45,61],[13,43,45,62],
 [13,43,45,65],[13,43,45,66],[13,43,45,67],
 [13,43,45,68],[13,43,45,69],[13,43,46,47],
 [13,43,46,48],[13,43,46,49],[13,43,46,55],
 [13,43,46,56],[13,43,46,57],[13,43,46,58],
 [13,43,46,59],[13,43,46,60],[13,43,46,61],
 [13,43,46,62],[13,43,46,65],[13,43,46,66],
 [13,43,46,67],[13,43,46,68],[13,43,46,69],
 [13,43,47,48],[13,43,47,49],[13,43,47,55],
 [13,43,47,57],[13,43,47,58],[13,43,47,59],
 [13,43,47,60],[13,43,47,61],[13,43,47,62],
 [13,43,47,65],[13,43,47,66],[13,43,47,67],
 [13,43,47,68],[13,43,47,69],[13,43,48,49],
 [13,43,48,55],[13,43,48,56],[13,43,48,57],
 [13,43,48,58],[13,43,48,59],[13,43,48,60],
 [13,43,48,61],[13,43,48,62],[13,43,48,64],
 [13,43,48,66],[13,43,48,67],[13,43,48,68],
 [13,43,48,69],[13,43,49,55],[13,43,49,56],
 [13,43,49,58],[13,43,49,59],[13,43,49,60],
 [13,43,49,61],[13,43,49,62],[13,43,49,64],
 [13,43,49,65],[13,43,49,66],[13,43,49,67],
 [13,43,49,68],[13,43,49,69],[13,43,55,58],
 [13,43,55,59],[13,43,55,60],[13,43,55,61],
 [13,43,55,62],[13,43,55,66],[13,43,55,67],
 [13,43,55,68],[13,43,55,69],[13,43,56,57],
 [13,43,56,62],[13,43,56,68],[13,43,56,69],
 [13,43,57,58],[13,43,57,60],[13,43,57,67],
 [13,43,57,68],[13,43,58,59],[13,43,58,60],
 [13,43,58,61],[13,43,58,62],[13,43,58,65],
 [13,43,58,66],[13,43,58,67],[13,43,58,68],
 [13,43,58,69],[13,43,59,60],[13,43,59,61],
 [13,43,59,62],[13,43,59,65],[13,43,59,66],
 [13,43,59,67],[13,43,59,68],[13,43,59,69],
 [13,43,60,61],[13,43,60,62],[13,43,60,65],
 [13,43,60,66],[13,43,60,67],[13,43,60,68],
 [13,43,60,69],[13,43,61,62],[13,43,61,64],
 [13,43,61,65],[13,43,61,66],[13,43,61,67],
 [13,43,61,68],[13,43,61,69],[13,43,62,65],
 [13,43,62,66],[13,43,62,67],[13,43,62,68],
 [13,43,62,69],[13,43,64,65],[13,43,64,67],
 [13,43,64,69],[13,43,66,67],[13,43,66,68],
 [13,43,66,69],[13,43,67,68],[13,43,67,69],
 [13,43,68,69],[13,44,45,46],[13,44,45,47],
 [13,44,45,48],[13,44,45,49],[13,44,45,50],
 [13,44,45,51],[13,44,45,54],[13,44,45,55],
 [13,44,45,58],[13,44,45,59],[13,44,45,60],
 [13,44,45,61],[13,44,45,62],[13,44,45,66],
 [13,44,45,67],[13,44,45,68],[13,44,45,69],
 [13,44,46,47],[13,44,46,48],[13,44,46,49],
 [13,44,46,53],[13,44,46,55],[13,44,46,57],
 [13,44,46,58],[13,44,46,59],[13,44,46,60],
 [13,44,46,61],[13,44,46,62],[13,44,46,65],
 [13,44,46,66],[13,44,46,67],[13,44,46,68],
 [13,44,46,69],[13,44,47,48],[13,44,47,49],
 [13,44,47,50],[13,44,47,53],[13,44,47,54],
 [13,44,47,55],[13,44,47,57],[13,44,47,58],
 [13,44,47,59],[13,44,47,60],[13,44,47,61],
 [13,44,47,62],[13,44,47,65],[13,44,47,66],
 [13,44,47,67],[13,44,47,68],[13,44,47,69],
 [13,44,48,49],[13,44,48,51],[13,44,48,52],
 [13,44,48,53],[13,44,48,55],[13,44,48,58],
 [13,44,48,59],[13,44,48,60],[13,44,48,61],
 [13,44,48,62],[13,44,48,64],[13,44,48,66],
 [13,44,48,67],[13,44,48,68],[13,44,48,69],
 [13,44,49,50],[13,44,49,52],[13,44,49,53],
 [13,44,49,54],[13,44,49,55],[13,44,49,57],
 [13,44,49,58],[13,44,49,59],[13,44,49,60],
 [13,44,49,61],[13,44,49,62],[13,44,49,64],
 [13,44,49,65],[13,44,49,66],[13,44,49,67],
 [13,44,49,68],[13,44,49,69],[13,44,50,51],
 [13,44,50,52],[13,44,50,53],[13,44,50,55],
 [13,44,50,58],[13,44,50,59],[13,44,50,60],
 [13,44,50,61],[13,44,50,62],[13,44,50,64],
 [13,44,50,66],[13,44,50,67],[13,44,50,68],
 [13,44,50,69],[13,44,51,53],[13,44,51,59],
 [13,44,51,61],[13,44,51,65],[13,44,51,67],
 [13,44,51,68],[13,44,51,69],[13,44,52,57],
 [13,44,52,61],[13,44,52,65],[13,44,52,66],
 [13,44,52,69],[13,44,53,54],[13,44,53,58],
 [13,44,53,60],[13,44,53,68],[13,44,54,57],
 [13,44,54,59],[13,44,54,61],[13,44,54,62],
 [13,44,54,66],[13,44,54,67],[13,44,54,68],
 [13,44,55,58],[13,44,55,59],[13,44,55,60],
 [13,44,55,61],[13,44,55,62],[13,44,55,66],
 [13,44,55,67],[13,44,55,68],[13,44,55,69],
 [13,44,57,58],[13,44,57,60],[13,44,57,67],
 [13,44,57,68],[13,44,58,59],[13,44,58,60],
 [13,44,58,61],[13,44,58,62],[13,44,58,65],
 [13,44,58,66],[13,44,58,67],[13,44,58,68],
 [13,44,58,69],[13,44,59,60],[13,44,59,61],
 [13,44,59,62],[13,44,59,65],[13,44,59,66],
 [13,44,59,67],[13,44,59,68],[13,44,59,69],
 [13,44,60,61],[13,44,60,62],[13,44,60,65],
 [13,44,60,66],[13,44,60,67],[13,44,60,68],
 [13,44,60,69],[13,44,61,62],[13,44,61,64],
 [13,44,61,65],[13,44,61,66],[13,44,61,67],
 [13,44,61,68],[13,44,61,69],[13,44,62,66],
 [13,44,62,67],[13,44,62,68],[13,44,62,69],
 [13,44,64,65],[13,44,64,67],[13,44,66,67],
 [13,44,66,68],[13,44,66,69],[13,44,67,68],
 [13,44,67,69],[13,44,68,69],[13,45,46,47],
 [13,45,46,48],[13,45,46,49],[13,45,46,55],
 [13,45,46,57],[13,45,46,58],[13,45,46,59],
 [13,45,46,60],[13,45,46,61],[13,45,46,62],
 [13,45,46,63],[13,45,46,65],[13,45,46,66],
 [13,45,46,67],[13,45,46,68],[13,45,46,69],
 [13,45,47,48],[13,45,47,49],[13,45,47,50],
 [13,45,47,51],[13,45,47,53],[13,45,47,55],
 [13,45,47,57],[13,45,47,58],[13,45,47,59],
 [13,45,47,60],[13,45,47,61],[13,45,47,62],
 [13,45,47,66],[13,45,47,67],[13,45,47,68],
 [13,45,47,69],[13,45,48,49],[13,45,48,50],
 [13,45,48,51],[13,45,48,53],[13,45,48,55],
 [13,45,48,57],[13,45,48,58],[13,45,48,59],
 [13,45,48,60],[13,45,48,61],[13,45,48,62],
 [13,45,48,63],[13,45,48,66],[13,45,48,67],
 [13,45,48,68],[13,45,48,69],[13,45,49,50],
 [13,45,49,55],[13,45,49,58],[13,45,49,59],
 [13,45,49,60],[13,45,49,61],[13,45,49,62],
 [13,45,49,63],[13,45,49,66],[13,45,49,67],
 [13,45,49,68],[13,45,49,69],[13,45,50,51],
 [13,45,50,53],[13,45,50,55],[13,45,50,58],
 [13,45,50,59],[13,45,50,60],[13,45,50,61],
 [13,45,50,62],[13,45,50,65],[13,45,50,66],
 [13,45,50,67],[13,45,50,68],[13,45,50,69],
 [13,45,51,53],[13,45,51,55],[13,45,51,57],
 [13,45,51,58],[13,45,51,60],[13,45,51,62],
 [13,45,51,63],[13,45,51,67],[13,45,51,68],
 [13,45,51,69],[13,45,53,58],[13,45,53,60],
 [13,45,53,63],[13,45,53,68],[13,45,54,58],
 [13,45,54,60],[13,45,54,62],[13,45,54,66],
 [13,45,54,67],[13,45,54,68],[13,45,54,69],
 [13,45,55,58],[13,45,55,59],[13,45,55,60],
 [13,45,55,61],[13,45,55,62],[13,45,55,66],
 [13,45,55,67],[13,45,55,68],[13,45,55,69],
 [13,45,57,58],[13,45,57,60],[13,45,57,67],
 [13,45,58,59],[13,45,58,60],[13,45,58,61],
 [13,45,58,62],[13,45,58,63],[13,45,58,65],
 [13,45,58,66],[13,45,58,67],[13,45,58,68],
 [13,45,58,69],[13,45,59,60],[13,45,59,61],
 [13,45,59,62],[13,45,59,65],[13,45,59,66],
 [13,45,59,67],[13,45,59,68],[13,45,59,69],
 [13,45,60,61],[13,45,60,62],[13,45,60,63],
 [13,45,60,65],[13,45,60,66],[13,45,60,67],
 [13,45,60,68],[13,45,60,69],[13,45,61,62],
 [13,45,61,63],[13,45,61,66],[13,45,61,67],
 [13,45,61,68],[13,45,61,69],[13,45,62,63],
 [13,45,62,65],[13,45,62,66],[13,45,62,67],
 [13,45,62,68],[13,45,62,69],[13,45,63,66],
 [13,45,63,67],[13,45,63,68],[13,45,63,69],
 [13,45,66,67],[13,45,66,68],[13,45,66,69],
 [13,45,67,68],[13,45,67,69],[13,45,68,69],
 [13,46,47,48],[13,46,47,49],[13,46,47,53],
 [13,46,47,55],[13,46,47,57],[13,46,47,58],
 [13,46,47,59],[13,46,47,60],[13,46,47,61],
 [13,46,47,62],[13,46,47,65],[13,46,47,66],
 [13,46,47,67],[13,46,47,68],[13,46,47,69],
 [13,46,48,49],[13,46,48,52],[13,46,48,55],
 [13,46,48,56],[13,46,48,57],[13,46,48,58],
 [13,46,48,59],[13,46,48,60],[13,46,48,61],
 [13,46,48,62],[13,46,48,63],[13,46,48,66],
 [13,46,48,67],[13,46,48,68],[13,46,48,69],
 [13,46,49,52],[13,46,49,53],[13,46,49,55],
 [13,46,49,56],[13,46,49,58],[13,46,49,59],
 [13,46,49,60],[13,46,49,61],[13,46,49,62],
 [13,46,49,63],[13,46,49,65],[13,46,49,66],
 [13,46,49,67],[13,46,49,68],[13,46,49,69],
 [13,46,52,57],[13,46,52,61],[13,46,52,63],
 [13,46,52,65],[13,46,52,66],[13,46,52,69],
 [13,46,53,56],[13,46,53,58],[13,46,53,60],
 [13,46,53,63],[13,46,53,68],[13,46,55,58],
 [13,46,55,59],[13,46,55,60],[13,46,55,61],
 [13,46,55,62],[13,46,55,66],[13,46,55,67],
 [13,46,55,68],[13,46,55,69],[13,46,56,57],
 [13,46,56,59],[13,46,56,62],[13,46,56,66],
 [13,46,56,68],[13,46,56,69],[13,46,57,58],
 [13,46,57,60],[13,46,57,67],[13,46,57,68],
 [13,46,58,59],[13,46,58,60],[13,46,58,61],
 [13,46,58,62],[13,46,58,63],[13,46,58,65],
 [13,46,58,66],[13,46,58,67],[13,46,58,68],
 [13,46,58,69],[13,46,59,60],[13,46,59,61],
 [13,46,59,62],[13,46,59,63],[13,46,59,65],
 [13,46,59,66],[13,46,59,67],[13,46,59,68],
 [13,46,59,69],[13,46,60,61],[13,46,60,62],
 [13,46,60,63],[13,46,60,65],[13,46,60,66],
 [13,46,60,67],[13,46,60,68],[13,46,60,69],
 [13,46,61,62],[13,46,61,63],[13,46,61,66],
 [13,46,61,67],[13,46,61,68],[13,46,61,69],
 [13,46,62,63],[13,46,62,65],[13,46,62,66],
 [13,46,62,67],[13,46,62,68],[13,46,62,69],
 [13,46,63,65],[13,46,63,66],[13,46,63,67],
 [13,46,63,68],[13,46,63,69],[13,46,66,67],
 [13,46,66,68],[13,46,66,69],[13,46,67,68],
 [13,46,67,69],[13,46,68,69],[13,47,48,49],
 [13,47,48,50],[13,47,48,51],[13,47,48,52],
 [13,47,48,53],[13,47,48,55],[13,47,48,57],
 [13,47,48,58],[13,47,48,59],[13,47,48,60],
 [13,47,48,61],[13,47,48,62],[13,47,48,66],
 [13,47,48,67],[13,47,48,68],[13,47,48,69],
 [13,47,49,50],[13,47,49,53],[13,47,49,54],
 [13,47,49,55],[13,47,49,56],[13,47,49,57],
 [13,47,49,58],[13,47,49,59],[13,47,49,60],
 [13,47,49,61],[13,47,49,62],[13,47,49,65],
 [13,47,49,66],[13,47,49,67],[13,47,49,68],
 [13,47,49,69],[13,47,50,51],[13,47,50,52],
 [13,47,50,53],[13,47,50,55],[13,47,50,56],
 [13,47,50,58],[13,47,50,59],[13,47,50,60],
 [13,47,50,61],[13,47,50,62],[13,47,50,65],
 [13,47,50,66],[13,47,50,67],[13,47,50,68],
 [13,47,50,69],[13,47,51,52],[13,47,51,53],
 [13,47,51,57],[13,47,51,61],[13,47,51,62],
 [13,47,51,65],[13,47,51,67],[13,47,51,69],
 [13,47,52,57],[13,47,52,61],[13,47,52,65],
 [13,47,52,66],[13,47,52,69],[13,47,53,54],
 [13,47,53,56],[13,47,53,58],[13,47,53,60],
 [13,47,53,68],[13,47,54,56],[13,47,54,57],
 [13,47,54,59],[13,47,54,61],[13,47,54,62],
 [13,47,54,66],[13,47,54,68],[13,47,54,69],
 [13,47,55,58],[13,47,55,59],[13,47,55,60],
 [13,47,55,61],[13,47,55,62],[13,47,55,66],
 [13,47,55,67],[13,47,55,68],[13,47,55,69],
 [13,47,56,57],[13,47,56,59],[13,47,56,62],
 [13,47,56,66],[13,47,56,68],[13,47,56,69],
 [13,47,57,58],[13,47,57,60],[13,47,57,67],
 [13,47,57,68],[13,47,58,59],[13,47,58,60],
 [13,47,58,61],[13,47,58,62],[13,47,58,65],
 [13,47,58,66],[13,47,58,67],[13,47,58,68],
 [13,47,58,69],[13,47,59,60],[13,47,59,61],
 [13,47,59,62],[13,47,59,65],[13,47,59,66],
 [13,47,59,67],[13,47,59,68],[13,47,59,69],
 [13,47,60,61],[13,47,60,62],[13,47,60,65],
 [13,47,60,66],[13,47,60,67],[13,47,60,68],
 [13,47,60,69],[13,47,61,62],[13,47,61,65],
 [13,47,61,66],[13,47,61,67],[13,47,61,68],
 [13,47,61,69],[13,47,62,65],[13,47,62,66],
 [13,47,62,67],[13,47,62,68],[13,47,62,69],
 [13,47,66,67],[13,47,66,68],[13,47,66,69],
 [13,47,67,68],[13,47,67,69],[13,47,68,69],
 [13,48,49,50],[13,48,49,52],[13,48,49,55],
 [13,48,49,56],[13,48,49,58],[13,48,49,59],
 [13,48,49,60],[13,48,49,61],[13,48,49,62],
 [13,48,49,63],[13,48,49,64],[13,48,49,66],
 [13,48,49,67],[13,48,49,68],[13,48,49,69],
 [13,48,50,51],[13,48,50,52],[13,48,50,53],
 [13,48,50,56],[13,48,50,58],[13,48,50,59],
 [13,48,50,60],[13,48,50,61],[13,48,50,62],
 [13,48,50,64],[13,48,50,66],[13,48,50,67],
 [13,48,50,68],[13,48,50,69],[13,48,51,52],
 [13,48,51,53],[13,48,51,56],[13,48,51,58],
 [13,48,51,60],[13,48,51,62],[13,48,51,63],
 [13,48,51,64],[13,48,51,67],[13,48,51,68],
 [13,48,52,57],[13,48,52,61],[13,48,52,63],
 [13,48,52,66],[13,48,52,69],[13,48,53,56],
 [13,48,53,58],[13,48,53,60],[13,48,53,63],
 [13,48,53,64],[13,48,53,68],[13,48,55,58],
 [13,48,55,59],[13,48,55,60],[13,48,55,61],
 [13,48,55,62],[13,48,55,66],[13,48,55,67],
 [13,48,55,68],[13,48,55,69],[13,48,56,57],
 [13,48,56,59],[13,48,56,62],[13,48,56,66],
 [13,48,56,68],[13,48,56,69],[13,48,57,58],
 [13,48,57,60],[13,48,57,67],[13,48,57,68],
 [13,48,58,59],[13,48,58,60],[13,48,58,61],
 [13,48,58,62],[13,48,58,63],[13,48,58,66],
 [13,48,58,67],[13,48,58,68],[13,48,58,69],
 [13,48,59,60],[13,48,59,61],[13,48,59,62],
 [13,48,59,66],[13,48,59,67],[13,48,59,68],
 [13,48,59,69],[13,48,60,61],[13,48,60,62],
 [13,48,60,63],[13,48,60,66],[13,48,60,67],
 [13,48,60,68],[13,48,60,69],[13,48,61,62],
 [13,48,61,63],[13,48,61,66],[13,48,61,67],
 [13,48,61,68],[13,48,61,69],[13,48,62,63],
 [13,48,62,66],[13,48,62,67],[13,48,62,68],
 [13,48,62,69],[13,48,63,64],[13,48,63,66],
 [13,48,63,67],[13,48,63,68],[13,48,63,69],
 [13,48,64,66],[13,48,64,67],[13,48,64,69],
 [13,48,66,67],[13,48,66,68],[13,48,66,69],
 [13,48,67,68],[13,48,67,69],[13,48,68,69],
 [13,49,50,52],[13,49,50,53],[13,49,50,56],
 [13,49,50,58],[13,49,50,59],[13,49,50,60],
 [13,49,50,61],[13,49,50,62],[13,49,50,64],
 [13,49,50,65],[13,49,50,66],[13,49,50,67],
 [13,49,50,68],[13,49,50,69],[13,49,52,54],
 [13,49,52,57],[13,49,52,61],[13,49,52,63],
 [13,49,52,65],[13,49,52,66],[13,49,52,69],
 [13,49,53,56],[13,49,53,58],[13,49,53,60],
 [13,49,53,63],[13,49,53,64],[13,49,53,68],
 [13,49,54,56],[13,49,54,57],[13,49,54,58],
 [13,49,54,59],[13,49,54,60],[13,49,54,61],
 [13,49,54,67],[13,49,54,68],[13,49,55,58],
 [13,49,55,59],[13,49,55,60],[13,49,55,61],
 [13,49,55,62],[13,49,55,66],[13,49,55,67],
 [13,49,55,68],[13,49,55,69],[13,49,56,57],
 [13,49,56,59],[13,49,56,62],[13,49,56,66],
 [13,49,56,68],[13,49,56,69],[13,49,57,58],
 [13,49,57,60],[13,49,57,67],[13,49,57,68],
 [13,49,58,59],[13,49,58,60],[13,49,58,61],
 [13,49,58,62],[13,49,58,63],[13,49,58,65],
 [13,49,58,66],[13,49,58,67],[13,49,58,68],
 [13,49,58,69],[13,49,59,60],[13,49,59,61],
 [13,49,59,62],[13,49,59,63],[13,49,59,65],
 [13,49,59,66],[13,49,59,67],[13,49,59,68],
 [13,49,59,69],[13,49,60,61],[13,49,60,62],
 [13,49,60,63],[13,49,60,65],[13,49,60,66],
 [13,49,60,67],[13,49,60,68],[13,49,60,69],
 [13,49,61,62],[13,49,61,63],[13,49,61,64],
 [13,49,61,65],[13,49,61,66],[13,49,61,67],
 [13,49,61,68],[13,49,61,69],[13,49,62,63],
 [13,49,62,65],[13,49,62,66],[13,49,62,67],
 [13,49,62,68],[13,49,62,69],[13,49,63,64],
 [13,49,63,65],[13,49,63,67],[13,49,63,68],
 [13,49,63,69],[13,49,64,65],[13,49,64,66],
 [13,49,64,67],[13,49,64,69],[13,49,66,67],
 [13,49,66,68],[13,49,66,69],[13,49,67,68],
 [13,49,67,69],[13,49,68,69],[13,50,51,52],
 [13,50,51,53],[13,50,51,55],[13,50,51,56],
 [13,50,51,58],[13,50,51,59],[13,50,51,60],
 [13,50,51,61],[13,50,51,62],[13,50,51,64],
 [13,50,51,65],[13,50,51,67],[13,50,51,68],
 [13,50,51,69],[13,50,52,61],[13,50,52,65],
 [13,50,52,66],[13,50,52,69],[13,50,53,56],
 [13,50,53,58],[13,50,53,60],[13,50,53,64],
 [13,50,53,68],[13,50,55,58],[13,50,55,60],
 [13,50,55,61],[13,50,55,62],[13,50,55,67],
 [13,50,55,68],[13,50,55,69],[13,50,56,59],
 [13,50,56,62],[13,50,56,66],[13,50,56,69],
 [13,50,58,60],[13,50,58,61],[13,50,58,62],
 [13,50,58,65],[13,50,58,67],[13,50,58,68],
 [13,50,58,69],[13,50,59,60],[13,50,59,61],
 [13,50,59,62],[13,50,59,65],[13,50,59,67],
 [13,50,59,68],[13,50,60,61],[13,50,60,62],
 [13,50,60,65],[13,50,60,66],[13,50,60,67],
 [13,50,60,68],[13,50,60,69],[13,50,61,62],
 [13,50,61,64],[13,50,61,65],[13,50,61,66],
 [13,50,61,67],[13,50,61,68],[13,50,61,69],
 [13,50,62,65],[13,50,62,66],[13,50,62,67],
 [13,50,62,68],[13,50,62,69],[13,50,64,65],
 [13,50,64,66],[13,50,64,67],[13,50,64,69],
 [13,50,66,67],[13,50,66,68],[13,50,66,69],
 [13,50,67,68],[13,50,67,69],[13,50,68,69],
 [13,51,52,57],[13,51,52,61],[13,51,52,63],
 [13,51,52,65],[13,51,52,69],[13,51,53,56],
 [13,51,53,58],[13,51,53,60],[13,51,53,63],
 [13,51,53,64],[13,51,53,68],[13,51,55,58],
 [13,51,55,59],[13,51,55,60],[13,51,55,61],
 [13,51,55,62],[13,51,55,67],[13,51,55,68],
 [13,51,55,69],[13,51,56,57],[13,51,56,59],
 [13,51,56,62],[13,51,56,68],[13,51,56,69],
 [13,51,57,58],[13,51,57,60],[13,51,57,67],
 [13,51,57,68],[13,51,58,59],[13,51,58,60],
 [13,51,58,61],[13,51,58,62],[13,51,58,65],
 [13,51,58,67],[13,51,58,68],[13,51,58,69],
 [13,51,59,60],[13,51,59,61],[13,51,59,62],
 [13,51,59,63],[13,51,59,65],[13,51,59,67],
 [13,51,59,68],[13,51,59,69],[13,51,60,61],
 [13,51,60,62],[13,51,60,63],[13,51,60,65],
 [13,51,60,67],[13,51,60,68],[13,51,60,69],
 [13,51,61,62],[13,51,61,63],[13,51,61,64],
 [13,51,61,65],[13,51,61,67],[13,51,61,68],
 [13,51,61,69],[13,51,62,63],[13,51,62,65],
 [13,51,62,67],[13,51,62,68],[13,51,62,69],
 [13,51,63,64],[13,51,63,65],[13,51,63,67],
 [13,51,63,68],[13,51,63,69],[13,51,64,65],
 [13,51,64,67],[13,51,64,69],[13,51,67,68],
 [13,51,67,69],[13,51,68,69],[13,52,54,57],
 [13,52,54,61],[13,52,54,66],[13,52,54,69],
 [13,52,61,63],[13,52,61,69],[13,52,63,65],
 [13,52,63,66],[13,52,63,69],[13,52,66,69],
 [13,53,54,56],[13,53,54,58],[13,53,54,60],
 [13,53,54,68],[13,53,58,60],[13,53,58,63],
 [13,53,60,63],[13,53,60,68],[13,53,63,64],
 [13,53,63,68],[13,54,56,57],[13,54,56,59],
 [13,54,56,62],[13,54,56,66],[13,54,56,68],
 [13,54,56,69],[13,54,57,58],[13,54,57,60],
 [13,54,57,67],[13,54,57,68],[13,54,58,59],
 [13,54,58,60],[13,54,58,61],[13,54,58,62],
 [13,54,58,66],[13,54,58,67],[13,54,58,68],
 [13,54,58,69],[13,54,59,60],[13,54,59,61],
 [13,54,59,66],[13,54,59,67],[13,54,59,68],
 [13,54,59,69],[13,54,60,61],[13,54,60,62],
 [13,54,60,66],[13,54,60,67],[13,54,60,68],
 [13,54,60,69],[13,54,61,62],[13,54,61,66],
 [13,54,61,67],[13,54,61,68],[13,54,61,69],
 [13,54,62,66],[13,54,62,67],[13,54,62,68],
 [13,54,62,69],[13,54,66,67],[13,54,66,68],
 [13,54,66,69],[13,54,67,68],[13,54,67,69],
 [13,54,68,69],[13,55,58,59],[13,55,58,60],
 [13,55,58,61],[13,55,58,62],[13,55,58,66],
 [13,55,58,67],[13,55,58,68],[13,55,58,69],
 [13,55,59,60],[13,55,59,61],[13,55,59,62],
 [13,55,59,66],[13,55,59,67],[13,55,59,68],
 [13,55,59,69],[13,55,60,61],[13,55,60,62],
 [13,55,60,66],[13,55,60,67],[13,55,60,68],
 [13,55,60,69],[13,55,61,62],[13,55,61,66],
 [13,55,61,67],[13,55,61,68],[13,55,61,69],
 [13,55,62,66],[13,55,62,67],[13,55,62,68],
 [13,55,62,69],[13,55,66,67],[13,55,66,68],
 [13,55,66,69],[13,55,67,68],[13,55,67,69],
 [13,55,68,69],[13,56,57,68],[13,56,59,62],
 [13,56,59,68],[13,56,62,66],[13,56,62,69],
 [13,56,66,69],[13,57,58,60],[13,57,58,67],
 [13,57,60,67],[13,58,59,60],[13,58,59,61],
 [13,58,59,62],[13,58,59,63],[13,58,59,66],
 [13,58,59,67],[13,58,59,68],[13,58,59,69],
 [13,58,60,61],[13,58,60,62],[13,58,60,63],
 [13,58,60,65],[13,58,60,66],[13,58,60,67],
 [13,58,60,68],[13,58,60,69],[13,58,61,62],
 [13,58,61,63],[13,58,61,66],[13,58,61,67],
 [13,58,61,68],[13,58,61,69],[13,58,62,63],
 [13,58,62,65],[13,58,62,66],[13,58,62,67],
 [13,58,62,68],[13,58,62,69],[13,58,63,65],
 [13,58,63,66],[13,58,63,67],[13,58,63,69],
 [13,58,66,67],[13,58,66,68],[13,58,66,69],
 [13,58,67,68],[13,58,67,69],[13,58,68,69],
 [13,59,60,61],[13,59,60,62],[13,59,60,63],
 [13,59,60,66],[13,59,60,67],[13,59,60,68],
 [13,59,60,69],[13,59,61,62],[13,59,61,63],
 [13,59,61,65],[13,59,61,66],[13,59,61,67],
 [13,59,61,68],[13,59,61,69],[13,59,62,63],
 [13,59,62,65],[13,59,62,66],[13,59,62,67],
 [13,59,62,68],[13,59,62,69],[13,59,63,65],
 [13,59,63,66],[13,59,63,67],[13,59,63,68],
 [13,59,63,69],[13,59,66,67],[13,59,66,68],
 [13,59,66,69],[13,59,67,68],[13,59,67,69],
 [13,59,68,69],[13,60,61,62],[13,60,61,63],
 [13,60,61,66],[13,60,61,67],[13,60,61,68],
 [13,60,61,69],[13,60,62,63],[13,60,62,65],
 [13,60,62,66],[13,60,62,67],[13,60,62,68],
 [13,60,62,69],[13,60,63,65],[13,60,63,66],
 [13,60,63,67],[13,60,63,68],[13,60,63,69],
 [13,60,66,67],[13,60,66,68],[13,60,66,69],
 [13,60,67,68],[13,60,67,69],[13,60,68,69],
 [13,61,62,63],[13,61,62,66],[13,61,62,67],
 [13,61,62,68],[13,61,62,69],[13,61,63,64],
 [13,61,63,65],[13,61,63,66],[13,61,63,67],
 [13,61,63,68],[13,61,63,69],[13,61,64,65],
 [13,61,66,67],[13,61,66,68],[13,61,66,69],
 [13,61,67,68],[13,61,67,69],[13,61,68,69],
 [13,62,63,65],[13,62,63,66],[13,62,63,67],
 [13,62,63,68],[13,62,63,69],[13,62,66,67],
 [13,62,66,68],[13,62,66,69],[13,62,67,68],
 [13,62,67,69],[13,62,68,69],[13,63,64,65],
 [13,63,64,66],[13,63,64,67],[13,63,64,69],
 [13,63,66,67],[13,63,66,68],[13,63,66,69],
 [13,63,67,68],[13,63,67,69],[13,63,68,69],
 [13,64,66,67],[13,64,66,69],[13,64,67,69],
 [13,66,67,68],[13,66,67,69],[13,66,68,69],
 [13,67,68,69],[14,15,17,18],[14,15,17,20],
 [14,15,17,22],[14,15,17,24],[14,15,17,26],
 [14,15,17,27],[14,15,17,37],[14,15,17,41],
 [14,15,17,44],[14,15,17,47],[14,15,17,49],
 [14,15,17,53],[14,15,17,54],[14,15,17,56],
 [14,15,17,57],[14,15,17,59],[14,15,17,61],
 [14,15,17,62],[14,15,17,68],[14,15,17,69],
 [14,15,18,20],[14,15,18,22],[14,15,18,24],
 [14,15,18,25],[14,15,18,26],[14,15,18,36],
 [14,15,18,41],[14,15,18,44],[14,15,18,47],
 [14,15,18,49],[14,15,18,52],[14,15,18,54],
 [14,15,18,56],[14,15,18,57],[14,15,18,59],
 [14,15,18,60],[14,15,18,61],[14,15,18,67],
 [14,15,18,68],[14,15,20,22],[14,15,20,24],
 [14,15,20,25],[14,15,20,26],[14,15,20,27],
 [14,15,20,36],[14,15,20,37],[14,15,20,41],
 [14,15,20,44],[14,15,20,45],[14,15,20,47],
 [14,15,20,49],[14,15,20,52],[14,15,20,53],
 [14,15,20,54],[14,15,20,56],[14,15,20,57],
 [14,15,20,58],[14,15,20,59],[14,15,20,61],
 [14,15,20,62],[14,15,20,67],[14,15,20,68],
 [14,15,22,24],[14,15,22,26],[14,15,22,27],
 [14,15,22,37],[14,15,22,41],[14,15,22,44],
 [14,15,22,47],[14,15,22,49],[14,15,22,54],
 [14,15,22,56],[14,15,22,57],[14,15,22,58],
 [14,15,22,59],[14,15,22,60],[14,15,22,61],
 [14,15,22,67],[14,15,22,68],[14,15,22,69],
 [14,15,24,25],[14,15,24,26],[14,15,24,27],
 [14,15,24,36],[14,15,24,37],[14,15,24,41],
 [14,15,24,44],[14,15,24,45],[14,15,24,47],
 [14,15,24,49],[14,15,24,52],[14,15,24,54],
 [14,15,24,56],[14,15,24,57],[14,15,24,59],
 [14,15,24,60],[14,15,24,61],[14,15,24,62],
 [14,15,24,67],[14,15,24,68],[14,15,24,69],
 [14,15,25,26],[14,15,25,27],[14,15,25,37],
 [14,15,25,45],[14,15,25,49],[14,15,25,53],
 [14,15,25,54],[14,15,25,57],[14,15,25,58],
 [14,15,25,59],[14,15,25,60],[14,15,25,61],
 [14,15,25,62],[14,15,25,67],[14,15,25,68],
 [14,15,25,69],[14,15,26,27],[14,15,26,36],
 [14,15,26,37],[14,15,26,41],[14,15,26,44],
 [14,15,26,47],[14,15,26,49],[14,15,26,52],
 [14,15,26,54],[14,15,26,56],[14,15,26,57],
 [14,15,26,58],[14,15,26,59],[14,15,26,60],
 [14,15,26,61],[14,15,26,62],[14,15,26,67],
 [14,15,26,68],[14,15,26,69],[14,15,27,36],
 [14,15,27,45],[14,15,27,47],[14,15,27,52],
 [14,15,27,54],[14,15,27,56],[14,15,27,60],
 [14,15,27,61],[14,15,27,62],[14,15,27,67],
 [14,15,27,68],[14,15,27,69],[14,15,36,37],
 [14,15,36,49],[14,15,36,53],[14,15,36,54],
 [14,15,36,57],[14,15,36,61],[14,15,36,62],
 [14,15,36,68],[14,15,36,69],[14,15,37,44],
 [14,15,37,47],[14,15,37,52],[14,15,37,54],
 [14,15,37,56],[14,15,37,58],[14,15,37,60],
 [14,15,37,61],[14,15,37,67],[14,15,37,68],
 [14,15,41,44],[14,15,41,45],[14,15,41,47],
 [14,15,41,49],[14,15,41,53],[14,15,41,54],
 [14,15,41,56],[14,15,41,57],[14,15,41,58],
 [14,15,41,59],[14,15,41,60],[14,15,41,61],
 [14,15,41,62],[14,15,41,68],[14,15,44,45],
 [14,15,44,47],[14,15,44,49],[14,15,44,52],
 [14,15,44,53],[14,15,44,54],[14,15,44,56],
 [14,15,44,57],[14,15,44,58],[14,15,44,59],
 [14,15,44,60],[14,15,44,61],[14,15,44,67],
 [14,15,44,68],[14,15,44,69],[14,15,45,47],
 [14,15,45,52],[14,15,45,54],[14,15,45,58],
 [14,15,45,59],[14,15,45,60],[14,15,45,61],
 [14,15,45,62],[14,15,45,67],[14,15,45,68],
 [14,15,45,69],[14,15,47,49],[14,15,47,53],
 [14,15,47,54],[14,15,47,56],[14,15,47,57],
 [14,15,47,58],[14,15,47,59],[14,15,47,61],
 [14,15,47,62],[14,15,47,68],[14,15,47,69],
 [14,15,49,52],[14,15,49,53],[14,15,49,54],
 [14,15,49,56],[14,15,49,57],[14,15,49,59],
 [14,15,49,60],[14,15,49,61],[14,15,49,67],
 [14,15,49,68],[14,15,52,53],[14,15,52,54],
 [14,15,52,57],[14,15,52,61],[14,15,52,62],
 [14,15,52,67],[14,15,52,69],[14,15,53,54],
 [14,15,53,56],[14,15,53,58],[14,15,53,60],
 [14,15,53,67],[14,15,53,68],[14,15,54,56],
 [14,15,54,57],[14,15,54,58],[14,15,54,59],
 [14,15,54,60],[14,15,54,61],[14,15,54,62],
 [14,15,54,67],[14,15,54,68],[14,15,54,69],
 [14,15,56,57],[14,15,56,59],[14,15,56,61],
 [14,15,56,62],[14,15,56,68],[14,15,56,69],
 [14,15,57,59],[14,15,57,60],[14,15,57,61],
 [14,15,57,67],[14,15,57,68],[14,15,58,60],
 [14,15,58,61],[14,15,58,62],[14,15,58,67],
 [14,15,58,68],[14,15,58,69],[14,15,59,60],
 [14,15,59,61],[14,15,59,67],[14,15,59,68],
 [14,15,59,69],[14,15,60,61],[14,15,60,62],
 [14,15,60,67],[14,15,60,68],[14,15,60,69],
 [14,15,61,62],[14,15,61,67],[14,15,61,68],
 [14,15,61,69],[14,15,62,67],[14,15,62,68],
 [14,15,62,69],[14,15,67,68],[14,15,67,69],
 [14,15,68,69],[14,17,18,20],[14,17,18,22],
 [14,17,18,24],[14,17,18,26],[14,17,18,30],
 [14,17,18,35],[14,17,18,39],[14,17,18,41],
 [14,17,18,44],[14,17,18,47],[14,17,18,49],
 [14,17,18,50],[14,17,18,53],[14,17,18,54],
 [14,17,18,55],[14,17,18,56],[14,17,18,57],
 [14,17,18,59],[14,17,18,61],[14,17,18,68],
 [14,17,20,22],[14,17,20,24],[14,17,20,26],
 [14,17,20,27],[14,17,20,37],[14,17,20,41],
 [14,17,20,44],[14,17,20,45],[14,17,20,47],
 [14,17,20,49],[14,17,20,53],[14,17,20,54],
 [14,17,20,56],[14,17,20,57],[14,17,20,59],
 [14,17,20,61],[14,17,20,62],[14,17,20,68],
 [14,17,22,24],[14,17,22,26],[14,17,22,30],
 [14,17,22,37],[14,17,22,39],[14,17,22,41],
 [14,17,22,44],[14,17,22,47],[14,17,22,49],
 [14,17,22,53],[14,17,22,54],[14,17,22,55],
 [14,17,22,56],[14,17,22,57],[14,17,22,58],
 [14,17,22,59],[14,17,22,61],[14,17,22,68],
 [14,17,24,26],[14,17,24,27],[14,17,24,37],
 [14,17,24,41],[14,17,24,44],[14,17,24,45],
 [14,17,24,47],[14,17,24,49],[14,17,24,53],
 [14,17,24,54],[14,17,24,56],[14,17,24,57],
 [14,17,24,59],[14,17,24,61],[14,17,24,62],
 [14,17,24,68],[14,17,24,69],[14,17,26,27],
 [14,17,26,30],[14,17,26,35],[14,17,26,37],
 [14,17,26,39],[14,17,26,41],[14,17,26,44],
 [14,17,26,47],[14,17,26,49],[14,17,26,50],
 [14,17,26,53],[14,17,26,54],[14,17,26,55],
 [14,17,26,56],[14,17,26,57],[14,17,26,58],
 [14,17,26,59],[14,17,26,61],[14,17,26,62],
 [14,17,26,68],[14,17,26,69],[14,17,27,30],
 [14,17,27,35],[14,17,27,39],[14,17,27,47],
 [14,17,27,53],[14,17,27,54],[14,17,27,55],
 [14,17,27,56],[14,17,27,61],[14,17,27,62],
 [14,17,27,69],[14,17,30,35],[14,17,30,41],
 [14,17,30,45],[14,17,30,47],[14,17,30,49],
 [14,17,30,58],[14,17,30,62],[14,17,30,68],
 [14,17,35,37],[14,17,35,41],[14,17,35,47],
 [14,17,35,49],[14,17,35,55],[14,17,35,57],
 [14,17,35,59],[14,17,35,62],[14,17,35,68],
 [14,17,35,69],[14,17,37,39],[14,17,37,44],
 [14,17,37,45],[14,17,37,47],[14,17,37,50],
 [14,17,37,54],[14,17,37,56],[14,17,37,58],
 [14,17,37,61],[14,17,37,62],[14,17,39,41],
 [14,17,39,45],[14,17,39,47],[14,17,39,49],
 [14,17,39,53],[14,17,39,55],[14,17,39,58],
 [14,17,39,59],[14,17,39,62],[14,17,39,68],
 [14,17,39,69],[14,17,41,44],[14,17,41,47],
 [14,17,41,49],[14,17,41,50],[14,17,41,53],
 [14,17,41,54],[14,17,41,55],[14,17,41,56],
 [14,17,41,57],[14,17,41,59],[14,17,41,61],
 [14,17,41,68],[14,17,44,45],[14,17,44,47],
 [14,17,44,49],[14,17,44,50],[14,17,44,53],
 [14,17,44,54],[14,17,44,55],[14,17,44,56],
 [14,17,44,57],[14,17,44,59],[14,17,44,61],
 [14,17,44,68],[14,17,45,47],[14,17,45,50],
 [14,17,45,53],[14,17,45,54],[14,17,45,55],
 [14,17,45,58],[14,17,45,61],[14,17,45,62],
 [14,17,45,69],[14,17,47,49],[14,17,47,50],
 [14,17,47,53],[14,17,47,54],[14,17,47,55],
 [14,17,47,56],[14,17,47,57],[14,17,47,58],
 [14,17,47,59],[14,17,47,61],[14,17,47,62],
 [14,17,47,68],[14,17,47,69],[14,17,49,50],
 [14,17,49,53],[14,17,49,54],[14,17,49,55],
 [14,17,49,56],[14,17,49,57],[14,17,49,59],
 [14,17,49,61],[14,17,49,68],[14,17,50,53],
 [14,17,50,59],[14,17,50,61],[14,17,50,62],
 [14,17,50,68],[14,17,50,69],[14,17,53,54],
 [14,17,53,56],[14,17,53,58],[14,17,53,62],
 [14,17,53,68],[14,17,54,56],[14,17,54,57],
 [14,17,54,58],[14,17,54,59],[14,17,54,61],
 [14,17,54,62],[14,17,54,68],[14,17,54,69],
 [14,17,55,58],[14,17,55,59],[14,17,55,62],
 [14,17,55,68],[14,17,55,69],[14,17,56,57],
 [14,17,56,59],[14,17,56,61],[14,17,56,62],
 [14,17,56,68],[14,17,56,69],[14,17,57,58],
 [14,17,57,59],[14,17,57,61],[14,17,57,68],
 [14,17,58,62],[14,17,58,69],[14,17,59,61],
 [14,17,59,68],[14,17,59,69],[14,17,61,62],
 [14,17,61,68],[14,17,61,69],[14,17,62,69],
 [14,18,20,22],[14,18,20,24],[14,18,20,25],
 [14,18,20,26],[14,18,20,36],[14,18,20,41],
 [14,18,20,44],[14,18,20,47],[14,18,20,49],
 [14,18,20,53],[14,18,20,54],[14,18,20,55],
 [14,18,20,56],[14,18,20,57],[14,18,20,59],
 [14,18,20,61],[14,18,20,66],[14,18,20,67],
 [14,18,20,68],[14,18,22,24],[14,18,22,26],
 [14,18,22,30],[14,18,22,39],[14,18,22,41],
 [14,18,22,43],[14,18,22,44],[14,18,22,47],
 [14,18,22,49],[14,18,22,53],[14,18,22,54],
 [14,18,22,55],[14,18,22,56],[14,18,22,57],
 [14,18,22,59],[14,18,22,60],[14,18,22,61],
 [14,18,22,66],[14,18,22,68],[14,18,24,25],
 [14,18,24,26],[14,18,24,36],[14,18,24,41],
 [14,18,24,44],[14,18,24,47],[14,18,24,49],
 [14,18,24,52],[14,18,24,53],[14,18,24,54],
 [14,18,24,56],[14,18,24,57],[14,18,24,59],
 [14,18,24,60],[14,18,24,61],[14,18,24,67],
 [14,18,24,68],[14,18,25,26],[14,18,25,35],
 [14,18,25,39],[14,18,25,43],[14,18,25,49],
 [14,18,25,50],[14,18,25,52],[14,18,25,53],
 [14,18,25,54],[14,18,25,55],[14,18,25,57],
 [14,18,25,59],[14,18,25,60],[14,18,25,61],
 [14,18,25,66],[14,18,25,67],[14,18,26,30],
 [14,18,26,35],[14,18,26,36],[14,18,26,39],
 [14,18,26,41],[14,18,26,43],[14,18,26,44],
 [14,18,26,47],[14,18,26,49],[14,18,26,50],
 [14,18,26,52],[14,18,26,53],[14,18,26,54],
 [14,18,26,55],[14,18,26,56],[14,18,26,57],
 [14,18,26,59],[14,18,26,60],[14,18,26,61],
 [14,18,26,67],[14,18,26,68],[14,18,30,36],
 [14,18,30,41],[14,18,30,47],[14,18,30,49],
 [14,18,30,52],[14,18,30,60],[14,18,30,67],
 [14,18,30,68],[14,18,35,36],[14,18,35,41],
 [14,18,35,47],[14,18,35,49],[14,18,35,52],
 [14,18,35,56],[14,18,35,59],[14,18,35,60],
 [14,18,35,67],[14,18,35,68],[14,18,36,43],
 [14,18,36,49],[14,18,36,50],[14,18,36,53],
 [14,18,36,54],[14,18,36,55],[14,18,36,57],
 [14,18,36,60],[14,18,36,61],[14,18,36,66],
 [14,18,39,41],[14,18,39,43],[14,18,39,44],
 [14,18,39,47],[14,18,39,49],[14,18,39,52],
 [14,18,39,53],[14,18,39,55],[14,18,39,60],
 [14,18,39,66],[14,18,39,67],[14,18,39,68],
 [14,18,41,44],[14,18,41,47],[14,18,41,49],
 [14,18,41,50],[14,18,41,53],[14,18,41,54],
 [14,18,41,55],[14,18,41,56],[14,18,41,57],
 [14,18,41,59],[14,18,41,61],[14,18,41,68],
 [14,18,43,49],[14,18,43,55],[14,18,43,56],
 [14,18,43,57],[14,18,43,60],[14,18,43,61],
 [14,18,43,67],[14,18,44,47],[14,18,44,49],
 [14,18,44,50],[14,18,44,52],[14,18,44,54],
 [14,18,44,56],[14,18,44,57],[14,18,44,59],
 [14,18,44,60],[14,18,44,61],[14,18,44,68],
 [14,18,47,49],[14,18,47,50],[14,18,47,53],
 [14,18,47,54],[14,18,47,55],[14,18,47,56],
 [14,18,47,57],[14,18,47,59],[14,18,47,61],
 [14,18,47,68],[14,18,49,50],[14,18,49,52],
 [14,18,49,53],[14,18,49,54],[14,18,49,55],
 [14,18,49,56],[14,18,49,57],[14,18,49,59],
 [14,18,49,60],[14,18,49,61],[14,18,49,66],
 [14,18,49,67],[14,18,49,68],[14,18,50,52],
 [14,18,50,53],[14,18,50,55],[14,18,50,56],
 [14,18,50,59],[14,18,50,60],[14,18,50,61],
 [14,18,50,66],[14,18,50,67],[14,18,50,68],
 [14,18,52,53],[14,18,52,54],[14,18,52,57],
 [14,18,52,61],[14,18,52,66],[14,18,52,67],
 [14,18,53,54],[14,18,53,56],[14,18,53,60],
 [14,18,53,67],[14,18,53,68],[14,18,54,56],
 [14,18,54,57],[14,18,54,59],[14,18,54,60],
 [14,18,54,61],[14,18,54,67],[14,18,54,68],
 [14,18,55,59],[14,18,55,60],[14,18,55,66],
 [14,18,55,67],[14,18,55,68],[14,18,56,57],
 [14,18,56,59],[14,18,56,61],[14,18,56,66],
 [14,18,56,68],[14,18,57,59],[14,18,57,60],
 [14,18,57,61],[14,18,57,67],[14,18,57,68],
 [14,18,59,61],[14,18,59,67],[14,18,59,68],
 [14,18,60,61],[14,18,60,66],[14,18,60,67],
 [14,18,61,67],[14,18,61,68],[14,18,66,67],
 [14,18,66,68],[14,20,21,22],[14,20,21,24],
 [14,20,21,25],[14,20,21,27],[14,20,21,45],
 [14,20,21,55],[14,20,21,57],[14,20,21,58],
 [14,20,21,59],[14,20,21,62],[14,20,21,66],
 [14,20,21,67],[14,20,21,68],[14,20,22,24],
 [14,20,22,26],[14,20,22,27],[14,20,22,37],
 [14,20,22,41],[14,20,22,44],[14,20,22,47],
 [14,20,22,49],[14,20,22,54],[14,20,22,55],
 [14,20,22,56],[14,20,22,57],[14,20,22,58],
 [14,20,22,59],[14,20,22,61],[14,20,22,66],
 [14,20,22,67],[14,20,22,68],[14,20,24,25],
 [14,20,24,26],[14,20,24,27],[14,20,24,36],
 [14,20,24,37],[14,20,24,41],[14,20,24,44],
 [14,20,24,45],[14,20,24,47],[14,20,24,49],
 [14,20,24,52],[14,20,24,53],[14,20,24,54],
 [14,20,24,56],[14,20,24,57],[14,20,24,59],
 [14,20,24,61],[14,20,24,62],[14,20,24,67],
 [14,20,24,68],[14,20,25,26],[14,20,25,27],
 [14,20,25,37],[14,20,25,45],[14,20,25,49],
 [14,20,25,53],[14,20,25,54],[14,20,25,55],
 [14,20,25,58],[14,20,25,59],[14,20,25,61],
 [14,20,25,62],[14,20,25,66],[14,20,25,67],
 [14,20,25,68],[14,20,26,27],[14,20,26,36],
 [14,20,26,37],[14,20,26,41],[14,20,26,44],
 [14,20,26,47],[14,20,26,49],[14,20,26,52],
 [14,20,26,54],[14,20,26,55],[14,20,26,56],
 [14,20,26,57],[14,20,26,58],[14,20,26,59],
 [14,20,26,61],[14,20,26,62],[14,20,26,67],
 [14,20,26,68],[14,20,27,36],[14,20,27,45],
 [14,20,27,47],[14,20,27,52],[14,20,27,53],
 [14,20,27,54],[14,20,27,55],[14,20,27,61],
 [14,20,27,62],[14,20,27,66],[14,20,27,67],
 [14,20,27,68],[14,20,36,37],[14,20,36,45],
 [14,20,36,49],[14,20,36,53],[14,20,36,55],
 [14,20,36,61],[14,20,36,62],[14,20,36,66],
 [14,20,36,68],[14,20,37,44],[14,20,37,45],
 [14,20,37,47],[14,20,37,52],[14,20,37,58],
 [14,20,37,61],[14,20,37,62],[14,20,37,68],
 [14,20,41,44],[14,20,41,45],[14,20,41,47],
 [14,20,41,49],[14,20,41,53],[14,20,41,54],
 [14,20,41,55],[14,20,41,56],[14,20,41,57],
 [14,20,41,58],[14,20,41,59],[14,20,41,61],
 [14,20,41,62],[14,20,41,66],[14,20,41,68],
 [14,20,44,45],[14,20,44,47],[14,20,44,49],
 [14,20,44,52],[14,20,44,53],[14,20,44,54],
 [14,20,44,55],[14,20,44,56],[14,20,44,57],
 [14,20,44,58],[14,20,44,59],[14,20,44,61],
 [14,20,44,66],[14,20,44,67],[14,20,44,68],
 [14,20,45,47],[14,20,45,52],[14,20,45,53],
 [14,20,45,54],[14,20,45,55],[14,20,45,57],
 [14,20,45,58],[14,20,45,59],[14,20,45,61],
 [14,20,45,62],[14,20,45,66],[14,20,45,67],
 [14,20,45,68],[14,20,47,49],[14,20,47,53],
 [14,20,47,54],[14,20,47,55],[14,20,47,56],
 [14,20,47,57],[14,20,47,58],[14,20,47,59],
 [14,20,47,61],[14,20,47,62],[14,20,47,68],
 [14,20,49,53],[14,20,49,54],[14,20,49,55],
 [14,20,49,56],[14,20,49,57],[14,20,49,59],
 [14,20,49,61],[14,20,49,66],[14,20,49,67],
 [14,20,49,68],[14,20,52,53],[14,20,52,54],
 [14,20,52,57],[14,20,52,61],[14,20,52,62],
 [14,20,52,66],[14,20,52,67],[14,20,53,54],
 [14,20,53,56],[14,20,53,58],[14,20,53,62],
 [14,20,53,67],[14,20,53,68],[14,20,54,56],
 [14,20,54,57],[14,20,54,59],[14,20,54,61],
 [14,20,54,62],[14,20,54,68],[14,20,55,58],
 [14,20,55,59],[14,20,55,61],[14,20,55,62],
 [14,20,55,66],[14,20,55,67],[14,20,55,68],
 [14,20,56,57],[14,20,56,59],[14,20,56,61],
 [14,20,56,62],[14,20,56,66],[14,20,56,68],
 [14,20,57,58],[14,20,57,59],[14,20,57,61],
 [14,20,57,67],[14,20,57,68],[14,20,58,61],
 [14,20,58,62],[14,20,58,67],[14,20,58,68],
 [14,20,59,61],[14,20,59,67],[14,20,59,68],
 [14,20,61,62],[14,20,61,66],[14,20,61,67],
 [14,20,61,68],[14,20,62,66],[14,20,62,67],
 [14,20,62,68],[14,20,66,67],[14,20,66,68],
 [14,20,67,68],[14,21,22,24],[14,21,22,27],
 [14,21,22,39],[14,21,22,43],[14,21,22,55],
 [14,21,22,58],[14,21,22,59],[14,21,22,60],
 [14,21,22,66],[14,21,22,67],[14,21,22,68],
 [14,21,22,69],[14,21,24,25],[14,21,24,27],
 [14,21,24,45],[14,21,24,57],[14,21,24,59],
 [14,21,24,60],[14,21,24,62],[14,21,24,67],
 [14,21,24,68],[14,21,24,69],[14,21,25,27],
 [14,21,25,39],[14,21,25,43],[14,21,25,45],
 [14,21,25,50],[14,21,25,52],[14,21,25,55],
 [14,21,25,57],[14,21,25,58],[14,21,25,59],
 [14,21,25,60],[14,21,25,62],[14,21,25,66],
 [14,21,25,67],[14,21,25,68],[14,21,25,69],
 [14,21,27,39],[14,21,27,43],[14,21,27,45],
 [14,21,27,55],[14,21,27,60],[14,21,27,62],
 [14,21,27,66],[14,21,27,67],[14,21,27,68],
 [14,21,27,69],[14,21,39,43],[14,21,39,45],
 [14,21,39,52],[14,21,39,55],[14,21,39,58],
 [14,21,39,59],[14,21,39,60],[14,21,39,62],
 [14,21,39,66],[14,21,39,67],[14,21,39,68],
 [14,21,39,69],[14,21,43,45],[14,21,43,52],
 [14,21,43,55],[14,21,43,57],[14,21,43,58],
 [14,21,43,59],[14,21,43,60],[14,21,43,62],
 [14,21,43,66],[14,21,43,67],[14,21,43,68],
 [14,21,43,69],[14,21,45,50],[14,21,45,52],
 [14,21,45,55],[14,21,45,57],[14,21,45,58],
 [14,21,45,59],[14,21,45,60],[14,21,45,62],
 [14,21,45,66],[14,21,45,67],[14,21,45,68],
 [14,21,45,69],[14,21,50,52],[14,21,50,59],
 [14,21,50,62],[14,21,50,66],[14,21,50,67],
 [14,21,50,68],[14,21,50,69],[14,21,52,62],
 [14,21,52,67],[14,21,52,69],[14,21,55,58],
 [14,21,55,59],[14,21,55,60],[14,21,55,62],
 [14,21,55,66],[14,21,55,67],[14,21,55,68],
 [14,21,55,69],[14,21,57,58],[14,21,57,59],
 [14,21,57,60],[14,21,57,67],[14,21,57,68],
 [14,21,58,60],[14,21,58,62],[14,21,58,67],
 [14,21,58,68],[14,21,58,69],[14,21,59,60],
 [14,21,59,67],[14,21,59,68],[14,21,59,69],
 [14,21,60,62],[14,21,60,66],[14,21,60,67],
 [14,21,60,68],[14,21,60,69],[14,21,62,66],
 [14,21,62,67],[14,21,62,68],[14,21,62,69],
 [14,21,66,67],[14,21,66,68],[14,21,66,69],
 [14,21,67,68],[14,21,67,69],[14,21,68,69],
 [14,22,24,26],[14,22,24,27],[14,22,24,37],
 [14,22,24,41],[14,22,24,44],[14,22,24,47],
 [14,22,24,49],[14,22,24,54],[14,22,24,56],
 [14,22,24,57],[14,22,24,59],[14,22,24,60],
 [14,22,24,61],[14,22,24,67],[14,22,24,68],
 [14,22,24,69],[14,22,26,27],[14,22,26,30],
 [14,22,26,37],[14,22,26,39],[14,22,26,41],
 [14,22,26,43],[14,22,26,44],[14,22,26,47],
 [14,22,26,49],[14,22,26,54],[14,22,26,55],
 [14,22,26,56],[14,22,26,57],[14,22,26,58],
 [14,22,26,59],[14,22,26,60],[14,22,26,61],
 [14,22,26,67],[14,22,26,68],[14,22,26,69],
 [14,22,27,39],[14,22,27,43],[14,22,27,47],
 [14,22,27,53],[14,22,27,54],[14,22,27,55],
 [14,22,27,56],[14,22,27,60],[14,22,27,61],
 [14,22,27,66],[14,22,27,67],[14,22,27,68],
 [14,22,27,69],[14,22,30,41],[14,22,30,47],
 [14,22,30,49],[14,22,30,68],[14,22,37,39],
 [14,22,37,43],[14,22,37,44],[14,22,37,47],
 [14,22,37,58],[14,22,37,60],[14,22,37,61],
 [14,22,37,67],[14,22,37,68],[14,22,39,41],
 [14,22,39,43],[14,22,39,44],[14,22,39,47],
 [14,22,39,49],[14,22,39,55],[14,22,39,58],
 [14,22,39,59],[14,22,39,60],[14,22,39,66],
 [14,22,39,67],[14,22,39,68],[14,22,39,69],
 [14,22,41,44],[14,22,41,47],[14,22,41,49],
 [14,22,41,53],[14,22,41,54],[14,22,41,55],
 [14,22,41,56],[14,22,41,57],[14,22,41,58],
 [14,22,41,59],[14,22,41,60],[14,22,41,61],
 [14,22,41,66],[14,22,41,68],[14,22,43,44],
 [14,22,43,49],[14,22,43,53],[14,22,43,55],
 [14,22,43,56],[14,22,43,57],[14,22,43,58],
 [14,22,43,59],[14,22,43,60],[14,22,43,61],
 [14,22,43,66],[14,22,43,67],[14,22,43,68],
 [14,22,43,69],[14,22,44,47],[14,22,44,49],
 [14,22,44,53],[14,22,44,54],[14,22,44,55],
 [14,22,44,56],[14,22,44,57],[14,22,44,58],
 [14,22,44,59],[14,22,44,60],[14,22,44,61],
 [14,22,44,66],[14,22,44,67],[14,22,44,68],
 [14,22,44,69],[14,22,47,49],[14,22,47,53],
 [14,22,47,54],[14,22,47,55],[14,22,47,56],
 [14,22,47,57],[14,22,47,58],[14,22,47,59],
 [14,22,47,61],[14,22,47,68],[14,22,47,69],
 [14,22,49,53],[14,22,49,54],[14,22,49,55],
 [14,22,49,56],[14,22,49,57],[14,22,49,59],
 [14,22,49,60],[14,22,49,61],[14,22,49,66],
 [14,22,49,67],[14,22,49,68],[14,22,53,56],
 [14,22,53,58],[14,22,53,60],[14,22,53,68],
 [14,22,54,56],[14,22,54,57],[14,22,54,58],
 [14,22,54,59],[14,22,54,61],[14,22,54,67],
 [14,22,54,68],[14,22,55,58],[14,22,55,59],
 [14,22,55,60],[14,22,55,61],[14,22,55,66],
 [14,22,55,67],[14,22,55,68],[14,22,55,69],
 [14,22,56,57],[14,22,56,59],[14,22,56,61],
 [14,22,56,66],[14,22,56,68],[14,22,56,69],
 [14,22,57,58],[14,22,57,59],[14,22,57,60],
 [14,22,57,61],[14,22,57,67],[14,22,57,68],
 [14,22,58,60],[14,22,58,61],[14,22,58,67],
 [14,22,58,68],[14,22,58,69],[14,22,59,60],
 [14,22,59,61],[14,22,59,67],[14,22,59,68],
 [14,22,59,69],[14,22,60,61],[14,22,60,66],
 [14,22,60,67],[14,22,60,68],[14,22,60,69],
 [14,22,61,66],[14,22,61,67],[14,22,61,68],
 [14,22,61,69],[14,22,66,67],[14,22,66,68],
 [14,22,66,69],[14,22,67,68],[14,22,67,69],
 [14,22,68,69],[14,24,25,26],[14,24,25,27],
 [14,24,25,37],[14,24,25,45],[14,24,25,49],
 [14,24,25,53],[14,24,25,54],[14,24,25,57],
 [14,24,25,59],[14,24,25,60],[14,24,25,61],
 [14,24,25,62],[14,24,25,67],[14,24,25,68],
 [14,24,25,69],[14,24,26,27],[14,24,26,36],
 [14,24,26,37],[14,24,26,41],[14,24,26,44],
 [14,24,26,47],[14,24,26,49],[14,24,26,52],
 [14,24,26,54],[14,24,26,56],[14,24,26,57],
 [14,24,26,59],[14,24,26,60],[14,24,26,61],
 [14,24,26,62],[14,24,26,67],[14,24,26,68],
 [14,24,26,69],[14,24,27,36],[14,24,27,45],
 [14,24,27,47],[14,24,27,52],[14,24,27,53],
 [14,24,27,54],[14,24,27,56],[14,24,27,60],
 [14,24,27,61],[14,24,27,62],[14,24,27,67],
 [14,24,27,68],[14,24,27,69],[14,24,36,37],
 [14,24,36,45],[14,24,36,49],[14,24,36,53],
 [14,24,36,54],[14,24,36,57],[14,24,36,60],
 [14,24,36,61],[14,24,36,62],[14,24,36,68],
 [14,24,36,69],[14,24,37,44],[14,24,37,45],
 [14,24,37,47],[14,24,37,52],[14,24,37,54],
 [14,24,37,56],[14,24,37,60],[14,24,37,61],
 [14,24,37,62],[14,24,37,67],[14,24,37,68],
 [14,24,41,44],[14,24,41,45],[14,24,41,47],
 [14,24,41,49],[14,24,41,53],[14,24,41,54],
 [14,24,41,56],[14,24,41,57],[14,24,41,59],
 [14,24,41,60],[14,24,41,61],[14,24,41,62],
 [14,24,41,68],[14,24,44,45],[14,24,44,47],
 [14,24,44,49],[14,24,44,52],[14,24,44,53],
 [14,24,44,54],[14,24,44,56],[14,24,44,57],
 [14,24,44,59],[14,24,44,60],[14,24,44,61],
 [14,24,44,67],[14,24,44,68],[14,24,44,69],
 [14,24,45,47],[14,24,45,53],[14,24,45,54],
 [14,24,45,57],[14,24,45,59],[14,24,45,60],
 [14,24,45,61],[14,24,45,62],[14,24,45,67],
 [14,24,45,68],[14,24,45,69],[14,24,47,49],
 [14,24,47,53],[14,24,47,54],[14,24,47,56],
 [14,24,47,57],[14,24,47,59],[14,24,47,61],
 [14,24,47,62],[14,24,47,68],[14,24,47,69],
 [14,24,49,52],[14,24,49,53],[14,24,49,54],
 [14,24,49,56],[14,24,49,57],[14,24,49,59],
 [14,24,49,60],[14,24,49,61],[14,24,49,67],
 [14,24,49,68],[14,24,52,53],[14,24,52,54],
 [14,24,52,57],[14,24,52,61],[14,24,52,62],
 [14,24,52,67],[14,24,52,69],[14,24,53,54],
 [14,24,53,56],[14,24,53,60],[14,24,53,62],
 [14,24,53,67],[14,24,53,68],[14,24,54,56],
 [14,24,54,57],[14,24,54,59],[14,24,54,60],
 [14,24,54,61],[14,24,54,62],[14,24,54,67],
 [14,24,54,68],[14,24,54,69],[14,24,56,57],
 [14,24,56,59],[14,24,56,61],[14,24,56,62],
 [14,24,56,68],[14,24,56,69],[14,24,57,59],
 [14,24,57,60],[14,24,57,61],[14,24,57,67],
 [14,24,57,68],[14,24,59,60],[14,24,59,61],
 [14,24,59,67],[14,24,59,68],[14,24,59,69],
 [14,24,60,61],[14,24,60,62],[14,24,60,67],
 [14,24,60,68],[14,24,60,69],[14,24,61,62],
 [14,24,61,67],[14,24,61,68],[14,24,61,69],
 [14,24,62,67],[14,24,62,68],[14,24,62,69],
 [14,24,67,68],[14,24,67,69],[14,24,68,69],
 [14,25,26,27],[14,25,26,35],[14,25,26,37],
 [14,25,26,39],[14,25,26,43],[14,25,26,49],
 [14,25,26,50],[14,25,26,52],[14,25,26,53],
 [14,25,26,54],[14,25,26,55],[14,25,26,57],
 [14,25,26,58],[14,25,26,59],[14,25,26,60],
 [14,25,26,61],[14,25,26,62],[14,25,26,67],
 [14,25,26,68],[14,25,26,69],[14,25,27,35],
 [14,25,27,39],[14,25,27,43],[14,25,27,45],
 [14,25,27,53],[14,25,27,54],[14,25,27,55],
 [14,25,27,60],[14,25,27,61],[14,25,27,62],
 [14,25,27,66],[14,25,27,67],[14,25,27,68],
 [14,25,27,69],[14,25,35,37],[14,25,35,49],
 [14,25,35,52],[14,25,35,55],[14,25,35,57],
 [14,25,35,59],[14,25,35,60],[14,25,35,62],
 [14,25,35,67],[14,25,35,68],[14,25,35,69],
 [14,25,37,39],[14,25,37,43],[14,25,37,45],
 [14,25,37,50],[14,25,37,52],[14,25,37,54],
 [14,25,37,58],[14,25,37,60],[14,25,37,61],
 [14,25,37,62],[14,25,37,67],[14,25,37,68],
 [14,25,39,43],[14,25,39,45],[14,25,39,49],
 [14,25,39,55],[14,25,39,58],[14,25,39,59],
 [14,25,39,60],[14,25,39,62],[14,25,39,66],
 [14,25,39,67],[14,25,39,68],[14,25,39,69],
 [14,25,43,45],[14,25,43,49],[14,25,43,52],
 [14,25,43,53],[14,25,43,55],[14,25,43,57],
 [14,25,43,58],[14,25,43,59],[14,25,43,60],
 [14,25,43,61],[14,25,43,62],[14,25,43,66],
 [14,25,43,67],[14,25,43,68],[14,25,43,69],
 [14,25,45,50],[14,25,45,52],[14,25,45,53],
 [14,25,45,54],[14,25,45,55],[14,25,45,57],
 [14,25,45,58],[14,25,45,59],[14,25,45,60],
 [14,25,45,61],[14,25,45,62],[14,25,45,66],
 [14,25,45,67],[14,25,45,68],[14,25,45,69],
 [14,25,49,50],[14,25,49,52],[14,25,49,53],
 [14,25,49,54],[14,25,49,55],[14,25,49,57],
 [14,25,49,59],[14,25,49,60],[14,25,49,61],
 [14,25,49,66],[14,25,49,67],[14,25,49,68],
 [14,25,50,52],[14,25,50,53],[14,25,50,61],
 [14,25,50,62],[14,25,50,66],[14,25,50,67],
 [14,25,50,69],[14,25,52,53],[14,25,52,54],
 [14,25,52,61],[14,25,52,62],[14,25,52,66],
 [14,25,52,67],[14,25,52,69],[14,25,53,54],
 [14,25,53,58],[14,25,53,60],[14,25,53,62],
 [14,25,53,67],[14,25,53,68],[14,25,54,57],
 [14,25,54,58],[14,25,54,60],[14,25,54,61],
 [14,25,54,62],[14,25,54,67],[14,25,54,68],
 [14,25,54,69],[14,25,55,58],[14,25,55,59],
 [14,25,55,60],[14,25,55,61],[14,25,55,62],
 [14,25,55,66],[14,25,55,67],[14,25,55,68],
 [14,25,55,69],[14,25,57,58],[14,25,57,59],
 [14,25,57,60],[14,25,57,61],[14,25,57,67],
 [14,25,58,60],[14,25,58,61],[14,25,58,62],
 [14,25,58,67],[14,25,58,68],[14,25,58,69],
 [14,25,59,60],[14,25,59,61],[14,25,59,67],
 [14,25,59,68],[14,25,59,69],[14,25,60,61],
 [14,25,60,62],[14,25,60,66],[14,25,60,67],
 [14,25,60,68],[14,25,60,69],[14,25,61,62],
 [14,25,61,66],[14,25,61,67],[14,25,61,68],
 [14,25,61,69],[14,25,62,66],[14,25,62,67],
 [14,25,62,68],[14,25,62,69],[14,25,66,67],
 [14,25,66,68],[14,25,66,69],[14,25,67,68],
 [14,25,67,69],[14,25,68,69],[14,26,27,35],
 [14,26,27,36],[14,26,27,39],[14,26,27,43],
 [14,26,27,47],[14,26,27,52],[14,26,27,54],
 [14,26,27,55],[14,26,27,56],[14,26,27,60],
 [14,26,27,61],[14,26,27,62],[14,26,27,67],
 [14,26,27,68],[14,26,27,69],[14,26,30,35],
 [14,26,30,41],[14,26,30,47],[14,26,30,49],
 [14,26,30,60],[14,26,30,62],[14,26,30,68],
 [14,26,35,36],[14,26,35,37],[14,26,35,41],
 [14,26,35,47],[14,26,35,49],[14,26,35,52],
 [14,26,35,55],[14,26,35,56],[14,26,35,57],
 [14,26,35,59],[14,26,35,60],[14,26,35,62],
 [14,26,35,67],[14,26,35,68],[14,26,35,69],
 [14,26,36,37],[14,26,36,43],[14,26,36,49],
 [14,26,36,50],[14,26,36,53],[14,26,36,54],
 [14,26,36,55],[14,26,36,57],[14,26,36,60],
 [14,26,36,61],[14,26,36,62],[14,26,36,68],
 [14,26,36,69],[14,26,37,39],[14,26,37,43],
 [14,26,37,44],[14,26,37,47],[14,26,37,52],
 [14,26,37,54],[14,26,37,56],[14,26,37,60],
 [14,26,37,61],[14,26,37,62],[14,26,37,67],
 [14,26,37,68],[14,26,39,41],[14,26,39,43],
 [14,26,39,44],[14,26,39,47],[14,26,39,49],
 [14,26,39,55],[14,26,39,58],[14,26,39,59],
 [14,26,39,60],[14,26,39,62],[14,26,39,67],
 [14,26,39,68],[14,26,39,69],[14,26,41,44],
 [14,26,41,47],[14,26,41,49],[14,26,41,50],
 [14,26,41,53],[14,26,41,54],[14,26,41,55],
 [14,26,41,56],[14,26,41,57],[14,26,41,58],
 [14,26,41,59],[14,26,41,60],[14,26,41,61],
 [14,26,41,62],[14,26,41,68],[14,26,43,44],
 [14,26,43,49],[14,26,43,52],[14,26,43,53],
 [14,26,43,55],[14,26,43,56],[14,26,43,58],
 [14,26,43,59],[14,26,43,60],[14,26,43,61],
 [14,26,43,62],[14,26,43,67],[14,26,43,68],
 [14,26,43,69],[14,26,44,47],[14,26,44,49],
 [14,26,44,50],[14,26,44,52],[14,26,44,53],
 [14,26,44,54],[14,26,44,55],[14,26,44,56],
 [14,26,44,57],[14,26,44,58],[14,26,44,59],
 [14,26,44,60],[14,26,44,61],[14,26,44,67],
 [14,26,44,68],[14,26,44,69],[14,26,47,49],
 [14,26,47,50],[14,26,47,53],[14,26,47,54],
 [14,26,47,55],[14,26,47,56],[14,26,47,57],
 [14,26,47,58],[14,26,47,59],[14,26,47,61],
 [14,26,47,62],[14,26,47,68],[14,26,47,69],
 [14,26,49,50],[14,26,49,52],[14,26,49,53],
 [14,26,49,54],[14,26,49,55],[14,26,49,56],
 [14,26,49,57],[14,26,49,59],[14,26,49,60],
 [14,26,49,61],[14,26,49,67],[14,26,49,68],
 [14,26,50,52],[14,26,50,53],[14,26,50,56],
 [14,26,50,60],[14,26,50,62],[14,26,50,67],
 [14,26,50,68],[14,26,52,53],[14,26,52,54],
 [14,26,52,57],[14,26,52,61],[14,26,52,62],
 [14,26,52,67],[14,26,52,69],[14,26,53,54],
 [14,26,53,56],[14,26,53,58],[14,26,53,60],
 [14,26,53,62],[14,26,53,67],[14,26,53,68],
 [14,26,54,56],[14,26,54,57],[14,26,54,58],
 [14,26,54,59],[14,26,54,60],[14,26,54,61],
 [14,26,54,62],[14,26,54,67],[14,26,54,68],
 [14,26,54,69],[14,26,55,58],[14,26,55,59],
 [14,26,55,60],[14,26,55,61],[14,26,55,62],
 [14,26,55,67],[14,26,55,68],[14,26,55,69],
 [14,26,56,57],[14,26,56,59],[14,26,56,61],
 [14,26,56,62],[14,26,56,68],[14,26,56,69],
 [14,26,57,58],[14,26,57,59],[14,26,57,60],
 [14,26,57,61],[14,26,57,67],[14,26,57,68],
 [14,26,58,60],[14,26,58,61],[14,26,58,62],
 [14,26,58,67],[14,26,58,68],[14,26,58,69],
 [14,26,59,60],[14,26,59,61],[14,26,59,67],
 [14,26,59,68],[14,26,59,69],[14,26,60,61],
 [14,26,60,62],[14,26,60,67],[14,26,60,68],
 [14,26,60,69],[14,26,61,62],[14,26,61,67],
 [14,26,61,68],[14,26,61,69],[14,26,62,67],
 [14,26,62,68],[14,26,62,69],[14,26,67,68],
 [14,26,67,69],[14,26,68,69],[14,27,30,35],
 [14,27,30,45],[14,27,30,47],[14,27,30,60],
 [14,27,30,62],[14,27,35,36],[14,27,35,47],
 [14,27,35,52],[14,27,35,55],[14,27,35,56],
 [14,27,35,60],[14,27,35,62],[14,27,35,67],
 [14,27,35,68],[14,27,35,69],[14,27,36,43],
 [14,27,36,45],[14,27,36,53],[14,27,36,54],
 [14,27,36,55],[14,27,36,60],[14,27,36,61],
 [14,27,36,62],[14,27,36,66],[14,27,36,68],
 [14,27,36,69],[14,27,39,43],[14,27,39,45],
 [14,27,39,47],[14,27,39,52],[14,27,39,53],
 [14,27,39,55],[14,27,39,60],[14,27,39,62],
 [14,27,39,66],[14,27,39,67],[14,27,39,68],
 [14,27,39,69],[14,27,43,45],[14,27,43,52],
 [14,27,43,53],[14,27,43,55],[14,27,43,56],
 [14,27,43,60],[14,27,43,61],[14,27,43,62],
 [14,27,43,66],[14,27,43,67],[14,27,43,68],
 [14,27,43,69],[14,27,45,47],[14,27,45,53],
 [14,27,45,54],[14,27,45,55],[14,27,45,60],
 [14,27,45,61],[14,27,45,62],[14,27,45,66],
 [14,27,45,67],[14,27,45,68],[14,27,45,69],
 [14,27,47,53],[14,27,47,54],[14,27,47,55],
 [14,27,47,56],[14,27,47,61],[14,27,47,62],
 [14,27,47,68],[14,27,47,69],[14,27,52,53],
 [14,27,52,54],[14,27,52,61],[14,27,52,62],
 [14,27,52,66],[14,27,52,67],[14,27,52,69],
 [14,27,53,54],[14,27,53,56],[14,27,53,60],
 [14,27,53,62],[14,27,53,67],[14,27,53,68],
 [14,27,54,56],[14,27,54,60],[14,27,54,61],
 [14,27,54,62],[14,27,54,67],[14,27,54,68],
 [14,27,54,69],[14,27,55,60],[14,27,55,61],
 [14,27,55,62],[14,27,55,66],[14,27,55,67],
 [14,27,55,68],[14,27,55,69],[14,27,56,61],
 [14,27,56,62],[14,27,56,66],[14,27,56,69],
 [14,27,60,61],[14,27,60,62],[14,27,60,66],
 [14,27,60,67],[14,27,60,68],[14,27,60,69],
 [14,27,61,62],[14,27,61,66],[14,27,61,67],
 [14,27,61,68],[14,27,61,69],[14,27,62,66],
 [14,27,62,67],[14,27,62,68],[14,27,62,69],
 [14,27,66,67],[14,27,66,68],[14,27,66,69],
 [14,27,67,68],[14,27,67,69],[14,27,68,69],
 [14,30,35,36],[14,30,35,41],[14,30,35,47],
 [14,30,35,49],[14,30,35,52],[14,30,35,60],
 [14,30,35,67],[14,30,35,68],[14,30,36,49],
 [14,30,36,60],[14,30,36,62],[14,30,41,45],
 [14,30,41,47],[14,30,41,49],[14,30,41,68],
 [14,30,45,47],[14,30,45,60],[14,30,45,62],
 [14,30,45,67],[14,30,45,68],[14,30,47,49],
 [14,30,47,62],[14,30,47,68],[14,30,49,52],
 [14,30,49,60],[14,30,49,67],[14,30,49,68],
 [14,30,52,62],[14,30,52,67],[14,30,58,60],
 [14,30,58,62],[14,30,58,67],[14,30,60,62],
 [14,30,60,67],[14,30,60,68],[14,30,62,67],
 [14,30,62,68],[14,35,36,37],[14,35,36,49],
 [14,35,36,55],[14,35,36,57],[14,35,36,60],
 [14,35,36,62],[14,35,36,68],[14,35,36,69],
 [14,35,37,47],[14,35,37,52],[14,35,37,56],
 [14,35,37,60],[14,35,37,62],[14,35,37,67],
 [14,35,37,68],[14,35,41,47],[14,35,41,49],
 [14,35,41,57],[14,35,41,59],[14,35,41,68],
 [14,35,47,49],[14,35,47,57],[14,35,47,59],
 [14,35,47,62],[14,35,47,68],[14,35,47,69],
 [14,35,49,52],[14,35,49,55],[14,35,49,56],
 [14,35,49,59],[14,35,49,60],[14,35,49,67],
 [14,35,49,68],[14,35,52,57],[14,35,52,62],
 [14,35,52,69],[14,35,55,59],[14,35,55,60],
 [14,35,55,67],[14,35,55,68],[14,35,55,69],
 [14,35,56,57],[14,35,56,59],[14,35,56,62],
 [14,35,56,68],[14,35,56,69],[14,35,57,59],
 [14,35,57,60],[14,35,57,67],[14,35,57,68],
 [14,35,59,60],[14,35,59,67],[14,35,59,68],
 [14,35,59,69],[14,35,60,62],[14,35,60,68],
 [14,35,60,69],[14,35,62,67],[14,35,62,68],
 [14,35,67,68],[14,35,67,69],[14,35,68,69],
 [14,36,37,43],[14,36,37,45],[14,36,37,50],
 [14,36,37,54],[14,36,37,60],[14,36,37,61],
 [14,36,37,62],[14,36,37,68],[14,36,43,45],
 [14,36,43,49],[14,36,43,53],[14,36,43,57],
 [14,36,43,62],[14,36,43,66],[14,36,43,68],
 [14,36,43,69],[14,36,45,50],[14,36,45,53],
 [14,36,45,54],[14,36,45,57],[14,36,45,60],
 [14,36,45,61],[14,36,45,62],[14,36,45,68],
 [14,36,45,69],[14,36,49,50],[14,36,49,53],
 [14,36,49,54],[14,36,49,55],[14,36,49,57],
 [14,36,49,60],[14,36,49,61],[14,36,49,66],
 [14,36,50,53],[14,36,50,55],[14,36,50,60],
 [14,36,50,61],[14,36,50,62],[14,36,50,66],
 [14,36,50,68],[14,36,50,69],[14,36,53,54],
 [14,36,53,62],[14,36,54,57],[14,36,54,61],
 [14,36,54,62],[14,36,54,68],[14,36,54,69],
 [14,36,55,60],[14,36,55,61],[14,36,55,62],
 [14,36,55,66],[14,36,55,69],[14,36,57,60],
 [14,36,57,61],[14,36,60,62],[14,36,60,66],
 [14,36,60,68],[14,36,60,69],[14,36,61,62],
 [14,36,61,66],[14,36,61,68],[14,36,61,69],
 [14,36,62,66],[14,36,62,68],[14,36,62,69],
 [14,36,66,69],[14,37,39,43],[14,37,39,44],
 [14,37,39,45],[14,37,39,47],[14,37,39,58],
 [14,37,39,60],[14,37,39,67],[14,37,43,44],
 [14,37,43,45],[14,37,43,52],[14,37,43,56],
 [14,37,43,58],[14,37,43,60],[14,37,43,61],
 [14,37,43,67],[14,37,43,68],[14,37,44,47],
 [14,37,44,50],[14,37,44,52],[14,37,44,54],
 [14,37,44,56],[14,37,44,58],[14,37,44,60],
 [14,37,44,61],[14,37,44,67],[14,37,45,47],
 [14,37,45,50],[14,37,45,52],[14,37,45,54],
 [14,37,45,58],[14,37,45,60],[14,37,45,62],
 [14,37,45,67],[14,37,45,68],[14,37,47,50],
 [14,37,47,54],[14,37,47,56],[14,37,47,58],
 [14,37,47,61],[14,37,47,62],[14,37,50,52],
 [14,37,50,56],[14,37,50,60],[14,37,50,61],
 [14,37,50,62],[14,37,50,67],[14,37,50,68],
 [14,37,52,54],[14,37,52,61],[14,37,52,62],
 [14,37,54,56],[14,37,54,58],[14,37,54,60],
 [14,37,54,61],[14,37,54,67],[14,37,54,68],
 [14,37,56,61],[14,37,56,62],[14,37,58,60],
 [14,37,58,61],[14,37,58,62],[14,37,58,67],
 [14,37,60,61],[14,37,60,62],[14,37,60,67],
 [14,37,60,68],[14,37,61,67],[14,37,61,68],
 [14,37,62,67],[14,37,62,68],[14,39,41,44],
 [14,39,41,45],[14,39,41,47],[14,39,41,49],
 [14,39,41,55],[14,39,41,58],[14,39,41,59],
 [14,39,41,60],[14,39,41,62],[14,39,41,66],
 [14,39,41,68],[14,39,43,44],[14,39,43,45],
 [14,39,43,49],[14,39,43,52],[14,39,43,53],
 [14,39,43,55],[14,39,43,58],[14,39,43,59],
 [14,39,43,60],[14,39,43,62],[14,39,43,66],
 [14,39,43,67],[14,39,43,68],[14,39,43,69],
 [14,39,44,45],[14,39,44,47],[14,39,44,49],
 [14,39,44,53],[14,39,44,55],[14,39,44,58],
 [14,39,44,59],[14,39,44,60],[14,39,44,66],
 [14,39,44,67],[14,39,44,68],[14,39,44,69],
 [14,39,45,47],[14,39,45,55],[14,39,45,58],
 [14,39,45,59],[14,39,45,60],[14,39,45,62],
 [14,39,45,66],[14,39,45,67],[14,39,45,68],
 [14,39,45,69],[14,39,47,49],[14,39,47,53],
 [14,39,47,55],[14,39,47,58],[14,39,47,59],
 [14,39,47,62],[14,39,47,68],[14,39,47,69],
 [14,39,49,52],[14,39,49,53],[14,39,49,55],
 [14,39,49,59],[14,39,49,60],[14,39,49,66],
 [14,39,49,67],[14,39,49,68],[14,39,52,53],
 [14,39,52,62],[14,39,52,67],[14,39,53,58],
 [14,39,53,60],[14,39,53,62],[14,39,53,67],
 [14,39,55,58],[14,39,55,59],[14,39,55,60],
 [14,39,55,62],[14,39,55,66],[14,39,55,67],
 [14,39,55,68],[14,39,55,69],[14,39,58,60],
 [14,39,58,62],[14,39,58,67],[14,39,58,68],
 [14,39,58,69],[14,39,59,60],[14,39,59,67],
 [14,39,59,68],[14,39,59,69],[14,39,60,62],
 [14,39,60,66],[14,39,60,67],[14,39,60,68],
 [14,39,60,69],[14,39,62,66],[14,39,62,67],
 [14,39,62,68],[14,39,62,69],[14,39,66,67],
 [14,39,66,68],[14,39,66,69],[14,39,67,68],
 [14,39,67,69],[14,39,68,69],[14,41,44,45],
 [14,41,44,47],[14,41,44,49],[14,41,44,50],
 [14,41,44,53],[14,41,44,54],[14,41,44,55],
 [14,41,44,56],[14,41,44,57],[14,41,44,58],
 [14,41,44,59],[14,41,44,60],[14,41,44,61],
 [14,41,44,66],[14,41,44,68],[14,41,45,47],
 [14,41,45,50],[14,41,45,53],[14,41,45,55],
 [14,41,45,58],[14,41,45,59],[14,41,45,60],
 [14,41,45,61],[14,41,45,62],[14,41,45,66],
 [14,41,45,68],[14,41,47,49],[14,41,47,50],
 [14,41,47,53],[14,41,47,54],[14,41,47,55],
 [14,41,47,56],[14,41,47,57],[14,41,47,58],
 [14,41,47,59],[14,41,47,61],[14,41,47,62],
 [14,41,47,68],[14,41,49,50],[14,41,49,53],
 [14,41,49,54],[14,41,49,55],[14,41,49,56],
 [14,41,49,57],[14,41,49,59],[14,41,49,60],
 [14,41,49,61],[14,41,49,66],[14,41,49,68],
 [14,41,50,53],[14,41,50,56],[14,41,50,59],
 [14,41,50,60],[14,41,50,61],[14,41,50,62],
 [14,41,50,66],[14,41,50,68],[14,41,53,54],
 [14,41,53,60],[14,41,53,62],[14,41,53,68],
 [14,41,54,56],[14,41,54,57],[14,41,54,59],
 [14,41,54,61],[14,41,54,68],[14,41,55,58],
 [14,41,55,59],[14,41,55,60],[14,41,55,61],
 [14,41,55,62],[14,41,55,66],[14,41,55,68],
 [14,41,56,57],[14,41,56,59],[14,41,56,61],
 [14,41,56,62],[14,41,56,68],[14,41,57,59],
 [14,41,57,60],[14,41,57,61],[14,41,57,68],
 [14,41,58,60],[14,41,58,61],[14,41,58,62],
 [14,41,58,68],[14,41,59,60],[14,41,59,61],
 [14,41,59,68],[14,41,60,61],[14,41,60,62],
 [14,41,60,66],[14,41,60,68],[14,41,61,62],
 [14,41,61,66],[14,41,61,68],[14,41,62,66],
 [14,41,62,68],[14,41,66,68],[14,43,44,45],
 [14,43,44,49],[14,43,44,53],[14,43,44,55],
 [14,43,44,57],[14,43,44,58],[14,43,44,59],
 [14,43,44,60],[14,43,44,61],[14,43,44,66],
 [14,43,44,67],[14,43,44,68],[14,43,44,69],
 [14,43,45,55],[14,43,45,57],[14,43,45,58],
 [14,43,45,59],[14,43,45,60],[14,43,45,61],
 [14,43,45,62],[14,43,45,66],[14,43,45,67],
 [14,43,45,68],[14,43,45,69],[14,43,49,52],
 [14,43,49,53],[14,43,49,55],[14,43,49,56],
 [14,43,49,59],[14,43,49,60],[14,43,49,61],
 [14,43,49,66],[14,43,49,67],[14,43,49,68],
 [14,43,52,53],[14,43,52,57],[14,43,52,61],
 [14,43,52,66],[14,43,52,67],[14,43,52,69],
 [14,43,53,56],[14,43,53,58],[14,43,53,60],
 [14,43,53,62],[14,43,53,67],[14,43,53,68],
 [14,43,55,58],[14,43,55,59],[14,43,55,60],
 [14,43,55,61],[14,43,55,62],[14,43,55,66],
 [14,43,55,67],[14,43,55,68],[14,43,55,69],
 [14,43,56,57],[14,43,56,62],[14,43,56,68],
 [14,43,56,69],[14,43,57,58],[14,43,57,59],
 [14,43,57,60],[14,43,57,61],[14,43,57,67],
 [14,43,57,68],[14,43,58,60],[14,43,58,61],
 [14,43,58,62],[14,43,58,67],[14,43,58,68],
 [14,43,58,69],[14,43,59,60],[14,43,59,61],
 [14,43,59,67],[14,43,59,68],[14,43,59,69],
 [14,43,60,61],[14,43,60,62],[14,43,60,66],
 [14,43,60,67],[14,43,60,68],[14,43,60,69],
 [14,43,61,62],[14,43,61,66],[14,43,61,67],
 [14,43,61,68],[14,43,61,69],[14,43,62,66],
 [14,43,62,67],[14,43,62,68],[14,43,62,69],
 [14,43,66,67],[14,43,66,68],[14,43,66,69],
 [14,43,67,68],[14,43,67,69],[14,43,68,69],
 [14,44,45,47],[14,44,45,50],[14,44,45,52],
 [14,44,45,54],[14,44,45,55],[14,44,45,58],
 [14,44,45,59],[14,44,45,60],[14,44,45,61],
 [14,44,45,66],[14,44,45,67],[14,44,45,68],
 [14,44,45,69],[14,44,47,49],[14,44,47,50],
 [14,44,47,53],[14,44,47,54],[14,44,47,55],
 [14,44,47,56],[14,44,47,57],[14,44,47,58],
 [14,44,47,59],[14,44,47,61],[14,44,47,68],
 [14,44,47,69],[14,44,49,50],[14,44,49,52],
 [14,44,49,53],[14,44,49,54],[14,44,49,55],
 [14,44,49,56],[14,44,49,57],[14,44,49,59],
 [14,44,49,60],[14,44,49,61],[14,44,49,66],
 [14,44,49,67],[14,44,49,68],[14,44,50,52],
 [14,44,50,53],[14,44,50,55],[14,44,50,56],
 [14,44,50,59],[14,44,50,60],[14,44,50,61],
 [14,44,50,66],[14,44,50,67],[14,44,50,68],
 [14,44,50,69],[14,44,52,53],[14,44,52,57],
 [14,44,52,61],[14,44,52,66],[14,44,52,67],
 [14,44,52,69],[14,44,53,54],[14,44,53,56],
 [14,44,53,58],[14,44,53,60],[14,44,53,67],
 [14,44,53,68],[14,44,54,56],[14,44,54,57],
 [14,44,54,59],[14,44,54,61],[14,44,54,67],
 [14,44,54,68],[14,44,55,58],[14,44,55,59],
 [14,44,55,60],[14,44,55,61],[14,44,55,66],
 [14,44,55,67],[14,44,55,68],[14,44,55,69],
 [14,44,56,57],[14,44,56,59],[14,44,56,61],
 [14,44,56,68],[14,44,56,69],[14,44,57,58],
 [14,44,57,59],[14,44,57,60],[14,44,57,61],
 [14,44,57,67],[14,44,57,68],[14,44,58,60],
 [14,44,58,61],[14,44,58,67],[14,44,58,68],
 [14,44,58,69],[14,44,59,60],[14,44,59,61],
 [14,44,59,67],[14,44,59,68],[14,44,59,69],
 [14,44,60,61],[14,44,60,66],[14,44,60,67],
 [14,44,60,68],[14,44,60,69],[14,44,61,66],
 [14,44,61,67],[14,44,61,68],[14,44,61,69],
 [14,44,66,67],[14,44,66,68],[14,44,66,69],
 [14,44,67,68],[14,44,67,69],[14,44,68,69],
 [14,45,47,50],[14,45,47,53],[14,45,47,55],
 [14,45,47,57],[14,45,47,58],[14,45,47,59],
 [14,45,47,61],[14,45,47,62],[14,45,47,68],
 [14,45,47,69],[14,45,50,52],[14,45,50,53],
 [14,45,50,55],[14,45,50,59],[14,45,50,60],
 [14,45,50,61],[14,45,50,62],[14,45,50,66],
 [14,45,50,67],[14,45,50,68],[14,45,50,69],
 [14,45,52,53],[14,45,52,54],[14,45,52,57],
 [14,45,52,61],[14,45,52,62],[14,45,52,66],
 [14,45,52,67],[14,45,52,69],[14,45,53,58],
 [14,45,53,60],[14,45,53,62],[14,45,53,67],
 [14,45,53,68],[14,45,54,58],[14,45,54,60],
 [14,45,54,62],[14,45,54,67],[14,45,54,68],
 [14,45,54,69],[14,45,55,58],[14,45,55,59],
 [14,45,55,60],[14,45,55,61],[14,45,55,62],
 [14,45,55,66],[14,45,55,67],[14,45,55,68],
 [14,45,55,69],[14,45,57,58],[14,45,57,59],
 [14,45,57,60],[14,45,57,67],[14,45,58,60],
 [14,45,58,61],[14,45,58,62],[14,45,58,67],
 [14,45,58,68],[14,45,58,69],[14,45,59,60],
 [14,45,59,61],[14,45,59,67],[14,45,59,68],
 [14,45,59,69],[14,45,60,61],[14,45,60,62],
 [14,45,60,66],[14,45,60,67],[14,45,60,68],
 [14,45,60,69],[14,45,61,62],[14,45,61,66],
 [14,45,61,67],[14,45,61,68],[14,45,61,69],
 [14,45,62,66],[14,45,62,67],[14,45,62,68],
 [14,45,62,69],[14,45,66,67],[14,45,66,68],
 [14,45,66,69],[14,45,67,68],[14,45,67,69],
 [14,45,68,69],[14,47,49,50],[14,47,49,53],
 [14,47,49,54],[14,47,49,55],[14,47,49,56],
 [14,47,49,57],[14,47,49,59],[14,47,49,61],
 [14,47,49,68],[14,47,50,53],[14,47,50,55],
 [14,47,50,56],[14,47,50,59],[14,47,50,61],
 [14,47,50,62],[14,47,50,68],[14,47,50,69],
 [14,47,53,54],[14,47,53,56],[14,47,53,58],
 [14,47,53,62],[14,47,53,68],[14,47,54,56],
 [14,47,54,57],[14,47,54,59],[14,47,54,61],
 [14,47,54,62],[14,47,54,68],[14,47,54,69],
 [14,47,55,58],[14,47,55,59],[14,47,55,61],
 [14,47,55,62],[14,47,55,68],[14,47,55,69],
 [14,47,56,57],[14,47,56,59],[14,47,56,61],
 [14,47,56,62],[14,47,56,68],[14,47,56,69],
 [14,47,57,58],[14,47,57,59],[14,47,57,61],
 [14,47,57,68],[14,47,58,61],[14,47,58,62],
 [14,47,58,68],[14,47,58,69],[14,47,59,61],
 [14,47,59,68],[14,47,59,69],[14,47,61,62],
 [14,47,61,68],[14,47,61,69],[14,47,62,68],
 [14,47,62,69],[14,47,68,69],[14,49,50,52],
 [14,49,50,53],[14,49,50,56],[14,49,50,59],
 [14,49,50,60],[14,49,50,61],[14,49,50,66],
 [14,49,50,67],[14,49,50,68],[14,49,52,53],
 [14,49,52,54],[14,49,52,57],[14,49,52,61],
 [14,49,52,66],[14,49,52,67],[14,49,53,56],
 [14,49,53,60],[14,49,53,67],[14,49,53,68],
 [14,49,54,56],[14,49,54,57],[14,49,54,59],
 [14,49,54,60],[14,49,54,61],[14,49,54,67],
 [14,49,54,68],[14,49,55,59],[14,49,55,60],
 [14,49,55,61],[14,49,55,66],[14,49,55,67],
 [14,49,55,68],[14,49,56,57],[14,49,56,59],
 [14,49,56,61],[14,49,56,66],[14,49,56,68],
 [14,49,57,59],[14,49,57,60],[14,49,57,61],
 [14,49,57,67],[14,49,57,68],[14,49,59,60],
 [14,49,59,61],[14,49,59,67],[14,49,59,68],
 [14,49,60,61],[14,49,60,66],[14,49,60,67],
 [14,49,60,68],[14,49,61,66],[14,49,61,67],
 [14,49,61,68],[14,49,66,67],[14,49,66,68],
 [14,49,67,68],[14,50,52,53],[14,50,52,61],
 [14,50,52,62],[14,50,52,66],[14,50,52,67],
 [14,50,52,69],[14,50,53,56],[14,50,53,60],
 [14,50,53,62],[14,50,53,67],[14,50,53,68],
 [14,50,55,60],[14,50,55,61],[14,50,55,62],
 [14,50,55,67],[14,50,55,68],[14,50,55,69],
 [14,50,56,59],[14,50,56,61],[14,50,56,62],
 [14,50,56,66],[14,50,56,69],[14,50,59,60],
 [14,50,59,61],[14,50,59,67],[14,50,59,68],
 [14,50,60,61],[14,50,60,62],[14,50,60,66],
 [14,50,60,67],[14,50,60,68],[14,50,60,69],
 [14,50,61,62],[14,50,61,66],[14,50,61,67],
 [14,50,61,68],[14,50,61,69],[14,50,62,66],
 [14,50,62,67],[14,50,62,68],[14,50,62,69],
 [14,50,66,67],[14,50,66,68],[14,50,66,69],
 [14,50,67,68],[14,50,67,69],[14,50,68,69],
 [14,52,53,54],[14,52,53,62],[14,52,53,67],
 [14,52,54,57],[14,52,54,61],[14,52,54,62],
 [14,52,54,67],[14,52,54,69],[14,52,57,61],
 [14,52,61,62],[14,52,61,69],[14,52,62,66],
 [14,52,62,67],[14,52,62,69],[14,52,66,69],
 [14,53,54,56],[14,53,54,58],[14,53,54,60],
 [14,53,54,62],[14,53,54,67],[14,53,54,68],
 [14,53,56,62],[14,53,58,60],[14,53,58,62],
 [14,53,60,62],[14,53,60,68],[14,53,62,67],
 [14,53,62,68],[14,54,56,57],[14,54,56,59],
 [14,54,56,61],[14,54,56,62],[14,54,56,68],
 [14,54,56,69],[14,54,57,58],[14,54,57,59],
 [14,54,57,60],[14,54,57,61],[14,54,57,67],
 [14,54,57,68],[14,54,58,60],[14,54,58,61],
 [14,54,58,62],[14,54,58,67],[14,54,58,68],
 [14,54,58,69],[14,54,59,60],[14,54,59,61],
 [14,54,59,67],[14,54,59,68],[14,54,59,69],
 [14,54,60,61],[14,54,60,62],[14,54,60,67],
 [14,54,60,68],[14,54,60,69],[14,54,61,62],
 [14,54,61,67],[14,54,61,68],[14,54,61,69],
 [14,54,62,67],[14,54,62,68],[14,54,62,69],
 [14,54,67,68],[14,54,67,69],[14,54,68,69],
 [14,55,58,60],[14,55,58,61],[14,55,58,62],
 [14,55,58,67],[14,55,58,68],[14,55,58,69],
 [14,55,59,60],[14,55,59,61],[14,55,59,67],
 [14,55,59,68],[14,55,59,69],[14,55,60,61],
 [14,55,60,62],[14,55,60,66],[14,55,60,67],
 [14,55,60,68],[14,55,60,69],[14,55,61,62],
 [14,55,61,66],[14,55,61,67],[14,55,61,68],
 [14,55,61,69],[14,55,62,66],[14,55,62,67],
 [14,55,62,68],[14,55,62,69],[14,55,66,67],
 [14,55,66,68],[14,55,66,69],[14,55,67,68],
 [14,55,67,69],[14,55,68,69],[14,56,57,59],
 [14,56,57,61],[14,56,57,68],[14,56,59,61],
 [14,56,59,68],[14,56,61,62],[14,56,61,68],
 [14,56,61,69],[14,56,62,66],[14,56,62,69],
 [14,56,66,69],[14,57,58,60],[14,57,58,61],
 [14,57,58,67],[14,57,59,60],[14,57,59,61],
 [14,57,59,68],[14,57,60,61],[14,57,60,67],
 [14,57,61,67],[14,57,61,68],[14,58,60,61],
 [14,58,60,62],[14,58,60,67],[14,58,60,68],
 [14,58,60,69],[14,58,61,62],[14,58,61,67],
 [14,58,61,68],[14,58,61,69],[14,58,62,67],
 [14,58,62,68],[14,58,62,69],[14,58,67,68],
 [14,58,67,69],[14,58,68,69],[14,59,60,61],
 [14,59,60,67],[14,59,60,68],[14,59,60,69],
 [14,59,61,67],[14,59,61,68],[14,59,61,69],
 [14,59,67,68],[14,59,67,69],[14,59,68,69],
 [14,60,61,62],[14,60,61,66],[14,60,61,67],
 [14,60,61,68],[14,60,61,69],[14,60,62,66],
 [14,60,62,67],[14,60,62,68],[14,60,62,69],
 [14,60,66,67],[14,60,66,68],[14,60,66,69],
 [14,60,67,68],[14,60,67,69],[14,60,68,69],
 [14,61,62,66],[14,61,62,67],[14,61,62,68],
 [14,61,62,69],[14,61,66,67],[14,61,66,68],
 [14,61,66,69],[14,61,67,68],[14,61,67,69],
 [14,61,68,69],[14,62,66,67],[14,62,66,68],
 [14,62,66,69],[14,62,67,68],[14,62,67,69],
 [14,62,68,69],[14,66,67,68],[14,66,67,69],
 [14,66,68,69],[14,67,68,69],[15,16,19,20],
 [15,16,19,21],[15,16,19,22],[15,16,19,23],
 [15,16,19,24],[15,16,19,25],[15,16,19,26],
 [15,16,19,27],[15,16,19,34],[15,16,19,39],
 [15,16,19,41],[15,16,19,43],[15,16,19,44],
 [15,16,19,45],[15,16,19,46],[15,16,19,47],
 [15,16,19,48],[15,16,19,49],[15,16,19,55],
 [15,16,19,58],[15,16,19,59],[15,16,19,60],
 [15,16,19,61],[15,16,19,62],[15,16,19,66],
 [15,16,19,67],[15,16,19,68],[15,16,19,69],
 [15,16,20,21],[15,16,20,22],[15,16,20,23],
 [15,16,20,24],[15,16,20,25],[15,16,20,26],
 [15,16,20,27],[15,16,20,34],[15,16,20,36],
 [15,16,20,38],[15,16,20,39],[15,16,20,40],
 [15,16,20,41],[15,16,20,42],[15,16,20,43],
 [15,16,20,44],[15,16,20,45],[15,16,20,46],
 [15,16,20,47],[15,16,20,48],[15,16,20,49],
 [15,16,20,55],[15,16,20,58],[15,16,20,59],
 [15,16,20,60],[15,16,20,61],[15,16,20,62],
 [15,16,20,66],[15,16,20,67],[15,16,20,68],
 [15,16,20,69],[15,16,21,22],[15,16,21,23],
 [15,16,21,24],[15,16,21,25],[15,16,21,26],
 [15,16,21,27],[15,16,21,34],[15,16,21,36],
 [15,16,21,39],[15,16,21,41],[15,16,21,43],
 [15,16,21,44],[15,16,21,45],[15,16,21,46],
 [15,16,21,47],[15,16,21,48],[15,16,21,49],
 [15,16,21,55],[15,16,21,58],[15,16,21,59],
 [15,16,21,60],[15,16,21,61],[15,16,21,62],
 [15,16,21,66],[15,16,21,67],[15,16,21,68],
 [15,16,21,69],[15,16,22,23],[15,16,22,24],
 [15,16,22,25],[15,16,22,26],[15,16,22,27],
 [15,16,22,34],[15,16,22,36],[15,16,22,38],
 [15,16,22,39],[15,16,22,40],[15,16,22,41],
 [15,16,22,42],[15,16,22,43],[15,16,22,44],
 [15,16,22,45],[15,16,22,46],[15,16,22,47],
 [15,16,22,48],[15,16,22,49],[15,16,22,55],
 [15,16,22,58],[15,16,22,59],[15,16,22,60],
 [15,16,22,61],[15,16,22,62],[15,16,22,66],
 [15,16,22,67],[15,16,22,68],[15,16,22,69],
 [15,16,23,24],[15,16,23,25],[15,16,23,26],
 [15,16,23,27],[15,16,23,34],[15,16,23,39],
 [15,16,23,41],[15,16,23,42],[15,16,23,43],
 [15,16,23,44],[15,16,23,45],[15,16,23,46],
 [15,16,23,47],[15,16,23,48],[15,16,23,49],
 [15,16,23,55],[15,16,23,58],[15,16,23,59],
 [15,16,23,60],[15,16,23,61],[15,16,23,62],
 [15,16,23,66],[15,16,23,67],[15,16,23,68],
 [15,16,23,69],[15,16,24,25],[15,16,24,26],
 [15,16,24,27],[15,16,24,34],[15,16,24,36],
 [15,16,24,38],[15,16,24,39],[15,16,24,40],
 [15,16,24,41],[15,16,24,42],[15,16,24,43],
 [15,16,24,44],[15,16,24,45],[15,16,24,46],
 [15,16,24,47],[15,16,24,48],[15,16,24,49],
 [15,16,24,51],[15,16,24,55],[15,16,24,58],
 [15,16,24,59],[15,16,24,60],[15,16,24,61],
 [15,16,24,62],[15,16,24,66],[15,16,24,67],
 [15,16,24,68],[15,16,24,69],[15,16,25,26],
 [15,16,25,27],[15,16,25,34],[15,16,25,39],
 [15,16,25,40],[15,16,25,41],[15,16,25,43],
 [15,16,25,44],[15,16,25,45],[15,16,25,46],
 [15,16,25,47],[15,16,25,48],[15,16,25,49],
 [15,16,25,51],[15,16,25,55],[15,16,25,58],
 [15,16,25,59],[15,16,25,60],[15,16,25,61],
 [15,16,25,62],[15,16,25,66],[15,16,25,67],
 [15,16,25,68],[15,16,25,69],[15,16,26,27],
 [15,16,26,34],[15,16,26,38],[15,16,26,39],
 [15,16,26,40],[15,16,26,41],[15,16,26,42],
 [15,16,26,43],[15,16,26,44],[15,16,26,45],
 [15,16,26,46],[15,16,26,47],[15,16,26,48],
 [15,16,26,49],[15,16,26,51],[15,16,26,55],
 [15,16,26,58],[15,16,26,59],[15,16,26,60],
 [15,16,26,61],[15,16,26,62],[15,16,26,66],
 [15,16,26,67],[15,16,26,68],[15,16,26,69],
 [15,16,27,34],[15,16,27,36],[15,16,27,39],
 [15,16,27,41],[15,16,27,42],[15,16,27,43],
 [15,16,27,44],[15,16,27,45],[15,16,27,46],
 [15,16,27,47],[15,16,27,48],[15,16,27,49],
 [15,16,27,51],[15,16,27,55],[15,16,27,58],
 [15,16,27,59],[15,16,27,60],[15,16,27,61],
 [15,16,27,62],[15,16,27,66],[15,16,27,67],
 [15,16,27,68],[15,16,27,69],[15,16,34,36],
 [15,16,34,39],[15,16,34,41],[15,16,34,43],
 [15,16,34,44],[15,16,34,45],[15,16,34,46],
 [15,16,34,47],[15,16,34,48],[15,16,34,49],
 [15,16,34,55],[15,16,34,58],[15,16,34,59],
 [15,16,34,60],[15,16,34,61],[15,16,34,62],
 [15,16,34,66],[15,16,34,67],[15,16,34,68],
 [15,16,34,69],[15,16,36,46],[15,16,36,48],
 [15,16,36,49],[15,16,36,51],[15,16,36,55],
 [15,16,36,61],[15,16,36,62],[15,16,36,66],
 [15,16,36,68],[15,16,36,69],[15,16,38,40],
 [15,16,38,42],[15,16,38,45],[15,16,38,49],
 [15,16,38,55],[15,16,38,60],[15,16,38,61],
 [15,16,38,67],[15,16,39,41],[15,16,39,43],
 [15,16,39,44],[15,16,39,45],[15,16,39,46],
 [15,16,39,47],[15,16,39,48],[15,16,39,49],
 [15,16,39,55],[15,16,39,58],[15,16,39,59],
 [15,16,39,60],[15,16,39,61],[15,16,39,62],
 [15,16,39,66],[15,16,39,67],[15,16,39,68],
 [15,16,39,69],[15,16,40,42],[15,16,40,44],
 [15,16,40,47],[15,16,40,48],[15,16,40,49],
 [15,16,40,55],[15,16,40,61],[15,16,40,69],
 [15,16,41,43],[15,16,41,44],[15,16,41,45],
 [15,16,41,46],[15,16,41,47],[15,16,41,48],
 [15,16,41,49],[15,16,41,55],[15,16,41,58],
 [15,16,41,59],[15,16,41,60],[15,16,41,61],
 [15,16,41,62],[15,16,41,66],[15,16,41,67],
 [15,16,41,68],[15,16,41,69],[15,16,42,44],
 [15,16,42,46],[15,16,42,49],[15,16,42,55],
 [15,16,42,59],[15,16,42,61],[15,16,42,62],
 [15,16,42,68],[15,16,43,44],[15,16,43,45],
 [15,16,43,46],[15,16,43,47],[15,16,43,48],
 [15,16,43,49],[15,16,43,55],[15,16,43,58],
 [15,16,43,59],[15,16,43,60],[15,16,43,61],
 [15,16,43,62],[15,16,43,66],[15,16,43,67],
 [15,16,43,68],[15,16,43,69],[15,16,44,45],
 [15,16,44,46],[15,16,44,47],[15,16,44,48],
 [15,16,44,49],[15,16,44,55],[15,16,44,58],
 [15,16,44,59],[15,16,44,60],[15,16,44,61],
 [15,16,44,62],[15,16,44,66],[15,16,44,67],
 [15,16,44,68],[15,16,44,69],[15,16,45,46],
 [15,16,45,47],[15,16,45,48],[15,16,45,49],
 [15,16,45,51],[15,16,45,55],[15,16,45,58],
 [15,16,45,59],[15,16,45,60],[15,16,45,61],
 [15,16,45,62],[15,16,45,66],[15,16,45,67],
 [15,16,45,68],[15,16,45,69],[15,16,46,47],
 [15,16,46,48],[15,16,46,49],[15,16,46,55],
 [15,16,46,58],[15,16,46,59],[15,16,46,60],
 [15,16,46,61],[15,16,46,62],[15,16,46,66],
 [15,16,46,67],[15,16,46,68],[15,16,46,69],
 [15,16,47,48],[15,16,47,49],[15,16,47,51],
 [15,16,47,55],[15,16,47,58],[15,16,47,59],
 [15,16,47,60],[15,16,47,61],[15,16,47,62],
 [15,16,47,66],[15,16,47,67],[15,16,47,68],
 [15,16,47,69],[15,16,48,49],[15,16,48,51],
 [15,16,48,55],[15,16,48,58],[15,16,48,59],
 [15,16,48,60],[15,16,48,61],[15,16,48,62],
 [15,16,48,66],[15,16,48,67],[15,16,48,68],
 [15,16,48,69],[15,16,49,55],[15,16,49,58],
 [15,16,49,59],[15,16,49,60],[15,16,49,61],
 [15,16,49,62],[15,16,49,66],[15,16,49,67],
 [15,16,49,68],[15,16,49,69],[15,16,51,55],
 [15,16,51,58],[15,16,51,59],[15,16,51,60],
 [15,16,51,61],[15,16,51,62],[15,16,51,66],
 [15,16,51,67],[15,16,51,68],[15,16,55,58],
 [15,16,55,59],[15,16,55,60],[15,16,55,61],
 [15,16,55,62],[15,16,55,66],[15,16,55,67],
 [15,16,55,68],[15,16,55,69],[15,16,58,59],
 [15,16,58,60],[15,16,58,61],[15,16,58,62],
 [15,16,58,66],[15,16,58,67],[15,16,58,68],
 [15,16,58,69],[15,16,59,60],[15,16,59,61],
 [15,16,59,62],[15,16,59,66],[15,16,59,67],
 [15,16,59,68],[15,16,59,69],[15,16,60,61],
 [15,16,60,62],[15,16,60,66],[15,16,60,67],
 [15,16,60,68],[15,16,60,69],[15,16,61,62],
 [15,16,61,66],[15,16,61,67],[15,16,61,68],
 [15,16,61,69],[15,16,62,66],[15,16,62,67],
 [15,16,62,68],[15,16,62,69],[15,16,66,67],
 [15,16,66,68],[15,16,66,69],[15,16,67,68],
 [15,16,67,69],[15,16,68,69],[15,17,18,20],
 [15,17,18,22],[15,17,18,23],[15,17,18,24],
 [15,17,18,26],[15,17,18,41],[15,17,18,44],
 [15,17,18,46],[15,17,18,47],[15,17,18,48],
 [15,17,18,49],[15,17,18,51],[15,17,18,54],
 [15,17,18,56],[15,17,18,57],[15,17,18,59],
 [15,17,18,61],[15,17,18,68],[15,17,19,22],
 [15,17,19,23],[15,17,19,24],[15,17,19,26],
 [15,17,19,27],[15,17,19,34],[15,17,19,37],
 [15,17,19,46],[15,17,19,48],[15,17,19,49],
 [15,17,19,56],[15,17,19,59],[15,17,19,62],
 [15,17,19,66],[15,17,19,68],[15,17,19,69],
 [15,17,20,22],[15,17,20,23],[15,17,20,24],
 [15,17,20,26],[15,17,20,27],[15,17,20,37],
 [15,17,20,41],[15,17,20,44],[15,17,20,47],
 [15,17,20,48],[15,17,20,49],[15,17,20,53],
 [15,17,20,54],[15,17,20,56],[15,17,20,57],
 [15,17,20,59],[15,17,20,61],[15,17,20,62],
 [15,17,20,66],[15,17,20,68],[15,17,20,69],
 [15,17,22,24],[15,17,22,26],[15,17,22,37],
 [15,17,22,41],[15,17,22,44],[15,17,22,46],
 [15,17,22,47],[15,17,22,48],[15,17,22,49],
 [15,17,22,54],[15,17,22,56],[15,17,22,57],
 [15,17,22,59],[15,17,22,61],[15,17,22,62],
 [15,17,22,68],[15,17,23,24],[15,17,23,26],
 [15,17,23,27],[15,17,23,34],[15,17,23,37],
 [15,17,23,46],[15,17,23,48],[15,17,23,49],
 [15,17,23,53],[15,17,23,56],[15,17,23,57],
 [15,17,23,59],[15,17,23,61],[15,17,23,62],
 [15,17,23,66],[15,17,23,68],[15,17,23,69],
 [15,17,24,26],[15,17,24,27],[15,17,24,34],
 [15,17,24,37],[15,17,24,41],[15,17,24,44],
 [15,17,24,46],[15,17,24,47],[15,17,24,48],
 [15,17,24,49],[15,17,24,51],[15,17,24,54],
 [15,17,24,56],[15,17,24,57],[15,17,24,59],
 [15,17,24,61],[15,17,24,62],[15,17,24,66],
 [15,17,24,68],[15,17,24,69],[15,17,26,27],
 [15,17,26,34],[15,17,26,37],[15,17,26,41],
 [15,17,26,44],[15,17,26,46],[15,17,26,47],
 [15,17,26,48],[15,17,26,49],[15,17,26,51],
 [15,17,26,54],[15,17,26,56],[15,17,26,57],
 [15,17,26,59],[15,17,26,61],[15,17,26,62],
 [15,17,26,68],[15,17,26,69],[15,17,27,34],
 [15,17,27,41],[15,17,27,44],[15,17,27,46],
 [15,17,27,47],[15,17,27,48],[15,17,27,49],
 [15,17,27,51],[15,17,27,54],[15,17,27,56],
 [15,17,27,59],[15,17,27,61],[15,17,27,62],
 [15,17,27,66],[15,17,27,69],[15,17,34,41],
 [15,17,34,46],[15,17,34,48],[15,17,34,49],
 [15,17,34,56],[15,17,34,59],[15,17,34,61],
 [15,17,34,62],[15,17,34,66],[15,17,34,69],
 [15,17,37,44],[15,17,37,46],[15,17,37,47],
 [15,17,37,48],[15,17,37,54],[15,17,37,56],
 [15,17,37,59],[15,17,37,61],[15,17,41,44],
 [15,17,41,46],[15,17,41,47],[15,17,41,49],
 [15,17,41,53],[15,17,41,54],[15,17,41,56],
 [15,17,41,57],[15,17,41,59],[15,17,41,61],
 [15,17,41,66],[15,17,41,68],[15,17,41,69],
 [15,17,44,46],[15,17,44,47],[15,17,44,48],
 [15,17,44,49],[15,17,44,51],[15,17,44,53],
 [15,17,44,54],[15,17,44,56],[15,17,44,57],
 [15,17,44,59],[15,17,44,61],[15,17,44,62],
 [15,17,44,66],[15,17,44,68],[15,17,46,48],
 [15,17,46,49],[15,17,46,53],[15,17,46,56],
 [15,17,46,57],[15,17,46,59],[15,17,46,61],
 [15,17,46,62],[15,17,46,66],[15,17,46,68],
 [15,17,46,69],[15,17,47,49],[15,17,47,53],
 [15,17,47,54],[15,17,47,56],[15,17,47,57],
 [15,17,47,59],[15,17,47,61],[15,17,47,62],
 [15,17,47,68],[15,17,47,69],[15,17,48,49],
 [15,17,48,51],[15,17,48,53],[15,17,48,56],
 [15,17,48,57],[15,17,48,59],[15,17,48,61],
 [15,17,48,62],[15,17,48,66],[15,17,48,68],
 [15,17,48,69],[15,17,49,53],[15,17,49,54],
 [15,17,49,56],[15,17,49,57],[15,17,49,59],
 [15,17,49,61],[15,17,49,62],[15,17,49,66],
 [15,17,49,68],[15,17,49,69],[15,17,51,53],
 [15,17,51,56],[15,17,51,57],[15,17,51,59],
 [15,17,51,61],[15,17,51,62],[15,17,51,66],
 [15,17,51,68],[15,17,51,69],[15,17,53,54],
 [15,17,53,56],[15,17,53,68],[15,17,54,56],
 [15,17,54,57],[15,17,54,59],[15,17,54,61],
 [15,17,54,62],[15,17,54,68],[15,17,54,69],
 [15,17,56,57],[15,17,56,59],[15,17,56,61],
 [15,17,56,62],[15,17,56,66],[15,17,56,68],
 [15,17,56,69],[15,17,57,59],[15,17,57,61],
 [15,17,57,68],[15,17,59,61],[15,17,59,66],
 [15,17,59,68],[15,17,59,69],[15,17,61,62],
 [15,17,61,68],[15,17,61,69],[15,17,62,66],
 [15,17,62,69],[15,17,66,68],[15,17,66,69],
 [15,18,20,22],[15,18,20,23],[15,18,20,24],
 [15,18,20,25],[15,18,20,26],[15,18,20,36],
 [15,18,20,41],[15,18,20,43],[15,18,20,44],
 [15,18,20,46],[15,18,20,47],[15,18,20,49],
 [15,18,20,54],[15,18,20,56],[15,18,20,57],
 [15,18,20,59],[15,18,20,60],[15,18,20,61],
 [15,18,20,67],[15,18,20,68],[15,18,21,22],
 [15,18,21,23],[15,18,21,24],[15,18,21,25],
 [15,18,21,26],[15,18,21,36],[15,18,21,43],
 [15,18,21,44],[15,18,21,46],[15,18,21,47],
 [15,18,21,48],[15,18,21,57],[15,18,21,59],
 [15,18,21,60],[15,18,21,67],[15,18,22,23],
 [15,18,22,24],[15,18,22,25],[15,18,22,26],
 [15,18,22,41],[15,18,22,43],[15,18,22,44],
 [15,18,22,47],[15,18,22,48],[15,18,22,49],
 [15,18,22,54],[15,18,22,56],[15,18,22,57],
 [15,18,22,59],[15,18,22,60],[15,18,22,61],
 [15,18,22,68],[15,18,23,24],[15,18,23,25],
 [15,18,23,26],[15,18,23,36],[15,18,23,41],
 [15,18,23,43],[15,18,23,44],[15,18,23,46],
 [15,18,23,47],[15,18,23,48],[15,18,23,52],
 [15,18,23,56],[15,18,23,57],[15,18,23,60],
 [15,18,23,61],[15,18,23,67],[15,18,23,68],
 [15,18,24,25],[15,18,24,26],[15,18,24,36],
 [15,18,24,41],[15,18,24,44],[15,18,24,46],
 [15,18,24,47],[15,18,24,48],[15,18,24,49],
 [15,18,24,51],[15,18,24,52],[15,18,24,54],
 [15,18,24,56],[15,18,24,57],[15,18,24,59],
 [15,18,24,60],[15,18,24,61],[15,18,24,67],
 [15,18,24,68],[15,18,25,26],[15,18,25,41],
 [15,18,25,43],[15,18,25,44],[15,18,25,46],
 [15,18,25,47],[15,18,25,48],[15,18,25,49],
 [15,18,25,51],[15,18,25,54],[15,18,25,57],
 [15,18,25,59],[15,18,25,60],[15,18,25,61],
 [15,18,25,67],[15,18,26,36],[15,18,26,41],
 [15,18,26,43],[15,18,26,44],[15,18,26,46],
 [15,18,26,47],[15,18,26,48],[15,18,26,49],
 [15,18,26,51],[15,18,26,52],[15,18,26,54],
 [15,18,26,56],[15,18,26,57],[15,18,26,59],
 [15,18,26,60],[15,18,26,61],[15,18,26,67],
 [15,18,26,68],[15,18,36,46],[15,18,36,48],
 [15,18,36,49],[15,18,36,51],[15,18,36,54],
 [15,18,36,57],[15,18,36,59],[15,18,36,61],
 [15,18,41,44],[15,18,41,47],[15,18,41,48],
 [15,18,41,49],[15,18,41,54],[15,18,41,56],
 [15,18,41,57],[15,18,41,59],[15,18,41,61],
 [15,18,41,67],[15,18,41,68],[15,18,43,46],
 [15,18,43,47],[15,18,43,48],[15,18,43,49],
 [15,18,43,57],[15,18,43,60],[15,18,43,61],
 [15,18,43,67],[15,18,44,47],[15,18,44,48],
 [15,18,44,49],[15,18,44,51],[15,18,44,52],
 [15,18,44,54],[15,18,44,56],[15,18,44,57],
 [15,18,44,59],[15,18,44,60],[15,18,44,61],
 [15,18,44,68],[15,18,46,47],[15,18,46,48],
 [15,18,46,52],[15,18,46,56],[15,18,46,57],
 [15,18,46,59],[15,18,46,60],[15,18,46,61],
 [15,18,46,67],[15,18,46,68],[15,18,47,48],
 [15,18,47,49],[15,18,47,51],[15,18,47,52],
 [15,18,47,54],[15,18,47,56],[15,18,47,57],
 [15,18,47,59],[15,18,47,60],[15,18,47,61],
 [15,18,47,67],[15,18,47,68],[15,18,48,51],
 [15,18,48,52],[15,18,48,56],[15,18,48,57],
 [15,18,48,59],[15,18,48,60],[15,18,48,61],
 [15,18,48,67],[15,18,48,68],[15,18,49,52],
 [15,18,49,54],[15,18,49,56],[15,18,49,57],
 [15,18,49,59],[15,18,49,60],[15,18,49,61],
 [15,18,49,67],[15,18,49,68],[15,18,51,52],
 [15,18,51,56],[15,18,51,57],[15,18,51,59],
 [15,18,51,60],[15,18,51,61],[15,18,51,67],
 [15,18,51,68],[15,18,52,54],[15,18,52,57],
 [15,18,52,61],[15,18,52,67],[15,18,54,56],
 [15,18,54,57],[15,18,54,59],[15,18,54,60],
 [15,18,54,61],[15,18,54,67],[15,18,54,68],
 [15,18,56,57],[15,18,56,59],[15,18,56,61],
 [15,18,56,68],[15,18,57,59],[15,18,57,60],
 [15,18,57,61],[15,18,57,67],[15,18,57,68],
 [15,18,59,61],[15,18,59,67],[15,18,59,68],
 [15,18,60,61],[15,18,60,67],[15,18,61,67],
 [15,18,61,68],[15,19,20,21],[15,19,20,22],
 [15,19,20,23],[15,19,20,24],[15,19,20,25],
 [15,19,20,26],[15,19,20,27],[15,19,20,34],
 [15,19,20,36],[15,19,20,39],[15,19,20,41],
 [15,19,20,43],[15,19,20,44],[15,19,20,45],
 [15,19,20,46],[15,19,20,47],[15,19,20,48],
 [15,19,20,49],[15,19,20,52],[15,19,20,55],
 [15,19,20,56],[15,19,20,58],[15,19,20,59],
 [15,19,20,60],[15,19,20,61],[15,19,20,62],
 [15,19,20,64],[15,19,20,66],[15,19,20,67],
 [15,19,20,68],[15,19,20,69],[15,19,21,22],
 [15,19,21,23],[15,19,21,24],[15,19,21,25],
 [15,19,21,26],[15,19,21,27],[15,19,21,34],
 [15,19,21,37],[15,19,21,39],[15,19,21,41],
 [15,19,21,43],[15,19,21,44],[15,19,21,45],
 [15,19,21,46],[15,19,21,47],[15,19,21,48],
 [15,19,21,49],[15,19,21,55],[15,19,21,58],
 [15,19,21,59],[15,19,21,60],[15,19,21,61],
 [15,19,21,62],[15,19,21,65],[15,19,21,66],
 [15,19,21,67],[15,19,21,68],[15,19,21,69],
 [15,19,22,23],[15,19,22,24],[15,19,22,25],
 [15,19,22,26],[15,19,22,27],[15,19,22,34],
 [15,19,22,36],[15,19,22,37],[15,19,22,39],
 [15,19,22,41],[15,19,22,43],[15,19,22,44],
 [15,19,22,45],[15,19,22,46],[15,19,22,47],
 [15,19,22,48],[15,19,22,49],[15,19,22,55],
 [15,19,22,58],[15,19,22,59],[15,19,22,60],
 [15,19,22,61],[15,19,22,62],[15,19,22,65],
 [15,19,22,66],[15,19,22,67],[15,19,22,68],
 [15,19,22,69],[15,19,23,24],[15,19,23,25],
 [15,19,23,26],[15,19,23,27],[15,19,23,34],
 [15,19,23,36],[15,19,23,37],[15,19,23,39],
 [15,19,23,41],[15,19,23,43],[15,19,23,44],
 [15,19,23,45],[15,19,23,46],[15,19,23,47],
 [15,19,23,48],[15,19,23,49],[15,19,23,52],
 [15,19,23,55],[15,19,23,56],[15,19,23,58],
 [15,19,23,59],[15,19,23,60],[15,19,23,61],
 [15,19,23,62],[15,19,23,64],[15,19,23,66],
 [15,19,23,67],[15,19,23,68],[15,19,23,69],
 [15,19,24,25],[15,19,24,26],[15,19,24,27],
 [15,19,24,34],[15,19,24,36],[15,19,24,37],
 [15,19,24,39],[15,19,24,41],[15,19,24,43],
 [15,19,24,44],[15,19,24,45],[15,19,24,46],
 [15,19,24,47],[15,19,24,48],[15,19,24,49],
 [15,19,24,52],[15,19,24,55],[15,19,24,56],
 [15,19,24,58],[15,19,24,59],[15,19,24,60],
 [15,19,24,61],[15,19,24,62],[15,19,24,64],
 [15,19,24,65],[15,19,24,66],[15,19,24,67],
 [15,19,24,68],[15,19,24,69],[15,19,25,26],
 [15,19,25,27],[15,19,25,34],[15,19,25,37],
 [15,19,25,39],[15,19,25,41],[15,19,25,43],
 [15,19,25,44],[15,19,25,45],[15,19,25,46],
 [15,19,25,47],[15,19,25,48],[15,19,25,49],
 [15,19,25,55],[15,19,25,58],[15,19,25,59],
 [15,19,25,60],[15,19,25,61],[15,19,25,62],
 [15,19,25,65],[15,19,25,66],[15,19,25,67],
 [15,19,25,68],[15,19,25,69],[15,19,26,27],
 [15,19,26,34],[15,19,26,36],[15,19,26,37],
 [15,19,26,39],[15,19,26,41],[15,19,26,43],
 [15,19,26,44],[15,19,26,45],[15,19,26,46],
 [15,19,26,47],[15,19,26,48],[15,19,26,49],
 [15,19,26,52],[15,19,26,55],[15,19,26,56],
 [15,19,26,58],[15,19,26,59],[15,19,26,60],
 [15,19,26,61],[15,19,26,62],[15,19,26,64],
 [15,19,26,65],[15,19,26,66],[15,19,26,67],
 [15,19,26,68],[15,19,26,69],[15,19,27,34],
 [15,19,27,36],[15,19,27,39],[15,19,27,41],
 [15,19,27,43],[15,19,27,44],[15,19,27,45],
 [15,19,27,46],[15,19,27,47],[15,19,27,48],
 [15,19,27,49],[15,19,27,52],[15,19,27,55],
 [15,19,27,56],[15,19,27,58],[15,19,27,59],
 [15,19,27,60],[15,19,27,61],[15,19,27,62],
 [15,19,27,64],[15,19,27,66],[15,19,27,67],
 [15,19,27,68],[15,19,27,69],[15,19,34,36],
 [15,19,34,39],[15,19,34,41],[15,19,34,43],
 [15,19,34,44],[15,19,34,45],[15,19,34,46],
 [15,19,34,47],[15,19,34,48],[15,19,34,49],
 [15,19,34,52],[15,19,34,55],[15,19,34,56],
 [15,19,34,58],[15,19,34,59],[15,19,34,60],
 [15,19,34,61],[15,19,34,62],[15,19,34,66],
 [15,19,34,67],[15,19,34,68],[15,19,34,69],
 [15,19,36,37],[15,19,36,46],[15,19,36,48],
 [15,19,36,49],[15,19,36,52],[15,19,36,55],
 [15,19,36,59],[15,19,36,61],[15,19,36,62],
 [15,19,36,66],[15,19,36,68],[15,19,36,69],
 [15,19,37,39],[15,19,37,44],[15,19,37,46],
 [15,19,37,47],[15,19,37,48],[15,19,37,52],
 [15,19,37,56],[15,19,37,58],[15,19,37,59],
 [15,19,37,60],[15,19,37,61],[15,19,37,67],
 [15,19,37,68],[15,19,39,41],[15,19,39,43],
 [15,19,39,44],[15,19,39,45],[15,19,39,46],
 [15,19,39,47],[15,19,39,48],[15,19,39,49],
 [15,19,39,52],[15,19,39,55],[15,19,39,58],
 [15,19,39,59],[15,19,39,60],[15,19,39,61],
 [15,19,39,62],[15,19,39,64],[15,19,39,65],
 [15,19,39,66],[15,19,39,67],[15,19,39,68],
 [15,19,39,69],[15,19,41,43],[15,19,41,44],
 [15,19,41,45],[15,19,41,46],[15,19,41,47],
 [15,19,41,48],[15,19,41,49],[15,19,41,55],
 [15,19,41,58],[15,19,41,59],[15,19,41,60],
 [15,19,41,61],[15,19,41,62],[15,19,41,64],
 [15,19,41,66],[15,19,41,67],[15,19,41,68],
 [15,19,41,69],[15,19,43,44],[15,19,43,45],
 [15,19,43,46],[15,19,43,47],[15,19,43,48],
 [15,19,43,49],[15,19,43,52],[15,19,43,55],
 [15,19,43,58],[15,19,43,59],[15,19,43,60],
 [15,19,43,61],[15,19,43,62],[15,19,43,66],
 [15,19,43,67],[15,19,43,68],[15,19,43,69],
 [15,19,44,45],[15,19,44,46],[15,19,44,47],
 [15,19,44,48],[15,19,44,49],[15,19,44,52],
 [15,19,44,55],[15,19,44,56],[15,19,44,58],
 [15,19,44,59],[15,19,44,60],[15,19,44,61],
 [15,19,44,62],[15,19,44,64],[15,19,44,65],
 [15,19,44,66],[15,19,44,67],[15,19,44,68],
 [15,19,44,69],[15,19,45,46],[15,19,45,47],
 [15,19,45,48],[15,19,45,49],[15,19,45,55],
 [15,19,45,58],[15,19,45,59],[15,19,45,60],
 [15,19,45,61],[15,19,45,62],[15,19,45,66],
 [15,19,45,67],[15,19,45,68],[15,19,45,69],
 [15,19,46,47],[15,19,46,48],[15,19,46,49],
 [15,19,46,52],[15,19,46,55],[15,19,46,56],
 [15,19,46,58],[15,19,46,59],[15,19,46,60],
 [15,19,46,61],[15,19,46,62],[15,19,46,66],
 [15,19,46,67],[15,19,46,68],[15,19,46,69],
 [15,19,47,48],[15,19,47,49],[15,19,47,52],
 [15,19,47,55],[15,19,47,56],[15,19,47,58],
 [15,19,47,59],[15,19,47,60],[15,19,47,61],
 [15,19,47,62],[15,19,47,65],[15,19,47,66],
 [15,19,47,67],[15,19,47,68],[15,19,47,69],
 [15,19,48,49],[15,19,48,52],[15,19,48,55],
 [15,19,48,56],[15,19,48,58],[15,19,48,59],
 [15,19,48,60],[15,19,48,61],[15,19,48,62],
 [15,19,48,66],[15,19,48,67],[15,19,48,68],
 [15,19,48,69],[15,19,49,52],[15,19,49,55],
 [15,19,49,56],[15,19,49,58],[15,19,49,59],
 [15,19,49,60],[15,19,49,61],[15,19,49,62],
 [15,19,49,66],[15,19,49,67],[15,19,49,68],
 [15,19,49,69],[15,19,52,61],[15,19,52,62],
 [15,19,52,66],[15,19,52,69],[15,19,55,58],
 [15,19,55,59],[15,19,55,60],[15,19,55,61],
 [15,19,55,62],[15,19,55,66],[15,19,55,67],
 [15,19,55,68],[15,19,55,69],[15,19,56,59],
 [15,19,56,62],[15,19,56,66],[15,19,56,69],
 [15,19,58,59],[15,19,58,60],[15,19,58,61],
 [15,19,58,62],[15,19,58,66],[15,19,58,67],
 [15,19,58,68],[15,19,58,69],[15,19,59,60],
 [15,19,59,61],[15,19,59,62],[15,19,59,64],
 [15,19,59,65],[15,19,59,66],[15,19,59,67],
 [15,19,59,68],[15,19,59,69],[15,19,60,61],
 [15,19,60,62],[15,19,60,65],[15,19,60,66],
 [15,19,60,67],[15,19,60,68],[15,19,60,69],
 [15,19,61,62],[15,19,61,66],[15,19,61,67],
 [15,19,61,68],[15,19,61,69],[15,19,62,66],
 [15,19,62,67],[15,19,62,68],[15,19,62,69],
 [15,19,64,67],[15,19,64,68],[15,19,66,67],
 [15,19,66,68],[15,19,66,69],[15,19,67,68],
 [15,19,67,69],[15,19,68,69],[15,20,21,22],
 [15,20,21,23],[15,20,21,24],[15,20,21,25],
 [15,20,21,26],[15,20,21,27],[15,20,21,34],
 [15,20,21,37],[15,20,21,39],[15,20,21,41],
 [15,20,21,43],[15,20,21,44],[15,20,21,45],
 [15,20,21,46],[15,20,21,47],[15,20,21,48],
 [15,20,21,49],[15,20,21,55],[15,20,21,57],
 [15,20,21,58],[15,20,21,59],[15,20,21,60],
 [15,20,21,61],[15,20,21,62],[15,20,21,65],
 [15,20,21,66],[15,20,21,67],[15,20,21,68],
 [15,20,21,69],[15,20,22,23],[15,20,22,24],
 [15,20,22,25],[15,20,22,26],[15,20,22,27],
 [15,20,22,28],[15,20,22,29],[15,20,22,30],
 [15,20,22,31],[15,20,22,32],[15,20,22,34],
 [15,20,22,37],[15,20,22,38],[15,20,22,39],
 [15,20,22,40],[15,20,22,41],[15,20,22,42],
 [15,20,22,43],[15,20,22,44],[15,20,22,45],
 [15,20,22,46],[15,20,22,47],[15,20,22,48],
 [15,20,22,49],[15,20,22,54],[15,20,22,55],
 [15,20,22,56],[15,20,22,57],[15,20,22,58],
 [15,20,22,59],[15,20,22,60],[15,20,22,61],
 [15,20,22,62],[15,20,22,63],[15,20,22,64],
 [15,20,22,65],[15,20,22,66],[15,20,22,67],
 [15,20,22,68],[15,20,22,69],[15,20,23,24],
 [15,20,23,25],[15,20,23,26],[15,20,23,27],
 [15,20,23,34],[15,20,23,36],[15,20,23,37],
 [15,20,23,39],[15,20,23,41],[15,20,23,42],
 [15,20,23,43],[15,20,23,44],[15,20,23,45],
 [15,20,23,46],[15,20,23,47],[15,20,23,48],
 [15,20,23,49],[15,20,23,52],[15,20,23,53],
 [15,20,23,55],[15,20,23,56],[15,20,23,57],
 [15,20,23,58],[15,20,23,59],[15,20,23,60],
 [15,20,23,61],[15,20,23,62],[15,20,23,64],
 [15,20,23,66],[15,20,23,67],[15,20,23,68],
 [15,20,23,69],[15,20,24,25],[15,20,24,26],
 [15,20,24,27],[15,20,24,28],[15,20,24,29],
 [15,20,24,30],[15,20,24,31],[15,20,24,32],
 [15,20,24,34],[15,20,24,36],[15,20,24,37],
 [15,20,24,38],[15,20,24,39],[15,20,24,40],
 [15,20,24,41],[15,20,24,42],[15,20,24,43],
 [15,20,24,44],[15,20,24,45],[15,20,24,46],
 [15,20,24,47],[15,20,24,48],[15,20,24,49],
 [15,20,24,52],[15,20,24,54],[15,20,24,55],
 [15,20,24,56],[15,20,24,57],[15,20,24,58],
 [15,20,24,59],[15,20,24,60],[15,20,24,61],
 [15,20,24,62],[15,20,24,63],[15,20,24,64],
 [15,20,24,65],[15,20,24,66],[15,20,24,67],
 [15,20,24,68],[15,20,24,69],[15,20,25,26],
 [15,20,25,27],[15,20,25,31],[15,20,25,34],
 [15,20,25,37],[15,20,25,39],[15,20,25,40],
 [15,20,25,41],[15,20,25,43],[15,20,25,44],
 [15,20,25,45],[15,20,25,46],[15,20,25,47],
 [15,20,25,48],[15,20,25,49],[15,20,25,53],
 [15,20,25,54],[15,20,25,55],[15,20,25,58],
 [15,20,25,59],[15,20,25,60],[15,20,25,61],
 [15,20,25,62],[15,20,25,66],[15,20,25,67],
 [15,20,25,68],[15,20,25,69],[15,20,26,27],
 [15,20,26,28],[15,20,26,29],[15,20,26,30],
 [15,20,26,31],[15,20,26,32],[15,20,26,34],
 [15,20,26,36],[15,20,26,37],[15,20,26,38],
 [15,20,26,39],[15,20,26,40],[15,20,26,41],
 [15,20,26,42],[15,20,26,43],[15,20,26,44],
 [15,20,26,45],[15,20,26,46],[15,20,26,47],
 [15,20,26,48],[15,20,26,49],[15,20,26,52],
 [15,20,26,54],[15,20,26,55],[15,20,26,56],
 [15,20,26,57],[15,20,26,58],[15,20,26,59],
 [15,20,26,60],[15,20,26,61],[15,20,26,62],
 [15,20,26,63],[15,20,26,64],[15,20,26,65],
 [15,20,26,66],[15,20,26,67],[15,20,26,68],
 [15,20,26,69],[15,20,27,32],[15,20,27,34],
 [15,20,27,36],[15,20,27,39],[15,20,27,41],
 [15,20,27,43],[15,20,27,44],[15,20,27,45],
 [15,20,27,46],[15,20,27,47],[15,20,27,48],
 [15,20,27,49],[15,20,27,52],[15,20,27,54],
 [15,20,27,55],[15,20,27,58],[15,20,27,59],
 [15,20,27,60],[15,20,27,61],[15,20,27,62],
 [15,20,27,64],[15,20,27,66],[15,20,27,67],
 [15,20,27,68],[15,20,27,69],[15,20,28,30],
 [15,20,28,41],[15,20,28,44],[15,20,28,47],
 [15,20,28,49],[15,20,28,52],[15,20,28,53],
 [15,20,28,59],[15,20,28,60],[15,20,28,61],
 [15,20,28,68],[15,20,29,31],[15,20,29,32],
 [15,20,29,36],[15,20,29,41],[15,20,29,44],
 [15,20,29,47],[15,20,29,49],[15,20,29,52],
 [15,20,29,59],[15,20,29,60],[15,20,29,61],
 [15,20,29,64],[15,20,29,68],[15,20,29,69],
 [15,20,30,41],[15,20,30,44],[15,20,30,47],
 [15,20,30,49],[15,20,30,52],[15,20,30,53],
 [15,20,30,58],[15,20,30,59],[15,20,30,60],
 [15,20,30,61],[15,20,30,68],[15,20,31,32],
 [15,20,31,41],[15,20,31,42],[15,20,31,44],
 [15,20,31,47],[15,20,31,49],[15,20,31,59],
 [15,20,31,61],[15,20,31,63],[15,20,31,67],
 [15,20,31,68],[15,20,32,40],[15,20,32,41],
 [15,20,32,44],[15,20,32,47],[15,20,32,49],
 [15,20,32,59],[15,20,32,60],[15,20,32,61],
 [15,20,32,63],[15,20,32,68],[15,20,34,36],
 [15,20,34,39],[15,20,34,41],[15,20,34,43],
 [15,20,34,44],[15,20,34,45],[15,20,34,46],
 [15,20,34,47],[15,20,34,48],[15,20,34,49],
 [15,20,34,52],[15,20,34,55],[15,20,34,56],
 [15,20,34,58],[15,20,34,59],[15,20,34,60],
 [15,20,34,61],[15,20,34,62],[15,20,34,66],
 [15,20,34,67],[15,20,34,68],[15,20,34,69],
 [15,20,36,37],[15,20,36,38],[15,20,36,46],
 [15,20,36,49],[15,20,36,52],[15,20,36,53],
 [15,20,36,55],[15,20,36,61],[15,20,36,62],
 [15,20,36,63],[15,20,36,64],[15,20,36,65],
 [15,20,36,66],[15,20,36,68],[15,20,36,69],
 [15,20,37,38],[15,20,37,39],[15,20,37,40],
 [15,20,37,42],[15,20,37,44],[15,20,37,46],
 [15,20,37,47],[15,20,37,48],[15,20,37,52],
 [15,20,37,58],[15,20,37,59],[15,20,37,60],
 [15,20,37,61],[15,20,37,63],[15,20,37,68],
 [15,20,38,40],[15,20,38,41],[15,20,38,42],
 [15,20,38,44],[15,20,38,45],[15,20,38,47],
 [15,20,38,49],[15,20,38,52],[15,20,38,59],
 [15,20,38,60],[15,20,38,61],[15,20,38,63],
 [15,20,38,64],[15,20,38,65],[15,20,38,68],
 [15,20,39,41],[15,20,39,43],[15,20,39,44],
 [15,20,39,45],[15,20,39,46],[15,20,39,47],
 [15,20,39,48],[15,20,39,49],[15,20,39,52],
 [15,20,39,55],[15,20,39,58],[15,20,39,59],
 [15,20,39,60],[15,20,39,61],[15,20,39,62],
 [15,20,39,64],[15,20,39,65],[15,20,39,66],
 [15,20,39,67],[15,20,39,68],[15,20,39,69],
 [15,20,40,41],[15,20,40,42],[15,20,40,44],
 [15,20,40,47],[15,20,40,48],[15,20,40,49],
 [15,20,40,52],[15,20,40,55],[15,20,40,59],
 [15,20,40,61],[15,20,40,63],[15,20,40,64],
 [15,20,40,65],[15,20,40,68],[15,20,41,42],
 [15,20,41,43],[15,20,41,44],[15,20,41,45],
 [15,20,41,46],[15,20,41,47],[15,20,41,48],
 [15,20,41,49],[15,20,41,53],[15,20,41,54],
 [15,20,41,55],[15,20,41,56],[15,20,41,57],
 [15,20,41,58],[15,20,41,59],[15,20,41,60],
 [15,20,41,61],[15,20,41,62],[15,20,41,63],
 [15,20,41,64],[15,20,41,65],[15,20,41,66],
 [15,20,41,67],[15,20,41,68],[15,20,41,69],
 [15,20,42,44],[15,20,42,46],[15,20,42,47],
 [15,20,42,49],[15,20,42,52],[15,20,42,55],
 [15,20,42,59],[15,20,42,61],[15,20,42,63],
 [15,20,42,64],[15,20,42,65],[15,20,42,68],
 [15,20,43,44],[15,20,43,45],[15,20,43,46],
 [15,20,43,47],[15,20,43,48],[15,20,43,49],
 [15,20,43,52],[15,20,43,55],[15,20,43,58],
 [15,20,43,59],[15,20,43,60],[15,20,43,61],
 [15,20,43,62],[15,20,43,66],[15,20,43,67],
 [15,20,43,68],[15,20,43,69],[15,20,44,45],
 [15,20,44,46],[15,20,44,47],[15,20,44,48],
 [15,20,44,49],[15,20,44,52],[15,20,44,53],
 [15,20,44,54],[15,20,44,55],[15,20,44,56],
 [15,20,44,57],[15,20,44,58],[15,20,44,59],
 [15,20,44,60],[15,20,44,61],[15,20,44,62],
 [15,20,44,63],[15,20,44,64],[15,20,44,65],
 [15,20,44,66],[15,20,44,67],[15,20,44,68],
 [15,20,44,69],[15,20,45,46],[15,20,45,47],
 [15,20,45,48],[15,20,45,49],[15,20,45,52],
 [15,20,45,54],[15,20,45,55],[15,20,45,58],
 [15,20,45,59],[15,20,45,60],[15,20,45,61],
 [15,20,45,62],[15,20,45,66],[15,20,45,67],
 [15,20,45,68],[15,20,45,69],[15,20,46,47],
 [15,20,46,48],[15,20,46,49],[15,20,46,52],
 [15,20,46,53],[15,20,46,55],[15,20,46,56],
 [15,20,46,57],[15,20,46,58],[15,20,46,59],
 [15,20,46,60],[15,20,46,61],[15,20,46,62],
 [15,20,46,63],[15,20,46,66],[15,20,46,67],
 [15,20,46,68],[15,20,46,69],[15,20,47,48],
 [15,20,47,49],[15,20,47,53],[15,20,47,54],
 [15,20,47,55],[15,20,47,56],[15,20,47,57],
 [15,20,47,58],[15,20,47,59],[15,20,47,60],
 [15,20,47,61],[15,20,47,62],[15,20,47,63],
 [15,20,47,64],[15,20,47,65],[15,20,47,66],
 [15,20,47,67],[15,20,47,68],[15,20,47,69],
 [15,20,48,49],[15,20,48,52],[15,20,48,55],
 [15,20,48,58],[15,20,48,59],[15,20,48,60],
 [15,20,48,61],[15,20,48,62],[15,20,48,63],
 [15,20,48,66],[15,20,48,67],[15,20,48,68],
 [15,20,48,69],[15,20,49,53],[15,20,49,54],
 [15,20,49,55],[15,20,49,56],[15,20,49,57],
 [15,20,49,58],[15,20,49,59],[15,20,49,60],
 [15,20,49,61],[15,20,49,62],[15,20,49,63],
 [15,20,49,64],[15,20,49,65],[15,20,49,66],
 [15,20,49,67],[15,20,49,68],[15,20,49,69],
 [15,20,52,53],[15,20,52,54],[15,20,52,57],
 [15,20,52,61],[15,20,52,62],[15,20,52,66],
 [15,20,52,67],[15,20,52,69],[15,20,53,54],
 [15,20,53,56],[15,20,53,58],[15,20,53,60],
 [15,20,53,67],[15,20,53,68],[15,20,54,56],
 [15,20,54,57],[15,20,54,59],[15,20,54,60],
 [15,20,54,61],[15,20,54,62],[15,20,54,68],
 [15,20,54,69],[15,20,55,58],[15,20,55,59],
 [15,20,55,60],[15,20,55,61],[15,20,55,62],
 [15,20,55,66],[15,20,55,67],[15,20,55,68],
 [15,20,55,69],[15,20,56,57],[15,20,56,59],
 [15,20,56,61],[15,20,56,62],[15,20,56,66],
 [15,20,56,68],[15,20,56,69],[15,20,57,59],
 [15,20,57,60],[15,20,57,61],[15,20,57,67],
 [15,20,57,68],[15,20,58,59],[15,20,58,60],
 [15,20,58,61],[15,20,58,62],[15,20,58,66],
 [15,20,58,67],[15,20,58,68],[15,20,58,69],
 [15,20,59,60],[15,20,59,61],[15,20,59,62],
 [15,20,59,63],[15,20,59,64],[15,20,59,65],
 [15,20,59,66],[15,20,59,67],[15,20,59,68],
 [15,20,59,69],[15,20,60,61],[15,20,60,62],
 [15,20,60,65],[15,20,60,66],[15,20,60,67],
 [15,20,60,68],[15,20,60,69],[15,20,61,62],
 [15,20,61,63],[15,20,61,64],[15,20,61,65],
 [15,20,61,66],[15,20,61,67],[15,20,61,68],
 [15,20,61,69],[15,20,62,63],[15,20,62,66],
 [15,20,62,67],[15,20,62,68],[15,20,62,69],
 [15,20,63,64],[15,20,63,65],[15,20,63,66],
 [15,20,63,68],[15,20,64,65],[15,20,64,67],
 [15,20,64,68],[15,20,65,68],[15,20,66,67],
 [15,20,66,68],[15,20,66,69],[15,20,67,68],
 [15,20,67,69],[15,20,68,69],[15,21,22,23],
 [15,21,22,24],[15,21,22,25],[15,21,22,26],
 [15,21,22,27],[15,21,22,29],[15,21,22,34],
 [15,21,22,36],[15,21,22,39],[15,21,22,41],
 [15,21,22,43],[15,21,22,44],[15,21,22,45],
 [15,21,22,46],[15,21,22,47],[15,21,22,48],
 [15,21,22,49],[15,21,22,55],[15,21,22,58],
 [15,21,22,59],[15,21,22,60],[15,21,22,61],
 [15,21,22,62],[15,21,22,66],[15,21,22,67],
 [15,21,22,68],[15,21,22,69],[15,21,23,24],
 [15,21,23,25],[15,21,23,26],[15,21,23,27],
 [15,21,23,34],[15,21,23,37],[15,21,23,39],
 [15,21,23,41],[15,21,23,43],[15,21,23,44],
 [15,21,23,45],[15,21,23,46],[15,21,23,47],
 [15,21,23,48],[15,21,23,49],[15,21,23,55],
 [15,21,23,57],[15,21,23,58],[15,21,23,59],
 [15,21,23,60],[15,21,23,61],[15,21,23,62],
 [15,21,23,66],[15,21,23,67],[15,21,23,68],
 [15,21,23,69],[15,21,24,25],[15,21,24,26],
 [15,21,24,27],[15,21,24,29],[15,21,24,31],
 [15,21,24,34],[15,21,24,36],[15,21,24,37],
 [15,21,24,39],[15,21,24,41],[15,21,24,43],
 [15,21,24,44],[15,21,24,45],[15,21,24,46],
 [15,21,24,47],[15,21,24,48],[15,21,24,49],
 [15,21,24,55],[15,21,24,57],[15,21,24,58],
 [15,21,24,59],[15,21,24,60],[15,21,24,61],
 [15,21,24,62],[15,21,24,65],[15,21,24,66],
 [15,21,24,67],[15,21,24,68],[15,21,24,69],
 [15,21,25,26],[15,21,25,27],[15,21,25,31],
 [15,21,25,34],[15,21,25,37],[15,21,25,39],
 [15,21,25,41],[15,21,25,43],[15,21,25,44],
 [15,21,25,45],[15,21,25,46],[15,21,25,47],
 [15,21,25,48],[15,21,25,49],[15,21,25,55],
 [15,21,25,57],[15,21,25,58],[15,21,25,59],
 [15,21,25,60],[15,21,25,61],[15,21,25,62],
 [15,21,25,65],[15,21,25,66],[15,21,25,67],
 [15,21,25,68],[15,21,25,69],[15,21,26,27],
 [15,21,26,31],[15,21,26,34],[15,21,26,37],
 [15,21,26,39],[15,21,26,41],[15,21,26,43],
 [15,21,26,44],[15,21,26,45],[15,21,26,46],
 [15,21,26,47],[15,21,26,48],[15,21,26,49],
 [15,21,26,55],[15,21,26,57],[15,21,26,58],
 [15,21,26,59],[15,21,26,60],[15,21,26,61],
 [15,21,26,62],[15,21,26,66],[15,21,26,67],
 [15,21,26,68],[15,21,26,69],[15,21,27,34],
 [15,21,27,36],[15,21,27,39],[15,21,27,41],
 [15,21,27,43],[15,21,27,44],[15,21,27,45],
 [15,21,27,46],[15,21,27,47],[15,21,27,48],
 [15,21,27,49],[15,21,27,55],[15,21,27,58],
 [15,21,27,59],[15,21,27,60],[15,21,27,61],
 [15,21,27,62],[15,21,27,66],[15,21,27,67],
 [15,21,27,68],[15,21,27,69],[15,21,29,31],
 [15,21,29,48],[15,21,29,49],[15,21,29,59],
 [15,21,29,60],[15,21,29,61],[15,21,29,69],
 [15,21,31,36],[15,21,31,44],[15,21,31,47],
 [15,21,31,49],[15,21,31,59],[15,21,31,67],
 [15,21,34,36],[15,21,34,39],[15,21,34,41],
 [15,21,34,43],[15,21,34,44],[15,21,34,45],
 [15,21,34,46],[15,21,34,47],[15,21,34,48],
 [15,21,34,49],[15,21,34,55],[15,21,34,58],
 [15,21,34,59],[15,21,34,60],[15,21,34,61],
 [15,21,34,62],[15,21,34,66],[15,21,34,67],
 [15,21,34,68],[15,21,34,69],[15,21,36,37],
 [15,21,36,46],[15,21,36,48],[15,21,36,49],
 [15,21,36,55],[15,21,36,57],[15,21,36,59],
 [15,21,36,61],[15,21,36,62],[15,21,36,66],
 [15,21,36,68],[15,21,36,69],[15,21,37,39],
 [15,21,37,43],[15,21,37,44],[15,21,37,46],
 [15,21,37,47],[15,21,37,48],[15,21,37,58],
 [15,21,37,59],[15,21,37,60],[15,21,37,61],
 [15,21,37,67],[15,21,37,68],[15,21,39,41],
 [15,21,39,43],[15,21,39,44],[15,21,39,45],
 [15,21,39,46],[15,21,39,47],[15,21,39,48],
 [15,21,39,49],[15,21,39,55],[15,21,39,58],
 [15,21,39,59],[15,21,39,60],[15,21,39,61],
 [15,21,39,62],[15,21,39,65],[15,21,39,66],
 [15,21,39,67],[15,21,39,68],[15,21,39,69],
 [15,21,41,43],[15,21,41,44],[15,21,41,45],
 [15,21,41,46],[15,21,41,47],[15,21,41,48],
 [15,21,41,49],[15,21,41,55],[15,21,41,57],
 [15,21,41,58],[15,21,41,59],[15,21,41,60],
 [15,21,41,61],[15,21,41,62],[15,21,41,65],
 [15,21,41,66],[15,21,41,67],[15,21,41,68],
 [15,21,41,69],[15,21,43,44],[15,21,43,45],
 [15,21,43,46],[15,21,43,47],[15,21,43,48],
 [15,21,43,49],[15,21,43,55],[15,21,43,57],
 [15,21,43,58],[15,21,43,59],[15,21,43,60],
 [15,21,43,61],[15,21,43,62],[15,21,43,65],
 [15,21,43,66],[15,21,43,67],[15,21,43,68],
 [15,21,43,69],[15,21,44,45],[15,21,44,46],
 [15,21,44,47],[15,21,44,48],[15,21,44,49],
 [15,21,44,55],[15,21,44,57],[15,21,44,58],
 [15,21,44,59],[15,21,44,60],[15,21,44,61],
 [15,21,44,62],[15,21,44,65],[15,21,44,66],
 [15,21,44,67],[15,21,44,68],[15,21,44,69],
 [15,21,45,46],[15,21,45,47],[15,21,45,48],
 [15,21,45,49],[15,21,45,55],[15,21,45,58],
 [15,21,45,59],[15,21,45,60],[15,21,45,61],
 [15,21,45,62],[15,21,45,66],[15,21,45,67],
 [15,21,45,68],[15,21,45,69],[15,21,46,47],
 [15,21,46,48],[15,21,46,49],[15,21,46,55],
 [15,21,46,57],[15,21,46,58],[15,21,46,59],
 [15,21,46,60],[15,21,46,61],[15,21,46,62],
 [15,21,46,66],[15,21,46,67],[15,21,46,68],
 [15,21,46,69],[15,21,47,48],[15,21,47,49],
 [15,21,47,55],[15,21,47,57],[15,21,47,58],
 [15,21,47,59],[15,21,47,60],[15,21,47,61],
 [15,21,47,62],[15,21,47,65],[15,21,47,66],
 [15,21,47,67],[15,21,47,68],[15,21,47,69],
 [15,21,48,49],[15,21,48,55],[15,21,48,57],
 [15,21,48,58],[15,21,48,59],[15,21,48,60],
 [15,21,48,61],[15,21,48,62],[15,21,48,66],
 [15,21,48,67],[15,21,48,68],[15,21,48,69],
 [15,21,49,55],[15,21,49,58],[15,21,49,59],
 [15,21,49,60],[15,21,49,61],[15,21,49,62],
 [15,21,49,66],[15,21,49,67],[15,21,49,68],
 [15,21,49,69],[15,21,55,58],[15,21,55,59],
 [15,21,55,60],[15,21,55,61],[15,21,55,62],
 [15,21,55,66],[15,21,55,67],[15,21,55,68],
 [15,21,55,69],[15,21,57,59],[15,21,57,60],
 [15,21,57,61],[15,21,57,67],[15,21,57,68],
 [15,21,58,59],[15,21,58,60],[15,21,58,61],
 [15,21,58,62],[15,21,58,66],[15,21,58,67],
 [15,21,58,68],[15,21,58,69],[15,21,59,60],
 [15,21,59,61],[15,21,59,62],[15,21,59,65],
 [15,21,59,66],[15,21,59,67],[15,21,59,68],
 [15,21,59,69],[15,21,60,61],[15,21,60,62],
 [15,21,60,65],[15,21,60,66],[15,21,60,67],
 [15,21,60,68],[15,21,60,69],[15,21,61,62],
 [15,21,61,65],[15,21,61,66],[15,21,61,67],
 [15,21,61,68],[15,21,61,69],[15,21,62,66],
 [15,21,62,67],[15,21,62,68],[15,21,62,69],
 [15,21,65,68],[15,21,66,67],[15,21,66,68],
 [15,21,66,69],[15,21,67,68],[15,21,67,69],
 [15,21,68,69],[15,22,23,24],[15,22,23,25],
 [15,22,23,26],[15,22,23,27],[15,22,23,34],
 [15,22,23,36],[15,22,23,37],[15,22,23,39],
 [15,22,23,41],[15,22,23,43],[15,22,23,44],
 [15,22,23,45],[15,22,23,46],[15,22,23,47],
 [15,22,23,48],[15,22,23,49],[15,22,23,55],
 [15,22,23,56],[15,22,23,57],[15,22,23,58],
 [15,22,23,59],[15,22,23,60],[15,22,23,61],
 [15,22,23,62],[15,22,23,66],[15,22,23,67],
 [15,22,23,68],[15,22,23,69],[15,22,24,25],
 [15,22,24,26],[15,22,24,27],[15,22,24,28],
 [15,22,24,29],[15,22,24,30],[15,22,24,31],
 [15,22,24,32],[15,22,24,34],[15,22,24,36],
 [15,22,24,37],[15,22,24,38],[15,22,24,39],
 [15,22,24,40],[15,22,24,41],[15,22,24,42],
 [15,22,24,43],[15,22,24,44],[15,22,24,45],
 [15,22,24,46],[15,22,24,47],[15,22,24,48],
 [15,22,24,49],[15,22,24,54],[15,22,24,55],
 [15,22,24,56],[15,22,24,57],[15,22,24,58],
 [15,22,24,59],[15,22,24,60],[15,22,24,61],
 [15,22,24,62],[15,22,24,63],[15,22,24,64],
 [15,22,24,65],[15,22,24,66],[15,22,24,67],
 [15,22,24,68],[15,22,24,69],[15,22,25,26],
 [15,22,25,27],[15,22,25,34],[15,22,25,37],
 [15,22,25,39],[15,22,25,40],[15,22,25,41],
 [15,22,25,43],[15,22,25,44],[15,22,25,45],
 [15,22,25,46],[15,22,25,47],[15,22,25,48],
 [15,22,25,49],[15,22,25,54],[15,22,25,55],
 [15,22,25,57],[15,22,25,58],[15,22,25,59],
 [15,22,25,60],[15,22,25,61],[15,22,25,62],
 [15,22,25,66],[15,22,25,67],[15,22,25,68],
 [15,22,25,69],[15,22,26,27],[15,22,26,28],
 [15,22,26,29],[15,22,26,30],[15,22,26,31],
 [15,22,26,32],[15,22,26,34],[15,22,26,36],
 [15,22,26,37],[15,22,26,38],[15,22,26,39],
 [15,22,26,40],[15,22,26,41],[15,22,26,42],
 [15,22,26,43],[15,22,26,44],[15,22,26,45],
 [15,22,26,46],[15,22,26,47],[15,22,26,48],
 [15,22,26,49],[15,22,26,54],[15,22,26,55],
 [15,22,26,56],[15,22,26,57],[15,22,26,58],
 [15,22,26,59],[15,22,26,60],[15,22,26,61],
 [15,22,26,62],[15,22,26,63],[15,22,26,64],
 [15,22,26,65],[15,22,26,66],[15,22,26,67],
 [15,22,26,68],[15,22,26,69],[15,22,27,28],
 [15,22,27,32],[15,22,27,34],[15,22,27,39],
 [15,22,27,41],[15,22,27,42],[15,22,27,43],
 [15,22,27,44],[15,22,27,45],[15,22,27,46],
 [15,22,27,47],[15,22,27,48],[15,22,27,49],
 [15,22,27,54],[15,22,27,55],[15,22,27,56],
 [15,22,27,58],[15,22,27,59],[15,22,27,60],
 [15,22,27,61],[15,22,27,62],[15,22,27,66],
 [15,22,27,67],[15,22,27,68],[15,22,27,69],
 [15,22,28,30],[15,22,28,41],[15,22,28,44],
 [15,22,28,47],[15,22,28,49],[15,22,28,58],
 [15,22,28,59],[15,22,28,61],[15,22,28,68],
 [15,22,29,31],[15,22,29,32],[15,22,29,36],
 [15,22,29,41],[15,22,29,44],[15,22,29,47],
 [15,22,29,49],[15,22,29,59],[15,22,29,60],
 [15,22,29,61],[15,22,29,68],[15,22,29,69],
 [15,22,30,41],[15,22,30,44],[15,22,30,47],
 [15,22,30,49],[15,22,30,59],[15,22,30,61],
 [15,22,30,68],[15,22,31,32],[15,22,31,36],
 [15,22,31,41],[15,22,31,44],[15,22,31,47],
 [15,22,31,49],[15,22,31,59],[15,22,31,61],
 [15,22,31,63],[15,22,31,68],[15,22,32,40],
 [15,22,32,41],[15,22,32,44],[15,22,32,47],
 [15,22,32,49],[15,22,32,59],[15,22,32,60],
 [15,22,32,61],[15,22,32,63],[15,22,32,68],
 [15,22,34,39],[15,22,34,41],[15,22,34,43],
 [15,22,34,44],[15,22,34,45],[15,22,34,46],
 [15,22,34,47],[15,22,34,48],[15,22,34,49],
 [15,22,34,55],[15,22,34,58],[15,22,34,59],
 [15,22,34,60],[15,22,34,61],[15,22,34,62],
 [15,22,34,66],[15,22,34,67],[15,22,34,68],
 [15,22,34,69],[15,22,36,37],[15,22,36,38],
 [15,22,36,46],[15,22,36,49],[15,22,36,54],
 [15,22,36,61],[15,22,36,62],[15,22,36,63],
 [15,22,36,64],[15,22,36,66],[15,22,36,68],
 [15,22,37,38],[15,22,37,39],[15,22,37,40],
 [15,22,37,42],[15,22,37,43],[15,22,37,44],
 [15,22,37,46],[15,22,37,47],[15,22,37,58],
 [15,22,37,59],[15,22,37,60],[15,22,37,61],
 [15,22,37,63],[15,22,37,67],[15,22,37,68],
 [15,22,38,40],[15,22,38,41],[15,22,38,42],
 [15,22,38,44],[15,22,38,47],[15,22,38,49],
 [15,22,38,55],[15,22,38,59],[15,22,38,60],
 [15,22,38,61],[15,22,38,63],[15,22,38,64],
 [15,22,38,65],[15,22,38,67],[15,22,38,68],
 [15,22,39,41],[15,22,39,43],[15,22,39,44],
 [15,22,39,45],[15,22,39,46],[15,22,39,47],
 [15,22,39,48],[15,22,39,49],[15,22,39,55],
 [15,22,39,58],[15,22,39,59],[15,22,39,60],
 [15,22,39,61],[15,22,39,62],[15,22,39,63],
 [15,22,39,64],[15,22,39,65],[15,22,39,66],
 [15,22,39,67],[15,22,39,68],[15,22,39,69],
 [15,22,40,41],[15,22,40,42],[15,22,40,44],
 [15,22,40,47],[15,22,40,48],[15,22,40,49],
 [15,22,40,55],[15,22,40,59],[15,22,40,61],
 [15,22,40,63],[15,22,40,64],[15,22,40,65],
 [15,22,40,68],[15,22,40,69],[15,22,41,42],
 [15,22,41,43],[15,22,41,44],[15,22,41,45],
 [15,22,41,46],[15,22,41,47],[15,22,41,48],
 [15,22,41,49],[15,22,41,54],[15,22,41,55],
 [15,22,41,56],[15,22,41,57],[15,22,41,58],
 [15,22,41,59],[15,22,41,60],[15,22,41,61],
 [15,22,41,62],[15,22,41,63],[15,22,41,64],
 [15,22,41,65],[15,22,41,66],[15,22,41,67],
 [15,22,41,68],[15,22,41,69],[15,22,42,44],
 [15,22,42,46],[15,22,42,47],[15,22,42,49],
 [15,22,42,55],[15,22,42,59],[15,22,42,61],
 [15,22,42,62],[15,22,42,63],[15,22,42,64],
 [15,22,42,65],[15,22,42,68],[15,22,43,44],
 [15,22,43,45],[15,22,43,46],[15,22,43,47],
 [15,22,43,48],[15,22,43,49],[15,22,43,55],
 [15,22,43,57],[15,22,43,58],[15,22,43,59],
 [15,22,43,60],[15,22,43,61],[15,22,43,62],
 [15,22,43,65],[15,22,43,66],[15,22,43,67],
 [15,22,43,68],[15,22,43,69],[15,22,44,45],
 [15,22,44,46],[15,22,44,47],[15,22,44,48],
 [15,22,44,49],[15,22,44,54],[15,22,44,55],
 [15,22,44,56],[15,22,44,57],[15,22,44,58],
 [15,22,44,59],[15,22,44,60],[15,22,44,61],
 [15,22,44,62],[15,22,44,63],[15,22,44,64],
 [15,22,44,65],[15,22,44,66],[15,22,44,67],
 [15,22,44,68],[15,22,44,69],[15,22,45,46],
 [15,22,45,47],[15,22,45,48],[15,22,45,49],
 [15,22,45,54],[15,22,45,55],[15,22,45,58],
 [15,22,45,59],[15,22,45,60],[15,22,45,61],
 [15,22,45,62],[15,22,45,66],[15,22,45,67],
 [15,22,45,68],[15,22,45,69],[15,22,46,47],
 [15,22,46,48],[15,22,46,49],[15,22,46,55],
 [15,22,46,57],[15,22,46,58],[15,22,46,59],
 [15,22,46,60],[15,22,46,61],[15,22,46,62],
 [15,22,46,66],[15,22,46,67],[15,22,46,68],
 [15,22,46,69],[15,22,47,48],[15,22,47,49],
 [15,22,47,54],[15,22,47,55],[15,22,47,56],
 [15,22,47,57],[15,22,47,58],[15,22,47,59],
 [15,22,47,60],[15,22,47,61],[15,22,47,62],
 [15,22,47,63],[15,22,47,64],[15,22,47,65],
 [15,22,47,66],[15,22,47,67],[15,22,47,68],
 [15,22,47,69],[15,22,48,49],[15,22,48,55],
 [15,22,48,56],[15,22,48,58],[15,22,48,59],
 [15,22,48,60],[15,22,48,61],[15,22,48,62],
 [15,22,48,63],[15,22,48,66],[15,22,48,67],
 [15,22,48,68],[15,22,48,69],[15,22,49,54],
 [15,22,49,55],[15,22,49,56],[15,22,49,57],
 [15,22,49,58],[15,22,49,59],[15,22,49,60],
 [15,22,49,61],[15,22,49,62],[15,22,49,63],
 [15,22,49,64],[15,22,49,65],[15,22,49,66],
 [15,22,49,67],[15,22,49,68],[15,22,49,69],
 [15,22,54,56],[15,22,54,57],[15,22,54,58],
 [15,22,54,59],[15,22,54,61],[15,22,54,62],
 [15,22,54,67],[15,22,54,68],[15,22,55,58],
 [15,22,55,59],[15,22,55,60],[15,22,55,61],
 [15,22,55,62],[15,22,55,66],[15,22,55,67],
 [15,22,55,68],[15,22,55,69],[15,22,56,57],
 [15,22,56,59],[15,22,56,61],[15,22,56,62],
 [15,22,56,66],[15,22,56,68],[15,22,56,69],
 [15,22,57,59],[15,22,57,60],[15,22,57,61],
 [15,22,57,67],[15,22,57,68],[15,22,58,59],
 [15,22,58,60],[15,22,58,61],[15,22,58,62],
 [15,22,58,66],[15,22,58,67],[15,22,58,68],
 [15,22,58,69],[15,22,59,60],[15,22,59,61],
 [15,22,59,62],[15,22,59,63],[15,22,59,64],
 [15,22,59,65],[15,22,59,66],[15,22,59,67],
 [15,22,59,68],[15,22,59,69],[15,22,60,61],
 [15,22,60,62],[15,22,60,65],[15,22,60,66],
 [15,22,60,67],[15,22,60,68],[15,22,60,69],
 [15,22,61,62],[15,22,61,63],[15,22,61,64],
 [15,22,61,65],[15,22,61,66],[15,22,61,67],
 [15,22,61,68],[15,22,61,69],[15,22,62,63],
 [15,22,62,66],[15,22,62,67],[15,22,62,68],
 [15,22,62,69],[15,22,63,64],[15,22,63,65],
 [15,22,63,68],[15,22,63,69],[15,22,64,65],
 [15,22,64,67],[15,22,64,68],[15,22,65,68],
 [15,22,66,67],[15,22,66,68],[15,22,66,69],
 [15,22,67,68],[15,22,67,69],[15,22,68,69],
 [15,23,24,25],[15,23,24,26],[15,23,24,27],
 [15,23,24,32],[15,23,24,34],[15,23,24,36],
 [15,23,24,37],[15,23,24,39],[15,23,24,41],
 [15,23,24,42],[15,23,24,43],[15,23,24,44],
 [15,23,24,45],[15,23,24,46],[15,23,24,47],
 [15,23,24,48],[15,23,24,49],[15,23,24,52],
 [15,23,24,55],[15,23,24,56],[15,23,24,57],
 [15,23,24,58],[15,23,24,59],[15,23,24,60],
 [15,23,24,61],[15,23,24,62],[15,23,24,66],
 [15,23,24,67],[15,23,24,68],[15,23,24,69],
 [15,23,25,26],[15,23,25,27],[15,23,25,34],
 [15,23,25,37],[15,23,25,39],[15,23,25,41],
 [15,23,25,43],[15,23,25,44],[15,23,25,45],
 [15,23,25,46],[15,23,25,47],[15,23,25,48],
 [15,23,25,49],[15,23,25,53],[15,23,25,55],
 [15,23,25,57],[15,23,25,58],[15,23,25,59],
 [15,23,25,60],[15,23,25,61],[15,23,25,62],
 [15,23,25,66],[15,23,25,67],[15,23,25,68],
 [15,23,25,69],[15,23,26,27],[15,23,26,34],
 [15,23,26,36],[15,23,26,37],[15,23,26,39],
 [15,23,26,41],[15,23,26,43],[15,23,26,44],
 [15,23,26,45],[15,23,26,46],[15,23,26,47],
 [15,23,26,48],[15,23,26,49],[15,23,26,52],
 [15,23,26,55],[15,23,26,56],[15,23,26,57],
 [15,23,26,58],[15,23,26,59],[15,23,26,60],
 [15,23,26,61],[15,23,26,62],[15,23,26,64],
 [15,23,26,66],[15,23,26,67],[15,23,26,68],
 [15,23,26,69],[15,23,27,32],[15,23,27,34],
 [15,23,27,36],[15,23,27,39],[15,23,27,41],
 [15,23,27,42],[15,23,27,43],[15,23,27,44],
 [15,23,27,45],[15,23,27,46],[15,23,27,47],
 [15,23,27,48],[15,23,27,49],[15,23,27,52],
 [15,23,27,55],[15,23,27,56],[15,23,27,58],
 [15,23,27,59],[15,23,27,60],[15,23,27,61],
 [15,23,27,62],[15,23,27,64],[15,23,27,66],
 [15,23,27,67],[15,23,27,68],[15,23,27,69],
 [15,23,32,41],[15,23,32,44],[15,23,32,47],
 [15,23,32,49],[15,23,32,59],[15,23,32,60],
 [15,23,32,61],[15,23,32,68],[15,23,34,36],
 [15,23,34,39],[15,23,34,41],[15,23,34,43],
 [15,23,34,44],[15,23,34,45],[15,23,34,46],
 [15,23,34,47],[15,23,34,48],[15,23,34,49],
 [15,23,34,52],[15,23,34,55],[15,23,34,56],
 [15,23,34,58],[15,23,34,59],[15,23,34,60],
 [15,23,34,61],[15,23,34,62],[15,23,34,66],
 [15,23,34,67],[15,23,34,68],[15,23,34,69],
 [15,23,36,37],[15,23,36,46],[15,23,36,48],
 [15,23,36,49],[15,23,36,52],[15,23,36,53],
 [15,23,36,55],[15,23,36,57],[15,23,36,59],
 [15,23,36,61],[15,23,36,62],[15,23,36,64],
 [15,23,36,66],[15,23,36,68],[15,23,36,69],
 [15,23,37,42],[15,23,37,43],[15,23,37,44],
 [15,23,37,46],[15,23,37,47],[15,23,37,48],
 [15,23,37,52],[15,23,37,56],[15,23,37,58],
 [15,23,37,59],[15,23,37,60],[15,23,37,61],
 [15,23,37,67],[15,23,37,68],[15,23,39,41],
 [15,23,39,43],[15,23,39,44],[15,23,39,45],
 [15,23,39,46],[15,23,39,47],[15,23,39,48],
 [15,23,39,49],[15,23,39,52],[15,23,39,55],
 [15,23,39,58],[15,23,39,59],[15,23,39,60],
 [15,23,39,61],[15,23,39,62],[15,23,39,64],
 [15,23,39,66],[15,23,39,67],[15,23,39,68],
 [15,23,39,69],[15,23,41,42],[15,23,41,43],
 [15,23,41,44],[15,23,41,45],[15,23,41,46],
 [15,23,41,47],[15,23,41,48],[15,23,41,49],
 [15,23,41,53],[15,23,41,55],[15,23,41,56],
 [15,23,41,58],[15,23,41,59],[15,23,41,60],
 [15,23,41,61],[15,23,41,62],[15,23,41,64],
 [15,23,41,66],[15,23,41,67],[15,23,41,68],
 [15,23,41,69],[15,23,42,46],[15,23,42,47],
 [15,23,42,49],[15,23,42,52],[15,23,42,55],
 [15,23,42,59],[15,23,42,61],[15,23,42,62],
 [15,23,42,64],[15,23,42,68],[15,23,43,44],
 [15,23,43,45],[15,23,43,46],[15,23,43,47],
 [15,23,43,48],[15,23,43,49],[15,23,43,52],
 [15,23,43,55],[15,23,43,57],[15,23,43,58],
 [15,23,43,59],[15,23,43,60],[15,23,43,61],
 [15,23,43,62],[15,23,43,66],[15,23,43,67],
 [15,23,43,68],[15,23,43,69],[15,23,44,45],
 [15,23,44,46],[15,23,44,47],[15,23,44,48],
 [15,23,44,49],[15,23,44,52],[15,23,44,53],
 [15,23,44,55],[15,23,44,56],[15,23,44,57],
 [15,23,44,58],[15,23,44,59],[15,23,44,60],
 [15,23,44,61],[15,23,44,62],[15,23,44,66],
 [15,23,44,67],[15,23,44,68],[15,23,44,69],
 [15,23,45,46],[15,23,45,47],[15,23,45,48],
 [15,23,45,49],[15,23,45,52],[15,23,45,55],
 [15,23,45,58],[15,23,45,59],[15,23,45,60],
 [15,23,45,61],[15,23,45,62],[15,23,45,66],
 [15,23,45,67],[15,23,45,68],[15,23,45,69],
 [15,23,46,47],[15,23,46,48],[15,23,46,49],
 [15,23,46,52],[15,23,46,53],[15,23,46,55],
 [15,23,46,56],[15,23,46,57],[15,23,46,58],
 [15,23,46,59],[15,23,46,60],[15,23,46,61],
 [15,23,46,62],[15,23,46,66],[15,23,46,67],
 [15,23,46,68],[15,23,46,69],[15,23,47,48],
 [15,23,47,49],[15,23,47,52],[15,23,47,53],
 [15,23,47,55],[15,23,47,57],[15,23,47,58],
 [15,23,47,59],[15,23,47,60],[15,23,47,61],
 [15,23,47,62],[15,23,47,64],[15,23,47,66],
 [15,23,47,67],[15,23,47,68],[15,23,47,69],
 [15,23,48,49],[15,23,48,52],[15,23,48,53],
 [15,23,48,55],[15,23,48,56],[15,23,48,57],
 [15,23,48,58],[15,23,48,59],[15,23,48,60],
 [15,23,48,61],[15,23,48,62],[15,23,48,66],
 [15,23,48,67],[15,23,48,68],[15,23,48,69],
 [15,23,49,52],[15,23,49,53],[15,23,49,55],
 [15,23,49,56],[15,23,49,58],[15,23,49,59],
 [15,23,49,60],[15,23,49,61],[15,23,49,62],
 [15,23,49,64],[15,23,49,66],[15,23,49,67],
 [15,23,49,68],[15,23,49,69],[15,23,52,53],
 [15,23,52,57],[15,23,52,61],[15,23,52,62],
 [15,23,52,66],[15,23,52,67],[15,23,52,69],
 [15,23,53,56],[15,23,53,58],[15,23,53,60],
 [15,23,53,67],[15,23,53,68],[15,23,55,58],
 [15,23,55,59],[15,23,55,60],[15,23,55,61],
 [15,23,55,62],[15,23,55,66],[15,23,55,67],
 [15,23,55,68],[15,23,55,69],[15,23,56,57],
 [15,23,56,61],[15,23,56,62],[15,23,56,66],
 [15,23,56,68],[15,23,56,69],[15,23,57,59],
 [15,23,57,60],[15,23,57,61],[15,23,57,67],
 [15,23,57,68],[15,23,58,59],[15,23,58,60],
 [15,23,58,61],[15,23,58,62],[15,23,58,66],
 [15,23,58,67],[15,23,58,68],[15,23,58,69],
 [15,23,59,60],[15,23,59,61],[15,23,59,62],
 [15,23,59,64],[15,23,59,66],[15,23,59,67],
 [15,23,59,68],[15,23,59,69],[15,23,60,61],
 [15,23,60,62],[15,23,60,66],[15,23,60,67],
 [15,23,60,68],[15,23,60,69],[15,23,61,62],
 [15,23,61,64],[15,23,61,66],[15,23,61,67],
 [15,23,61,68],[15,23,61,69],[15,23,62,66],
 [15,23,62,67],[15,23,62,68],[15,23,62,69],
 [15,23,64,67],[15,23,64,68],[15,23,66,67],
 [15,23,66,68],[15,23,66,69],[15,23,67,68],
 [15,23,67,69],[15,23,68,69],[15,24,25,26],
 [15,24,25,27],[15,24,25,34],[15,24,25,37],
 [15,24,25,39],[15,24,25,41],[15,24,25,43],
 [15,24,25,44],[15,24,25,45],[15,24,25,46],
 [15,24,25,47],[15,24,25,48],[15,24,25,49],
 [15,24,25,51],[15,24,25,54],[15,24,25,55],
 [15,24,25,57],[15,24,25,58],[15,24,25,59],
 [15,24,25,60],[15,24,25,61],[15,24,25,62],
 [15,24,25,65],[15,24,25,66],[15,24,25,67],
 [15,24,25,68],[15,24,25,69],[15,24,26,27],
 [15,24,26,28],[15,24,26,29],[15,24,26,30],
 [15,24,26,31],[15,24,26,32],[15,24,26,34],
 [15,24,26,36],[15,24,26,37],[15,24,26,38],
 [15,24,26,39],[15,24,26,40],[15,24,26,41],
 [15,24,26,42],[15,24,26,43],[15,24,26,44],
 [15,24,26,45],[15,24,26,46],[15,24,26,47],
 [15,24,26,48],[15,24,26,49],[15,24,26,51],
 [15,24,26,52],[15,24,26,54],[15,24,26,55],
 [15,24,26,56],[15,24,26,57],[15,24,26,58],
 [15,24,26,59],[15,24,26,60],[15,24,26,61],
 [15,24,26,62],[15,24,26,63],[15,24,26,64],
 [15,24,26,65],[15,24,26,66],[15,24,26,67],
 [15,24,26,68],[15,24,26,69],[15,24,27,30],
 [15,24,27,32],[15,24,27,34],[15,24,27,36],
 [15,24,27,39],[15,24,27,41],[15,24,27,42],
 [15,24,27,43],[15,24,27,44],[15,24,27,45],
 [15,24,27,46],[15,24,27,47],[15,24,27,48],
 [15,24,27,49],[15,24,27,51],[15,24,27,52],
 [15,24,27,54],[15,24,27,55],[15,24,27,56],
 [15,24,27,58],[15,24,27,59],[15,24,27,60],
 [15,24,27,61],[15,24,27,62],[15,24,27,66],
 [15,24,27,67],[15,24,27,68],[15,24,27,69],
 [15,24,28,30],[15,24,28,41],[15,24,28,44],
 [15,24,28,47],[15,24,28,48],[15,24,28,49],
 [15,24,28,52],[15,24,28,58],[15,24,28,59],
 [15,24,28,60],[15,24,28,61],[15,24,28,68],
 [15,24,29,31],[15,24,29,32],[15,24,29,36],
 [15,24,29,41],[15,24,29,42],[15,24,29,44],
 [15,24,29,47],[15,24,29,48],[15,24,29,49],
 [15,24,29,59],[15,24,29,61],[15,24,29,68],
 [15,24,29,69],[15,24,30,41],[15,24,30,44],
 [15,24,30,47],[15,24,30,48],[15,24,30,49],
 [15,24,30,58],[15,24,30,59],[15,24,30,61],
 [15,24,30,68],[15,24,31,32],[15,24,31,36],
 [15,24,31,41],[15,24,31,42],[15,24,31,44],
 [15,24,31,47],[15,24,31,49],[15,24,31,59],
 [15,24,31,61],[15,24,31,67],[15,24,31,68],
 [15,24,32,40],[15,24,32,41],[15,24,32,44],
 [15,24,32,47],[15,24,32,49],[15,24,32,51],
 [15,24,32,59],[15,24,32,60],[15,24,32,61],
 [15,24,32,63],[15,24,32,68],[15,24,34,36],
 [15,24,34,39],[15,24,34,41],[15,24,34,43],
 [15,24,34,44],[15,24,34,45],[15,24,34,46],
 [15,24,34,47],[15,24,34,48],[15,24,34,49],
 [15,24,34,52],[15,24,34,55],[15,24,34,56],
 [15,24,34,58],[15,24,34,59],[15,24,34,60],
 [15,24,34,61],[15,24,34,62],[15,24,34,66],
 [15,24,34,67],[15,24,34,68],[15,24,34,69],
 [15,24,36,37],[15,24,36,38],[15,24,36,46],
 [15,24,36,48],[15,24,36,49],[15,24,36,51],
 [15,24,36,52],[15,24,36,54],[15,24,36,55],
 [15,24,36,57],[15,24,36,59],[15,24,36,61],
 [15,24,36,62],[15,24,36,63],[15,24,36,64],
 [15,24,36,65],[15,24,36,66],[15,24,36,68],
 [15,24,36,69],[15,24,37,38],[15,24,37,39],
 [15,24,37,40],[15,24,37,42],[15,24,37,43],
 [15,24,37,44],[15,24,37,46],[15,24,37,47],
 [15,24,37,48],[15,24,37,52],[15,24,37,54],
 [15,24,37,56],[15,24,37,58],[15,24,37,59],
 [15,24,37,60],[15,24,37,61],[15,24,37,63],
 [15,24,37,67],[15,24,37,68],[15,24,38,40],
 [15,24,38,41],[15,24,38,42],[15,24,38,44],
 [15,24,38,45],[15,24,38,47],[15,24,38,49],
 [15,24,38,52],[15,24,38,55],[15,24,38,59],
 [15,24,38,61],[15,24,38,63],[15,24,38,64],
 [15,24,38,65],[15,24,38,67],[15,24,38,68],
 [15,24,39,41],[15,24,39,43],[15,24,39,44],
 [15,24,39,45],[15,24,39,46],[15,24,39,47],
 [15,24,39,48],[15,24,39,49],[15,24,39,52],
 [15,24,39,55],[15,24,39,58],[15,24,39,59],
 [15,24,39,60],[15,24,39,61],[15,24,39,62],
 [15,24,39,63],[15,24,39,64],[15,24,39,65],
 [15,24,39,66],[15,24,39,67],[15,24,39,68],
 [15,24,39,69],[15,24,40,41],[15,24,40,42],
 [15,24,40,44],[15,24,40,47],[15,24,40,48],
 [15,24,40,49],[15,24,40,52],[15,24,40,55],
 [15,24,40,59],[15,24,40,61],[15,24,40,63],
 [15,24,40,64],[15,24,40,65],[15,24,40,68],
 [15,24,40,69],[15,24,41,42],[15,24,41,43],
 [15,24,41,44],[15,24,41,45],[15,24,41,46],
 [15,24,41,47],[15,24,41,48],[15,24,41,49],
 [15,24,41,54],[15,24,41,55],[15,24,41,56],
 [15,24,41,57],[15,24,41,58],[15,24,41,59],
 [15,24,41,60],[15,24,41,61],[15,24,41,62],
 [15,24,41,63],[15,24,41,64],[15,24,41,65],
 [15,24,41,66],[15,24,41,67],[15,24,41,68],
 [15,24,41,69],[15,24,42,44],[15,24,42,46],
 [15,24,42,47],[15,24,42,49],[15,24,42,52],
 [15,24,42,55],[15,24,42,59],[15,24,42,61],
 [15,24,42,62],[15,24,42,63],[15,24,42,64],
 [15,24,42,65],[15,24,42,68],[15,24,43,44],
 [15,24,43,45],[15,24,43,46],[15,24,43,47],
 [15,24,43,48],[15,24,43,49],[15,24,43,52],
 [15,24,43,55],[15,24,43,57],[15,24,43,58],
 [15,24,43,59],[15,24,43,60],[15,24,43,61],
 [15,24,43,62],[15,24,43,65],[15,24,43,66],
 [15,24,43,67],[15,24,43,68],[15,24,43,69],
 [15,24,44,45],[15,24,44,46],[15,24,44,47],
 [15,24,44,48],[15,24,44,49],[15,24,44,51],
 [15,24,44,52],[15,24,44,54],[15,24,44,55],
 [15,24,44,56],[15,24,44,57],[15,24,44,58],
 [15,24,44,59],[15,24,44,60],[15,24,44,61],
 [15,24,44,62],[15,24,44,63],[15,24,44,64],
 [15,24,44,65],[15,24,44,66],[15,24,44,67],
 [15,24,44,68],[15,24,44,69],[15,24,45,46],
 [15,24,45,47],[15,24,45,48],[15,24,45,49],
 [15,24,45,51],[15,24,45,54],[15,24,45,55],
 [15,24,45,58],[15,24,45,59],[15,24,45,60],
 [15,24,45,61],[15,24,45,62],[15,24,45,66],
 [15,24,45,67],[15,24,45,68],[15,24,45,69],
 [15,24,46,47],[15,24,46,48],[15,24,46,49],
 [15,24,46,52],[15,24,46,55],[15,24,46,56],
 [15,24,46,57],[15,24,46,58],[15,24,46,59],
 [15,24,46,60],[15,24,46,61],[15,24,46,62],
 [15,24,46,66],[15,24,46,67],[15,24,46,68],
 [15,24,46,69],[15,24,47,48],[15,24,47,49],
 [15,24,47,51],[15,24,47,52],[15,24,47,54],
 [15,24,47,55],[15,24,47,56],[15,24,47,57],
 [15,24,47,58],[15,24,47,59],[15,24,47,60],
 [15,24,47,61],[15,24,47,62],[15,24,47,63],
 [15,24,47,64],[15,24,47,65],[15,24,47,66],
 [15,24,47,67],[15,24,47,68],[15,24,47,69],
 [15,24,48,49],[15,24,48,51],[15,24,48,52],
 [15,24,48,55],[15,24,48,56],[15,24,48,57],
 [15,24,48,58],[15,24,48,59],[15,24,48,60],
 [15,24,48,61],[15,24,48,62],[15,24,48,63],
 [15,24,48,66],[15,24,48,67],[15,24,48,68],
 [15,24,48,69],[15,24,49,52],[15,24,49,54],
 [15,24,49,55],[15,24,49,56],[15,24,49,57],
 [15,24,49,58],[15,24,49,59],[15,24,49,60],
 [15,24,49,61],[15,24,49,62],[15,24,49,63],
 [15,24,49,64],[15,24,49,65],[15,24,49,66],
 [15,24,49,67],[15,24,49,68],[15,24,49,69],
 [15,24,51,52],[15,24,51,55],[15,24,51,56],
 [15,24,51,57],[15,24,51,58],[15,24,51,59],
 [15,24,51,60],[15,24,51,61],[15,24,51,62],
 [15,24,51,63],[15,24,51,64],[15,24,51,65],
 [15,24,51,66],[15,24,51,67],[15,24,51,68],
 [15,24,51,69],[15,24,52,54],[15,24,52,57],
 [15,24,52,61],[15,24,52,62],[15,24,52,66],
 [15,24,52,67],[15,24,52,69],[15,24,54,56],
 [15,24,54,57],[15,24,54,59],[15,24,54,60],
 [15,24,54,61],[15,24,54,62],[15,24,54,67],
 [15,24,54,68],[15,24,54,69],[15,24,55,58],
 [15,24,55,59],[15,24,55,60],[15,24,55,61],
 [15,24,55,62],[15,24,55,66],[15,24,55,67],
 [15,24,55,68],[15,24,55,69],[15,24,56,57],
 [15,24,56,59],[15,24,56,61],[15,24,56,62],
 [15,24,56,68],[15,24,56,69],[15,24,57,59],
 [15,24,57,60],[15,24,57,61],[15,24,57,67],
 [15,24,57,68],[15,24,58,59],[15,24,58,60],
 [15,24,58,61],[15,24,58,62],[15,24,58,66],
 [15,24,58,67],[15,24,58,68],[15,24,58,69],
 [15,24,59,60],[15,24,59,61],[15,24,59,62],
 [15,24,59,63],[15,24,59,64],[15,24,59,65],
 [15,24,59,66],[15,24,59,67],[15,24,59,68],
 [15,24,59,69],[15,24,60,61],[15,24,60,62],
 [15,24,60,65],[15,24,60,66],[15,24,60,67],
 [15,24,60,68],[15,24,60,69],[15,24,61,62],
 [15,24,61,63],[15,24,61,64],[15,24,61,65],
 [15,24,61,66],[15,24,61,67],[15,24,61,68],
 [15,24,61,69],[15,24,62,66],[15,24,62,67],
 [15,24,62,68],[15,24,62,69],[15,24,63,64],
 [15,24,63,65],[15,24,63,66],[15,24,63,68],
 [15,24,63,69],[15,24,64,65],[15,24,64,67],
 [15,24,64,68],[15,24,65,68],[15,24,66,67],
 [15,24,66,68],[15,24,66,69],[15,24,67,68],
 [15,24,67,69],[15,24,68,69],[15,25,26,27],
 [15,25,26,31],[15,25,26,34],[15,25,26,37],
 [15,25,26,39],[15,25,26,40],[15,25,26,41],
 [15,25,26,43],[15,25,26,44],[15,25,26,45],
 [15,25,26,46],[15,25,26,47],[15,25,26,48],
 [15,25,26,49],[15,25,26,51],[15,25,26,54],
 [15,25,26,55],[15,25,26,57],[15,25,26,58],
 [15,25,26,59],[15,25,26,60],[15,25,26,61],
 [15,25,26,62],[15,25,26,66],[15,25,26,67],
 [15,25,26,68],[15,25,26,69],[15,25,27,34],
 [15,25,27,39],[15,25,27,41],[15,25,27,43],
 [15,25,27,44],[15,25,27,45],[15,25,27,46],
 [15,25,27,47],[15,25,27,48],[15,25,27,49],
 [15,25,27,51],[15,25,27,54],[15,25,27,55],
 [15,25,27,58],[15,25,27,59],[15,25,27,60],
 [15,25,27,61],[15,25,27,62],[15,25,27,66],
 [15,25,27,67],[15,25,27,68],[15,25,27,69],
 [15,25,31,41],[15,25,31,44],[15,25,31,47],
 [15,25,31,49],[15,25,31,61],[15,25,31,67],
 [15,25,31,68],[15,25,34,39],[15,25,34,41],
 [15,25,34,43],[15,25,34,44],[15,25,34,45],
 [15,25,34,46],[15,25,34,47],[15,25,34,48],
 [15,25,34,49],[15,25,34,55],[15,25,34,58],
 [15,25,34,59],[15,25,34,60],[15,25,34,61],
 [15,25,34,62],[15,25,34,66],[15,25,34,67],
 [15,25,34,68],[15,25,34,69],[15,25,37,39],
 [15,25,37,40],[15,25,37,43],[15,25,37,44],
 [15,25,37,46],[15,25,37,47],[15,25,37,48],
 [15,25,37,54],[15,25,37,58],[15,25,37,59],
 [15,25,37,60],[15,25,37,61],[15,25,37,67],
 [15,25,37,68],[15,25,39,41],[15,25,39,43],
 [15,25,39,44],[15,25,39,45],[15,25,39,46],
 [15,25,39,47],[15,25,39,48],[15,25,39,49],
 [15,25,39,55],[15,25,39,58],[15,25,39,59],
 [15,25,39,60],[15,25,39,61],[15,25,39,62],
 [15,25,39,65],[15,25,39,66],[15,25,39,67],
 [15,25,39,68],[15,25,39,69],[15,25,40,41],
 [15,25,40,44],[15,25,40,47],[15,25,40,48],
 [15,25,40,49],[15,25,40,55],[15,25,40,59],
 [15,25,40,61],[15,25,40,65],[15,25,40,68],
 [15,25,40,69],[15,25,41,43],[15,25,41,44],
 [15,25,41,45],[15,25,41,46],[15,25,41,47],
 [15,25,41,48],[15,25,41,49],[15,25,41,53],
 [15,25,41,54],[15,25,41,55],[15,25,41,58],
 [15,25,41,59],[15,25,41,60],[15,25,41,61],
 [15,25,41,62],[15,25,41,65],[15,25,41,66],
 [15,25,41,67],[15,25,41,68],[15,25,41,69],
 [15,25,43,44],[15,25,43,45],[15,25,43,46],
 [15,25,43,47],[15,25,43,48],[15,25,43,49],
 [15,25,43,55],[15,25,43,57],[15,25,43,58],
 [15,25,43,59],[15,25,43,60],[15,25,43,61],
 [15,25,43,62],[15,25,43,65],[15,25,43,66],
 [15,25,43,67],[15,25,43,68],[15,25,43,69],
 [15,25,44,45],[15,25,44,46],[15,25,44,47],
 [15,25,44,48],[15,25,44,49],[15,25,44,51],
 [15,25,44,54],[15,25,44,55],[15,25,44,57],
 [15,25,44,58],[15,25,44,59],[15,25,44,60],
 [15,25,44,61],[15,25,44,62],[15,25,44,66],
 [15,25,44,67],[15,25,44,68],[15,25,44,69],
 [15,25,45,46],[15,25,45,47],[15,25,45,48],
 [15,25,45,49],[15,25,45,51],[15,25,45,54],
 [15,25,45,55],[15,25,45,58],[15,25,45,59],
 [15,25,45,60],[15,25,45,61],[15,25,45,62],
 [15,25,45,66],[15,25,45,67],[15,25,45,68],
 [15,25,45,69],[15,25,46,47],[15,25,46,48],
 [15,25,46,49],[15,25,46,53],[15,25,46,55],
 [15,25,46,57],[15,25,46,58],[15,25,46,59],
 [15,25,46,60],[15,25,46,61],[15,25,46,62],
 [15,25,46,66],[15,25,46,67],[15,25,46,68],
 [15,25,46,69],[15,25,47,48],[15,25,47,49],
 [15,25,47,51],[15,25,47,53],[15,25,47,55],
 [15,25,47,57],[15,25,47,58],[15,25,47,59],
 [15,25,47,60],[15,25,47,61],[15,25,47,62],
 [15,25,47,65],[15,25,47,66],[15,25,47,67],
 [15,25,47,68],[15,25,47,69],[15,25,48,49],
 [15,25,48,51],[15,25,48,53],[15,25,48,55],
 [15,25,48,57],[15,25,48,58],[15,25,48,59],
 [15,25,48,60],[15,25,48,61],[15,25,48,62],
 [15,25,48,66],[15,25,48,67],[15,25,48,68],
 [15,25,48,69],[15,25,49,53],[15,25,49,54],
 [15,25,49,55],[15,25,49,57],[15,25,49,58],
 [15,25,49,59],[15,25,49,60],[15,25,49,61],
 [15,25,49,62],[15,25,49,65],[15,25,49,66],
 [15,25,49,67],[15,25,49,68],[15,25,49,69],
 [15,25,51,53],[15,25,51,55],[15,25,51,57],
 [15,25,51,58],[15,25,51,59],[15,25,51,60],
 [15,25,51,61],[15,25,51,62],[15,25,51,65],
 [15,25,51,66],[15,25,51,67],[15,25,51,68],
 [15,25,51,69],[15,25,53,54],[15,25,53,58],
 [15,25,53,60],[15,25,53,67],[15,25,53,68],
 [15,25,54,57],[15,25,54,58],[15,25,54,60],
 [15,25,54,61],[15,25,54,62],[15,25,54,67],
 [15,25,54,68],[15,25,54,69],[15,25,55,58],
 [15,25,55,59],[15,25,55,60],[15,25,55,61],
 [15,25,55,62],[15,25,55,66],[15,25,55,67],
 [15,25,55,68],[15,25,55,69],[15,25,57,59],
 [15,25,57,60],[15,25,57,61],[15,25,57,67],
 [15,25,58,59],[15,25,58,60],[15,25,58,61],
 [15,25,58,62],[15,25,58,66],[15,25,58,67],
 [15,25,58,68],[15,25,58,69],[15,25,59,60],
 [15,25,59,61],[15,25,59,62],[15,25,59,65],
 [15,25,59,66],[15,25,59,67],[15,25,59,68],
 [15,25,59,69],[15,25,60,61],[15,25,60,62],
 [15,25,60,65],[15,25,60,66],[15,25,60,67],
 [15,25,60,68],[15,25,60,69],[15,25,61,62],
 [15,25,61,65],[15,25,61,66],[15,25,61,67],
 [15,25,61,68],[15,25,61,69],[15,25,62,66],
 [15,25,62,67],[15,25,62,68],[15,25,62,69],
 [15,25,65,68],[15,25,66,67],[15,25,66,68],
 [15,25,66,69],[15,25,67,68],[15,25,67,69],
 [15,25,68,69],[15,26,27,28],[15,26,27,34],
 [15,26,27,36],[15,26,27,39],[15,26,27,41],
 [15,26,27,43],[15,26,27,44],[15,26,27,45],
 [15,26,27,46],[15,26,27,47],[15,26,27,48],
 [15,26,27,49],[15,26,27,51],[15,26,27,52],
 [15,26,27,54],[15,26,27,55],[15,26,27,56],
 [15,26,27,58],[15,26,27,59],[15,26,27,60],
 [15,26,27,61],[15,26,27,62],[15,26,27,64],
 [15,26,27,66],[15,26,27,67],[15,26,27,68],
 [15,26,27,69],[15,26,28,30],[15,26,28,41],
 [15,26,28,44],[15,26,28,47],[15,26,28,49],
 [15,26,28,52],[15,26,28,58],[15,26,28,59],
 [15,26,28,60],[15,26,28,61],[15,26,28,68],
 [15,26,29,31],[15,26,29,32],[15,26,29,41],
 [15,26,29,44],[15,26,29,47],[15,26,29,49],
 [15,26,29,52],[15,26,29,59],[15,26,29,60],
 [15,26,29,61],[15,26,29,64],[15,26,29,68],
 [15,26,30,41],[15,26,30,44],[15,26,30,47],
 [15,26,30,48],[15,26,30,49],[15,26,30,59],
 [15,26,30,60],[15,26,30,61],[15,26,30,68],
 [15,26,31,32],[15,26,31,36],[15,26,31,41],
 [15,26,31,42],[15,26,31,44],[15,26,31,47],
 [15,26,31,49],[15,26,31,59],[15,26,31,61],
 [15,26,31,63],[15,26,31,67],[15,26,31,68],
 [15,26,32,40],[15,26,32,41],[15,26,32,44],
 [15,26,32,47],[15,26,32,49],[15,26,32,51],
 [15,26,32,59],[15,26,32,60],[15,26,32,61],
 [15,26,32,68],[15,26,34,36],[15,26,34,39],
 [15,26,34,41],[15,26,34,43],[15,26,34,44],
 [15,26,34,45],[15,26,34,46],[15,26,34,47],
 [15,26,34,48],[15,26,34,49],[15,26,34,52],
 [15,26,34,55],[15,26,34,56],[15,26,34,58],
 [15,26,34,59],[15,26,34,60],[15,26,34,61],
 [15,26,34,62],[15,26,34,66],[15,26,34,67],
 [15,26,34,68],[15,26,34,69],[15,26,36,37],
 [15,26,36,46],[15,26,36,48],[15,26,36,49],
 [15,26,36,51],[15,26,36,52],[15,26,36,54],
 [15,26,36,55],[15,26,36,57],[15,26,36,59],
 [15,26,36,61],[15,26,36,62],[15,26,36,63],
 [15,26,36,64],[15,26,36,65],[15,26,36,66],
 [15,26,36,68],[15,26,36,69],[15,26,37,38],
 [15,26,37,39],[15,26,37,40],[15,26,37,42],
 [15,26,37,43],[15,26,37,44],[15,26,37,46],
 [15,26,37,47],[15,26,37,48],[15,26,37,52],
 [15,26,37,54],[15,26,37,56],[15,26,37,59],
 [15,26,37,60],[15,26,37,61],[15,26,37,67],
 [15,26,37,68],[15,26,38,40],[15,26,38,41],
 [15,26,38,42],[15,26,38,44],[15,26,38,47],
 [15,26,38,49],[15,26,38,52],[15,26,38,55],
 [15,26,38,59],[15,26,38,60],[15,26,38,61],
 [15,26,38,63],[15,26,38,64],[15,26,38,65],
 [15,26,38,68],[15,26,39,41],[15,26,39,43],
 [15,26,39,44],[15,26,39,45],[15,26,39,46],
 [15,26,39,47],[15,26,39,48],[15,26,39,49],
 [15,26,39,55],[15,26,39,58],[15,26,39,59],
 [15,26,39,60],[15,26,39,61],[15,26,39,62],
 [15,26,39,63],[15,26,39,64],[15,26,39,65],
 [15,26,39,66],[15,26,39,67],[15,26,39,68],
 [15,26,39,69],[15,26,40,41],[15,26,40,42],
 [15,26,40,44],[15,26,40,47],[15,26,40,48],
 [15,26,40,49],[15,26,40,52],[15,26,40,55],
 [15,26,40,59],[15,26,40,61],[15,26,40,63],
 [15,26,40,64],[15,26,40,65],[15,26,40,68],
 [15,26,40,69],[15,26,41,42],[15,26,41,43],
 [15,26,41,44],[15,26,41,45],[15,26,41,46],
 [15,26,41,47],[15,26,41,48],[15,26,41,49],
 [15,26,41,54],[15,26,41,55],[15,26,41,56],
 [15,26,41,57],[15,26,41,58],[15,26,41,59],
 [15,26,41,60],[15,26,41,61],[15,26,41,62],
 [15,26,41,63],[15,26,41,64],[15,26,41,65],
 [15,26,41,66],[15,26,41,67],[15,26,41,68],
 [15,26,41,69],[15,26,42,44],[15,26,42,46],
 [15,26,42,47],[15,26,42,49],[15,26,42,52],
 [15,26,42,55],[15,26,42,59],[15,26,42,61],
 [15,26,42,62],[15,26,42,63],[15,26,42,64],
 [15,26,42,65],[15,26,42,68],[15,26,43,44],
 [15,26,43,45],[15,26,43,46],[15,26,43,47],
 [15,26,43,48],[15,26,43,49],[15,26,43,52],
 [15,26,43,55],[15,26,43,58],[15,26,43,59],
 [15,26,43,60],[15,26,43,61],[15,26,43,62],
 [15,26,43,66],[15,26,43,67],[15,26,43,68],
 [15,26,43,69],[15,26,44,45],[15,26,44,46],
 [15,26,44,47],[15,26,44,48],[15,26,44,49],
 [15,26,44,51],[15,26,44,52],[15,26,44,54],
 [15,26,44,55],[15,26,44,56],[15,26,44,57],
 [15,26,44,58],[15,26,44,59],[15,26,44,60],
 [15,26,44,61],[15,26,44,62],[15,26,44,63],
 [15,26,44,64],[15,26,44,65],[15,26,44,66],
 [15,26,44,67],[15,26,44,68],[15,26,44,69],
 [15,26,45,46],[15,26,45,47],[15,26,45,48],
 [15,26,45,49],[15,26,45,51],[15,26,45,52],
 [15,26,45,55],[15,26,45,58],[15,26,45,59],
 [15,26,45,60],[15,26,45,61],[15,26,45,62],
 [15,26,45,66],[15,26,45,67],[15,26,45,68],
 [15,26,45,69],[15,26,46,47],[15,26,46,48],
 [15,26,46,49],[15,26,46,52],[15,26,46,55],
 [15,26,46,56],[15,26,46,57],[15,26,46,58],
 [15,26,46,59],[15,26,46,60],[15,26,46,61],
 [15,26,46,62],[15,26,46,63],[15,26,46,66],
 [15,26,46,67],[15,26,46,68],[15,26,46,69],
 [15,26,47,48],[15,26,47,49],[15,26,47,51],
 [15,26,47,52],[15,26,47,54],[15,26,47,55],
 [15,26,47,56],[15,26,47,57],[15,26,47,58],
 [15,26,47,59],[15,26,47,60],[15,26,47,61],
 [15,26,47,62],[15,26,47,63],[15,26,47,64],
 [15,26,47,65],[15,26,47,66],[15,26,47,67],
 [15,26,47,68],[15,26,47,69],[15,26,48,49],
 [15,26,48,51],[15,26,48,52],[15,26,48,55],
 [15,26,48,56],[15,26,48,57],[15,26,48,58],
 [15,26,48,59],[15,26,48,60],[15,26,48,61],
 [15,26,48,62],[15,26,48,66],[15,26,48,67],
 [15,26,48,68],[15,26,48,69],[15,26,49,52],
 [15,26,49,54],[15,26,49,55],[15,26,49,56],
 [15,26,49,57],[15,26,49,58],[15,26,49,59],
 [15,26,49,60],[15,26,49,61],[15,26,49,62],
 [15,26,49,63],[15,26,49,64],[15,26,49,65],
 [15,26,49,66],[15,26,49,67],[15,26,49,68],
 [15,26,49,69],[15,26,51,52],[15,26,51,56],
 [15,26,51,57],[15,26,51,58],[15,26,51,59],
 [15,26,51,60],[15,26,51,61],[15,26,51,62],
 [15,26,51,63],[15,26,51,64],[15,26,51,65],
 [15,26,51,66],[15,26,51,67],[15,26,51,68],
 [15,26,51,69],[15,26,52,54],[15,26,52,57],
 [15,26,52,61],[15,26,52,62],[15,26,52,66],
 [15,26,52,67],[15,26,52,69],[15,26,54,56],
 [15,26,54,57],[15,26,54,58],[15,26,54,59],
 [15,26,54,60],[15,26,54,61],[15,26,54,62],
 [15,26,54,67],[15,26,54,68],[15,26,54,69],
 [15,26,55,58],[15,26,55,59],[15,26,55,60],
 [15,26,55,61],[15,26,55,62],[15,26,55,66],
 [15,26,55,67],[15,26,55,68],[15,26,55,69],
 [15,26,56,57],[15,26,56,59],[15,26,56,61],
 [15,26,56,62],[15,26,56,66],[15,26,56,68],
 [15,26,56,69],[15,26,57,59],[15,26,57,60],
 [15,26,57,61],[15,26,57,67],[15,26,57,68],
 [15,26,58,59],[15,26,58,60],[15,26,58,61],
 [15,26,58,62],[15,26,58,66],[15,26,58,67],
 [15,26,58,68],[15,26,58,69],[15,26,59,60],
 [15,26,59,61],[15,26,59,62],[15,26,59,63],
 [15,26,59,64],[15,26,59,65],[15,26,59,66],
 [15,26,59,67],[15,26,59,68],[15,26,59,69],
 [15,26,60,61],[15,26,60,62],[15,26,60,65],
 [15,26,60,66],[15,26,60,67],[15,26,60,68],
 [15,26,60,69],[15,26,61,62],[15,26,61,63],
 [15,26,61,64],[15,26,61,65],[15,26,61,66],
 [15,26,61,67],[15,26,61,68],[15,26,61,69],
 [15,26,62,63],[15,26,62,66],[15,26,62,67],
 [15,26,62,68],[15,26,62,69],[15,26,63,64],
 [15,26,63,65],[15,26,63,68],[15,26,64,65],
 [15,26,64,67],[15,26,64,68],[15,26,65,68],
 [15,26,66,67],[15,26,66,68],[15,26,66,69],
 [15,26,67,68],[15,26,67,69],[15,26,68,69],
 [15,27,28,30],[15,27,28,44],[15,27,28,47],
 [15,27,28,48],[15,27,28,52],[15,27,28,58],
 [15,27,28,60],[15,27,28,61],[15,27,28,68],
 [15,27,30,47],[15,27,30,48],[15,27,30,49],
 [15,27,30,60],[15,27,30,61],[15,27,32,41],
 [15,27,32,44],[15,27,32,47],[15,27,32,49],
 [15,27,32,51],[15,27,32,60],[15,27,32,61],
 [15,27,32,68],[15,27,34,36],[15,27,34,39],
 [15,27,34,41],[15,27,34,43],[15,27,34,44],
 [15,27,34,45],[15,27,34,46],[15,27,34,47],
 [15,27,34,48],[15,27,34,49],[15,27,34,52],
 [15,27,34,55],[15,27,34,56],[15,27,34,58],
 [15,27,34,59],[15,27,34,60],[15,27,34,61],
 [15,27,34,62],[15,27,34,66],[15,27,34,67],
 [15,27,34,68],[15,27,34,69],[15,27,36,46],
 [15,27,36,48],[15,27,36,49],[15,27,36,51],
 [15,27,36,52],[15,27,36,54],[15,27,36,55],
 [15,27,36,59],[15,27,36,61],[15,27,36,62],
 [15,27,36,64],[15,27,36,66],[15,27,36,68],
 [15,27,36,69],[15,27,39,41],[15,27,39,43],
 [15,27,39,44],[15,27,39,45],[15,27,39,46],
 [15,27,39,47],[15,27,39,48],[15,27,39,49],
 [15,27,39,52],[15,27,39,55],[15,27,39,58],
 [15,27,39,59],[15,27,39,60],[15,27,39,61],
 [15,27,39,62],[15,27,39,64],[15,27,39,66],
 [15,27,39,67],[15,27,39,68],[15,27,39,69],
 [15,27,41,42],[15,27,41,43],[15,27,41,44],
 [15,27,41,45],[15,27,41,46],[15,27,41,47],
 [15,27,41,48],[15,27,41,49],[15,27,41,54],
 [15,27,41,55],[15,27,41,58],[15,27,41,59],
 [15,27,41,60],[15,27,41,61],[15,27,41,62],
 [15,27,41,64],[15,27,41,66],[15,27,41,67],
 [15,27,41,68],[15,27,41,69],[15,27,42,44],
 [15,27,42,46],[15,27,42,47],[15,27,42,49],
 [15,27,42,52],[15,27,42,55],[15,27,42,59],
 [15,27,42,61],[15,27,42,62],[15,27,42,64],
 [15,27,42,68],[15,27,43,44],[15,27,43,45],
 [15,27,43,46],[15,27,43,47],[15,27,43,48],
 [15,27,43,49],[15,27,43,52],[15,27,43,55],
 [15,27,43,58],[15,27,43,59],[15,27,43,60],
 [15,27,43,61],[15,27,43,62],[15,27,43,66],
 [15,27,43,67],[15,27,43,68],[15,27,43,69],
 [15,27,44,45],[15,27,44,46],[15,27,44,47],
 [15,27,44,48],[15,27,44,49],[15,27,44,52],
 [15,27,44,54],[15,27,44,55],[15,27,44,56],
 [15,27,44,58],[15,27,44,59],[15,27,44,60],
 [15,27,44,61],[15,27,44,62],[15,27,44,64],
 [15,27,44,66],[15,27,44,67],[15,27,44,68],
 [15,27,44,69],[15,27,45,46],[15,27,45,47],
 [15,27,45,48],[15,27,45,49],[15,27,45,51],
 [15,27,45,54],[15,27,45,55],[15,27,45,58],
 [15,27,45,59],[15,27,45,60],[15,27,45,61],
 [15,27,45,62],[15,27,45,66],[15,27,45,67],
 [15,27,45,68],[15,27,45,69],[15,27,46,47],
 [15,27,46,48],[15,27,46,49],[15,27,46,52],
 [15,27,46,55],[15,27,46,56],[15,27,46,58],
 [15,27,46,59],[15,27,46,60],[15,27,46,61],
 [15,27,46,62],[15,27,46,66],[15,27,46,67],
 [15,27,46,68],[15,27,46,69],[15,27,47,48],
 [15,27,47,49],[15,27,47,51],[15,27,47,52],
 [15,27,47,54],[15,27,47,55],[15,27,47,56],
 [15,27,47,58],[15,27,47,59],[15,27,47,60],
 [15,27,47,61],[15,27,47,62],[15,27,47,64],
 [15,27,47,66],[15,27,47,67],[15,27,47,68],
 [15,27,47,69],[15,27,48,49],[15,27,48,51],
 [15,27,48,52],[15,27,48,55],[15,27,48,56],
 [15,27,48,58],[15,27,48,59],[15,27,48,60],
 [15,27,48,61],[15,27,48,62],[15,27,48,66],
 [15,27,48,67],[15,27,48,68],[15,27,48,69],
 [15,27,49,52],[15,27,49,55],[15,27,49,56],
 [15,27,49,58],[15,27,49,59],[15,27,49,60],
 [15,27,49,61],[15,27,49,62],[15,27,49,64],
 [15,27,49,66],[15,27,49,67],[15,27,49,68],
 [15,27,49,69],[15,27,51,52],[15,27,51,56],
 [15,27,51,59],[15,27,51,60],[15,27,51,61],
 [15,27,51,62],[15,27,51,64],[15,27,51,66],
 [15,27,51,67],[15,27,51,68],[15,27,51,69],
 [15,27,52,54],[15,27,52,61],[15,27,52,62],
 [15,27,52,66],[15,27,52,67],[15,27,52,69],
 [15,27,54,56],[15,27,54,58],[15,27,54,60],
 [15,27,54,61],[15,27,54,62],[15,27,54,67],
 [15,27,54,68],[15,27,54,69],[15,27,55,58],
 [15,27,55,59],[15,27,55,60],[15,27,55,61],
 [15,27,55,62],[15,27,55,66],[15,27,55,67],
 [15,27,55,68],[15,27,55,69],[15,27,56,59],
 [15,27,56,61],[15,27,56,62],[15,27,56,66],
 [15,27,56,69],[15,27,58,59],[15,27,58,60],
 [15,27,58,61],[15,27,58,62],[15,27,58,66],
 [15,27,58,67],[15,27,58,68],[15,27,58,69],
 [15,27,59,60],[15,27,59,61],[15,27,59,62],
 [15,27,59,64],[15,27,59,66],[15,27,59,67],
 [15,27,59,68],[15,27,59,69],[15,27,60,61],
 [15,27,60,62],[15,27,60,66],[15,27,60,67],
 [15,27,60,68],[15,27,60,69],[15,27,61,62],
 [15,27,61,64],[15,27,61,66],[15,27,61,67],
 [15,27,61,68],[15,27,61,69],[15,27,62,66],
 [15,27,62,67],[15,27,62,68],[15,27,62,69],
 [15,27,64,67],[15,27,64,68],[15,27,66,67],
 [15,27,66,68],[15,27,66,69],[15,27,67,68],
 [15,27,67,69],[15,27,68,69],[15,28,30,41],
 [15,28,30,44],[15,28,30,47],[15,28,30,48],
 [15,28,30,49],[15,28,30,52],[15,28,30,53],
 [15,28,30,58],[15,28,30,59],[15,28,30,60],
 [15,28,30,61],[15,28,30,68],[15,28,41,44],
 [15,28,41,47],[15,28,41,49],[15,28,41,59],
 [15,28,41,61],[15,28,41,68],[15,28,44,47],
 [15,28,44,49],[15,28,44,53],[15,28,44,58],
 [15,28,44,59],[15,28,44,60],[15,28,44,61],
 [15,28,44,68],[15,28,47,49],[15,28,47,52],
 [15,28,47,53],[15,28,47,58],[15,28,47,59],
 [15,28,47,60],[15,28,47,61],[15,28,47,68],
 [15,28,48,49],[15,28,48,52],[15,28,48,53],
 [15,28,48,58],[15,28,48,59],[15,28,48,60],
 [15,28,48,61],[15,28,48,68],[15,28,49,52],
 [15,28,49,53],[15,28,49,58],[15,28,49,59],
 [15,28,49,60],[15,28,49,61],[15,28,49,68],
 [15,28,53,60],[15,28,58,68],[15,28,59,61],
 [15,28,59,68],[15,28,61,68],[15,29,31,32],
 [15,29,31,36],[15,29,31,41],[15,29,31,42],
 [15,29,31,44],[15,29,31,47],[15,29,31,49],
 [15,29,31,59],[15,29,31,61],[15,29,31,68],
 [15,29,32,41],[15,29,32,44],[15,29,32,47],
 [15,29,32,49],[15,29,32,59],[15,29,32,60],
 [15,29,32,61],[15,29,32,68],[15,29,36,48],
 [15,29,36,49],[15,29,36,52],[15,29,36,59],
 [15,29,36,61],[15,29,36,64],[15,29,36,68],
 [15,29,36,69],[15,29,41,42],[15,29,41,44],
 [15,29,41,47],[15,29,41,48],[15,29,41,49],
 [15,29,41,59],[15,29,41,60],[15,29,41,61],
 [15,29,41,64],[15,29,41,68],[15,29,41,69],
 [15,29,42,44],[15,29,42,47],[15,29,42,49],
 [15,29,42,52],[15,29,42,59],[15,29,42,61],
 [15,29,42,64],[15,29,42,68],[15,29,44,47],
 [15,29,44,48],[15,29,44,49],[15,29,44,52],
 [15,29,44,59],[15,29,44,60],[15,29,44,61],
 [15,29,44,64],[15,29,44,68],[15,29,47,48],
 [15,29,47,49],[15,29,47,52],[15,29,47,59],
 [15,29,47,60],[15,29,47,61],[15,29,47,64],
 [15,29,47,68],[15,29,47,69],[15,29,48,49],
 [15,29,48,52],[15,29,48,60],[15,29,48,61],
 [15,29,48,68],[15,29,48,69],[15,29,49,52],
 [15,29,49,59],[15,29,49,60],[15,29,49,61],
 [15,29,49,64],[15,29,49,68],[15,29,49,69],
 [15,29,52,61],[15,29,52,69],[15,29,59,61],
 [15,29,59,64],[15,29,59,68],[15,29,59,69],
 [15,29,60,61],[15,29,60,68],[15,29,60,69],
 [15,29,61,64],[15,29,61,68],[15,29,61,69],
 [15,29,64,68],[15,29,68,69],[15,30,41,44],
 [15,30,41,47],[15,30,41,49],[15,30,41,53],
 [15,30,41,59],[15,30,41,61],[15,30,41,68],
 [15,30,44,47],[15,30,44,48],[15,30,44,49],
 [15,30,44,53],[15,30,44,59],[15,30,44,61],
 [15,30,44,68],[15,30,47,48],[15,30,47,49],
 [15,30,47,53],[15,30,47,59],[15,30,47,61],
 [15,30,47,68],[15,30,48,52],[15,30,48,58],
 [15,30,48,60],[15,30,48,68],[15,30,49,52],
 [15,30,49,53],[15,30,49,59],[15,30,49,60],
 [15,30,49,61],[15,30,49,68],[15,30,52,53],
 [15,30,52,61],[15,30,53,58],[15,30,53,60],
 [15,30,53,68],[15,30,58,60],[15,30,58,61],
 [15,30,59,60],[15,30,59,61],[15,30,59,68],
 [15,30,60,61],[15,30,60,68],[15,30,61,68],
 [15,31,32,41],[15,31,32,44],[15,31,32,47],
 [15,31,32,49],[15,31,32,59],[15,31,32,61],
 [15,31,32,63],[15,31,32,68],[15,31,36,49],
 [15,31,36,59],[15,31,36,63],[15,31,36,68],
 [15,31,41,42],[15,31,41,44],[15,31,41,47],
 [15,31,41,49],[15,31,41,59],[15,31,41,61],
 [15,31,41,63],[15,31,41,67],[15,31,41,68],
 [15,31,42,44],[15,31,42,47],[15,31,42,49],
 [15,31,42,63],[15,31,42,68],[15,31,44,47],
 [15,31,44,49],[15,31,44,59],[15,31,44,61],
 [15,31,44,63],[15,31,44,67],[15,31,44,68],
 [15,31,47,49],[15,31,47,59],[15,31,47,61],
 [15,31,47,63],[15,31,47,67],[15,31,47,68],
 [15,31,49,59],[15,31,49,61],[15,31,49,63],
 [15,31,49,67],[15,31,49,68],[15,31,59,61],
 [15,31,59,63],[15,31,59,67],[15,31,59,68],
 [15,31,61,63],[15,31,61,68],[15,31,63,68],
 [15,31,67,68],[15,32,40,41],[15,32,40,44],
 [15,32,40,47],[15,32,40,49],[15,32,40,63],
 [15,32,40,68],[15,32,41,44],[15,32,41,47],
 [15,32,41,49],[15,32,41,59],[15,32,41,60],
 [15,32,41,61],[15,32,41,63],[15,32,41,68],
 [15,32,44,47],[15,32,44,49],[15,32,44,59],
 [15,32,44,60],[15,32,44,61],[15,32,44,68],
 [15,32,47,49],[15,32,47,51],[15,32,47,59],
 [15,32,47,60],[15,32,47,61],[15,32,47,63],
 [15,32,47,68],[15,32,49,59],[15,32,49,60],
 [15,32,49,61],[15,32,49,63],[15,32,49,68],
 [15,32,51,60],[15,32,51,63],[15,32,51,68],
 [15,32,59,60],[15,32,59,61],[15,32,59,68],
 [15,32,60,68],[15,32,61,63],[15,32,61,68],
 [15,32,63,68],[15,34,36,46],[15,34,36,48],
 [15,34,36,49],[15,34,36,52],[15,34,36,61],
 [15,34,36,62],[15,34,36,63],[15,34,36,66],
 [15,34,36,69],[15,34,39,41],[15,34,39,43],
 [15,34,39,44],[15,34,39,45],[15,34,39,46],
 [15,34,39,47],[15,34,39,48],[15,34,39,49],
 [15,34,39,55],[15,34,39,58],[15,34,39,59],
 [15,34,39,60],[15,34,39,61],[15,34,39,62],
 [15,34,39,63],[15,34,39,66],[15,34,39,67],
 [15,34,39,68],[15,34,39,69],[15,34,41,43],
 [15,34,41,44],[15,34,41,45],[15,34,41,46],
 [15,34,41,47],[15,34,41,48],[15,34,41,49],
 [15,34,41,55],[15,34,41,58],[15,34,41,59],
 [15,34,41,60],[15,34,41,61],[15,34,41,62],
 [15,34,41,63],[15,34,41,66],[15,34,41,67],
 [15,34,41,68],[15,34,41,69],[15,34,43,44],
 [15,34,43,45],[15,34,43,46],[15,34,43,47],
 [15,34,43,48],[15,34,43,49],[15,34,43,52],
 [15,34,43,55],[15,34,43,58],[15,34,43,59],
 [15,34,43,60],[15,34,43,61],[15,34,43,62],
 [15,34,43,66],[15,34,43,67],[15,34,43,68],
 [15,34,43,69],[15,34,44,45],[15,34,44,46],
 [15,34,44,47],[15,34,44,48],[15,34,44,49],
 [15,34,44,55],[15,34,44,58],[15,34,44,59],
 [15,34,44,60],[15,34,44,61],[15,34,44,62],
 [15,34,44,66],[15,34,44,67],[15,34,44,68],
 [15,34,44,69],[15,34,45,46],[15,34,45,47],
 [15,34,45,48],[15,34,45,49],[15,34,45,52],
 [15,34,45,55],[15,34,45,58],[15,34,45,59],
 [15,34,45,60],[15,34,45,61],[15,34,45,62],
 [15,34,45,66],[15,34,45,67],[15,34,45,68],
 [15,34,45,69],[15,34,46,47],[15,34,46,48],
 [15,34,46,49],[15,34,46,52],[15,34,46,55],
 [15,34,46,56],[15,34,46,58],[15,34,46,59],
 [15,34,46,60],[15,34,46,61],[15,34,46,62],
 [15,34,46,63],[15,34,46,66],[15,34,46,67],
 [15,34,46,68],[15,34,46,69],[15,34,47,48],
 [15,34,47,49],[15,34,47,55],[15,34,47,58],
 [15,34,47,59],[15,34,47,60],[15,34,47,61],
 [15,34,47,62],[15,34,47,63],[15,34,47,66],
 [15,34,47,67],[15,34,47,68],[15,34,47,69],
 [15,34,48,49],[15,34,48,52],[15,34,48,55],
 [15,34,48,56],[15,34,48,58],[15,34,48,59],
 [15,34,48,60],[15,34,48,61],[15,34,48,62],
 [15,34,48,63],[15,34,48,66],[15,34,48,67],
 [15,34,48,68],[15,34,48,69],[15,34,49,52],
 [15,34,49,55],[15,34,49,56],[15,34,49,58],
 [15,34,49,59],[15,34,49,60],[15,34,49,61],
 [15,34,49,62],[15,34,49,63],[15,34,49,66],
 [15,34,49,67],[15,34,49,68],[15,34,49,69],
 [15,34,52,61],[15,34,52,62],[15,34,52,66],
 [15,34,52,69],[15,34,55,58],[15,34,55,59],
 [15,34,55,60],[15,34,55,61],[15,34,55,62],
 [15,34,55,66],[15,34,55,67],[15,34,55,68],
 [15,34,55,69],[15,34,56,61],[15,34,56,62],
 [15,34,56,66],[15,34,56,69],[15,34,58,59],
 [15,34,58,60],[15,34,58,61],[15,34,58,62],
 [15,34,58,66],[15,34,58,67],[15,34,58,68],
 [15,34,58,69],[15,34,59,60],[15,34,59,61],
 [15,34,59,62],[15,34,59,63],[15,34,59,66],
 [15,34,59,67],[15,34,59,68],[15,34,59,69],
 [15,34,60,61],[15,34,60,62],[15,34,60,66],
 [15,34,60,67],[15,34,60,68],[15,34,60,69],
 [15,34,61,62],[15,34,61,63],[15,34,61,66],
 [15,34,61,67],[15,34,61,68],[15,34,61,69],
 [15,34,62,63],[15,34,62,66],[15,34,62,67],
 [15,34,62,68],[15,34,62,69],[15,34,63,66],
 [15,34,63,68],[15,34,63,69],[15,34,66,67],
 [15,34,66,68],[15,34,66,69],[15,34,67,68],
 [15,34,67,69],[15,34,68,69],[15,36,37,38],
 [15,36,37,46],[15,36,37,48],[15,36,37,54],
 [15,36,37,61],[15,36,37,63],[15,36,37,68],
 [15,36,38,49],[15,36,38,52],[15,36,38,55],
 [15,36,38,59],[15,36,38,61],[15,36,38,64],
 [15,36,38,65],[15,36,38,68],[15,36,46,48],
 [15,36,46,49],[15,36,46,52],[15,36,46,53],
 [15,36,46,57],[15,36,46,59],[15,36,46,61],
 [15,36,46,62],[15,36,46,63],[15,36,46,66],
 [15,36,46,68],[15,36,46,69],[15,36,48,49],
 [15,36,48,51],[15,36,48,52],[15,36,48,53],
 [15,36,48,55],[15,36,48,57],[15,36,48,59],
 [15,36,48,61],[15,36,48,62],[15,36,48,63],
 [15,36,48,68],[15,36,48,69],[15,36,49,52],
 [15,36,49,53],[15,36,49,54],[15,36,49,55],
 [15,36,49,57],[15,36,49,59],[15,36,49,61],
 [15,36,49,62],[15,36,49,63],[15,36,49,64],
 [15,36,49,65],[15,36,49,66],[15,36,49,69],
 [15,36,51,53],[15,36,51,57],[15,36,51,59],
 [15,36,51,61],[15,36,51,62],[15,36,51,63],
 [15,36,51,65],[15,36,51,66],[15,36,51,69],
 [15,36,52,61],[15,36,52,62],[15,36,52,66],
 [15,36,52,69],[15,36,53,54],[15,36,54,57],
 [15,36,54,59],[15,36,54,61],[15,36,54,62],
 [15,36,54,68],[15,36,54,69],[15,36,55,61],
 [15,36,55,62],[15,36,55,66],[15,36,55,69],
 [15,36,57,61],[15,36,59,61],[15,36,59,62],
 [15,36,59,63],[15,36,59,64],[15,36,61,62],
 [15,36,61,63],[15,36,61,64],[15,36,61,65],
 [15,36,61,66],[15,36,61,68],[15,36,61,69],
 [15,36,62,63],[15,36,62,66],[15,36,62,68],
 [15,36,62,69],[15,36,63,64],[15,36,63,65],
 [15,36,63,66],[15,36,63,68],[15,36,63,69],
 [15,36,64,65],[15,36,64,68],[15,36,66,69],
 [15,37,38,40],[15,37,38,42],[15,37,38,44],
 [15,37,38,47],[15,37,38,52],[15,37,38,59],
 [15,37,38,60],[15,37,38,61],[15,37,38,67],
 [15,37,38,68],[15,37,39,43],[15,37,39,44],
 [15,37,39,46],[15,37,39,47],[15,37,39,48],
 [15,37,39,58],[15,37,39,60],[15,37,39,61],
 [15,37,39,67],[15,37,40,42],[15,37,40,44],
 [15,37,40,47],[15,37,40,48],[15,37,40,52],
 [15,37,40,59],[15,37,40,61],[15,37,40,63],
 [15,37,40,68],[15,37,42,44],[15,37,42,46],
 [15,37,42,47],[15,37,42,61],[15,37,42,63],
 [15,37,43,44],[15,37,43,46],[15,37,43,47],
 [15,37,43,48],[15,37,43,52],[15,37,43,58],
 [15,37,43,59],[15,37,43,60],[15,37,43,61],
 [15,37,43,67],[15,37,43,68],[15,37,44,46],
 [15,37,44,47],[15,37,44,48],[15,37,44,52],
 [15,37,44,54],[15,37,44,56],[15,37,44,58],
 [15,37,44,59],[15,37,44,60],[15,37,44,61],
 [15,37,44,67],[15,37,46,47],[15,37,46,48],
 [15,37,46,52],[15,37,46,56],[15,37,46,58],
 [15,37,46,59],[15,37,46,60],[15,37,46,61],
 [15,37,46,63],[15,37,46,67],[15,37,46,68],
 [15,37,47,48],[15,37,47,54],[15,37,47,56],
 [15,37,47,58],[15,37,47,59],[15,37,47,60],
 [15,37,47,61],[15,37,47,63],[15,37,47,67],
 [15,37,48,52],[15,37,48,56],[15,37,48,58],
 [15,37,48,60],[15,37,48,61],[15,37,48,63],
 [15,37,48,67],[15,37,48,68],[15,37,52,54],
 [15,37,52,61],[15,37,54,56],[15,37,54,58],
 [15,37,54,60],[15,37,54,61],[15,37,54,67],
 [15,37,54,68],[15,37,56,61],[15,37,58,60],
 [15,37,58,61],[15,37,58,67],[15,37,59,60],
 [15,37,59,61],[15,37,59,63],[15,37,60,61],
 [15,37,60,67],[15,37,60,68],[15,37,61,63],
 [15,37,61,67],[15,37,61,68],[15,37,63,68],
 [15,38,40,41],[15,38,40,42],[15,38,40,44],
 [15,38,40,47],[15,38,40,49],[15,38,40,52],
 [15,38,40,55],[15,38,40,59],[15,38,40,61],
 [15,38,40,63],[15,38,40,64],[15,38,40,65],
 [15,38,40,68],[15,38,41,42],[15,38,41,44],
 [15,38,41,45],[15,38,41,47],[15,38,41,49],
 [15,38,41,59],[15,38,41,60],[15,38,41,61],
 [15,38,41,63],[15,38,41,64],[15,38,41,65],
 [15,38,41,67],[15,38,41,68],[15,38,42,44],
 [15,38,42,47],[15,38,42,49],[15,38,42,52],
 [15,38,42,55],[15,38,42,59],[15,38,42,61],
 [15,38,42,63],[15,38,42,64],[15,38,42,65],
 [15,38,42,68],[15,38,44,45],[15,38,44,47],
 [15,38,44,49],[15,38,44,52],[15,38,44,55],
 [15,38,44,59],[15,38,44,60],[15,38,44,61],
 [15,38,44,63],[15,38,44,64],[15,38,44,65],
 [15,38,44,67],[15,38,44,68],[15,38,45,47],
 [15,38,45,49],[15,38,45,55],[15,38,45,59],
 [15,38,45,60],[15,38,45,61],[15,38,45,67],
 [15,38,45,68],[15,38,47,49],[15,38,47,52],
 [15,38,47,59],[15,38,47,60],[15,38,47,61],
 [15,38,47,63],[15,38,47,64],[15,38,47,65],
 [15,38,47,67],[15,38,47,68],[15,38,49,52],
 [15,38,49,55],[15,38,49,59],[15,38,49,60],
 [15,38,49,61],[15,38,49,63],[15,38,49,64],
 [15,38,49,65],[15,38,49,67],[15,38,49,68],
 [15,38,52,61],[15,38,52,67],[15,38,55,59],
 [15,38,55,60],[15,38,55,61],[15,38,55,67],
 [15,38,55,68],[15,38,59,60],[15,38,59,61],
 [15,38,59,63],[15,38,59,64],[15,38,59,65],
 [15,38,59,67],[15,38,59,68],[15,38,60,61],
 [15,38,60,65],[15,38,60,67],[15,38,60,68],
 [15,38,61,63],[15,38,61,64],[15,38,61,65],
 [15,38,61,67],[15,38,61,68],[15,38,63,64],
 [15,38,63,65],[15,38,63,68],[15,38,64,65],
 [15,38,64,67],[15,38,64,68],[15,38,65,68],
 [15,38,67,68],[15,39,41,43],[15,39,41,44],
 [15,39,41,45],[15,39,41,46],[15,39,41,47],
 [15,39,41,48],[15,39,41,49],[15,39,41,55],
 [15,39,41,58],[15,39,41,59],[15,39,41,60],
 [15,39,41,61],[15,39,41,62],[15,39,41,66],
 [15,39,41,67],[15,39,41,68],[15,39,41,69],
 [15,39,43,44],[15,39,43,45],[15,39,43,46],
 [15,39,43,47],[15,39,43,48],[15,39,43,49],
 [15,39,43,52],[15,39,43,55],[15,39,43,58],
 [15,39,43,59],[15,39,43,60],[15,39,43,61],
 [15,39,43,62],[15,39,43,65],[15,39,43,66],
 [15,39,43,67],[15,39,43,68],[15,39,43,69],
 [15,39,44,45],[15,39,44,46],[15,39,44,47],
 [15,39,44,48],[15,39,44,49],[15,39,44,55],
 [15,39,44,58],[15,39,44,59],[15,39,44,60],
 [15,39,44,61],[15,39,44,62],[15,39,44,63],
 [15,39,44,65],[15,39,44,66],[15,39,44,67],
 [15,39,44,68],[15,39,44,69],[15,39,45,46],
 [15,39,45,47],[15,39,45,48],[15,39,45,49],
 [15,39,45,55],[15,39,45,58],[15,39,45,59],
 [15,39,45,60],[15,39,45,61],[15,39,45,62],
 [15,39,45,66],[15,39,45,67],[15,39,45,68],
 [15,39,45,69],[15,39,46,47],[15,39,46,48],
 [15,39,46,49],[15,39,46,52],[15,39,46,55],
 [15,39,46,58],[15,39,46,59],[15,39,46,60],
 [15,39,46,61],[15,39,46,62],[15,39,46,63],
 [15,39,46,66],[15,39,46,67],[15,39,46,68],
 [15,39,46,69],[15,39,47,48],[15,39,47,49],
 [15,39,47,55],[15,39,47,58],[15,39,47,59],
 [15,39,47,60],[15,39,47,61],[15,39,47,62],
 [15,39,47,63],[15,39,47,66],[15,39,47,67],
 [15,39,47,68],[15,39,47,69],[15,39,48,49],
 [15,39,48,52],[15,39,48,55],[15,39,48,58],
 [15,39,48,59],[15,39,48,60],[15,39,48,61],
 [15,39,48,62],[15,39,48,63],[15,39,48,66],
 [15,39,48,67],[15,39,48,68],[15,39,48,69],
 [15,39,49,52],[15,39,49,55],[15,39,49,58],
 [15,39,49,59],[15,39,49,60],[15,39,49,61],
 [15,39,49,62],[15,39,49,63],[15,39,49,64],
 [15,39,49,65],[15,39,49,66],[15,39,49,67],
 [15,39,49,68],[15,39,49,69],[15,39,52,61],
 [15,39,52,62],[15,39,52,67],[15,39,55,58],
 [15,39,55,59],[15,39,55,60],[15,39,55,61],
 [15,39,55,62],[15,39,55,66],[15,39,55,67],
 [15,39,55,68],[15,39,55,69],[15,39,58,59],
 [15,39,58,60],[15,39,58,61],[15,39,58,62],
 [15,39,58,66],[15,39,58,67],[15,39,58,68],
 [15,39,58,69],[15,39,59,60],[15,39,59,61],
 [15,39,59,62],[15,39,59,63],[15,39,59,64],
 [15,39,59,66],[15,39,59,67],[15,39,59,68],
 [15,39,59,69],[15,39,60,61],[15,39,60,62],
 [15,39,60,65],[15,39,60,66],[15,39,60,67],
 [15,39,60,68],[15,39,60,69],[15,39,61,62],
 [15,39,61,63],[15,39,61,64],[15,39,61,65],
 [15,39,61,66],[15,39,61,67],[15,39,61,68],
 [15,39,61,69],[15,39,62,63],[15,39,62,66],
 [15,39,62,67],[15,39,62,68],[15,39,62,69],
 [15,39,63,64],[15,39,63,65],[15,39,63,66],
 [15,39,63,69],[15,39,64,65],[15,39,64,67],
 [15,39,64,68],[15,39,66,67],[15,39,66,68],
 [15,39,66,69],[15,39,67,68],[15,39,67,69],
 [15,39,68,69],[15,40,41,42],[15,40,41,44],
 [15,40,41,47],[15,40,41,48],[15,40,41,49],
 [15,40,41,59],[15,40,41,61],[15,40,41,63],
 [15,40,41,64],[15,40,41,65],[15,40,41,68],
 [15,40,41,69],[15,40,42,44],[15,40,42,47],
 [15,40,42,49],[15,40,42,52],[15,40,42,55],
 [15,40,42,59],[15,40,42,61],[15,40,42,63],
 [15,40,42,64],[15,40,42,65],[15,40,42,68],
 [15,40,44,47],[15,40,44,48],[15,40,44,49],
 [15,40,44,59],[15,40,44,61],[15,40,44,63],
 [15,40,44,64],[15,40,44,65],[15,40,44,68],
 [15,40,44,69],[15,40,47,48],[15,40,47,49],
 [15,40,47,59],[15,40,47,61],[15,40,47,63],
 [15,40,47,64],[15,40,47,65],[15,40,47,68],
 [15,40,47,69],[15,40,48,49],[15,40,48,52],
 [15,40,48,55],[15,40,48,63],[15,40,48,68],
 [15,40,48,69],[15,40,49,52],[15,40,49,55],
 [15,40,49,59],[15,40,49,61],[15,40,49,63],
 [15,40,49,64],[15,40,49,65],[15,40,49,68],
 [15,40,49,69],[15,40,52,61],[15,40,52,69],
 [15,40,55,59],[15,40,55,61],[15,40,55,69],
 [15,40,59,61],[15,40,59,63],[15,40,59,64],
 [15,40,59,65],[15,40,59,68],[15,40,59,69],
 [15,40,61,63],[15,40,61,64],[15,40,61,65],
 [15,40,61,68],[15,40,63,64],[15,40,63,65],
 [15,40,63,68],[15,40,63,69],[15,40,64,65],
 [15,40,64,68],[15,40,65,68],[15,40,68,69],
 [15,41,42,44],[15,41,42,46],[15,41,42,47],
 [15,41,42,49],[15,41,42,59],[15,41,42,61],
 [15,41,42,62],[15,41,42,63],[15,41,42,64],
 [15,41,42,65],[15,41,42,68],[15,41,43,44],
 [15,41,43,45],[15,41,43,46],[15,41,43,47],
 [15,41,43,48],[15,41,43,49],[15,41,43,55],
 [15,41,43,58],[15,41,43,59],[15,41,43,60],
 [15,41,43,61],[15,41,43,62],[15,41,43,65],
 [15,41,43,66],[15,41,43,67],[15,41,43,68],
 [15,41,43,69],[15,41,44,45],[15,41,44,46],
 [15,41,44,47],[15,41,44,48],[15,41,44,49],
 [15,41,44,53],[15,41,44,54],[15,41,44,55],
 [15,41,44,56],[15,41,44,57],[15,41,44,58],
 [15,41,44,59],[15,41,44,60],[15,41,44,61],
 [15,41,44,62],[15,41,44,63],[15,41,44,64],
 [15,41,44,65],[15,41,44,66],[15,41,44,67],
 [15,41,44,68],[15,41,44,69],[15,41,45,46],
 [15,41,45,47],[15,41,45,48],[15,41,45,49],
 [15,41,45,55],[15,41,45,58],[15,41,45,59],
 [15,41,45,60],[15,41,45,61],[15,41,45,62],
 [15,41,45,66],[15,41,45,67],[15,41,45,68],
 [15,41,45,69],[15,41,46,47],[15,41,46,48],
 [15,41,46,49],[15,41,46,53],[15,41,46,55],
 [15,41,46,57],[15,41,46,58],[15,41,46,59],
 [15,41,46,60],[15,41,46,61],[15,41,46,62],
 [15,41,46,63],[15,41,46,66],[15,41,46,67],
 [15,41,46,68],[15,41,46,69],[15,41,47,48],
 [15,41,47,49],[15,41,47,53],[15,41,47,54],
 [15,41,47,55],[15,41,47,56],[15,41,47,57],
 [15,41,47,58],[15,41,47,59],[15,41,47,60],
 [15,41,47,61],[15,41,47,62],[15,41,47,63],
 [15,41,47,64],[15,41,47,65],[15,41,47,66],
 [15,41,47,67],[15,41,47,68],[15,41,47,69],
 [15,41,48,49],[15,41,48,55],[15,41,48,56],
 [15,41,48,58],[15,41,48,59],[15,41,48,60],
 [15,41,48,61],[15,41,48,62],[15,41,48,63],
 [15,41,48,66],[15,41,48,67],[15,41,48,68],
 [15,41,48,69],[15,41,49,53],[15,41,49,54],
 [15,41,49,55],[15,41,49,56],[15,41,49,57],
 [15,41,49,58],[15,41,49,59],[15,41,49,60],
 [15,41,49,61],[15,41,49,62],[15,41,49,63],
 [15,41,49,64],[15,41,49,65],[15,41,49,66],
 [15,41,49,67],[15,41,49,68],[15,41,49,69],
 [15,41,53,54],[15,41,53,60],[15,41,53,68],
 [15,41,54,56],[15,41,54,57],[15,41,54,59],
 [15,41,54,61],[15,41,54,67],[15,41,54,68],
 [15,41,54,69],[15,41,55,58],[15,41,55,59],
 [15,41,55,60],[15,41,55,61],[15,41,55,62],
 [15,41,55,66],[15,41,55,67],[15,41,55,68],
 [15,41,55,69],[15,41,56,57],[15,41,56,59],
 [15,41,56,61],[15,41,56,62],[15,41,56,68],
 [15,41,57,59],[15,41,57,60],[15,41,57,61],
 [15,41,57,68],[15,41,58,59],[15,41,58,60],
 [15,41,58,61],[15,41,58,62],[15,41,58,66],
 [15,41,58,67],[15,41,58,68],[15,41,58,69],
 [15,41,59,60],[15,41,59,61],[15,41,59,62],
 [15,41,59,63],[15,41,59,64],[15,41,59,65],
 [15,41,59,66],[15,41,59,67],[15,41,59,68],
 [15,41,59,69],[15,41,60,61],[15,41,60,62],
 [15,41,60,65],[15,41,60,66],[15,41,60,67],
 [15,41,60,68],[15,41,60,69],[15,41,61,62],
 [15,41,61,63],[15,41,61,64],[15,41,61,65],
 [15,41,61,66],[15,41,61,67],[15,41,61,68],
 [15,41,61,69],[15,41,62,63],[15,41,62,66],
 [15,41,62,67],[15,41,62,68],[15,41,62,69],
 [15,41,63,64],[15,41,63,65],[15,41,63,68],
 [15,41,63,69],[15,41,64,65],[15,41,64,67],
 [15,41,64,68],[15,41,65,68],[15,41,66,67],
 [15,41,66,68],[15,41,66,69],[15,41,67,68],
 [15,41,67,69],[15,41,68,69],[15,42,44,46],
 [15,42,44,47],[15,42,44,49],[15,42,44,52],
 [15,42,44,55],[15,42,44,59],[15,42,44,61],
 [15,42,44,62],[15,42,44,63],[15,42,44,64],
 [15,42,44,65],[15,42,44,68],[15,42,46,47],
 [15,42,46,49],[15,42,46,52],[15,42,46,55],
 [15,42,46,62],[15,42,46,63],[15,42,46,68],
 [15,42,47,49],[15,42,47,52],[15,42,47,55],
 [15,42,47,59],[15,42,47,61],[15,42,47,62],
 [15,42,47,63],[15,42,47,64],[15,42,47,65],
 [15,42,47,68],[15,42,49,52],[15,42,49,55],
 [15,42,49,59],[15,42,49,61],[15,42,49,62],
 [15,42,49,63],[15,42,49,64],[15,42,49,65],
 [15,42,49,68],[15,42,52,61],[15,42,52,62],
 [15,42,55,61],[15,42,55,62],[15,42,59,61],
 [15,42,59,62],[15,42,59,63],[15,42,59,64],
 [15,42,59,65],[15,42,59,68],[15,42,61,63],
 [15,42,61,64],[15,42,61,65],[15,42,61,68],
 [15,42,62,63],[15,42,62,68],[15,42,63,64],
 [15,42,63,65],[15,42,63,68],[15,42,64,65],
 [15,42,64,68],[15,42,65,68],[15,43,44,45],
 [15,43,44,46],[15,43,44,47],[15,43,44,48],
 [15,43,44,49],[15,43,44,55],[15,43,44,57],
 [15,43,44,58],[15,43,44,59],[15,43,44,60],
 [15,43,44,61],[15,43,44,62],[15,43,44,65],
 [15,43,44,66],[15,43,44,67],[15,43,44,68],
 [15,43,44,69],[15,43,45,46],[15,43,45,47],
 [15,43,45,48],[15,43,45,49],[15,43,45,55],
 [15,43,45,58],[15,43,45,59],[15,43,45,60],
 [15,43,45,61],[15,43,45,62],[15,43,45,66],
 [15,43,45,67],[15,43,45,68],[15,43,45,69],
 [15,43,46,47],[15,43,46,48],[15,43,46,49],
 [15,43,46,52],[15,43,46,55],[15,43,46,57],
 [15,43,46,58],[15,43,46,59],[15,43,46,60],
 [15,43,46,61],[15,43,46,62],[15,43,46,66],
 [15,43,46,67],[15,43,46,68],[15,43,46,69],
 [15,43,47,48],[15,43,47,49],[15,43,47,55],
 [15,43,47,57],[15,43,47,58],[15,43,47,59],
 [15,43,47,60],[15,43,47,61],[15,43,47,62],
 [15,43,47,65],[15,43,47,66],[15,43,47,67],
 [15,43,47,68],[15,43,47,69],[15,43,48,49],
 [15,43,48,52],[15,43,48,55],[15,43,48,57],
 [15,43,48,58],[15,43,48,59],[15,43,48,60],
 [15,43,48,61],[15,43,48,62],[15,43,48,66],
 [15,43,48,67],[15,43,48,68],[15,43,48,69],
 [15,43,49,52],[15,43,49,55],[15,43,49,58],
 [15,43,49,59],[15,43,49,60],[15,43,49,61],
 [15,43,49,62],[15,43,49,65],[15,43,49,66],
 [15,43,49,67],[15,43,49,68],[15,43,49,69],
 [15,43,52,57],[15,43,52,61],[15,43,52,66],
 [15,43,52,67],[15,43,52,69],[15,43,55,58],
 [15,43,55,59],[15,43,55,60],[15,43,55,61],
 [15,43,55,62],[15,43,55,66],[15,43,55,67],
 [15,43,55,68],[15,43,55,69],[15,43,57,59],
 [15,43,57,60],[15,43,57,61],[15,43,57,67],
 [15,43,57,68],[15,43,58,59],[15,43,58,60],
 [15,43,58,61],[15,43,58,62],[15,43,58,66],
 [15,43,58,67],[15,43,58,68],[15,43,58,69],
 [15,43,59,60],[15,43,59,61],[15,43,59,62],
 [15,43,59,65],[15,43,59,66],[15,43,59,67],
 [15,43,59,68],[15,43,59,69],[15,43,60,61],
 [15,43,60,62],[15,43,60,65],[15,43,60,66],
 [15,43,60,67],[15,43,60,68],[15,43,60,69],
 [15,43,61,62],[15,43,61,65],[15,43,61,66],
 [15,43,61,67],[15,43,61,68],[15,43,61,69],
 [15,43,62,66],[15,43,62,67],[15,43,62,68],
 [15,43,62,69],[15,43,66,67],[15,43,66,68],
 [15,43,66,69],[15,43,67,68],[15,43,67,69],
 [15,43,68,69],[15,44,45,46],[15,44,45,47],
 [15,44,45,48],[15,44,45,49],[15,44,45,51],
 [15,44,45,52],[15,44,45,54],[15,44,45,55],
 [15,44,45,58],[15,44,45,59],[15,44,45,60],
 [15,44,45,61],[15,44,45,62],[15,44,45,66],
 [15,44,45,67],[15,44,45,68],[15,44,45,69],
 [15,44,46,47],[15,44,46,48],[15,44,46,49],
 [15,44,46,53],[15,44,46,55],[15,44,46,57],
 [15,44,46,58],[15,44,46,59],[15,44,46,60],
 [15,44,46,61],[15,44,46,62],[15,44,46,66],
 [15,44,46,67],[15,44,46,68],[15,44,46,69],
 [15,44,47,48],[15,44,47,49],[15,44,47,53],
 [15,44,47,54],[15,44,47,55],[15,44,47,56],
 [15,44,47,57],[15,44,47,58],[15,44,47,59],
 [15,44,47,60],[15,44,47,61],[15,44,47,62],
 [15,44,47,63],[15,44,47,64],[15,44,47,65],
 [15,44,47,66],[15,44,47,67],[15,44,47,68],
 [15,44,47,69],[15,44,48,49],[15,44,48,51],
 [15,44,48,52],[15,44,48,53],[15,44,48,55],
 [15,44,48,56],[15,44,48,58],[15,44,48,59],
 [15,44,48,60],[15,44,48,61],[15,44,48,62],
 [15,44,48,63],[15,44,48,66],[15,44,48,67],
 [15,44,48,68],[15,44,48,69],[15,44,49,52],
 [15,44,49,53],[15,44,49,54],[15,44,49,55],
 [15,44,49,56],[15,44,49,57],[15,44,49,58],
 [15,44,49,59],[15,44,49,60],[15,44,49,61],
 [15,44,49,62],[15,44,49,63],[15,44,49,64],
 [15,44,49,65],[15,44,49,66],[15,44,49,67],
 [15,44,49,68],[15,44,49,69],[15,44,51,53],
 [15,44,51,59],[15,44,51,61],[15,44,51,63],
 [15,44,51,65],[15,44,51,66],[15,44,51,67],
 [15,44,51,68],[15,44,51,69],[15,44,52,53],
 [15,44,52,57],[15,44,52,61],[15,44,52,62],
 [15,44,52,66],[15,44,52,67],[15,44,52,69],
 [15,44,53,54],[15,44,53,56],[15,44,53,58],
 [15,44,53,60],[15,44,53,67],[15,44,53,68],
 [15,44,54,56],[15,44,54,57],[15,44,54,59],
 [15,44,54,61],[15,44,54,62],[15,44,54,67],
 [15,44,54,68],[15,44,55,58],[15,44,55,59],
 [15,44,55,60],[15,44,55,61],[15,44,55,62],
 [15,44,55,66],[15,44,55,67],[15,44,55,68],
 [15,44,55,69],[15,44,56,57],[15,44,56,59],
 [15,44,56,61],[15,44,56,62],[15,44,56,68],
 [15,44,56,69],[15,44,57,59],[15,44,57,60],
 [15,44,57,61],[15,44,57,67],[15,44,57,68],
 [15,44,58,59],[15,44,58,60],[15,44,58,61],
 [15,44,58,62],[15,44,58,66],[15,44,58,67],
 [15,44,58,68],[15,44,58,69],[15,44,59,60],
 [15,44,59,61],[15,44,59,62],[15,44,59,63],
 [15,44,59,64],[15,44,59,65],[15,44,59,66],
 [15,44,59,67],[15,44,59,68],[15,44,59,69],
 [15,44,60,61],[15,44,60,62],[15,44,60,65],
 [15,44,60,66],[15,44,60,67],[15,44,60,68],
 [15,44,60,69],[15,44,61,62],[15,44,61,63],
 [15,44,61,64],[15,44,61,65],[15,44,61,66],
 [15,44,61,67],[15,44,61,68],[15,44,61,69],
 [15,44,62,63],[15,44,62,66],[15,44,62,67],
 [15,44,62,68],[15,44,62,69],[15,44,63,64],
 [15,44,63,65],[15,44,63,66],[15,44,63,68],
 [15,44,63,69],[15,44,64,65],[15,44,64,67],
 [15,44,64,68],[15,44,65,68],[15,44,66,67],
 [15,44,66,68],[15,44,66,69],[15,44,67,68],
 [15,44,67,69],[15,44,68,69],[15,45,46,47],
 [15,45,46,48],[15,45,46,49],[15,45,46,52],
 [15,45,46,55],[15,45,46,58],[15,45,46,59],
 [15,45,46,60],[15,45,46,61],[15,45,46,62],
 [15,45,46,66],[15,45,46,67],[15,45,46,68],
 [15,45,46,69],[15,45,47,48],[15,45,47,49],
 [15,45,47,51],[15,45,47,52],[15,45,47,55],
 [15,45,47,58],[15,45,47,59],[15,45,47,60],
 [15,45,47,61],[15,45,47,62],[15,45,47,66],
 [15,45,47,67],[15,45,47,68],[15,45,47,69],
 [15,45,48,49],[15,45,48,51],[15,45,48,52],
 [15,45,48,55],[15,45,48,58],[15,45,48,59],
 [15,45,48,60],[15,45,48,61],[15,45,48,62],
 [15,45,48,66],[15,45,48,67],[15,45,48,68],
 [15,45,48,69],[15,45,49,52],[15,45,49,55],
 [15,45,49,58],[15,45,49,59],[15,45,49,60],
 [15,45,49,61],[15,45,49,62],[15,45,49,66],
 [15,45,49,67],[15,45,49,68],[15,45,49,69],
 [15,45,51,52],[15,45,51,55],[15,45,51,58],
 [15,45,51,60],[15,45,51,62],[15,45,51,66],
 [15,45,51,67],[15,45,51,68],[15,45,51,69],
 [15,45,52,54],[15,45,52,61],[15,45,52,62],
 [15,45,52,66],[15,45,52,67],[15,45,52,69],
 [15,45,54,58],[15,45,54,60],[15,45,54,62],
 [15,45,54,67],[15,45,54,68],[15,45,54,69],
 [15,45,55,58],[15,45,55,59],[15,45,55,60],
 [15,45,55,61],[15,45,55,62],[15,45,55,66],
 [15,45,55,67],[15,45,55,68],[15,45,55,69],
 [15,45,58,59],[15,45,58,60],[15,45,58,61],
 [15,45,58,62],[15,45,58,66],[15,45,58,67],
 [15,45,58,68],[15,45,58,69],[15,45,59,60],
 [15,45,59,61],[15,45,59,62],[15,45,59,66],
 [15,45,59,67],[15,45,59,68],[15,45,59,69],
 [15,45,60,61],[15,45,60,62],[15,45,60,66],
 [15,45,60,67],[15,45,60,68],[15,45,60,69],
 [15,45,61,62],[15,45,61,66],[15,45,61,67],
 [15,45,61,68],[15,45,61,69],[15,45,62,66],
 [15,45,62,67],[15,45,62,68],[15,45,62,69],
 [15,45,66,67],[15,45,66,68],[15,45,66,69],
 [15,45,67,68],[15,45,67,69],[15,45,68,69],
 [15,46,47,48],[15,46,47,49],[15,46,47,53],
 [15,46,47,55],[15,46,47,57],[15,46,47,58],
 [15,46,47,59],[15,46,47,60],[15,46,47,61],
 [15,46,47,62],[15,46,47,63],[15,46,47,66],
 [15,46,47,67],[15,46,47,68],[15,46,47,69],
 [15,46,48,49],[15,46,48,52],[15,46,48,55],
 [15,46,48,56],[15,46,48,57],[15,46,48,58],
 [15,46,48,59],[15,46,48,60],[15,46,48,61],
 [15,46,48,62],[15,46,48,63],[15,46,48,66],
 [15,46,48,67],[15,46,48,68],[15,46,48,69],
 [15,46,49,52],[15,46,49,53],[15,46,49,55],
 [15,46,49,56],[15,46,49,58],[15,46,49,59],
 [15,46,49,60],[15,46,49,61],[15,46,49,62],
 [15,46,49,63],[15,46,49,66],[15,46,49,67],
 [15,46,49,68],[15,46,49,69],[15,46,52,53],
 [15,46,52,57],[15,46,52,61],[15,46,52,62],
 [15,46,52,66],[15,46,52,67],[15,46,52,69],
 [15,46,53,56],[15,46,53,58],[15,46,53,60],
 [15,46,53,67],[15,46,53,68],[15,46,55,58],
 [15,46,55,59],[15,46,55,60],[15,46,55,61],
 [15,46,55,62],[15,46,55,66],[15,46,55,67],
 [15,46,55,68],[15,46,55,69],[15,46,56,57],
 [15,46,56,59],[15,46,56,61],[15,46,56,62],
 [15,46,56,66],[15,46,56,68],[15,46,56,69],
 [15,46,57,60],[15,46,57,61],[15,46,57,67],
 [15,46,57,68],[15,46,58,59],[15,46,58,60],
 [15,46,58,61],[15,46,58,62],[15,46,58,66],
 [15,46,58,67],[15,46,58,68],[15,46,58,69],
 [15,46,59,60],[15,46,59,61],[15,46,59,62],
 [15,46,59,63],[15,46,59,66],[15,46,59,67],
 [15,46,59,68],[15,46,59,69],[15,46,60,61],
 [15,46,60,62],[15,46,60,66],[15,46,60,67],
 [15,46,60,68],[15,46,60,69],[15,46,61,62],
 [15,46,61,63],[15,46,61,66],[15,46,61,67],
 [15,46,61,68],[15,46,61,69],[15,46,62,63],
 [15,46,62,66],[15,46,62,67],[15,46,62,68],
 [15,46,62,69],[15,46,63,66],[15,46,63,68],
 [15,46,63,69],[15,46,66,67],[15,46,66,68],
 [15,46,66,69],[15,46,67,68],[15,46,67,69],
 [15,46,68,69],[15,47,48,49],[15,47,48,51],
 [15,47,48,52],[15,47,48,53],[15,47,48,55],
 [15,47,48,57],[15,47,48,58],[15,47,48,59],
 [15,47,48,60],[15,47,48,61],[15,47,48,62],
 [15,47,48,63],[15,47,48,66],[15,47,48,67],
 [15,47,48,68],[15,47,48,69],[15,47,49,53],
 [15,47,49,54],[15,47,49,55],[15,47,49,56],
 [15,47,49,57],[15,47,49,58],[15,47,49,59],
 [15,47,49,60],[15,47,49,61],[15,47,49,62],
 [15,47,49,63],[15,47,49,64],[15,47,49,65],
 [15,47,49,66],[15,47,49,67],[15,47,49,68],
 [15,47,49,69],[15,47,51,52],[15,47,51,53],
 [15,47,51,57],[15,47,51,61],[15,47,51,62],
 [15,47,51,63],[15,47,51,65],[15,47,51,66],
 [15,47,51,67],[15,47,51,69],[15,47,52,53],
 [15,47,52,57],[15,47,52,61],[15,47,52,62],
 [15,47,52,66],[15,47,52,67],[15,47,52,69],
 [15,47,53,54],[15,47,53,56],[15,47,53,58],
 [15,47,53,60],[15,47,53,67],[15,47,53,68],
 [15,47,54,56],[15,47,54,57],[15,47,54,59],
 [15,47,54,61],[15,47,54,62],[15,47,54,68],
 [15,47,54,69],[15,47,55,58],[15,47,55,59],
 [15,47,55,60],[15,47,55,61],[15,47,55,62],
 [15,47,55,66],[15,47,55,67],[15,47,55,68],
 [15,47,55,69],[15,47,56,57],[15,47,56,59],
 [15,47,56,61],[15,47,56,62],[15,47,56,66],
 [15,47,56,68],[15,47,56,69],[15,47,57,59],
 [15,47,57,60],[15,47,57,61],[15,47,57,67],
 [15,47,57,68],[15,47,58,59],[15,47,58,60],
 [15,47,58,61],[15,47,58,62],[15,47,58,66],
 [15,47,58,67],[15,47,58,68],[15,47,58,69],
 [15,47,59,60],[15,47,59,61],[15,47,59,62],
 [15,47,59,63],[15,47,59,64],[15,47,59,65],
 [15,47,59,66],[15,47,59,67],[15,47,59,68],
 [15,47,59,69],[15,47,60,61],[15,47,60,62],
 [15,47,60,65],[15,47,60,66],[15,47,60,67],
 [15,47,60,68],[15,47,60,69],[15,47,61,62],
 [15,47,61,63],[15,47,61,64],[15,47,61,65],
 [15,47,61,66],[15,47,61,67],[15,47,61,68],
 [15,47,61,69],[15,47,62,63],[15,47,62,66],
 [15,47,62,67],[15,47,62,68],[15,47,62,69],
 [15,47,63,64],[15,47,63,65],[15,47,63,66],
 [15,47,63,68],[15,47,63,69],[15,47,64,65],
 [15,47,64,67],[15,47,64,68],[15,47,65,68],
 [15,47,66,67],[15,47,66,68],[15,47,66,69],
 [15,47,67,68],[15,47,67,69],[15,47,68,69],
 [15,48,49,52],[15,48,49,55],[15,48,49,56],
 [15,48,49,58],[15,48,49,59],[15,48,49,60],
 [15,48,49,61],[15,48,49,62],[15,48,49,63],
 [15,48,49,66],[15,48,49,67],[15,48,49,68],
 [15,48,49,69],[15,48,51,52],[15,48,51,53],
 [15,48,51,56],[15,48,51,58],[15,48,51,60],
 [15,48,51,62],[15,48,51,63],[15,48,51,67],
 [15,48,51,68],[15,48,52,53],[15,48,52,57],
 [15,48,52,61],[15,48,52,62],[15,48,52,66],
 [15,48,52,67],[15,48,52,69],[15,48,53,56],
 [15,48,53,58],[15,48,53,60],[15,48,53,67],
 [15,48,53,68],[15,48,55,58],[15,48,55,59],
 [15,48,55,60],[15,48,55,61],[15,48,55,62],
 [15,48,55,66],[15,48,55,67],[15,48,55,68],
 [15,48,55,69],[15,48,56,57],[15,48,56,59],
 [15,48,56,61],[15,48,56,62],[15,48,56,66],
 [15,48,56,68],[15,48,56,69],[15,48,57,59],
 [15,48,57,60],[15,48,57,61],[15,48,57,67],
 [15,48,57,68],[15,48,58,59],[15,48,58,60],
 [15,48,58,61],[15,48,58,62],[15,48,58,66],
 [15,48,58,67],[15,48,58,68],[15,48,58,69],
 [15,48,59,60],[15,48,59,61],[15,48,59,62],
 [15,48,59,66],[15,48,59,67],[15,48,59,68],
 [15,48,59,69],[15,48,60,61],[15,48,60,62],
 [15,48,60,66],[15,48,60,67],[15,48,60,68],
 [15,48,60,69],[15,48,61,62],[15,48,61,63],
 [15,48,61,66],[15,48,61,67],[15,48,61,68],
 [15,48,61,69],[15,48,62,63],[15,48,62,66],
 [15,48,62,67],[15,48,62,68],[15,48,62,69],
 [15,48,63,66],[15,48,63,68],[15,48,63,69],
 [15,48,66,67],[15,48,66,68],[15,48,66,69],
 [15,48,67,68],[15,48,67,69],[15,48,68,69],
 [15,49,52,53],[15,49,52,54],[15,49,52,57],
 [15,49,52,61],[15,49,52,62],[15,49,52,66],
 [15,49,52,67],[15,49,52,69],[15,49,53,56],
 [15,49,53,58],[15,49,53,60],[15,49,53,67],
 [15,49,53,68],[15,49,54,56],[15,49,54,57],
 [15,49,54,58],[15,49,54,59],[15,49,54,60],
 [15,49,54,61],[15,49,54,67],[15,49,54,68],
 [15,49,55,58],[15,49,55,59],[15,49,55,60],
 [15,49,55,61],[15,49,55,62],[15,49,55,66],
 [15,49,55,67],[15,49,55,68],[15,49,55,69],
 [15,49,56,57],[15,49,56,59],[15,49,56,61],
 [15,49,56,62],[15,49,56,66],[15,49,56,68],
 [15,49,56,69],[15,49,57,59],[15,49,57,60],
 [15,49,57,61],[15,49,57,67],[15,49,57,68],
 [15,49,58,59],[15,49,58,60],[15,49,58,61],
 [15,49,58,62],[15,49,58,66],[15,49,58,67],
 [15,49,58,68],[15,49,58,69],[15,49,59,60],
 [15,49,59,61],[15,49,59,62],[15,49,59,63],
 [15,49,59,64],[15,49,59,65],[15,49,59,66],
 [15,49,59,67],[15,49,59,68],[15,49,59,69],
 [15,49,60,61],[15,49,60,62],[15,49,60,65],
 [15,49,60,66],[15,49,60,67],[15,49,60,68],
 [15,49,60,69],[15,49,61,62],[15,49,61,63],
 [15,49,61,64],[15,49,61,65],[15,49,61,66],
 [15,49,61,67],[15,49,61,68],[15,49,61,69],
 [15,49,62,63],[15,49,62,66],[15,49,62,67],
 [15,49,62,68],[15,49,62,69],[15,49,63,64],
 [15,49,63,65],[15,49,63,68],[15,49,63,69],
 [15,49,64,65],[15,49,64,67],[15,49,64,68],
 [15,49,65,68],[15,49,66,67],[15,49,66,68],
 [15,49,66,69],[15,49,67,68],[15,49,67,69],
 [15,49,68,69],[15,51,52,53],[15,51,52,57],
 [15,51,52,61],[15,51,52,62],[15,51,52,66],
 [15,51,52,67],[15,51,52,69],[15,51,53,56],
 [15,51,53,58],[15,51,53,60],[15,51,53,67],
 [15,51,53,68],[15,51,55,58],[15,51,55,59],
 [15,51,55,60],[15,51,55,61],[15,51,55,62],
 [15,51,55,66],[15,51,55,67],[15,51,55,68],
 [15,51,55,69],[15,51,56,57],[15,51,56,59],
 [15,51,56,61],[15,51,56,62],[15,51,56,66],
 [15,51,56,68],[15,51,56,69],[15,51,57,59],
 [15,51,57,60],[15,51,57,61],[15,51,57,67],
 [15,51,57,68],[15,51,58,59],[15,51,58,60],
 [15,51,58,61],[15,51,58,62],[15,51,58,66],
 [15,51,58,67],[15,51,58,68],[15,51,58,69],
 [15,51,59,60],[15,51,59,61],[15,51,59,62],
 [15,51,59,63],[15,51,59,64],[15,51,59,65],
 [15,51,59,66],[15,51,59,67],[15,51,59,68],
 [15,51,59,69],[15,51,60,61],[15,51,60,62],
 [15,51,60,65],[15,51,60,66],[15,51,60,67],
 [15,51,60,68],[15,51,60,69],[15,51,61,62],
 [15,51,61,63],[15,51,61,64],[15,51,61,65],
 [15,51,61,66],[15,51,61,67],[15,51,61,68],
 [15,51,61,69],[15,51,62,63],[15,51,62,66],
 [15,51,62,67],[15,51,62,68],[15,51,62,69],
 [15,51,63,64],[15,51,63,65],[15,51,63,66],
 [15,51,63,68],[15,51,63,69],[15,51,64,65],
 [15,51,64,67],[15,51,64,68],[15,51,65,68],
 [15,51,66,67],[15,51,66,68],[15,51,66,69],
 [15,51,67,68],[15,51,67,69],[15,51,68,69],
 [15,52,53,54],[15,52,53,67],[15,52,54,57],
 [15,52,54,61],[15,52,54,62],[15,52,54,67],
 [15,52,54,69],[15,52,57,61],[15,52,61,62],
 [15,52,61,69],[15,52,62,66],[15,52,62,67],
 [15,52,62,69],[15,52,66,69],[15,53,54,56],
 [15,53,54,58],[15,53,54,60],[15,53,54,67],
 [15,53,54,68],[15,53,58,60],[15,53,60,68],
 [15,54,56,57],[15,54,56,59],[15,54,56,61],
 [15,54,56,62],[15,54,56,68],[15,54,56,69],
 [15,54,57,59],[15,54,57,60],[15,54,57,61],
 [15,54,57,67],[15,54,57,68],[15,54,58,59],
 [15,54,58,60],[15,54,58,61],[15,54,58,62],
 [15,54,58,67],[15,54,58,68],[15,54,58,69],
 [15,54,59,60],[15,54,59,61],[15,54,59,67],
 [15,54,59,68],[15,54,59,69],[15,54,60,61],
 [15,54,60,62],[15,54,60,67],[15,54,60,68],
 [15,54,60,69],[15,54,61,62],[15,54,61,67],
 [15,54,61,68],[15,54,61,69],[15,54,62,67],
 [15,54,62,68],[15,54,62,69],[15,54,67,68],
 [15,54,67,69],[15,54,68,69],[15,55,58,59],
 [15,55,58,60],[15,55,58,61],[15,55,58,62],
 [15,55,58,66],[15,55,58,67],[15,55,58,68],
 [15,55,58,69],[15,55,59,60],[15,55,59,61],
 [15,55,59,62],[15,55,59,66],[15,55,59,67],
 [15,55,59,68],[15,55,59,69],[15,55,60,61],
 [15,55,60,62],[15,55,60,66],[15,55,60,67],
 [15,55,60,68],[15,55,60,69],[15,55,61,62],
 [15,55,61,66],[15,55,61,67],[15,55,61,68],
 [15,55,61,69],[15,55,62,66],[15,55,62,67],
 [15,55,62,68],[15,55,62,69],[15,55,66,67],
 [15,55,66,68],[15,55,66,69],[15,55,67,68],
 [15,55,67,69],[15,55,68,69],[15,56,57,59],
 [15,56,57,61],[15,56,57,68],[15,56,59,61],
 [15,56,59,62],[15,56,59,68],[15,56,61,62],
 [15,56,61,68],[15,56,61,69],[15,56,62,66],
 [15,56,62,69],[15,56,66,69],[15,57,59,60],
 [15,57,59,61],[15,57,59,68],[15,57,60,61],
 [15,57,60,67],[15,57,61,67],[15,57,61,68],
 [15,58,59,60],[15,58,59,61],[15,58,59,62],
 [15,58,59,66],[15,58,59,67],[15,58,59,68],
 [15,58,59,69],[15,58,60,61],[15,58,60,62],
 [15,58,60,66],[15,58,60,67],[15,58,60,68],
 [15,58,60,69],[15,58,61,62],[15,58,61,66],
 [15,58,61,67],[15,58,61,68],[15,58,61,69],
 [15,58,62,66],[15,58,62,67],[15,58,62,68],
 [15,58,62,69],[15,58,66,67],[15,58,66,68],
 [15,58,66,69],[15,58,67,68],[15,58,67,69],
 [15,58,68,69],[15,59,60,61],[15,59,60,62],
 [15,59,60,66],[15,59,60,67],[15,59,60,68],
 [15,59,60,69],[15,59,61,62],[15,59,61,63],
 [15,59,61,64],[15,59,61,65],[15,59,61,66],
 [15,59,61,67],[15,59,61,68],[15,59,61,69],
 [15,59,62,63],[15,59,62,66],[15,59,62,67],
 [15,59,62,68],[15,59,62,69],[15,59,63,64],
 [15,59,63,65],[15,59,63,66],[15,59,63,68],
 [15,59,63,69],[15,59,64,65],[15,59,64,68],
 [15,59,65,68],[15,59,66,67],[15,59,66,68],
 [15,59,66,69],[15,59,67,68],[15,59,67,69],
 [15,59,68,69],[15,60,61,62],[15,60,61,66],
 [15,60,61,67],[15,60,61,68],[15,60,61,69],
 [15,60,62,66],[15,60,62,67],[15,60,62,68],
 [15,60,62,69],[15,60,65,68],[15,60,66,67],
 [15,60,66,68],[15,60,66,69],[15,60,67,68],
 [15,60,67,69],[15,60,68,69],[15,61,62,63],
 [15,61,62,66],[15,61,62,67],[15,61,62,68],
 [15,61,62,69],[15,61,63,64],[15,61,63,65],
 [15,61,63,66],[15,61,63,68],[15,61,63,69],
 [15,61,64,65],[15,61,64,68],[15,61,65,68],
 [15,61,66,67],[15,61,66,68],[15,61,66,69],
 [15,61,67,68],[15,61,67,69],[15,61,68,69],
 [15,62,63,66],[15,62,63,68],[15,62,63,69],
 [15,62,66,67],[15,62,66,68],[15,62,66,69],
 [15,62,67,68],[15,62,67,69],[15,62,68,69],
 [15,63,64,65],[15,63,64,68],[15,63,65,68],
 [15,63,66,68],[15,63,66,69],[15,63,68,69],
 [15,64,65,68],[15,64,67,68],[15,66,67,68],
 [15,66,67,69],[15,66,68,69],[15,67,68,69],
 [16,19,20,21],[16,19,20,22],[16,19,20,23],
 [16,19,20,24],[16,19,20,25],[16,19,20,26],
 [16,19,20,27],[16,19,20,34],[16,19,20,39],
 [16,19,20,41],[16,19,20,42],[16,19,20,43],
 [16,19,20,44],[16,19,20,45],[16,19,20,46],
 [16,19,20,47],[16,19,20,48],[16,19,20,49],
 [16,19,20,55],[16,19,20,58],[16,19,20,59],
 [16,19,20,60],[16,19,20,61],[16,19,20,62],
 [16,19,20,66],[16,19,20,67],[16,19,20,68],
 [16,19,20,69],[16,19,21,22],[16,19,21,23],
 [16,19,21,24],[16,19,21,25],[16,19,21,26],
 [16,19,21,27],[16,19,21,34],[16,19,21,37],
 [16,19,21,39],[16,19,21,41],[16,19,21,42],
 [16,19,21,43],[16,19,21,44],[16,19,21,45],
 [16,19,21,46],[16,19,21,47],[16,19,21,48],
 [16,19,21,49],[16,19,21,52],[16,19,21,55],
 [16,19,21,56],[16,19,21,57],[16,19,21,58],
 [16,19,21,59],[16,19,21,60],[16,19,21,61],
 [16,19,21,62],[16,19,21,66],[16,19,21,67],
 [16,19,21,68],[16,19,21,69],[16,19,22,23],
 [16,19,22,24],[16,19,22,25],[16,19,22,26],
 [16,19,22,27],[16,19,22,30],[16,19,22,34],
 [16,19,22,35],[16,19,22,37],[16,19,22,39],
 [16,19,22,40],[16,19,22,41],[16,19,22,43],
 [16,19,22,44],[16,19,22,45],[16,19,22,46],
 [16,19,22,47],[16,19,22,48],[16,19,22,49],
 [16,19,22,54],[16,19,22,55],[16,19,22,57],
 [16,19,22,58],[16,19,22,59],[16,19,22,60],
 [16,19,22,61],[16,19,22,62],[16,19,22,66],
 [16,19,22,67],[16,19,22,68],[16,19,22,69],
 [16,19,23,24],[16,19,23,25],[16,19,23,26],
 [16,19,23,27],[16,19,23,34],[16,19,23,35],
 [16,19,23,37],[16,19,23,39],[16,19,23,40],
 [16,19,23,41],[16,19,23,42],[16,19,23,43],
 [16,19,23,44],[16,19,23,45],[16,19,23,46],
 [16,19,23,47],[16,19,23,48],[16,19,23,49],
 [16,19,23,52],[16,19,23,55],[16,19,23,56],
 [16,19,23,57],[16,19,23,58],[16,19,23,59],
 [16,19,23,60],[16,19,23,61],[16,19,23,62],
 [16,19,23,66],[16,19,23,67],[16,19,23,68],
 [16,19,23,69],[16,19,24,25],[16,19,24,26],
 [16,19,24,27],[16,19,24,34],[16,19,24,37],
 [16,19,24,39],[16,19,24,41],[16,19,24,42],
 [16,19,24,43],[16,19,24,44],[16,19,24,45],
 [16,19,24,46],[16,19,24,47],[16,19,24,48],
 [16,19,24,49],[16,19,24,55],[16,19,24,58],
 [16,19,24,59],[16,19,24,60],[16,19,24,61],
 [16,19,24,62],[16,19,24,66],[16,19,24,67],
 [16,19,24,68],[16,19,24,69],[16,19,25,26],
 [16,19,25,27],[16,19,25,34],[16,19,25,35],
 [16,19,25,37],[16,19,25,39],[16,19,25,40],
 [16,19,25,41],[16,19,25,42],[16,19,25,43],
 [16,19,25,44],[16,19,25,45],[16,19,25,46],
 [16,19,25,47],[16,19,25,48],[16,19,25,49],
 [16,19,25,54],[16,19,25,55],[16,19,25,57],
 [16,19,25,58],[16,19,25,59],[16,19,25,60],
 [16,19,25,61],[16,19,25,62],[16,19,25,66],
 [16,19,25,67],[16,19,25,68],[16,19,25,69],
 [16,19,26,27],[16,19,26,34],[16,19,26,35],
 [16,19,26,37],[16,19,26,39],[16,19,26,40],
 [16,19,26,41],[16,19,26,43],[16,19,26,44],
 [16,19,26,45],[16,19,26,46],[16,19,26,47],
 [16,19,26,48],[16,19,26,49],[16,19,26,52],
 [16,19,26,54],[16,19,26,55],[16,19,26,56],
 [16,19,26,58],[16,19,26,59],[16,19,26,60],
 [16,19,26,61],[16,19,26,62],[16,19,26,66],
 [16,19,26,67],[16,19,26,68],[16,19,26,69],
 [16,19,27,34],[16,19,27,35],[16,19,27,39],
 [16,19,27,40],[16,19,27,41],[16,19,27,43],
 [16,19,27,44],[16,19,27,45],[16,19,27,46],
 [16,19,27,47],[16,19,27,48],[16,19,27,49],
 [16,19,27,52],[16,19,27,54],[16,19,27,55],
 [16,19,27,56],[16,19,27,58],[16,19,27,59],
 [16,19,27,60],[16,19,27,61],[16,19,27,62],
 [16,19,27,66],[16,19,27,67],[16,19,27,68],
 [16,19,27,69],[16,19,30,41],[16,19,30,45],
 [16,19,30,47],[16,19,30,48],[16,19,30,49],
 [16,19,30,52],[16,19,30,59],[16,19,30,60],
 [16,19,30,62],[16,19,30,67],[16,19,34,39],
 [16,19,34,41],[16,19,34,43],[16,19,34,44],
 [16,19,34,45],[16,19,34,46],[16,19,34,47],
 [16,19,34,48],[16,19,34,49],[16,19,34,52],
 [16,19,34,55],[16,19,34,56],[16,19,34,58],
 [16,19,34,59],[16,19,34,60],[16,19,34,61],
 [16,19,34,62],[16,19,34,66],[16,19,34,67],
 [16,19,34,68],[16,19,34,69],[16,19,35,37],
 [16,19,35,41],[16,19,35,42],[16,19,35,45],
 [16,19,35,47],[16,19,35,52],[16,19,35,56],
 [16,19,35,59],[16,19,35,60],[16,19,35,62],
 [16,19,35,67],[16,19,35,68],[16,19,37,39],
 [16,19,37,40],[16,19,37,45],[16,19,37,47],
 [16,19,37,48],[16,19,37,52],[16,19,37,54],
 [16,19,37,56],[16,19,37,59],[16,19,37,60],
 [16,19,37,62],[16,19,37,67],[16,19,37,68],
 [16,19,39,41],[16,19,39,43],[16,19,39,44],
 [16,19,39,45],[16,19,39,46],[16,19,39,47],
 [16,19,39,48],[16,19,39,49],[16,19,39,52],
 [16,19,39,55],[16,19,39,58],[16,19,39,59],
 [16,19,39,60],[16,19,39,61],[16,19,39,62],
 [16,19,39,66],[16,19,39,67],[16,19,39,68],
 [16,19,39,69],[16,19,40,42],[16,19,40,45],
 [16,19,40,48],[16,19,40,49],[16,19,40,55],
 [16,19,40,61],[16,19,40,66],[16,19,40,67],
 [16,19,40,69],[16,19,41,43],[16,19,41,44],
 [16,19,41,45],[16,19,41,46],[16,19,41,47],
 [16,19,41,48],[16,19,41,49],[16,19,41,55],
 [16,19,41,58],[16,19,41,59],[16,19,41,60],
 [16,19,41,61],[16,19,41,62],[16,19,41,66],
 [16,19,41,67],[16,19,41,68],[16,19,41,69],
 [16,19,42,43],[16,19,42,44],[16,19,42,46],
 [16,19,42,49],[16,19,42,52],[16,19,42,55],
 [16,19,42,59],[16,19,42,60],[16,19,42,61],
 [16,19,42,62],[16,19,42,66],[16,19,43,44],
 [16,19,43,45],[16,19,43,46],[16,19,43,47],
 [16,19,43,48],[16,19,43,49],[16,19,43,55],
 [16,19,43,56],[16,19,43,58],[16,19,43,59],
 [16,19,43,60],[16,19,43,61],[16,19,43,62],
 [16,19,43,66],[16,19,43,67],[16,19,43,68],
 [16,19,43,69],[16,19,44,45],[16,19,44,46],
 [16,19,44,47],[16,19,44,48],[16,19,44,49],
 [16,19,44,52],[16,19,44,55],[16,19,44,56],
 [16,19,44,58],[16,19,44,59],[16,19,44,60],
 [16,19,44,61],[16,19,44,62],[16,19,44,66],
 [16,19,44,67],[16,19,44,68],[16,19,44,69],
 [16,19,45,46],[16,19,45,47],[16,19,45,48],
 [16,19,45,49],[16,19,45,54],[16,19,45,55],
 [16,19,45,57],[16,19,45,58],[16,19,45,59],
 [16,19,45,60],[16,19,45,61],[16,19,45,62],
 [16,19,45,66],[16,19,45,67],[16,19,45,68],
 [16,19,45,69],[16,19,46,47],[16,19,46,48],
 [16,19,46,49],[16,19,46,52],[16,19,46,55],
 [16,19,46,56],[16,19,46,57],[16,19,46,58],
 [16,19,46,59],[16,19,46,60],[16,19,46,61],
 [16,19,46,62],[16,19,46,66],[16,19,46,67],
 [16,19,46,68],[16,19,46,69],[16,19,47,48],
 [16,19,47,49],[16,19,47,52],[16,19,47,54],
 [16,19,47,55],[16,19,47,56],[16,19,47,57],
 [16,19,47,58],[16,19,47,59],[16,19,47,60],
 [16,19,47,61],[16,19,47,62],[16,19,47,66],
 [16,19,47,67],[16,19,47,68],[16,19,47,69],
 [16,19,48,49],[16,19,48,52],[16,19,48,55],
 [16,19,48,56],[16,19,48,57],[16,19,48,58],
 [16,19,48,59],[16,19,48,60],[16,19,48,61],
 [16,19,48,62],[16,19,48,66],[16,19,48,67],
 [16,19,48,68],[16,19,48,69],[16,19,49,52],
 [16,19,49,54],[16,19,49,55],[16,19,49,56],
 [16,19,49,57],[16,19,49,58],[16,19,49,59],
 [16,19,49,60],[16,19,49,61],[16,19,49,62],
 [16,19,49,66],[16,19,49,67],[16,19,49,68],
 [16,19,49,69],[16,19,52,54],[16,19,52,57],
 [16,19,52,61],[16,19,52,62],[16,19,52,66],
 [16,19,52,69],[16,19,54,56],[16,19,54,57],
 [16,19,54,59],[16,19,54,60],[16,19,54,62],
 [16,19,54,66],[16,19,54,67],[16,19,54,68],
 [16,19,54,69],[16,19,55,58],[16,19,55,59],
 [16,19,55,60],[16,19,55,61],[16,19,55,62],
 [16,19,55,66],[16,19,55,67],[16,19,55,68],
 [16,19,55,69],[16,19,56,59],[16,19,56,62],
 [16,19,56,66],[16,19,56,69],[16,19,57,58],
 [16,19,57,59],[16,19,57,60],[16,19,57,67],
 [16,19,58,59],[16,19,58,60],[16,19,58,61],
 [16,19,58,62],[16,19,58,66],[16,19,58,67],
 [16,19,58,68],[16,19,58,69],[16,19,59,60],
 [16,19,59,61],[16,19,59,62],[16,19,59,66],
 [16,19,59,67],[16,19,59,68],[16,19,59,69],
 [16,19,60,61],[16,19,60,62],[16,19,60,66],
 [16,19,60,67],[16,19,60,68],[16,19,60,69],
 [16,19,61,62],[16,19,61,66],[16,19,61,67],
 [16,19,61,68],[16,19,61,69],[16,19,62,66],
 [16,19,62,67],[16,19,62,68],[16,19,62,69],
 [16,19,66,67],[16,19,66,68],[16,19,66,69],
 [16,19,67,68],[16,19,67,69],[16,19,68,69],
 [16,20,21,22],[16,20,21,23],[16,20,21,24],
 [16,20,21,25],[16,20,21,26],[16,20,21,27],
 [16,20,21,33],[16,20,21,34],[16,20,21,37],
 [16,20,21,38],[16,20,21,39],[16,20,21,41],
 [16,20,21,43],[16,20,21,44],[16,20,21,45],
 [16,20,21,46],[16,20,21,47],[16,20,21,48],
 [16,20,21,49],[16,20,21,53],[16,20,21,55],
 [16,20,21,58],[16,20,21,59],[16,20,21,60],
 [16,20,21,61],[16,20,21,62],[16,20,21,66],
 [16,20,21,67],[16,20,21,68],[16,20,21,69],
 [16,20,22,23],[16,20,22,24],[16,20,22,25],
 [16,20,22,26],[16,20,22,27],[16,20,22,33],
 [16,20,22,34],[16,20,22,37],[16,20,22,38],
 [16,20,22,39],[16,20,22,40],[16,20,22,41],
 [16,20,22,42],[16,20,22,43],[16,20,22,44],
 [16,20,22,45],[16,20,22,46],[16,20,22,47],
 [16,20,22,48],[16,20,22,49],[16,20,22,54],
 [16,20,22,55],[16,20,22,58],[16,20,22,59],
 [16,20,22,60],[16,20,22,61],[16,20,22,62],
 [16,20,22,66],[16,20,22,67],[16,20,22,68],
 [16,20,22,69],[16,20,23,24],[16,20,23,25],
 [16,20,23,26],[16,20,23,27],[16,20,23,34],
 [16,20,23,37],[16,20,23,39],[16,20,23,41],
 [16,20,23,42],[16,20,23,43],[16,20,23,44],
 [16,20,23,45],[16,20,23,46],[16,20,23,47],
 [16,20,23,48],[16,20,23,49],[16,20,23,53],
 [16,20,23,55],[16,20,23,58],[16,20,23,59],
 [16,20,23,60],[16,20,23,61],[16,20,23,62],
 [16,20,23,66],[16,20,23,67],[16,20,23,68],
 [16,20,23,69],[16,20,24,25],[16,20,24,26],
 [16,20,24,27],[16,20,24,34],[16,20,24,36],
 [16,20,24,37],[16,20,24,38],[16,20,24,39],
 [16,20,24,40],[16,20,24,41],[16,20,24,42],
 [16,20,24,43],[16,20,24,44],[16,20,24,45],
 [16,20,24,46],[16,20,24,47],[16,20,24,48],
 [16,20,24,49],[16,20,24,53],[16,20,24,54],
 [16,20,24,55],[16,20,24,58],[16,20,24,59],
 [16,20,24,60],[16,20,24,61],[16,20,24,62],
 [16,20,24,66],[16,20,24,67],[16,20,24,68],
 [16,20,24,69],[16,20,25,26],[16,20,25,27],
 [16,20,25,33],[16,20,25,34],[16,20,25,36],
 [16,20,25,37],[16,20,25,39],[16,20,25,40],
 [16,20,25,41],[16,20,25,43],[16,20,25,44],
 [16,20,25,45],[16,20,25,46],[16,20,25,47],
 [16,20,25,48],[16,20,25,49],[16,20,25,53],
 [16,20,25,54],[16,20,25,55],[16,20,25,58],
 [16,20,25,59],[16,20,25,60],[16,20,25,61],
 [16,20,25,62],[16,20,25,66],[16,20,25,67],
 [16,20,25,68],[16,20,25,69],[16,20,26,27],
 [16,20,26,34],[16,20,26,37],[16,20,26,38],
 [16,20,26,39],[16,20,26,40],[16,20,26,41],
 [16,20,26,42],[16,20,26,43],[16,20,26,44],
 [16,20,26,45],[16,20,26,46],[16,20,26,47],
 [16,20,26,48],[16,20,26,49],[16,20,26,54],
 [16,20,26,55],[16,20,26,58],[16,20,26,59],
 [16,20,26,60],[16,20,26,61],[16,20,26,62],
 [16,20,26,66],[16,20,26,67],[16,20,26,68],
 [16,20,26,69],[16,20,27,33],[16,20,27,34],
 [16,20,27,36],[16,20,27,37],[16,20,27,39],
 [16,20,27,40],[16,20,27,41],[16,20,27,43],
 [16,20,27,44],[16,20,27,45],[16,20,27,46],
 [16,20,27,47],[16,20,27,48],[16,20,27,49],
 [16,20,27,53],[16,20,27,54],[16,20,27,55],
 [16,20,27,58],[16,20,27,59],[16,20,27,60],
 [16,20,27,61],[16,20,27,62],[16,20,27,66],
 [16,20,27,67],[16,20,27,68],[16,20,27,69],
 [16,20,33,36],[16,20,33,37],[16,20,33,45],
 [16,20,33,49],[16,20,33,53],[16,20,33,58],
 [16,20,33,59],[16,20,33,60],[16,20,33,61],
 [16,20,33,62],[16,20,33,66],[16,20,33,68],
 [16,20,33,69],[16,20,34,36],[16,20,34,39],
 [16,20,34,41],[16,20,34,43],[16,20,34,44],
 [16,20,34,45],[16,20,34,46],[16,20,34,47],
 [16,20,34,48],[16,20,34,49],[16,20,34,55],
 [16,20,34,58],[16,20,34,59],[16,20,34,60],
 [16,20,34,61],[16,20,34,62],[16,20,34,66],
 [16,20,34,67],[16,20,34,68],[16,20,34,69],
 [16,20,36,37],[16,20,36,40],[16,20,36,45],
 [16,20,36,46],[16,20,36,49],[16,20,36,53],
 [16,20,36,55],[16,20,36,60],[16,20,36,61],
 [16,20,36,62],[16,20,36,66],[16,20,36,68],
 [16,20,36,69],[16,20,37,38],[16,20,37,39],
 [16,20,37,40],[16,20,37,45],[16,20,37,47],
 [16,20,37,48],[16,20,37,59],[16,20,37,60],
 [16,20,37,62],[16,20,37,68],[16,20,38,40],
 [16,20,38,42],[16,20,38,45],[16,20,38,48],
 [16,20,38,49],[16,20,38,53],[16,20,38,58],
 [16,20,38,60],[16,20,38,61],[16,20,38,62],
 [16,20,38,66],[16,20,38,69],[16,20,39,41],
 [16,20,39,43],[16,20,39,44],[16,20,39,45],
 [16,20,39,46],[16,20,39,47],[16,20,39,48],
 [16,20,39,49],[16,20,39,55],[16,20,39,58],
 [16,20,39,59],[16,20,39,60],[16,20,39,61],
 [16,20,39,62],[16,20,39,66],[16,20,39,67],
 [16,20,39,68],[16,20,39,69],[16,20,40,42],
 [16,20,40,44],[16,20,40,45],[16,20,40,47],
 [16,20,40,48],[16,20,40,49],[16,20,40,53],
 [16,20,40,55],[16,20,40,61],[16,20,40,66],
 [16,20,40,67],[16,20,41,43],[16,20,41,44],
 [16,20,41,45],[16,20,41,46],[16,20,41,47],
 [16,20,41,48],[16,20,41,49],[16,20,41,53],
 [16,20,41,54],[16,20,41,55],[16,20,41,58],
 [16,20,41,59],[16,20,41,60],[16,20,41,61],
 [16,20,41,62],[16,20,41,66],[16,20,41,67],
 [16,20,41,68],[16,20,41,69],[16,20,42,43],
 [16,20,42,44],[16,20,42,46],[16,20,42,49],
 [16,20,42,55],[16,20,42,59],[16,20,42,60],
 [16,20,42,61],[16,20,42,66],[16,20,42,68],
 [16,20,43,44],[16,20,43,45],[16,20,43,46],
 [16,20,43,47],[16,20,43,48],[16,20,43,49],
 [16,20,43,55],[16,20,43,58],[16,20,43,59],
 [16,20,43,60],[16,20,43,61],[16,20,43,62],
 [16,20,43,66],[16,20,43,67],[16,20,43,68],
 [16,20,43,69],[16,20,44,45],[16,20,44,46],
 [16,20,44,47],[16,20,44,48],[16,20,44,49],
 [16,20,44,54],[16,20,44,55],[16,20,44,58],
 [16,20,44,59],[16,20,44,60],[16,20,44,61],
 [16,20,44,62],[16,20,44,66],[16,20,44,67],
 [16,20,44,68],[16,20,44,69],[16,20,45,46],
 [16,20,45,47],[16,20,45,48],[16,20,45,49],
 [16,20,45,53],[16,20,45,54],[16,20,45,55],
 [16,20,45,58],[16,20,45,59],[16,20,45,60],
 [16,20,45,61],[16,20,45,62],[16,20,45,66],
 [16,20,45,67],[16,20,45,68],[16,20,45,69],
 [16,20,46,47],[16,20,46,48],[16,20,46,49],
 [16,20,46,55],[16,20,46,58],[16,20,46,59],
 [16,20,46,60],[16,20,46,61],[16,20,46,62],
 [16,20,46,66],[16,20,46,67],[16,20,46,68],
 [16,20,46,69],[16,20,47,48],[16,20,47,49],
 [16,20,47,53],[16,20,47,54],[16,20,47,55],
 [16,20,47,58],[16,20,47,59],[16,20,47,60],
 [16,20,47,61],[16,20,47,62],[16,20,47,66],
 [16,20,47,67],[16,20,47,68],[16,20,47,69],
 [16,20,48,49],[16,20,48,55],[16,20,48,58],
 [16,20,48,59],[16,20,48,60],[16,20,48,61],
 [16,20,48,62],[16,20,48,66],[16,20,48,67],
 [16,20,48,68],[16,20,48,69],[16,20,49,54],
 [16,20,49,55],[16,20,49,58],[16,20,49,59],
 [16,20,49,60],[16,20,49,61],[16,20,49,62],
 [16,20,49,66],[16,20,49,67],[16,20,49,68],
 [16,20,49,69],[16,20,53,58],[16,20,53,60],
 [16,20,53,62],[16,20,53,67],[16,20,53,68],
 [16,20,54,59],[16,20,54,60],[16,20,54,62],
 [16,20,54,66],[16,20,54,68],[16,20,54,69],
 [16,20,55,58],[16,20,55,59],[16,20,55,60],
 [16,20,55,61],[16,20,55,62],[16,20,55,66],
 [16,20,55,67],[16,20,55,68],[16,20,55,69],
 [16,20,58,59],[16,20,58,60],[16,20,58,61],
 [16,20,58,62],[16,20,58,66],[16,20,58,67],
 [16,20,58,68],[16,20,58,69],[16,20,59,60],
 [16,20,59,61],[16,20,59,62],[16,20,59,66],
 [16,20,59,67],[16,20,59,68],[16,20,59,69],
 [16,20,60,61],[16,20,60,62],[16,20,60,66],
 [16,20,60,67],[16,20,60,68],[16,20,60,69],
 [16,20,61,62],[16,20,61,66],[16,20,61,67],
 [16,20,61,68],[16,20,61,69],[16,20,62,66],
 [16,20,62,67],[16,20,62,68],[16,20,62,69],
 [16,20,66,67],[16,20,66,68],[16,20,66,69],
 [16,20,67,68],[16,20,67,69],[16,20,68,69],
 [16,21,22,23],[16,21,22,24],[16,21,22,25],
 [16,21,22,26],[16,21,22,27],[16,21,22,29],
 [16,21,22,33],[16,21,22,34],[16,21,22,35],
 [16,21,22,36],[16,21,22,38],[16,21,22,39],
 [16,21,22,41],[16,21,22,42],[16,21,22,43],
 [16,21,22,44],[16,21,22,45],[16,21,22,46],
 [16,21,22,47],[16,21,22,48],[16,21,22,49],
 [16,21,22,50],[16,21,22,55],[16,21,22,56],
 [16,21,22,58],[16,21,22,59],[16,21,22,60],
 [16,21,22,61],[16,21,22,62],[16,21,22,66],
 [16,21,22,67],[16,21,22,68],[16,21,22,69],
 [16,21,23,24],[16,21,23,25],[16,21,23,26],
 [16,21,23,27],[16,21,23,30],[16,21,23,34],
 [16,21,23,35],[16,21,23,37],[16,21,23,39],
 [16,21,23,41],[16,21,23,42],[16,21,23,43],
 [16,21,23,44],[16,21,23,45],[16,21,23,46],
 [16,21,23,47],[16,21,23,48],[16,21,23,49],
 [16,21,23,50],[16,21,23,51],[16,21,23,52],
 [16,21,23,53],[16,21,23,55],[16,21,23,56],
 [16,21,23,57],[16,21,23,58],[16,21,23,59],
 [16,21,23,60],[16,21,23,61],[16,21,23,62],
 [16,21,23,66],[16,21,23,67],[16,21,23,68],
 [16,21,23,69],[16,21,24,25],[16,21,24,26],
 [16,21,24,27],[16,21,24,30],[16,21,24,33],
 [16,21,24,34],[16,21,24,35],[16,21,24,36],
 [16,21,24,37],[16,21,24,39],[16,21,24,41],
 [16,21,24,42],[16,21,24,43],[16,21,24,44],
 [16,21,24,45],[16,21,24,46],[16,21,24,47],
 [16,21,24,48],[16,21,24,49],[16,21,24,51],
 [16,21,24,53],[16,21,24,55],[16,21,24,58],
 [16,21,24,59],[16,21,24,60],[16,21,24,61],
 [16,21,24,62],[16,21,24,66],[16,21,24,67],
 [16,21,24,68],[16,21,24,69],[16,21,25,26],
 [16,21,25,27],[16,21,25,33],[16,21,25,34],
 [16,21,25,35],[16,21,25,36],[16,21,25,37],
 [16,21,25,39],[16,21,25,41],[16,21,25,42],
 [16,21,25,43],[16,21,25,44],[16,21,25,45],
 [16,21,25,46],[16,21,25,47],[16,21,25,48],
 [16,21,25,49],[16,21,25,50],[16,21,25,51],
 [16,21,25,52],[16,21,25,53],[16,21,25,55],
 [16,21,25,57],[16,21,25,58],[16,21,25,59],
 [16,21,25,60],[16,21,25,61],[16,21,25,62],
 [16,21,25,66],[16,21,25,67],[16,21,25,68],
 [16,21,25,69],[16,21,26,27],[16,21,26,30],
 [16,21,26,34],[16,21,26,35],[16,21,26,37],
 [16,21,26,39],[16,21,26,41],[16,21,26,43],
 [16,21,26,44],[16,21,26,45],[16,21,26,46],
 [16,21,26,47],[16,21,26,48],[16,21,26,49],
 [16,21,26,50],[16,21,26,51],[16,21,26,52],
 [16,21,26,53],[16,21,26,55],[16,21,26,57],
 [16,21,26,58],[16,21,26,59],[16,21,26,60],
 [16,21,26,61],[16,21,26,62],[16,21,26,66],
 [16,21,26,67],[16,21,26,68],[16,21,26,69],
 [16,21,27,30],[16,21,27,33],[16,21,27,34],
 [16,21,27,35],[16,21,27,36],[16,21,27,37],
 [16,21,27,39],[16,21,27,41],[16,21,27,42],
 [16,21,27,43],[16,21,27,44],[16,21,27,45],
 [16,21,27,46],[16,21,27,47],[16,21,27,48],
 [16,21,27,49],[16,21,27,51],[16,21,27,53],
 [16,21,27,55],[16,21,27,58],[16,21,27,59],
 [16,21,27,60],[16,21,27,61],[16,21,27,62],
 [16,21,27,66],[16,21,27,67],[16,21,27,68],
 [16,21,27,69],[16,21,29,34],[16,21,29,35],
 [16,21,29,37],[16,21,29,42],[16,21,29,46],
 [16,21,29,48],[16,21,29,49],[16,21,29,51],
 [16,21,29,53],[16,21,29,60],[16,21,29,61],
 [16,21,29,62],[16,21,29,67],[16,21,29,69],
 [16,21,30,36],[16,21,30,47],[16,21,30,48],
 [16,21,30,58],[16,21,30,59],[16,21,30,60],
 [16,21,30,62],[16,21,30,67],[16,21,30,68],
 [16,21,33,34],[16,21,33,35],[16,21,33,36],
 [16,21,33,37],[16,21,33,39],[16,21,33,42],
 [16,21,33,45],[16,21,33,46],[16,21,33,48],
 [16,21,33,49],[16,21,33,50],[16,21,33,51],
 [16,21,33,52],[16,21,33,53],[16,21,33,57],
 [16,21,33,58],[16,21,33,59],[16,21,33,60],
 [16,21,33,61],[16,21,33,62],[16,21,33,66],
 [16,21,33,68],[16,21,33,69],[16,21,34,36],
 [16,21,34,38],[16,21,34,39],[16,21,34,41],
 [16,21,34,43],[16,21,34,44],[16,21,34,45],
 [16,21,34,46],[16,21,34,47],[16,21,34,48],
 [16,21,34,49],[16,21,34,50],[16,21,34,52],
 [16,21,34,55],[16,21,34,56],[16,21,34,58],
 [16,21,34,59],[16,21,34,60],[16,21,34,61],
 [16,21,34,62],[16,21,34,66],[16,21,34,67],
 [16,21,34,68],[16,21,34,69],[16,21,35,36],
 [16,21,35,37],[16,21,35,38],[16,21,35,42],
 [16,21,35,45],[16,21,35,47],[16,21,35,48],
 [16,21,35,50],[16,21,35,52],[16,21,35,56],
 [16,21,35,59],[16,21,35,60],[16,21,35,62],
 [16,21,35,67],[16,21,35,68],[16,21,36,37],
 [16,21,36,45],[16,21,36,46],[16,21,36,48],
 [16,21,36,49],[16,21,36,50],[16,21,36,51],
 [16,21,36,52],[16,21,36,53],[16,21,36,55],
 [16,21,36,57],[16,21,36,60],[16,21,36,61],
 [16,21,36,62],[16,21,36,66],[16,21,36,68],
 [16,21,36,69],[16,21,37,38],[16,21,37,39],
 [16,21,37,43],[16,21,37,45],[16,21,37,47],
 [16,21,37,48],[16,21,37,50],[16,21,37,52],
 [16,21,37,56],[16,21,37,59],[16,21,37,60],
 [16,21,37,62],[16,21,37,67],[16,21,37,68],
 [16,21,38,43],[16,21,38,45],[16,21,38,46],
 [16,21,38,48],[16,21,38,49],[16,21,38,51],
 [16,21,38,53],[16,21,38,55],[16,21,38,58],
 [16,21,38,60],[16,21,38,61],[16,21,38,62],
 [16,21,38,66],[16,21,38,67],[16,21,38,69],
 [16,21,39,41],[16,21,39,43],[16,21,39,44],
 [16,21,39,45],[16,21,39,46],[16,21,39,47],
 [16,21,39,48],[16,21,39,49],[16,21,39,52],
 [16,21,39,53],[16,21,39,55],[16,21,39,58],
 [16,21,39,59],[16,21,39,60],[16,21,39,61],
 [16,21,39,62],[16,21,39,66],[16,21,39,67],
 [16,21,39,68],[16,21,39,69],[16,21,41,43],
 [16,21,41,44],[16,21,41,45],[16,21,41,46],
 [16,21,41,47],[16,21,41,48],[16,21,41,49],
 [16,21,41,50],[16,21,41,53],[16,21,41,55],
 [16,21,41,57],[16,21,41,58],[16,21,41,59],
 [16,21,41,60],[16,21,41,61],[16,21,41,62],
 [16,21,41,66],[16,21,41,67],[16,21,41,68],
 [16,21,41,69],[16,21,42,43],[16,21,42,44],
 [16,21,42,46],[16,21,42,50],[16,21,42,52],
 [16,21,42,55],[16,21,42,59],[16,21,42,60],
 [16,21,42,62],[16,21,42,66],[16,21,42,68],
 [16,21,43,44],[16,21,43,45],[16,21,43,46],
 [16,21,43,47],[16,21,43,48],[16,21,43,49],
 [16,21,43,53],[16,21,43,55],[16,21,43,56],
 [16,21,43,57],[16,21,43,58],[16,21,43,59],
 [16,21,43,60],[16,21,43,61],[16,21,43,62],
 [16,21,43,66],[16,21,43,67],[16,21,43,68],
 [16,21,43,69],[16,21,44,45],[16,21,44,46],
 [16,21,44,47],[16,21,44,48],[16,21,44,49],
 [16,21,44,52],[16,21,44,55],[16,21,44,56],
 [16,21,44,58],[16,21,44,59],[16,21,44,60],
 [16,21,44,61],[16,21,44,62],[16,21,44,66],
 [16,21,44,67],[16,21,44,68],[16,21,44,69],
 [16,21,45,46],[16,21,45,47],[16,21,45,48],
 [16,21,45,49],[16,21,45,50],[16,21,45,51],
 [16,21,45,52],[16,21,45,53],[16,21,45,55],
 [16,21,45,57],[16,21,45,58],[16,21,45,59],
 [16,21,45,60],[16,21,45,61],[16,21,45,62],
 [16,21,45,66],[16,21,45,67],[16,21,45,68],
 [16,21,45,69],[16,21,46,47],[16,21,46,48],
 [16,21,46,49],[16,21,46,50],[16,21,46,52],
 [16,21,46,55],[16,21,46,56],[16,21,46,57],
 [16,21,46,58],[16,21,46,59],[16,21,46,60],
 [16,21,46,61],[16,21,46,62],[16,21,46,66],
 [16,21,46,67],[16,21,46,68],[16,21,46,69],
 [16,21,47,48],[16,21,47,49],[16,21,47,50],
 [16,21,47,51],[16,21,47,52],[16,21,47,53],
 [16,21,47,55],[16,21,47,57],[16,21,47,58],
 [16,21,47,59],[16,21,47,60],[16,21,47,61],
 [16,21,47,62],[16,21,47,66],[16,21,47,67],
 [16,21,47,68],[16,21,47,69],[16,21,48,49],
 [16,21,48,50],[16,21,48,51],[16,21,48,52],
 [16,21,48,53],[16,21,48,55],[16,21,48,56],
 [16,21,48,57],[16,21,48,58],[16,21,48,59],
 [16,21,48,60],[16,21,48,61],[16,21,48,62],
 [16,21,48,66],[16,21,48,67],[16,21,48,68],
 [16,21,48,69],[16,21,49,50],[16,21,49,52],
 [16,21,49,55],[16,21,49,56],[16,21,49,58],
 [16,21,49,59],[16,21,49,60],[16,21,49,61],
 [16,21,49,62],[16,21,49,66],[16,21,49,67],
 [16,21,49,68],[16,21,49,69],[16,21,50,51],
 [16,21,50,52],[16,21,50,53],[16,21,50,59],
 [16,21,50,61],[16,21,50,62],[16,21,50,66],
 [16,21,50,67],[16,21,50,68],[16,21,50,69],
 [16,21,51,52],[16,21,51,53],[16,21,51,56],
 [16,21,51,59],[16,21,51,60],[16,21,51,62],
 [16,21,51,67],[16,21,51,68],[16,21,52,53],
 [16,21,52,61],[16,21,52,62],[16,21,52,67],
 [16,21,52,69],[16,21,53,56],[16,21,53,58],
 [16,21,53,60],[16,21,53,62],[16,21,53,67],
 [16,21,53,68],[16,21,55,58],[16,21,55,59],
 [16,21,55,60],[16,21,55,61],[16,21,55,62],
 [16,21,55,66],[16,21,55,67],[16,21,55,68],
 [16,21,55,69],[16,21,56,57],[16,21,56,59],
 [16,21,56,61],[16,21,56,62],[16,21,56,66],
 [16,21,56,68],[16,21,56,69],[16,21,57,58],
 [16,21,57,59],[16,21,57,60],[16,21,57,67],
 [16,21,57,68],[16,21,58,59],[16,21,58,60],
 [16,21,58,61],[16,21,58,62],[16,21,58,66],
 [16,21,58,67],[16,21,58,68],[16,21,58,69],
 [16,21,59,60],[16,21,59,61],[16,21,59,62],
 [16,21,59,66],[16,21,59,67],[16,21,59,68],
 [16,21,59,69],[16,21,60,61],[16,21,60,62],
 [16,21,60,66],[16,21,60,67],[16,21,60,68],
 [16,21,60,69],[16,21,61,62],[16,21,61,66],
 [16,21,61,67],[16,21,61,68],[16,21,61,69],
 [16,21,62,66],[16,21,62,67],[16,21,62,68],
 [16,21,62,69],[16,21,66,67],[16,21,66,68],
 [16,21,66,69],[16,21,67,68],[16,21,67,69],
 [16,21,68,69],[16,22,23,24],[16,22,23,25],
 [16,22,23,26],[16,22,23,27],[16,22,23,34],
 [16,22,23,37],[16,22,23,39],[16,22,23,40],
 [16,22,23,41],[16,22,23,43],[16,22,23,44],
 [16,22,23,45],[16,22,23,46],[16,22,23,47],
 [16,22,23,48],[16,22,23,49],[16,22,23,55],
 [16,22,23,56],[16,22,23,57],[16,22,23,58],
 [16,22,23,59],[16,22,23,60],[16,22,23,61],
 [16,22,23,62],[16,22,23,66],[16,22,23,67],
 [16,22,23,68],[16,22,23,69],[16,22,24,25],
 [16,22,24,26],[16,22,24,27],[16,22,24,30],
 [16,22,24,32],[16,22,24,33],[16,22,24,34],
 [16,22,24,35],[16,22,24,36],[16,22,24,37],
 [16,22,24,38],[16,22,24,39],[16,22,24,40],
 [16,22,24,41],[16,22,24,42],[16,22,24,43],
 [16,22,24,44],[16,22,24,45],[16,22,24,46],
 [16,22,24,47],[16,22,24,48],[16,22,24,49],
 [16,22,24,54],[16,22,24,55],[16,22,24,58],
 [16,22,24,59],[16,22,24,60],[16,22,24,61],
 [16,22,24,62],[16,22,24,66],[16,22,24,67],
 [16,22,24,68],[16,22,24,69],[16,22,25,26],
 [16,22,25,27],[16,22,25,32],[16,22,25,33],
 [16,22,25,34],[16,22,25,35],[16,22,25,36],
 [16,22,25,37],[16,22,25,39],[16,22,25,40],
 [16,22,25,41],[16,22,25,42],[16,22,25,43],
 [16,22,25,44],[16,22,25,45],[16,22,25,46],
 [16,22,25,47],[16,22,25,48],[16,22,25,49],
 [16,22,25,54],[16,22,25,55],[16,22,25,57],
 [16,22,25,58],[16,22,25,59],[16,22,25,60],
 [16,22,25,61],[16,22,25,62],[16,22,25,66],
 [16,22,25,67],[16,22,25,68],[16,22,25,69],
 [16,22,26,27],[16,22,26,29],[16,22,26,30],
 [16,22,26,32],[16,22,26,34],[16,22,26,35],
 [16,22,26,37],[16,22,26,38],[16,22,26,39],
 [16,22,26,40],[16,22,26,41],[16,22,26,42],
 [16,22,26,43],[16,22,26,44],[16,22,26,45],
 [16,22,26,46],[16,22,26,47],[16,22,26,48],
 [16,22,26,49],[16,22,26,54],[16,22,26,55],
 [16,22,26,56],[16,22,26,57],[16,22,26,58],
 [16,22,26,59],[16,22,26,60],[16,22,26,61],
 [16,22,26,62],[16,22,26,66],[16,22,26,67],
 [16,22,26,68],[16,22,26,69],[16,22,27,32],
 [16,22,27,33],[16,22,27,34],[16,22,27,37],
 [16,22,27,39],[16,22,27,40],[16,22,27,41],
 [16,22,27,42],[16,22,27,43],[16,22,27,44],
 [16,22,27,45],[16,22,27,46],[16,22,27,47],
 [16,22,27,48],[16,22,27,49],[16,22,27,54],
 [16,22,27,55],[16,22,27,56],[16,22,27,58],
 [16,22,27,59],[16,22,27,60],[16,22,27,61],
 [16,22,27,62],[16,22,27,66],[16,22,27,67],
 [16,22,27,68],[16,22,27,69],[16,22,29,32],
 [16,22,29,40],[16,22,29,43],[16,22,29,49],
 [16,22,29,60],[16,22,29,61],[16,22,29,62],
 [16,22,29,67],[16,22,29,69],[16,22,30,41],
 [16,22,30,45],[16,22,30,47],[16,22,30,49],
 [16,22,30,50],[16,22,30,59],[16,22,30,62],
 [16,22,30,68],[16,22,32,40],[16,22,32,49],
 [16,22,32,50],[16