/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.io.IOException;
import tim.prune.config.Config;

public abstract class ExternalTools {
    public static final int TOOL_EXIFTOOL = 0;
    public static final int TOOL_GPSBABEL = 1;
    public static final int TOOL_GNUPLOT = 2;
    public static final int TOOL_XERCES = 3;
    private static final String[] CONFIG_KEYS = new String[]{"prune.exiftoolpath", "prune.gpsbabelpath", "prune.gnuplotpath"};
    private static final String[] VERIFY_FLAGS = new String[]{"-v", "-V", "-V"};

    public static boolean isToolInstalled(Config config, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                String string = config.getConfigString(CONFIG_KEYS[n]);
                if (string == null || string.length() <= 0) break;
                return ExternalTools.check(String.valueOf(string) + " " + VERIFY_FLAGS[n]);
            }
            case 3: {
                try {
                    return Class.forName("org.apache.xerces.parsers.SAXParser").getClassLoader() != null;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return false;
    }

    public static boolean isToolInstalled(int n, String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return ExternalTools.check(String.valueOf(string) + " " + VERIFY_FLAGS[n]);
            }
        }
        return false;
    }

    private static boolean check(String string) {
        try {
            Runtime.getRuntime().exec(string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

