/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import tim.prune.function.filesleuth.data.FileTypeBlacklist;
import tim.prune.function.filesleuth.data.TrackFileList;

public class TrackFileFinder {
    private final TrackFileList _tracks;
    private final File _startDir;
    private final boolean _subdirectories;

    public TrackFileFinder(TrackFileList trackFileList, File file, boolean bl) {
        this._tracks = trackFileList;
        this._startDir = file;
        this._subdirectories = bl;
    }

    public void begin() {
        new Thread(this::run).start();
    }

    private void run() {
        int n = this._subdirectories ? Integer.MAX_VALUE : 1;
        try {
            Files.walk(Path.of(this._startDir.getAbsolutePath(), new String[0]), n, FileVisitOption.FOLLOW_LINKS).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(FileTypeBlacklist::isAllowed).forEach(this._tracks::foundFile);
        }
        catch (IOException | UncheckedIOException exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        this._tracks.setListComplete();
    }
}

