#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-2nPyhRygoxcEDChgkR2nHG
key:                  hOpenPGP-2.10.1-2nPyhRygoxcEDChgkR2nHG
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  5a98d8e56ab383ab7c1b2e1829aae437
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-2nPyhRygoxcEDChgkR2nHG
depends:
    aeson-2.1.2.1-LS8mizUYnpf1U9zpV4sjcf
    asn1-encoding-0.9.6-DNWVWoTxdSnGlftGs3XJtZ
    attoparsec-0.14.4-L0PdW4nkr6mJUEG3ZdEFXH base-4.17.2.1
    base16-bytestring-1.0.2.0-L60Rqi32njv1QNA4jOe3ZV
    bifunctors-5.6-A6Zwer6eIymEBcUSWcjeeY binary-0.8.9.1
    binary-conduit-1.3.1-5Qdu9bNeltH2SUdXWWoSUN bytestring-0.11.5.3
    bz2-1.0.1.1-Kbv1gYSRL9N6B4F49uwlc3
    conduit-1.3.6.1-LEKlJ5sjhOMOY4BoQvHAk
    conduit-extra-1.3.6-2wqo8ucVt5IGPwh2HHGSdk containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.0-DPZJlEmcVd8Aodr5WBuA08
    errors-2.3.0-2YbgC0AKqAT9OyqxzOnEUU
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    incremental-parser-0.5.1-BTvotQyZjZWGHIVyMwkpmO
    ixset-typed-0.5.1.0-B6VFNlDmJzjrEUCTN8FSQ
    lens-5.2.3-DzkbQ1V4DGJJfQUmuvkfoj
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-APaQU0Ye6OaKm6pWDY2rCG
    openpgp-asciiarmor-0.1.2-DzWzcVaCnqNFSoeis6xnsF
    prettyprinter-1.7.1-L5f5fQ72tN6KrwJu1IwhTZ
    resourcet-1.2.6-GnLJF89DOOQL8wsZDsu1Nb
    split-0.2.5-KcBaumhT6eFHklJKzsytdC text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-vB8Yx6KwyeBrT13JKFJ0i
    zlib-0.6.3.0-DQJ3sjglCnhJjpkMXQsJJY

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

