#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 minimorph
version:              0.3.0.1
visibility:           public
id:                   minimorph-0.3.0.1-7H7hRj1k9t0GnjHVIVKjd3
key:                  minimorph-0.3.0.1-7H7hRj1k9t0GnjHVIVKjd3
license:              BSD-3-Clause
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Eric Kow
homepage:             https://github.com/Mikolaj/minimorph
synopsis:             English spelling functions with an emphasis on simplicity.
description:
    A set of simplistic functions capturing the more regular
    parts of English spelling (for generation, not parsing).
    You will need to complement this with some account for
    irregular nouns/verbs. This package is not meant to provide
    anything resembling a full account of English morphology
    (something like Functional Morphology or sequor could be
    better suited). The main goal is to provide something cheap
    and cheerful with no learning curve, that you can use until
    your application calls for more robustness.
    See <https://github.com/Mikolaj/miniutter> for a simple
    use case.

category:             Natural Language Processing
abi:                  40f149758220d8e954cc0b8ecf6e169f
exposed:              True
exposed-modules:
    NLP.Minimorph.English NLP.Minimorph.Number NLP.Minimorph.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/minimorph-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/minimorph-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/minimorph-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-minimorph
hs-libraries:         HSminimorph-0.3.0.1-7H7hRj1k9t0GnjHVIVKjd3
depends:              base-4.17.2.1 text-2.0.2
haddock-interfaces:   /usr/share/doc/haskell-minimorph/html/minimorph.haddock
haddock-html:         /usr/share/doc/haskell-minimorph/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

