#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mwc-random
version:              0.15.2.0
visibility:           public
id:                   mwc-random-0.15.2.0-EYmt0F0gTfJ89Y5sH4vzL1
key:                  mwc-random-0.15.2.0-EYmt0F0gTfJ89Y5sH4vzL1
license:              BSD-2-Clause
copyright:            2009, 2010, 2011 Bryan O'\''Sullivan
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/haskell/mwc-random
synopsis:             Fast, high quality pseudo random number generation
description:
    This package contains code for generating high quality random
    numbers that follow either a uniform or normal distribution.  The
    generated numbers are suitable for use in statistical applications.
    .
    The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
    multiply-with-carry generator, which has a period of 2^8222 and
    fares well in tests of randomness.  It is also extremely fast,
    between 2 and 3 times faster than the Mersenne Twister.
    .
    Compared to the mersenne-random package, this package has a more
    convenient API, is faster, and supports more statistical
    distributions.

category:             Math, Statistics
abi:                  195518198b29317b0e0b6f3b7beaf7b4
exposed:              True
exposed-modules:
    System.Random.MWC System.Random.MWC.CondensedTable
    System.Random.MWC.Distributions System.Random.MWC.SeedSource

import-dirs:          /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mwc-random
hs-libraries:         HSmwc-random-0.15.2.0-EYmt0F0gTfJ89Y5sH4vzL1
depends:
    base-4.17.2.1 math-functions-0.3.4.4-E8iUEx01Qk9DqpLsVR97wn
    primitive-0.8.0.0-1110YmBHzhAERV5HY7EG3e
    random-1.2.1.2-KXwyGxW8gFCDB692Rea4Jy time-1.12.2
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:   /usr/share/doc/haskell-mwc-random/html/mwc-random.haddock
haddock-html:         /usr/share/doc/haskell-mwc-random/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

