#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 RSA
version:              2.4.1
visibility:           public
id:                   RSA-2.4.1-4L4GSM3VP4I6QYLwWb18Ns
key:                  RSA-2.4.1-4L4GSM3VP4I6QYLwWb18Ns
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@galois.com>
author:               Adam Wick <awick@galois.com>
stability:            stable
synopsis:
    Implementation of RSA, using the padding schemes of PKCS#1 v2.1.

description:
    This library implements the RSA encryption and signature
    algorithms for arbitrarily-sized ByteStrings. While the
    implementations work, they are not necessarily the fastest ones
    on the planet. Particularly key generation. The algorithms
    included are based of RFC 3447, or the Public-Key Cryptography
    Standard for RSA, version 2.1 (a.k.a, PKCS#1 v2.1).

category:             Cryptography, Codec
abi:                  c0b9ea85d9d98c48cec0989e0b25b39f
exposed:              True
exposed-modules:
    Codec.Crypto.RSA Codec.Crypto.RSA.Exceptions Codec.Crypto.RSA.Pure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/RSA-2.4.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/RSA-2.4.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/RSA-2.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-rsa
hs-libraries:         HSRSA-2.4.1-4L4GSM3VP4I6QYLwWb18Ns
depends:
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl base-4.17.2.1 binary-0.8.9.1
    bytestring-0.11.5.3 crypto-api-0.13.3-L9US7GS3I02EI9rbQ94kVv
    crypto-pubkey-types-0.4.3-L5RrbWUNpiR8dQycRuSkQ0

haddock-interfaces:   /usr/share/doc/haskell-rsa/html/RSA.haddock
haddock-html:         /usr/share/doc/haskell-rsa/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

