#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-2utbcoYl1Xq5BPphnoNKXb
key:                  hledger-web-1.32.1-2utbcoYl1Xq5BPphnoNKXb
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a24f239170f10429ad0bb9cca814a924
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-2utbcoYl1Xq5BPphnoNKXb
depends:
    Decimal-0.5.2-1AVfBjxYGHAykzeOKFfVr
    aeson-2.1.2.1-LDBL5bcX1HC79scYyh3opi base-4.17.2.1
    base64-0.4.2.4-7UF38kSEquK4m3L2XQGIPV
    blaze-html-0.9.2.0-FKwarBKbyvpIFQ2PEdKkVd
    blaze-markup-0.8.3.0-58qVR6Ti62D37e0qM46OpS bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3jbMOlKTiDn4NCqaBZ47Ne
    clientsession-0.9.2.0-9zbtGwYZx303VRsdBcr8x4
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-AL3EmwxQHuQ1mZT9WLAkFR
    conduit-extra-1.3.6-6dO1xP5ViME37M1InDuSps containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-Iwhcaoy60Zm2QUSRc5Mtdd filepath-1.4.2.2
    hjsmin-0.2.1-7VlkKmyRAQUKKxdKZZUia
    hledger-1.32.1-LcJlFhjA9M82EOJJ04jE8H
    hledger-lib-1.32.1-9H5GgUh7cKdAxiqdfjK6ei
    hspec-2.10.9-2QQi0gYhs9C6V2MzXjeexi
    http-client-0.7.17-39vQCRHDS8Y4AZkwpcxUyW
    http-conduit-2.3.9.1-16gFKEPUkcU7pOEwwzAGYm
    http-types-0.12.4-3FyJu2Ux8ftJoanRheHyWI
    megaparsec-9.6.1-AHfz4qPwoQs815dRss8YYZ mtl-2.2.2
    network-3.1.4.0-24l6wfZeDaoIo68scGYLPE
    safe-0.3.21-1cfKzbT7BvNI1gm17QusEM
    shakespeare-2.1.0.1-FqN7fD0LwuU83QNB6ozdcx
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-FZLvposRpy5EPSL1bbufv9
    unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    utf8-string-1.0.2-FnO1h94XkEn7naEuvLflUO
    wai-3.2.4-G8OpaxOEe1K2xhGxWFGAVq
    wai-cors-0.2.7-9XynAUq9voG8jkzh9TLKaU
    wai-extra-3.1.16-4fktyihdjtV14ZFcgmL8Fb
    wai-handler-launch-3.0.3.1-WnffcTjI3wJO1J2SPOjC9
    warp-3.3.30-38vnaj4wlDPIgdQnaBLjGR
    yaml-0.11.11.2-7NEgW6E2pbYEs4sf4NTDIA
    yesod-1.6.2.1-HwUHYTxk7VEIQzrLwZdZhl
    yesod-core-1.6.26.0-3g9T4I6QDS4GZo80RUw7pY
    yesod-form-1.7.6-9SXnsaiF30rDGfgnrmzo0t
    yesod-static-1.6.1.0-HpP0hFvqBBKChdjlTYjQMw
    yesod-test-1.6.16-IWOwLBAQgKB2HCmoFe2dMg

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

