/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deformably register two images using a symmetric forces demons
algorithm.


This class was contributed by Tom Vercauteren, INRIA &amp; Mauna Kea
Technologies based on a variation of the DemonsRegistrationFilter .

FastSymmetricForcesDemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the deformation field which will map a moving image onto
a fixed image.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


Tom Vercauteren, INRIA &amp; Mauna Kea Technologies
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/ux2obj


WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.

See:
 DemonsRegistrationFilter

 DemonsRegistrationFunction

 itk::FastSymmetricForcesDemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastSymmetricForcesDemonsRegistrationFilter.h
*/
public class FastSymmetricForcesDemonsRegistrationFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FastSymmetricForcesDemonsRegistrationFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FastSymmetricForcesDemonsRegistrationFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FastSymmetricForcesDemonsRegistrationFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FastSymmetricForcesDemonsRegistrationFilter::~FastSymmetricForcesDemonsRegistrationFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FastSymmetricForcesDemonsRegistrationFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FastSymmetricForcesDemonsRegistrationFilter::FastSymmetricForcesDemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FastSymmetricForcesDemonsRegistrationFilter() {
    this(SimpleITKJNI.new_FastSymmetricForcesDemonsRegistrationFilter(), true);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(VectorDouble StandardDeviations) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(StandardDeviations), StandardDeviations);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(double value) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  VectorDouble getStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseGradientType(UseGradientTypeType UseGradientType)
*/
public  void setUseGradientType(FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType UseGradientType) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setUseGradientType(swigCPtr, this, UseGradientType.swigValue());
  }

  /**
UseGradientTypeType itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseGradientType() const
*/
public  FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType getUseGradientType() {
    return FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType.swigToEnum(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getUseGradientType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumUpdateStepLength(double MaximumUpdateStepLength)

Set/Get the maximum update step length.

*/
public  void setMaximumUpdateStepLength(double MaximumUpdateStepLength) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setMaximumUpdateStepLength(swigCPtr, this, MaximumUpdateStepLength);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumUpdateStepLength() const
*/
public  double getMaximumUpdateStepLength() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getMaximumUpdateStepLength(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  void setSmoothDisplacementField(boolean SmoothDisplacementField) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setSmoothDisplacementField(swigCPtr, this, SmoothDisplacementField);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public  void smoothDisplacementFieldOn() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_smoothDisplacementFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public  void smoothDisplacementFieldOff() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_smoothDisplacementFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  boolean getSmoothDisplacementField() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getSmoothDisplacementField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  void setSmoothUpdateField(boolean SmoothUpdateField) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setSmoothUpdateField(swigCPtr, this, SmoothUpdateField);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public  void smoothUpdateFieldOn() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_smoothUpdateFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public  void smoothUpdateFieldOff() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_smoothUpdateFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  boolean getSmoothUpdateField() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getSmoothUpdateField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(VectorDouble UpdateFieldStandardDeviations) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(UpdateFieldStandardDeviations), UpdateFieldStandardDeviations);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(double value) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  VectorDouble getUpdateFieldStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getUpdateFieldStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  double getMaximumError() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public  void setIntensityDifferenceThreshold(double IntensityDifferenceThreshold) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setIntensityDifferenceThreshold(swigCPtr, this, IntensityDifferenceThreshold);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public  double getIntensityDifferenceThreshold() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getIntensityDifferenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseImageSpacing() const
*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetRMSChange() const

Set/Get the root mean squared change of the previous iteration. May
not be used by all solvers.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getRMSChange(swigCPtr, this);
  }

  /**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the overlapping region between the two images. This
value is calculated for the current iteration

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMetric() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getMetric(swigCPtr, this);
  }

  /**
void itk::simple::FastSymmetricForcesDemonsRegistrationFilter::StopRegistration()

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  void stopRegistration() {
    SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_stopRegistration(swigCPtr, this);
  }

  /**
std::string itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FastSymmetricForcesDemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage, Image initialDisplacementField) {
    return new Image(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(initialDisplacementField), initialDisplacementField), true);
  }

  /**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.FastSymmetricForcesDemonsRegistrationFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

  public final static class UseGradientTypeType {
    public final static FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType Symmetric = new FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType("Symmetric");
    public final static FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType Fixed = new FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType("Fixed");
    public final static FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType WarpedMoving = new FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType("WarpedMoving");
    public final static FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType MappedMoving = new FastSymmetricForcesDemonsRegistrationFilter.UseGradientTypeType("MappedMoving");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static UseGradientTypeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + UseGradientTypeType.class + " with value " + swigValue);
    }

    private UseGradientTypeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private UseGradientTypeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private UseGradientTypeType(String swigName, UseGradientTypeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static UseGradientTypeType[] swigValues = { Symmetric, Fixed, WarpedMoving, MappedMoving };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
