/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Denoise a binary image using min/max curvature flow.


BinaryMinMaxCurvatureFlowImageFilter implements a curvature driven image denoising algorithm. This filter
assumes that the image is essentially binary: consisting of two
classes. Iso-brightness contours in the input image are viewed as a
level set. The level set is then evolved using a curvature-based speed
function:

\\[ I_t = F_{\\mbox{minmax}} |\\nabla I| \\]

where $ F_{\\mbox{minmax}} = \\min(\\kappa,0) $ if $ \\mbox{Avg}_{\\mbox{stencil}}(x) $ is less than or equal to $ T_{threshold} $ and $ \\max(\\kappa,0) $ , otherwise. $ \\kappa $ is the mean curvature of the iso-brightness contour at point $ x $ .

In min/max curvature flow, movement is turned on or off depending on
the scale of the noise one wants to remove. Switching depends on the
average image value of a region of radius $ R $ around each point. The choice of $ R $ , the stencil radius, governs the scale of the noise to be removed.

The threshold value $ T_{threshold} $ is a user specified value which discriminates between the two pixel
classes.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a BinaryMinMaxCurvatureFlowFunction object. A zero flux Neumann boundary condition is used when computing
derivatives near the data boundary.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a real type. This filter works for any dimensional images.
 Reference: "Level Set Methods and Fast Marching Methods", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 BinaryMinMaxCurvatureFlowFunction

 CurvatureFlowImageFilter

 MinMaxCurvatureFlowImageFilter

 itk::simple::BinaryMinMaxCurvatureFlow for the procedural interface

 itk::BinaryMinMaxCurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMinMaxCurvatureFlowImageFilter.h
*/
public class BinaryMinMaxCurvatureFlowImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryMinMaxCurvatureFlowImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryMinMaxCurvatureFlowImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryMinMaxCurvatureFlowImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryMinMaxCurvatureFlowImageFilter::~BinaryMinMaxCurvatureFlowImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryMinMaxCurvatureFlowImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryMinMaxCurvatureFlowImageFilter::BinaryMinMaxCurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryMinMaxCurvatureFlowImageFilter() {
    this(SimpleITKJNI.new_BinaryMinMaxCurvatureFlowImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetTimeStep(double TimeStep)
*/
public  void setTimeStep(double TimeStep) {
    SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_setTimeStep(swigCPtr, this, TimeStep);
  }

  /**
double itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetTimeStep() const
*/
public  double getTimeStep() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_getTimeStep(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetStencilRadius(int StencilRadius)
*/
public  void setStencilRadius(int StencilRadius) {
    SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_setStencilRadius(swigCPtr, this, StencilRadius);
  }

  /**
int itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetStencilRadius() const
*/
public  int getStencilRadius() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_getStencilRadius(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetThreshold(double Threshold)

Set/Get the threshold value.

*/
public  void setThreshold(double Threshold) {
    SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_setThreshold(swigCPtr, this, Threshold);
  }

  /**
double itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetThreshold() const

Set/Get the threshold value.

*/
public  double getThreshold() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_getThreshold(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMinMaxCurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryMinMaxCurvatureFlowImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryMinMaxCurvatureFlowImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
