/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Identify local maxima whose height above the baseline is greater than
h.


HConvexImageFilter extract local maxima that are more than h intensity units above the
(local) background. This has the effect of extracting objects that are
brighter than background by at least h intensity units.

This filter uses the HMaximaImageFilter .

Geodesic morphology and the H-Convex algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMinimaImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HConvex for the procedural interface

 itk::HConvexImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHConvexImageFilter.h
*/
public class HConvexImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HConvexImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HConvexImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HConvexImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HConvexImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HConvexImageFilter::~HConvexImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HConvexImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HConvexImageFilter::HConvexImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HConvexImageFilter() {
    this(SimpleITKJNI.new_HConvexImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HConvexImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  void setHeight(double Height) {
    SimpleITKJNI.HConvexImageFilter_setHeight(swigCPtr, this, Height);
  }

  /**
double itk::simple::HConvexImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  double getHeight() {
    return SimpleITKJNI.HConvexImageFilter_getHeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HConvexImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.HConvexImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::HConvexImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.HConvexImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HConvexImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.HConvexImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::HConvexImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.HConvexImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::HConvexImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HConvexImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HConvexImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HConvexImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HConvexImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.HConvexImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
