/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Watershed segmentation implementation with morphological operators.


Watershed pixel are labeled 0. TOutputImage should be an integer type.
Labels of output image are in no particular order. You can reorder the
labels such that object labels are consecutive and sorted based on
object size by passing the output of this filter to a RelabelComponentImageFilter .

The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.

This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://doi.org/10.54294/lf8u75


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 WatershedImageFilter , MorphologicalWatershedFromMarkersImageFilter

 itk::simple::MorphologicalWatershed for the procedural interface

 itk::MorphologicalWatershedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMorphologicalWatershedImageFilter.h
*/
public class MorphologicalWatershedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MorphologicalWatershedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MorphologicalWatershedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MorphologicalWatershedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MorphologicalWatershedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MorphologicalWatershedImageFilter::~MorphologicalWatershedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MorphologicalWatershedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MorphologicalWatershedImageFilter::MorphologicalWatershedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MorphologicalWatershedImageFilter() {
    this(SimpleITKJNI.new_MorphologicalWatershedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::SetLevel(double Level)
*/
public  void setLevel(double Level) {
    SimpleITKJNI.MorphologicalWatershedImageFilter_setLevel(swigCPtr, this, Level);
  }

  /**
double itk::simple::MorphologicalWatershedImageFilter::GetLevel() const
*/
public  double getLevel() {
    return SimpleITKJNI.MorphologicalWatershedImageFilter_getLevel(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::SetMarkWatershedLine(bool MarkWatershedLine)

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public  void setMarkWatershedLine(boolean MarkWatershedLine) {
    SimpleITKJNI.MorphologicalWatershedImageFilter_setMarkWatershedLine(swigCPtr, this, MarkWatershedLine);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOn()

Set the value of MarkWatershedLine to true or false respectfully.

*/
public  void markWatershedLineOn() {
    SimpleITKJNI.MorphologicalWatershedImageFilter_markWatershedLineOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOff()
*/
public  void markWatershedLineOff() {
    SimpleITKJNI.MorphologicalWatershedImageFilter_markWatershedLineOff(swigCPtr, this);
  }

  /**
bool itk::simple::MorphologicalWatershedImageFilter::GetMarkWatershedLine() const

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public  boolean getMarkWatershedLine() {
    return SimpleITKJNI.MorphologicalWatershedImageFilter_getMarkWatershedLine(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.MorphologicalWatershedImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.MorphologicalWatershedImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.MorphologicalWatershedImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::MorphologicalWatershedImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.MorphologicalWatershedImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::MorphologicalWatershedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MorphologicalWatershedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MorphologicalWatershedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MorphologicalWatershedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MorphologicalWatershedImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MorphologicalWatershedImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
