/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Rank filter of a greyscale image.


Nonlinear filter in which each output pixel is a user defined rank of
input pixels in a user defined neighborhood. The default rank is 0.5
(median). The boundary conditions are different to the standard
itkMedianImageFilter. In this filter the neighborhood is cropped at
the boundary, and is therefore smaller.

This filter uses a recursive implementation - essentially the one by
Huang 1979, I believe, to compute the rank, and is therefore usually a
lot faster than the direct implementation. The extensions to Huang are
support for arbitrary pixel types (using c++ maps) and arbitrary
neighborhoods. I presume that these are not new ideas.

This filter is based on the sliding window code from the
consolidatedMorphology package on InsightJournal.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://doi.org/10.54294/igq8fn


See:
 MedianImageFilter

Richard Beare

See:
 itk::simple::Rank for the procedural interface

 itk::RankImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRankImageFilter.h
*/
public class RankImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RankImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RankImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RankImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RankImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RankImageFilter::~RankImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RankImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RankImageFilter::RankImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RankImageFilter() {
    this(SimpleITKJNI.new_RankImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RankImageFilter::SetRank(double Rank)
*/
public  void setRank(double Rank) {
    SimpleITKJNI.RankImageFilter_setRank(swigCPtr, this, Rank);
  }

  /**
double itk::simple::RankImageFilter::GetRank() const
*/
public  double getRank() {
    return SimpleITKJNI.RankImageFilter_getRank(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RankImageFilter::SetRadius(std::vector&lt; unsigned int &gt; Radius)
*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.RankImageFilter_setRadius(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::RankImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.RankImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::RankImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.RankImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::RankImageFilter::GetKernelType() const

Get the kernel or structuring element .

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.RankImageFilter_getKernelType(swigCPtr, this));
  }

  /**
std::string itk::simple::RankImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RankImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RankImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RankImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RankImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RankImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
