/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter computes the signed distance map of the input image as an
approximation with pixel accuracy to the Euclidean distance.


This class is parameterized over the type of the input image and the
type of the output image.

For purposes of evaluating the signed distance map, the input is
assumed to be binary composed of pixels with value 0 and non-zero.

The inside is considered as having negative distances. Outside is
treated as having positive distances. To change the convention, use
the InsideIsPositive(bool) function.

As a convention, the distance is evaluated from the boundary of the ON
pixels.

The filter returns


A signed distance map with the approximation to the euclidean
distance.

A voronoi partition. (See itkDanielssonDistanceMapImageFilter)

A vector map containing the component of the vector relating the
current pixel with the closest point of the closest object to this
pixel. Given that the components of the distance are computed in
"pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used. (See
itkDanielssonDistanceMapImageFilter)
 This filter internally uses the DanielssonDistanceMap filter. This
filter is N-dimensional.


See:
 itkDanielssonDistanceMapImageFilter

 itk::simple::SignedDanielssonDistanceMap for the procedural interface

 itk::SignedDanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSignedDanielssonDistanceMapImageFilter.h
*/
public class SignedDanielssonDistanceMapImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SignedDanielssonDistanceMapImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SignedDanielssonDistanceMapImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SignedDanielssonDistanceMapImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SignedDanielssonDistanceMapImageFilter::~SignedDanielssonDistanceMapImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SignedDanielssonDistanceMapImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SignedDanielssonDistanceMapImageFilter::SignedDanielssonDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SignedDanielssonDistanceMapImageFilter() {
    this(SimpleITKJNI.new_SignedDanielssonDistanceMapImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::SetInsideIsPositive(bool InsideIsPositive)

Set if the inside represents positive values in the signed distance
map. By convention ON pixels are treated as inside pixels.

*/
public  void setInsideIsPositive(boolean InsideIsPositive) {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_setInsideIsPositive(swigCPtr, this, InsideIsPositive);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::InsideIsPositiveOn()

Set the value of InsideIsPositive to true or false respectfully.

*/
public  void insideIsPositiveOn() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_insideIsPositiveOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::InsideIsPositiveOff()
*/
public  void insideIsPositiveOff() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_insideIsPositiveOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedDanielssonDistanceMapImageFilter::GetInsideIsPositive() const

Get if the inside represents positive values in the signed distance
map. See GetInsideIsPositive()

*/
public  boolean getInsideIsPositive() {
    return SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getInsideIsPositive(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::SetSquaredDistance(bool SquaredDistance)

Set if the distance should be squared.

*/
public  void setSquaredDistance(boolean SquaredDistance) {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_setSquaredDistance(swigCPtr, this, SquaredDistance);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::SquaredDistanceOn()

Set the value of SquaredDistance to true or false respectfully.

*/
public  void squaredDistanceOn() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_squaredDistanceOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::SquaredDistanceOff()
*/
public  void squaredDistanceOff() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_squaredDistanceOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedDanielssonDistanceMapImageFilter::GetSquaredDistance() const

Get the distance squared.

*/
public  boolean getSquaredDistance() {
    return SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getSquaredDistance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set if image spacing should be used in computing distances.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedDanielssonDistanceMapImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedDanielssonDistanceMapImageFilter::GetUseImageSpacing() const

Get whether spacing is used.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Image itk::simple::SignedDanielssonDistanceMapImageFilter::GetVoronoiMap() const

Get Voronoi Map This map shows for each pixel what object is closest
to it. Each object should be labeled by a number (larger than 0), so
the map has a value for each pixel corresponding to the label of the
closest object.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getVoronoiMap() {
    return new Image(SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getVoronoiMap(swigCPtr, this), true);
  }

  /**
Image itk::simple::SignedDanielssonDistanceMapImageFilter::GetVectorDistanceMap() const

Get vector field of distances.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getVectorDistanceMap() {
    return new Image(SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getVectorDistanceMap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::SignedDanielssonDistanceMapImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SignedDanielssonDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SignedDanielssonDistanceMapImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SignedDanielssonDistanceMapImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
