/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.PT;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;

public class Mol2Reader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int ac = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private int chainID = 64;

    @Override
    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    @Override
    public boolean checkLine() throws Exception {
        if (this.line.equals("@<TRIPOS>MOLECULE")) {
            if (!this.processMolecule()) {
                return true;
            }
            this.continuing = !this.isLastModel(this.modelNumber);
            return false;
        }
        if (this.line.length() != 0 && this.line.charAt(0) == '#') {
            this.checkCurrentLineForScript();
        }
        return true;
    }

    private boolean processMolecule() throws Exception {
        this.isPDB = false;
        String thisDataSetName = this.rd().trim();
        if (!this.doGetModel(++this.modelNumber, thisDataSetName)) {
            return false;
        }
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = 64;
        this.rd();
        this.line = this.line + " 0 0 0 0 0 0";
        this.ac = this.parseIntStr(this.line);
        int bondCount = this.parseInt();
        if (bondCount == 0) {
            this.asc.setNoAutoBond();
        }
        int resCount = this.parseInt();
        this.rd();
        this.rd();
        if (this.rd() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.rd() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            if (this.line.indexOf("jmolscript:") >= 0) {
                this.checkCurrentLineForScript();
                if (this.line.equals("#")) {
                    this.line = "";
                }
            }
            if (this.line.length() != 0) {
                thisDataSetName = thisDataSetName + ": " + this.line.trim();
            }
        }
        this.newAtomSet(thisDataSetName);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.ac);
                this.asc.setAtomSetName(thisDataSetName);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(bondCount);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(resCount);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.rd();
        }
        this.nAtoms += this.ac;
        if (this.isPDB) {
            this.setIsPDB();
            this.setModelPDB(true);
        }
        this.applySymmetryAndSetTrajectory();
        return true;
    }

    private void readAtoms(int ac) throws Exception {
        if (ac == 0) {
            return;
        }
        int i0 = this.asc.ac;
        for (int i = 0; i < ac; ++i) {
            Atom atom = this.asc.addNewAtom();
            String[] tokens = PT.getTokens(this.rd());
            String atomType = tokens[5];
            String name = tokens[1];
            int pt = atomType.indexOf(".");
            if (pt >= 0) {
                atom.elementSymbol = atomType.substring(0, pt);
            } else {
                atom.atomName = name;
                atom.elementSymbol = atom.getElementSymbol();
            }
            atom.atomName = name + '\u0000' + atomType;
            atom.set(this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]));
            if (tokens.length > 6) {
                atom.sequenceNumber = this.parseIntStr(tokens[6]);
                if (atom.sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 90) {
                        this.chainID = 96;
                    }
                    ++this.chainID;
                }
                this.lastSequenceNumber = atom.sequenceNumber;
                this.setChainID(atom, "" + (char)this.chainID);
            }
            if (tokens.length > 7) {
                atom.group3 = tokens[7];
            }
            if (tokens.length <= 8) continue;
            atom.partialCharge = this.parseFloatStr(tokens[8]);
            if (atom.partialCharge != (float)((int)atom.partialCharge)) continue;
            atom.formalCharge = (int)atom.partialCharge;
        }
        Atom[] atoms = this.asc.atoms;
        String g3 = atoms[i0].group3;
        if (g3 == null) {
            return;
        }
        boolean isPDB = false;
        if (!g3.equals("UNK") && !g3.startsWith("RES")) {
            int i = this.asc.ac;
            while (--i >= i0) {
                if (g3.equals(atoms[this.asc.ac - 1].group3)) continue;
                isPDB = true;
                break;
            }
            if (isPDB) {
                int pt;
                isPDB = false;
                i = this.asc.ac;
                while (--i >= i0 && (pt = this.getPDBGroupLength(atoms[i].group3)) != 0 && pt <= 3) {
                    if (!this.vwr.getJBR().isKnownPDBGroup(g3.substring(0, pt), Integer.MAX_VALUE)) continue;
                    this.isPDB = true;
                    isPDB = true;
                    break;
                }
            }
        }
        int i = this.asc.ac;
        while (--i >= i0) {
            if (isPDB) {
                g3 = atoms[i].group3;
                g3 = g3.substring(0, this.getPDBGroupLength(g3));
                atoms[i].isHetero = this.vwr.getJBR().isHetero(g3);
            } else {
                g3 = null;
            }
            atoms[i].group3 = g3;
        }
    }

    private int getPDBGroupLength(String g3) {
        int pt0;
        int pt = pt0 = g3.length();
        while (--pt > 0 && Character.isDigit(g3.charAt(pt))) {
        }
        return ++pt;
    }

    private void readBonds(int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            String[] tokens = PT.getTokens(this.rd());
            int atomIndex1 = this.parseIntStr(tokens[1]);
            int atomIndex2 = this.parseIntStr(tokens[2]);
            int order = this.parseIntStr(tokens[3]);
            if (order == Integer.MIN_VALUE) {
                order = tokens[3].equals("ar") ? 515 : (tokens[3].equals("am") ? 1 : 17);
            }
            this.asc.addBond(new Bond(this.nAtoms + atomIndex1 - 1, this.nAtoms + atomIndex2 - 1, order));
        }
    }

    private void readResInfo(int resCount) throws Exception {
        for (int i = 0; i < resCount; ++i) {
            this.rd();
        }
    }

    private void readCrystalInfo() throws Exception {
        int i;
        this.rd();
        String[] tokens = this.getTokens();
        if (tokens.length < 6) {
            return;
        }
        String name = "";
        for (i = 6; i < tokens.length; ++i) {
            name = name + " " + tokens[i];
        }
        name = name == "" ? " P1" : name + " *";
        name = name.substring(1);
        this.setSpaceGroupName(name);
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloatStr(tokens[i]));
        }
        Atom[] atoms = this.asc.atoms;
        for (int i2 = 0; i2 < this.ac; ++i2) {
            this.setAtomCoord(atoms[this.nAtoms + i2]);
        }
    }
}

