/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class OsmServerReader
extends OsmConnection {
    private final OsmApi api;
    private boolean doAuthenticate;
    protected boolean gpxParsedProperly;
    protected String contentType;

    protected OsmServerReader() {
        this(OsmApi.getOsmApi());
    }

    protected OsmServerReader(OsmApi osmApi) {
        this.api = osmApi;
        this.doAuthenticate = OsmApi.isUsingOAuthAndOAuthSetUp(osmApi) && OsmApi.USE_OAUTH_FOR_ALL_REQUESTS.get() != false;
    }

    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStream(urlStr, progressMonitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor, String reason) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            String url = urlStr.startsWith("http") ? urlStr : this.getBaseUrl() + urlStr;
            InputStream inputStream = this.getInputStreamRaw(url, progressMonitor, reason);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected String getBaseUrl() {
        return this.api.getBaseUrl();
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, null);
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, reason, false);
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, reason, uncompressAccordingToContentDisposition, "GET", null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition, String httpMethod, byte[] requestBody) throws OsmTransferException {
        HttpClient.Response response;
        HttpClient client;
        if (NetworkManager.isOffline(urlStr)) {
            throw new OsmApiException(OfflineAccessException.forResource(urlStr));
        }
        URL url = null;
        try {
            url = new URL(urlStr.replace(" ", "%20"));
        }
        catch (MalformedURLException e) {
            throw new OsmTransferException(e);
        }
        String protocol = url.getProtocol();
        if ("file".equals(protocol) || "jar".equals(protocol)) {
            try {
                InputStream inputStream = Utils.openStream(url);
                return inputStream;
            }
            catch (IOException e) {
                throw new OsmTransferException(e);
            }
        }
        this.activeConnection = client = HttpClient.create(url, httpMethod).setAccept("application/xml, */*;q=0.8").setFinishOnCloseOutput(false).setReasonForRequest(reason).setOutputMessage(I18n.tr("Downloading data...", new Object[0])).setRequestBody(requestBody);
        this.adaptRequest(client);
        if (this.doAuthenticate && Objects.equals(this.api.getHost(), client.getURL().getHost())) {
            this.addAuth(client);
        }
        if (this.cancel) {
            throw new OsmTransferCanceledException("Operation canceled");
        }
        try {
            response = client.connect(progressMonitor);
            this.contentType = response.getContentType();
        }
        catch (IOException e) {
            Logging.error(e);
            OsmTransferException ote = new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection.", new Object[0]), e);
            ote.setUrl(url.toString());
            throw ote;
        }
        try {
            if (response.getResponseCode() == 401) {
                CredentialsManager.getInstance().purgeCredentialsCache(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost());
                throw new OsmApiException(401, null, null);
            }
            if (response.getResponseCode() == 407) {
                throw new OsmTransferCanceledException("Proxy Authentication Required");
            }
            if (response.getResponseCode() != 200) {
                String errorHeader = response.getHeaderField("Error");
                String errorBody = OsmServerReader.fetchResponseText(response);
                throw new OsmApiException(response.getResponseCode(), errorHeader, errorBody, url.toString(), null, this.contentType);
            }
            response.uncompressAccordingToContentDisposition(uncompressAccordingToContentDisposition);
            return response.getContent();
        }
        catch (OsmTransferException e) {
            throw e;
            catch (IOException e2) {
                throw new OsmTransferException(e2);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    private static String fetchResponseText(HttpClient.Response response) {
        try {
            return response.fetchContent();
        }
        catch (IOException e) {
            Logging.error(e);
            return I18n.tr("Reading error text failed.", new Object[0]);
        }
    }

    protected void adaptRequest(HttpClient request) {
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public DataSet parseOsm(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChange(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean doAuthenticate) {
        this.doAuthenticate = doAuthenticate;
    }

    public final boolean isGpxParsedProperly() {
        return this.gpxParsedProperly;
    }

    public List<Note> parseNotes(int noteLimit, int daysClosed, ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    protected static String getAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    public <T> T fetchData(String api, String subtask, DomParser<T> parser, ProgressMonitor monitor, String reason) throws OsmTransferException {
        try {
            T t;
            block12: {
                monitor.beginTask("");
                monitor.indeterminateSubTask(subtask);
                InputStream in = this.getInputStream(api, monitor.createSubTaskMonitor(1, true), reason);
                try {
                    t = parser.parse(XmlUtils.parseSafeDOM(in));
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (OsmTransferException e) {
                        throw e;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        throw new OsmTransferException(e);
                    }
                }
                in.close();
            }
            return t;
        }
        finally {
            monitor.finishTask();
        }
    }

    @FunctionalInterface
    protected static interface DomParser<R> {
        public R parse(Document var1) throws XmlParsingException;
    }
}

