/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class UnsafeMemoryIO
extends MemoryIO {
    protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeMemoryIO.getUnsafe());

    private static Object getUnsafe() {
        try {
            Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
            Field f = sunUnsafe.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return f.get(sunUnsafe);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final byte getByte(long address2) {
        return unsafe.getByte(address2);
    }

    @Override
    public final short getShort(long address2) {
        return unsafe.getShort(address2);
    }

    @Override
    public final int getInt(long address2) {
        return unsafe.getInt(address2);
    }

    @Override
    public final long getLong(long address2) {
        return unsafe.getLong(address2);
    }

    @Override
    public final float getFloat(long address2) {
        return unsafe.getFloat(address2);
    }

    @Override
    public final double getDouble(long address2) {
        return unsafe.getDouble(address2);
    }

    @Override
    public final void putByte(long address2, byte value2) {
        unsafe.putByte(address2, value2);
    }

    @Override
    public final void putShort(long address2, short value2) {
        unsafe.putShort(address2, value2);
    }

    @Override
    public final void putInt(long address2, int value2) {
        unsafe.putInt(address2, value2);
    }

    @Override
    public final void putLong(long address2, long value2) {
        unsafe.putLong(address2, value2);
    }

    @Override
    public final void putFloat(long address2, float value2) {
        unsafe.putFloat(address2, value2);
    }

    @Override
    public final void putDouble(long address2, double value2) {
        unsafe.putDouble(address2, value2);
    }

    @Override
    public final void _copyMemory(long src, long dst, long size2) {
        unsafe.copyMemory(src, dst, size2);
    }

    @Override
    public final void setMemory(long src, long size2, byte value2) {
        unsafe.setMemory(src, size2, value2);
    }

    @Override
    public final void memcpy(long dst, long src, long size2) {
        Foreign.memcpy(dst, src, size2);
    }

    @Override
    public final void memmove(long dst, long src, long size2) {
        Foreign.memmove(dst, src, size2);
    }

    @Override
    public final long memchr(long address2, int value2, long size2) {
        return Foreign.memchr(address2, value2, size2);
    }

    @Override
    public final void putByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.putByteArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.getByteArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putCharArray(long address2, char[] data2, int offset2, int length2) {
        Foreign.putCharArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getCharArray(long address2, char[] data2, int offset2, int length2) {
        Foreign.getCharArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putShortArray(long address2, short[] data2, int offset2, int length2) {
        Foreign.putShortArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getShortArray(long address2, short[] data2, int offset2, int length2) {
        Foreign.getShortArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putIntArray(long address2, int[] data2, int offset2, int length2) {
        Foreign.putIntArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getIntArray(long address2, int[] data2, int offset2, int length2) {
        Foreign.getIntArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putLongArray(long address2, long[] data2, int offset2, int length2) {
        Foreign.putLongArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getLongArray(long address2, long[] data2, int offset2, int length2) {
        Foreign.getLongArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putFloatArray(long address2, float[] data2, int offset2, int length2) {
        Foreign.putFloatArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getFloatArray(long address2, float[] data2, int offset2, int length2) {
        Foreign.getFloatArray(address2, data2, offset2, length2);
    }

    @Override
    public final void putDoubleArray(long address2, double[] data2, int offset2, int length2) {
        Foreign.putDoubleArray(address2, data2, offset2, length2);
    }

    @Override
    public final void getDoubleArray(long address2, double[] data2, int offset2, int length2) {
        Foreign.getDoubleArray(address2, data2, offset2, length2);
    }

    @Override
    public final long getStringLength(long address2) {
        return Foreign.strlen(address2);
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long address2) {
        return Foreign.getZeroTerminatedByteArray(address2);
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
        return Foreign.getZeroTerminatedByteArray(address2, maxlen);
    }

    @Override
    public final void putZeroTerminatedByteArray(long address2, byte[] data2, int offset2, int length2) {
        Foreign.putZeroTerminatedByteArray(address2, data2, offset2, length2);
    }

    static class UnsafeMemoryIO64
    extends UnsafeMemoryIO {
        UnsafeMemoryIO64() {
        }

        @Override
        public final long getAddress(long address2) {
            return unsafe.getLong(address2);
        }

        @Override
        public final void putAddress(long address2, long value2) {
            unsafe.putLong(address2, value2);
        }
    }

    static class UnsafeMemoryIO32
    extends UnsafeMemoryIO {
        UnsafeMemoryIO32() {
        }

        @Override
        public final long getAddress(long address2) {
            return (long)unsafe.getInt(address2) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address2, long value2) {
            unsafe.putInt(address2, (int)value2);
        }
    }
}

