/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo26_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("26.2.0");
    private static final Logger LOG = Logger.getLogger(MethodHandles.lookup().lookupClass());

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    private void migrateRealm(RealmModel realm) {
        HashMap headers = new HashMap(realm.getBrowserSecurityHeaders());
        headers.remove("xXSSProtection");
        realm.setBrowserSecurityHeaders(Collections.unmodifiableMap(headers));
    }
}

