/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PartialEvaluationContext;
import org.keycloak.authorization.policy.provider.PartialEvaluationPolicyProvider;
import org.keycloak.authorization.policy.provider.PartialEvaluationStorageProvider;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourceType;

public class PartialEvaluator {
    private static final String NO_ID = "none";
    private static final String ID_FIELD = "id";
    private static final String PARTIAL_EVALUATION_CONTEXT_CACHE = "kc.authz.fgap.partial.evaluation.cache";

    public List<Predicate> getPredicates(KeycloakSession session, ResourceType resourceType, PartialEvaluationStorageProvider storage, RealmModel realm, CriteriaBuilder builder, CriteriaQuery<?> queryBuilder, Path<?> path) {
        if (!AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm)) {
            return storage == null ? List.of() : storage.getFilters(new PartialEvaluationContext(storage, builder, queryBuilder, path));
        }
        UserModel adminUser = session.getContext().getUser();
        if (this.shouldSkipPartialEvaluation(session, adminUser, resourceType)) {
            return List.of();
        }
        PartialEvaluationContext context = this.runEvaluation(session, adminUser, resourceType, storage, builder, queryBuilder, path);
        return this.buildPredicates(context);
    }

    private PartialEvaluationContext runEvaluation(KeycloakSession session, UserModel adminUser, ResourceType resourceType, PartialEvaluationStorageProvider storage, CriteriaBuilder builder, CriteriaQuery<?> queryBuilder, Path<?> path) {
        HashMap<String, Map> cache = (HashMap<String, Map>)session.getAttributeOrDefault(PARTIAL_EVALUATION_CONTEXT_CACHE, Map.of());
        if (cache.getOrDefault(adminUser.getId(), Map.of()).containsKey(resourceType.getType())) {
            PartialEvaluationContext evaluationContext = (PartialEvaluationContext)((Map)cache.get(adminUser.getId())).get(resourceType.getType());
            evaluationContext.setStorage(storage);
            evaluationContext.setCriteriaBuilder(builder);
            evaluationContext.setCriteriaQuery(queryBuilder);
            evaluationContext.setPath(path);
            return evaluationContext;
        }
        HashSet<String> allowedResources = new HashSet<String>();
        HashSet<String> deniedResources = new HashSet<String>();
        List<PartialEvaluationPolicyProvider> policyProviders = this.getPartialEvaluationPolicyProviders(session);
        for (PartialEvaluationPolicyProvider policyProvider : policyProviders) {
            policyProvider.getPermissions(session, resourceType, adminUser).forEach(permission -> {
                Set<String> ids = permission.getResourceNames();
                Set<Policy> policies = permission.getAssociatedPolicies();
                for (Policy policy : policies) {
                    PartialEvaluationPolicyProvider provider = this.getPartialEvaluationPolicyProvider(policy, policyProviders);
                    if (provider == null) continue;
                    boolean granted = provider.evaluate(session, policy, adminUser);
                    if (Logic.NEGATIVE.equals((Object)policy.getLogic())) {
                        boolean bl = granted = !granted;
                    }
                    if (granted) {
                        allowedResources.addAll(ids);
                        continue;
                    }
                    deniedResources.addAll(ids);
                }
            });
        }
        allowedResources.removeAll(deniedResources);
        PartialEvaluationContext context = this.createEvaluationContext(session, resourceType, allowedResources, deniedResources, storage, builder, queryBuilder, path, adminUser);
        if (cache.isEmpty()) {
            cache = new HashMap<String, Map>();
        }
        cache.computeIfAbsent(adminUser.getId(), s -> new HashMap()).computeIfAbsent(resourceType.getType(), s -> context);
        if (session.getAttribute(PARTIAL_EVALUATION_CONTEXT_CACHE) == null) {
            session.setAttribute(PARTIAL_EVALUATION_CONTEXT_CACHE, cache);
        }
        return (PartialEvaluationContext)((Map)cache.get(adminUser.getId())).get(resourceType.getType());
    }

    private List<Predicate> buildPredicates(PartialEvaluationContext context) {
        ResourceType resourceType;
        List<Predicate> storageFilters = this.getStorageFilters(context);
        CriteriaBuilder builder = context.getCriteriaBuilder();
        Path<?> path = context.getPath();
        if (this.isDenied(storageFilters, context)) {
            return List.of(builder.equal((Expression)path.get(ID_FIELD), (Object)NO_ID));
        }
        Set<String> deniedIds = context.getDeniedResources();
        if (deniedIds.contains((resourceType = context.getResourceType()).getType())) {
            deniedIds = Set.of();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!deniedIds.isEmpty()) {
            predicates.add(builder.not((Expression)path.get(ID_FIELD).in(deniedIds)));
        }
        List<Predicate> storageNegateFilters = this.getStorageNegateFilters(context);
        predicates.addAll(storageNegateFilters);
        Set<String> allowedResourceIds = context.getAllowedResources();
        if (allowedResourceIds.contains(resourceType.getType())) {
            allowedResourceIds = Set.of();
        }
        if (allowedResourceIds.isEmpty()) {
            predicates.addAll(storageFilters);
            return predicates;
        }
        if (storageFilters.isEmpty()) {
            predicates.add(builder.and(new Predicate[]{path.get(ID_FIELD).in(allowedResourceIds)}));
        } else {
            ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(storageFilters);
            orPredicates.add(path.get(ID_FIELD).in(allowedResourceIds));
            predicates.add(builder.or(orPredicates.toArray(new Predicate[0])));
        }
        return predicates;
    }

    private PartialEvaluationContext createEvaluationContext(KeycloakSession session, ResourceType resourceType, Set<String> allowedResources, Set<String> deniedResources, PartialEvaluationStorageProvider storage, CriteriaBuilder builder, CriteriaQuery<?> queryBuilder, Path<?> path, UserModel adminUser) {
        PartialEvaluationContext context = new PartialEvaluationContext(resourceType, allowedResources, deniedResources, storage, builder, queryBuilder, path);
        String groupType = resourceType.getGroupType();
        if (groupType != null) {
            ResourceType groupResourceType = (ResourceType)AdminPermissionsSchema.SCHEMA.getResourceTypes().get(groupType);
            if (groupResourceType == null) {
                return context;
            }
            PartialEvaluationContext evaluateGroups = this.runEvaluation(session, adminUser, groupResourceType, storage, builder, queryBuilder, path);
            context.setAllowedGroups(evaluateGroups.getAllowedResources());
            context.setDeniedGroups(evaluateGroups.getDeniedResources());
        }
        return context;
    }

    private List<Predicate> getStorageFilters(PartialEvaluationContext context) {
        PartialEvaluationStorageProvider storage = context.getStorage();
        return storage == null ? List.of() : storage.getFilters(context);
    }

    private List<Predicate> getStorageNegateFilters(PartialEvaluationContext context) {
        PartialEvaluationStorageProvider storage = context.getStorage();
        return storage == null ? List.of() : storage.getNegateFilters(context);
    }

    private boolean isDenied(List<Predicate> storageFilters, PartialEvaluationContext context) {
        return context.getAllowedResources().isEmpty() && storageFilters.isEmpty();
    }

    private List<PartialEvaluationPolicyProvider> getPartialEvaluationPolicyProviders(KeycloakSession session) {
        return session.getAllProviders(PolicyProvider.class).stream().filter(provider -> provider instanceof PartialEvaluationPolicyProvider).map(PartialEvaluationPolicyProvider.class::cast).toList();
    }

    private PartialEvaluationPolicyProvider getPartialEvaluationPolicyProvider(Policy policy, List<PartialEvaluationPolicyProvider> policyProviders) {
        return policyProviders.stream().filter(p -> p.supports(policy)).findAny().orElse(null);
    }

    private boolean hasViewScope(Policy permission) {
        return permission.getScopes().stream().map(Scope::getName).anyMatch(name -> name.startsWith("view"));
    }

    private boolean shouldSkipPartialEvaluation(KeycloakSession session, UserModel user, ResourceType resourceType) {
        if (AdminPermissionsSchema.isSkipEvaluation(session)) {
            return true;
        }
        if (user == null) {
            return true;
        }
        ClientModel client = this.getRealmManagementClient(session);
        if (client == null) {
            return true;
        }
        if (resourceType.equals(AdminPermissionsSchema.USERS) || resourceType.equals(AdminPermissionsSchema.GROUPS)) {
            return user.hasRole(client.getRole(AdminRoles.VIEW_USERS)) || user.hasRole(client.getRole(AdminRoles.MANAGE_USERS)) || !this.hasAnyQueryAdminRole(client, user);
        }
        if (resourceType.equals(AdminPermissionsSchema.CLIENTS)) {
            return user.hasRole(client.getRole(AdminRoles.VIEW_CLIENTS)) || user.hasRole(client.getRole(AdminRoles.MANAGE_CLIENTS)) || !this.hasAnyQueryAdminRole(client, user);
        }
        return false;
    }

    private ClientModel getRealmManagementClient(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        if (realm.getName().equals(Config.getAdminRealm())) {
            return session.clients().getClientByClientId(realm, realm.getMasterAdminClient().getClientId());
        }
        return realm.getClientByClientId("realm-management");
    }

    private boolean hasAnyQueryAdminRole(ClientModel client, UserModel user) {
        boolean result = false;
        for (String adminRole : List.of(AdminRoles.QUERY_CLIENTS, AdminRoles.QUERY_GROUPS, AdminRoles.QUERY_USERS)) {
            RoleModel role = client.getRole(adminRole);
            if (!user.hasRole(role)) continue;
            result = true;
            break;
        }
        return result;
    }
}

