/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;

public class ClientApplicationSynchronizer
implements Synchronizer<ClientModel.ClientRemovedEvent> {
    @Override
    public void synchronize(ClientModel.ClientRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        AdminPermissionsSchema.SCHEMA.removeResourceObject(authorizationProvider, (ProviderEvent)event);
        this.removeFromClientPolicies(event, authorizationProvider);
    }

    private void removeFromClientPolicies(ClientModel.ClientRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        ResourceServerStore store = storeFactory.getResourceServerStore();
        ResourceServer resourceServer = store.findByClient(event.getClient());
        if (resourceServer != null) {
            storeFactory.getResourceServerStore().delete(event.getClient());
        }
        EnumMap<Policy.FilterOption, String[]> attributes = new EnumMap<Policy.FilterOption, String[]>(Policy.FilterOption.class);
        attributes.put(Policy.FilterOption.TYPE, new String[]{"client"});
        attributes.put(Policy.FilterOption.CONFIG, new String[]{"clients", event.getClient().getId()});
        attributes.put(Policy.FilterOption.ANY_OWNER, Policy.FilterOption.EMPTY_FILTER);
        List<Policy> search = storeFactory.getPolicyStore().find(null, attributes, null, null);
        for (Policy policy : search) {
            PolicyProviderFactory policyFactory = authorizationProvider.getProviderFactory(policy.getType());
            ClientPolicyRepresentation representation = (ClientPolicyRepresentation)ClientPolicyRepresentation.class.cast(policyFactory.toRepresentation(policy, authorizationProvider));
            Set clients = representation.getClients();
            clients.remove(event.getClient().getId());
            policyFactory.onUpdate(policy, representation, authorizationProvider);
        }
    }
}

