/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.AuthenticationExecutionEntity;
import org.keycloak.models.jpa.entities.AuthenticationFlowEntity;
import org.keycloak.models.jpa.entities.AuthenticatorConfigEntity;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientInitialAccessEntity;
import org.keycloak.models.jpa.entities.ComponentConfigEntity;
import org.keycloak.models.jpa.entities.ComponentEntity;
import org.keycloak.models.jpa.entities.DefaultClientScopeRealmMappingEntity;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmLocalizationTextsEntity;
import org.keycloak.models.jpa.entities.RequiredActionProviderEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.utils.StreamsUtil;

public class RealmAdapter
implements StorageProviderRealmModel,
JpaModel<RealmEntity> {
    protected static final Logger logger = Logger.getLogger(RealmAdapter.class);
    protected RealmEntity realm;
    protected EntityManager em;
    protected KeycloakSession session;
    private PasswordPolicy passwordPolicy;
    private OTPPolicy otpPolicy;
    private static final String BROWSER_HEADER_PREFIX = "_browser_header.";
    public static final String COMPONENT_PROVIDER_EXISTS_DISABLED = "component.provider.exists.disabled";

    public Long getClientsCount() {
        return this.session.clients().getClientsCount((RealmModel)this);
    }

    public RealmAdapter(KeycloakSession session, EntityManager em, RealmEntity realm) {
        this.session = session;
        this.em = em;
        this.realm = realm;
    }

    public RealmEntity getEntity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public String getDisplayNameHtml() {
        return this.getAttribute("displayNameHtml");
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.setAttribute("displayNameHtml", displayNameHtml);
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.em.flush();
    }

    public boolean isUserManagedAccessAllowed() {
        return this.realm.isAllowUserManagedAccess();
    }

    public void setUserManagedAccessAllowed(boolean userManagedAccessAllowed) {
        this.realm.setAllowUserManagedAccess(userManagedAccessAllowed);
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
        if (registrationEmailAsUsername) {
            this.realm.setDuplicateEmailsAllowed(false);
        }
        this.em.flush();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.em.flush();
    }

    public void setAttribute(String name, String value) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        RealmAttributeEntity attr = new RealmAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setRealm(this.realm);
        this.em.persist((Object)attr);
        this.realm.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<RealmAttributeEntity> it = this.realm.getAttributes().iterator();
        while (it.hasNext()) {
            RealmAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.getAttribute("defaultSignatureAlgorithm");
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.setAttribute("defaultSignatureAlgorithm", defaultSignatureAlgorithm);
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute("bruteForceProtected", false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute("bruteForceProtected", value);
    }

    public boolean isPermanentLockout() {
        return this.getAttribute("permanentLockout", false);
    }

    public void setPermanentLockout(boolean val) {
        this.setAttribute("permanentLockout", val);
    }

    public int getMaxTemporaryLockouts() {
        return this.getAttribute("maxTemporaryLockouts", 0);
    }

    public RealmRepresentation.BruteForceStrategy getBruteForceStrategy() {
        String name = this.getAttribute("bruteForceStrategy");
        if (name == null) {
            return RealmRepresentation.BruteForceStrategy.MULTIPLE;
        }
        return RealmRepresentation.BruteForceStrategy.valueOf((String)name);
    }

    public void setBruteForceStrategy(RealmRepresentation.BruteForceStrategy val) {
        this.setAttribute("bruteForceStrategy", val.toString());
    }

    public void setMaxTemporaryLockouts(int val) {
        this.setAttribute("maxTemporaryLockouts", val);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute("maxFailureWaitSeconds", 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute("maxFailureWaitSeconds", val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute("waitIncrementSeconds", 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute("waitIncrementSeconds", val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute("quickLoginCheckMilliSeconds", 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute("quickLoginCheckMilliSeconds", val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute("minimumQuickLoginWaitSeconds", 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute("minimumQuickLoginWaitSeconds", val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute("maxDeltaTimeSeconds", 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute("maxDeltaTimeSeconds", val);
    }

    public int getFailureFactor() {
        return this.getAttribute("failureFactor", 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute("failureFactor", failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isLoginWithEmailAllowed() {
        return this.realm.isLoginWithEmailAllowed();
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        this.realm.setLoginWithEmailAllowed(loginWithEmailAllowed);
        if (loginWithEmailAllowed) {
            this.realm.setDuplicateEmailsAllowed(false);
        }
        this.em.flush();
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.realm.isDuplicateEmailsAllowed();
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        this.realm.setDuplicateEmailsAllowed(duplicateEmailsAllowed);
        if (duplicateEmailsAllowed) {
            this.realm.setLoginWithEmailAllowed(false);
            this.realm.setRegistrationEmailAsUsername(false);
        }
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
        this.em.flush();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public boolean isRevokeRefreshToken() {
        return this.realm.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.realm.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getRefreshTokenMaxReuse() {
        return this.realm.getRefreshTokenMaxReuse();
    }

    public void setRefreshTokenMaxReuse(int revokeRefreshTokenReuseCount) {
        this.realm.setRefreshTokenMaxReuse(revokeRefreshTokenReuseCount);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.realm.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.realm.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        return this.realm.getSsoSessionIdleTimeoutRememberMe();
    }

    public void setSsoSessionIdleTimeoutRememberMe(int seconds) {
        this.realm.setSsoSessionIdleTimeoutRememberMe(seconds);
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        return this.realm.getSsoSessionMaxLifespanRememberMe();
    }

    public void setSsoSessionMaxLifespanRememberMe(int seconds) {
        this.realm.setSsoSessionMaxLifespanRememberMe(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        return this.realm.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.realm.setOfflineSessionIdleTimeout(seconds);
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        return this.getAttribute("offlineSessionMaxLifespanEnabled", false);
    }

    public void setOfflineSessionMaxLifespanEnabled(boolean offlineSessionMaxLifespanEnabled) {
        this.setAttribute("offlineSessionMaxLifespanEnabled", offlineSessionMaxLifespanEnabled);
    }

    public int getOfflineSessionMaxLifespan() {
        return this.getAttribute("offlineSessionMaxLifespan", 5184000);
    }

    public void setOfflineSessionMaxLifespan(int seconds) {
        this.setAttribute("offlineSessionMaxLifespan", seconds);
    }

    public int getClientSessionIdleTimeout() {
        return this.getAttribute("clientSessionIdleTimeout", 0);
    }

    public void setClientSessionIdleTimeout(int seconds) {
        this.setAttribute("clientSessionIdleTimeout", seconds);
    }

    public int getClientSessionMaxLifespan() {
        return this.getAttribute("clientSessionMaxLifespan", 0);
    }

    public void setClientSessionMaxLifespan(int seconds) {
        this.setAttribute("clientSessionMaxLifespan", seconds);
    }

    public int getClientOfflineSessionIdleTimeout() {
        return this.getAttribute("clientOfflineSessionIdleTimeout", 0);
    }

    public void setClientOfflineSessionIdleTimeout(int seconds) {
        this.setAttribute("clientOfflineSessionIdleTimeout", seconds);
    }

    public int getClientOfflineSessionMaxLifespan() {
        return this.getAttribute("clientOfflineSessionMaxLifespan", 0);
    }

    public void setClientOfflineSessionMaxLifespan(int seconds) {
        this.setAttribute("clientOfflineSessionMaxLifespan", seconds);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public OAuth2DeviceConfig getOAuth2DeviceConfig() {
        return new OAuth2DeviceConfig((RealmModel)this);
    }

    public CibaConfig getCibaPolicy() {
        return new CibaConfig((RealmModel)this);
    }

    public ParConfig getParPolicy() {
        return new ParConfig((RealmModel)this);
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        HashMap userActionTokens = new HashMap();
        this.getAttributes().entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> !((String)entry.getValue()).isEmpty()).filter(entry -> ((String)entry.getKey()).startsWith("actionTokenGeneratedByUserLifespan.")).forEach(entry -> userActionTokens.put(((String)entry.getKey()).substring("actionTokenGeneratedByUserLifespan".length() + 1), Integer.valueOf((String)entry.getValue())));
        return Collections.unmodifiableMap(userActionTokens);
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
        this.em.flush();
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        return this.getAttribute("actionTokenGeneratedByAdminLifespan", 43200);
    }

    public void setActionTokenGeneratedByAdminLifespan(int actionTokenGeneratedByAdminLifespan) {
        this.setAttribute("actionTokenGeneratedByAdminLifespan", actionTokenGeneratedByAdminLifespan);
    }

    public int getActionTokenGeneratedByUserLifespan() {
        return this.getAttribute("actionTokenGeneratedByUserLifespan", this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(int actionTokenGeneratedByUserLifespan) {
        this.setAttribute("actionTokenGeneratedByUserLifespan", actionTokenGeneratedByUserLifespan);
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenId) {
        if (actionTokenId == null || this.getAttribute("actionTokenGeneratedByUserLifespan." + actionTokenId) == null) {
            return this.getActionTokenGeneratedByUserLifespan();
        }
        return this.getAttribute("actionTokenGeneratedByUserLifespan." + actionTokenId, this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(String actionTokenId, Integer actionTokenGeneratedByUserLifespan) {
        if (actionTokenGeneratedByUserLifespan != null) {
            this.setAttribute("actionTokenGeneratedByUserLifespan." + actionTokenId, actionTokenGeneratedByUserLifespan);
        }
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setRealm(this.realm);
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public Stream<RequiredCredentialModel> getRequiredCredentialsStream() {
        return this.realm.getRequiredCredentials().stream().map(this::toRequiredCredentialModel);
    }

    public Stream<GroupModel> getDefaultGroupsStream() {
        return this.realm.getDefaultGroupIds().stream().map(this::getGroupById);
    }

    public void addDefaultGroup(GroupModel group) {
        Set<String> groupsIds = this.realm.getDefaultGroupIds();
        if (groupsIds.contains(group.getId())) {
            return;
        }
        groupsIds.add(group.getId());
        this.em.flush();
        GroupModel.GroupUpdatedEvent.fire((GroupModel)group, (KeycloakSession)this.session);
    }

    public void removeDefaultGroup(GroupModel group) {
        Set<String> groupIds = this.realm.getDefaultGroupIds();
        if (groupIds.remove(group.getId())) {
            this.em.flush();
        }
    }

    public Stream<ClientModel> getClientsStream() {
        return this.session.clients().getClientsStream((RealmModel)this);
    }

    public Stream<ClientModel> getClientsStream(Integer firstResult, Integer maxResults) {
        return this.session.clients().getClientsStream((RealmModel)this, firstResult, maxResults);
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream() {
        return this.session.clients().getAlwaysDisplayInConsoleClientsStream((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.session.clients().addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.session.clients().addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        if (id == null) {
            return false;
        }
        ClientModel client = this.getClientById(id);
        if (client == null) {
            return false;
        }
        return this.session.clients().removeClient((RealmModel)this, id);
    }

    public ClientModel getClientById(String id) {
        return this.session.clients().getClientById((RealmModel)this, id);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.session.clients().getClientByClientId((RealmModel)this, clientId);
    }

    public Stream<ClientModel> searchClientByClientIdStream(String clientId, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByClientIdStream((RealmModel)this, clientId, firstResult, maxResults);
    }

    public Stream<ClientModel> searchClientByAttributes(Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByAttributes((RealmModel)this, attributes, firstResult, maxResults);
    }

    public Stream<ClientModel> searchClientByAuthenticationFlowBindingOverrides(Map<String, String> overrides, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByAuthenticationFlowBindingOverrides((RealmModel)this, overrides, firstResult, maxResults);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        Map<String, String> attributes = this.getAttributes();
        if (attributes.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith(BROWSER_HEADER_PREFIX)) continue;
            headers.put(entry.getKey().substring(BROWSER_HEADER_PREFIX.length()), entry.getValue());
        }
        return Collections.unmodifiableMap(headers);
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.setAttribute(BROWSER_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getSmtpConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(this.realm.getSmtpConfig());
        return Collections.unmodifiableMap(config);
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public RoleModel getRole(String name) {
        return this.session.roles().getRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.roles().addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.roles().addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.session.roles().getRealmRolesStream((RealmModel)this);
    }

    public Stream<RoleModel> getRolesStream(Integer first, Integer max) {
        return this.session.roles().getRealmRolesStream((RealmModel)this, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.session.roles().searchForRolesStream((RealmModel)this, search, first, max);
    }

    public RoleModel getRoleById(String id) {
        return this.session.roles().getRoleById((RealmModel)this, id);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = PasswordPolicy.parse((KeycloakSession)this.session, (String)this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public OTPPolicy getOTPPolicy() {
        if (this.otpPolicy == null) {
            this.otpPolicy = new OTPPolicy();
            this.otpPolicy.setDigits(this.realm.getOtpPolicyDigits());
            this.otpPolicy.setAlgorithm(this.realm.getOtpPolicyAlgorithm());
            this.otpPolicy.setInitialCounter(this.realm.getOtpPolicyInitialCounter());
            this.otpPolicy.setLookAheadWindow(this.realm.getOtpPolicyLookAheadWindow());
            this.otpPolicy.setType(this.realm.getOtpPolicyType());
            this.otpPolicy.setPeriod(this.realm.getOtpPolicyPeriod());
            this.otpPolicy.setCodeReusable(this.getAttribute("realmReusableOtpCode", false).booleanValue());
        }
        return this.otpPolicy;
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.realm.setOtpPolicyAlgorithm(policy.getAlgorithm());
        this.realm.setOtpPolicyDigits(policy.getDigits());
        this.realm.setOtpPolicyInitialCounter(policy.getInitialCounter());
        this.realm.setOtpPolicyLookAheadWindow(policy.getLookAheadWindow());
        this.realm.setOtpPolicyType(policy.getType());
        this.realm.setOtpPolicyPeriod(policy.getPeriod());
        this.setAttribute("realmReusableOtpCode", policy.isCodeReusable());
        this.em.flush();
    }

    public WebAuthnPolicy getWebAuthnPolicy() {
        return this.getWebAuthnPolicy("");
    }

    public void setWebAuthnPolicy(WebAuthnPolicy policy) {
        this.setWebAuthnPolicy(policy, "");
    }

    public WebAuthnPolicy getWebAuthnPolicyPasswordless() {
        return this.getWebAuthnPolicy("Passwordless");
    }

    public void setWebAuthnPolicyPasswordless(WebAuthnPolicy policy) {
        this.setWebAuthnPolicy(policy, "Passwordless");
    }

    private WebAuthnPolicy getWebAuthnPolicy(String attributePrefix) {
        WebAuthnPolicy policy = new WebAuthnPolicy();
        String rpEntityName = this.getAttribute("webAuthnPolicyRpEntityName" + attributePrefix);
        if (rpEntityName == null || rpEntityName.isEmpty()) {
            rpEntityName = "keycloak";
        }
        policy.setRpEntityName(rpEntityName);
        String signatureAlgorithmsString = this.getAttribute("webAuthnPolicySignatureAlgorithms" + attributePrefix);
        if (signatureAlgorithmsString == null || signatureAlgorithmsString.isEmpty()) {
            signatureAlgorithmsString = "ES256,RS256";
        }
        List<String> signatureAlgorithms = Arrays.asList(signatureAlgorithmsString.split(","));
        policy.setSignatureAlgorithm(signatureAlgorithms);
        String rpId = this.getAttribute("webAuthnPolicyRpId" + attributePrefix);
        if (rpId == null || rpId.isEmpty()) {
            rpId = "";
        }
        policy.setRpId(rpId);
        String attestationConveyancePreference = this.getAttribute("webAuthnPolicyAttestationConveyancePreference" + attributePrefix);
        if (attestationConveyancePreference == null || attestationConveyancePreference.isEmpty()) {
            attestationConveyancePreference = "not specified";
        }
        policy.setAttestationConveyancePreference(attestationConveyancePreference);
        String authenticatorAttachment = this.getAttribute("webAuthnPolicyAuthenticatorAttachment" + attributePrefix);
        if (authenticatorAttachment == null || authenticatorAttachment.isEmpty()) {
            authenticatorAttachment = "not specified";
        }
        policy.setAuthenticatorAttachment(authenticatorAttachment);
        String requireResidentKey = this.getAttribute("webAuthnPolicyRequireResidentKey" + attributePrefix);
        if (requireResidentKey == null || requireResidentKey.isEmpty()) {
            requireResidentKey = "not specified";
        }
        policy.setRequireResidentKey(requireResidentKey);
        String userVerificationRequirement = this.getAttribute("webAuthnPolicyUserVerificationRequirement" + attributePrefix);
        if (userVerificationRequirement == null || userVerificationRequirement.isEmpty()) {
            userVerificationRequirement = "not specified";
        }
        policy.setUserVerificationRequirement(userVerificationRequirement);
        String createTime = this.getAttribute("webAuthnPolicyCreateTimeout" + attributePrefix);
        if (createTime != null) {
            policy.setCreateTimeout(Integer.parseInt(createTime));
        } else {
            policy.setCreateTimeout(0);
        }
        String avoidSameAuthenticatorRegister = this.getAttribute("webAuthnPolicyAvoidSameAuthenticatorRegister" + attributePrefix);
        if (avoidSameAuthenticatorRegister != null) {
            policy.setAvoidSameAuthenticatorRegister(Boolean.parseBoolean(avoidSameAuthenticatorRegister));
        }
        String acceptableAaguidsString = this.getAttribute("webAuthnPolicyAcceptableAaguids" + attributePrefix);
        List<Object> acceptableAaguids = new ArrayList();
        if (acceptableAaguidsString != null && !acceptableAaguidsString.isEmpty()) {
            acceptableAaguids = Arrays.asList(acceptableAaguidsString.split(","));
        }
        policy.setAcceptableAaguids(acceptableAaguids);
        String extraOriginsString = this.getAttribute("webAuthnPolicyExtraOrigins" + attributePrefix);
        List<Object> extraOrigins = new ArrayList();
        if (extraOriginsString != null && !extraOriginsString.isEmpty()) {
            extraOrigins = Arrays.asList(extraOriginsString.split(","));
        }
        policy.setExtraOrigins(extraOrigins);
        return policy;
    }

    private void setWebAuthnPolicy(WebAuthnPolicy policy, String attributePrefix) {
        String rpEntityName = policy.getRpEntityName();
        this.setAttribute("webAuthnPolicyRpEntityName" + attributePrefix, rpEntityName);
        List signatureAlgorithms = policy.getSignatureAlgorithm();
        String signatureAlgorithmsString = String.join((CharSequence)",", signatureAlgorithms);
        this.setAttribute("webAuthnPolicySignatureAlgorithms" + attributePrefix, signatureAlgorithmsString);
        String rpId = policy.getRpId();
        this.setAttribute("webAuthnPolicyRpId" + attributePrefix, rpId);
        String attestationConveyancePreference = policy.getAttestationConveyancePreference();
        this.setAttribute("webAuthnPolicyAttestationConveyancePreference" + attributePrefix, attestationConveyancePreference);
        String authenticatorAttachment = policy.getAuthenticatorAttachment();
        this.setAttribute("webAuthnPolicyAuthenticatorAttachment" + attributePrefix, authenticatorAttachment);
        String requireResidentKey = policy.getRequireResidentKey();
        this.setAttribute("webAuthnPolicyRequireResidentKey" + attributePrefix, requireResidentKey);
        String userVerificationRequirement = policy.getUserVerificationRequirement();
        this.setAttribute("webAuthnPolicyUserVerificationRequirement" + attributePrefix, userVerificationRequirement);
        int createTime = policy.getCreateTimeout();
        this.setAttribute("webAuthnPolicyCreateTimeout" + attributePrefix, Integer.toString(createTime));
        boolean avoidSameAuthenticatorRegister = policy.isAvoidSameAuthenticatorRegister();
        this.setAttribute("webAuthnPolicyAvoidSameAuthenticatorRegister" + attributePrefix, Boolean.toString(avoidSameAuthenticatorRegister));
        List acceptableAaguids = policy.getAcceptableAaguids();
        if (acceptableAaguids != null && !acceptableAaguids.isEmpty()) {
            String acceptableAaguidsString = String.join((CharSequence)",", acceptableAaguids);
            this.setAttribute("webAuthnPolicyAcceptableAaguids" + attributePrefix, acceptableAaguidsString);
        } else {
            this.removeAttribute("webAuthnPolicyAcceptableAaguids" + attributePrefix);
        }
        List extraOrigins = policy.getExtraOrigins();
        if (extraOrigins != null && !extraOrigins.isEmpty()) {
            String extraOriginsString = String.join((CharSequence)",", extraOrigins);
            this.setAttribute("webAuthnPolicyExtraOrigins" + attributePrefix, extraOriginsString);
        } else {
            this.removeAttribute("webAuthnPolicyExtraOrigins" + attributePrefix);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.em.flush();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.em.flush();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.em.flush();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.em.flush();
    }

    public Stream<String> getEventsListenersStream() {
        return this.realm.getEventsListeners().stream();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.realm.setEventsListeners(listeners);
        this.em.flush();
    }

    public Stream<String> getEnabledEventTypesStream() {
        return this.realm.getEnabledEventTypes().stream();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.realm.setEnabledEventTypes(enabledEventTypes);
        this.em.flush();
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
        this.em.flush();
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
        this.em.flush();
    }

    public boolean isOrganizationsEnabled() {
        return this.getAttribute("organizationsEnabled", Boolean.FALSE);
    }

    public void setOrganizationsEnabled(boolean organizationsEnabled) {
        this.setAttribute("organizationsEnabled", organizationsEnabled);
    }

    public boolean isAdminPermissionsEnabled() {
        return this.getAttribute("adminPermissionsEnabled", Boolean.FALSE);
    }

    public void setAdminPermissionsEnabled(boolean adminPermissionsEnabled) {
        boolean isAdminPermissionsAlreadyEnabled = this.getAdminPermissionsClient() != null;
        this.setAttribute("adminPermissionsEnabled", adminPermissionsEnabled);
        if (adminPermissionsEnabled && !isAdminPermissionsAlreadyEnabled) {
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean isVerifiableCredentialsEnabled() {
        return this.getAttribute("verifiableCredentialsEnabled", Boolean.FALSE);
    }

    public void setVerifiableCredentialsEnabled(boolean verifiableCredentialsEnabled) {
        this.setAttribute("verifiableCredentialsEnabled", verifiableCredentialsEnabled);
    }

    public ClientModel getMasterAdminClient() {
        String masterAdminClientId = this.realm.getMasterAdminClient();
        if (masterAdminClientId == null) {
            return null;
        }
        RealmAdapter masterRealm = this.getName().equals(Config.getAdminRealm()) ? this : this.session.realms().getRealmByName(Config.getAdminRealm());
        return this.session.clients().getClientById((RealmModel)masterRealm, masterAdminClientId);
    }

    public void setMasterAdminClient(ClientModel client) {
        String appEntityId = client != null ? ((ClientEntity)this.em.getReference(ClientEntity.class, (Object)client.getId())).getId() : null;
        this.realm.setMasterAdminClient(appEntityId);
        this.em.flush();
    }

    public void setDefaultRole(RoleModel role) {
        this.realm.setDefaultRoleId(role.getId());
    }

    public RoleModel getDefaultRole() {
        if (this.realm.getDefaultRoleId() == null) {
            return null;
        }
        return this.session.roles().getRoleById((RealmModel)this, this.realm.getDefaultRoleId());
    }

    public void setAdminPermissionsClient(ClientModel client) {
        this.setAttribute("adminPermissionsClientId", client.getId());
    }

    public ClientModel getAdminPermissionsClient() {
        if (this.getAttribute("adminPermissionsClientId") == null) {
            return null;
        }
        return this.session.clients().getClientById((RealmModel)this, this.getAttribute("adminPermissionsClientId"));
    }

    public Stream<IdentityProviderModel> getIdentityProvidersStream() {
        return this.session.identityProviders().getAllStream();
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        return this.session.identityProviders().getByAlias(alias);
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        this.session.identityProviders().create(identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        this.session.identityProviders().remove(alias);
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.session.identityProviders().update(identityProvider);
    }

    public boolean isIdentityFederationEnabled() {
        return this.session.identityProviders().isIdentityFederationEnabled();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
        this.em.flush();
    }

    public Stream<String> getSupportedLocalesStream() {
        return this.realm.getSupportedLocales().stream();
    }

    public void setSupportedLocales(Set<String> locales) {
        this.realm.setSupportedLocales(locales);
        this.em.flush();
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
        this.em.flush();
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersStream() {
        return this.session.identityProviders().getMappersStream();
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersByAliasStream(String brokerAlias) {
        return this.session.identityProviders().getMappersByAliasStream(brokerAlias);
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        return this.session.identityProviders().createMapper(model);
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.session.identityProviders().removeMapper(mapping);
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.session.identityProviders().updateMapper(mapping);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        return this.session.identityProviders().getMapperById(id);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        return this.session.identityProviders().getMapperByName(alias, name);
    }

    public AuthenticationFlowModel getBrowserFlow() {
        String flowId = this.realm.getBrowserFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.realm.setBrowserFlow(flow.getId());
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        String flowId = this.realm.getRegistrationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.realm.setRegistrationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        String flowId = this.realm.getDirectGrantFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.realm.setDirectGrantFlow(flow.getId());
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        String flowId = this.realm.getResetCredentialsFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.realm.setResetCredentialsFlow(flow.getId());
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        String flowId = this.realm.getClientAuthenticationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.realm.setClientAuthenticationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        String flowId = this.realm.getDockerAuthenticationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setDockerAuthenticationFlow(AuthenticationFlowModel flow) {
        this.realm.setDockerAuthenticationFlow(flow.getId());
    }

    public AuthenticationFlowModel getFirstBrokerLoginFlow() {
        String flowId = this.getAttribute("firstBrokerLoginFlowId");
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setFirstBrokerLoginFlow(AuthenticationFlowModel flow) {
        this.setAttribute("firstBrokerLoginFlowId", flow.getId());
    }

    public Stream<AuthenticationFlowModel> getAuthenticationFlowsStream() {
        return this.realm.getAuthenticationFlows().stream().map(this::entityToModel);
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        return this.realm.getAuthenticationFlows().stream().filter(flow -> Objects.equals(flow.getAlias(), alias)).findFirst().map(this::entityToModel).orElse(null);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        return this.getAuthenticatorConfigsStream().filter(config -> Objects.equals(config.getAlias(), alias)).findFirst().orElse(null);
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setProviderId(entity.getProviderId());
        model.setDescription(entity.getDescription());
        model.setBuiltIn(entity.isBuiltIn());
        model.setTopLevel(entity.isTopLevel());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        AuthenticationFlowEntity entity = this.getAuthenticationFlowEntity(id, false);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        if (KeycloakModelUtils.isFlowUsed((KeycloakSession)this.session, (RealmModel)this, (AuthenticationFlowModel)model)) {
            throw new ModelException("Cannot remove authentication flow, it is currently in use");
        }
        AuthenticationFlowEntity entity = this.getAuthenticationFlowEntity(model.getId(), true);
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = this.getAuthenticationFlowEntity(model.getId(), false);
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
    }

    private AuthenticationFlowEntity getAuthenticationFlowEntity(String id, boolean readForRemove) {
        AuthenticationFlowEntity entity;
        AuthenticationFlowEntity authenticationFlowEntity = entity = readForRemove ? (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE) : (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!entity.getRealm().equals(this.getEntity())) {
            return null;
        }
        return entity;
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
        entity.setRealm(this.realm);
        this.realm.getAuthenticationFlows().add(entity);
        this.em.persist((Object)entity);
        model.setId(entity.getId());
        return model;
    }

    public Stream<AuthenticationExecutionModel> getAuthenticationExecutionsStream(String flowId) {
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.getReference(AuthenticationFlowEntity.class, (Object)flowId);
        return flow.getExecutions().stream().filter(e -> this.getId().equals(e.getRealm().getId())).map(this::entityToModel).sorted((Comparator<AuthenticationExecutionModel>)AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlow().getId());
        model.setAuthenticatorFlow(entity.isAutheticatorFlow());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity entity = this.getAuthenticationExecution(id, false);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String flowId) {
        TypedQuery query = this.em.createNamedQuery("authenticationFlowExecution", AuthenticationExecutionEntity.class).setParameter("flowId", (Object)flowId);
        if (query.getResultList().isEmpty()) {
            return null;
        }
        AuthenticationExecutionEntity authenticationFlowExecution = (AuthenticationExecutionEntity)query.getResultList().get(0);
        return this.entityToModel(authenticationFlowExecution);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setFlowId(model.getFlowId());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getParentFlow());
        entity.setParentFlow(flow);
        flow.getExecutions().add(entity);
        entity.setRealm(this.realm);
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        this.em.persist((Object)entity);
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = this.getAuthenticationExecution(model.getId(), false);
        if (entity == null) {
            return;
        }
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        entity.setFlowId(model.getFlowId());
        if (model.getParentFlow() != null) {
            AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getParentFlow());
            entity.setParentFlow(flow);
        }
        this.em.flush();
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = this.getAuthenticationExecution(model.getId(), true);
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    private AuthenticationExecutionEntity getAuthenticationExecution(String id, boolean readForRemove) {
        AuthenticationExecutionEntity entity;
        AuthenticationExecutionEntity authenticationExecutionEntity = entity = readForRemove ? (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE) : (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!entity.getRealm().equals(this.getEntity())) {
            return null;
        }
        return entity;
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity auth = new AuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setRealm(this.realm);
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticatorConfigs().add(auth);
        this.em.persist((Object)auth);
        model.setId(auth.getId());
        return model;
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(model.getId(), true);
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(id, false);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorConfigModel entityToModel(AuthenticatorConfigEntity entity) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(model.getId(), false);
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            if (model.getConfig() != null) {
                entity.getConfig().putAll(model.getConfig());
            }
        }
        this.em.flush();
    }

    private AuthenticatorConfigEntity getAuthenticatorConfigEntity(String id, boolean readForRemove) {
        AuthenticatorConfigEntity entity;
        AuthenticatorConfigEntity authenticatorConfigEntity = entity = readForRemove ? (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE) : (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!entity.getRealm().equals(this.getEntity())) {
            return null;
        }
        return entity;
    }

    public Stream<AuthenticatorConfigModel> getAuthenticatorConfigsStream() {
        return this.realm.getAuthenticatorConfigs().stream().map(this::entityToModel);
    }

    public Stream<RequiredActionConfigModel> getRequiredActionConfigsStream() {
        return this.getRequiredActionProvidersStream().map(this::requiredActionToConfigModel);
    }

    public RequiredActionConfigModel getRequiredActionConfigById(String id) {
        return this.getRequiredActionConfigsStream().filter(req -> req.getId().equals(id)).findFirst().orElse(null);
    }

    public RequiredActionConfigModel getRequiredActionConfigByAlias(String alias) {
        return this.getRequiredActionConfigsStream().filter(req -> req.getAlias().equals(alias)).findFirst().orElse(null);
    }

    private RequiredActionConfigModel requiredActionToConfigModel(RequiredActionProviderModel reqAction) {
        RequiredActionConfigModel configModel = new RequiredActionConfigModel();
        configModel.setId(reqAction.getId());
        configModel.setConfig(new HashMap(reqAction.getConfig()));
        configModel.setProviderId(reqAction.getProviderId());
        configModel.setAlias(reqAction.getAlias());
        return configModel;
    }

    public void removeRequiredActionProviderConfig(RequiredActionConfigModel model) {
        this.getRequiredActionProvidersStream().filter(req -> req.getProviderId().equals(model.getProviderId()) && req.getAlias().equals(model.getAlias())).findFirst().ifPresent(reqAction -> {
            reqAction.setConfig(null);
            this.updateRequiredActionProvider((RequiredActionProviderModel)reqAction);
        });
    }

    public void updateRequiredActionConfig(RequiredActionConfigModel model) {
        this.getRequiredActionProvidersStream().filter(req -> req.getProviderId().equals(model.getProviderId()) && req.getAlias().equals(model.getAlias())).findFirst().ifPresent(reqAction -> {
            RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
            if (factory == null || !factory.isConfigurable()) {
                return;
            }
            factory.validateConfig(this.session, (RealmModel)this, model);
            HashMap<String, String> config = new HashMap<String, String>();
            if (reqAction.getConfig() != null) {
                config.putAll(reqAction.getConfig());
            }
            if (model != null && model.getConfig() != null) {
                for (ProviderConfigProperty configProperty : factory.getConfigMetadata()) {
                    String value = (String)model.getConfig().get(configProperty.getName());
                    config.put(configProperty.getName(), value);
                }
            }
            reqAction.setConfig(config);
            this.updateRequiredActionProvider((RequiredActionProviderModel)reqAction);
        });
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        if (this.getRequiredActionProviderByAlias(model.getAlias()) != null) {
            throw new ModelDuplicateException("A Required Action Provider with given alias already exists.");
        }
        RequiredActionProviderEntity action = new RequiredActionProviderEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        action.setId(id);
        action.setAlias(model.getAlias());
        action.setName(model.getName());
        action.setRealm(this.realm);
        action.setProviderId(model.getProviderId());
        action.setConfig(model.getConfig());
        action.setEnabled(model.isEnabled());
        action.setDefaultAction(model.isDefaultAction());
        action.setPriority(model.getPriority());
        this.realm.getRequiredActionProviders().add(action);
        this.em.persist((Object)action);
        this.em.flush();
        model.setId(action.getId());
        return model;
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredProviderEntity(model.getId(), true);
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        RequiredActionProviderEntity entity = this.getRequiredProviderEntity(id, false);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public RequiredActionProviderModel entityToModel(RequiredActionProviderEntity entity) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        model.setEnabled(entity.isEnabled());
        model.setDefaultAction(entity.isDefaultAction());
        model.setPriority(entity.getPriority());
        model.setName(entity.getName());
        if (entity.getConfig() != null) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.putAll(entity.getConfig());
            model.setConfig(config);
        }
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredProviderEntity(model.getId(), false);
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setProviderId(model.getProviderId());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        entity.setPriority(model.getPriority());
        entity.setName(model.getName());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            if (model.getConfig() != null) {
                entity.getConfig().putAll(model.getConfig());
            }
        }
        this.em.flush();
    }

    public Stream<RequiredActionProviderModel> getRequiredActionProvidersStream() {
        return this.realm.getRequiredActionProviders().stream().map(this::entityToModel).sorted((Comparator<RequiredActionProviderModel>)RequiredActionProviderModel.RequiredActionComparator.SINGLETON);
    }

    private RequiredActionProviderEntity getRequiredProviderEntity(String id, boolean readForRemove) {
        RequiredActionProviderEntity entity;
        RequiredActionProviderEntity requiredActionProviderEntity = entity = readForRemove ? (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE) : (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!entity.getRealm().equals(this.getEntity())) {
            return null;
        }
        return entity;
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        return this.getRequiredActionProvidersStream().filter(action -> Objects.equals(action.getAlias(), alias)).findFirst().orElse(null);
    }

    public GroupModel createGroup(String id, String name, GroupModel toParent) {
        return this.session.groups().createGroup((RealmModel)this, id, name, toParent);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.session.groups().moveGroup((RealmModel)this, group, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.session.groups().getGroupById((RealmModel)this, id);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.session.groups().getGroupsStream((RealmModel)this);
    }

    public Long getGroupsCount(Boolean onlyTopGroups) {
        return this.session.groups().getGroupsCount((RealmModel)this, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(String search) {
        return this.session.groups().getGroupsCountByNameContaining((RealmModel)this, search);
    }

    public Stream<GroupModel> getTopLevelGroupsStream() {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(Integer first, Integer max) {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this, first, max);
    }

    public boolean removeGroup(GroupModel group) {
        return this.session.groups().removeGroup((RealmModel)this, group);
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        return this.session.clientScopes().getClientScopesStream((RealmModel)this);
    }

    public ClientScopeModel addClientScope(String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, name);
    }

    public ClientScopeModel addClientScope(String id, String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, id, name);
    }

    public boolean removeClientScope(String id) {
        return this.session.clientScopes().removeClientScope((RealmModel)this, id);
    }

    public ClientScopeModel getClientScopeById(String id) {
        return this.session.clientScopes().getClientScopeById((RealmModel)this, id);
    }

    public void addDefaultClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        DefaultClientScopeRealmMappingEntity entity = new DefaultClientScopeRealmMappingEntity();
        entity.setClientScopeId(clientScope.getId());
        entity.setRealm(this.getEntity());
        entity.setDefaultScope(defaultScope);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void removeDefaultClientScope(ClientScopeModel clientScope) {
        int numRemoved = this.em.createNamedQuery("deleteDefaultClientScopeRealmMapping").setParameter("clientScopeId", (Object)clientScope.getId()).setParameter("realm", (Object)this.getEntity()).executeUpdate();
        this.em.flush();
    }

    public Stream<ClientScopeModel> getDefaultClientScopesStream(boolean defaultScope) {
        TypedQuery query = this.em.createNamedQuery("defaultClientScopeRealmMappingIdsByRealm", String.class);
        query.setParameter("realm", (Object)this.getEntity());
        query.setParameter("defaultScope", (Object)defaultScope);
        return StreamsUtil.closing(query.getResultStream().map(this::getClientScopeById).filter(Objects::nonNull));
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        model = this.importComponentModel(model);
        ComponentUtil.notifyCreated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)model);
        return model;
    }

    public ComponentModel importComponentModel(ComponentModel model) {
        block6: {
            ComponentFactory componentFactory = null;
            try {
                componentFactory = ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)model);
                if (componentFactory == null && System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) == null) {
                    throw new IllegalArgumentException("Invalid component type");
                }
                componentFactory.validateConfiguration(this.session, (RealmModel)this, model);
            }
            catch (Exception e) {
                if (System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) != null) break block6;
                throw e;
            }
        }
        ComponentEntity c = new ComponentEntity();
        if (model.getId() == null) {
            c.setId(KeycloakModelUtils.generateId());
        } else {
            c.setId(model.getId());
        }
        c.setName(model.getName());
        c.setParentId(model.getParentId());
        if (model.getParentId() == null) {
            c.setParentId(this.getId());
            model.setParentId(this.getId());
        }
        c.setProviderType(model.getProviderType());
        c.setProviderId(model.getProviderId());
        c.setSubType(model.getSubType());
        c.setRealm(this.realm);
        this.em.persist((Object)c);
        this.realm.getComponents().add(c);
        this.setConfig(model, c);
        model.setId(c.getId());
        return model;
    }

    protected void setConfig(ComponentModel model, ComponentEntity c) {
        c.getComponentConfigs().clear();
        for (String key : model.getConfig().keySet()) {
            List vals = (List)model.getConfig().get((Object)key);
            if (vals == null) continue;
            for (String val : vals) {
                ComponentConfigEntity config = new ComponentConfigEntity();
                config.setId(KeycloakModelUtils.generateId());
                config.setName(key);
                config.setValue(val);
                config.setComponent(c);
                c.getComponentConfigs().add(config);
            }
        }
    }

    public void updateComponent(ComponentModel component) {
        ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)component).validateConfiguration(this.session, (RealmModel)this, component);
        ComponentEntity c = this.getComponentEntity(component.getId());
        if (c == null) {
            return;
        }
        ComponentModel old = this.entityToModel(c);
        c.setName(component.getName());
        c.setProviderId(component.getProviderId());
        c.setProviderType(component.getProviderType());
        c.setParentId(component.getParentId());
        c.setSubType(component.getSubType());
        this.setConfig(component, c);
        ComponentUtil.notifyUpdated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)old, (ComponentModel)component);
    }

    public void removeComponent(ComponentModel component) {
        ComponentEntity c = this.getComponentEntity(component.getId());
        if (c == null) {
            return;
        }
        this.session.users().preRemove((RealmModel)this, component);
        ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)component);
        this.removeComponents(component.getId());
        this.getEntity().getComponents().remove(c);
    }

    public void removeComponents(String parentId) {
        Predicate<ComponentEntity> sameParent = c -> Objects.equals(parentId, c.getParentId());
        this.getEntity().getComponents().stream().filter(sameParent).map(this::entityToModel).forEach(c -> {
            this.session.users().preRemove((RealmModel)this, c);
            ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)c);
        });
        this.getEntity().getComponents().removeIf(sameParent);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId, String providerType) {
        if (parentId == null) {
            parentId = this.getId();
        }
        String parent = parentId;
        Stream<ComponentEntity> componentStream = this.realm.getComponents().stream().filter(c -> Objects.equals(parent, c.getParentId()));
        if (providerType != null) {
            componentStream = componentStream.filter(c -> Objects.equals(providerType, c.getProviderType()));
        }
        return componentStream.map(this::entityToModel);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId) {
        return this.getComponentsStream(parentId, null);
    }

    protected ComponentModel entityToModel(ComponentEntity c) {
        ComponentModel model = new ComponentModel();
        model.setId(c.getId());
        model.setName(c.getName());
        model.setProviderType(c.getProviderType());
        model.setProviderId(c.getProviderId());
        model.setSubType(c.getSubType());
        model.setParentId(c.getParentId());
        MultivaluedHashMap config = new MultivaluedHashMap();
        for (ComponentConfigEntity configEntity : c.getComponentConfigs()) {
            config.add((Object)configEntity.getName(), (Object)configEntity.getValue());
        }
        model.setConfig(config);
        return model;
    }

    private RequiredCredentialModel toRequiredCredentialModel(RequiredCredentialEntity entity) {
        RequiredCredentialModel model = new RequiredCredentialModel();
        model.setFormLabel(entity.getFormLabel());
        model.setType(entity.getType());
        model.setSecret(entity.isSecret());
        model.setInput(entity.isInput());
        return model;
    }

    public Stream<ComponentModel> getComponentsStream() {
        return this.realm.getComponents().stream().map(this::entityToModel);
    }

    public ComponentModel getComponent(String id) {
        ComponentEntity c = this.getComponentEntity(id);
        return c == null ? null : this.entityToModel(c);
    }

    private ComponentEntity getComponentEntity(String id) {
        ComponentEntity c = (ComponentEntity)this.em.find(ComponentEntity.class, (Object)id);
        if (c == null) {
            return null;
        }
        if (!c.getRealm().equals(this.getEntity())) {
            return null;
        }
        return c;
    }

    public void createOrUpdateRealmLocalizationTexts(String locale, Map<String, String> localizationTexts) {
        Map<String, RealmLocalizationTextsEntity> currentLocalizationTexts = this.realm.getRealmLocalizationTexts();
        if (currentLocalizationTexts.containsKey(locale)) {
            RealmLocalizationTextsEntity localizationTextsEntity = currentLocalizationTexts.get(locale);
            HashMap<String, String> updatedTexts = new HashMap<String, String>(localizationTextsEntity.getTexts());
            updatedTexts.putAll(localizationTexts);
            localizationTextsEntity.setTexts(updatedTexts);
            this.em.persist((Object)localizationTextsEntity);
        } else {
            RealmLocalizationTextsEntity realmLocalizationTextsEntity = new RealmLocalizationTextsEntity();
            realmLocalizationTextsEntity.setRealm(this.realm);
            realmLocalizationTextsEntity.setLocale(locale);
            realmLocalizationTextsEntity.setTexts(localizationTexts);
            this.em.persist((Object)realmLocalizationTextsEntity);
        }
    }

    public boolean removeRealmLocalizationTexts(String locale) {
        if (locale == null) {
            return false;
        }
        if (this.realm.getRealmLocalizationTexts().containsKey(locale)) {
            this.em.remove((Object)this.realm.getRealmLocalizationTexts().get(locale));
            return true;
        }
        return false;
    }

    public Map<String, Map<String, String>> getRealmLocalizationTexts() {
        HashMap<String, Map<String, String>> localizationTexts = new HashMap<String, Map<String, String>>();
        this.realm.getRealmLocalizationTexts().forEach((locale, localizationTextsEntity) -> localizationTexts.put(localizationTextsEntity.getLocale(), localizationTextsEntity.getTexts()));
        return localizationTexts;
    }

    public Map<String, String> getRealmLocalizationTextsByLocale(String locale) {
        if (this.realm.getRealmLocalizationTexts().containsKey(locale)) {
            return this.realm.getRealmLocalizationTexts().get(locale).getTexts();
        }
        return Collections.emptyMap();
    }

    public ClientInitialAccessModel createClientInitialAccessModel(int expiration, int count) {
        RealmEntity realmEntity = (RealmEntity)this.em.find(RealmEntity.class, (Object)this.realm.getId());
        ClientInitialAccessEntity entity = new ClientInitialAccessEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setRealm(realmEntity);
        entity.setCount(count);
        entity.setRemainingCount(count);
        int currentTime = Time.currentTime();
        entity.setTimestamp(currentTime);
        entity.setExpiration(expiration);
        this.em.persist((Object)entity);
        return this.entityToModel(entity);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(String id) {
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)this.em.find(ClientInitialAccessEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (entity == null) {
            return null;
        }
        if (!entity.getRealm().getId().equals(this.realm.getId())) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public void removeClientInitialAccessModel(String id) {
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)this.em.find(ClientInitialAccessEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (entity == null) {
            return;
        }
        if (!entity.getRealm().getId().equals(this.realm.getId())) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public Stream<ClientInitialAccessModel> getClientInitialAccesses() {
        RealmEntity realmEntity = (RealmEntity)this.em.find(RealmEntity.class, (Object)this.realm.getId());
        TypedQuery query = this.em.createNamedQuery("findClientInitialAccessByRealm", ClientInitialAccessEntity.class);
        query.setParameter("realm", (Object)realmEntity);
        return StreamsUtil.closing(query.getResultStream().map(this::entityToModel));
    }

    public void decreaseRemainingCount(ClientInitialAccessModel clientInitialAccess) {
        this.em.createNamedQuery("decreaseClientInitialAccessRemainingCount").setParameter("id", (Object)clientInitialAccess.getId()).executeUpdate();
    }

    private ClientInitialAccessModel entityToModel(ClientInitialAccessEntity entity) {
        ClientInitialAccessModel model = new ClientInitialAccessModel();
        model.setId(entity.getId());
        model.setCount(entity.getCount());
        model.setRemainingCount(entity.getRemainingCount());
        model.setExpiration(entity.getExpiration());
        model.setTimestamp(entity.getTimestamp());
        return model;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

