/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.oidc.OIDCClientSecretConfigWrapper;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientUnregisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdatedContext;
import org.keycloak.services.clientpolicy.context.AdminClientViewContext;
import org.keycloak.services.clientpolicy.context.ClientSecretRotationContext;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.ClientAttributeCertificateResource;
import org.keycloak.services.resources.admin.ClientScopeEvaluateResource;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.validation.ValidationUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientResource {
    protected static final Logger logger = Logger.getLogger(ClientResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected ClientModel client;
    protected final KeycloakSession session;
    protected final ClientConnection clientConnection;

    public ClientResource(RealmModel realm, AdminPermissionEvaluator auth, ClientModel clientModel, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = clientModel;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT);
        this.clientConnection = session.getContext().getConnection();
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.client);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.client);
        return new ProtocolMappersResource(this.session, (ProtocolMapperContainerModel)this.client, this.auth, this.adminEvent, manageCheck, viewCheck);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Update the client")
    public Response update(ClientRepresentation rep) {
        this.auth.clients().requireConfigure(this.client);
        try {
            this.session.setAttribute("client.secret.rotation.enabled", (Object)Boolean.FALSE);
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientUpdateContext(rep, this.client, this.auth.adminAuth()));
            this.updateClientFromRep(rep, this.client, this.session);
            ValidationUtil.validateClient((KeycloakSession)this.session, (ClientModel)this.client, (boolean)false, r -> {
                this.session.getTransactionManager().setRollbackOnly();
                throw new ErrorResponseException("invalid_input", r.getAllLocalizedErrorsAsString(AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale())), Response.Status.BAD_REQUEST);
            });
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientUpdatedContext(rep, this.client, this.auth.adminAuth()));
            if (!((Boolean)this.session.getAttribute("client.secret.rotation.enabled")).booleanValue()) {
                logger.debugv("Removing the previous rotation info for client {0}{1}, if there is", (Object)this.client.getClientId(), (Object)this.client.getName());
                OIDCClientSecretConfigWrapper.fromClientModel(this.client).removeClientSecretRotationInfo();
            }
            this.session.removeAttribute("client.secret.rotation.enabled");
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Client already exists");
        }
        catch (ClientTypeException cte) {
            throw ErrorResponse.error(cte.getMessage(), cte.getParameters(), Response.Status.BAD_REQUEST);
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get representation of the client")
    public ClientRepresentation getClient() {
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientViewContext(this.client, this.auth.adminAuth()));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.auth.clients().requireView(this.client);
        ClientRepresentation representation = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.session);
        representation.setAccess(this.auth.clients().getAccess(this.client));
        return representation;
    }

    @Path(value="certificates/{attr}")
    public ClientAttributeCertificateResource getCertficateResource(@PathParam(value="attr") String attributePrefix) {
        return new ClientAttributeCertificateResource(this.auth, this.client, this.session, attributePrefix, this.adminEvent);
    }

    @GET
    @NoCache
    @Path(value="installation/providers/{providerId}")
    @Tag(name="Clients")
    @Operation
    public Response getInstallationProvider(@PathParam(value="providerId") String providerId) {
        this.auth.clients().requireView(this.client);
        ClientInstallationProvider provider = (ClientInstallationProvider)this.session.getProvider(ClientInstallationProvider.class, providerId);
        if (provider == null) {
            throw new NotFoundException("Unknown Provider");
        }
        return provider.generateInstallation(this.session, this.realm, this.client, this.session.getContext().getUri().getBaseUri());
    }

    @DELETE
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Delete the client")
    public void deleteClient() {
        this.auth.clients().requireManage(this.client);
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientUnregisterContext(this.client, this.auth.adminAuth()));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        if (!new ClientManager(new RealmManager(this.session)).removeClient(this.realm, this.client)) {
            throw new ErrorResponseException("invalid_request", "Could not delete client", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Generate a new secret for the client")
    public CredentialRepresentation regenerateSecret() {
        try {
            this.auth.clients().requireConfigure(this.client);
            logger.debug((Object)"regenerateSecret");
            this.session.setAttribute("client.secret.rotation.enabled", (Object)Boolean.FALSE);
            ClientRepresentation representation = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.session);
            ClientSecretRotationContext secretRotationContext = new ClientSecretRotationContext(representation, this.client, this.client.getSecret());
            String secret = KeycloakModelUtils.generateSecret((ClientModel)this.client);
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)secretRotationContext);
            CredentialRepresentation rep = new CredentialRepresentation();
            rep.setType("secret");
            rep.setValue(secret);
            if (!((Boolean)this.session.getAttribute("client.secret.rotation.enabled")).booleanValue()) {
                logger.debugv("Removing the previous rotation info for client {0}{1}, if there is", (Object)this.client.getClientId(), (Object)this.client.getName());
                OIDCClientSecretConfigWrapper.fromClientModel(this.client).removeClientSecretRotationInfo();
            }
            this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            this.session.removeAttribute("client.secret.rotation.enabled");
            rep.setValue(secret);
            return rep;
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="registration-access-token")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Generate a new registration access token for the client")
    public ClientRepresentation regenerateRegistrationAccessToken() {
        this.auth.clients().requireManage(this.client);
        String token = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, this.realm, this.client, RegistrationAuth.AUTHENTICATED);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.session);
        rep.setRegistrationAccessToken(token);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get the client secret")
    public CredentialRepresentation getClientSecret() {
        this.auth.clients().requireView(this.client);
        logger.debug((Object)"getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.client.getSecret());
        if (model == null) {
            throw new NotFoundException("Client does not have a secret");
        }
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.client);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.client);
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.client, this.session, this.adminEvent, manageCheck, viewCheck);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, (RoleContainerModel)this.client, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-client-scopes")
    @Tag(name="Clients")
    @Operation(summary="Get default client scopes.  Only name and ids are returned.")
    public Stream<ClientScopeRepresentation> getDefaultClientScopes() {
        return this.getDefaultClientScopes(true);
    }

    private Stream<ClientScopeRepresentation> getDefaultClientScopes(boolean defaultScope) {
        this.auth.clients().requireView(this.client);
        return this.client.getClientScopes(defaultScope).values().stream().map(ClientResource::toRepresentation);
    }

    @PUT
    @NoCache
    @Path(value="default-client-scopes/{clientScopeId}")
    @Tag(name="Clients")
    @Operation
    public void addDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, true);
    }

    private void addDefaultClientScope(String clientScopeId, boolean defaultScope) {
        this.auth.clients().requireManage(this.client);
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        if (defaultScope && clientScope.isDynamicScope()) {
            throw new ErrorResponseException("invalid_request", "Can't assign a Dynamic Scope to a Client as a Default Scope", Response.Status.BAD_REQUEST);
        }
        this.client.addClientScope(clientScope, defaultScope);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLIENT_SCOPE_CLIENT_MAPPING).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-client-scopes/{clientScopeId}")
    @Tag(name="Clients")
    @Operation
    public void removeDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.auth.clients().requireManage(this.client);
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.client.removeClientScope(clientScope);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLIENT_SCOPE_CLIENT_MAPPING).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="optional-client-scopes")
    @Tag(name="Clients")
    @Operation(summary="Get optional client scopes.  Only name and ids are returned.")
    public Stream<ClientScopeRepresentation> getOptionalClientScopes() {
        return this.getDefaultClientScopes(false);
    }

    @PUT
    @NoCache
    @Path(value="optional-client-scopes/{clientScopeId}")
    @Tag(name="Clients")
    @Operation
    public void addOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, false);
    }

    @DELETE
    @NoCache
    @Path(value="optional-client-scopes/{clientScopeId}")
    @Tag(name="Clients")
    @Operation
    public void removeOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.removeDefaultClientScope(clientScopeId);
    }

    @Path(value="evaluate-scopes")
    public ClientScopeEvaluateResource clientScopeEvaluateResource() {
        return new ClientScopeEvaluateResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, this.client, this.clientConnection);
    }

    @Path(value="service-account-user")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get a user dedicated to the service account")
    public UserRepresentation getServiceAccountUser() {
        this.auth.clients().requireView(this.client);
        UserModel user = this.session.users().getServiceAccount(this.client);
        if (user == null) {
            if (this.client.isServiceAccountsEnabled()) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
                user = this.session.users().getServiceAccount(this.client);
            } else {
                throw new BadRequestException("Service account not enabled for the client '" + this.client.getClientId() + "'");
            }
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
    }

    @Path(value="push-revocation")
    @POST
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Push the client's revocation policy to its admin URL If the client has an admin URL, push revocation policy to it.")
    public GlobalRequestResult pushRevocation() {
        this.auth.clients().requireConfigure(this.client);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).resource(ResourceType.CLIENT).success();
        return new ResourceAdminManager(this.session).pushClientRevocationPolicy(this.realm, this.client);
    }

    @Path(value="session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get application session count Returns a number of user sessions associated with this client { \"count\": number }")
    public Map<String, Long> getApplicationSessionCount() {
        this.auth.clients().requireView(this.client);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getActiveUserSessions(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="user-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get user sessions for client Returns a list of user sessions associated with this client\n")
    public Stream<UserSessionRepresentation> getUserSessions(@Parameter(description="Paging offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults) {
        this.auth.clients().requireView(this.client);
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        return this.session.sessions().getUserSessionsStream(this.client.getRealm(), this.client, firstResult, maxResults).map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="offline-session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get application offline session count Returns a number of offline user sessions associated with this client { \"count\": number }")
    public Map<String, Long> getOfflineSessionCount() {
        this.auth.clients().requireView(this.client);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getOfflineSessionsCount(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="offline-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get offline sessions for client Returns a list of offline user sessions associated with this client")
    public Stream<UserSessionRepresentation> getOfflineUserSessions(@Parameter(description="Paging offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults) {
        this.auth.clients().requireView(this.client);
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        return this.session.sessions().getOfflineUserSessionsStream(this.client.getRealm(), this.client, firstResult, maxResults).map(this::toUserSessionRepresentation);
    }

    @Path(value="nodes")
    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Register a cluster node with the client Manually register cluster node to this client - usually it\u2019s not needed to call this directly as adapter should handle by sending registration request to Keycloak")
    @APIResponse(responseCode="204", description="No Content")
    public void registerNode(Map<String, String> formParams) {
        this.auth.clients().requireConfigure(this.client);
        String node = formParams.get("node");
        if (node == null) {
            throw new BadRequestException("Node not found in params");
        }
        ReservedCharValidator.validate((String)node);
        logger.debugf("Register node: %s", (Object)node);
        this.client.registerNode(node, Time.currentTime());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri(), node).success();
    }

    @Path(value="nodes/{node}")
    @DELETE
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Unregister a cluster node from the client")
    public void unregisterNode(@PathParam(value="node") String node) {
        this.auth.clients().requireConfigure(this.client);
        logger.debugf("Unregister node: %s", (Object)node);
        Integer time = (Integer)this.client.getRegisteredNodes().get(node);
        if (time == null) {
            throw new NotFoundException("Client does not have node ");
        }
        this.client.unregisterNode(node);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="test-nodes-available")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Test if registered cluster nodes are available Tests availability by sending 'ping' request to all cluster nodes.")
    public GlobalRequestResult testNodesAvailable() {
        this.auth.clients().requireConfigure(this.client);
        logger.debug((Object)"Test availability of cluster nodes");
        GlobalRequestResult result = new ResourceAdminManager(this.session).testNodesAvailability(this.realm, this.client);
        this.adminEvent.operation(OperationType.ACTION).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="/authz")
    public AuthorizationService authorization() {
        ProfileHelper.requireFeature(Profile.Feature.AUTHORIZATION);
        return new AuthorizationService(this.session, this.client, this.auth, this.adminEvent);
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference getManagementPermissions() {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.roles().requireView((RoleContainerModel)this.client);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.clients().isPermissionsEnabled(this.client)) {
            return new ManagementPermissionReference();
        }
        return this.toMgmtRef(this.client, permissions);
    }

    private ManagementPermissionReference toMgmtRef(ClientModel client, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.clients().resource(client).getId());
        ref.setScopePermissions(permissions.clients().getPermissions(client));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.clients().requireManage(this.client);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.clients().setPermissionsEnabled(this.client, ref.isEnabled());
        if (ref.isEnabled()) {
            return this.toMgmtRef(this.client, permissions);
        }
        return new ManagementPermissionReference();
    }

    @Path(value="client-secret/rotated")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Invalidate the rotated secret for the client")
    public Response invalidateRotatedSecret() {
        try {
            this.auth.clients().requireConfigure(this.client);
            logger.debug((Object)"delete rotated secret");
            OIDCClientSecretConfigWrapper wrapper = OIDCClientSecretConfigWrapper.fromClientModel(this.client);
            CredentialRepresentation rep = new CredentialRepresentation();
            rep.setType("secret");
            rep.setValue(wrapper.getClientRotatedSecret());
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            wrapper.removeClientSecretRotated();
            return Response.noContent().build();
        }
        catch (RuntimeException rte) {
            throw new ErrorResponseException(rte.getCause().getMessage(), rte.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="client-secret/rotated")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Get the rotated client secret")
    public CredentialRepresentation getClientRotatedSecret() {
        this.auth.clients().requireView(this.client);
        logger.debug((Object)"getClientRotatedSecret");
        OIDCClientSecretConfigWrapper wrapper = OIDCClientSecretConfigWrapper.fromClientModel(this.client);
        if (!wrapper.hasRotatedSecret()) {
            throw new NotFoundException("Client does not have a rotated secret");
        }
        UserCredentialModel model = UserCredentialModel.secret((String)wrapper.getClientRotatedSecret());
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    private void updateClientFromRep(ClientRepresentation rep, ClientModel client, KeycloakSession session) throws ModelDuplicateException {
        UserModel serviceAccount = this.session.users().getServiceAccount(client);
        boolean serviceAccountScopeAssigned = client.getClientScopes(true).containsKey("service_account");
        if (Boolean.TRUE.equals(rep.isServiceAccountsEnabled())) {
            if (serviceAccount == null || !serviceAccountScopeAssigned) {
                new ClientManager(new RealmManager(session)).enableServiceAccount(client);
            }
        } else if (!(!Boolean.FALSE.equals(rep.isServiceAccountsEnabled()) && client.isServiceAccountsEnabled() || serviceAccount == null && !serviceAccountScopeAssigned)) {
            new ClientManager(new RealmManager(session)).disableServiceAccount(client);
        }
        if (rep.getClientId() != null && !rep.getClientId().equals(client.getClientId())) {
            new ClientManager(new RealmManager(session)).clientIdChanged(client, rep);
        }
        if (rep.isFullScopeAllowed() != null && rep.isFullScopeAllowed().booleanValue() != client.isFullScopeAllowed()) {
            this.auth.clients().requireManage(client);
        }
        if (rep.isBearerOnly() != null && rep.isBearerOnly().booleanValue() || rep.isPublicClient() != null && rep.isPublicClient().booleanValue()) {
            rep.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client, (KeycloakSession)session);
        RepresentationToModel.updateClientProtocolMappers((ClientRepresentation)rep, (ClientModel)client);
        this.updateAuthorizationSettings(rep);
    }

    private void updateAuthorizationSettings(ClientRepresentation rep) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
            if (Boolean.TRUE.equals(rep.getAuthorizationServicesEnabled())) {
                this.authorization().enable(false);
            } else {
                this.authorization().disable();
            }
        }
    }

    private UserSessionRepresentation toUserSessionRepresentation(UserSessionModel userSession) {
        UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
        Map.Entry result = userSession.getAuthenticatedClientSessions().entrySet().stream().filter(entry -> Objects.equals(this.client.getId(), entry.getKey())).findFirst().orElse(null);
        if (result != null) {
            rep.setLastAccess(Time.toMillis((long)((AuthenticatedClientSessionModel)result.getValue()).getTimestamp()));
        }
        return rep;
    }

    private static ClientScopeRepresentation toRepresentation(ClientScopeModel clientScopeModel) {
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setId(clientScopeModel.getId());
        rep.setName(clientScopeModel.getName());
        return rep;
    }
}

