/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.DeploymentStateProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.ClientScopeAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.JpaRealmProvider;
import org.keycloak.models.jpa.MigrationModelAdapter;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientScopeClientMappingEntity;
import org.keycloak.models.jpa.entities.ClientScopeEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmLocalizationTextsEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StreamsUtil;

public class JpaRealmProvider
implements RealmProvider,
ClientProvider,
ClientScopeProvider,
GroupProvider,
RoleProvider,
DeploymentStateProvider {
    protected static final Logger logger = Logger.getLogger(JpaRealmProvider.class);
    private final KeycloakSession session;
    protected EntityManager em;
    private Set<String> clientSearchableAttributes;
    private Set<String> groupSearchableAttributes;

    public JpaRealmProvider(KeycloakSession session, EntityManager em, Set<String> clientSearchableAttributes, Set<String> groupSearchableAttributes) {
        this.session = session;
        this.em = em;
        this.clientSearchableAttributes = clientSearchableAttributes;
        this.groupSearchableAttributes = groupSearchableAttributes;
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        return adapter;
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        return adapter;
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> providerType) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdsWithProviderType", String.class);
        query.setParameter("providerType", (Object)providerType.getName());
        return this.getRealms((TypedQuery<String>)query);
    }

    public Stream<RealmModel> getRealmsStream() {
        TypedQuery query = this.em.createNamedQuery("getAllRealmIds", String.class);
        return this.getRealms((TypedQuery<String>)query);
    }

    public Stream<RealmModel> getRealmsStream(String search) {
        if (search.trim().isEmpty()) {
            return this.getRealmsStream();
        }
        TypedQuery query = this.em.createNamedQuery("getRealmIdsWithNameContaining", String.class);
        query.setParameter("search", (Object)search);
        return this.getRealms((TypedQuery<String>)query);
    }

    private Stream<RealmModel> getRealms(TypedQuery<String> query) {
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmProvider)this.session.realms()).getRealm(arg_0)).filter(Objects::nonNull));
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdByName", String.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        String id = (String)query.getResultList().get(0);
        return this.session.realms().getRealm(id);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        realm.getDefaultGroupIds().clear();
        this.em.flush();
        this.session.clients().removeClients((RealmModel)adapter);
        this.em.createNamedQuery("deleteDefaultClientScopeRealmMappingByRealm").setParameter("realm", (Object)realm).executeUpdate();
        this.session.clientScopes().removeClientScopes((RealmModel)adapter);
        this.session.roles().removeRoles((RealmModel)adapter);
        this.em.createNamedQuery("deleteOrganizationDomainsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteOrganizationsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.session.groups().preRemove((RealmModel)adapter);
        this.session.identityProviders().removeAll();
        this.session.identityProviders().removeAllMappers();
        this.em.createNamedQuery("removeClientInitialAccessByRealm").setParameter("realm", (Object)realm).executeUpdate();
        this.em.remove((Object)realm);
        this.em.flush();
        this.em.clear();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void close() {
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException();
        }
        RoleEntity entity = new RoleEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)realm.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.roles().getRoleById(realm, (String)roles.get(0));
    }

    public RoleModel addClientRole(ClientModel client, String name) {
        return this.addClientRole(client, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException();
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(client.getRealm().getId());
        roleEntity.setClientId(client.getId());
        roleEntity.setClientRole(true);
        this.em.persist((Object)roleEntity);
        RoleAdapter adapter = new RoleAdapter(this.session, client.getRealm(), this.em, roleEntity);
        return adapter;
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIds", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream roles = query.getResultStream();
        return StreamsUtil.closing(roles.map(arg_0 -> ((RealmModel)realm).getRoleById(arg_0)).filter(Objects::nonNull));
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        TypedQuery query = this.em.createNamedQuery("getClientRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("client", (Object)client.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.roles().getRoleById(client.getRealm(), (String)roles.get(0));
    }

    public Map<ClientModel, Set<String>> getAllRedirectUrisOfEnabledClients(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAllRedirectUrisOfEnabledClients", Map.class);
        query.setParameter("realm", (Object)realm.getId());
        return StreamsUtil.closing(query.getResultStream().filter(s -> s.get("client") != null)).collect(Collectors.groupingBy(s -> this.toClientModel(realm, (ClientEntity)s.get("client")), Collectors.mapping(s -> (String)s.get("redirectUri"), Collectors.toSet())));
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.getRolesStream((TypedQuery<RoleEntity>)query, realm, first, max);
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        if (ids == null) {
            return Stream.empty();
        }
        TypedQuery query = search == null ? this.em.createNamedQuery("getRoleIdsFromIdList", String.class) : this.em.createNamedQuery("getRoleIdsByNameContainingFromIdList", String.class).setParameter("search", (Object)search);
        query.setParameter("realm", (Object)realm.getId()).setParameter("ids", ids.collect(Collectors.toList()));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)query, (Integer)first, (Integer)max).getResultStream()).map(g -> this.session.roles().getRoleById(realm, g)).filter(Objects::nonNull);
    }

    public Stream<RoleModel> searchForClientRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.searchForClientRolesStream(realm, ids, search, first, max, false);
    }

    public Stream<RoleModel> searchForClientRolesStream(RealmModel realm, String search, Stream<String> excludedIds, Integer first, Integer max) {
        return this.searchForClientRolesStream(realm, excludedIds, search, first, max, true);
    }

    private Stream<RoleModel> searchForClientRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max, boolean negateIds) {
        List idList = null;
        if (ids != null && (idList = ids.collect(Collectors.toList())).isEmpty() && !negateIds) {
            return Stream.empty();
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(RoleEntity.class);
        Root roleRoot = query.from(RoleEntity.class);
        Root clientRoot = query.from(ClientEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)roleRoot.get("realmId"), (Object)realm.getId()));
        predicates.add(cb.isTrue((Expression)roleRoot.get("clientRole")));
        predicates.add(cb.equal((Expression)roleRoot.get("clientId"), (Expression)clientRoot.get("id")));
        if (search != null && !((String)search).isEmpty()) {
            search = "%" + ((String)search).trim().toLowerCase() + "%";
            predicates.add(cb.or((Expression)cb.like(cb.lower((Expression)roleRoot.get("name")), (String)search), (Expression)cb.like(cb.lower((Expression)clientRoot.get("clientId")), (String)search)));
        }
        if (idList != null && !idList.isEmpty()) {
            Predicate idFilter = roleRoot.get("id").in(idList);
            if (negateIds) {
                idFilter = cb.not((Expression)idFilter);
            }
            predicates.add(idFilter);
        }
        query.select((Selection)roleRoot).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{cb.asc((Expression)clientRoot.get("clientId")), cb.asc((Expression)roleRoot.get("name"))});
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(query), (Integer)first, (Integer)max).getResultStream()).map(roleEntity -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)roleEntity));
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.getRolesStream((TypedQuery<RoleEntity>)query, client.getRealm(), first, max);
    }

    protected Stream<RoleModel> getRolesStream(TypedQuery<RoleEntity> query, RealmModel realm, Integer first, Integer max) {
        Stream results = PaginationUtils.paginateQuery(query, (Integer)first, (Integer)max).getResultStream();
        return StreamsUtil.closing(results.map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, client.getRealm(), search, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, realm, search, first, max);
    }

    protected Stream<RoleModel> searchForRoles(TypedQuery<RoleEntity> query, RealmModel realm, String search, Integer first, Integer max) {
        query.setParameter("search", (Object)("%" + search.trim().toLowerCase() + "%"));
        Stream results = PaginationUtils.paginateQuery(query, (Integer)first, (Integer)max).getResultStream();
        return StreamsUtil.closing(results.map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)));
    }

    public boolean removeRole(RoleModel role) {
        RealmModel realm;
        if (role.getContainer() instanceof RealmModel) {
            realm = (RealmModel)role.getContainer();
        } else if (role.getContainer() instanceof ClientModel) {
            realm = ((ClientModel)role.getContainer()).getRealm();
        } else {
            throw new IllegalStateException("RoleModel's container isn not instance of either RealmModel or ClientModel");
        }
        this.session.users().preRemove(realm, role);
        RoleEntity roleEntity = (RoleEntity)this.em.getReference(RoleEntity.class, (Object)role.getId());
        if (roleEntity == null || !roleEntity.getRealmId().equals(realm.getId())) {
            throw new ModelException("Role not found or trying to remove role from incorrect realm");
        }
        roleEntity.getCompositeRoles().forEach(childRole -> childRole.getParentRoles().remove(roleEntity));
        roleEntity.getParentRoles().forEach(parentRole -> parentRole.getCompositeRoles().remove(roleEntity));
        this.em.createNamedQuery("deleteClientScopeRoleMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.remove((Object)roleEntity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)this.roleRemovedEvent(role));
        return true;
    }

    public RoleContainerModel.RoleRemovedEvent roleRemovedEvent(RoleModel role) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void removeRoles(RealmModel realm) {
        realm.getRolesStream().forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        client.getRolesStream().forEach(this::removeRole);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)id);
        if (groupEntity == null) {
            return null;
        }
        if (!groupEntity.getRealm().equals(realm.getId())) {
            return null;
        }
        GroupAdapter adapter = new GroupAdapter(this.session, realm, this.em, groupEntity);
        return adapter;
    }

    public GroupModel getGroupByName(RealmModel realm, GroupModel parent, String name) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(builder.equal((Expression)root.get("parentId"), (Object)(parent != null ? parent.getId() : GroupEntity.TOP_PARENT_ID)));
        predicates.add(builder.equal((Expression)root.get("name"), (Object)name));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, null, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        List groups = this.em.createQuery(queryBuilder).getResultList();
        if (groups.isEmpty()) {
            return null;
        }
        if (groups.size() > 1) {
            throw new IllegalStateException("Should not be more than one Group with same name");
        }
        return this.session.groups().getGroupById(realm, (String)groups.get(0));
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        GroupModel previousParent = group.getParent();
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        } else {
            this.session.groups().addTopLevelGroup(realm, group);
        }
        this.em.flush();
        String newPath = KeycloakModelUtils.buildGroupPath((GroupModel)group);
        String previousPath = KeycloakModelUtils.buildGroupPath((GroupModel)group, (GroupModel)previousParent);
        GroupModel.GroupPathChangeEvent.fire((GroupModel)group, (String)newPath, (String)previousPath, (KeycloakSession)this.session);
        this.fireGroupUpdatedEvent(group);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, null, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing((Stream)this.em.createQuery(queryBuilder).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g)).filter(Objects::nonNull);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        if (search == null || search.isEmpty()) {
            return this.getGroupsStream(realm, ids, first, max);
        }
        List idsList = ids.collect(Collectors.toList());
        if (idsList.isEmpty()) {
            return Stream.empty();
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(builder.like(builder.lower((Expression)root.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        predicates.add(root.get("id").in(idsList));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)first, (Integer)max).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g)).filter(Objects::nonNull);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, Integer first, Integer max) {
        if (first == null && max == null) {
            return this.getGroupsStream(realm, ids);
        }
        List<String> idsList = ids.toList();
        if (idsList.isEmpty()) {
            return Stream.empty();
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(root.get("id").in(idsList));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing((Stream)this.em.createQuery(queryBuilder).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g)).filter(Objects::nonNull);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids) {
        return ids.map(id -> this.session.groups().getGroupById(realm, id)).filter(Objects::nonNull).sorted(GroupModel.COMPARE_BY_NAME);
    }

    public Long getGroupsCount(RealmModel realm, Stream<String> ids, String search) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)builder.count((Expression)root.get("id")));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        if (search != null && !search.isEmpty()) {
            predicates.add(builder.like(builder.lower((Expression)root.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        }
        predicates.add(root.get("id").in(ids.toList()));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return (Long)this.em.createQuery(queryBuilder).getSingleResult();
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)builder.count((Expression)root.get("id")));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            predicates.add(builder.equal((Expression)root.get("parentId"), (Object)GroupEntity.TOP_PARENT_ID));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        return (Long)this.em.createQuery(queryBuilder).getSingleResult();
    }

    public long getClientsCount(RealmModel realm) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)builder.count((Expression)root.get("id")));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.CLIENTS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        return (Long)this.em.createQuery(queryBuilder).getSingleResult();
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByNameStream(realm, search, false, null, null).count();
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupsInRole", GroupEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        Stream results = PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultStream();
        return StreamsUtil.closing(results.map(g -> new GroupAdapter(this.session, realm, this.em, (GroupEntity)g)).sorted(GroupModel.COMPARE_BY_NAME));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, String search, Boolean exact, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(builder.equal((Expression)root.get("parentId"), (Object)GroupEntity.TOP_PARENT_ID));
        if (Boolean.TRUE.equals(exact)) {
            predicates.add(builder.like((Expression)root.get("name"), search));
        } else {
            predicates.add(builder.like(builder.lower((Expression)root.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)firstResult, (Integer)maxResults).getResultStream().map(arg_0 -> ((RealmModel)realm).getGroupById(arg_0)).filter(Objects::nonNull).sorted(GroupModel.COMPARE_BY_NAME));
    }

    public boolean removeGroup(RealmModel realm, GroupModel group) {
        if (group == null) {
            return false;
        }
        4 event = new /* Unavailable Anonymous Inner Class!! */;
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        group.getSubGroupsStream().forEach(arg_0 -> ((RealmModel)realm).removeGroup(arg_0));
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)group.getId(), LockModeType.PESSIMISTIC_WRITE);
        if (groupEntity == null || !groupEntity.getRealm().equals(realm.getId())) {
            return false;
        }
        this.em.createNamedQuery("deleteGroupRoleMappingsByGroup").setParameter("group", (Object)groupEntity).executeUpdate();
        this.em.remove((Object)groupEntity);
        return true;
    }

    public GroupModel createGroup(RealmModel realm, String id, GroupModel.Type type, String name, GroupModel toParent) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        } else if (GroupEntity.TOP_PARENT_ID.equals(id)) {
            throw new ModelException("The ID of the new group is equals to the tag used for top level groups");
        }
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setId(id);
        groupEntity.setName(name);
        groupEntity.setRealm(realm.getId());
        groupEntity.setParentId(toParent == null ? GroupEntity.TOP_PARENT_ID : toParent.getId());
        groupEntity.setType(type == null ? GroupModel.Type.REALM.intValue() : type.intValue());
        this.em.persist((Object)groupEntity);
        this.em.flush();
        GroupAdapter group = new GroupAdapter(this.session, realm, this.em, groupEntity);
        this.fireGroupCreatedEvent(group);
        return group;
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        subGroup.setParent(null);
        this.fireGroupUpdatedEvent(subGroup);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteGroupRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        String clientScopeMapping = JpaUtils.getTableNameForNativeQuery((String)"SCOPE_MAPPING", (EntityManager)this.em);
        this.em.createNativeQuery("delete from " + clientScopeMapping + " where ROLE_ID = :role").setParameter("role", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm) {
        this.em.createNamedQuery("deleteGroupRoleMappingsByRealm").setParameter("realm", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteGroupAttributesByRealm").setParameter("realm", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteGroupsByRealm").setParameter("realm", (Object)realm.getId()).executeUpdate();
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.addClient(realm, KeycloakModelUtils.generateId(), clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        } else if (id.length() > 36) {
            throw new ModelValidationException("Client ID must not exceed 36 characters");
        }
        if (clientId == null) {
            clientId = id;
        }
        logger.tracef("addClient(%s, %s, %s)%s", new Object[]{realm, id, clientId, StackUtil.getShortStackTrace()});
        ClientEntity entity = new ClientEntity();
        entity.setId(id);
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        ClientModel resource = this.toClientModel(realm, entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientCreationEvent)() -> resource));
        return resource;
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        return this.getClientsStream(realm, null, null);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return StreamsUtil.closing(this.getClientIdsStream(realm, firstResult, maxResults).map(id -> new ClientModelLazyDelegate.WithId(this.session, realm, id)));
    }

    private Stream<String> getClientIdsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.CLIENTS, realm, builder, queryBuilder, (Path)root));
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("clientId"))});
        return PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)firstResult, (Integer)maxResults).getResultStream();
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAlwaysDisplayInConsoleClients", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream clientStream = query.getResultStream();
        return StreamsUtil.closing(clientStream.map(c -> this.session.clients().getClientById(realm, c)).filter(Objects::nonNull));
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        logger.tracef("getClientById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        ClientEntity client = (ClientEntity)this.em.find(ClientEntity.class, (Object)id);
        if (client == null || !realm.getId().equals(client.getRealmId())) {
            return null;
        }
        return this.toClientModel(realm, client);
    }

    private ClientModel toClientModel(RealmModel realm, ClientEntity client) {
        ClientAdapter adapter = new ClientAdapter(realm, this.em, this.session, client);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_TYPES)) {
            ClientTypeManager mgr = (ClientTypeManager)this.session.getProvider(ClientTypeManager.class);
            return mgr.augmentClient((ClientModel)adapter);
        }
        return adapter;
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        logger.tracef("getClientByClientId(%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        TypedQuery query = this.em.createNamedQuery("findClientIdByClientId", String.class);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        String id = (String)results.get(0);
        return this.session.clients().getClientById(realm, id);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        predicates.add(builder.like(builder.lower((Expression)root.get("clientId")), builder.lower(builder.literal((Object)("%" + clientId + "%")))));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.CLIENTS, realm, builder, queryBuilder, (Path)root));
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("clientId"))});
        Stream results = PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)firstResult, (Integer)maxResults).getResultStream();
        return StreamsUtil.closing(results.map(id -> new ClientModelLazyDelegate.WithId(this.session, realm, id)));
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Map<String, String> filteredAttributes = this.clientSearchableAttributes == null ? attributes : attributes.entrySet().stream().filter(m -> this.clientSearchableAttributes.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        String dbProductName = (String)((Session)this.em.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
        for (Map.Entry<String, String> entry : filteredAttributes.entrySet()) {
            Predicate attrValuePredicate;
            String key = entry.getKey();
            String value = entry.getValue();
            Join attributeJoin = root.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)attributeJoin.get("name"), (Object)key);
            if (dbProductName.equals("Oracle")) {
                attrValuePredicate = builder.equal(builder.function("DBMS_LOB.COMPARE", Integer.class, new Expression[]{attributeJoin.get("value"), builder.literal((Object)value)}), (Object)0);
                predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
                continue;
            }
            if (dbProductName.equals("PostgreSQL")) {
                Predicate attrValuePredicate1 = builder.equal(builder.function("substr", Integer.class, new Expression[]{attributeJoin.get("value"), builder.literal((Object)1), builder.literal((Object)255)}), builder.function("substr", Integer.class, new Expression[]{builder.literal((Object)value), builder.literal((Object)1), builder.literal((Object)255)}));
                Predicate attrValuePredicate2 = builder.equal((Expression)attributeJoin.get("value"), (Object)value);
                predicates.add(builder.and(new Predicate[]{attrNamePredicate, attrValuePredicate1, attrValuePredicate2}));
                continue;
            }
            attrValuePredicate = builder.equal((Expression)attributeJoin.get("value"), (Object)value);
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.CLIENTS, realm, builder, queryBuilder, (Path)root));
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("clientId"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultStream()).map(id -> this.session.clients().getClientById(realm, id)).filter(Objects::nonNull);
    }

    public Stream<ClientModel> searchClientsByAuthenticationFlowBindingOverrides(RealmModel realm, Map<String, String> overrides, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        String dbProductName = (String)((Session)this.em.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            String bindingName = entry.getKey();
            String authenticationFlowId = entry.getValue();
            MapJoin authFlowBindings = root.joinMap("authFlowBindings", JoinType.LEFT);
            Predicate attrNamePredicate = builder.equal((Expression)authFlowBindings.key(), (Object)bindingName);
            Predicate attrValuePredicate = dbProductName.equals("Oracle") ? builder.equal(builder.function("DBMS_LOB.COMPARE", Integer.class, new Expression[]{authFlowBindings.value(), builder.literal((Object)authenticationFlowId)}), (Object)0) : builder.equal((Expression)authFlowBindings.value(), (Object)authenticationFlowId);
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("clientId"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultStream()).map(id -> this.session.clients().getClientById(realm, id)).filter(Objects::nonNull);
    }

    public void removeClients(RealmModel realm) {
        StreamsUtil.closing(this.getClientIdsStream(realm, -1, -1)).forEach(id -> this.removeClient(realm, (String)id));
    }

    public boolean removeClient(RealmModel realm, String id) {
        logger.tracef("removeClient(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        ClientModel client = this.getClientById(realm, id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        this.session.roles().removeRoles(client);
        ClientEntity clientEntity = (ClientEntity)this.em.find(ClientEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        int countRemoved = this.em.createNamedQuery("deleteClientScopeClientMappingByClient").setParameter("clientId", (Object)clientEntity.getId()).executeUpdate();
        this.em.remove((Object)clientEntity);
        try {
            this.em.flush();
        }
        catch (RuntimeException e) {
            logger.errorv("Unable to delete client entity: {0} from realm {1}", (Object)client.getClientId(), (Object)realm.getName());
            throw e;
        }
        return true;
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        ClientScopeEntity clientScope = (ClientScopeEntity)this.em.find(ClientScopeEntity.class, (Object)id);
        if (clientScope == null || !realm.getId().equals(clientScope.getRealmId())) {
            return null;
        }
        ClientScopeAdapter adapter = new ClientScopeAdapter(realm, this.em, this.session, clientScope);
        return adapter;
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getClientScopeIds", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream scopes = query.getResultStream();
        return StreamsUtil.closing(scopes.map(arg_0 -> ((RealmModel)realm).getClientScopeById(arg_0)).filter(Objects::nonNull));
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        ClientScopeEntity entity = new ClientScopeEntity();
        entity.setId(id);
        name = KeycloakModelUtils.convertClientScopeName((String)name);
        entity.setName(name);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        ClientScopeAdapter clientScope = new ClientScopeAdapter(realm, this.em, this.session, entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        this.em.flush();
        return clientScope;
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        ClientScopeModel clientScope = this.getClientScopeById(realm, id);
        if (clientScope == null) {
            return false;
        }
        this.session.users().preRemove(clientScope);
        realm.removeDefaultClientScope(clientScope);
        ClientScopeEntity clientScopeEntity = (ClientScopeEntity)this.em.find(ClientScopeEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        this.em.createNamedQuery("deleteClientScopeClientMappingByClientScope").setParameter("clientScopeId", (Object)clientScope.getId()).executeUpdate();
        this.em.createNamedQuery("deleteClientScopeRoleMappingByClientScope").setParameter("clientScope", (Object)clientScopeEntity).executeUpdate();
        this.em.remove((Object)clientScopeEntity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
        this.em.flush();
        return true;
    }

    public void removeClientScopes(RealmModel realm) {
        realm.getClientScopesStream().map(ClientScopeModel::getId).forEach(id -> this.removeClientScope(realm, (String)id));
    }

    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        Map<String, ClientScopeModel> existingClientScopes = this.getClientScopes(realm, client, true);
        existingClientScopes.putAll(this.getClientScopes(realm, client, false));
        clientScopes.stream().filter(clientScope -> !existingClientScopes.containsKey(clientScope.getName())).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).forEach(clientScope -> {
            ClientScopeClientMappingEntity entity = new ClientScopeClientMappingEntity();
            entity.setClientScopeId(clientScope.getId());
            entity.setClientId(client.getId());
            entity.setDefaultScope(defaultScope);
            this.em.persist((Object)entity);
            this.em.flush();
            this.em.detach((Object)entity);
        });
    }

    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        this.em.createNamedQuery("deleteClientScopeClientMapping").setParameter("clientScopeId", (Object)clientScope.getId()).setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.flush();
    }

    public void addClientScopeToAllClients(RealmModel realm, ClientScopeModel clientScope, boolean defaultClientScope) {
        if (realm.equals((Object)clientScope.getRealm())) {
            this.em.createNamedQuery("addClientScopeToAllClients").setParameter("realmId", (Object)realm.getId()).setParameter("clientScopeId", (Object)clientScope.getId()).setParameter("clientProtocol", (Object)clientScope.getProtocol()).setParameter("defaultScope", (Object)defaultClientScope).executeUpdate();
        }
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScope) {
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        TypedQuery query = this.em.createNamedQuery("clientScopeClientMappingIdsByClient", String.class);
        query.setParameter("clientId", (Object)client.getId());
        query.setParameter("defaultScope", (Object)defaultScope);
        return StreamsUtil.closing((Stream)query.getResultStream()).map(clientScopeId -> this.session.clientScopes().getClientScopeById(realm, clientScopeId)).filter(Objects::nonNull).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).collect(Collectors.toMap(ClientScopeModel::getName, Function.identity()));
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Boolean exact, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        if (Boolean.TRUE.equals(exact)) {
            predicates.add(builder.equal((Expression)root.get("name"), (Object)search));
        } else {
            predicates.add(builder.like(builder.lower((Expression)root.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)first, (Integer)max).getResultStream().map(id -> this.session.groups().getGroupById(realm, id)).filter(Objects::nonNull).sorted(GroupModel.COMPARE_BY_NAME).distinct());
    }

    public Stream<GroupModel> searchGroupsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Map<String, String> filteredAttributes = this.groupSearchableAttributes == null || this.groupSearchableAttributes.isEmpty() ? attributes : attributes.entrySet().stream().filter(m -> this.groupSearchableAttributes.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(GroupEntity.class);
        Root root = queryBuilder.from(GroupEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        for (Map.Entry<String, String> entry : filteredAttributes.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) continue;
            String value = entry.getValue();
            Join attributeJoin = root.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)attributeJoin.get("name"), (Object)key);
            Predicate attrValuePredicate = builder.equal((Expression)attributeJoin.get("value"), (Object)value);
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, realm, builder, queryBuilder, (Path)root));
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultStream()).map(g -> new GroupAdapter(this.session, realm, this.em, (GroupEntity)g));
    }

    public void removeExpiredClientInitialAccess() {
        int currentTime = Time.currentTime();
        this.em.createNamedQuery("removeExpiredClientInitialAccess").setParameter("currentTime", (Object)currentTime).executeUpdate();
    }

    private RealmLocalizationTextsEntity getRealmLocalizationTextsEntity(String locale, String realmId) {
        RealmLocalizationTextsEntity.RealmLocalizationTextEntityKey key = new RealmLocalizationTextsEntity.RealmLocalizationTextEntityKey();
        key.setRealm((RealmEntity)this.em.getReference(RealmEntity.class, (Object)realmId));
        key.setLocale(locale);
        return (RealmLocalizationTextsEntity)this.em.find(RealmLocalizationTextsEntity.class, (Object)key);
    }

    public boolean updateLocalizationText(RealmModel realm, String locale, String key, String text) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            entity.getTexts().put(key, text);
            this.em.persist((Object)entity);
            return true;
        }
        return false;
    }

    public void saveLocalizationText(RealmModel realm, String locale, String key, String text) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity == null) {
            entity = new RealmLocalizationTextsEntity();
            entity.setRealm((RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId()));
            entity.setLocale(locale);
            entity.setTexts(new HashMap<String, String>());
        }
        entity.getTexts().put(key, text);
        this.em.persist((Object)entity);
    }

    public void saveLocalizationTexts(RealmModel realm, String locale, Map<String, String> localizationTexts) {
        RealmLocalizationTextsEntity entity = new RealmLocalizationTextsEntity();
        entity.setTexts(localizationTexts);
        entity.setLocale(locale);
        entity.setRealm((RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId()));
        this.em.merge((Object)entity);
    }

    public boolean deleteLocalizationTextsByLocale(RealmModel realm, String locale) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaDelete criteriaDelete = builder.createCriteriaDelete(RealmLocalizationTextsEntity.class);
        Root root = criteriaDelete.from(RealmLocalizationTextsEntity.class);
        criteriaDelete.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("realmId"), (Object)realm.getId()), (Expression)builder.equal((Expression)root.get("locale"), (Object)locale)));
        int linesUpdated = this.em.createQuery(criteriaDelete).executeUpdate();
        return linesUpdated == 1;
    }

    public String getLocalizationTextsById(RealmModel realm, String locale, String key) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            return entity.getTexts().get(key);
        }
        return null;
    }

    public boolean deleteLocalizationText(RealmModel realm, String locale, String key) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            entity.getTexts().remove(key);
            this.em.persist((Object)entity);
            return true;
        }
        return false;
    }

    public Set<String> getClientSearchableAttributes() {
        return this.clientSearchableAttributes;
    }

    private void fireGroupUpdatedEvent(GroupModel group) {
        GroupModel.GroupUpdatedEvent.fire((GroupModel)group, (KeycloakSession)this.session);
    }

    private void fireGroupCreatedEvent(GroupAdapter group) {
        GroupModel.GroupCreatedEvent.fire((GroupModel)group, (KeycloakSession)this.session);
    }
}

