/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.quarkus.registry.config.RegistryConfigImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface JsonBuilder<T> {
    public T build();

    public static <T> List<T> modifiableListOrNull(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        try {
            if (list instanceof List) {
                list.addAll(Collections.emptyList());
                return (List)list;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new ArrayList<T>(list);
    }

    public static <K, V> Map<K, V> modifiableMapOrNull(Map<K, V> map, Supplier<Map<K, V>> mapSupplier) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            map.putAll(Collections.emptyMap());
            return map;
        }
        catch (UnsupportedOperationException immutableMap) {
            Map result = mapSupplier.get();
            result.putAll(map);
            return result;
        }
    }

    public static <T> List<T> toUnmodifiableList(Collection<T> o) {
        if (o == null || o.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(o);
    }

    public static <K, V> Map<K, V> toUnmodifiableMap(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Map.copyOf(map);
    }

    public static <T> T buildIfBuilder(T o) {
        if (o instanceof JsonBuilder) {
            return ((JsonBuilder)o).build();
        }
        return o;
    }

    public static <S> S buildIfBuilder(S o, Class<S> clazz) {
        if (o instanceof JsonBuilder) {
            return (S)((JsonBuilder)o).build();
        }
        return o;
    }

    public static <T> List<T> buildersToUnmodifiableList(List<T> o) {
        if (o == null || o.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(o.size());
        o.forEach(x -> result.add(JsonBuilder.buildIfBuilder(x)));
        return Collections.unmodifiableList(result);
    }

    public static <K, V> Map<K, V> buildUnmodifiableMap(Map<K, V> map, Supplier<Map<K, V>> supplier) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        Map result = supplier.get();
        map.forEach((k, v) -> result.put(k, JsonBuilder.buildIfBuilder(v)));
        return Collections.unmodifiableMap(result);
    }

    public static void ensureNextToken(JsonParser p, JsonToken expected, DeserializationContext ctxt) throws IOException {
        if (p.nextToken() != expected) {
            throw InvalidFormatException.from((JsonParser)p, (String)("Expected " + String.valueOf(expected)), (Object)ctxt, RegistryConfigImpl.Builder.class);
        }
    }

    public static class JsonBuilderSerializer<T>
    extends JsonSerializer<JsonBuilder<T>> {
        public void serialize(JsonBuilder<T> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject(value.build());
        }
    }
}

