/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

@Deprecated
public class OpenApiProcessor {
    static final IndexView EMPTY_INDEX = new Indexer().complete();

    private OpenApiProcessor() {
    }

    public static OpenAPI bootstrap(IndexView index) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfig openApiConfig = OpenApiConfig.fromConfig(config);
        return OpenApiProcessor.bootstrap(openApiConfig, index);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index) {
        ClassLoader defaultClassLoader = ClassLoaderUtil.getDefaultClassLoader();
        return OpenApiProcessor.bootstrap(config, index, defaultClassLoader);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, OpenApiStaticFile ... staticFiles) {
        ClassLoader defaultClassLoader = ClassLoaderUtil.getDefaultClassLoader();
        return OpenApiProcessor.bootstrap(config, index, defaultClassLoader, staticFiles);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, ClassLoader classLoader) {
        List<OpenApiStaticFile> staticfiles = OpenApiProcessor.loadOpenApiStaticFiles(classLoader::getResource);
        return OpenApiProcessor.bootstrap(config, index, classLoader, staticfiles.toArray(new OpenApiStaticFile[0]));
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, ClassLoader classLoader, OpenApiStaticFile ... staticFiles) {
        OpenApiDocument.INSTANCE.reset();
        if (config != null) {
            OpenApiDocument.INSTANCE.config(config);
        }
        if (staticFiles != null && staticFiles.length > 0) {
            for (OpenApiStaticFile staticFile : staticFiles) {
                OpenApiDocument.INSTANCE.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile(config, staticFile));
            }
        }
        if (config != null && index != null) {
            OpenApiDocument.INSTANCE.modelFromAnnotations(OpenApiProcessor.modelFromAnnotations(config, classLoader, index));
        }
        if (config != null && classLoader != null) {
            OpenApiDocument.INSTANCE.modelFromReader(OpenApiProcessor.modelFromReader(config, classLoader, index));
            OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter(config, classLoader, index));
        }
        OpenApiDocument.INSTANCE.initialize();
        OpenAPI openAPI = OpenApiDocument.INSTANCE.get();
        OpenApiDocument.INSTANCE.reset();
        return openAPI;
    }

    public static OpenAPI modelFromStaticFile(OpenApiConfig config, OpenApiStaticFile staticFile) {
        if (staticFile == null) {
            return null;
        }
        try {
            return OpenApiParser.parse(staticFile.getContent(), staticFile.getFormat(), config);
        }
        catch (Exception e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    public static OpenAPI modelFromStaticFile(OpenApiStaticFile staticFile) {
        return OpenApiProcessor.modelFromStaticFile(null, staticFile);
    }

    public static OpenAPI modelFromAnnotations(OpenApiConfig config, IndexView index) {
        return OpenApiProcessor.modelFromAnnotations(config, ClassLoaderUtil.getDefaultClassLoader(), index);
    }

    public static OpenAPI modelFromAnnotations(OpenApiConfig config, ClassLoader loader, IndexView index) {
        return OpenApiProcessor.modelFromAnnotations(config, loader, index, new AnnotationScannerFactory(loader));
    }

    public static OpenAPI modelFromAnnotations(OpenApiConfig config, ClassLoader loader, IndexView index, Supplier<Iterable<AnnotationScanner>> scannerSupplier) {
        if (config.scanDisable()) {
            return null;
        }
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, loader, index, scannerSupplier);
        return scanner.scan(new String[0]);
    }

    @Deprecated
    public static OpenAPI modelFromReader(OpenApiConfig config, ClassLoader loader) {
        return OpenApiProcessor.modelFromReader(config, loader, EMPTY_INDEX);
    }

    public static OpenAPI modelFromReader(OpenApiConfig config, ClassLoader loader, IndexView index) {
        OASModelReader reader = (OASModelReader)OpenApiProcessor.newInstance(config.modelReader(), loader, index);
        return reader != null ? reader.buildModel() : null;
    }

    @Deprecated
    public static OASFilter getFilter(OpenApiConfig config, ClassLoader loader) {
        return OpenApiProcessor.getFilter(config, loader, EMPTY_INDEX);
    }

    public static OASFilter getFilter(OpenApiConfig config, ClassLoader loader, IndexView index) {
        return OpenApiProcessor.getFilter(config.filter(), loader, index);
    }

    public static OASFilter getFilter(String className, ClassLoader loader, IndexView index) {
        return (OASFilter)OpenApiProcessor.newInstance(className, loader, index);
    }

    static <T> T newInstance(String className, ClassLoader loader, IndexView index) {
        if (className == null) {
            return null;
        }
        Class klazz = OpenApiProcessor.uncheckedCall(() -> loader.loadClass(className));
        return (T)Arrays.stream(klazz.getDeclaredConstructors()).filter(OpenApiProcessor::acceptsIndexView).findFirst().map(ctor -> OpenApiProcessor.uncheckedCall(() -> ctor.newInstance(index))).orElseGet(() -> OpenApiProcessor.uncheckedCall(() -> klazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
    }

    private static boolean acceptsIndexView(Constructor<?> ctor) {
        return ctor.getParameterCount() == 1 && IndexView.class.isAssignableFrom(ctor.getParameterTypes()[0]);
    }

    private static <T> T uncheckedCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    public static List<URL> locateStaticFiles(Function<String, URL> loadFunction) {
        ArrayList<URL> apiStaticFiles = new ArrayList<URL>();
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/META-INF/openapi.yaml");
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/WEB-INF/classes/META-INF/openapi.yaml");
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/META-INF/openapi.yml");
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/WEB-INF/classes/META-INF/openapi.yml");
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/META-INF/openapi.json");
        OpenApiProcessor.locateStaticFile(apiStaticFiles, loadFunction, "/WEB-INF/classes/META-INF/openapi.json");
        return apiStaticFiles;
    }

    public static List<OpenApiStaticFile> loadOpenApiStaticFiles(Function<String, URL> loadFunction) {
        ArrayList<OpenApiStaticFile> apiStaticFiles = new ArrayList<OpenApiStaticFile>();
        OpenApiProcessor.locateStaticFiles(loadFunction).forEach(locator -> {
            try {
                Format format = locator.toString().endsWith(".json") ? Format.JSON : Format.YAML;
                apiStaticFiles.add(new OpenApiStaticFile((URL)locator, locator.openStream(), format));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return apiStaticFiles;
    }

    private static void locateStaticFile(List<URL> apiStaticFiles, Function<String, URL> loadFunction, String path) {
        Optional.ofNullable(loadFunction.apply(path)).ifPresent(apiStaticFiles::add);
    }
}

