/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.CurrentClassAndInnerScope;
import org.jetbrains.kotlin.javac.resolve.SingleTypeImportScope;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameterListOwner;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0006\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007j\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b0\fj\b\u0012\u0004\u0012\u00020\b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ClassifierResolver;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "<init>", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;)V", "cache", "Ljava/util/HashMap;", "Lcom/sun/source/tree/Tree;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "Lkotlin/collections/HashMap;", "beingResolved", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "resolve", "tree", "unit", "Lcom/sun/source/tree/CompilationUnitTree;", "containingElement", "Lorg/jetbrains/kotlin/load/java/structure/JavaElement;", "", "removeBeingResolved", "pathSegments", "", "", "path", "tryToResolve", "javac-wrapper"})
@SourceDebugExtension(value={"SMAP\nClassifierResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierResolver.kt\norg/jetbrains/kotlin/javac/resolve/ClassifierResolver\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1198#2,2:252\n1#3:254\n*S KotlinDebug\n*F\n+ 1 ClassifierResolver.kt\norg/jetbrains/kotlin/javac/resolve/ClassifierResolver\n*L\n72#1:252,2\n*E\n"})
public final class ClassifierResolver {
    @NotNull
    private final JavacWrapper javac;
    @NotNull
    private final HashMap<Tree, JavaClassifier> cache;
    @NotNull
    private final HashSet<Tree> beingResolved;

    public ClassifierResolver(@NotNull JavacWrapper javac2) {
        Intrinsics.checkNotNullParameter(javac2, "javac");
        this.javac = javac2;
        this.cache = new HashMap();
        this.beingResolved = new HashSet();
    }

    @Nullable
    public final JavaClassifier resolve(@NotNull Tree tree, @NotNull CompilationUnitTree unit, @NotNull JavaElement containingElement) {
        JavaClassifier javaClassifier;
        JavaClassifier result2;
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(containingElement, "containingElement");
        JavaClassifier javaClassifier2 = result2 = this.cache.get(tree);
        if (javaClassifier2 != null) {
            return javaClassifier2;
        }
        if (this.beingResolved.contains(tree)) {
            return null;
        }
        this.beingResolved(tree);
        JavaClassifier $this$resolve_u24lambda_u240 = javaClassifier = this.tryToResolve(tree, unit, containingElement);
        boolean bl = false;
        ((Map)this.cache).put(tree, $this$resolve_u24lambda_u240);
        this.removeBeingResolved(tree);
        return javaClassifier;
    }

    private final void beingResolved(Tree tree) {
        if (tree instanceof JCTree.JCTypeApply) {
            JCTree.JCExpression jCExpression = ((JCTree.JCTypeApply)tree).clazz;
            Intrinsics.checkNotNullExpressionValue(jCExpression, "clazz");
            this.beingResolved(jCExpression);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            this.beingResolved.add(tree);
            JCTree.JCExpression jCExpression = ((JCTree.JCFieldAccess)tree).selected;
            Intrinsics.checkNotNullExpressionValue(jCExpression, "selected");
            this.beingResolved(jCExpression);
        } else {
            this.beingResolved.add(tree);
        }
    }

    private final void removeBeingResolved(Tree tree) {
        if (tree instanceof JCTree.JCTypeApply) {
            JCTree.JCExpression jCExpression = ((JCTree.JCTypeApply)tree).clazz;
            Intrinsics.checkNotNullExpressionValue(jCExpression, "clazz");
            this.beingResolved(jCExpression);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            this.beingResolved.remove(tree);
            JCTree.JCExpression jCExpression = ((JCTree.JCFieldAccess)tree).selected;
            Intrinsics.checkNotNullExpressionValue(jCExpression, "selected");
            this.beingResolved(jCExpression);
        } else {
            this.beingResolved.remove(tree);
        }
    }

    private final List<String> pathSegments(String path) {
        ArrayList<String> arrayList;
        ArrayList<String> pathSegments = new ArrayList<String>();
        int numberOfBrackets = 0;
        StringBuilder builder = new StringBuilder();
        CharSequence $this$forEach$iv = path;
        boolean $i$f$forEach = false;
        block6: for (int i2 = 0; i2 < $this$forEach$iv.length(); ++i2) {
            char element$iv;
            char c2 = element$iv = $this$forEach$iv.charAt(i2);
            boolean bl = false;
            switch (c2) {
                case '<': {
                    ++numberOfBrackets;
                    break;
                }
                case '>': {
                    numberOfBrackets += -1;
                    break;
                }
                case '.': {
                    if (numberOfBrackets != 0) continue block6;
                    pathSegments.add(builder.toString());
                    builder.setLength(0);
                    break;
                }
                case '@': {
                    break;
                }
                default: {
                    if (numberOfBrackets != 0) continue block6;
                    builder.append(c2);
                }
            }
        }
        ArrayList<String> $this$pathSegments_u24lambda_u241 = arrayList = pathSegments;
        boolean bl = false;
        $this$pathSegments_u24lambda_u241.add(builder.toString());
        return arrayList;
    }

    private final JavaClassifier tryToResolve(Tree tree, CompilationUnitTree unit, JavaElement containingElement) {
        JavaClass javaClass;
        List<String> pathSegments = this.pathSegments(tree.toString());
        JavaElement javaElement = containingElement;
        if (javaElement instanceof JavaClass) {
            javaClass = (JavaClass)containingElement;
        } else if (javaElement instanceof JavaTypeParameterListOwner) {
            String string = CollectionsKt.singleOrNull(pathSegments);
            if (string != null) {
                Object v3;
                block8: {
                    String pathSegment = string;
                    boolean bl = false;
                    Name name2 = Name.identifier(pathSegment);
                    Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                    Name identifier = name2;
                    Iterable iterable = ((JavaTypeParameterListOwner)containingElement).getTypeParameters();
                    for (Object t2 : iterable) {
                        JavaTypeParameter it = (JavaTypeParameter)t2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getName(), identifier)) continue;
                        v3 = t2;
                        break block8;
                    }
                    v3 = null;
                }
                JavaTypeParameter javaTypeParameter = v3;
                if (javaTypeParameter != null) {
                    JavaTypeParameter it = javaTypeParameter;
                    boolean bl = false;
                    return it;
                }
            }
            JavaElement javaElement2 = containingElement;
            Intrinsics.checkNotNull(javaElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.JavaMember");
            javaClass = ((JavaMember)javaElement2).getContainingClass();
        } else {
            if (javaElement instanceof JavaPackage) {
                return new SingleTypeImportScope(this.javac, unit).findClass(CollectionsKt.first(pathSegments), pathSegments);
            }
            throw new UnsupportedOperationException();
        }
        JavaClass containingClass = javaClass;
        return new CurrentClassAndInnerScope(this.javac, unit, containingClass).findClass(CollectionsKt.first(pathSegments), pathSegments);
    }
}

