/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.sender_icon_cache;

import com.google.common.cache.CacheLoader;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SenderIconCacheLoader
extends CacheLoader<String, Optional<ImageIcon>> {
    private static final String WIKI_BASE_URL = "https://upload.wikimedia.org/wikipedia/commons/thumb";
    private static final Logger logger = LogManager.getLogger();
    private final AtomicBoolean useLocalIcons;

    public SenderIconCacheLoader(@NotNull AtomicBoolean useLocalIcons) {
        this.useLocalIcons = useLocalIcons;
    }

    @Nullable
    private ImageIcon getLocalImageIcon(@NotNull String source2) {
        URL url = SenderIconCacheLoader.class.getResource(source2);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    @Nullable
    private ImageIcon getIcon(@NotNull String networkResource, @NotNull String localResource) {
        ImageIcon icon = null;
        if (!this.useLocalIcons.get()) {
            Request request = new Request.Builder().url(networkResource).get().build();
            try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful() && body != null) {
                    BufferedImage b_img = ImageIO.read(body.byteStream());
                    icon = new ImageIcon(b_img);
                }
            }
            catch (Exception ex) {
                icon = null;
            }
        }
        if (icon == null || icon.getIconWidth() < 0 || icon.getIconHeight() < 0) {
            URL url = SenderIconCacheLoader.class.getResource(localResource);
            if (url != null) {
                icon = new ImageIcon(url);
            } else {
                logger.error("Could not load icon from local jar");
                icon = null;
            }
        }
        return icon;
    }

    @Override
    @NotNull
    public Optional<ImageIcon> load(@NotNull String sender) {
        ImageIcon icon = switch (sender) {
            case "3Sat" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/f/f2/3sat-Logo.svg/775px-3sat-Logo.svg.png", "/mediathek/res/sender/3sat.png");
            case "ARD" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/68/ARD_logo.svg/320px-ARD_logo.svg.png", "/mediathek/res/sender/ard.png");
            case "ARTE.DE" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-de.png");
            case "ARTE.EN" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-en.png");
            case "ARTE.ES" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-es.png");
            case "ARTE.FR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-fr.png");
            case "ARTE.IT" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-it.png");
            case "ARTE.PL" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-pl.png");
            case "BR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/BR_Dachmarke.svg/320px-BR_Dachmarke.svg.png", "/mediathek/res/sender/br.png");
            case "HR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/63/HR_Logo.svg/519px-HR_Logo.svg.png", "/mediathek/res/sender/hr.png");
            case "KiKA" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/Kika_2012.svg/320px-Kika_2012.svg.png", "/mediathek/res/sender/kika.png");
            case "MDR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/61/MDR_Logo_2017.svg/800px-MDR_Logo_2017.svg.png", "/mediathek/res/sender/mdr.png");
            case "DW" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/Deutsche_Welle_Logo.svg/743px-Deutsche_Welle_Logo.svg.png", "/mediathek/res/sender/dw.png");
            case "NDR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/08/NDR_Dachmarke.svg/308px-NDR_Dachmarke.svg.png", "/mediathek/res/sender/ndr.png");
            case "ORF" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/ORF_logo.svg/709px-ORF_logo.svg.png", "/mediathek/res/sender/orf.png");
            case "RBB" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/7/79/Rbb_Logo_2017.08.svg/320px-Rbb_Logo_2017.08.svg.png", "/mediathek/res/sender/rbb.png");
            case "SR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/8/83/SR_Dachmarke.svg/602px-SR_Dachmarke.svg.png", "/mediathek/res/sender/sr.png");
            case "SRF" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/8/84/Schweizer_Radio_und_Fernsehen_Logo.svg/559px-Schweizer_Radio_und_Fernsehen_Logo.svg.png", "/mediathek/res/sender/srf.png");
            case "SRF.Podcast" -> this.getLocalImageIcon("/mediathek/res/sender/srf-podcast.png");
            case "SWR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/SWR_Dachmarke.svg/320px-SWR_Dachmarke.svg.png", "/mediathek/res/sender/swr.png");
            case "WDR" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/9b/WDR_Dachmarke.svg/320px-WDR_Dachmarke.svg.png", "/mediathek/res/sender/wdr.png");
            case "ZDF" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/c/c1/ZDF_logo.svg/200px-ZDF_logo.svg.png", "/mediathek/res/sender/zdf.png");
            case "ZDF-tivi" -> this.getLocalImageIcon("/mediathek/res/sender/zdf-tivi.png");
            case "PHOENIX" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/d/de/Phoenix_Logo_2018_ohne_Claim.svg/640px-Phoenix_Logo_2018_ohne_Claim.svg.png", "/mediathek/res/sender/phoenix.png");
            case "Funk.net" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/99/Funk_Logo.svg/454px-Funk_Logo.svg.png", "/mediathek/res/sender/funk_net.png");
            case "Radio Bremen TV" -> this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/7/73/Logo_Radio_Bremen_TV.svg/320px-Logo_Radio_Bremen_TV.svg.png", "/mediathek/res/sender/rbtv.jpg");
            default -> null;
        };
        Optional<Object> optIcon = icon == null ? Optional.empty() : Optional.of(icon);
        return optIcon;
    }
}

