## Description

This module is not intended to exploit a vulnerability, but rather to perform host discovery on IPv6-enabled local networks. It sends ICMPv6 Echo Requests to several well-known multicast addresses (e.g., FF02::1) and listens for any ICMPv6-based response.

This technique helps identify active IPv6 hosts and services, particularly when traditional IPv4 reconnaissance is limited or disabled. All responses — including Echo Replies, Neighbor Solicitations, and others — are valid evidence of a live host.

## Verification Steps

1. Do: `use auxiliary/scanner/discovery/ipv6_neighbor`
2. Do: `set RHOSTS [IP]`
3. Do: `set SHOST [IP]`
4. Do: `run`

## Scenarios
```
msf6 auxiliary(scanner/discovery/ipv6_multicast_ping) > set SHOST 10.0.2.4
SHOST => 10.0.2.4
msf6 auxiliary(scanner/discovery/ipv6_multicast_ping) > set RHOST 10.0.2.2-10RHOST => 10.0.2.2-10
msf6 auxiliary(scanner/discovery/ipv6_multicast_ping) > run
[*] Running module against 10.0.2.2
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.3
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.4
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.5
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.6
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.7
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.8
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.9
[*] Sending multicast pings...
[*] Listening for responses...
[*] Running module against 10.0.2.10
[*] Sending multicast pings...
[*] Listening for responses...
[*] Auxiliary module execution completed
```
